<?
class Gateway_model extends CI_Model
{

    function __construct()
    {
        parent::__construct();
    }
    
    function get_hotel_statuses_names (){
        $hotelstates = array ();
        $query = $this->db->query ( "SELECT * FROM  hotelstates" );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $hotelstates [$row->id]["id_state"] = $row->id;
                $hotelstates [$row->id]["name"] = $row->name;
            }
        }
        
        return $hotelstates;
    }
    
    function get_hotel_users($db_name){
        return $this->db->select('fullname, lastname, middlename, isAdministrator, position, language, login')->get($db_name.'.users')->result_array();
    }
    
    function get_last_logs($db_name){
        $return_data = array();
        $sql = "SELECT loger.ip, loger.data, users.fullname, users.lastname, users.login, users.id FROM `$db_name`.loger 
                INNER JOIN `$db_name`.users ON users.id = loger.user_id
                LIMIT 0, 20";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                if ($row->id > 0) {
                    array_push($return_data, array(
                        'firstname' => $row->fullname,
                        'lastname' => $row->lastname,
                        'date' => $row->data,
                        'ip' => $row->ip,
                        'email' => $row->login
                    ));
                }
            }
        }
        
        return $return_data;
    }
    
    function get_logauthip_list($db_name) {
        $logauthip = array ();
        if ($db_name != "") {
            $sql = "SELECT logauthip.*, users.fullname, users.lastname, users.login, users.id 
                    FROM `" . $db_name . "`.logauthip INNER JOIN `" . $db_name . "`.users ON users.id = logauthip.id_user 
                    ORDER BY logauthip.id DESC LIMIT 0,20";
            $query = $this->db->query ( $sql );
            foreach ($query->result() as $row) {
                if ($row->id > 0) {
                    array_push($logauthip, array(
                        "firstname" => $row->fullname,
                        "lastname" => $row->lastname,
                        "date" => $row->time,
                        "ip" => $row->ip,
                        "email" => $row->login
                    ));
                }
            }
        }
        return $logauthip;
    }
    
    function get_channels_data($db_name){
        $return_data = array();
        $dc_cfg_tables = $this->get_dc_channels_cfg_tbl_names();
        foreach($dc_cfg_tables as $dc_id => $table_name){
            $temp_dc_name = str_replace("dc_", "", $table_name);
            $temp_dc_name = str_replace("_xml_cfg", "", $temp_dc_name);
            
            $hotels_dc_ids_arr = array();
            switch($table_name){
                case "dc_hrs_xml_cfg":
                    $sql = "SELECT int_value FROM `$db_name`.$table_name WHERE name LIKE 'hotelKey'";
                    $query2 = $this->db->query($sql);
                    if ($query2->num_rows() > 0) {
                        foreach ($query2->result() as $row2) {
                            array_push($hotels_dc_ids_arr, $row2->int_value);
                        }
                    }
                    break;
                case "dc_hotel_inn_xml_cfg":
                    $sql = "SELECT str_value FROM `$db_name`.$table_name WHERE name LIKE 'user'";
                    $query2 = $this->db->query($sql);
                    if ($query2->num_rows() > 0) {
                        foreach ($query2->result() as $row2) {
                            array_push($hotels_dc_ids_arr, $row2->str_value);
                        }
                    }
                    break;
                case "dc_airbnb_xml_cfg":
                    $sql = "SELECT int_value FROM `$db_name`.$table_name WHERE name LIKE 'user_id'";
                    $query2 = $this->db->query($sql);
                    if ($query2->num_rows() > 0) {
                        foreach ($query2->result() as $row2) {
                            array_push($hotels_dc_ids_arr, $row2->int_value);
                        }
                    }
                    break;
                default:
                    $sql = "SELECT int_value FROM `$db_name`.$table_name WHERE name LIKE 'hotel_id'";
                    $query2 = $this->db->query ( $sql );
                    if ($query2->num_rows () > 0) {
                        foreach ( $query2->result () as $row2 ) {
                            array_push($hotels_dc_ids_arr, $row2->int_value);
                        }
                    }
                    break;
            }
//             $sql = "SELECT int_value FROM `$db_name`.$table_name WHERE name LIKE 'hotel_id'";
//             $query2 = $this->db->query ( $sql );
//             if ($query2->num_rows () > 0) {
//                 foreach ( $query2->result () as $row2 ) {
//                     array_push($hotels_dc_ids_arr, $row2->int_value);
//                 }
//             }
            $return_data[$temp_dc_name] = $hotels_dc_ids_arr;
        }
        
        return $return_data;
    }
    
    function get_property_dwelling(){
        $dwelling_array = array();
        $dwelling_array[1]["dwelling_id"] = 1;
        $dwelling_array[1]["dwelling_name"] = "Single";
        $dwelling_array[1]["dwelling_selected"] = "";
        $dwelling_array[2]["dwelling_id"] = 2;
        $dwelling_array[2]["dwelling_name"] = "Multi";
        $dwelling_array[2]["dwelling_selected"] = "";
    
        return $dwelling_array;
    }
    
    function get_property_types(){
        $property_types = array();
        $sql2 = "SELECT id, name, dwelling FROM global_hotelix_common.property_type WHERE 1";
        $query2 = $this->db->query ( $sql2 );
        if ($query2->num_rows() > 0)
        {
            foreach ( $query2->result () as $row2 ) {
                $property_types[$row2->dwelling][$row2->id]["property_type_id"] = $row2->id;
                $property_types[$row2->dwelling][$row2->id]["property_type_name"] = $row2->name;
                $property_types[$row2->dwelling][$row2->id]["property_type_selected"] = "";
            }
        }
    
        return $property_types;
    }
    
    function get_properties_data($db_name){
        $return_data = array();
        
        $property_dwelling = $this->get_property_dwelling();
        //$property_types = $this->get_property_types();
        
        $sql = "SELECT property_information.id as property_id,
        property_information.street, property_information.city, property_information.dwelling,
        property_information.additional_information, property_information.post_code, property_information.property_type,
        property_information.state, property_information.country, property_information.property_name,
        property_information.reception_phone, property_information.email, property_information.check_in_time,
        property_information.check_out_time, property_information.web_address, property_information.email,
        property_information.gps_coordinates
        FROM `".$db_name."`.property_information
        WHERE 1";
        $query2 = $this->db->query ( $sql );
        if ($query2->num_rows () > 0) {
            foreach ( $query2->result () as $row2 ) {       
                array_push($return_data, array(
                    "name" => $row2->property_name,
                    "type" => $row2->dwelling,
                    "type_str" => $property_dwelling[$row2->dwelling]["dwelling_name"],
                    "class" => $row2->property_type,
                    //"class_str" => $property_types[$row2->dwelling][$row2->property_type]["property_type_name"],
                    "phone" => $row2->reception_phone,
                    "email" => $row2->email,
                    "webAdress" => $row2->web_address,
                    "checkin" => $row2->check_in_time,
                    "checkout" => $row2->check_out_time,
                    "adressStreet" => $row2->street,
                    "adressCity" => $row2->city,
                    "adressState" => $row2->state,
                    "adressCountry" => $row2->country,
                    "adressPostalCode" => $row2->post_code,
                    "gps_coordinates" => $row2->gps_coordinates
                ));
            }
        }
        return $return_data;
    }
    
    function get_happines_data($hms_id){
        
    }
    
    function get_legal_entities_data($db_name){
        return $this->db->select('*')->get($db_name.'.partners')->result_array();
    }
    
    function get_dc_channels_cfg_tbl_names(){
        $dc_cfg_names = array();
        $dc_cfg_names[1] = "dc_booking_xml_cfg";
        $dc_cfg_names[2] = "dc_ostrovok_xml_cfg";
        $dc_cfg_names[3] = "dc_expedia_xml_cfg";
        $dc_cfg_names[4] = "dc_hostelsclub_xml_cfg";
        $dc_cfg_names[5] = "dc_agoda_xml_cfg";
        $dc_cfg_names[6] = "dc_hotel_inn_xml_cfg";
        $dc_cfg_names[7] = "dc_oktogo_xml_cfg";
        $dc_cfg_names[8] = "dc_hostelworld_xml_cfg";
        $dc_cfg_names[9] = "dc_101otel_xml_cfg";
        $dc_cfg_names[11] = "dc_hrs_xml_cfg";
        $dc_cfg_names[12] = "dc_vashotel_xml_cfg";
        $dc_cfg_names[13] = "dc_bronevik_xml_cfg";
        $dc_cfg_names[14] = "dc_hotels24_xml_cfg";
        $dc_cfg_names[15] = "dc_ozon_xml_cfg";
        $dc_cfg_names[16] = "dc_tripadvisor_xml_cfg";
        $dc_cfg_names[17] = "dc_hotelbook_xml_cfg";
        $dc_cfg_names[18] = "dc_eholiday_xml_cfg";
        $dc_cfg_names[19] = "dc_dobovo_xml_cfg";
        $dc_cfg_names[20] = "dc_dorms_xml_cfg";
        $dc_cfg_names[21] = "dc_cbooking_xml_cfg";
        $dc_cfg_names[22] = "dc_airbnb_xml_cfg";
        $dc_cfg_names[23] = "dc_roomp_xml_cfg";
        $dc_cfg_names[24] = "dc_axis_travel_xml_cfg";
        $dc_cfg_names[25] = "dc_onetwotrip_xml_cfg";
        $dc_cfg_names[26] = "dc_tvil_xml_cfg";
        $dc_cfg_names[27] = "dc_academ_service_xml_cfg";
        $dc_cfg_names[28] = "dc_aanda_xml_cfg";
        $dc_cfg_names[29] = "dc_nash_travel_xml_cfg";
        $dc_cfg_names[30] = "dc_sutochno_xml_cfg";
        return $dc_cfg_names;
    }
    
    function get_additional_services_data($db_name){
        $return_data = array();
        
        $fms = $this->db->select('IF(is_active = 1, "true", "false") as is_active_bool')
                                        ->get_where('`'.$db_name.'`.modules', array('name' => 'fms'))->row()->is_active_bool;
        $return_data ['fms'] = ($fms == "true") ? 1 : 0;
        
        $housekeeping =  $this->db->select('IF(value = 1, "true", "false") as housekeeping_bool')
                                                 ->get_where('`'.$db_name.'`.hotelix_config', array('name' => 'house_keeping_release'))->row()->housekeeping_bool;
        $return_data ['housekeeping'] = ($housekeeping == "true") ? 1 : 0;
        
        $wifi = $this->db->select('IF(value = 1, "true", "false") as wifi_bool')
                                         ->get_where('`'.$db_name.'`.hotelix_config', array('name' => 'wifi_release'))->row()->wifi_bool;
        $return_data ['wifi'] = ($wifi == "true") ? 1 : 0;
                                         
        $reputation = $this->db->select('IF(value = 1, "true", "false") as reputation_bool')
            ->get_where('`' . $db_name . '`.hotelix_config', array('name' => 'show_newest_reviews_pages'))->row()->reputation_bool;
        $return_data['reputation'] = ($reputation == "true") ? 1 : 0;
            
        $kkm = $this->db->select('IF(is_active = 1, "true", "false") as is_active_bool')
                                        ->get_where('`'.$db_name.'`.modules', array('name' => 'kkm'))->row()->is_active_bool;
        $return_data ['kkm'] = ($kkm == "true") ? 1 : 0;
                                        
        $google_analitycs = $this->db->select('IF(middletext <> "", "true", "false") as google_analitycs_bool')
            ->get('`' . $db_name . '`.online_options')->row()->google_analitycs_bool;
        $return_data['google_analitycs'] = ($google_analitycs == "true") ? 1 : 0;
            
        $vpos_bool = $this->db->select('IF(value = 1, "true", "false") as vpos_bool')
        ->get_where('`' . $db_name . '`.hotelix_config', array('name' => 'global_payment_VC'))->row()->vpos_bool;
        $return_data['vpos'] = ($vpos_bool == "true") ? 1 : 0;
        //$return_data['vpos'] = "";
        
        $guardia_civil = $this->db->select('IF(is_active = 1, "true", "false") as is_active_bool')
                                                 ->get_where('`'.$db_name.'`.modules', array('name' => 'fms'))->row()->is_active_bool;
        $return_data['guardia_civil'] = ($guardia_civil == "true") ? 1 : 0;
                                                 
        $prro = $this->db->select('IF(is_active = 1, "true", "false") as is_active_bool')
                                                 ->get_where('`'.$db_name.'`.modules', array('name' => 'rro'))->row()->is_active_bool;
        $return_data['prro'] = ($prro == "true") ? 1 : 0;
        
        $return_data['faktury'] = "";
        
        $stripe = $this->db->select('IF(str_value <> "", "true", "false") as stripe_bool')
            ->get_where('`' . $db_name . '`.hotelix_config', array('name' => 'stripe_account_id'))->row()->stripe_bool;
        $return_data['stripe'] = ($stripe == "true") ? 1 : 0;
            
        $liqpay_publickey = $this->db->select('IF((str_text <> "" AND str_text <> "{publickey}"), "true", "false") as liqpay_publickey_bool')
            ->get_where('`' . $db_name . '`.gatewayoforder_personal', array('name' => 'publickey'))->row()->liqpay_publickey_bool;
        
            
        $liqpay_privat_key = $this->db->select('IF((str_text <> "" AND str_text <> "{liqpay_privat_key}"), "true", "false") as liqpay_privat_key_bool')
            ->get_where('`' . $db_name . '`.gatewayoforder_personal', array('name' => 'liqpay_privat_key'))->row()->liqpay_privat_key_bool;
        
        $return_data['liqpay'] = 0;
        if($liqpay_publickey == "true" && $liqpay_privat_key == "true"){
            $return_data['liqpay'] = 1;
        }
        $paypal_bool_str = $this->db->select('IF(str_value <> "", "true", "false") as paypal_bool')
            ->get_where('`' . $db_name . '`.hotelix_config', array('name' => 'paypal_merchant_seller_id'))->row()->paypal_bool;
        $return_data['paypal'] = ($paypal_bool_str == "true") ? 1 : 0;
            
            
        $return_data['appex'] = "";
        $return_data['przelewy'] = "";
        $return_data['tpay'] = "";
        $return_data['ipay'] = "";
        
        return $return_data;
    }
}
?>