<?php

$hms_id = $this->config->item('hotel_id');

// ========================= set date ranges START ================================
$system_date_format = $this->frontdesk->get_systemdateformat();
$daterangepicker_date_format = $this->frontdesk->get_systemdateformat('for_daterangepicker');
$date_range = $this->session->userdata('stripe_invoices_date_range');
if ($date_range != ""){
	list ( $start_date, $end_date ) = explode ( ' - ',  $date_range);
	$start_date_timestamp = strtotime($start_date." 00:00");
	$end_date_timestamp = strtotime($end_date." 23:59");
}else {
	$start_date_timestamp = strtotime("- 89 days 00:00");
	$end_date_timestamp = strtotime("today 23:59");
	$start_date = date($system_date_format, $start_date_timestamp);
	$end_date = date($system_date_format, $end_date_timestamp);
}
// ========================= set date ranges FIN ==================================
// ========================= status selector START ================================
$statuses_arr = array(''=>"{mlw_all}", 'only_opened'=>"{clt_not_payed_invoices}");
$status_selector_options_arr = array();
$selected_status = $this->session->userdata('stripe_invoices_selected_status');
foreach ( $statuses_arr as $val => $name ) {
	$selected = "";
	if ($selected_status == $val) {
		$selected = "selected";
	}
	array_push ( $status_selector_options_arr, array (
			'value' => $val,
			'name' => $name,
			'selected' => $selected
	) );
}
if ($from_msg_routing == 'hm_rout'){//перехід відбувся з повідомлення системи, показуєм неоплачені інвойси
	$status_selector_options_arr[1]['selected'] = 'selected';
	$selected_status = "only_opened";
}
// ========================= status selector FINAL ================================
//================================== pagination START =============================
if ($this->session->userdata ( 'stripe_invoices_lines_per_page' ) != ""){
	$lines_per_page = $this->session->userdata ( 'stripe_invoices_lines_per_page' );
}else{
	$lines_per_page = 100;
}
$cur_page = $current_page;
$page_first_line = ($cur_page - 1) * $lines_per_page;
$lines_per_current_page = $page_first_line+1;
$url_for_pagination = "/stripe_concept/invoices/";
// $all_lines_count = count($invoices_list['data']);
//================================== pagination FIN ===============================
//================ need ACT hotels START ============================
$hotel_country = $this->frontdesk->get_visitka_id_country_3c();
$need_acts_countries = ['RUS', 'UKR', 'BLR', 'ABH'];
$acts_hide_class = (in_array($hotel_country, $need_acts_countries)) ? "" : "d0";
//================ need ACT hotels FINAL ============================
//================ double invoice for russian & ukrainians hotels START ============================
$country_hide_class = "d0";
if (in_array($hotel_country, array('UKR'))){//'RUS', 
    $country_hide_class = "";
}
//================ double invoice for russian & ukrainians hotels FINAL ============================
//================ totally hide invoice for russian hotels START ============================
$invoice_hide_for_RUS_class = "";
if ($this->releases->stripe_invoice_dontshow_ico_trigger()){
    $invoice_hide_for_RUS_class = "d0";
}
//================ totally hide invoice for russian hotels FINAL ============================
$stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id");
if ($stripe_billing_customer_id == ""){//нема кастомера
	$invoices_arr = array();
}else{//є кастомер
	$tbl_acts = "stripe_acts";
	$customer_id = $stripe_billing_customer_id;
	$secret_key = $this->stripe_billing_m2->get_secret_key();
	$this->stripe->setApiKey($secret_key);
	$invoices_arr = array();
	if ($selected_status == "only_opened" ){
		$all_invoices = $this->stripe_billing_m2->get_opened_invoices();
		foreach ($all_invoices as $invoice) {
			//============== ACTS deeds START =====================
			$act_invioce_hide_class = "d0";
			//============== ACTS deeds FINAL =====================
			$payment_intent = $this->payment_intent->retrieve( $invoice ['payment_intent'] );
			$client_secret = $payment_intent->client_secret;
			$pi_pm = $payment_intent->payment_method;
			if (!empty($pi_pm)){
				$payment_method_checking_data = $this->payment_method->retrieve( $pi_pm );
				if ($payment_method_checking_data->customer != $customer_id){
					$pi_pm = '';
				}
			}
			$payform4invoice_param = array(
			    'amount' => $invoice['amount_due'],//allready devided by 100 !!!
			    'invoice_id' => $invoice['id'],
			    'number' => $invoice['number']
			);
			$pay_opened_invoice_hide_class = $pay_opened_invoice_hide_class_ru = "d0";
			if (in_array($hotel_country, ['RUS', 'BLR', 'ABH'])) {
			    $pay_opened_invoice_hide_class_ru = "";
			} else {
			    $pay_opened_invoice_hide_class = "";
			}
            array_push($invoices_arr, array(
                'n' => $lines_per_current_page,
                'hms_id' => $hms_id,
                'id' => $invoice['id'],
                'number' => $invoice['number'],
                'amount' => $this->frontdesk->showcurrency($invoice['amount_due']),//allready devided by 100 !!!
                'created' => $invoice['created'],
                'currency' => strtoupper($invoice['currency']),
                'description' => $invoice['description'],
                'status' => $invoice['status'],
                'do_pay_hide_class' => "",
                'pay_opened_invoice_hide_class' => $pay_opened_invoice_hide_class,
                'pay_opened_invoice_hide_class_ru' => $pay_opened_invoice_hide_class_ru,
                'act_invioce_hide_class' => $act_invioce_hide_class,
                'client_secret' => $client_secret,
                'pi_pm' => $pi_pm,
                'country_marker' => $hotel_country,
                'double_invoice_hide_class' => "",
                //'appex_payform4billing' => $this->appex->make_payform4invoice($payform4invoice_param),
                'mandarin_payform4billing' => $this->mandarin_pay->make_payform4invoice($payform4invoice_param),
            ));
			$lines_per_current_page++;
		}
		$pagination = "";
	}else{
		$temp_list_page = 1;
		$all_invoices = array();
		$invoices_list = $this->invoice->all ( array (
				"customer" => $customer_id,
				"limit" => $lines_per_page,
				"created" => array (
						"gte" => $start_date_timestamp,
						"lte" => $end_date_timestamp
				)
		) );
		$invoices_list = $invoices_list->__toArray(true);
		$all_invoices[$temp_list_page] = $invoices_list;
		while ($invoices_list['has_more']){
			$starting_after = $invoices_list['data'][$lines_per_page-1]['id'];
			$invoices_list = $this->invoice->all ( array (
					"customer" => $customer_id,
					"starting_after" => $starting_after,
					"limit" => $lines_per_page,
					"created" => array (
							"gte" => $start_date_timestamp,
							"lte" => $end_date_timestamp
					)
			) );
			$temp_list_page ++;
			$invoices_list = $invoices_list->__toArray(true);
			$all_invoices[$temp_list_page] = $invoices_list;
		};
		$all_lines_count = 0;
		foreach ($all_invoices as $invoices_list_on_page) {
			$all_lines_count += count($invoices_list_on_page['data']);
		}
		foreach ($all_invoices[$cur_page]['data'] as $invoice) {
		    $do_pay_hide_class = $pay_opened_invoice_hide_class = $pay_opened_invoice_hide_class_ru = "d0";
			$client_secret = $pi_pm = '';
			$mandarin_payform4billing = '';
			if ($invoice ['status'] == 'open'){
				$do_pay_hide_class = "";
				if (in_array($hotel_country, ['RUS', 'BLR', 'ABH'])) {
				    $pay_opened_invoice_hide_class_ru = "";
				} else {
				    $pay_opened_invoice_hide_class = "";
				}
				$payment_intent = $this->payment_intent->retrieve( $invoice ['payment_intent'] );
				$client_secret = $payment_intent->client_secret;
				$pi_pm = $payment_intent->payment_method;
				if (!empty($pi_pm)){
					$payment_method_checking_data = $this->payment_method->retrieve( $pi_pm );
					if ($payment_method_checking_data->customer != $customer_id){
						$pi_pm = '';
					}
				}
				$payform4invoice_param = array(
				    //'amount' => ((int) $invoice['total']) / 100,
				    'amount' => $invoice['amount_due'] / 100,
				    'invoice_id' => $invoice['id'],
				    'number' => $invoice['number']
				);
				$mandarin_payform4billing = $this->mandarin_pay->make_payform4invoice($payform4invoice_param);
			}
			//============== ACTS deeds START =====================
			$act_invioce_hide_class = "d0";
			$act = $this->db->get_where($tbl_acts, array('act_number' => "A-".$invoice ['number']))->row();
			if (!empty($act)){
				$act_invioce_hide_class = "";
			}
            //============== ACTS deeds FINAL =====================
            switch ($invoice['status']) {
                case 'open':
                    $amount_fild = 'amount_due';
                    break;
                case 'draft':
                    $amount_fild = 'amount_due';
                    break;
                case 'paid':
                    $amount_fild = $invoice['amount_due'] != 0 ? 'amount_due' : 'total';
                    break;

                default:
                    $amount_fild = 'total';
                    break;
            }
            array_push($invoices_arr, array(
                'n' => $lines_per_current_page,
                'hms_id' => $hms_id,
                'id' => $invoice['id'],
                'number' => $invoice['number'],
                'amount' => $this->frontdesk->showcurrency($invoice[$amount_fild]/100),
                'created' => date("Y-m-d H:i", $invoice['created']),
                'currency' => strtoupper($invoice['currency']),
                'description' => $invoice['description'],
                'status' => "{clt_" . $invoice['status'] . "}",
                'do_pay_hide_class' => $do_pay_hide_class,
                'pay_opened_invoice_hide_class' => $pay_opened_invoice_hide_class,
                'pay_opened_invoice_hide_class_ru' => $pay_opened_invoice_hide_class_ru,
                'act_invioce_hide_class' => $act_invioce_hide_class,
                'client_secret' => $client_secret,
                'pi_pm' => $pi_pm,
                'country_marker' => $hotel_country,
                'double_invoice_hide_class' => ($invoice ['status'] == 'paid') ? "d0":"",
                //'appex_payform4billing' => $this->appex->make_payform4invoice($payform4invoice_param),
                'mandarin_payform4billing' => $mandarin_payform4billing,
            ));
			$lines_per_current_page++;
		}
		$pagination = $this->htmltpl->pagination ($all_lines_count, $lines_per_page, $cur_page, $url_for_pagination, 100);
	}
	//============== cards selector START ====================================
	$customer_obj = $this->customer->retrieve($customer_id);
	$cards_select_options_arr = array();
	$payment_methods = $this->payment_method->all(array('customer'=>$customer_id, 'type' => 'card'));
	$payment_methods = $payment_methods->__toArray(true);
	foreach ($payment_methods['data'] as $source) {
		array_push ( $cards_select_options_arr, array (
    		'id' => $source ['id'],
    		// 		'address_zip' => $source ['address_zip'],
    		// 		'address_zip_check' => $source ['address_zip_check'],
    		'brand' => strtoupper ( $source ['card']['brand'] ),
    		'country' => $source ['card']['country'],
    		'exp_month' => $source ['card']['exp_month'],
    		'exp_year' => $source ['card']['exp_year'],
    		'funding' => $source ['card']['funding'],
    		'last4' => $source ['card']['last4'],
    		'name' => '**** '.$source ['card']['last4'],
		    'selected' => ($source ['id'] == $customer_obj->invoice_settings->default_payment_method) ? "selected" : "",
		// 		'selected' => ($source ['id'] == $customer['default_source']) ? "selected" : "",
		) );
	}
	array_push ( $cards_select_options_arr, array (
			'id' => '',
			'brand' => '',
			'name' => '{clt_add_payment_method}',
			'selected' => ''
	) );
	//============== cards selector FINIS ====================================
}
$menu_data = $this->htmltpl->get_left_settings_menu ( 99, 6 );
$data = array(
    'header' => $this->htmltpl->getHeader_new(0, 1, 0, "stripe_invoices"),
    'footer_html' => $this->htmltpl->getFooter_new(),
    'settings_main_menu' => $menu_data["main_menu"],
    'settings_sub_menu' => $menu_data["sub_menu"],
    'invoices_arr' => $invoices_arr,
    'daterangepicker_date_format' => $daterangepicker_date_format,
    'start_date' => $start_date,
    'end_date' => $end_date,
    'pagination' => $pagination,
    'status_selector_options_arr' => $status_selector_options_arr,
    'acts_hide_class' => $acts_hide_class,
    'publish_key' => $this->stripe_billing_m2->get_publish_key(),
    'cards_select_options_arr' => $cards_select_options_arr,
    'country_hide_class' => $country_hide_class,
    'invoice_hide_for_RUS_class' => $invoice_hide_for_RUS_class
);
$this->mlanguages->getdictionary("stripe_invoices", "", $data);
$this->mlanguages->getdictionary("stripe_statuses", "", $data);
$this->mlanguages->getdictionary("stripe_plans", "", $data);
$this->mlanguages->getdictionary("stripe_manage_payment_methods", "", $data);
$this->mlanguages->getdictionary("stripe_card_decline_codes", "", $data);
$this->mlanguages->getdictionary("billing_firstdatapayment", "", $data);
$this->parser->parse ( 'templates/stripe_concept2/invoices_view.html', $data );
