<?php
$system_date_format = $this->frontdesk->get_systemdateformat();
$stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
$secret_key = $this->stripe_billing_m->get_secret_key();
$this->stripe->setApiKey($secret_key);
$customer_obj = $this->customer->retrieve($stripe_billing_customer_id);
$customer = $customer_obj->__toArray(true);
$is_main_id = -1;
if (isset($customer['subscriptions'])) {
    foreach ($customer['subscriptions']['data'] as $id=>$cell) {
        if (isset($cell['metadata']['is_main'])) {
            if ($cell['metadata']['is_main'] == 1) {
                $is_main_id = $id;
                break;
            }
        }
    }
}
//========================== get upcoming invoice START ============================
$upcoming_invoice_data = $this->invoice->upcoming(array("customer" => $stripe_billing_customer_id));
$upcoming_invoice_data = $upcoming_invoice_data->__toArray(true);
$upcoming_invoice_data['date'] = date("$system_date_format H:i", $upcoming_invoice_data['date']);
$upcoming_invoice_data['currency'] = strtoupper($upcoming_invoice_data['currency']);
$upcoming_invoice_data['total'] = $this->frontdesk->showcurrency(((int)$upcoming_invoice_data['total'])/100);
$invoice_pars_arr = array();
$invoice_lines_arr = array();
foreach ($upcoming_invoice_data['lines']['data'] as $line) {
	array_push ( $invoice_lines_arr, array (
			'line_description' => $line ['description'],
			'amount' => $this->frontdesk->showcurrency(((int)$line ['amount'])/100),
	) );
}
$upcoming_invoice_data['lines'] = $invoice_lines_arr;
array_push($invoice_pars_arr, $upcoming_invoice_data);
//========================== get upcoming invoice END   ============================

$menu_data = $this->htmltpl->get_left_settings_menu ( 99, 2 );
$data = array (
		'header' => $this->htmltpl->getHeader_new (),
		'footer_html' => $this->htmltpl->getFooter_new(),
		'settings_main_menu' => $menu_data ["main_menu"],
		'settings_sub_menu' => $menu_data ["sub_menu"],
		'invoice_pars_arr' => $invoice_pars_arr,
);

$data['stripe_current_period_start'] = date("F j, Y, g:i a", $customer['subscriptions']['data'][$is_main_id]['current_period_start']);
$data['stripe_current_period_end'] = date("F j, Y, g:i a", $customer['subscriptions']['data'][$is_main_id]['current_period_end']);
$data['stripe_created'] = date("F j, Y, g:i a", $customer['subscriptions']['data'][$is_main_id]['created']);
$data['stripe_billing'] = $customer['subscriptions']['data'][$is_main_id]['billing'];

$this->mlanguages->getdictionary("stripe_summary", "", $data);
$this->parser->parse ( 'templates/stripe_concept/summary2_view.html', $data );
