<?php
// ========================= set date ranges START ================================
$system_date_format = $this->frontdesk->get_systemdateformat();
$daterangepicker_date_format = $this->frontdesk->get_systemdateformat('for_daterangepicker');
$date_range = $this->session->userdata('stripe_invoices_date_range');
if ($date_range != ""){
	list ( $start_date, $end_date ) = explode ( ' - ',  $date_range);
	$start_date_timestamp = strtotime($start_date." 00:00");
	$end_date_timestamp = strtotime($end_date." 23:59");
}else {
	$start_date_timestamp = strtotime("first day of this month 00:00");
	$end_date_timestamp = strtotime("last day of this month 23:59");
	$start_date = date($system_date_format, $start_date_timestamp);
	$end_date = date($system_date_format, $end_date_timestamp);
}
// ========================= set date ranges FIN ==================================
// ========================= status selector START ================================
$statuses_arr = array(''=>"{mlw_all}", 'only_opened'=>"{clt_not_payed_invoices}");
$status_selector_options_arr = array();
$selected_status = $this->session->userdata('stripe_invoices_selected_status');
foreach ( $statuses_arr as $val => $name ) {
	$selected = "";
	if ($selected_status == $val) {
		$selected = "selected";
	}
	array_push ( $status_selector_options_arr, array (
			'value' => $val,
			'name' => $name,
			'selected' => $selected
	) );
}
if ($from_msg_routing == 'hm_rout'){//перехід відбувся з повідомлення системи, показуєм неоплачені інвойси
	$status_selector_options_arr[1]['selected'] = 'selected';
	$selected_status = "only_opened";
}
// ========================= status selector FINAL ================================
//================================== pagination START =============================
if ($this->session->userdata ( 'stripe_invoices_lines_per_page' ) != ""){
	$lines_per_page = $this->session->userdata ( 'stripe_invoices_lines_per_page' );
}else{
	$lines_per_page = 100;
}
$cur_page = $current_page;
$page_first_line = ($cur_page - 1) * $lines_per_page;
$lines_per_current_page = $page_first_line+1;
$url_for_pagination = "/stripe_concept/invoices/";
// $all_lines_count = count($invoices_list['data']);
//================================== pagination FIN ===============================
$stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id");
if ($stripe_billing_customer_id == ""){//нема кастомера
	$invoices_arr = array();
}else{//є кастомер
	$tbl_acts = "stripe_acts";
	$customer_id = $stripe_billing_customer_id;
	$secret_key = $this->stripe_billing_m->get_secret_key();
	$this->stripe->setApiKey($secret_key);
	$invoices_arr = array();
	if ($selected_status == "only_opened"){
		$all_invoices = $this->stripe_billing_m->get_opened_invoices();
		foreach ($all_invoices as $invoice) {
			//============== ACTS deeds START =====================
			$act_invioce_hide_class = "d0";
			//============== ACTS deeds FINAL =====================
			array_push ( $invoices_arr, array (
			'n' => $lines_per_current_page,
			'id' => $invoice ['id'],
			'number' => $invoice ['number'],
			'amount_paid' => $this->frontdesk->showcurrency($invoice ['amount_total']),
			// 	'amount_paid' => $this->frontdesk->showcurrency(((int)$invoice ['amount_paid'])/100),
			'created' => $invoice ['created'],
			'currency' => strtoupper ( $invoice ['currency'] ),
			'description' => $invoice ['description'],
			'status' => $invoice ['status'],
			'do_pay_hide_class' => "",
			'act_invioce_hide_class' => $act_invioce_hide_class,
			) );
			$lines_per_current_page++;
		}
		$pagination = "";
	}else{
		$temp_list_page = 1;
		$all_invoices = array();
		$invoices_list = $this->invoice->all ( array (
				"customer" => $customer_id,
				"limit" => $lines_per_page,
				"created" => array (
						"gte" => $start_date_timestamp,
						"lte" => $end_date_timestamp
				)
		) );
		$invoices_list = $invoices_list->__toArray(true);
		$all_invoices[$temp_list_page] = $invoices_list;
		while ($invoices_list['has_more']){
			$starting_after = $invoices_list['data'][$lines_per_page-1]['id'];
			$invoices_list = $this->invoice->all ( array (
					"customer" => $customer_id,
					"starting_after" => $starting_after,
					"limit" => $lines_per_page,
					"created" => array (
							"gte" => $start_date_timestamp,
							"lte" => $end_date_timestamp
					)
			) );
			$temp_list_page ++;
			$invoices_list = $invoices_list->__toArray(true);
			$all_invoices[$temp_list_page] = $invoices_list;
		};
		$all_lines_count = 0;
		foreach ($all_invoices as $invoices_list_on_page) {
			$all_lines_count += count($invoices_list_on_page['data']);
		}
		foreach ($all_invoices[$cur_page]['data'] as $invoice) {
			$do_pay_hide_class = "d0";
			if ($invoice ['status'] == 'open'){
				$do_pay_hide_class = "";
			}
			//============== ACTS deeds START =====================
			$act_invioce_hide_class = "d0";
			$act = $this->db->get_where($tbl_acts, array('act_number' => "A-".$invoice ['number']))->row();
			if (!empty($act)){
				$act_invioce_hide_class = "";
			}
			//============== ACTS deeds FINAL =====================
			array_push ( $invoices_arr, array (
			'n' => $lines_per_current_page,
			'id' => $invoice ['id'],
			'number' => $invoice ['number'],
			'amount_paid' => $this->frontdesk->showcurrency(((int)$invoice ['total'])/100),
			// 	'amount_paid' => $this->frontdesk->showcurrency(((int)$invoice ['amount_paid'])/100),
			'created' => date("Y-m-d H:i", $invoice ['created']),
			'currency' => strtoupper ( $invoice ['currency'] ),
			'description' => $invoice ['description'],
			'status' => "{clt_".$invoice ['status']."}",
			'do_pay_hide_class' => $do_pay_hide_class,
			'act_invioce_hide_class' => $act_invioce_hide_class,
			) );
			$lines_per_current_page++;
		}
		$pagination = $this->htmltpl->pagination ($all_lines_count, $lines_per_page, $cur_page, $url_for_pagination, 100);
	}
}
//================ need ACT only for russian hotels START ============================
$hotel_country = $this->frontdesk->get_visitka_id_country_3c();
$act_hide_class = ($hotel_country == "RUS") ? "" : "d0";
//================ need ACT only for russian hotels FINAL ============================
$menu_data = $this->htmltpl->get_left_settings_menu ( 99, 6 );
$data = array (
		'header' => $this->htmltpl->getHeader_new (0, 1, 0, "stripe_invoices"),
		'footer_html' => $this->htmltpl->getFooter_new(),
		'settings_main_menu' => $menu_data ["main_menu"],
		'settings_sub_menu' => $menu_data ["sub_menu"],
		'invoices_arr' => $invoices_arr,
		'daterangepicker_date_format' => $daterangepicker_date_format,
		'start_date' => $start_date,
		'end_date' => $end_date,
		'pagination' => $pagination,
		'status_selector_options_arr' => $status_selector_options_arr,
		'act_hide_class' => $act_hide_class,
);
$this->mlanguages->getdictionary("stripe_invoices", "", $data);
$this->mlanguages->getdictionary("stripe_statuses", "", $data);
$this->parser->parse ( 'templates/stripe_concept/invoices_view.html', $data );
