<?php
$session_data = $this->session->userdata('rlist');
$search_items = $this->rlist_mdl->get_search_items_values();
$sortby = $this->rlist_mdl->get_sortby_values();

$data = array();
$prefix = $this->mlanguages->get_language_prefix();
$status_table_name = "global_hotelix_languages.".$prefix."_statusofreservation";

//================ pagination init START =============================
if ($this->session->userdata ( 'rlist_lines_per_page' ) != ""){
	$lines_per_page = $this->session->userdata ( 'rlist_lines_per_page' );
}else{
	$lines_per_page = 50;
}
$cur_page = $current_page;
$page_first_line = ($cur_page - 1) * $lines_per_page;
$url_for_pagination = "/reservation_c2/rlist_dev/";
//================ pagination init FINAL =============================

$sql_where_str = " WHERE deskofreservation.deleted=0";

foreach ($search_items as $item_name => $item_value) {
    switch ($item_name) {
        case 'date_range':
            list ( $range_start_date, $range_end_date ) = explode ( ' - ', $item_value );
            $data["date_range"] = $item_value;
            $data['range_start_date'] = $range_start_date;
            $data['range_end_date'] = $range_end_date;
            break;
        case 'date_type':
            $date_types_set = array(
            "{mlw_datein}",//0
            "{mlw_dateout}",//1
            "{mlw_datecreate}",//2 - default
            "{mlw_days_of_stay}"//3
            );
            $date_type_select_options = array();
            
            foreach ($date_types_set as $val => $clt_name) {
                array_push($date_type_select_options, array(
                    'val' => $val,
                    'clt_name' => $clt_name,
                    'selected' => $val == $item_value ? 'selected' : '',
                ));
            }
                        
            $data['date_type_select_options'] = $date_type_select_options;
            
            switch ($item_value) {
                case 0://mlw_datein
                    $sql_where_str .= " AND deskofreservation.datein BETWEEN '$range_start_date' AND '$range_end_date'";
                    break;
                case 1://mlw_dateout
                    $sql_where_str .= " AND deskofreservation.dateout BETWEEN '$range_start_date' AND '$range_end_date'";
                    break;
                case 2://mlw_datecreate - default
                    $sql_where_str .= " AND deskofreservation.date BETWEEN '$range_start_date 00:00:00' AND '$range_end_date 23:59:59'";
                    break;
                case 3://mlw_days_of_stay
                    $sql_where_str .= " AND deskofreservation.datein <= '$range_end_date' AND deskofreservation.dateout >= '$range_start_date'";
                    break;
            }
            break;
        case 'statuses':
            $selected_statuses = array();
            foreach ($item_value as $status_id) {
                $selected_statuses[$status_id] = $status_id;
            }
            $all_statuses = $this->htmltpl->get_all_statuses_from_db();
            $statuses_select_options = array();
            foreach ( $all_statuses as $status_id =>  $status_data) {
                array_push ( $statuses_select_options, array (
                    'value' => $status_id,
                    'name' => $status_data['name'],
                    'selected_option' => isset ( $selected_statuses [$status_id] ) ? 'selected' : '',
                ) );
            }
            $data['statuses_select_options'] = $statuses_select_options;
            
            if (count($all_statuses) != count($selected_statuses)) {
                $sql_where_str .= " AND deskofreservation.status IN (" . implode(", ", $selected_statuses) . ")";
            }
            break;
        case 'categories':
            $selected_categories = array();
            foreach ($item_value as $category_id) {
                $selected_categories[$category_id] = $category_id;
            }
            
            //формування масиву опцій селекту категорій
            
            $categories_select_options = array();
            $all_categories = $this->htmltpl->get_all_categories_from_db();
            foreach ($all_categories as $category_id => $category_data) {
                array_push($categories_select_options, array(
                    'value' => $category_id,
                    'name' => $category_data['name'],
                    'selected_option' => isset ( $selected_categories [$category_id] ) ? 'selected' : '',
                ));
            }
            $data['categories_select_options'] = $categories_select_options;
            
            if (count($all_categories) !== count($selected_categories)) {
                $sql_where_str .= " AND rooms.category_id IN (" . implode(", ", $selected_categories) . ")";
            }
            break;
        case 'rate':
            $rates_select_options = array(
                array(
                    'val' => '',
                    'clt_name' => '{mlw_all}',
                    'selected' => 'selected'
                )
            );
            $all_rates_query_result = $this->db->query ( "SELECT id, caption FROM rate WHERE isactive = 1 ORDER BY `caption` ASC" )->result ();
            foreach ( $all_rates_query_result as $rate_data ) {
                array_push($rates_select_options, array(
                    'val' => $rate_data->id,
                    'clt_name' => $rate_data->caption,
                    'selected' => $rate_data->id == $item_value ? 'selected' : '',
                ));
                
            }
            
            if ($item_value) {
                $sql_where_str .= " AND deskofreservation.price_type = $item_value";
            }
            $data["rates_select_options"] = $rates_select_options;
            break;
        case 'intgroupid':
            $data['intgroupid'] = $item_value;
            
            if ($item_value) {
                $sql_where_str .= " AND deskofreservation.intgroupid = $item_value";
            }
            break;
        case 'room':
            $rooms_select_options = array(
                array(
                    'val' => '',
                    'clt_name' => '{mlw_all}',
                    'selected' => 'selected',
                    'optgroup' => array()
                )
            );
            $all_rooms_query_result = $this->db->query ( "SELECT id, name, category_id FROM rooms WHERE 
                                        rooms.category_id IN (" . implode(", ", $selected_categories) . ") ORDER BY category_id, name ASC" )->result ();
            $optgroup_room_label = '';
            foreach ( $all_rooms_query_result as $room_data ) {
                array_push($rooms_select_options, array(
                    'val' => $room_data->id,
                    'clt_name' => $room_data->name,
                    'selected' => $room_data->id == $item_value && isset($selected_categories[$room_data->category_id])? 'selected' : '',
                    'optgroup' => $optgroup_room_label != $room_data->category_id ? array(
                        array(
                            'group_name' => $all_categories[$room_data->category_id]['name']
                        )
                    ) : array(),
                ));
                $optgroup_room_label = $room_data->category_id;
            }

            $data['rooms_select_options'] = $rooms_select_options;
            
            if ($item_value) {
                $sql_where_str .= " AND deskofreservation.room_id = $item_value";
            }
            break;
        case 'dealer':
            $dealers_select_options = array(
                array(
                    'val' => '',
                    'clt_name' => '{mlw_all}',
                    'selected' => 'selected'
                ),
                /* array(
                    'val' => 'all_dealers',
                    'clt_name' => '{mlw_all_dealers}',
                    'selected' => $item_value == 'all_dealers' ? 'selected' : '',
                ) */
            );
            $all_dealers_query_result = $this->db->query ( "SELECT id, name FROM dealers ORDER BY `name` ASC" )->result ();
            foreach ( $all_dealers_query_result as $dealer_data ) {
                array_push($dealers_select_options, array(
                    'val' => $dealer_data->id,
                    'clt_name' => $dealer_data->name,
                    'selected' => $dealer_data->id == $item_value ? 'selected' : '',
                ));
                
            }
            $data["dealers_select_options"] = $dealers_select_options;
            
            if ($item_value) {
                $sql_where_str .= " AND deskofreservation.id_dealer = $item_value";
            }
            break;
        case 'discount':
            $data['discount_checked'] = $item_value ? 'checked' : '';
            
            if ($item_value) {
                $sql_where_str .= " AND deskofreservation.discount != 0";
            }
            break;
        case 'negative_balance':
            $data['negative_balance_checked'] = $item_value ? 'checked' : '';
            
            if ($item_value) {
                $sql_where_str .= " AND deskofreservation.balance < 0";
            }
            break;
        case 'not_confirmed':
            $data['not_confirmed_checked'] = $item_value ? 'checked' : '';
            
            if ($item_value) {
                $sql_where_str .= " AND deskofreservation.avoidtime > 0 AND deskofreservation.duetime > 0";
            }
            break;
        case 'bso':
            $data['bso_checked'] = $item_value ? 'checked' : '';
            
            if ($item_value) {
                $sql_where_str .= " AND payment.bso_id != 0";
            }
            break;
        case 'user':
            $users_select_options = array(
                array(
                    'val' => '',
                    'clt_name' => '{mlw_all}',
                    'selected' => 'selected'
                )
            );
            $all_users_query_result = $this->db->query ( "SELECT id, fullname, lastname FROM users ORDER BY `fullname` ASC" )->result();
            foreach ( $all_users_query_result as $user_data ) {
                array_push($users_select_options, array(
                    'val' => $user_data->id,
                    'clt_name' => "$user_data->fullname $user_data->lastname",
                    'selected' => $user_data->id == $item_value ? 'selected' : '',
                ));
            }
            $data['users_select_options'] = $users_select_options;
            
            if ($item_value) {
                $sql_where_str .= " AND deskofreservation.id_user = $item_value";
            }
            break;
    }
}

$money_fields = $this->rlist_mdl->get_money_fields();
$checked_money_fields = array();
$first_money_field_entry_position = false;

$fields = $this->rlist_mdl->get_fields();
$checked_fields = array();

$data["th_pars_data"] = array();
$data["reservation_list"] = array();
$data["display_options"] = (array)$fields;
$display_options_sorting_sign = $sortby->order == 'asc' ? 'up' : 'down';
$data["display_options"][$sortby->field_name]->sorting_sign = "<i class='bi bi-caret-$display_options_sorting_sign-fill' aria-hidden='true'>";

$sql_order_str = '';
$position = 0;//fild 'number' allways present and first
foreach($fields as $field_name => $field_data){
    
    if ($field_data->checked == 'checked') {
        array_push($checked_fields, $field_name);
        if (in_array($field_name, $money_fields)) {
            array_push($checked_money_fields, $field_name);
            if (!$first_money_field_entry_position) {
                $first_money_field_entry_position = $position;
            }
        }
        $position++;
    }
    
    $is_sortedby_this_fild = false;
    if ($field_name == $sortby->field_name ) {
        $is_sortedby_this_fild = true;
        $sql_order_str = "ORDER BY $field_name $sortby->order";
    }
	
	array_push ( $data["th_pars_data"], array (
	    'tbl_classes' => $field_data->tbl_th_class . " column_class_{$field_data->name} {$field_data->hiding_class}",
		'name' => $field_data->name,
		'clt' => $field_data->clt,
		'sortable_hiding_class' => $field_data->sortable_hiding_class,
		'sort_asc_activ_class' => $is_sortedby_this_fild && strtolower($sortby->order) == 'asc' ? '-fill ' : ' unactiv',//text-primary
		'sort_desc_activ_class' => $is_sortedby_this_fild && strtolower($sortby->order) == 'desc' ? '-fill ' : ' unactiv',//text-primary
	));
}
$data['check_all_filds_is_checked'] = count($checked_fields) == count((array)$fields) ? 'checked' : '';

$sums = array();
if ($first_money_field_entry_position) {
    $sums['total'] = array_fill_keys($money_fields, 0);
    $sums['page'] = array_fill_keys($money_fields, 0);
    $sql_total_sums = "SELECT deskofreservation.amount, deskofreservation.discount, SUM(payment.amount) as pay_amount, deskofreservation.balance
                        FROM deskofreservation
                        INNER JOIN rooms ON rooms.id=deskofreservation.room_id
                        LEFT JOIN payment ON  payment.reservation_id = deskofreservation.id
                        $sql_where_str
                        GROUP BY deskofreservation.id";
    
    $query_total_sums = $this->db->query($sql_total_sums)->result();
    foreach ($query_total_sums as $money_fild_values) {
        foreach ($sums['total'] as $money_fild_name => &$total_sum) {
            $total_sum += $money_fild_values->$money_fild_name;
        }
        unset($total_sum);
    }
}

$rlist_sql = "SELECT SQL_CALC_FOUND_ROWS 1 as number, deskofreservation.guest_id, deskofreservation.intgroupid, groupreservations.name as group_name,
deskofreservation.id as reservation_id, CONCAT(rooms.name, ' (', categories.name, ')') as cat_room_name, categories.name as cat_name, rooms.name as room_name,
CONCAT(guests.lastname, ' ', guests.firstname) as guest_name, CONCAT(users.lastname, ' ', users.fullname) as user_name, 
 deskofreservation.adults as base_places, deskofreservation.addbedplace as additional_places, deskofreservation.baby_places as baby_places,
dealers.name as dealer, rate.caption as rate_name, ".$status_table_name.".name as status_name,
deskofreservation.datein, deskofreservation.duration, deskofreservation.dateout, deskofreservation.amount, deskofreservation.discount,
SUM(IFNULL(payment.amount,0)) as pay_amount, deskofreservation.balance, deskofreservation.date, guests.phone, guests.email, deskofreservation.avoidtime, deskofreservation.duetime
FROM deskofreservation
JOIN guests ON deskofreservation.guest_id=guests.id
JOIN rooms ON rooms.id=deskofreservation.room_id
JOIN categories ON categories.id=rooms.category_id
JOIN ".$status_table_name." ON ".$status_table_name.".id = deskofreservation.status
LEFT JOIN dealers ON dealers.id = deskofreservation.id_dealer
LEFT JOIN payment ON  payment.reservation_id = deskofreservation.id
LEFT JOIN groupreservations ON  groupreservations.id = deskofreservation.intgroupid
LEFT JOIN rate ON  rate.id = deskofreservation.price_type
LEFT JOIN users ON users.id = deskofreservation.id_user
$sql_where_str
GROUP BY deskofreservation.id " . $sql_order_str . " LIMIT ".$page_first_line.", ".$lines_per_page;

$_SESSION['rlist_sql'] = $rlist_sql;//збереження в сесію СКЛ сторінки для передачі на вивід в ехель

$query_rlist_result = $this->db->query ( $rlist_sql )->result();
$query_p = $this->db->query ( "SELECT FOUND_ROWS() AS all_lines_count" )->row();
$all_lines_count = $query_p->all_lines_count;

$lines_per_current_page = $page_first_line;
foreach ( $query_rlist_result as $row ) {
    if ($first_money_field_entry_position) {
        foreach ($sums['page'] as $money_fild_name => &$page_sum) {
            $page_sum += $row->$money_fild_name;
        }
        unset($page_sum);
    }
	$td_reservation_data = array();
	if($row->avoidtime > 0 && $row->duetime > 0){
	    $confirm_status_str = "({clt_not_confirmed})";
	}
	
	$mono_status = $this->frontdesk_c2->mono_control_bydate($row->datein, $row->dateout);
	
	foreach($checked_fields as $field_name){
        switch ($field_name) {
            case "number":
                $td_value = ++$lines_per_current_page;
                break;
            case "reservation_id":
                $group_str = $row->intgroupid > 0 ? " <a href='/reservation_c2/foliogroup/{$row->intgroupid}'>[ GROUP {$row->group_name}]</a>" : '';
                $td_value = "<a href='/reservation_c2/folio/{$row->$field_name}/1'>{$row->$field_name}</a>$group_str";
                break;
            case "guest_name":
                $td_value = $mono_status ? '---' : "<a href='/reservation_c2/guestfolio/{$row->guest_id }'>{$row->$field_name}</a>";
                break;
            case "status_name":
                if ($mono_status == 1) {
                    $td_value = "---";
                } else {
                    $is_confirmed_str = ($row->avoidtime > 0 && $row->duetime > 0) ? ' ({clt_not_confirmed})' : '';
                    $td_value = "{$row->$field_name}{$is_confirmed_str}";
                }
                break;
            default:
                if ($mono_status) {
                    $td_value = '---';
                }elseif (in_array($field_name, $money_fields)) {
                    $td_value = $this->frontdesk->showcurrency($row->$field_name);
                }else {
                    $td_value = $row->$field_name;
                }
                break;
        }
        array_push($td_reservation_data, array(
            'td_class' => $fields->$field_name->tbl_th_class . " column_class_{$fields->$field_name->name} {$fields->$field_name->hiding_class}",
            'td_value' => $td_value,
        ));
	}
	array_push ( $data["reservation_list"], array (
		'td_reservation_data' => $td_reservation_data,
		'reservation_id' => $row->reservation_id
	) );
}
$data['tbl_foot'] = array();

if ($first_money_field_entry_position) {
    $data['tbl_foot'] = array(
        array(
            'tr_summ_page' => array(),
            'tr_summ_total' => array()
        )
    );
    foreach($checked_fields as $field_name){
        if (in_array($field_name, $checked_money_fields)) {
            array_push($data['tbl_foot'][0]['tr_summ_page'], array(
                'th_class' => 'text-right',
                'th_value' => $this->frontdesk->showcurrency($sums['page'][$field_name])
            ));
            array_push($data['tbl_foot'][0]['tr_summ_total'], array(
                'th_class' => 'text-right',
                'th_value' => $this->frontdesk->showcurrency($sums['total'][$field_name])
            ));
        }else {
            array_push($data['tbl_foot'][0]['tr_summ_page'], array(
                'th_class' => '',
                'th_value' => ''
            ));
            array_push($data['tbl_foot'][0]['tr_summ_total'], array(
                'th_class' => '',
                'th_value' => ''
            ));
        }
    }
    $data['tbl_foot'][0]['tr_summ_page'][$first_money_field_entry_position-1] ['th_value'] = '{caption_totalsum} {caption_onpage}: ';
    $data['tbl_foot'][0]['tr_summ_total'][$first_money_field_entry_position-1] ['th_value'] = '{caption_totalsum}: ';
    array_push($data['tbl_foot'][0]['tr_summ_page'], array(
        'th_class' => '',
        'th_value' => ''
    ));
    array_push($data['tbl_foot'][0]['tr_summ_total'], array(
        'th_class' => '',
        'th_value' => ''
    ));
}
$data["header"] = $this->htmltpl->getHeader_new ();
$data["footer_html"] = $this->htmltpl->getFooter_new ();
$data["left_menu"] = $this->htmltpl->get_left_menu (2);
$data["pagination"] = $this->htmltpl->pagination ($all_lines_count, $lines_per_page, $cur_page, $url_for_pagination);
$this->mlanguages->getdictionary("reservations_reservationedit", "", $data);
$this->mlanguages->getdictionary("reservations_rlist", "", $data);
$this->parser->parse ( 'templates/reservation_c2_rlist_dev_view.html', $data );