<?php
$pie_slices_limit = 10;
$report_number_threshold = $this->config->item('report_number_threshold');
$system_dateformat = $this->frontdesk->get_systemdateformat();
$picker_dateformat = $this->frontdesk->get_systemdateformat('for_daterangepicker');
$date_range = $this->session->userdata ( 'report_revenue_date_range' );
$selected_source = $this->session->userdata ( 'report_revenue_selected_source' );
$active_sources = $this->db->order_by('name', 'ASC')->select('id, name')->get_where('dealers', array('is_active' => 1))->result_array();
array_unshift($active_sources,array('id'=>'', 'name'=>'{mlw_all}'));
$select_option_sources = array();
foreach ($active_sources as $source) {
    $selected = ($source['id'] == $selected_source)? "selected":"";
    array_push($select_option_sources, array('id'=>$source['id'], 'name'=>$source['name'], 'selected' => $selected));
}
if (empty($date_range)){
	$start_date = date($system_dateformat, strtotime("first day of last month"));
	$end_date = date($system_dateformat, strtotime("last day of last month"));
}else{
	list ( $start_date, $end_date ) = explode ( ' - ', $date_range );
	$start_date = date($system_dateformat, strtotime($start_date));
	$end_date = date($system_dateformat, strtotime($end_date));
}
//формування масиву опцій селекту категорій START
$all_categories = $this->htmltpl->get_all_categories_from_db();
foreach ($all_categories as $key => $category) {// робимо валідними тільки активні і не овербукінг категорії
    if (!$category['is_active'] || isset($category['over'])) {
        unset($all_categories[$key]);
    }
}
$selected_categories = $this->session->userdata ( 'report_revenue_selected_categories' );
if ($selected_categories == "") {// робимо вибраними всі
    $selected_categories = array();
    foreach ( $all_categories as $category_id => $category_data ) {
        array_push($selected_categories, $category_id);
    }
}
$categories_select_options = array();
foreach ($all_categories as $category_id => $category_data) {
    $is_selected = in_array($category_id, $selected_categories) ? 'selected' : '';
    array_push($categories_select_options, array(
        'id' => $category_id,
        'name' => $category_data['name'],
        'selected' => $is_selected
    ));
}
//формування масиву опцій селекту категорій FINAL
//формування масиву опцій селекту відповідальних START
$all_users = $this->db->select('id, fullname, lastname')->get('users')->result();
$selected_users = $this->session->userdata ( 'report_revenue_selected_users' );
$selected_all_users = $this->session->userdata ( 'report_revenue_all_users' );

$selected_all_users_checked = "";
if($selected_all_users == 1){
    $selected_all_users_checked = "checked";
}

if ($selected_users == "") {// робимо вибраними всіх
    $selected_users = array();
    foreach ($all_users as $user) {
        array_push($selected_users, $user->id);
    }
}
$select_option_users = array();
foreach ($all_users as $user) {
    $is_selected = in_array($user->id, $selected_users) ? 'selected' : '';
    array_push($select_option_users, array(
        'id' => $user->id,
        'name' => "$user->fullname $user->lastname",
        'selected' => $is_selected
    ));;
}
//формування масиву опцій селекту відповідальних FINAL
$start_prev_date = date($system_dateformat, strtotime("$start_date -1 year"));
$end_prev_date = date($system_dateformat, strtotime("$end_date -1 year"));
$start_intdate = round(strtotime($start_date) / 86400);
$end_intdate = round(strtotime($end_date) / 86400);
$request_data = array(
    'start_intdate' => $start_intdate,
    'end_intdate' => $end_intdate,
    'selected_source' => $selected_source,
    'selected_categories' => $selected_categories,
    'selected_users' => $selected_users,
    'selected_all_users' => $selected_all_users
);
$cur_data = $this->report_model->get_REVENUE_graphycs_data($request_data);
$start_prev_intdate = round( strtotime($start_prev_date) / 86400);
$end_prev_intdate = round( strtotime($end_prev_date) / 86400);
$request_data = array(
    'start_intdate' => $start_prev_intdate,
    'end_intdate' => $end_prev_intdate,
    'selected_source' => $selected_source,
    'selected_categories' => $selected_categories,
    'selected_users' => $selected_users
);
$prev_data = $this->report_model->get_REVENUE_graphycs_data($request_data);
//==================== вирівнювання даних СТАРТ ================
if (isset($cur_data['accommodation'])){
	foreach ($cur_data['accommodation'] as $cat_id => $cat_data) {
		if (!isset($prev_data['accommodation'][$cat_id])){
			$prev_data['accommodation'][$cat_id]['amount'] = 0;
			$prev_data['accommodation'][$cat_id]['name'] = $cat_data['name'];
		}
		if ($cat_data['amount'] == 0  && $prev_data['accommodation'][$cat_id]['amount'] == 0){
		    unset($cur_data['accommodation'][$cat_id]);
		    unset($prev_data['accommodation'][$cat_id]);
		}
	}
}
if (isset($prev_data['accommodation'])){
	foreach ($prev_data['accommodation'] as $cat_id => $cat_data) {
		if (!isset($cur_data['accommodation'][$cat_id])){
			$cur_data['accommodation'][$cat_id]['amount'] = 0;
			$cur_data['accommodation'][$cat_id]['name'] = $cat_data['name'];
		}
		if ($cat_data['amount'] == 0  && $cur_data['accommodation'][$cat_id]['amount'] == 0){
		    unset($cur_data['accommodation'][$cat_id]);
		    unset($prev_data['accommodation'][$cat_id]);
		}
	}
}
if (isset($cur_data['services'])){
	foreach ($cur_data['services'] as $service_id => $service_data) {
		if (!isset($prev_data['services'][$service_id])){
			$prev_data['services'][$service_id]['amount'] = 0;
			$prev_data['services'][$service_id]['name'] = $service_data['name'];
		}
		if ($service_data['amount'] == 0  && $prev_data['services'][$service_id]['amount'] == 0){
		    unset($cur_data['services'][$service_id]);
		    unset($prev_data['services'][$service_id]);
		}
	}
}
if (isset($prev_data['services'])){
	foreach ($prev_data['services'] as $service_id => $service_data) {
		if (!isset($cur_data['services'][$service_id])){
			$cur_data['services'][$service_id]['amount'] = 0;
			$cur_data['services'][$service_id]['name'] = $service_data['name'];
		}
		if ($service_data['amount'] == 0  && $cur_data['services'][$service_id]['amount'] == 0){
		    unset($cur_data['services'][$service_id]);
		    unset($prev_data['services'][$service_id]);
		}
	}
}
//==================== вирівнювання даних ФІНІШ ================
$pies_parsing_arr = array (
		'accommodation_labels' => array (),
		'accommodation_cur_data' => array (),
		'accommodation_prev_data' => array (),
		'services_labels' => array (),
		'services_data' => array (),
		'services_cur_data' => array (),
		'services_prev_data' => array (),
);
$result_arr = array('services'=>array(), 'accommodation'=>array());
$counter_accommodations = $pie_slices_limit;
$rest_accommodation_cur_amount = 0;
$rest_accommodation_prev_amount = 0;
foreach ($cur_data['accommodation'] as $cat_id => $cat_data) {
	$result_arr['accommodation'][$cat_id]['name'] = $cat_data['name'];
	$cur_amount = $cat_data['amount'];
	$result_arr['accommodation'][$cat_id]['cur_amount'] = number_format($cur_amount, 2, ".", $report_number_threshold);
	$prev_amount = $prev_data['accommodation'][$cat_id]['amount'];
	$result_arr['accommodation'][$cat_id]['prev_amount'] = number_format($prev_amount, 2, ".", $report_number_threshold);
	$diff_amount = $cat_data['amount'] - $prev_data['accommodation'][$cat_id]['amount'];
	$result_arr['accommodation'][$cat_id]['diff_amount'] = number_format($diff_amount, 2, ".", $report_number_threshold);
	$arrow_class = "d0";
	$diff_percent = 0;
	if ($diff_amount > 0){
		$arrow_class = 'ion-arrow-up-c green';
		$diff_percent = round(abs($diff_amount/$cur_amount)*100, 2);
	}elseif ($diff_amount<0) {
		$arrow_class = 'ion-arrow-down-c red';
		$diff_percent = round(abs($diff_amount/$prev_amount)*100, 2);
	}
	$result_arr['accommodation'][$cat_id]['arrow_class'] = $arrow_class;
	$result_arr['accommodation'][$cat_id]['diff_percent'] =  number_format($diff_percent, 2);
	if ($counter_accommodations > 0){
		array_push($pies_parsing_arr['accommodation_labels'], $cat_data['name']);
		array_push($pies_parsing_arr['accommodation_cur_data'], number_format($cur_amount/$cur_data['accommodation_subtotal'] *100,2));
		array_push($pies_parsing_arr['accommodation_prev_data'], number_format($prev_amount/$prev_data['accommodation_subtotal'] *100,2));
		$counter_accommodations --;
	}else{
		$rest_accommodation_cur_amount += $cur_amount;
		$rest_accommodation_prev_amount += $prev_amount;
	}
}
if (count($cur_data['accommodation']) > $pie_slices_limit){
	array_push($pies_parsing_arr['accommodation_labels'], "{mlw_other}");
	array_push($pies_parsing_arr['accommodation_cur_data'], number_format($rest_accommodation_cur_amount/$cur_data['accommodation_subtotal'] *100,2));
	array_push($pies_parsing_arr['accommodation_prev_data'], number_format($rest_accommodation_prev_amount/$prev_data['accommodation_subtotal'] *100,2));
}
$counter_services = $pie_slices_limit;
$rest_services_cur_amount = 0;
$rest_services_prev_amount = 0;
foreach ($cur_data['services'] as $service_id => $service_data) {
	$result_arr['services'][$service_id]['name'] = $service_data['name'];
	$cur_amount = $service_data['amount'];
	$result_arr['services'][$service_id]['cur_amount'] = number_format($cur_amount, 2, ".", $report_number_threshold);
	$prev_amount = $prev_data['services'][$service_id]['amount'];
	$result_arr['services'][$service_id]['prev_amount'] = number_format($prev_amount, 2, ".", $report_number_threshold);
	$diff_amount = $service_data['amount'] - $prev_data['services'][$service_id]['amount'];
	$result_arr['services'][$service_id]['diff_amount'] = number_format($diff_amount, 2, ".", $report_number_threshold);
	$arrow_class = "d0";
	$diff_percent = 0;
	if ($diff_amount > 0){
		$arrow_class = 'ion-arrow-up-c green';
		$diff_percent = round(abs($diff_amount/$cur_amount)*100, 2);
	}elseif ($diff_amount<0) {
		$arrow_class = 'ion-arrow-down-c red';
		$diff_percent = round(abs($diff_amount/$prev_amount)*100, 2);
	}
	$result_arr['services'][$service_id]['arrow_class'] = $arrow_class;
	$result_arr['services'][$service_id]['diff_percent'] = number_format($diff_percent, 2);
	if ($counter_services > 0){
		array_push($pies_parsing_arr['services_labels'], $service_data['name']);
		array_push($pies_parsing_arr['services_cur_data'], number_format($cur_amount/$cur_data['services_subtotal'] *100,2));
		array_push($pies_parsing_arr['services_prev_data'], number_format($prev_amount/$prev_data['services_subtotal'] *100,2));
		$counter_services --;
	}else{
		$rest_services_cur_amount += $cur_amount;
		$rest_services_prev_amount += $prev_amount;
	}
}
if (count($cur_data['services']) > $pie_slices_limit){
	array_push($pies_parsing_arr['services_labels'], "{mlw_other}");
	array_push($pies_parsing_arr['services_cur_data'], number_format($rest_services_cur_amount/$cur_data['services_subtotal'] *100,2));
	array_push($pies_parsing_arr['services_prev_data'], number_format($rest_services_prev_amount/$prev_data['services_subtotal'] *100,2));
}
$cur_amount = $cur_data ['accommodation_subtotal'];
$prev_amount = $prev_data ['accommodation_subtotal'];
$diff_amount = $cur_amount - $prev_amount;
$arrow_class = "d0";
$diff_percent = 0;
if ($diff_amount > 0){
	$arrow_class = 'ion-arrow-up-c green';
	$diff_percent = round(abs($diff_amount/$cur_amount)*100, 2);
}elseif ($diff_amount<0) {
	$arrow_class = 'ion-arrow-down-c red';
	$diff_percent = round(abs($diff_amount/$prev_amount)*100, 2);
}
$result_arr ['accommodation_subtotal'] = array (
		array (
				'cur_amount' => number_format($cur_amount, 2, ".", $report_number_threshold),
				'prev_amount' => number_format($prev_amount, 2, ".", $report_number_threshold),
				'diff_amount' => number_format($diff_amount, 2, ".", $report_number_threshold),
				'diff_percent' => number_format($diff_percent, 2),
				'arrow_class' => $arrow_class,
		)
);
$cur_amount = $cur_data ['services_subtotal'];
$prev_amount = $prev_data ['services_subtotal'];
$diff_amount = $cur_amount - $prev_amount;
$arrow_class = "d0";
$diff_percent = 0;
if ($diff_amount > 0){
	$arrow_class = 'ion-arrow-up-c green';
	$diff_percent = round(abs($diff_amount/$cur_amount)*100, 2);
}elseif ($diff_amount<0) {
	$arrow_class = 'ion-arrow-down-c red';
	$diff_percent = round(abs($diff_amount/$prev_amount)*100, 2);
}
$result_arr ['services_subtotal'] = array (
		array (
				'cur_amount' => number_format($cur_amount, 2, ".", $report_number_threshold),
				'prev_amount' => number_format($prev_amount, 2, ".", $report_number_threshold),
				'diff_amount' => number_format($diff_amount, 2, ".", $report_number_threshold),
				'diff_percent' => number_format($diff_percent, 2),
				'arrow_class' => $arrow_class,
		)
);
$cur_amount = $cur_data ['accommodation_subtotal'] + $cur_data ['services_subtotal'];
$prev_amount = $prev_data ['accommodation_subtotal'] + $prev_data ['services_subtotal'];
$diff_amount = $cur_amount - $prev_amount;
$arrow_class = "d0";
$diff_percent = 0;
if ($diff_amount > 0){
	$arrow_class = 'ion-arrow-up-c green';
	$diff_percent = round(abs($diff_amount/$cur_amount)*100, 2);
}elseif ($diff_amount<0) {
	$arrow_class = 'ion-arrow-down-c red';
	$diff_percent = round(abs($diff_amount/$prev_amount)*100, 2);
}
$result_arr ['total'] = array (
		array (
				'cur_amount' => number_format($cur_amount, 2, ".", $report_number_threshold),
				'prev_amount' => number_format($prev_amount, 2, ".", $report_number_threshold),
				'diff_amount' => number_format($diff_amount, 2, ".", $report_number_threshold),
				'diff_percent' => number_format($diff_percent, 2),
				'arrow_class' => $arrow_class,
		)
);
$accommodation_hide_class = "";
$services_hide_class = "";
if (empty($result_arr['accommodation'])){
	$accommodation_hide_class = "d0";
}
if (empty($result_arr['services'])){
	$services_hide_class = "d0";
}
$data = array();
foreach ($pies_parsing_arr as $label => $value) {
	$data[$label] = json_encode($value);
}

$data["picker_dateformat"] = $picker_dateformat;
$data["accommodation_hide_class"] = $accommodation_hide_class;
$data["services_hide_class"] = $services_hide_class;
$data["parsing_arr"] = array($result_arr);
$data["start_date"] = $start_date;
$data["end_date"] = $end_date;
$data["curr_period"] = "$start_date - $end_date";
$data["prev_period"] = "$start_prev_date - $end_prev_date";
$data["select_option_sources"] = $select_option_sources;
$data["select_option_categories"] = $categories_select_options;
$data["select_option_users"] = $select_option_users;
$data["all_users_checked"] = $selected_all_users_checked;
$data["left_menu"] = $this->htmltpl->get_left_menu (1, 4);
$data["header"] = $this->htmltpl->getHeader_new ();
$data["footer_html"] = $this->htmltpl->getFooter_new();
$this->mlanguages->getdictionary("reports_c2_fraphs", "", $data);
$this->parser->parse ( 'templates/reports_c2/revenue_view.html', $data );

?>