<?php

$data['date'] = $filter_data['date'];

$data['sum_policies'] = [];

$data['total_adults'] = 0;
$data['total_baby_places'] = 0;
$data['total_infant_places'] = 0;

$data['services'] = [];

foreach ($days as $day) {
    if ($day['meal_policy_id'] == 1) {
        continue;
    }
    

    $data['services'][] = [
        'date' => $day['date'],
        'reservation_id' => $day['reservation_id'],
        'room' => $this->db->where('id', $day['room_id'])->get('rooms')->row_array()['name'] ?? 'Room not found',
        'rate' => $day['caption'],
        'adults' => $day['adults'] + $day['addbedplace'],
        'baby_places' => $day['baby_places'],
        'infant_places' => $day['babyplace2'],
        'meal_policy' => '{-'.$day['policy_name'].'-}',
        'guest' => $day['firstname'] . ' ' . $day['lastname'],
    ];

    $data['total_adults'] += $day['adults'] + $day['addbedplace'];
    $data['total_baby_places'] += $day['baby_places'];
    $data['total_infant_places'] += $day['babyplace2'];

    $data['sum_policies'][$day['meal_policy_id']]['policy_name'] = '{-'.$day['policy_name'].'-}';
    
    $data['sum_policies'][$day['meal_policy_id']]['total_adults'] = 
        ($data['sum_policies'][$day['meal_policy_id']]['total_adults'] ?? 0) + $day['adults'] + $day['addbedplace'];
    
    $data['sum_policies'][$day['meal_policy_id']]['total_baby_places'] = 
        ($data['sum_policies'][$day['meal_policy_id']]['total_baby_places'] ?? 0) + $day['baby_places'];
    
    $data['sum_policies'][$day['meal_policy_id']]['total_infant_places'] = 
        ($data['sum_policies'][$day['meal_policy_id']]['total_infant_places'] ?? 0) + $day['babyplace2'];
}

$data['select_option_rates'] = $this->db->select('id, caption')->where('isactive', 1)->get('rate')->result_array();
$data['select_option_statuses'] = $this->htmltpl->get_all_statuses_from_db();
$data['select_option_categories'] = $this->db->select('id, name')->where('is_active', 1)->get('categories')->result_array();
$data['select_option_rooms'] = $this->db->select('id, name')->where('is_active', 1)->get('rooms')->result_array();
$data['select_option_policies'] = $this->db->select('id, name')->where('id !=', 1)->get('meal_policies')->result_array();

foreach ($data['select_option_rates'] as $k => $v) {
    if (!in_array($v['id'], array_values($filter_data['rates']))) {
        $data['select_option_rates'][$k]['selected_option'] = '';
    } else {
        $data['select_option_rates'][$k]['selected_option'] = 'selected';
    }
}

foreach ($data['select_option_statuses'] as $k => $v) {
    $data['select_option_statuses'][$k]['value'] = $k;
    if (!in_array($k, $filter_data['statuses'])) {
        $data['select_option_statuses'][$k]['selected_option'] = '';
    } else {
        $data['select_option_statuses'][$k]['selected_option'] = 'selected';
    }
}

foreach ($data['select_option_categories'] as $k => $v) {
    if (!in_array($v['id'], $filter_data['categories'])) {
        $data['select_option_categories'][$k]['selected_option'] = '';
    } else {
        $data['select_option_categories'][$k]['selected_option'] = 'selected';
    }
}

foreach ($data['select_option_rooms'] as $k => $v) {
    if (!in_array($v['id'], $filter_data['rooms'])) {
        $data['select_option_rooms'][$k]['selected_option'] = '';
    } else {
        $data['select_option_rooms'][$k]['selected_option'] = 'selected';
    }
}

foreach ($data['select_option_policies'] as $k => $v) {
    if (!in_array($v['id'], $filter_data['policies'])) {
        $data['select_option_policies'][$k]['selected_option'] = '';
    } else {
        $data['select_option_policies'][$k]['selected_option'] = 'selected';
    }
}

$data['header'] = $this->htmltpl->getHeader_new();
$data['footer_html'] = $this->htmltpl->getFooter_new();

$data['left_menu'] = $this->htmltpl->get_left_menu(2);

//echo '<pre>';
//print_r($data);
//print_r(array_values($filter_data['rates']));
//exit();
$this->mlanguages->getdictionary('reservations_reservationedit', '', $data);
$this->mlanguages->getdictionary('reservations_rlist', '', $data);
$this->mlanguages->getdictionary('tbl_meal_policies', '', $data);
$this->parser->parse('templates/reports_c2/meal_plan_list_rlist_view.html', $data);
