<?php
if ($this->session->userdata ( 'kkm_shift_lines_per_page' ) != ""){
    $lines_per_page = $this->session->userdata ( 'kkm_shift_lines_per_page' );
}else{$lines_per_page = 50;}
$cur_page = $current_page;
$page_first_line = ($cur_page - 1) * $lines_per_page;
$lines_per_current_page = $page_first_line+1;
$url_for_pagination = "/reports_c2/kkm_shiftslist/";

$report_number_threshold = $this->config->item('report_number_threshold');
$system_dateformat = $this->frontdesk->get_systemdateformat();
$picker_dateformat = $this->frontdesk->get_systemdateformat('for_daterangepicker');
$date_range = $this->session->userdata ( 'report_kkm_shiftslist_date_range' );
if (empty($date_range)){
	$start_date = date($system_dateformat, strtotime("previous week monday"));
	$end_date = date($system_dateformat, strtotime("previous week sunday"));
}else{
	list ( $start_date, $end_date ) = explode ( ' - ', $date_range );
	$start_date = date($system_dateformat, strtotime($start_date));
	$end_date = date($system_dateformat, strtotime($end_date));
}
$start_timestamp = strtotime($start_date);
$end_timestamp = strtotime($end_date." 23:59:59");
$sql = "SELECT SQL_CALC_FOUND_ROWS t1.SessionNumber, t1.kkm_device_id, t2.NameDevice, t2.UnitName, t3.open_time, t3.close_time,
                SUM(IF(t1.pay_or_ref = 1, t1.amount, 0)) as refs_amount, SUM(IF(t1.pay_or_ref = 0, t1.amount, 0)) as pays_amount 
		FROM kkm_checks AS t1
		LEFT JOIN kkm_devices AS t2 ON t2.id = t1.kkm_device_id
		LEFT JOIN kkm_shifts_log AS t3 ON t3.kkm_device_id = t1.kkm_device_id AND t3.SessionNumber = t1.SessionNumber
		WHERE UNIX_TIMESTAMP(t1.processing_time) BETWEEN $start_timestamp AND $end_timestamp AND t1.fiscal_provider_id = 1
		GROUP BY t1.kkm_device_id, t1.SessionNumber
        LIMIT $page_first_line, $lines_per_page";//fiscal_provider_id = 1 is KKM

$query_res = $this->db->query($sql)->result_array();
$query_p = $this->db->query ( "SELECT FOUND_ROWS() AS all_lines_count" )->row();
$all_lines_count = $query_p->all_lines_count;

$total_pays = $total_refs = 0;
foreach ($query_res as &$rec) {
    $rec['n'] = $lines_per_current_page;
    $rec['pays_refs_amount'] = $rec['pays_amount'] - $rec['refs_amount'];
    $total_pays += $rec['pays_amount'];
    $total_refs += $rec['refs_amount'];
    $rec['pays_amount'] = $this->frontdesk->showcurrency($rec['pays_amount']);
    $rec['refs_amount'] = $this->frontdesk->showcurrency(-$rec['refs_amount']);
    $rec['pays_refs_amount'] = $this->frontdesk->showcurrency($rec['pays_refs_amount']);
    $lines_per_current_page++;
}
$data["total_pays"] = $this->frontdesk->showcurrency($total_pays);
$data["total_refs"] = $this->frontdesk->showcurrency(-$total_refs);
$data["total_pays_refs"] = $this->frontdesk->showcurrency($total_pays-$total_refs);
$data["picker_dateformat"] = $picker_dateformat;
$data["parsing_arr"] = $query_res;
$data["start_date"] = $start_date;
$data["end_date"] = $end_date;
$data["left_menu"] = $this->htmltpl->get_left_menu (1, 5);
$data["header"] = $this->htmltpl->getHeader_new ();
$data["footer_html"] = $this->htmltpl->getFooter_new();
$data["pagination"] = $this->htmltpl->pagination ($all_lines_count, $lines_per_page, $cur_page, $url_for_pagination);
$this->mlanguages->getdictionary("admin_payment_paymenttype", "", $data);
$this->mlanguages->getdictionary("kkm_shifts", "", $data);
$this->parser->parse ( 'templates/reports_c2/kkm_shiftslist_view.html', $data );
?>