<?php
$dc_hotel_id = $dc_hotel_id;
$dc_user = $this->config->item ( 'dc_booking_xml_user' );
$dc_password = html_entity_decode ($this->config->item ( 'dc_booking_xml_pwd' ));
$auth = $dc_user . ":" . $dc_password;
$headers = array('Authorization: Basic ' . base64_encode($auth));
$request = "<request>
				<hotel_id>$dc_hotel_id</hotel_id>
			</request>";
$ch = curl_init();
$url = 'https://supply-xml.booking.com/hotels/xml/getpromotions';
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $request);
$response = curl_exec($ch);
curl_close($ch);
$response = json_decode(json_encode(simplexml_load_string($response)), true);
$promotions_arr = $response;
if (!isset($response['promotion'][0])){// only 1 promotion
	$promotions_arr = array();
	$promotions_arr['promotion'][0] = $response['promotion'];
}
$promotions = array();
foreach ($promotions_arr['promotion'] as $k => $v) {
	$promotions[$k]['dc_hotel_id'] = $dc_hotel_id;
	$promotions[$k]['id'] = $v['@attributes']['id'];
	$promotions[$k]['name'] = $v['@attributes']['name'];
	$promotions[$k]['type'] = $v['@attributes']['type'];
	$promotions[$k]['target_channel'] = $v['@attributes']['target_channel'];
	$promotions[$k]['min_stay_through'] = $v['@attributes']['min_stay_through'];
	$promotions[$k]['non_refundable'] = (bool)($v['@attributes']['non_refundable'])
		? 'Non Refundable' : 'Refundable';
	$promotions[$k]['no_cc_promotion'] = (bool)($v['@attributes']['no_cc_promotion'])
		? 'Credit Card is NOT Required' : 'Credit Card is Requiered' ;
	$promotions[$k]['status'] = (bool)($v['@attributes']['active'])
	? 'active' : 'inactive';
	$promotions[$k]['last_minute_unit'] = $v['last_minute']['@attributes']['unit'] != -1
		? $v['last_minute']['@attributes']['unit'] : "--";
	$promotions[$k]['last_minute_value'] = $v['last_minute']['@attributes']['value'] != -1
		? $v['last_minute']['@attributes']['value'] : "--";
	$promotions[$k]['early_booker_value'] = $v['early_booker']['@attributes']['value'] != -1
		? $v['last_minute']['@attributes']['value'] : "--";
	$promotions[$k]['early_booker_value'] = $v['early_booker']['@attributes']['value'] != -1
		? $v['early_booker']['@attributes']['value'] : "--";
	$promotions[$k]['book_date'] = $v['book_date']['@attributes']['start'] . ' - <br/>' . $v['book_date']['@attributes']['end'];
	$promotions[$k]['book_time'] = $v['book_time']['@attributes']['start'] . ' - <br/>' . $v['book_time']['@attributes']['end'];
	$promotions[$k]['stay_date'] = $v['stay_date']['@attributes']['start'] . ' - <br/>' . $v['stay_date']['@attributes']['end'];
	//Р”РЅС– С‚РёР¶РЅСЏ
	if( is_array($v['stay_date']['active_weekdays']['active_weekday']) ){
		foreach( $v['stay_date']['active_weekdays']['active_weekday'] as $key => $val ){
			$promotions[$k]['active_weekdays'][$key]['day'] = $val;
		}
	} else {
		$promotions[$k]['active_weekdays'][0]['day'] = $v['stay_date']['active_weekdays']['active_weekday'];
	}
	//Р’РёРєР»СЋС‡РµРЅС– РґРЅС–
	if( isset( $v['stay_date']['excluded_dates']['excluded_date'] )
			&& is_array( $v['stay_date']['excluded_dates']['excluded_date'] ) ){
		foreach( $v['stay_date']['excluded_dates']['excluded_date'] as $key => $val ){
			$promotions[$k]['excluded_dates'][$key]['day'] = $val;
		}
	} elseif( isset( $v['stay_date']['excluded_dates']['excluded_date'] ) ) {
		$promotions[$k]['excluded_dates'][0]['day'] = $v['stay_date']['excluded_dates']['excluded_date'];
	} else {
		$promotions[$k]['excluded_dates'][0]['day'] = '--';
	}
	//Р”РѕРґР°С‚РєРѕРІС– РґРЅС–
	if( isset($v['additional_dates']['additional_date'])
		&& is_array( $v['additional_dates']['additional_date'] ) ){
		foreach( $v['additional_dates']['additional_date'] as $key => $val ){
			$promotions[$k]['additional_dates'][$key]['day'] = $val;
		}
	} elseif( isset($v['additional_dates']['additional_date']) ) {
		$promotions[$k]['additional_dates'][0]['day'] = $v['additional_dates']['additional_date'];
	} else {
		$promotions[$k]['additional_dates'][0]['day'] = '--';
	}
	// РљС–РјРЅР°С‚Рё
	if( count( $v['rooms']['room'] ) > 1 ){
		foreach( $v['rooms']['room'] as $key => $val ){
			$promotions[$k]['rooms'][$key]['room'] = $val['@attributes']['id'];
		}
	} else {
		$promotions[$k]['rooms'][0]['room'] = $v['rooms']['room']['@attributes']['id'];
	}
	//РўР°СЂРёС„Рё
	if( isset( $v['parent_rates']['parent_rate'] ) && count( $v['parent_rates']['parent_rate'] ) > 1 ){
		foreach( $v['parent_rates']['parent_rate'] as $key => $val ){
			$promotions[$k]['parent_rates'][$key]['rate'] = $val['@attributes']['id'];
		}
	} elseif( isset( $v['parent_rates']['parent_rate'] ) ) {
		$promotions[$k]['parent_rates'][0]['rate'] = $v['parent_rates']['parent_rate']['@attributes']['id'];
	} else {
		$promotions[$k]['parent_rates'][0]['rate'] = '--';
	}
	$promotions[$k]['discount'] = $v['discount']['@attributes']['value'];
	$promotions[$k]['total_revenue'][0] = array(
		'value' 			=> $v['stats']['total_revenue']['@attributes']['value'],
		'currency' 			=> $v['stats']['total_revenue']['@attributes']['currency'],
		'nr_room_nights' 	=> $v['stats']['nr_room_nights'],
		'nr_bookings'		=> $v['stats']['nr_bookings'],
		'nr_cancellations'	=> $v['stats']['nr_cancellations'],
	);
}


$menu_data = $this->htmltpl->get_left_settings_menu ( 7, 1 );
$submenulist = $this->navigation->getnotelist_admin_2 ( 33, 1 );
$submenulist [10] ['active'] = 'class="active"';
$data = array (
		'submenulist' => $submenulist,
		'header' => $this->htmltpl->getHeader_new (),
		'footer' => $this->htmltpl->getFooter_new(),
		'settings_main_menu' => $menu_data ["main_menu"],
		'settings_sub_menu' => $menu_data ["sub_menu"],
		'promotions' => $promotions,
);
$this->mlanguages->getdictionary ( "dc_cannal_all_options", "", $data );
$this->parser->parse ( 'templates/dc_booking_c2_promotions_list_view.html', $data );
?>
