<?php
	$dc_hotel_id = $dc_hotel_id;
	$id = $id;
	$headers = $this->dcm_booking_promotions->get_auth_headers();
	$request = "<request>
					<hotel_id>$dc_hotel_id</hotel_id>
					<id>$id</id>
				</request>";
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, 'https://supply-xml.booking.com/hotels/xml/getpromotions');
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	curl_setopt($ch, CURLOPT_POST, true);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $request);
	$response = curl_exec($ch);
	curl_close($ch);
	$response = json_decode(json_encode(simplexml_load_string($response)), true);
	$active_weekdays_options_arr = $this->dcm_booking_promotions->get_weekdays_arr();
	$rooms_rates_arrs = $this->dcm_booking_promotions->get_rooms_rates_arrs($dc_hotel_id);

	$rooms_options_arr = $rooms_rates_arrs['rooms'];
	$rates_options_arr = $rooms_rates_arrs['rates'];
	$promotion = array();
	$book_time_start_hours_options_arr = $book_time_end_hours_options_arr = $this->dcm_booking_promotions->get_hours_arr();
	$promotion['promotion_name'] 		= $response['promotion']['@attributes']['name'];
	$promotion['promotion_type'] 		= $response['promotion']['@attributes']['type'];
	$promotion['target_channel'] 		= $response['promotion']['@attributes']['target_channel'];
	$promotion['min_stay_through']		= $response['promotion']['@attributes']['min_stay_through'];
	$promotion['non_refundable'] 		= $response['promotion']['@attributes']['non_refundable'] == 1 ? 'checked="checked"' : '';
	$promotion['no_cc_promotion'] 		= $response['promotion']['@attributes']['no_cc_promotion'] ? 'checked="checked"' : '';
	$promotion['last_minute_unit'] 		= $response['promotion']['last_minute']['@attributes']['unit'];
	$promotion['last_minute_value'] 	= $response['promotion']['last_minute']['@attributes']['value'];
	$promotion['early_booker_value'] 	= $response['promotion']['early_booker']['@attributes']['value'];

	$promotion['book_date_start'] 		= $response['promotion']['book_date']['@attributes']['start'] == -1 ? "":$response['promotion']['book_date']['@attributes']['start'];
	$promotion['book_date_end'] 		= $response['promotion']['book_date']['@attributes']['end'] == -1 ? "":$response['promotion']['book_date']['@attributes']['end'];
	$promotion['book_date_val'] 		= $promotion['need_book_date_checked'] = "";
	if ($promotion['book_date_start'] > 0){
		$promotion['need_book_date_checked']= "checked";
		$promotion['book_date_val'] 	= $promotion['book_date_start']." - ".$promotion['book_date_end'];
	}
	$promotion['book_time_start'] 		= $response['promotion']['book_time']['@attributes']['start'];
	$promotion['book_time_end'] 		= $response['promotion']['book_time']['@attributes']['end'];
	$promotion['stay_date_start'] 		= $response['promotion']['stay_date']['@attributes']['start'];
	$promotion['stay_date_end'] 		= $response['promotion']['stay_date']['@attributes']['end'];
	$promotion['stay_date_val'] 		= $promotion['stay_date_start']." - ".$promotion['stay_date_end'];
	if( is_array($response['promotion']['stay_date']['active_weekdays']['active_weekday']) ){
		foreach( $response['promotion']['stay_date']['active_weekdays']['active_weekday'] as $k => $v ){
			$promotion['active_weekdays'][$k]['day'] = $v;
			$active_weekdays_options_arr[$v]['selected'] = "selected";
		}
	} else {
		$promotion['active_weekdays'][0]['day'] = $response['promotion']['stay_date']['active_weekdays']['active_weekday'];
		$active_weekdays_options_arr[$response['promotion']['stay_date']['active_weekdays']['active_weekday']]['selected'] = "selected";
	}

	$promotion['excluded_dates'] = "";
	if( isset( $response['promotion']['stay_date']['excluded_dates']['excluded_date'] )	&& is_array( $response['promotion']['stay_date']['excluded_dates']['excluded_date'] ) ){
		foreach( $response['promotion']['stay_date']['excluded_dates']['excluded_date'] as $k => $v ){
			$promotion['excluded_dates'] .= $v.",";
		}
		$promotion['excluded_dates'] = substr($promotion['excluded_dates'], 0, -1);
	} elseif( isset( $response['promotion']['stay_date']['excluded_dates']['excluded_date'] ) ) {
		$promotion['excluded_dates'] = $response['promotion']['stay_date']['excluded_dates']['excluded_date'];
	}
	$promotion['additional_dates'] = "";
	if( isset($response['promotion']['additional_dates']['additional_date'])&& is_array( $response['promotion']['additional_dates']['additional_date'] ) ){
		foreach( $response['promotion']['additional_dates']['additional_date'] as $k => $v ){
			$promotion['additional_dates'] .= $v.",";
		}
		$promotion['additional_dates'] = substr($promotion['additional_dates'], 0, -1);
	} elseif( isset($response['promotion']['additional_dates']['additional_date']) ) {
		$promotion['additional_dates'] = $response['promotion']['additional_dates']['additional_date'];
	}

	if( count( $response['promotion']['rooms']['room'] ) > 1 ){
		foreach( $response['promotion']['rooms']['room'] as $k => $v ){
			$promotion['rooms'][$k]['room'] = $v['@attributes']['id'];
			$rooms_options_arr[$v['@attributes']['id']]['selected'] = "selected";
		}
	} else {
		$promotion['rooms'][0]['room'] = $response['promotion']['rooms']['room']['@attributes']['id'];
		$rooms_options_arr[$response['promotion']['rooms']['room']['@attributes']['id']]['selected'] = "selected";
	}
	if( isset( $response['promotion']['parent_rates']['parent_rate'] ) && count( $response['promotion']['parent_rates']['parent_rate'] ) > 1 ){
		foreach( $response['promotion']['parent_rates']['parent_rate'] as $k => $v ){
			$promotion['parent_rates'][$k]['parent_rate'] = $v['@attributes']['id'];
			$rates_options_arr[$v['@attributes']['id']]['selected'] = "selected";
		}
	} elseif( isset( $response['promotion']['parent_rates']['parent_rate'] ) ) {
		$promotion['parent_rates'][0]['rate'] = $response['promotion']['parent_rates']['parent_rate']['@attributes']['id'];
		$rates_options_arr[$response['promotion']['parent_rates']['parent_rate']['@attributes']['id']]['selected'] = "selected";
	} else {
		$promotion['parent_rates'][0]['rate'] = '--';
	}
	$promotion['discount'] = $response['promotion']['discount']['@attributes']['value'];
	$promotion['total_revenue'][0] = array(
			'value' 			=> $response['promotion']['stats']['total_revenue']['@attributes']['value'],
			'currency' 			=> $response['promotion']['stats']['total_revenue']['@attributes']['currency'],
			'nr_room_nights' 	=> $response['promotion']['stats']['nr_room_nights'],
			'nr_bookings'		=> $response['promotion']['stats']['nr_bookings'],
			'nr_cancellations'	=> $response['promotion']['stats']['nr_cancellations'],
	);
	$promotion_type_options_arr = $this->dcm_booking_promotions->get_promotion_types_arr($promotion['promotion_type']);
	$target_channel_options_arr = $this->dcm_booking_promotions->get_target_channels_arr();
	if (isset($target_channel_options_arr[$promotion['target_channel']])) {$target_channel_options_arr[$promotion['target_channel']]['selected'] = "selected";}
	$last_minute_unit_options_arr = $this->dcm_booking_promotions->get_last_minute_units_arr();
	if ($promotion['last_minute_unit'] != -1) {$last_minute_unit_options_arr[$promotion['last_minute_unit']]['selected'] = "selected";}
	$book_time_start_hours_options_arr[$promotion['book_time_start']]["selected"] = "selected";
	$book_time_end_hours_options_arr[$promotion['book_time_end']]["selected"] = "selected";

	$menu_data = $this->htmltpl->get_left_settings_menu ( 7, 1 );
	$submenulist = $this->navigation->getnotelist_admin_2 ( 33, 1 );
	$submenulist [10] ['active'] = 'class="active"';
	$data = array (
			'submenulist' => $submenulist,
			'header' => $this->htmltpl->getHeader_new (),
			'footer' => $this->htmltpl->getFooter_new(),
			'settings_main_menu' => $menu_data ["main_menu"],
			'settings_sub_menu' => $menu_data ["sub_menu"],
			'active_weekdays_options_arr' => $active_weekdays_options_arr,
			'rooms_options_arr' => $rooms_options_arr,
			'rates_options_arr' => $rates_options_arr,
			'book_time_start_hours_options_arr' => $book_time_start_hours_options_arr,
			'book_time_end_hours_options_arr' => $book_time_end_hours_options_arr,
			'promotion_type_options_arr' => $promotion_type_options_arr,
			'target_channel_options_arr' => $target_channel_options_arr,
			'last_minute_unit_options_arr' => $last_minute_unit_options_arr,
			'dc_hotel_id' => $dc_hotel_id,
			'promotion_id' => $id,
			'title_clt' => "{clt_edit_promotion}",
	);
	$data = array_merge($data, $promotion);
	$this->mlanguages->getdictionary ( "dc_cannal_all_options", "", $data );
	$this->mlanguages->getdictionary ( "booking_promotions", "", $data );
	$this->parser->parse ( 'templates/dc_booking/edit_promotion.html', $data );
?>
