<?php
if (isset($contact_id) && $contact_id) {
    $action = 'update';
    $contact = (array) $this->contacts_mdl->get_contact(array('id' => $contact_id));
}else {
    $action = 'create';
    $contact = $this->contacts_mdl->pure_contact;
}

$properties = $this->booking_api_mdl->get_hms_properties(array('property_filds_to_select' => array('id', 'property_name')));
$properties_pars_arr = array();
foreach ($properties as $property) {
    $selected = '';
    if ($action == 'update') {
        if ($contact['property_id'] == $property->id) {
            $selected = 'selected';
        }
    }
    $properties_pars_arr[$property->id] = array(
        'prop_id' => $property->id,
        'prop_name' => "$property->property_name (id:$property->id)",
        'prop_selected' => $selected
    );
}

$ContactProfileTypes_pars_arr = $this->booking_api_mdl->get_contact_profile_types_enum();
foreach ($ContactProfileTypes_pars_arr as &$ContactProfileType) {
    $selected = '';
    if ($action == 'update') {
        if ($contact['ContactProfileType'] == $ContactProfileType['prof_type']) {
            $selected = 'selected';
        }
    }
    $ContactProfileType['cpt_selected'] = $selected;
}

$genders = $this->booking_api_mdl->get_bk_genders_enum();
$genders_pars_arr = array();
foreach ($genders as $gender) {
    $selected = '';
    if ($action == 'update') {
        if ($contact['Gender'] == $gender) {
            $selected = 'selected';
        }
    }
    $genders_pars_arr[$gender] = array(
        'gender_val' => $gender,
        'gender_name' => "{clt_$gender}",
        'gender_selected' => $selected
    );
}

$languages = $this->db->select('name_original as lang_name, 2char as lang_val')
    ->get_where('`global_hotelix`.dic_languages', array('isactive' => 1))
    ->result();


    $name_languages_pars_arr = $address_languages_pars_arr = array();
foreach ($languages as $language) {
    $selected = $addr_selected = '';
    if ($action == 'update') {
        if ($contact['Language'] == $language->lang_val) {
            $selected = 'selected';
        }
        if ($contact['Address_Language'] == $language->lang_val) {
            $addr_selected = 'selected';
        }
    }
    $name_languages_pars_arr[$language->lang_val] = array(
        'lang_name' => $language->lang_name,
        'lang_val' => $language->lang_val,
        'lang_selected' => $selected
    );
    $address_languages_pars_arr[$language->lang_val] = array(
        'lang_name' => $language->lang_name,
        'lang_val' => $language->lang_val,
        'lang_selected' => $addr_selected
    );
}

$pttcs = $this->booking_api_mdl->get_bk_PhoneTechnologyTypeCodes();
$pttcs_pars_arr = array();
foreach ($pttcs as $ptt_code => $ptt_name) {
    $selected = '';
    if ($action == 'update') {
        if ($contact['PhoneTechType'] == $ptt_code) {
            $selected = 'selected';
        }
    }
    $pttcs_pars_arr[$ptt_code] = array(
        'ptt_code' => $ptt_code,
        'ptt_name' => $ptt_name,
        'ptt_selected' => $selected
    );
}

$JobTitles = $this->booking_api_mdl->get_bk_JobTitles();
$JobTitles_pars_arr = array();
foreach ($JobTitles as $JobTitle) {
    $selected = '';
    if ($action == 'update') {
        if ($contact['JobTitle'] == $JobTitle['id']) {
            $selected = 'selected';
        }
    }
    $JobTitles_pars_arr[$JobTitle['id']] = array(
        'jt_id' => $JobTitle['id'],
        'jt_name' => $JobTitle['name'],
        'jt_selected' => $selected
    );
}

$countries = $this->db->select('NAME_LAT as name, id_2ch as val')
->get_where('`global_fms_base`.dict_country', array('active' => 1))
->result();
$countries_pars_arr = array();
foreach ($countries as $country) {
    $selected = '';
    if ($action == 'update') {
        if ($contact['CountryName'] == $country->val) {
            $selected = 'selected';
        }
    }
    $countries_pars_arr[$country->val] = array(
        'country_name' => $country->name,
        'country_val' => $country->val,
        'country_selected' => $selected
    );
}
$contact['countries_pars_arr'] = $countries_pars_arr;
$contact['JobTitles_pars_arr'] = $JobTitles_pars_arr;
$contact['pttcs_pars_arr'] = $pttcs_pars_arr;
$contact['name_languages_pars_arr'] = $name_languages_pars_arr;
$contact['address_languages_pars_arr'] = $address_languages_pars_arr;
$contact['properties_pars_arr'] = $properties_pars_arr;
$contact['ContactProfileTypes_pars_arr'] = $ContactProfileTypes_pars_arr;
$contact['genders_pars_arr'] = $genders_pars_arr;
$contact_form_data = array(
    'contact_parse_arr' => array($contact),
);

$form_content = $this->parser->parse('templates/contacts/contact_form.html', $contact_form_data, true);
$menu_data = $this->htmltpl->get_left_settings_menu ( 1, 16 );

$data = array (
    'header' => $this->htmltpl->getHeader_new (),
    'footer_html' => $this->htmltpl->getFooter_new(),
    'settings_main_menu' => $menu_data ["main_menu"],
    'settings_sub_menu' => $menu_data ["sub_menu"],
    'crup_page_name_clt' => "{clt_{$action}_contact_page_name}",
    'form_content' => $form_content,
);
$this->mlanguages->getdictionary("admin_payment_paymenttype", "", $data);
$this->parser->parse ( 'templates/contacts/crup_view.html', $data );