<?php
$way = $this->Stripe->delegation2currency($currency);

switch ($way) {
    case "uk":
        $currency_arr = array();
        $currency_arr[0]["currency_name"] = $currency;
        $currency_arr[0]["selected"] = "selected";
        $stripe = $this->Stripe->get_param_hms_billing_uk();
        $stripe_account = "uk";
        break;
    case "us":
        $currency_arr = array();
        $currency_arr[0]["currency_name"] = $currency;
        $currency_arr[0]["selected"] = "selected";
        $stripe = $this->Stripe->get_param_hms_billing();
        $stripe_account = "us";
        break;
    default:
        die("Stripe delegation error! Unknown way!");
        break;
}


$curl_data = array();
$url = "https://cpcrm-dev.otelms.com/gate/get_billidoc_data/" . $this->config->item('hotel_id');
$result = $this->Curl_model->CurlPlug($curl_data, $url);

$data_billing = json_decode($result, true);

$balance = 0;
$count_billingdoc = count($data_billing);
for ($i = 0; $i < $count_billingdoc; $i ++) {
    $balance += $data_billing[$i]["amount"];
}

$data = array();
if ($balance < 0) {
    $data["balance"] = abs($balance);
} else {
    $data["balance"] = "";
}
$data["currency_options"] = $currency_arr;
$data['header'] = $this->htmltpl->getHeader_new(0, 0);
$data['footer_html'] = $this->htmltpl->getFooter_new();
$menu_data = $this->htmltpl->get_left_settings_menu(9, 2);
$data["settings_main_menu"] = $menu_data["main_menu"];
$data["settings_sub_menu"] = $menu_data["sub_menu"];

$this->mlanguages->getdictionary("left_menu_c2", "", $data);

$this->mlanguages->getdictionary("billing_firstdatapayment", "", $data);


$data['publishable_key'] = $stripe['publishable_key'];
$data['stripe_account'] = $stripe_account;

$this->parser->parse('templates/billing_c2_stripe_view.html', $data);
?>