<?php

class Stripe_billing_m3 extends CI_model
{
    public function __construct(){
        parent::__construct();
        $this->load->model('hotelix_config');
        $this->load->model ( 'hms_routing_m2' );
    }

    public function get_property_region_id_for_plans( string $country=""): int
    {
        if( empty( $country ) ){
            $country = $this->frontdesk->get_visitka_id_country_3c();
        }

        $region_id = $this->db
            ->where('id', $country)
            ->get('global_fms_base.dict_country')
            ->row()->region_id ?? 0;

        if( ! $region_id > 0 ){
            $region_id = 17;//International Market(USD)
        }

        return $region_id;
    }

    public function get_billing_count(): ?array
    {
        $sql = "SELECT dwelling, count(id) AS q 
            FROM property_information 
            GROUP BY dwelling";
        
        $prop_groups = $this->db->query($sql)->result_array();

        foreach( $prop_groups as &$p ){
            if( $p['dwelling'] == 1 ){
                $p['rooms'] = $this->hotelix_config->get_record('single_dwelling_rooms_count', 'int');
            } else {
               $p['rooms'] = $this->hotelix_config->get_record('multi_dwelling_rooms_count', 'int');
            }
        }
        
        return $prop_groups;
    }

    public function get_keys( int $region_id, string $type = 'public' ): ?string
    {
        $account_id = $this->db
            ->where('region_id', $region_id)
            ->get('global_hotelix.stripe_region2account')
            ->row()
            ->account_id ?? 0;

        if( ! $account_id ) return null;

        $keys = [
            'public' => $this->config->item('stripe_billing_public_' . $account_id),
            'secret' => $this->config->item('stripe_billing_secret_' . $account_id),
        ];

        return $keys[$type] ?? null;
    }

    public function get_plans_ranges( array $prop_groups, string $currency ): array
    {
        $dict_currencies = $this->db->get('global_hotelix.currency')->result_array();

        $currency_symbol = array_column($dict_currencies, 'symbol', 'name')[$currency] ?? '';

        $base_ranges = array (
            1 => array (
                'mcount_value' => 1,
                'mcount_pars_value' => 1,
                'mcount_clt' => '{clt_month}',
                'active_class' => 'active',
                'main_currency_symbol' => $currency_symbol,
                'old_hidden' => 'd0',
                'is_checked' => 'checked',
            ),
            3 => array (
                'mcount_value' => 3,
                'mcount_pars_value' => 3,
                'mcount_clt' => '{clt_3months}',
                'active_class' => '',
                'main_currency_symbol' => $currency_symbol,
                'old_hidden' => '',
                'is_checked' => '',
            ),
            6 => array (
                'mcount_value' => 6,
                'mcount_pars_value' => 6,
                'mcount_clt' => '{clt_months}',
                'active_class' => '',
                'main_currency_symbol' => $currency_symbol,
                'old_hidden' => '',
                'is_checked' => '',
            ),
            12 => array (
                'mcount_value' => 12,
                'mcount_pars_value' => 1,
                'mcount_clt' => '{clt_year}',
                'active_class' => '',
                'is_checked' => '',
                'main_currency_symbol' => $currency_symbol,
                'old_hidden' => ''
            ),
        );

        foreach( $prop_groups as &$g ){
            $month_price = $this->db
                ->where('mcount', 1)
                ->where('type_id',  $g['dwelling'])
                ->where('currency', strtolower($currency))
                ->where('is_active', 1)
                ->where('is_main', 1)
                ->get('global_hotelix.stripe_plans_test_v3')
                ->row();
            
            if( $g['dwelling'] == 2 ){
                $g['type_str'] = '{clt_multi}';
                foreach( $base_ranges as &$r ){
                    $price = $this->db
                        ->where('mcount', $r['mcount_value'])->where('type_id',  $g['dwelling'])->where('is_main', 1)
                        ->where('currency', strtolower($currency))->where('is_active', 1)
                        ->get('global_hotelix.stripe_plans_test_v3')
                        ->row();
                    $r['price'] = $price->amount ?? 0;
                    $r['old_price'] = $month_price->amount ?? 0;
                }
                $g['ranges'] = $base_ranges;
                
                
            } else {
                $g['type_str'] = '{clt_single}';
                if( $g['rooms'] > 5) {
                    $g['ranges']['1'] = $base_ranges[1];
                }                
                $g['ranges']['12'] = $base_ranges[12];
            }
        }

        return $prop_groups;
    }

    public function save_subscription_id(): void
    {
        try {
            $subscriptions = $this->stripe->subscriptions->all(['customer' => $this->customer_id]);
        } catch( Exception $e ){
            $error_text = $e->getMessage();
            $this->session->set_userdata ( array('error_page_message' => $error_text) );
        }
        
        foreach( $subscriptions['data'] as $key => $s ){
            if( ! null == $s->metadata->is_main ){
               $this->hotelix_config->set_record( "stripe_subscription_id", $s->id );
            }
        }
    }

    public function get_subscription_data()
    {
        $sub_id = $this->hotelix_config->get_record('stripe_subscription_id');
        //$sub_id = 'sub_1Rpp6JFtGkXaNdPMj3CGxTS5';
        
        if( ! $sub_id ) return null;

        try{
            $subscription = $this->stripe->subscriptions->retrieve($sub_id);
        } catch( Exception $e ){
            $error_text = $e->getMessage();
            $this->session->set_userdata ( array('error_page_message' => $error_text) );
            dd( $error_text );
        }
        if( ! null == $subscription->schedule ){
            try{
                $schedule = $this->stripe->subscriptionSchedules->retrieve( $subscription->schedule, ['expand' => ['phases.items.price', 'subscription']] );
            } catch( Exception $e ){
                $error_text = $e->getMessage();
                $this->session->set_userdata ( array('error_page_message' => $error_text) );
                dd( $error_text );
            }
            return $schedule;
        }
        return $subscription;
    }

    public function get_invoices( string $customer_id, bool $open_only )
    {
        $request = [
            'customer' => $customer_id
        ];

        if( $open_only ){
            $request['status'] = 'open';
        }

        try {
            $invoices = $this->stripe->invoices->all();

        } catch( Exception $e ){
            $error_text = $e->getMessage();
            $this->session->set_userdata ( array('error_page_message' => $error_text) );
            die ( "<meta http-equiv='refresh' content='0;url=/errors_c2/view_error/0/'>" );
            return null;
        }

        return $invoices;
    }

    public function get_plans( bool $is_main )
    {
        if ($this->config->item('hms_stripe_billing_test') == 1) {
            $table_stripe_plans = "stripe_plans_test_v3";
        } else {
            $table_stripe_plans = "stripe_plans_v3";
        }

        $currency = $this->get_currency( $this->stripe_region_id );

        $plans = $this->db
            ->where('currency', $currency['region_currency'])
            ->where('is_active', 1);

        if( $currency['has_plan'] ){
            $plans->where( 'region_id', $this->stripe_region_id );
        } else {
            $plans->where( 'region_id', 0 );
        }

        if( $is_main ){
            $plans->where('is_main', 1 );
        }

        return $plans->get('global_hotelix.' . $table_stripe_plans)->result_array();
    }

    public function calculate_apart_tiers( string $plan_id, int $quantity, string $currency ): int
    {
        $tier = $this->db
            ->where( 'up_to >', $quantity )
            ->where( 'plan_id', $plan_id )
            ->where( 'currency', $currency )
            ->order_by('up_to', 'ASC')
            ->get( 'global_hotelix.stripe_plans_tiers_v3' )
            ->row_array();
        
        if( $tier == null ) return 0;
            
        return $tier['flat_amount'] > 0 ? $tier['flat_amount'] : $tier['unit_amount'] * $quantity;

    }

    public function get_features()
    {
        $modules = $this->db->where_in('region_id', [0, $this->stripe_region_id])->get('global_hotelix_stripe.plans_modules')->result_array();
        

        foreach( $modules as $m ){
            $features[$m['label']]['feature_text'] = '{' . $m['caption'] . '}';
            $features[$m['label']]['bold_style'] = $m['parent_id'] ?  '' : 'style="font-weight: bold"';
            if( $m['level'] == 'free' ) $features[$m['label']]['free_i_class'] = 'fa-check-circle icon-success';
            if( $m['level'] == 'base' ) $features[$m['label']]['base_i_class'] = 'fa-check-circle icon-success';
            if( $m['level'] == 'ultra' ) $features[$m['label']]['ultra_i_class'] = 'fa-check-circle icon-success';
            $features[$m['label']]['free_i_class'] = $features[$m['label']]['free_i_class'] ?? 'fa-times icon-danger';
            $features[$m['label']]['base_i_class'] = $features[$m['label']]['base_i_class'] ?? 'fa-plus-circle icon-warning';
        }

        return $features;
    }

    public function get_modules( string $level ): array
    {
        $currency = $this->stripe_billing_m3->get_currency( $this->stripe_region_id )['region_currency'] ?? '';
        
        $modules = $this->db
                ->where_in('region_id', [0, $this->stripe_region_id])
                ->where('level', $level)
                ->where('parent_id', 0)
                ->get('global_hotelix_stripe.plans_modules')
                ->result_array();

        
        $dict_currencies = $this->db->get('global_hotelix.currency')->result_array();
        
        $currency_symbol = array_column($dict_currencies, 'symbol', 'name')[$currency] ?? '';

        $i = 0;/////////// !!!
        foreach ($modules as $m) {
            if( $i == 5 ) break;/////////// !!!
            $res[$m['label']]['caption'] = '{' . $m['caption'] . '}';
            $res[$m['label']]['icon_class'] = 'fa-calendar'; ////// !!!!!!!
            $res[$m['label']]['main_currency_symbol'] = $currency_symbol;
            $res[$m['label']]['price'] = $this->frontdesk->showcurrency(1568); /////////// !!!
            $res[$m['label']]['checked'] = (rand(0,1)) ? 'checked' : ''; /////////// !!!
            $res[$m['label']]['id'] = $m['label'];
            $i++;/////////// !!!
        }

        return $res;
    }


    /** HELPER FUNCTIONS */
    public function sync_plans( $date = '2025-07-22' )
    {
        $currencies = $this->get_currency();

        try{
            $products = $this->stripe->products->all( ['created' => ['gt' => strtotime($date)]] );
        } catch( Exception $e) {
            dd( $e->getMessage() );
        }

        foreach( $products['data'] as $product ){
            //if( null == $product->metadata->is_main ) continue;

            $expand_arr = ['data.currency_options'];
            foreach( $currencies as $c ){
                $currency = strtolower($c['region_currency']);
                array_push( $expand_arr, "data.currency_options.$currency.tiers" );
            }

            try{
                $prices = $this->stripe->prices->all(['product' => $product, 'expand' => $expand_arr])['data'] ?? [];
                foreach( $prices as $price ){
                    foreach( $currencies as $c ){
                        $currency = strtolower($c['region_currency']);
                        if( ! null ==  $price->currency_options->$currency ){
                            $plan = [
                                'is_active' => (int)$price->active,
                                'is_main' => (int)$product->metadata->is_main ?? 0,
                                'has_tiers' => (int)($price->billing_scheme == 'tiered'),
                                'lookup_key' => (string)$price->lookup_key,
                                'mcount' => $price->recurring->interval == 'month' 
                                    ? $price->recurring->interval_count 
                                    : $price->recurring->interval_count * 12,
                                'amount' =>  $price->billing_scheme == 'tiered' ? 0 : (float)$price->currency_options->$currency->unit_amount/100,
                                'type_id' => $price->metadata->type_id ?? 0,
                                'level' => $price->metadata->level ?? null
                                
                            ];

                            $sql = "INSERT INTO global_hotelix.stripe_plans_test_v3 
                                (plan_id, name, product_id, is_active, is_main, has_tiers, amount, currency, lookup_key, mcount, type_id, level) 
                                VALUES(
                                    '{$price->id}',
                                    '{$product->name}',
                                    '{$product->id}',
                                    {$plan['is_active']},
                                    {$plan['is_main']},
                                    {$plan['has_tiers']},
                                    {$plan['amount']},
                                    '$currency',
                                    '{$plan['lookup_key']}',
                                    {$plan['mcount']},
                                    {$plan['type_id']},
                                    '{$plan['level']}'
                                )
                                ON DUPLICATE KEY UPDATE 
                                    amount={$plan['amount']},
                                    mcount={$plan['mcount']},
                                    is_active={$plan['is_active']},
                                    is_main={$plan['is_main']},
                                    type_id={$plan['type_id']},
                                    level='{$plan['level']}'
                                ";
                            $this->db->query( $sql );

                            if( $price->billing_scheme == 'tiered' ){
                                foreach( $price->currency_options->$currency->tiers as $tier ){
                                    $up_to = $tier->up_to == null ? 9999 : $tier->up_to;
                                    $unit_amount = (double)$tier->unit_amount/100;
                                    $flat_amount = (double)$tier->flat_amount/100;

                                    $sql = "INSERT INTO global_hotelix.stripe_plans_tiers_v3 (plan_id, currency, unit_amount, flat_amount, up_to) 
                                        VALUES (
                                            '{$price->id}',
                                            '$currency',
                                            $unit_amount,
                                            $flat_amount,
                                            $up_to
                                        ) 
                                        ON DUPLICATE KEY UPDATE unit_amount=$unit_amount, flat_amount=$flat_amount";
                                    $this->db->query( $sql );
                                }
                            }
                        }

                        
                    }
                }

            } catch( Exception $e) {
                dd( $e->getMessage() );
            }
        }
    }

    public function get_currency( ?int $region_id = null ): array
    {
        $currencies = $this->db->from('global_hotelix.stripe_region2account');

        if( $region_id ){
            $currencies->where('region_id', $region_id);
        }

        if( $region_id ){
            return $currencies->get()->row_array() ?? [];
        }

        return $currencies->get()->result_array();
    }

    public function create_customer(): ?string
    {
        $hms_id = $this->config->item('hotel_id');

        $customer_data = [
            'email' => "hms_customer_$hms_id@otelms.com",
            'description' => "HMS customer $hms_id",
            'metadata' => [
                'hms_id' => $hms_id,
                'host' => $this->config->item('host_name')
            ]
        ];

        $customer = $this->stripe->customers->create($customer_data);
        
        $this->hotelix_config->set_record("stripe_billing_customer_id", $customer->id);
        $this->hotelix_config->set_record("stripe_subscription_id", '');
        $this->hotelix_config->set_record("stripe_plan_id", '');
        
        return $customer;
    }

    public function clear_billing()
    {
        $this->hotelix_config->set_record("stripe_billing_customer_id", '');
        $this->hotelix_config->set_record("stripe_subscription_id", '');
        $this->hotelix_config->set_record("stripe_plan_id", '');
    }


    /** OLD FUNCTIONS */

    
    public function get_plans_descriptions_by_levels() {
        $tbl = 'global_hotelix_stripe.plans_modules';
        $region_id = $this->get_property_region_id_for_plans();
        $descrs = $this->db->select('level, caption, parent_id')->get_where($tbl, "region_id = 0 OR region_id = $region_id")->result();
        $res = [];
        foreach ($descrs as $descr) {
            if (!isset($res[$descr->level])) {
                $res[$descr->level] = [];
            }
            array_push($res[$descr->level], ['clt' => '{'.$descr->caption.'}', 'bold_class' => $descr->parent_id == 0 ? 'style="font-weight: bold"' : '']);
        }
        return $res;
    }
    
    
    
    
    function get_customer() {
        $stripe_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
        $secret_key = $this->stripe_billing_m2->get_secret_key();
        $this->stripe->setApiKey($secret_key);
        $response = $this->customer->retrieve($stripe_customer_id);
        $customer = $response->__toArray(true);
        return $customer;
    }
    
    function save_stripe_workshop_settings($data){//застаріла здається, див майстерню
        $tbl_name = "`stripe_info`";
        $keys = array("property_type", "stripe_region", "stripe_version");
        $insert_arr = array();
        foreach ($keys as $insrting_item) {
            if (isset($_POST[$insrting_item])){
                $insert_arr['name'] = $insrting_item;
                $insert_arr['value'] = $_POST[$insrting_item];
                $this->frontdesk->db_insert_on_duplicate_key_update($tbl_name, $insert_arr, $keys);
            }
        }
    }
    
    function save_hms_billing_version($data){
        $this->hotelix_config->set_record("hms_billing_version", $data['hms_billing_version'], 'int');
    }
    
    function save_stripe_billing_offline($data){
        $this->hotelix_config->set_record("stripe_billing_offline", $data['stripe_billing_offline'], 'int');
    }
    
    function save_lock_till_open($data){
        $this->hotelix_config->set_record("lock_till_open", $data['lock_till_open']);
    }
    
    function save_hms_property_type4stripe($data){
        $this->hotelix_config->set_record("hms_property_type4stripe", $data['hms_property_type4stripe'], 'int');
    }
    
    function save_hms_property_count4stripe($data){
        $this->hotelix_config->set_record("hms_property_count4stripe", $data['hms_property_count4stripe'], 'int');
    }
    
    function get_db_plans_data_by_month_count_old ($month_count) {
        $type_id_arr = $this->stripe_billing_m2->get_property_type_id_arr_for_plans();
        $type_id = $type_id_arr['type_id'];
        
        //$type_id = 1;
        
        $region_id = $this->stripe_billing_m2->get_stripe_region_id();
        $return_array = array();
        
        if ($this->config->item('hms_stripe_billing_test') == 1) {
            $table_stripe_plans = "stripe_plans_test";
        } else {
            $table_stripe_plans = "stripe_plans";
        }
        if ($type_id == 2){//hotels
            $sql = "SELECT plan_id, amount, currency, is_premium FROM `global_hotelix`." . $table_stripe_plans . "
            WHERE `region_id` = $region_id AND  (`type_id` = $type_id OR `type_id` = 0 and `is_premium`=2)  AND mcount = " . $month_count;
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                foreach ($query->result() as $row) {
                    switch ($row->is_premium) {
                        case 0:
                            $return_array["standart"]["plan_id"] = $row->plan_id;
                            $return_array["standart"]["is_premium"] = $row->is_premium;
                            $return_array["standart"]["price"] = number_format($row->amount, 2, '.', '');
                            $return_array["standart"]["monthly_price"] = number_format($row->amount / $month_count, 2, '.', '');
                            $return_array["standart"]["plan_currency"] = strtoupper($row->currency);
                            break;
                        case 1:
                            $return_array["premium"]["plan_id"] = $row->plan_id;
                            $return_array["premium"]["is_premium"] = $row->is_premium;
                            $return_array["premium"]["price"] = number_format($row->amount, 2, '.', '');
                            $return_array["premium"]["monthly_price"] = number_format($row->amount / $month_count, 2, '.', '');
                            $return_array["premium"]["plan_currency"] = strtoupper($row->currency);
                            break;
                        case 2:
                            if ($this->config->item('allow_mono_rate') == 1){
                                $return_array["mono"]["plan_id"] = $row->plan_id;
                                $return_array["mono"]["is_premium"] = $row->is_premium;
                                $return_array["mono"]["price"] = number_format($row->amount, 2, '.', '');
                                $return_array["mono"]["monthly_price"] = number_format($row->amount / $month_count, 2, '.', '');
                                $return_array["mono"]["plan_currency"] = strtoupper($row->currency);
                            }
                            break;
                    }
                }
            }
        }
        if ($type_id == 1){//aparts
            $sql = "SELECT $table_stripe_plans.plan_id, $table_stripe_plans.currency, stripe_plans_tiers.*, is_premium
            FROM `global_hotelix`.$table_stripe_plans
            JOIN global_hotelix.stripe_plans_tiers ON stripe_plans_tiers.plan_id = $table_stripe_plans.plan_id
            WHERE is_premium = 0 AND `region_id` = $region_id AND  `type_id` = $type_id AND mcount = " . $month_count;
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $res_tier_arr = $query->result_array();
                $tiers_price = $this->stripe_billing_m2->tiers_price($res_tier_arr, $type_id_arr['price_count']);
                $return_array["standart"]["plan_id"] = $res_tier_arr[0]['plan_id'];
                $return_array["standart"]["price"] = number_format($tiers_price, 2, '.', '');
                $return_array["standart"]["monthly_price"] = number_format($tiers_price / $month_count, 2, '.', '');
                $return_array["standart"]["plan_currency"] = strtoupper($res_tier_arr[0]['currency']);
            }else{//NO TIRES? ANOMAL
            }
            
            $sql = "SELECT $table_stripe_plans.plan_id, $table_stripe_plans.currency, stripe_plans_tiers.*, is_premium
            FROM `global_hotelix`.$table_stripe_plans
            JOIN global_hotelix.stripe_plans_tiers ON stripe_plans_tiers.plan_id = $table_stripe_plans.plan_id
            WHERE is_premium = 1 AND `region_id` = $region_id AND  `type_id` = $type_id AND mcount = " . $month_count;
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $res_tier_arr = $query->result_array();
                $tiers_price = $this->stripe_billing_m2->tiers_price($res_tier_arr, $type_id_arr['price_count']);
                $return_array["premium"]["plan_id"] = $res_tier_arr[0]['plan_id'];
                $return_array["premium"]["price"] = number_format($tiers_price, 2, '.', '');
                $return_array["premium"]["monthly_price"] = number_format($tiers_price / $month_count, 2, '.', '');
                $return_array["premium"]["plan_currency"] = strtoupper($res_tier_arr[0]['currency']);
            }else{//NO TIRES? ANOMAL
            }
            
            // не потрібна поки логіка моно режиму для апартаментів
            //    			$sql = "SELECT plan_id, amount, currency, is_premium FROM `global_hotelix`." . $table_stripe_plans . "
            //    			WHERE `region_id` = $region_id AND  `type_id` = 0 and `is_premium`=2  AND mcount = " . $month_count;
            //    			$query = $this->db->query($sql);
            //    			if ($query->num_rows() > 0) {
            //                 $row = $query->row();
            //                 $return_array["mono"]["plan_id"] = $row->plan_id;
            //                 $return_array["mono"]["is_premium"] = $row->is_premium;
            //                 $return_array["mono"]["price"] = number_format($row->amount, 2, '.', '');
            //                 $return_array["mono"]["monthly_price"] = number_format($row->amount / $month_count, 2, '.', '');
            //                 $return_array["mono"]["plan_currency"] = strtoupper($row->currency);
            //             }
        }
        //================= врахування скидки (купона) при існуючому кастомері START ==========================
        $discount = "";
        $stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id");
        if ($stripe_billing_customer_id != ""){//є кастомер
            $customer_id = $stripe_billing_customer_id;
            $secret_key = $this->stripe_billing_m2->get_secret_key();
            $this->stripe->setApiKey ( $secret_key );
            $customer_obj = $this->customer->retrieve ($customer_id);
            $customer = $customer_obj->__toArray(true);
            if (!is_null($customer['discount'])){
                $coupon_arr = $customer['discount']['coupon'];
                if (isset($coupon_arr['id']) && $coupon_arr['id'] != ""){
                    if ($coupon_arr['amount_off'] != ""){//скидка фіксованва
                        $discount = $this->frontdesk->showcurrency(((int)$coupon_arr['amount_off'])/100);
                        $discount_in_percents = false;
                    }else{//скидка відсоткова
                        $discount = (int)$coupon_arr['percent_off'];
                        $discount_in_percents = true;
                    }
                }
            }
        }
        if ($discount != ""){//була встановлена знижка, отже був кастомер, оновлюєм масив цін
            foreach ($return_array as &$plan) {
                //наразі виводимо ціну зі знижкою, її і міняємо, в майбутніх планах виводити 3: ціну, ціну зі знижкою, знижку
                if($discount_in_percents){
                    // 	   				$plan['price_with_discount'] = $price_with_discount;
                    // 	   				$plan['discount'] = $discount;
                    $plan['price'] = number_format($plan['price']*(1 - $discount / 100), 2, '.', '');
                    $plan['monthly_price'] = number_format($plan['monthly_price']*(1 - $discount / 100), 2, '.', '');
                }else{
                    //вияснити і доробити коли знижка не відсоткова!!!!!!!!!!!!!!!
                    // 	   				$plan['price_with_discount'] = $price_with_discount;
                    // 	   				$plan['discount'] = $discount;
                    // 	   				$plan['price'] = $plan['price'];
                    // 	   				$plan['monthly_price'] = $plan['monthly_price'];
                }
                unset($plan);
            }
        }
        //================= врахування скидки (купона) при існуючому кастомері FINAL ==========================
        return $return_array;
    }
    
    public function get_db_plans_data_by_month_count ($month_count) {
        $type_id_arr = $this->get_property_type_id_arr_for_plans();
        $type_id = $type_id_arr['type_id'];
        
        $region_id = $this->stripe_billing_m2->get_stripe_region_id();
        $hotel_country = $this->frontdesk->get_visitka_id_country_3c();
        $is_country_in_russector = $hotel_country == 'RUS' ? true : false;
        $table_stripe_plans = ($this->config->item('hms_stripe_billing_test') == 1) ? "stripe_plans_test": "stripe_plans";
        $plans_tiers_tbl = 'global_hotelix.stripe_plans_tiers';
        
        $stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id");
        $stripe_subscription_id = $this->hotelix_config->get_record("stripe_subscription_id");
        $current_plan_id = ($stripe_billing_customer_id != '' && $stripe_subscription_id != '') ? $this->hotelix_config->get_record("stripe_plan_id") : '';
        
        $return_array = [];
        $level_sort_keys = ['free' => 0, 'base' => 1, 'premium' => 2, 'ultra' => 3];
        if ($this->config->item('stripe_OFF_free_plan') == 1) {
            unset($level_sort_keys['free']);
        }
        
        if ($type_id == 3) {//hybrid
            $apparts_type = 1;
            $hotels_type = 2;
            
            $apparts_set = $hotels_set = [];
            
            $types_sql_where_str = '';
            if (isset($type_id_arr['quantities'][$apparts_type]['apparts_count']) && $type_id_arr['quantities'][$apparts_type]['apparts_count']) {
                $types_sql_where_str .= "$apparts_type";
            }
            if (isset($type_id_arr['quantities'][$hotels_type]['hotels_count']) && $type_id_arr['quantities'][$hotels_type]['hotels_count']) {
                $types_sql_where_str = $types_sql_where_str != '' ? "$types_sql_where_str, $hotels_type" : "$hotels_type";
            }
            
            $query_res = $this->db
            ->select('type_id, plan_id, has_tiers, amount, currency, level')
            ->from("`global_hotelix`.$table_stripe_plans")
            ->where("`region_id` = $region_id AND `type_id` IN($types_sql_where_str) AND mcount = $month_count AND is_active = 1")
            ->where_in('level', array_keys($level_sort_keys))
            ->get()->result();
            
            foreach ($query_res as $plan_set) {
                switch ($plan_set->type_id) {
                    case $apparts_type:
                        $apparts_count = $type_id_arr['quantities'][$apparts_type]['apparts_rooms_count'];
                        $res_tier_arr = $this->db->get_where($plans_tiers_tbl, ['plan_id' => $plan_set->plan_id])->result_array();
                        if ($res_tier_arr) {
                            $grouped_tiers_arr = [];
                            foreach ($res_tier_arr as $tiers_arr) {
                                if (!isset($grouped_tiers_arr[$plan_set->level])) {
                                    $grouped_tiers_arr[$plan_set->level] = [];
                                }
                                array_push($grouped_tiers_arr[$plan_set->level], $tiers_arr);
                            }
                            foreach ($grouped_tiers_arr as $plan_level => $grouped_arr) {
                                $tiers_price = $this->stripe_billing_m2->tiers_price($grouped_arr, $apparts_count);
                                $apparts_set[$plan_level] = [
                                    'plan_id' => $plan_set->plan_id,
                                    'has_tiers' => 1,
                                    'level' => $plan_set->level,
                                    'clt_plan_level_name' => strtoupper($plan_set->level),
                                    'price_int' => (int) $tiers_price,
                                    'price_float' => '00',
                                    'monthly_price_int' => (int)$tiers_price / $month_count,
                                    'currency' => strtoupper($plan_set->currency),
                                    'quantity' => $apparts_count,
                                ];
                            }
                        }else{//NO TIRES? ANOMAL
                        }
                        break;
                    case $hotels_type:
                        if ($plan_set->has_tiers) {
                            $hotels_count = $type_id_arr['quantities'][$hotels_type]['hotels_rooms_count'];
                            $tiers_sql = "SELECT flat_amount
                            FROM $plans_tiers_tbl
                            WHERE plan_id = '$plan_set->plan_id' AND up_to >= $hotels_count
                            ORDER BY up_to ASC";
                            $tiers_query_row = $this->db->query($tiers_sql)->row();
                            $plan_amount = 0;
                            if ($tiers_query_row && isset($tiers_query_row->flat_amount)) {
                                $plan_amount = $tiers_query_row->flat_amount;
                            }
                        }else{
                            $hotels_count = $type_id_arr['quantities'][$hotels_type]['hotels_count'];
                            $plan_amount = $plan_set->amount * $hotels_count;
                        }
                        $hotels_set[$plan_set->level] = [
                            'plan_id' => $plan_set->plan_id,
                            'has_tiers' => $plan_set->has_tiers,
                            'level' => $plan_set->level,
                            'clt_plan_level_name' => strtoupper($plan_set->level),
                            'price_int' => (int)$plan_amount,
                            'price_float' => '00',
                            'monthly_price_int' => (int)$plan_amount / $month_count,
                            'currency' => strtoupper($plan_set->currency),
                            'quantity' => $hotels_count,
                        ];
                        break;
                }
            }
            foreach ($level_sort_keys as $level_name => $level_num) {
                if (!isset($return_array[$level_num])) {
                    if (isset($hotels_set[$level_name])) {
                        $return_array[$level_num] = $hotels_set[$level_name];
                        $return_array[$level_num]['hibryd_data'] = [];
                        $return_array[$level_num]['hibryd_data'][$hotels_set[$level_name]['plan_id']] = [
                            'plan_id' => $hotels_set[$level_name]['plan_id'],
                            'has_tiers' => $hotels_set[$level_name]['has_tiers'],
                            'quantity' => $hotels_set[$level_name]['quantity'],
                            'prop_type' => $hotels_type,
                        ];
                        if (isset($apparts_set[$level_name])) {
                            $return_array[$level_num]['plan_id'] .= ",".$apparts_set[$level_name]['plan_id'];
                            $return_array[$level_num]['price_int'] += (int) $apparts_set[$level_name]['price_int'];
                            $return_array[$level_num]['monthly_price_int'] += (int) $apparts_set[$level_name]['monthly_price_int'];
                            $return_array[$level_num]['hibryd_data'][$apparts_set[$level_name]['plan_id']] = [
                                'plan_id' => $apparts_set[$level_name]['plan_id'],
                                'has_tiers' => $apparts_set[$level_name]['has_tiers'],
                                'quantity' => $apparts_set[$level_name]['quantity'],
                                'prop_type' => $apparts_type,
                            ];
                        }
                    }elseif (isset($apparts_set[$level_name])) {
                        $return_array[$level_num] = $apparts_set[$level_name];
                        $return_array[$level_num]['hibryd_data'] = [];
                        $return_array[$level_num]['hibryd_data'][$apparts_set[$level_name]['plan_id']] = [
                            'plan_id' => $apparts_set[$level_name]['plan_id'],
                            'has_tiers' => $apparts_set[$level_name]['has_tiers'],
                            'quantity' => $apparts_set[$level_name]['quantity'],
                            'prop_type' => $apparts_type,
                        ];
                    }
                }
            }
            $cols_count_divider = round(12 / count($return_array));
            foreach ($return_array as &$return_array_set) {
                $is_current = $current_plan_id == $return_array_set['plan_id'] ? true : false;
                $return_array_set['cols_count_divider'] = $cols_count_divider;
                $return_array_set['hibryd_data'] = base64_encode(json_encode($return_array_set['hibryd_data']));
                $return_array_set['hide_for_active_class'] = $is_current ? 'd0' : '';
                $return_array_set['show_for_active_norusector_class'] = ($is_current && !$is_country_in_russector) ? '' : 'd0';
                $return_array_set['show_for_active_rusector_class'] = ($is_current && $is_country_in_russector) ? '' : 'd0';
                $return_array_set['style_for_active_class'] = $is_current ? 'pricing-active pricing-indigo' : '';
                $return_array_set['monthly_price'] = number_format($return_array_set['monthly_price_int'], 2, '.', '');
            }
            unset($return_array_set);
        }
        if ($type_id == 2){//hotels
            $rooms_or_aparts_count = $type_id_arr['price_count'];
            $query_res = $this->db
            ->select('plan_id, has_tiers, amount, currency, level')
            ->from("`global_hotelix`.$table_stripe_plans")
            ->where("`region_id` = $region_id AND `type_id` = $type_id AND mcount = $month_count AND is_active = 1")
            ->where_in('level', array_keys($level_sort_keys))
            ->get()->result();
            
            if ($query_res) {
                $cols_count_divider = round(12 / count($query_res));
                foreach ($query_res as $row) {
                    $plan_amount = $row->amount;
                    if ($row->has_tiers) {
                        $tiers_sql = "SELECT flat_amount
                        FROM $plans_tiers_tbl
                        WHERE plan_id = '$row->plan_id' AND up_to >= $rooms_or_aparts_count
                        ORDER BY up_to ASC";
                        $tiers_query_row = $this->db->query($tiers_sql)->row();
                        if ($tiers_query_row && isset($tiers_query_row->flat_amount)) {
                            $plan_amount = $tiers_query_row->flat_amount;
                        }
                    }
                    $is_current = $current_plan_id == $row->plan_id ? 1 : 0;
                    if (isset($level_sort_keys[$row->level])) {
                        $return_array[$level_sort_keys[$row->level]] = [
                            'plan_id' => $row->plan_id,
                            'has_tiers' => $row->has_tiers,
                            'level' => $row->level,
                            'clt_plan_level_name' => strtoupper($row->level),
                            'price_int' => (int)$plan_amount,
                            'price_float' => '00',
                            'monthly_price' => number_format((int)$plan_amount / $month_count, 2, '.', ''),
                            'currency' => strtoupper($row->currency),
                            'hide_for_active_class' => $is_current ? 'd0' : '',
                            'show_for_active_norusector_class' => ($is_current && !$is_country_in_russector) ? '' : 'd0',
                            'show_for_active_rusector_class' => ($is_current && $is_country_in_russector) ? '' : 'd0',
                            'style_for_active_class' => $is_current ? 'pricing-active pricing-indigo' : '',
                            'cols_count_divider' => $cols_count_divider,
                        ];
                    }
                }
            }
        }
        
        if ($type_id == 1){//aparts
            $rooms_or_aparts_count = $type_id_arr['price_count'];
            $res_tier_arr = $this->db
            ->select("$table_stripe_plans.plan_id, $table_stripe_plans.currency, $table_stripe_plans.level, $table_stripe_plans.has_tiers, stripe_plans_tiers.*")
            ->from("`global_hotelix`.$table_stripe_plans")
            ->join('global_hotelix.stripe_plans_tiers', "stripe_plans_tiers.plan_id = $table_stripe_plans.plan_id")
            ->where("`region_id` = $region_id AND `type_id` = $type_id AND mcount = $month_count AND is_active = 1")
            ->where_in('level', array_keys($level_sort_keys))
            ->get()->result_array();
            
            if ($res_tier_arr) {
                $grouped_tiers_arr = [];
                foreach ($res_tier_arr as $tiers_arr) {
                    if (!isset($grouped_tiers_arr[$level_sort_keys[$tiers_arr['level']]])) {
                        $grouped_tiers_arr[$level_sort_keys[$tiers_arr['level']]] = [];
                    }
                    array_push($grouped_tiers_arr[$level_sort_keys[$tiers_arr['level']]], $tiers_arr);
                }
                $cols_count_divider = round(12 / count($grouped_tiers_arr));
                foreach ($grouped_tiers_arr as $key => $grouped_arr) {
                    $tiers_price = $this->stripe_billing_m2->tiers_price($grouped_arr, $rooms_or_aparts_count);
                    $is_current = $current_plan_id == $grouped_arr[0]['plan_id'] ? 1 : 0;
                    $return_array[$key] = [
                        'plan_id' => $grouped_arr[0]['plan_id'],
                        'has_tiers' => 1,
                        'level' => $grouped_arr[0]['level'],
                        'clt_plan_level_name' => strtoupper($grouped_arr[0]['level']),
                        'price_int' => (int) $tiers_price,
                        'price_float' => '00',
                        'monthly_price' => number_format($tiers_price / $month_count, 2, '.', ''),
                        'currency' => strtoupper($grouped_arr[0]['currency']),
                        'hide_for_active_class' => $is_current ? 'd0' : '',
                        'show_for_active_norusector_class' => ($is_current && !$is_country_in_russector) ? '' : 'd0',
                        'show_for_active_rusector_class' => ($is_current && $is_country_in_russector) ? '' : 'd0',
                        'style_for_active_class' => $is_current ? 'pricing-active pricing-indigo' : '',
                        'cols_count_divider' => $cols_count_divider,
                    ];
                }
            }else{//NO TIRES? ANOMAL
            }
        }
        
        ksort($return_array);
        
        //================= врахування скидки (купона) при існуючому кастомері START ==========================
        $discount = "";
        if ($stripe_billing_customer_id != ""){//є кастомер
            $customer_id = $stripe_billing_customer_id;
            $secret_key = $this->stripe_billing_m2->get_secret_key();
            $this->stripe->setApiKey ( $secret_key );
            $customer_obj = $this->customer->retrieve ($customer_id);
            $customer = $customer_obj->__toArray(true);
            if (!is_null($customer['discount'])){
                $coupon_arr = $customer['discount']['coupon'];
                if (isset($coupon_arr['id']) && $coupon_arr['id'] != ""){
                    if ($coupon_arr['amount_off'] != ""){//скидка фіксованва
                        $discount = $this->frontdesk->showcurrency(((int)$coupon_arr['amount_off'])/100);
                        $discount_in_percents = false;
                    }else{//скидка відсоткова
                        $discount = (int)$coupon_arr['percent_off'];
                        $discount_in_percents = true;
                    }
                }
            }
        }
        if ($discount != ""){//була встановлена знижка, отже був кастомер, оновлюєм масив цін
            foreach ($return_array as &$plan) {
                //наразі виводимо ціну зі знижкою, її і міняємо, в майбутніх планах виводити 3: ціну, ціну зі знижкою, знижку
                if($discount_in_percents){
                    $plan['price_int'] = (int)$plan['price_int']*(1 - $discount / 100);
                    $plan['monthly_price'] = number_format($plan['monthly_price']*(1 - $discount / 100), 2, '.', '');
                }else{
                    //вияснити і доробити коли знижка не відсоткова!!!!!!!!!!!!!!!
                }
                unset($plan);
            }
        }
        //================= врахування скидки (купона) при існуючому кастомері FINAL ==========================
        return $return_array;
    }
    
    function get_property_type_id_arr_for_plans() {
        $res_arr = array();
        
        $res_arr['type_id'] = $this->hotelix_config->get_record("hms_property_type4stripe", "int");
        $res_arr['price_count'] = $this->hotelix_config->get_record("hms_property_count4stripe", "int");
        
        if ($res_arr['type_id'] == 0) {
            $res_arr['type_id'] = 2;
        }
        
        if ($res_arr['type_id'] == 2) {
            //$res_arr['price_count'] = 1;
        }
        
        if ($res_arr['price_count'] == 0) {
            $res_arr['price_count'] = 1;
        }
        
        if ($this->releases->stripe_hybrid_props_types()) {
            $qtts = $this->get_hybrid_props_types_quantities();
            $apparts_type = 1;
            $hotels_type = 2;
            
            $res_arr['type_id'] = 3;
            $res_arr['quantities'] = [
                $apparts_type => [
                    'apparts_count' => isset($qtts->single_dwelling_count) ? $qtts->single_dwelling_count : 0,
                    'apparts_rooms_count' => isset($qtts->single_dwelling_rooms_count) ? $qtts->single_dwelling_rooms_count : 0,
                ],
                $hotels_type => [
                    'hotels_count' => isset($qtts->multi_dwelling_count) ? $qtts->multi_dwelling_count : 0,
                    'hotels_rooms_count' => isset($qtts->multi_dwelling_rooms_count) ? $qtts->multi_dwelling_rooms_count : 0,
                ]
            ];
        }
        
        return $res_arr;
    }
    
    public function get_hybrid_props_types_quantities() {
        $hybrid_quantities_names = $this->get_hybrid_quantities_names();
        $hybrid_properties_quantities = [];
        foreach ($hybrid_quantities_names as $quantity_name) {
            $hybrid_properties_quantities[$quantity_name] = $this->hotelix_config->get_record ($quantity_name, 'int');
        }
        return (object)$hybrid_properties_quantities;
    }
    
    public function get_hybrid_quantities_names() {
        return [
            'single_dwelling_count',
            'single_dwelling_rooms_count',
            'multi_dwelling_count',
            'multi_dwelling_rooms_count'
        ];
    }
    

    
    function get_stripe_region_id() {
        $region_id = 4;
        $region_id = $this->hotelix_config->get_record("stripe_region_id", "int");
        if ($region_id == 0) $region_id = 4;
        return $region_id;
    }
    
    function tiers_price($arr, $top){
        $unit_amount_array=array();
        $flat_amount_array= array();
        $sum=0;
        $start = 1;
        foreach ($arr as $k=>$v){
            for ($x=$start;$x <= $v['up_to'];$x++){
                $unit_amount_array[$x]=$v["unit_amount"];
            }
            $start = $v['up_to'] + 1;
            $flat_amount_array[$v['up_to']] = $v["flat_amount"];
        }
        for ($x=1;$x<=$top;$x++){
            $sum+=$unit_amount_array[$x];
            if(isset($flat_amount_array[$x])){
                $sum+=$flat_amount_array[$x];
            }
        }
        return $sum;
    }
    
    function add_pay_method($stripe_token) {
        $stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
        $secret_key = $this->stripe_billing_m2->get_secret_key();
        $this->stripe->setApiKey ( $secret_key );
        $customer_obj = $this->customer->retrieve($stripe_billing_customer_id);
        try {
            $new_source = $customer_obj->sources->create(array("source" => $stripe_token));
        } catch ( \Stripe\Error\Card $e ) {
            $this->session->set_userdata ( array('header_msg' => 110) );
            $body = $e->getJsonBody();
            $error = $body['error']['decline_code'];
            echo "<script>console.log( 'decline_code: ".$error."' );</script>";
        }
        if (isset($new_source['id'])){
            return $new_source['id'];
        }else{
            return null;
        }
    }
    
    function add_new_pay_method_to_customer($pm_id) {
        $customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
        $secret_key = $this->stripe_billing_m2->get_secret_key();
        $this->stripe->setApiKey ( $secret_key );
        try {
            $payment_method = $this->payment_method->retrieve($pm_id);
            $payment_method->attach(array('customer' => $customer_id));
        } catch ( \Stripe\Error\Card $e ) {
            $body = $e->getJsonBody();
            $this->session->set_userdata ( array('header_msg' => 110) );
            if (isset($body['error']['decline_code'])){
                $this->session->set_userdata(array("header_msg_text"=>"{".$body['error']['decline_code']."}"));
            }
            die ( "<meta http-equiv='refresh' content='0;url=/stripe_concept2/plans'>" );
        }
    }
    
    function get_opened_invoices () {
        $customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
        $secret_key = $this->stripe_billing_m2->get_secret_key();
        $this->stripe->setApiKey ( $secret_key );
        $limit = 100;
        $all_invoices = array();
        $current_list = $this->invoice->all ( array (
            "customer" => $customer_id,
            "limit" => $limit,
            // 				"created" => array (
                // 						"gte" => $start_date_timestamp,
                // 						"lte" => $end_date_timestamp
                // 				)
        ) );
        $current_list = $current_list->__toArray(true);
        $all_invoices = array_merge($all_invoices, $current_list['data']);
        while ($current_list['has_more']){
            $starting_after = $current_list['data'][$limit-1]['id'];
            $current_list = $this->invoice->all ( array (
                "customer" => $customer_id,
                "starting_after" => $starting_after,
                "limit" => $limit,
                // 					"created" => array (
                    // 							"gte" => $start_date_timestamp,
                    // 							"lte" => $end_date_timestamp
                    // 					)
            ) );
            $current_list = $current_list->__toArray(true);
            $all_invoices = array_merge($all_invoices, $current_list['data']);
        };
        $opened_invoices_arr = array();
        foreach ($all_invoices as $invoice) {
            if ($invoice ['status'] == 'open'){
                array_push ( $opened_invoices_arr, array (
                    'id' => $invoice ['id'],
                    'number' => $invoice ['number'],
                    'amount_total' => (int)$invoice ['total'] / 100 ,
                    'amount_paid' => (int)$invoice ['amount_paid'] / 100 ,
                    'amount_due' => ( int ) $invoice ['amount_due'] / 100 ,
                    'created' => date ( "Y-m-d H:i", $invoice ['created'] ),
                    'currency' => strtoupper ( $invoice ['currency'] ),
                    'description' => $invoice ['description'],
                    'status' => $invoice ['status'],
                    'payment_intent' => $invoice ['payment_intent']
                ) );
            }
        }
        return $opened_invoices_arr;
    }
    
    function pay_invoice($invoice_id) {
        $secret_key = $this->stripe_billing_m2->get_secret_key();
        $this->stripe->setApiKey($secret_key);
        try {
            $invoice = $this->invoice->retrieve($invoice_id);
            $invoice->pay();
        } catch ( \Stripe\Error\Card $e ) {
            $this->session->set_userdata ( array (
                'header_msg' => 110
            ) );
        }
        $this->hms_routing_m->check_states_set_routing();
    }
    
    function make_act_by_cron($data) {
        $tbl_acts = "stripe_acts";
        if ($data['debug'] == 'trunc_acts_tbl'){
            $this->db->empty_table($tbl_acts);
        }
        $res_arr = array();
        $customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
        $sub_id = $this->hotelix_config->get_record("stripe_subscription_id", "str");
        if (!empty($customer_id) && !empty($sub_id)){
            $secret_key = $this->stripe_billing_m2->get_secret_key();
            $this->stripe->setApiKey ( $secret_key );
            $limit = 100;
            $past_days = $data['past_days'];
            $start_date_timestamp = strtotime("-$past_days days");
            $all_invoices = array();
            $invoices = $this->invoice->all ( array (
                "customer" => $customer_id,
                "limit" => $limit,
                "created" => array (
                    "gte" => $start_date_timestamp
                ),
                "status" => "paid",
            ) );
            $invoices = $invoices->__toArray(true);
            if (!empty($invoices['data'])){
                $tbl_1 = "partners";
                $sql = "SELECT $tbl_1.name as legal_name, $tbl_1.addrLine1, $tbl_1.addrLine2, $tbl_1.city, $tbl_1.state, $tbl_1.postcode, $tbl_1.DOC_INN
                FROM $tbl_1
                ORDER BY isdefault DESC";
                $partner = $this->db->query($sql)->row();
                if(!empty($partner)){
                    $p_data = array (
                        'legal_name' => '-',
                        'DOC_INN' => '-',
                        'addrLine1' => '',
                        'addrLine2' => '',
                        'city' => '',
                        'state' => '',
                        'postcode' => ''
                    );
                    foreach ($partner as $fild => $val) {
                        if (!empty($val)){
                            $p_data[$fild] = $val;
                        }
                    }
                    foreach ($invoices['data'] as $invoice) {
                        $act_data = array();
                        $act_data['act_number'] = "A-".$invoice ['number'];
                        $act_exist = $this->db->get_where($tbl_acts, array('act_number' => $act_data['act_number']))->row();
                        if(empty($act_exist)){
                            foreach ($invoice['lines']['data'] as $invoice_line) {
                                if ($invoice_line['type'] == 'subscription'){
                                    $act_data['DOC_INN'] = $p_data['DOC_INN'];
                                    $act_data['period_start'] = date("Y-m-d", $invoice_line['period']['start']);
                                    $act_data['period_end'] = date("Y-m-d", $invoice_line['period']['end']);
                                    $act_data['legal_name'] = $p_data['legal_name'];
                                    $act_data['address'] = $p_data['addrLine1']."<br>".$p_data['addrLine2']."<br>".$p_data['city']."<br>".$p_data['state']."<br>".$p_data['postcode'];
                                    $act_data['act_date'] = date('Y-m-d', strtotime("last day of ".date('Y-m-d',$invoice_line['period']['end'])));//date("Y-m-d", $invoice['finalized_at']);
                                    $act_data['amount'] = number_format($invoice['total']/100, 2, '.',',');
                                    $insert_arr = array (
                                        'act_number' => $act_data ['act_number'],
                                        'data' => json_encode ( $act_data, true )
                                    );
                                    $this->db->insert($tbl_acts, $insert_arr);
                                    array_push($res_arr, $act_data ['act_number']);
                                    continue;
                                }
                            }
                        }
                    }
                }
            }
        }
        return $res_arr;
    }
    
    function is_clear_30d() {
        $start_date = date('Y-m-d');
        $end_date = date('Y-m-d', strtotime("$start_date + 30 days"));
        $sql = "SELECT reservation_id
        FROM deskofdays AS t1
        JOIN rooms AS t2 ON t1.room_id = t2.id
        WHERE t1.date BETWEEN '$start_date' AND '$end_date' AND t2.is_active = 1";
        $active_reservations = $this->db->query($sql)->result();
        $is_active_reservations = ($active_reservations) ? true : false;
        $in_release = $this->releases->is_mono_clear_30();
        return ($in_release && !$is_active_reservations) ? 1 : 0;
    }
    
    public function subscription_period_edges_uptodating (){
        $res = [
            'subscription' => [
                'id' => '',
                'plan_metadata' => [],
                'current_period_start' => '',
                'current_period_end' => ''
            ]
        ];
        $res = json_decode(json_encode($res));
        \Stripe\Stripe::setApiKey($this->stripe_billing_m2->get_secret_key());
        $stripe_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
        
        try {
            $customer_obj = \Stripe\Customer::retrieve($stripe_customer_id);
        } catch ( \Stripe\Error\InvalidRequest $e ) {
            $body = $e->getJsonBody();
            $error_text = 'No stripe customer! Error #627';
            //$error_text .= isset($body['error']) && isset($body['error']['message']) ? '<br>'.$body['error']['message'] : '';
            $this->session->set_userdata ( array('error_page_message' => $error_text) );
            die ( "<meta http-equiv='refresh' content='0;url=/errors_c2/view_error/0/'>" );
        }
        
        if (isset($customer_obj->subscriptions->data[0]->id)){
            $res->subscription->id = $customer_obj->subscriptions->data[0]->id;
            $res->subscription->plan_metadata = $customer_obj->subscriptions->data[0]->plan->metadata->__toArray();
            $current_period_start= isset($customer_obj->subscriptions->data[0]->current_period_start) ? $customer_obj->subscriptions->data[0]->current_period_start: false;
            $current_period_end = isset($customer_obj->subscriptions->data[0]->current_period_end) ? $customer_obj->subscriptions->data[0]->current_period_end: false;
            if ($current_period_start && $current_period_end){
                $this->hotelix_config->set_record("stripe_sub_current_period_start", $current_period_start, 'int');
                $this->hotelix_config->set_record("stripe_sub_current_period_end", $current_period_end, 'int');
                $res->subscription->current_period_start = $current_period_start;
                $res->subscription->current_period_end = $current_period_end;
            }
        }
        return $res;
    }
    
    public function get_stripe_info() {
        $pay_day_missing = 0;
        $is_subscription = 0;
        $balance = 0;
        $customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id");
        if ($customer_id && $customer_id != '') {
            $secret_key = $this->stripe_billing_m2->get_secret_key();
            $this->stripe->setApiKey($secret_key);
            $customer_obj = $this->customer->retrieve($customer_id);
            $customer = $customer_obj->__toArray(true);
            $balance = $customer['balance'];
            if (isset($customer['subscriptions']['data'][0]['id'])) {
                $is_subscription = 1;
                
                $limit_expired_days = 30;
                $created_timestamp = strtotime("now - $limit_expired_days days");
                $expired_invoices = $this->invoice->all([
                    'customer' => $customer_id,
                    'status' => 'open',
                    "created" => [
                        "lte" => $created_timestamp
                    ],
                    "limit" => 1,
                ])->__toArray(true);
                
                if (isset($expired_invoices['data'][0]['id'])) {
                    $expired_invoice = $expired_invoices['data'][0];
                    $invoce_created_date = $expired_invoice['created'];
                    $pay_day_missing = floor((strtotime("now") - $invoce_created_date) / (24 * 60 * 60));
                }
            }
        }
        
        $result = [
            'pay_day_missing' => $pay_day_missing,     //кількість днів неоплаченого інвойсу
            'is_subscription' => $is_subscription,     //0/1 чи є підписка
            'balance' => $balance,                     //баланс
        ];
        return $result;
    }
    
    public function init_stripe (){
        $stripe = new \Stripe\Stripe();
        $stripe->setApiKey($this->stripe_billing_m2->get_secret_key());
        return $stripe;
        /*
         * Array
         (
         [0] => getApiKey
         [1] => getClientId
         [2] => getLogger
         [3] => setLogger
         [4] => setApiKey
         [5] => setClientId
         [6] => getApiVersion
         [7] => setApiVersion
         [8] => getCABundlePath
         [9] => setCABundlePath
         [10] => getVerifySslCerts
         [11] => setVerifySslCerts
         [12] => getAccountId
         [13] => setAccountId
         [14] => getAppInfo
         [15] => setAppInfo
         [16] => getMaxNetworkRetries
         [17] => setMaxNetworkRetries
         [18] => getMaxNetworkRetryDelay
         [19] => getInitialNetworkRetryDelay
         [20] => getEnableTelemetry
         [21] => setEnableTelemetry
         )
         *  */
    }
    
    public function get_stripe_customer_info_obj (){
        $stripe_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
        $stripe = $this->init_stripe();
        $customer = new \Stripe\Customer();
        return $customer->retrieve($stripe_customer_id);
        
        /* methods
         * Array
         (
         [0] => getSavedNestedResources
         [1] => addInvoiceItem
         [2] => invoices
         [3] => invoiceItems
         [4] => charges
         [5] => updateSubscription
         [6] => cancelSubscription
         [7] => deleteDiscount
         [8] => createSource
         [9] => retrieveSource
         [10] => updateSource
         [11] => deleteSource
         [12] => allSources
         [13] => createTaxId
         [14] => retrieveTaxId
         [15] => deleteTaxId
         [16] => allTaxIds
         [17] => createBalanceTransaction
         [18] => retrieveBalanceTransaction
         [19] => updateBalanceTransaction
         [20] => allBalanceTransactions
         [21] => __set
         [22] => refresh
         [23] => baseUrl
         [24] => classUrl
         [25] => resourceUrl
         [26] => instanceUrl
         [27] => getPermanentAttributes
         [28] => getAdditiveParams
         [29] => __construct
         [30] => __isset
         [31] => __unset
         [32] => __get
         [33] => __debugInfo
         [34] => offsetSet
         [35] => offsetExists
         [36] => offsetUnset
         [37] => offsetGet
         [38] => count
         [39] => keys
         [40] => values
         [41] => constructFrom
         [42] => refreshFrom
         [43] => updateAttributes
         [44] => serializeParameters
         [45] => serializeParamsValue
         [46] => jsonSerialize
         [47] => __toJSON
         [48] => __toString
         [49] => __toArray
         [50] => dirty
         [51] => emptyValues
         [52] => getLastResponse
         [53] => setLastResponse
         [54] => isDeleted
         [55] => all
         [56] => create
         [57] => delete
         [58] => retrieve
         [59] => update
         [60] => save
         )
         
         keys
         Array
         (
         [0] => id
         [1] => object
         [2] => account_balance
         [3] => address
         [4] => balance
         [5] => created
         [6] => currency
         [7] => default_currency
         [8] => default_source
         [9] => delinquent
         [10] => description
         [11] => discount
         [12] => email
         [13] => invoice_prefix
         [14] => invoice_settings
         [15] => livemode
         [16] => metadata
         [17] => name
         [18] => next_invoice_sequence
         [19] => phone
         [20] => preferred_locales
         [21] => shipping
         [22] => sources
         [23] => subscriptions
         [24] => tax_exempt
         [25] => tax_ids
         [26] => tax_info
         [27] => tax_info_verification
         [28] => test_clock
         )
         *  */
    }
}
