<?php
class Rro_model extends CI_Model {//default Checkbox
    const PROVIDER_ID = RROCHECKBOX_ID;
    public $log_tbl = 'rro_log_checks_operation';
	public function __construct() {
		parent::__construct ();

		if ($this->releases->rro_activity()) {
		    $this->dev_endpoint = 'https://dev-api.checkbox.in.ua/api';
		    $this->prod_endpoint = 'https://api.checkbox.in.ua/api';
		    $this->ep = $this->get_endpoint();
		    $this->api_version = '/v1';
		    $this->license_key = $this->get_device_license_key();
		    $this->api_urls = (object)array(
		        'signin_cashier' => $this->ep . $this->api_version . '/cashier/signin',
		        'signout_cashier' => $this->ep . $this->api_version . '/cashier/signout',
		        'get_shifts' => $this->ep . $this->api_version . '/shifts',
		        'open_shift' => $this->ep . $this->api_version . '/shifts',
		        'close_shift' => $this->ep . $this->api_version . '/shifts/close',
		        'cashier_profile' => $this->ep . $this->api_version . '/cashier/me',
		        'register_check' => $this->ep . $this->api_version . '/receipts/sell',
		        'receipts' => $this->ep . $this->api_version . '/receipts',
		        'cash_registers' => $this->ep . $this->api_version . '/cash-registers?in_use=false'
		    );
		}
	}


	public function get_endpoint (){
	    $prod_or_dev = $this->hotelix_config->get_record('rro_prod_or_dev_endpoint', 'int');;
	    //$endpoint = $prod_or_dev ? $this->prod_endpoint : $this->dev_endpoint;
		$endpoint = $this->prod_endpoint;
	    return $endpoint;
	}

	public function get_cashier_auth_data (){
	    $tbl = 'rro_cashier2casa';
	    $user_id = $_SESSION ['user']["id"];

	    $cashier = array(
	        'login' => '',
	        'password' => ''
	    );
	    $cashier_set = $this->db->get_where($tbl, array('user_id' => $user_id))->row();
	    if ($cashier_set) {
	        $cashier = array(
	            'login' => $cashier_set->login,
	            'password' => $cashier_set->password
	        );
	    }


// 	    $cashier = array(
// 	        'login' => 'Test030419',
// 	        'password' => '123456'
// 	    );




	    return $cashier;
	}

	public function get_device_license_key (){
	    $tbl = 'rro_cashier2casa';
	    $user_id = $_SESSION ['user']["id"];

	    $key = '';
	    $casa_set = $this->db->get_where($tbl, array('user_id' => $user_id))->row();
	    if ($casa_set) {
	        $key = $casa_set->license_key;
	    }

// 	    $key = '6814e72c41f982b2a46241c1';
	    return $key;
	}

	public function isactive_rro_module (){
	    $rro_in_release = $this->releases->rro_activity();
	    $query_module_activity = $this->db->select('is_active')->get_where('modules', array('name'=>'rro'))->row();
	    $module_activity = isset($query_module_activity->is_active) ? $query_module_activity->is_active : false;
	    $isactive = ($module_activity && $rro_in_release) ? true : false;
		return $isactive;
	}

	public function get_cashier_profile()
	{
	    $params = array(
	        'headers' => array(
	            'Authorization: Bearer ' . $this->session->userdata('rro_token')
	        ),
	        'api_url' => $this->api_urls->cashier_profile
	    );
	    $response = $this->api_get($params);

	    return $response;
	}

	public function signin () {
        $params = array(
            'headers' => array(),
            'post_data' => $this->get_cashier_auth_data(),
            'api_url' => $this->api_urls->signin_cashier
        );

        $response = $this->api_post($params);
	    
	    if (is_array($response)) {
    	    if (isset($response['access_token'])){
    	        $this->session->set_userdata(array(
    	            'rro_token' => $response['access_token']
    	        ));
    	    }
    	    if (isset($response['message'])){
    	        $header_msg_text = $response['message'];
    	        if (isset($response['detail'][0]['msg'])) {
    	            $header_msg_text .= '<br>'.$response['detail'][0]['msg'];
    	        }
    	        $this->session->set_userdata ( array('header_msg_text'=>$header_msg_text));
    	    }
	    }

        return $response;
	}

	public function signout () {
        $params = array(
            'headers' => array(
                'Authorization: Bearer ' . $this->session->userdata('rro_token')
            ),
            'post_data' => array(),
            'api_url' => $this->api_urls->signout_cashier
        );
	    $response = $this->api_post($params);
	    $this->session->set_userdata(array(
	        'rro_token' => ''
	    ));
	    return $response;
	}

	public function get_shifts()
	{
	    $params = array(
	        'headers' => array(
	            'Authorization: Bearer ' . $this->session->userdata('rro_token'),
	            //'X-License-Key: '. $this->license_key,
	        ),
	        'post_data' => array(),
	        'api_url' => $this->api_urls->get_shifts
	    );
	    $response = $this->api_get($params);
	    return $response;
	}

	public function open_shift()
	{
	    $params = array(
	        'headers' => array(
	            'Authorization: Bearer ' . $this->session->userdata('rro_token'),
	            'X-License-Key: '. $this->license_key,
	        ),
	        'post_data' => array(),
	        'api_url' => $this->api_urls->open_shift
	    );
	    $response = $this->api_post($params);
	    return $response;
	}

	public function close_shift()
	{
	    $params = array(
	        'headers' => array(
	            'Authorization: Bearer ' . $this->session->userdata('rro_token'),
	        ),
	        'post_data' => array(),
	        'api_url' => $this->api_urls->close_shift
	    );
	    $response = $this->api_post($params);
	    return $response;
	}

	public function api_post($param) {
	    $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $param['api_url']);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $param['headers']);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($param['post_data']));
        $response = curl_exec($ch);
        $curl_info = curl_getinfo($ch);
        curl_close($ch);

        $response = $curl_info['content_type'] != 'application/json' ? $response : json_decode($response, true);
        return $response;
	}

	public function api_get($param) {
	    $ch = curl_init();
	    curl_setopt($ch, CURLOPT_URL, $param['api_url']);
	    curl_setopt($ch, CURLOPT_HTTPHEADER, $param['headers']);
	    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
	    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	    $response = curl_exec($ch);

	    $curl_info = curl_getinfo($ch);

	    curl_close($ch);
	    $response = $curl_info['content_type'] != 'application/json' ? $response : json_decode($response);

	    return $response;
	}

	public function make_check_strings($payment_data) {

	    $reservation_id = $payment_data['reservation_id'];
	    $is_return = isset($payment_data['pay_or_ref']) && $payment_data['pay_or_ref'] == 1 ? true : false;

	    $goods = $payments = $delivery = $errors = array();

        $delivery = array(
            'emails' => array($this->get_ClientEmailAddress($reservation_id))
        );

        $pay_id = $payment_data['pay_id'];

        if ($is_return) {//refund
	        $tbl = 'rro_checks';
	        $check_strings_query = $this->db->get_where($tbl, array('pay_or_ref_id'=>$pay_id, 'pay_or_ref' => 0))->row();
	        if ($check_strings_query && isset($check_strings_query->CheckAllData)){
	            if (!isset($check_strings_query->fiscal_provider_id) || $check_strings_query->fiscal_provider_id == self::PROVIDER_ID) {
    	            $strict_check_strings = json_decode($check_strings_query->CheckAllData, true);
    	            $goods = $strict_check_strings['goods'];
    	            $payments = $strict_check_strings['payments'];
    	            foreach ($goods as &$good) {
    	                $good['is_return'] = true;
    	            }
    	            unset($good);
	            }else {
	                array_push($errors, 'Чек продажу фіскалізовано іншою ПРРО! Відміна не можлива.');
	            }
	        }else {
	            array_push($errors, '500 : Error HMS : refund strings retrive error!');
	        }
        }else{//payment
            $items = array();
            $where_str = " check_payment_id = $pay_id";
            $query_result = $this->db->query(
                "SELECT item_id as service_id, SUM(check_payment_items.amount) as service_amount, item_service_table_id as tbl_id,
                services_types.name as name_s, services_types.kind_id, services.count, services_types.tax as service_tax,
                services_types_main.name as name_sm, services_types_main.id as sm_type_id, services_types_main.tax as service_main_tax,
                taxes_fees2property.name as name_tf, services_tf.taxes_fees_id
                FROM check_payment_items
                LEFT JOIN services_main ON services_main.id = check_payment_items.item_id
                LEFT JOIN services_types_main ON  services_types_main.id = services_main.type
                LEFT JOIN services ON services.id = check_payment_items.item_id
                LEFT JOIN services_types ON  services_types.id = services.type
                LEFT JOIN services_tf ON services_tf.id = check_payment_items.item_id
                LEFT JOIN taxes_fees2property ON taxes_fees2property.id = services_tf.taxes_fees_id
                WHERE $where_str
                GROUP BY service_id")->result();


            foreach ($query_result as $row){
                switch ($row->tbl_id) {
                    case 1: // services
                        array_push($items, array(
                        'services_id' => $row->service_id,
                        'count' => $row->count,
                        'amount' => $row->service_amount,
                        'name' => $row->name_s,
                        'tax' => $row->service_tax,
                        ));
                        break;
                    case 2://main services
                        array_push($items, array(
                        'services_id' => $row->service_id,
                        'count' => 1,
                        'amount' => $row->service_amount,
                        'name' => $row->sm_type_id == 1 ? $this->make_main_service1_name(array('reservation_id' => $reservation_id)) : $row->name_sm,
                        'tax' => $row->service_main_tax,
                        ));
                        break;
                    case 3: // services tax & fees
                        array_push($items, array(
                        'services_id' => $row->service_id,
                        'count' => 1,
                        'amount' => $row->service_amount,
                        'name' => $row->name_tf,
                        'tax' => null,
                        ));
                        break;
                }
            }

            $all_paied_sum = 0;
            foreach ($items as $item){
                array_push($goods, array(
                    'good' => array(
                        'code'		=> $item ["services_id"],
                        'name'		=> $item ["name"],
                        'price'		=> (int)number_format($item ["amount"] / $item ["count"], 2, ".", "") * 100,
                        'tax'		=> $this->make_goods_taxgrp(array('tax_val' => $item ['tax'])),
                    //Доступні податкові ставки: [1, 'А', 2, 'Б', 3, 'В', 4, 'Г', 5, 'Д', 6, 'Я', 7, 'З', 8, 'Ж', 9, 'B', 12, 14, 'О', 15, 'П', 16, 'ф', 18, 'С']
                    ),
                    'quantity'	=> $item ["count"]* 1000,
                    'is_return'	=> $is_return,
                ));
                $all_paied_sum += $item ["amount"];
            }
            if(!$all_paied_sum){
                array_push($errors, 'Помилка. Cума оплати більша вартості всіх товарів та послуг.');
            }
            $payments = array(
                array(
                    'type' => $this->get_payment_type_form_txt_constant($pay_id),
                    'value' => $all_paied_sum * 100,
                    'label' => $this->get_payment_type_form_label($pay_id),
                )
            );
        }

        if(empty($errors)){
            $data = array(
                'goods' 	=> $goods,
                'delivery'	=> $delivery,
                'payments'	=> $payments,
                'discounts'	=> array(),
            );
        }else {
            $data = array(
                'errors' 	=> $errors,
            );
        }
	    return $data;
	}

	public function make_main_service1_name($in_data) {
	    $result =  'Проживання';
	    $res_id = $in_data['reservation_id'];
	    $sql = "SELECT CONCAT('Номер: ', categories.name, ', проживання: ', t1.datein, ' - ', t1.dateout) AS name
        	    FROM `deskofreservation` AS t1
        	    JOIN rooms ON rooms.id = t1.room_id
        	    JOIN categories ON categories.id = rooms.category_id
        	    WHERE t1.id = $res_id";
	    $query_res = $this->db->query($sql)->row();
	    if ($query_res && isset($query_res->name)){
	        $result = $query_res->name;
	    }
        return $result;
	}

	private function make_goods_taxgrp($p = array('tax_val'=>null)) {
	    //Доступні податкові ставки: [1, 'А', 2, 'Б', 3, 'В', 4, 'Г', 5, 'Д', 6, 'Я', 7, 'З', 8, 'Ж', 9, 'B', 12, 14, 'О', 15, 'П', 16, 'ф', 18, 'С']
	    $taxgrps = array();
	    if ($p['tax_val'] && $p['tax_val'] > 0) {
	        $taxgrps = array('A');
	    }
	    return $taxgrps;
	}

	public function register_check($data) {
	    $params = array(
	        'headers' => array(
	            'Authorization: Bearer ' . $this->session->userdata('rro_token'),
	        ),
	        'post_data' => $data['check_strings'],
	        'api_url' => $this->api_urls->register_check
	    );
	    $response = $this->api_post($params);
	    if (isset($data['debug']) && $data['debug']) {
	        echo '<pre>';
	        print_r($response);
	    }
	    return $response;
	}

	public function log_check_operation($log_data) {
	    $log_tbl = $this->log_tbl;
	    $where_arr = array(
	        'pay_or_ref_id' => $log_data['pay_or_ref_id'],
	        'pay_or_ref' => $log_data['pay_or_ref']
	    );
        $id_log_tbl = $this->db->select('id')
            ->get_where($log_tbl, $where_arr)
            ->row();
        if ($id_log_tbl) {
            $this->db->update($log_tbl, $log_data, array('id'=>$id_log_tbl->id));
        }else {
            $this->db->insert($log_tbl, $log_data);
        }
	}

	public function save_check_data($check_data) {
	    $tbl = 'rro_checks';
	    $this->db->insert($tbl, $check_data);
	}

	public function get_receipt($param) {
        $receipt_id = $param['receipt_id'];
        $receipt_format = $param['format'];
	    $params = array(
	        'headers' => array(
	            'Authorization: Bearer ' . $this->session->userdata('rro_token')
	        ),
	        'api_url' => $this->api_urls->receipts."/$receipt_id/$receipt_format"
	    );
	    $response = $this->api_get($params);
	    return $response;
	}

	public function check_processing($data) {
// 	    $data = array(
// 	        'reservation_id' => $post['reservation_id'],
// 	        'id_partner' => $post['id_partner'],
// 	        'pay_id' => $pay_id,
//          'pay_or_ref' ?
//          'ref_id' ?
// 	    );
	    $pay_or_ref = isset($data['pay_or_ref']) ? $data['pay_or_ref'] : 0;
	    $pay_or_ref_id = $pay_or_ref ? $data['ref_id'] : $data['pay_id'];
	    $check_already_exist_query = $this->db->select('id')->get_where('rro_checks', array('pay_or_ref_id'=>$pay_or_ref_id, 'pay_or_ref'=>$pay_or_ref))->row();
	    if ($check_already_exist_query) {
	        $header_msg_text = 'Чек уже був успішно зареестрований.';
	        $result_check_processing = true;
	    }else{
	        $check_strings = $this->rro_model->make_check_strings ( $data );
	        if(isset($check_strings['errors'])){
	            $result_check_processing = false;
	            $header_msg_text = '';
	            foreach ($check_strings['errors'] as $error) {
	                $header_msg_text .= "$error <br>";
	            }
	        }else {
	            $api_response = $this->rro_model->register_check ( array('check_strings' => $check_strings));
	            $this->rro_model->log_check_operation(array(
	                'pay_or_ref_id' => $pay_or_ref_id,
	                'pay_or_ref' => $pay_or_ref,
	                'strings' => json_encode($check_strings),
	                'response' => json_encode($api_response)
	            ));
	            $result_check_processing = false;
	            if (isset($api_response['message']) || !is_array($api_response)){
	                if (is_array($api_response)) {
	                    $header_msg_text = $api_response['message'];
	                    if (isset($api_response['detail'][0]['msg'])) {
	                        $header_msg_text .= '<br>'.$api_response['detail'][0]['msg'];
	                    }
	                }else {
	                    $header_msg_text = $api_response;
	                }
	            }else{//succesfull register check
	                $header_msg_text = 'Чек успішно зареестрований.';
	                $this->rro_model->save_check_data(array(
	                    'pay_or_ref_id' => $pay_or_ref_id,
	                    'pay_or_ref' => $pay_or_ref,
	                    'fiscal_provider_id' => self::PROVIDER_ID,
	                    'CheckAllData' => json_encode($api_response),
	                ));
	                $result_check_processing = true;
	            }
	        }
	    }
	    $this->session->set_userdata ( array('header_msg_text'=>$header_msg_text));
	    return $result_check_processing;
	}

	public function get_payment_type_form_txt_constant($pay_id){
	    $txt_constants = array(1=>'CASH', 2=>'CASHLESS');
	    $sql = "SELECT payment_form_id
                FROM payment
                JOIN payment_types ON payment_types.id = payment.type
                WHERE payment.id = $pay_id";
	    $row = $this->db->query($sql)->row();
	    return $txt_constants[$row->payment_form_id];
	}

	public function get_payment_type_form_label($pay_id){
	    $txt_label = ' ';
	    $sql = "SELECT payment_types.name
        	    FROM payment
        	    JOIN payment_types ON payment_types.id = payment.type
        	    WHERE payment.id = $pay_id";
	    $row = $this->db->query($sql)->row();
	    if ($row && isset($row->name)) {
	        $txt_label = $row->name;
	    }
	    return $txt_label;
	}

	public function get_cash_registers() {
	    $params = array(
	        'headers' => array(
	            'Authorization: Bearer ' . $this->session->userdata('rro_token')
	        ),
	        'api_url' => $this->api_urls->cash_registers
	    );
	    $response = $this->api_get($params);
	    return $response;
	}

	public function get_ClientEmailAddress ($reservation_id){
	    $client_email = 'noemail@gmail.com';
	    if (isset($reservation_id)) {
	        $sql = "SELECT guests.email FROM deskofreservation
    				LEFT JOIN guests ON deskofreservation.guest_id = guests.id
    				WHERE deskofreservation.id = $reservation_id";
	        $query = $this->db->query($sql)->row();
	        if ($query && isset($query->email) && $query->email != '') {
	            $client_email = $query->email;
	        }
	    }
	    return $client_email;
	}

	public function fiscalize_Payment($pay_id) {
	    $payment_data = $this->db->select('id_partner, reservation_id')->get_where('payment', array('id'=>$pay_id))->row();
	    if ($payment_data) {
	        $data = array(
	            'reservation_id' => $payment_data->reservation_id,
	            'id_partner' => $payment_data->id_partner,
	            'pay_id' => $pay_id
	        );
	        $this->rro_model->check_processing($data);
	    }
	}

	public function fiscalize_Refund($ref_id) {
	    $payment_data = $this->db->select('id as pay_id, id_partner, reservation_id')->get_where('payment', array('refund_id'=>$ref_id))->row();
	    if ($payment_data) {
	        $data = array(
	            'reservation_id' => $payment_data->reservation_id,
	            'id_partner' => $payment_data->id_partner,
	            'pay_id' => $payment_data->pay_id,
	            'ref_id' => $ref_id,
	            'pay_or_ref' => 1,
	        );
	        $this->rro_model->check_processing($data);
	    }
	}

	public function print_receipt($p) {
	    $check_id = $p['check_id'];
	    $receipt_format = $p['receipt_format'];// 'html'; 'pdf';
	    $tbl = 'rro_checks';
	    $check_data = $this->db->get_where($tbl, array('id'=>$check_id))->row();
	    if ($check_data){
	        if ($check_data->fiscal_provider_id == self::PROVIDER_ID) {
	            $CheckAllData = json_decode($check_data->CheckAllData);
	            $check = $this->get_receipt(array(
	                'receipt_id' => $CheckAllData->id,
	                'format' => $receipt_format
	            ));
	            switch ($receipt_format) {
	                case 'html':
	                    echo $check;
	                    break;
	                case 'pdf':
	                    $this->output->set_content_type($receipt_format)->set_output($check);
	                    break;
	            }
	        }else {
	            echo 'Чек фіскалізований іншим ППРО.';
	        }
	    }
	}
	
	public function get_logs($p = array('limit' => 50, 'date' => null)) {
	    $limit = isset($p['limit']) ? $p['limit'] : 50;
	    $date = isset($p['date']) && $p['date'] ? $p['date'] : date('Y-m-d', strtotime('-1 month'));
 	    $log_tbl = $this->log_tbl;
	    $logs = $this->db->order_by('id DESC')->limit($limit)->get_where($log_tbl, array('time >=' => $date))->result();
	    return $logs;
	}
}