<?php
class Rro_mdl extends CI_Model {
	public function __construct() {
		parent::__construct ();
	}

	public function get_fiscalable_partners() {
	    $partners_data = array();
	    $whr_arr = array(
	        'is_active' => 1,
	        'is_fiscalable' => 1,
	        'country' => 'UKR',
	    );
	    $partners_query = $this->db->order_by('name')->select('id, name')->get_where('partners', $whr_arr)->result();
	    foreach ( $partners_query as $row ) {
            $partners_data[$row->id] = array(
                "id" => $row->id,
                "name" => $row->name,
                "selected" => ""
            );
	    }
	    return $partners_data;
	}

	public function get_active_users() {
	    $users_data = array();
	    $whr_arr = array(
	        'is_active' => 1,
	    );
	    $users_query = $this->db->order_by('fullname')->select('id, fullname, lastname')->get_where('users', $whr_arr)->result();
	    foreach ( $users_query as $row ) {
	        $user_name = "$row->fullname $row->lastname";
	        if (trim($user_name) != '') {
	            $users_data[$row->id] = array(
	                "id" => $row->id,
	                "name" => "$row->fullname $row->lastname",
	                "selected" => ""
	            );
	        }
	    }
	    return $users_data;
	}

	public function get_vchasno_settings_by_partner_id($partner_id) {
	    $users_data = $this->db->select('t3.user_id, t2.token_vchasno as token')
	    ->from('rro_providers as t1')
	    ->where('t1.id = 2')
	    ->join('rro_partner2provider as t2', "t1.id = t2.provider_id AND t2.partner_id = $partner_id")
	    ->join('rro_allowedusers4ptnr2prov_set as t3', 't3.ptnr2prov_set_id = t2.id', 'left')
	    ->get()
	    ->result();
	    return $users_data;
	}

	public function get_vchasno_set_data() {
	    $users_data = $this->db->select('t3.user_id, t2.partner_id, t2.token_vchasno as token')
	    ->from('rro_providers as t1')
	    ->where('t1.id = 2')
	    ->join('rro_partner2provider as t2', "t1.id = t2.provider_id")
	    ->join('rro_allowedusers4ptnr2prov_set as t3', 't3.ptnr2prov_set_id = t2.id', 'left')
	    ->get()->result();
	    return $users_data;
	}

	public function save_settings_vchasno($p) {
	    if (isset($p['partner_selected']) && $p['partner_selected'] !='') {
	        $provider_id = 2;//vchasno
	        $partner_selected = $p['partner_selected'];
	        $token = isset($p['token']) ? $p['token'] : '';
	        $whr_arr = array(
	            'provider_id' => $provider_id,
// 	            'partner_id' => $partner_selected
	        );
            $upd_arr = array(
                'token_vchasno' => $token,
                'partner_id' => $partner_selected
            );
	        $tbl_pa2pr_sets = 'rro_partner2provider';
	        $pa2pr_set_id = $this->db->select('id')->get_where($tbl_pa2pr_sets, $whr_arr)->row();
            if (!$pa2pr_set_id) {
                $ins_arr = $whr_arr + $upd_arr;
                $this->db->insert($tbl_pa2pr_sets, $ins_arr);
                $pa2pr_set_id = $this->db->insert_id();
            }else {
                $pa2pr_set_id = $pa2pr_set_id->id;
                $this->db->update($tbl_pa2pr_sets, $upd_arr, array('id' => $pa2pr_set_id));
            }
            if (isset($p['users_selected'])) {
                $tbl_allowed_users = 'rro_allowedusers4ptnr2prov_set';
                $whr_arr = array('ptnr2prov_set_id'=>$pa2pr_set_id);
                $this->db->delete($tbl_allowed_users, $whr_arr);
                foreach ($p['users_selected'] as $user_id) {
                    $this->db->insert($tbl_allowed_users, array(
                        'user_id' => $user_id,
                        'ptnr2prov_set_id' => $pa2pr_set_id
                    ));
                }
            }
	    }
	}

	public function check_processing($p) {
	    $errors = array();
	    if (Rro::get_active_rro_provider() == 2) {
	        $partner_id = $p['id_partner'];
	        $user_id = $_SESSION['user']['id'];
	        $user_is_allowed = $partner_is_correct = false;
	        $vchasno_set_data = $this->get_vchasno_set_data();

	        foreach ($vchasno_set_data as $vchasno_set) {
	            if (!$user_is_allowed && $vchasno_set->user_id == $user_id) {
	                $user_is_allowed = true;
	            }
	            if (!$partner_is_correct && $vchasno_set->partner_id == $partner_id) {
	                $partner_is_correct = true;
	            }
	        }
	        if ($user_is_allowed && $partner_is_correct) {
	            $this->load->model('rro_vchasno_mdl');
	            $this->rro_vchasno_mdl->check_processing($p);
	        }else {
	            if (!$user_is_allowed) {
	                array_push($errors, "Користувач не має права друкувати фіскальні чеки Вчасно.Каса");
	            }
	            if (!$partner_is_correct) {
	                array_push($errors, "Юридична особа не налаштована для друку чеків Вчасно.Каса");
	            }
	        }
	    }else {
	        $this->load->model('rro_model');//rro_checkbox_mdl
	        $this->rro_model->check_processing($p);
	    }
	    if (count($errors)) {
	        $header_msg_text = 'Чек не фіскалізовано!';
	        foreach ($errors as $error) {
	            $header_msg_text .= "<br>$error";
	        }
	        $this->session->set_userdata ( array('header_msg_text'=>$header_msg_text));
	    }
	}
}