<?

class mreviews extends CI_Model
{

    function __construct()
    {
        parent::__construct();
    }

    function get_checkin_type()
    {
        $checkin_types = array();
        
        $checkin_types[0]["checkin_type_value"] = 0;
        $checkin_types[0]["checkin_type_name"] = "{clt_review_please_choose}";
        $checkin_types[0]["checkin_type_selected"] = "";
        $checkin_types[1]["checkin_type_value"] = 1;
        $checkin_types[1]["checkin_type_name"] = "{clt_review_online}";
        $checkin_types[1]["checkin_type_selected"] = "";
        $checkin_types[2]["checkin_type_value"] = 2;
        $checkin_types[2]["checkin_type_name"] = "{clt_step_3_line_5}";
        $checkin_types[2]["checkin_type_selected"] = "";
        
        return $checkin_types;
    }

    function get_review_statuses()
    {
        $review_statuses = array();
        $review_statuses[0]["status_value"] = 0;
        $review_statuses[0]["status_name"] = "{clt_all}";
        $review_statuses[1]["status_value"] = 2;
        $review_statuses[1]["status_name"] = "{clt_with_review}";
        $review_statuses[2]["status_value"] = 3;
        $review_statuses[2]["status_name"] = "{clt_pending_review}";
        $review_statuses[3]["status_value"] = 4;
        $review_statuses[3]["status_name"] = "{clt_without_review}";
        
        return $review_statuses;
    }

    function get_rating_names()
    {
        $rating_names = array();
        
        $rating_names[1]["rating_value"] = 1;
        $rating_names[1]["rating_name"] = "{clt_review_rating_1}";
        $rating_names[1]["rating_selected"] = "";
        $rating_names[2]["rating_value"] = 2;
        $rating_names[2]["rating_name"] = "{clt_review_rating_1}";
        $rating_names[2]["rating_selected"] = "";
        $rating_names[3]["rating_value"] = 3;
        $rating_names[3]["rating_name"] = "{clt_review_rating_2}";
        $rating_names[3]["rating_selected"] = "";
        $rating_names[4]["rating_value"] = 4;
        $rating_names[4]["rating_name"] = "{clt_review_rating_2}";
        $rating_names[4]["rating_selected"] = "";
        $rating_names[5]["rating_value"] = 5;
        $rating_names[5]["rating_name"] = "{clt_review_rating_3}";
        $rating_names[5]["rating_selected"] = "";
        $rating_names[6]["rating_value"] = 6;
        $rating_names[6]["rating_name"] = "{clt_review_rating_3}";
        $rating_names[6]["rating_selected"] = "";
        $rating_names[7]["rating_value"] = 7;
        $rating_names[7]["rating_name"] = "{clt_review_rating_4}";
        $rating_names[7]["rating_selected"] = "";
        $rating_names[8]["rating_value"] = 8;
        $rating_names[8]["rating_name"] = "{clt_review_rating_4}";
        $rating_names[8]["rating_selected"] = "";
        $rating_names[9]["rating_value"] = 9;
        $rating_names[9]["rating_name"] = "{clt_review_rating_5}";
        $rating_names[9]["rating_selected"] = "";
        $rating_names[10]["rating_value"] = 10;
        $rating_names[10]["rating_name"] = "{clt_review_rating_5}";
        $rating_names[10]["rating_selected"] = "";
        
        return $rating_names;
    }

    function get_trip_types()
    {
        $trip_types = array();
        
        $trip_types[1]["trip_value"] = 1;
        $trip_types[1]["trip_data_value"] = "business";
        $trip_types[1]["trip_icon"] = "business.svg";
        $trip_types[1]["trip_name"] = "{clt_step_1_trip_types_1}";
        $trip_types[1]["trip_selected"] = "";
        $trip_types[2]["trip_value"] = 2;
        $trip_types[2]["trip_data_value"] = "family";
        $trip_types[2]["trip_icon"] = "family.svg";
        $trip_types[2]["trip_name"] = "{clt_step_1_trip_types_2}";
        $trip_types[2]["trip_selected"] = "";
        $trip_types[3]["trip_value"] = 3;
        $trip_types[3]["trip_data_value"] = "couple";
        $trip_types[3]["trip_icon"] = "couple.svg";
        $trip_types[3]["trip_name"] = "{clt_step_1_trip_types_3}";
        $trip_types[3]["trip_selected"] = "";
        $trip_types[4]["trip_value"] = 4;
        $trip_types[4]["trip_data_value"] = "friends";
        $trip_types[4]["trip_icon"] = "friends.svg";
        $trip_types[4]["trip_name"] = "{clt_step_1_trip_types_4}";
        $trip_types[4]["trip_selected"] = "";
        $trip_types[5]["trip_value"] = 5;
        $trip_types[5]["trip_data_value"] = "single";
        $trip_types[5]["trip_icon"] = "single.svg";
        $trip_types[5]["trip_name"] = "{clt_step_1_trip_types_5}";
        $trip_types[5]["trip_selected"] = "";
        
        return $trip_types;
    }

    function get_reservation_type()
    {
        $reservation_types = array();
        
        $reservation_types[0]["reservation_types_value"] = 0;
        $reservation_types[0]["reservation_types_name"] = "{clt_step_1_book_types_1}";
        $reservation_types[0]["reservation_types_selected"] = "";
        $reservation_types[1]["reservation_types_value"] = 1;
        $reservation_types[1]["reservation_types_name"] = "{clt_step_1_book_types_2}";
        $reservation_types[1]["reservation_types_selected"] = "";
        $reservation_types[2]["reservation_types_value"] = 2;
        $reservation_types[2]["reservation_types_name"] = "{clt_step_1_book_types_3}";
        $reservation_types[2]["reservation_types_selected"] = "";
        $reservation_types[3]["reservation_types_value"] = 3;
        $reservation_types[3]["reservation_types_name"] = "{clt_step_1_book_types_4}";
        $reservation_types[3]["reservation_types_selected"] = "";
        $reservation_types[4]["reservation_types_value"] = 4;
        $reservation_types[4]["reservation_types_name"] = "{clt_step_1_book_types_5}";
        $reservation_types[4]["reservation_types_selected"] = "";
        
        return $reservation_types;
    }

    function get_choice_types()
    {
        $choice_types = array();
        
        $choice_types[0]["choice_types_value"] = 1;
        $choice_types[0]["choice_types_name"] = "{clt_step_2_choice_types_1}";
        $choice_types[0]["choice_types_check"] = "";
        $choice_types[1]["choice_types_value"] = 2;
        $choice_types[1]["choice_types_name"] = "{clt_step_2_choice_types_2}";
        $choice_types[1]["choice_types_check"] = "";
        $choice_types[2]["choice_types_value"] = 3;
        $choice_types[2]["choice_types_name"] = "{clt_step_2_choice_types_3}";
        $choice_types[2]["choice_types_check"] = "";
        $choice_types[3]["choice_types_value"] = 4;
        $choice_types[3]["choice_types_name"] = "{clt_step_2_choice_types_4}";
        $choice_types[3]["choice_types_check"] = "";
        $choice_types[4]["choice_types_value"] = 5;
        $choice_types[4]["choice_types_name"] = "{clt_step_2_choice_types_5}";
        $choice_types[4]["choice_types_check"] = "";
        $choice_types[5]["choice_types_value"] = 6;
        $choice_types[5]["choice_types_name"] = "{clt_step_2_choice_types_6}";
        $choice_types[5]["choice_types_check"] = "";
        $choice_types[6]["choice_types_value"] = 7;
        $choice_types[6]["choice_types_name"] = "{clt_step_2_choice_types_7}";
        $choice_types[6]["choice_types_check"] = "";
        
        return $choice_types;
    }

    function get_wishes_of_stays()
    {
        $wishes_of_stay = array();
        
        $wishes_of_stay[0]["wishes_of_stay_value"] = 1;
        $wishes_of_stay[0]["wishes_of_stay_name"] = "{clt_step_2_wishes_of_stay_1}";
        $wishes_of_stay[0]["wishes_of_stay_check"] = "";
        $wishes_of_stay[1]["wishes_of_stay_value"] = 2;
        $wishes_of_stay[1]["wishes_of_stay_name"] = "{clt_step_2_wishes_of_stay_2}";
        $wishes_of_stay[1]["wishes_of_stay_check"] = "";
        $wishes_of_stay[2]["wishes_of_stay_value"] = 3;
        $wishes_of_stay[2]["wishes_of_stay_name"] = "{clt_step_2_wishes_of_stay_3}";
        $wishes_of_stay[2]["wishes_of_stay_check"] = "";
        $wishes_of_stay[3]["wishes_of_stay_value"] = 4;
        $wishes_of_stay[3]["wishes_of_stay_name"] = "{clt_step_2_wishes_of_stay_4}";
        $wishes_of_stay[3]["wishes_of_stay_check"] = "";
        
        return $wishes_of_stay;
    }

    function get_experience()
    {
        $experience_array = array();
        $experience_array[0]["experience_value"] = 0;
        $experience_array[0]["experience_name"] = "{clt_review_na}";
        $experience_array[0]["experience_selected"] = "";
        $experience_array[1]["experience_value"] = 1;
        $experience_array[1]["experience_name"] = "{clt_step_2_line_5}";
        $experience_array[1]["experience_selected"] = "";
        $experience_array[2]["experience_value"] = 2;
        $experience_array[2]["experience_name"] = "{clt_step_2_line_6}";
        $experience_array[2]["experience_selected"] = "";
        $experience_array[3]["experience_value"] = 3;
        $experience_array[3]["experience_name"] = "{clt_step_2_line_7}";
        $experience_array[3]["experience_selected"] = "";
        $experience_array[4]["experience_value"] = 4;
        $experience_array[4]["experience_name"] = "{clt_step_2_line_8}";
        $experience_array[4]["experience_selected"] = "";
        $experience_array[5]["experience_value"] = 5;
        $experience_array[5]["experience_name"] = "{clt_step_2_line_9}";
        $experience_array[5]["experience_selected"] = "";
        
        return $experience_array;
    }

    function get_improve_rating()
    {
        $improve_rating = array();
        
        $improve_rating[0]["improve_rating_value"] = 1;
        $improve_rating[0]["improve_rating_name"] = "{clt_step_3_improve_rating_1}";
        $improve_rating[0]["improve_rating_check"] = "";
        $improve_rating[1]["improve_rating_value"] = 2;
        $improve_rating[1]["improve_rating_name"] = "{clt_step_3_improve_rating_2}";
        $improve_rating[1]["improve_rating_check"] = "";
        $improve_rating[2]["improve_rating_value"] = 3;
        $improve_rating[2]["improve_rating_name"] = "{clt_step_3_improve_rating_3}";
        $improve_rating[2]["improve_rating_check"] = "";
        $improve_rating[3]["improve_rating_value"] = 4;
        $improve_rating[3]["improve_rating_name"] = "{clt_step_3_improve_rating_4}";
        $improve_rating[3]["improve_rating_check"] = "";
        
        return $improve_rating;
    }

    function get_review_services_array($rerurn_type = 0)
    {
        $services = array();
        // $services[0]["service_id"] = 1;
        // $services[0]["service_name"] = "The WiFi?";
        // $services[1]["service_id"] = 2;
        // $services[1]["service_name"] = "Your lunch and/or dinner?";
        // $services[2]["service_id"] = 3;
        // $services[2]["service_name"] = "The bar?";
        
        $sql = "SELECT property_amenety_type.id as amenety_type_id, property_amenety_type.name as amenety_type_name,
property_ameneties.id as amenety_id, property_ameneties.name as amenety_name, property2ameneties.amenity_id
FROM property_amenety_type
LEFT JOIN property_ameneties ON property_ameneties.type_id = property_amenety_type.id
LEFT JOIN property2ameneties ON property2ameneties.amenity_id = property_ameneties.id AND property2ameneties.property_id = 1";
        $query = $this->db->query($sql);
        $inc = 0;
        foreach ($query->result() as $row) {
            $property[$row->amenety_type_id]["ameneties"][$row->amenety_id]["amenety_id"] = $row->amenety_id;
            $property[$row->amenety_type_id]["ameneties"][$row->amenety_id]["amenety_name"] = "{-" . $row->amenety_name . "-}";
            if ($row->amenity_id != NULL) {
                if ($rerurn_type == 0) {
                    $services[$inc]["service_id"] = $row->amenety_id;
                    $services[$inc]["service_name"] = "{-" . $row->amenety_name . "-}";
                    $inc ++;
                } else {
                    $services[$row->amenety_id]["service_id"] = $row->amenety_id;
                    $services[$row->amenety_id]["service_name"] = "{-" . $row->amenety_name . "-}";
                }
            }
        }
        
        return $services;
    }

    function get_review_services_improves_array()
    {
        // first key of array $services_improves is service_id
        $services_improves = array();
        // $services_improves[1]["improves"][0]["improve_id"] = 1;
        // $services_improves[1]["improves"][0]["improve_name"] = "The ease of access";
        // $services_improves[1]["improves"][1]["improve_id"] = 2;
        // $services_improves[1]["improves"][1]["improve_name"] = "The speed of connection";
        
        // $services_improves[2]["improves"][0]["improve_id"] = 3;
        // $services_improves[2]["improves"][0]["improve_name"] = "The value for money";
        // $services_improves[2]["improves"][1]["improve_id"] = 4;
        // $services_improves[2]["improves"][1]["improve_name"] = "The quality of food and beverages";
        // $services_improves[2]["improves"][2]["improve_id"] = 5;
        // $services_improves[2]["improves"][2]["improve_name"] = "The friendliness of our staff";
        
        // $services_improves[3]["improves"][0]["improve_id"] = 3;
        // $services_improves[3]["improves"][0]["improve_name"] = "The value for money";
        // $services_improves[3]["improves"][1]["improve_id"] = 4;
        // $services_improves[3]["improves"][1]["improve_name"] = "The quality of food and beverages";
        // $services_improves[3]["improves"][2]["improve_id"] = 5;
        // $services_improves[3]["improves"][2]["improve_name"] = "The friendliness of our staff";
        
        $services_improves[0]["improve_id"] = 1;
        $services_improves[0]["improve_name"] = "{clt_step_4_improve_1}";
        $services_improves[0]["improve_rating_check"] = "";
        $services_improves[1]["improve_id"] = 2;
        $services_improves[1]["improve_name"] = "{clt_step_4_improve_2}";
        $services_improves[1]["improve_rating_check"] = "";
        $services_improves[2]["improve_id"] = 3;
        $services_improves[2]["improve_name"] = "{clt_step_4_improve_3}";
        $services_improves[2]["improve_rating_check"] = "";
        
        return $services_improves;
    }

    function update_settings($data)
    {
        
        // if(isset($data["mail_body"])){
        // $sql = "INSERT INTO reviews_config (name, str_value) VALUES('mail_body', '".addslashes ( $data["mail_body"])."') ON DUPLICATE KEY UPDATE str_value = '".addslashes ( $data["mail_body"])."'";
        // $query = $this->db->query ( $sql );
        // }
        if (isset($data["isactive"])) {
            $sql = "INSERT INTO  reviews_config (name, value) VALUES('isactive', '1') ON DUPLICATE KEY UPDATE value = '1'";
            $query = $this->db->query($sql);
        } else {
            $sql = "INSERT INTO  reviews_config (name, value) VALUES('isactive', '0') ON DUPLICATE KEY UPDATE value = '0'";
            $query = $this->db->query($sql);
        }
        
        if (isset($data["is_automatic_review"])) {
            $sql = "INSERT INTO  reviews_config (name, value) VALUES('is_automatic_review', '1') ON DUPLICATE KEY UPDATE value = '1'";
            $query = $this->db->query($sql);
        } else {
            $sql = "INSERT INTO  reviews_config (name, value) VALUES('is_automatic_review', '0') ON DUPLICATE KEY UPDATE value = '0'";
            $query = $this->db->query($sql);
        }
        
        if (isset($data["is_autoremind_1"])) {
            $sql = "INSERT INTO  reviews_config (name, value) VALUES('is_autoremind_1', '1') ON DUPLICATE KEY UPDATE value = '1'";
            $query = $this->db->query($sql);
        } else {
            $sql = "INSERT INTO  reviews_config (name, value) VALUES('is_autoremind_1', '0') ON DUPLICATE KEY UPDATE value = '0'";
            $query = $this->db->query($sql);
        }
        
        if (isset($data["is_autoremind_2"])) {
            $sql = "INSERT INTO  reviews_config (name, value) VALUES('is_autoremind_2', '1') ON DUPLICATE KEY UPDATE value = '1'";
            $query = $this->db->query($sql);
        } else {
            $sql = "INSERT INTO  reviews_config (name, value) VALUES('is_autoremind_2', '0') ON DUPLICATE KEY UPDATE value = '0'";
            $query = $this->db->query($sql);
        }
        
        if (isset($data["autoremind_days_1"])) {
            $sql = "INSERT INTO  reviews_config (name, value) VALUES('autoremind_days_1', '" . $data["autoremind_days_1"] . "') ON DUPLICATE KEY UPDATE value = '" . $data["autoremind_days_1"] . "'";
            $query = $this->db->query($sql);
        } else {
            $sql = "INSERT INTO  reviews_config (name, value) VALUES('autoremind_days_1', '0') ON DUPLICATE KEY UPDATE value = '0'";
            $query = $this->db->query($sql);
        }
        
        if (isset($data["autoremind_days_2"])) {
            $sql = "INSERT INTO  reviews_config (name, value) VALUES('autoremind_days_2', '" . $data["autoremind_days_2"] . "') ON DUPLICATE KEY UPDATE value = '" . $data["autoremind_days_2"] . "'";
            $query = $this->db->query($sql);
        } else {
            $sql = "INSERT INTO  reviews_config (name, value) VALUES('autoremind_days_2', '0') ON DUPLICATE KEY UPDATE value = '0'";
            $query = $this->db->query($sql);
        }
        
        if (isset($data["auto_send"])) {
            $sql = "INSERT INTO  reviews_config (name, value) VALUES('auto_send', '1') ON DUPLICATE KEY UPDATE value = '1'";
            $query = $this->db->query($sql);
        } else {
            $sql = "INSERT INTO  reviews_config (name, value) VALUES('auto_send', '0') ON DUPLICATE KEY UPDATE value = '0'";
            $query = $this->db->query($sql);
        }
        
        if (isset($data["days_delay"]) && $data["days_delay"] >= 0 && $data["days_delay"] <= 7) {
            $days = $data["days_delay"];
            $sql = "INSERT INTO  reviews_config (name, value) VALUES('days_delay', '1') ON DUPLICATE KEY UPDATE value = '$days'";
            $query = $this->db->query($sql);
        }
    }

    function get_record($name, $valuename = "str")
    {
        $query = $this->db->query("SELECT * FROM `reviews_config` WHERE name LIKE '" . $name . "'");
        $result = null;
        
        if ($valuename == "int") {
            $result = 0;
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $result = $row->value;
            }
        } elseif ($valuename == "str") {
            $result = "";
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $result = $row->str_value;
            }
        }
        return $result;
    }

    function get_reviews_list($main_select = "", $page_first_line = 1, $lines_per_page = 50, $review_select = "")
    {
        $date = date("Y-m-d");
        // $sql = "SELECT reviews_new.id as review_id, deskofreservation.id as reservation_id, CONCAT(guests.firstname, ' ', guests.lastname) as guest_name,
        // reviews_new.status as review_status, reviews_new.create_date, reviews_new.experience_value as rating
        // FROM reviews_new
        // INNER JOIN deskofreservation ON deskofreservation.id = reviews_new.reservation_id
        // INNER JOIN guests ON guests.id = deskofreservation.guest_id
        // ".$main_select."
        // ORDER BY reviews_new.id DESC LIMIT ".$page_first_line.", ".$lines_per_page;
        if ($review_select == "") {
           /*  $sql = "SELECT reviews_new.id as review_id, deskofreservation.id as reservation_id, CONCAT(guests.firstname, ' ', guests.lastname) as guest_name,
                    reviews_new.status as review_status, reviews_new.create_date, reviews_new.experience_value as rating, guests.email as guest_email
                    FROM deskofreservation
                    INNER JOIN guests ON guests.id = deskofreservation.guest_id
                    LEFT JOIN reviews_new ON reviews_new.reservation_id = deskofreservation.id
                    " . $main_select . "
                    ORDER BY deskofreservation.id DESC LIMIT " . $page_first_line . ", " . $lines_per_page; */
            
            $sql = "SELECT SQL_CALC_FOUND_ROWS  reviews_new.id as review_id, deskofreservation.id as reservation_id, CONCAT(guests.firstname, ' ', guests.lastname) as guest_name,
                    reviews_new.status as review_status, reviews_new.create_date, reviews_new.experience_value as rating, guests.email as guest_email,
                    reviews_sending_log.error,reviews_sending_log.id as log_id
                    FROM deskofreservation
                    INNER JOIN guests ON guests.id = deskofreservation.guest_id
                    LEFT JOIN reviews_sending_log ON reviews_sending_log.reservation_id = deskofreservation.id
                
                    LEFT JOIN reviews_new ON reviews_new.reservation_id = deskofreservation.id
                     " . $main_select . "
                    ORDER BY deskofreservation.id DESC LIMIT " . $page_first_line . ", " . $lines_per_page;
        } else {
           /*  $sql = "SELECT reviews_new.id as review_id, deskofreservation.id as reservation_id, CONCAT(guests.firstname, ' ', guests.lastname) as guest_name,
                    guests.email as guest_email,
                    reviews_new.status as review_status, reviews_new.create_date, reviews_new.experience_value as rating
                    FROM reviews_new
                    INNER JOIN deskofreservation ON reviews_new.reservation_id = deskofreservation.id
                    INNER JOIN guests ON guests.id = deskofreservation.guest_id
                    " . $main_select . " AND " . $review_select . " 1
                    ORDER BY deskofreservation.id DESC LIMIT " . $page_first_line . ", " . $lines_per_page; */
            
            $sql = "SELECT SQL_CALC_FOUND_ROWS reviews_new.id as review_id, deskofreservation.id as reservation_id, CONCAT(guests.firstname, ' ', guests.lastname) as guest_name,
                    reviews_new.status as review_status, reviews_new.create_date, reviews_new.experience_value as rating, guests.email as guest_email,
                    reviews_sending_log.error,reviews_sending_log.id as log_id
                    FROM deskofreservation
                    INNER JOIN guests ON guests.id = deskofreservation.guest_id
                    LEFT JOIN reviews_sending_log ON reviews_sending_log.reservation_id = deskofreservation.id
                    INNER JOIN reviews_new ON reviews_new.reservation_id = deskofreservation.id AND " . $review_select . " 1
                     " . $main_select . "
                         
                    ORDER BY deskofreservation.id DESC LIMIT " . $page_first_line . ", " . $lines_per_page;
        }
        
        // $sql = "SELECT reviews_new.id as review_id, deskofreservation.id as reservation_id, CONCAT(guests.firstname, ' ', guests.lastname) as guest_name,
        // reviews_new.status as review_status, reviews_new.create_date, reviews_new.experience_value as rating, guests.email as guest_email
        // FROM deskofreservation
        // INNER JOIN guests ON guests.id = deskofreservation.guest_id
        // LEFT JOIN reviews_new ON reviews_new.reservation_id = deskofreservation.id AND ".$review_select." 1
        // ".$main_select."
        // ORDER BY deskofreservation.id DESC LIMIT ".$page_first_line.", ".$lines_per_page;
        /* 
          echo $sql;
         die();  */
        $query = $this->db->query($sql);
       
        return $query->result_array();  
    }

    /*
     * GET ALL REVIEWS QUESTIONS
     */
    function get_review_questions()
    {
        // $review_questions = array();
        // $sql = "SELECT otelms_tripadvisor.reviews_questions.*, reviews_active_questions.question_id as is_active_id FROM otelms_tripadvisor.reviews_questions
        // LEFT JOIN reviews_active_questions ON reviews_active_questions.question_id = otelms_tripadvisor.reviews_questions.id";
        // $query = $this->db->query ( $sql );
        // $i = 1;
        // foreach ($query->result_array() as $row)
        // {
        // $review_questions[$i]["question_id"] = $row["id"];
        // $review_questions[$i]["question_name"] = $row["title"];
        // if($row["is_active_id"] == NULL){
        // $review_questions[$i]["question_active"] = 0;
        // $review_questions[$i]["question_active_checked"] = "";
        // }else{
        // $review_questions[$i]["question_active"] = 1;
        // $review_questions[$i]["question_active_checked"] = "checked";
        // }
        // $i++;
        // }
        $curl_data = array();
        $curl_data["hotel_id"] = $this->config->item("hotel_id");
        $output = json_encode($curl_data);
        
        $url = "https://" . $this->config->item('reviews_host') . "/reviews_c2/get_review_questions";
        $result = $this->Curl_model->CurlPlugRaw_clean($output, $url);
        // echo $result;
        // die();
        $review_questions = json_decode($result, true);
        
        // echo "<pre>";
        // print_r($review_questions);
        // die();
        return $review_questions;
    }
    
    // insert into local hotel db question
    function insert_active_question($question_id)
    {
        // $sql = "INSERT INTO reviews_active_questions (question_id) VALUES('".$question_id."') ON DUPLICATE KEY UPDATE question_id = '".$question_id."'";
        // $this->db->query( $sql );
        $curl_data = array();
        $curl_data["hotel_id"] = $this->config->item("hotel_id");
        $curl_data["question_id"] = $question_id;
        $output = json_encode($curl_data);
        
        $url = "https://" . $this->config->item('reviews_host') . "/reviews_c2/insert_active_question";
        // echo $url;
        $result = $this->Curl_model->CurlPlugRaw_clean($output, $url);
        // echo $result;
    }
    
    // delete into local hotel db question
    function delete_active_question($question_id)
    {
        // $sql = "DELETE FROM reviews_active_questions WHERE question_id = '" . $question_id . "'";
        // $this->db->query($sql);
        $curl_data = array();
        $curl_data["hotel_id"] = $this->config->item("hotel_id");
        $curl_data["question_id"] = $question_id;
        $output = json_encode($curl_data);
        
        $url = "https://" . $this->config->item('reviews_host') . "/reviews_c2/delete_active_question";
        $result = $this->Curl_model->CurlPlugRaw_clean($output, $url);
    }

    function integration_propertylogo_fotos()
    {
        $property_logo_images = array();
        $i = 1;
        $sql = "SELECT id, logo_small, logo_original FROM property_information";
        $query = $this->db->query($sql);
        foreach ($query->result_array() as $row) {
            $property_logo_images[$i]["property_id"] = $row["id"];
            $property_logo_images[$i]["img_small_file_data"] = $row["logo_small"];
            $property_logo_images[$i]["img_original_file_data"] = $row["logo_original"];
            $i ++;
        }
        
        $img_curl_data = array();
        $img_curl_data["hotel_id"] = $this->config->item('hotel_id');
        $img_curl_data["property_logo_images"] = $property_logo_images;
        $this->external_fotos_save($img_curl_data);
    }

    function external_fotos_save($imgdata)
    {
        $output = json_encode($imgdata);
        $url = "https://" . $this->config->item('reviews_host') . "/media_images_gate/image_save";
        $result = $this->Curl_model->CurlPlugRaw_clean($output, $url);
        echo $result;
    }

    function get_review_scores_set()
    {
        $scores = array();
        for ($i = 1; $i < 10; $i ++) {
            $scores[$i] = array(
                'id' => $i,
                'name' => $i . '+',
                'selected' => 'selected'
            );
        }
        return $scores;
    }

    function get_review_sort_options_arr()
    {
        $arr = array(
            'DESC' => array(
                'val' => 'DESC',
                'name' => '{От высоких к низким оценкам}',
                'selected' => ''
            ),
            'ASC' => array(
                'val' => 'ASC',
                'name' => '{От низких к высоким оценкам}',
                'selected' => ''
            )
        );
        return $arr;
    }

    function get_affected_channels($conditions = array())
    {
        $sql_where_str = "";
        if (isset($conditions['in_header'])) {
            $sql_where_str .= " AND in_header = 1";
        }
        if ($sql_where_str != "") {
            $sql_where_str = substr_replace($sql_where_str, 'WHERE', 0, 4);
        }
        $sql = "SELECT dc_id, in_header, in_reviews, FORMAT(AVG(score), 1) AS score, SUM(count) AS count, error, updated
                FROM reviews_channels_config
                $sql_where_str
                GROUP BY dc_id";
        $res = $this->db->query($sql)->result();
        return $res;
    }

    function get_deltas_periods_data($d = array())
    {
        if (isset($d['period'])) {
            $tbl = "reviews_all_channels";
            $tbl_config = "reviews_channels_config";
            $start_date = $d['period']['start_date'];
            $end_date = $d['period']['end_date'];
            $delta_length = $d['period']['delta_length'];
            $sql = "SELECT t1.dc_id, FORMAT(AVG(t1.score), 1) AS avg_score
                    FROM $tbl AS t1
                    JOIN $tbl_config AS t2 ON t1.dc_id = t2.dc_id
                    WHERE created BETWEEN '$start_date' AND '$end_date' AND t2.in_header = 1
                    GROUP BY dc_id";
            $curr_period = $this->db->query($sql)->result();
            
            $start_date = date('Y-m-d H:i:s', strtotime("$start_date - $delta_length days"));
            $end_date = date('Y-m-d H:i:s', strtotime("$end_date - $delta_length days"));
            $sql = "SELECT t1.dc_id, FORMAT(AVG(t1.score), 1) AS avg_score
                    FROM $tbl AS t1
                    JOIN $tbl_config AS t2 ON t1.dc_id = t2.dc_id
                    WHERE created BETWEEN '$start_date' AND '$end_date' AND t2.in_header = 1
                    GROUP BY dc_id";
            $prev_period = $this->db->query($sql)->result();
            $res_arr = array();
            foreach ($curr_period as $data) {
                $res_arr[$data->dc_id]['delta_txt'] = '{clt_nodata}';
                $res_arr[$data->dc_id]['curr'] = $data;
            }
            foreach ($prev_period as $data) {
                $res_arr[$data->dc_id]['delta_txt'] = '{clt_nodata}';
                $res_arr[$data->dc_id]['prev'] = $data;
            }
            foreach ($res_arr as $dc_id => &$data) {
                if (isset($data['curr']) && isset($data['prev'])) {
                    $delta_sign = ($data['curr']->avg_score < $data['prev']->avg_score) ? '-' : '+';
                    $delta_abc = abs($data['curr']->avg_score - $data['prev']->avg_score);
                    $delta_percent = round($delta_abc / $data['prev']->avg_score * 100, 1);
                    $data['delta_txt'] = $delta_sign . $delta_percent . ' %';
                }
            }
        }
        return $res_arr;
    }

    function get_booking_rw_block($rw)
    {
        $body = json_decode($rw->body);
        $rw->country = isset($body->reviewer->country_code) ? $body->reviewer->country_code : '';
        $rw->headline = isset($body->content->headline) ? $body->content->headline : '';
        if (isset($body->content->positive)) {
            $rw->positive = $body->content->positive;
        } else {
            $rw->positive = "";
            $rw->hide_positive_div_class = "d0";
        }
        if (isset($body->content->negative)) {
            $rw->negative = $body->content->negative;
        } else {
            $rw->negative = "";
            $rw->hide_negative_div_class = "d0";
        }
        $rw->room = '';
        if (isset($body->reply->text)) {
            $rw->reply_text = $body->reply->text;
        } else {
            $rw->reply_text = "";
            $rw->hide_reply_div_class = "d0";
        }
        $reservation_data = $this->get_reservation_data($rw->reservation_id);
        foreach ($reservation_data as $fild => $value) {
            $rw->$fild = $value;
        }
        $rw->reviewer = isset($body->reviewer->name) && $body->reviewer->name != '' ? $body->reviewer->name : 'Anonymous';
        return $this->parser->parse('templates/reviews_c2/blocks_tmpls/booking.html', $rw, true);
    }

    function get_reservation_data($reservation_id = "")
    {
        if ($reservation_id != "") {
            $sql = "SELECT CONCAT(t1.datein, ' - ', t1.dateout) AS date, t2.name AS room, CONCAT(t3.firstname, ' ', t3.lastname) AS reviewer
            FROM deskofreservation AS t1
            JOIN rooms ON t1.room_id = rooms.id
            JOIN categories AS t2 ON rooms.category_id = t2.id
            JOIN guests AS t3 ON t3.id = t1.guest_id
            WHERE t1.id = $reservation_id";
            $res = $this->db->query($sql)->row();
        }
        if (! get_object_vars($res)) {
            $res = new stdClass();
            $res->date = '';
            $res->room = '---';
            $res->reviewer = '';
            $res->reservation_info = "(---)";
        } else {
            $res->reservation_info = " (<a href='/reservation_c2/folio/$reservation_id' target='_blank'># $reservation_id</a>)";
        }
        return $res;
    }

    function get_airbnb_rw_block($rw)
    {
        $body = json_decode($rw->body);
        // $rw->reviewer = $body->reviewer_id;
        $rw->public_review = $body->public_review;
        $rw->private_feedback = $body->private_feedback;
        $rw->hide_public_review_div_class = ($body->public_review == "") ? 'd0' : '';
        $rw->hide_private_feedback_div_class = ($body->private_feedback == "") ? 'd0' : '';
        $rw->category_ratings = $body->category_ratings;
        $reservation_data = $this->get_reservation_data($rw->reservation_id);
        foreach ($reservation_data as $fild => $value) {
            $rw->$fild = $value;
        }
        $rw->hide_reply_div_class = "d0";
        return $this->parser->parse('templates/reviews_c2/blocks_tmpls/airbnb.html', $rw, true);
    }

    function get_otelms_rw_block($rw)
    {
        $body = json_decode($rw->body);
        $rw->positive = $body->experience_text;
        $rw->negative = ''; // $body->hotel_not_positive;
        $rw->hide_positive_div_class = ($rw->positive == "") ? 'd0' : '';
        $rw->hide_negative_div_class = ($rw->negative == "") ? 'd0' : '';
        $reservation_data = $this->get_reservation_data($rw->reservation_id);
        foreach ($reservation_data as $fild => $value) {
            $rw->$fild = $value;
        }
        $rw->hide_reply_div_class = "d0";
        return $this->parser->parse('templates/reviews_c2/blocks_tmpls/otelms.html', $rw, true);
    }

    function get_all_channels_list()
    {
        $all_channels = $this->dc_model->get_dc_channels_list_data();
        $all_channels[0] = array(
            'name' => "OtelMS",
            'short_name' => "otel",
            'small_logo' => "chmanager_small_otel.png",
            'url' => "Otelms.com"
        );
        return $all_channels;
    }

    function update_otelms_reviews()
    {
        $errors = array();
        $date_depth = '2016-01-01';
        $timestamp_depth = strtotime("$date_depth 00:00:00");
        $dc_id = 0;
        // $src_tbl = 'reviews';
        $src_tbl = 'reviews_new';
        $trg_tbl = 'reviews_all_channels';
        $config_tbl = "reviews_channels_config";
        // $scoring_filds = array( 'hotel_staff', 'hotel_service', 'room_clean', 'comfort', 'performence_price_ratio', 'hotel_location');
        $scoring_filds = array(
            'experience_value'
        );
        // $select_filds = "id AS review_id, reservation_id, hotel_positive, hotel_not_positive, timestamp AS created_timestamp, ".implode(", ", $scoring_filds);
        $select_filds = "id AS review_id, reservation_id, experience_text, create_date AS created_timestamp, " . implode(", ", $scoring_filds);
        $reviews = $this->db->select($select_filds)
            ->get_where($src_tbl, "create_date >= $timestamp_depth")
            ->result();
        foreach ($reviews as $rw) {
            $avg_score = $scored_items_count = 0;
            foreach ($scoring_filds as $scoring_fild) {
                $avg_score += $rw->$scoring_fild;
                $scored_items_count ++;
            }
            $avg_score = ($scored_items_count != 0) ? $avg_score / $scored_items_count : 0;
            $ins_or_upd_arr = array(
                'dc_id' => $dc_id,
                'dc_hotel_id' => 0,
                'reservation_id' => $rw->reservation_id,
                'rw_id' => $rw->review_id,
                'created' => $rw->created_timestamp, // date('Y-m-d H:i:s', $rw->created_timestamp),
                'modified' => date('Y-m-d H:i:s'),
                'body' => json_encode($rw),
                'score' => round($avg_score, 1)
            );
            if ($this->db->get_where($trg_tbl, array(
                'rw_id' => $rw->review_id,
                'dc_id' => $dc_id
            ))->row()) {
                $this->db->update($trg_tbl, $ins_or_upd_arr, array(
                    'rw_id' => $rw->review_id,
                    'dc_id' => $dc_id
                ));
            } else {
                $this->db->insert($trg_tbl, $ins_or_upd_arr);
            }
        }
        $sql = "SELECT FORMAT(AVG(score), 1) AS score, SUM(1) AS count
                FROM $trg_tbl
                WHERE dc_id = $dc_id
                GROUP BY dc_id";
        $row = $this->db->query($sql)->row();
        if ($row) {
            $ins_upd_arr = array(
                'dc_id' => $dc_id,
                'hotel_id' => 0,
                'score' => $row->score,
                'count' => $row->count,
                'error' => null,
                'updated' => date('Y-m-d H:i:s')
            );
            if ($this->db->get_where($config_tbl, array(
                'dc_id' => $dc_id
            ))->row()) {
                $this->db->update($config_tbl, $ins_upd_arr, array(
                    'dc_id' => $dc_id
                ));
            } else {
                $this->db->insert($config_tbl, $ins_upd_arr);
            }
        }
    }

    function get_reviews_from_booking($TEST_MODE = 0)
    {
        $errors = array();
        if ($TEST_MODE) {
            $hotels = array(
                '5804014',
                '361674'
            );
        } else {
            $hotels = array();
            $query_res = $this->db->select('int_value')
                ->like('name', 'hotel_id')
                ->get('dc_booking_xml_cfg')
                ->result();
            foreach ($query_res as $hotel_id) {
                array_push($hotels, $hotel_id->int_value);
            }
        }
        $dc_id = 1; // booking.com
        $max_updated = $this->db->select_max('updated')
            ->where('dc_id', $dc_id)
            ->get('reviews_all_channels')
            ->result();
        $date = (isset($max_updated['0']) &&
                 $max_updated['0']->updated != '0000-00-00 00:00:00') ? $max_updated['0']->updated : '2011-01-01';
        $date = date('Y-m-d', strtotime($date) - 86400); // -1 day from last
                                                         // update
        $tbl = "reviews_all_channels";
        $tbl2 = "reviews_channels_config";
        $dc_user = $this->config->item('dc_booking_xml_user');
        $dc_password = html_entity_decode($this->config->item('dc_booking_xml_pwd'));
        $auth = $dc_user . ":" . $dc_password; // 'de323d32';//
        $headers = array(
            'Authorization: Basic ' . base64_encode($auth)
        );
        foreach ($hotels as $hotel) {
            $next_url = "https://supply-xml.booking.com/review-api/properties/$hotel/reviews?from_date=$date&limit=10";
            do {
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $next_url);
                curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                $responce = curl_exec($ch);
                curl_close($ch);
                $dc_data = json_decode($responce);
                $next_url = (isset($dc_data->meta->next_page) && $dc_data->meta->next_page != "") ? $dc_data->meta->next_page : null;
                if (isset($dc_data->data->reviews)) {
                    foreach ($dc_data->data->reviews as $rw) {
                        $hms_res_id = '';
                        if (isset($rw->reservation_id) && $rw->reservation_id != '') {
                            $row_query = $this->db->select('id')
                                ->get_where('deskofreservation', array(
                                'dc_reservationid' => $rw->reservation_id
                            ))
                                ->row();
                            if ($row_query) {
                                $hms_res_id = $row_query->id;
                            }
                        }
                        $avg_score = $scored_items_count = 0;
                        foreach ($rw->scoring as $score_item_val) {
                            if (! is_null($score_item_val)) {
                                $avg_score += $score_item_val;
                                $scored_items_count ++;
                            }
                        }
                        $avg_score = ($scored_items_count != 0) ? $avg_score / $scored_items_count : 0;
                        $ins_or_upd_arr = array(
                            'dc_id' => $dc_id,
                            'dc_hotel_id' => $hotel,
                            'reservation_id' => $hms_res_id,
                            'rw_id' => $rw->review_id,
                            'created' => $rw->created_timestamp,
                            'modified' => $rw->last_change_timestamp,
                            'updated' => date('Y-m-d H:i:s'),
                            'body' => json_encode($rw),
                            'score' => round($avg_score, 1)
                        );

                        if ($this->db->get_where($tbl, array(
                            'rw_id' => $rw->review_id,
                            'dc_id' => $dc_id
                        ))->row()) {
                            $this->db->update($tbl, $ins_or_upd_arr, array(
                                'rw_id' => $rw->review_id,
                                'dc_id' => $dc_id
                            ));
                        } else {
                            $this->db->insert($tbl, $ins_or_upd_arr);
                        }
                    }
              
                }
            } while (! is_null($next_url));
            
            $score_url = "https://supply-xml.booking.com/review-api/properties/$hotel/score";
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $score_url);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $responce = curl_exec($ch);
            curl_close($ch);
            
            // $errors = array('hms_msg'=>'Token error', 'ch_resp'=>$responce);
            
            $resp = json_decode($responce);
            $max_review_count = 0;
            $scores_sum = 0;
            $counts_sum = 0;
            if (isset($resp->data->scores)) {
                foreach ($resp->data->scores as $score_data) {
                    $max_review_count = ($score_data->review_count > $max_review_count) ? $score_data->review_count : $max_review_count;
                    $scores_sum += $score_data->score * $score_data->review_count;
                    $counts_sum += $score_data->review_count;
                }
            }
            $ins_upd_arr = array(
                'dc_id' => $dc_id,
                'hotel_id' => $hotel,
                'score' => ($counts_sum != 0) ? round($scores_sum / $counts_sum, 1) : 0,
                'count' => $max_review_count,
                'error' => ($errors) ? json_encode($errors) : null,
                'updated' => date('Y-m-d H:i:s')
            );
            if ($this->db->get_where($tbl2, array(
                'dc_id' => $dc_id,
                'hotel_id' => $hotel
            ))->row()) {
                $this->db->update($tbl2, $ins_upd_arr, array(
                    'dc_id' => $dc_id,
                    'hotel_id' => $hotel
                ));
            } else {
                $this->db->insert($tbl2, $ins_upd_arr);
            }
        }
    }

    function get_reviews_from_airbnb($TEST_MODE = 0)
    {
        $errors = array();
        if ($TEST_MODE) {
            $token = "4zm0u7agizpy2mmi5tcs9onhu";
            $refresh_token = 'bktfjsvjsmj5qdso14iwtfiau';
        } else {
            $token = $this->db->select('str_value')
                ->like('name', 'access_token')
                ->get('dc_airbnb_xml_cfg')
                ->row()->str_value;
            $refresh_token = $this->db->select('str_value')
                ->like('name', 'refresh_token')
                ->get('dc_airbnb_xml_cfg')
                ->row()->str_value;
        }
        $dc_id = 22;
        $tbl = "reviews_all_channels";
        $tbl2 = "reviews_channels_config";
        $client = 'awkk3fb3oa4o67f5zbjg8eees';
        $secret = '39qswxnwqbatb6mipl0ahktyl';
        $auth = $client . ':' . $secret;
        
        $headers = array(
            'Content-Type:application/json',
            'Authorization: Basic ' . base64_encode($auth)
        );
        $url = 'https://api.airbnb.com/v2/oauth2/authorizations/' . $token . '?_unwrapped=true';
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        $responce = curl_exec($ch);
        curl_close($ch);
        $result = json_decode($responce, true);
        
        if (! isset($result['valid']) || $result['valid'] == 0) {
            $url = 'https://api.airbnb.com/v2/oauth2/authorizations?_unwrapped=true';
            $data = array(
                'refresh_token' => $refresh_token,
                'reset_refresh_token' => 0
            );
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
            $validation_result = curl_exec($ch);
            curl_close($ch);
            $result = json_decode($validation_result, true);
            $token = isset($result['access_token']) ? $result['access_token'] : '';
        }
        if ($token != '') {
            $headers = array(
                'Content-Type:application/json',
                'X-Airbnb-Oauth-Token:' . $token,
                'X-Airbnb-API-Key:' . $client
            );
            $offset = 0;
            do {
                $url = 'https://api.airbnb.com/v2/listing_reviews?_limit=25&reviewer_role=guest&_offset=' . $offset;
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                $responce = curl_exec($ch);
                curl_close($ch);
                $result = json_decode($responce);
                if (isset($result->reviews)) {
                    foreach ($result->reviews as $rw) {
                        $hms_res_id = '';
                        if (isset($rw->reservation_confirmation_code) && $rw->reservation_confirmation_code != '') {
                            $row_query = $this->db->select('id')
                                ->get_where('deskofreservation', array(
                                'dc_uuid' => $rw->reservation_confirmation_code
                            ))
                                ->row();
                            if ($row_query) {
                                $hms_res_id = $row_query->id;
                            }
                        }
                        if ($rw->overall_rating == NULL) {
                            continue;
                        }
                        $ins_or_upd_arr = array(
                            'dc_id' => $dc_id,
                            // 'dc_hotel_id' => '',
                            'reservation_id' => $hms_res_id,
                            'rw_id' => $rw->id,
                            'created' => $rw->first_completed_at,
                            'modified' => $rw->submitted_at,
                            'body' => json_encode($rw),
                            'score' => $rw->overall_rating
                        );
                        if ($this->db->get_where($tbl, array(
                            'rw_id' => $rw->id,
                            'dc_id' => $dc_id
                        ))->row()) {
                            $this->db->update($tbl, $ins_or_upd_arr, array(
                                'rw_id' => $rw->id,
                                'dc_id' => $dc_id
                            ));
                        } else {
                            $this->db->insert($tbl, $ins_or_upd_arr);
                        }
                    }
                }
                $offset += 25;
            } while (isset($result->reviews) && count($result->reviews));
            
            $url = 'https://api.airbnb.com/v2/rating_stats';
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $scores_resp = curl_exec($ch);
            curl_close($ch);
            $res_scores = json_decode($scores_resp);
            $stats = isset($res_scores->rating_stats[0]) ? $res_scores->rating_stats[0] : '';
        } else {
            $errors = array(
                'hms_msg' => 'Token error',
                'ch_resp' => $validation_result
            );
        }
        $ins_upd_arr = array(
            'dc_id' => $dc_id,
            'hotel_id' => isset($stats->entity_id) ? $stats->entity_id : '---',
            'score' => isset($stats->rating) ? $stats->rating : 0,
            'count' => isset($stats->count) ? $stats->count : 0,
            'error' => ($errors) ? json_encode($errors) : null,
            'updated' => date('Y-m-d H:i:s')
        );
        if ($this->db->get_where($tbl2, array(
            'dc_id' => $dc_id
        ))->row()) {
            $this->db->update($tbl2, $ins_upd_arr, array(
                'dc_id' => $dc_id
            ));
        } else {
            $this->db->insert($tbl2, $ins_upd_arr);
        }
    }

    function get_booking_props()
    {
        $result = new stdClass();
        $result->is_multi = false;
        $sql = "SELECT DISTINCT dc_hotel_id AS id, 'TEST_name' AS name, '' AS selected FROM reviews_all_channels WHERE dc_id = 1";
        $result->hotels = $this->db->query($sql)->result();
        $result->is_multi = count($result->hotels) > 1 ? true : false;
        return $result;
    }

    function get_not_send_reviews_reservation()
    {
        $reserve = '2'; // reserve days if missed some days
        $days_delay = $this->mreviews->get_record("days_delay", "int");
        $date_out_to = new DateTime("- $days_delay day");
        $day_out_from = $days_delay + $reserve;
        $date_out_from = new DateTime("- $day_out_from day");
        
        $reservation_list = $this->db->
        // ->select('guests.email,deskofreservation.id')
        select('deskofreservation.id')
            ->from('deskofreservation')
            ->join('guests', 'guests.id = deskofreservation.guest_id', 'left')
            ->join('reviews_new', 'reviews_new.reservation_id = deskofreservation.id', 'left')
            ->where('dateout <=', $date_out_to->format('Y-m-d'))
            ->where('dateout >=', $date_out_from->format('Y-m-d'))
            ->where('deskofreservation.deleted', '0')
            ->where_in('deskofreservation.status', array(
            '1',
            '2',
            '3'
        ))
            ->where('reviews_new.reservation_id', NULL)
            ->where('guests.email !=', '')
            ->
        get()
            ->result();
        // print_r($reservation_list);
        return $reservation_list;
    }

    function send_review_request($rid, $return_json = 0)
    {
        $hotel_id = 0;
        //$host = $_SERVER["HTTP_HOST"];
        
        $hms_id = $this->config->item("hotel_id");
        $query = $this->db->query("SELECT host FROM visitka.config WHERE id = $hms_id");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $host = $row->host;
        }
        
        $sql = "SELECT * FROM visitka.config WHERE host LIKE '$host'";
        $query = $this->db->query($sql);
        if ($query->num_rows() != 0) {
            $row = $query->row();
            $hotel_id = $row->id;
        }
        
        $reviews_is_active = 0;
        $sql = "SELECT is_active FROM modules WHERE name LIKE 'reviews_v2'";
        $query = $this->db->query($sql);
        if ($query->num_rows() != 0) {
            $row = $query->row();
            $reviews_is_active = $row->is_active;
        }
        
        $success_send = 0;
        
        if ($reviews_is_active == 1) {
            if ($hotel_id != 0 and $rid != 0) {
                $guest_citizenship_code = "";
                $property_id = 1;
                $sql = "SELECT categories.property_id, guests.firstname, guests.lastname, guests.email, guests.city, guests.citizenship_code, deskofreservation.datein, deskofreservation.dateout
                FROM deskofreservation
                INNER JOIN guests ON guests.id = deskofreservation.guest_id
                INNER JOIN rooms ON rooms.id=deskofreservation.room_id
                INNER JOIN categories ON categories.id=rooms.category_id
                WHERE deskofreservation.id = $rid";
                $query = $this->db->query($sql);
                
                if ($query->num_rows() > 0) {
                    $row = $query->row();
                    
                    $email = str_replace("%40", "@", $row->email);
                    $firstname = $row->firstname;
                    $lastname = $row->lastname;
                    $city_name = $row->city;
                    $datein = $row->datein;
                    $dateout = $row->dateout;
                    $guest_citizenship_code = $row->citizenship_code;
                    $property_id = $row->property_id;
                } else {
                    $data_msg = array(
                        "id" => 103,
                        "message_text" => 'Reservation is not isset'
                    );
                    $header_messages = $this->load->view('header_msg_view', $data_msg, true);
                    
                        $json_data = array();
                        $json_data["header_messages"] = $header_messages;
                        return $json_data;
                    
                }
                if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                    $data_msg = array(
                        "id" => 103,
                        "message_text" => 'Guest don`t have email or email is not valid'
                    );
                    $header_messages = $this->load->view('header_msg_view', $data_msg, true);
                    $json_data = array();
                    $json_data["header_messages"] = $header_messages;
                    return $json_data;
                }
                
                // $query = $this->db->query ( "SELECT * FROM logo" );
                // $hotel_name = "";
                // if ($query->num_rows () > 0) {
                // $row = $query->row ();
                // $hotel_name = stripslashes ( $row->logo_title );
                // }
                
                $query = $this->db->query("SELECT property_name FROM  property_information WHERE id = $property_id");
                $hotel_name = "";
                if ($query->num_rows() > 0) {
                    $row = $query->row();
                    $hotel_name = stripslashes($row->property_name);
                }
                
                if ($guest_citizenship_code == "") {
                    $lang = "eng";
                } else {
                    $lang = strtolower($guest_citizenship_code);
                    if ($lang == "esp") {
                        $lang = "spa";
                    }
                    $localization_languages = $this->frontdesk_c2->get_local_active_localization_languages();
                    
                    if (! isset($localization_languages[$lang])) {
                        $lang = "eng";
                    }
                }
                $company=$this->releases->get_company();
                $reviews_host = $company['review_url'];
                
                $url_1 = "https://" . $reviews_host . "/reviews_c2/new_review/" . $rid . "/" . $hotel_id . "/2/" . uniqid($rid) . "?lang=" . $lang;
                $url_reviews_guest_book = $url_1;
                $url_2 = "https://" . $reviews_host . "/reviews_c2/new_review/" . $rid . "/" . $hotel_id . "/4/" . uniqid($rid);
                $url_3 = "https://" . $reviews_host . "/reviews_c2/new_review/" . $rid . "/" . $hotel_id . "/3/" . uniqid($rid);
                
                $url_img_email = "";
                $query = $this->db->query("SELECT str_value FROM hotelix_config WHERE name LIKE 'url_img_email'");
                if ($query->num_rows() > 0) {
                    $row = $query->row();
                    $url_img_email = stripslashes($row->str_value);
                }
                
                $data = array(
                    "hotel_id" => $hotel_id,
                    "host" => $host,
                    // "dbname" => $dbname,
                    "rid" => $rid,
                    // "uid" => "simplestring",
                    "uid" => uniqid($rid),
                    // "url" => $url,
                    "url_img_email" => $url_img_email,
                    "email" => $email,
                    "firstname" => $firstname,
                    "lastname" => $lastname,
                    "city_name" => $city_name,
                    "datein" => $datein,
                    "dateout" => $dateout,
                    "hotel_name" => $hotel_name
                );
                
                $output = json_encode($data);
                $url = "https://" . $reviews_host . "/reviews_c2/save_request_review";
                $result = $this->Curl_model->CurlPlugMass($output, $url);
                
                // send email
                ;
                $subj = $this->mlanguages->getdictionaryword("project_review ", $lang, "{clt_hotel_opinion}") . " " . $hotel_name . " (" . $rid . ")";
                
                $data_msg = array(
                    // "url" => $url,
                    "url_1" => $url_1,
                    "url_reviews_guest_book" => $url_reviews_guest_book,
                    "url_2" => $url_2,
                    "url_3" => $url_3,
                    "uid" => $data["uid"],
                    "url_img_email" => $data["url_img_email"],
                    
                    "reservation_id" => $data["rid"],
                    "hotel_id" => $data["hotel_id"],
                    "hotel_name" => $data["hotel_name"],
                    "firstname" => $data["firstname"],
                    "lastname" => $data["lastname"],
                    "datein" => $data["datein"],
                    "dateout" => $data["dateout"],
                    "city_name" => $data["city_name"]
                );
                
                $this->load->library('parser');
                $mail_body = $this->mreviews->get_record("mail_body");
                $this->mlanguages->getdictionary("project_review", $lang, $data_msg);
                
                $message = $this->parser->parse('templates/reviews_c2/reviews_c2_send_request.html', $data_msg, true);
                
//                 $this->load->library('email');
                
//                 $use_user_smtp = $this->hotelix_config->get_record("use_user_smtp", "int");
                
//                 $config = array();
//                 if ($use_user_smtp == 1) {
//                     $config = $this->hms_mail->getparam(4);
//                 } else {
//                     $config = $this->hms_mail->getparam(3);
//                 }
                
//                 $this->email->initialize($config);
//                 $this->email->set_mailtype("html");
                
//                 $this->email->to($email);
//                 $this->email->set_mailtype("html");
//                 $this->email->subject($subj);
//                 $this->email->message($message);
//                 $from_caption = $this->mlanguages->getdictionaryword("state_lock", $lang, "{caption_customer_support}");
//                 $this->email->from($config['from'], $hotel_name);
                
                // ===== OUTSIDE GATE START ============
                // ================= SEND EMAIL ============================================
                $db_name = $this->db->database;
                $host = '';
                $query = $this->db->query("SELECT host FROM visitka.config WHERE db_name LIKE '" . $db_name . "'");
                
                if ($query->num_rows() > 0) {
                    $row = $query->row();
                    $host = $row->host;
                }
                $url = "https://" . $host . "/outside_gate/Test/send_email";
                $email_cfg_way = $this->config->item('email_way_main');
                
                $email_config = array();
                $email_config[4] = $this->hms_mail->getparam(4);
                $email_config[3] = $this->hms_mail->getparam(3);
                $email_config[2] = $this->hms_mail->getparam(2);
                $email_config[1] = $this->hms_mail->getparam(1);
                
                $curl_data = array();
                $curl_data["hotel_id"] = $this->config->item('hotel_id');
                $curl_data["email_cfg_way"] = $email_cfg_way;               
                $curl_data["subject"] = $subj;
                $curl_data["message"] = $message;
                $curl_data["mail_body"] = $message;
                $curl_data["use_us"] = '';
                $curl_data["email"] = $email;
                $curl_data["property_name"] = $hotel_name;
                $curl_data["use_user_smtp"] = $this->hotelix_config->get_record("use_user_smtp", "int");
                $curl_data["email_config"] = $email_config;
                $curl_data["get_response"] = 1;
                
                $output = json_encode($curl_data);
                
                $result = $this->Curl_model->CurlPlugRaw_clean($output, $url);
//                 echo $result;
//                 die();
                $result_array = json_decode($result, true);
                
                if($result_array['send_state'] == 0){
                    $info = $result_array ['send_result'];
                    $data_msg = array(
                        "id" => 103,
                        "message_text" => $info
                    );
                    $this->add_sending_log($rid, $info);
                    $header_messages = $this->load->view('header_msg_view', $data_msg, true);
                }else{
                    $this->delete_sending_log($rid);
                    $success_send = 1;
                    $query = $this->db->query("UPDATE deskofreservation SET review_status = 1 WHERE id = " . $rid);
                    $data_msg = array(
                        "id" => 106
                    );
                    
                    // save review pending status
                    $pending_status = 3;
                    $sql = "INSERT INTO reviews_new(reservation_id, status) VALUES(" . $rid . ", " . $pending_status . ")
                    ON DUPLICATE KEY UPDATE status = " . $pending_status;
                    $query = $this->db->query($sql);
                    
                    $header_messages = $this->load->view('header_msg_view', $data_msg, true);
                }
                
                $log_email_data = array();
                $log_email_data["response"] = "OUTSIDE:".$result;
                $log_email_data["way"] = 3;
                $log_email_data["email"] = $email;
                
                // логування відправки на емейл
                $this->hms_mail->save_email_log($log_email_data);;

                // ===== OUTSIDE GATE END ============
//                 if (! $this->email->send()) {
//                     $info=$this->email->print_debugger(array('subject'));
//                     $data_msg = array(
//                         "id" => 103,
//                         "message_text" => $info
//                     );
//                     $this->add_sending_log($rid, $info);
//                     $header_messages = $this->load->view('header_msg_view', $data_msg, true);
//                 } else {
//                     $this->delete_sending_log($rid);
//                     $success_send = 1;
//                     $query = $this->db->query("UPDATE deskofreservation SET review_status = 1 WHERE id = " . $rid);
//                     $data_msg = array(
//                         "id" => 106
//                     );
                    
//                     // save review pending status
//                     $pending_status = 3;
//                     $sql = "INSERT INTO reviews_new(reservation_id, status) VALUES(" . $rid . ", " . $pending_status . ")
//                     ON DUPLICATE KEY UPDATE status = " . $pending_status;
//                     $query = $this->db->query($sql);
                    
//                     $header_messages = $this->load->view('header_msg_view', $data_msg, true);
//                 }
            } else {
                $data_msg = array(
                    "id" => 104
                );
                $header_messages = $this->load->view('header_msg_view', $data_msg, true);
            }
        } else {
            $data_msg = array(
                "id" => 105
            );
            $header_messages = $this->load->view('header_msg_view', $data_msg, true);
        }
        
        if ($return_json == 0) {
            return $header_messages;
        } else {
            $json_data = array();
            $json_data["header_messages"] = $header_messages;
            $json_data["success_send"] = $success_send;
            return $json_data;
        }
    }
    public function add_sending_log($res_id, $info)
    {
        $json_info=json_encode($info);
        
        $sql = "INSERT INTO reviews_sending_log(reservation_id, error) VALUES(" .$res_id . ", " .$json_info. ")
                    ON DUPLICATE KEY UPDATE error = " . $json_info;
        $query = $this->db->query($sql);
    }
    public function delete_sending_log($res_id)
    {
        $this->db->delete('reviews_sending_log', array('reservation_id' => $res_id));
    }
    public function show_sending_log($res_id)
    {
       $res= $this->db->select('error')->from('reviews_sending_log')->where('reservation_id',$res_id)->get()->row();
        if($res){
       return $res->error;}
    }
}
?>