<?
class Rlist_mdl extends CI_model {
    const DATE_RANGE_DAYS_PAST = 90;
    const DB_FIELD_NAME_FOR_CHECKED_fields = 'rlist_checked_fields';
	function __construct() {
		parent::__construct ();
		if (! class_exists('Htmltpl')) {
		    $this->load->model ( 'htmltpl' );
		}
		$this->user = isset($_SESSION['user']['id']) ? $_SESSION['user']['id'] : 0;
		$this->init_search_items();		
		$this->init_sortby_values();
	}
	
	public $fields_default_set = array (
	    'number',
	    'reservation_id',
	    'cat_room_name',
	    'cat_name',
	    'room_name',
	    'guest_name',
	    'user_name',
	    'base_places',
	    'additional_places',
	    'baby_places',
	    'dealer',
	    'rate_name',
	    'status_name',
	    'datein',
	    'duration',
	    'dateout',
	    'amount',
	    'discount',
	    'pay_amount',
	    'balance',
	    'date',
	    'phone',
	    'email',
	);
	public $fields = array ();
	
	private $fields_default_checked = array (
	    'number',
	    'reservation_id',
	    'cat_name',
	    'room_name',
	    'balance',
	    'date',
	    'phone',
	    'email',
	);
	
	private $fields_sortable = array (
	    'reservation_id',
	    'cat_name',
	    'room_name',
	    'guest_name',
	    'user_name',
	    'base_places',
	    'additional_places',
	    'baby_places',
	    'dealer',
	    'rate_name',
	    'status_name',
	    'datein',
	    'duration',
	    'dateout',
	    'amount',
	    'discount',
	    'pay_amount',
	    'balance',
	    'date',
	    'phone',
	    'email',
	);
	
	private $money_fields = array(
	    'amount',
	    'discount',
	    'pay_amount',
	    'balance'
	);
		
	public function save_checked_fields_to_db($fields){
	    if ($this->user) {
	        foreach ($fields as $field_name => $checked_value) {
	            $fields[$field_name] = $checked_value == 'checked' || $checked_value == 'true' ? true : false;
	        }
	        $json_fields = json_encode($fields);
	        $sql = "INSERT INTO hotelix_interface_config (userid, name, str_value) VALUES('$this->user', '".self::DB_FIELD_NAME_FOR_CHECKED_fields."', '$json_fields')
			ON DUPLICATE KEY UPDATE str_value = '$json_fields'";
	        $query = $this->db->query( $sql );
	    }
	}
		
	private function get_fields_from_db(){
	    $fields = array();
	    $where_arr = array('userid' => $this->user);
	    $query_fields_row = $this->db->like(array('name' => self::DB_FIELD_NAME_FOR_CHECKED_fields))->select('str_value')->get_where('hotelix_interface_config', $where_arr)->row();
	    if ($query_fields_row) {
	        $fields = json_decode($query_fields_row->str_value);
	    }
	    return $fields;
	}
	
	public function get_fields(){
	    $this->init_fields();
	    return $this->fields;
	}
	
	public $search_items_set = array (
	    'date_range',
	    'date_type',
	    'statuses',
	    'categories',
	    'rate',
	    'intgroupid',
	    'room',
	    'dealer',
	    'discount',
	    'negative_balance',
	    'not_confirmed',
	    'bso',
	    'user',
	);
	
	public $search_items = array ();
	public $user;
	
	private function init_search_items() {
	    $this->search_items = $this->get_default_search_items_values();
	}
	
	private function init_fields() {
	    $fields_from_db = $this->get_fields_from_db();
	    if (!empty($fields_from_db)) {
	        $fields_set = array_keys((array)$fields_from_db);
	        $checked_fields = array();
	        foreach ($fields_from_db as $field_name => $checked) {
	            if ($checked) {
	                array_push($checked_fields, $field_name);
	            }
	        }
	    }else {
	        $fields_set = $this->fields_default_set;
	        $checked_fields = $this->fields_default_checked;
	    }
	    $clts = $this->get_fields_clts();
	    $th_classes = $this->get_fields_tbl_th_classes();
	    foreach ($fields_set as $pos => $field_name){
            $is_checked = in_array($field_name, $checked_fields) ? 'checked' : '';
            $this->fields[$field_name] = array(
                'movable_class' => $field_name != 'number' ? 'is_movable' : '',
                'sortable_hiding_class' => !in_array($field_name, $this->fields_sortable) ? 'd0' : '',
                'sorting_sign' => '',
                'is_checkable' => $field_name == 'number' ? 'disabled' : '',
                'position' => $pos,
                'name' => $field_name,
                'checked' => $is_checked,
                'clt' => isset($clts[$field_name]) ? $clts[$field_name] : '',
                'hiding_class' => $is_checked ? '' : 'd0',
                'tbl_th_class' => isset($th_classes[$field_name]) ? $th_classes[$field_name] : ''
            );
        }
        $this->fields = json_decode(json_encode($this->fields));
	}
	
	public function restore_fields_defaults() {
	    $where_arr = array('userid' => $this->user);
	    $this->db->like(array('name' => self::DB_FIELD_NAME_FOR_CHECKED_fields))->delete('hotelix_interface_config', $where_arr);
	    return;
	}
	
	public function get_fields_clts() {
	    $clts = array();
	    $clts ['number'] = '#';
	    $clts ['reservation_id'] = '{caption_order}';
	    $clts ['cat_room_name'] = '{caption_room} ({caption_category})';
	    $clts ['cat_name'] = '{caption_category}';
	    $clts ['room_name'] = '{caption_room}';
	    $clts ['guest_name'] = '{caption_guest}';
	    $clts ['user_name'] = '{caption_assignedto}';
	    $clts ['base_places'] = '{caption_rlist_baseplaces}';
	    $clts ['additional_places'] = '{caption_rlist_additional_places}';
	    $clts ['baby_places'] = '{caption_rlist_baby_places}';
	    $clts ['dealer'] = '{caption_dealer}';
	    $clts ['rate_name'] = '{caption_rate}';
	    $clts ['status_name'] = '{caption_status}';
	    $clts ['datein'] = '{caption_checkin}';
	    $clts ['duration'] = '{caption_days}';
	    $clts ['dateout'] = '{caption_checkout}';
	    $clts ['amount'] = '{caption_sum}';
	    $clts ['discount'] = '{caption_discount}';
	    $clts ['pay_amount'] = '{caption_paid}';
	    $clts ['balance'] = '{caption_balance}';
	    $clts ['date'] = '{caption_date}';
	    $clts ['phone'] = '{caption_phone}';
	    $clts ['email'] = '{caption_email}';
	    return $clts;
	}
	
	public function get_fields_tbl_th_classes() {
	    $th_classes ['number'] = '';
	    $th_classes ['reservation_id'] = '';
	    $th_classes ['cat_room_name'] = '';
	    $th_classes ['cat_name'] = '';
	    $th_classes ['room_name'] = '';
	    $th_classes ['guest_name'] = '';
	    $th_classes ['user_name'] = '';
	    $th_classes ['base_places'] = '';
	    $th_classes ['additional_places'] = '';
	    $th_classes ['baby_places'] = '';
	    $th_classes ['dealer'] = '';
	    $th_classes ['rate_name'] = '';
	    $th_classes ['status_name'] = '';
	    $th_classes ['datein'] = '';//text_nowrap
	    $th_classes ['duration'] = '';
	    $th_classes ['dateout'] = '';//text_nowrap
	    $th_classes ['amount'] = 'text-right';
	    $th_classes ['discount'] = 'text-right';
	    $th_classes ['pay_amount'] = 'text-right';
	    $th_classes ['balance'] = 'text-right';
	    $th_classes ['date'] = 'text-right';
	    $th_classes ['phone'] = 'text-right';
	    $th_classes ['email'] = 'text-right';
	    return $th_classes;
	}
	
	public function get_default_search_items_values() {
	    $items = (object)array();
	    $items->date_range->val = date('Y-m-d', strtotime('-'.self::DATE_RANGE_DAYS_PAST.'days')).' - '.date('Y-m-d');
	    $items->date_type->val = 2;//create date
	    $items->statuses->val = $this->get_default_selected_statuses();
	    $items->categories->val = $this->get_default_selected_categories();
	    $items->rate->val = '';
	    $items->intgroupid->val = '';
	    $items->room->val = '';
	    $items->dealer->val = '';
	    $items->discount->val = '';
	    $items->negative_balance->val = false;
	    $items->not_confirmed->val = false;
	    $items->bso->val = false;
	    $items->user->val = $this->user;
	    
	    return $items;
	}
		
	public function get_search_items_values($p = array('return' => 'object')) {
	    $items = array();
	    foreach ($this->search_items_set as $search_item) {
	        if (isset($this->search_items->$search_item->val)) {
	            $items[$search_item] = $this->search_items->$search_item->val;
	        }
	    }
	    return isset($p['return']) && $p['return'] == 'array' ? $items : (object)$items;
	}
	
	public function set_search_items_values($p = array()) {
	    $search_items = &$this->search_items;
	    if (isset($p['reset_search_form']) && $p['reset_search_form']) {
	        $search_items = $this->get_default_search_items_values();
	    }else {
	        foreach ($search_items as $item_name => $item_data) {
	            if (isset($p[$item_name])) {
	                $item_data->val = $p[$item_name];
	            }
	        }
	    }
	}
	
	public function get_default_selected_statuses() {// робимо вибраними сатуси типу 1
	    $selected = array();
	    $all_statuses = $this->htmltpl->get_all_statuses_from_db ();
	    foreach ( $all_statuses as $status_id => $status_data ) {
	        if ($status_data ['type'] == 1) {
	            $selected [$status_id] = $status_id;
	        }
	    }
	    return $selected;
	}
	
	public function get_default_selected_categories() {// робимо вибраними тільки активні категорії
        $selected = array();
        $all_categories = $this->htmltpl->get_all_categories_from_db ();
        foreach ( $all_categories as $category_id => $category_data ) {
            if ($category_data ['is_active']) {
                $selected[$category_id] = $category_id;
            }
        }
	    return $selected;
	}
	
	public $sortby = array();
	
	
	private function init_sortby_values () {
	    $this->sortby = json_decode(json_encode($this->get_default_sortby_values()));
	}
	
	public function set_sortby_values ($p = array()) {
	    $sortby = &$this->sortby;
	    foreach ($sortby as $name => $value) {
	        if (isset($p[$name])) {
	            $sortby->$name = $p[$name];
	        }
	    }
	}
	
	public function get_sortby_values ($p = array('return' => 'object')) {
	    return isset($p['return']) && $p['return'] == 'array' ? (array)$this->sortby : $this->sortby;
	}
	
	public function get_default_sortby_values () {
	    return array(
	        'field_name' => 'reservation_id',
	        'order' => 'DESC'
	    );
	}
	
	public function get_fields_xls_data() {
	    $fields_set = $this->fields_default_set;
        $fields_set['number'] = array(
            'clt' => '{caption_number}',
            'format' => 'string'
        );
        $fields_set['reservation_id'] = array(
            'clt' => '{caption_order}',
            'format' => 'string',
        );
        $fields_set['cat_room_name'] = array(
            'clt' => '{caption_cat_room_name}',
            'format' => 'string',
        );
        $fields_set['cat_name'] = array(
            'clt' => '{caption_category}',
            'format' => 'string',
        );
        $fields_set['room_name'] = array(
            'clt' => '{caption_room}',
            'format' => 'string',
        );
        $fields_set['guest_name'] = array(
            'clt' => '{caption_guest}',
            'format' => 'string',
        );
        $fields_set['user_name'] = array(
            'clt' => '{caption_assignedto}',
            'format' => 'string',
        );
        $fields_set['base_places'] = array(
            'clt' => '{caption_base_places}',
            'format' => 'string',
        );
        $fields_set['additional_places'] = array(
            'clt' => '{caption_additional_places}',
            'format' => 'string',
        );
        $fields_set['baby_places'] = array(
            'clt' => '{caption_baby_places}',
            'format' => 'string',
        );
        $fields_set['dealer'] = array(
            'clt' => '{caption_istochnik}',
            'format' => 'string',
        );
        $fields_set['rate_name'] = array(
            'clt' => '{caption_price_type}',
            'format' => 'string',
        );
        $fields_set['status_name'] = array(
            'clt' => '{caption_status}',
            'format' => 'string',
        );
        $fields_set['datein'] = array(
            'clt' => '{caption_checkin}',
            'format' => 'date',
        );
        $fields_set['duration'] = array(
            'clt' => '{caption_days}',
            'format' => 'string',
        );
        $fields_set['dateout'] = array(
            'clt' => '{caption_checkout}',
            'format' => 'date',
        );
        $fields_set['amount'] = array(
            'clt' => '{caption_sum}',
            'format' => '#,##0.00',
        );
        $fields_set['discount'] = array(
            'clt' => '{caption_discount}',
            'format' => '#,##0.00',
        );
        $fields_set['pay_amount'] = array(
            'clt' => '{caption_pay_amount}',
            'format' => '#,##0.00',
        );
        $fields_set['balance'] = array(
            'clt' => '{caption_balance}',
            'format' => '#,##0.00',
        );
        $fields_set['date'] = array(
            'clt' => '{caption_createdate}',
            'format' => 'datetime',
        );
        $fields_set['phone'] = array(
            'clt' => '{caption_phone}',
            'format' => 'string',
        );
        $fields_set['email'] = array(
            'clt' => '{caption_email}',
            'format' => 'string',
        );
        return $fields_set;
	}
	
	public function get_money_fields() {
	    return $this->money_fields;
	}
	
}