<?php
class formsprinter_model_v2 extends CI_Model {
	function __construct() {
		parent::__construct ();

		$this->load->model ( 'frontdesk' );
		$this->load->model ( 'fms_core' );
		$this->load->model ( 'hotelix_config' );
		$this->load->model ( 'internationalfields' );
		$this->load->model ( 'mcustomers' );
		$this->load->model ( 'mlanguages' );
		$this->load->model ( 'mpartners' );
	}

	function get_template_list($data){
	    $template_list = array();
	    $global_country = $this->hotelix_config->get_record("global_country");

	    $sql = "
(SELECT id, name, use_us, 'local' as location_type, is_prepayment FROM templates WHERE isactive = 1 AND id_area = ".$data["id_area"].")
UNION
(SELECT id, name, use_us, 'global' as location_type, is_prepayment FROM global_hotelix_common.templates
INNER JOIN global_hotelix_common.templates2countries ON global_hotelix_common.templates2countries.template_id = global_hotelix_common.templates.id
INNER JOIN templates_glolal_activity ON global_hotelix_common.templates.id = templates_glolal_activity.global_template_id
WHERE templates_glolal_activity.isactive = 1 AND global_hotelix_common.templates.isactive = 1
AND id_area = ".$data["id_area"]." AND global_hotelix_common.templates2countries.country_code LIKE '".$global_country."')";
// 	    echo $sql;
// 	    die();
	    $query = $this->db->query ( $sql );
	    $i = 0;
	    foreach ( $query->result () as $row ) {
	       $template_list[$i]["template_id"] = $row->id;
	       $template_list[$i]["template_name"] = $row->name;
	       $template_list[$i]["template_use_us"] = $row->use_us;
	       $template_list[$i]["template_location_type"] = $row->location_type;
	       $template_list[$i]["template_is_prepayment"] = $row->is_prepayment;
	       $i++;
	    }

	    return $template_list;
	}

	function get_order_data_v2($reservation_id, $guest_id = 0, $services = array(), $template_language = "", $pay_amount = "") {
	    $template_language_code_int = @($this->db->
	        get_where("`global_hotelix_languages`.`localization`", array('code' => $template_language))->row()->code_int);
	    $data = array();
	    $host = "";
	    if (isset($_SERVER["HTTP_HOST"])) {
	        $host = $_SERVER["HTTP_HOST"];
	    }
	     
	    $user_language_code = $this->mlanguages->get_user_lang_code();
	     
	    $hms_hotel_id = $this->config->item ( 'hotel_id' );
	    $wifi_hotspot_name = $this->hotelix_config->get_record("wifi_hotspot_name", "str");
	    // 	    echo $wifi_hotspot_name;
	    // 	    die();
	    $data ["fpl_hotspot_name"] = $wifi_hotspot_name;
	    if($guest_id <> 0){
	        $guest_sql = " INNER JOIN guests ON guests.id = ".$guest_id;
	    }else{
	        $guest_sql = " INNER JOIN guests ON deskofreservation.guest_id = guests.id ";
	    }
	
	    $legalsystem = $this->frontdesk->getlegalsystem();
	    $legalsystem_db = $this->frontdesk->getlegalsystem_db($legalsystem);
	    $dict_entrygoal_mass = $this->fms_core->get_dict_entrygoal($legalsystem_db);
	    $dict_documenttype_mass = $this->fms_core->get_dict_documenttype($legalsystem_db);
	
	    $doc_types = array ();
	    $query = $this->db->query ( "SELECT * FROM doc_types" );
	    foreach ( $query->result () as $row ) {
	        $doc_types[$row->id] = $row->name;
	    }
	    $folio_eventst = array();
	    $custom_ServicesList = array();
	    $ServicesList = array();
	    $vat_block = array();
	     
	    $s_counter = 1;
	    $cs_counter = 1;
	    $services_summ = 0;
	    $services_all_summ_nds_amount = 0; // sum for all services
	    $checked_services_summ = 0;
	    $summ_nds_amount = 0; // sum for custom services
	    $sql = "SELECT deskofreservation.id as res_id, services_types.tax, services_types.id as servace_type_id,
	    services_types.name as services_name, dealers.name as s_dealer,
	    services.id as services_id, services.action_time as services_action_time,
	    services.count as services_count, services.description as services_description,
	    services.time as services_time, services.amount, services.price, rooms.name as room_name,
	    categories.name as categories_name, services.time as service_create_time, measurements.name as services_measurement_name
	    FROM deskofreservation
	    INNER JOIN rooms ON rooms.id=deskofreservation.room_id
	    INNER JOIN categories ON categories.id=rooms.category_id
	    INNER JOIN services ON services.reservation_id = deskofreservation.id
	    INNER JOIN  services_types ON services_types.id = services.type
	    LEFT JOIN  measurements ON measurements.id = services_types.measurement_id
	    LEFT JOIN dealers ON dealers.id=services.id_dealer
	    WHERE deskofreservation.id = ".$reservation_id."
				ORDER by services.action_time ASC";
	    // 	    echo $sql;
	    // 	    die();
	
	    $query2 = $this->db->query ( $sql );
	    foreach ( $query2->result () as $row2 ) {
	        $service_name_str = "";
	        $service_name = $this->internationalfields->get_value("service", $row2->servace_type_id, "international_name");
	        if (isset($service_name [$template_language_code_int])){
	            $service_name_str = $service_name [$template_language_code_int];
	        }
	
	        if(isset($services["service"][$row2->services_id])){
	            array_push ( $custom_ServicesList, array (
	                'fpl_services_type' => "service",
	                'fpl_services_id' => $row2->services_id,
	                'fpl_services_name' => $service_name_str,
	                'fpl_taxes_fees_id' => 0,
	                'fpl_services_action_time' => $this->frontdesk->systemdateformat($row2->services_action_time),
	                'fpl_service_create_time' => $this->frontdesk->systemdateformat($row2->service_create_time),
	                'fpl_services_services_count' => $row2->services_count,
	                'fpl_services_measure' => $this->mlanguages->getdictionaryword("tbl_measurements",
	                    $template_language, $row2->services_measurement_name),
	                'fpl_s_dealer' => $row2->s_dealer,
	                'fpl_servicesamount' => $this->frontdesk->showcurrency ( $row2->amount ),
	                'fpl_servicesamount_perunit' => $this->frontdesk->showcurrency ( $row2->price ),
	                'fpl_custom_servicesList_vat' => $this->frontdesk->showcurrency ( ($row2->amount/100) * $row2->tax ),
	                'fpl_custom_servicesList_vat_percent' => $row2->tax,
	
	                'fpl_servicesamount_perunit_before_vat' => $this->frontdesk->showcurrency ( $row2->price - ($row2->price/100) * $row2->tax ),
	                'fpl_servicesamount_before_vat' => $this->frontdesk->showcurrency ( $row2->amount - ($row2->amount/100) * $row2->tax ),
	
	                'fpl_counter' => $cs_counter,
	                'fpl_services_description' => $row2->services_description
	            ) );
	            $cs_counter++;
	            $checked_services_summ += $row2->amount;
	
	            $summ_nds_amount += ($row2->amount/100) * $row2->tax;
	        }
	        array_push ( $ServicesList, array (
	            'fpl_services_id' => $row2->services_id,
	            'fpl_services_name' => $service_name_str,
	            'fpl_taxes_fees_id' => 0,
	            'period_tf_type' => 0,
	            'fpl_services_action_time_standart_dateformat' => $row2->services_action_time,
	            'fpl_services_action_time' => $this->frontdesk->systemdateformat($row2->services_action_time),
	            'fpl_service_create_time' => $this->frontdesk->systemdateformat($row2->service_create_time),
	            'fpl_services_services_count' => $row2->services_count,
	            'fpl_services_measure' => $this->mlanguages->getdictionaryword("tbl_measurements",
	                $template_language, $row2->services_measurement_name),
	            'fpl_s_dealer' => $row2->s_dealer,
	            'fpl_servicesamount' => $this->frontdesk->showcurrency ( $row2->amount ),
	            'fpl_servicesamount_perunit' => $this->frontdesk->showcurrency ( $row2->price ),
	            'fpl_servicesamount_no_format' => $row2->amount,
	            'fpl_servicesamount_perunit_no_format' => $row2->price,
	            'fpl_counter' => $s_counter,
	            'fpl_services_description' => $row2->services_description,
	            'fpl_event_description' => $row2->services_description,
	        ) );
	        array_push ( $folio_eventst, array (
	            'fpl_event_date' => $this->frontdesk->systemdateformat($row2->service_create_time),
	            'fpl_event_name' => $row2->services_name,
	            'fpl_event_description' => $row2->services_description,
	            'fpl_event_charge' => $row2->amount,
	            'fpl_event_credit' => 0,
	        ) );
	        $amount_without_vat = ($row2->amount/(100+$row2->tax)) * 100;
	        $amount_vat = ($amount_without_vat / 100) * $row2->tax;
	        array_push ( $vat_block, array (
	            'fpl_vat_rate' => $row2->tax,
	            'fpl_net_value' => $amount_without_vat,
	            'fpl_vat_value' => $amount_vat,
	            'fpl_brutto_value' => $row2->amount
	        ) );
	
	        $services_summ += $row2->amount;
	        $services_all_summ_nds_amount += ($row2->amount/100) * $row2->tax;
	        $s_counter++;
	
	    }
	     
	    // get taxes & fees services START
	    //if($this->config->item('taxes2_fees_new') == 1){
	    $sql = "SELECT deskofreservation.id as res_id,
	    taxes_fees2property.name as services_name, '' as s_dealer,
	    services_tf.id as services_id, '' as services_action_time,
	    1 as services_count, '' as services_description,
	    '' as services_time, services_tf.value as amount, services_tf.value as price, rooms.name as room_name,
	    categories.name as categories_name, '' as service_create_time, '' as services_measurement_name,
	    taxes_fees2property.period_type, services_tf.taxes_fees_id, taxes_fees2property.vat_value, taxes_fees2property.type_id
	    FROM deskofreservation
	    INNER JOIN rooms ON rooms.id=deskofreservation.room_id
	    INNER JOIN categories ON categories.id=rooms.category_id
	    INNER JOIN services_tf ON services_tf.reservation_id = deskofreservation.id
	    INNER JOIN taxes_fees2property ON services_tf.taxes_fees_id = taxes_fees2property.id
	    LEFT JOIN  taxes_fees2property_link ON  taxes_fees2property_link.property_id = categories.property_id AND  taxes_fees2property_link.taxes_fees_id = taxes_fees2property.id
	    WHERE deskofreservation.id = ".$reservation_id;
	    //LEFT JOIN taxes_fees2property ON taxes_fees2property.property_id = categories.property_id AND taxes_fees2property.taxes_fees_id = taxes_fees.id
	    // 	        	    echo $sql;
	    // 	        	    print_r($services["service"]);
	    // 	        	    die();
	    $query2 = $this->db->query ( $sql );
	    foreach ( $query2->result () as $row2 ) {
	        $service_name = $this->internationalfields->get_value("service", $row2->services_id, "international_name");
	         
	        if(isset($services["service_tf"][$row2->services_id])){
	            array_push ( $custom_ServicesList, array (
	                'fpl_services_type' => "service",
	                'fpl_services_id' => $row2->services_id,
	                //'fpl_services_name' => $this->mlanguages->getdictionaryword ( "tbl_fee_tax_policies_new", '', '{-'.$row2->services_name.'-}' ),
	                'fpl_services_name' => $row2->services_name,
	                'fpl_taxes_fees_id' => $row2->taxes_fees_id,
	                'fpl_services_action_time' => $this->frontdesk->systemdateformat($row2->services_action_time),
	                'fpl_service_create_time' => $this->frontdesk->systemdateformat($row2->service_create_time),
	                'fpl_services_services_count' => $row2->services_count,
	                'fpl_services_measure' => $this->mlanguages->getdictionaryword("tbl_measurements",
	                    $template_language, $row2->services_measurement_name),
	                'fpl_s_dealer' => $row2->s_dealer,
	                'fpl_servicesamount' => $this->frontdesk->showcurrency ( $row2->amount ),
	                'fpl_servicesamount_perunit' => $this->frontdesk->showcurrency ( $row2->price ),
	                'fpl_custom_servicesList_vat' => 0,
	                'fpl_custom_servicesList_vat_percent' => 0,
	                 
	                'fpl_servicesamount_perunit_before_vat' => 0,
	                'fpl_servicesamount_before_vat' => 0,
	                 
	                'fpl_counter' => $cs_counter,
	                'fpl_services_description' => $row2->services_description
	            ) );
	            $cs_counter++;
	            $checked_services_summ += $row2->amount;
	             
	            $summ_nds_amount += 0;
	        }
	         
	        $period_type = 0;
	        if($row2->period_type != NULL){
	            $period_type = $row2->period_type;
	        }
	         
	        array_push ( $ServicesList, array (
	            'fpl_services_id' => $row2->services_id,
	            'fpl_services_name' => $row2->services_name,
	            'fpl_taxes_fees_id' => $row2->taxes_fees_id,
	            'period_tf_type' => $period_type,
	            'fpl_services_action_time_standart_dateformat' => $row2->services_action_time,
	            'fpl_services_action_time' => $this->frontdesk->systemdateformat($row2->services_action_time),
	            'fpl_service_create_time' => $this->frontdesk->systemdateformat($row2->service_create_time),
	            'fpl_services_services_count' => $row2->services_count,
	            'fpl_services_measure' => $this->mlanguages->getdictionaryword("tbl_measurements",
	                $template_language, $row2->services_measurement_name),
	            'fpl_s_dealer' => $row2->s_dealer,
	            'fpl_servicesamount' => $this->frontdesk->showcurrency ( $row2->amount ),
	            'fpl_servicesamount_perunit' => $this->frontdesk->showcurrency ( $row2->price ),
	            'fpl_servicesamount_no_format' => $row2->amount,
	            'fpl_servicesamount_perunit_no_format' => $row2->price,
	            'fpl_counter' => $s_counter,
	            'fpl_services_description' => $row2->services_description,
	            'fpl_event_description' => $row2->services_description,
	        ) );
	        array_push($folio_eventst, array(
	            'fpl_event_date' => $this->frontdesk->systemdateformat($row2->service_create_time),
	            'fpl_event_name' => $row2->services_name,
	            'fpl_event_description' => $row2->services_description,
	            'fpl_event_charge' => $row2->amount,
	            'fpl_event_credit' => 0
	        ));
	
	        if ($row2->type_id == 2) {
	            $amount_without_vat = ($row2->amount / (100 + $row2->vat_value)) * 100;
	            $amount_vat = ($amount_without_vat / 100) * $row2->vat_value;
	            array_push($vat_block, array(
	                'fpl_vat_rate' => $row2->vat_value,
	                'fpl_net_value' => $amount_without_vat,
	                'fpl_vat_value' => $amount_vat,
	                'fpl_brutto_value' => $row2->amount
	            ));
	        }
	        $services_summ += $row2->amount;
	        
	        $s_counter++;
	         
	    }
	    //}
	    // get taxes & fees services END
	
	    $url_to_booking_page = "";
	    $query2 = $this->db->query ( "SELECT url_to_booking_page FROM online_options WHERE 1" );
	     
	    if ($query2->num_rows () > 0) {
	        $row2 = $query2->row ();
	        if($row2->url_to_booking_page == ""){
	            $is_origin = true;
	            $host = $this->releases->get_company_host($is_origin);
	            
	            $url_to_booking_page = "https://book-".$host."/";
	        }else{
	            $url_to_booking_page = $row2->url_to_booking_page;
	        }
	    }
	    $data ["url_to_booking_page"] = $url_to_booking_page;
	     
	    //=============================================================================================
	    //=============================================================================================
	    //=============================================================================================
	    $paymentList = array();
	    $paid_sum = 0;
	    $sql = "SELECT payment_types.name, payment.create_time, bso_records.id as bso_id,
	    payment.description, payment.amount as total, payment.id as id_payment,
	    rooms.name as room_name, categories.name as categories_name, checkprn_gate.checkstatus,
	    checkprn_gate.id as checkprn_id, bso_records.code as bso_code, bso_records.number as bso_number
	    FROM deskofreservation
	
	    INNER JOIN rooms ON rooms.id=deskofreservation.room_id
	    INNER JOIN categories ON categories.id=rooms.category_id
	    INNER JOIN payment ON payment.reservation_id = deskofreservation.id
	    LEFT JOIN checkprn_gate ON checkprn_gate.payment_id = payment.id
	    LEFT JOIN  bso_records ON  bso_records.payment_id = payment.id
	    INNER JOIN payment_types ON payment_types.id = payment.type
	    WHERE deskofreservation.id = ".$reservation_id." ";
	    $query2 = $this->db->query ( $sql );
	
	    foreach ( $query2->result () as $row2 ) {
	        $paid_sum += $row2->total;
	        array_push ( $paymentList, array (
	            'fpl_typename' => $row2->name,
	            'fpl_total' => $this->frontdesk->showcurrency ( $row2->total ),
	            'fpl_pay_description' => $row2->description,
	            'fpl_event_description' => $row2->description,
	            'fpl_type' => $row2->categories_name,
	            'fpl_create_time_standart_dateformat' => $row2->create_time,
	            'fpl_create_time' => $this->frontdesk->systemdateformat($row2->create_time),
	            'fpl_bso_code' => $row2->bso_code,
	            'fpl_bso_number' => $row2->bso_number
	        ) );
	        array_push ( $folio_eventst, array (
	            'fpl_event_date' => $this->frontdesk->systemdateformat($row2->create_time),
	            'fpl_event_name' => $row2->name,
	            'fpl_event_description' => $row2->description,
	            'fpl_event_charge' => 0,
	            'fpl_event_credit' => $row2->total,
	        ) );
	    }
	    //=============================================================================================
	    $rates = array ();
	    $query = $this->db->query ( "SELECT * FROM rate WHERE isactive = 1" );
	    foreach ( $query->result () as $row ) {
	        $rates [$row->id] = $row->caption;
	    }
	    //=============================================================================================
	    $service_main_ismanual = 0;
	    $query2 = $this->db->query ( "SELECT * FROM services_main WHERE reservation_id = " . $reservation_id );
	
	    if ($query2->num_rows () > 0) {
	        $row2 = $query2->row ();
	        $service_main_ismanual = $row2->ismanual;
	
	    }
	    //=============================================================================================
	    $ud_price_category = 0;
	    $query2 = $this->db->query ( "SELECT ud_price_category FROM deskofreservation WHERE id = " . $reservation_id );
	
	    if ($query2->num_rows () > 0) {
	        $row2 = $query2->row ();
	        $ud_price_category = $row2->ud_price_category;
	
	    }
	
	    //=============================================================================================
	    $categories_names = array();
	    $sql = "SELECT id, shortname FROM categories";
	    $query2 = $this->db->query ( $sql );
	
	    foreach ( $query2->result () as $row2 ) {
	        $categories_names [$row2->id] = $row2->shortname;
	    }
	    //=============================== tarification =========================================
	
	    $data_tarification = array();
	    $data_tarification["rates"] = array();
	    $deskofdays_prices = $this->frontdesk->getdeskofdays_price ( $reservation_id );
	    $seasons_statistics = $this->frontdesk->getpricecalculation ( 0, $reservation_id, 0, 1 );
	    //print_r($deskofdays_prices);
	    if ($seasons_statistics == 0) {
	    } else {
	        $i = 0;
	        foreach ( $deskofdays_prices as $intdate => $cell ) {
	            $type_place = "";
	            if (isset ( $seasons_statistics [$intdate] ["season_id"] )) {
	                $season_id = $seasons_statistics [$intdate] ["season_id"];
	
	                if(isset($rates [$seasons_statistics [$intdate] ["price_type"]])){
	                    $rate_name = $rates [$seasons_statistics [$intdate] ["price_type"]];
	                }else{
	                    $rate_name = "";
	                }
	                if (isset ( $seasons_statistics [$intdate] ["season_id"] )) {
	                    switch ($service_main_ismanual) {
	                        case 0 :
	                            $data_tarification ["rates"] [$i] ["fpl_rate_strategy"] = $rate_name;
	                            break;
	                        case 1 :
	                            $data_tarification ["rates"] [$i] ["fpl_rate_strategy"] = "{mlw_cost_fixed}";
	                            break;
	                        case 2 :
	                            $data_tarification ["rates"] [$i] ["fpl_rate_strategy"] = "{mlw_cost_daily}";
	                            break;
	                        default :
	                            $data_tarification ["rates"] [$i] ["fpl_rate_strategy"] = $rate_name;
	                            break;
	                    }
	                }
	                if (isset ( $deskofdays_prices [$intdate] )) {
	                    if (isset ( $seasons_statistics [$intdate] ["season_id"] )) {
	                        $data_tarification ["rates"] [$i] ["fpl_day_price"] = $this->frontdesk->showcurrency ( $deskofdays_prices [$intdate] ["price"] );
	                    } else {
	                        $data_tarification ["rates"] [$i] ["fpl_day_price"] = $this->frontdesk->showcurrency ( $deskofdays_prices [$intdate] ["price"] );
	                    }
	                } else {
	                    $data_tarification ["rates"] [$i] ["fpl_day_price"] = "";
	                }
	                $data_tarification ["rates"] [$i] ["fpl_day_rate"] = $rate_name;
	                if(isset($categories_names[$ud_price_category])){
	                    $data_tarification ["rates"] [$i] ["fpl_rate_taken"] = $categories_names[$ud_price_category];
	                }else{
	                    $data_tarification ["rates"] [$i] ["fpl_rate_taken"] = "";
	                }
	
	                $i++;
	            }
	        }
	    }
	
	
	
	    //=============================================================================================
	    //=============================================================================================
	    //=============================================================================================
	    $ServicesMainList = array();
	    $sql = "SELECT deskofreservation.id as res_id, deskofreservation.duration,
	    services_types_main.name as services_name, services_main.id as services_id, services_types_main.tax,
	    dealers.name as sm_dealer,services_main.description as services_main_description,
	    services_main.time as services_time, services_main.amount, services_main.time as service_create_time,
	    services_main.type, measurements.name as services_measurement_name, services_types_main.id as service_type_main_id
	    FROM deskofreservation
	    INNER JOIN rooms ON rooms.id=deskofreservation.room_id
	    INNER JOIN categories ON categories.id=rooms.category_id
	    INNER JOIN services_main ON services_main.reservation_id = deskofreservation.id
	    INNER JOIN  services_types_main ON  services_types_main.id = services_main.type
	    LEFT JOIN  measurements ON measurements.id = services_types_main.measurement_id
	    LEFT JOIN dealers ON dealers.id=services_main.id_dealer
	    WHERE services_main.type = 2
	    AND deskofreservation.id = ".$reservation_id." ORDER by deskofreservation.id ASC";
	    // 	    echo $sql;
	    // 	    die();
	    $query2 = $this->db->query ( $sql );
	    $cancelation_payment_sum = 0;
	    $cancel_accommodation_penalty_amount = 0;
	    foreach ( $query2->result () as $row2 ) {
	        $query_pay = $this->db->query ( "SELECT check_payment_items.*
	                                         FROM check_payment_items
	                                         INNER JOIN payment ON payment.id = check_payment_items.check_payment_id
	                                         INNER JOIN services_main ON services_main.id = check_payment_items.item_id
	                                         WHERE check_payment_items.reservation_id = ".$reservation_id." AND check_payment_items.item_id = $row2->services_id
	            AND check_payment_items.item_service_table_id = 2" );
	        $pay_status = "-";
	        if ($query_pay->num_rows () > 0) {
	            $pay_status = "Да";
	        }
	        $cancelation_payment_sum += $row2->amount;
	         
	        $service_name = $this->internationalfields->get_value("service_main", $row2->service_type_main_id, "international_name");
	         
	        if(isset($services["main_service"][$row2->services_id])){
	            array_unshift ( $custom_ServicesList, array (
	                'fpl_services_type' => "main_service",
	                'fpl_services_id' => $row2->services_id,
	                'fpl_services_name' => $service_name[$template_language_code_int],
	                'fpl_services_type' => $row2->type,
	                'fpl_services_action_time' => "",
	                'fpl_service_create_time' => $this->frontdesk->systemdateformat($row2->service_create_time),
	                'fpl_services_services_count' => $row2->duration,
	                'fpl_services_measure' => $this->mlanguages->getdictionaryword("tbl_measurements",
	                    $template_language, $row2->services_measurement_name),
	                'fpl_s_dealer' => $row2->sm_dealer,
	                'fpl_servicesamount' => $this->frontdesk->showcurrency ( $row2->amount ),
	                'fpl_servicesamount_perunit' => $this->frontdesk->showcurrency ( $row2->amount ),
	                'fpl_custom_servicesList_vat' => $this->frontdesk->showcurrency ( ($row2->amount/100) * $row2->tax ),
	                'fpl_custom_servicesList_vat_percent' => $row2->tax,
	
	                'fpl_servicesamount_perunit_before_vat' => $this->frontdesk->showcurrency ( $row2->amount - ($row2->amount/100) * $row2->tax ),
	                'fpl_servicesamount_before_vat' => $this->frontdesk->showcurrency ( $row2->amount - ($row2->amount/100) * $row2->tax ),
	
	                'fpl_counter' => $cs_counter,
	                'fpl_services_description' => $row2->services_main_description,
	                 
	            ) );
	            $cs_counter++;
	            $checked_services_summ += $row2->amount;
	
	            $summ_nds_amount += ($row2->amount/100) * $row2->tax;
	        }
	        array_push ( $ServicesMainList, array (
	            'fpl_pay_status' => $pay_status,
	            'fpl_services_id' => $row2->services_id,
	            'fpl_services_name' => $service_name[$template_language_code_int],
	            'fpl_services_type' => $row2->type,
	            'fpl_s_dealer' => $row2->sm_dealer,
	            'fpl_services_action_time' => "",
	            'fpl_service_create_time' => $this->frontdesk->systemdateformat($row2->service_create_time),
	            'fpl_services_services_count' => $row2->duration,
	            'fpl_services_measure' => $this->mlanguages->getdictionaryword("tbl_measurements",
	                $template_language, $row2->services_measurement_name),
	            'fpl_servicesamount' => $this->frontdesk->showcurrency ( $row2->amount ),
	            'fpl_servicesamount_perunit' => $this->frontdesk->showcurrency ( $row2->amount ),
	            'fpl_counter' => $s_counter,
	            'fpl_services_description' => $row2->services_main_description,
	            'fpl_event_description' => $row2->services_main_description,
	        ) );
	        array_push ( $folio_eventst, array (
	            'fpl_event_date' => $this->frontdesk->systemdateformat ( $row2->service_create_time ),
	            'fpl_event_name' => $service_name[$template_language_code_int],
	            'fpl_event_description' => $row2->services_main_description,
	            'fpl_event_charge' => $row2->amount,
	            'fpl_event_credit' => 0
	        ) );
	
	        $amount_without_vat = ($row2->amount/(100+$row2->tax)) * 100;
	        $amount_vat = ($amount_without_vat / 100) * $row2->tax;
	        array_push ( $vat_block, array (
	            'fpl_vat_rate' => $row2->tax,
	            'fpl_net_value' => $amount_without_vat,
	            'fpl_vat_value' => $amount_vat,
	            'fpl_brutto_value' => $row2->amount
	        ) );
	        	
	        $services_summ += $row2->amount;
	        $services_all_summ_nds_amount += ($row2->amount/100) * $row2->tax;
	        $s_counter++;
	    }
	    //=============================================================================================
	    //=============================================================================================
	    //=============================================================================================
	    $query2 = $this->db->query ( "SELECT deskofreservation.id as res_id, deskofreservation.duration,
	        services_types_main.name as services_name, services_main.id as services_id, services_types_main.tax,
	        dealers.name as sm_dealer, services_main.description as services_main_description,
	        services_main.time as services_time, services_main.amount, services_main.time as service_create_time,
	        services_types_main.id as main_type_id, measurements.name as services_measurement_name, services_types_main.id as service_type_main_id
	    	FROM deskofreservation
	        INNER JOIN rooms ON rooms.id=deskofreservation.room_id
	        INNER JOIN categories ON categories.id=rooms.category_id
	        INNER JOIN services_main ON services_main.reservation_id = deskofreservation.id
	        INNER JOIN  services_types_main ON  services_types_main.id = services_main.type
	        LEFT JOIN  measurements ON measurements.id = services_types_main.measurement_id
	        LEFT JOIN dealers ON dealers.id=services_main.id_dealer
	        WHERE (services_main.type = 1 OR services_main.type = 3 OR services_main.type = 4 OR services_main.type = 5) AND
	        deskofreservation.id = ".$reservation_id." ORDER by deskofreservation.id ASC" );
	    foreach ( $query2->result () as $row2 ) {
	         
	        if ($row2->main_type_id == 1){//проживання
	            $cancel_accommodation_penalty_amount = $row2->amount;
	            //echo "===".$cancel_accommodation_penalty_amount."===";
	            //die ('<br>DIED by Y Development Department of HMS IT TEAM<br>10 дек. 2019 г.  12:58:09 <br>formsprinter_model_v2.php');
	        }
	         
	        $service_name = $this->internationalfields->get_value("service_main", $row2->main_type_id, "international_name");
	        $fpl_services_name = '';
	        if(isset($service_name[$template_language_code_int])){
	            $fpl_services_name = $service_name[$template_language_code_int];
	        }
	        if(isset($services["main_service"][$row2->services_id])){
	            array_unshift ( $custom_ServicesList, array (
	                'fpl_services_type' => "main_service",
	                'fpl_services_id' => $row2->services_id,
	                'fpl_services_name' => $fpl_services_name,
	                'fpl_services_type' => $row2->main_type_id,
	                'fpl_services_action_time' => "",
	                'fpl_service_create_time' => $this->frontdesk->systemdateformat($row2->service_create_time),
	                'fpl_services_services_count' => $row2->duration,
	                'fpl_services_measure' => $this->mlanguages->getdictionaryword("tbl_measurements",
	                    $template_language, $row2->services_measurement_name),
	                'fpl_s_dealer' => $row2->sm_dealer,
	                'fpl_servicesamount' => $this->frontdesk->showcurrency ( $row2->amount ),
	                'fpl_servicesamount_perunit' => $this->frontdesk->showcurrency ( $row2->amount /$row2->duration  ),
	                'fpl_custom_servicesList_vat' => $this->frontdesk->showcurrency ( ($row2->amount/100) * $row2->tax ),
	                'fpl_custom_servicesList_vat_percent' => $row2->tax,
	
	                'fpl_servicesamount_perunit_before_vat' => $this->frontdesk->showcurrency ( $row2->amount - ($row2->amount/100) * $row2->tax ),
	                'fpl_servicesamount_before_vat' => $this->frontdesk->showcurrency ( $row2->amount - ($row2->amount/100) * $row2->tax ),
	
	                'fpl_counter' => $cs_counter,
	                'fpl_services_description' => $row2->services_main_description
	            ) );
	            $cs_counter++;
	            $checked_services_summ += $row2->amount;
	
	            $summ_nds_amount += ($row2->amount/100) * $row2->tax;
	        }
	        array_push ( $ServicesMainList, array (
	            'fpl_services_id' => $row2->services_id,
	            'fpl_services_name' => $fpl_services_name,
	            'fpl_services_type' => $row2->main_type_id,
	            'fpl_s_dealer' => $row2->sm_dealer,
	            'fpl_services_action_time' => "",
	            'fpl_service_create_time' => $this->frontdesk->systemdateformat($row2->service_create_time),
	            'fpl_services_services_count' => $row2->duration,
	            'fpl_services_measure' => $this->mlanguages->getdictionaryword("tbl_measurements",
	                $template_language, $row2->services_measurement_name),
	            'fpl_servicesamount' => $this->frontdesk->showcurrency ( $row2->amount ),
	            'fpl_servicesamount_perunit' => $this->frontdesk->showcurrency ( $row2->amount ),
	            'fpl_counter' => $s_counter,
	            'fpl_services_description' => $row2->services_main_description,
	            'fpl_event_description' => $row2->services_main_description,
	        ) );
	        array_push ( $folio_eventst, array (
	            'fpl_event_date' => $this->frontdesk->systemdateformat ( $row2->service_create_time ),
	            'fpl_event_name' => $fpl_services_name,
	            'fpl_event_description' => $row2->services_main_description,
	            'fpl_event_charge' => $row2->amount,
	            'fpl_event_credit' => 0
	        ) );
	         
	        $amount_without_vat = ($row2->amount/(100+$row2->tax)) * 100;
	        $amount_vat = ($amount_without_vat / 100) * $row2->tax;
	        array_push ( $vat_block, array (
	            'fpl_vat_rate' => $row2->tax,
	            'fpl_net_value' => $amount_without_vat,
	            'fpl_vat_value' => $amount_vat,
	            'fpl_brutto_value' => $row2->amount
	        ) );
	        $s_counter++;
	    }
	     
	     
	     
	     
	     
	     
	    //=============================================================================================
	    //=============================================================================================
	    //=============================================================================================
	    $RefundList = array();
	    $query2 = $this->db->query ( "SELECT deskofreservation.id as res_id,
	            payment_types.name as payment_name, refund.id as refund_id, refund.time as refund_time,
	            refund.description, refund.amount, rooms.name as room_name,
	            categories.name as categories_name FROM deskofreservation
	
	            INNER JOIN rooms ON rooms.id=deskofreservation.room_id
	            INNER JOIN categories ON categories.id=rooms.category_id
	            INNER JOIN refund ON refund.reservation_id = deskofreservation.id
	            INNER JOIN  payment_types ON  payment_types.id = refund.type
	            WHERE deskofreservation.id = ".$reservation_id." " );
	    foreach ( $query2->result () as $row2 ) {
	
	        array_push ( $RefundList, array (
	            'fpl_refund_id' => $row2->refund_id,
	            'fpl_payment_name' => $row2->payment_name,
	            'fpl_refund_time' => $this->frontdesk->systemdateformat($row2->refund_time),
	            'fpl_refund_time_standart_dateformat' => $row2->refund_time,
	            'fpl_refund_description' => $row2->description,
	            'fpl_event_description' => $row2->description,
	            'fpl_refundamount' => $this->frontdesk->showcurrency ( $row2->amount )
	        ) );
	
	        array_push ( $folio_eventst, array (
	            'fpl_event_date' => $this->frontdesk->systemdateformat ( $row2->refund_time ),
	            'fpl_event_name' => $row2->payment_name,
	            'fpl_event_description' => $row2->description,
	            'fpl_event_charge' => $row2->amount,
	            'fpl_event_credit' => 0
	        ) );
	
	    }
	    //=============================================================================================
	    //=============================================================================================
	    //=============================================================================================
	    $documentsList = array ();
	    $query2 = $this->db->query ( "SELECT documents.*, users.fullname, users.lastname
	            		FROM documents INNER JOIN deskofreservation ON deskofreservation.id=documents.reservation_id
						INNER JOIN users ON users.id = documents.user_id WHERE deskofreservation.id = ".$reservation_id );
	    foreach ( $query2->result () as $row2 ) {
	
	        array_push ( $documentsList, array (
	            'fpl_document_id' => $row2->id,
	            'fpl_firstname' => $row2->firstname,
	            'fpl_lastname' => $row2->lastname,
	            'fpl_document_description' => $row2->description,
	            'fpl_filename' => $row2->filename
	        ) );
	    }
	    //=============================================================================================
	    //=============================================================================================
	    //=============================================================================================
	    $guestsList = array ();
	
	
	    $query2 = $this->db->query ( "SELECT guests.*, reservation_details.*, wifi_radius_vouchers.password as wifi_password,
	            wifi_radius_vouchers.name as wifi_login
	            FROM guests
				INNER JOIN guests_deskofreservation ON guests_deskofreservation.guest_id=guests.id
				INNER JOIN deskofreservation ON deskofreservation.id=guests_deskofreservation.reservation_id
				INNER JOIN reservation_details ON (reservation_details.guest_id = guests.id AND reservation_details.reservation_id = deskofreservation.id)
	            LEFT JOIN wifi_radius_vouchers ON (wifi_radius_vouchers.guest_id = guests.id AND wifi_radius_vouchers.res_id = deskofreservation.id)
				WHERE deskofreservation.id = " . $reservation_id );
	    foreach ( $query2->result () as $row2 ) {
	
	        if (isset ( $dict_entrygoal_mass [$row2->goal_id] ["id"] )) {
	            $goal = $dict_entrygoal_mass [$row2->goal_id] ["id"];
	        } else {
	            $goal = "";
	        }
	        if (isset ( $doc_types [$row2->doc_type] )) {
	            $doc_type = $doc_types [$row2->doc_type];
	        } else {
	            if(isset($dict_documenttype_mass [$row2->doc_type] ["name"])){
	                $doc_type = $dict_documenttype_mass [$row2->doc_type] ["name"];
	            }else{
	                $doc_type = "";
	            }
	        }
	
	        $fpl_full_address_rus = "";
	
	        if(trim($row2->address) <> "" ){
	            $fpl_full_address_rus .= $row2->address;
	        }
	        if(trim($row2->addrbuilding) <> "" ){
	            $fpl_full_address_rus .= " д. ".$row2->addrbuilding;
	        }
	        if(trim($row2->addrhousing) <> "" ){
	            $fpl_full_address_rus .= " корп. ".$row2->addrhousing;
	        }
	        if(trim($row2->addrapt) <> "" ){
	            $fpl_full_address_rus .= " кв. ".$row2->addrapt;
	        }
	
	        if(isset($natiomality_mass[$row2->nationality])){
	            $nationality_guestlist = $natiomality_mass[$row2->nationality];
	        }else{
	            $nationality_guestlist = "";
	        }
	
	        $gender = "";
	        switch ($row2->gender) {
	            case 1 :
	                $gender = "Мужской";
	                break;
	            case 2 :
	                $gender = "Женский";
	                break;
	        }
	
	        if($row2->wifi_password == NULL){
	            $wifi_password = "";
	            $wifi_login = "";
	        }else{
	            $wifi_password = $row2->wifi_password;
	            $wifi_login = $row2->wifi_password;
	            //$wifi_login = $row2->wifi_login;
	        }
	         
	
	        $guestsList[$row2->id] = array (
	            'fpl_gl_guest_id' => $row2->id,
	            'fpl_wifi_login' => $wifi_login,
	            'fpl_wifi_code' => $wifi_password,
	            'fpl_wifi_pin' => $wifi_password,
	            'fpl_hotspot_name' => $wifi_hotspot_name,
	            'fpl_gl_firstname' => $row2->firstname,
	            'fpl_gl_lastname' => $row2->lastname,
	            'fpl_gl_middlename' => $row2->middlename,
	            'fpl_gl_email' => $row2->email,
	            'fpl_gl_dob' => $this->frontdesk->systemdateformat($row2->dob),
	            "fpl_gl_phone" => $row2->phone,
	            "fpl_gl_citizenship" => $row2->citizenship,
	            'fpl_gl_city' => $row2->city,
	            'fpl_gl_state' => $row2->state,
	            'fpl_gl_pob_state' => $row2->pob_state,
	            "fpl_gl_guest_country" => $row2->country,
	            'fpl_gl_full_address_rus' => $fpl_full_address_rus,
	            'fpl_gl_address' => $row2->address,
	            'fpl_gl_addrbuilding' => $row2->addrbuilding,
	            'fpl_gl_addrapt' => $row2->addrapt,
	            'fpl_gl_postcode' => $row2->postcode,
	            'fpl_gl_passportid' => $row2->passportid,
	            'fpl_gl_nationality' => $nationality_guestlist,
	            'fpl_gl_gender' => $gender,
	            'fpl_gl_doc_type' => $doc_type,
	            'fpl_gl_pob_city' => $row2->pob_city,
	            'fpl_gl_doc_precode' => $row2->doc_precode,
	            'fpl_gl_doc_date_open' => $this->frontdesk->systemdateformat($row2->doc_date_open),
	            'fpl_gl_doc_date_till' => $this->frontdesk->systemdateformat($row2->doc_date_till),
	            'fpl_gl_passportissuedby' => $row2->passportissuedby,
	            'fpl_gl_reg_visa_precode' => $row2->reg_visa_precode,
	            'fpl_gl_reg_visa_num' => $row2->reg_visa_num,
	            'fpl_gl_visamultiplicity' => $row2->visamultiplicity,
	            'fpl_gl_visitpurpose' => $row2->visitpurpose,
	            'fpl_gl_card_date_of_issue' => $this->frontdesk->systemdateformat($row2->card_date_of_issue),
	            'fpl_gl_migration_card_num' => $row2->migration_card_num,
	            'fpl_gl_migration_card_precode' => $row2->migration_card_precode,
	            'fpl_gl_dict_officialorgan_fmsCODE' => $row2->dict_officialorgan_fmsCODE,
	            'fpl_gl_reg_visa_type' => $row2->reg_visa_type,
	            'fpl_gl_card_date_of_issue' => $this->frontdesk->systemdateformat($row2->card_date_of_issue),
	            'fpl_gl_pob_city' => $row2->pob_city,
	            'fpl_gl_pob_district' => $row2->pob_district,
	
	
	            'fpl_gl_goal' => $goal,
	        ) ;
	    }
	    //=============================================================================================
	    //=============================================================================================
	    //=============================================================================================
	    $sql = "SELECT deskofreservation.*, categories.property_id as cat_property_id,
	    partners.name as partner_name, partners.legal_name as partner_legal_name, partners.ZKPO, partners.addrLine1,
	    partners.addrLine2, partners.bankname, partners.MFO, partners.DOC_INN, partners.DOC_SN, partners.correspondent_account,
	    partners.accountnumber, partners.nds as partner_nds, partners.country as partner_contry, partners.type_of_company, partners.swift, partners.DOC_type as partner_doc_type,
	    partners.city as partner_city, partners.state as partner_region, partners.postcode as partner_zip, partners.bic as partner_bic,
	    partners.email as partner_email, partners.nds_number,
	    rooms.name as room_name, categories.name as category_name, users.fullname as user_fullname, users.lastname as user_lastname,
	    users.middlename as user_middlename, partners.correspondent_account, dealers.name as dealer_name, rate.caption as tarif,
	    rate.id as tarif_id, rate.cancellation_policy_id as rate_cancellation_policy_id, meal_policies.name as meal_plan,
	    reservation_details.visamultiplicity, reservation_details.visitpurpose, reservation_details.goal_id, reservation_details.card_number, reservation_details.card_valid_time,
	    reservation_details.reg_visa_type as reg_visa_type_d, reservation_details.reg_visa_precode, reservation_details.reg_date_in as reg_date_in_d,
	    reservation_details.reg_date_out, reservation_details.migration_card_precode, reservation_details.migration_card_num, reservation_details.card_date_of_issue,
	    rooms.category_id as category_id, guests.firstname, guests.lastname, guests.middlename,
	    guests.phone, guests.passportid, guests.foreign, guests.address, guests.email,  guests.doc_type,
	    guests.nationality, guests.citizenship, guests.dob, guests.gender, guests.postcode, guests.country,
	    guests.state, guests.city, guests.addrbuilding, guests.addrapt, guests.addrhousing, guests.pob_state, guests.pob_city, guests.pob_district, guests.doc_date_open, guests.doc_precode,
	    guests.dict_officialorgan_fmsCODE, guests.passportissuedby, property_information.range_id as child_range_id,
	    property_information.reception_phone, property_information.email as hotel_email, property_information.street as hotel_street,
	    property_information.city as hotel_city, property_information.state as hotel_state, property_information.post_code as post_code, property_information.country as hotel_country,
	    property_information.id as property_id, property_information.gps_coordinates as hotel_gps_coordinates, groupreservations.name as group_name
	    FROM deskofreservation
	    $guest_sql
	    INNER JOIN rooms ON deskofreservation.room_id = rooms.id
	    INNER JOIN categories ON categories.id = rooms.category_id
	    LEFT JOIN reservation_details ON (reservation_details.reservation_id = deskofreservation.id AND reservation_details.guest_id = guests.id)
	    LEFT JOIN reservation_goals ON reservation_details.goal_id = reservation_goals.id
	    LEFT JOIN rate ON deskofreservation.price_type = rate.id
	    LEFT JOIN groupreservations ON deskofreservation.intgroupid = groupreservations.id
	    LEFT JOIN meal_policies ON meal_policies.id = rate.meal_policy_id
	    LEFT JOIN dealers ON deskofreservation.id_dealer = dealers.id
	    LEFT JOIN users ON deskofreservation.id_user = users.id
	    LEFT JOIN partners ON deskofreservation.id_partner = partners.id
	    LEFT JOIN property_information ON  property_information.id = categories.property_id
	    WHERE deskofreservation.id = " . $reservation_id;
	    // 	            echo $sql."||";
	    $query = $this->db->query ( $sql );
	
	    $row = $query->row ();
	    //=============================================================================================
	    //=============================MAIN GUEST DATA============================================
	    //=============================================================================================
	    $natiomality_mass = array ();
	    $query2 = $this->db->query ( "SELECT * FROM language WHERE is_active = 1" );
	    foreach ( $query2->result () as $row2 ) {
	        $natiomality_mass [$row2->id] = $row2->name;
	    }
	
	    if(isset($natiomality_mass[$row->nationality])){
	        $nationality = $natiomality_mass[$row->nationality];
	    }else{
	        $nationality = "";;
	    }
	
	
	    $query2 = $this->db->query ( "SELECT guests.*, reservation_details.*,
	        wifi_radius_vouchers.password as wifi_password, wifi_radius_vouchers.name as wifi_login
	        FROM guests
	        INNER JOIN reservation_details ON reservation_details.guest_id = '" . $row->guest_id."'
	        LEFT JOIN wifi_radius_vouchers ON (wifi_radius_vouchers.guest_id = guests.id AND wifi_radius_vouchers.res_id = $reservation_id)
	        WHERE reservation_details.reservation_id = " . $reservation_id . " AND guests.id = '" . $row->guest_id."'" );
	    foreach ( $query2->result () as $row2 ) {
	
	        if (isset ( $dict_entrygoal_mass [$row2->goal_id] ["id"] )) {
	            $goal = $dict_entrygoal_mass [$row2->goal_id] ["id"];
	        } else {
	            $goal = "";
	        }
	        if (isset ( $doc_types [$row2->doc_type] )) {
	            $doc_type = $doc_types [$row2->doc_type];
	        } else {
	            if(isset($dict_documenttype_mass [$row2->doc_type] ["name"])){
	                $doc_type = $dict_documenttype_mass [$row2->doc_type] ["name"];
	            }else{
	                $doc_type = "";
	            }
	        }
	
	        $fpl_full_address_rus = "";
	
	        if(trim($row2->address) <> "" ){
	            $fpl_full_address_rus .= $row2->address;
	        }
	        if(trim($row2->addrbuilding) <> "" ){
	            $fpl_full_address_rus .= " д. ".$row2->addrbuilding;
	        }
	        if(trim($row2->addrhousing) <> "" ){
	            $fpl_full_address_rus .= " корп. ".$row2->addrhousing;
	        }
	        if(trim($row2->addrapt) <> "" ){
	            $fpl_full_address_rus .= " кв. ".$row2->addrapt;
	        }
	
	        if(isset($natiomality_mass[$row2->nationality])){
	            $nationality_guestlist = $natiomality_mass[$row2->nationality];
	        }else{
	            $nationality_guestlist = "";
	        }
	
	        $gender = "";
	        switch ($row2->gender) {
	            case 1 :
	                $gender = "Мужской";
	                break;
	            case 2 :
	                $gender = "Женский";
	                break;
	        }
	         
	        if($row2->wifi_password == NULL){
	            $wifi_password = "";
	            $wifi_login = "";
	        }else{
	            $wifi_password = $row2->wifi_password;
	            $wifi_login = $row2->wifi_password;
	            //$wifi_login = $row2->wifi_login;
	        }
	         
	        $guestsList[$row2->id] = array (
	            'fpl_gl_guest_id' => $row2->id,
	            'fpl_wifi_login' => $wifi_login,
	            'fpl_wifi_code' => $wifi_password,
	            'fpl_wifi_pin' => $wifi_password,
	            'fpl_hotspot_name' => $wifi_hotspot_name,
	            'fpl_gl_firstname' => $row2->firstname,
	            'fpl_gl_lastname' => $row2->lastname,
	            'fpl_gl_middlename' => $row2->middlename,
	            'fpl_gl_email' => $row2->email,
	            'fpl_gl_dob' => $this->frontdesk->systemdateformat($row2->dob),
	            "fpl_gl_phone" => $row2->phone,
	            "fpl_gl_foreign" => $row2->foreign,
	            'fpl_gl_nationality' => $nationality_guestlist,
	            'fpl_gl_gender' => $gender,
	            "fpl_gl_guest_country" => $row2->country,
	            "fpl_gl_citizenship" => $row2->citizenship,
	            'fpl_gl_city' => $row2->city,
	            'fpl_gl_state' => $row2->state,
	            'fpl_gl_pob_state' => $row2->pob_state,
	            'fpl_gl_city' => $row2->city,
	            'fpl_gl_full_address_rus' => $fpl_full_address_rus,
	            'fpl_gl_address' => $row2->address,
	            'fpl_gl_addrbuilding' => $row2->addrbuilding,
	            'fpl_gl_addrhousing' => $row2->addrhousing,
	            'fpl_gl_addrapt' => $row2->addrapt,
	            'fpl_gl_postcode' => $row2->postcode,
	            'fpl_gl_passportid' => $row2->passportid,
	            'fpl_gl_doc_type' => $doc_type,
	            'fpl_gl_pob_city' => $row2->pob_city,
	            'fpl_gl_doc_precode' => $row2->doc_precode,
	            'fpl_gl_doc_date_open' => $this->frontdesk->systemdateformat($row2->doc_date_open),
	            'fpl_gl_doc_date_till' => $this->frontdesk->systemdateformat($row2->doc_date_till),
	            'fpl_gl_passportissuedby' => $row2->passportissuedby,
	            'fpl_gl_reg_visa_precode' => $row2->reg_visa_precode,
	            'fpl_gl_reg_visa_num' => $row2->reg_visa_num,
	            'fpl_gl_visamultiplicity' => $row2->visamultiplicity,
	            'fpl_gl_visitpurpose' => $row2->visitpurpose,
	            'fpl_gl_card_date_of_issue' => $this->frontdesk->systemdateformat($row2->card_date_of_issue),
	            'fpl_gl_migration_card_num' => $row2->migration_card_num,
	            'fpl_gl_migration_card_precode' => $row2->migration_card_precode,
	            'fpl_gl_dict_officialorgan_fmsCODE' => $row2->dict_officialorgan_fmsCODE,
	            'fpl_gl_reg_visa_type' => $row2->reg_visa_type,
	            'fpl_gl_card_date_of_issue' => $this->frontdesk->systemdateformat($row2->card_date_of_issue),
	            'fpl_gl_pob_city' => $row2->pob_city,
	            'fpl_gl_pob_district' => $row2->pob_district,
	            'fpl_gl_goal' => $goal,
	        );
	    }
	    //=============================================================================================
	    //=============================================================================================
	    //=============================================================================================
	
	
	    $data ["fpl_cancellation_due"] = $this->frontdesk->systemdateformat(date("Y-m-d H:i", $row->duetime));
	    $data ["fpl_penalty_after_reservation_sum"] = $this->frontdesk->showcurrency ($cancelation_payment_sum);
	
	
	
	    if ($row->price_type == 0) {
	        $tarif = "Ошибка!!!!";
	    } else {
	        $tarif = $row->tarif;
	    }
	
	    if (isset ( $doc_types [$row->doc_type] )) {
	        $doc_type = $doc_types [$row->doc_type];
	    } else {
	        if(isset($dict_documenttype_mass [$row->doc_type] ["name"])){
	            $doc_type = $dict_documenttype_mass [$row->doc_type] ["name"];
	        }else{
	            $doc_type = "";
	        }
	    }
	    $data ["fpl_group_id"] = $row->intgroupid;
	    $data ["fpl_group_name"] = $row->group_name;
	    
	    $data ["fpl_custom_servicesList_vat_summ"] = $this->frontdesk->showcurrency ( $summ_nds_amount  );
	
	    $data ["fpl_custom_ServicesList_amount_before_vat"] = $this->frontdesk->showcurrency ( $checked_services_summ - $summ_nds_amount  );
	
	    $data ["fpl_daily_pricing"] = $data_tarification["rates"];
	
	    $data ["fpl_custom_ServicesList_quantity"] = $cs_counter - 1;
	
	    $data ["fpl_reservation_id"] = $reservation_id;
	     
	    //$data ["fpl_pincode_md5"] = md5($hms_hotel_id." ".$reservation_id);
	    //$pincode_md5 = md5($hms_hotel_id." ".$reservation_id);
	     
	    $reservation_pincode_phrase = $this->config->item('reservation_pincode_phrase');
	    $pincode_md5 = md5($reservation_pincode_phrase.$hms_hotel_id.$reservation_id);
	    
	    $pm_url_version = $this->releases->get_pm_url_version();
	    $pm_base_urls = $this->releases->get_pm_base_urls();
	    switch($pm_url_version){
	        case 0:
	            $data ["url_reservation_online"] = $url_to_booking_page."bookit_c2/reservation_info/".$hms_hotel_id."/".$reservation_id."/".$pincode_md5;
	            break;
	        case 1:
	            $data ["url_reservation_online"] = $pm_base_urls['pmv2']."bookit_c2/reservation_info/".$hms_hotel_id."/".$reservation_id."/".$pincode_md5."?hms_system_id=$hms_hotel_id";
	            break;
	        case 2:
	            $data ["url_reservation_online"] = $pm_base_urls['pmv3']."bookit_c2/reservation_info/".$hms_hotel_id."/".$reservation_id."/".$pincode_md5."?hms_system_id=$hms_hotel_id";
	            break;
	        default:
	            $data ["url_reservation_online"] = $url_to_booking_page."bookit_c2/reservation_info/".$hms_hotel_id."/".$reservation_id."/".$pincode_md5;
	            break;
	    }
	    //$data ["url_reservation_online"] = $url_to_booking_page."bookit_c2/reservation_info/".$hms_hotel_id."/".$reservation_id."/".$pincode_md5;
	    //$data ["url_reservation_online"] = $url_to_booking_page."bookit_c2/reservation_info/".$reservation_id."/".$pincode_md5;
	     
	    $data ['fpl_correspondent_account'] = $row->correspondent_account;
	    $data ['fpl_dealer_name'] = $row->dealer_name;
	    $data ['fpl_id_user'] = $row->id_user;
	    $data ['fpl_user_name'] = $row->user_lastname." ".$row->user_fullname." ".$row->user_middlename;
	    $data ['fpl_current_user'] = $_SESSION ['user']['lastname']." ".$_SESSION ['user']['fullname'];
	    $data ['fpl_tarif'] = $tarif;
	    $data ['fpl_goal_id'] = $row->goal_id;
	    $data ['fpl_dc_rid_prev'] = $row->dc_rid_prev;
	    $data ['fpl_dc_rid_next'] = $row->dc_rid_next;
	
	    if(isset($categories_names[$ud_price_category])){
	        $data ['fpl_ud_price_category'] = $categories_names[$ud_price_category];
	    }else{
	        $data ['fpl_ud_price_category'] = "";
	    }
	
	    $data ['fpl_hotel_phone'] = $row->reception_phone;
	    $data ['fpl_hotel_email'] = $row->hotel_email;
	    $data ['fpl_hotel_address'] = $row->hotel_street;
	    $data ['fpl_hotel_city'] = $row->hotel_city;
	    $data ['fpl_hotel_state'] = $row->hotel_state;
	    $data ['fpl_hotel_zip'] = $row->post_code;
	    $data ['fpl_hotel_email'] = $row->hotel_email;
	    $data ['fpl_hotel_country'] = $row->hotel_country;
	
	
	    $global_lang = $this->hotelix_config->get_record("global_language", "int");
	    $global_currency_id = $this->hotelix_config->get_record("global_currency", "int");
	    $query_currency = $this->db->get_where('`global_hotelix`.`currency`', array('id' => $global_currency_id));
	
	    $property_custom_info = $this->frontdesk->get_property_custom_info(0, $row->category_id, $global_lang);
	    //echo "property_custom_info".$property_custom_info;
	    $property_id = 0;
	    if($property_custom_info == 0){
	        $sql2 = "SELECT id FROM property_information LIMIT 1";
	        $query2 = $this->db->query ( $sql2 );
	        if ($query2->num_rows () > 0) {
	            $row2 = $query2->row();
	            $property_id = $row2->id;
	
	            $property_custom_info = $this->frontdesk->get_property_custom_info($property_id, 0, $global_lang);
	        }else{
	            $property_id = 0;
	        }
	
	    }
	
	    if(isset($property_custom_info["name"])){
	        $data ['fpl_hotel_name_main'] = $property_custom_info["name"];
	    }else{
	        $data ['fpl_hotel_name_main'] = "";
	    }
	
	    $international_category_name = $this->internationalfields->get_value("category", $row->category_id, "international_name", $global_lang);
	    $data ['fpl_categories_name_main'] = $international_category_name;
	
	    if($row->property_id != NULL){
	        $international_summary = $this->internationalfields->get_value("property_custom", $row->property_id, "international_summary", $global_lang);
	        $international_houseRules = $this->internationalfields->get_value("property_custom", $row->property_id, "international_houseRules", $global_lang);
	        $amenities_list = $this->frontdesk->get_property_amenity_types_all($row->property_id);
	        $international_summary_arr = $this->internationalfields->get_value("property_custom", $row->property_id, "international_summary", $template_language_code_int);
	        $international_hotel_name = $this->internationalfields->get_value("property_custom", $row->property_id, "international_name", $template_language_code_int);
	    }else{
	        if($property_id == 0){
	            $international_summary = "";
	            $international_houseRules = "";
	            $amenities_list = array();
	        }else{
	            $international_summary = $this->internationalfields->get_value("property_custom", $property_id, "international_summary", $global_lang);
	            $international_houseRules = $this->internationalfields->get_value("property_custom", $property_id, "international_houseRules", $global_lang);
	            $amenities_list = $this->frontdesk->get_property_amenity_types_all($property_id);
	            $international_summary_arr = $this->internationalfields->get_value("property_custom", $property_id, "international_summary", $template_language_code_int);
	            $international_hotel_name = $this->internationalfields->get_value("property_custom", $property_id, "international_name", $template_language_code_int);
	        }
	    }
	    $data ['fpl_hotel_general_description_main'] = $international_summary;
	
	    //echo $property_id.$global_lang;
	
	    //$international_summary_arr = $this->internationalfields->get_value("property_custom", $property_id, "international_summary", $template_language_code_int);
	    $data ['fpl_hotel_general_description'] = isset($international_summary_arr[$template_language_code_int])? $international_summary_arr[$template_language_code_int]:"{fpl_hotel_general_description}";
	    //$international_hotel_name = $this->internationalfields->get_value("property_custom", $property_id, "international_name", $template_language_code_int);
	    //echo "<pre>".$template_language_code_int;
	    //print_r($international_hotel_name);
	    if(isset($international_hotel_name[$template_language_code_int])){
	        $data ['fpl_hotel_name'] = $international_hotel_name[$template_language_code_int];
	    }else{
	        $data ['fpl_hotel_name'] = "";
	    }
	     
	     
	    $international_cat_property_name = $this->internationalfields->get_value("property_custom", $row->cat_property_id, "international_name", $template_language_code_int);
	    //echo "<pre>".$template_language_code_int;
	    //print_r($international_hotel_name);
	    if(isset($international_cat_property_name[$template_language_code_int])){
	        $data ['fpl_hotel_name_by_category_property'] = $international_cat_property_name[$template_language_code_int];
	    }else{
	        $data ['fpl_hotel_name_by_category_property'] = $data ['fpl_hotel_name'];
	    }
	
	     
	
	    $international_hotel_rules = $this->internationalfields->get_value("property_custom", $property_id, "international_houseRules", $template_language_code_int);
	
	    if(isset($international_hotel_rules[$template_language_code_int])){
	        $data ['fpl_hotel_rules'] = $international_hotel_rules[$template_language_code_int];
	    }else{
	        $data ['fpl_hotel_rules'] = "";
	    }
	
	    $data ['fpl_caption_currency'] = $query_currency->row()->name;
	
	
	
	    $data ['fpl_hotel_amenities_list'] = array();
	    $amenity_inc = 0;
	    foreach($amenities_list as $cell){
	        $data ['fpl_hotel_amenities_list'][$amenity_inc]["fpl_amenity_name"] =
	        $this->mlanguages->getdictionaryword("setup_property_c2_description",
	            $template_language, "-".$cell["amenity_name"]."-");
	        $amenity_inc++;
	    }
	
	    $data["fpl_hotel_gps"] = $row->hotel_gps_coordinates;
	    $data["fpl_hotel_rules_main"] = $international_houseRules;
	    $data["fpl_hotel_mail"] = $row->hotel_email;
	
	    $data["fpl_category_name_main"] = $this->internationalfields->get_value("category", $row->category_id, "international_name", $global_lang);
	
	    switch ($row->partner_nds) {
	        case 0 :
	            $data["fpl_is_VAT_included"] = $this->mlanguages->getdictionaryword("ajax_check_allprint",
	            $template_language, "{caption_empty_nds}"); // Без//{caption_empty_nds}
	            break;
	        case 1 :
	            $data["fpl_is_VAT_included"] = $this->mlanguages->getdictionaryword("ajax_check_allprint",
	            $template_language, "{caption_included_nds}");//В том числе
	            break;
	        case 2 :
	            $data["fpl_is_VAT_included"] = "";
	            break;
	        default :
	            $data["fpl_is_VAT_included"] = "";
	            break;
	    }
	    if($summ_nds_amount == 0){
	        $data["fpl_total_vat_summ"] = "";
	    }else{
	        $data["fpl_total_vat_summ"] = $this->frontdesk->showcurrency ($summ_nds_amount)."{fpl_caption_currency}";
	    }
	    $data["fpl_rate_name_main"] = $row->tarif;
	
	    if($row->tarif_id == '' || $row->tarif_id == 0){
	        $international_rate_name_arr = array();
	    }else{
	        $international_rate_name_arr = $this->internationalfields->get_value("rate", $row->tarif_id, "international_name", $template_language_code_int);
	    }
	    $data["fpl_rate_name"] = isset($international_rate_name_arr[$template_language_code_int])? $international_rate_name_arr[$template_language_code_int]:"{fpl_rate_name}";
	
	    $data["fpl_meal_plan"] = $this->mlanguages->getdictionaryword("tbl_meal_policies",
	        $template_language, "-".$row->meal_plan."-");
	
	    $data["fpl_room_description_main"] = $this->internationalfields->get_value("category", $row->category_id, "international_comment", $global_lang);
	    $international_room_description_arr = $this->internationalfields->get_value("category", $row->category_id, "international_comment", $template_language_code_int);
	    $data["fpl_room_description"] = (isset($international_room_description_arr[$template_language_code_int])) ? $international_room_description_arr[$template_language_code_int]:"";
	
	
	    $data["fpl_room_amenities_list"] = array();
	
	    $room_amenities_list = $this->frontdesk->get_category_amenity_types_all($row->category_id);
	
	    $data ['fpl_room_amenities_list'] = array();
	    $amenity_inc = 0;
	    foreach($room_amenities_list as $cell){
	        $data ['fpl_room_amenities_list'][$amenity_inc]["fpl_amenity_name"] =
	        $this->mlanguages->getdictionaryword("tbl_roomscategories_equipment",
	            $template_language, "-".$cell["category_amenity_name"]."-");
	        $amenity_inc++;
	    }
	
	    $baby_age_start = 0;
	    $baby_age_end = 0;
	    $child_age_start = 0;
	    $child_age_end = 0;
// 	    if ($row->property_id != NULL) {
// 	        $sql2 = "SELECT value FROM property_config WHERE name = 'baby_age_start' AND property_id = " . $row->property_id;
// 	        $query2 = $this->db->query ( $sql2 );
// 	        if ($query2->num_rows () > 0) {
// 	            $row2 = $query2->row ();
// 	            $baby_age_start = $row2->value;
// 	        }
	
// 	        $sql2 = "SELECT value FROM property_config WHERE name = 'baby_age_end' AND property_id = " . $row->property_id;
// 	        $query2 = $this->db->query ( $sql2 );
// 	        if ($query2->num_rows () > 0) {
// 	            $row2 = $query2->row ();
// 	            $baby_age_end = $row2->value;
// 	        }
	
// 	        $sql2 = "SELECT value FROM property_config WHERE name = 'child_age_start' AND property_id = " . $row->property_id;
// 	        $query2 = $this->db->query ( $sql2 );
// 	        if ($query2->num_rows () > 0) {
// 	            $row2 = $query2->row ();
// 	            $child_age_start = $row2->value;
// 	        }
	
// 	        $sql2 = "SELECT value FROM property_config WHERE name = 'child_age_end' AND property_id = " . $row->property_id;
// 	        $query2 = $this->db->query ( $sql2 );
// 	        if ($query2->num_rows () > 0) {
// 	            $row2 = $query2->row ();
// 	            $child_age_end = $row2->value;
// 	        }
// 	    }
	    
	    if ($row->property_id != NULL) {
	        $age_acb_ranges_arr = array();
	        $query_res = $this->db->get_where('age_ranges_acb', "range_id = $row->child_range_id AND `from` <> -1")->result();
	        if (!empty($query_res)){
	            foreach ($query_res as $range) {
	                array_push($age_acb_ranges_arr, array(
	                    'id' => $range->id,
	                    'from' => $range->from,
	                    'to' => $range->to
	                ));
	            }
                if (count($age_acb_ranges_arr) > 2) {
                    foreach ($age_acb_ranges_arr as $range) {
                        switch ($range['id']) {
                            case 1: // baby ages
                                $baby_age_start = $range['from'];
                                $baby_age_end = $range['to'];
                                break;
                            case 2: // children_ages
                                $child_age_start = $range['from'];
                                $child_age_end = $range['to'];
                                break;
                        }
                    }
                }
	        }  
	    }
	    
	
	    $data ['fpl_child_age_start'] = $child_age_start;
	    $data ['fpl_child_age_end'] = $child_age_end;
	    $data ['fpl_baby_age_start'] = $baby_age_start;
	    $data ['fpl_baby_age_end'] = $baby_age_end;
	
	
	
	
	    $data ['fpl_guest_id'] = $row->guest_id;
	    $data ['fpl_groupid'] = $row->groupid;
	    $data ['fpl_type_id'] = $row->category_id;
	    $data ['fpl_room_id'] = $row->room_id;
	    $data ['fpl_room_name'] = $row->room_name;
	    $data ['fpl_categories_name'] = $categories_names[$row->category_id];
	    $data ['fpl_adult_places'] = $row->adults;
	    $data ['fpl_add_places'] = $row->add_places;
	    $data ['fpl_baby_places'] = $row->baby_places;
	    $data ['fpl_babyplace2'] = $row->babyplace2;
	    $data ['fpl_addbedplace'] = $row->addbedplace;
	    $data ['fpl_free_places'] = $row->free_places;
	    $data ['fpl_total_guest_count'] = $row->adults + $row->baby_places + $row->babyplace2;
	    $data ['fpl_discount'] = $row->discount;
	    $data ['fpl_percent_discount'] = $row->percent_discount;
	    $data ['fpl_amount'] = $row->amount;
	    //=================================cancelation_policy============================================================
	    $cancelation_policy_tbl = "global_hotelix_common.dc_cancelationpolicy_list";
	    $cancelation_rate_query = $this->db->get_where($cancelation_policy_tbl, array('id' => $row->rate_cancellation_policy_id));
	    if ($cancelation_rate_query->num_rows()>0){
	        $cancelation_rate_data = $cancelation_rate_query->row();
	        $data ['fpl_cancelation_deadline'] =
	        $this->frontdesk->systemdateformat(date("Y-m-d", strtotime($row->datein." -".$cancelation_rate_data->deadline_days." days")));
	        $data ['fpl_cancel_penalty_amount_before_deadline'] =
	        $this->frontdesk->showcurrency ($cancelation_rate_data->penalty_ar * $cancel_accommodation_penalty_amount / 100);
	        $data ['fpl_cancel_penalty_amount_after_deadline'] =
	        $this->frontdesk->showcurrency ($cancelation_rate_data->penalty_ad  * $cancel_accommodation_penalty_amount / 100);
	    }else{
	        $data ['fpl_cancelation_deadline'] = "";
	        $data ['fpl_cancel_penalty_amount_before_deadline'] = $this->frontdesk->showcurrency (0);
	        $data ['fpl_cancel_penalty_amount_after_deadline'] = $this->frontdesk->showcurrency (0);
	    }
	    //=======================================cancelation_policy_END=====================================================
	    $datein = $row->datein;
	    $dateout = $row->dateout;
	
	    $data ['fpl_paid_sum'] = $paid_sum;
	    $data ['fpl_balance'] = $row->balance;
	    $data ['fpl_datein'] = $this->frontdesk->systemdateformat($row->datein);
	    $data ['fpl_dateout'] = $this->frontdesk->systemdateformat($row->dateout);
	    $data ['fpl_check_in_time'] = $row->checkintime;
	    $data ['fpl_check_out_time'] = $row->checkouttime;
	    $data ['fpl_dateout'] = $this->frontdesk->systemdateformat($row->dateout);
	    $data ['fpl_duration'] = $row->duration;
	    $data ['fpl_description'] = $row->description;
	    $data ['fpl_maid_description'] = $row->maid_description;
	
	    $data ['fpl_status'] = $row->status;
	    $data ['fpl_date'] = $this->frontdesk->systemdateformat($row->date);
	    $data ['fpl_resourse'] = $row->resourse;
	    $data ['fpl_commission'] = $row->commission;
	    $data ['fpl_user'] = $row->id_user;
	    $data ['fpl_dealer'] = $row->id_dealer;
	    $data ['fpl_id_company_customer'] = $row->id_company_customer;
	    $data ["fpl_price_type"] = $row->price_type;
	    $data ["fpl_isNew"] = $row->isNew;
	    $data ["fpl_isread"] = $row->isread;
	    // guests
	    $data ["fpl_guest_firstname"] = $row->firstname;
	    $data ["fpl_guest_lastname"] = $row->lastname;
	    $data ["fpl_guest_middlename"] = $row->middlename;
	    $data ["fpl_guest_phone"] = $row->phone;
	    $data ["fpl_guest_passportid"] = $row->passportid;
	    $data ["fpl_guest_foreign"] = $row->foreign;
	    $data ["fpl_guest_doc_type"] = $doc_type;
	
	    $data ["fpl_guest_pob_state"] = $row->pob_state;
	    $data ["fpl_guest_pob_city"] = $row->pob_city;
	    $data ["fpl_guest_pob_district"] = $row->pob_district;
	    $data ["fpl_guest_doc_date_open"] = $this->frontdesk->systemdateformat($row->doc_date_open);
	    $data ["fpl_guest_doc_precode"] = $row->doc_precode;
	    $data ["fpl_guest_passportissuedby"] = $row->passportissuedby;
	    $data ["fpl_guest_dict_officialorgan_fmsCODE"] = $row->dict_officialorgan_fmsCODE;
	
	    $data["fpl_guest_full_address_rus"] = "";
	
	    if(trim($row->address) <> "" ){
	        $data["fpl_guest_full_address_rus"] .= $row->address;
	    }
	    if(trim($row->addrbuilding) <> "" ){
	        $data["fpl_guest_full_address_rus"] .= " д. ".$row->addrbuilding;
	    }
	    if(trim($row->addrhousing) <> "" ){
	        $data["fpl_guest_full_address_rus"] .= " корп. ".$row->addrhousing;
	    }
	    if(trim($row->addrapt) <> "" ){
	        $data["fpl_guest_full_address_rus"] .= " кв. ".$row->addrapt;
	    }
	
	
	    $data ["fpl_guest_firstname"] = $row->firstname;
	    $data ["fpl_guest_lastname"] = $row->lastname;
	    $data ["fpl_guest_middlename"] = $row->middlename;
	    $data ["fpl_guest_phone"] = $row->phone;
	    $data ["fpl_guest_passportid"] = $row->passportid;
	    $data ["fpl_guest_foreign"] = $row->foreign;
	    $data ["fpl_guest_address"] = $row->address;
	    $data ["fpl_guest_email"] = $row->email;
	    $data ["fpl_guest_mother_tongue"] = $nationality;
	    $data ["fpl_guest_dob"] = $this->frontdesk->systemdateformat($row->dob);
	    $gender = "";
	    switch ($row->gender) {
	        case 1 :
	            $gender = "Мужской";
	            break;
	        case 2 :
	            $gender = "Женский";
	            break;
	    }
	    $data ["fpl_guest_gender"] = $gender;
	    $data ["fpl_guest_citizenship"] = $row->citizenship;
	    $data ["fpl_guest_postcode"] = $row->postcode;
	    $data ["fpl_guest_country"] = $row->country;
	    $data ["fpl_guest_state"] = $row->state;
	    $data ["fpl_guest_city"] = $row->city;
	    $data ["fpl_guest_pob_state"] = $row->pob_state;
	    $data ["fpl_guest_pob_city"] = $row->pob_city;
	    $data ["fpl_guest_addrbuilding"] = $row->addrbuilding;
	    $data ["fpl_guest_addrhousing"] = $row->addrhousing;
	    $data ["fpl_guest_addrapt"] = $row->addrapt;
	
	
	    $data ["fpl_guest_reg_visa_type"] = $row->reg_visa_type_d;
	    $data ["fpl_guest_reg_visa_precode"] = $row->reg_visa_precode;
	    $data ["fpl_guest_reg_date_in"] = $this->frontdesk->systemdateformat($row->reg_date_in_d);
	    $data ["fpl_guest_reg_date_out"] = $this->frontdesk->systemdateformat($row->reg_date_out);
	    $data ["fpl_guest_migration_card_precode"] = $row->migration_card_precode;
	    $data ["fpl_guest_migration_card_num"] = $row->migration_card_num;
	
	    $data ["fpl_guest_visitpurpose"] = $row->visitpurpose;
	    $data ["fpl_guest_visamultiplicity"] = $row->visamultiplicity;
	    $data ["fpl_guest_doc_type"] = $doc_type;
	
	    $data ["fpl_guest_address"] = $row->address;
	    $data ["fpl_guest_email"] = $row->email;
	
	    $data ["fpl_guest_mother_tongue"] = $nationality;
	
	    $data ["fpl_guest_dob"] = $this->frontdesk->systemdateformat($row->dob);
	
	    $gender = "";
	    switch ($row->gender) {
	        case 1 :
	            $gender = "Мужской";
	            break;
	        case 2 :
	            $gender = "Женский";
	            break;
	    }
	    $data ["fpl_guest_gender"] = $gender;
	
	    //============= MAIN GUEST DATA ================
	
	    // 	            $data ["fpl_m_guest_firstname"] = $row->firstname;
	    // 	            $data ["fpl_m_guest_lastname"] = $row->lastname;
	    // 	            $data ["fpl_m_guest_middlename"] = $row->middlename;
	    // 	            $data ["fpl_m_guest_address"] = $row->address;
	    // 	            $data ["fpl_m_guest_email"] = $row->email;
	    // 	            $data ["fpl_m_guest_phone"] = $row->phone;
	    // 	            $data ["fpl_m_guest_passportid"] = $row->passportid;
	    // 	            $data ["fpl_m_guest_foreign"] = $row->foreign;
	    // 	            $data ["fpl_m_guest_doc_type"] = $row->doc_type;
	    // 	            $data ["fpl_m_guest_nationality"] = $row->nationality;
	    // 	            $data ["fpl_m_guest_citizenship"] = $row->citizenship;
	    // 	            $data ["fpl_m_guest_dob"] = $row->dob;
	    // 	            $data ["fpl_m_guest_gender"] = $row->gender;
	    // 	            $data ["fpl_m_guest_postcode"] = $row->postcode;
	    // 	            $data ["fpl_m_guest_country"] = $row->country;
	    // 	            $data ["fpl_m_guest_state"] = $row->state;
	    // 	            $data ["fpl_m_guest_city"] = $row->city;
	    // 	            $data ["fpl_m_guest_addrbuilding"] = $row->addrbuilding;
	    // 	            $data ["fpl_m_guest_addrapt"] = $row->addrapt;
	    // 	            $data ["fpl_m_guest_addrhousing"] = $row->addrhousing;
	    // 	            $data ["fpl_m_guest_pob_state"] = $row->pob_state;
	    // 	            $data ["fpl_m_guest_pob_city"] = $row->pob_city;
	    // 	            $data ["fpl_m_guest_pob_district"] = $row->pob_district;
	    // 	            $data ["fpl_m_guest_doc_date_open"] = $row->doc_date_open;
	    // 	            $data ["fpl_m_guest_doc_precode"] = $row->doc_precode;
	    // 	            $data ["fpl_m_guest_dict_officialorgan_fmsCODE"] = $row->dict_officialorgan_fmsCODE;
	    // 	            $data ["fpl_m_guest_passportissuedby"] = $row->passportissuedby;
	    //============= MAIN GUEST DATA ================
	
	    $data ["fpl_guest_citizenship"] = $row->citizenship;
	    $data ["fpl_guest_postcode"] = $row->postcode;
	    $data ["fpl_guest_country"] = $row->country;
	    $data ["fpl_guest_state"] = $row->state;
	    $data ["fpl_guest_city"] = $row->city;
	    $data ["fpl_guest_addrbuilding"] = $row->addrbuilding;
	    $data ["fpl_guest_addrhousing"] = $row->addrhousing;
	    $data ["fpl_guest_addrapt"] = $row->addrapt;
	    // dc
	    $data ["fpl_dc_date"] = $this->frontdesk->systemdateformat($row->dc_date);
	    $data ["fpl_dc_time"] = $this->frontdesk->systemdateformat($row->dc_time);
	    $data ["fpl_dc_uuid"] = $row->dc_uuid;
	    $data ["fpl_dc_status"] = $row->dc_status;
	    $data ["fpl_dc_guestname"] = $row->dc_guestname;
	    $data ["fpl_dc_numberofguest"] = $row->dc_numberofguest;
	    $data ["fpl_dc_currencycode"] = $row->dc_currencycode;
	    $data ["fpl_dc_countrycode"] = $row->dc_countrycode;
	    $data ["fpl_dc_city"] = $row->dc_city;
	    $data ["fpl_dc_customerremarks"] = $row->dc_customerremarks;
	    $data ["fpl_dc_totalprice"] = $row->dc_totalprice;
	    $data ['fpl_dc_reservationid'] = $row->dc_reservationid;
	    $data ['fpl_dc_roomreservation_id'] = $row->dc_roomreservation_id;
	
	    $data ["fpl_tourtax"] = $row->tourtax;
	
	    //$data ["fpl_check_in_time"] = "---???---";
	    //$data ["fpl_check_out_time"] = "---???---";
	
	    $data ["fpl_origin_categoryid"] = $row->origin_categoryid;
	
	
	    $data ["fpl_guest_reg_visa_type"] = $row->reg_visa_type_d;
	    $data ["fpl_guest_reg_visa_precode"] = $row->reg_visa_precode;
	    $data ["fpl_guest_reg_date_in"] = $this->frontdesk->systemdateformat($row->reg_date_in_d);
	    $data ["fpl_guest_reg_date_out"] = $this->frontdesk->systemdateformat($row->reg_date_out);
	    $data ["fpl_guest_migration_card_precode"] = $row->migration_card_precode;
	    $data ["fpl_guest_migration_card_num"] = $row->migration_card_num;
	    $data ["fpl_guest_card_date_of_issue"] = $row->card_date_of_issue;
	    $data ["fpl_guest_visitpurpose"] = $row->visitpurpose;
	    $data ["fpl_guest_visamultiplicity"] = $row->visamultiplicity;
	
	    $data ['fpl_partner'] = $row->id_partner;
	    $data ['fpl_partner_name'] = $row->partner_name;
	    $data ['fpl_partner_legal_name'] = $row->partner_legal_name;
	    $data ["fpl_partner_ZKPO"] = $row->ZKPO;
	    $data ["fpl_partner_addrLine1"] = $row->addrLine1;
	    $data ["fpl_partner_addrLine2"] = $row->addrLine2;
	    $data ["fpl_partner_bankname"] = $row->bankname;
	    $data ["fpl_partner_MFO"] = $row->MFO;
	    $data ["fpl_partner_DOC_INN"] = $row->DOC_INN;
	    $data ["fpl_partner_DOC_SN"] = $row->DOC_SN;
	    $data ["fpl_partner_correspondent_account"] = $row->correspondent_account;
	    $data ["fpl_partner_accountnumber"] = $row->accountnumber;
	     
	    $data ["fpl_partner_city"] = $row->partner_city;
	    $data ["fpl_partner_region"] = $row->partner_region;
	    $data ["fpl_partner_zip"] = $row->partner_zip;
	    $data ["fpl_partner_email"] = $row->partner_email;
	    $data ["fpl_partner_bic"] = $row->partner_bic;
	    $data ["fpl_partner_account_number"] = $row->accountnumber;
	    $data ["fpl_vat_id"] = $row->nds_number;
	    $data ["fpl_partner_swift"] = $row->swift;
	    $data ["fpl_partner_doc_type"] = $row->partner_doc_type;
	
	    //=================================== partner BANK DETAILS -- START ===================================
	    $data ["fpl_bank_details"] = array();
	    $static_bank_data = array (
	        'bank_name' => $row->bankname,
	        'swift' => $row->swift,
	        'account_number' => $row->accountnumber,
	        'korr_account' => $row->correspondent_account
	    );
	    $partners_edit_page_data = $this->mpartners->partners_edit_page_data($row->partner_contry, $row->type_of_company, $template_language);
	    foreach ($static_bank_data as $key => $value) {
	        if ($partners_edit_page_data['fields'][$key] != "d0") {
	            array_push ( $data ["fpl_bank_details"], array (
	                'fpl_caption_key' => $partners_edit_page_data ['caption_fields'] [$key],
	                'fpl_caption_value' => $value
	            ) );
	        };
	    }
	    $data ["fpl_aquiring_url"] = "";
	    // 	            echo "<pre>";
	    // 	            print_r($data ["fpl_bank_details"]);
	    // 	            die ('');
	    //=================================== partner BANK DETAILS -- END ===================================
	    $data ["fpl_all_services_summ"] = $services_summ;
	    $data ["fpl_all_services_nds_summ"] = $services_all_summ_nds_amount;
	    $data ["fpl_all_services_without_nds_summ"] = $services_summ - $services_all_summ_nds_amount;
	    $data ["fpl_total_amount_str_int_ru"] = $this->frontdesk->num2str ( $services_summ );
	    $data ["fpl_total_amount_str_float_ru"] = $this->frontdesk->num2str ( $services_summ );
	    $data ["fpl_total_amount_str_int_ua"] = $this->frontdesk->num2str ( $services_summ, "ua" );
	    $data ["fpl_total_amount_str_float_ua"] = $this->frontdesk->num2str ( $services_summ, "ua" );
	
	    $data ["fpl_now_date"] = $this->frontdesk->systemdateformat(date("Y-m-d"));
	
	    // ========= CHECK DOMAIN OTELMS|AGAST ===========
	    if ($_SERVER['REMOTE_ADDR'] == "109.70.24.230") {
	        $hms_host = "agast.ru";
	    } else {
	        $hms_host = "otelms.com";
	    }
	    //$host_data = explode(".", $host);
	    $query_v = $this->db->query("SELECT host FROM visitka.config WHERE id = " .
	        $this->config->item("hotel_id"));
	    if($query_v->num_rows()> 0) {
	        $row_v = $query_v->row();
	        $visitka_host = $row_v->host;
	        $host_data = explode(".", $visitka_host);
	    }
	    $new_host = $host_data[0].".".$hms_host;
	    
	    $data ["fpl_hotel_logo"] = $new_host.'/gatepublic/show_property_logo/'.$row->cat_property_id.'/logo.jpg';
	    $data ["fpl_cat_property_id"] = $row->cat_property_id;
	
	    $data ["fpl_hotel_name_ru"] = "undefined";
	    $data ["fpl_hotel_name_en"] = "undefined";
	
	    if($row->id_company_customer > 0){
	        $customer_data = $this->mcustomers->getCustomer($row->id_company_customer);
	
	        $data ["fpl_customer_company_name"] = $customer_data->name;
	        $data ["fpl_customer_company_inn"] = $customer_data->doc_inn;
	        $data ["fpl_customer_company_kpp"] = $customer_data->zkpo;
	        $data ["fpl_customer_company_address"] = $customer_data->address;
	    }else{
	        $data ["fpl_customer_company_name"] = "";
	        $data ["fpl_customer_company_inn"] = "";
	        $data ["fpl_customer_company_kpp"] = "";
	        $data ["fpl_customer_company_address"] = "";
	    }
	    $sql = "SELECT descriptionlanguages.name as lang_name, internationalfields.name, internationalfields.value FROM descriptionlanguages
	            INNER JOIN internationalfields ON internationalfields.language_id = descriptionlanguages.id
	            WHERE descriptionlanguages.name IN ('en', 'ru') AND internationalfields.table_id = ".$row->cat_property_id." AND
	            internationalfields.table_type LIKE 'property_custom' AND internationalfields.name LIKE 'international_name'";
	    $query2 = $this->db->query ( $sql );
	
	    if ($query2->num_rows () > 0) {
	        foreach ($query2->result() as $row2) {
	            switch ($row2->lang_name) {
	                case "en":
	                    $data["fpl_hotel_name_en"] = $row2->value;
	                    break;
	                case "ru":
	                    $data["fpl_hotel_name_ru"] = $row2->value;
	                    break;
	            }
	        }
	    }
	
	    $data ["fpl_categories_name_ru"] = "undefined";
	    $data ["fpl_categories_name_en"] = "undefined";
	
	    $sql = "SELECT descriptionlanguages.name as lang_name, internationalfields.name, internationalfields.value FROM descriptionlanguages
	            INNER JOIN internationalfields ON internationalfields.language_id = descriptionlanguages.id
	            WHERE descriptionlanguages.name IN ('en', 'ru') AND internationalfields.table_id = ".$row->category_id." AND
	            internationalfields.table_type LIKE 'category' AND internationalfields.name LIKE 'international_name'";
	    $query2 = $this->db->query ( $sql );
	
	    if ($query2->num_rows () > 0) {
	        foreach ($query2->result() as $row2) {
	            switch ($row2->lang_name) {
	                case "en" :
	    	            			$data ["fpl_categories_name_en"] = $row2->value;
	    	            			break;
	                case "ru" :
	    	            			$data ["fpl_categories_name_ru"] = $row2->value;
	    	            			break;
	            }
	        }
	    }
	
	    $hms_host = "";
	    $query = $this->db->query ( "SELECT str_value FROM hotelix_config WHERE name LIKE 'online_booking_url'" );
	    if ($query->num_rows () > 0) {
	        $row_host = $query->row ();
	        $hms_host = $row_host->str_value;
	    }
	
	     
	
	    $tstamp = time();
	
	    $data ["fpl_uniteller_url"] = $hms_host . "/unitpay/upcprepare_post/?oid=m-hms-" . $hms_hotel_id . "-" . $reservation_id . "&total=" . $services_summ;
	    $data ["fpl_liqpay_url"] = $hms_host . "/liqpay/upcprepare_post/?oid=mhms-" . $hms_hotel_id . "-" . $reservation_id . "&total=" . $services_summ;
	    $data ["fpl_apex_url"] = $hms_host . "/appex/upcprepare_post/?oid=" . $hms_hotel_id . "-" . $reservation_id . "-" . $tstamp . "m&total=" . $services_summ;
	
	    $data ["fpl_guestsList"] = $guestsList;
	    $data ["fpl_ServicesList"] = $ServicesList;
	    //мусів зробити цю хню щоб поміняти нумерацію послуг... START
	    foreach ($custom_ServicesList as $custom_ServiceKey => $custom_Service){
	        $custom_ServicesList[$custom_ServiceKey]['fpl_counter'] = $custom_ServiceKey+1;
	    }//хня END
	    $data ["fpl_custom_ServicesList"] = $custom_ServicesList;
	    $data ["fpl_ServicesMainList"] = $ServicesMainList;
	    $data ["fpl_paymentList"] = $paymentList;
	    $data ["fpl_RefundList"] = $RefundList;
	
	    usort($folio_eventst, function ($a, $b){return strnatcmp($a["fpl_event_date"], $b["fpl_event_date"]);});
	    $fpl_folio_events = array();
	    $i = 1;
	    $fpl_total_charges = 0;
	    $fpl_total_credits = 0;
	    foreach ($folio_eventst as $folio_event){
	        $fpl_folio_events[$i] = $folio_event;
	        $fpl_folio_events[$i]['fpl_event_counter'] = $i;
	        $fpl_folio_events[$i]['fpl_event_charge'] = ($folio_event['fpl_event_charge'] != 0)? $this->frontdesk->showcurrency($folio_event['fpl_event_charge']) : "";
	        $fpl_folio_events[$i]['fpl_event_credit'] = ($folio_event['fpl_event_credit'] != 0)? $this->frontdesk->showcurrency($folio_event['fpl_event_credit']) : "";
	        $fpl_total_charges += $folio_event['fpl_event_charge'];
	        $fpl_total_credits += $folio_event['fpl_event_credit'];
	        $i++;
	    }
	    $data ["fpl_folio_events"] = $fpl_folio_events;
	    $data ["fpl_total_charges"] = $this->frontdesk->showcurrency($fpl_total_charges);
	    $data ["fpl_total_credits"] = $this->frontdesk->showcurrency($fpl_total_credits);
	    $data ["fpl_invoice_counter"] = "NO COUNTER YET";
	
	    $data ["fpl_documentsList"] = $documentsList;
	
	    $data ["fpl_custom_ServicesList_amount"] = number_format ( $checked_services_summ, 2, '.', '' );
	    $num2row_ServicesList_amount_str = "";
	    if($template_language == 'rus' || $template_language == 'ukr'){
	        switch ($query_currency->row ()->name) {
	            case "RUB" :
	                $num2row_ServicesList_amount_str = $this->frontdesk->num2str ( $data ["fpl_custom_ServicesList_amount"], "ru" );
	                break;
	            case "UAH" :
	                $num2row_ServicesList_amount_str = $this->frontdesk->num2str ( $data ["fpl_custom_ServicesList_amount"], "ua" );
	                ;
	                break;
	        }
	    }
	    $data ["fpl_custom_ServicesList_amount_string"] = $num2row_ServicesList_amount_str;
	    $data ["fpl_custom_ServicesList_amount_string_ru"] = number_format ( $checked_services_summ, 2, '.', '' );
	    $data ["fpl_custom_ServicesList_amount_string_uk"] = number_format ( $checked_services_summ, 2, '.', '' );
	
	     
	    list ( $year, $month, $day ) = explode ( "-", $datein );
	    $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	    list ( $year, $month, $day ) = explode ( "-", $dateout );
	    $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	
	    $international_category_name_str = $row->category_name;
	    if(isset($international_category_name[$global_lang])){
	        $international_category_name_str = $international_category_name[$global_lang];
	    }
	     
	    $main_service_taked = 0; // індикатор основних сервісів
	    $daily_profit = array();
	    $sum_accrual_price = 0;
	    $sum_payment_price = 0;
	    $sum_all_price = 0;
	    for ($i = $intdatein; $i < $intdateout; $i ++) {
	        $daily_profit_counter = 0;
	        foreach ($data["fpl_ServicesList"] as $key => $service_data) {
	            if ($service_data["period_tf_type"] > 0) {
	                switch ($service_data["period_tf_type"]) {
	                    case 2:
	                        if (! isset($data["fpl_ServicesList"][$key]["daily_profit_taked"])) {
	                            $daily_profit[$i][$daily_profit_counter]["date"] = $this->frontdesk->systemdateformat(gmdate("Y-m-d", $i * 86400));
	                            $daily_profit[$i][$daily_profit_counter]["action_name"] = $service_data["fpl_services_name"];
	                            $daily_profit[$i][$daily_profit_counter]["accrual_price"] = $service_data["fpl_servicesamount_perunit"];
	                            $daily_profit[$i][$daily_profit_counter]["fpl_event_description"] = $service_data["fpl_event_description"];
	                            $daily_profit[$i][$daily_profit_counter]["payment_price"] = "";
	                            $daily_profit_counter ++;
	                            $sum_accrual_price += $service_data["fpl_servicesamount_perunit"];
	                            $data["fpl_ServicesList"][$key]["daily_profit_taked"] = 1;
	                        }
	                        break;
	                    case 1:
	                        $daily_profit[$i][$daily_profit_counter]["date"] = $this->frontdesk->systemdateformat(gmdate("Y-m-d", $i * 86400));
	                        $daily_profit[$i][$daily_profit_counter]["action_name"] = $service_data["fpl_services_name"];
	                        $daily_profit[$i][$daily_profit_counter]["accrual_price"] = $this->frontdesk->showcurrency($service_data["fpl_servicesamount_no_format"]/$data["fpl_duration"]);
	                        $daily_profit[$i][$daily_profit_counter]["fpl_event_description"] = $service_data["fpl_event_description"];
	                        $sum_accrual_price += $service_data["fpl_servicesamount_no_format"] / $data["fpl_duration"];
	                        $daily_profit[$i][$daily_profit_counter]["payment_price"] = "";
	                        $daily_profit_counter ++;
	                        break;
	                }
	            }
	        }
	
	        foreach ($data["fpl_ServicesMainList"] as $key => $service_data) {
	            switch($service_data["fpl_services_type"]){
	                case 1:
	                    // послуга проживання
	                    if (isset($deskofdays_prices[$i])) {
	                        $daily_profit[$i][$daily_profit_counter]["date"] = $this->frontdesk->systemdateformat(gmdate("Y-m-d", $i * 86400));
	                        $daily_profit[$i][$daily_profit_counter]["action_name"] = $service_data["fpl_services_name"];
	                        $daily_profit[$i][$daily_profit_counter]["accrual_price"] = $deskofdays_prices[$i]["price"];
	                        $daily_profit[$i][$daily_profit_counter]["fpl_event_description"] = $international_category_name_str.", ".$data["fpl_room_name"];
	                        $daily_profit[$i][$daily_profit_counter]["payment_price"] = "";
	                        $daily_profit_counter ++;
	                        $sum_accrual_price += $deskofdays_prices[$i]["price"];
	                    }
	                    break;
	                default:
	                    if ($main_service_taked == 0) {
	                        $daily_profit[$i][$daily_profit_counter]["date"] = $this->frontdesk->systemdateformat(gmdate("Y-m-d", $i * 86400));
	                        $daily_profit[$i][$daily_profit_counter]["action_name"] = $service_data["fpl_services_name"];
	                        $daily_profit[$i][$daily_profit_counter]["accrual_price"] = $service_data["fpl_servicesamount_perunit"];
	                        $daily_profit[$i][$daily_profit_counter]["fpl_event_description"] = $service_data["fpl_event_description"];
	                        $daily_profit[$i][$daily_profit_counter]["payment_price"] = "";
	                        $daily_profit_counter ++;
	                        $sum_accrual_price += $service_data["fpl_servicesamount_perunit"];
	                    }
	                    break;
	            }
	
	        }
	        $main_service_taked = 1;
	    }
	
	    // payments
	    foreach ($data["fpl_paymentList"] as $key => $payment_data) {
	        $payment_action_datetime = $payment_data["fpl_create_time_standart_dateformat"];
	        list ($pay_date, $pay_time) = explode(" ", $payment_action_datetime);
	        list ($year, $month, $day) = explode("-", $pay_date);
	        $intdate_pay_action = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
	
	        if (isset($daily_profit[$intdate_pay_action])) {
	            $daily_profit_counter = max(array_keys($daily_profit[$intdate_pay_action]));
	            $daily_profit_counter ++;
	        } else {
	            $daily_profit_counter = 0;
	        }
	        $daily_profit[$intdate_pay_action][$daily_profit_counter]["date"] = $this->frontdesk->systemdateformat($pay_date);
	        $daily_profit[$intdate_pay_action][$daily_profit_counter]["action_name"] = $payment_data["fpl_typename"];
	        $daily_profit[$intdate_pay_action][$daily_profit_counter]["accrual_price"] = "";
	        $daily_profit[$intdate_pay_action][$daily_profit_counter]["fpl_event_description"] = $payment_data["fpl_event_description"];
	        $daily_profit[$intdate_pay_action][$daily_profit_counter]["payment_price"] = $payment_data["fpl_total"];
	        $daily_profit_counter ++;
	        $sum_payment_price += $payment_data["fpl_total"];
	    }
	
	    //         echo "<pre>";
	    //         print_r($daily_profit);
	    //         die();
	    // services
	    foreach ($data["fpl_ServicesList"] as $key => $service_data) {
	
	        if ($service_data["fpl_services_action_time_standart_dateformat"] != "") {
	            $service_action_datetime = $service_data["fpl_services_action_time_standart_dateformat"];
	            list ($service_date, $service_time) = explode(" ", $service_action_datetime);
	            list ($year, $month, $day) = explode("-", $service_date);
	
	            $intdate_service_action = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
	            if (isset($daily_profit[$intdate_service_action])) {
	                $daily_profit_counter = max(array_keys($daily_profit[$intdate_service_action]));
	                $daily_profit_counter ++;
	            } else {
	                $daily_profit_counter = 0;
	            }
	
	            $daily_profit[$intdate_service_action][$daily_profit_counter]["date"] = $this->frontdesk->systemdateformat($service_date);
	            $daily_profit[$intdate_service_action][$daily_profit_counter]["action_name"] = $service_data["fpl_services_name"];
	            $daily_profit[$intdate_service_action][$daily_profit_counter]["accrual_price"] = $service_data["fpl_servicesamount"];
	            $daily_profit[$intdate_service_action][$daily_profit_counter]["fpl_event_description"] = $service_data["fpl_event_description"];
	            $daily_profit[$intdate_service_action][$daily_profit_counter]["payment_price"] = "";
	            $daily_profit_counter ++;
	            $sum_accrual_price += $service_data["fpl_servicesamount_perunit"];
	        }
	    }
	
	    // refunds
	    foreach ($data["fpl_RefundList"] as $key => $refund_data) {
	        $refund_action_datetime = $refund_data["fpl_refund_time_standart_dateformat"];
	        list ($refund_date, $refund_time) = explode(" ", $refund_action_datetime);
	        list ($year, $month, $day) = explode("-", $pay_date);
	        $intdate_pay_action = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
	
	        if (isset($daily_profit[$intdate_pay_action])) {
	            $daily_profit_counter = max(array_keys($daily_profit[$intdate_pay_action]));
	            $daily_profit_counter ++;
	        } else {
	            $daily_profit_counter = 0;
	        }
	        $daily_profit[$intdate_pay_action][$daily_profit_counter]["date"] = $refund_date;
	        $daily_profit[$intdate_pay_action][$daily_profit_counter]["action_name"] = "refund";
	        $daily_profit[$intdate_pay_action][$daily_profit_counter]["accrual_price"] = $refund_data["fpl_refundamount"];
	        $daily_profit[$intdate_pay_action][$daily_profit_counter]["fpl_event_description"] = $refund_data["fpl_event_description"];
	        $daily_profit[$intdate_pay_action][$daily_profit_counter]["payment_price"] = "";
	        $daily_profit_counter ++;
	        $sum_accrual_price += $refund_data["fpl_refundamount"];
	    }
	
	
	    ksort($daily_profit);
	    $data ["fpl_daily_profit"] = array();
	    foreach($daily_profit as $intdate => $date_cell){
	        foreach($date_cell as $inc => $cell){
	            array_push($data ["fpl_daily_profit"], $cell);
	        }
	    }
	
	    $data ["fpl_daily_profit_balance"] = $this->frontdesk->showcurrency ($fpl_total_credits - $fpl_total_charges);
	
	    foreach ($data["fpl_ServicesList"] as $service_data) {
	
	    }
	
	    $data ["fpl_current_year"] = date ( "Y" );
	
	    if($pay_amount != ""){
	         
	        if(!is_float($pay_amount)){
	            $pay_amount = number_format ( $pay_amount, 2, '.', '' );
	        }
	         
	        $data ["fpl_template_pay_amount"] = $pay_amount;
	    }else{
	        $data ["fpl_template_pay_amount"] = abs($data['fpl_balance']);
	    }
	     
	    $pay_signature = md5($this->config->item('reservation_pincode_phrase').$hms_hotel_id.$reservation_id);
	    
	    switch($pm_url_version){
	        case 0:
	            $data ["fpl_onlinepaypage"] = $url_to_booking_page."bookit_c2/pay/$reservation_id/".abs($data ["fpl_template_pay_amount"])."/".$pay_signature;
	            break;
	        case 1:
	            $data ["fpl_onlinepaypage"] = $pm_base_urls['pmv2']."bookit_c2/pay/$reservation_id/".abs($data ["fpl_template_pay_amount"])."/".$pay_signature."?hms_system_id=$hms_hotel_id";
	            break;
	        case 2:
	            $data ["fpl_onlinepaypage"] = $pm_base_urls['pmv3']."bookit_c2/pay/$reservation_id/".abs($data ["fpl_template_pay_amount"])."/".$pay_signature."?hms_system_id=$hms_hotel_id";
	            break;
	        default:
	            $data ["fpl_onlinepaypage"] = $url_to_booking_page."bookit_c2/pay/$reservation_id/".abs($data ["fpl_template_pay_amount"])."/".$pay_signature;
	            break;
	    }
	    
	    //$data ["fpl_onlinepaypage"] = $url_to_booking_page."bookit_c2/pay/$reservation_id/".abs($data ["fpl_template_pay_amount"])."/".$pay_signature;
	
	    //$data ["fpl_template_pay_amount"] = "template_pay_amount";
	     
	    $data['fpl_vat_block'] = array();
	    foreach ($vat_block as $cell) {
	        //if ($cell["fpl_vat_rate"] > 0) {
	        if (isset($data['fpl_vat_block'][$cell["fpl_vat_rate"]])) {
	            $data['fpl_vat_block'][$cell["fpl_vat_rate"]]["fpl_net_value"] += $cell["fpl_net_value"];
	            $data['fpl_vat_block'][$cell["fpl_vat_rate"]]["fpl_vat_value"] += $cell["fpl_vat_value"];
	            $data['fpl_vat_block'][$cell["fpl_vat_rate"]]["fpl_brutto_value"] += $cell["fpl_brutto_value"];
	        } else {
	            $data['fpl_vat_block'][$cell["fpl_vat_rate"]]["fpl_vat_rate"] = $cell["fpl_vat_rate"];
	            $data['fpl_vat_block'][$cell["fpl_vat_rate"]]["fpl_net_value"] = $cell["fpl_net_value"];
	            $data['fpl_vat_block'][$cell["fpl_vat_rate"]]["fpl_vat_value"] = $cell["fpl_vat_value"];
	            $data['fpl_vat_block'][$cell["fpl_vat_rate"]]["fpl_brutto_value"] = $cell["fpl_brutto_value"];
	        }
	        //}
	    }
	     
	    foreach ($data['fpl_vat_block'] as $cell) {
	        $data['fpl_vat_block'][$cell["fpl_vat_rate"]]["fpl_net_value"] = $this->frontdesk->showcurrency ($cell["fpl_net_value"]);
	        $data['fpl_vat_block'][$cell["fpl_vat_rate"]]["fpl_vat_value"] = $this->frontdesk->showcurrency ($cell["fpl_vat_value"]);
	        $data['fpl_vat_block'][$cell["fpl_vat_rate"]]["fpl_brutto_value"] = $this->frontdesk->showcurrency ($cell["fpl_brutto_value"]);
	    }
	    //$data['fpl_now_date'] = date('Y-m-d');
	
	    ksort($data);
	
	    if ($this->session->userdata ( 'global_debug' ) == 1) {
	        echo "<pre>";
	        echo json_encode($data);
	        print_r($data);
	        echo "</pre>";
	    }
	
	     
	     
	    // 	            echo "<pre>";
	    // 	            print_r($vat_block);;
	    // 	            die();
	    return $data;
	}

	function get_template($array, $return_type = 0){
// 	    print_r($array);
// 		die();
		$template_id = $array["template_id"];
		$reservation_id = $array["reservation_id"];

		$services = array();
		if(isset($array["service"])){
			$services = $array["service"];
		}

		$pay_amount = "";
		if(isset($array["template_pay_amount"])){
		    $pay_amount = $array["template_pay_amount"];
		}
		
		$table = "templates";
		if(isset($array["template_location_type"])){
            switch ($array["template_location_type"]) {
                case "local":
                    $table = "templates";
                    break;
                case "global":
                    $table = "global_hotelix_common.templates";
                    break;
            }
		}
        //echo $table;
        //die();
		//======= GET TEMPLATE ============
		$sql = "SELECT templates.html, templates.language FROM ".$table." WHERE templates.id = " . $template_id;
		//echo $sql;
		//die();
		$query = $this->db->query ( $sql );
		$template = "";
		$template_language = "";
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$template = stripslashes ( $row->html );
			$template_language = $row->language;
		}

		//======= GET TEMPLATE DATA============


		if(isset($array["guests"])){
			$guest_id = 0;
			$guests = array();
			$guests = $array["guests"];
			$main_data = array();
			//print_r($guests);
			//print_r($array);
			//echo sizeof($array['guests']);
			if (sizeof($array['guests']) == 1) {
				//echo "==".$array["guests"][0]["guest_id"]."+++";
				//echo "AAAA".$array["guests"][0]."+++";
				if(isset($array['guests'][0]['guest_id'])){
					if(!isset($guests [0]))
						$guests [0] = $array['guests'][0]['guest_id'];
				}
			}else{

			}
			$i = 0;
			//print_r($guests);
			//die();
			foreach($guests as $key => $guest_id){
				$data = array();
				$data = $this->get_order_data_v2($reservation_id, $guest_id, 0, $template_language, $pay_amount);
				
				//========== FOR MULTY GUESTS ==========
				$this->load->library('parser');
				$html = $this->parser->parse_string(stripslashes($template), $data, true);
				$main_data["pl_node_list"][$i]["pl_node_cell"] = $html . "<br>";
				$i++;
			}

			switch ($return_type) {
				case 1 :
					//$this->mlanguages->getdictionary ( "templatedata", $template_language, $main_data );
					$html = $this->parser->parse ( 'templates/formsprinter_multy_guests_template.html', $main_data, true );
					return $html;
					break;
				case 0 :
					//$this->mlanguages->getdictionary ( "templatedata", $template_language, $main_data );
					$html = $this->parser->parse ( 'templates/formsprinter_multy_guests_template.html', $main_data, true );
					echo $html;
					return;
					break;
			}

		}else{
			$data = $this->get_order_data_v2($reservation_id, 0, $services, $template_language, $pay_amount);
		}
// 		echo "<pre>";
// 		print_r($data);
// 		die();
		switch ($return_type) {
			case 1 :
				//$this->mlanguages->getdictionary ( "templatedata", $template_language, $main_data );
				$this->load->library ( 'parser' );
				$html = $this->parser->parse_string ( stripslashes ( $template ), $data, true );
				return $html;
				break;
			case 0 :
				//$this->mlanguages->getdictionary ( "templatedata", $template_language, $main_data );
				$this->load->library ( 'parser' );
				echo $this->parser->parse_string ( stripslashes ( $template ), $data, true );
				return;
				break;
		}
	}
	
	function get_group_template($array, $return_type = 0){
	    // 	    print_r($array);
	    // 		die();
	    $template_id = $array["template_id"];
	    $group_id = $array["group_id"];
	
	    $table = "templates";
	    if(isset($array["template_location_type"])){
	        switch ($array["template_location_type"]) {
	            case "local":
	                $table = "templates";
	                break;
	            case "global":
	                $table = "global_hotelix_common.templates";
	                break;
	        }
	    }
	    //echo $table;
	    //die();
	    //======= GET TEMPLATE ============
	    $sql = "SELECT templates.html, templates.language FROM ".$table." WHERE templates.id = " . $template_id;
	    //echo $sql;
	    $query = $this->db->query ( $sql );
	    $template = "";
	    $template_language = "";
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $template = stripslashes ( $row->html );
	        $template_language = $row->language;
	    }
	
	    //======= GET TEMPLATE DATA============
	    $data = array();
	    $ids_reservations = array_keys($array["group_reservations"]);
        $fpl_all_rooms = array();
        $counter = 0;
        $services_amount = 0;
        $services_nds_amount = 0;
        foreach($ids_reservations as $res_id){
           $res_data = $this->get_order_data_v2($res_id, 0, $services = array(), $template_language, $pay_amount = '');
           if($counter == 0){
               $data['fpl_partner_bankname'] = $res_data['fpl_partner_bankname'];
               $data['fpl_partner_MFO'] = $res_data['fpl_partner_MFO'];
               $data['fpl_partner_DOC_INN'] = $res_data['fpl_partner_DOC_INN'];
               $data['fpl_partner_ZKPO'] = $res_data['fpl_partner_ZKPO'];
               $data['fpl_partner_correspondent_account'] = $res_data['fpl_partner_correspondent_account'];
               $data['fpl_partner_accountnumber'] = $res_data['fpl_partner_accountnumber'];
               $data['fpl_partner_name'] = $res_data['fpl_partner_name'];
               $data['fpl_partner_region'] = $res_data['fpl_partner_region'];
               $data['fpl_partner_city'] = $res_data['fpl_partner_city'];
               $data['fpl_partner_addrLine1'] = $res_data['fpl_partner_addrLine1'];
               $data['fpl_customer_company_name'] = $res_data['fpl_customer_company_name'];
               $data['fpl_customer_company_inn'] = $res_data['fpl_customer_company_inn'];
               $data['fpl_customer_company_kpp'] = $res_data['fpl_customer_company_kpp'];
               $data['fpl_group_id'] = $res_data['fpl_group_id'];
               $data['fpl_group_name'] = $res_data['fpl_group_name'];
               $data['fpl_caption_currency'] = $res_data['fpl_caption_currency'];
               $data['fpl_is_VAT_included'] = $res_data['fpl_is_VAT_included'];
               $data['fpl_total_amount_str_float_ua'] = $res_data['fpl_total_amount_str_float_ua'];
               $data['fpl_total_vat_summ'] = $res_data['fpl_total_vat_summ'];
               $data['fpl_amount'] = $res_data['fpl_amount'];
               //$data['fpl_all_services_summ'] = $res_data['fpl_all_services_summ'];
               //$data['fpl_all_services_nds_summ'] = $res_data['fpl_all_services_nds_summ'];
               $data['fpl_now_date'] = $res_data['fpl_now_date'];

           }
           
           $services_amount += $res_data['fpl_all_services_summ'];
           $services_nds_amount += $res_data['fpl_all_services_nds_summ'];
           
	       array_push($fpl_all_rooms, $res_data);
	       $counter ++;
        }
  		
  		$data ['fpl_reservations_main_services_amount'] = $services_amount;
  		$data ['fpl_reservations_main_services_nds_amount'] = $services_nds_amount;
  		$data ['fpl_reservations_amount_without_nds'] = $services_amount - $services_nds_amount;
  		
  		$data ['fpl_all_rooms'] = $fpl_all_rooms;
  		
        //echo "<pre>$return_type";
        //print_r($data);
        //die();
  		
	    switch ($return_type) {
	        case 1 :
	            $this->load->library ( 'parser' );
	            $html = $this->parser->parse_string ( stripslashes ( $template ), $data, true );
	            return $html;
	            break;
	        case 0 :
	            $this->load->library ( 'parser' );
	            echo $this->parser->parse_string ( stripslashes ( $template ), $data, true );
	            return;
	            break;
	    }
	}

	function get_global_template($array, $return_type = 0){
	    //print_r($_POST);
	    //die();
	    $template_id = $array["template_id"];
	    $reservation_id = $array["reservation_id"];

	    $services = array();
	    if(isset($array["service"])){
	        $services = $array["service"];
	    }

	    //======= GET TEMPLATE ============
	    $query = $this->db->query ( "SELECT global_hotelix_common.system_forms.html FROM global_hotelix_common.system_forms WHERE global_hotelix_common.system_forms.id = " . $template_id );
	    $template = "";
	    $template_language = "";
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $template = stripslashes ( $row->html );
	    }

	    //======= GET TEMPLATE DATA============


	    if(isset($array["guests"])){
	        $guest_id = 0;
	        $guests = array();
	        $guests = $array["guests"];
	        $main_data = array();
	        //print_r($guests);
	        //print_r($array);
	        //echo sizeof($array['guests']);
	        if (sizeof($array['guests']) == 1) {
	            //echo "==".$array["guests"][0]["guest_id"]."+++";
	            //echo "AAAA".$array["guests"][0]."+++";
	            if(isset($array['guests'][0]['guest_id'])){
	                if(!isset($guests [0]))
	                    $guests [0] = $array['guests'][0]['guest_id'];
	            }
	        }else{

	        }
	        $i = 0;
	        //print_r($guests);
	        //die();
	        foreach($guests as $key => $guest_id){
	            $data = array();
	            $data = $this->get_order_data_v2($reservation_id, $guest_id, 0, $template_language);

	            //========== FOR MULTY GUESTS ==========
	            $this->load->library('parser');
	            $html = $this->parser->parse_string(stripslashes($template), $data, true);
	            $main_data["pl_node_list"][$i]["pl_node_cell"] = $html . "<br>";
	            $i++;
	        }

	        switch ($return_type) {
	            case 1 :
	                //$this->mlanguages->getdictionary ( "templatedata", $template_language, $main_data );
	                $html = $this->parser->parse ( 'templates/formsprinter_multy_guests_template.html', $main_data, true );
	                return $html;
	                break;
	            case 0 :
	                //$this->mlanguages->getdictionary ( "templatedata", $template_language, $main_data );
	                $html = $this->parser->parse ( 'templates/formsprinter_multy_guests_template.html', $main_data, true );
	                echo $html;
	                return;
	                break;
	        }

	    }else{
	        $data = $this->get_order_data_v2($reservation_id, 0, $services, $template_language);
	    }

	    switch ($return_type) {
	        case 1 :
	            //$this->mlanguages->getdictionary ( "templatedata", $template_language, $main_data );
	            $this->load->library ( 'parser' );
	            $html = $this->parser->parse_string ( stripslashes ( $template ), $data, true );
	            return $html;
	            break;
	        case 0 :
	            //$this->mlanguages->getdictionary ( "templatedata", $template_language, $main_data );
	            $this->load->library ( 'parser' );
	            echo $this->parser->parse_string ( stripslashes ( $template ), $data, true );
	            return;
	            break;
	    }
	}

	function get_template_mail_data($template_id, $template_local_type = "local"){
		$return_data = array();
		$return_data["mail_title"] = "";
		$return_data["mail_body"] = "";
		
		$table = "templates";
        switch ($template_local_type) {
            case "local":
                $table = "templates";
                break;
            case "global":
                $table = "global_hotelix_common.templates";
                break;
        }
		
		$sql = "SELECT mail_title, mail_body, use_us FROM ".$table." WHERE id = ".$template_id;
		//echo $sql;
		$query = $this->db->query ( $sql );
		$template = "";
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$return_data["mail_title"] = stripslashes ( $row->mail_title );
			$return_data["mail_body"] = stripslashes ( $row->mail_body );
			$return_data["use_us"] = $row->use_us;
		}

		return $return_data;
	}

	function send_template_toemail_OLD($data, $debug = true){
	    $this->load->library('m_pdf');

	    $template_id = $data["send_id_template"];
	    $reservation_id = $data["reservation_id"];
	    $email = $data["send_email"];

	    $this->load->library ( 'email' );
	    $config = array();
	    $config = $this->hms_mail->getparam(3);
	    $this->email->initialize ( $config );

	    $ttemplate_data = array();
	    $ttemplate_data["template_id"] = $template_id;
	    $ttemplate_data["reservation_id"] = $reservation_id;

	    if(isset($data["service"])){
	        $ttemplate_data["service"] = $data["service"];
	    }

	    if(isset($data["guests"])){
	        $ttemplate_data["guests"] = $data["guests"];
	    }

	    if(isset($data["location_type"])){
	        $ttemplate_data["template_location_type"] = $data["location_type"];
	    }
	    //echo "<pre>";
	    //print_r($ttemplate_data);
	    //die();
	    $template = $this->get_template($ttemplate_data, 1);
// 	    $template = '<table border="0" cellpadding="0" cellspacing="0" style="margin: 0px; padding: 0px;  border: 0px; background-color:
// #ffffff; font-family: blinkmacsystemfont, -apple-system,  roboto, helvetica, arial,  sans-serif;
// font-size: 14px; line-height: 20px; -webkit-print-color-adjust: exact !important;" width="100%">
// 	<tbody>
// 	<tr>
// 		<td align="center" style="margin: 0px; padding: 0px; border: 0px; background-color: #ffffff;  font-family:
// 		blinkmacsystemfont, -apple-system, , roboto, helvetica, arial, sans-serif; font-size: 14px;
// 		 line-height: 20px; color: #383838;" valign="top">
// 			<table border="0" cellpadding="0" cellspacing="0" style="margin: 0px; padding: 0px; border: 0px; width: 700px;" width="700">
// 				<tbody>
// 				<tr>
// 					<td style="margin: 0px; padding: 0px; border: 0px; text-align: left;" valign="top">
// 						<table border="0" cellpadding="0" cellspacing="0" style="margin: 0px; padding: 0px; border: 0px; width: 100%; min-width: 100%;" width="100%">
// 							<tbody>
// 							<tr>
// 								<td style="margin: 0px; padding: 0px; border: 0px;" valign="top">
// 									<table border="0" cellpadding="0" cellspacing="0" style="margin: 0px; padding: 0px; border: 0px; width: 100%; min-width: 100%;" width="100%">
// 										<tbody>
// 										<tr>
// 											<td style="margin: 0px; padding: 0px; border: 0px; text-align: left;" valign="top">
// 												<table border="0" cellpadding="0" cellspacing="0" style="margin: 0px; padding: 0px; border: 0px; width: 100%; min-width: 100%;" width="100%">
// 													<tbody>
// 													<tr>
// 														<td style="padding-left: 8px; padding-right: 8px;">
// 															<table border="0" cellpadding="0" cellspacing="0" style="margin: 0px; padding: 0px; border: 0px; width: 100%; min-width: 100%;" width="100%">
// 																<tbody>
// 																<tr>
// 																	<td style="padding: 8px; text-align: left;" valign="top">
// 																		<table border="0" cellpadding="0" cellspacing="0" width="100%">
// 																			<tbody>
// 																			<tr>
// 																				<td style="text-align: left;" valign="top">
// 																				<table border="0" cellpadding="0" cellspacing="0" width="100%">
// 																					<tbody>
// 																					<tr>
// 																						<td style="text-align: left; font-family: blinkmacsystemfont, -apple-system,  roboto, helvetica, arial, sans-serif; margin: 0px; padding: 8px 0px; border-width: 0px 0px 1px; border-image: initial; width: 70%; border-color: initial initial #ededed initial; border-style: initial initial solid initial; line-height: 30px; padding-top: 2px;" valign="top"></td>
// 	    		<td style="text-align: left; font-family: blinkmacsystemfont, -apple-system,  roboto, helvetica, arial, sans-serif; margin: 0px; padding: 8px 0px; border-width: 0px 0px 1px; border-image: initial; width: 70%; border-color: initial initial #ededed initial; border-style: initial initial solid initial; line-height: 30px; padding-top: 2px;" valign="top">
//     		PRETEST</td>
// 	    		<td style="text-align: left; font-family: blinkmacsystemfont, -apple-system,  roboto, helvetica, arial, sans-serif; margin: 0px; padding: 8px 0px; border-width: 0px 0px 1px; border-image: initial; width: 70%; border-color: initial initial #ededed initial; border-style: initial initial solid initial; line-height: 30px; padding-top: 2px;" valign="top">
//     		    <img style="width: 20px; float: left; padding-top: 5px; padding-right: 8px; margin-left: -2px;" src="data:image/svg+xml;base64,&#10;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">
//     		</td>
// 																					</tr>
// 																					</tbody>
// 																				</table>
// 																				</td>
// 																			</tr>
// 																			</tbody>
// 																		</table>
// 																	</td>
// 																</tr>
// 																</tbody>
// 															</table>
// 														</td>
// 													</tr>
// 													</tbody>
// 												</table>
// 											</td>
// 										</tr>
// 										</tbody>
// 									</table>
// 								</td>
// 							</tr>
// 							</tbody>
// 						</table>
// 					</td>
// 				</tr>
// 				</tbody>
// 			</table>
// 		</td>
// 	</tr>
// 	</tbody>
// </table>';

	    $template_mail_data = $this->get_template_mail_data($template_id);

	    //================= SEND EMAIL ============================================//cltelexlv@gmail.com

	    $subj = $template_mail_data["mail_title"];

	    $this->email->to ( $email );
	    $this->email->from ( $config['from'], 'HMS OtelMS' );
	    $this->email->subject ( $subj );


	    $isfile = false;

	    if(isset($template_mail_data["use_us"]) && ($template_mail_data["use_us"] == "vemail")) {

	        $isfile = true;
	        $this->m_pdf->pdf->WriteHTML($template);

// 	        $this->m_pdf->pdf->WriteHTML('Beginning bit of document...');//WriteHTML($template);Beginning bit of document...
// 	        $this->m_pdf->pdf->WriteFixedPosHTML('This text will appear just where I want it!', 1, 1, 1, 1, 'visible');

	        $file_name = $subj . '.pdf';
	        //$file = '/tmp/'.$file_name.'.pdf';

	        $pdf_str = $this->m_pdf->pdf->Output($file_name,'S');

	        //$template = $template . $template;
// 	        $template = "";

// 	        $template = "<h1>test</h1>" . $template;
// 	        $template = "<h1>test</h1>" . $template;
// 	        $template = "<h1>test</h1>" . $template;
// 	        $template = "<h1>test</h1>" . $template;
// 	        $template = "<h1>test</h1>" . $template;
// 	        $template = "<h1>test</h1>" . $template;
// 	        $template = "<h1>test</h1>" . $template;
// 	        $template = "<h1>test</h1>" . $template;
// 	        $template = "<h1>test</h1>" . $template;
// 	        $template = "<h1>test</h1>" . $template;
// 	        $template = "<h1>test</h1>" . $template;
// 	        $template = "<h1>test</h1>" . $template;
// 	        $template = "<h1>test</h1>" . $template;

	        $this->email->message ( $template );

	        //$this->email->message ( "test123" );

	        $tmp_name = "FA".$this->config->item ( 'hotel_id' )."".mt_rand(0,999999);
	        $file = '/tmp/'.$tmp_name.'.pdf';


	        file_put_contents($file, $pdf_str);

	        $this->email->attach( $file, 'attachment', $file_name);
	        //$this->email->attach($template, 'attachment', 'test_report.html', 'application/html');
	        //unlink($file);
	    }else{
	        $this->email->message ( $template );
	    }


	    if (! $this->email->send ()) {
	        if($debug){
	           show_error ( $this->email->print_debugger () );
	           echo '1. E-mail error!\n';
	        }
	        $config = $this->hms_mail->getparam(1);
	        $this->email->initialize ( $config );
	        $this->email->from ( $config['from'], 'HMS OtelMS' );
	        if (! $this->email->send ()) {
	            if($debug)
	               echo '2. E-mail error!\n';
	        }
	    } else {
	        if($debug)
	           echo 'Your e-mail has been sent!\n';
	    }
	    if($isfile) {
	       unlink($file);
	    }
	}
	
	function send_template_toemail_curl($data, $debug = true, $result_type = 0)
    {
// 	    echo "<pre>";
// 	    print_r($data);
// 	    die();
        $this->load->library('m_pdf');
        
        $this->m_pdf->clear();
        
        $template_id = $data["send_id_template"];
        $reservation_id = $data["reservation_id"];
        $email = $data["send_email"];
        
        $ttemplate_data = array();
        $ttemplate_data["template_id"] = $template_id;
        $ttemplate_data["reservation_id"] = $reservation_id;
        
        if (isset($data["service"])) {
            $ttemplate_data["service"] = $data["service"];
        }
        
        if (isset($data["guests"])) {
            $ttemplate_data["guests"] = $data["guests"];
        }
        
        $template_local_type = "local";
        if (isset($data["location_type"])) {
            $ttemplate_data["template_location_type"] = $data["location_type"];
            $template_local_type = $data["location_type"];
        }
        
        if(isset($data["pay_amount"])){
            $ttemplate_data["template_pay_amount"] = $data["pay_amount"];
        }
        
        // echo "<pre>";
        // print_r($ttemplate_data);
        // die();
        $template = $this->get_template($ttemplate_data, 1);
        
        $template_mail_data = $this->get_template_mail_data($template_id, $template_local_type);
        
        
//         echo "<pre>";
//         print_r($template_mail_data);
        $subj = $template_mail_data["mail_title"]." ($reservation_id)";
        
        $isfile = false;
        
        $pdf_str = "";
        if (isset($template_mail_data["use_us"]) && ($template_mail_data["use_us"] == "vemail")) {
            
            $isfile = true;
            $this->m_pdf->pdf->WriteHTML($template);
            
            $file_name = $subj . '.pdf';
            //echo $template."<br>";
            
            $pdf_str = $this->m_pdf->pdf->Output($file_name, 'S');
            //echo $pdf_str."<br>";;
        }
        
        $db_name = $this->db->database;
        
        if (isset($data["host"])) {
            $host = $data["host"];
        } else {
            $host = "";
            if ($db_name != "") {
                $query = $this->db->query("SELECT host FROM visitka.config WHERE db_name LIKE '" . $db_name . "'");
                
                if ($query->num_rows() > 0) {
                    $row = $query->row();
                    $host = $row->host;
                }
            }
        }
        
        // ======= GET TEMPLATE LANGUAGE START ============
        $table = "templates";
        if(isset($ttemplate_data["template_location_type"])){
            switch ($ttemplate_data["template_location_type"]) {
                case "local":
                    $table = "templates";
                    break;
                case "global":
                    $table = "global_hotelix_common.templates";
                    break;
            }
        }
        $sql = "SELECT templates.language, templates.name as template_name FROM ".$table." WHERE templates.id = " . $template_id;
        //echo $sql;
        $query = $this->db->query ( $sql );
        $template_language = "";
        $template_name = "";
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $template_language = $row->language;
            $template_name = $row->template_name;
        }
        
        // ======= GET TEMPLATE LANGUAGE END ============
        
        $mail_body_data = array();
        $mail_body_data = $this->get_order_data_v2($reservation_id, 0, 0, $template_language);
        
        $mail_body = $this->parser->parse_string ( stripslashes ( $template_mail_data["mail_body"] ), $mail_body_data, true );
        
        // ====== log =====
        $send_log_template = array();
        $send_log_template ['email'] = $email;
        $send_log_template ['reservation_id'] = $reservation_id;
        $send_log_template ['template_id'] = $template_id;
        $send_log_template ['template_name'] = $template_name;
        $send_log_template ['create_time'] = date('Y-m-d H:i');
        $this->loger->log_send_template($send_log_template);
        // ====== log end ====
        $log_data = array();
        $log_data ["s_id"] = $template_id;
        $log_data ["description"] = "template_id: $template_id";
        //$log_data ["description"] = $this->loger->StoreDescription ( array('template_id' => $template_id), array('template_id' => $template_id) );
        $log_data ["res_id"] = $reservation_id;
        $log_data ["amount"] = 0;
        $this->loger->SaveLog ( $log_data, "template", "send" );
        
        // ================= SEND EMAIL ============================================
        $url = "https://" . $host . "/outside_gate/Test/send_email";
        //echo $url."<br>++++++++++++++";;
        $curl_data = array();
        $curl_data["hotel_id"] = $this->config->item('hotel_id');
        $curl_data["email_cfg_way"] = $this->config->item('email_way_rescue');
        $curl_data["custom_outside_mail_gate"] = $this->config->item('custom_outside_mail_gate');
        $curl_data["attachment"] = base64_encode($pdf_str);
        $curl_data["subject"] = $subj;
        $curl_data["message"] = $template;
        $curl_data["mail_body"] = $mail_body;
        $curl_data["use_us"] = $template_mail_data["use_us"];
        $curl_data["email"] = $email;
        $curl_data["property_name"] = $mail_body_data ['fpl_hotel_name_by_category_property'];
        
        $curl_data["use_user_smtp"] = $this->hotelix_config->get_record("use_user_smtp", "int");
        
        $email_config = array();
        $email_config[4] = $this->hms_mail->getparam(4);
        $email_config[3] = $this->hms_mail->getparam(3);
        $email_config[2] = $this->hms_mail->getparam(2);
        //print_r($this->hms_mail->getparam(2));
        //die();
        $email_config[1] = $this->hms_mail->getparam(1);
         //echo "<pre>";
         //print_r($curl_data);
//         die();
        
        $curl_data["email_config"] = $email_config;
        
        $output = json_encode($curl_data);

        $result = $this->Curl_model->CurlPlugRaw_clean($output, $url);
         //echo $result;
         //die();
        if ($result_type == 0) {
            $data_msg = array();
            $this->mlanguages->getdictionary ( "home_msg_hms_massages", "", $data_msg );
            $message_str = '<h3>{mlw_system_message}</h3>' . $result;
           
            $msg = $this->debugmodel->make_up_messege($message_str);
            echo $this->parser->parse_string ( $msg, $data_msg, true );
            // echo $result;
        } else {
            return $result;
        }
    }

	public function pdf($template = 'invoice_ru_company_company_advance')
	{
	    $this->load->library('m_pdf');

	    $ttemplate_data = array();
	    $ttemplate_data["template_id"] = 311;
	    $ttemplate_data["reservation_id"] = 17614;

	    $html = $this->get_template($ttemplate_data, 1);
	    //echo $html;
	    //die();

	    $filename = $template.'.pdf';
	    $this->m_pdf->pdf->WriteHTML($html);
	    $file_str = $this->m_pdf->pdf->Output('','S');

	    $tmp_name = "FA".$this->config->item ( 'hotel_id' )."".mt_rand(0,999999);
	    $file = '/tmp/'.$tmp_name.'.pdf';


	    file_put_contents($file, $file_str);

	    $this->send_mail('vyachmenev@otelms.com','Тест PDF',
	        'ferents.yurij@gmail.com',
	        'Тестовая форма на почту', '<h4>TEST PDF</h4>', $file,
	        $filename);
	}

	private function send_mail($from, $name, $to, $subject, $body, $file =
	    null, $filename = null)
	{
	    $this->load->library ( 'email' );
	    $config = array();
	    $config = $this->hms_mail->getparam(3);
	    $this->email->initialize ( $config );

	    $this->email->from($config["from"], $name);
	    $this->email->to($to);
	    $this->email->subject($subject);
	    $this->email->message($body);
	    ! isset( $file ) ? '' : $this->email->attach($file,
	        'attachment', $filename, 'application/pdf');
        if (!$this->email->send()) {
            show_error($this->email->print_debugger());
            echo '1. E-mail error!\n';
        } else {
            echo $this->email->print_debugger();
	           echo 'Your e-mail has been sent!\n';
	    }

	}
}
?>