<?php
class formsprinter_model extends CI_Model {
	function __construct() {
		parent::__construct ();

		$this->load->model ( 'frontdesk' );
		$this->load->model ( 'fms_core' );
	}


	function get_order_data($reservation_id, $guest_id = 0, $services = array()) {
	    $data = array();
        
	    if($guest_id <> 0){
	        $guest_sql = " INNER JOIN guests ON guests.id = ".$guest_id;
	    }else{
	        $guest_sql = " INNER JOIN guests ON deskofreservation.guest_id = guests.id ";
	    }

	    $legalsystem = $this->frontdesk->getlegalsystem();
	    $legalsystem_db = $this->frontdesk->getlegalsystem_db($legalsystem);
	    $dict_entrygoal_mass = $this->fms_core->get_dict_entrygoal($legalsystem_db);
	    $dict_documenttype_mass = $this->fms_core->get_dict_documenttype($legalsystem_db);

	    $doc_types = array ();
	    $query = $this->db->query ( "SELECT * FROM doc_types" );
	    foreach ( $query->result () as $row ) {
	        $doc_types[$row->id] = $row->name;
	    }
	    $custom_ServicesList = array();
	    $ServicesList = array();
	    $s_counter = 1;
	    $cs_counter = 1;
	    $services_summ = 0;

	    $sql = "SELECT guests.*, deskofreservation.id as res_id,
	    services_types.name as services_name, dealers.name as s_dealer,
	    services.id as services_id, services.action_time as services_action_time,
	    services.count as services_count, services.description as services_description,
	    services.time as services_time, services.amount, services.price, rooms.name as room_name,
	    categories.name as categories_name, services.time as service_create_time FROM deskofreservation
	    $guest_sql
	    INNER JOIN rooms ON rooms.id=deskofreservation.room_id
	    INNER JOIN categories ON categories.id=rooms.category_id
	    INNER JOIN services ON services.reservation_id = deskofreservation.id
	    INNER JOIN  services_types ON  services_types.id = services.type
	    LEFT JOIN dealers ON dealers.id=services.id_dealer
	    WHERE deskofreservation.id = ".$reservation_id."
				ORDER by services.action_time ASC";
	    $query2 = $this->db->query ( $sql );
	    foreach ( $query2->result () as $row2 ) {
	        if(isset($services["service"][$row2->services_id])){
	            array_push ( $custom_ServicesList, array (
	                'fpl_services_type' => "service",
	                'fpl_services_id' => $row2->services_id,
	                'fpl_services_name' => $row2->services_name,
	                'fpl_services_action_time' => $this->frontdesk->systemdateformat($row2->services_action_time),
	                'fpl_service_create_time' => $this->frontdesk->systemdateformat($row2->service_create_time),
	                'fpl_services_services_count' => $row2->services_count,
	                'fpl_s_dealer' => $row2->s_dealer,
	                'fpl_services_time' => $this->frontdesk->systemdateformat($row2->services_time),
	                'fpl_servicesamount' => $this->frontdesk->showcurrency ( $row2->amount ),
	                'fpl_servicesamount_perunit' => $this->frontdesk->showcurrency ( $row2->price ),
	                'fpl_counter' => $cs_counter,
	                'fpl_services_description' => $row2->services_description
	            ) );
	            $cs_counter++;
	        }
	        array_push ( $ServicesList, array (
	            'fpl_services_id' => $row2->services_id,
	            'fpl_services_name' => $row2->services_name,
	            'fpl_services_action_time' => $this->frontdesk->systemdateformat($row2->services_action_time),
	            'fpl_service_create_time' => $this->frontdesk->systemdateformat($row2->service_create_time),
	            'fpl_services_services_count' => $row2->services_count,
	            'fpl_s_dealer' => $row2->s_dealer,
	            'fpl_services_time' => $this->frontdesk->systemdateformat($row2->services_time),
	            'fpl_servicesamount' => $this->frontdesk->showcurrency ( $row2->amount ),
	            'fpl_servicesamount_perunit' => $this->frontdesk->showcurrency ( $row2->price ),
	            'fpl_counter' => $s_counter,
	            'fpl_services_description' => $row2->services_description
	        ) );

	        $services_summ += $row2->amount;

	        $s_counter++;

	    }
	    //=============================================================================================
	    //=============================================================================================
	    //=============================================================================================
	    $paymentList = array();
	    $paid_sum = 0;
	    $sql = "SELECT guests.*, payment_types.name, payment.create_time, bso_records.id as bso_id,
	    payment.description, payment.amount as total, payment.id as id_payment,
	    rooms.name as room_name, categories.name as categories_name, checkprn_gate.checkstatus,
	    checkprn_gate.id as checkprn_id, bso_records.code as bso_code, bso_records.number as bso_number
	    FROM deskofreservation
	    $guest_sql
	    INNER JOIN rooms ON rooms.id=deskofreservation.room_id
	    INNER JOIN categories ON categories.id=rooms.category_id
	    INNER JOIN payment ON payment.reservation_id = deskofreservation.id
	    LEFT JOIN checkprn_gate ON checkprn_gate.payment_id = payment.id
	    LEFT JOIN  bso_records ON  bso_records.payment_id = payment.id
	    INNER JOIN payment_types ON payment_types.id = payment.type
	    WHERE deskofreservation.id = ".$reservation_id." ORDER by guests.id ASC";
	    $query2 = $this->db->query ( $sql );

	    foreach ( $query2->result () as $row2 ) {
	        $paid_sum += $row2->total;
	        array_push ( $paymentList, array (
	            'fpl_typename' => $row2->name,
	            'fpl_total' => $this->frontdesk->showcurrency ( $row2->total ),
	            'fpl_pay_description' => $row2->description,
	            'fpl_type' => $row2->categories_name,
	            'fpl_create_time' => $this->frontdesk->systemdateformat($row2->create_time),
	            'fpl_bso_code' => $row2->bso_code,
	            'fpl_bso_number' => $row2->bso_number
	        ) );
	    }
	    //=============================================================================================
	    $rates = array ();
	    $query = $this->db->query ( "SELECT * FROM rate WHERE isactive = 1" );
	    foreach ( $query->result () as $row ) {
	        $rates [$row->id] = $row->caption;
	    }
	    //=============================================================================================
	    $service_main_ismanual = 0;
	    $query2 = $this->db->query ( "SELECT * FROM services_main WHERE reservation_id = " . $reservation_id );

	    if ($query2->num_rows () > 0) {
	        $row2 = $query2->row ();
	        $service_main_ismanual = $row2->ismanual;

	    }
	    //=============================================================================================
	    $ud_price_category = 0;
	    $query2 = $this->db->query ( "SELECT ud_price_category FROM deskofreservation WHERE id = " . $reservation_id );

	    if ($query2->num_rows () > 0) {
	        $row2 = $query2->row ();
	        $ud_price_category = $row2->ud_price_category;

	    }

	    //=============================================================================================
	    $categories_names = array();
	    $sql = "SELECT id, shortname FROM categories";
	    $query2 = $this->db->query ( $sql );

	    foreach ( $query2->result () as $row2 ) {
	        $categories_names [$row2->id] = $row2->shortname;
	    }
	    //=============================== tarification =========================================

	    $data_tarification = array();
	    $data_tarification["rates"] = array();
	    $deskofdays_prices = $this->frontdesk->getdeskofdays_price ( $reservation_id );
	    $seasons_statistics = $this->frontdesk->getpricecalculation ( 0, $reservation_id, 0, 1 );

	    if ($seasons_statistics == 0) {
	    } else {
	        $i = 0;
	        foreach ( $deskofdays_prices as $intdate => $cell ) {
	            $type_place = "";
	            if (isset ( $seasons_statistics [$intdate] ["season_id"] )) {
	                $season_id = $seasons_statistics [$intdate] ["season_id"];
	                if (isset ( $rates [$seasons_statistics [$intdate] ["price_type"]])) {
	                   $rate_name = $rates [$seasons_statistics [$intdate] ["price_type"]];
	                }else{
	                    $rate_name = "";
	                }
	                if (isset ( $seasons_statistics [$intdate] ["season_id"] )) {
	                    switch ($service_main_ismanual) {
	                        case 0 :
	                            $data_tarification ["rates"] [$i] ["fpl_rate_strategy"] = $rate_name;
	                            break;
	                        case 1 :
	                            $data_tarification ["rates"] [$i] ["fpl_rate_strategy"] = "{mlw_cost_fixed}";
	                            break;
	                        case 2 :
	                            $data_tarification ["rates"] [$i] ["fpl_rate_strategy"] = "{mlw_cost_daily}";
	                            break;
	                        default :
	                            $data_tarification ["rates"] [$i] ["fpl_rate_strategy"] = $rate_name;
	                            break;
	                    }
	                }
	                if (isset ( $deskofdays_prices [$intdate] )) {
	                    if (isset ( $seasons_statistics [$intdate] ["season_id"] )) {
	                        $data_tarification ["rates"] [$i] ["fpl_day_price"] = $this->frontdesk->showcurrency ( $deskofdays_prices [$intdate] ["price"] );
	                    } else {
	                        $data_tarification ["rates"] [$i] ["fpl_day_price"] = $this->frontdesk->showcurrency ( $deskofdays_prices [$intdate] ["price"] );
	                    }
	                } else {
	                    $data_tarification ["rates"] [$i] ["fpl_day_price"] = "";
	                }
	                $data_tarification ["rates"] [$i] ["fpl_day_rate"] = $rate_name;
	                if(isset($categories_names[$ud_price_category])){
	                    $data_tarification ["rates"] [$i] ["fpl_rate_taken"] = $categories_names[$ud_price_category];
	                }else{
	                    $data_tarification ["rates"] [$i] ["fpl_rate_taken"] = "";
	                }

	                $i++;
	            }
	        }
	    }



	    //=============================================================================================
	    //=============================================================================================
	    //=============================================================================================
	    $ServicesMainList = array();
	    $sql = "SELECT guests.*, deskofreservation.id as res_id,
	    services_types_main.name as services_name, services_main.id as services_id,
	    dealers.name as sm_dealer,services_main.description as services_main_description,
	    services_main.time as services_time, services_main.amount, services_main.time as service_create_time FROM deskofreservation
	    $guest_sql
	    INNER JOIN rooms ON rooms.id=deskofreservation.room_id
	    INNER JOIN categories ON categories.id=rooms.category_id
	    INNER JOIN services_main ON services_main.reservation_id = deskofreservation.id
	    INNER JOIN  services_types_main ON  services_types_main.id = services_main.type
	    LEFT JOIN dealers ON dealers.id=services_main.id_dealer
	    WHERE services_main.type = 2
	    AND deskofreservation.id = ".$reservation_id." ORDER by deskofreservation.id ASC";
	    $query2 = $this->db->query ( $sql );
	    $cancelation_payment_sum = 0;
	    foreach ( $query2->result () as $row2 ) {
	        $query_pay = $this->db->query ( "SELECT check_payment_items.* FROM check_payment_items INNER JOIN payment ON payment.id = check_payment_items.check_payment_id INNER JOIN services_main ON services_main.id = check_payment_items.item_id WHERE check_payment_items.reservation_id = ".$reservation_id." AND check_payment_items.item_id = $row2->services_id AND check_payment_items.item_service_table_id = 2" );
	        $pay_status = "-";
	        if ($query_pay->num_rows () > 0) {
	            $pay_status = "Да";
	        }
	        $cancelation_payment_sum += $row2->amount;

	        if(isset($services["main_service"][$row2->services_id])){
	            array_push ( $custom_ServicesList, array (
	                'fpl_services_type' => "main_service",
	                'fpl_services_id' => $row2->services_id,
	                'fpl_services_name' => $row2->services_name,
	                'fpl_services_action_time' => "",
	                'fpl_service_create_time' => $row2->service_create_time,
	                'fpl_services_services_count' => 1,
	                'fpl_s_dealer' => $row2->sm_dealer,
	                'fpl_services_time' => $this->frontdesk->systemdateformat($row2->services_time),
	                'fpl_servicesamount' => $this->frontdesk->showcurrency ( $row2->amount ),
	                'fpl_servicesamount_perunit' => $this->frontdesk->showcurrency ( $row2->amount ),
	                'fpl_counter' => $cs_counter,
	                'fpl_services_description' => $row2->services_main_description
	            ) );
	            $cs_counter++;
	        }
	        array_push ( $ServicesMainList, array (
	            'fpl_pay_status' => $pay_status,
	            'fpl_services_id' => $row2->services_id,
	            'fpl_services_name' => $row2->services_name,
	            'fpl_s_dealer' => $row2->sm_dealer,
	            'fpl_service_create_time' => $this->frontdesk->systemdateformat($row2->service_create_time),
	            'fpl_services_time' => $this->frontdesk->systemdateformat($row2->services_time),
	            'fpl_servicesamount' => $this->frontdesk->showcurrency ( $row2->amount ),
	            'fpl_servicesamount_perunit' => $this->frontdesk->showcurrency ( $row2->amount ),
	            'fpl_counter' => $s_counter,
	            'fpl_services_description' => $row2->services_main_description
	        ) );

	        $services_summ += $row2->amount;

	        $s_counter++;
	    }
	    //=============================================================================================
	    //=============================================================================================
	    //=============================================================================================
	    $query2 = $this->db->query ( "SELECT guests.*, deskofreservation.id as res_id,
	        services_types_main.name as services_name, services_main.id as services_id,
	        dealers.name as sm_dealer, services_main.description as services_main_description,
	        services_main.time as services_time, services_main.amount, services_main.time as service_create_time FROM deskofreservation
	        $guest_sql
	        INNER JOIN rooms ON rooms.id=deskofreservation.room_id
	        INNER JOIN categories ON categories.id=rooms.category_id
	        INNER JOIN services_main ON services_main.reservation_id = deskofreservation.id
	        INNER JOIN  services_types_main ON  services_types_main.id = services_main.type
	        LEFT JOIN dealers ON dealers.id=services_main.id_dealer
	        WHERE (services_main.type = 1 OR services_main.type = 3 OR services_main.type = 4 OR services_main.type = 5) AND
	        deskofreservation.id = ".$reservation_id." ORDER by deskofreservation.id ASC" );
	        foreach ( $query2->result () as $row2 ) {
	            if(isset($services["main_service"][$row2->services_id])){
	                array_push ( $custom_ServicesList, array (
	                    'fpl_services_type' => "main_service",
	                    'fpl_services_id' => $row2->services_id,
	                    'fpl_services_name' => $row2->services_name,
	                    'fpl_services_action_time' => "",
	                    'fpl_service_create_time' => $row2->service_create_time,
	                    'fpl_services_services_count' => 1,
	                    'fpl_s_dealer' => $row2->sm_dealer,
	                    'fpl_services_time' => $this->frontdesk->systemdateformat($row2->services_time),
	                    'fpl_servicesamount' => $this->frontdesk->showcurrency ( $row2->amount ),
	                    'fpl_services_description' => $row2->services_main_description
	                ) );
	            }
	            array_push ( $ServicesMainList, array (
	                'fpl_services_id' => $row2->services_id,
	                'fpl_services_name' => $row2->services_name,
	                'fpl_s_dealer' => $row2->sm_dealer,
	                'fpl_service_create_time' => $row2->service_create_time,
	                'fpl_services_time' => $row2->services_time,
	                'fpl_servicesamount' => $this->frontdesk->showcurrency ( $row2->amount ),
	                'fpl_services_description' => $row2->services_main_description
	            ) );
	        }
	        //=============================================================================================
	        //=============================================================================================
	        //=============================================================================================
	        $RefundList = array();
	        $query2 = $this->db->query ( "SELECT guests.*, deskofreservation.id as res_id,
	            payment_types.name as payment_name, refund.id as refund_id, refund.time as refund_time,
	            refund.description, refund.amount, rooms.name as room_name,
	            categories.name as categories_name FROM deskofreservation
	            $guest_sql
	            INNER JOIN rooms ON rooms.id=deskofreservation.room_id
	            INNER JOIN categories ON categories.id=rooms.category_id
	            INNER JOIN refund ON refund.reservation_id = deskofreservation.id
	            INNER JOIN  payment_types ON  payment_types.id = refund.type
	            WHERE deskofreservation.id = ".$reservation_id." ORDER by guests.id ASC" );
	            foreach ( $query2->result () as $row2 ) {

	                array_push ( $RefundList, array (
	                    'fpl_refund_id' => $row2->refund_id,
	                    'fpl_payment_name' => $row2->payment_name,
	                    'fpl_refund_time' => $this->frontdesk->systemdateformat($row2->refund_time),
	                    'fpl_refund_description' => $row2->description,
	                    'fpl_refundamount' => $this->frontdesk->showcurrency ( $row2->amount )
	                ) );
	            }
	            //=============================================================================================
	            //=============================================================================================
	            //=============================================================================================
	            $documentsList = array ();
	            $query2 = $this->db->query ( "SELECT documents.*, users.fullname, users.lastname FROM documents INNER JOIN deskofreservation ON deskofreservation.id=documents.reservation_id
				INNER JOIN users ON users.id = documents.user_id WHERE deskofreservation.id = ".$reservation_id );
	            foreach ( $query2->result () as $row2 ) {

	                array_push ( $documentsList, array (
	                    'fpl_document_id' => $row2->id,
	                    'fpl_firstname' => $row2->firstname,
	                    'fpl_lastname' => $row2->lastname,
	                    'fpl_document_description' => $row2->description,
	                    'fpl_filename' => $row2->filename
	                ) );
	            }
	            //=============================================================================================
	            //=============================================================================================
	            //=============================================================================================
	            $guestsList = array ();


	            $query2 = $this->db->query ( "SELECT guests.*, reservation_details.* FROM guests
				INNER JOIN guests_deskofreservation ON guests_deskofreservation.guest_id=guests.id
				INNER JOIN deskofreservation ON deskofreservation.id=guests_deskofreservation.reservation_id
				INNER JOIN reservation_details ON (reservation_details.guest_id = guests.id AND reservation_details.reservation_id = deskofreservation.id)
				WHERE deskofreservation.id = " . $reservation_id );
	            foreach ( $query2->result () as $row2 ) {

	                if (isset ( $dict_entrygoal_mass [$row2->goal_id] ["id"] )) {
	                    $goal = $dict_entrygoal_mass [$row2->goal_id] ["id"];
	                } else {
	                    $goal = "";
	                }
	                if (isset ( $doc_types [$row2->doc_type] )) {
	                    $doc_type = $doc_types [$row2->doc_type];
	                } else {
	                    if(isset($dict_documenttype_mass [$row2->doc_type] ["name"])){
	                        $doc_type = $dict_documenttype_mass [$row2->doc_type] ["name"];
	                    }else{
	                        $doc_type = "";
	                    }
	                }

	                $fpl_full_address_rus = "";

	                if(trim($row2->address) <> "" ){
	                    $fpl_full_address_rus .= $row2->address;
	                }
	                if(trim($row2->addrbuilding) <> "" ){
	                    $fpl_full_address_rus .= " д. ".$row2->addrbuilding;
	                }
	                if(trim($row2->addrhousing) <> "" ){
	                    $fpl_full_address_rus .= " корп. ".$row2->addrhousing;
	                }
	                if(trim($row2->addrapt) <> "" ){
	                    $fpl_full_address_rus .= " кв. ".$row2->addrapt;
	                }

	                if(isset($natiomality_mass[$row2->nationality])){
	                    $nationality_guestlist = $natiomality_mass[$row2->nationality];
	                }else{
	                    $nationality_guestlist = "";
	                }

	                $gender = "";
	                switch ($row2->gender) {
	                    case 1 :
	                        $gender = "Мужской";
	                        break;
	                    case 2 :
	                        $gender = "Женский";
	                        break;
	                }

	                $guestsList[$row2->id] = array (
	                    'fpl_guest_id' => $row2->id,
	                    'fpl_firstname' => $row2->firstname,
	                    'fpl_lastname' => $row2->lastname,
	                    'fpl_middlename' => $row2->middlename,
	                    'fpl_email' => $row2->email,
	                    'fpl_dob' => $this->frontdesk->systemdateformat($row2->dob),
	                    "fpl_phone" => $row2->phone,
	                    "fpl_citizenship" => $row2->citizenship,
	                    'fpl_city' => $row2->city,
	                    'fpl_state' => $row2->state,
	                    'fpl_pob_state' => $row2->pob_state,
	                    "fpl_guest_country" => $row2->country,
	                    'fpl_gl_full_address_rus' => $fpl_full_address_rus,
	                    'fpl_address' => $row2->address,
	                    'fpl_addrbuilding' => $row2->addrbuilding,
	                    'fpl_addrapt' => $row2->addrapt,
	                    'fpl_postcode' => $row2->postcode,
	                    'fpl_passportid' => $row2->passportid,
	                    'fpl_nationality' => $nationality_guestlist,
	                    'fpl_gender' => $gender,
	                    'fpl_doc_type' => $doc_type,
	                    'fpl_pob_city' => $row2->pob_city,
	                    'fpl_doc_precode' => $row2->doc_precode,
	                    'fpl_doc_date_open' => $this->frontdesk->systemdateformat($row2->doc_date_open),
	                    'fpl_doc_date_till' => $this->frontdesk->systemdateformat($row2->doc_date_till),
	                    'fpl_passportissuedby' => $row2->passportissuedby,
	                    'fpl_reg_visa_precode' => $row2->reg_visa_precode,
	                    'fpl_reg_visa_num' => $row2->reg_visa_num,
	                    'fpl_visamultiplicity' => $row2->visamultiplicity,
	                    'fpl_visitpurpose' => $row2->visitpurpose,
	                    'fpl_card_date_of_issue' => $this->frontdesk->systemdateformat($row2->card_date_of_issue),
	                    'fpl_migration_card_num' => $row2->migration_card_num,
	                    'fpl_migration_card_precode' => $row2->migration_card_precode,
	                    'fpl_dict_officialorgan_fmsCODE' => $row2->dict_officialorgan_fmsCODE,
	                    'fpl_reg_visa_type' => $row2->reg_visa_type,
	                    'fpl_card_date_of_issue' => $this->frontdesk->systemdateformat($row2->card_date_of_issue),
	                    'fpl_pob_city' => $row2->pob_city,
	                    'fpl_pob_district' => $row2->pob_district,


	                    'fpl_goal' => $goal,
	                ) ;
	            }

	            //=============================================================================================
	            //=============================================================================================
	            //=============================================================================================
	            $sql = "SELECT deskofreservation.*, partners.name as partner_name, partners.legal_name as partner_legal_name,
	            partners.ZKPO, partners.addrLine1, partners.addrLine2, partners.bankname,
	            partners.MFO, partners.DOC_INN, partners.DOC_SN, partners.correspondent_account, partners.accountnumber,
	            rooms.name as room_name, users.fullname as user_fullname, users.lastname as user_lastname,
	            users.middlename as user_middlename, partners.correspondent_account, dealers.name as dealer_name, rate.caption as tarif, reservation_details.visamultiplicity,
	            reservation_details.visitpurpose, reservation_details.goal_id, reservation_details.card_number, reservation_details.card_valid_time,
	            reservation_details.reg_visa_type as reg_visa_type_d, reservation_details.reg_visa_precode, reservation_details.reg_date_in as reg_date_in_d,
	            reservation_details.reg_date_out, reservation_details.migration_card_precode, reservation_details.migration_card_num, reservation_details.card_date_of_issue,
	            rooms.category_id as category_id, guests.firstname, guests.lastname, guests.middlename,
	            guests.phone, guests.passportid, guests.foreign, guests.address, guests.email,  guests.doc_type,
	            guests.nationality, guests.citizenship, guests.dob, guests.gender, guests.postcode, guests.country,
	            guests.state, guests.city, guests.addrbuilding, guests.addrapt, guests.addrhousing, guests.pob_state, guests.pob_city, guests.pob_district, guests.doc_date_open, guests.doc_precode,
	            guests.dict_officialorgan_fmsCODE, guests.passportissuedby
	            FROM deskofreservation
	            $guest_sql
	            INNER JOIN rooms ON deskofreservation.room_id = rooms.id
	            LEFT JOIN reservation_details ON (reservation_details.reservation_id = deskofreservation.id AND reservation_details.guest_id = guests.id)
	            LEFT JOIN reservation_goals ON reservation_details.goal_id = reservation_goals.id
	            LEFT JOIN rate ON deskofreservation.price_type = rate.id
	            LEFT JOIN dealers ON deskofreservation.id_dealer = dealers.id
	            LEFT JOIN users ON deskofreservation.id_user = users.id
	            LEFT JOIN partners ON deskofreservation.id_partner = partners.id
	            WHERE deskofreservation.id = " . $reservation_id;
	            //echo $sql."||";
	            $query = $this->db->query ( $sql );

	            $row = $query->row ();
	            //=============================================================================================
	            //=============================MAIN GUEST DATA============================================
	            //=============================================================================================
	            $natiomality_mass = array ();
	            $query2 = $this->db->query ( "SELECT * FROM language WHERE is_active = 1" );
	            foreach ( $query2->result () as $row2 ) {
	                $natiomality_mass [$row2->id] = $row2->name;
	            }

	            if(isset($natiomality_mass[$row->nationality])){
	                $nationality = $natiomality_mass[$row->nationality];
	            }else{
	                $nationality = "";
	            }


	            $query2 = $this->db->query ( "SELECT guests.*, reservation_details.*
	                FROM guests
	                INNER JOIN reservation_details ON reservation_details.guest_id = $row->guest_id
	                WHERE reservation_details.reservation_id = " . $reservation_id . " AND guests.id = " . $row->guest_id );
	            foreach ( $query2->result () as $row2 ) {

	                if (isset ( $dict_entrygoal_mass [$row2->goal_id] ["id"] )) {
	                    $goal = $dict_entrygoal_mass [$row2->goal_id] ["id"];
	                } else {
	                    $goal = "";
	                }
	                if (isset ( $doc_types [$row2->doc_type] )) {
	                    $doc_type = $doc_types [$row2->doc_type];
	                } else {
	                    if(isset($dict_documenttype_mass [$row2->doc_type] ["name"])){
	                        $doc_type = $dict_documenttype_mass [$row2->doc_type] ["name"];
	                    }else{
	                        $doc_type = "";
	                    }
	                }

	                $fpl_full_address_rus = "";

	                if(trim($row2->address) <> "" ){
	                    $fpl_full_address_rus .= $row2->address;
	                }
	                if(trim($row2->addrbuilding) <> "" ){
	                    $fpl_full_address_rus .= " д. ".$row2->addrbuilding;
	                }
	                if(trim($row2->addrhousing) <> "" ){
	                    $fpl_full_address_rus .= " корп. ".$row2->addrhousing;
	                }
	                if(trim($row2->addrapt) <> "" ){
	                    $fpl_full_address_rus .= " кв. ".$row2->addrapt;
	                }

	                if(isset($natiomality_mass[$row2->nationality])){
	                    $nationality_guestlist = $natiomality_mass[$row2->nationality];
	                }else{
	                    $nationality_guestlist = "";
	                }

	                $gender = "";
	                switch ($row2->gender) {
	                    case 1 :
	                        $gender = "Мужской";
	                        break;
	                    case 2 :
	                        $gender = "Женский";
	                        break;
	                }

	                $guestsList[$row2->id] = array (
	                    'fpl_guest_id' => $row2->id,
	                    'fpl_firstname' => $row2->firstname,
	                    'fpl_lastname' => $row2->lastname,
	                    'fpl_middlename' => $row2->middlename,
	                    'fpl_email' => $row2->email,
	                    'fpl_dob' => $this->frontdesk->systemdateformat($row2->dob),
	                    "fpl_phone" => $row2->phone,
	                    "fpl_foreign" => $row2->foreign,
	                    'fpl_nationality' => $nationality_guestlist,
	                    'fpl_gender' => $gender,
	                    "fpl_guest_country" => $row2->country,
	                    "fpl_citizenship" => $row2->citizenship,
	                    'fpl_city' => $row2->city,
	                    'fpl_state' => $row2->state,
	                    'fpl_pob_state' => $row2->pob_state,
	                    'fpl_city' => $row2->city,
	                    'fpl_gl_full_address_rus' => $fpl_full_address_rus,
	                    'fpl_address' => $row2->address,
	                    'fpl_addrbuilding' => $row2->addrbuilding,
	                    'fpl_addrhousing' => $row2->addrhousing,
	                    'fpl_addrapt' => $row2->addrapt,
	                    'fpl_postcode' => $row2->postcode,
	                    'fpl_passportid' => $row2->passportid,
	                    'fpl_doc_type' => $doc_type,
	                    'fpl_pob_city' => $row2->pob_city,
	                    'fpl_doc_precode' => $row2->doc_precode,
	                    'fpl_doc_date_open' => $this->frontdesk->systemdateformat($row2->doc_date_open),
	                    'fpl_doc_date_till' => $this->frontdesk->systemdateformat($row2->doc_date_till),
	                    'fpl_passportissuedby' => $row2->passportissuedby,
	                    'fpl_reg_visa_precode' => $row2->reg_visa_precode,
	                    'fpl_reg_visa_num' => $row2->reg_visa_num,
	                    'fpl_visamultiplicity' => $row2->visamultiplicity,
	                    'fpl_visitpurpose' => $row2->visitpurpose,
	                    'fpl_card_date_of_issue' => $this->frontdesk->systemdateformat($row2->card_date_of_issue),
	                    'fpl_migration_card_num' => $row2->migration_card_num,
	                    'fpl_migration_card_precode' => $row2->migration_card_precode,
	                    'fpl_dict_officialorgan_fmsCODE' => $row2->dict_officialorgan_fmsCODE,
	                    'fpl_reg_visa_type' => $row2->reg_visa_type,
	                    'fpl_card_date_of_issue' => $this->frontdesk->systemdateformat($row2->card_date_of_issue),
	                    'fpl_pob_city' => $row2->pob_city,
	                    'fpl_pob_district' => $row2->pob_district,
	                    'fpl_goal' => $goal,
	                );
	            }
	            //=============================================================================================
	            //=============================================================================================
	            //=============================================================================================
	            if ($row->price_type == 0) {
	                $tarif = "Ошибка!!!!";
	            } else {
	                $tarif = $row->tarif;
	            }

	            if (isset ( $doc_types [$row->doc_type] )) {
	                $doc_type = $doc_types [$row->doc_type];
	            } else {
	                if(isset($dict_documenttype_mass [$row->doc_type] ["name"])){
	                    $doc_type = $dict_documenttype_mass [$row->doc_type] ["name"];
	                }else{
	                    $doc_type = "";
	                }
	            }

	            $data ["fpl_daily_pricing"] = $data_tarification["rates"];



	            $data ["fpl_reservation_id"] = $reservation_id;

	            $data ['fpl_correspondent_account'] = $row->correspondent_account;
	            $data ['fpl_dealer_name'] = $row->dealer_name;
	            $data ['fpl_id_user'] = $row->id_user;
	            $data ['fpl_user_name'] = $row->user_lastname." ".$row->user_fullname." ".$row->user_middlename;
	            $data ['fpl_tarif'] = $tarif;
	            $data ['fpl_goal_id'] = $row->goal_id;
	            $data ['fpl_dc_rid_prev'] = $row->dc_rid_prev;
	            $data ['fpl_dc_rid_next'] = $row->dc_rid_next;

	            if(isset($categories_names[$ud_price_category])){
	                $data ['fpl_ud_price_category'] = $categories_names[$ud_price_category];
	            }else{
	                $data ['fpl_ud_price_category'] = "";
	            }

	            $data ['fpl_canceltoquota'] = $row->canceltoquota;
	            $data ['fpl_guest_id'] = $row->guest_id;
	            $data ['fpl_groupid'] = $row->groupid;
	            $data ['fpl_type_id'] = $row->category_id;
	            $data ['fpl_room_id'] = $row->room_id;
	            $data ['fpl_room_name'] = $row->room_name;
	            $data ['fpl_categories_name'] = $categories_names[$row->category_id];
	            $data ['fpl_adult_places'] = $row->adults;
	            $data ['fpl_add_places'] = $row->add_places;
	            $data ['fpl_baby_places'] = $row->baby_places;
	            $data ['fpl_babyplace2'] = $row->babyplace2;
	            $data ['fpl_addbedplace'] = $row->addbedplace;
	            $data ['fpl_free_places'] = $row->free_places;
	            $data ['fpl_total_guest_count'] = $row->adults + $row->baby_places + $row->babyplace2;
	            $data ['fpl_discount'] = $row->discount;
	            $data ['fpl_percent_discount'] = $row->percent_discount;
	            $data ['fpl_amount'] = $row->amount;
	            $data ['fpl_paid_sum'] = $paid_sum;
	            $data ['fpl_balance'] = $row->balance;
	            $data ['fpl_datein'] = $this->frontdesk->systemdateformat($row->datein);
	            $data ['fpl_duration'] = $row->duration;
	            $data ['fpl_description'] = $row->description;
	            $data ['fpl_maid_description'] = $row->maid_description;
	            $data ['fpl_dateout'] = $this->frontdesk->systemdateformat($row->dateout);
	            $data ['fpl_status'] = $row->status;
	            $data ['fpl_date'] = $this->frontdesk->systemdateformat($row->date);
	            $data ['fpl_resourse'] = $row->resourse;
	            $data ['fpl_commission'] = $row->commission;
	            $data ['fpl_user'] = $row->id_user;
	            $data ['fpl_dealer'] = $row->id_dealer;
	            $data ['fpl_id_company_customer'] = $row->id_company_customer;
	            $data ["fpl_price_type"] = $row->price_type;
	            $data ["fpl_isNew"] = $row->isNew;
	            $data ["fpl_isread"] = $row->isread;
	            // guests
	            $data ["fpl_firstname"] = $row->firstname;
	            $data ["fpl_lastname"] = $row->lastname;
	            $data ["fpl_middlename"] = $row->middlename;
	            $data ["fpl_phone"] = $row->phone;
	            $data ["fpl_passportid"] = $row->passportid;
	            $data ["fpl_foreign"] = $row->foreign;
	            $data ["fpl_doc_type"] = $doc_type;

	            $data ["fpl_pob_state"] = $row->pob_state;
	            $data ["fpl_pob_city"] = $row->pob_city;
	            $data ["fpl_pob_district"] = $row->pob_district;
	            $data ["fpl_doc_date_open"] = $this->frontdesk->systemdateformat($row->doc_date_open);
	            $data ["fpl_doc_precode"] = $row->doc_precode;
	            $data ["fpl_passportissuedby"] = $row->passportissuedby;
	            $data ["fpl_dict_officialorgan_fmsCODE"] = $row->dict_officialorgan_fmsCODE;

	            $data["fpl_full_address_rus"] = "";

	            if(trim($row->address) <> "" ){
	                $data["fpl_full_address_rus"] .= $row->address;
	            }
	            if(trim($row->addrbuilding) <> "" ){
	                $data["fpl_full_address_rus"] .= " д. ".$row->addrbuilding;
	            }
	            if(trim($row->addrhousing) <> "" ){
	                $data["fpl_full_address_rus"] .= " корп. ".$row->addrhousing;
	            }
	            if(trim($row->addrapt) <> "" ){
	                $data["fpl_full_address_rus"] .= " кв. ".$row->addrapt;
	            }

	            if($guest_id <> 0){
	                $data ["fpl_guest_firstname"] = $row->firstname;
	                $data ["fpl_guest_lastname"] = $row->lastname;
	                $data ["fpl_guest_middlename"] = $row->middlename;
	                $data ["fpl_guest_phone"] = $row->phone;
	                $data ["fpl_guest_passportid"] = $row->passportid;
	                $data ["fpl_guest_foreign"] = $row->foreign;
	                $data ["fpl_guest_address"] = $row->address;
	                $data ["fpl_guest_email"] = $row->email;
	                $data ["fpl_guest_nationality"] = $nationality;
	                $data ["fpl_guest_dob"] = $this->frontdesk->systemdateformat($row->dob);
	                $gender = "";
	                switch ($row->gender) {
	                    case 1 :
	                        $gender = "Мужской";
	                        break;
	                    case 2 :
	                        $gender = "Женский";
	                        break;
	                }
	                $data ["fpl_guest_gender"] = $gender;
	                $data ["fpl_guest_citizenship"] = $row->citizenship;
	                $data ["fpl_guest_postcode"] = $row->postcode;
	                $data ["fpl_guest_country"] = $row->country;
	                $data ["fpl_guest_state"] = $row->state;
	                $data ["fpl_guest_city"] = $row->city;
	                $data ["fpl_guest_pob_state"] = $row->pob_state;
	                $data ["fpl_guest_pob_city"] = $row->pob_city;
	                $data ["fpl_guest_addrbuilding"] = $row->addrbuilding;
	                $data ["fpl_guest_addrhousing"] = $row->addrhousing;
	                $data ["fpl_guest_addrapt"] = $row->addrapt;

	                $data ["fpl_guest_card_number"] = $row->card_number;
	                $data ["fpl_guest_card_valid_time"] = $this->frontdesk->systemdateformat($row->card_valid_time);
	                $data ["fpl_guest_reg_visa_type"] = $row->reg_visa_type_d;
	                $data ["fpl_guest_reg_visa_precode"] = $row->reg_visa_precode;
	                $data ["fpl_guest_reg_date_in"] = $this->frontdesk->systemdateformat($row->reg_date_in_d);
	                $data ["fpl_guest_reg_date_out"] = $this->frontdesk->systemdateformat($row->reg_date_out);
	                $data ["fpl_guest_migration_card_precode"] = $row->migration_card_precode;
	                $data ["fpl_guest_migration_card_num"] = $row->migration_card_num;
	                $data ["fpl_guest_card_date_of_issue"] = $this->frontdesk->systemdateformat($row->card_date_of_issue);
	                $data ["fpl_guest_visitpurpose"] = $row->visitpurpose;
	                $data ["fpl_guest_visamultiplicity"] = $row->visamultiplicity;
	                $data ["fpl_guest_doc_type"] = $doc_type;
	            }
	            $data ["fpl_address"] = $row->address;
	            $data ["fpl_email"] = $row->email;

	            $data ["fpl_nationality"] = $nationality;

	            $data ["fpl_dob"] = $this->frontdesk->systemdateformat($row->dob);

	            $gender = "";
	            switch ($row->gender) {
	                case 1 :
	                    $gender = "Мужской";
	                    break;
	                case 2 :
	                    $gender = "Женский";
	                    break;
	            }
	            $data ["fpl_gender"] = $gender;

	            //============= MAIN GUEST DATA ================

	            $data ["fpl_m_guest_firstname"] = $row->firstname;
	            $data ["fpl_m_guest_lastname"] = $row->lastname;
	            $data ["fpl_m_guest_middlename"] = $row->middlename;
	            $data ["fpl_m_guest_address"] = $row->address;
	            $data ["fpl_m_guest_email"] = $row->email;
	            $data ["fpl_m_guest_phone"] = $row->phone;
	            $data ["fpl_m_guest_passportid"] = $row->passportid;
	            $data ["fpl_m_guest_foreign"] = $row->foreign;
	            $data ["fpl_m_guest_doc_type"] = $row->doc_type;
	            $data ["fpl_m_guest_nationality"] = $row->nationality;
	            $data ["fpl_m_guest_citizenship"] = $row->citizenship;
	            $data ["fpl_m_guest_dob"] = $row->dob;
	            $data ["fpl_m_guest_gender"] = $row->gender;
	            $data ["fpl_m_guest_postcode"] = $row->postcode;
	            $data ["fpl_m_guest_country"] = $row->country;
	            $data ["fpl_m_guest_state"] = $row->state;
	            $data ["fpl_m_guest_city"] = $row->city;
	            $data ["fpl_m_guest_addrbuilding"] = $row->addrbuilding;
	            $data ["fpl_m_guest_addrapt"] = $row->addrapt;
	            $data ["fpl_m_guest_addrhousing"] = $row->addrhousing;
	            $data ["fpl_m_guest_pob_state"] = $row->pob_state;
	            $data ["fpl_m_guest_pob_city"] = $row->pob_city;
	            $data ["fpl_m_guest_pob_district"] = $row->pob_district;
	            $data ["fpl_m_guest_doc_date_open"] = $row->doc_date_open;
	            $data ["fpl_m_guest_doc_precode"] = $row->doc_precode;
	            $data ["fpl_m_guest_dict_officialorgan_fmsCODE"] = $row->dict_officialorgan_fmsCODE;
	            $data ["fpl_m_guest_passportissuedby"] = $row->passportissuedby;
	            //============= MAIN GUEST DATA ================

	            $data ["fpl_citizenship"] = $row->citizenship;
	            $data ["fpl_postcode"] = $row->postcode;
	            $data ["fpl_country"] = $row->country;
	            $data ["fpl_state"] = $row->state;
	            $data ["fpl_city"] = $row->city;
	            $data ["fpl_addrbuilding"] = $row->addrbuilding;
	            $data ["fpl_addrhousing"] = $row->addrhousing;
	            $data ["fpl_addrapt"] = $row->addrapt;
	            // dc
	            $data ["fpl_dc_date"] = $this->frontdesk->systemdateformat($row->dc_date);
	            $data ["fpl_dc_time"] = $this->frontdesk->systemdateformat($row->dc_time);
	            $data ["fpl_dc_uuid"] = $row->dc_uuid;
	            $data ["fpl_dc_status"] = $row->dc_status;
	            $data ["fpl_dc_guestname"] = $row->dc_guestname;
	            $data ["fpl_dc_numberofguest"] = $row->dc_numberofguest;
	            $data ["fpl_dc_currencycode"] = $row->dc_currencycode;
	            $data ["fpl_dc_countrycode"] = $row->dc_countrycode;
	            $data ["fpl_dc_city"] = $row->dc_city;
	            $data ["fpl_dc_customerremarks"] = $row->dc_customerremarks;
	            $data ["fpl_dc_totalprice"] = $row->dc_totalprice;
	            $data ['fpl_dc_reservationid'] = $row->dc_reservationid;
	            $data ['fpl_dc_roomreservation_id'] = $row->dc_roomreservation_id;

	            $data ["fpl_tourtax"] = $row->tourtax;
	            $data ["fpl_early_check_in"] = $row->early_check_in;
	            $data ["fpl_late_check_out"] = $row->late_check_out;
	            $data ["fpl_early_check_out_time"] = $row->early_check_in;
	            $data ["fpl_early_check_in_time"] = $row->late_check_out;
	            $data ["fpl_origin_categoryid"] = $row->origin_categoryid;

	            $data ["fpl_card_number"] = $row->card_number;
	            $data ["fpl_card_valid_time"] = $this->frontdesk->systemdateformat($row->card_valid_time);
	            $data ["fpl_reg_visa_type"] = $row->reg_visa_type_d;
	            $data ["fpl_reg_visa_precode"] = $row->reg_visa_precode;
	            $data ["fpl_reg_date_in"] = $this->frontdesk->systemdateformat($row->reg_date_in_d);
	            $data ["fpl_reg_date_out"] = $this->frontdesk->systemdateformat($row->reg_date_out);
	            $data ["fpl_migration_card_precode"] = $row->migration_card_precode;
	            $data ["fpl_migration_card_num"] = $row->migration_card_num;
	            $data ["fpl_card_date_of_issue"] = $row->card_date_of_issue;
	            $data ["fpl_visitpurpose"] = $row->visitpurpose;
	            $data ["fpl_visamultiplicity"] = $row->visamultiplicity;

	            $data ['fpl_partner'] = $row->id_partner;
	            $data ['fpl_partner_name'] = $row->partner_name;
	            $data ['fpl_partner_legal_name'] = $row->partner_legal_name;
	            $data ["fpl_partner_ZKPO"] = $row->ZKPO;
	            $data ["fpl_partner_addrLine1"] = $row->addrLine1;
	            $data ["fpl_partner_addrLine2"] = $row->addrLine2;
	            $data ["fpl_partner_bankname"] = $row->bankname;
	            $data ["fpl_partner_MFO"] = $row->MFO;
	            $data ["fpl_partner_DOC_INN"] = $row->DOC_INN;
	            $data ["fpl_partner_DOC_SN"] = $row->DOC_SN;
	            $data ["fpl_partner_correspondent_account"] = $row->correspondent_account;
	            $data ["fpl_partner_accountnumber"] = $row->accountnumber;

	            $data ["fpl_total_amount_str_int_ru"] = $this->frontdesk->num2str ( $services_summ );
	            $data ["fpl_total_amount_str_float_ru"] = $this->frontdesk->num2str ( $services_summ );
	            $data ["fpl_total_amount_str_int_ua"] = $this->frontdesk->num2str ( $services_summ, "ua" );
	            $data ["fpl_total_amount_str_float_ua"] = $this->frontdesk->num2str ( $services_summ, "ua" );

	            $data ["fpl_now_date"] = $this->frontdesk->systemdateformat(date("Y-m-d"));


	            $hms_host = "";
	            $query = $this->db->query ( "SELECT str_value FROM hotelix_config WHERE name LIKE 'online_booking_url'" );
	            if ($query->num_rows () > 0) {
	                $row = $query->row ();
	                $hms_host = $row->str_value;
	            }

	            $hms_hotel_id = $this->config->item ( 'hotel_id' );

	            $tstamp = time();

	            $data ["fpl_uniteller_url"] = $hms_host . "/unitpay/upcprepare_post/?oid=m-hms-" . $hms_hotel_id . "-" . $reservation_id . "&total=" . $services_summ;
	            $data ["fpl_liqpay_url"] = $hms_host . "/liqpay/upcprepare_post/?oid=mhms-" . $hms_hotel_id . "-" . $reservation_id . "&total=" . $services_summ;
	            $data ["fpl_apex_url"] = $hms_host . "/appex/upcprepare_post/?oid=" . $hms_hotel_id . "-" . $reservation_id . "-" . $tstamp . "m&total=" . $services_summ;

	            $data ["fpl_guestsList"] = $guestsList;
	            $data ["fpl_ServicesList"] = $ServicesList;
	            $data ["fpl_custom_ServicesList"] = $custom_ServicesList;
	            $data ["fpl_ServicesMainList"] = $ServicesMainList;
	            $data ["fpl_paymentList"] = $paymentList;
	            $data ["fpl_RefundList"] = $RefundList;
	            $data ["fpl_documentsList"] = $documentsList;

	            if ($this->session->userdata ( 'global_debug' ) == 1) {
	                echo "<pre>";
	                print_r($data);
	            }

	            return $data;
	}

	function get_order_data_v2_($reservation_id, $guest_id = 0, $services = array()) {
		$data = array();

		$fpl_custom_ServicesList_amount = 0;


		$result = $this->db->query("select deskofreservation.guest_id, deskofreservation.id_partner, partners.nds, partners.nds_value
		FROM deskofreservation
		INNER JOIN partners ON partners.id = deskofreservation.id_partner
		WHERE deskofreservation.id = ".$reservation_id );
		$row = $result->row();
		$guest_id = $row->guest_id;
		$id_partner = $row->id_partner;
		$nds = $row->nds;
		$nds_value = $row->nds_value;

		if($guest_id <> 0){
			$guest_sql = " INNER JOIN guests ON guests.id = ".$guest_id;
		}else{
			$guest_sql = " INNER JOIN guests ON deskofreservation.guest_id = guests.id ";
		}

		$legalsystem = $this->frontdesk->getlegalsystem();
		$legalsystem_db = $this->frontdesk->getlegalsystem_db($legalsystem);
		$dict_entrygoal_mass = $this->fms_core->get_dict_entrygoal($legalsystem_db);
		$dict_documenttype_mass = $this->fms_core->get_dict_documenttype($legalsystem_db);
		$dict_visacategory_mass = $this->fms_core->get_dict_visacategory($legalsystem_db);
		$dict_visamultiplicity_mass = $this->fms_core->get_dict_visamultiplicity($legalsystem_db);
		$dict_visitpurpose_mass = $this->fms_core->get_dict_visitpurpose($legalsystem_db, 1);

		$doc_types = array ();
		$query = $this->db->query ( "SELECT * FROM doc_types" );
		foreach ( $query->result () as $row ) {
			$doc_types[$row->id] = $row->name;
		}
		$custom_ServicesList = array();
		$ServicesList = array();
		$s_counter = 1;
		$cs_counter = 1;
		$services_summ = 0;
		$nds_all_amount = 0;

		$sql = "SELECT guests.*, deskofreservation.id as res_id,
				services_types.name as services_name, dealers.name as s_dealer,
				services.id as services_id, services.action_time as services_action_time,
				services.count as services_count, services.description as services_description,
				services.time as services_time, services.amount, services.price, rooms.name as room_name,
				categories.name as categories_name, services.time as service_create_time FROM deskofreservation
				$guest_sql
				INNER JOIN rooms ON rooms.id=deskofreservation.room_id
				INNER JOIN categories ON categories.id=rooms.category_id
				INNER JOIN services ON services.reservation_id = deskofreservation.id
				INNER JOIN  services_types ON  services_types.id = services.type
				LEFT JOIN dealers ON dealers.id=services.id_dealer
				WHERE deskofreservation.id = ".$reservation_id."
				ORDER by services.action_time ASC";
		$query2 = $this->db->query ( $sql );
		foreach ( $query2->result () as $row2 ) {
			if(isset($services["service"][$row2->services_id])){
				array_push ( $custom_ServicesList, array (
				'fpl_services_type' => "service",
				'fpl_services_id' => $row2->services_id,
				'fpl_services_name' => $row2->services_name,
				'fpl_services_action_time' => $this->frontdesk->systemdateformat($row2->services_action_time),
				'fpl_service_create_time' => $this->frontdesk->systemdateformat($row2->service_create_time),
				'fpl_services_services_count' => $row2->services_count,
				'fpl_s_dealer' => $row2->s_dealer,
				'fpl_services_time' => $this->frontdesk->systemdateformat($row2->services_time),
				'fpl_servicesamount' => $this->frontdesk->showcurrency ( $row2->amount ),
				'fpl_servicesamount_perunit' => $this->frontdesk->showcurrency ( $row2->price ),
				'fpl_service_netto_amount' => $this->frontdesk->showcurrency ( $row2->amount - (($row2->amount/100)*$nds_value) ),
				'fpl_service_vat_amount' => $this->frontdesk->showcurrency ( ($row2->amount/100)*$nds_value),
				'fpl_service_vat_percent' => $nds_value,
				'fpl_counter' => $cs_counter,
				'fpl_services_description' => $row2->services_description
				) );
				$cs_counter++;
				$fpl_custom_ServicesList_amount += $row2->amount;
			}
			array_push ( $ServicesList, array (
			'fpl_services_id' => $row2->services_id,
			'fpl_services_name' => $row2->services_name,
			'fpl_services_action_time' => $this->frontdesk->systemdateformat($row2->services_action_time),
			'fpl_service_create_time' => $this->frontdesk->systemdateformat($row2->service_create_time),
			'fpl_services_services_count' => $row2->services_count,
			'fpl_s_dealer' => $row2->s_dealer,
			'fpl_services_time' => $this->frontdesk->systemdateformat($row2->services_time),
			'fpl_servicesamount' => $this->frontdesk->showcurrency ( $row2->amount ),
			'fpl_servicesamount_perunit' => $this->frontdesk->showcurrency ( $row2->price ),
			'fpl_service_netto_amount' => $this->frontdesk->showcurrency ( $row2->amount - (($row2->amount/100)*$nds_value) ),
			'fpl_service_netto_amount_perunit' => $this->frontdesk->showcurrency ( $row2->price - (($row2->price/100)*$nds_value) ),
			'fpl_service_vat_rate_percent' => $this->frontdesk->showcurrency ( ($row2->amount/100)*$nds_value),
			'fpl_service_vat_rate' => $nds_value,
			'fpl_counter' => $s_counter,
			'fpl_services_description' => $row2->services_description
			) );

			$services_summ += $row2->amount;
			$nds_all_amount += ($row2->amount/100)*$nds_value;
			$s_counter++;

		}
		//echo "<pre>";
		//print_r($ServicesList);
		//=============================================================================================
		//=============================================================================================
		//=============================================================================================
		$paymentList = array();
		$paid_sum = 0;
		$sql = "SELECT guests.*, payment_types.name, payment.create_time, bso_records.id as bso_id,
				payment.description, payment.amount as total, payment.id as id_payment,
				rooms.name as room_name, categories.name as categories_name, checkprn_gate.checkstatus,
				checkprn_gate.id as checkprn_id, bso_records.code as bso_code, bso_records.number as bso_number
				FROM deskofreservation
				$guest_sql
				INNER JOIN rooms ON rooms.id=deskofreservation.room_id
				INNER JOIN categories ON categories.id=rooms.category_id
				INNER JOIN payment ON payment.reservation_id = deskofreservation.id
				LEFT JOIN checkprn_gate ON checkprn_gate.payment_id = payment.id
				LEFT JOIN  bso_records ON  bso_records.payment_id = payment.id
				INNER JOIN payment_types ON payment_types.id = payment.type
				WHERE deskofreservation.id = ".$reservation_id." ORDER by guests.id ASC";
		$query2 = $this->db->query ( $sql );

		foreach ( $query2->result () as $row2 ) {
			$paid_sum += $row2->total;
			array_push ( $paymentList, array (
			'fpl_typename' => $row2->name,
			'fpl_total' => $this->frontdesk->showcurrency ( $row2->total ),
			'fpl_pay_description' => $row2->description,
			'fpl_type' => $row2->categories_name,
			'fpl_create_time' => $this->frontdesk->systemdateformat($row2->create_time),
			'fpl_bso_code' => $row2->bso_code,
			'fpl_bso_number' => $row2->bso_number
			) );
		}
		//echo "<pre>";
		//print_r($paymentList);

		//=============================================================================================
		//=============================================================================================
		//=============================================================================================
		$RefundList = array();
		$query2 = $this->db->query ( "SELECT deskofreservation.id as res_id,
				payment_types.name as payment_name, refund.id as refund_id, refund.time as refund_time,
				refund.description, refund.amount, rooms.name as room_name,
				categories.name as categories_name FROM deskofreservation
				INNER JOIN rooms ON rooms.id=deskofreservation.room_id
				INNER JOIN categories ON categories.id=rooms.category_id
				INNER JOIN refund ON refund.reservation_id = deskofreservation.id
				INNER JOIN payment_types ON  payment_types.id = refund.type
				WHERE deskofreservation.id = ".$reservation_id );
		foreach ( $query2->result () as $row2 ) {

			array_push ( $RefundList, array (
			'fpl_refund_id' => $row2->refund_id,
			'fpl_payment_name' => $row2->payment_name,
			'fpl_refund_time' => $this->frontdesk->systemdateformat($row2->refund_time),
			'fpl_refund_description' => $row2->description,
			'fpl_refundamount' => $this->frontdesk->showcurrency ( $row2->amount )
			) );
		}

		//=============================================================================================
		$rates = array ();
		$query = $this->db->query ( "SELECT * FROM rate WHERE isactive = 1" );
		foreach ( $query->result () as $row ) {
			$rates [$row->id] = $row->caption;
		}
		//=============================================================================================
		$service_main_ismanual = 0;
		$query2 = $this->db->query ( "SELECT * FROM services_main WHERE reservation_id = " . $reservation_id );

		if ($query2->num_rows () > 0) {
			$row2 = $query2->row ();
			$service_main_ismanual = $row2->ismanual;

		}
		//=============================================================================================
		$ud_price_category = 0;
		$query2 = $this->db->query ( "SELECT ud_price_category FROM deskofreservation WHERE id = " . $reservation_id );

		if ($query2->num_rows () > 0) {
			$row2 = $query2->row ();
			$ud_price_category = $row2->ud_price_category;

		}

		//=============================================================================================
		$categories_names = array();
		$sql = "SELECT id, shortname FROM categories";
		$query2 = $this->db->query ( $sql );

		foreach ( $query2->result () as $row2 ) {
			$categories_names [$row2->id] = $row2->shortname;
		}
		//=============================== tarification =========================================

		$data_tarification = array();
		$data_tarification["rates"] = array();
		$deskofdays_prices = $this->frontdesk->getdeskofdays_price ( $reservation_id );
		//echo "<pre>";
		//print_r($deskofdays_prices);
		$seasons_statistics = $this->frontdesk->getpricecalculation ( 0, $reservation_id, 0, 1 );

		if ($seasons_statistics == 0) {
		} else {
			/*$i = 0;
			foreach ( $deskofdays_prices as $intdate => $cell ) {
				$type_place = "";
				if (isset ( $seasons_statistics [$intdate] ["season_id"] )) {
					$season_id = $seasons_statistics [$intdate] ["season_id"];

					$rate_name = $rates [$seasons_statistics [$intdate] ["price_type"]];
					if (isset ( $seasons_statistics [$intdate] ["season_id"] )) {
						switch ($service_main_ismanual) {
							case 0 :
								$data_tarification ["rates"] [$i] ["fpl_rate_strategy"] = $rate_name;
								break;
							case 1 :
								$data_tarification ["rates"] [$i] ["fpl_rate_strategy"] = "{mlw_cost_fixed}";
								break;
							case 2 :
								$data_tarification ["rates"] [$i] ["fpl_rate_strategy"] = "{mlw_cost_daily}";
								break;
							default :
								$data_tarification ["rates"] [$i] ["fpl_rate_strategy"] = $rate_name;
								break;
						}
					}
					if (isset ( $deskofdays_prices [$intdate] )) {
						if (isset ( $seasons_statistics [$intdate] ["season_id"] )) {
							$data_tarification ["rates"] [$i] ["fpl_day_price"] = $this->frontdesk->showcurrency ( $deskofdays_prices [$intdate] ["price"] );
						} else {
							$data_tarification ["rates"] [$i] ["fpl_day_price"] = $this->frontdesk->showcurrency ( $deskofdays_prices [$intdate] ["price"] );
						}
					} else {
						$data_tarification ["rates"] [$i] ["fpl_day_price"] = "";
					}
					$data_tarification ["rates"] [$i] ["fpl_day_rate"] = $rate_name;
					if(isset($categories_names[$ud_price_category])){
						$data_tarification ["rates"] [$i] ["fpl_rate_taken"] = $categories_names[$ud_price_category];
					}else{
						$data_tarification ["rates"] [$i] ["fpl_rate_taken"] = "";
					}

					$i++;
				}
			}
			*/
			$i = 0;
			foreach ( $deskofdays_prices as $intdate => $cell ) {
				$data_tarification["rates"][$i]["fpl_date"] = $this->frontdesk->systemdateformat(date("Y-m-d", $intdate* 86400));

				$data_tarification["rates"][$i]["fpl_day_services_list"] = array();
				$s_i = 0;
				foreach($ServicesList as $cell){
					if($cell["fpl_services_action_time"] === $data_tarification["rates"][$i]["fpl_date"]){
						$data_tarification["rates"][$i]["fpl_day_services_list"][$s_i]["fpl_day_service_name"] = $cell["fpl_services_name"];
						$data_tarification["rates"][$i]["fpl_day_services_list"][$s_i]["fpl_day_service_count"] = $cell["fpl_services_services_count"];
						$data_tarification["rates"][$i]["fpl_day_services_list"][$s_i]["fpl_day_service_amount_perunit_netto"] = $cell["fpl_servicesamount_perunit"];
						$data_tarification["rates"][$i]["fpl_day_services_list"][$s_i]["fpl_day_service_amount_netto"] = $cell["fpl_servicesamount"];
						$data_tarification["rates"][$i]["fpl_day_services_list"][$s_i]["fpl_day_service_amount_perunit"] = $cell["fpl_servicesamount_perunit"];
						$data_tarification["rates"][$i]["fpl_day_services_list"][$s_i]["fpl_day_service_amount"] = $cell["fpl_servicesamount"];
						$data_tarification["rates"][$i]["fpl_day_services_list"][$s_i]["fpl_vat_percent"] = "";
						$data_tarification["rates"][$i]["fpl_day_services_list"][$s_i]["fpl_balance_after_charge"] = "";
						$s_i++;
					}
				}

				$data_tarification["rates"][$i]["fpl_day_payments_list"] = array();
				$p_i = 0;
				foreach($paymentList as $cell){
					if($cell["fpl_create_time"] === $data_tarification["rates"][$i]["fpl_date"]){
						$data_tarification["rates"][$i]["fpl_day_payments_list"][$p_i]["fpl_day_pay_method"] = $cell["fpl_typename"];
						$data_tarification["rates"][$i]["fpl_day_payments_list"][$p_i]["fpl_day_pay_amount"] = $cell["fpl_total"];
						$data_tarification["rates"][$i]["fpl_day_payments_list"][$p_i]["fpl_balance_after_credit"] = "";
						$p_i++;
					}
				}

				$data_tarification["rates"][$i]["fpl_day_refund_list"] = array();
				$r_i = 0;
				foreach($RefundList as $cell){
					if($cell["fpl_refund_time"] === $data_tarification["rates"][$i]["fpl_date"]){
						$data_tarification["rates"][$i]["fpl_day_refund_list"][$r_i]["fpl_day_refund_method"] = $cell["fpl_payment_name"];
						$data_tarification["rates"][$i]["fpl_day_refund_list"][$r_i]["fpl_day_refund_amount"] = $cell["fpl_refundamount"];
						$data_tarification["rates"][$i]["fpl_day_refund_list"][$r_i]["fpl_balance_after_credit"] = "";
						$r_i++;
					}
				}

				$data_tarification["rates"][$i]["fpl_day_charges"] = "";
				$data_tarification["rates"][$i]["fpl_day_credit"] = "";
				$data_tarification["rates"][$i]["fpl_day_balance"] = "";

				$i++;
			}
		}



		//=============================================================================================
		//=============================================================================================
		//=============================================================================================
		$ServicesMainList = array();
		$sql = "SELECT guests.*, deskofreservation.id as res_id,
				services_types_main.name as services_name, services_main.id as services_id,
				dealers.name as sm_dealer,services_main.description as services_main_description,
				services_main.time as services_time, services_main.amount, services_main.time as service_create_time FROM deskofreservation
				$guest_sql
				INNER JOIN rooms ON rooms.id=deskofreservation.room_id
				INNER JOIN categories ON categories.id=rooms.category_id
				INNER JOIN services_main ON services_main.reservation_id = deskofreservation.id
				INNER JOIN  services_types_main ON  services_types_main.id = services_main.type
				LEFT JOIN dealers ON dealers.id=services_main.id_dealer
				WHERE services_main.type = 2
				AND deskofreservation.id = ".$reservation_id." ORDER by deskofreservation.id ASC";
		$query2 = $this->db->query ( $sql );
		$cancelation_payment_sum = 0;
		foreach ( $query2->result () as $row2 ) {
			$query_pay = $this->db->query ( "SELECT check_payment_items.* FROM check_payment_items INNER JOIN payment ON payment.id = check_payment_items.check_payment_id INNER JOIN services_main ON services_main.id = check_payment_items.item_id WHERE check_payment_items.reservation_id = ".$reservation_id." AND check_payment_items.item_id = $row2->services_id AND check_payment_items.item_service_table_id = 2" );
			$pay_status = "-";
			if ($query_pay->num_rows () > 0) {
				$pay_status = "Да";
			}
			$cancelation_payment_sum += $row2->amount;

			if(isset($services["main_service"][$row2->services_id])){
				array_push ( $custom_ServicesList, array (
				'fpl_services_type' => "main_service",
				'fpl_services_id' => $row2->services_id,
				'fpl_services_name' => $row2->services_name,
				'fpl_services_action_time' => "",
				'fpl_service_create_time' => $row2->service_create_time,
				'fpl_services_services_count' => 1,
				'fpl_s_dealer' => $row2->sm_dealer,
				'fpl_services_time' => $this->frontdesk->systemdateformat($row2->services_time),
				'fpl_servicesamount' => $this->frontdesk->showcurrency ( $row2->amount ),
				'fpl_servicesamount_perunit' => $this->frontdesk->showcurrency ( $row2->amount ),
				'fpl_service_netto_amount' => $this->frontdesk->showcurrency ( $row2->amount - (($row2->amount/100)*$nds_value) ),
				'fpl_service_vat_amount' => $this->frontdesk->showcurrency ( ($row2->amount/100)*$nds_value),
				'fpl_service_vat_percent' => $nds_value,
				'fpl_counter' => $cs_counter,
				'fpl_services_description' => $row2->services_main_description
				) );
				$cs_counter++;
				$fpl_custom_ServicesList_amount += $row2->amount;
			}
			array_push ( $ServicesMainList, array (
			'fpl_pay_status' => $pay_status,
			'fpl_services_id' => $row2->services_id,
			'fpl_services_name' => $row2->services_name,
			'fpl_s_dealer' => $row2->sm_dealer,
			'fpl_service_create_time' => $this->frontdesk->systemdateformat($row2->service_create_time),
			'fpl_services_time' => $this->frontdesk->systemdateformat($row2->services_time),
			'fpl_servicesamount' => $this->frontdesk->showcurrency ( $row2->amount ),
			'fpl_servicesamount_perunit' => $this->frontdesk->showcurrency ( $row2->amount ),
			'fpl_service_netto_amount' => $this->frontdesk->showcurrency ( $row2->amount - (($row2->amount/100)*$nds_value) ),
			'fpl_service_vat_amount' => $this->frontdesk->showcurrency ( ($row2->amount/100)*$nds_value),
			'fpl_service_vat_percent' => $nds_value,
			'fpl_counter' => $s_counter,
			'fpl_services_description' => $row2->services_main_description
			) );

			$services_summ += $row2->amount;
			$nds_all_amount += ($row2->amount/100)*$nds_value;
			$s_counter++;
		}
		//=============================================================================================
		//=============================================================================================
		//=============================================================================================
		$query2 = $this->db->query ( "SELECT guests.*, deskofreservation.id as res_id,
				services_types_main.name as services_name, services_main.id as services_id,
				dealers.name as sm_dealer, services_main.description as services_main_description,
				services_main.time as services_time, services_main.amount, services_main.time as service_create_time FROM deskofreservation
				$guest_sql
				INNER JOIN rooms ON rooms.id=deskofreservation.room_id
				INNER JOIN categories ON categories.id=rooms.category_id
				INNER JOIN services_main ON services_main.reservation_id = deskofreservation.id
				INNER JOIN  services_types_main ON  services_types_main.id = services_main.type
				LEFT JOIN dealers ON dealers.id=services_main.id_dealer
				WHERE (services_main.type = 1 OR services_main.type = 3 OR services_main.type = 4 OR services_main.type = 5) AND
				deskofreservation.id = ".$reservation_id." ORDER by deskofreservation.id ASC" );

		foreach ( $query2->result () as $row2 ) {
			if(isset($services["main_service"][$row2->services_id])){
				array_push ( $custom_ServicesList, array (
				'fpl_services_type' => "main_service",
				'fpl_services_id' => $row2->services_id,
				'fpl_services_name' => $row2->services_name,
				'fpl_services_action_time' => "",
				'fpl_service_create_time' => $row2->service_create_time,
				'fpl_services_services_count' => 1,
				'fpl_s_dealer' => $row2->sm_dealer,
				'fpl_services_time' => $this->frontdesk->systemdateformat($row2->services_time),
				'fpl_servicesamount' => $this->frontdesk->showcurrency ( $row2->amount ),
				'fpl_service_netto_amount' => $this->frontdesk->showcurrency ( $row2->amount - (($row2->amount/100)*$nds_value) ),
				'fpl_service_vat_amount' => $this->frontdesk->showcurrency ( ($row2->amount/100)*$nds_value),
				'fpl_service_vat_percent' => $nds_value,
				'fpl_services_description' => $row2->services_main_description
				) );
				$fpl_custom_ServicesList_amount += $row2->amount;
			}
			array_push ( $ServicesMainList, array (
			'fpl_services_id' => $row2->services_id,
			'fpl_services_name' => $row2->services_name,
			'fpl_s_dealer' => $row2->sm_dealer,
			'fpl_service_create_time' => $row2->service_create_time,
			'fpl_services_time' => $row2->services_time,
			'fpl_servicesamount' => $this->frontdesk->showcurrency ( $row2->amount ),
			'fpl_service_netto_amount' => $this->frontdesk->showcurrency ( $row2->amount - (($row2->amount/100)*$nds_value) ),
			'fpl_service_vat_amount' => $this->frontdesk->showcurrency ( ($row2->amount/100)*$nds_value),
			'fpl_service_vat_percent' => $nds_value,
			'fpl_services_description' => $row2->services_main_description
			) );
			$nds_all_amount += ($row2->amount/100)*$nds_value;
		}

		//=============================================================================================
		//=============================================================================================
		//=============================================================================================
		$documentsList = array ();
		$query2 = $this->db->query ( "SELECT documents.*, users.fullname, users.lastname FROM documents INNER JOIN deskofreservation ON deskofreservation.id=documents.reservation_id
				INNER JOIN users ON users.id = documents.user_id WHERE deskofreservation.id = ".$reservation_id );
		foreach ( $query2->result () as $row2 ) {

			array_push ( $documentsList, array (
			'fpl_document_id' => $row2->id,
			'fpl_firstname' => $row2->firstname,
			'fpl_lastname' => $row2->lastname,
			'fpl_document_description' => $row2->description,
			'fpl_filename' => $row2->filename
			) );
		}
		//=============================================================================================
		//=============================================================================================
		//=============================================================================================
		$guestsList = array ();


		$query2 = $this->db->query ( "SELECT guests.*, reservation_details.* FROM guests
				INNER JOIN guests_deskofreservation ON guests_deskofreservation.guest_id=guests.id
				INNER JOIN deskofreservation ON deskofreservation.id=guests_deskofreservation.reservation_id
				INNER JOIN reservation_details ON (reservation_details.guest_id = guests.id AND reservation_details.reservation_id = deskofreservation.id)
				WHERE deskofreservation.id = " . $reservation_id );
		foreach ( $query2->result () as $row2 ) {

			if (isset ( $dict_entrygoal_mass [$row2->goal_id] ["id"] )) {
				$goal = $dict_entrygoal_mass [$row2->goal_id] ["id"];
			} else {
				$goal = "";
			}
			if (isset ( $doc_types [$row2->doc_type] )) {
				$doc_type = $doc_types [$row2->doc_type];
			} else {
				if(isset($dict_documenttype_mass [$row2->doc_type] ["name"])){
					$doc_type = $dict_documenttype_mass [$row2->doc_type] ["name"];
				}else{
					$doc_type = "";
				}
			}

			$fpl_full_address_rus = "";

			if(trim($row2->address) <> "" ){
				$fpl_full_address_rus .= $row2->address;
			}
			if(trim($row2->addrbuilding) <> "" ){
				$fpl_full_address_rus .= " д. ".$row2->addrbuilding;
			}
			if(trim($row2->addrhousing) <> "" ){
				$fpl_full_address_rus .= " корп. ".$row2->addrhousing;
			}
			if(trim($row2->addrapt) <> "" ){
				$fpl_full_address_rus .= " кв. ".$row2->addrapt;
			}

			if(isset($natiomality_mass[$row2->nationality])){
				$nationality_guestlist = $natiomality_mass[$row2->nationality];
			}else{
				$nationality_guestlist = "";
			}

			$gender = "";
			switch ($row2->gender) {
				case 1 :
					$gender = "Мужской";
					break;
				case 2 :
					$gender = "Женский";
					break;
			}

			$guestsList[$row2->id] = array (
					'fpl_guest_id' => $row2->id,
					'fpl_firstname' => $row2->firstname,
					'fpl_lastname' => $row2->lastname,
					'fpl_middlename' => $row2->middlename,
					'fpl_email' => $row2->email,
					'fpl_dob' => $this->frontdesk->systemdateformat($row2->dob),
					"fpl_phone" => $row2->phone,
					"fpl_citizenship" => $row2->citizenship,
					'fpl_city' => $row2->city,
					'fpl_state' => $row2->state,
					'fpl_pob_state' => $row2->pob_state,
					"fpl_guest_country" => $row2->country,
					'fpl_gl_full_address_rus' => $fpl_full_address_rus,
					'fpl_address' => $row2->address,
					'fpl_addrbuilding' => $row2->addrbuilding,
					'fpl_addrapt' => $row2->addrapt,
					'fpl_postcode' => $row2->postcode,
					'fpl_passportid' => $row2->passportid,
					'fpl_nationality' => $nationality_guestlist,
					'fpl_gender' => $gender,
					'fpl_doc_type' => $doc_type,
					'fpl_pob_city' => $row2->pob_city,
					'fpl_doc_precode' => $row2->doc_precode,
					'fpl_doc_date_open' => $this->frontdesk->systemdateformat($row2->doc_date_open),
					'fpl_doc_date_till' => $this->frontdesk->systemdateformat($row2->doc_date_till),
					'fpl_passportissuedby' => $row2->passportissuedby,
					'fpl_reg_visa_precode' => $row2->reg_visa_precode,
					'fpl_reg_visa_num' => $row2->reg_visa_num,
					'fpl_visamultiplicity' => $row2->visamultiplicity,
					'fpl_visitpurpose' => $row2->visitpurpose,
					'fpl_card_date_of_issue' => $this->frontdesk->systemdateformat($row2->card_date_of_issue),
					'fpl_migration_card_num' => $row2->migration_card_num,
					'fpl_migration_card_precode' => $row2->migration_card_precode,
					'fpl_dict_officialorgan_fmsCODE' => $row2->dict_officialorgan_fmsCODE,
					'fpl_reg_visa_type' =>  $dict_visacategory_mass [$row2->reg_visa_type] ["name"],
					'fpl_card_date_of_issue' => $this->frontdesk->systemdateformat($row2->card_date_of_issue),
					'fpl_pob_city' => $row2->pob_city,
					'fpl_pob_district' => $row2->pob_district,


					'fpl_goal' => $goal,
			) ;
		}

		//=============================================================================================
		//=============================================================================================
		//=============================================================================================
		$sql = "SELECT deskofreservation.*, partners.name as partner_name, partners.legal_name as partner_legal_name,
		partners.ZKPO, partners.addrLine1, partners.addrLine2, partners.bankname,
		partners.MFO, partners.DOC_INN, partners.DOC_SN, partners.correspondent_account, partners.accountnumber,
		rooms.name as room_name, users.fullname as user_fullname, users.lastname as user_lastname,
		users.middlename as user_middlename, partners.correspondent_account, dealers.name as dealer_name, rate.caption as tarif, reservation_details.visamultiplicity,
		reservation_details.visitpurpose, reservation_details.goal_id, reservation_details.card_number, reservation_details.card_valid_time,
		reservation_details.reg_visa_type as reg_visa_type_d, reservation_details.reg_visa_precode, reservation_details.reg_date_in as reg_date_in_d,
		reservation_details.reg_date_out, reservation_details.migration_card_precode, reservation_details.migration_card_num, reservation_details.card_date_of_issue,
		rooms.category_id as category_id, guests.firstname, guests.lastname, guests.middlename,
		guests.phone, guests.passportid, guests.foreign, guests.address, guests.email,  guests.doc_type,
		guests.nationality, guests.citizenship, guests.dob, guests.gender, guests.postcode, guests.country,
		guests.state, guests.city, guests.addrbuilding, guests.addrapt, guests.addrhousing, guests.pob_state, guests.pob_city, guests.pob_district, guests.doc_date_open, guests.doc_precode,
		guests.dict_officialorgan_fmsCODE, guests.passportissuedby
		FROM deskofreservation
		$guest_sql
		INNER JOIN rooms ON deskofreservation.room_id = rooms.id
		LEFT JOIN reservation_details ON (reservation_details.reservation_id = deskofreservation.id AND reservation_details.guest_id = guests.id)
		LEFT JOIN reservation_goals ON reservation_details.goal_id = reservation_goals.id
		LEFT JOIN rate ON deskofreservation.price_type = rate.id
		LEFT JOIN dealers ON deskofreservation.id_dealer = dealers.id
		LEFT JOIN users ON deskofreservation.id_user = users.id
		LEFT JOIN partners ON deskofreservation.id_partner = partners.id
		WHERE deskofreservation.id = " . $reservation_id;
		//echo $sql."||";
		$query = $this->db->query ( $sql );

		$row = $query->row ();
		//=============================================================================================
		//=============================MAIN GUEST DATA============================================
		//=============================================================================================
		$natiomality_mass = array ();
		$query2 = $this->db->query ( "SELECT * FROM language WHERE is_active = 1" );
		foreach ( $query2->result () as $row2 ) {
			$natiomality_mass [$row2->id] = $row2->name;
		}

		if(isset($natiomality_mass[$row->nationality])){
			$nationality = $natiomality_mass[$row->nationality];
		}else{
			$nationality = "";
		}


		$query2 = $this->db->query ( "SELECT guests.*, reservation_details.*
				FROM guests
				INNER JOIN reservation_details ON reservation_details.guest_id = $row->guest_id
				WHERE reservation_details.reservation_id = " . $reservation_id . " AND guests.id = " . $row->guest_id );
		foreach ( $query2->result () as $row2 ) {

			if (isset ( $dict_entrygoal_mass [$row2->goal_id] ["id"] )) {
				$goal = $dict_entrygoal_mass [$row2->goal_id] ["id"];
			} else {
				$goal = "";
			}
			if (isset ( $doc_types [$row2->doc_type] )) {
				$doc_type = $doc_types [$row2->doc_type];
			} else {
				if(isset($dict_documenttype_mass [$row2->doc_type] ["name"])){
					$doc_type = $dict_documenttype_mass [$row2->doc_type] ["name"];
				}else{
					$doc_type = "";
				}
			}

			$fpl_full_address_rus = "";

			if(trim($row2->address) <> "" ){
				$fpl_full_address_rus .= $row2->address;
			}
			if(trim($row2->addrbuilding) <> "" ){
				$fpl_full_address_rus .= " д. ".$row2->addrbuilding;
			}
			if(trim($row2->addrhousing) <> "" ){
				$fpl_full_address_rus .= " корп. ".$row2->addrhousing;
			}
			if(trim($row2->addrapt) <> "" ){
				$fpl_full_address_rus .= " кв. ".$row2->addrapt;
			}

			if(isset($natiomality_mass[$row2->nationality])){
				$nationality_guestlist = $natiomality_mass[$row2->nationality];
			}else{
				$nationality_guestlist = "";
			}

			$gender = "";
			switch ($row2->gender) {
				case 1 :
					$gender = "Мужской";
					break;
				case 2 :
					$gender = "Женский";
					break;
			}

			$guestsList[$row2->id] = array (
					'fpl_guest_id' => $row2->id,
					'fpl_firstname' => $row2->firstname,
					'fpl_lastname' => $row2->lastname,
					'fpl_middlename' => $row2->middlename,
					'fpl_email' => $row2->email,
					'fpl_dob' => $this->frontdesk->systemdateformat($row2->dob),
					"fpl_phone" => $row2->phone,
					"fpl_foreign" => $row2->foreign,
					'fpl_nationality' => $nationality_guestlist,
					'fpl_gender' => $gender,
					"fpl_guest_country" => $row2->country,
					"fpl_citizenship" => $row2->citizenship,
					'fpl_city' => $row2->city,
					'fpl_state' => $row2->state,
					'fpl_pob_state' => $row2->pob_state,
					'fpl_city' => $row2->city,
					'fpl_gl_full_address_rus' => $fpl_full_address_rus,
					'fpl_address' => $row2->address,
					'fpl_addrbuilding' => $row2->addrbuilding,
					'fpl_addrhousing' => $row2->addrhousing,
					'fpl_addrapt' => $row2->addrapt,
					'fpl_postcode' => $row2->postcode,
					'fpl_passportid' => $row2->passportid,
					'fpl_doc_type' => $doc_type,
					'fpl_pob_city' => $row2->pob_city,
					'fpl_doc_precode' => $row2->doc_precode,
					'fpl_doc_date_open' => $this->frontdesk->systemdateformat($row2->doc_date_open),
					'fpl_doc_date_till' => $this->frontdesk->systemdateformat($row2->doc_date_till),
					'fpl_passportissuedby' => $row2->passportissuedby,
					'fpl_reg_visa_precode' => $row2->reg_visa_precode,
					'fpl_reg_visa_num' => $row2->reg_visa_num,
					'fpl_visamultiplicity' => $row2->visamultiplicity,
					'fpl_visitpurpose' => $row2->visitpurpose,
					'fpl_card_date_of_issue' => $this->frontdesk->systemdateformat($row2->card_date_of_issue),
					'fpl_migration_card_num' => $row2->migration_card_num,
					'fpl_migration_card_precode' => $row2->migration_card_precode,
					'fpl_dict_officialorgan_fmsCODE' => $row2->dict_officialorgan_fmsCODE,
					'fpl_reg_visa_type' => $dict_visacategory_mass [$row2->reg_visa_type] ["name"],
					'fpl_card_date_of_issue' => $this->frontdesk->systemdateformat($row2->card_date_of_issue),
					'fpl_pob_city' => $row2->pob_city,
					'fpl_pob_district' => $row2->pob_district,
					'fpl_goal' => $goal,
			);
		}
		//=============================================================================================
		//=============================================================================================
		//=============================================================================================

		$base_places = 0;
		$query = $this->db->query ( "SELECT ratetocategory.*, categories.places FROM ratetocategory INNER JOIN categories ON categories.id = ratetocategory.category_id
		WHERE ratetocategory.category_id = ".$row->category_id." AND ratetocategory.rate_id = ".$row->price_type );
		foreach ( $query->result () as $row_rtc ) {

			if ($row_rtc->baseplace == 0) {
				$base_places = $row_rtc->places;
			} else {
				$base_places = $row_rtc->baseplace;
			}
		}

		if ($row->price_type == 0) {
			$tarif = "Ошибка!!!!";
		} else {
			$tarif = $row->tarif;
		}

		if (isset ( $doc_types [$row->doc_type] )) {
			$doc_type = $doc_types [$row->doc_type];
		} else {
			if(isset($dict_documenttype_mass [$row->doc_type] ["name"])){
				$doc_type = $dict_documenttype_mass [$row->doc_type] ["name"];
			}else{
				$doc_type = "";
			}
		}

		$data ["fpl_daily_pricing"] = $data_tarification["rates"];



		$data ["fpl_reservation_id"] = $reservation_id;

		$data ['fpl_correspondent_account'] = $row->correspondent_account;
		$data ['fpl_dealer_name'] = $row->dealer_name;
		$data ['fpl_id_user'] = $row->id_user;
		$data ['fpl_user_name'] = $row->user_lastname." ".$row->user_fullname." ".$row->user_middlename;
		$data ['fpl_current_user_name'] = $row->user_lastname." ".$row->user_fullname." ".$row->user_middlename;
		$data ['fpl_tarif'] = $tarif;
		$data ['fpl_goal_id'] = $row->goal_id;
		$data ['fpl_dc_rid_prev'] = $row->dc_rid_prev;
		$data ['fpl_dc_rid_next'] = $row->dc_rid_next;

		if(isset($categories_names[$ud_price_category])){
			$data ['fpl_ud_price_category'] = $categories_names[$ud_price_category];
		}else{
			$data ['fpl_ud_price_category'] = "";
		}

		$data ['fpl_canceltoquota'] = $row->canceltoquota;
		$data ['fpl_guest_id'] = $row->guest_id;
		$data ['fpl_groupid'] = $row->groupid;
		$data ['fpl_type_id'] = $row->category_id;
		$data ['fpl_room_id'] = $row->room_id;
		$data ['fpl_room_name'] = $row->room_name;
		$data ['fpl_categories_name'] = $categories_names[$row->category_id];
		$data ['fpl_adult_places'] = $row->adults;
		$data ['fpl_base_places'] = $base_places;
		$data ['fpl_add_places'] = $row->add_places;
		$data ['fpl_baby_places'] = $row->baby_places;
		$data ['fpl_babyplace2'] = $row->babyplace2;
		$data ['fpl_addbedplace'] = $row->addbedplace;
		$data ['fpl_free_places'] = $row->free_places;
		$data ['fpl_total_guest_count'] = $row->adults + $row->baby_places + $row->babyplace2;
		$data ['fpl_discount'] = $this->frontdesk->showcurrency ( $row->discount );
		$data ['fpl_percent_discount'] = $row->percent_discount;
		$data ['fpl_amount'] = $row->amount;
		$data ['fpl_paid_sum'] = $paid_sum;
		$data ['fpl_balance'] = $row->balance;
		if($row->balance > 0){
			$data ['fpl_pay_due'] = 0;
		}else{
			$data ['fpl_pay_due'] = abs($row->balance);
		}
		$data ['fpl_datein'] = $this->frontdesk->systemdateformat($row->datein);
		$data ['fpl_duration'] = $row->duration;
		$data ['fpl_description'] = $row->description;
		$data ['fpl_maid_description'] = $row->maid_description;
		$data ['fpl_dateout'] = $this->frontdesk->systemdateformat($row->dateout);
		$data ['fpl_status'] = $row->status;
		$data ['fpl_date'] = $this->frontdesk->systemdateformat($row->date);
		if($row->duetime != 0){
			$data ['fpl_cancellation_due'] = $this->frontdesk->systemdateformat(date("Y-m-d H:i:s", $row->duetime));
		}else{
			$data ['fpl_cancellation_due'] = 0;
		}
		$data ['fpl_resourse'] = $row->resourse;
		$data ['fpl_commission'] = $row->commission;
		$data ['fpl_user'] = $row->id_user;
		$data ['fpl_dealer'] = $row->id_dealer;
		$data ['fpl_id_company_customer'] = $row->id_company_customer;
		$data ["fpl_price_type"] = $row->price_type;
		$data ["fpl_isNew"] = $row->isNew;
		$data ["fpl_isread"] = $row->isread;
		// guests
		$data ["fpl_firstname"] = $row->firstname;
		$data ["fpl_lastname"] = $row->lastname;
		$data ["fpl_middlename"] = $row->middlename;
		$data ["fpl_phone"] = $row->phone;
		$data ["fpl_passportid"] = $row->passportid;
		$data ["fpl_foreign"] = $row->foreign;
		$data ["fpl_doc_type"] = $doc_type;

		$data ["fpl_pob_state"] = $row->pob_state;
		$data ["fpl_pob_city"] = $row->pob_city;
		$data ["fpl_pob_district"] = $row->pob_district;
		$data ["fpl_doc_date_open"] = $this->frontdesk->systemdateformat($row->doc_date_open);
		$data ["fpl_doc_precode"] = $row->doc_precode;
		$data ["fpl_passportissuedby"] = $row->passportissuedby;
		$data ["fpl_dict_officialorgan_fmsCODE"] = $row->dict_officialorgan_fmsCODE;

		$data["fpl_full_address_rus"] = "";

		if(trim($row->address) <> "" ){
			$data["fpl_full_address_rus"] .= $row->address;
		}
		if(trim($row->addrbuilding) <> "" ){
			$data["fpl_full_address_rus"] .= " д. ".$row->addrbuilding;
		}
		if(trim($row->addrhousing) <> "" ){
			$data["fpl_full_address_rus"] .= " корп. ".$row->addrhousing;
		}
		if(trim($row->addrapt) <> "" ){
			$data["fpl_full_address_rus"] .= " кв. ".$row->addrapt;
		}

		if($guest_id <> 0){
			$data ["fpl_guest_firstname"] = $row->firstname;
			$data ["fpl_guest_lastname"] = $row->lastname;
			$data ["fpl_guest_middlename"] = $row->middlename;
			$data ["fpl_guest_phone"] = $row->phone;
			$data ["fpl_guest_passportid"] = $row->passportid;
			$data ["fpl_guest_foreign"] = $row->foreign;
			$data ["fpl_guest_address"] = $row->address;
			$data ["fpl_guest_email"] = $row->email;
			$data ["fpl_guest_nationality"] = $nationality;
			$data ["fpl_guest_dob"] = $this->frontdesk->systemdateformat($row->dob);
			$gender = "";
			switch ($row->gender) {
				case 1 :
					$gender = "Мужской";
					break;
				case 2 :
					$gender = "Женский";
					break;
			}
			$data ["fpl_guest_gender"] = $gender;
			$data ["fpl_guest_citizenship"] = $row->citizenship;
			$data ["fpl_guest_postcode"] = $row->postcode;
			$data ["fpl_guest_country"] = $row->country;
			$data ["fpl_guest_state"] = $row->state;
			$data ["fpl_guest_city"] = $row->city;
			$data ["fpl_guest_pob_state"] = $row->pob_state;
			$data ["fpl_guest_pob_city"] = $row->pob_city;
			$data ["fpl_guest_addrbuilding"] = $row->addrbuilding;
			$data ["fpl_guest_addrhousing"] = $row->addrhousing;
			$data ["fpl_guest_addrapt"] = $row->addrapt;

			$data ["fpl_guest_card_number"] = $row->card_number;
			$data ["fpl_guest_card_valid_time"] = $this->frontdesk->systemdateformat($row->card_valid_time);
			$data ["fpl_guest_reg_visa_type"] = $dict_visacategory_mass [$row->reg_visa_type_d] ["name"];
			$data ["fpl_guest_reg_visa_precode"] = $row->reg_visa_precode;
			$data ["fpl_guest_reg_date_in"] = $this->frontdesk->systemdateformat($row->reg_date_in_d);
			$data ["fpl_guest_reg_date_out"] = $this->frontdesk->systemdateformat($row->reg_date_out);
			$data ["fpl_guest_migration_card_precode"] = $row->migration_card_precode;
			$data ["fpl_guest_migration_card_num"] = $row->migration_card_num;
			$data ["fpl_guest_card_date_of_issue"] = $this->frontdesk->systemdateformat($row->card_date_of_issue);
			$data ["fpl_guest_visitpurpose"] = $dict_visitpurpose_mass [$row->visitpurpose] ["name"];
			$data ["fpl_guest_visamultiplicity"] = $dict_visamultiplicity_mass [$row->visamultiplicity] ["name"];
			$data ["fpl_guest_doc_type"] = $doc_type;
		}
		$data ["fpl_address"] = $row->address;
		$data ["fpl_email"] = $row->email;

		$data ["fpl_nationality"] = $nationality;

		$data ["fpl_dob"] = $this->frontdesk->systemdateformat($row->dob);

		$gender = "";
		switch ($row->gender) {
			case 1 :
				$gender = "Мужской";
				break;
			case 2 :
				$gender = "Женский";
				break;
		}
		$data ["fpl_gender"] = $gender;

		$data ["fpl_citizenship"] = $row->citizenship;
		$data ["fpl_postcode"] = $row->postcode;
		$data ["fpl_country"] = $row->country;
		$data ["fpl_state"] = $row->state;
		$data ["fpl_city"] = $row->city;
		$data ["fpl_addrbuilding"] = $row->addrbuilding;
		$data ["fpl_addrhousing"] = $row->addrhousing;
		$data ["fpl_addrapt"] = $row->addrapt;
		// dc
		$data ["fpl_dc_date"] = $this->frontdesk->systemdateformat($row->dc_date);
		$data ["fpl_dc_time"] = $this->frontdesk->systemdateformat($row->dc_time);
		$data ["fpl_dc_uuid"] = $row->dc_uuid;
		$data ["fpl_dc_status"] = $row->dc_status;
		$data ["fpl_dc_guestname"] = $row->dc_guestname;
		$data ["fpl_dc_numberofguest"] = $row->dc_numberofguest;
		$data ["fpl_dc_currencycode"] = $row->dc_currencycode;
		$data ["fpl_dc_countrycode"] = $row->dc_countrycode;
		$data ["fpl_dc_city"] = $row->dc_city;
		$data ["fpl_dc_customerremarks"] = $row->dc_customerremarks;
		$data ["fpl_dc_totalprice"] = $row->dc_totalprice;
		$data ['fpl_dc_reservationid'] = $row->dc_reservationid;
		$data ['fpl_dc_roomreservation_id'] = $row->dc_roomreservation_id;

		$data ["fpl_tourtax"] = $row->tourtax;
		$data ["flp_vat_amount"] = "";
		$data ["fpl_early_check_in"] = $row->early_check_in;
		$data ["fpl_late_check_out"] = $row->late_check_out;
		$data ["fpl_early_check_out_time"] = $row->early_check_in;
		$data ["fpl_early_check_in_time"] = $row->late_check_out;

		$data ["fpl_check_in_time"] = $row->checkintime;
		$data ["fpl_check_out_time"] = $row->checkouttime;

		$data ["fpl_origin_categoryid"] = $row->origin_categoryid;

		$data ["fpl_card_number"] = $row->card_number;
		$data ["fpl_card_valid_time"] = $this->frontdesk->systemdateformat($row->card_valid_time);
		$data ["fpl_reg_visa_type"] = $dict_visacategory_mass [$row->reg_visa_type_d] ["name"];
		$data ["fpl_reg_visa_precode"] = $row->reg_visa_precode;
		$data ["fpl_reg_date_in"] = $this->frontdesk->systemdateformat($row->reg_date_in_d);
		$data ["fpl_reg_date_out"] = $this->frontdesk->systemdateformat($row->reg_date_out);
		$data ["fpl_migration_card_precode"] = $row->migration_card_precode;
		$data ["fpl_migration_card_num"] = $row->migration_card_num;
		$data ["fpl_card_date_of_issue"] = $row->card_date_of_issue;
		$data ["fpl_visitpurpose"] = $row->visitpurpose;
		$data ["fpl_visamultiplicity"] = $row->visamultiplicity;

		$data ['fpl_hotel_logo_url'] = "";

		$data ['fpl_partner'] = $row->id_partner;
		$data ['fpl_partner_name'] = $row->partner_name;
		$data ['fpl_partner_legal_name'] = $row->partner_legal_name;
		$data ["fpl_partner_ZKPO"] = $row->ZKPO;
		$data ["fpl_partner_addrLine1"] = $row->addrLine1;
		$data ["fpl_partner_addrLine2"] = $row->addrLine2;
		$data ["fpl_partner_bankname"] = $row->bankname;
		$data ["fpl_partner_MFO"] = $row->MFO;
		$data ["fpl_partner_DOC_INN"] = $row->DOC_INN;
		$data ["fpl_partner_DOC_SN"] = $row->DOC_SN;
		$data ["fpl_partner_correspondent_account"] = $row->correspondent_account;
		$data ["fpl_partner_accountnumber"] = $row->accountnumber;

		$data ["fpl_total_amount_str_int_pl"] = $this->frontdesk->num2str ( $fpl_custom_ServicesList_amount, "pl"  );
		$data ["fpl_total_amount_str_int_ka"] = $this->frontdesk->num2str ( $fpl_custom_ServicesList_amount, "ka"  );
		$data ["fpl_total_amount_str_int_sp"] = $this->frontdesk->num2str ( $fpl_custom_ServicesList_amount, "sp"  );
		$data ["fpl_total_amount_str_int_en"] = $this->frontdesk->num2str ( $fpl_custom_ServicesList_amount, "en"  );
		$data ["fpl_total_amount_str_int_ru"] = $this->frontdesk->num2str ( $fpl_custom_ServicesList_amount );
		$data ["fpl_total_amount_str_float_ru"] = $this->frontdesk->num2str ( $fpl_custom_ServicesList_amount );
		$data ["fpl_total_amount_str_int_ua"] = $this->frontdesk->num2str ( $fpl_custom_ServicesList_amount, "ua" );
		$data ["fpl_total_amount_str_float_ua"] = $this->frontdesk->num2str ( $fpl_custom_ServicesList_amount, "ua" );
		$data ["fpl_total_amount_float"] = substr($this->frontdesk->showcurrency( $fpl_custom_ServicesList_amount ), strpos($this->frontdesk->showcurrency( $fpl_custom_ServicesList_amount ),'.')+1);

		$data ["fpl_now_date"] = $this->frontdesk->systemdateformat(date("Y-m-d"));


		$hms_host = "";
		$query = $this->db->query ( "SELECT str_value FROM hotelix_config WHERE name LIKE 'online_booking_url'" );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$hms_host = $row->str_value;
		}

		$hms_hotel_id = $this->config->item ( 'hotel_id' );

		$tstamp = time();

		$data ["fpl_uniteller_url"] = $hms_host . "/unitpay/upcprepare_post/?oid=m-hms-" . $hms_hotel_id . "-" . $reservation_id . "&total=" . $fpl_custom_ServicesList_amount;
		$data ["fpl_liqpay_url"] = $hms_host . "/liqpay/upcprepare_post/?oid=mhms-" . $hms_hotel_id . "-" . $reservation_id . "&total=" . $fpl_custom_ServicesList_amount;
		$data ["fpl_apex_url"] = $hms_host . "/appex/upcprepare_post/?oid=" . $hms_hotel_id . "-" . $reservation_id . "-" . $tstamp . "m&total=" . $fpl_custom_ServicesList_amount;

		$data ["fpl_guestsList"] = $guestsList;
		$data ["fpl_ServicesList"] = $ServicesList;
		$data ["fpl_custom_ServicesList"] = $custom_ServicesList;

		$data ["fpl_custom_ServicesList_amount"] =  $this->frontdesk->showcurrency( $fpl_custom_ServicesList_amount );
		$data ["fpl_customServicesList_vat_amount"] = $this->frontdesk->showcurrency( $nds_all_amount );

		//$this->frontdesk->showcurrency


		$data ["fpl_ServicesMainList"] = $ServicesMainList;
		$data ["fpl_paymentList"] = $paymentList;
		$data ["fpl_RefundList"] = $RefundList;
		$data ["fpl_documentsList"] = $documentsList;

		if ($this->session->userdata ( 'global_debug' ) == 1) {
			echo "<pre>";
			print_r($data);
		}

		return $data;
	}
}

?>