<?php
class Fmss_mdl extends CI_Model {
    private $url_wsdl;
    private $soap_version = SOAP_1_2;
    private $systemkey;
    private $auth_params;
    private $guidkey;//token
    public static $tbl_guests = 'guests';
    public static $tbl_reservations = 'deskofreservation';
    public static $tbl_res_details = 'reservation_details';
    public static $records_local_tbl = 'fmss_records';
    public static $logs_local_tbl = 'fmss_req_res_log';
    public static $global_logs_tbl = 'global_project_fms.skala_addedpersons_hash2hms_id';
    public $client;

    public function __construct() {
        parent::__construct ();
        require_once "./application/libraries/Fmss/FmssClasses.php";
        $this->url_wsdl = self::get_skala_url_wsdl();//$this->config->item('fmss_url_wsdl');//
        $this->client = new SoapClient($this->url_wsdl, array("soap_version" => $this->soap_version, "trace" => 1));
        
        if (php_sapi_name() == "cli") {
            
        } else {
            $this->systemkey = $this->get_systemkey();
            $this->auth_params = $this->get_auth_params();
        }
                
        $this->guidkey = $this->get_guidkey();
    }

    public static function get_skala_url_wsdl() {
        $cnfg = new CI_Config();
        $url_wsdl = $cnfg->item('fmss_url_wsdl');
        unset($cnfg);
        return $url_wsdl;
    }

    private function get_systemkey() {
        $systemkey = $this->hotelix_config->get_record('skala_systemkey');//$systemkey = '27FF0C0C9C074D41B277E2563FA9A8D8';
        return $systemkey;
    }

    private function get_auth_params() {
        $login = $this->hotelix_config->get_record('skala_login');
        $password = $this->hotelix_config->get_record('skala_password');
        $params = array('login'=>$login, 'password'=>$password);//$params = array('login'=>'MS_Otel', 'password'=>'a(E-n4W!a44u|');
        return $params;
    }

    private function get_guidkey() {
        $guidkey = $this->session->userdata('fmss_token');
        return $guidkey;
    }

    private function login_skala() {
        $guidkey = $this->CallSoapAction(array('action'=>'Login', 'data'=>$this->auth_params));
        if ($guidkey != 'unautorize') {
            $this->session->set_userdata(array('fmss_token' => $guidkey));
            $this->guidkey = $guidkey;
        }


        // 	    $test_connection_result = $this->CallSoapAction(array('action'=>'GetCertNumb', 'data'=>array('guidkey'=>$this->guidkey)));
        // 	    if ($test_connection_result->systemcode == 'unautorize' || $test_connection_result->systemcode == 'token_expired' || $test_connection_result->systemcode == 'denied') {
        // 	        $guidkey = $this->CallSoapAction(array('action'=>'Login', 'data'=>$this->auth_params));
        // 	        $this->session->set_userdata(array('fmss_token' => $guidkey));
        // 	    }

        // 	    $guidkey = $this->CallSoapAction(array('action'=>'Login', 'data'=>$this->auth_params));
        // 	    $this->session->set_userdata(array('fmss_token' => $guidkey));

        // 	    $guidkey = $this->session->userdata('fmss_token');
        return $guidkey;
    }

    private function CallSoapAction($p) {
        $action = $p['action'];
        $data = $p['data'];
        $Response = $this->client->{$action}($data);//$Response = $this->client->__soapCall($action, array($data));
        $Result = $Response->{$action.'Result'};
        return $Result;
    }

    public function GetSoapFunctions() {
        $funcs_arr = $this->client->__getFunctions();
        $funcs_arr = array_unique($funcs_arr);
        sort($funcs_arr);
        return $funcs_arr;
    }

    public function GetSoapTypes() {
        $types_str = '';
        $types = $this->client->__getTypes();
        foreach ($types as $type) {
            $types_str .= preg_replace(array(
                '/(\w+) ([a-zA-Z0-9]+)/',
                '/\n /'
            ), array(
                '<font color="green">${1}</font> <font color="blue">${2}</font>',
                "\n\t"
            ), $type);
            $types_str .= "\n\n";
        }
        return $types_str;
    }

    public function add_person ($p = array('guest_id'=>'', 'res_id'=>'')) {
        $this->login_skala();
        $action = 'AddPersonNew';
        $guest_id = $p['guest_id'];
        $res_id = $p['res_id'];
        $debug = false;
        if ($this->session->userdata('fmss_support_mode')) {
            $debug = true;
        }
        $person = new PersonNew(array(
            'guest_id' => $guest_id,
            'res_id' => $res_id,
            'debug' => $debug
        ));
        $data = array();
        $data['guidkey'] = $this->guidkey;
        $data['person'] = get_object_vars($person);
        $data['systemkey'] = $this->systemkey;

        $api_response = $this->CallSoapAction(array(
            'action' => $action,
            'data' => $data
        ));
        $log_data = array(
            'action' => $action,
            'guest_id' => $guest_id,
            'reservation_id' => $res_id,
            'request' => json_encode($data),
            'response' => json_encode($api_response),
        );
        $log_id = $this->log_request_response($log_data);

        $result = array('api_response' => $api_response, 'last_req_res_log_id' => $log_id);
        return (object)$result;
    }

    public function get_person_status ($p = array('guest_id'=>'', 'res_id'=>'', 'hash' => '')) {
        $result = false;
        $guest_id = $p['guest_id'];
        $res_id = $p['res_id'];
        if (isset($p['hash']) && $p['hash'] != '') {
            $hash = $p['hash'];
        }else {
            $hash = $this->get_guest2res_hash(array('guest_id'=>$guest_id, 'res_id'=>$res_id));
        }
        if ($hash != '') {
            $action = 'GetPersonStatusNew';
            $this->login_skala();
            $data = array();
            $data['guidkey'] = $this->guidkey;
            $data['id'] = $hash;
            $result = $this->CallSoapAction(array(
                'action' => $action,
                'data' => $data
            ));

            $log_data = array(
                'action' => $action,
                'guest_id' => $guest_id,
                'reservation_id' => $res_id,
                'request' => json_encode($data),
                'response' => json_encode($result),
            );
            $this->log_request_response($log_data);

        }
        return $result;
    }

    public function refresh_person_status_by_hash ($hash = '', $res_id = '', $guest_id = '') {//for cron too
        if ($hash != '') {
            if ($res_id == '' && $guest_id == '') {
                $query_row = $this->db->select('reservation_id, guest_id')->get_where(self::$records_local_tbl, array('hash' => $hash))->row();
                if ($query_row) {
                    $guest_id = $query_row->guest_id;
                    $res_id = $query_row->reservation_id;
                }else{
                    return;
                }
            }
        }elseif ($res_id != '' && $guest_id != '') {
            $hash = $this->get_guest2res_hash(array('guest_id'=>$guest_id, 'res_id'=>$res_id));
        }

        if ($hash != '') {
            $result = $this->get_person_status(array('guest_id'=>$guest_id, 'res_id'=>$res_id, 'hash' => $hash));
            $state_txt = isset($result->Value) ? $result->Value : 'Ошибка';
            $this->update_person_status_local_n_global(array('state_txt' => $state_txt, 'hash' => $hash));
        }
        return;
    }

    private function update_person_status_local_n_global($p = array('state_txt' => '', 'hash' => '')){
        $whr_arr = array('hash' => $p['hash']);
        $upd_arr = array(
            'state_txt' => $p['state_txt'],
            'state' => $this->determine_stateint_based_on_statetxt($p['state_txt']),
        );
        $this->db->update(self::$records_local_tbl, $upd_arr, $whr_arr);
        $this->db->update(self::$global_logs_tbl, $upd_arr, $whr_arr);
    }

    private function determine_stateint_based_on_statetxt($status_txt = '')
    {
        $state = - 21;
        switch ($status_txt) {
            case 'Ошибка постановки':
                $state = - 1;
                break;
            case 'Не отправлен':
                $state = - 2;
                break;
            case 'На постановке':
                $state = 2;
                break;
            case 'Поставлен на учёт':
                $state = 3;
                break;
            case 'На снятии':
                $state = 6;
                break;
            case 'Не отправлен на снятие':
                $state = - 6;
                break;
            case 'Ошибка снятии':
                $state = - 7;
                break;
            case 'Снят на бумаге':
            case 'Снят с учёта':
                $state = 7;
                break;
        }
        return $state;
    }

    public function reg_person ($p = array('guest_id'=>'', 'res_id'=>'')) {
        $action = 'RegPerson';
        $this->login_skala();
        $guest_id = $p['guest_id'];
        $res_id = $p['res_id'];
        $hash = $this->get_guest2res_hash(array('guest_id'=>$guest_id, 'res_id'=>$res_id));
        if ($hash != '') {
            $data = array();
            $data['guidkey'] = $this->guidkey;
            $data['id'] = $hash;
            $api_response = $this->CallSoapAction(array(
                'action' => $action,
                'data' => $data
            ));
        }else{
            echo 'Empty hash : reg_person';
        }

        $log_data = array(
            'action' => $action,
            'guest_id' => $guest_id,
            'reservation_id' => $res_id,
            'request' => json_encode($data),
            'response' => json_encode($api_response),
        );
        $log_id = $this->log_request_response($log_data);

        $result = array('api_response' => $api_response, 'last_req_res_log_id' => $log_id);

        return (object)$result;
    }

    public function unreg_person ($p = array('guest_id'=>'', 'res_id'=>'')) {
        $action = 'UnregPerson';
        $this->login_skala();
        $result = false;
        $guest_id = $p['guest_id'];
        $res_id = $p['res_id'];
        $hash = $this->get_guest2res_hash(array('guest_id'=>$guest_id, 'res_id'=>$res_id));
        if ($hash != '') {
            $data = array();
            $data['guidkey'] = $this->guidkey;
            $data['id'] = $hash;
            $data['unreg_reason'] = 0;
            $result = $this->CallSoapAction(array(
                'action' => $action,
                'data' => $data
            ));
        }else{
            echo 'Empty hash : reg_person';
        }

        $log_data = array(
            'action' => $action,
            'guest_id' => $guest_id,
            'reservation_id' => $res_id,
            'request' => json_encode($data),
            'response' => json_encode($result),
        );
        $this->log_request_response($log_data);

        // 	    $LastRequest = $this->client->__getLastRequest();
        // 	    $LastResponse = $this->client->__getLastResponse();
        // 	    echo "<pre>";
        // 	    print_r($LastRequest);
        // 	    print_r($LastResponse);
        return $result;
    }

    public function edit_person($p = array('guest_id'=>'', 'res_id'=>'')){
        $action = 'EditPerson';
        $this->login_skala();
        $guest_id = $p['guest_id'];
        $res_id = $p['res_id'];
        $hash = $this->get_guest2res_hash(array('guest_id' => $guest_id, 'res_id' => $res_id));
        $person = new PersonNew(array(
            'guest_id' => $guest_id,
            'res_id' => $res_id
        ));
        $data = array();
        $data['guidkey'] = $this->guidkey;
        $data['person'] = get_object_vars($person);
        $data['hash'] = $hash;
        $data['systemkey'] = $this->systemkey;
        $result = $this->CallSoapAction(array(
            'action' => $action,
            'data' => $data
        ));

        $log_data = array(
            'action' => $action,
            'guest_id' => $guest_id,
            'reservation_id' => $res_id,
            'request' => json_encode($data),
            'response' => json_encode($result),
        );
        $this->log_request_response($log_data);

        return $result;
    }

    public function get_guest2res_hash ($p = array('guest_id'=>'', 'res_id'=>'')) {
        $hash = '';
        $guest_id = $p['guest_id'];
        $res_id = $p['res_id'];
        $query_row = $this->db->select('hash')->get_where(self::$records_local_tbl, array('guest_id' => $guest_id, 'reservation_id' => $res_id))->row();
        if ($query_row && isset($query_row->hash)) {
            $hash = $query_row->hash;
        }
        return $hash;
    }

    public function get_persons_status($p = '')
    {
        $this->login_skala();
        $data = array();
        $data['guidkey'] = $this->guidkey;
        $data['date'] = $p;
        $result = $this->CallSoapAction(array(
            'action' => 'GetPersonsStatus',
            'data' => $data
        ));
        return $result;
    }

    public function extension_person($p = array('guest_id'=>'', 'res_id'=>''))
    {
        $action = 'ExtensionPerson';
        $this->login_skala();
        $guest_id = $p['guest_id'];
        $res_id = $p['res_id'];
        $hash = $this->get_guest2res_hash(array('guest_id' => $guest_id, 'res_id' => $res_id));
        $res_edges = $this->get_reservation_edges(array('res_id' => $res_id));
        $data = array();
        $data['guidkey'] = $this->guidkey;
        $data['hash'] = $hash;
        $data['StayPeriodFrom'] = $res_edges->datein;
        $data['StayPeriodTo'] = $res_edges->dateout;
        $data['systemkey'] = $this->systemkey;
        $result = $this->CallSoapAction(array(
            'action' => $action,
            'data' => $data
        ));

        $log_data = array(
            'action' => $action,
            'guest_id' => $guest_id,
            'reservation_id' => $res_id,
            'request' => json_encode($data),
            'response' => json_encode($result),
        );
        $this->log_request_response($log_data);

        return $result;
    }

    public function edit_stay_to($p = array('guest_id'=>'', 'res_id'=>''))
    {
        $action = 'EditStayPeriodToPerson';
        $this->login_skala();
        $guest_id = $p['guest_id'];
        $res_id = $p['res_id'];
        $hash = $this->get_guest2res_hash(array('guest_id' => $guest_id, 'res_id' => $res_id));
        $res_edges = $this->get_reservation_edges(array('res_id' => $res_id));
        $data = array();
        $data['guidkey'] = $this->guidkey;
        $data['hash'] = $hash;
        $data['StayPeriodTo'] = $res_edges->dateout;
        $data['systemkey'] = $this->systemkey;
        $result = $this->CallSoapAction(array(
            'action' => $action,
            'data' => $data
        ));

        $log_data = array(
            'action' => $action,
            'guest_id' => $guest_id,
            'reservation_id' => $res_id,
            'request' => json_encode($data),
            'response' => json_encode($result),
        );
        $this->log_request_response($log_data);

        return $result;
    }

    public function add_document_scan($p = array('guest_id'=>'', 'res_id'=>''))
    {
        $action = 'AddDocumentScans';
        $this->login_skala();
        $guest_id = $p['guest_id'];
        $res_id = $p['res_id'];
        $hash = $this->get_guest2res_hash(array('guest_id' => $guest_id, 'res_id' => $res_id));
        $scan = $this->get_guest_doc_scan(array('guest_id' => $guest_id));
        $data = array();
        $data['guidkey'] = $this->guidkey;
        $data['id'] = $hash;
        $data['docType'] = '103008';
        $data['base64str'][] = base64_encode($scan);
        $result = $this->CallSoapAction(array(
            'action' => $action,
            'data' => $data
        ));

        $data['base64str'] = ['doc img'];//overwrite for db space economy!!
        $log_data = array(
            'action' => $action,
            'guest_id' => $guest_id,
            'reservation_id' => $res_id,
            'request' => json_encode($data),
            'response' => json_encode($result),
        );
        $this->log_request_response($log_data);
        return $result;
    }

    private function get_guest_doc_scan($p = array('guest_id'=>'')) {
        $this->load->model('images_core');
        $imgdata = array();
        $imgdata["hms_id"] = $this->config->item ( 'hotel_id' );
        $imgdata["guest_id"] = $p['guest_id'];
        $imgdata["foto_id"] = 1;
        $imgdata["size"] = 3;
        $image = $this->images_core->get_guest_image($imgdata);
        return $image;
    }

    public function GetUID()
    {
        $data = array();
        $data['guidkey'] = $this->guidkey;

        $result = $this->CallSoapAction(array(
            'action' => 'GetUID',
            'data' => $data
        ));
        return $result;
    }

    public function GetPersonID($p = array('guest_id'=>'', 'res_id'=>'')){
        $this->login_skala();
        $guest_id = $p['guest_id'];
        $res_id = $p['res_id'];
        $hash = $this->get_guest2res_hash(array('guest_id' => $guest_id, 'res_id' => $res_id));
        if ($hash != '') {
            $data = array();
            $data['guidkey'] = $this->guidkey;
            $data['id'] = $hash;
            $data['systemkey'] = $this->systemkey;
            $result = $this->CallSoapAction(array(
                'action' => 'GetPersonID',
                'data' => $data
            ));
            $LastRequest = $this->client->__getLastRequest();
            $LastResponse = $this->client->__getLastResponse();
            echo "<pre>";
            print_r($data);
            print_r($LastRequest);
            print_r($LastResponse);
        }else{
            $result = 'Empty hash : GetPersonID';
        }
        return $result;
    }

    private function CallSoapAction_xml($p) {//deprecated, interesting for history, may detete
        $action = $p['action'];
        $data = $p['data'];
        $response_class = $action.'Response';
        $result_class = $action.'Result';
        $this->client->__soapCall($action, array($data));
        $RespResult = $this->client->__getLastResponse();
        $RespResult = $this->xmlsoapBody_to_obj($RespResult);
        $RespResult = $RespResult->$response_class->$result_class;
        return $RespResult;
    }

    private function xmlsoapBody_to_obj($xml) {//deprecated, interesting for history, may detete
        $xml = preg_replace("/(<\/?)(\w+):([^>]*>)/", '$1$2$3', $xml);
        $xml = simplexml_load_string($xml);
        $obj = json_decode(json_encode($xml));
        return $obj->soapBody;
    }

    private function get_reservation_edges($p = array('res_id' => '')) {
        $res_id = $p['res_id'];
        $query_row = $this->db->select('datein, dateout')->get_where('deskofreservation', array('id'=>$res_id))->row();
        return $query_row;
    }

    public function testing_settings_connect() {
        $this->auth_params = array('login'=>$this->hotelix_config->get_record('skala_login'), 'password'=>$this->hotelix_config->get_record('skala_password'));
        $this->systemkey = $this->hotelix_config->get_record('skala_systemkey');
        $login_result = $this->login_skala();
        echo "<pre>";
        echo '<br>Connection URL:<br>';
        print_r($this->url_wsdl);
        echo '<br>SystemKey:<br>';
        print_r($this->systemkey);
        echo '<br>LoginResult:<br>';
        print_r($login_result);
    }

    private function log_request_response($log_data) {
        $log_tbl = self::$logs_local_tbl;
        $log_data['request'] = $this->unicode_decode($log_data['request']);
        $log_data['response'] = $this->unicode_decode($log_data['response']);
        $this->db->insert($log_tbl, $log_data);
        $log_id = $this->db->insert_id();
        return $log_id;
    }

    public function get_logs($p = array('guest_id'=>'', 'res_id'=>'')) {
        $log_tbl = self::$logs_local_tbl;
        $logs = $this->db->order_by('id', 'desc')->get_where($log_tbl, $p)->result();
        return $logs;
    }

    private function unicode_decode($str) {
        return preg_replace_callback('/\\\\u([0-9a-fA-F]{4})/', function ($match) {
            return mb_convert_encoding(pack('H*', $match[1]), 'UTF-8', 'UCS-2BE');
        }, $str);
    }

    public function parse_response_for_history($resp) {
        $parsed_resp = '';
        $resp = json_decode($resp);
        if (is_object($resp)) {
            $errors = null;
            if (isset($resp->errors) && count($resp->errors)) {
                if (isset($resp->errors->ErrorMessage)) {
                    foreach ($resp->errors->ErrorMessage as $error) {
                        $error->name = preg_replace("/[a-zA-Z]/i", "", $error->name);
                        $errors .= "<br>$error->name $error->message.";
                    }
                }
            }
            if (isset($resp->systemcode)) {
                $parsed_resp .= "{$resp->systemcode}.";
                switch ($resp->systemcode) {
                    case 'success':
                        $parsed_resp = 'Успешная операция.';
                        break;
                }
                if (isset($resp->hash)) {
                    $parsed_resp .= " Номер хеша: {$resp->hash}.";
                }
            }else {
                foreach ($resp as $p_val) {
                    if (!in_array(mb_substr($p_val, -1), array('.', ',', '!', ';', ':', '?'))) {
                        $p_val = $p_val . '.';
                    }
                    $parsed_resp .= $p_val;
                }
            }
        }else {//string
            $parsed_resp = $resp;
            switch ($resp) {
                case 'sended':
                    $parsed_resp = 'Отправлен.';
                    break;
            }
        }
        if ($errors) {
            $parsed_resp = "Ошибки:$errors";
        }

        return $parsed_resp;
    }

    public function get_actions_enum() {
        return (object)array(
            'AddPersonNew' => array('rus_name' => 'Добавление гражданина'),
            'RegPerson' => array('rus_name' => 'Постановка на учет'),
            'GetPersonStatusNew' => array('rus_name' => 'Получение состояния'),
            'UnregPerson' => array('rus_name' => 'Снятие с учета'),
            'EditPerson' => array('rus_name' => 'Редактирование'),
            'ExtensionPerson' => array('rus_name' => 'Продление'),
            'EditStayPeriodToPerson' => array('rus_name' => 'Изменение даты выезда'),
            'AddDocumentScans' => array('rus_name' => 'Добавление документов'),
        );
    }

    public function parse_action_for_history($action) {
        $actions = $this->get_actions_enum();
        $parsed_action = isset($actions->{$action}['rus_name']) ? $actions->{$action}['rus_name'] : 'Undefined action!';
        return $parsed_action;
    }
}