<?php
class factura_model extends CI_Model {
	function __construct() {
		parent::__construct ();
	}
	
	function add_factura($data){
	    $this->db->insert('tbl_factura', $data);
	    return $this->db->insert_id ();
	}
	
	function add_facture_items_updates($data){
	    $this->db->insert('tbl_factura_items', $data);
	}
	
	/*
	 * 
	 * 
	 */
	function get_items_type_ids(){
	    $item_types = array();
	    $item_types['services'] = 1;
	    $item_types['services_tf'] = 2;
	    $item_types['services_main'] = 3;
	    return $item_types;
	}
	
	function get_factura_items($data){
	    $select_res = "1";
	    $select_factura = "1";
	    $reservation_id = 0;
	    if(isset($data ['reservation_id'])){
	       $reservation_id = $data ['reservation_id'];
	       $select_res = "deskofreservation.id = $reservation_id";
	    }
	    $factura_id = 0;
	    if(isset($data ['factura_id'])){
	        $factura_id = $data ['factura_id'];
	        $select_factura = "tbl_factura.id = $factura_id";
	    }
	    
	    // item_type: 1 - services
	    //            2 - services_tf
	    //            3 - services_main
	    $item_types = $this->factura_model->get_items_type_ids();
	    
	    $ServicesList = array ();
	    $sql = "SELECT t1.*, SUM(tbl_factura_items.item_pay_amount) as pay_amount FROM (SELECT services_types.name as services_name,
		services.id as services_id, services.action_time as services_action_time,
		services.count as services_count, services.description as services_description,
		services.amount, services.price, partners.name as partner, deskofreservation.id as res_id,
		services_types.tax, services_types.tax_on
		FROM deskofreservation
		INNER JOIN guests ON deskofreservation.guest_id=guests.id
		INNER JOIN services ON services.reservation_id = deskofreservation.id
		LEFT JOIN partners ON services.id_partner = partners.id
		INNER JOIN services_types ON services_types.id = services.type
        WHERE $select_res
		ORDER by services.action_time ASC) as t1
        LEFT JOIN tbl_factura ON tbl_factura.res_id = t1.res_id AND tbl_factura.void = 0
        LEFT JOIN tbl_factura_items ON tbl_factura_items.factura_id = tbl_factura.id AND tbl_factura_items.item_id = t1.services_id
         AND tbl_factura_items.item_type = ".$item_types['services']."
        WHERE $select_factura
        GROUP BY t1.services_id";
// 	     echo $sql;
// 	    die();
	    $query2 = $this->db->query ( $sql );
	    foreach ( $query2->result () as $row2 ) {
	        $need_topay_value = ($row2->services_count * $row2->price) - $row2->pay_amount;
	        
	        $paid_service = 0;
	        if($need_topay_value <= 0){
	            $paid_service = 1;
	        }
	        
	        $vat_percent = 0;
	        $vat_value = 0;
	        if($row2->tax_on == 1){
	            $vat_percent = $row2->tax;
	            if($vat_percent > 0)
	               $vat_value = (( $row2->services_count * $row2->price ) / 100) * $vat_percent;
	        }
	        
	        $amount_without_vat = ($row2->services_count * $row2->price) - $vat_value;
	        
	        $pay_amount = 0;
	        if($factura_id > 0){
	            $pay_amount = $row2->pay_amount;
	        }else{
	            $pay_amount = ($row2->services_count * $row2->price) - $row2->pay_amount;
	        }
	        
	        array_push ( $ServicesList, array (
	            'services_id' => $row2->services_id,
	            'services_name' => $row2->services_name,
	            'services_type' => "services",
	            'services_services_count' => $row2->services_count,
	            'servicesamount' => $this->frontdesk->showcurrency ( $row2->price ),
	            'summ' => $this->frontdesk->showcurrency ( $row2->services_count * $row2->price ),
	            'amount_without_vat' => $this->frontdesk->showcurrency ( $amount_without_vat ),
	            'amount_without_vat_value' => $amount_without_vat,
	            'servicesamount_value' => $row2->price,
	            'summ_value' => $row2->services_count * $row2->price,
	            'pay_amount' => $row2->pay_amount,
	            'need_topay' => ($row2->services_count * $row2->price) - $row2->pay_amount,
	            'input_value' => $pay_amount,
	            'paid_service' => $paid_service,
	            'vat_amount' =>  $this->frontdesk->showcurrency ( $vat_value ),
	            'vat_amount_value' => $vat_value,
	            'vat_percent' => $vat_percent,
	        ) );
	    }
	    
	    $user_language_code = $this->mlanguages->get_user_lang_code();
	    $sql = "SELECT t1.*, SUM(tbl_factura_items.item_pay_amount) as pay_amount FROM (SELECT guests.*, deskofreservation.id as res_id, partners.name as partner,
		services_types_main.name as services_name, services_main.id as services_id,
		dealers.name as sm_dealer, services_main.description as services_main_description,
		services_main.time as services_time, services_main.amount, services_main.time as service_create_time,
        services_types_main.id as service_type_main_id, services_types_main.tax
		FROM deskofreservation
		INNER JOIN guests ON deskofreservation.guest_id=guests.id
		INNER JOIN rooms ON rooms.id=deskofreservation.room_id
		INNER JOIN categories ON categories.id=rooms.category_id
		INNER JOIN services_main ON services_main.reservation_id = deskofreservation.id
		INNER JOIN services_types_main ON  services_types_main.id = services_main.type
		LEFT JOIN dealers ON dealers.id=services_main.id_dealer
		LEFT JOIN partners ON deskofreservation.id_partner = partners.id
		WHERE (services_main.type = 1 OR services_main.type = 2 OR services_main.type = 3 OR services_main.type = 4 OR services_main.type = 5 OR services_main.type = 6) AND
		$select_res ORDER by deskofreservation.id ASC) as t1
        LEFT JOIN tbl_factura ON tbl_factura.res_id = t1.res_id AND tbl_factura.void = 0
        LEFT JOIN tbl_factura_items ON tbl_factura_items.factura_id = tbl_factura.id AND tbl_factura_items.item_id = t1.services_id
		AND tbl_factura_items.item_type = ".$item_types['services_main']."
		WHERE $select_factura
        GROUP BY t1.services_id";
// 	    echo $sql;
// 	     die();
	    $query2 = $this->db->query ( $sql );
	    foreach ( $query2->result () as $row2 ) {
	        $service_name = $this->internationalfields->get_value("service_main", $row2->service_type_main_id, "international_name");
	        $need_topay_value = $row2->amount - $row2->pay_amount;
	        
	        $paid_service = 0;
	        if($need_topay_value <= 0){
	            $paid_service = 1;
	        }
	        
	        $vat_percent = $row2->tax;
	        $vat_value = 0;
	        if($vat_percent > 0){
	           $vat_value = ($row2->amount / 100) * $vat_percent;
	        }
	        
	        $amount_without_vat = ($row2->amount) - $vat_value;
	        
	        $pay_amount = 0;
	        if($factura_id > 0){
	            $pay_amount = $row2->pay_amount;
	        }else{
	            $pay_amount = $row2->amount - $row2->pay_amount;
	        }
	        
	        array_push ( $ServicesList, array (
	            'services_id' => $row2->services_id,
	            'services_name' => $service_name[$user_language_code],
	            'services_type' => "services_main",
	            'servicesamount' => $this->frontdesk->showcurrency ( $row2->amount ),
	            'summ' => $this->frontdesk->showcurrency ( $row2->amount ),
	            'amount_without_vat' => $this->frontdesk->showcurrency ( $amount_without_vat ),
	            'amount_without_vat_value' => $amount_without_vat,
	            'services_services_count' => 1,
	            'servicesamount_value' => $row2->amount,
	            'summ_value' => $row2->amount,
	            'pay_amount' => $row2->pay_amount,
	            'need_topay' => $row2->amount - $row2->pay_amount,
	            'input_value' => $pay_amount,
	            'paid_service' => $paid_service,
	            'vat_amount' =>  $this->frontdesk->showcurrency ( $vat_value ),
	            'vat_amount_value' => $vat_value,
	            'vat_percent' => $vat_percent,
	        ) );
	    }
	    
	    if ($this->releases->is_taxes_fees_allow() == 1) {
	        $sql = "SELECT t1.*, SUM(tbl_factura_items.item_pay_amount) as pay_amount FROM (SELECT taxes_fees2property.name as services_name,
		services_tf.id as services_id, services_tf.value, partners.name as partner, deskofreservation.id as res_id
		FROM deskofreservation
		INNER JOIN services_tf ON services_tf.reservation_id = deskofreservation.id
        INNER JOIN taxes_fees2property ON services_tf.taxes_fees_id = taxes_fees2property.id
    	LEFT JOIN partners ON deskofreservation.id_partner = partners.id
		WHERE $select_res) as t1
        LEFT JOIN tbl_factura ON tbl_factura.res_id = t1.res_id AND tbl_factura.void = 0
        LEFT JOIN tbl_factura_items ON tbl_factura_items.factura_id = tbl_factura.id AND tbl_factura_items.item_id = t1.services_id
		AND tbl_factura_items.item_type = ".$item_types['services_tf']."
		WHERE $select_factura
        GROUP BY t1.services_id";
	        // echo $sql;
	        //  die();
	        $query2 = $this->db->query( $sql );
	        foreach ($query2->result() as $row2) {
	            $need_topay_value = $row2->value - $row2->pay_amount;
	            $paid_service = 0;
	            if($need_topay_value <= 0){
	                $paid_service = 1;
	            }
	            
	            $amount_without_vat = 1 * $row2->value;
	            $vat_percent = 0;
	            $vat_value = 0;
	            $pay_amount = 0;
	            if($factura_id > 0){
	                $pay_amount = $row2->pay_amount;
	            }else{
	                $pay_amount = $row2->value - $row2->pay_amount;
	            }
	            array_push($ServicesList, array(
	                'services_id' => $row2->services_id,
	                'services_name' => $row2->services_name,
	                'services_type' => "services_tf",
	                'services_services_count' => 1,
	                'servicesamount' => $this->frontdesk->showcurrency($row2->value),
	                'summ' => $this->frontdesk->showcurrency(1 * $row2->value),
	                'amount_without_vat' => $this->frontdesk->showcurrency($amount_without_vat),
	                'amount_without_vat_value' => $amount_without_vat,
	                'servicesamount_value' => $row2->value,
	                'summ_value' => $row2->value,
	                'pay_amount' => $row2->pay_amount,
	                'need_topay' => $row2->value - $row2->pay_amount,
	                'input_value' => $pay_amount,
	                'paid_service' => $paid_service,
	                'vat_amount' =>  $this->frontdesk->showcurrency ( $vat_value ),
	                'vat_amount_value' => $vat_value,
	                'vat_percent' => $vat_percent,
	            ));
	        }
	    }
	    return $ServicesList;
	}
	
	function get_factura_amounts($data){
	    $res_id = $data['res_id'];
	    // item_type: 1 - services
	    //            2 - services_tf
	    //            3 - services_main
	    $item_types = $this->factura_model->get_items_type_ids();
	    
	    //if($data['factura_pdf_version'] == )
	    $sql_group_by_tax = "";
	    $sql_group_by_tax_global = "";
// 	    echo $data['factura_pdf_version'];
// 	    die();
	    if($data['factura_pdf_version'] == 1){
	        $sql_group_by_tax = ", t1.item_tax";
	        $sql_group_by_tax_global = ", total_tbl.item_tax";
	    }
	    $factura_data = array();
	    $sql = " SELECT total_tbl.id as factura_id, total_tbl.number, total_tbl.date, 
	    SUM(total_tbl.total_amount) as total_all_amount, SUM(total_tbl.pay_amount) as sum_pay_all_amount, SUM(total_tbl.sum_tax) as sum_all_vat, total_tbl.item_tax 
	    FROM (
	        SELECT tbl_factura.*, SUM(tbl_factura_items.item_total) as total_amount, SUM(tbl_factura_items.item_pay_amount) as pay_amount,
	        SUM(if(t1.item_tax > 0, ((tbl_factura_items.item_pay_amount / 100) * t1.item_tax), 0)) as sum_tax, t1.item_tax
	    FROM (SELECT services_types.name as services_name,
	    services.id as services_id, services.action_time as services_action_time,
	    services.count as services_count, services.description as services_description,
	    services.amount, services.price, partners.name as partner, deskofreservation.id as res_id,
	    if(services_types.tax_on = 1, services_types.tax, 0 ) as item_tax
	    FROM deskofreservation
	    INNER JOIN guests ON deskofreservation.guest_id=guests.id
	    INNER JOIN services ON services.reservation_id = deskofreservation.id
	    LEFT JOIN partners ON services.id_partner = partners.id
	    INNER JOIN services_types ON  services_types.id = services.type
	    WHERE deskofreservation.id = $res_id
	    ORDER by services.action_time ASC) as t1
	    LEFT JOIN tbl_factura ON tbl_factura.res_id = t1.res_id AND tbl_factura.void = 0
	    LEFT JOIN tbl_factura_items ON tbl_factura_items.factura_id = tbl_factura.id AND tbl_factura_items.item_id = t1.services_id
	    AND tbl_factura_items.item_type = ".$item_types['services']."
	    WHERE 1
	    GROUP BY tbl_factura.id $sql_group_by_tax
	    UNION 
	    SELECT tbl_factura.*, SUM(tbl_factura_items.item_total) as total_amount, SUM(tbl_factura_items.item_pay_amount) as pay_amount,
	    SUM((tbl_factura_items.item_pay_amount / 100) * t1.item_tax) as sum_tax, t1.item_tax
	    FROM (SELECT guests.*, deskofreservation.id as res_id, partners.name as partner,
		services_types_main.name as services_name, services_main.id as services_id,
		dealers.name as sm_dealer, services_main.description as services_main_description,
		services_main.time as services_time, services_main.amount, services_main.time as service_create_time,
        services_types_main.id as service_type_main_id,
        if(services_types_main.tax > 0, services_types_main.tax, 0 ) as item_tax
		FROM deskofreservation
		INNER JOIN guests ON deskofreservation.guest_id=guests.id
		INNER JOIN rooms ON rooms.id=deskofreservation.room_id
		INNER JOIN categories ON categories.id=rooms.category_id
		INNER JOIN services_main ON services_main.reservation_id = deskofreservation.id
		INNER JOIN services_types_main ON  services_types_main.id = services_main.type
		LEFT JOIN dealers ON dealers.id=services_main.id_dealer
		LEFT JOIN partners ON deskofreservation.id_partner = partners.id
		WHERE (services_main.type = 1 OR services_main.type = 2 OR services_main.type = 3 OR services_main.type = 4 OR services_main.type = 5 OR services_main.type = 6) AND
		deskofreservation.id = $res_id ORDER by deskofreservation.id ASC) as t1
        LEFT JOIN tbl_factura ON tbl_factura.res_id = t1.res_id AND tbl_factura.void = 0
        LEFT JOIN tbl_factura_items ON tbl_factura_items.factura_id = tbl_factura.id AND tbl_factura_items.item_id = t1.services_id
		AND tbl_factura_items.item_type = ".$item_types['services_main']."
		WHERE 1
        GROUP BY tbl_factura.id $sql_group_by_tax
	    UNION
	    SELECT tbl_factura.*, SUM(tbl_factura_items.item_total) as total_amount, SUM(tbl_factura_items.item_pay_amount) as pay_amount,
	    0 as sum_tax, 0 as item_tax
	    FROM (SELECT taxes_fees2property.name as services_name,
		services_tf.id as services_id, services_tf.value, partners.name as partner, deskofreservation.id as res_id
		FROM deskofreservation
		INNER JOIN services_tf ON services_tf.reservation_id = deskofreservation.id
        INNER JOIN taxes_fees2property ON services_tf.taxes_fees_id = taxes_fees2property.id
    	LEFT JOIN partners ON deskofreservation.id_partner = partners.id
		WHERE deskofreservation.id = $res_id) as t1
        LEFT JOIN tbl_factura ON tbl_factura.res_id = t1.res_id AND tbl_factura.void = 0
        LEFT JOIN tbl_factura_items ON tbl_factura_items.factura_id = tbl_factura.id AND tbl_factura_items.item_id = t1.services_id
		AND tbl_factura_items.item_type = ".$item_types['services_tf']."
		WHERE 1
        GROUP BY tbl_factura.id) as total_tbl WHERE 1 GROUP BY total_tbl.id $sql_group_by_tax_global";
// 	    echo $sql;
// 	    die();
	    $query = $this->db->query( $sql );
	    foreach ($query->result() as $row) {
	        array_push($factura_data, array(
	            'factura_id_list' => $row->factura_id,
	            'number' => $row->number,
	            'date' => $row->date,
	            'item_tax' => $row->item_tax,
	            'sum_all_vat' => $row->sum_all_vat,
	            'total_pay_amount_brutto' => $row->sum_pay_all_amount,
	            'total_pay_amount_netto' => $row->sum_pay_all_amount - $row->sum_all_vat,
	            'pay_all_amount' => $row->pay_all_amount,
	        ));
	    }
	    
	    return $factura_data;
	}
	
	function get_parent_data($res_id){
	    $sql = "SELECT * FROM tbl_factura WHERE type IN (1,2) AND res_id = $res_id";
	    return $this->db->query( $sql )->result_array();   
	}
	
	function get_factura_by_resid($res_id){
	    $sql = "SELECT * FROM tbl_factura WHERE res_id = $res_id";
	    return $this->db->query( $sql )->result_array();
	}
}
?>