<?
class DebugModel3 extends CI_model {
	function __construct() {
		parent::__construct ();
		$this->load->model ( 'frontdesk' );
		$this->load->model ( 'hotelix_config' );
	}

	function get_parts_of_refillsum($coef_mass, $refillsum) { // повертає розбивку суми поповнення пропорційно коефіцієнтам
		$coef_sum = array_sum($coef_mass);
		if ($refillsum > $coef_sum){
			$delta_refill = $refillsum - $coef_sum;
			$refillsum -= $delta_refill;
		}else{
			$delta_refill = 0;
		}
		$max_value = 0;
		$max_value_key = 0;
		$result_mas = array();
		foreach ($coef_mass as $key => $value){
			$result_mas[$key] = round($refillsum*$value/$coef_sum, 2);
			if ($value > $max_value){
				$max_value = $value;
				$max_value_key = $key;
			}
		}
		$delta = $refillsum - array_sum($result_mas);
		$result_mas[$max_value_key] = $result_mas[$max_value_key] + $delta;
		if ($delta_refill > 0){
			$result_mas[$max_value_key] += $delta_refill;
		}
		return $result_mas;
	}

	function get_prices($intdatein, $intdateout) { // отримання цін по діапазону вхідних дат враховуючи єлди, активні рейти і категорії
		echo "<br>", $intdatein, " -- ", $intdateout, "<br>";
		$yieldprice_array = array ();
		$sql = "SELECT * FROM yieldprice WHERE intdate >= " . $intdatein . " AND intdate <= " . $intdateout;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$yieldprice_array [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["price"] = $row->price;
				$yieldprice_array [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["perperson_price"] = $row->perperson_price;
				$yieldprice_array [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["extrabed_price"] = $row->extrabed_price;
				$yieldprice_array [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["additional_bed_price"] = $row->additional_bed_price;
				$yieldprice_array [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["baby_2price"] = $row->baby_2price;
				$yieldprice_array [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["singleuseprice"] = $row->singleuseprice;
			}
		}
		$array_prices = array ();
		$sql = "SELECT categories.id as cat_id, deskofdaysseason.intdate, seasonspricelist.* FROM seasonspricelist
		INNER JOIN categories ON categories.id = seasonspricelist.category_id
		INNER JOIN rate ON rate.id = seasonspricelist.rate_id
		INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
		INNER JOIN deskofdaysseason ON deskofdaysseason.seasonid = seasons.id
		WHERE categories.is_active = 1 AND rate.isactive = 1 AND intdate >= " . $intdatein . " AND intdate <= " . $intdateout;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$array_prices [$row->cat_id] [$row->rate_id] [$row->intdate] ["price"] = $row->price;
				$array_prices [$row->cat_id] [$row->rate_id] [$row->intdate] ["perperson_price"] = $row->perperson_price;
				$array_prices [$row->cat_id] [$row->rate_id] [$row->intdate] ["extrabed_price"] = $row->extrabed_price;
				$array_prices [$row->cat_id] [$row->rate_id] [$row->intdate] ["additional_bed_price"] = $row->additional_bed_price;
				$array_prices [$row->cat_id] [$row->rate_id] [$row->intdate] ["baby_2price"] = $row->baby_2price;
				$array_prices [$row->cat_id] [$row->rate_id] [$row->intdate] ["singleuseprice"] = $row->singleuse_price;
				if (isset($yieldprice_array [$row->cat_id] [$row->rate_id] [$row->intdate])){
					$array_prices [$row->cat_id] [$row->rate_id] [$row->intdate] =
					    array_replace ($array_prices[$row->cat_id] [$row->rate_id] [$row->intdate],
					    		       $yieldprice_array[$row->cat_id] [$row->rate_id] [$row->intdate]);
				}
			}
		}
		echo "<pre>";
		print_r($yieldprice_array);
		print_r($array_prices);
// 		return $array_prices;
	}

	function get_graphycs_data($intdate_in = "", $intdate_out = "", $categories) {
		/*
		 * if ($datein == "" && $dateout == "") { $datein = "2016-07-22"; $dateout = "2016-07-23"; } echo strtotime($datein), '<br>', round (strtotime($datein)/86400), '<br>'; echo strtotime($dateout), '<br>', round (strtotime($dateout)/86400), '<br>'; //echo "DATEIN: " . $datein . " DATEOUT: " . $dateout . "<br><br>"; list ( $year, $month, $day ) = explode ( "-", $datein ); $intdate_in = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 ); list ( $year, $month, $day ) = explode ( "-", $dateout ); $intdate_out = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		*/
		if (!count($categories)){
			return false;
		}
		$search_categories_str = implode(", ", $categories);
// 		echo $search_categories_str; die();
		$romms_count_array = array ();
// 		$overbooking_category_id = 0;
// 		$query = $this->db->query ( "SELECT value FROM hotelix_config WHERE name LIKE 'overbooking_category_id'" );
// 		if ($query->num_rows () > 0) {
// 			$row = $query->row ();
// 			$overbooking_category_id = $row->value;
// 		}
		$sql = "SELECT categories.name, categories.id as category_id, COUNT(rooms.id) as count_allrooms  FROM rooms
		INNER JOIN categories ON categories.id = rooms.`category_id` AND categories.is_active = 1 AND categories.id IN ($search_categories_str)
		GROUP BY categories.id";
		$query = $this->db->query ( $sql );
		foreach ( $query->result () as $row ) {
		$romms_count_array [$row->category_id] ["count"] = $row->count_allrooms;
		$romms_count_array [$row->category_id] ["name"] = $row->name;
		}
		$array = array ();
		foreach ( $romms_count_array as $category_id => $cell ) {
			for($i = $intdate_in; $i <= $intdate_out; $i ++) {
				$array [$category_id] ["cat_name"] = $cell ["name"];
				$array [$category_id] ["dates"] [$i] ["date"] = gmdate ( "d-m-y", $i * 86400 );
				$array [$category_id] ["dates"] [$i] ["amount"] = 0;
				$array [$category_id] ["dates"] [$i] ["ADR"] = 0;
				$array [$category_id] ["dates"] [$i] ["REV"] = 0;
				$array [$category_id] ["dates"] [$i] ["room_reserved"] = 0;
				$array [$category_id] ["dates"] [$i] ["room_total"] = $romms_count_array [$category_id] ["count"];
				$array [$category_id] ["dates"] [$i] ["ocupancy"] = 0;
			}
		}

		$sql = "SELECT categories.id as category_id, deskofdays.intdate, categories.name as cat_name, SUM(deskofreservation.amount/deskofreservation.duration) as amount, COUNT(rooms.id) as room_reserved  FROM deskofreservation
		INNER JOIN deskofdays ON deskofdays.reservation_id = deskofreservation.id
		INNER JOIN rooms ON rooms.id = deskofdays.`room_id`
		INNER JOIN categories ON categories.id = rooms.`category_id` AND categories.is_active = 1 AND categories.id IN ($search_categories_str)
		WHERE deskofdays.intdate >= " . $intdate_in . " AND deskofdays.intdate <= " . $intdate_out . " GROUP BY categories.id, deskofdays.intdate";
		// echo $sql;
		$query = $this->db->query ( $sql );
		foreach ( $query->result () as $row ) {
			$array [$row->category_id] ["cat_name"] = $row->cat_name;
			$array [$row->category_id] ["dates"] [$row->intdate] ["date"] = gmdate ( "d-m-y", $row->intdate * 86400 );
			$array [$row->category_id] ["dates"] [$row->intdate] ["amount"] = $row->amount;
			$array [$row->category_id] ["dates"] [$row->intdate] ["ADR"] = round ( $row->amount / $row->room_reserved, 2 );
			$array [$row->category_id] ["dates"] [$row->intdate] ["REV"] = round ( $row->amount / $romms_count_array [$row->category_id] ["count"], 2 );
			$array [$row->category_id] ["dates"] [$row->intdate] ["room_reserved"] = $row->room_reserved;
			$array [$row->category_id] ["dates"] [$row->intdate] ["room_total"] = $romms_count_array [$row->category_id] ["count"];
			$array [$row->category_id] ["dates"] [$row->intdate] ["ocupancy"] = round ( $row->room_reserved / $romms_count_array [$row->category_id] ["count"], 2 );
		}
// 		echo "<pre>";
// 		print_r ( $array );die('DEBUG MODEL');
		//формуємо відповідний рез_масив з масивів: categories_per_date, dates_per_all_categories, total_all_period_all_categories
		$rez_arr ['categories_per_date'] = $array;
		if(count( $rez_arr ['categories_per_date']) > 1){$more_than_one = true;}
		foreach ( $rez_arr ['categories_per_date'] as $category_id => $category_data ) {
			foreach ( $category_data ['dates'] as $date_int => $date_data ) {
				// формуємо масив по всім датам в сумі по категоріям
				$rez_arr ['dates_per_all_categories'] [$date_int] ['date'] = $date_data ['date'];
				if (! isset ( $rez_arr ['dates_per_all_categories'] [$date_int] ['amount'] )) {
					$rez_arr ['dates_per_all_categories'] [$date_int] ['amount'] = 0;
				}
				$rez_arr ['dates_per_all_categories'] [$date_int] ['amount'] += $date_data ['amount'];
				if (! isset ( $rez_arr ['dates_per_all_categories'] [$date_int] ['room_reserved'] )) {
					$rez_arr ['dates_per_all_categories'] [$date_int] ['room_reserved'] = 0;
				}
				$rez_arr ['dates_per_all_categories'] [$date_int] ['room_reserved'] += $date_data ['room_reserved'];
				if (! isset ( $rez_arr ['dates_per_all_categories'] [$date_int] ['room_total'] )) {
					$rez_arr ['dates_per_all_categories'] [$date_int] ['room_total'] = 0;
				}
				$rez_arr ['dates_per_all_categories'] [$date_int] ['room_total'] += $date_data ['room_total'];
				// формуємо масив по всім категоріям за весь період і
				if ($more_than_one) {
					if (! isset ( $rez_arr ['total_all_period_all_categories'] ['all'] ['amount'] )) {
						$rez_arr ['total_all_period_all_categories'] ['all'] ['amount'] = 0;
					}
					$rez_arr ['total_all_period_all_categories'] ['all'] ['amount'] += $date_data ['amount'];
					if (! isset ( $rez_arr ['total_all_period_all_categories'] ['all'] ['room_reserved'] )) {
						$rez_arr ['total_all_period_all_categories'] ['all'] ['room_reserved'] = 0;
					}
					$rez_arr ['total_all_period_all_categories'] ['all'] ['room_reserved'] += $date_data ['room_reserved'];
					if (! isset ( $rez_arr ['total_all_period_all_categories'] ['all'] ['room_total'] )) {
						$rez_arr ['total_all_period_all_categories'] ['all'] ['room_total'] = 0;
					}
					$rez_arr ['total_all_period_all_categories'] ['all'] ['room_total'] += $date_data ['room_total'];
					$rez_arr ['total_all_period_all_categories'] ['all'] ['cat_name'] = "All categories for all period";
				}
				//по кожній за весь
				if (! isset ( $rez_arr ['total_all_period_all_categories'] [$category_id] ['amount'] )) {
					$rez_arr ['total_all_period_all_categories'] [$category_id] ['amount'] = 0;
				}
				$rez_arr ['total_all_period_all_categories'] [$category_id] ['amount'] += $date_data ['amount'];
				if (! isset ( $rez_arr ['total_all_period_all_categories'] [$category_id] ['room_reserved'] )) {
					$rez_arr ['total_all_period_all_categories'] [$category_id] ['room_reserved'] = 0;
				}
				$rez_arr ['total_all_period_all_categories'] [$category_id] ['room_reserved'] += $date_data ['room_reserved'];
				if (! isset ( $rez_arr ['total_all_period_all_categories'] [$category_id] ['room_total'] )) {
					$rez_arr ['total_all_period_all_categories'] [$category_id] ['room_total'] = 0;
				}
				$rez_arr ['total_all_period_all_categories'] [$category_id] ['room_total'] += $date_data ['room_total'];
			}
			$rez_arr ['total_all_period_all_categories'] [$category_id] ['cat_name'] = $category_data ['cat_name'];
		}
		//після формування, фінішна доводка рез_масиву, вираховування АДР и РЕВ
		foreach ($rez_arr ['dates_per_all_categories'] as $date_int => $date_data){
			$rez_arr ['dates_per_all_categories'][$date_int]['ADR'] = ($date_data ['room_reserved'] == 0) ? 0 : round ( $date_data ['amount'] / $date_data ['room_reserved'], 2 );
			$rez_arr ['dates_per_all_categories'][$date_int]['REV'] = round ( $date_data ['amount'] / $date_data ['room_total'], 2 );
			$rez_arr ['dates_per_all_categories'][$date_int]['ocupancy'] = round ( $date_data ['room_reserved'] / $date_data ['room_total'], 2 );
		}
		foreach ( $rez_arr ['total_all_period_all_categories'] as $key => $value ) {
			$rez_arr ['total_all_period_all_categories'] [$key] ['ADR'] =
			round ( $rez_arr ['total_all_period_all_categories'] [$key] ['amount'] / $rez_arr ['total_all_period_all_categories'] [$key] ['room_reserved'], 2 );
			$rez_arr ['total_all_period_all_categories'] [$key] ['REV'] =
			round ( $rez_arr ['total_all_period_all_categories'] [$key] ['amount'] / $rez_arr ['total_all_period_all_categories'] [$key] ['room_total'], 2 );
			$rez_arr ['total_all_period_all_categories'] [$key] ['ocupancy'] =
			round ( $rez_arr ['total_all_period_all_categories'] [$key] ['room_reserved'] / $rez_arr ['total_all_period_all_categories'] [$key] ['room_total'], 2 );
		}
		//рез_масив готовий
		// 	echo "<pre>";
		// 	print_r($rez_arr);die('DIE IN form_rez_arr');
		return $rez_arr;
	}

	function get_biiling_messages_v1() {
	    $all_messages = "";

	    $hms_billing_version = $this->hotelix_config->get_record("hms_billing_version", "int");
	    //========== hms_allowed = 0, billing =2 якщо в тебе немає підписки виводити повідомлення, з кнопкою отложить (30хв) START ===========
	    if ($hms_billing_version == 2){
	        $user_id = $_SESSION ["user"] ["id"];
	        $hms_allowed = $this->hotelix_config->get_record("hms_allowed", "int");
	        $has_expired_invoices = $this->hotelix_config->get_record("stripe_has_expired_invoices", "int");
	        $has_opened_invoices = $this->hotelix_config->get_record("stripe_has_opened_invoices", "int");
	        $stripe_plan_id = $this->hotelix_config->get_record("stripe_plan_id");
	        $stripe_subscription_id = $this->hotelix_config->get_record("stripe_subscription_id");
	        $lock_till_open_date = $this->hotelix_config->get_record("lock_till_open");
	        $is_locked_till_open = ((strtotime($lock_till_open_date) - strtotime(date("Y-m-d"))) <= 0) ? true : false;
	        if ($hms_allowed == 0){

	            if ($has_expired_invoices == 1){
	                $hms_notification_id = 10; //hms_notification_id_10 {clt_hm_stripe_has_expired_invioces}
	                $need_show_msg = false;
	                $sql = "SELECT remind_date FROM hms_system_alarm WHERE user_id = $user_id AND hms_notification_id = $hms_notification_id";
	                $query = $this->db->query ( $sql );
	                if ($query->num_rows () > 0) {
	                    $remind_date = $query->row()->remind_date;
	                    if ($remind_date < time()){
	                        $need_show_msg = true;
	                    }
	                }else{
	                    $need_show_msg = true;
	                }
	                if ($need_show_msg){

	                    $message = '<div id="systemMsg" onclick="$(\'#systemMsg\').remove();">
						<img src="/images/gtk-about.png" align="left"/>
						<h3>{mlw_system_message}</h3>' .
	                    						'{clt_hm_has_stripe_expired_invioces}';
	                    $message .= '<br><a class="notification" notification_id = '.$hms_notification_id.' href="#">{mlw_remind_later}</a></div>';

	                    $all_messages .= $message;
	                }
	            }
	        }


	        if ($has_opened_invoices == 1){
	            $hms_notification_id = 11; //hms_notification_id_11 {clt_hm_stripe_has_opened_invioces}
	            $need_show_msg = false;
	            $sql = "SELECT remind_date FROM hms_system_alarm WHERE user_id = $user_id AND hms_notification_id = $hms_notification_id";
	            $query = $this->db->query ( $sql );
	            if ($query->num_rows () > 0) {
	                $remind_date = $query->row()->remind_date;
	                if ($remind_date < time()){
	                    $need_show_msg = true;
	                }
	            }else{
	                $need_show_msg = true;
	            }
	            if ($need_show_msg){
	                $access_be_closed_date = $this->hotelix_config->get_record("stripe_access_be_closed_date");

	                $message = '<div id="systemMsg" onclick="$(\'#systemMsg\').remove();">
						<img src="/images/gtk-about.png" align="left"/>
						<h3>{mlw_system_message}</h3>' .
						'{clt_hm_has_stripe_expired_invioces}<br>{clt_hm_access_be_closed} '.$access_be_closed_date;
	                $message .= '<br><a class="notification" notification_id = '.$hms_notification_id.' href="#">{mlw_remind_later}</a></div>';

	                $all_messages .= $message;
	            }
	        }
	    }

	    return $all_messages;
	}

	function get_all_header_messages($wizard = 0){ // повертає всі повідомлення для заголовку
		$all_messages = "";
		if ($wizard) {
		    return $alarm_msg;
		}

		if(!isset($_SESSION ["user"] ["id"])){
		    return $all_messages;
		}
		$remind_date = time();
		if ($this->session->userdata ( 'header_msg' ) != "") {
			$data_msg = array ("id" => $this->session->userdata ( 'header_msg' ));

			$all_messages .= $this->load->view ( 'header_msg_view', $data_msg, true );
			$this->session->unset_userdata ( 'header_msg' );
		}
		if ($this->session->userdata ( 'header_msg_text' ) != "") {
		      $data_msg = array ("id" => 0,
		      "message_text" => $this->session->userdata ( 'header_msg_text')
		      );
		      $all_messages .= $this->load->view ( 'header_msg_view', $data_msg, true );
		      $this->session->unset_userdata ( 'header_msg_text' );
		}

		$hms_billing_version = $this->hotelix_config->get_record("hms_billing_version", "int");
//========== hms_allowed = 0, billing =2 якщо в тебе немає підписки виводити повідомлення, з кнопкою отложить (30хв) START ===========
		if ($hms_billing_version == 2){
			$user_id = $_SESSION ["user"] ["id"];
			$hms_allowed = $this->hotelix_config->get_record("hms_allowed", "int");
			$has_expired_invoices = $this->hotelix_config->get_record("stripe_has_expired_invoices", "int");
			$has_opened_invoices = $this->hotelix_config->get_record("stripe_has_opened_invoices", "int");
			$stripe_plan_id = $this->hotelix_config->get_record("stripe_plan_id");
			$stripe_subscription_id = $this->hotelix_config->get_record("stripe_subscription_id");
			$lock_till_open_date = $this->hotelix_config->get_record("lock_till_open");
			$is_locked_till_open = ((strtotime($lock_till_open_date) - strtotime(date("Y-m-d"))) <= 0) ? true : false;
			if ($hms_allowed == 0){
				if ($stripe_plan_id == ""){
					if ($is_locked_till_open){//hms_notification_id_8 {clt_hm_no_stripe_plan}
						$hms_notification_id = 8;
						$access_be_closed_date = "";
					}else{//hms_notification_id_9 {clt_hm_no_stripe_plan} {clt_hm_access_be_closed}
						$hms_notification_id = 9;
						$access_be_closed_date = $lock_till_open_date;
					}
					$need_show_msg = false;
					$sql = "SELECT remind_date FROM hms_system_alarm WHERE user_id = $user_id AND hms_notification_id = $hms_notification_id";
					$query = $this->db->query ( $sql );
					if ($query->num_rows () > 0) {
						$remind_date = $query->row()->remind_date;
						if ($remind_date < time()){
							$need_show_msg = true;
						}
					}else{
						$need_show_msg = true;
					}
					if ($need_show_msg){
						$data_msg = array (
								"id" => 112,
								"hms_notification_id" => $hms_notification_id,
								"access_be_closed_date" => $access_be_closed_date,
						);
						$all_messages .= $this->load->view ( 'header_msg_view', $data_msg, true );
					}
				}
				if ($has_expired_invoices == 1){
					$hms_notification_id = 10; //hms_notification_id_10 {clt_hm_stripe_has_expired_invioces}
					$need_show_msg = false;
					$sql = "SELECT remind_date FROM hms_system_alarm WHERE user_id = $user_id AND hms_notification_id = $hms_notification_id";
					$query = $this->db->query ( $sql );
					if ($query->num_rows () > 0) {
						$remind_date = $query->row()->remind_date;
						if ($remind_date < time()){
							$need_show_msg = true;
						}
					}else{
						$need_show_msg = true;
					}
					if ($need_show_msg){
						$data_msg = array (
								"id" => 113,
								"hms_notification_id" => $hms_notification_id,
						);
						$all_messages .= $this->load->view ( 'header_msg_view', $data_msg, true );
					}
				}
			}
			if ($has_opened_invoices == 1){
				$hms_notification_id = 11; //hms_notification_id_11 {clt_hm_stripe_has_opened_invioces}
				$need_show_msg = false;
				$sql = "SELECT remind_date FROM hms_system_alarm WHERE user_id = $user_id AND hms_notification_id = $hms_notification_id";
				$query = $this->db->query ( $sql );
				if ($query->num_rows () > 0) {
					$remind_date = $query->row()->remind_date;
					if ($remind_date < time()){
						$need_show_msg = true;
					}
				}else{
					$need_show_msg = true;
				}
				if ($need_show_msg){
					$access_be_closed_date = $this->hotelix_config->get_record("stripe_access_be_closed_date");
					$data_msg = array (
							"id" => 114,
							"hms_notification_id" => $hms_notification_id,
							"access_be_closed_date" => $access_be_closed_date,
					);
					$all_messages .= $this->load->view ( 'header_msg_view', $data_msg, true );
				}
			}
		}
//========== hms_allowed = 0, billing =2 якщо в тебе немає підписки виводити повідомлення, з кнопкою отложить (30хв) FINISH ===========
		$sql = "SELECT * FROM global_hotelix.hms_erp WHERE hms_id = " . $this->config->item('hotel_id');
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$current_balance = $row->current_balance;

			if ($current_balance < 0 && $hms_billing_version != 2) {
				if ($current_balance + $row->rate < 0) {
					$notify_msg = "";
					$sql2 = "SELECT remind_date, user_id FROM hms_system_alarm WHERE hms_notification_id = 3 AND user_id = " . $_SESSION ["user"] ["id"];
					$query2 = $this->db->query ( $sql2 );

					if ($query2->num_rows () > 0) {
						$row2 = $query2->row ();
						if ($row2->remind_date == 0 || $row2->remind_date <= $remind_date) {
							$sql3 = "SELECT text FROM global_hotelix.hms_notification WHERE id = 4";
							$query3 = $this->db->query ( $sql3 );

							if ($query3->num_rows () > 0) {
								$row3 = $query3->row ();
								$notify_msg = $row3->text;
							}
						}
					} else {
						$sql3 = "SELECT text FROM global_hotelix.hms_notification WHERE id = 4";
						$query3 = $this->db->query ( $sql3 );

						if ($query3->num_rows () > 0) {
							$row3 = $query3->row ();
							$notify_msg = $row3->text;
						}
					}
				} else {
					$notify_msg = "";
					$sql2 = "SELECT remind_date, user_id FROM hms_system_alarm WHERE hms_notification_id = 1 AND user_id = " . $_SESSION ["user"] ["id"];
					//echo $sql2;
					//die();
					$query2 = $this->db->query ( $sql2 );

					if ($query2->num_rows () > 0) {
						$row2 = $query2->row ();
						if ($row2->remind_date == 0 || $row2->remind_date <= $remind_date) {
							$sql3 = "SELECT text FROM global_hotelix.hms_notification WHERE id = 5";
							$query3 = $this->db->query ( $sql3 );

							if ($query3->num_rows () > 0) {
								$row3 = $query3->row ();
								$notify_msg = $row3->text;
							}
						}
					} else {
						$sql3 = "SELECT text FROM global_hotelix.hms_notification WHERE id = 5";
						$query3 = $this->db->query ( $sql3 );

						if ($query3->num_rows () > 0) {
							$row3 = $query3->row ();
							$notify_msg = $row3->text;
						}
					}
				}

				if (trim ( $notify_msg ) != "") {
					$data_msg = array (
							"id" => 18,
							"notify_msg" => $notify_msg
					);
					$all_messages .= $this->load->view ( 'header_msg_view', $data_msg, true );
				}
			}
		}

		// for_all_alarms_messages
		$sql = "SELECT * FROM hms_alarm WHERE state = 0 AND user_id = " . $_SESSION ["user"] ["id"] . " AND (remind_date=0 OR remind_date <= " . $remind_date . " )";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
			    $version_alert_bool = 1;
			    if($row->hms_alarm_template_id == 8){
			        $version = $this->hotelix_config->get_record('version', 'int');
			        if($version == 2){
			            $version_alert_bool = 0;
			        }
			    }

			    if ($version_alert_bool == 1) {
                    $result = $this->db->query("SELECT html from global_hotelix.hms_alarm_templates where id =" . $row->hms_alarm_template_id);
                    $result = $result->row();
                    $alarm_msg = $result->html;
                    $data = array();
                    $data_msg = array(
                        "id" => 21,
                        "alarm_msg" => $alarm_msg
                    );
                    $all_messages .= $this->load->view('header_msg_view', $data_msg, true);
                }
			}
		}

        // take cases alerts
        $case_msg_readtime = $this->config->item('case_msg_readtime');
		$sql = "SELECT * FROM cases_crm WHERE state = 1";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {

			    $readtime = strtotime($row->readtime);
// 			    echo $readtime."+".$case_msg_readtime."<". time();
// 			    die();
			    if(($readtime+$case_msg_readtime) < time()){
				    $data_msg = array ("id" => 22, "uid" => $row->id, "notify_msg" => $row->message);
				    $all_messages .= $this->load->view ( 'header_msg_view', $data_msg, true );
			    }
			}
		}

		//if property count == 0 when get header message
		$sql = "SELECT id FROM property_information";
		$query = $this->db->query ( $sql );
		if ($query->num_rows() == 0) {

            // $data_msg = array ("id" => 109);
            // $all_messages .= $this->load->view ( 'header_msg_view', $data_msg, true );

            $notify_msg = "";
            $sql2 = "SELECT remind_date, user_id FROM hms_system_alarm WHERE hms_notification_id = 7 AND user_id = " . $_SESSION["user"]["id"];
            $query2 = $this->db->query($sql2);

            if ($query2->num_rows() > 0) {
                $row2 = $query2->row();
                if ($row2->remind_date == 0 || $row2->remind_date <= $remind_date) {
                    $sql3 = "SELECT text FROM global_hotelix.hms_notification WHERE id = 7";
                    $query3 = $this->db->query($sql3);

                    if ($query3->num_rows() > 0) {
                        $row3 = $query3->row();
                        $notify_msg = $row3->text;
                    }
                }
            } else {
                $sql3 = "SELECT text FROM global_hotelix.hms_notification WHERE id = 7";
                $query3 = $this->db->query($sql3);

                if ($query3->num_rows() > 0) {
                    $row3 = $query3->row();
                    $notify_msg = $row3->text;
                }
            }

            if (trim($notify_msg) != "") {
                $data_msg = array(
                    "id" => 109,
                    "notify_msg" => $notify_msg
                );
                $all_messages .= $this->load->view('header_msg_view', $data_msg, true);
            }
        }


		$query = $this->db->query("SELECT * FROM categories WHERE is_active = 1");
		$bool = 0;
		if ($wizard == 0) {
			if ($query->num_rows() == 0) {
				$data_msg = array(
						"id" => 100
				);
				$all_messages .= $this->load->view ( 'header_msg_view', $data_msg, true );
				$bool = 1;
			}
			$query = $this->db->query("SELECT * FROM rooms");

			if ($query->num_rows() == 0) {
				$data_msg = array(
						"id" => 101
				);
				if ($bool != 1) {
					//$Msg .= $this->load->view('home_msg_view', $data_msg, true);
				}
			}
			$query = $this->db->query("SELECT * FROM partners WHERE isdefault = 1");
			if ($query->num_rows() == 0) {
				$data_msg = array(
						"id" => 102
				);
				if ($bool != 1) {
					$all_messages .= $this->load->view ( 'header_msg_view', $data_msg, true );
				}
			}
		} else {
			switch ($wizard) {
				case 8:
					$data_msg = array(
					"id" => 8
					);
					$all_messages .= $this->load->view ( 'header_msg_view', $data_msg, true );

					break;
				case 9:
					$data_msg = array(
					"id" => $wizard
					);
					$all_messages .= $this->load->view ( 'header_msg_view', $data_msg, true );

					break;
			}
		}
// 		echo $all_messages; die("DEBUG MODEL");
		return $all_messages;
	}

	function make_up_messege($msg) {// оформляє повідомлення для заголовку
		$msg = '<div class="alert alert-dismissable alert-info" onclick="$(this).remove();">
		<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
		<i class="ion-android-warning"></i>&nbsp; <strong>{mlw_system_message} &nbsp;&nbsp;</strong><br>'.$msg.'
		</div>';
		return $msg;
	}

	function currency2str($num) {//Возвращает сумму прописью
		$nul='{caption_nul}';
		$ten=array(
				array('','{caption_1}','{caption_2}','{caption_3}','{caption_4}','{caption_5}','{caption_6}'
						,'{caption_7}','{caption_8}','{caption_9}'),
				array('','{caption_1a}','{caption_2e}','{caption_3}','{caption_4}','{caption_5}','{caption_6}'
						,'{caption_7}','{caption_8}','{caption_9}'),
		);
		$a20=array('{caption_10}','{caption_11}','{caption_12}','{caption_13}','{caption_14}'
				,'{caption_15}','{caption_16}','{caption_17}','{caption_18}','{caption_19}');
		$tens=array(2=>'{caption_20}','{caption_30}','{caption_40}','{caption_50}','{caption_60}','{caption_70}' ,'{caption_80}','{caption_90}');
		$hundred=array('','{caption_100}','{caption_200}','{caption_300}','{caption_400}','{caption_500}','{caption_600}'
				,'{caption_700}','{caption_800}','{caption_900}');
		$unit=array( // Units
				array('{caption_kop}' ,'{caption_kop_s}' ,'{caption_kop_ss}', 1),
				array('{caption_rub}'   ,'{caption_rub_s}'   ,'{caption_rub_ss}',0),
				array('{caption_thousand}'  ,'{caption_thousand_s}'  ,'{caption_thousand_ss}',1),
				array('{caption_million}' ,'{caption_million_s}','{caption_million_ss}' ,0),
				array('{caption_milliard}' ,'{caption_milliard_s}','{caption_milliard_ss}' ,0),
		);
		//
		list($rub,$kop) = explode('.',sprintf("%015.2f", floatval($num)));
		$out = array();
		if (intval($rub)>0) {
			foreach(str_split($rub,3) as $uk=>$v) { // by 3 symbols
				if (!intval($v)) continue;
				$uk = sizeof($unit)-$uk-1; // unit key
				$gender = $unit[$uk][3];
				list($i1,$i2,$i3) = array_map('intval',str_split($v,1));
				// mega-logic
				$out[] = $hundred[$i1]; # 1xx-9xx
				if ($i2>1) $out[]= $tens[$i2].' '.$ten[$gender][$i3]; # 20-99
				else $out[]= $i2>0 ? $a20[$i3] : $ten[$gender][$i3]; # 10-19 | 1-9
				// units without rub & kop
				if ($uk>1) $out[]= $this->morph($v,$unit[$uk][0],$unit[$uk][1],$unit[$uk][2]);
			} //foreach
		}
		else $out[] = $nul;
		$out[] = $this->morph(intval($rub), $unit[1][0],$unit[1][1],$unit[1][2]); // rub
		$out[] = $kop.' '.$this->morph($kop,$unit[0][0],$unit[0][1],$unit[0][2]); // kop
		return trim(preg_replace('/ {2,}/', ' ', join(' ',$out)));
	}

	function morph($n, $f1, $f2, $f5) {//Возвращает сумму прописью, Склоняем словоформу
		$n = abs(intval($n)) % 100;
		if ($n>10 && $n<20) return $f5;
		$n = $n % 10;
		if ($n>1 && $n<5) return $f2;
		if ($n==1) return $f1;
		return $f5;
	}

		function test_desc_airbnb($category_id){
		$category_descriptions_db = $this->frontdesk->get_category_descriptions ( $category_id );
	}

	function get_country_2chr($country) {
		$new_country = "";
		switch ($country) {
			case "ukr" :
				$new_country = "ua";
				break;
			case "rus" :
				$new_country = "ru";
				break;
			default :
				$new_country = $country;
				break;
		}
		return $new_country;
	}

	function mergeamount ($pa=0, $li= 0) {
		$prl = array();
		$l_num = 0;
		$p_num = 0;
		$length_of_p = count($pa)-1;
		$length_of_l = count($li)-1;
		$cur_p = $pa [$p_num]['pamount'];
		$cur_l = $li [$l_num]['iamount'];
		while ( $l_num <= $length_of_l && $p_num <=  $length_of_p) {
			$dif = $cur_p - $cur_l;
			if ($dif == 0){
				$prl[$pa[$p_num]['pid']][$li[$l_num]['iid']] = $cur_p;
				$p_num++;
				$l_num++;
				if ($l_num <= $length_of_l && $p_num <=  $length_of_p){
					$cur_p = $pa [$p_num] ['pamount'];
					$cur_l = $li [$l_num] ['iamount'];
				}
			}elseif ($dif < 0) {
				$prl[$pa[$p_num]['pid']][$li[$l_num]['iid']] = $cur_p;
				$p_num++;
				$cur_l -= $cur_p;
				$cur_p = $pa [$p_num]['pamount'];

			}else{
				$prl[$pa[$p_num]['pid']][$li[$l_num]['iid']] = $cur_l;
				$l_num++;
				$cur_p -= $cur_l;
				$cur_l = $li [$l_num]['iamount'];
			}
		}
		return $prl;
	}

	function db_insert_on_duplicate_key_update($tbl_name, $data, $keys){
		$sql_str = $this->db->insert_string($tbl_name, $data);
		$sql_str .= " ON DUPLICATE KEY ";
		foreach ($keys as $key){unset($data[$key]);}
		$sql_str .= $this->db->update_string($tbl_name, $data, "1");
		$sql_str = str_replace( " $tbl_name SET", "", $sql_str );
		$sql_str = str_replace( " WHERE 1", "", $sql_str );
		$this->db->query ( $sql_str );
	}

	function count_bso_local($db_name = "hotelix_test-hotel-dev_ZIP", $month = 0, $year = 0) {
	/* рахує к-ть БСО в готелі за вказаний місяць і рік, якщо місяць = 0, за всі місяці, якщо рік = 0, за всі роки*/
		$local_tbl = "`bso_records`";
		$db_name = "`".$db_name."`";
		$where_str ="";
		if($year){
			$where_str .= " AND year(date) = $year";
		}
		if($month){
			$where_str .= " AND month(date) = $month";
		}
		$sql = "SELECT year(date) as year, month(date) as month, count(id) as count_bso
				FROM $db_name.$local_tbl
	      		WHERE 1 $where_str GROUP BY month(date), year(date) ORDER BY  year(date) ASC";
		$query = $this->db->query ( $sql );
		return $query->result_array();
	}

	function get_reviews_from_booking () {
	    $dc_id = 1;//booking.com
	    $hotels = array('5804014', '361674');
	    $date = '2018-01-01';
	    $tbl = "reviews_all_channels";
	    $dc_user = $this->config->item ( 'dc_booking_xml_user' );
	    $dc_password = html_entity_decode ($this->config->item ( 'dc_booking_xml_pwd' ));
	    $auth = $dc_user . ":" . $dc_password;
	    $headers = array('Authorization: Basic ' . base64_encode($auth));
	    foreach ($hotels as $hotel) {
	        $next_url = "https://supply-xml.booking.com/review-api/properties/$hotel/reviews?from_date=$date&limit=10";
	        do {
	            $ch = curl_init();
	            curl_setopt($ch, CURLOPT_URL, $next_url);
	            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
	            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	            $responce = curl_exec($ch);
	            curl_close($ch);
	            $dc_data = json_decode($responce);
	            $next_url = (isset($dc_data->meta->next_page) && $dc_data->meta->next_page != "") ? $dc_data->meta->next_page : null;
	            if (isset($dc_data->data->reviews)){
	                foreach ($dc_data->data->reviews as $rw) {
	                    $hms_res_id = '';
	                    if (isset($rw->reservation_id) && $rw->reservation_id != ''){
	                        $row_query = $this->db->select('id')->get_where('deskofreservation', array('dc_reservationid'=>$rw->reservation_id))->row();
	                        if ($row_query){
	                            $hms_res_id = $row_query->id;
	                        }
	                    }
	                    $avg_score = $scored_items_count= 0;
	                    foreach ($rw->scoring as $score_item_val) {
	                        if (!is_null($score_item_val)){
	                           $avg_score += $score_item_val;
	                           $scored_items_count++;
	                        }
	                    }
	                    $avg_score = ($scored_items_count != 0) ? $avg_score/$scored_items_count : 0;
	                    $ins_or_upd_arr = array(
	                        'dc_id' => $dc_id,
	                        'reservation_id' => $hms_res_id,
	                        'rw_id' => $rw->review_id,
	                        'created' => $rw->created_timestamp,
	                        'modified' => $rw->last_change_timestamp,
	                        'body' => json_encode($rw),
	                        'score' => round($avg_score, 1),
	                    );
	                    if($this->db->get_where($tbl, array('rw_id'=>$rw->review_id, 'dc_id'=>$dc_id))->row()){
	                        $this->db->update($tbl, $ins_or_upd_arr, array('rw_id'=>$rw->review_id, 'dc_id'=>$dc_id));
	                    }else {
	                        $this->db->insert($tbl, $ins_or_upd_arr);
	                    }
	                }
	            }
	        } while( !is_null($next_url) );

	        $score_url = "https://supply-xml.booking.com/review-api/properties/$hotel/score";
	        $ch = curl_init();
	        curl_setopt($ch, CURLOPT_URL, $score_url);
	        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
	        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	        $responce = curl_exec($ch);
	        curl_close($ch);
	        $resp = json_decode($responce);
	        if (isset($resp->data->scores)){
	            $max_review_count = 0;
	            $scores_sum = 0;
	            $counts_sum = 0;
	            foreach ($resp->data->scores as $score_data) {
	                $max_review_count = ($score_data->review_count > $max_review_count) ? $score_data->review_count : $max_review_count;
	                $scores_sum += $score_data->score * $score_data->review_count;
	                $counts_sum += $score_data->review_count;
	            }
                $ins_upd_arr = array(
                    'dc_id' => $dc_id,
                    'hotel_id' => $hotel,
                    'score' => round($scores_sum / $counts_sum, 1),
                    'count' => $max_review_count,
                );
                $tbl2 = "reviews_channels_config";
                if($this->db->get_where($tbl2, array('dc_id'=>$dc_id, 'hotel_id' => $hotel,))->row()){
                    $this->db->update($tbl2, $ins_upd_arr, array('dc_id'=>$dc_id, 'hotel_id' => $hotel,));
                }else {
                    $this->db->insert($tbl2, $ins_upd_arr);
                }
	        }
	    }
	}

	function get_reviews_from_airbnb () {
	    $dc_id = 22;
	    $tbl = "reviews_all_channels";

	    $token = "8s41t4bgjg4omijlzxtp29bs2";//"4ko6x2zi1jz4fs7brx5apnrd0";//$this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');bgfqpxu8kk3vox3x3uy3pwzv1
	    $client = 'awkk3fb3oa4o67f5zbjg8eees';
	    $secret = '39qswxnwqbatb6mipl0ahktyl';
	    $auth = $client . ':' . $secret;

	    $headers = array(
	        'Content-Type:application/json',
	        'Authorization: Basic ' . base64_encode($auth),
	    );
	    $url = 'https://api.airbnb.com/v2/oauth2/authorizations/' .$token. '?_unwrapped=true';
	    $ch = curl_init();
	    curl_setopt($ch, CURLOPT_URL, $url);
	    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	    $responce = curl_exec($ch);
	    curl_close($ch);
	    $result = json_decode($responce, true);

	    if( ! isset( $result['valid'] ) || $result['valid'] == 0 ){
	        $headers = array(
	            'Content-Type:application/json',
	            'Authorization: Basic ' . base64_encode($auth),
	        );
	        $url = 'https://api.airbnb.com/v2/oauth2/authorizations?_unwrapped=true';
	        $data = array(
	            'refresh_token' => '88prki8gl2jm9lsk5zjt81g3',//'4dkd4wi0ygkoioipcqtujd6fh',
	            'reset_refresh_token' => 0,
	        );

	        $ch = curl_init();
	        curl_setopt($ch, CURLOPT_URL, $url);
	        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
	        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	        curl_setopt($ch, CURLOPT_POST, true);
	        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	        $buffer = curl_exec($ch);
	        curl_close($ch);
	        $result = json_decode($buffer, true);
	        $token = $result['access_token'];
	    }
	    $headers = array(
	        'Content-Type:application/json',
	        'X-Airbnb-Oauth-Token:'. $token,
	        'X-Airbnb-API-Key:' . $client,
	   );
	    $offset = 0;
	    do {
	        $url = 'https://api.airbnb.com/v2/listing_reviews?_limit=25&reviewer_role=guest&_offset=' . $offset;
	            $ch = curl_init();
	            curl_setopt($ch, CURLOPT_URL, $url);
	            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
	            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	            $responce = curl_exec($ch);
	            curl_close($ch);
	            $result = json_decode( $responce );

	            if (isset($result->reviews)){
	                foreach ($result->reviews as $rw) {
	                    $hms_res_id = '';
	                    if (isset($rw->reservation_confirmation_code) && $rw->reservation_confirmation_code != ''){
	                        $row_query = $this->db->select('id')->get_where('deskofreservation', array('dc_uuid'=>$rw->reservation_confirmation_code))->row();
	                        if ($row_query){
	                            $hms_res_id = $row_query->id;
	                        }
	                    }
	                    $ins_or_upd_arr = array(
	                        'dc_id' => $dc_id,
	                        'reservation_id' => $hms_res_id,
	                        'rw_id' => $rw->id,
	                        'created' => $rw->first_completed_at,
	                        'modified' => $rw->submitted_at,
	                        'body' => json_encode($rw),
	                        'score' => $rw->overall_rating,
	                    );
	                    if($this->db->get_where($tbl, array('rw_id'=>$rw->id, 'dc_id'=>$dc_id))->row()){
	                        $this->db->update($tbl, $ins_or_upd_arr, array('rw_id'=>$rw->id, 'dc_id'=>$dc_id));
	                    }else {
	                        $this->db->insert($tbl, $ins_or_upd_arr);
	                    }
	                }
	            }
	            $offset += 25;
	    } while( count( $result->reviews ) );

	    $url = 'https://api.airbnb.com/v2/rating_stats';
	    $ch = curl_init();
	    curl_setopt($ch, CURLOPT_URL, $url);
	    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	    $buffer = curl_exec($ch);
	    curl_close($ch);
	    $res_scores =  json_decode( $buffer);
// 	    [rating_stats] => Array
// 	    (
// 	        [0] => stdClass Object
// 	        (
// 	            [entity_id] => 280179069
// 	            [entity_type] => user
// 	            [rating] => 4.29
// 	            [count] => 7
// 	            [category_stats] =>
// 	            )
	    $stats = isset($res_scores->rating_stats[0]) ? $res_scores->rating_stats[0] : '';
	    if (isset($stats->rating) && isset($stats->count) && isset($stats->entity_id)){
	        $hotel = $stats->entity_id;
	        $ins_upd_arr = array(
	            'dc_id' => $dc_id,
	            'hotel_id' => $hotel,
	            'score' => $stats->rating,
	            'count' => $stats->count,
	        );
	        $tbl2 = "reviews_channels_config";
	        if($this->db->get_where($tbl2, array('dc_id'=>$dc_id, 'hotel_id' => $hotel,))->row()){
	            $this->db->update($tbl2, $ins_upd_arr, array('dc_id'=>$dc_id, 'hotel_id' => $hotel,));
	        }else {
	            $this->db->insert($tbl2, $ins_upd_arr);
	        }
	    }
	    die("DIED by A Department at debugmodel3.php get_reviews_from_airbnb() on 12 окт. 2020 г. 19:29:39");
	}

	public function convert_currencies($props = ArrayObject::STD_PROP_LIST){
	    //Example $props: array('currency_from'=>'USA', 'currency_to'=>'UAH', 'amount'=>100)
	    //On errors returns array('Error'=>'error description')
	    //On sucsess returns $converted_amount
	    if (isset($props['currency_from']) && $props['currency_from'] != ''){
	        $currency_from = $props['currency_from'];
	    }else {
	        return array('Error'=>'currency_from not set');
	    }
	    if (isset($props['currency_to']) && $props['currency_to'] != ''){
	        $currency_to = $props['currency_to'];
	    }else {
	        return array('Error'=>'currency_to not set');
	    }
	    if (isset($props['amount']) && $props['amount'] != 0){
	        $amount = $props['amount'];
	    }else {
	        return array('Error'=>'amount not set');
	    }
	    //start validation complete
	    $tbl = 'global_hotelix.currency_rates_today';
        $rate_to = $this->db->select('rate')->get_where($tbl, array('name'=>$currency_to))->row();
        $rate_from = $this->db->select('rate')->get_where($tbl, array('name'=>$currency_from))->row();
        if ($rate_from && $rate_to) {
            $rate_to = $rate_to->rate;
            $rate_from = $rate_from->rate;
            $rates_koef = $rate_to / $rate_from;
            $converted_amount = round($amount * $rates_koef, 2);
            return $converted_amount;
	    }else{
	        return array('Error'=>"not converted from $currency_from to $currency_to, rates are invalid;");
	    }
	}

    public function optimize_restricts_arr($p) {//copied to dc_model
        $periods = $p['periods'];
        $indicators = array();
        foreach ($periods as $per_key => $per_data) {
            $indicator_key = $per_data['room_id'].'-'.$per_data['package_id'].'-'.$per_data['closure_type'].'-'.$per_data['closure_status'];
            if (isset($indicators[$indicator_key]) && ($per_data['date_start'] == $indicators[$indicator_key]['date'])) {
                $indicators[$indicator_key]['date'] = date('Y-m-d', strtotime($per_data['date_end']." + 1 day"));
                $periods[$indicators[$indicator_key]['per_key']]['date_end'] = $per_data['date_end'];
                unset($periods[$per_key]);
            }else {
                $indicators[$indicator_key] = array('date'=>date('Y-m-d', strtotime($per_data['date_end']." + 1 day")), 'per_key'=>$per_key);
            }
        }
        //$periods = array_values($periods);
        $p['periods'] = $periods;
        return $p;
    }

}
