<?php
class Tables {
	var $ta_hotels = "`global_hotelix`.`dc_ta_hotels`";
	var $h_config = 'hotelix_config';
	var $prop_info = "property_information";
	var $currency_rates_today = "currency_rates_today";
	var $currencies = '`global_hotelix`.`currency`';
	var $supported_langs = 'descriptionlanguages';
	var $availability = "deskofdays_availability";
	var $inter = "internationalfields";
	var $room_views = "global_hotelix_common.room_view_type";
	var $beds2rooms = "beds2rooms";
	var $room_params = "category_room_param";
	var $bed_types = "`global_hotelix_common`.`bed_types`";
	var $room_photos = "category_images_registry";
	var $category2amenities = "category2amenities";
	var $category_ameneties = "category_ameneties";
	var $cancelations = "`global_hotelix_common`.`dc_cancelationpolicy_list`";
	var $cancelation_types = "`global_hotelix_common`.`cancellationpolicy_types`";
	var $meal_policies = "meal_policies";
}
class Dcm_ta_gate extends CI_Model {
	static $db_tables;
	public function __construct(){
		$this->db_tables =  new Tables();
		parent::__construct();
	}
	function log_http_push () {
		$data = array (
				'get' => $_SERVER ['QUERY_STRING'],
				'post' => json_encode ( $_POST ),
				'rawpost' => file_get_contents ( "php://input" ),
				'server' => json_encode ( $_SERVER )
		);
		$this->db->insert ( 'dc_booking.ta_http_push', $data );
	}
	function curl_rawpost_requested_booking_data($requested_booking_data, $url) {
        $headers = array('Content-Type: application/json');
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $requested_booking_data);
        $result = curl_exec($ch);
        curl_close($ch);
        return $result;
	}
	function get_ta_hotels($single_hotel_partner_hotel_code = "") {
		$t = &$this->db_tables;
		$where_arr = array('active' => 1);
		if (!empty($single_hotel_partner_hotel_code)){
			$parsed_ids_arr = explode('_', $single_hotel_partner_hotel_code);
			$where_arr['hms_id'] = $parsed_ids_arr[0];
			$where_arr['prop_id'] = $parsed_ids_arr[1];
		}
		$hotels_list = $this->db->get_where($t->ta_hotels, $where_arr)->result_array();
		return (!empty($single_hotel_partner_hotel_code)) ? $hotels_list[0] : $hotels_list;
	}
	function get_hotel_inventory_data($data) {
		$t = &$this->db_tables;
		$this->db->database = $data['dbname'];
		$hotel_property_data = $this->db->get_where($t->prop_info, array('id'=>$data['prop_id']))->row_array();
		// 		[id] => 1
		// 		[property_name] => otelMS
		// 		[property_name_english] =>
		// 		[dwelling] => 2
		// 		[property_type] => 14
		// 		[street] => Puliuia st. 40
		// 		[additional_information] =>
		// 		[city] => Львов
		// 		[state] => Львовская обл.
		// 		[post_code] => 79000
		// 		[country] => UKR
		// 		[gps_coordinates] => 49.8020418,23.9907771
		// 		[reception_phone] => +38044987654
		// 		[email] => support@otelms.com
		// 		[web_address] =>
		// 		[star_rating] => 0
		// 		[check_in_time] => 09:00
		// 		[check_out_time] => 11:30
		// 		[timezone] => Europe/Kiev
		
		return $hotel_property_data;
	}
	function convert_currency_from_amount_to($currency_from="", $amount=0, $currency_to=""){
		$t = &$this->db_tables;
		if($currency_from != "" && $currency_from != "" && $amount != 0){
			$sql = "SELECT t1.rate AS $currency_from, t2.rate AS $currency_to
					FROM $t->currency_rates_today as t1, $t->currency_rates_today as t2 
					WHERE t1.name = '$currency_from' AND t2.name = '$currency_to'";
			$rate = $this->db->query($sql)->row();
			$query = $this->db->query ( $sql );
			$rates_koef = $rate->$currency_to/$rate->$currency_from;
			$converted_amount = round($amount * $rates_koef);
			return $converted_amount;
		}
		return 0;
	}
	function get_hotel_currency() {
		$t = &$this->db_tables;
		$sql = "SELECT t1.name AS hotel_currency 
				FROM $t->currencies AS t1
				JOIN $t->h_config AS t2 ON t1.id = t2.value 
				WHERE t2.name = 'global_currency'";
		return ($this->db->query ( $sql )->row()->hotel_currency);
	}
	function get_ability_hotel_responce_language($requested_lang) {
		$t = &$this->db_tables;
		$requested_lang = substr ( $requested_lang, 0, 2 );
		$lang_code = $this->db->select('code')->get_where($t->supported_langs, array('name'=>$requested_lang))->row();
		if (!empty($lang_code)){
			$lang_code = $lang_code->code;
		}else {
			$lang_code = 45; //english by default? ili kak?
		}
		return $lang_code;
	}
	function get_hotel_availability_data($requested_data) {
		$t = &$this->db_tables;
		$hotel = $this->get_ta_hotels($requested_data['partner_hotel_code']);
		if (empty($hotel)){return NULL;}
		$this->db->database = $hotel['dbname'];
		$resp_language_id = $this->get_ability_hotel_responce_language($requested_data['language']);
		$hotel_currency = $this->get_hotel_currency();
		$int_datein = $requested_data['start_intday'];
		$int_dateout = $requested_data['end_intday'];
		$requested_rooms = $requested_data['rooms'];
		$requested_persons = $requested_data['persons'];
		$flags = $requested_data['requested_flags'];
		$prop_id = $hotel['prop_id'];
		$order_str = "ORDER BY total_price";
		if ($flags->multiple_room_rates){
			$order_str = "";
		}
		$sql = "SELECT  t1.category_id, t1.count as rooms_remaining, 
						COUNT(1) AS days_count, SUM(IFNULL(yieldprice.price, seasonspricelist.price)) AS total_price,
						IF(ratetocategory.maxplace, ratetocategory.maxplace, categories.add_places) AS max_room_places,
						ratetocategory.rate_id,
						t_inter_1.value AS category_name, t_inter_2.value AS rate_name
				FROM $t->availability AS t1
				JOIN categories ON categories.id = t1.category_id AND categories.web_booking = 1
				JOIN ratetocategory ON ratetocategory.category_id = t1.category_id AND ratetocategory.onlinebook = 1
				JOIN rate ON rate.id = ratetocategory.rate_id AND rate.isactive = 1
				JOIN onlinerates ON onlinerates.rateid = ratetocategory.rate_id
				LEFT JOIN yieldprice ON yieldprice.id_restrict_rate	= rate.id AND yieldprice.category_id = categories.id AND yieldprice.intdate = t1.intdate
				JOIN deskofdaysseason ON deskofdaysseason.intdate = t1.intdate
				JOIN seasons ON seasons.id = deskofdaysseason.seasonid AND seasons.is_active = 1
				JOIN seasonspricelist ON seasonspricelist.rate_id = rate.id AND seasonspricelist.category_id = categories.id AND seasonspricelist.season_id = seasons.id
				LEFT JOIN $t->inter AS t_inter_1 ON t_inter_1.table_id = categories.id AND t_inter_1.language_id = $resp_language_id 
							AND t_inter_1.table_type = 'category' AND t_inter_1.name = 'international_name'
				LEFT JOIN $t->inter AS t_inter_2 ON t_inter_2.table_id = onlinerates.rateid AND t_inter_2.language_id = $resp_language_id
							AND t_inter_2.table_type = 'rate' AND t_inter_2.name = 'international_name'
				WHERE 	t1.intdate BETWEEN $int_datein AND $int_dateout	AND t1.count >= $requested_rooms AND categories.property_id = $prop_id
				GROUP BY t1.category_id, rate.id
				HAVING 	days_count >= ($int_dateout-$int_datein+1) AND max_room_places >= $requested_persons
				$order_str";
		$query = $this->db->query ( $sql );
		$base_result = $this->db->query($sql)->result();
		if (empty($base_result)){
			return NULL;
		}
		$base_result = ($flags->multiple_room_rates) ? $base_result : array($base_result[0]);
		$result = new stdClass();
		foreach ($base_result as $data_set) {
			$room_type_id = $data_set->category_id;
			if (!isset($result->room_types->$room_type_id)){
				$result->room_types->$room_type_id = new RoomType ( array (
						'persistent_room_type_code' => $room_type_id,
						'name' => $data_set->category_name
				) );
				if ($flags->room_type_details){
					$result->room_types->$room_type_id->max_occupancy->number_of_adults = $data_set->max_room_places;
					$result->room_types->$room_type_id->max_occupancy->number_of_children = 0;
					$room_type_conditions_data = new stdClass();
					$room_type_conditions_data->room_type_id = $room_type_id;
					$room_type_conditions_data->photos = $flags->photos;
					$room_type_conditions_data->text = $flags->text;
					$room_type_conditions_data->resp_language_id = $resp_language_id;
					$room_type_details = $this->get_room_type_details($room_type_conditions_data);
					unset($room_type_conditions_data);
					foreach ($room_type_details as $p_name => $p_val) {
						$result->room_types->$room_type_id->$p_name = $p_val;
					}
				}
			}
			$rate_plan_id = $data_set->rate_id;
			if (!isset($result->rate_plans->$rate_plan_id)){
				$result->rate_plans->$rate_plan_id = new RatePlan ( array (
						'persistent_rate_plan_code' => $rate_plan_id,
						'name' => $data_set->rate_name
				) );
				if ($flags->rate_plan_details){
					$rate_plan_conditions_data = new stdClass();
					$rate_plan_conditions_data->rate_plan_id = $rate_plan_id;
					$rate_plan_conditions_data->photos = $flags->photos;
					$rate_plan_conditions_data->text = $flags->text;
					$rate_plan_conditions_data->resp_language_id = $resp_language_id;
					$rate_plan_details = $this->get_rate_plan_details($rate_plan_conditions_data);
					unset($rate_plan_conditions_data);
					foreach ($rate_plan_details as $p_name => $p_val) {
						$result->rate_plans->$rate_plan_id->$p_name = $p_val;
					}
				}
			}
			$room_rate_id = $room_type_id."_".$rate_plan_id;
			$converted_rate_amount = $this->convert_currency_from_amount_to ( $hotel_currency, $data_set->total_price, $requested_data ['currency'] );
			$result->room_rates->$room_rate_id = new RoomRates ( array (
					'persistent_room_rate_code' => $room_rate_id,
					'room_type_key' => $data_set->category_id,
					'rate_plan_key' => $data_set->rate_id,
					'line_items' => array (
							new LineItems ( array (
									'price' => new PriceItems ( array (
											'requested_currency_price' => new Price ( $converted_rate_amount, $requested_data ['currency'] ),
											'currency_of_charge_price' => new Price ( $data_set->total_price, $hotel_currency) // валюта проплати? звідки знаєм? Обовязкова при запиті доступності бронювання
									) ),
									'type' => 'rate',
									'paid_at_checkout' => true
							) ),
// 							new LineItems () // for fee and taxes if needed
					),
					'rooms_remaining' => ($flags->room_rate_details) ? $data_set->rooms_remaining : NULL,
					'url' => 'some URL with a GET request should go to a page that will show the price quoted and allow a user to book the room',
					'partner_data' => ( object ) array (
							'hms_id' => $hotel ['hms_id'],
							'prop_id' => $hotel ['prop_id'],
							'dbname' => $hotel ['dbname'],
							'rate_id' => $rate_plan_id,
							'category_id' => $room_type_id 
					)
			) );
			if ($flags->room_rate_details){
				$result->room_rates->$room_rate_id->rooms_remaining = $data_set->rooms_remaining;
				if ($flags->text){
					$result->room_rates->$room_rate_id->payment_policy = "Hotel payment policy some text";
					$result->room_rates->$room_rate_id->payment_policy = "Hotel miscellaneous policies some text";
				}
			}
			if ($flags->hotel_details){
				$result->hotel_details = new HotelDetails();
			}
			if ($flags->partner_booking_data){
				$result->partner_booking_details = new PartnerBookingDetails();
				if ($flags->text){
					$result->partner_booking_details->terms_and_conditions = "General terms and conditions text.";
					$result->partner_booking_details->payment_policy = "Describes how the partner will use the credit card information, e.g. charged immediately or hold";
				}
			}
		}
		return $result;//json_decode(json_encode($result_arr), FALSE);//(object)$result_arr;
	}
	function get_room_type_details($requested_data) {
		$result = new stdClass();
		$t = &$this->db_tables;
		if ($requested_data->photos){
			$result->photos = array();
			$sql = "SELECT t1.id_position AS url
					FROM $t->room_photos AS t1
					WHERE t1.category_id = $requested_data->room_type_id";
			$photos = $this->db->query($sql)->result_array();
			foreach ($photos as $photo_data) {
				array_push($result->photos, new Photo($photo_data));
			}
		}
		if ($requested_data->text){
			$sql = "SELECT  inter.value AS description
					FROM $t->room_params AS t1
					LEFT JOIN $t->inter AS inter ON inter.table_id = t1.catID AND inter.language_id = $requested_data->resp_language_id
													AND inter.table_type = 'category' AND inter.name = 'international_comment'
					WHERE t1.catID = $requested_data->room_type_id";
			$row = $this->db->query($sql)->row();
			if (isset($row->description)){
				$result->description = $row->description;
			}
		}
		//======================================  get category amenities
		$sql = "SELECT t2.tripadvisor AS amenity_code
				FROM $t->category2amenities AS t1
				JOIN $t->category_ameneties AS t2 ON t1.amenity_id = t2.id
				WHERE t1.category_id = $requested_data->room_type_id AND t2.tripadvisor != ''";
		$amenities_query_result = $this->db->query($sql)->result();
		$amenities = array();
		foreach ($amenities_query_result as $amenity) {
			array_push($amenities, $amenity->amenity_code);
		}
		$result->room_amenities->standard = $amenities;
		$result->room_amenities->custom = array();
		//======================================  get category room size
		$result->room_size = NULL;
		//======================================  get category bed_configurations and extra_bed_configurations
		
		$result->bed_configurations = NULL;
		$result->extra_bed_configurations = NULL;
		//======================================  get category room_view_types
		$sql = "SELECT t2.tripadvisor AS view_code
		FROM $t->room_params AS t1
		JOIN $t->room_views AS t2 ON t1.view = t2.id
		WHERE t1.catID = $requested_data->room_type_id AND t2.tripadvisor != ''";
		$views_query_result = $this->db->query($sql)->result();
		$views = array();
		foreach ($views_query_result as $view) {
			array_push($views, $view->view_code);
		}
		$result->room_view_types->standard = $views;
		$result->room_view_types->custom = array();
		//======================================  get category accessibility_features
		$result->accessibility_features = NULL;
		//======================================  get category room_smoking_policy
		$result->room_smoking_policy = 'unknown';
		
		return $result;
	}
	
	function get_rate_plan_details($requested_data) {
		$result = new stdClass();
		$t = &$this->db_tables;
		if ($requested_data->photos){
			$result->photos = NULL;
		}
		if ($requested_data->text){
			$sql = "SELECT  inter.value AS description
			FROM rate AS t1
			LEFT JOIN $t->inter AS inter ON inter.table_id = t1.id AND inter.language_id = $requested_data->resp_language_id
										AND inter.table_type = 'rate' AND inter.name = 'international_description'
			WHERE t1.id = $requested_data->rate_plan_id";
			$row = $this->db->query($sql)->row();
			if (isset($row->description)){
				$result->description = $row->description;
			}
		}
		//======================================  get rate amenities
		$result->rate_amenities->standard = array();
		$result->rate_amenities->custom = array();
		//======================================  get rate cancellation_policy 
		$result->cancellation_policy  = NULL;
		//refundable : none partial full 
		$sql = "SELECT  t2.name AS cancelation_name_code, t3.id AS cancelation_type_id, t4.id AS meal_plan,
						t2.penalty_ar,t2.deadline_days, t2.deadline_hours, t2.penalty_ad, t2.penalty_ad_nights, t2.description
				FROM rate AS t1
				JOIN $t->cancelations AS t2 ON t2.id = t1.cancellation_policy_id
				JOIN $t->cancelation_types AS t3 ON t3.id = t2.type_id
				JOIN $t->meal_policies as t4 ON t1.meal_policy_id = t4.id
				WHERE t1.id = $requested_data->rate_plan_id";
		$row_rezult = $this->db->query($sql)->row();
		$row = $this->db->query($sql)->row();
		$result->cancellation_policy->cancellation_summary->refundable = 'none';//$row_rezult->cancelation_type_id;
		$result->cancellation_policy->cancellation_summary->cancellation_deadline = "";
		$result->cancellation_policy->cancellation_summary->unstructured_cancellation_text = $row_rezult->description;
		$cancellation_rule = new stdClass();
// 		$cancellation_rule->start_datetime = "";
// 		$cancellation_rule->end_datetime = "";
// // 		$cancellation_rule->fixed_fee->amount = "";
// // 		$cancellation_rule->fixed_fee->currency = "";
// 		$cancellation_rule->taxes_included = true;
		$cancellation_rule->percent_fee->amount = 1;
// 		$cancellation_rule->night_fee->num_nights = 4;
		$result->cancellation_policy->cancellation_rules = array($cancellation_rule);
		//======================================  get rate meal_plan
	
		$result->meal_plan->standard = array($row_rezult->meal_plan);
		$result->meal_plan->custom = array();
		return $result;
	}
}

class Response{
	protected $request = "";
	public $api_version = 8;
	public function __construct($request){
		if (!empty($request)){
			$this->request = $request;
		}else{
			exit('{Cannot Parse Request}');
		}
	}
	private function validate(&$obj_or_arr) {
		foreach ( $obj_or_arr as $p => $v ) {
			if (is_array($v) || is_object($v)){
				$this->validate($v);
				if (!count((array)$v)){
					unset($obj_or_arr->$p);
				}
			}elseif (is_null($v)) {
				unset($obj_or_arr->$p);
			}
		}
	}
	private function __validate() {
		self::validate($this);
	}
	public function get_request(){
		return json_decode($this->request);
	}
	public function send() {
// 		echo "<pre>";
// 		print_r($this);
// 		die("DIED by A Department on dcm_ta_gate.php send() at 25.11.2019 12:47:00");
		self::__validate();
		header ( 'Content-Type: application/json' );
		echo json_encode($this, true);
	}
}

class ConfigResponse extends Response {
	public $configuration = 'required';
	public $debug_info = "debug mode";
	public function __construct(){
		$this->configuration = new Configuration;
	}
}

class InventoryResponse extends Response {
	public $lang = "en_US";
	public $hotels = 'required';
	public function __construct($request){
		parent::__construct($request);
	}
	public function add_hotel($hotel_data) {
		if (!is_array($this->hotels)){
			$this->hotels = array();
		}
		$this->hotels[] = new InventoryHotel ($hotel_data);
	}
}

class BookingSubmitResponse extends Response {
	public $language = "en_US";
	public $problems;
	public $reference_id;
	public $status;
	public $reservation;
	public $customer_support;
	public function __construct($request){
		parent::__construct($request);
		if (!empty($request)){
			$request = json_decode($request);
			$this->reference_id = $request->reference_id;
			$this->reservation = new Reservation($request);
			$this->customer_support = new CustomerSupport();
		}else{
			exit('Cannot Parse Booking Submit Response');
		}
	}
// 	public function get_requested_rooms_count (){
// 		return count($this->reservation->rooms);
// 	}
// 	public function get_start_intday(){
// 		return round (strtotime($this->reservation->start_date)/86400);
// 	}
// 	public function get_end_intday(){
// 		return round (strtotime($this->reservation->end_date)/86400);
// 	}
}

class AvailabilityResponse extends Response {
	public $language = "en_US";
	public $availability_request;
	public $response_payload;
	public $hotels;
	public function __construct($request){
		if (!empty($request)){
			$request = json_decode($request);
			$this->response_payload = $request->requested_payload;
			$this->availability_request = $request;
			foreach ($this->availability_request->hotels as $requested_hotel) {
				$partner_hotel_code = $requested_hotel->partner_hotel_code;
				$this->hotels->$partner_hotel_code = new SingleHotelResponse;
			}
		}else{
			exit('Cannot Parse Availability Request');
		}
	}
	public function get_start_intday(){
		return round (strtotime($this->availability_request->start_date)/86400);
	}
	public function get_end_intday(){
		return round (strtotime($this->availability_request->end_date)/86400);
	}
	public function get_requested_flags ($flag = ""){
		$rezult = new stdClass();
		if (! is_null ( $this->availability_request )) {
			foreach ( $this->availability_request->requested_payload->categories as $flag_name => $flag_val ) {
				$rezult->$flag_name = $flag_val;
			}
			foreach ( $this->availability_request->requested_payload->category_modifiers as $flag_name => $flag_val ) {
				$rezult->$flag_name = $flag_val;
			}
			if (!empty($flag)){
				return $rezult->$flag;
			}
		} else {
			echo "NO requested_payload";
		}
		return $rezult;
	}
	public function get_requested_rooms_count (){
		return count($this->availability_request->party);
	}
	public function get_requested_guests_count (){
		$max_guests_count = 1;
		foreach ($this->availability_request->party as $room_party) {
			$children_count = (isset($room_party->children)) ? count($room_party->children) : 0;
			$room_guests_count = $room_party->adults + $children_count;
			if ($room_guests_count > $max_guests_count){ $max_guests_count = $room_guests_count;}
		}
		return $max_guests_count;
	}
}

class ContactInfo {
// full_name	string 		The full name of the contact
// email		string 		The email address for the contact. Maximum of 256 characters.
// phone_number	string 		The phone number for the contact. maximum of 50 characters.
	public $full_name;
	public $email;
	public $phone_number;
	public function __construct($full_name = 'required', $email = 'required', $phone_number = 'required'){
		$this->full_name = $full_name;
		$this->email = $email;
		$this->phone_number = $phone_number;
	}
}


class Configuration {
// 	emergency_contacts	ContactInfo array Array of Technical Contact Info objects. Must be present. Must include technical contacts to be notified in case of urgent API issues.
// 	info_contacts	ContactInfo array	Array of Contact Info objects. Must be present.
// 	languages	string array	[Optional] Array of strings. This is a list of languages that the partner supports. Use the least specific language possible, e.g. If the partner supports all English regardless of country, list only “en”. Do not list all the currently supported variants of English. TripAdvisor may still send requests that do not use one of the partner’s supported languages. If this happens, the response can be any language the partner chooses; however, TripAdvisor will not allow this property to be displayed in Instant Booking for that particular locale.
// 	pref_hotels	number	[Optional] Preferred number of hotels per availability request. TripAdvisor may still request a different number of hotels in one request. This is a suggestion to TripAdvisor.
// 	five_min_rate_limit	number	[Optional] Preferred rate limit, number of requests over 5 minutes. This is a suggestion to TripAdvisor
	public $emergency_contacts = 'required';
	public $info_contacts = 'required';
	public $languages = array();
	public $pref_hotels = 50;
	public $five_min_rate_limit = 10000;
	
	public function __construct(){
// 		unset($this->pref_hotels);
// 		$this->languages = array();
// 		$this->info_contacts = new ContactInfo;
	}
	
	public function add_emergency_contact($full_name = 'required', $email = 'required', $phone_number = 'required') {
		if (!is_array($this->emergency_contacts)){
			$this->emergency_contacts = array();
		}
		$this->emergency_contacts[] = new ContactInfo ($full_name, $email, $phone_number);
	}
	public function add_info_contact($full_name = 'required', $email = 'required', $phone_number = 'required') {
		if (!is_array($this->info_contacts)){
			$this->info_contacts = array();
		}
		$this->info_contacts[] = new ContactInfo ($full_name, $email, $phone_number);
	}
}

class InventoryHotel{
	public $ta_id			;//= 0;
	public $partner_id		;//= 'required';
	public $name			;//= 'required';
	public $street			;//= 'required';
	public $city			;//= 'required';
	public $postal_code		;//= '';
	public $state			;//= 'required';
	public $country			;//= 'required';
	public $latitude		;//= 0;
	public $longitude		;//= 0;
	public $desc			;//= '';
	public $url				;//= 'required';
	public $email			;//= '';
	public $phone			;//= '';
	public $fax				;//= '';
	public $room_types		;//= '';
	
	public function __construct($hotel_data = array()){
		foreach ($this as $p => $v) {
			if (isset($hotel_data[$p])){
				$this->$p = $hotel_data[$p];
			}
		}
// 		$this->room_types = (object) array('RoomShortName' => new InventoryRoomType);
	}
}

class InventoryRoomType {
// 	Field			Type			Description
// 	url				string		 	[Optional] The URL of the hotel on the partner site. Make this URL as specific as possible. This URL must be accessible with a GET request. Maximum 2000 characters.
// 	desc			string		 	[Optional] Description of the room type. Maximum 1000 characters.
	
	public $url		= "";
	public $desc	= "";
	public function __construct(){
	}
}
class SingleHotelResponse  {
// 	Field			Type			Description
// 	response_type	string			The type of response returned for a hotel. Must be one of "available",  "unavailable" or "error"
// 	available		SingleHotel map	Representation of an individual hotel. Only if response_type is "available".
// 	error			Error object	Only if response_type is "error". See Error.
	public $response_type;
	public $available;
	public $error;
	public function __construct(){
	}
}
class RoomType {
	public $persistent_room_type_code;
	public $name;
	public $description;
	public $photos;
	public $room_amenities;
	public $max_occupancy;
	public $room_size;
	public $bed_configurations;
	public $extra_bed_configurations;
	public $room_view_types;
	public $accessibility_features;
	public $room_smoking_policy;
	
	public function __construct($room_data=array()){
		foreach ($this as $p => $v) {
			if (isset($room_data[$p])){
				$this->$p = $room_data[$p];
			}
		}
	}
}
class RatePlan {
	public $persistent_rate_plan_code;
	public $name;
	public $description;
	public $photos;
	public $rate_amenities;
	public $cancellation_policy ;
	public $meal_plan;

	public function __construct($rate_data=array()){
		foreach ($this as $p => $v) {
			if (isset($rate_data[$p])){
				$this->$p = $rate_data[$p];
			}
		}
	}
}
class RoomRates {
	public $persistent_room_rate_code;
	public $room_type_key;
	public $rate_plan_key;
	public $line_items;
	public $payment_policy;
	public $rooms_remaining;
	public $other_policy;
	public $url;
	public $partner_data;
	
	public function __construct($room_rate_data=array()){
		foreach ($this as $p => $v) {
			if (isset($room_rate_data[$p])){
				$this->$p = $room_rate_data[$p];
			}
		}
	}
}
class LineItems {
	public $price;
	public $type;
	public $sub_type;
	public $paid_at_checkout;

	public function __construct($line_item_data=array()){
		foreach ($this as $p => $v) {
			if (isset($line_item_data[$p])){
				$this->$p = $line_item_data[$p];
			}
		}
	}
}
class HotelDetails {
	public $name;
	public $address1;
	public $address2;
	public $city;
	public $state;
	public $postal_code;
	public $country;
	public $latitude;
	public $longitude;
	public $phone;
	public $url;//URL for general hotel contact, not a booking page.
	public $hotel_amenities;
	public $photos;
	public $checkin_checkout_policy;
	public $checkin_time;
	public $checkout_time;
	public $hotel_smoking_policy;
	public $child_policy;
	public $pet_policy;
	public $parking_shuttle;
	public $hotel_extra_bed_policy;
	
	public function __construct($partner_hotel_code, $requested_lang){
		$hotel_details = array();
		foreach ($this as $p => $v) {
			if (isset($hotel_details[$p])){
				$this->$p = $hotel_details[$p];
			}
		}
		$this->name = "Test_delails";
	}
}
class PartnerBookingDetails {
	public $accepted_credit_cards;
	public $terms_and_conditions;
	public $terms_and_conditions_url;
	public $payment_policy;
	public $other_policy;
	public $customer_support;
	public function __construct(){
		$this->accepted_credit_cards = array('Visa', 'MasterCard', 'AmericanExpress', 'Discover');
		$this->customer_support = new CustomerSupport();
	}
}
class Error {
	
// 	error_code			number			One of these error codes:
// 										1	Unknown Error
// 										2	Cannot Parse Request
// 										3	Invalid Hotel ID. If partner_hotel_code is unknown, return this.
// 										4	Timeout requested. Stops requests for the specified time.
// 										5	Recoverable Error. Equivalent to http 503.
// 	message				string			String describing the error. Used for debugging. Maximum length is 1000 characters.
// 	timeout				number			Number of seconds we should stop sending requests for use with Error Code 4
	
	public $error_code;
	public $message;
	public $timeout;
	
	public function __construct(){
	}
}
class Photo {
	public $url;
	public $caption;
	public $width;
	public $height;
	public function __construct($photo_details=array()){
		foreach ($this as $p => $v) {
			if (isset($photo_details[$p])){
				$this->$p = $photo_details[$p];
			}
		}
	}
}
class Customer {
	public $first_name;
	public $last_name;
	public $phone_number;
	public $email;
	public $country;
	public function __construct(){
	}
}
class RoomStay {
	public $party;
	public $traveler_first_name;
	public $traveler_last_name;
	public function __construct(){
	}
}
class PaymentMethod {
	public $card_type;
	public $card_number;
	public $cardholder_name;
	public $expiration_month;
	public $expiration_year;
	public $cvv;
	public $billing_address;
	public function __construct(){
	}
}
class Address {
	public $address1;
	public $address2;
	public $city;
	public $state;
	public $postal_code;//U.S. Address: Required Other Address: Optional. Zip code or postal code
	public $country;//ISO 3166 country code
	public function __construct(){
	}
}
class Reservation {
	public $reservation_id;
	public $status;// The status of the reservation, must be one of:Booked, Cancelled, CheckedIn, CheckedOut
	public $confirmation_url = "http://www.hotelsite.com/deeplink-to-reservation";
	public $start_date;
	public $end_date;
	public $partner_hotel_code;
	public $hotel;//HotelDetails object
	public $customer;
	public $rooms;
	public $legal_text;
	public $comments;
	public $line_items;//An array of LineItem objects will contain a separate LineItem for rate, tax, and fee types with each corresponding sub_type
	public function __construct($request_data = stdClass){
		foreach ($this as $p => $v) {
			if (isset($request_data->$p)){
				$this->$p = $request_data->$p;
			}
		}
		$this->hotel = new HotelDetails();
	}
}
class PriceItems {
	public $requested_currency_price;
	public $currency_of_charge_price;
	public function __construct($price_item_data){
		foreach ($this as $p => $v) {
			if (isset($price_item_data[$p])){
				$this->$p = $price_item_data[$p];
			}
		}
	}
}
class Price {
	public $amount;// number The value of the price.
	public $currency;// string ISO 4217 currency code for the price
	public function __construct($amount=NULL, $currency=NULL){
		$this->amount = $amount;
		$this->currency = $currency;
	}
}
class Problem {
	public $problem;
	public $explanation;
	public $detail;
	public function __construct(){
	}
}
class Contact {
	public $contact;//string	The contact detail, e.g. phone number or email address
	public $description;//string A description for this contact.
	public function __construct(){
	}
}
class CustomerSupport {
	public $phone_numbers;
	public $emails;
	public $urls;
	public function __construct(){
		$this->phone_numbers->standard = array (array(
				'description' => 'Short description of the phone number',
				'country_code' => '4',
				'number' => 03228764932 )
		);
		$this->phone_numbers->custom = array ();
		$this->emails = array(array('description'=>'', 'email'=>'info@otelms.com'));
		
	}
}
class ProblemTypes {
	public $problem_type = array (
			'CreditCardDeclined',
			'CreditCardTypeNotSupported',
			'MissingTravelerFirstName',
			'MissingTravelerLastName',
			'MissingEmail',
			'MissingReservationFirstName',
			'MissingReservationLastName',
			'MissingWorkPhone',
			'MissingHomePhone',
			'MissingAddress',
			'MissingCity',
			'MissingStateProvince',
			'MissingCountry',
			'MissingPostalCode',
			'MissingCardholderName',
			'InvalidTravelerFirstName',
			'InvalidTravelerLastName',
			'InvalidEmail',
			'InvalidReservationFirstName',
			'InvalidReservationLastName',
			'InvalidWorkPhone',
			'InvalidHomePhone',
			'InvalidAddress',
			'InvalidCity',
			'InvalidStateProvince',
			'InvalidCountry',
			'InvalidPostalCode',
			'InvalidCardholderName',
			'UnknownUserProblem',
			'RoomNotAvailable',
			'PartnerDown',
			'PartnerTimeout',
			'AgentAttention',
			'PropertyNotSupported',
			'PriceMismatch',
			'UnknownReference',
			'UnknownPartnerProblem' 
	);
}