<?php 
class dcm_ozon extends dcm_abstract {
    public function __construct() {
        parent::__construct();
        


        $this->table_name_r2c = "dc_ozon_rate2category_link";
        $this->table_name_dc_category2occupancy = "dc_ozon_category2occupancy";;
        $this->table_name_dc2hms_category_link = "dc_ozon_rooms_link";
        
        
        $this->sql_dc_rates = "select dc_ozon_rates.id as dc_hms_id_rate, dc_ozon_rates.dc_rate_id as dc_rate_id, dc_ozon_rates.active, 
        		dc_ozon_rates.name as dc_rate_name, dc_global_restrict_rate.name as restrict_name 
        		from dc_ozon_rates 
        		LEFT JOIN dc_ozon_rates_link ON dc_ozon_rates_link.dc_rate_id = dc_ozon_rates.dc_rate_id
        		LEFT JOIN dc_global_restrict_rate ON dc_global_restrict_rate.rate_id = dc_ozon_rates_link.restrict_id";
        $this->sql_dc_category_link = "select dc_room_name as dc_category_name,
            dc_room_id	 as dc_category_id, dc_ozon_rooms_link.id as dc_hms_id_cat,
            category_id as hms_category_id
            from dc_ozon_rooms_link";
        $this->sql_dc_r2rlink = "select dc_rate_id as dc_rate_id, restrict_id as hms_restrict_id from dc_ozon_rates_link";
        $this->sql_dc_r2c = "select dc_rate_id as dc_rate_id,
            dc_category_id as dc_category_id,
            hms_rate_id as hms_rate_id,
            hms_price_func_id as hms_price_func_id,
            hms_restrict_id as hms_restrict_id,
            hms_occupancy_id as hms_occupancy_id
            from dc_ozon_rate2category_link";
        
        $this->sql_get_occupancies = "select id as hms_occupancy_id,
           name as hms_occupancy_name, dc_room_id from dc_ozon_occupancy";
        $this->sql_build_hms_categories = "select id as hms_category_id,
            name as hms_category_name from categories";
        
        $this->sql_dc_category_list = "select dc_ozon_rooms_link.dc_room_name as dc_category_name, 
            dc_ozon_rooms_link.dc_room_id as dc_category_id, dc_ozon_rooms_link.id as dc_hms_id, dc_ozon_rooms_link.active, dc_ozon_occupancy.id as hms_occupancy_id, dc_ozon_occupancy.name as hms_occupancy_name from dc_ozon_rooms_link 
        	INNER JOIN dc_ozon_occupancy ON dc_ozon_occupancy.dc_room_id = dc_ozon_rooms_link.dc_room_id";
        $this->sql_dc_category2occupancy_list = "select dc_category_id as dc_category_id,
            hms_occupancy_id as hms_occupancy_id from dc_ozon_category2occupancy";
        $this->form_action_c2o_post = "/dc_ozon/categories_edit_post";
        $this->form_action_r2c_post = "/dc_ozon/rates_edit_post";
        
        $this->form_action_c2o_post_c2 = "/dc_ozon_c2/categories_edit_post";
        $this->form_action_r2c_post_c2 = "/dc_ozon_c2/rates_edit_post";
    }
    
    function get_occupancies($occupancy_bool = FALSE)
    {
    	$sql = $this->sql_get_occupancies;
    	$query = $this->db->query($sql);
    	$occupancies = array();
    	foreach ($query->result() as $row) {
    		$occupancies[$row->dc_room_id] [$row->hms_occupancy_id] ['hms_occupancy_id'] = $row->hms_occupancy_id;
    		$occupancies[$row->dc_room_id] [$row->hms_occupancy_id] ['hms_occupancy_name'] = $row->hms_occupancy_name;
    	}
    	return $occupancies;
    }
    
    function build_category2occupancy($type = 0)
    {
    	$sql = $this->sql_dc_category_list;
    
    	$c2o = array();
    	
    	$hms_categories = $this->build_hms_categories();
    	$query = $this->db->query($sql);
    	foreach ($query->result() as $row) {
    		$c2o[$row->dc_category_id]['dc_category_id'] = $row->dc_category_id;
    		//$c2o[$row->dc_category_id]['dc_hms_id'] = $row->dc_hms_id;
    		if(isset($row->dc_hms_id)){
    			$c2o[$row->dc_category_id]['dc_hms_id'] = $row->dc_hms_id;
    		}
    		$c2o[$row->dc_category_id]['dc_category_name'] = $row->dc_category_name;
    		if(isset($row->active)){
    			$c2o[$row->dc_category_id]['active'] = $row->active;
    		}else{
    			$c2o[$row->dc_category_id]['active'] = "";
    		}
    		
    		$c2o[$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_occupancy_id'] = $row->hms_occupancy_id;
    		$c2o[$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_occupancy_name'] = $row->hms_occupancy_name;
    		$c2o[$row->dc_category_id]['hms_categories_list'] = $hms_categories;
    	}
    	$sql = $this->sql_dc_category_link;
    
    	$query = $this->db->query($sql);
    	foreach ($query->result() as $row) {
    		$c2o[$row->dc_category_id]['hms_categories_list'][$row->hms_category_id]['selected'] = "selected";
    	}
    
    	$sql = $this->sql_dc_category2occupancy_list;
    	// echo $sql;
    	$query = $this->db->query($sql);
    	foreach ($query->result() as $row) {
    		$c2o[$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['checked'] = "checked";
    	}
    	return $c2o;
    }
    
    function build_rate2category($occupancy_bool = 0, $roomstorate = 0, $price_func = 0)
    {
    	$sql = $this->sql_dc_rates;
    	//echo $sql."<br>";
    	$query = $this->db->query($sql);
    	$rate2category = array();
    	$hms_rates_list = $this->build_hms_rates();
    	$hms_restrictions_list = $this->build_hms_restrictions();
    	$hms_occupancies_list = $this->get_occupancies();
    
    	$c2o = $this->get_category2occupancy();
    
    	foreach ($query->result() as $rate_row) {
    		$sql = $this->sql_dc_category_link;
    		// echo $sql."<br>";
    		$query2 = $this->db->query($sql);
    
    		$rate2category[$rate_row->dc_rate_id] = array();
    		$rate2category[$rate_row->dc_rate_id]['dc_rate_name'] = $rate_row->dc_rate_name;
    		$rate2category[$rate_row->dc_rate_id]['dc_rate_id'] = $rate_row->dc_rate_id;
    		$rate2category[$rate_row->dc_rate_id]['urlencode_dc_rate_id'] = urlencode($rate_row->dc_rate_id);
    		$rate2category[$rate_row->dc_rate_id]['dc_hms_id_rate'] = $rate_row->dc_hms_id_rate;
    		if(isset($rate_row->active)){
    			$rate2category[$rate_row->dc_rate_id]['active'] = $rate_row->active;
    		}else{
    			$rate2category[$rate_row->dc_rate_id]['active'] = "active";
    		}
    		// ================================================================================
    		if (isset($rate_row->restrict_name)) {
    			$rate2category[$rate_row->dc_rate_id]['restrict_name'] = $rate_row->restrict_name;
    		} else {
    			$rate2category[$rate_row->dc_rate_id]['restrict_name'] = "";
    		}
				// ================================================================================
			foreach ( $query2->result () as $category_row ) {
				$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['dc_category_name'] = $category_row->dc_category_name;
				$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['dc_category_id'] = $category_row->dc_category_id;
				$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['urlencode_dc_category_id'] = urlencode($category_row->dc_category_id);
				$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['dc_rate_id'] = $rate_row->dc_rate_id;
				$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['urlencode_dc_rate_id'] = urlencode($rate_row->dc_rate_id);
				
				$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['dc_hms_id_cat'] = $category_row->dc_hms_id_cat;
				$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['dc_hms_id_rate'] = $rate_row->dc_hms_id_rate;
				// $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['hms_restrictions_list'] = $hms_restrictions_list;
				if (isset ( $hms_occupancies_list [$category_row->dc_category_id] )) {
					foreach ( $hms_occupancies_list [$category_row->dc_category_id] as $occupancy_cell ) {
						if (isset ( $c2o [$category_row->dc_category_id] [$occupancy_cell["hms_occupancy_id"]] )) {
							$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell["hms_occupancy_id"]] ['dc_rate_id'] = $rate_row->dc_rate_id;
							$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell["hms_occupancy_id"]] ['dc_rate_name'] = $rate_row->dc_rate_name;
							$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell["hms_occupancy_id"]] ['dc_category_name'] = $category_row->dc_category_name;
							$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell["hms_occupancy_id"]] ['dc_category_id'] = $category_row->dc_category_id;
							$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell["hms_occupancy_id"]] ['hms_rates_list'] = $hms_rates_list;
							$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell["hms_occupancy_id"]] ['hms_price_func_list'] = $this->build_price_func ();
							$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell["hms_occupancy_id"]] ['hms_restrictions_list'] = $hms_restrictions_list;
							
							$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell["hms_occupancy_id"]] ['hms_occupancy_id'] = $occupancy_cell["hms_occupancy_id"];
							$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell["hms_occupancy_id"]] ['hms_occupancy_name'] = $occupancy_cell["hms_occupancy_name"];
						}
					}
				}
				if (! isset ( $rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] )) {
					unset ( $rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] );
				}
				$rate2category [$rate_row->dc_rate_id] ['hms_restrictions_list'] = $hms_restrictions_list;
			}
		}
    	//echo "<pre>";
    	//print_r($rate2category);
    	//die();
    	//
    	$sql = $this->sql_dc_r2c;
    	$query = $this->db->query($sql);
    	// echo $sql;
    	foreach ($query->result() as $row) {
    		if (isset($c2o[$row->dc_category_id][$row->hms_occupancy_id])) {
    			$rate2category[$row->dc_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_rates_list'][$row->hms_rate_id]['selected'] = 'selected';
    			$rate2category[$row->dc_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_restrictions_list'][$row->hms_restrict_id]['selected'] = 'selected';
    			$rate2category[$row->dc_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_price_func_list'][0]['pf_selected'] = '';
    			$rate2category[$row->dc_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_price_func_list'][$row->hms_price_func_id]['pf_selected'] = 'selected';
    		}
    	}
    
    	if ($this->sql_dc_r2rlink !== "") {
    		$sql = $this->sql_dc_r2rlink;
    		$query = $this->db->query($sql);
    		// echo $sql;
    		foreach ($query->result() as $row) {
    			$rate2category[$row->dc_rate_id]['hms_restrictions_list'][$row->hms_restrict_id]['selected'] = 'selected';
    		}
    	}
    	// echo "<pre>";
    	// print_r($rate2category);
    	return $rate2category;
    }
    
    
    function rate2category_save_ozon($r2c)
    {
    	if (sizeof($r2c)) {
    
    	} else {
    		return;
    	}
    	
    
    	$this->db->query("delete from " . $this->table_name_r2c);
    
    	//echo "<pre>";
    	//print_r($r2c);
    	
    	foreach ($r2c as $dc_hms_id_rate => $dc_category_list) {
    		foreach ($dc_category_list['room_list'] as $dc_hms_id_cat => $occupancy) {
    		    //print_r($occupancy);
    			foreach ($occupancy as $key => $cell) {
    				$sql = "insert into " . $this->table_name_r2c . "  (dc_rate_id, dc_category_id, hms_occupancy_id,  hms_rate_id, hms_price_func_id) values
    				('".$dc_category_list['dc_rate_id']."', '".$cell['dc_category_id']."', " . $cell['hms_occupancy_id'] . ", " . $cell['hms_rate_id'] . ", " . $cell['hms_price_func_id'] . ") on duplicate key update
                hms_rate_id=" . $cell['hms_rate_id'] . ", hms_price_func_id=" . $cell['hms_price_func_id'] . "
                    , hms_occupancy_id=" . $cell['hms_occupancy_id'] . "";
    				// echo $sql . "\n";
    				$this->db->query($sql);
    				//===================================
    				
    			}
    		}
    		$sql = "INSERT INTO dc_ozon_rates_link (dc_rate_id, restrict_id) values ('".$dc_category_list['dc_rate_id']."', ".$r2c[$dc_hms_id_rate]['hms_restrict_id'].")
			on duplicate key update restrict_id = ".$r2c[$dc_hms_id_rate]['hms_restrict_id'];
    		$this->db->query ( $sql );
    	}
    	
    	//die();
    	   
    }
    
    function category2occupancy_save_ozon($c2o)
    {
    	$this->db->query("delete from " . $this->table_name_dc_category2occupancy);
    	foreach ($c2o as $dc_hms_id => $cell) {
    		$sql = "insert into " . $this->table_name_dc2hms_category_link . "  (dc_room_id, category_id) values
    		('" . $cell['dc_category_id'] . "', " . $cell['hms_category_id'] . ") on duplicate key update
                category_id=" . $cell['hms_category_id'] . " ";
    		// echo $sql . "\n";
    		$this->db->query($sql);
    		if (isset($cell['occupancies'])) {
    			foreach ($cell['occupancies'] as $key => $state) {
    				$sql = "insert into " . $this->table_name_dc_category2occupancy . " (dc_category_id, hms_occupancy_id)
                    values ('" . $cell['dc_category_id'] . "', " . $key . ") on duplicate key update
                        dc_category_id = '" . $cell['dc_category_id'] . "', hms_occupancy_id = " . $key . "";
    				//echo $sql . "\n";
    				$this->db->query($sql);
    			}
    		}
    	}
    }
    
    function options_save($data) {
    	$data_1 = array ();
    	$query = $this->db->query ( "SELECT * FROM dc_ozon_xml_cfg WHERE name LIKE 'general_update'" );
    
    	if ($query->num_rows () > 0) {
    		$row = $query->row_array ();
    		$data_1["general_update"] = $row["int_value"];
    	}
    	$sql = "INSERT INTO dc_ozon_xml_cfg (name, int_value) VALUES('dealer_id', '" . $data ["dealer"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["dealer"];
    	$query = $this->db->query ( $sql );
    	$sql = "INSERT INTO dc_ozon_xml_cfg (name, int_value) VALUES('overbooking_category_id', '" . $data ["overbooking_category"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["overbooking_category"];
    	$query = $this->db->query ( $sql );
    	$sql = "INSERT INTO dc_ozon_xml_cfg (name, int_value) VALUES('general_update', '" . $data ["general_update"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["general_update"];
    	$query = $this->db->query ( $sql );
    
    	$data_2 = array ();
    	$query = $this->db->query ( "SELECT * FROM dc_ozon_xml_cfg WHERE name LIKE 'general_update'" );
    
    	if ($query->num_rows () > 0) {
    		$row = $query->row_array ();
    		$data_2["general_update"] = $row["int_value"];
    	}
    
    	$this->Loger_admin->SaveLog ( $data_1, $data_2, "loger_admin", 0, "dc_ozon_xml_cfg", "edit" );
    }
    
    function gethotelid() {
    	$query = $this->db->query ( "SELECT int_value FROM dc_ozon_xml_cfg WHERE name LIKE 'hotel_id'" );
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$hotel_id = $row->int_value;
    	} else {
    		$hotel_id = "none";
    	}
    	return $hotel_id;
    }
    function getauthparam() {
    	$data = array ();
    	$data ['user'] = "";
    	$data ['pwd'] = "";
    	$data ['hotel_str'] = "";
    	$data ['hotel_id'] = 0;
    	$data ['test_mode'] = 1;
    	 
    	$query = $this->db->query ( "SELECT int_value FROM dc_ozon_xml_cfg WHERE name LIKE 'test_mode'" );
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$data ['test_mode'] = $row->int_value;
    	} else {
    		$data ['test_mode'] = 0;
    	}

    	if($data ['test_mode'] == 1) {
    			//======== TEST MODE ===============
    			$data ['api_url'] = "http://stage.api.ozon.travel/hotels/cm/v1";    			
    	} else {
    	    $data ['api_url'] = "https://api.ozon.travel/hotels/cm/ozon/v1";
    	}
    	
    	$query = $this->db->query ( "SELECT str_value FROM dc_ozon_xml_cfg WHERE name LIKE 'user'" );
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$data ['user'] = $row->str_value;
    	}
    	 
    	$query = $this->db->query ( "SELECT str_value FROM dc_ozon_xml_cfg WHERE name LIKE 'pwd'" );
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$data ['pwd'] = $row->str_value;
    	}
    	
    	$query = $this->db->query ( "SELECT str_value FROM dc_ozon_xml_cfg WHERE name LIKE 'hotel_str'" );
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$data ['hotel_str'] = $row->str_value;
    	}
    	
    	$query = $this->db->query ( "SELECT int_value FROM dc_ozon_xml_cfg WHERE name LIKE 'hotel_id'" );
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$data ['hotel_id'] = $row->int_value;
    	}

    	return $data;
    }
    function bokking_xml_parse_OLD($data, $send_notification = 1) {
    	$dc_hotel_id = "";
    	$query = $this->db->query ( "SELECT int_value FROM dc_ozon_xml_cfg WHERE name LIKE 'hotel_id'" );
    
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$dc_hotel_id = $row->int_value;
    	}
    
    	$occupancy_rate = array ();
    
    	$query = $this->db->query ( "SELECT dc_rate_id, dc_category_id, hms_occupancy_id, hms_rate_id FROM dc_ozon_rate2category_link" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$occupancy_rate [$row->dc_rate_id] [$row->dc_category_id] [$row->hms_occupancy_id] = $row->hms_rate_id;
    		}
    	}
    
    	$rates = array ();
    
    	$query = $this->db->query ( "SELECT hms_rate_id, dc_rate_id FROM dc_ozon_rates_link" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$rates [$row->dc_rate_id] = $row->hms_rate_id;
    		}
    	}
    
    	$rates_names = array ();
    
    	$query = $this->db->query ( "SELECT name, dc_rate_id FROM  dc_ozon_rates" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$rates_names [$row->dc_rate_id] ["dc_rate_name"] = $row->name;
    			$rates_names [$row->dc_rate_id] ["dc_rate_id"] = $row->dc_rate_id;
    		}
    	}
    
    	$hms_rate_id = 0;
    	$query = $this->db->query ( "SELECT hms_rate_id, dc_rate_id FROM  dc_ozon_rates_link" );
    
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    
    		$hms_rate_id = $row->hms_rate_id;
    	}
    
    	$categories = array ();
    
    	$query = $this->db->query ( "SELECT dc_room_id, category_id FROM dc_ozon_rooms_link" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$categories [$row->dc_room_id] = $row->category_id;
    		}
    	}
    
    	$categories_names = array ();
    
    	$query = $this->db->query ( "SELECT id, name FROM categories" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$categories_names [$row->id] = $row->name;
    		}
    	}
    
    	$query = $this->db->query ( "SELECT id FROM rate WHERE isdefault = 1" );
    
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$price_type = $row->id;
    	}
    
    	$rates_link = array ();
    
    	$query = $this->db->query ( "SELECT dc_category_id, hms_rate_id FROM dc_ozon_rate2category_link" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$rates_link [$row->dc_category_id] = $row->hms_rate_id;
    		}
    	}
    
    	$query = $this->db->query ( "SELECT int_value FROM dc_ozon_xml_cfg WHERE name LIKE 'dealer_id'" );
    
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$dealer = $row->int_value;
    	}
    
    	$query = $this->db->query ( "SELECT int_value FROM dc_ozon_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
    
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$overbooking_category_id = $row->int_value;
    	}
    
    	$result_array = array ();
    	if ($data ["code"] == 200) {
    		$i = 0;
    		foreach ( $data ["data"]["bookings"] as $key => $reservations ) {
    			// echo $key."<pre>++<br><br><br><br><br>";
    			// print_r($reservations);
    			$res_data = array ();
    			$res_i = 1;
    			$count = count ( $reservations );
    			$qty = count($reservations["rooms"]);
    			foreach ( $reservations["rooms"] as $reservation_data ) {
    				if ($dc_hotel_id != $reservations ["hotel_id"]) {
    					echo "dc_hotel_id missmatch";
    					continue;
    				}
    				$dc_reservationid_str = $reservations ["booking_id"];
    				$dc_uuid = $reservations ["booking_id"]."_".$res_i;
    				//$result_array ["reservations"] [$i] ["reservation"] ["bronevik_original_id"] = $reservation_data ["@attributes"] ["Id"];
    				$otelms_rooms = array ();
    				$sql = "SELECT id, dc_uuid FROM deskofreservation WHERE deleted = 0 AND cancel = 0 AND dc_id = 15 AND dc_uuid LIKE '" . $dc_uuid."'";
    				//echo $sql;
    				$query = $this->db->query ( $sql );
    					
    				if ($query->num_rows () > 0) {
    					foreach ( $query->result () as $row ) {
    						$otelms_rooms [$row->dc_uuid] ["otelms_reservation_id"] = $row->id;
    						$otelms_rooms [$row->dc_uuid] ["dc_uuid"] = $row->dc_uuid;
    						$otelms_rooms [$row->dc_uuid] ["status"] = 0;
    					}
    				}
    					
    				// print_r ( $otelms_rooms );
    					
    				$result_array ["reservations"] [$i] ["dc_rate_id"] = 1;
    				$result_array ["reservations"] [$i] ["currencycode"] = $reservations ["currency"];
    					
    				$result_array ["reservations"] [$i] ["card"] ["cc_cvc"] = "";
    					
    				$result_array ["reservations"] [$i] ["card"] ["ExpMonth"] = "";
    				$result_array ["reservations"] [$i] ["card"] ["ExpYear"] = "";
    				$result_array ["reservations"] [$i] ["card"] ["CardHolder"] = "";
    				$result_array ["reservations"] [$i] ["card"] ["CardNumber"] = "";
    				$result_array ["reservations"] [$i] ["card"] ["cc_type"] = "";
    					
    				$result_array ["reservations"] [$i] ["guest"] ["address"] = "";
    				$result_array ["reservations"] [$i] ["guest"] ["city"] = "";
    				$result_array ["reservations"] [$i] ["guest"] ["country"] = "";
    				$result_array ["reservations"] [$i] ["guest"] ["email"] = "";
    					
    				$guest_arr_name = explode(" ", $reservation_data["guests"][0]);
    				
    				if(isset($guest_arr_name[0]) && isset($guest_arr_name[1])){
    					$result_array ["reservations"] [$i] ["guest"] ["firstname"] = $guest_arr_name[0];
    					$result_array ["reservations"] [$i] ["guest"] ["lastname"] = $guest_arr_name[1];
    				}else{
    					$result_array ["reservations"] [$i] ["guest"] ["firstname"] = $reservation_data["guests"][0];
    				}
    				
    				//$result_array ["reservations"] [$i] ["guest"] ["firstname"] = $reservation_data["guests"][0];
    				$result_array ["reservations"] [$i] ["guest"] ["lastname"] = "";
    				$result_array ["reservations"] [$i] ["guest"] ["phone"] = "";
    				$result_array ["reservations"] [$i] ["guest"] ["passportid"] = "";
    					
    				$result_array ["reservations"] [$i] ["status"] = $reservations ["status"];
    				$result_array ["reservations"] [$i] ["dc_reservationid"] = eregi_replace("([^0-9])", "", $dc_reservationid_str);
    					
    				$created_at_arr = explode ( " ", $reservations ["created"] );
    				$created_at = $created_at_arr [0];
    				$created_at_time = $created_at_arr [1];
    					
    				$result_array ["reservations"] [$i] ["reservation"] ["dc_id"] = 15;
    					
    				$result_array ["reservations"] [$i] ["reservation"] ["commissionamount"] = 0;
    				$result_array ["reservations"] [$i] ["reservation"] ["date"] = $created_at;
    				$result_array ["reservations"] [$i] ["reservation"] ["dc_reservationid"] = eregi_replace("([^0-9])", "", $dc_reservationid_str);
    				$result_array ["reservations"] [$i] ["reservation"] ["time"] = $created_at_time;
    				$result_array ["reservations"] [$i] ["reservation"] ["isNew"] = 1;
    				$datein = $reservations["arrival_date"];
    				$result_array ["reservations"] [$i] ["reservation"] ["datein"] = $datein;
    				$result_array ["reservations"] [$i] ["reservation"] ["checkintime"] = "";
    				$dateout = $reservations["departure_date"];
    				list ( $year, $month, $day ) = explode ( "-", $datein );
    				$intdate_in = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
    				list ( $year, $month, $day ) = explode ( "-", $dateout );
    				$intdate_out = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
    				if ($intdate_in == $intdate_out) {
    					$dateout = gmdate ( "Y-m-d", ($intdate_out + 1) * 86400 );
    				}
    					
    				$result_array ["reservations"] [$i] ["reservation"] ["dateout"] = $dateout;
    				$result_array ["reservations"] [$i] ["reservation"] ["checkouttime"] = "";
    					
    				$result_array ["reservations"] [$i] ["reservation"] ["dc_roomreservation_id"] = "";
    				$result_array ["reservations"] [$i] ["reservation"] ["dc_uuid"] = $dc_uuid;
    					
    				$result_array ["reservations"] [$i] ["reservation"] ["add_places"] = 0;
    				$result_array ["reservations"] [$i] ["reservation"] ["baby_places"] = 0;
    				$result_array ["reservations"] [$i] ["reservation"] ["amount"] = 0;
    					
    				$result_array ["reservations"] [$i] ["reservation"] ["description"] = "";
    					
    				$RoomId = $reservation_data["room_id"];
    				$RoomTypeId = $reservation_data["adults_number"];
    				$dc_rate_id = 0;
    				if(isset($reservation_data["daily_prices"]["yyyy-MM-dd"]["rate_id"])){
    					$dc_rate_id = $reservation_data["daily_prices"]["yyyy-MM-dd"]["rate_id"];
    				}
    					
    				if (isset ( $occupancy_rate [$dc_rate_id][$RoomId] [$RoomTypeId] )) {
    					$result_array ["reservations"] [$i] ["reservation"] ["price_type"] = $occupancy_rate [$dc_rate_id][$RoomId] [$RoomTypeId];
    				} else {
    					$result_array ["reservations"] [$i] ["reservation"] ["price_type"] = $price_type;
    				}
    					
    				$result_array ["reservations"] [$i] ["reservation"] ["user"] = - 1;
    					
    				$result_array ["reservations"] [$i] ["reservation"] ["category_id"] = $RoomId;
    					
    				if (isset ( $categories [$RoomId] )) {
    
    					$room_id = $categories [$RoomId];
    					$result_array ["reservations"] [$i] ["reservation"] ["type_id"] = $room_id;
    					$result_array ["reservations"] [$i] ["reservation"] ["reservation_type_name"] = $categories_names [$room_id];
    				} else {
    					$result_array ["reservations"] [$i] ["reservation"] ["type_id"] = 0;
    					$result_array ["reservations"] [$i] ["reservation"] ["reservation_type_name"] = "";
    				}
    					
    				$result_array ["reservations"] [$i] ["reservation"] ["dealer"] = $dealer;
    				$result_array ["reservations"] [$i] ["reservation"] ["dc_guestname"] = $reservation_data["guests"][0];
    				$result_array ["reservations"] [$i] ["reservation"] ["dc_numberofguest"] = 1;
    				$result_array ["reservations"] [$i] ["reservation"] ["dc_countrycode"] = "";
    				$result_array ["reservations"] [$i] ["reservation"] ["dc_currencycode"] = $reservations ["currency"];
    				$result_array ["reservations"] [$i] ["reservation"] ["dc_city"] = "";
    				$result_array ["reservations"] [$i] ["reservation"] ["dc_customerremarks"] = "";
    				$result_array ["reservations"] [$i] ["reservation"] ["dc_roomremarks"] = "";
    					
    				$result_array ["reservations"] [$i] ["reservation"] ["dc_totalprice"] = 0;
    					
    				$result_array ["reservations"] [$i] ["reservation"] ["smoking"] = "";
    				$result_array ["reservations"] [$i] ["roomreservation_id"] = "";
    					
    				$p = 1;
    				$duration = $intdate_out - $intdate_in;
    				$result_array ["reservations"] [$i] ["reservation"] ["dc_totalprice"] = $duration * $reservation_data["daily_prices"]["yyyy-MM-dd"]["price"];
    				echo $intdate_in." ".$intdate_out;
    				for($k = $intdate_in; $k < $intdate_out; $k ++) {
    					$result_array ["reservations"] [$i] ["per_day"] [$p] ["dc_reservation_id"] = $dc_uuid;
    					$result_array ["reservations"] [$i] ["per_day"] [$p] ["price"] = $reservation_data["daily_prices"]["yyyy-MM-dd"]["price"];
    					$result_array ["reservations"] [$i] ["per_day"] [$p] ["dc_rate_id"] = $reservation_data["daily_prices"]["yyyy-MM-dd"]["rate_id"];
    					$result_array ["reservations"] [$i] ["per_day"] [$p] ["dc_rate_name"] = $rates_names [$reservation_data["daily_prices"]["yyyy-MM-dd"]["rate_id"]]["dc_rate_name"];
    					$result_array ["reservations"] [$i] ["per_day"] [$p] ["dc_currencycode"] = $reservations ["currency"];
    					$result_array ["reservations"] [$i] ["per_day"] [$p] ["intdate"] = $k;
    					$result_array ["reservations"] [$i] ["per_day"] [$p] ["date_rate"] = gmdate ( "Y-m-d", $k * 86400 );
    					$p ++;
    				}
    					
    				for($gst = 1; $gst < count($reservation_data["guests"]); $gst++){
    					$result_array ["reservations"] [$i] ["guest_add"][$gst]["name"] = $reservation_data["guests"][$gst];
    				}
    					
    				if($qty > 1){
    					$result_array ["reservations"] [$i] ["reservation"] ["groupid"] = eregi_replace("([^0-9])", "", $dc_reservationid_str);
    				}
    					
    					
    				$i ++;
    				$res_i ++;
    			}
    		}
    	}
    
    	echo "<pre>";
    	print_r ( $result_array );
    	// die ();
    
    	$host = "";
    	if ($_SERVER ["HTTP_HOST"]) {
    		$host = $_SERVER ["HTTP_HOST"];
    	}
    
    
    	$reservationpush = array ();
    	$log_data = array();
    	$log_data = "empty";
    
    	if (isset ( $result_array ["reservations"] )) {
    		$k = 0;
    		$bool_guest = 0;
    		$bool_cancel = 0;
    		$guest_array = array ();
    		$guest_counter = 1;
    		$r_i = 0;
    		foreach ( $result_array ["reservations"] as $reservations ) {
    			$amount = 0;
    			foreach ( $reservations ["per_day"] as $per_day ) {
    				$amount += $per_day["price"];
    			}
    			$reservations["reservation"] ["amount"] = $amount;
    
    			$calculate_data = array ();
    			$calculate_data ["type_id"] = $reservations["reservation"] ["type_id"];
    			$calculate_data ["datein"] = $reservations["reservation"] ["datein"];
    			$calculate_data ["dateout"] = $reservations["reservation"] ["dateout"];
    			$calculate_data ["add_places"] = $reservations["reservation"] ["add_places"];
    			$calculate_data ["baby_places"] = $reservations["reservation"] ["baby_places"];
    			$calculate_data ["addbedplace"] = 0;
    			$calculate_data ["babyplace2"] = 0;
    			$calculate_data ["price_type"] = $reservations["reservation"] ["price_type"];
    
    			$temp_amount = $this->frontdesk->getpricecalculation ( $calculate_data );
    			$otelms_amount = 0;
    			for($p = 0; $p < count ( $temp_amount ); $p ++) {
    				$otelms_amount += $temp_amount [$p] ["amount"];
    			}
    			$booking_amount = $reservations["reservation"] ["amount"];
    			$reservations["reservation"] ["discount"] = 0;
    			if ($booking_amount != $otelms_amount) {
    				if ($otelms_amount != 0) {
    					$reservations["reservation"] ["discount"] = $otelms_amount - $booking_amount;
    				}
    			}
    
    			//=====================================================
    			//=====================================================
    			//=====================================================
    
    			$datein = $reservations["reservation"] ["datein"];
    			$dateout = $reservations["reservation"] ["dateout"];
    			$type_id = $reservations["reservation"] ["type_id"];
    			//$sql = "SELECT id, room_id FROM deskofreservation WHERE cancel = 0 AND deleted = 0 AND dc_uuid LIKE '" . $reservations["reservation"] ["dc_uuid"] . "' ORDER BY id DESC ";
    
    			$sql = "SELECT id, room_id FROM deskofreservation WHERE cancel = 0 AND deleted = 0 AND dc_uuid LIKE '" . $reservations ["reservation"] ["dc_uuid"] . "' ORDER BY id DESC ";
    			//echo $sql;
    			$query = $this->db->query ( $sql );
    			$hms_reservation_id = 0;
    			$otelms_room_id = 0;
    			if ($query->num_rows () > 0) {
    				$row = $query->row ();
    				$hms_reservation_id = $row->id;
    				$otelms_room_id = $row->room_id;
    			}
    			//echo $hms_reservation_id."+++++++++++++++";
    			$reservations["reservation"] ["dc_totalprice"] = 0;
    			foreach ( $reservations["per_day"] as $cell ) {
    				$reservations["reservation"] ["dc_totalprice"] += $cell ["price"];
    				$reservations["reservation"] ["amount"] += $cell ["price"];
    			}
    			if (isset ( $reservations["per_day"] )) {
    					
    				$this->dc_rate_intdate_insert ( $reservations["per_day"] );
    			}
    
    			if ($reservations ["status"] == "Correction") {
    				$reservations["reservation"] ["specialstatus"] = "Correction";
    			}
    
    			if ($reservations["status"] == "Cancellation") {
    					
    				$query2 = $this->db->query ( "SELECT deskofreservation.datein, deskofreservation.dateout, rooms.category_id FROM deskofreservation INNER JOIN rooms ON rooms.id = deskofreservation.room_id WHERE deskofreservation.id = $hms_reservation_id" );
    					
    				if ($query2->num_rows () > 0) {
    					$row2 = $query2->row ();
    					$datein = $row2->datein;
    					$dateout = $row2->dateout;
    					$type_id = $row2->category_id;
    				}
    					
    				$time2 = date ( "Y-m-d H:i:s" );
    				$status = 5;
    				$query2 = $this->db->query ( "SELECT id FROM  services_main WHERE reservation_id = " . $hms_reservation_id . " AND type = 2" );
    					
    				if ($query2->num_rows () > 0) {
    					$reservationpush [$k] ["response"] = "failed";
    					$reservationpush [$k] ["text"] = "{caption_already_canceled}";
    					$reservationpush [$k] ["status"] = "cancel";
    					//$reservationpush [$k] ["bronevik_status"] = $reservations ["status"];
    
    					$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    					$reservationpush [$k] ["dc_reservationid"] = $reservations ["reservation"] ["dc_reservationid"];
    					//$reservationpush [$k] ["bronevik_original_id"] = $reservations ["reservation"] ["bronevik_original_id"];
    					$k ++;
    
    					$dc_log_data = array ();
    					$dc_log_data ["datein"] = $datein;
    					$dc_log_data ["dateout"] = $dateout;
    					$dc_log_data ["category_id"] = $type_id;
    					$this->frontdesk->dc_log_update ( $dc_log_data );
    				} else {
    					$query2 = $this->db->query ( "SELECT id FROM deskofreservation WHERE id = " . $hms_reservation_id );
    
    					if ($query2->num_rows () > 0) {
    						$data_cancel = array ();
    							
    						$data_cancel ["res_id"] = $hms_reservation_id;
    						$data_cancel ["charge"] = 0;
    						$data_cancel ["status"] = 5;
    						;
    						$data_cancel ["description"] = "cancel from 101otel";
    						$data_cancel ["guestbe_request"] = 0;
    						$data_cancel ["user"] = - 1;
    						// ====================
    						$this->Cancel->Insert ( $data_cancel );
    						// ====================
    						$reservationpush [$k] ["response"] = "ok";
    						$reservationpush [$k] ["text"] = "";
    						$reservationpush [$k] ["status"] = "cancel";
    						//$reservationpush [$k] ["bronevik_status"] = $reservations ["status"];
    						$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    						$reservationpush [$k] ["dc_reservationid"] = $reservations["reservation"]["dc_reservationid"];
    						//$reservationpush [$k] ["bronevik_original_id"] = $reservations ["reservation"] ["bronevik_original_id"];
    						$k ++;
    					} else {
    						$reservationpush [$k] ["response"] = "failed";
    						$reservationpush [$k] ["text"] = "{caption_nobooking_tocancel}";
    						$reservationpush [$k] ["status"] = "cancel";
    						//$reservationpush [$k] ["bronevik_status"] = $reservations ["status"];
    						$reservationpush [$k] ["hms_reservation_id"] = 0;
    						$reservationpush [$k] ["dc_reservationid"] = $reservations["reservation"]["dc_reservationid"];
    						//$reservationpush [$k] ["bronevik_original_id"] = $reservations ["reservation"] ["bronevik_original_id"];
    						$k ++;
    					}
    				}
    			} else {
    					
    				if($hms_reservation_id == 0){
    					/*
    					 * NEW RESERVATION BLOCK
    					*/
    
    					$room_id = 0;
    
    					if ($type_id == 0 or $type_id == "") {
    						$query2 = $this->db->query ( "SELECT int_value FROM dc_ozon_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
    						if ($query->num_rows () > 0) {
    							$row2 = $query2->row ();
    							$type_id = $row2->int_value;
    						}
    					}
    
    					if ($type_id == 0 or $type_id == "") {
    						if (isset ( $overbooking_category_id )) {
    							$reservations["reservation"] ["origin_categoryid"] = $type_id;
    							$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $overbooking_category_id );
    
    							$insert_over_room_bool = 0;
    							if ($room_id == 0) {
    								$room_id = $this->dc_model->dc_make_overbooking_room ( $overbooking_category_id );
    								$insert_over_room_bool = 1;
    							}
    						} else {
    							$reservationpush [$k] ["response"] = "failed";
    							$reservationpush [$k] ["text"] = "no overbooking_category_id";
    							$reservationpush [$k] ["status"] = "new";
    							//$reservationpush [$k] ["bronevik_status"] = $reservations ["status"];
    							$reservationpush [$k] ["hms_reservation_id"] = 0;
    							$reservationpush [$k] ["dc_reservationid"] = $reservations["reservation"]["dc_reservationid"];
    							//$reservationpush [$k] ["bronevik_original_id"] = $reservations ["reservation"] ["bronevik_original_id"];
    							$reservationpush [$k] ["dc_room_id"] = $reservations["reservation"] ["category_id"];
    							$result_array ["reservations"] [$r_i]["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    							$result_array ["reservations"] [$r_i]["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    							$result_array ["reservations"] [$r_i]["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    							$k ++;
    						}
    						/*$reservationpush [$k] ["response"] = "error";
    						 $reservationpush [$k] ["text"] = "UNKNOWN CATEGORY";
    						$reservationpush [$k] ["status"] = "update";
    						$reservationpush [$k] ["bronevik_status"] = $reservations ["status"];
    						$reservationpush [$k] ["hms_reservation_id"] = $row->id;
    						$reservationpush [$k] ["dc_reservationid"] = $reservations["reservation"]["dc_reservationid"];
    						$reservationpush [$k] ["bronevik_original_id"] = $reservations ["reservation"] ["bronevik_original_id"];
    						$result_array ["reservations"] [$r_i]["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    						$result_array ["reservations"] [$r_i]["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    						$result_array ["reservations"] [$r_i]["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    						$k ++;
    						*/
    					}else{
    						$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $type_id );
    					}
    					if ($room_id == 0) {
    							
    						if (isset ( $overbooking_category_id )) {
    							$reservations ["reservation"] ["origin_categoryid"] = $type_id;
    							$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $overbooking_category_id );
    
    							$insert_over_room_bool = 0;
    							if ($room_id == 0) {
    								$room_id = $this->dc_model->dc_make_overbooking_room ( $overbooking_category_id );
    								$insert_over_room_bool = 1;
    							}
    						} else {
    							$reservationpush [$k] ["response"] = "failed";
    							$reservationpush [$k] ["text"] = "no overbooking_category_id";
    							$reservationpush [$k] ["status"] = "new";
    							//$reservationpush [$k] ["bronevik_status"] = $reservations ["status"];
    							$reservationpush [$k] ["hms_reservation_id"] = 0;
    							$reservationpush [$k] ["dc_reservationid"] = $reservations ["reservation"] ["dc_reservationid"];
    							//$reservationpush [$k] ["bronevik_original_id"] = $reservations ["reservation"] ["bronevik_original_id"];
    							$reservationpush [$k] ["dc_room_id"] = $reservations ["reservation"] ["category_id"];
    							$result_array ["reservations"] [$r_i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    							$result_array ["reservations"] [$r_i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    							$result_array ["reservations"] [$r_i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    						}
    					}
    					$reservations ["reservation"] ["room_id"] = $room_id;
    
    					if ($bool_guest == 0) {
    						if ($reservations ["status"] == "Correction") {
    							if (isset ( $guest_array [$i] )) {
    								$guest_id = $guest_array [$i];
    							} else {
    								$guest_id = $this->frontdesk->Guest_insert ( $reservations ["guest"] );
    							}
    						} else {
    							$guest_id = $this->frontdesk->Guest_insert ( $reservations ["guest"] );
    							// $bool_guest = 1;
    						}
    					}
    
    					// echo "<pre>";
    					// print_r ( $reservations["reservation"] );
    					// die ();
    					$reservation_id = $this->frontdesk->Reservation_insert ( $reservations ["reservation"], $guest_id, 0, 1 );
    
    					if (isset ( $otelms_rooms [$reservations ["reservation"] ["dc_uuid"]] )) {
    						$otelms_rooms [$reservations ["reservation"] ["dc_uuid"]] ["status"] = 1;
    					}
    
    					if (isset ( $reservations ["card"] )) {
    						$this->frontdesk->insert_tbl_CreditCards ( $reservations ["card"], $guest_id, $reservation_id );
    					}
    
    					if (isset ( $reservations ["guest_add"] )) {
    						for($gst = 1; $gst <= count ( $reservations ["guest_add"] ); $gst ++) {
    							$add_guest_data = array ();
    							$add_guest_data ['firstname_' . $gst] = $reservations ["guest_add"] [$gst] ["name"];
    							$add_guest_data ["reservation_id"] = $reservation_id;
    							$guest_id_add = $this->frontdesk->Guest_add_baby_insert ( $add_guest_data, $gst );
    							$this->frontdesk->guests_reservation_insert ( $guest_id_add, $reservation_id );
    						}
    					}
    
    					if ($reservation_id > 0) {
    						$reservationpush [$k] ["response"] = "ok";
    						$reservationpush [$k] ["text"] = "";
    						$reservationpush [$k] ["status"] = "new";
    						//$reservationpush [$k] ["bronevik_status"] = $reservations ["status"];
    						$reservationpush [$k] ["hms_reservation_id"] = $reservation_id;
    						$reservationpush [$k] ["dc_reservationid"] = $reservations ["reservation"] ["dc_reservationid"];
    						//$reservationpush [$k] ["bronevik_original_id"] = $reservations ["reservation"] ["bronevik_original_id"];
    						$reservationpush [$k] ["dc_room_id"] = $reservations ["reservation"] ["category_id"];
    						$result_array ["reservations"] [$r_i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    						$result_array ["reservations"] [$r_i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    						$result_array ["reservations"] [$r_i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    						$k ++;
    					} else {
    						$reservationpush [$k] ["response"] = "failed";
    						$reservationpush [$k] ["text"] = "undferror";
    						$reservationpush [$k] ["status"] = "new";
    						//$reservationpush [$k] ["bronevik_status"] = $reservations ["status"];
    						$reservationpush [$k] ["hms_reservation_id"] = 0;
    						$reservationpush [$k] ["dc_reservationid"] = $reservations ["reservation"] ["dc_reservationid"];
    						//$reservationpush [$k] ["bronevik_original_id"] = $reservations ["reservation"] ["bronevik_original_id"];
    						$reservationpush [$k] ["dc_room_id"] = $reservations ["reservation"] ["category_id"];
    						$result_array ["reservations"] [$r_i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    						$result_array ["reservations"] [$r_i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    						$result_array ["reservations"] [$r_i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    						$k ++;
    					}
    				} else {
    					/*
    					 * UPDATE RESERVATION BLOCK
    					*
    					*/
    					if($reservations ["status"] == "new"){
    						$reservationpush [$k] ["response"] = "okskip";
    						$reservationpush [$k] ["text"] = "{caption_already_exist_insystem}";
    						$reservationpush [$k] ["status"] = "new";
    						//$reservationpush [$k] ["bronevik_status"] = $reservations ["status"];
    						$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    						$reservationpush [$k] ["dc_reservationid"] = $reservations["reservation"]["dc_reservationid"];
    						//$reservationpush [$k] ["bronevik_original_id"] = $reservations ["reservation"] ["bronevik_original_id"];
    						$result_array ["reservations"] [$r_i]["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    						$result_array ["reservations"] [$r_i]["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    						$result_array ["reservations"] [$r_i]["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    						$k++;
    						continue;
    					}
    
    					$reservation_data = $this->frontdesk->GetReservation ( $hms_reservation_id );
    
    					//$reservation_data ["user"] = $xml_array ["reservations"] [$dc_reservationid] ["room"] [$cell ["dc_roomreservation_id"]] ["reservation"] ["user"];
    
    					$reservation_data ["firstname"] = $reservations["guest"] ["firstname"];
    					$reservation_data ["lastname"] = $reservations["guest"] ["lastname"];
    					$reservation_data ["phone"] = $reservations["guest"] ["phone"];
    					$reservation_data ["email"] = $reservations["guest"] ["email"];
    
    					$reservation_data ["amount"] = $reservations["reservation"] ["amount"];
    					$reservation_data ["discount"] = $reservations["reservation"] ["discount"];
    					$reservation_data ["date"] = $reservations["reservation"] ["date"];
    					$reservation_data ["add_places"] = $reservations["reservation"] ["add_places"];
    					$reservation_data ["baby_places"] = $reservations["reservation"] ["baby_places"];
    					$reservation_data ["datein"] = $reservations["reservation"] ["datein"];
    					$reservation_data ["dateout"] = $reservations["reservation"] ["dateout"];
    
    					$reservation_data ["checkintime"] = $reservations["reservation"] ["checkintime"];
    					$reservation_data ["checkouttime"] = $reservations["reservation"] ["checkouttime"];
    
    
    					//$reservation_data ["type_id"] = $reservations["reservation"] ["type_id"];
    					$reservation_data ["price_type"] = $reservations["reservation"] ["price_type"];
    					$reservation_data ["guest_id_new"] = 0;
    					$reservation_data ["free_places"] = 0;
    					$reservation_data ["maid_description"] = "";
    					$reservation_data ["isread"] = 0;
    					$reservation_data ["dc_guestname"] = $reservations["reservation"] ["dc_guestname"];
    					$reservation_data ["dc_currencycode"] = $reservations["reservation"] ["dc_currencycode"];
    					$reservation_data ["dc_countrycode"] = $reservations["reservation"] ["dc_countrycode"];
    					$reservation_data ["dc_city"] = $reservations["reservation"] ["dc_city"];
    					$reservation_data ["dc_customerremarks"] = $reservations["reservation"] ["dc_customerremarks"];
    					$reservation_data ["dc_roomremarks"] = $reservations["reservation"] ["dc_roomremarks"];
    					$reservation_data ["dc_numberofguest"] = $reservations["reservation"] ["dc_numberofguest"];
    					$reservation_data ["dc_totalprice"] = $reservations["reservation"] ["dc_totalprice"];
    					$reservation_data ["smoking"] = $reservations["reservation"] ["smoking"];
    
    					//$origin_categoryid = $reservation_data["origin_categoryid"];
    
    					//print_r($reservation_data);
    
    					if ($reservation_data ["type_id"] == $type_id) {
    						$can_resize = $this->frontdesk->qd_canresize($hms_reservation_id, $datein, $dateout );
    					} else {
    						$can_resize = 0;
    						$reservation_data ["type_id"] = $type_id;
    					}
    
    					//$can_resize = $this->frontdesk->qd_canresize($hms_reservation_id, $datein, $dateout );
    
    					if($can_resize == 1){
    						if ($reservation_data["origin_categoryid"] <> ""){
    							$reservation_data["origin_categoryid"] = "";
    						}
    						$update_res = $this->frontdesk->UpdateReservation ( $reservation_data, 0, 1 );
    							
    						if(isset($otelms_rooms[$reservations ["reservation"] ["dc_uuid"]])){
    							$otelms_rooms[$reservations ["reservation"] ["dc_uuid"]]["status"] = 1;
    						}
    						if ($update_res == "FreeError") {
    							$reservationpush [$k] ["response"] = "error";
    							$reservationpush [$k] ["text"] = "";
    							$reservationpush [$k] ["status"] = "modified";
    							//$reservationpush [$k] ["bronevik_status"] = $reservations ["status"];
    							$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    							$result_array ["reservations"] [$r_i]["reservation"] ["reservation_alert"] = "";
    							$result_array ["reservations"] [$r_i]["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    							$result_array ["reservations"] [$r_i]["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    							$reservationpush [$k] ["dc_reservationid"] = $reservations["reservation"]["dc_reservationid"];
    							//$reservationpush [$k] ["bronevik_original_id"] = $reservations ["reservation"] ["bronevik_original_id"];
    							$k ++;
    						}else{
    							$reservationpush [$k] ["response"] = "ok";
    							$reservationpush [$k] ["text"] = "";
    							$reservationpush [$k] ["alert"] = "";
    							$reservationpush [$k] ["status"] = "modified";
    							//$reservationpush [$k] ["bronevik_status"] = $reservations ["status"];
    							$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    							$result_array ["reservations"] [$r_i]["reservation"] ["reservation_alert"] = "";
    							$result_array ["reservations"] [$r_i]["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    							$result_array ["reservations"] [$r_i]["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    							$reservationpush [$k] ["dc_reservationid"] = $reservations["reservation"]["dc_reservationid"];
    							//$reservationpush [$k] ["bronevik_original_id"] = $reservations ["reservation"] ["bronevik_original_id"];
    							$k ++;
    						}
    					}else{
    						/*if ($type_id == 0 or $type_id == "") {
    						 $query2 = $this->db->query ( "SELECT int_value FROM dc_ozon_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
    						if ($query->num_rows () > 0) {
    						$row2 = $query2->row ();
    						$type_id = $row2->int_value;
    						}
    						}
    						*/
    						if ($type_id == 0 or $type_id == "") {
    							if (isset ( $overbooking_category_id )) {
    								$reservations["reservation"] ["origin_categoryid"] = $type_id;
    								$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $overbooking_category_id );
    									
    								$insert_over_room_bool = 0;
    								if ($room_id == 0) {
    									$room_id = $this->dc_model->dc_make_overbooking_room ( $overbooking_category_id );
    									$insert_over_room_bool = 1;
    								}
    							} else {
    								$reservationpush [$k] ["response"] = "failed";
    								$reservationpush [$k] ["text"] = "no overbooking_category_id";
    								$reservationpush [$k] ["status"] = "new";
    								//$reservationpush [$k] ["bronevik_status"] = $reservations ["status"];
    								$reservationpush [$k] ["hms_reservation_id"] = 0;
    								$reservationpush [$k] ["dc_reservationid"] = $reservations["reservation"]["dc_reservationid"];
    								//$reservationpush [$k] ["bronevik_original_id"] = $reservations ["reservation"] ["bronevik_original_id"];
    								$reservationpush [$k] ["dc_room_id"] = $reservations["reservation"] ["category_id"];
    								$result_array ["reservations"] [$r_i]["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    								$result_array ["reservations"] [$r_i]["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    								$result_array ["reservations"] [$r_i]["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    								$k ++;
    							}
    							$reservationpush [$k] ["response"] = "error";
    							$reservationpush [$k] ["text"] = "UNKNOWN CATEGORY";
    							$reservationpush [$k] ["status"] = "update";
    							//$reservationpush [$k] ["bronevik_status"] = $reservations ["status"];
    							$reservationpush [$k] ["hms_reservation_id"] = $row->id;
    							$reservationpush [$k] ["dc_reservationid"] = $reservations["reservation"]["dc_reservationid"];
    							//$reservationpush [$k] ["bronevik_original_id"] = $reservations ["reservation"] ["bronevik_original_id"];
    							$result_array ["reservations"] [$r_i]["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    							$result_array ["reservations"] [$r_i]["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    							$result_array ["reservations"] [$r_i]["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    							$k ++;
    						} else {
    							$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $type_id );
    						}
    						//if ($reservation_data["origin_categoryid"] <> ""){
    						//	$reservation_data["origin_categoryid"] = "";
    						//}
    							
    						if ($room_id == 0) {
    
    							if (isset ( $overbooking_category_id )) {
    								$reservation_data ["origin_categoryid"] = $type_id;
    								$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $overbooking_category_id );
    									
    								$insert_over_room_bool = 0;
    								if ($room_id == 0) {
    									$room_id = $this->dc_model->dc_make_overbooking_room ( $overbooking_category_id );
    									$insert_over_room_bool = 1;
    								}
    							} else {
    								$reservationpush [$k] ["response"] = "failed";
    								$reservationpush [$k] ["text"] = "no overbooking_category_id";
    								$reservationpush [$k] ["status"] = "new";
    								//$reservationpush [$k] ["bronevik_status"] = $reservations ["status"];
    								$reservationpush [$k] ["hms_reservation_id"] = 0;
    								$reservationpush [$k] ["dc_reservationid"] = $reservations["reservation"]["dc_reservationid"];
    								//$reservationpush [$k] ["bronevik_original_id"] = $reservations ["reservation"] ["bronevik_original_id"];
    								$reservationpush [$k] ["dc_room_id"] = $reservations["reservation"] ["category_id"];
    								$result_array ["reservations"] [$r_i]["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    								$result_array ["reservations"] [$r_i]["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    								$result_array ["reservations"] [$r_i]["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    							}
    						}
    						$reservation_data ["room_id"] = $room_id;
    							
    						$update_res = $this->frontdesk->UpdateReservation ( $reservation_data, 0, 1 );
    							
    						if(isset($otelms_rooms[$reservations["reservation"] ["dc_uuid"]])){
    							$otelms_rooms[$reservations["reservation"] ["dc_uuid"]]["status"] = 1;
    						}
    							
    						if ($update_res == "FreeError") {
    							$reservationpush [$k] ["response"] = "error";
    							$reservationpush [$k] ["text"] = "";
    							$reservationpush [$k] ["status"] = "modified";
    							//$reservationpush [$k] ["bronevik_status"] = $reservations ["status"];
    							$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    							$result_array ["reservations"] [$r_i]["reservation"] ["reservation_alert"] = "";
    							$result_array ["reservations"] [$r_i]["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    							$result_array ["reservations"] [$r_i]["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    							$reservationpush [$k] ["dc_reservationid"] = $reservations["reservation"]["dc_reservationid"];
    							//$reservationpush [$k] ["bronevik_original_id"] = $reservations ["reservation"] ["bronevik_original_id"];
    							$k ++;
    						}else{
    							$reservationpush [$k] ["response"] = "ok";
    							$reservationpush [$k] ["text"] = "";
    							$reservationpush [$k] ["alert"] = "";
    							$reservationpush [$k] ["status"] = "modified";
    							//$reservationpush [$k] ["bronevik_status"] = $reservations ["status"];
    							$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    							$result_array ["reservations"] [$r_i]["reservation"] ["reservation_alert"] = "";
    							$result_array ["reservations"] [$r_i]["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    							$result_array ["reservations"] [$r_i]["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    							$reservationpush [$k] ["dc_reservationid"] = $reservations["reservation"]["bronevik_original_id"];
    							//$reservationpush [$k] ["bronevik_original_id"] = $reservations ["reservation"] ["bronevik_original_id"];
    							$k ++;
    						}
    
    					}
    				}
    			}
    			$r_i ++;
    		}
    		 
    		//print_r ( $reservationpush );
    		//print_r ( $otelms_rooms );
    		//die();
    		foreach($otelms_rooms as $cell){
    			if($cell["status"] == 0){
    				//$this->frontdesk->DeleteReservation($cell["otelms_reservation_id"]);
    				$status = 5;
    				$data_cancel = array ();
    				$data_cancel ["res_id"] = $cell["otelms_reservation_id"];
    				$data_cancel ["charge"] = 0;
    				$data_cancel ["status"] = $status;
    				$data_cancel ["description"] = "cancel from Agoda";
    				$data_cancel ["guestbe_request"] = 0;
    				$data_cancel ["user"] = - 1;
    				// ====================
    				$this->Cancel->Insert ( $data_cancel );
    			}
    		}
    		 
    
    		 
    		$counter_r = 0;
    		$new_mass = array ();
    		foreach ( $result_array ["reservations"] as $cell ) {
    
    			if ($cell["status"] == "new" or $cell["status"] == "Correction") {
    				$new_mass ['dcname'] = "Ozon";
    				$new_mass ['status'] = $cell["status"];
    				$new_mass ['dc_reservationid'] = $cell["reservation"]["dc_reservationid"];
    				$new_mass ['dc_channel_name'] = "Ozon";
    				$new_mass ['hotel_name'] = "hotel_name";
    				$new_mass ['guest_firstname'] = $cell["guest"]  ["firstname"];
    				$new_mass ['guest_lastname'] = $cell["guest"]  ["lastname"];
    				$new_mass ['guest_phone'] = $cell["guest"] ["phone"];
    				$new_mass ['guest_email'] = $cell["guest"] ["email"];
    				//$new_mass ['hms_reservation_id'] = $cell["reservation"] ["hms_reservation_id"];
    					
    				$new_mass ["room"] [$counter_r]["reservation_current"] = $i;
    				$new_mass ["room"] [$counter_r]["reservation_alert"] = $cell["reservation"] ["reservation_alert"];
    				$new_mass ["room"] [$counter_r]["hms_reservation_id"] = $cell["reservation"] ["hms_reservation_id"];
    				$new_mass ["room"] [$counter_r]["url"] = $cell["reservation"] ["url"];
    				$new_mass ["room"] [$counter_r]["dc_channel_name"] = "Bronevik";
    					
    				$new_mass ["room"] [$counter_r]["reservation_dc_reservationid"] = $cell["reservation"] ["dc_reservationid"];
    				$new_mass ["room"] [$counter_r]["reservation_dc_roomreservation_id"] = $cell["reservation"] ["dc_roomreservation_id"];
    				$new_mass ["room"] [$counter_r]["hotel_name"] = "hotel_name";
    				$new_mass ["room"] [$counter_r]["reservation_date"] = $cell["reservation"]["date"];
    				$new_mass ["room"] [$counter_r]["status"] = $cell["status"];
    				$new_mass ["room"] [$counter_r]["reservation_datein"] = $cell["reservation"]["datein"];
    				$new_mass ["room"] [$counter_r]["reservation_dateout"] = $cell["reservation"]["dateout"];
    				$new_mass ["room"] [$counter_r]["reservation_type_name"] = $cell["reservation"]["reservation_type_name"];
    				$new_mass ["room"] [$counter_r]["reservation_category_id"] = $cell["reservation"]["type_id"];
    				$new_mass ["room"] [$counter_r]["reservation_dc_totalprice"] = $cell["reservation"]["dc_totalprice"];
    				$new_mass ["room"] [$counter_r]["reservation_dc_customerremarks"] = "";
    					
    				$new_mass ["room"] [$counter_r]["dc_rate_intdate_data"] = $cell["per_day"];
    					
    				$counter_r++;
    			}
    
    
    		}
    		if(count($new_mass) > 0){
    			//print_r($new_mass);
    			$this->dc_model->send_notifyarray_new ( $new_mass );
    		}
    		 
    	}
    
    	print_r ( $reservationpush );
    	//die();
    	foreach ( $reservationpush as $arg ) {
    		if ($arg ['status'] == "cancel") {
    			$data = array ();
    			$data ["hms_reservation_id"] = $arg ["hms_reservation_id"];
    			$data ['response'] = $arg ['response'];
    			$data ['resid'] = $arg ['dc_reservationid'];
    			$data ['dcname'] = "Ozon";
    			$data ['status'] = $arg ['status'];
    			$data ['text'] = $arg ['text'];
    			$this->dc_model->send_notifyarray ( $data );
    		}
    	}
    	return $log_data;
    }
    
    
    function bokking_xml_parse($data, $send_notification = 1) {
    	$hotel_name = "";
    	$query = $this->db->query ( "SELECT * FROM logo" );
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$hotel_name = stripslashes ( $row->logo_title );
    	}
   		$dc_hotel_id = "";
    	$query = $this->db->query ( "SELECT int_value FROM dc_ozon_xml_cfg WHERE name LIKE 'hotel_id'" );
    
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$dc_hotel_id = $row->int_value;
    	}
    
    	$occupancy_rate = array ();
    
    	$query = $this->db->query ( "SELECT dc_rate_id, dc_category_id, hms_occupancy_id, hms_rate_id FROM dc_ozon_rate2category_link" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$occupancy_rate [$row->dc_rate_id] [$row->dc_category_id] [$row->hms_occupancy_id] = $row->hms_rate_id;
    		}
    	}
    
    	$rates = array ();
    
    	$query = $this->db->query ( "SELECT hms_rate_id, dc_rate_id FROM dc_ozon_rates_link" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$rates [$row->dc_rate_id] = $row->hms_rate_id;
    		}
    	}
    
    	$rates_names = array ();
    
    	$query = $this->db->query ( "SELECT name, dc_rate_id FROM  dc_ozon_rates" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$rates_names [$row->dc_rate_id] ["dc_rate_name"] = $row->name;
    			$rates_names [$row->dc_rate_id] ["dc_rate_id"] = $row->dc_rate_id;
    		}
    	}
    
    	$hms_rate_id = 0;
    	$query = $this->db->query ( "SELECT hms_rate_id, dc_rate_id FROM  dc_ozon_rates_link" );
    
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    
    		$hms_rate_id = $row->hms_rate_id;
    	}
    
    	$categories = array ();
    
    	$query = $this->db->query ( "SELECT dc_room_id, category_id FROM dc_ozon_rooms_link" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$categories [$row->dc_room_id] = $row->category_id;
    		}
    	}
    
    	$categories_names = array ();
    
    	$query = $this->db->query ( "SELECT id, name FROM categories" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$categories_names [$row->id] = $row->name;
    		}
    	}
    
    	$query = $this->db->query ( "SELECT id FROM rate WHERE isdefault = 1" );
    
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$price_type = $row->id;
    	}
    
    	$rates_link = array ();
    
    	$query = $this->db->query ( "SELECT dc_category_id, hms_rate_id FROM dc_ozon_rate2category_link" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$rates_link [$row->dc_category_id] = $row->hms_rate_id;
    		}
    	}
    
    	$query = $this->db->query ( "SELECT int_value FROM dc_ozon_xml_cfg WHERE name LIKE 'dealer_id'" );
    
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$dealer = $row->int_value;
    	}
    
    	$query = $this->db->query ( "SELECT int_value FROM dc_ozon_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
    
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$overbooking_category_id = $row->int_value;
    	}
    
    
    
    	$result_array = array ();
    
    	if (isset ( $data ["data"] ) || isset ( $data ["Response"] )) {
    		if (isset ( $data ["data"] ["bookings"] ) || isset ( $data ["Response"] ["bookings"])){
    			
    
    			$reservations = array ();
    			if (isset ( $data ["code"] )) {
    				if( $data ["code"] == 200 ){
    					$reservations = $data ["data"] ["bookings"];
    				}
    			} else {
    				if(isset($data ["Response"])){
    					$reservations = $data ["Response"] ["bookings"];
    				}
    			}
    
    			$counter = 0;
    			echo "<pre>";
    			print_r($reservations);
    			foreach ( $reservations as $reservation ) {
    				if ($dc_hotel_id != $reservation ["hotel_id"]) {
    					echo "dc_hotel_id missmatch";
    					continue;
    				}
    				 
    				$dc_uuid = $reservation ["booking_id"];
    				
    				$otelms_rooms = array();
    				$query = $this->db->query ( "SELECT id, dc_uuid FROM deskofreservation WHERE deleted = 0 AND cancel = 0 AND dc_id = 15 AND dc_uuid LIKE '" . $dc_uuid."'");
    				
    				if ($query->num_rows () > 0) {
    					foreach ( $query->result () as $row ) {
    						$otelms_rooms [$row->dc_uuid]["otelms_reservation_id"] = $row->id;
    						$otelms_rooms [$row->dc_uuid]["dc_uuid"] = $row->dc_uuid;
    						$otelms_rooms [$row->dc_uuid]["status"] = 0;
    					}
    				}
    					
    				$qty = count($reservation["rooms"]);
    				$j = 0;
    				foreach ( $reservation["rooms"] as $rooms ) {
    				//for($j = 0; $j < $qty; $j ++) {    					
    					$RoomId = $rooms["room_id"];
    					$RoomTypeId = $rooms["adults_number"];
    					$dc_rate_id = 0;
    					if(isset($rooms["daily_prices"]["yyyy-MM-dd"]["rate_id"])){
    						$dc_rate_id = $rooms["daily_prices"]["yyyy-MM-dd"]["rate_id"];
    					}else{
    						if(isset($rooms["daily_prices"][$reservation["arrival_date"]]["rate_id"])){
    							$dc_rate_id = $rooms["daily_prices"][$reservation["arrival_date"]]["rate_id"];
    						}
    					}
    						
    					if (isset ( $occupancy_rate [$dc_rate_id][$RoomId] [$RoomTypeId] )) {
    						$result_array ["reservations"] [$counter] [$j] ["reservation"]["price_type"]  = $occupancy_rate [$dc_rate_id][$RoomId] [$RoomTypeId];
    					} else {
    						$result_array ["reservations"] [$counter] [$j] ["reservation"]["price_type"]  = $price_type;
    					}
    					
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_totalprice"] = 0;
    
    					list ($year, $month, $day) = explode("-", $reservation["arrival_date"]);
    					$int_datein = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
    					list ($year, $month, $day) = explode("-", $reservation["departure_date"]);
    					$int_dateout = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
    					$duration = $int_dateout - $int_datein;
    					if (isset ( $reservation ["daily_prices"] ["yyyy-MM-dd"] )) {
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_totalprice"] = $duration * $rooms ["daily_prices"] ["yyyy-MM-dd"] ["price"];
							for($k = $int_datein; $k < $int_dateout; $k ++) {
								$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["dc_currencycode"] = $reservation ["currency"];
								$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["dc_reservation_id"] = $reservation ["booking_id"] . "_" . $RoomId . "_" . $j;
								$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["price"] = $rooms ["daily_prices"] ["yyyy-MM-dd"];
								$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["dc_rate_id"] = $rooms["daily_prices"]["yyyy-MM-dd"]["rate_id"];
								$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["dc_rate_name"] = $rates_names [$rooms["daily_prices"]["yyyy-MM-dd"]["rate_id"]]["dc_rate_name"];
								
								$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["intdate"] = $k;
								$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["date_rate"] = gmdate ( "Y-m-d", $k * 86400 );
							}
						} else {
							for($k = $int_datein; $k < $int_dateout; $k ++) {
								$date = gmdate ( "Y-m-d", $k * 86400 );
								$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["dc_currencycode"] = $reservation ["currency"];
								$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["dc_reservation_id"] = $reservation ["booking_id"] . "_" . $RoomId . "_" . $j;
								$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["price"] = $rooms ["daily_prices"] [$date]["price"];
								$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["dc_rate_id"] = $rooms["daily_prices"][$date]["rate_id"];
								$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["dc_rate_name"] = $rates_names [$rooms["daily_prices"][$date]["rate_id"]]["dc_rate_name"];
								
								$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["intdate"] = $k;
								$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["date_rate"] = $date;
								
								$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_totalprice"] += $rooms ["daily_prices"] ["$date"]["price"];
							}
						}
    
    					$result_array ["reservations"] [$counter] [$j] ["dc_rate_id"] = $dc_rate_id;
    					$result_array ["reservations"] [$counter] [$j] ["currencycode"] = $reservation ["currency"];
    					$result_array ["reservations"] [$counter] [$j] ["card"] ["cc_cvc"] = "";
    
    					$result_array ["reservations"] [$counter] [$j] ["card"] ["ExpMonth"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["card"] ["ExpYear"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["card"] ["CardHolder"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["card"] ["CardNumber"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["card"] ["cc_type"] = "";
    
    					$result_array ["reservations"] [$counter] [$j] ["guest"] ["address"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["guest"] ["city"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["guest"] ["country"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["guest"] ["email"] = "";
    					
    					$guest_arr_name = explode(" ", $rooms["guests"][0]);
    					
    					if(isset($guest_arr_name[0]) && isset($guest_arr_name[1])){
    						$result_array ["reservations"] [$counter] [$j] ["guest"] ["firstname"] = $guest_arr_name[0];
    						$result_array ["reservations"] [$counter] [$j] ["guest"] ["lastname"] = $guest_arr_name[1];
    					}else{
    						$result_array ["reservations"] [$counter] [$j] ["guest"] ["firstname"] = $rooms["guests"][0];
    					}
    					
    					$result_array ["reservations"] [$counter] [$j] ["guest"] ["phone"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["guest"] ["passportid"] = "";
    
    					$result_array ["reservations"] [$counter] [$j] ["status"] = $reservation["status"];
    					// $result_array ["reservations"] [$i] ["status"] = "cancelled";
    					$result_array ["reservations"] [$counter] [$j] ["dc_reservationid"] = (int)preg_replace("([^0-9])", "", $dc_uuid);
    					
    
    					$created_at_arr = explode ( " ", $reservation ["created"] );
    					$created_at = $created_at_arr [0];
    					if (isset ( $created_at_arr [1] )) {
    						$created_at_time = $created_at_arr [0] . " " . $created_at_arr [1];
    					} else {
    						$created_at_time = $created_at_arr [0];
    					}
    
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_id"] = 15;
    
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["commissionamount"] = 0;
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["date"] = $created_at;
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_reservationid"] = (int)preg_replace("([^0-9])", "", $dc_uuid);
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["time"] = $created_at_time;
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_date"] = $created_at_arr[0];
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_time"] = $created_at_arr[1];
    					if(isset($reservation ["modified"])){
    						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_updatetime"] = $reservation ["modified"];
    					}else{
    						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_updatetime"] = "";
    					}
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["isNew"] = 1;
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["datein"] = $reservation ["arrival_date"];
    						
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dateout"] = $reservation ["departure_date"];
    
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["checkintime"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["checkouttime"] = "";
    
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_roomreservation_id"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_uuid"] = $dc_uuid . "_" . $RoomId . "_" . $j;
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["category_id"] = $RoomId;
    					if (isset ( $categories_names [$categories ["$RoomId"]] )) {
    						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["reservation_type_name"] = $categories_names [$categories [$RoomId]];
    					} else {
    						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["reservation_type_name"] = "";
    					}
    
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["placement_id"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["add_places"] = 0;
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["baby_places"] = 0;
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["amount"] = $result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_totalprice"];
    
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["description"] = "";
    					if(isset($_SESSION["user"]["id"])){
    						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["user"]  = $_SESSION["user"]["id"];
    					}else{
    						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["user"] = - 1;
    					}
    
    					if (isset ( $categories [$RoomId] )) {
    						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["type_id"] = $categories [$RoomId];
    						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_type_id"] = $RoomId;
    					} else {
    						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["type_id"] = 0;
    						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_type_id"] = 0;
    					}
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dealer"] = $dealer;
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_guestname"] = $rooms["guests"][0];
    					
    					if(isset($reservation ["guests"])){
    						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_numberofguest"] = count($reservation ["guests"]);
    					}else{
    						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_numberofguest"] = 0;
    					}
    					
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_countrycode"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_currencycode"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_city"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_customerremarks"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_roomremarks"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["description"] = "";
    
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["smoking"] = "";
    
    					$result_array ["reservations"] [$counter] [$j] ["roomreservation_id"] = "";
    
    					for($gst = 1; $gst < count($rooms["guests"]); $gst++){
    						$guest_arr_name = explode(" ", $rooms["guests"][$gst]);
    							
    						if(isset($guest_arr_name[0]) && isset($guest_arr_name[1])){
    							$result_array ["reservations"] [$counter] [$j] ["guest_add"][$gst] ["firstname"] = $guest_arr_name[0];
    							$result_array ["reservations"] [$counter] [$j] ["guest_add"][$gst] ["lastname"] = $guest_arr_name[1];
    						}else{
    							$result_array ["reservations"] [$counter] [$j] ["guest_add"][$gst] ["firstname"] = $rooms["guests"][$gst];
    						}
    						//$result_array ["reservations"] [$counter] [$j] ["guest_add"][$gst]["firstname"] = $rooms["guests"][$gst];
    					}
    					
    					if($qty > 1){
    						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["groupid"] = $dc_uuid;
    					}
    
    					$j++;
    				}
    				$counter++;
    			}
    		}
    	}
    	echo "<pre>";
    	print_r ( $result_array );
    	//die ();
    
    	$host = "";
    	if (isset($_SERVER ["HTTP_HOST"])) {
    		$host = $_SERVER ["HTTP_HOST"];
    	}
    
    	$reservationpush = array ();
    
    	if (isset ( $result_array ["reservations"] )) {
    		$k = 0;
    		$bool_guest = 0;
    		$bool_cancel = 0;
    		$guest_array = array ();
    		$guest_counter = 1;
    		foreach ( $result_array ["reservations"] as $key => $reservations ) {
    			$res_count = count ( $reservations );
    			//print_r ( $reservations );
    			// die();
    
    
    			//echo "++";
    			//print_r($guest_array);
    			for($i = 0; $i < $res_count; $i ++) {
    				/*
    				 *
    				* calculate discount
    				*/
    
    				//$amount = 0;
    					
    				//$reservations [$i] ["reservation"] ["amount"] = $amount;
    
    
    				$calculate_data = array ();
    				$calculate_data ["type_id"] = $reservations [$i] ["reservation"] ["type_id"];
    				$calculate_data ["datein"] = $reservations [$i] ["reservation"] ["datein"];
    				$calculate_data ["dateout"] = $reservations [$i] ["reservation"] ["dateout"];
    				$calculate_data ["add_places"] = $reservations [$i] ["reservation"] ["add_places"];
    				$calculate_data ["baby_places"] = $reservations [$i] ["reservation"] ["baby_places"];
    				$calculate_data ["addbedplace"] = 0;
    				$calculate_data ["babyplace2"] = 0;
    				$calculate_data ["price_type"] = $reservations [$i] ["reservation"] ["price_type"];
    
    				$temp_amount = $this->frontdesk->getpricecalculation ( $calculate_data );
    				$otelms_amount = 0;
    				for($p = 0; $p < count ( $temp_amount ); $p ++) {
    					$otelms_amount += $temp_amount [$p] ["amount"];
    				}
    				$booking_amount = $reservations [$i] ["reservation"] ["amount"];
    				$reservations [$i] ["reservation"] ["discount"] = 0;
    				if ($booking_amount != $otelms_amount) {
    					if ($otelms_amount != 0) {
    						$reservations [$i] ["reservation"] ["discount"] = $otelms_amount - $booking_amount;
    					}
    				}
    
    				//=====================================================
    				//=====================================================
    				//=====================================================
    
    				$datein = $reservations [$i] ["reservation"] ["datein"];
    				$dateout = $reservations [$i] ["reservation"] ["dateout"];
    				$type_id = $reservations [$i] ["reservation"] ["type_id"];
    				$sql = "SELECT id, room_id, dc_updatetime FROM deskofreservation WHERE cancel=0 AND deleted = 0 AND dc_uuid LIKE '" . $reservations [$i] ["reservation"] ["dc_uuid"] . "' AND dc_reservationid = ".$reservations [$i] ["reservation"] ["dc_reservationid"]." ORDER BY id DESC ";
    				//echo $sql;
    				$query = $this->db->query ( $sql );
    				$hms_reservation_id = 0;
    				$otelms_room_id = 0;
    				if ($query->num_rows () > 0) {
    					$row = $query->row ();
    					if($reservations [$i] ["reservation"] ["dc_updatetime"] == $row->dc_updatetime){
    						$result_array ["reservations"] [$key] [$i] ["status"] = "update";
    						$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = "SKIP";
    						$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $row->id;
    						$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $row->id;
    						continue;
    					}
    					$hms_reservation_id = $row->id;
    					$otelms_room_id = $row->room_id;
    					//$reservations [1] ["status"] = "modified";
    				}else{
    					if ($reservations [$i] ["status"] == "canceled") {
    						$reservationpush [$k] ["response"] = "failed";
    						$reservationpush [$k] ["text"] = "{caption_nobooking_tocancel}";
    						$reservationpush [$k] ["status"] = "cancel";
    							
    						$reservationpush [$k] ["hms_reservation_id"] = 0;
    						$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    						$k ++;
    						continue;
    					}
    				}
    				//echo $hms_reservation_id."+++++++++++++++";
    				$reservations [$i] ["reservation"] ["dc_totalprice"] = 0;
    				foreach ( $reservations [$i] ["per_day"] as $cell ) {
    					$reservations [$i] ["reservation"] ["dc_totalprice"] += $cell ["price"];
    					$reservations [$i] ["reservation"] ["amount"] += $cell ["price"];
    				}
    				if (isset ( $reservations [$i] ["per_day"] )) {
    
    					$this->dc_rate_intdate_insert ( $reservations [$i] ["per_day"] );
    				}
    
    
    				if ($reservations [$i] ["status"] == "canceled") {
    					$sql = "SELECT deskofreservation.dc_updatetime, deskofreservation.datein, deskofreservation.dateout, rooms.category_id FROM deskofreservation INNER JOIN rooms ON rooms.id = deskofreservation.room_id WHERE deskofreservation.id = $hms_reservation_id";
    					$query2 = $this->db->query ( $sql );
    						
    					if ($query2->num_rows () > 0) {
    						$row2 = $query2->row ();
    						if($reservations [$i] ["reservation"] ["dc_updatetime"] == $row2->dc_updatetime){
    							
    							continue;
    						}
    						$datein = $row2->datein;
    						$dateout = $row2->dateout;
    						$type_id = $row2->category_id;
    					} else {
							
							$reservationpush [$k] ["response"] = "failed";
							$reservationpush [$k] ["text"] = "{caption_nobooking_tocancel}";
							$reservationpush [$k] ["status"] = "cancel";
							
							$reservationpush [$k] ["hms_reservation_id"] = 0;
							$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
							$k ++;
							
							//continue;
						}
    
    					$time2 = date ( "Y-m-d H:i:s" );
    					$status = 5;
    					$query2 = $this->db->query ( "SELECT id FROM  services_main WHERE reservation_id = " . $hms_reservation_id . " AND type = 2" );
    
    					if ($query2->num_rows () > 0) {
    						$reservationpush [$k] ["response"] = "failed";
    						$reservationpush [$k] ["text"] = "{caption_already_canceled}";
    						$reservationpush [$k] ["status"] = "cancel";
    
    						$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    						$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    						$k ++;
    
    						$dc_log_data = array ();
    						$dc_log_data ["datein"] = $datein;
    						$dc_log_data ["dateout"] = $dateout;
    						$dc_log_data ["category_id"] = $type_id;
    						$this->frontdesk->dc_log_update ( $dc_log_data );
    					} else {
    						$query2 = $this->db->query ( "SELECT id FROM deskofreservation WHERE id = " . $hms_reservation_id );
    
    						if ($query2->num_rows () > 0) {
    							$data_cancel = array ();
    
    							$data_cancel ["res_id"] = $hms_reservation_id;
    							$data_cancel ["charge"] = 0;
    							$data_cancel ["status"] = 5;
    							;
    							$data_cancel ["description"] = "cancel from OZON";
    							$data_cancel ["guestbe_request"] = 0;
    							if(isset($_SESSION["user"]["id"])){
    								$data_cancel ["user"] = $_SESSION["user"]["id"];
    							}else{
    								$data_cancel ["user"] = - 1;
    							}
    							// ====================
    							$this->Cancel->Insert ( $data_cancel );
    							// ====================
    							/*
    							 * ========== UPDATE MODIFY TIME ==========
    							 */
    							$query2 = $this->db->query ( "UPDATE deskofreservation SET dc_updatetime = '".$reservations [$i] ["reservation"] ["dc_updatetime"]."' WHERE id = " . $hms_reservation_id );
    							
    							$reservationpush [$k] ["response"] = "ok";
    							$reservationpush [$k] ["text"] = "";
    							$reservationpush [$k] ["status"] = "cancel";
    							$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    							$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    							$k ++;
    						} else {
    							$reservationpush [$k] ["response"] = "failed";
    							$reservationpush [$k] ["text"] = "{caption_nobooking_tocancel}";
    							$reservationpush [$k] ["status"] = "cancel";
    
    							$reservationpush [$k] ["hms_reservation_id"] = 0;
    							$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    							$k ++;
    						}
    					}
    				} else {
    
    					if($hms_reservation_id == 0){
    						/*
    						 * NEW RESERVATION BLOCK
    						*/
    
    						$room_id = 0;
    
    						if ($type_id == 0 or $type_id == "") {
    							$query2 = $this->db->query ( "SELECT int_value FROM dc_ozon_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
    							if ($query->num_rows () > 0) {
    								$row2 = $query2->row ();
									$type_id = $row2->int_value;
								}
							}
							
							if ($type_id == 0 or $type_id == "") {
								if (isset ( $overbooking_category_id )) {
									$reservations ["reservation"] ["origin_categoryid"] = $type_id;
									$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $overbooking_category_id );
									
									$insert_over_room_bool = 0;
									if ($room_id == 0) {
										$room_id = $this->dc_model->dc_make_overbooking_room ( $overbooking_category_id );
										$insert_over_room_bool = 1;
									}
								} else {
									$reservationpush [$k] ["response"] = "failed";
									$reservationpush [$k] ["text"] = "no overbooking_category_id";
									$reservationpush [$k] ["status"] = "new";
									// $reservationpush [$k] ["bronevik_status"] = $reservations ["status"];
									$reservationpush [$k] ["hms_reservation_id"] = 0;
									$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
									// $reservationpush [$k] ["bronevik_original_id"] = $reservations ["reservation"] ["bronevik_original_id"];
									$reservationpush [$k] ["dc_room_id"] = $reservations ["reservation"] ["category_id"];
									$result_array ["reservations"] [$r_i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
									$result_array ["reservations"] [$r_i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
									$result_array ["reservations"] [$r_i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
									$k ++;
								}
							} else {
								$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $type_id );
							}
							// $room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $type_id );
							if ($room_id == 0) {
								
								if (isset ( $overbooking_category_id )) {
									$reservations [$i] ["reservation"] ["origin_categoryid"] = $type_id;
									$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $overbooking_category_id );
									
									$insert_over_room_bool = 0;
									if ($room_id == 0) {
										$room_id = $this->dc_model->dc_make_overbooking_room ( $overbooking_category_id );
										$insert_over_room_bool = 1;
    									}
    								} else {
    									$reservationpush [$k] ["response"] = "failed";
    									$reservationpush [$k] ["text"] = "no overbooking_category_id";
    									$reservationpush [$k] ["status"] = "new";
    									$reservationpush [$k] ["hms_reservation_id"] = 0;
    									$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    									$reservationpush [$k] ["dc_room_id"] = $reservations [$i] ["reservation"] ["category_id"];
    									$result_array ["reservations"] [$key] [$i] ["status"] = "new";
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    								}
    							}
    							$reservations [$i] ["reservation"] ["room_id"] = $room_id;
    
    							if ($bool_guest == 0) {
    								$guest_id = $this->frontdesk->Guest_insert ( $reservations [$i] ["guest"] );
    								$bool_guest = 1;
    							}
    
    							// echo "<pre>";
    							// print_r ( $reservations [$i] ["reservation"] );
    							// die ();
    							$reservation_id = $this->frontdesk->Reservation_insert ( $reservations [$i] ["reservation"], $guest_id, 0, 1 );
    
    							if(isset($otelms_rooms[$reservations [$i] ["reservation"] ["dc_uuid"]])){
    								$otelms_rooms[$reservations [$i]["reservation"] ["dc_uuid"]]["status"] = 1;
    							}
    
    							if (isset ( $reservations [$i] ["card"] )) {
    								$this->frontdesk->insert_tbl_CreditCards ( $reservations [$i] ["card"], $guest_id, $reservation_id );
    							}
    							
    							if (isset ( $reservations[$i] ["guest_add"] )) {
    								for($gst = 1; $gst <= count ( $reservations [$i] ["guest_add"] ); $gst ++) {
    									$add_guest_data = array ();
    									$add_guest_data ['firstname_' . $gst] = $reservations [$i] ["guest_add"] [$gst] ["firstname"];
    									$add_guest_data ['lastname_' . $gst] = $reservations [$i] ["guest_add"] [$gst] ["lastname"];
    									$add_guest_data ["reservation_id"] = $reservation_id;
    									$guest_id_add = $this->frontdesk->Guest_add_baby_insert ( $add_guest_data, $gst );
    									$this->frontdesk->guests_reservation_insert ( $guest_id_add, $reservation_id );
    								}
    							}
    
    							if ($reservation_id > 0) {
    								$reservationpush [$k] ["response"] = "ok";
    								$reservationpush [$k] ["text"] = "";
    								$reservationpush [$k] ["status"] = "new";
    								$reservationpush [$k] ["hms_reservation_id"] = $reservation_id;
    								$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    								$reservationpush [$k] ["dc_room_id"] = $reservations [$i] ["reservation"] ["category_id"];
    								$result_array ["reservations"] [$key] [$i] ["status"] = "new";
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    								$k ++;
    							} else {
    								$reservationpush [$k] ["response"] = "failed";
    								$reservationpush [$k] ["text"] = "undferror";
    								$reservationpush [$k] ["status"] = "new";
    								$reservationpush [$k] ["hms_reservation_id"] = 0;
    								$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    								$reservationpush [$k] ["dc_room_id"] = $reservations [$i] ["reservation"] ["category_id"];
    								$result_array ["reservations"] [$key] [$i] ["status"] = "new";
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    								$k ++;
    							}
    						
    					}else{
    						/*
    						 * UPDATE RESERVATION BLOCK
    						*
    						*/
    
    
    						$reservation_data = $this->frontdesk->GetReservation ( $hms_reservation_id );
    
    						//$reservation_data ["user"] = $xml_array ["reservations"] [$dc_reservationid] ["room"] [$cell ["dc_roomreservation_id"]] ["reservation"] ["user"];
    						$reservation_data ["firstname"] = $reservations [$i] ["guest"] ["firstname"];
    						$reservation_data ["lastname"] = $reservations [$i] ["guest"] ["lastname"];
    						$reservation_data ["phone"] = $reservations [$i] ["guest"] ["phone"];
    						$reservation_data ["email"] = $reservations [$i] ["guest"] ["email"];
    
    						$reservation_data ["amount"] = $reservations [$i] ["reservation"] ["amount"];
    						$reservation_data ["discount"] = $reservations [$i] ["reservation"] ["discount"];
    						$reservation_data ["date"] = $reservations [$i] ["reservation"] ["date"];
    						$reservation_data ["add_places"] = $reservations [$i] ["reservation"] ["add_places"];
    						$reservation_data ["baby_places"] = $reservations [$i] ["reservation"] ["baby_places"];
    						$reservation_data ["datein"] = $reservations [$i] ["reservation"] ["datein"];
    						$reservation_data ["dateout"] = $reservations [$i] ["reservation"] ["dateout"];
    						$reservation_data ["checkintime"] = $reservations [$i] ["reservation"] ["checkintime"];
    						$reservation_data ["checkouttime"] = $reservations [$i] ["reservation"] ["checkouttime"];
    
    
    						//$reservation_data ["type_id"] = $reservations [$i] ["reservation"] ["type_id"];
    						$reservation_data ["price_type"] = $reservations [$i] ["reservation"] ["price_type"];
    						$reservation_data ["guest_id_new"] = 0;
    						$reservation_data ["free_places"] = 0;
    						$reservation_data ["maid_description"] = "";
    						$reservation_data ["isread"] = 0;
    						$reservation_data ["dc_guestname"] = $reservations [$i] ["reservation"] ["dc_guestname"];
    						$reservation_data ["dc_currencycode"] = $reservations [$i] ["reservation"] ["dc_currencycode"];
    						$reservation_data ["dc_countrycode"] = $reservations [$i] ["reservation"] ["dc_countrycode"];
    						$reservation_data ["dc_city"] = $reservations [$i] ["reservation"] ["dc_city"];
    						$reservation_data ["dc_customerremarks"] = $reservations [$i] ["reservation"] ["dc_customerremarks"];
    						$reservation_data ["dc_roomremarks"] = $reservations [$i] ["reservation"] ["dc_roomremarks"];
    						$reservation_data ["dc_numberofguest"] = $reservations [$i] ["reservation"] ["dc_numberofguest"];
    						$reservation_data ["dc_totalprice"] = $reservations [$i] ["reservation"] ["dc_totalprice"];
    						$reservation_data ["smoking"] = $reservations [$i] ["reservation"] ["smoking"];
    
    						$reservation_data ["description"] = $reservations [$i] ["reservation"] ["dc_customerremarks"];
    							
    						$reservation_data ["dc_date"] = $reservations [$i] ["reservation"] ["dc_date"];
    						$reservation_data ["dc_time"] = $reservations [$i] ["reservation"] ["dc_time"];
    						$reservation_data ["dc_updatetime"] = $reservations [$i] ["reservation"] ["dc_updatetime"];
    
    						// print_r($reservation_data);
    
    						if ($reservation_data ["type_id"] == $type_id) {
    							$can_resize = $this->frontdesk->qd_canresize($hms_reservation_id, $datein, $dateout );
    						} else {
    							$can_resize = 0;
    							$reservation_data ["type_id"] = $type_id;
    						}
    
    						//$can_resize = $this->frontdesk->qd_canresize($hms_reservation_id, $datein, $dateout );
    
    						if($can_resize == 1){
    
    							$update_res = $this->frontdesk->UpdateReservation ( $reservation_data, 0, 1 );
    
    							if(isset($otelms_rooms[$reservations [$i]["reservation"] ["dc_uuid"]])){
    								$otelms_rooms[$reservations [$i]["reservation"] ["dc_uuid"]]["status"] = 1;
    							}
    							if ($update_res == "FreeError") {
    								$reservationpush [$k] ["response"] = "error";
    								$reservationpush [$k] ["text"] = "";
    								$reservationpush [$k] ["status"] = "modified";
    								$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = "";
    								$result_array ["reservations"] [$key] [$i] ["status"] = "modified";
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    								$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["reservation"]["dc_reservationid"];
    								$k ++;
    							}else{
    								$reservationpush [$k] ["response"] = "ok";
    								$reservationpush [$k] ["text"] = "";
    								$reservationpush [$k] ["alert"] = "";
    								$reservationpush [$k] ["status"] = "modified";
    								$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = "";
    								$result_array ["reservations"] [$key] [$i] ["status"] = "modified";
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    								$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["reservation"]["dc_reservationid"];
    								$k ++;
    							}
    						}else{
    							if ($type_id == 0 or $type_id == "") {
    								$query2 = $this->db->query ( "SELECT int_value FROM dc_101otel_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
    								if ($query->num_rows () > 0) {
    									$row2 = $query2->row ();
    									$type_id = $row2->int_value;
    								}
    							}
								if ($type_id == 0 or $type_id == "") {
									if (isset ( $overbooking_category_id )) {
										$reservations ["reservation"] ["origin_categoryid"] = $type_id;
										$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $overbooking_category_id );
										
										$insert_over_room_bool = 0;
										if ($room_id == 0) {
											$room_id = $this->dc_model->dc_make_overbooking_room ( $overbooking_category_id );
											$insert_over_room_bool = 1;
										}
									} else {
										$reservationpush [$k] ["response"] = "failed";
										$reservationpush [$k] ["text"] = "no overbooking_category_id";
										$reservationpush [$k] ["status"] = "modified";
										// $reservationpush [$k] ["bronevik_status"] = $reservations ["status"];
										$reservationpush [$k] ["hms_reservation_id"] = 0;
										$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
										// $reservationpush [$k] ["bronevik_original_id"] = $reservations ["reservation"] ["bronevik_original_id"];
										$reservationpush [$k] ["dc_room_id"] = $reservations ["reservation"] ["category_id"];
										$result_array ["reservations"] [$r_i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
										$result_array ["reservations"] [$r_i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
										$result_array ["reservations"] [$r_i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
										$k ++;
									}
								} else {
									$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $type_id );
								}
    								//$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $type_id );
    								if ($room_id == 0) {
    										
    									if (isset ( $overbooking_category_id )) {
    										$reservations [$i] ["reservation"] ["origin_categoryid"] = $type_id;
    										$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $overbooking_category_id );
    
    										$insert_over_room_bool = 0;
    										if ($room_id == 0) {
    											$room_id = $this->dc_model->dc_make_overbooking_room ( $overbooking_category_id );
    											$insert_over_room_bool = 1;
    										}
    									} else {
    										$reservationpush [$k] ["response"] = "failed";
    										$reservationpush [$k] ["text"] = "no overbooking_category_id";
    										$reservationpush [$k] ["status"] = "new";
    										$reservationpush [$k] ["hms_reservation_id"] = 0;
    										$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    										$reservationpush [$k] ["dc_room_id"] = $reservations [$i] ["reservation"] ["category_id"];
    										$result_array ["reservations"] [$key] [$i] ["status"] = "new";
    										$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    										$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    										$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    									}
    								}
    								$reservation_data ["room_id"] = $room_id;
    
    								$update_res = $this->frontdesk->UpdateReservation ( $reservation_data, 0, 1 );
    
    								if(isset($otelms_rooms[$reservations [$i]["reservation"] ["dc_uuid"]])){
    									$otelms_rooms[$reservations [$i]["reservation"] ["dc_uuid"]]["status"] = 1;
    								}
    
    								if ($update_res == "FreeError") {
    									$reservationpush [$k] ["response"] = "error";
    									$reservationpush [$k] ["text"] = "";
    									$reservationpush [$k] ["status"] = "modified";
    									$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    									$result_array ["reservations"] [$key] [$i] ["status"] = "modified";
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = "";
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    									$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["reservation"]["dc_reservationid"];
    									$k ++;
    								}else{
    									$reservationpush [$k] ["response"] = "ok";
    									$reservationpush [$k] ["text"] = "";
    									$reservationpush [$k] ["alert"] = "";
    									$reservationpush [$k] ["status"] = "modified";
    									$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    									$result_array ["reservations"] [$key] [$i] ["status"] = "modified";
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = "";
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    									$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["reservation"]["dc_reservationid"];
    									$k ++;
    								}
    							
    						}
    					}
    				}
    				// }
    			}
    		}
    
    		print_r ( $result_array );
    		print_r ( $otelms_rooms );
    		//die();
    		foreach($otelms_rooms as $cell){
    			if($cell["status"] == 0){
    				//$this->frontdesk->DeleteReservation($cell["otelms_reservation_id"]);
    				$status = 5;
    				$data_cancel = array ();
    				$data_cancel ["res_id"] = $cell["otelms_reservation_id"];
    				$data_cancel ["charge"] = 0;
    				$data_cancel ["status"] = $status;
    				$data_cancel ["description"] = "cancel from OZON";
					$data_cancel ["guestbe_request"] = 0;
					if (isset ( $_SESSION ["user"] ["id"] )) {
						$data_cancel ["user"] = $_SESSION ["user"] ["id"];
					} else {
						$data_cancel ["user"] = - 1;
					}
    				// ====================
    				$this->Cancel->Insert ( $data_cancel );
    			}
    		}
    
    		//die();
    		$counter_r = 0;
    		$new_mass = array ();
    		foreach ( $result_array ["reservations"] as $cell ) {
    
    			//print_r($cell);
    			$res_count = count ( $cell );
    			//echo "+++++++++++++++++++++++".$res_count;
    			for($i = 0; $i < $res_count; $i ++) {
    				if ($cell [$i] ["status"] == "modified" or $cell [$i] ["status"] == "new") {
    					$new_mass ['dcname'] = "OZON";
    					$new_mass ['status'] = $cell [$i] ["status"];
    					$new_mass ['dc_reservationid'] = $cell [$i] ["reservation"]["dc_reservationid"];
    					$new_mass ['dc_channel_name'] = "OZON";
    					$new_mass ['hotel_name'] = $hotel_name;
    					$new_mass ['guest_firstname'] = $cell [$i] ["guest"]  ["firstname"];
    					$new_mass ['guest_lastname'] = $cell [$i] ["guest"]  ["lastname"];
    					$new_mass ['guest_phone'] = $cell [$i] ["guest"] ["phone"];
    					$new_mass ['guest_email'] = $cell [$i] ["guest"] ["email"];
    
    					$new_mass ["room"] [$counter_r]["reservation_current"] = $i;
    					$new_mass ["room"] [$counter_r]["reservation_alert"] = $cell [$i] ["reservation"] ["reservation_alert"];
    					$new_mass ["room"] [$counter_r]["hms_reservation_id"] = $cell [$i] ["reservation"] ["hms_reservation_id"];
    					$new_mass ["room"] [$counter_r]["url"] = $cell [$i] ["reservation"] ["url"];
    					$new_mass ["room"] [$counter_r]["dc_channel_name"] = "Hotels24";
    
    					$new_mass ["room"] [$counter_r]["reservation_dc_reservationid"] = $cell [$i] ["reservation"] ["dc_reservationid"];
    					$new_mass ["room"] [$counter_r]["reservation_dc_roomreservation_id"] = $cell [$i] ["reservation"] ["dc_roomreservation_id"];
    					$new_mass ["room"] [$counter_r]["hotel_name"] = "hotel_name";
    					$new_mass ["room"] [$counter_r]["reservation_date"] = $cell [$i] ["reservation"]["date"];
    					$new_mass ["room"] [$counter_r]["status"] = $cell [$i] ["status"];
    					$new_mass ["room"] [$counter_r]["reservation_datein"] = $cell [$i] ["reservation"]["datein"];
    					$new_mass ["room"] [$counter_r]["reservation_dateout"] = $cell [$i] ["reservation"]["dateout"];
    					$new_mass ["room"] [$counter_r]["reservation_type_name"] = $cell [$i] ["reservation"]["reservation_type_name"];
    					$new_mass ["room"] [$counter_r]["reservation_category_id"] = $cell [$i] ["reservation"]["type_id"];
    					$new_mass ["room"] [$counter_r]["reservation_dc_totalprice"] = $cell [$i] ["reservation"]["dc_totalprice"];
    					$new_mass ["room"] [$counter_r]["reservation_dc_customerremarks"] = $cell [$i] ["reservation"]["dc_customerremarks"];
    
    					$new_mass ["room"] [$counter_r]["dc_rate_intdate_data"] = $cell [$i] ["per_day"];
    
    					$counter_r++;
    				}
    			}
    
    		}
    		if(count($new_mass) > 0){
    			//print_r($new_mass);
    			$this->dc_model->send_notifyarray_new ( $new_mass );
    		}
    
    	}
    
    	print_r ( $reservationpush );
    	foreach ( $reservationpush as $arg ) {
    		if ($arg ['status'] == "cancel") {
    			$data = array ();
    			$data ["hms_reservation_id"] = $arg ["hms_reservation_id"];
    			$data ['response'] = $arg ['response'];
    			$data ['resid'] = $arg ['dc_reservationid'];
    			$data ['dcname'] = "OZON";
    			$data ['status'] = $arg ['status'];
    			$data ['text'] = $arg ['text'];
    			$this->dc_model->send_notifyarray ( $data );
    		}
    	}
    	
    	return json_encode($reservationpush, true);
    }
	
	function dc_rate_intdate_insert($data) {
		$count = count ( $data );
		if ($count != 0) {
			foreach ( $data as $cell ) {
				$query = $this->db->query ( "DELETE FROM dc_ozon_rate_intdate WHERE dc_reservation_id LIKE '" . $cell ["dc_reservation_id"]."'" );
				break;
			}
			foreach ( $data as $cell ) {
				$sql = "INSERT INTO dc_ozon_rate_intdate (dc_reservation_id, dc_rate_id, intdate, price) VALUES('" . $cell ["dc_reservation_id"] . "',
		'" . $cell ["dc_rate_id"] . "', '" . $cell ["intdate"] . "', '" . $cell ["price"] . "')
		ON DUPLICATE KEY UPDATE price = '" . $cell ["price"] . "'";
				// echo $sql;
				$query = $this->db->query ( $sql );
			}
		}
	}
}