<?php 
class dcm_onetwotrip_v2 extends dcm_abstract {
    public function __construct() {
        parent::__construct();
        
        $this->dc_id = 25;
        
        //$this->overbooking_category_id = $this->get_dc_overbooking_category_id();
        
        $this->table_name_r2c = "dc_onetwotrip_rate2category_link";
        $this->table_name_dc_category2occupancy = "dc_onetwotrip_category2occupancy";
        $this->table_name_dc2hms_category_link = "dc_onetwotrip_rooms_link";
        
        
        $this->sql_dc_rates = "select  dc_onetwotrip_rates.dc_hotel_id, dc_onetwotrip_rates.dc_rate_id as dc_rate_id, dc_onetwotrip_rates.active, dc_onetwotrip_rates.name as dc_rate_name, dc_global_restrict_rate.name as restrict_name
        		from dc_onetwotrip_rates
        		LEFT JOIN dc_onetwotrip_rates_link ON dc_onetwotrip_rates_link.dc_rate_id = dc_onetwotrip_rates.dc_rate_id
        		LEFT JOIN dc_global_restrict_rate ON dc_global_restrict_rate.rate_id = dc_onetwotrip_rates_link.restrict_id";
        $this->sql_dc_category_link = "select dc_onetwotrip_rooms_link.dc_hotel_id, dc_room_name as dc_category_name,
            dc_room_id	 as dc_category_id,
            category_id as hms_category_id
            from dc_onetwotrip_rooms_link";
        $this->sql_dc_r2rlink = "select dc_rate_id as dc_rate_id, restrict_id as hms_restrict_id from dc_onetwotrip_rates_link";
        $this->sql_dc_r2c = "select dc_rate_id as dc_rate_id,
            dc_category_id as dc_category_id,
            hms_rate_id as hms_rate_id,
            hms_price_func_id as hms_price_func_id,
            hms_restrict_id as hms_restrict_id,
            hms_occupancy_id as hms_occupancy_id
            from dc_onetwotrip_rate2category_link";
        
        $this->sql_get_occupancies = "select id as hms_occupancy_id,
           name as hms_occupancy_name from dc_onetwotrip_occupancy";
        $this->sql_build_hms_categories = "select id as hms_category_id,
            name as hms_category_name from categories WHERE is_active = 1";
        
        $this->sql_dc_category_list = "select concat('<i>', dc_onetwotrip_xml_cfg.str_value, '</i> - <b>',  dc_room_name,  '</b> - ') as dc_category_name,
            dc_room_id as dc_category_id, active from dc_onetwotrip_rooms_link left join dc_onetwotrip_xml_cfg on
            dc_onetwotrip_rooms_link.dc_hotel_id = dc_onetwotrip_xml_cfg.int_value and dc_onetwotrip_xml_cfg.name='hotel_id'
            ";
        
        $this->sql_dc_category_list = "select dc_onetwotrip_xml_cfg.str_value as dc_property_name,  dc_room_name as dc_category_name,
            dc_room_id as dc_category_id, active from dc_onetwotrip_rooms_link left join dc_onetwotrip_xml_cfg on
            dc_onetwotrip_rooms_link.dc_hotel_id = dc_onetwotrip_xml_cfg.int_value and dc_onetwotrip_xml_cfg.name='hotel_id'
            ";
        
        $this->sql_dc_category2occupancy_list = "select dc_category_id as dc_category_id,
            hms_occupancy_id as hms_occupancy_id from dc_onetwotrip_category2occupancy";
        $this->form_action_c2o_post = "/dc_onetwotrip_c2/categories_edit_post";
        $this->form_action_r2c_post = "/dc_onetwotrip_c2/rates_edit_post";
        
        $this->form_action_c2o_post_c2 = "/dc_onetwotrip_c2/categories_edit_post";
        $this->form_action_r2c_post_c2 = "/dc_onetwotrip_c2/rates_edit_post";
    }
    
    function category2occupancy_save_booking($c2o)
    {
        $this->db->query("delete from " . $this->table_name_dc_category2occupancy);
        foreach ($c2o as $dc_category_id => $cell) {
            $sql = "insert into " . $this->table_name_dc2hms_category_link . "  (dc_room_id, category_id) values
            ($dc_category_id, " . $cell['hms_category_id'] . ") on duplicate key update
                category_id=" . $cell['hms_category_id'] . " ";
            // echo $sql . "\n";
            $this->db->query($sql);
            if (isset($cell['occupancies'])) {
                foreach ($cell['occupancies'] as $key => $state) {
                    $sql = "insert into " . $this->table_name_dc_category2occupancy . " (dc_category_id, hms_occupancy_id)
                    values (" . $dc_category_id . ", " . $key . ") on duplicate key update
                        dc_category_id = " . $dc_category_id . ", hms_occupancy_id = " . $key . "";
                    $this->db->query($sql);
                }
            }
        }
    }
    
    function rate2category_save_booking($r2c)
    {
        if (sizeof($r2c)) {
    
        } else {
            return;
        }
         
    
        $this->db->query("delete from " . $this->table_name_r2c);
    
        //echo "<pre>";
        //print_r($r2c);
         
        foreach ($r2c as $dc_rate_id => $dc_category_list) {
            foreach ($dc_category_list['room_list'] as $dc_category_id => $occupancy) {
                //print_r($occupancy);
                foreach ($occupancy as $key => $cell) {
                    $sql = "insert into " . $this->table_name_r2c . "  (dc_rate_id, dc_category_id, hms_occupancy_id,  hms_rate_id, hms_price_func_id) values
                    ($dc_rate_id, $dc_category_id, " . $cell['hms_occupancy_id'] . ", " . $cell['hms_rate_id'] . ", " . $cell['hms_price_func_id'] . ") on duplicate key update
                hms_rate_id=" . $cell['hms_rate_id'] . ", hms_price_func_id=" . $cell['hms_price_func_id'] . "
                    , hms_occupancy_id=" . $cell['hms_occupancy_id'] . "";
                    // echo $sql . "\n";
                    $this->db->query($sql);
                    //===================================
    
                }
            }
            $sql = "INSERT INTO dc_onetwotrip_rates_link (dc_rate_id, restrict_id) values ($dc_rate_id, ".$r2c[$dc_rate_id]['hms_restrict_id'].")
			on duplicate key update restrict_id = ".$r2c[$dc_rate_id]['hms_restrict_id'];
            $this->db->query ( $sql );
        }
         
        //die();
    
    }
}
?>