<?php 
class dcm_hotels24 extends dcm_abstract {
    public function __construct() {
        parent::__construct();
        

        $this->dc_id = 14;
        $this->table_name_r2c = "dc_hotels24_rate2category_link";
        $this->table_name_dc_category2occupancy = "dc_hotels24_category2occupancy";
        $this->table_name_dc2hms_category_link = "dc_hotels24_rooms_link";
        
        
        $this->sql_dc_rates = "select dc_hotels24_rates.dc_hotel_id, dc_hotels24_rates.dc_rate_id as dc_rate_id, dc_hotels24_rates.active, dc_hotels24_rates.name as dc_rate_name, 
        		dc_global_restrict_rate.name as restrict_name, dc_hotels24_xml_cfg.int_value as dc_property_name 
        		from dc_hotels24_rates 
        		LEFT JOIN dc_hotels24_rates_link ON dc_hotels24_rates_link.dc_rate_id = dc_hotels24_rates.dc_rate_id
        		LEFT JOIN dc_global_restrict_rate ON dc_global_restrict_rate.rate_id = dc_hotels24_rates_link.restrict_id 
        		LEFT JOIN dc_hotels24_xml_cfg on dc_hotels24_rates.dc_hotel_id = dc_hotels24_xml_cfg.int_value and dc_hotels24_xml_cfg.name='hotel_id'";
        $this->sql_dc_category_link = "select dc_hotels24_rooms_link.dc_hotel_id, dc_room_name as dc_category_name,
            dc_room_id	 as dc_category_id,
            category_id as hms_category_id
            from dc_hotels24_rooms_link";
        $this->sql_dc_r2rlink = "select dc_rate_id as dc_rate_id, restrict_id as hms_restrict_id from dc_hotels24_rates_link";
        $this->sql_dc_r2c = "select dc_rate_id as dc_rate_id,
            dc_category_id as dc_category_id,
            hms_rate_id as hms_rate_id,
            hms_price_func_id as hms_price_func_id,
            hms_restrict_id as hms_restrict_id,
            hms_occupancy_id as hms_occupancy_id
            from dc_hotels24_rate2category_link";
        
        $this->sql_get_occupancies = "select id as hms_occupancy_id,
           name as hms_occupancy_name from dc_hotels24_occupancy";
        $this->sql_build_hms_categories = "select id as hms_category_id,
            name as hms_category_name from categories";
        
        $this->sql_dc_category_list = "select dc_room_name as dc_category_name, dc_hotels24_xml_cfg.int_value as dc_property_name,
            dc_room_id as dc_category_id, active from dc_hotels24_rooms_link left join dc_hotels24_xml_cfg on
            dc_hotels24_rooms_link.dc_hotel_id = dc_hotels24_xml_cfg.int_value and dc_hotels24_xml_cfg.name='hotel_id'";
        $this->sql_dc_category2occupancy_list = "select dc_category_id as dc_category_id,
            hms_occupancy_id as hms_occupancy_id from dc_hotels24_category2occupancy";
        $this->form_action_c2o_post = "/dc_hotels24/categories_edit_post";
        $this->form_action_r2c_post = "/dc_hotels24/rates_edit_post";
        
        $this->form_action_c2o_post_c2 = "/dc_hotels24_c2/categories_edit_post";
        $this->form_action_r2c_post_c2 = "/dc_hotels24_c2/rates_edit_post";
    }
    
    function getauthparam() {
    	$data = array ();
    	$data ['hotel_id'] = "";
    	$data ['test_mode'] = 1;
    	
    	
    
    	$query = $this->db->query ( "SELECT int_value FROM dc_hotels24_xml_cfg WHERE name LIKE 'hotel_id'" );
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$data ['hotel_id'] = $row->int_value;
    	} else {
    		$data ['hotel_id'] = "none";
    	}
    	
    	$query = $this->db->query ( "SELECT int_value FROM dc_hotels24_xml_cfg WHERE name LIKE 'test_mode'" );
    	if ($query->num_rows () > 0) {
    	    $row = $query->row ();
    	    $data ['test_mode'] = $row->int_value;
    	} else {
    	    $data ['test_mode'] = 0;
    	}
    	
    	if ($data ['test_mode'] == 1) {
    	    $data ['api_url'] = "https://api-test.hotels24.ua";
    	    $data ['api_key'] = "176f22801d3d9637240b7c361c3b34f9a780943be8c6660a4fa6e101e3a9b5fa";
    	    
    	} else {
    	    $data ['api_url'] = "https://api.hotels24.ua";
    	    $data ['api_key'] = "176f22801d3d9637240b7c361c3b34f9a780943be8c6660a4fa6e101e3a9b5fa";
    	}
    	
    	return $data;
    }
    
    function rate2category_save_hotels24($r2c)
    {
    	if (sizeof($r2c)) {
    
    	} else {
    		return;
    	}
    	
    
    	$this->db->query("delete from " . $this->table_name_r2c);
    
    	//echo "<pre>";
    	//print_r($r2c);
    	
    	foreach ($r2c as $dc_rate_id => $dc_category_list) {
    		foreach ($dc_category_list['room_list'] as $dc_category_id => $occupancy) {
    		    //print_r($occupancy);
    			foreach ($occupancy as $key => $cell) {
    				$sql = "insert into " . $this->table_name_r2c . "  (dc_rate_id, dc_category_id, hms_occupancy_id,  hms_rate_id, hms_price_func_id) values
    				($dc_rate_id, $dc_category_id, " . $cell['hms_occupancy_id'] . ", " . $cell['hms_rate_id'] . ", " . $cell['hms_price_func_id'] . ") on duplicate key update
                hms_rate_id=" . $cell['hms_rate_id'] . ", hms_price_func_id=" . $cell['hms_price_func_id'] . "
                    , hms_occupancy_id=" . $cell['hms_occupancy_id'] . "";
    				// echo $sql . "\n";
    				$this->db->query($sql);
    				//===================================
    				
    			}
    		}
    		$sql = "INSERT INTO dc_hotels24_rates_link (dc_rate_id, restrict_id) values ($dc_rate_id, ".$r2c[$dc_rate_id]['hms_restrict_id'].")
			on duplicate key update restrict_id = ".$r2c[$dc_rate_id]['hms_restrict_id'];
    		$this->db->query ( $sql );
    	}
    	
    	//die();
    	   
    }
    
    function category2occupancy_save_hotels24($c2o)
    {
    	$this->db->query("delete from " . $this->table_name_dc_category2occupancy);
    	foreach ($c2o as $dc_category_id => $cell) {
    		$sql = "insert into " . $this->table_name_dc2hms_category_link . "  (dc_room_id, category_id) values
    		($dc_category_id, " . $cell['hms_category_id'] . ") on duplicate key update
                category_id=" . $cell['hms_category_id'] . " ";
    		// echo $sql . "\n";
    		$this->db->query($sql);
    		if (isset($cell['occupancies'])) {
    			foreach ($cell['occupancies'] as $key => $state) {
    				$sql = "insert into " . $this->table_name_dc_category2occupancy . " (dc_category_id, hms_occupancy_id)
                    values (" . $dc_category_id . ", " . $key . ") on duplicate key update
                        dc_category_id = " . $dc_category_id . ", hms_occupancy_id = " . $key . "";
    				$this->db->query($sql);
    			}
    		}
    	}
    }
    
    function options_save($data) {
    	$data_1 = array ();
    	$query = $this->db->query ( "SELECT * FROM dc_hotels24_xml_cfg WHERE name LIKE 'general_update'" );
    
    	if ($query->num_rows () > 0) {
    		$row = $query->row_array ();
    		$data_1["general_update"] = $row["int_value"];
    	}
    	$sql = "INSERT INTO dc_hotels24_xml_cfg (dc_account_id, name, int_value) VALUES(0, 'dealer_id', '" . $data ["dealer"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["dealer"];
    	$query = $this->db->query ( $sql );
    	$sql = "INSERT INTO dc_hotels24_xml_cfg (dc_account_id, name, int_value) VALUES(0, 'overbooking_category_id', '" . $data ["overbooking_category"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["overbooking_category"];
    	$query = $this->db->query ( $sql );
    	$sql = "INSERT INTO dc_hotels24_xml_cfg (dc_account_id, name, int_value) VALUES(0, 'general_update', '" . $data ["general_update"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["general_update"];
    	$query = $this->db->query ( $sql );
    
    	$data_2 = array ();
    	$query = $this->db->query ( "SELECT * FROM dc_hotels24_xml_cfg WHERE name LIKE 'general_update'" );
    
    	if ($query->num_rows () > 0) {
    		$row = $query->row_array ();
    		$data_2["general_update"] = $row["int_value"];
    	}
    
    	$this->Loger_admin->SaveLog ( $data_1, $data_2, "loger_admin", 0, "dc_hotels24_xml_cfg", "edit" );
    }
    function gethotelid() {
    	$query = $this->db->query ( "SELECT int_value FROM dc_hotels24_xml_cfg WHERE name LIKE 'hotel_id'" );
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$hotel_id = $row->int_value;
    	} else {
    		$hotel_id = "none";
    	}
    	return $hotel_id;
    }
	function bokking_xml_parse($data, $send_notification = 1) {
		$rates = array ();
		
		$query = $this->db->query ( "SELECT hms_rate_id, dc_rate_id FROM   dc_hotels24_rates_link" );
		
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$rates [$row->dc_rate_id] = $row->hms_rate_id;
			}
		}
		
		$rates_names = array ();
		
		$query = $this->db->query ( "SELECT name, dc_rate_id FROM  dc_hotels24_rates" );
		
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$rates_names ["dc_rate_name"] = $row->name;
				$rates_names ["dc_rate_id"] = $row->dc_rate_id;
			}
		}
		
		$hms_rate_id = 0;
		$query = $this->db->query ( "SELECT hms_rate_id, dc_rate_id FROM  dc_hotels24_rates_link" );
		
		if ($query->num_rows () > 0) {
			$row = $query->row ();
				
			$hms_rate_id = $row->hms_rate_id;
		}
		
		$categories = array ();
		
		$query = $this->db->query ( "SELECT dc_room_id, category_id FROM dc_hotels24_rooms_link" );
		
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$categories [$row->dc_room_id] = $row->category_id;
			}
		}
		
		$categories_names = array ();
		
		$query = $this->db->query ( "SELECT id, name FROM categories" );
		
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$categories_names [$row->id] = $row->name;
			}
		}
		
		$query = $this->db->query ( "SELECT id FROM rate WHERE isdefault = 1" );
		
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$price_type = $row->id;
		}
		
		$rates_link = array ();
		
		$query = $this->db->query ( "SELECT dc_category_id, hms_rate_id FROM dc_hotels24_rate2category_link" );
		
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$rates_link [$row->dc_category_id] = $row->hms_rate_id;
			}
		}
		
		$query = $this->db->query ( "SELECT int_value FROM dc_hotels24_xml_cfg WHERE name LIKE 'dealer_id'" );
		
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$dealer = $row->int_value;
		}
		
		$query = $this->db->query ( "SELECT int_value FROM dc_hotels24_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
		
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$overbooking_category_id = $row->int_value;
		}
		
		
		
		$result_array = array ();
		
		if (isset ( $data ["data"] )) {
			if (isset ( $data ["data"] ["booking"] )) {
				
				$otelms_rooms = array();
				$query = $this->db->query ( "SELECT id, dc_uuid FROM deskofreservation WHERE deleted = 0 AND cancel = 0 AND dc_id = 14 AND dc_reservationid = ". $data ["data"] ["orderId"]);
				
				if ($query->num_rows () > 0) {
					foreach ( $query->result () as $row ) {
						$otelms_rooms [$row->dc_uuid]["otelms_reservation_id"] = $row->id;
						$otelms_rooms [$row->dc_uuid]["dc_uuid"] = $row->dc_uuid;
						$otelms_rooms [$row->dc_uuid]["status"] = 0;
					}
				}
				
				$reservations = array ();
				if (isset ( $data ["data"] ["booking"] [0] )) {
					$reservations = $data ["data"] ["booking"];
				} else {
					$reservations [0] = $data ["data"] ["booking"];
				}
				
				$counter = 0;
				echo "<pre>";
				print_r($reservations);
				foreach ( $reservations as $reservation ) {
					
					$qty = count($reservation["bookedRooms"]);
					for($j = 0; $j < $qty; $j ++) {
						
						if (isset ( $rates_link [$reservation["bookedRooms"][$j]["roomId"]] )) {
							$price_type = $rates_link [$reservation["bookedRooms"][$j]["roomId"]];
						}
												
						list ($year, $month, $day) = explode("-", $reservation["dateStart"]);
						$int_datein = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
						list ($year, $month, $day) = explode("-", $reservation["dateEnd"]);
						$int_dateout = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
						$duration = $int_dateout - $int_datein;
						for($k = $int_datein; $k < $int_dateout; $k++){
							$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["dc_currencycode"] = "";
							$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["dc_reservation_id"] = $data ["data"] ["orderId"] . "_" . $reservation["bookedRooms"][$j]["roomId"] . "_" . $j;
							$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["price"] = $reservation["bookedRooms"][$j]["roomPrice"] / $duration;
							$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["dc_rate_id"] = $rates_names["dc_rate_id"];
							
							$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["dc_rate_name"] = $rates_names["dc_rate_name"];
							
							$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["intdate"] = $k;
							$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["date_rate"] = gmdate("Y-m-d", $k * 86400);
						}
						
						$result_array ["reservations"] [$counter] [$j] ["dc_rate_id"] = "";
						$result_array ["reservations"] [$counter] [$j] ["currencycode"] = "";
						
						$result_array ["reservations"] [$counter] [$j] ["card"] ["cc_cvc"] = "";
						
						$result_array ["reservations"] [$counter] [$j] ["card"] ["ExpMonth"] = "";
						$result_array ["reservations"] [$counter] [$j] ["card"] ["ExpYear"] = "";
						$result_array ["reservations"] [$counter] [$j] ["card"] ["CardHolder"] = "";
						$result_array ["reservations"] [$counter] [$j] ["card"] ["CardNumber"] = "";
						$result_array ["reservations"] [$counter] [$j] ["card"] ["cc_type"] = "";
						
						$result_array ["reservations"] [$counter] [$j] ["guest"] ["address"] = "";
						$result_array ["reservations"] [$counter] [$j] ["guest"] ["city"] = "";
						$result_array ["reservations"] [$counter] [$j] ["guest"] ["country"] = "";
						$result_array ["reservations"] [$counter] [$j] ["guest"] ["email"] = $data ["data"]["contact"]["emails"];
						$result_array ["reservations"] [$counter] [$j] ["guest"] ["firstname"] = $data ["data"]["contact"]["firstName"];
						$result_array ["reservations"] [$counter] [$j] ["guest"] ["lastname"] = $data ["data"]["contact"]["lastName"];
						$result_array ["reservations"] [$counter] [$j] ["guest"] ["phone"] = $data ["data"]["contact"]["phones"];
						$result_array ["reservations"] [$counter] [$j] ["guest"] ["passportid"] = "";
						
						$result_array ["reservations"] [$counter] [$j] ["status"] = $reservation["status"];
						// $result_array ["reservations"] [$i] ["status"] = "cancelled";
						$result_array ["reservations"] [$counter] [$j] ["dc_reservationid"] = $data ["data"] ["orderId"];
						
						$created_at_arr = explode ( " ", $data ["data"] ["created"] );
						$created_at = $created_at_arr [0];
						if (isset ( $created_at_arr [1] )) {
							$created_at_time = $created_at_arr [0] . " " . $created_at_arr [1];
						} else {
							$created_at_time = $created_at_arr [0];
						}
						
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_id"] = 14;
						
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["commissionamount"] = 0;
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["date"] = $created_at;
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_reservationid"] = $data ["data"] ["orderId"];
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["time"] = $created_at_time;
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_date"] = $created_at_arr[0];
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_time"] = $created_at_arr[1];
						if(isset($data ["data"] ["updated"])){
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_updatetime"] = $data ["data"] ["updated"];
						}else{
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_updatetime"] = "";
						}
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["isNew"] = 1;
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["datein"] = $reservation ["dateStart"];
					
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dateout"] = $reservation ["dateEnd"];
						
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["checkintime"] = "";
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["checkouttime"] = "";
						
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_roomreservation_id"] = "";
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_uuid"] = $data ["data"] ["orderId"] . "_" . $reservation["bookedRooms"][$j]["roomId"] . "_" . $j;
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["category_id"] = $reservation["bookedRooms"][$j]["roomId"];
						if (isset ( $categories_names [$categories [$reservation["bookedRooms"][$j]["roomId"]]] )) {
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["reservation_type_name"] = $categories_names [$categories [$reservation["bookedRooms"][$j]["roomId"]]];
						} else {
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["reservation_type_name"] = "";
						}
						
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["placement_id"] = "";
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["add_places"] = 0;
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["baby_places"] = 0;
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["amount"] = $reservation["bookedRooms"][$j]["roomPrice"];
						
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["price_type"] = $price_type;
						
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["description"] = "";
						if(isset($_SESSION["user"]["id"])){
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["user"]  = $_SESSION["user"]["id"];
						}else{
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["user"] = - 1;
						}
						
						if (isset ( $categories [$reservation["bookedRooms"][$j]["roomId"]] )) {
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["type_id"] = $categories [$reservation["bookedRooms"][$j]["roomId"]];
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_type_id"] = $reservation["bookedRooms"][$j]["roomId"];
						} else {
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["type_id"] = 0;
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_type_id"] = 0;
						}
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dealer"] = $dealer;
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_guestname"] = $data ["data"]["contact"]["firstName"] . " " . $data ["data"]["contact"]["lastName"];
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_numberofguest"] = $reservation["bookedRooms"][$j]["guestCount"];
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_countrycode"] = "";
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_currencycode"] = "";
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_city"] = "";
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_customerremarks"] = $reservation["bookingNoteHotel"];
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_roomremarks"] = "";
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["description"] = $reservation["bookingNoteHotel"];
						
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_totalprice"] =  $reservation["bookedRooms"][$j]["roomPrice"];
						
						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["smoking"] = "";
						
						$result_array ["reservations"] [$counter] [$j] ["roomreservation_id"] = "";
						
						if($qty > 1){
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["groupid"] = $data ["data"] ["orderId"];
						}
						
						
					}
					$counter++;
				}
			}
		}
		//echo "<pre>";
		//print_r ( $result_array );
		//die ();
		
		$host = "";
		if ($_SERVER ["HTTP_HOST"]) {
			$host = $_SERVER ["HTTP_HOST"];
		}
		
		//$host = $this->releases->get_company_host();
		
		$reservationpush = array ();
		
		if (isset ( $result_array ["reservations"] )) {
			$k = 0;
			$bool_guest = 0;
			$bool_cancel = 0;
			$guest_array = array ();
			$guest_counter = 1;
			foreach ( $result_array ["reservations"] as $key => $reservations ) {
				$res_count = count ( $reservations );
				//print_r ( $reservations );
				// die();
		
		
				//echo "++";
				//print_r($guest_array);
				for($i = 0; $i < $res_count; $i ++) {
					/*
					 *
					* calculate discount
					*/
		
					//$amount = 0;
					
					//$reservations [$i] ["reservation"] ["amount"] = $amount;
		
		
					$calculate_data = array ();
					$calculate_data ["type_id"] = $reservations [$i] ["reservation"] ["type_id"];
					$calculate_data ["datein"] = $reservations [$i] ["reservation"] ["datein"];
					$calculate_data ["dateout"] = $reservations [$i] ["reservation"] ["dateout"];
					$calculate_data ["add_places"] = $reservations [$i] ["reservation"] ["add_places"];
					$calculate_data ["baby_places"] = $reservations [$i] ["reservation"] ["baby_places"];
					$calculate_data ["addbedplace"] = 0;
					$calculate_data ["babyplace2"] = 0;
					$calculate_data ["price_type"] = $reservations [$i] ["reservation"] ["price_type"];
		
					$temp_amount = $this->frontdesk->getpricecalculation ( $calculate_data );
					$otelms_amount = 0;
					for($p = 0; $p < count ( $temp_amount ); $p ++) {
						$otelms_amount += $temp_amount [$p] ["amount"];
					}
					$booking_amount = $reservations [$i] ["reservation"] ["amount"];
					$reservations [$i] ["reservation"] ["discount"] = 0;
					if ($booking_amount != $otelms_amount) {
						if ($otelms_amount != 0) {
							$reservations [$i] ["reservation"] ["discount"] = $otelms_amount - $booking_amount;
						}
					}
		
					//=====================================================
					//=====================================================
					//=====================================================
		
					$datein = $reservations [$i] ["reservation"] ["datein"];
					$dateout = $reservations [$i] ["reservation"] ["dateout"];
					$type_id = $reservations [$i] ["reservation"] ["type_id"];
					$sql = "SELECT id, room_id FROM deskofreservation WHERE cancel=0 AND deleted = 0 AND dc_uuid LIKE '" . $reservations [$i] ["reservation"] ["dc_uuid"] . "' AND dc_reservationid = ".$reservations [$i] ["reservation"] ["dc_reservationid"]." ORDER BY id DESC ";
					//echo $sql;
					$query = $this->db->query ( $sql );
					$hms_reservation_id = 0;
					$otelms_room_id = 0;
					if ($query->num_rows () > 0) {
						$row = $query->row ();
						$hms_reservation_id = $row->id;
						$otelms_room_id = $row->room_id;
						//$reservations [1] ["status"] = "modified";
					}
					//echo $hms_reservation_id."+++++++++++++++";
					$reservations [$i] ["reservation"] ["dc_totalprice"] = 0;
					foreach ( $reservations [$i] ["per_day"] as $cell ) {
						$reservations [$i] ["reservation"] ["dc_totalprice"] += $cell ["price"];
						$reservations [$i] ["reservation"] ["amount"] += $cell ["price"];
					}
					if (isset ( $reservations [$i] ["per_day"] )) {
		
						$this->dc_rate_intdate_insert ( $reservations [$i] ["per_day"] );
					}
						
					if ($reservations [1] ["status"] == "modified") {
						$reservations [$i] ["reservation"] ["specialstatus"] = "modified";
					}
						
					if ($reservations [$i] ["status"] == "cancelOral" || $reservations [$i] ["status"] == "cancel" 
					|| $reservations [$i] ["status"] == "notArrived") {
		
						$query2 = $this->db->query ( "SELECT deskofreservation.datein, deskofreservation.dateout, rooms.category_id FROM deskofreservation INNER JOIN rooms ON rooms.id = deskofreservation.room_id WHERE deskofreservation.id = $hms_reservation_id" );
							
						if ($query2->num_rows () > 0) {
							$row2 = $query2->row ();
							$datein = $row2->datein;
							$dateout = $row2->dateout;
							$type_id = $row2->category_id;
						}
		
						$time2 = date ( "Y-m-d H:i:s" );
						$status = 5;
						$query2 = $this->db->query ( "SELECT id FROM  services_main WHERE reservation_id = " . $hms_reservation_id . " AND type = 2" );
		
						if ($query2->num_rows () > 0) {
							$reservationpush [$k] ["response"] = "failed";
							$reservationpush [$k] ["text"] = "есть уже отмена";
							$reservationpush [$k] ["status"] = "cancel";
								
							$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
							$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
							$k ++;
								
							$dc_log_data = array ();
							$dc_log_data ["datein"] = $datein;
							$dc_log_data ["dateout"] = $dateout;
							$dc_log_data ["category_id"] = $type_id;
							$this->frontdesk->dc_log_update ( $dc_log_data );
						} else {
							$query2 = $this->db->query ( "SELECT id FROM deskofreservation WHERE id = " . $hms_reservation_id );
								
							if ($query2->num_rows () > 0) {
								$data_cancel = array ();
		
								$data_cancel ["res_id"] = $hms_reservation_id;
								$data_cancel ["charge"] = 0;
								$data_cancel ["status"] = 5;
								;
								$data_cancel ["description"] = "cancel from 101otel";
								$data_cancel ["guestbe_request"] = 0;
								$data_cancel ["user"] = - 1;
								
								// ====================
								$this->Cancel->Insert ( $data_cancel );
								
								// ======== UPDATE STATUS notArrived ========
								if($reservations [$i] ["status"] == "notArrived"){
									$this->frontdesk->update_reservation_status ( $hms_reservation_id, 6 );
								}
								//====================
								
								$reservationpush [$k] ["response"] = "ok";
								$reservationpush [$k] ["text"] = "";
								$reservationpush [$k] ["status"] = "cancel";
								$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
								$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
								$k ++;
							} else {
								$reservationpush [$k] ["response"] = "failed";
								$reservationpush [$k] ["text"] = "нет брони для отмены";
								$reservationpush [$k] ["status"] = "cancel";
		
								$reservationpush [$k] ["hms_reservation_id"] = 0;
								$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
								$k ++;
							}
						}
					} else {
		
						if($hms_reservation_id == 0){
							/*
							 * NEW RESERVATION BLOCK
							*/
								
							$room_id = 0;
								
							if ($type_id == 0 or $type_id == "") {
								$query2 = $this->db->query ( "SELECT int_value FROM dc_hotels24_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
								if ($query->num_rows () > 0) {
									$row2 = $query2->row ();
									$type_id = $row2->int_value;
								}
							}
							if ($type_id == 0 or $type_id == "") {
								$reservationpush [$k] ["response"] = "error";
								$reservationpush [$k] ["text"] = "UNKNOWN CATEGORY";
								$reservationpush [$k] ["status"] = "update";
								$reservationpush [$k] ["hms_reservation_id"] = $row->id;
								$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
								$result_array ["reservations"] [$key] [$i] ["status"] = "update";
								$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
								$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
								$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
								$k ++;
							} else {
								$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $type_id );
								if ($room_id == 0) {
										
									if (isset ( $overbooking_category_id )) {
										$reservations [$i] ["reservation"] ["origin_categoryid"] = $type_id;
										$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $overbooking_category_id );
		
										$insert_over_room_bool = 0;
										if ($room_id == 0) {
											$room_id = $this->dc_model->dc_make_overbooking_room ( $overbooking_category_id );
											$insert_over_room_bool = 1;
										}
									} else {
										$reservationpush [$k] ["response"] = "failed";
										$reservationpush [$k] ["text"] = "no overbooking_category_id";
										$reservationpush [$k] ["status"] = "new";
										$reservationpush [$k] ["hms_reservation_id"] = 0;
										$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
										$reservationpush [$k] ["dc_room_id"] = $reservations [$i] ["reservation"] ["category_id"];
										$result_array ["reservations"] [$key] [$i] ["status"] = "new";
										$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
										$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
										$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
									}
								}
								$reservations [$i] ["reservation"] ["room_id"] = $room_id;
		
								if ($bool_guest == 0) {
									if ($reservations [1] ["status"] == "modified") {
										if (isset ( $guest_array [$i] )) {
											$guest_id = $guest_array [$i];
										} else {
											$guest_id = $this->frontdesk->Guest_insert ( $reservations [$i] ["guest"] );
										}
									} else {
										$guest_id = $this->frontdesk->Guest_insert ( $reservations [$i] ["guest"] );
										$bool_guest = 1;
									}
								}
		
								// echo "<pre>";
								// print_r ( $reservations [$i] ["reservation"] );
								// die ();
								$reservation_id = $this->frontdesk->Reservation_insert ( $reservations [$i] ["reservation"], $guest_id, 0, 1 );
		
								if(isset($otelms_rooms[$reservations [$i] ["reservation"] ["dc_uuid"]])){
									$otelms_rooms[$reservations [$i]["reservation"] ["dc_uuid"]]["status"] = 1;
								}
		
								if (isset ( $reservations [$i] ["card"] )) {
									$this->frontdesk->insert_tbl_CreditCards ( $reservations [$i] ["card"], $guest_id, $reservation_id );
								}
		
								if ($reservation_id > 0) {
									$reservationpush [$k] ["response"] = "ok";
									$reservationpush [$k] ["text"] = "";
									$reservationpush [$k] ["status"] = "new";
									$reservationpush [$k] ["hms_reservation_id"] = $reservation_id;
									$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
									$reservationpush [$k] ["dc_room_id"] = $reservations [$i] ["reservation"] ["category_id"];
									$result_array ["reservations"] [$key] [$i] ["status"] = "new";
									$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
									$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
									$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
									$k ++;
								} else {
									$reservationpush [$k] ["response"] = "failed";
									$reservationpush [$k] ["text"] = "undferror";
									$reservationpush [$k] ["status"] = "new";
									$reservationpush [$k] ["hms_reservation_id"] = 0;
									$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
									$reservationpush [$k] ["dc_room_id"] = $reservations [$i] ["reservation"] ["category_id"];
									$result_array ["reservations"] [$key] [$i] ["status"] = "new";
									$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
									$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
									$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
									$k ++;
								}
							}
						}else{
							/*
							 * UPDATE RESERVATION BLOCK
							*
							*/
								
		
							$reservation_data = $this->frontdesk->GetReservation ( $hms_reservation_id );
		
							//$reservation_data ["user"] = $xml_array ["reservations"] [$dc_reservationid] ["room"] [$cell ["dc_roomreservation_id"]] ["reservation"] ["user"];
							$reservation_data ["firstname"] = $reservations [$i] ["guest"] ["firstname"];
							$reservation_data ["lastname"] = $reservations [$i] ["guest"] ["lastname"];
							$reservation_data ["phone"] = $reservations [$i] ["guest"] ["phone"];
							$reservation_data ["email"] = $reservations [$i] ["guest"] ["email"];
								
							$reservation_data ["amount"] = $reservations [$i] ["reservation"] ["amount"];
							$reservation_data ["discount"] = $reservations [$i] ["reservation"] ["discount"];
							$reservation_data ["date"] = $reservations [$i] ["reservation"] ["date"];
							$reservation_data ["add_places"] = $reservations [$i] ["reservation"] ["add_places"];
							$reservation_data ["baby_places"] = $reservations [$i] ["reservation"] ["baby_places"];
							$reservation_data ["datein"] = $reservations [$i] ["reservation"] ["datein"];
							$reservation_data ["dateout"] = $reservations [$i] ["reservation"] ["dateout"];
							$reservation_data ["checkintime"] = $reservations [$i] ["reservation"] ["checkintime"];
							$reservation_data ["checkouttime"] = $reservations [$i] ["reservation"] ["checkouttime"];
		
								
							//$reservation_data ["type_id"] = $reservations [$i] ["reservation"] ["type_id"];
							$reservation_data ["price_type"] = $reservations [$i] ["reservation"] ["price_type"];
							$reservation_data ["guest_id_new"] = 0;
							$reservation_data ["free_places"] = 0;
							$reservation_data ["maid_description"] = "";
							$reservation_data ["isread"] = 0;
							$reservation_data ["dc_guestname"] = $reservations [$i] ["reservation"] ["dc_guestname"];
							$reservation_data ["dc_currencycode"] = $reservations [$i] ["reservation"] ["dc_currencycode"];
							$reservation_data ["dc_countrycode"] = $reservations [$i] ["reservation"] ["dc_countrycode"];
							$reservation_data ["dc_city"] = $reservations [$i] ["reservation"] ["dc_city"];
							$reservation_data ["dc_customerremarks"] = $reservations [$i] ["reservation"] ["dc_customerremarks"];
							$reservation_data ["dc_roomremarks"] = $reservations [$i] ["reservation"] ["dc_roomremarks"];
							$reservation_data ["dc_numberofguest"] = $reservations [$i] ["reservation"] ["dc_numberofguest"];
							$reservation_data ["dc_totalprice"] = $reservations [$i] ["reservation"] ["dc_totalprice"];
							$reservation_data ["smoking"] = $reservations [$i] ["reservation"] ["smoking"];
								
							$reservation_data ["description"] = $reservations [$i] ["reservation"] ["dc_customerremarks"];
							
							$reservation_data ["dc_date"] = $reservations [$i] ["reservation"] ["dc_date"];
							$reservation_data ["dc_time"] = $reservations [$i] ["reservation"] ["dc_time"];
							$reservation_data ["dc_updatetime"] = $reservations [$i] ["reservation"] ["dc_updatetime"];
		
							// print_r($reservation_data);
								
							if ($reservation_data ["type_id"] == $type_id) {
								$can_resize = $this->frontdesk->qd_canresize($hms_reservation_id, $datein, $dateout );
							} else {
								$can_resize = 0;
								$reservation_data ["type_id"] = $type_id;
							}
								
							//$can_resize = $this->frontdesk->qd_canresize($hms_reservation_id, $datein, $dateout );
								
							if($can_resize == 1){
		
								$update_res = $this->frontdesk->UpdateReservation ( $reservation_data, 0, 1 );
		
								if(isset($otelms_rooms[$reservations [$i]["reservation"] ["dc_uuid"]])){
									$otelms_rooms[$reservations [$i]["reservation"] ["dc_uuid"]]["status"] = 1;
								}
								if ($update_res == "FreeError") {
									$reservationpush [$k] ["response"] = "error";
									$reservationpush [$k] ["text"] = "";
									$reservationpush [$k] ["status"] = "modified";
									$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
									$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = "";
									$result_array ["reservations"] [$key] [$i] ["status"] = "modified";
									$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
									$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
									$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["reservation"]["dc_reservationid"];
									$k ++;
								}else{
									$reservationpush [$k] ["response"] = "ok";
									$reservationpush [$k] ["text"] = "";
									$reservationpush [$k] ["alert"] = "";
									$reservationpush [$k] ["status"] = "modified";
									$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
									$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = "";
									$result_array ["reservations"] [$key] [$i] ["status"] = "modified";
									$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
									$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
									$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["reservation"]["dc_reservationid"];
									$k ++;
								}
							}else{
								if ($type_id == 0 or $type_id == "") {
									$query2 = $this->db->query ( "SELECT int_value FROM dc_101otel_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
									if ($query->num_rows () > 0) {
										$row2 = $query2->row ();
										$type_id = $row2->int_value;
									}
								}
								if ($type_id == 0 or $type_id == "") {
									$reservationpush [$k] ["response"] = "error";
									$reservationpush [$k] ["text"] = "UNKNOWN CATEGORY";
									$reservationpush [$k] ["status"] = "modified";
									$reservationpush [$k] ["hms_reservation_id"] = $row->id;
									$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
									$result_array ["reservations"] [$key] [$i] ["status"] = "modified";
									$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
									$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
									$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
									$k ++;
								} else {
									$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $type_id );
									if ($room_id == 0) {
											
										if (isset ( $overbooking_category_id )) {
											$reservations [$i] ["reservation"] ["origin_categoryid"] = $type_id;
											$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $overbooking_category_id );
		
											$insert_over_room_bool = 0;
											if ($room_id == 0) {
												$room_id = $this->dc_model->dc_make_overbooking_room ( $overbooking_category_id );
												$insert_over_room_bool = 1;
											}
										} else {
											$reservationpush [$k] ["response"] = "failed";
											$reservationpush [$k] ["text"] = "no overbooking_category_id";
											$reservationpush [$k] ["status"] = "new";
											$reservationpush [$k] ["hms_reservation_id"] = 0;
											$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
											$reservationpush [$k] ["dc_room_id"] = $reservations [$i] ["reservation"] ["category_id"];
											$result_array ["reservations"] [$key] [$i] ["status"] = "new";
											$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
											$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
											$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
										}
									}
									$reservation_data ["room_id"] = $room_id;
		
									$update_res = $this->frontdesk->UpdateReservation ( $reservation_data, 0, 1 );
										
									if(isset($otelms_rooms[$reservations [$i]["reservation"] ["dc_uuid"]])){
										$otelms_rooms[$reservations [$i]["reservation"] ["dc_uuid"]]["status"] = 1;
									}
		
									if ($update_res == "FreeError") {
										$reservationpush [$k] ["response"] = "error";
										$reservationpush [$k] ["text"] = "";
										$reservationpush [$k] ["status"] = "modified";
										$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
										$result_array ["reservations"] [$key] [$i] ["status"] = "modified";
										$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = "";
										$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
										$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
										$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["reservation"]["dc_reservationid"];
										$k ++;
									}else{
										$reservationpush [$k] ["response"] = "ok";
										$reservationpush [$k] ["text"] = "";
										$reservationpush [$k] ["alert"] = "";
										$reservationpush [$k] ["status"] = "modified";
										$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
										$result_array ["reservations"] [$key] [$i] ["status"] = "modified";
										$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = "";
										$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
										$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
										$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["reservation"]["dc_reservationid"];
										$k ++;
									}
								}
							}
						}
					}
					// }
				}
			}
				
			print_r ( $result_array );
			print_r ( $otelms_rooms );
			//die();
			foreach($otelms_rooms as $cell){
				if($cell["status"] == 0){
					//$this->frontdesk->DeleteReservation($cell["otelms_reservation_id"]);
					$status = 5;
					$data_cancel = array ();
					$data_cancel ["res_id"] = $cell["otelms_reservation_id"];
					$data_cancel ["charge"] = 0;
					$data_cancel ["status"] = $status;
					$data_cancel ["description"] = "cancel from hotels24";
					$data_cancel ["guestbe_request"] = 0;
					$data_cancel ["user"] = - 1;
					// ====================
					$this->Cancel->Insert ( $data_cancel );
				}
			}
				
			//die();
			$counter_r = 0;
			$hotel_name = "";
			$query = $this->db->query("SELECT * FROM logo");
			if ($query->num_rows() > 0) {
				$row = $query->row();
				$hotel_name = stripslashes($row->logo_title);
			}
			$new_mass = array ();
			foreach ( $result_array ["reservations"] as $cell ) {
				
				//print_r($cell);
				$res_count = count ( $cell );
				//echo "+++++++++++++++++++++++".$res_count;
				for($i = 0; $i < $res_count; $i ++) {
					if ($cell [$i] ["status"] == "modified" or $cell [$i] ["status"] == "new") {
						$new_mass ['dcname'] = "Hotels24";
						$new_mass ['status'] = $cell [$i] ["status"];
						$new_mass ['dc_reservationid'] = $cell [$i] ["reservation"]["dc_reservationid"];
						$new_mass ['dc_channel_name'] = "Hotels24";
						$new_mass ['hotel_name'] = $hotel_name;
						$new_mass ['guest_firstname'] = $cell [$i] ["guest"]  ["firstname"];
						$new_mass ['guest_lastname'] = $cell [$i] ["guest"]  ["lastname"];
						$new_mass ['guest_phone'] = $cell [$i] ["guest"] ["phone"];
						$new_mass ['guest_email'] = $cell [$i] ["guest"] ["email"];
		
						$new_mass ["room"] [$counter_r]["reservation_current"] = $i;
						$new_mass ["room"] [$counter_r]["reservation_alert"] = $cell [$i] ["reservation"] ["reservation_alert"];
						$new_mass ["room"] [$counter_r]["hms_reservation_id"] = $cell [$i] ["reservation"] ["hms_reservation_id"];
						$new_mass ["room"] [$counter_r]["url"] = $cell [$i] ["reservation"] ["url"];
						$new_mass ["room"] [$counter_r]["dc_channel_name"] = "Hotels24";
		
						$new_mass ["room"] [$counter_r]["reservation_dc_reservationid"] = $cell [$i] ["reservation"] ["dc_reservationid"];
						$new_mass ["room"] [$counter_r]["reservation_dc_roomreservation_id"] = $cell [$i] ["reservation"] ["dc_roomreservation_id"];
						$new_mass ["room"] [$counter_r]["hotel_name"] = "hotel_name";
						$new_mass ["room"] [$counter_r]["reservation_date"] = $cell [$i] ["reservation"]["date"];
						$new_mass ["room"] [$counter_r]["status"] = $cell [$i] ["status"];
						$new_mass ["room"] [$counter_r]["reservation_datein"] = $cell [$i] ["reservation"]["datein"];
						$new_mass ["room"] [$counter_r]["reservation_dateout"] = $cell [$i] ["reservation"]["dateout"];
						$new_mass ["room"] [$counter_r]["reservation_type_name"] = $cell [$i] ["reservation"]["reservation_type_name"];
						$new_mass ["room"] [$counter_r]["reservation_category_id"] = $cell [$i] ["reservation"]["type_id"];
						$new_mass ["room"] [$counter_r]["reservation_dc_totalprice"] = $cell [$i] ["reservation"]["dc_totalprice"];
						$new_mass ["room"] [$counter_r]["reservation_dc_customerremarks"] = $cell [$i] ["reservation"]["dc_customerremarks"];
		
						$new_mass ["room"] [$counter_r]["dc_rate_intdate_data"] = $cell [$i] ["per_day"];
		
						$counter_r++;
					}
				}
		
			}
			if(count($new_mass) > 0){
				//print_r($new_mass);
				$this->dc_model->send_notifyarray_new ( $new_mass );
			}
				
		}
		
		print_r ( $reservationpush );
		foreach ( $reservationpush as $arg ) {
			if ($arg ['status'] == "cancel") {
				$data = array ();
				$data ["hms_reservation_id"] = $arg ["hms_reservation_id"];
				$data ['response'] = $arg ['response'];
				$data ['resid'] = $arg ['dc_reservationid'];
				$data ['dcname'] = "Hotels24";
				$data ['status'] = $arg ['status'];
				$data ['text'] = $arg ['text'];
				$this->dc_model->send_notifyarray ( $data );
			}
		}
	}
	function dc_rate_intdate_insert($data) {
		$count = count ( $data );
		if ($count != 0) {
			foreach ( $data as $cell ) {
				$query = $this->db->query ( "DELETE FROM dc_hotels24_rate_intdate WHERE dc_reservation_id LIKE '" . $cell ["dc_reservation_id"]."'" );
				break;
			}
			foreach ( $data as $cell ) {
				$sql = "INSERT INTO dc_hotels24_rate_intdate (dc_reservation_id, dc_rate_id, intdate, price) VALUES('" . $cell ["dc_reservation_id"] . "',
		'" . $cell ["dc_rate_id"] . "', '" . $cell ["intdate"] . "', '" . $cell ["price"] . "')
		ON DUPLICATE KEY UPDATE price = '" . $cell ["price"] . "'";
				// echo $sql;
				$query = $this->db->query ( $sql );
			}
		}
	}
}