<?php
class dcm_hostelworld extends CI_Model {
	function __construct() {
		parent::__construct ();
		if (isset($GLOBALS['cron_last_changed'])) {
		
		} else {
		  $this->load->model ( 'Cancel' );
		  $this->load->model ( 'frontdesk' );
		  $this->load->model ( 'dc_model' );
		}
	}
	function getauthparam() {
		$data = array ();
		$sql = "SELECT * FROM dc_hostelworld_xml_cfg";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				switch ($row->name) {
					case "dealer_id" :
						$data [$row->name] = $row->int_value;
						break;
					case "overbooking_category_id" :
						$data [$row->name] = $row->int_value;
						break;
					case "hotel_id" :
						$data [$row->name] = $row->int_value;
						break;
					case "general_update" :
						$data [$row->name] = $row->int_value;
						break;
					case "test_access" :
						$data [$row->name] = $row->int_value;
						break;
					case "prop_pass" :
						$data [$row->name] = $row->str_value;
						break;
					case "currency" :
						$data [$row->name] = $row->str_value;
						break;
				}
			}
		}
		
		$data ["consumer_key"] = $this->config->item ( 'hw_consumer_key' );
		$data ["secret"] = $this->config->item ( 'hw_secret' );
		$data ["consumer_signature"] = sha1($this->config->item ( 'hw_consumer_key' ) . "--" . $this->config->item ( 'hw_secret' ) . "--" . $data ["prop_pass"]);
		$data ["url"] = 'https://property.xsapi.webresint.com';
		return $data;
	}
	function get_rate() {
		$rate_id = 1;
		$query = $this->db->query ( "SELECT hms_rate_id FROM dc_hostelworld_rate_link" );
		
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			if($row->hms_rate_id > 0){
			     $rate_id = $row->hms_rate_id;
			}
		}
		return $rate_id;
	}
	function getrateavail_rates_new($datein_int, $dateout_int, $upload_type) {
	    if ($datein_int == 0 || $dateout_int == 0) {
	        $result = array ();
	        $result ["rates"] = array();
	        $result ["last_id"] = 0;
	        return $result;
	    }
		$overbooking_reservations_array = array ();
		if (isset ( $datein_out_mass ["intdatein"] )) {
			$overbooking_reservations_array = $this->dc_model->get_overbooking_origincat ( $datein_int, $dateout_int );
		}
		
		$categories_rooms_all = array ();
		$sql = "SELECT dc_hostelworld_room_categories_link.dc_category_id, categories.id, COUNT(rooms.id) as count_rooms FROM `rooms`
		INNER JOIN categories ON categories.id = rooms.category_id
	
		INNER JOIN  dc_hostelworld_room_categories_link ON  dc_hostelworld_room_categories_link.hms_category_id = categories.id
		WHERE rooms.dc_active=1 AND categories.is_active=1 GROUP BY rooms.category_id";
		// echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				
				if (isset ( $datein_int )) {
					for($i = $datein_int; $i <= $dateout_int; $i ++) {
						$categories_rooms_all [$row->dc_category_id] [$i] ["free"] = $row->count_rooms;
						$categories_rooms_all [$row->dc_category_id] [$i] ["date"] = gmdate ( "Y-m-d", $i * 86400 );
					}
				}
			}
		}
		
		$deskofdays_restricted = array ();
		$sql = "SELECT * FROM deskofrate";
		// echo $sql;
		// die();
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$deskofdays_restricted [$row->category_id] [$row->rate_id] [$row->intdate] ["closed"] = $row->closed;
				// $deskofdays_restricted [$row->category_id]
				// [$row->rate_id] [$row->intdate] ["closedonarrival"] =
				// $row->closedonarrival;
			}
		}
		
		
		$rate_id = 1;
		$rate_id = $this->get_rate ();
		$categories_beds = array ();
		
		$sql = "SELECT IF( baseplace> 0, baseplace, categories.places) as occupancy, categories.id FROM rate
		INNER JOIN seasonspricelist ON seasonspricelist.rate_id = rate.id
		INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
		INNER JOIN deskofdaysseason ON seasons.id = deskofdaysseason.seasonid
		INNER JOIN categories ON categories.id = seasonspricelist.category_id
		INNER JOIN ratetocategory ON ratetocategory.rate_id = rate.id AND ratetocategory.category_id = categories.id
		INNER JOIN dc_hostelworld_room_categories_link ON categories.id = dc_hostelworld_room_categories_link.hms_category_id
		WHERE categories.is_active =1
		AND seasons.is_active =1
		AND rate.id = $rate_id
		AND deskofdaysseason.intdate >=$datein_int
		AND deskofdaysseason.intdate <=$dateout_int
		ORDER BY seasonspricelist.category_id, intdate";
		//echo $sql;
		// die();
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$categories_beds [$row->id] = $row->occupancy;
			}
		}
		// echo "<pre>";
		// print_r ( $categories_rooms_all );
		// die();
		$rates = array ();
		
		$rate_strategy = 0;
		$query = $this->db->query ( "SELECT value FROM hotelix_config WHERE name LIKE 'rate_strategy'" );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$rate_strategy = $row->value;
		}
		
		$restrict_id = 0;
		$query = $this->db->query ( "SELECT restrict_id FROM dc_hostelworld_rate_link " );
		
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$restrict_id = $row->restrict_id;
		}
		
		$min = 0;
		$max = 999;
		switch ($upload_type) {
			case "y" :
				$sql = "SELECT count(deskofdays.room_id) as reserved_rooms_count, categories.id as hms_cat_id, dc_log_yieldprice.id, dc_hostelworld_room_categories_link.dc_category_id as dc_room_id, dc_log_yieldprice.dc_id, dc_log_yieldprice.intdate, yieldprice.price as yield_price,
		yieldprice.singleuseprice as yield_singleuse_price,
		seasonspricelist.rate_id, seasonspricelist.category_id, seasonspricelist.price, seasonspricelist.price1, seasonspricelist.price2,
		seasonspricelist.price3, seasonspricelist.price4, seasonspricelist.price5, seasonspricelist.price6, seasonspricelist.price7,
		    seasonspricelist.singleuse_price, seasonspricelist.singleuse_price1, seasonspricelist.singleuse_price2,
		seasonspricelist.singleuse_price3, seasonspricelist.singleuse_price4, seasonspricelist.singleuse_price5, seasonspricelist.singleuse_price6, seasonspricelist.singleuse_price7
		FROM dc_log_yieldprice
				    INNER JOIN dc_hostelworld_rate_link ON dc_hostelworld_rate_link.hms_rate_id = dc_log_yieldprice.rate_id
		INNER JOIN dc_hostelworld_room_categories_link ON dc_hostelworld_room_categories_link.hms_category_id = dc_log_yieldprice.categoryid
		INNER JOIN categories ON categories.id = dc_hostelworld_room_categories_link.hms_category_id
		INNER JOIN rooms ON rooms.category_id = categories.id
		LEFT JOIN deskofdaysseason ON deskofdaysseason.intdate = dc_log_yieldprice.intdate
		LEFT JOIN seasonspricelist ON (seasonspricelist.rate_id = dc_log_yieldprice.rate_id AND seasonspricelist.category_id = dc_log_yieldprice.categoryid AND seasonspricelist.season_id = deskofdaysseason.seasonid)
		LEFT JOIN yieldprice ON (yieldprice.id_restrict_rate = dc_log_yieldprice.rate_id AND yieldprice.category_id = dc_log_yieldprice.categoryid AND yieldprice.intdate = dc_log_yieldprice.intdate)
		LEFT JOIN deskofdays ON deskofdays.room_id = rooms.id AND deskofdays.intdate= dc_log_yieldprice.intdate
		WHERE dc_log_yieldprice.dc_id = 8 GROUP BY dc_log_yieldprice.intdate ORDER BY dc_log_yieldprice.id";
				break;
			case "r" :
				$sql = "SELECT dc_log_rate.id, count(deskofdays.room_id) as reserved_rooms_count, categories.id as hms_cat_id, dc_log_rate.id, dc_hostelworld_room_categories_link.dc_category_id as dc_room_id, dc_log_rate.dc_id, dc_log_rate.intdate, yieldprice.price as yield_price,
		yieldprice.singleuseprice as yield_singleuse_price,
		seasonspricelist.rate_id, seasonspricelist.category_id, seasonspricelist.price, seasonspricelist.price1, seasonspricelist.price2,
		seasonspricelist.price3, seasonspricelist.price4, seasonspricelist.price5, seasonspricelist.price6, seasonspricelist.price7,
		    seasonspricelist.singleuse_price, seasonspricelist.singleuse_price1, seasonspricelist.singleuse_price2,
		seasonspricelist.singleuse_price3, seasonspricelist.singleuse_price4, seasonspricelist.singleuse_price5, seasonspricelist.singleuse_price6, seasonspricelist.singleuse_price7
		FROM (select * FROM dc_log_rate
				    INNER JOIN dc_hostelworld_rate_link ON dc_hostelworld_rate_link.hms_rate_id = dc_log_rate.rate_id
				    WHERE dc_log_rate.dc_id = 8 
				    ORDER BY dc_log_rate.id LIMIT 100) as dc_log_rate
		INNER JOIN dc_hostelworld_rate_link ON dc_hostelworld_rate_link.hms_rate_id = dc_log_rate.rate_id
		LEFT JOIN deskofdaysseason ON deskofdaysseason.intdate = dc_log_rate.intdate
		LEFT JOIN seasonspricelist ON (seasonspricelist.rate_id = dc_log_rate.rate_id AND seasonspricelist.season_id = deskofdaysseason.seasonid)
		INNER JOIN dc_hostelworld_room_categories_link ON dc_hostelworld_room_categories_link.hms_category_id = seasonspricelist.category_id
		INNER JOIN categories ON categories.id = dc_hostelworld_room_categories_link.hms_category_id
		INNER JOIN rooms ON rooms.category_id = categories.id
		LEFT JOIN yieldprice ON (yieldprice.id_restrict_rate = dc_log_rate.rate_id AND dc_hostelworld_room_categories_link.hms_category_id = yieldprice.category_id AND yieldprice.intdate = dc_log_rate.intdate)
		LEFT JOIN deskofdays ON deskofdays.room_id = rooms.id AND deskofdays.intdate= dc_log_rate.intdate
		WHERE dc_log_rate.dc_id = 8 GROUP BY categories.id, dc_log_rate.intdate ORDER BY dc_log_rate.id";
				break;
		}
		
		//echo $sql;
		
		$last_id = 0;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				if ($rate_strategy == 2) {
					$row->intdatentdate_week = gmdate ( "w", $row->intdate * 86400 );
					switch ($row->intdatentdate_week) {
						case 0 :
							$price = $row->price7;
							break;
						case 1 :
							$price = $row->price1;
							break;
						case 2 :
							$price = $row->price2;
							break;
						case 3 :
							$price = $row->price3;
							break;
						case 4 :
							$price = $row->price4;
							break;
						case 5 :
							$price = $row->price5;
							break;
						case 6 :
							$price = $row->price6;
							break;
					}
				} else {
					$price = $row->price;
				}
				
				if ($row->yield_price > 0) {
					$price = $row->yield_price;
				}
				$date = gmdate ( "Y-m-d", $row->intdate * 86400 );
				$free_count = 0;
				$count_overbook_rooms = 0;
				if (isset ( $overbooking_reservations_array [$row->hms_cat_id] [$row->intdate] )) {
					$count_overbook_rooms = $overbooking_reservations_array [$row->hms_cat_id] [$row->intdate];
				}
				$free_count = $categories_rooms_all [$row->dc_room_id] [$row->intdate] ["free"] - ($row->reserved_rooms_count + $count_overbook_rooms);
				// echo "-";
				$rates [$row->hms_cat_id] [$row->intdate] ['places'] = $categories_beds [$row->hms_cat_id];
				$rates [$row->hms_cat_id] [$row->intdate] ["dc_category_id"] = $row->dc_room_id;
				$rates [$row->hms_cat_id] [$row->intdate] ["date_start"] = $date;
				$rates [$row->hms_cat_id] [$row->intdate] ["date_end"] = $date;
				if($price <> 0){
					$rates [$row->hms_cat_id] [$row->intdate] ["price"] = $this->frontdesk->dc_currency ( $price / $rates [$row->hms_cat_id] [$row->intdate] ['places'] );
					$rates [$row->hms_cat_id] [$row->intdate] ["price22"] = $price;
				}else{
					$rates [$row->hms_cat_id] [$row->intdate] ["price"] = 0;
				}
				
				$rates [$row->hms_cat_id] [$row->intdate] ["count"] = $free_count;
				
				if (isset ( $deskofdays_restricted [$row->hms_cat_id] [$restrict_id] [$row->intdate] ["closed"] )) {
					if ($deskofdays_restricted [$row->hms_cat_id] [$restrict_id] [$row->intdate] ["closed"] == 1) {
						$rates [$row->hms_cat_id] [$row->intdate] ["count"] = 0;
					}
				}
					
				
				
				$rates [$row->hms_cat_id] [$row->intdate] ["beds"] = $rates [$row->hms_cat_id] [$row->intdate] ["count"] * $rates [$row->hms_cat_id] [$row->intdate] ['places'];
				
				$last_id = $row->id;
			}
		}
		
		$categories_rooms_all_new = $rates;
		
		$category_keys = array_keys ( $categories_rooms_all_new );
		/*$roomsresult = array ();
		foreach ( $category_keys as $category_id ) {
			for($i = $intdatein; $i <= $intdateout; $i ++) {
				if (isset ( $categories_rooms_all_new [$category_id] [$i] ))
					array_push ( $roomsresult, $categories_rooms_all_new [$category_id] [$i] );
			}
		}
		*/
		$result_mass = array ();
		$k = 0;
		foreach ( $category_keys as $category_id ) {
			for($i = $datein_int; $i <= $dateout_int; $i ++) {
				if (isset ( $categories_rooms_all_new [$category_id] [$i] )) {
					$dc_category_id = $categories_rooms_all_new [$category_id] [$i] ["dc_category_id"];
					$result_mass [$dc_category_id] ["dc_category_id"] = $dc_category_id;
					$result_mass [$dc_category_id] ["range"] [$k] = $categories_rooms_all_new [$category_id] [$i];
					$k ++;
				}
			}
		}
		
		$result = array ();
		$result ["rates"] = $result_mass;
		$result ["last_id"] = $last_id;
		return $result;
	}
	function getrateavail_rates($datein, $dateout, $restrict = 1) {
		list ( $year, $month, $day ) = explode ( "-", $datein );
		$intdatein = floor ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		list ( $year, $month, $day ) = explode ( "-", $dateout );
		$intdateout = floor ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		
		$rate_strategy = $this->frontdesk->GetRateStrategy ();
		
		$inttoday = floor ( gmmktime () / 86400 );
		
		if ($intdatein < $inttoday)
			$intdatein = $inttoday;
			
			// get rate from rate_link
		$rate_id = 1;
		$rate_id = $this->get_rate ();
		
		// fill array with occupied rooms
		
		$categories_beds = array ();
		$sql = "SELECT id, places
		FROM `categories`
		";
		$sql = "SELECT IF( baseplace> 0, baseplace, categories.places) as occupancy, categories.id FROM rate
		INNER JOIN seasonspricelist ON seasonspricelist.rate_id = rate.id
		INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
		INNER JOIN deskofdaysseason ON seasons.id = deskofdaysseason.seasonid
		INNER JOIN categories ON categories.id = seasonspricelist.category_id
		INNER JOIN ratetocategory ON ratetocategory.rate_id = rate.id AND ratetocategory.category_id = categories.id
		INNER JOIN dc_hostelworld_room_categories_link ON categories.id = dc_hostelworld_room_categories_link.hms_category_id
		WHERE categories.is_active = 1
		AND seasons.is_active = 1
		AND rate.id = $rate_id
		AND deskofdaysseason.intdate >=$intdatein
		AND deskofdaysseason.intdate <=$intdateout
		ORDER BY seasonspricelist.category_id, intdate";
		// echo $sql;
		// die();
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$categories_beds [$row->id] = $row->occupancy;
			}
		}
		
		$min_date = 0;
		$max_date = 0;
		$categories_rooms_all = array ();
		$data_return = array ();
		// $intdate_today = floor ( time () / 86400 );
		$last_id = 0;
		$sql = "SELECT dc_log_yieldprice.id as dc_log_id, categories.id as category_id, dc_log_yieldprice.intdate as log_intdate, COUNT(rooms.id) as count_rooms  FROM categories
				INNER JOIN dc_hostelworld_room_categories_link ON dc_hostelworld_room_categories_link.hms_category_id = categories.id
				INNER JOIN dc_log_yieldprice ON dc_log_yieldprice.categoryid = categories.id
				INNER JOIN rooms ON rooms.category_id = categories.id
				WHERE rooms.dc_active=1 AND dc_log_yieldprice.dc_id = 8 
					GROUP BY dc_log_yieldprice.categoryid, dc_log_yieldprice.intdate";
		$query = $this->db->query ( $sql );
		// echo $sql;
		// echo "start wait\n";
		// sleep(15);
		// echo "done wait\n";
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				// count_rooms_booking
				if ($min_date == 0) {
					$min_date = $row->log_intdate;
				} else {
					if ($row->log_intdate < $min_date) {
						$min_date = $row->log_intdate;
					}
				}
				
				if ($max_date == 0) {
					$max_date = $row->log_intdate;
				} else {
					if ($row->log_intdate > $max_date) {
						$max_date = $row->log_intdate;
					}
				}
				
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["free"] = $row->count_rooms;
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["date"] = date ( "Y-m-d", $row->log_intdate * 86400 );
				// $last_id = $row->dc_log_id;
				if ($row->dc_log_id > $last_id) {
					$last_id = $row->dc_log_id;
				}
			}
		} else {
			$data_return ["rates"] = array ();
			$data_return ["last_id"] = 0;
			$data_return ["response"] = 3;
			return $data_return;
		}
		
		$rooms_occupied = array ();
		$sql = "SELECT categories.id AS hms_category_id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
			FROM `rooms`
			INNER JOIN categories ON categories.id = rooms.category_id
			INNER JOIN dc_hostelworld_room_categories_link ON dc_hostelworld_room_categories_link.hms_category_id = categories.id
			INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
			WHERE deskofdays.intdate >= $intdatein AND deskofdays.intdate <= $intdateout
			GROUP BY deskofdays.intdate, rooms.category_id";
		// echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$rooms_occupied [$row->hms_category_id] [$row->intdate] = $row->count_rooms;
			}
		}
		
		$rooms_occupied_overbook = $this->dc_model->get_overbooking_origincat ( $intdatein, $intdateout );
		$datein_out_mass = $this->dc_model->get_datein_dateout_dc_log ( 8 );
		// echo "<pre>";
		// print_r ( $datein_out_mass );
		// print_r ( $rooms_occupied );
		if (isset ( $datein_out_mass ["intdatein"] )) {
			$rooms_occupied_overbook = $this->dc_model->get_overbooking_origincat ( $datein_out_mass ["intdatein"], $datein_out_mass ["intdateout"] );
		}
		
		// fill yeld price
		$rooms_yield = array ();
		$sql = "SELECT category_id as hms_category_id, intdate, price FROM yieldprice  WHERE id_restrict_rate=$rate_id AND
		intdate >= $intdatein AND intdate <= $intdateout";
		// echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$rooms_yield [$row->hms_category_id] [$row->intdate] = $row->price;
			}
		}
		
		$deskof_restrictedprice = array ();
		
		$sql = "SELECT intdate, id_restrict_rate, category_id, price, singleuseprice
				FROM yieldprice WHERE  intdate >= $intdatein AND intdate <= $intdateout ";
		// echo $sql;
		// die();
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["price"] = $row->price;
				$deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["singleuseprice"] = $row->singleuseprice;
			}
		}
		
		$deskofdays_restricted = array ();
		if ($restrict == 1) {
			
			$sql = "SELECT * FROM deskofrate";
			// echo $sql;
			// die();
			$query = $this->db->query ( $sql );
			if ($query->num_rows () > 0) {
				foreach ( $query->result () as $row ) {
					$deskofdays_restricted [$row->category_id] [$row->rate_id] [$row->intdate] ["closed"] = $row->closed;
					// $deskofdays_restricted [$row->category_id]
					// [$row->rate_id] [$row->intdate] ["closedonarrival"] =
					// $row->closedonarrival;
				}
			}
		}
		// echo "<pre>";
		// print_r($deskofdays_restricted);
		// die();
		$restrict_id = 0;
		$query = $this->db->query ( "SELECT restrict_id FROM dc_hostelworld_rate_link " );
		
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$restrict_id = $row->restrict_id;
		}
		// echo $rate_strategy;
		// fill array with perday price
		$rooms_price = array ();
		$sql = "SELECT seasonspricelist.rate_id, categories.id AS hms_category_id,deskofdaysseason.intdate, categories.base_price, seasonspricelist.price, seasonspricelist.price1, seasonspricelist.price2,
	seasonspricelist.price3, seasonspricelist.price4, seasonspricelist.price5,
	seasonspricelist.price6, seasonspricelist.price7,
	seasonspricelist.singleuse_price, seasonspricelist.singleuse_price1, seasonspricelist.singleuse_price2,
	seasonspricelist.singleuse_price3, seasonspricelist.singleuse_price4, seasonspricelist.singleuse_price5,
	seasonspricelist.singleuse_price6, seasonspricelist.singleuse_price7
	
	FROM rate
	INNER JOIN seasonspricelist ON seasonspricelist.rate_id = rate.id
	INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
	INNER JOIN deskofdaysseason ON seasons.id = deskofdaysseason.seasonid
	INNER JOIN categories ON categories.id = seasonspricelist.category_id
	INNER JOIN dc_hostelworld_room_categories_link ON categories.id = dc_hostelworld_room_categories_link.hms_category_id
	WHERE categories.is_active =1
	AND seasons.is_active =1
	AND rate.id = $rate_id
	AND deskofdaysseason.intdate >=$intdatein
	AND deskofdaysseason.intdate <=$intdateout
	ORDER BY category_id, intdate";
		// echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price;
			}
		}
		
		// echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$rooms_price [$row->hms_category_id] [$row->intdate] = $row->base_price;
				
				$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price;
				
				$week_day = date ( "w", $row->intdate * 86400 );
				$price = 0;
				
				// if ($restrict_id != 0) {
				
				if (isset ( $deskof_restrictedprice [$row->hms_category_id] [$row->rate_id] [$row->intdate] ["price"] )) {
					$price = $deskof_restrictedprice [$row->hms_category_id] [$row->rate_id] [$row->intdate] ["price"];
					
					$rooms_price [$row->hms_category_id] [$row->intdate] = $price;
				} 				// }
				else {
					switch ($rate_strategy) {
						case 1 :
							$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price;
							
							break;
						case 2 :
							switch ($week_day) {
								case 1 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price1;
									
									break;
								case 2 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price2;
									
									break;
								case 3 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price3;
									
									break;
								case 4 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price4;
									
									break;
								case 5 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price5;
									
									break;
								case 6 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price6;
									
									break;
								case 0 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price7;
									
									break;
							}
							break;
					}
				}
			}
		}
		
		$dc_rooms = array ();
		$result = array ();
		$category_keys = array_keys ( $categories_rooms_all );
		foreach ( $category_keys as $category_id ) {
			
			$sql = "select * from dc_hostelworld_room_categories_link where hms_category_id =" . $category_id;
			$query = $this->db->query ( $sql );
			if ($query->num_rows () > 0) {
				$row2 = $query->row ();
				$min = $row2->min;
				$max = $row2->max;
			} else {
				$min = 0;
				$max = 999;
			}
			
			$arr_intdate_keys = array_keys ( $categories_rooms_all [$category_id] );
			foreach ( $arr_intdate_keys as $intdate ) {
				$dc_rooms [$category_id] [$intdate] ['places'] = $categories_beds [$category_id];
				$dc_rooms [$category_id] [$intdate] ["dc_category_id"] = $row2->dc_category_id;
				$dc_rooms [$category_id] [$intdate] ["date_start"] = gmdate ( "Y-m-d", $intdate * 86400 );
				$dc_rooms [$category_id] [$intdate] ["date_end"] = gmdate ( "Y-m-d", $intdate * 86400 );
				$dc_rooms [$category_id] [$intdate] ["count"] = $categories_rooms_all [$category_id] [$intdate] ["free"];
				if (isset ( $rooms_occupied [$category_id] [$intdate] )) {
					$dc_rooms [$category_id] [$intdate] ["count"] -= $rooms_occupied [$category_id] [$intdate];
				}
				if (isset ( $rooms_occupied_overbook [$category_id] [$intdate] )) {
					$dc_rooms [$category_id] [$intdate] ["count"] -= $rooms_occupied_overbook [$category_id] [$intdate];
				}
				if ($dc_rooms [$category_id] [$intdate] ["count"] < 0) {
					$dc_rooms [$category_id] [$intdate] ["count"] = 0;
				}
				
				// Параметры загружености
				
				if ($dc_rooms [$category_id] [$intdate] ["count"] > $min) {
					$dc_rooms [$category_id] [$intdate] ["count"] = $dc_rooms [$category_id] [$intdate] ["count"] - $min;
				} else {
					$dc_rooms [$category_id] [$intdate] ["count"] = 0;
				}
				
				if ($dc_rooms [$category_id] [$intdate] ["count"] > $max) {
					$dc_rooms [$category_id] [$intdate] ["count"] = $max;
				}
				
				if ($restrict == 1) {
					if (isset ( $deskofdays_restricted [$category_id] [$restrict_id] [$intdate] ["closed"] )) {
						if ($deskofdays_restricted [$category_id] [$restrict_id] [$intdate] ["closed"] == 1) {
							$dc_rooms [$category_id] [$intdate] ["count"] = 0;
						}
					}
					
					// if (isset($deskofdays_restricted
					// [$category_id] [$restrict_id] [$intdate]
					// ["closedonarrival"])){
					// $dc_rooms [$category_id] [$intdate] ["count"] = 0;
					// }
				}
				
				// END Параметры загружености
				$dc_rooms [$category_id] [$intdate] ["beds"] = $dc_rooms [$category_id] [$intdate] ["count"] * $dc_rooms [$category_id] [$intdate] ['places'];
				if (isset ( $rooms_price [$category_id] [$intdate] )) {
					$dc_rooms [$category_id] [$intdate] ['price'] = $this->frontdesk->dc_currency ( $rooms_price [$category_id] [$intdate] / $dc_rooms [$category_id] [$intdate] ['places'] );
					$dc_rooms [$category_id] [$intdate] ['price22'] = $rooms_price [$category_id] [$intdate];
				} else {
					$dc_rooms [$category_id] [$intdate] ['price'] = 0;
				}
				/*
				 * if (isset ( $rooms_yield [$category_id] [$intdate] )) { $dc_rooms [$category_id] [$intdate] ['price'] = $rooms_yield [$category_id] [$intdate]; }
				 */
				
				// array_push ( $result, $dc_rooms [$category_id]
				// [$intdate] );
			}
		}
		
		$categories_rooms_all_new = $dc_rooms;
		
		$category_keys = array_keys ( $categories_rooms_all_new );
		$roomsresult = array ();
		foreach ( $category_keys as $category_id ) {
			for($i = $intdatein; $i <= $intdateout; $i ++) {
				if (isset ( $categories_rooms_all_new [$category_id] [$i] ))
					array_push ( $roomsresult, $categories_rooms_all_new [$category_id] [$i] );
			}
		}
		
		$result_mass = array ();
		$k = 0;
		foreach ( $category_keys as $category_id ) {
			for($i = $intdatein; $i <= $intdateout; $i ++) {
				if (isset ( $categories_rooms_all_new [$category_id] [$i] )) {
					$dc_category_id = $categories_rooms_all_new [$category_id] [$i] ["dc_category_id"];
					$result_mass [$dc_category_id] ["dc_category_id"] = $dc_category_id;
					$result_mass [$dc_category_id] ["range"] [$k] = $categories_rooms_all_new [$category_id] [$i];
					$k ++;
				}
			}
		}
		
		// echo "<pre>";
		// print_r($roomsresult);
		// die();
		$result = array ();
		$result ["rates"] = $result_mass;
		$result ["last_id"] = $last_id;
		return $result;
	}
	function getrateavail_2($datein, $dateout, $restrict = 1) {
		list ( $year, $month, $day ) = explode ( "-", $datein );
		$intdatein = floor ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		list ( $year, $month, $day ) = explode ( "-", $dateout );
		$intdateout = floor ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		
		$rate_strategy = $this->frontdesk->GetRateStrategy ();
		
		$inttoday = floor ( gmmktime () / 86400 );
		
		if ($intdatein < $inttoday)
			$intdatein = $inttoday;
			
			// get rate from rate_link
		$rate_id = 1;
		$rate_id = $this->get_rate ();
		
		// fill array with occupied rooms
		
		$categories_beds = array ();
		$sql = "SELECT id, places
		FROM `categories`
		";
		$sql = "SELECT IF( baseplace> 0, baseplace, categories.places) as occupancy, categories.id FROM rate
		INNER JOIN seasonspricelist ON seasonspricelist.rate_id = rate.id
		INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
		INNER JOIN deskofdaysseason ON seasons.id = deskofdaysseason.seasonid
		INNER JOIN categories ON categories.id = seasonspricelist.category_id
		INNER JOIN ratetocategory ON ratetocategory.rate_id = rate.id AND ratetocategory.category_id = categories.id
		INNER JOIN dc_hostelworld_room_categories_link ON categories.id = dc_hostelworld_room_categories_link.hms_category_id
		WHERE categories.is_active =1
		AND seasons.is_active =1
		AND rate.id = $rate_id
		AND deskofdaysseason.intdate >=$intdatein
		AND deskofdaysseason.intdate <=$intdateout
		ORDER BY seasonspricelist.category_id, intdate";
		// echo $sql;
		// die();
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$categories_beds [$row->id] = $row->occupancy;
			}
		}
		
		$min_date = 0;
		$max_date = 0;
		$categories_rooms_all = array ();
		$data_return = array ();
		$intdate_today = floor ( time () / 86400 );
		$last_id = 0;
		$sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms  FROM categories
				INNER JOIN dc_hostelworld_room_categories_link ON dc_hostelworld_room_categories_link.hms_category_id = categories.id
				INNER JOIN dc_log ON dc_log.categoryid = categories.id
				INNER JOIN rooms ON rooms.category_id = categories.id
				WHERE rooms.dc_active=1 AND dc_log.dc_id = 8 AND dc_log.intdate >= " . $intdate_today . "
				GROUP BY dc_log.categoryid, dc_log.intdate";
		$query = $this->db->query ( $sql );
		// echo $sql;
		// echo "start wait\n";
		// sleep(15);
		// echo "done wait\n";
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				// count_rooms_booking
				if ($min_date == 0) {
					$min_date = $row->log_intdate;
				} else {
					if ($row->log_intdate < $min_date) {
						$min_date = $row->log_intdate;
					}
				}
				
				if ($max_date == 0) {
					$max_date = $row->log_intdate;
				} else {
					if ($row->log_intdate > $max_date) {
						$max_date = $row->log_intdate;
					}
				}
				
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["free"] = $row->count_rooms;
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["date"] = date ( "Y-m-d", $row->log_intdate * 86400 );
				// $last_id = $row->dc_log_id;
				if ($row->dc_log_id > $last_id) {
					$last_id = $row->dc_log_id;
				}
			}
		} else {
			$data_return ["response"] = 3;
			return $data_return;
		}
		
		$rooms_occupied = array ();
		$sql = "SELECT categories.id AS hms_category_id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
		FROM `rooms`
		INNER JOIN categories ON categories.id = rooms.category_id
		INNER JOIN dc_hostelworld_room_categories_link ON dc_hostelworld_room_categories_link.hms_category_id = categories.id
		INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
		WHERE deskofdays.intdate >= $intdatein AND deskofdays.intdate <= $intdateout
		GROUP BY deskofdays.intdate, rooms.category_id";
		// echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$rooms_occupied [$row->hms_category_id] [$row->intdate] = $row->count_rooms;
			}
		}
		
		$rooms_occupied_overbook = $this->dc_model->get_overbooking_origincat ( $intdatein, $intdateout );
		$datein_out_mass = $this->dc_model->get_datein_dateout_dc_log ( 8 );
		// echo "<pre>";
		// print_r ( $datein_out_mass );
		// print_r ( $rooms_occupied );
		if (isset ( $datein_out_mass ["intdatein"] )) {
			$rooms_occupied_overbook = $this->dc_model->get_overbooking_origincat ( $datein_out_mass ["intdatein"], $datein_out_mass ["intdateout"] );
		}
		
		// fill yeld price
		$rooms_yield = array ();
		$sql = "SELECT category_id as hms_category_id, intdate, price FROM yieldprice  WHERE id_restrict_rate=$rate_id AND
			intdate >= $intdatein AND intdate <= $intdateout";
		// echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$rooms_yield [$row->hms_category_id] [$row->intdate] = $row->price;
			}
		}
		
		$deskof_restrictedprice = array ();
		
		$sql = "SELECT intdate, id_restrict_rate, category_id, price, singleuseprice
			FROM yieldprice WHERE  intdate >= $intdatein AND intdate <= $intdateout ";
		// echo $sql;
		// die();
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["price"] = $row->price;
				$deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["singleuseprice"] = $row->singleuseprice;
			}
		}
		
		$deskofdays_restricted = array ();
		if ($restrict == 1) {
			
			$sql = "SELECT * FROM deskofrate";
			// echo $sql;
			// die();
			$query = $this->db->query ( $sql );
			if ($query->num_rows () > 0) {
				foreach ( $query->result () as $row ) {
					$deskofdays_restricted [$row->category_id] [$row->rate_id] [$row->intdate] ["closed"] = $row->closed;
					// $deskofdays_restricted [$row->category_id]
					// [$row->rate_id] [$row->intdate] ["closedonarrival"] =
					// $row->closedonarrival;
				}
			}
		}
		// echo "<pre>";
		// print_r($deskofdays_restricted);
		// die();
		$restrict_id = 0;
		$query = $this->db->query ( "SELECT restrict_id FROM dc_hostelworld_rate_link " );
		
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$restrict_id = $row->restrict_id;
		}
		// echo $rate_strategy;
		// fill array with perday price
		$rooms_price = array ();
		$sql = "SELECT seasonspricelist.rate_id, categories.id AS hms_category_id,deskofdaysseason.intdate, categories.base_price, seasonspricelist.price, seasonspricelist.price1, seasonspricelist.price2,
			seasonspricelist.price3, seasonspricelist.price4, seasonspricelist.price5,
			seasonspricelist.price6, seasonspricelist.price7,
			seasonspricelist.singleuse_price, seasonspricelist.singleuse_price1, seasonspricelist.singleuse_price2,
			seasonspricelist.singleuse_price3, seasonspricelist.singleuse_price4, seasonspricelist.singleuse_price5,
			seasonspricelist.singleuse_price6, seasonspricelist.singleuse_price7
		
			FROM rate
			INNER JOIN seasonspricelist ON seasonspricelist.rate_id = rate.id
			INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
			INNER JOIN deskofdaysseason ON seasons.id = deskofdaysseason.seasonid
			INNER JOIN categories ON categories.id = seasonspricelist.category_id
			INNER JOIN dc_hostelworld_room_categories_link ON categories.id = dc_hostelworld_room_categories_link.hms_category_id
			WHERE categories.is_active =1
			AND seasons.is_active =1
			AND rate.id = $rate_id
			AND deskofdaysseason.intdate >=$intdatein
			AND deskofdaysseason.intdate <=$intdateout
			ORDER BY category_id, intdate";
		// echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price;
			}
		}
		
		// echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$rooms_price [$row->hms_category_id] [$row->intdate] = $row->base_price;
				
				$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price;
				
				$week_day = date ( "w", $row->intdate * 86400 );
				$price = 0;
				
				// if ($restrict_id != 0) {
				
				if (isset ( $deskof_restrictedprice [$row->hms_category_id] [$row->rate_id] [$row->intdate] ["price"] )) {
					$price = $deskof_restrictedprice [$row->hms_category_id] [$row->rate_id] [$row->intdate] ["price"];
					
					$rooms_price [$row->hms_category_id] [$row->intdate] = $price;
				} 				// }
				else {
					switch ($rate_strategy) {
						case 1 :
							$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price;
							
							break;
						case 2 :
							switch ($week_day) {
								case 1 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price1;
									
									break;
								case 2 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price2;
									
									break;
								case 3 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price3;
									
									break;
								case 4 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price4;
									
									break;
								case 5 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price5;
									
									break;
								case 6 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price6;
									
									break;
								case 0 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price7;
									
									break;
							}
							break;
					}
				}
			}
		}
		
		$dc_rooms = array ();
		$result = array ();
		$category_keys = array_keys ( $categories_rooms_all );
		foreach ( $category_keys as $category_id ) {
			
			$sql = "select * from dc_hostelworld_room_categories_link where hms_category_id =" . $category_id;
			$query = $this->db->query ( $sql );
			if ($query->num_rows () > 0) {
				$row2 = $query->row ();
				$min = $row2->min;
				$max = $row2->max;
			} else {
				$min = 0;
				$max = 999;
			}
			
			$arr_intdate_keys = array_keys ( $categories_rooms_all [$category_id] );
			foreach ( $arr_intdate_keys as $intdate ) {
				$dc_rooms [$category_id] [$intdate] ['places'] = $categories_beds [$category_id];
				$dc_rooms [$category_id] [$intdate] ["dc_category_id"] = $row2->dc_category_id;
				$dc_rooms [$category_id] [$intdate] ["date_start"] = gmdate ( "Y-m-d", $intdate * 86400 );
				$dc_rooms [$category_id] [$intdate] ["date_end"] = gmdate ( "Y-m-d", $intdate * 86400 );
				$dc_rooms [$category_id] [$intdate] ["count"] = $categories_rooms_all [$category_id] [$intdate] ["free"];
				if (isset ( $rooms_occupied [$category_id] [$intdate] )) {
					$dc_rooms [$category_id] [$intdate] ["count"] -= $rooms_occupied [$category_id] [$intdate];
				}
				if (isset ( $rooms_occupied_overbook [$category_id] [$intdate] )) {
					$dc_rooms [$category_id] [$intdate] ["count"] -= $rooms_occupied_overbook [$category_id] [$intdate];
				}
				if ($dc_rooms [$category_id] [$intdate] ["count"] < 0) {
					$dc_rooms [$category_id] [$intdate] ["count"] = 0;
				}
				
				// Параметры загружености
				
				if ($dc_rooms [$category_id] [$intdate] ["count"] > $min) {
					$dc_rooms [$category_id] [$intdate] ["count"] = $dc_rooms [$category_id] [$intdate] ["count"] - $min;
				} else {
					$dc_rooms [$category_id] [$intdate] ["count"] = 0;
				}
				
				if ($dc_rooms [$category_id] [$intdate] ["count"] > $max) {
					$dc_rooms [$category_id] [$intdate] ["count"] = $max;
				}
				
				if ($restrict == 1) {
					if (isset ( $deskofdays_restricted [$category_id] [$restrict_id] [$intdate] ["closed"] )) {
						if ($deskofdays_restricted [$category_id] [$restrict_id] [$intdate] ["closed"] == 1) {
							$dc_rooms [$category_id] [$intdate] ["count"] = 0;
						}
					}
					
					// if (isset($deskofdays_restricted
					// [$category_id] [$restrict_id] [$intdate]
					// ["closedonarrival"])){
					// $dc_rooms [$category_id] [$intdate] ["count"] = 0;
					// }
				}
				
				// коррекція к-сті відповідно умовам ф-ї availability_count_correction
				$dc_rooms[$category_id][$intdate]["count"] = $this->frontdesk_c2->availability_count_correction($dc_rooms[$category_id][$intdate]["count"]);
				
				// END Параметры загружености
				$dc_rooms [$category_id] [$intdate] ["beds"] = $dc_rooms [$category_id] [$intdate] ["count"] * $dc_rooms [$category_id] [$intdate] ['places'];
				if (isset ( $rooms_price [$category_id] [$intdate] )) {
					$dc_rooms [$category_id] [$intdate] ['price'] = $this->frontdesk->dc_currency ( $rooms_price [$category_id] [$intdate] / $dc_rooms [$category_id] [$intdate] ['places'] );
					$dc_rooms [$category_id] [$intdate] ['price22'] = $rooms_price [$category_id] [$intdate];
				} else {
					$dc_rooms [$category_id] [$intdate] ['price'] = 0;
				}
				/*
				 * if (isset ( $rooms_yield [$category_id] [$intdate] )) { $dc_rooms [$category_id] [$intdate] ['price'] = $rooms_yield [$category_id] [$intdate]; }
				 */
				
				// array_push ( $result, $dc_rooms [$category_id]
				// [$intdate] );
			}
		}
		
		$categories_rooms_all_new = $dc_rooms;
		/*
		 * $count_arr = count ( $categories_rooms_all_new ); $count = sizeof ( $categories_rooms_all_new ); $array_keys = array_keys ( $categories_rooms_all_new ); foreach ( $array_keys as $key ) { $j = $intdatein; for($i = $intdatein + 1; $i <= $intdateout; $i ++) { $count_1 = $categories_rooms_all_new [$key] [$i] ["count"]; $count_2 = $categories_rooms_all_new [$key] [$j] ["count"]; $room_category_1 = $categories_rooms_all_new [$key] [$i] ["dc_category_id"]; $room_category_2 = $categories_rooms_all_new [$key] [$j] ["dc_category_id"]; $room_category_1 = $categories_rooms_all_new [$key] [$i] ["dc_category_id"]; $room_category_2 = $categories_rooms_all_new [$key] [$j] ["dc_category_id"]; $room_price_1 = $categories_rooms_all_new [$key] [$i] ["price"]; $room_price_2 = $categories_rooms_all_new [$key] [$j] ["price"]; if ($room_category_1 == $room_category_2 and $count_1 == $count_2 and $room_price_1 == $room_price_2) { // $categories_rooms_all_new [$key] [$j] ["hotel"] = // $categories_rooms_all_new [$key] [$i] ["hotel"]; $categories_rooms_all_new [$key] [$j] ["date_end"] = $categories_rooms_all_new [$key] [$i] ["date_end"]; unset ( $categories_rooms_all_new [$key] [$i] ); } else { $j = $i; } } }
		 */
		// print_r($categories_rooms_all_new);
		
		$category_keys = array_keys ( $categories_rooms_all_new );
		$roomsresult = array ();
		foreach ( $category_keys as $category_id ) {
			for($i = $intdatein; $i <= $intdateout; $i ++) {
				if (isset ( $categories_rooms_all_new [$category_id] [$i] ))
					array_push ( $roomsresult, $categories_rooms_all_new [$category_id] [$i] );
			}
		}
		
		$result_mass = array ();
		$k = 0;
		foreach ( $category_keys as $category_id ) {
			for($i = $intdatein; $i <= $intdateout; $i ++) {
				if (isset ( $categories_rooms_all_new [$category_id] [$i] )) {
					$dc_category_id = $categories_rooms_all_new [$category_id] [$i] ["dc_category_id"];
					$result_mass [$dc_category_id] ["dc_category_id"] = $dc_category_id;
					$result_mass [$dc_category_id] ["range"] [$k] = $categories_rooms_all_new [$category_id] [$i];
					$k ++;
				}
			}
		}
		
		// echo "<pre>";
		// print_r($roomsresult);
		// die();
		return $result_mass;
	}
	
	function getavailability_v2_OLD($datein, $dateout) {
	    list ( $year, $month, $day ) = explode ( "-", $datein );
	    $intdatein = floor ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	    list ( $year, $month, $day ) = explode ( "-", $dateout );
	    $intdateout = floor ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	
	    //$rate_strategy = $this->frontdesk->GetRateStrategy ();
	
	    $inttoday = floor ( gmmktime () / 86400 );
	
	    if ($intdatein < $inttoday)
	        $intdatein = $inttoday;
	
	        // get rate from rate_link
	        //$rate_id = 1;
	        $rate_id = $this->get_rate ();
	        $dc_id = 8;
	        $limit_array = $this->frontdesk->get_dc_log_limit_array ();
	        $hw_uploadperiod = $limit_array[$dc_id];
	        // fill array with occupied rooms
	
	        $categories_beds = array ();
	        $sql = "SELECT id, places
		FROM `categories`
		";
	        $sql = "SELECT IF( baseplace> 0, baseplace, categories.places) as occupancy, categories.id FROM rate
	        INNER JOIN seasonspricelist ON seasonspricelist.rate_id = rate.id
	        INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
	        INNER JOIN deskofdaysseason ON seasons.id = deskofdaysseason.seasonid
	        INNER JOIN categories ON categories.id = seasonspricelist.category_id
	        INNER JOIN ratetocategory ON ratetocategory.rate_id = rate.id AND ratetocategory.category_id = categories.id
	        INNER JOIN dc_hostelworld_room_categories_link ON categories.id = dc_hostelworld_room_categories_link.hms_category_id
	        WHERE categories.is_active =1
	        AND seasons.is_active =1
	        AND rate.id = $rate_id
	        AND deskofdaysseason.intdate >=$intdatein
	        AND deskofdaysseason.intdate <=$intdateout
	        ORDER BY seasonspricelist.category_id, intdate";
	        echo $sql;
	        // die();
	        $query = $this->db->query ( $sql );
	        if ($query->num_rows () > 0) {
	            foreach ( $query->result () as $row ) {
	                $categories_beds [$row->id] = $row->occupancy;
	            }
	        }
	
	        $min_date = 0;
	        $max_date = 0;
	        $categories_rooms_all = array ();
	        $data_return = array ();
	        $intdate_today = floor ( time () / 86400 );
	        $last_id = 0;
	        // 		$sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms  FROM categories
	        // 				INNER JOIN dc_hostelworld_room_categories_link ON dc_hostelworld_room_categories_link.hms_category_id = categories.id
	        // 				INNER JOIN dc_log ON dc_log.categoryid = categories.id
	        // 				INNER JOIN rooms ON rooms.category_id = categories.id
	        // 				WHERE rooms.dc_active=1 AND dc_log.dc_id = 8 AND dc_log.intdate >= " . $intdate_today . "
	        // 					GROUP BY dc_log.categoryid, dc_log.intdate LIMIT 0, $hw_uploadperiod";
	
	
	        $sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms  FROM dc_log
				INNER JOIN dc_hostelworld_room_categories_link ON dc_hostelworld_room_categories_link.hms_category_id = dc_log.categoryid
				INNER JOIN categories ON categories.id = dc_log.categoryid
 				INNER JOIN rooms ON rooms.category_id = categories.id
				WHERE rooms.dc_active=1 AND dc_log.dc_id = 8 AND dc_log.intdate >= " . $intdate_today . "
					GROUP BY dc_log.categoryid, dc_log.intdate ORDER BY dc_log.id ASC LIMIT 0, $hw_uploadperiod";
	        $query = $this->db->query ( $sql );
	        if ($query->num_rows () > 0) {
	            foreach ( $query->result () as $row ) {
	                if ($min_date == 0) {
	                    $min_date = $row->log_intdate;
	                } else {
	                    if ($row->log_intdate < $min_date) {
	                        $min_date = $row->log_intdate;
	                    }
	                }
	
	                if ($max_date == 0) {
	                    $max_date = $row->log_intdate;
	                } else {
	                    if ($row->log_intdate > $max_date) {
	                        $max_date = $row->log_intdate;
	                    }
	                }
	
	                $categories_rooms_all [$row->category_id] [$row->log_intdate] ["free"] = $row->count_rooms;
	                $categories_rooms_all [$row->category_id] [$row->log_intdate] ["date"] = date ( "Y-m-d", $row->log_intdate * 86400 );
	                // $last_id = $row->dc_log_id;
	                if ($row->dc_log_id > $last_id) {
	                    $last_id = $row->dc_log_id;
	                }
	            }
	        } else {
	            $data_return ["response"] = 3;
	            return $data_return;
	        }
	
	
	        $rooms_occupied = array ();
	        $sql = "SELECT categories.id AS hms_category_id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
	        FROM `rooms`
	        INNER JOIN categories ON categories.id = rooms.category_id
	        INNER JOIN dc_hostelworld_room_categories_link ON dc_hostelworld_room_categories_link.hms_category_id = categories.id
	        INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
	        WHERE deskofdays.intdate >= $intdatein AND deskofdays.intdate <= $intdateout
	        GROUP BY deskofdays.intdate, rooms.category_id";
	        // echo $sql;
	        $query = $this->db->query ( $sql );
	        if ($query->num_rows () > 0) {
	            foreach ( $query->result () as $row ) {
	                $rooms_occupied [$row->hms_category_id] [$row->intdate] = $row->count_rooms;
	            }
	        }
	
	        $rooms_occupied_overbook = $this->dcm_cron_lastchanged->get_overbooking_origincat ( $intdatein, $intdateout );
	        $datein_out_mass = $this->dcm_cron_lastchanged->get_datein_dateout_dc_log ( 8 );
	        // echo "<pre>";
	        // print_r ( $datein_out_mass );
	        // print_r ( $rooms_occupied );
	        if (isset ( $datein_out_mass ["intdatein"] )) {
	            $rooms_occupied_overbook = $this->dcm_cron_lastchanged->get_overbooking_origincat ( $datein_out_mass ["intdatein"], $datein_out_mass ["intdateout"] );
	        }
	
	        $dc_rooms = array ();
	        $result = array ();
	        $category_keys = array_keys ( $categories_rooms_all );
	        foreach ( $category_keys as $category_id ) {
	
	            $sql = "select * from dc_hostelworld_room_categories_link where hms_category_id =" . $category_id;
	            $query = $this->db->query ( $sql );
	            if ($query->num_rows () > 0) {
	                $row2 = $query->row ();
	                $min = $row2->min;
	                $max = $row2->max;
	            } else {
	                $min = 0;
	                $max = 999;
	            }
	
	            $arr_intdate_keys = array_keys ( $categories_rooms_all [$category_id] );
	            foreach ( $arr_intdate_keys as $intdate ) {
	                $dc_rooms [$category_id] [$intdate] ['places'] = $categories_beds [$category_id];
	                $dc_rooms [$category_id] [$intdate] ["dc_category_id"] = $row2->dc_category_id;
	                $dc_rooms [$category_id] [$intdate] ["date_start"] = gmdate ( "Y-m-d", $intdate * 86400 );
	                $dc_rooms [$category_id] [$intdate] ["date_end"] = gmdate ( "Y-m-d", $intdate * 86400 );
	                $dc_rooms [$category_id] [$intdate] ["count"] = $categories_rooms_all [$category_id] [$intdate] ["free"];
	                if (isset ( $rooms_occupied [$category_id] [$intdate] )) {
	                    $dc_rooms [$category_id] [$intdate] ["count"] -= $rooms_occupied [$category_id] [$intdate];
	                }
	                if (isset ( $rooms_occupied_overbook [$category_id] [$intdate] )) {
	                    $dc_rooms [$category_id] [$intdate] ["count"] -= $rooms_occupied_overbook [$category_id] [$intdate];
	                }
	                if ($dc_rooms [$category_id] [$intdate] ["count"] < 0) {
	                    $dc_rooms [$category_id] [$intdate] ["count"] = 0;
	                }
	
	                // Параметры загружености
	
	                if ($dc_rooms [$category_id] [$intdate] ["count"] > $min) {
	                    $dc_rooms [$category_id] [$intdate] ["count"] = $dc_rooms [$category_id] [$intdate] ["count"] - $min;
	                } else {
	                    $dc_rooms [$category_id] [$intdate] ["count"] = 0;
	                }
	
	                if ($dc_rooms [$category_id] [$intdate] ["count"] > $max) {
	                    $dc_rooms [$category_id] [$intdate] ["count"] = $max;
	                }
	
	                // коррекція к-сті відповідно умовам ф-ї availability_count_correction
	                $startdate = $enddate = date("Y-m-d", $intdate * 86400);
	                $dc_rooms[$category_id][$intdate]["count"] = $this->frontdesk_c2->availability_count_correction($dc_rooms[$category_id][$intdate]["count"], $startdate, $enddate);
	
	                $dc_rooms [$category_id] [$intdate] ["beds"] = $dc_rooms [$category_id] [$intdate] ["count"] * $dc_rooms [$category_id] [$intdate] ['places'];
	
	
	            }
	        }
	
	        $categories_rooms_all_new = $dc_rooms;
	
	        $category_keys = array_keys ( $categories_rooms_all_new );
	        $roomsresult = array ();
	        foreach ( $category_keys as $category_id ) {
	            for($i = $intdatein; $i <= $intdateout; $i ++) {
	                if (isset ( $categories_rooms_all_new [$category_id] [$i] ))
	                    array_push ( $roomsresult, $categories_rooms_all_new [$category_id] [$i] );
	            }
	        }
	
	        $result_mass = array ();
	        $k = 0;
	        foreach ( $category_keys as $category_id ) {
	            for($i = $intdatein; $i <= $intdateout; $i ++) {
	                if (isset ( $categories_rooms_all_new [$category_id] [$i] )) {
	                    $dc_category_id = $categories_rooms_all_new [$category_id] [$i] ["dc_category_id"];
	                    $result_mass [$dc_category_id] ["dc_category_id"] = $dc_category_id;
	                    $result_mass [$dc_category_id] ["max_beds"] = $categories_rooms_all [$category_id] [$i] ["free"];
	                    $result_mass [$dc_category_id] ["range"] [$k] = $categories_rooms_all_new [$category_id] [$i];
	                    $k ++;
	                }
	            }
	        }
	
	        echo "<pre>";
	        print_r($roomsresult);
	        die();
	        $return_data = array();
	        $return_data ['data'] = $result_mass;
	        $return_data ['last_id'] = $last_id;
	        return $return_data;
	}
	
	function getavailability_v2($datein, $dateout) {
	    list ( $year, $month, $day ) = explode ( "-", $datein );
	    $intdatein = floor ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	    list ( $year, $month, $day ) = explode ( "-", $dateout );
	    $intdateout = floor ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	
	    //$rate_strategy = $this->frontdesk->GetRateStrategy ();
	
	    $inttoday = floor ( gmmktime () / 86400 );
	
	    if ($intdatein < $inttoday)
	        $intdatein = $inttoday;
	        	
	        // get rate from rate_link
	        //$rate_id = 1;
	        $rate_id = $this->get_rate ();
	        $dc_id = 8;
	        $limit_array = $this->frontdesk->get_dc_log_limit_array ();
	        $hw_uploadperiod = $limit_array[$dc_id];
	        // fill array with occupied rooms
	
	        $categories_beds = array ();
	        $sql = "SELECT id, places
		FROM `categories`
		";
	        // 		$sql = "SELECT IF( baseplace> 0, baseplace, categories.places) as occupancy, categories.id FROM rate
	        // 		INNER JOIN dc_hostelworld_rate2category_link
	        // 		INNER JOIN seasonspricelist ON seasonspricelist.rate_id = rate.id
	        // 		INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
	        // 		INNER JOIN deskofdaysseason ON seasons.id = deskofdaysseason.seasonid
	        // 		INNER JOIN categories ON categories.id = seasonspricelist.category_id
	        // 		INNER JOIN ratetocategory ON ratetocategory.rate_id = rate.id AND ratetocategory.category_id = categories.id
	        // 		INNER JOIN dc_hostelworld_room_categories_link ON categories.id = dc_hostelworld_room_categories_link.hms_category_id
	        // 		WHERE categories.is_active =1
	        // 		AND seasons.is_active =1
	        // 		AND rate.id = $rate_id
	        // 		AND deskofdaysseason.intdate >=$intdatein
	        // 		AND deskofdaysseason.intdate <=$intdateout
	        // 		ORDER BY seasonspricelist.category_id, intdate";
	        // echo $sql;
	        // die();
	        $query = $this->db->query ( $sql );
	        if ($query->num_rows () > 0) {
	            foreach ( $query->result () as $row ) {
	                //$categories_beds [$row->id] = $row->occupancy;
	                $categories_beds [$row->id] = $row->places;
	            }
	        }
	
	        $min_date = 0;
	        $max_date = 0;
	        $categories_rooms_all = array ();
	        $data_return = array ();
	        $intdate_today = floor ( time () / 86400 );
	        $last_id = 0;
	        // 		$sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms  FROM categories
	        // 				INNER JOIN dc_hostelworld_room_categories_link ON dc_hostelworld_room_categories_link.hms_category_id = categories.id
	        // 				INNER JOIN dc_log ON dc_log.categoryid = categories.id
	        // 				INNER JOIN rooms ON rooms.category_id = categories.id
	        // 				WHERE rooms.dc_active=1 AND dc_log.dc_id = 8 AND dc_log.intdate >= " . $intdate_today . "
	        // 					GROUP BY dc_log.categoryid, dc_log.intdate LIMIT 0, $hw_uploadperiod";
	
	        $hw_categories_data = array();
	        $sql = "SELECT dc_category_id, beds, basictype FROM dc_hostelworld_room_categories_link";
	        $query = $this->db->query ( $sql );
	        if ($query->num_rows () > 0) {
	            foreach ( $query->result () as $row ) {
	                $private_pos = strpos(strtolower($row->basictype), "private");
	                $is_private = 1;
	                if ($private_pos === false) {
	                    $is_private = 0;
	                }
	
	                $hw_categories_data [$row->dc_category_id]['beds'] = $row->beds;
	                $hw_categories_data [$row->dc_category_id]['basictype'] = $row->basictype;
	                $hw_categories_data [$row->dc_category_id]['is_private'] = $is_private;
	            }
	        }
	
	        $sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms,
		        dc_hostelworld_room_categories_link.beds, dc_hostelworld_room_categories_link.basictype
		        FROM dc_log
				INNER JOIN dc_hostelworld_room_categories_link ON dc_hostelworld_room_categories_link.hms_category_id = dc_log.categoryid
				INNER JOIN categories ON categories.id = dc_log.categoryid
 				INNER JOIN rooms ON rooms.category_id = categories.id
				WHERE rooms.dc_active=1 AND dc_log.dc_id = 8 AND dc_log.intdate >= " . $intdate_today . "
					GROUP BY dc_log.categoryid, dc_log.intdate ORDER BY dc_log.id ASC LIMIT 0, $hw_uploadperiod";
	        //echo $sql;
	        $query = $this->db->query ( $sql );
	        if ($query->num_rows () > 0) {
	            foreach ( $query->result () as $row ) {
	                if ($min_date == 0) {
	                    $min_date = $row->log_intdate;
	                } else {
	                    if ($row->log_intdate < $min_date) {
	                        $min_date = $row->log_intdate;
	                    }
	                }
	
	                if ($max_date == 0) {
	                    $max_date = $row->log_intdate;
	                } else {
	                    if ($row->log_intdate > $max_date) {
	                        $max_date = $row->log_intdate;
	                    }
	                }
	
	
	                $categories_rooms_all [$row->category_id] [$row->log_intdate] ["free"] = $row->count_rooms;
	                $categories_rooms_all [$row->category_id] [$row->log_intdate] ["date"] = date ( "Y-m-d", $row->log_intdate * 86400 );
	                // $last_id = $row->dc_log_id;
	                if ($row->dc_log_id > $last_id) {
	                    $last_id = $row->dc_log_id;
	                }
	            }
	        } else {
	            $sql = "DELETE FROM dc_log WHERE dc_id = 8";
	            $query = $this->db->query ( $sql );
	            
	            $data_return ["response"] = 3;
	            return $data_return;
	        }
	
	        // 		echo "<pre>";
	        // 		print_r($categories_rooms_all);
	        // 		die();
	
	        $rooms_occupied = array ();
	        $sql = "SELECT categories.id AS hms_category_id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
	        FROM `rooms`
	        INNER JOIN categories ON categories.id = rooms.category_id
	        INNER JOIN dc_hostelworld_room_categories_link ON dc_hostelworld_room_categories_link.hms_category_id = categories.id
	        INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
	        WHERE deskofdays.intdate >= $intdatein AND deskofdays.intdate <= $intdateout
	        GROUP BY deskofdays.intdate, rooms.category_id";
	        // echo $sql;
	        $query = $this->db->query ( $sql );
	        if ($query->num_rows () > 0) {
	            foreach ( $query->result () as $row ) {
	                $rooms_occupied [$row->hms_category_id] [$row->intdate] = $row->count_rooms;
	            }
	        }
	
	        $rooms_occupied_overbook = $this->dcm_cron_lastchanged->get_overbooking_origincat ( $intdatein, $intdateout );
	        $datein_out_mass = $this->dcm_cron_lastchanged->get_datein_dateout_dc_log ( 8 );
	        // echo "<pre>";
	        // print_r ( $datein_out_mass );
	        // print_r ( $rooms_occupied );
	        if (isset ( $datein_out_mass ["intdatein"] )) {
	            $rooms_occupied_overbook = $this->dcm_cron_lastchanged->get_overbooking_origincat ( $datein_out_mass ["intdatein"], $datein_out_mass ["intdateout"] );
	        }
	
	        $dc_rooms = array ();
	        $result = array ();
	        $category_keys = array_keys ( $categories_rooms_all );
	        foreach ( $category_keys as $category_id ) {
	            	
	            $sql = "select * from dc_hostelworld_room_categories_link where hms_category_id =" . $category_id;
	            $query = $this->db->query ( $sql );
	            if ($query->num_rows () > 0) {
	                $row2 = $query->row ();
	                $min = $row2->min;
	                $max = $row2->max;
	            } else {
	                $min = 0;
	                $max = 999;
	            }
	            	
	            $arr_intdate_keys = array_keys ( $categories_rooms_all [$category_id] );
	            foreach ( $arr_intdate_keys as $intdate ) {
	                $dc_rooms [$category_id] [$intdate] ['places'] = $categories_beds [$category_id];
	                $dc_rooms [$category_id] [$intdate] ["dc_category_id"] = $row2->dc_category_id;
	                $dc_rooms [$category_id] [$intdate] ["date_start"] = gmdate ( "Y-m-d", $intdate * 86400 );
	                $dc_rooms [$category_id] [$intdate] ["date_end"] = gmdate ( "Y-m-d", $intdate * 86400 );
	                $dc_rooms [$category_id] [$intdate] ["count"] = $categories_rooms_all [$category_id] [$intdate] ["free"];
	                if (isset ( $rooms_occupied [$category_id] [$intdate] )) {
	                    $dc_rooms [$category_id] [$intdate] ["count"] -= $rooms_occupied [$category_id] [$intdate];
	                }
	                if (isset ( $rooms_occupied_overbook [$category_id] [$intdate] )) {
	                    $dc_rooms [$category_id] [$intdate] ["count"] -= $rooms_occupied_overbook [$category_id] [$intdate];
	                }
	                if ($dc_rooms [$category_id] [$intdate] ["count"] < 0) {
	                    $dc_rooms [$category_id] [$intdate] ["count"] = 0;
	                }
	
	                // Параметры загружености
	
	                if ($dc_rooms [$category_id] [$intdate] ["count"] > $min) {
	                    $dc_rooms [$category_id] [$intdate] ["count"] = $dc_rooms [$category_id] [$intdate] ["count"] - $min;
	                } else {
	                    $dc_rooms [$category_id] [$intdate] ["count"] = 0;
	                }
	
	                if ($dc_rooms [$category_id] [$intdate] ["count"] > $max) {
	                    $dc_rooms [$category_id] [$intdate] ["count"] = $max;
	                }
	
	                // коррекція к-сті відповідно умовам ф-ї availability_count_correction
	                $startdate = $enddate = date("Y-m-d", $intdate * 86400);
	                $dc_rooms[$category_id][$intdate]["count"] = $this->frontdesk_c2->availability_count_correction($dc_rooms[$category_id][$intdate]["count"], $startdate, $enddate);
	
	                //$dc_rooms [$category_id] [$intdate] ["beds"] = $dc_rooms [$category_id] [$intdate] ["count"] * $dc_rooms [$category_id] [$intdate] ['places'];
	                if($hw_categories_data [$row2->dc_category_id] ["is_private"] == 1){
	                    $dc_rooms [$category_id] [$intdate] ["beds"] = $dc_rooms [$category_id] [$intdate] ["count"] * $hw_categories_data [$row2->dc_category_id] ["beds"];
	                }else{
	                    $dc_rooms [$category_id] [$intdate] ["beds"] = $dc_rooms [$category_id] [$intdate] ["count"] * $dc_rooms [$category_id] [$intdate] ['places'];
	                }
	
	
	            }
	        }
	
	        $categories_rooms_all_new = $dc_rooms;
	
	        $category_keys = array_keys ( $categories_rooms_all_new );
	        $roomsresult = array ();
	        foreach ( $category_keys as $category_id ) {
	            for($i = $intdatein; $i <= $intdateout; $i ++) {
	                if (isset ( $categories_rooms_all_new [$category_id] [$i] ))
	                    array_push ( $roomsresult, $categories_rooms_all_new [$category_id] [$i] );
	            }
	        }
	
	        $result_mass = array ();
	        $k = 0;
	        foreach ( $category_keys as $category_id ) {
	            for($i = $intdatein; $i <= $intdateout; $i ++) {
	                if (isset ( $categories_rooms_all_new [$category_id] [$i] )) {
	                    $dc_category_id = $categories_rooms_all_new [$category_id] [$i] ["dc_category_id"];
	                    $result_mass [$dc_category_id] ["dc_category_id"] = $dc_category_id;
	                    $result_mass [$dc_category_id] ["max_beds"] = $hw_categories_data [$dc_category_id] ["beds"];
	                    //$result_mass [$dc_category_id] ["max_beds"] = $categories_rooms_all [$category_id] [$i] ["free"];
	                    $result_mass [$dc_category_id] ["range"] [$k] = $categories_rooms_all_new [$category_id] [$i];
	                    $k ++;
	                }
	            }
	        }
	
	        // 		echo "<pre>";
	        // 		print_r($roomsresult);
	        // 		die();
	        $return_data = array();
	        $return_data ['data'] = $result_mass;
	        $return_data ['last_id'] = $last_id;
	        return $return_data;
	}
	
	function getrateavail_($datein, $dateout, $restrict = 1) {
		list ( $year, $month, $day ) = explode ( "-", $datein );
		$intdatein = floor ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		list ( $year, $month, $day ) = explode ( "-", $dateout );
		$intdateout = floor ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		
		$rate_strategy = $this->frontdesk->GetRateStrategy ();
		
		$inttoday = floor ( gmmktime () / 86400 );
		
		if ($intdatein < $inttoday)
			$intdatein = $inttoday;
			
			// get rate from rate_link
		$rate_id = 1;
		$rate_id = $this->get_rate ();
		
		// fill array with occupied rooms
		
		$categories_beds = array ();
		$sql = "SELECT id, places
		FROM `categories`
		";
		$sql = "SELECT IF( baseplace> 0, baseplace, categories.places) as occupancy, categories.id FROM rate
		INNER JOIN seasonspricelist ON seasonspricelist.rate_id = rate.id
		INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
		INNER JOIN deskofdaysseason ON seasons.id = deskofdaysseason.seasonid
		INNER JOIN categories ON categories.id = seasonspricelist.category_id
		INNER JOIN ratetocategory ON ratetocategory.rate_id = rate.id AND ratetocategory.category_id = categories.id
		INNER JOIN dc_hostelworld_room_categories_link ON categories.id = dc_hostelworld_room_categories_link.hms_category_id
		WHERE categories.is_active =1
		AND seasons.is_active =1
		AND rate.id = $rate_id
		AND deskofdaysseason.intdate >=$intdatein
		AND deskofdaysseason.intdate <=$intdateout
		ORDER BY seasonspricelist.category_id, intdate";
		// echo $sql;
		// die();
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$categories_beds [$row->id] = $row->occupancy;
			}
		}
		
		$rooms_occupied = array ();
		$sql = "SELECT categories.id AS hms_category_id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
		FROM `rooms`
		INNER JOIN categories ON categories.id = rooms.category_id
		INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
		WHERE deskofdays.intdate >= $intdatein AND deskofdays.intdate <= $intdateout
		GROUP BY deskofdays.intdate, rooms.category_id";
		// echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$rooms_occupied [$row->hms_category_id] [$row->intdate] = $row->count_rooms;
			}
		}
		
		$rooms_occupied_overbook = $this->dc_model->get_overbooking_origincat ( $intdatein, $intdateout );
		
		// fill yeld price
		$rooms_yield = array ();
		$sql = "SELECT category_id as hms_category_id, intdate, price FROM yieldprice  WHERE id_restrict_rate=$rate_id AND 
			intdate >= $intdatein AND intdate <= $intdateout";
		// echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$rooms_yield [$row->hms_category_id] [$row->intdate] = $row->price;
			}
		}
		
		$deskof_restrictedprice = array ();
		
		$sql = "SELECT intdate, id_restrict_rate, category_id, price, singleuseprice
		FROM yieldprice WHERE  intdate >= $intdatein AND intdate <= $intdateout ";
		// echo $sql;
		// die();
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["price"] = $row->price;
				$deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["singleuseprice"] = $row->singleuseprice;
			}
		}
		
		$deskofdays_restricted = array ();
		if ($restrict == 1) {
			
			$sql = "SELECT * FROM deskofrate";
			// echo $sql;
			// die();
			$query = $this->db->query ( $sql );
			if ($query->num_rows () > 0) {
				foreach ( $query->result () as $row ) {
					$deskofdays_restricted [$row->category_id] [$row->rate_id] [$row->intdate] ["closed"] = $row->closed;
					// $deskofdays_restricted [$row->category_id]
					// [$row->rate_id] [$row->intdate] ["closedonarrival"] =
					// $row->closedonarrival;
				}
			}
		}
		// echo "<pre>";
		// print_r($deskofdays_restricted);
		// die();
		$restrict_id = 0;
		$query = $this->db->query ( "SELECT restrict_id FROM dc_hostelworld_rate_link " );
		
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$restrict_id = $row->restrict_id;
		}
		// echo $rate_strategy;
		// fill array with perday price
		$rooms_price = array ();
		$sql = "SELECT seasonspricelist.rate_id, categories.id AS hms_category_id,deskofdaysseason.intdate, categories.base_price, seasonspricelist.price, seasonspricelist.price1, seasonspricelist.price2, 
		seasonspricelist.price3, seasonspricelist.price4, seasonspricelist.price5,
		seasonspricelist.price6, seasonspricelist.price7, 
		seasonspricelist.singleuse_price, seasonspricelist.singleuse_price1, seasonspricelist.singleuse_price2,
		seasonspricelist.singleuse_price3, seasonspricelist.singleuse_price4, seasonspricelist.singleuse_price5, 
		seasonspricelist.singleuse_price6, seasonspricelist.singleuse_price7  

FROM rate
INNER JOIN seasonspricelist ON seasonspricelist.rate_id = rate.id
INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
INNER JOIN deskofdaysseason ON seasons.id = deskofdaysseason.seasonid
INNER JOIN categories ON categories.id = seasonspricelist.category_id
INNER JOIN dc_hostelworld_room_categories_link ON categories.id = dc_hostelworld_room_categories_link.hms_category_id
WHERE categories.is_active =1
AND seasons.is_active =1
AND rate.id = $rate_id
AND deskofdaysseason.intdate >=$intdatein
AND deskofdaysseason.intdate <=$intdateout
ORDER BY category_id, intdate";
		// echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price;
			}
		}
		
		// echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$rooms_price [$row->hms_category_id] [$row->intdate] = $row->base_price;
				
				$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price;
				
				$week_day = date ( "w", $row->intdate * 86400 );
				$price = 0;
				
				// if ($restrict_id != 0) {
				
				if (isset ( $deskof_restrictedprice [$row->hms_category_id] [$row->rate_id] [$row->intdate] ["price"] )) {
					$price = $deskof_restrictedprice [$row->hms_category_id] [$row->rate_id] [$row->intdate] ["price"];
					
					$rooms_price [$row->hms_category_id] [$row->intdate] = $price;
				} 				// }
				else {
					switch ($rate_strategy) {
						case 1 :
							$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price;
							
							break;
						case 2 :
							switch ($week_day) {
								case 1 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price1;
									
									break;
								case 2 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price2;
									
									break;
								case 3 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price3;
									
									break;
								case 4 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price4;
									
									break;
								case 5 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price5;
									
									break;
								case 6 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price6;
									
									break;
								case 0 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price7;
									
									break;
							}
							break;
					}
				}
			}
		}
		
		$sql = "SELECT dc_category_id, categories.id AS hms_category_id, categories.id AS places, COUNT( rooms.id ) AS count_rooms
FROM  `rooms` 
INNER JOIN categories ON categories.id = rooms.category_id
INNER JOIN dc_hostelworld_room_categories_link ON categories.id = dc_hostelworld_room_categories_link.hms_category_id
WHERE 1 
GROUP BY dc_category_id, rooms.category_id";
		$dc_rooms = array ();
		$result = array ();
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$sql = "select min, max from dc_hostelworld_room_categories_link where hms_category_id =" . $row->hms_category_id;
				$query2 = $this->db->query ( $sql );
				if ($query2->num_rows () > 0) {
					$row2 = $query2->row ();
					$min = $row2->min;
					$max = $row2->max;
				} else {
					$min = 0;
					$max = 999;
				}
				for($i = $intdatein; $i <= $intdateout; $i ++) {
					$dc_rooms [$row->hms_category_id] [$i] ['places'] = $categories_beds [$row->hms_category_id];
					$dc_rooms [$row->hms_category_id] [$i] ["dc_category_id"] = $row->dc_category_id;
					$dc_rooms [$row->hms_category_id] [$i] ["date_start"] = gmdate ( "Y-m-d", $i * 86400 );
					$dc_rooms [$row->hms_category_id] [$i] ["date_end"] = gmdate ( "Y-m-d", $i * 86400 );
					$dc_rooms [$row->hms_category_id] [$i] ["count"] = $row->count_rooms;
					if (isset ( $rooms_occupied [$row->hms_category_id] [$i] )) {
						$dc_rooms [$row->hms_category_id] [$i] ["count"] -= $rooms_occupied [$row->hms_category_id] [$i];
					}
					if (isset ( $rooms_occupied_overbook [$row->hms_category_id] [$i] )) {
						$dc_rooms [$row->hms_category_id] [$i] ["count"] -= $rooms_occupied_overbook [$row->hms_category_id] [$i];
					}
					if ($dc_rooms [$row->hms_category_id] [$i] ["count"] < 0) {
						$dc_rooms [$row->hms_category_id] [$i] ["count"] = 0;
					}
					
					// Параметры загружености
					
					if ($dc_rooms [$row->hms_category_id] [$i] ["count"] > $min) {
						$dc_rooms [$row->hms_category_id] [$i] ["count"] = $dc_rooms [$row->hms_category_id] [$i] ["count"] - $min;
					} else {
						$dc_rooms [$row->hms_category_id] [$i] ["count"] = 0;
					}
					
					if ($dc_rooms [$row->hms_category_id] [$i] ["count"] > $max) {
						$dc_rooms [$row->hms_category_id] [$i] ["count"] = $max;
					}
					
					if ($restrict == 1) {
						if (isset ( $deskofdays_restricted [$row->hms_category_id] [$restrict_id] [$i] ["closed"] )) {
							if ($deskofdays_restricted [$row->hms_category_id] [$restrict_id] [$i] ["closed"] == 1) {
								$dc_rooms [$row->hms_category_id] [$i] ["count"] = 0;
							}
						}
						
						// if (isset($deskofdays_restricted
						// [$row->hms_category_id] [$restrict_id] [$i]
						// ["closedonarrival"])){
						// $dc_rooms [$row->hms_category_id] [$i] ["count"] = 0;
						// }
					}
					
					// END Параметры загружености
					$dc_rooms [$row->hms_category_id] [$i] ["beds"] = $dc_rooms [$row->hms_category_id] [$i] ["count"] * $dc_rooms [$row->hms_category_id] [$i] ['places'];
					if (isset ( $rooms_price [$row->hms_category_id] [$i] )) {
						$dc_rooms [$row->hms_category_id] [$i] ['price'] = $this->frontdesk->dc_currency ( $rooms_price [$row->hms_category_id] [$i] / $dc_rooms [$row->hms_category_id] [$i] ['places'] );
						$dc_rooms [$row->hms_category_id] [$i] ['price22'] = $rooms_price [$row->hms_category_id] [$i];
					} else {
						$dc_rooms [$row->hms_category_id] [$i] ['price'] = 0;
					}
					/*
					 * if (isset ( $rooms_yield [$row->hms_category_id] [$i] )) { $dc_rooms [$row->hms_category_id] [$i] ['price'] = $rooms_yield [$row->hms_category_id] [$i]; }
					 */
					
					// array_push ( $result, $dc_rooms [$row->hms_category_id]
					// [$i] );
				}
			}
		}
		
		$categories_rooms_all_new = $dc_rooms;
		$count_arr = count ( $categories_rooms_all_new );
		
		$count = sizeof ( $categories_rooms_all_new );
		
		$array_keys = array_keys ( $categories_rooms_all_new );
		foreach ( $array_keys as $key ) {
			$j = $intdatein;
			for($i = $intdatein + 1; $i <= $intdateout; $i ++) {
				$count_1 = $categories_rooms_all_new [$key] [$i] ["count"];
				$count_2 = $categories_rooms_all_new [$key] [$j] ["count"];
				$room_category_1 = $categories_rooms_all_new [$key] [$i] ["dc_category_id"];
				$room_category_2 = $categories_rooms_all_new [$key] [$j] ["dc_category_id"];
				$room_category_1 = $categories_rooms_all_new [$key] [$i] ["dc_category_id"];
				$room_category_2 = $categories_rooms_all_new [$key] [$j] ["dc_category_id"];
				
				$room_price_1 = $categories_rooms_all_new [$key] [$i] ["price"];
				$room_price_2 = $categories_rooms_all_new [$key] [$j] ["price"];
				
				if ($room_category_1 == $room_category_2 and $count_1 == $count_2 and $room_price_1 == $room_price_2) {
					// $categories_rooms_all_new [$key] [$j] ["hotel"] =
					// $categories_rooms_all_new [$key] [$i] ["hotel"];
					$categories_rooms_all_new [$key] [$j] ["date_end"] = $categories_rooms_all_new [$key] [$i] ["date_end"];
					unset ( $categories_rooms_all_new [$key] [$i] );
				} else {
					$j = $i;
				}
			}
		}
		
		// print_r($categories_rooms_all_new);
		
		$category_keys = array_keys ( $categories_rooms_all_new );
		$roomsresult = array ();
		foreach ( $category_keys as $category_id ) {
			for($i = $intdatein; $i <= $intdateout; $i ++) {
				if (isset ( $categories_rooms_all_new [$category_id] [$i] ))
					array_push ( $roomsresult, $categories_rooms_all_new [$category_id] [$i] );
			}
		}
		
		// echo "<pre>";
		// print_r($roomsresult);
		// die();
		return $roomsresult;
	}
	function getrateavail($datein, $dateout, $restrict = 1) {
		list ( $year, $month, $day ) = explode ( "-", $datein );
		$intdatein = floor ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		list ( $year, $month, $day ) = explode ( "-", $dateout );
		$intdateout = floor ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		
		$rate_strategy = $this->frontdesk->GetRateStrategy ();
		
		$inttoday = floor ( gmmktime () / 86400 );
		
		if ($intdatein < $inttoday)
			$intdatein = $inttoday;
			
			// get rate from rate_link
		$rate_id = 1;
		$rate_id = $this->get_rate ();
		
		// fill array with occupied rooms
		
		$categories_beds = array ();
		$sql = "SELECT id, places
		FROM `categories`
		";
		$sql = "SELECT IF( baseplace> 0, baseplace, categories.places) as occupancy, categories.id FROM rate
		INNER JOIN seasonspricelist ON seasonspricelist.rate_id = rate.id
		INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
		INNER JOIN deskofdaysseason ON seasons.id = deskofdaysseason.seasonid
		INNER JOIN categories ON categories.id = seasonspricelist.category_id
		INNER JOIN ratetocategory ON ratetocategory.rate_id = rate.id AND ratetocategory.category_id = categories.id
		INNER JOIN dc_hostelworld_room_categories_link ON categories.id = dc_hostelworld_room_categories_link.hms_category_id
		WHERE categories.is_active =1
		AND seasons.is_active =1
		AND rate.id = $rate_id
		AND deskofdaysseason.intdate >=$intdatein
		AND deskofdaysseason.intdate <=$intdateout
		ORDER BY seasonspricelist.category_id, intdate";
		// echo $sql;
		// die();
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$categories_beds [$row->id] = $row->occupancy;
			}
		}
		
		$rooms_occupied = array ();
		$sql = "SELECT categories.id AS hms_category_id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
		FROM `rooms`
		INNER JOIN categories ON categories.id = rooms.category_id
		INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
		WHERE deskofdays.intdate >= $intdatein AND deskofdays.intdate <= $intdateout
		GROUP BY deskofdays.intdate, rooms.category_id";
		// echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$rooms_occupied [$row->hms_category_id] [$row->intdate] = $row->count_rooms;
			}
		}
		
		$rooms_occupied_overbook = $this->dc_model->get_overbooking_origincat ( $intdatein, $intdateout );
		
		// fill yeld price
		$rooms_yield = array ();
		$sql = "SELECT category_id as hms_category_id, intdate, price FROM yieldprice  WHERE id_restrict_rate=$rate_id AND
		intdate >= $intdatein AND intdate <= $intdateout";
		// echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$rooms_yield [$row->hms_category_id] [$row->intdate] = $row->price;
			}
		}
		
		$deskof_restrictedprice = array ();
		
		$sql = "SELECT intdate, id_restrict_rate, category_id, price, singleuseprice
		FROM yieldprice WHERE  intdate >= $intdatein AND intdate <= $intdateout ";
		// echo $sql;
		// die();
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["price"] = $row->price;
				$deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["singleuseprice"] = $row->singleuseprice;
			}
		}
		
		$deskofdays_restricted = array ();
		if ($restrict == 1) {
			
			$sql = "SELECT * FROM deskofrate";
			// echo $sql;
			// die();
			$query = $this->db->query ( $sql );
			if ($query->num_rows () > 0) {
				foreach ( $query->result () as $row ) {
					$deskofdays_restricted [$row->category_id] [$row->rate_id] [$row->intdate] ["closed"] = $row->closed;
					// $deskofdays_restricted [$row->category_id]
					// [$row->rate_id] [$row->intdate] ["closedonarrival"] =
					// $row->closedonarrival;
				}
			}
		}
		// echo "<pre>";
		// print_r($deskofdays_restricted);
		// die();
		$restrict_id = 0;
		$query = $this->db->query ( "SELECT restrict_id FROM dc_hostelworld_rate_link " );
		
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$restrict_id = $row->restrict_id;
		}
		// echo $rate_strategy;
		// fill array with perday price
		$rooms_price = array ();
		$sql = "SELECT seasonspricelist.rate_id, categories.id AS hms_category_id,deskofdaysseason.intdate, categories.base_price, seasonspricelist.price, seasonspricelist.price1, seasonspricelist.price2,
			seasonspricelist.price3, seasonspricelist.price4, seasonspricelist.price5,
			seasonspricelist.price6, seasonspricelist.price7,
			seasonspricelist.singleuse_price, seasonspricelist.singleuse_price1, seasonspricelist.singleuse_price2,
			seasonspricelist.singleuse_price3, seasonspricelist.singleuse_price4, seasonspricelist.singleuse_price5,
			seasonspricelist.singleuse_price6, seasonspricelist.singleuse_price7
	
			FROM rate
			INNER JOIN seasonspricelist ON seasonspricelist.rate_id = rate.id
			INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
			INNER JOIN deskofdaysseason ON seasons.id = deskofdaysseason.seasonid
			INNER JOIN categories ON categories.id = seasonspricelist.category_id
			INNER JOIN dc_hostelworld_room_categories_link ON categories.id = dc_hostelworld_room_categories_link.hms_category_id
			WHERE categories.is_active =1
			AND seasons.is_active =1
			AND rate.id = $rate_id
			AND deskofdaysseason.intdate >=$intdatein
			AND deskofdaysseason.intdate <=$intdateout
			ORDER BY category_id, intdate";
		// echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price;
			}
		}
		
		// echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$rooms_price [$row->hms_category_id] [$row->intdate] = $row->base_price;
				
				$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price;
				
				$week_day = date ( "w", $row->intdate * 86400 );
				$price = 0;
				
				// if ($restrict_id != 0) {
				
				if (isset ( $deskof_restrictedprice [$row->hms_category_id] [$row->rate_id] [$row->intdate] ["price"] )) {
					$price = $deskof_restrictedprice [$row->hms_category_id] [$row->rate_id] [$row->intdate] ["price"];
					
					$rooms_price [$row->hms_category_id] [$row->intdate] = $price;
				} 				// }
				else {
					switch ($rate_strategy) {
						case 1 :
							$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price;
							
							break;
						case 2 :
							switch ($week_day) {
								case 1 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price1;
									
									break;
								case 2 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price2;
									
									break;
								case 3 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price3;
									
									break;
								case 4 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price4;
									
									break;
								case 5 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price5;
									
									break;
								case 6 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price6;
									
									break;
								case 0 :
									$rooms_price [$row->hms_category_id] [$row->intdate] = $row->price7;
									
									break;
							}
							break;
					}
				}
			}
		}
		
		$sql = "SELECT dc_category_id, categories.id AS hms_category_id, categories.id AS places, COUNT( rooms.id ) AS count_rooms
FROM  `rooms`
INNER JOIN categories ON categories.id = rooms.category_id
INNER JOIN dc_hostelworld_room_categories_link ON categories.id = dc_hostelworld_room_categories_link.hms_category_id
WHERE 1
GROUP BY dc_category_id, rooms.category_id";
		$dc_rooms = array ();
		$result = array ();
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$sql = "select min, max from dc_hostelworld_room_categories_link where hms_category_id =" . $row->hms_category_id;
				$query2 = $this->db->query ( $sql );
				if ($query2->num_rows () > 0) {
					$row2 = $query2->row ();
					$min = $row2->min;
					$max = $row2->max;
				} else {
					$min = 0;
					$max = 999;
				}
				for($i = $intdatein; $i <= $intdateout; $i ++) {
					$dc_rooms [$row->hms_category_id] [$i] ['places'] = $categories_beds [$row->hms_category_id];
					$dc_rooms [$row->hms_category_id] [$i] ["dc_category_id"] = $row->dc_category_id;
					$dc_rooms [$row->hms_category_id] [$i] ["date_start"] = gmdate ( "Y-m-d", $i * 86400 );
					$dc_rooms [$row->hms_category_id] [$i] ["date_end"] = gmdate ( "Y-m-d", $i * 86400 );
					$dc_rooms [$row->hms_category_id] [$i] ["count"] = $row->count_rooms;
					if (isset ( $rooms_occupied [$row->hms_category_id] [$i] )) {
						$dc_rooms [$row->hms_category_id] [$i] ["count"] -= $rooms_occupied [$row->hms_category_id] [$i];
					}
					if (isset ( $rooms_occupied_overbook [$row->hms_category_id] [$i] )) {
						$dc_rooms [$row->hms_category_id] [$i] ["count"] -= $rooms_occupied_overbook [$row->hms_category_id] [$i];
					}
					if ($dc_rooms [$row->hms_category_id] [$i] ["count"] < 0) {
						$dc_rooms [$row->hms_category_id] [$i] ["count"] = 0;
					}
					
					// Параметры загружености
					
					if ($dc_rooms [$row->hms_category_id] [$i] ["count"] > $min) {
						$dc_rooms [$row->hms_category_id] [$i] ["count"] = $dc_rooms [$row->hms_category_id] [$i] ["count"] - $min;
					} else {
						$dc_rooms [$row->hms_category_id] [$i] ["count"] = 0;
					}
					
					if ($dc_rooms [$row->hms_category_id] [$i] ["count"] > $max) {
						$dc_rooms [$row->hms_category_id] [$i] ["count"] = $max;
					}
					
					if ($restrict == 1) {
						if (isset ( $deskofdays_restricted [$row->hms_category_id] [$restrict_id] [$i] ["closed"] )) {
							if ($deskofdays_restricted [$row->hms_category_id] [$restrict_id] [$i] ["closed"] == 1) {
								$dc_rooms [$row->hms_category_id] [$i] ["count"] = 0;
							}
						}
						
						// if (isset($deskofdays_restricted
						// [$row->hms_category_id] [$restrict_id] [$i]
						// ["closedonarrival"])){
						// $dc_rooms [$row->hms_category_id] [$i] ["count"] = 0;
						// }
					}
					
					// END Параметры загружености
					$dc_rooms [$row->hms_category_id] [$i] ["beds"] = $dc_rooms [$row->hms_category_id] [$i] ["count"] * $dc_rooms [$row->hms_category_id] [$i] ['places'];
					if (isset ( $rooms_price [$row->hms_category_id] [$i] )) {
						$dc_rooms [$row->hms_category_id] [$i] ['price'] = $this->frontdesk->dc_currency ( $rooms_price [$row->hms_category_id] [$i] / $dc_rooms [$row->hms_category_id] [$i] ['places'] );
						$dc_rooms [$row->hms_category_id] [$i] ['price22'] = $rooms_price [$row->hms_category_id] [$i];
					} else {
						$dc_rooms [$row->hms_category_id] [$i] ['price'] = 0;
					}
					/*
					 * if (isset ( $rooms_yield [$row->hms_category_id] [$i] )) { $dc_rooms [$row->hms_category_id] [$i] ['price'] = $rooms_yield [$row->hms_category_id] [$i]; }
					 */
					
					// array_push ( $result, $dc_rooms [$row->hms_category_id]
					// [$i] );
				}
			}
		}
		
		$categories_rooms_all_new = $dc_rooms;
		$count_arr = count ( $categories_rooms_all_new );
		
		$count = sizeof ( $categories_rooms_all_new );
		
		$array_keys = array_keys ( $categories_rooms_all_new );
		foreach ( $array_keys as $key ) {
			$j = $intdatein;
			for($i = $intdatein + 1; $i <= $intdateout; $i ++) {
				$count_1 = $categories_rooms_all_new [$key] [$i] ["count"];
				$count_2 = $categories_rooms_all_new [$key] [$j] ["count"];
				$room_category_1 = $categories_rooms_all_new [$key] [$i] ["dc_category_id"];
				$room_category_2 = $categories_rooms_all_new [$key] [$j] ["dc_category_id"];
				$room_category_1 = $categories_rooms_all_new [$key] [$i] ["dc_category_id"];
				$room_category_2 = $categories_rooms_all_new [$key] [$j] ["dc_category_id"];
				
				$room_price_1 = $categories_rooms_all_new [$key] [$i] ["price"];
				$room_price_2 = $categories_rooms_all_new [$key] [$j] ["price"];
				
				if ($room_category_1 == $room_category_2 and $count_1 == $count_2 and $room_price_1 == $room_price_2) {
					// $categories_rooms_all_new [$key] [$j] ["hotel"] =
					// $categories_rooms_all_new [$key] [$i] ["hotel"];
					$categories_rooms_all_new [$key] [$j] ["date_end"] = $categories_rooms_all_new [$key] [$i] ["date_end"];
					unset ( $categories_rooms_all_new [$key] [$i] );
				} else {
					$j = $i;
				}
			}
		}
		
		// print_r($categories_rooms_all_new);
		
		$category_keys = array_keys ( $categories_rooms_all_new );
		$roomsresult = array ();
		foreach ( $category_keys as $category_id ) {
			for($i = $intdatein; $i <= $intdateout; $i ++) {
				if (isset ( $categories_rooms_all_new [$category_id] [$i] ))
					array_push ( $roomsresult, $categories_rooms_all_new [$category_id] [$i] );
			}
		}
		
		$result_mass = array ();
		$k = 0;
		foreach ( $category_keys as $category_id ) {
			for($i = $intdatein; $i <= $intdateout; $i ++) {
				if (isset ( $categories_rooms_all_new [$category_id] [$i] )) {
					$dc_category_id = $categories_rooms_all_new [$category_id] [$i] ["dc_category_id"];
					$result_mass [$dc_category_id] ["dc_category_id"] = $dc_category_id;
					$result_mass [$dc_category_id] ["range"] [$k] = $categories_rooms_all_new [$category_id] [$i];
					$k ++;
				}
			}
		}
		
		// echo "<pre>";
		// print_r($roomsresult);
		// die();
		return $result_mass;
	}
	function options_save($data) {
		$data_1 = $this->Loger_admin->get_values_col("dc_hostelworld_xml_cfg");
		
		$sql = "INSERT INTO dc_hostelworld_xml_cfg (name, int_value) VALUES('dealer_id', '" . $data ["dealer"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["dealer"];
		$query = $this->db->query ( $sql );
		$sql = "INSERT INTO dc_hostelworld_xml_cfg (name, int_value) VALUES('overbooking_category_id', '" . $data ["overbooking_category"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["overbooking_category"];
		$query = $this->db->query ( $sql );
		$sql = "INSERT INTO dc_hostelworld_xml_cfg (name, int_value) VALUES('general_update', '" . $data ["general_update"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["general_update"];
		$query = $this->db->query ( $sql );
		$sql = "INSERT INTO dc_hostelworld_xml_cfg (name, int_value) VALUES('version', '" . $data ["version"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["version"];
		$query = $this->db->query ( $sql );
		
		$data_2 = $this->Loger_admin->get_values_col("dc_hostelworld_xml_cfg");
		$this->Loger_admin->SaveLog_col($data_1, $data_2, "loger_admin", "dc_hostelworld_xml_cfg", "edit");
	}
	function gethotelid() {
		$query = $this->db->query ( "SELECT int_value FROM dc_hostelworld_xml_cfg WHERE name LIKE 'hotel_id'" );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$hotel_id = $row->int_value;
		} else {
			$hotel_id = "none";
		}
		return $hotel_id;
	}
	function get_version() {
		$query = $this->db->query ( "SELECT int_value FROM dc_hostelworld_xml_cfg WHERE name LIKE 'version'" );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$version = $row->int_value;
		} else {
			$version = 1;
		}
		return $version;
	}
	function update_rooms($data, $restrict = array()) {
		return $data;
	}
	function get_bookings_withID($dc_reservation_id) {
	}
	function get_bookings_OLD($data, $host = "") {
		$debug = true;
		if ($this->session->userdata ( 'global_debug' ) == 1) {
			$debug = true;
		}
		// echo $str_data;
	
		$category_places_array = array ();
		$query = $this->db->query ( "SELECT IF( baseplace> 0, baseplace, categories.places) as occupancy, categories.id FROM categories
				INNER JOIN ratetocategory ON ratetocategory.category_id = categories.id
				INNER JOIN dc_hostelworld_rate_link ON dc_hostelworld_rate_link.hms_rate_id = ratetocategory.rate_id " );
	
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$category_places_array [$row->id] = $row->occupancy;
			}
		}
	
		$currency_array = array ();
		$query = $this->db->query ( "SELECT * FROM  `global_hotelix`.currency" );
	
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$currency_array [$row->name] = $row->code;
			}
		}
	
		$rates = array ();
	
		$query = $this->db->query ( "SELECT hms_rate_id, dc_rate_id FROM  dc_hostelworld_rate_link" );
	
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$rates [$row->dc_rate_id] = $row->hms_rate_id;
			}
		}
		$hms_rate_id = 0;
		$query = $this->db->query ( "SELECT hms_rate_id, dc_rate_id FROM  dc_hostelworld_rate_link" );
	
		if ($query->num_rows () > 0) {
			$row = $query->row ();
				
			$hms_rate_id = $row->hms_rate_id;
		}
	
		$categories = array ();
	
		$query = $this->db->query ( "SELECT dc_category_id, hms_category_id FROM dc_hostelworld_room_categories_link" );
	
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$categories [$row->dc_category_id] = $row->hms_category_id;
			}
		}
	
		$query = $this->db->query ( "SELECT id FROM rate WHERE isdefault = 1" );
	
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$price_type = $row->id;
		}
	
		$query = $this->db->query ( "SELECT int_value FROM dc_hostelworld_xml_cfg WHERE name LIKE 'dealer_id'" );
	
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$dealer = $row->int_value;
		}
	
		$query = $this->db->query ( "SELECT int_value FROM dc_hostelworld_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
	
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$overbooking_category_id = $row->int_value;
		}
	
		$result_array = array ();
		if (isset ( $data ["result"] ["bookings"] )) {
				
			$count_reservations = count ( $data ["result"] ["bookings"] );
			for($i = 0; $i < $count_reservations; $i ++) {
				$dc_res_mass = explode ( "-", $data ["result"] ["bookings"] [$i] ["ref"] );
	
				$result_array [$i] ["reservation"] ['groupid'] = $data ["result"] ["bookings"] [$i] ["ref"];
				$result_array [$i] ['status'] = "new";
				$result_array [$i] ["reservation"] ['dc_reservationid'] = $dc_res_mass [0];
				$result_array [$i] ["reservation"] ['dc_roomreservation_id'] = $dc_res_mass [1];
	
				// $result_array [$i] ["reservation"] ['dc_currencycode'] =
				// $currency_array [$data ["result"] ["bookings"] [$i]
				// ["currency"]];
				$result_array [$i] ["reservation"] ['dc_currencycode'] = $data ["result"] ["bookings"] [$i] ["currency"];
				$result_array [$i] ["reservation"] ['discount'] = 0;
				$result_array [$i] ["reservation"] ["user"] = - 1;
				$result_array [$i] ["reservation"] ["isNew"] = 1;
				$result_array [$i] ["reservation"] ["dc_id"] = 8;
				$result_array [$i] ["reservation"] ["dealer"] = $dealer;
				$result_array [$i] ["reservation"] ["price_type"] = $hms_rate_id;
	
				$result_array [$i] ["reservation"] ["due"] = $data ["result"] ["bookings"] [$i] ["due"];
				$result_array [$i] ["reservation"] ["paid"] = $data ["result"] ["bookings"] [$i] ["paid"];
				// $result_array [$i] ["reservation"] ["dc_totalprice"] = (
				// string )
				// $response->ReservationsList->HotelReservation->ResGlobalInfo->Fees->Fee
				// ['Amount'];
				$result_array [$i] ["reservation"] ["dc_totalprice"] = 0;
				$j = 0;
				$count_room = 0;
				foreach ( $data ["result"] ["bookings"] [$i] ["roomnights"] as $dc_type_id => $dates ) {
					$temp_i = 0;
					foreach ( $dates as $key_date => $dates_prices ) {
						foreach ( $dates_prices as $key_price => $count_room_value ) {
							list ( $year, $month, $day ) = explode ( "-", $key_date );
							$date = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
							$result_array [$i] ["reservation"] ["dc_rate_intdate_data"] [$temp_i] ["dc_roomreservation_id"] = $result_array [$i] ["reservation"] ['dc_roomreservation_id'];
							$result_array [$i] ["reservation"] ["dc_rate_intdate_data"] [$temp_i] ["dc_rate_id"] = 1;
							$result_array [$i] ["reservation"] ["dc_rate_intdate_data"] [$temp_i] ["intdate"] = $date;
							$result_array [$i] ["reservation"] ["dc_rate_intdate_data"] [$temp_i] ["date_rate"] = $key_date;
							$result_array [$i] ["reservation"] ["dc_rate_intdate_data"] [$temp_i] ["price"] = $key_price;
							$result_array [$i] ["reservation"] ["dc_rate_intdate_data"] [$temp_i] ["dc_currencycode"] = $result_array [$i] ["reservation"] ['dc_currencycode'];
								
							$result_array [$i] ["reservation"] ["dc_totalprice"] += $key_price;
							$temp_i ++;
						}
					}
						
					foreach ( $dates as $key_date => $dates_prices ) {
						foreach ( $dates_prices as $key_price => $count_room_value ) {
							$count_room = $count_room_value;
							break;
						}
						break;
					}
						
					$result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_type_id"] = $dc_type_id;
					$result_array [$i] ["reservation"] ["roomnights"] [$j] ["hms_type_id"] = $categories [$dc_type_id];
						
					if (isset ( $category_places_array [$categories [$dc_type_id]] )) {
						$places = $category_places_array [$categories [$dc_type_id]];
						$result_array [$i] ["reservation"] ["count_room"] = ceil ( $count_room / $places );
					}
					if (isset ( $result_array [$i] ["reservation"] ["count_room"] )) {
						for($r = 1; $r <= $result_array [$i] ["reservation"] ["count_room"]; $r ++) {
							if ($count_room <= $places) {
								$result_array [$i] ["reservation"] ["count_guests"] [$r] = $count_room;
								break;
							} else {
								$result_array [$i] ["reservation"] ["count_guests"] [$r] = $places;
								$count_room = $count_room - $places;
							}
						}
					}
					// $result_array [$i] ["reservation"] ["count_room"] =
					// $count_room;
						
					$result_array [$i] ["reservation"] ["dc_guestname"] = $data ["result"] ["bookings"] [$i] ["firstname"] . " " . $data ["result"] ["bookings"] [$i] ["lastname"];
						
					$date = array_keys ( $dates );
						
					if (count ( $date ) > 1) {
						$datein = $date [0];
						$last = count ( $date ) - 1;
						$dateout_temp = $date [$last];
						list ( $year, $month, $day ) = explode ( "-", $dateout_temp );
						$intdate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
						$dateout = date ( "Y-m-d", ($intdate + 1) * 86400 );
					} else {
						$datein = $date [0];
						list ( $year, $month, $day ) = explode ( "-", $datein );
						$intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
						$dateout = date ( "Y-m-d", ($intdatein + 1) * 86400 );
					}
						
					$result_array [$i] ["reservation"] ["roomnights"] [$j] ["datein"] = $datein;
					$result_array [$i] ["reservation"] ["roomnights"] [$j] ["dateout"] = $dateout;
						
					$result_array [$i] ["reservation"] ["roomnights"][$j]["dc_uuid"] = $result_array [$i] ["reservation"] ['dc_reservationid'] . "_" . $result_array [$i] ["reservation"] ['dc_roomreservation_id'] . "_" . $j;
					$j ++;
				}
	
				$guest = array ();
				$result_array [$i] ["guest"] ['firstname'] = $data ["result"] ["bookings"] [$i] ["firstname"];
				$result_array [$i] ["guest"] ['lastname'] = $data ["result"] ["bookings"] [$i] ["lastname"];
				$result_array [$i] ["guest"] ['phone'] = $data ["result"] ["bookings"] [$i] ["phone"];
				$result_array [$i] ["guest"] ['email'] = $data ["result"] ["bookings"] [$i] ["email"];
				$result_array [$i] ["guest"] ['nationality'] = $data ["result"] ["bookings"] [$i] ["nationality"];
				switch ($data ["result"] ["bookings"] [$i] ["gender"] ["type"]) {
					case "MALE" :
						$gender = 1;
						break;
					case "FAMALE" :
						$gender = 2;
						break;
				}
				// $result_array [$i] ["reservation"] ['gender'] = $gender;
			}
		}
		if ($debug == true) {
			echo "<pre>";
			print_r ( $result_array );
		}
		// die ();
	
		$cancellations_array = array ();
		if (isset ( $data ["result"] ["cancellations"] )) {
				
			$count_cancellations_reservations = count ( $data ["result"] ["cancellations"] );
			for($i = 0; $i < $count_cancellations_reservations; $i ++) {
				$dc_res_mass = explode ( "-", $data ["result"] ["cancellations"] [$i] ["ref"] );
				$cancellations_array [$i] ['groupid'] = $data ["result"] ["cancellations"] [$i] ["ref"];
				$cancellations_array [$i] ['dc_reservationid'] = $dc_res_mass [0];
				$cancellations_array [$i] ['dc_roomreservation_id'] = $dc_res_mass [1];
				$cancellations_array [$i] ['reason'] = $data ["result"] ["cancellations"] [$i] ["reason"];
			}
		}
		if ($debug == true) {
			echo "<pre>";
			print_r ( $cancellations_array );
			// die();
		}
		$reservationpush = array ();
		$k = 0;
		if (isset ( $result_array )) {
			$count_array = count ( $result_array );
				
			for($i = 0; $i < $count_array; $i ++) {
				$count_rooms = count ( $result_array [$i] ["reservation"] ["roomnights"] );
				for($j = 0; $j < $count_rooms; $j ++) {
					$bool_guest = 0;
					$datein = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["datein"];
					$dateout = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dateout"];
					$type_id = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["hms_type_id"];
					$result_array [$i] ["reservation"] ["datein"] = $datein;
					$result_array [$i] ["reservation"] ["dateout"] = $dateout;
					$result_array [$i] ["reservation"] ["type_id"] = $type_id;
					$dc_uuid = $result_array [$i] ["reservation"] ["roomnights"] [$j]["dc_uuid"];
						
					if (isset ( $result_array [$i] ["reservation"] ["dc_rate_intdate_data"] )) {
						$this->dc_rate_intdate_insert ( $result_array [$i] ["reservation"] ["dc_rate_intdate_data"] );
					}
						
					$query = $this->db->query ( "SELECT id FROM deskofreservation WHERE deleted = 0 AND dc_reservationid = " . $result_array [$i] ["reservation"] ["dc_reservationid"] . " AND dc_uuid LIKE '" . $dc_uuid ."'" );
					$hms_reservation_id = 0;
					if ($query->num_rows () > 0) {
						$row = $query->row ();
						$hms_reservation_id = $row->id;
					}
						
					$sql = "SELECT id, room_id FROM deskofreservation WHERE deleted = 0 AND dc_reservationid = " . $result_array [$i] ["reservation"] ["dc_reservationid"] . " AND dc_uuid LIKE '" . $dc_uuid ."'";
					// echo $sql . "<br>";
					$query = $this->db->query ( $sql );
						
					if ($query->num_rows () > 0) {
	
						foreach ( $query->result () as $row ) {
								
							$reservation_data = $this->frontdesk->GetReservation ( $row->id );
								
							// echo "<pre>";
							// print_r($reservation_data);
							$reservation_data ["user"] = $result_array [$i] ["reservation"] ["user"];
							$reservation_data ["firstname"] = $result_array [$i] ["guest"] ["firstname"];
							$reservation_data ["lastname"] = $result_array [$i] ["guest"] ["lastname"];
							$reservation_data ["phone"] = $result_array [$i] ["guest"] ["phone"];
							$reservation_data ["email"] = $result_array [$i] ["guest"] ["email"];
							$reservation_data ["datein"] = $result_array [$i] ["reservation"] ["datein"];
							$reservation_data ["dateout"] = $result_array [$i] ["reservation"] ["dateout"];
							$reservation_data ["price_type"] = $hms_rate_id;
							$reservation_data ["room_id"] = 0;
								
							$reservation_data ["type_id"] = $type_id;
							$reservation_data ["guest_id_new"] = 0;
							$reservation_data ["free_places"] = 0;
							$reservation_data ["maid_description"] = "";
							$reservation_data ["isread"] = 0;
							$reservation_data ["dc_currencycode"] = $result_array [$i] ["reservation"] ["dc_currencycode"];
								
							$reservation_data ["room_id"] = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $type_id, 0, $reservation_data ["reservation_id"] );
								
							if ($reservation_data ["room_id"] == 0) {
								if (isset ( $overbooking_category_id )) {
									$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $overbooking_category_id, 0, $reservation_data ["reservation_id"] );
									$reservation_data ["origin_categoryid"] = $reservation_data ["type_id"];
									$reservation_data ["room_id"] = $room_id;
									$reservation_data ["type_id"] = $overbooking_category_id;
									$update_res = $this->frontdesk->UpdateReservation ( $reservation_data, 0, 1 );
									if ($update_res == "FreeError") {
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "error";
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "Not Free rooms";
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "update";
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_status"] = "";
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = $row->id;
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
	
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_name"] = $result_array [$i] ["reservation"] ["dc_guestname"];
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_phone"] = $result_array [$i] ["guest"] ['phone'];
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_email"] = $result_array [$i] ["guest"] ['email'];
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["date"] = "";
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["datein"] = $datein;
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dateout"] = $dateout;
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["rates"] = $result_array [$i] ["reservation"] ["dc_rate_intdate_data"];
										$k ++;
									} else {
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "ok";
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "overbooking transfer";
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "update";
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_status"] = "";
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = $row->id;
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
	
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_name"] = $result_array [$i] ["reservation"] ["dc_guestname"];
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_phone"] = $result_array [$i] ["guest"] ['phone'];
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_email"] = $result_array [$i] ["guest"] ['email'];
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["date"] = "";
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["datein"] = $datein;
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dateout"] = $dateout;
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["rates"] = $result_array [$i] ["reservation"] ["dc_rate_intdate_data"];
										$k ++;
									}
								} else {
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "error";
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "Not Free rooms (overbooking not set)";
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "update";
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_status"] = "";
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = $row->id;
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
										
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_name"] = $result_array [$i] ["reservation"] ["dc_guestname"];
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_phone"] = $result_array [$i] ["guest"] ['phone'];
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_email"] = $result_array [$i] ["guest"] ['email'];
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["date"] = "";
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["datein"] = $datein;
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dateout"] = $dateout;
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["rates"] = $result_array [$i] ["reservation"] ["dc_rate_intdate_data"];
									$k ++;
								}
							} else {
								// print_r($reservation_data);
								$calculate_data = array ();
								$calculate_data ["type_id"] = $reservation_data ["type_id"];
								$calculate_data ["datein"] = $reservation_data ["datein"];
								$calculate_data ["dateout"] = $reservation_data ["dateout"];
								$calculate_data ["add_places"] = 0;
								$calculate_data ["baby_places"] = 0;
								$calculate_data ["addbedplace"] = 0;
								$calculate_data ["babyplace2"] = 0;
								$calculate_data ["price_type"] = $hms_rate_id;
	
								$temp_amount = $this->frontdesk->getpricecalculation ( $calculate_data );
								$otelms_amount = 0;
								for($h = 0; $h < count ( $temp_amount ); $h ++) {
									$otelms_amount += $temp_amount [$h] ["amount"];
								}
	
								$booking_amount = $result_array [$i] ["reservation"] ["dc_totalprice"];
								$addons_sum = 0;
								if (($booking_amount - $addons_sum) != $otelms_amount) {
									if ($otelms_amount != 0) {
										$reservation_data ["discount"] = $otelms_amount - ($booking_amount - $addons_sum);
									}
								}
	
								$update_res = $this->frontdesk->UpdateReservation ( $reservation_data, 0, 1 );
								if ($update_res == "FreeError") {
										
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "error";
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "Not Free rooms (overbooking not set)";
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "update";
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_status"] = "";
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = $row->id;
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
										
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_name"] = $result_array [$i] ["reservation"] ["dc_guestname"];
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_phone"] = $result_array [$i] ["guest"] ['phone'];
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_email"] = $result_array [$i] ["guest"] ['email'];
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["date"] = "";
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["datein"] = $datein;
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dateout"] = $dateout;
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["rates"] = $result_array [$i] ["reservation"] ["dc_rate_intdate_data"];
									$k ++;
								} else {
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "ok";
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "";
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "update";
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_status"] = "";
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = $row->id;
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
										
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_name"] = $result_array [$i] ["reservation"] ["dc_guestname"];
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_phone"] = $result_array [$i] ["guest"] ['phone'];
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_email"] = $result_array [$i] ["guest"] ['email'];
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["date"] = "";
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["datein"] = $datein;
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dateout"] = $dateout;
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["rates"] = $result_array [$i] ["reservation"] ["dc_rate_intdate_data"];
									$k ++;
								}
							}
						}
					} else {
	
						if (isset ( $result_array [$i] ["reservation"] ["count_room"] )) {
								
							for($r = 1; $r <= $result_array [$i] ["reservation"] ["count_room"]; $r ++) {
	
								$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $type_id );
	
								if ($room_id == 0) {
										
									$result_array [$i] ["reservation"] ["origin_categoryid"] = $type_id;
									if (isset ( $overbooking_category_id )) {
										$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $overbooking_category_id );
										$result_array [$i] ["reservation"] ["type_id"] = $overbooking_category_id;
									} else {
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "failed";
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "no overbooking_category_id";
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "new";
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = 0;
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_room_id"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_type_id"];
	
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_name"] = $result_array [$i] ["reservation"] ["dc_guestname"];
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_phone"] = $result_array [$i] ["guest"] ['phone'];
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_email"] = $result_array [$i] ["guest"] ['email'];
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["date"] = "";
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["datein"] = $datein;
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dateout"] = $dateout;
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["rates"] = $result_array [$i] ["reservation"] ["dc_rate_intdate_data"];
										$k ++;
									}
								}
	
								$result_array [$i] ["reservation"] ["room_id"] = $room_id;
	
								if ($result_array [$i] ["reservation"] ["room_id"] == 0) {
										
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "failed";
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "dc_reservationid = " . $result_array [$i] ["reservation"] ['groupid'];
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["fff"] = $result_array [$i] ["reservation"] ['groupid'];
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "new";
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_status"] = "";
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = 0;
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_room_id"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_type_id"];
										
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_name"] = $result_array [$i] ["reservation"] ["dc_guestname"];
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_phone"] = $result_array [$i] ["guest"] ['phone'];
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_email"] = $result_array [$i] ["guest"] ['email'];
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["date"] = "";
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["datein"] = $datein;
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dateout"] = $dateout;
									$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["rates"] = $result_array [$i] ["reservation"] ["dc_rate_intdate_data"];
									$k ++;
								} else {
									if ($bool_guest == 0) {
										$guest_id = $this->frontdesk->Guest_insert ( $result_array [$i] ["guest"] );
										$bool_guest = 1;
									}
										
									$calculate_data = array ();
									$calculate_data ["type_id"] = $result_array [$i] ["reservation"] ["type_id"];
									$calculate_data ["datein"] = $result_array [$i] ["reservation"] ["datein"];
									$calculate_data ["dateout"] = $result_array [$i] ["reservation"] ["dateout"];
									$calculate_data ["add_places"] = 0;
									$calculate_data ["baby_places"] = 0;
									$calculate_data ["addbedplace"] = 0;
									$calculate_data ["babyplace2"] = 0;
									$calculate_data ["price_type"] = $hms_rate_id;
										
									$temp_amount = $this->frontdesk->getpricecalculation ( $calculate_data );
									$otelms_amount = 0;
									for($h = 0; $h < count ( $temp_amount ); $h ++) {
										$otelms_amount += $temp_amount [$h] ["amount"];
									}
										
									$booking_amount = $result_array [$i] ["reservation"] ["dc_totalprice"];
									$addons_sum = 0;
									if (($booking_amount - $addons_sum) != $otelms_amount) {
										if ($otelms_amount != 0) {
											$result_array [$i] ["reservation"] ["discount"] = $otelms_amount - ($booking_amount - $addons_sum);
										}
									}
									$result_array [$i] ["reservation"] ["dc_numberofguest"] = $result_array [$i] ["reservation"] ["count_guests"] [$r];
									$reservation_id = $this->frontdesk->Reservation_insert ( $result_array [$i] ["reservation"], $guest_id, 0, 1 );
									if (isset ( $result_array [$i] ["card"] )) {
										$this->frontdesk->insert_tbl_CreditCards ( $result_array [$i] ["card"], $guest_id, $reservation_id );
									}
										
									if ($reservation_id > 0) {
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "ok";
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "";
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "new";
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_status"] = "";
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = $reservation_id;
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_room_id"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_type_id"];
	
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_name"] = $result_array [$i] ["reservation"] ["dc_guestname"];
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_phone"] = $result_array [$i] ["guest"] ['phone'];
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_email"] = $result_array [$i] ["guest"] ['email'];
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["date"] = "";
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["datein"] = $datein;
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dateout"] = $dateout;
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["rates"] = $result_array [$i] ["reservation"] ["dc_rate_intdate_data"];
										$k ++;
									} else {
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "failed";
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "undferror";
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "new";
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_status"] = "";
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = 0;
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_room_id"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_type_id"];
	
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_name"] = $result_array [$i] ["reservation"] ["dc_guestname"];
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_phone"] = $result_array [$i] ["guest"] ['phone'];
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_email"] = $result_array [$i] ["guest"] ['email'];
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["date"] = "";
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["datein"] = $datein;
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dateout"] = $dateout;
										$reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["rates"] = $result_array [$i] ["reservation"] ["dc_rate_intdate_data"];
										$k ++;
									}
								}
							}
						}
					}
				}
			}
		}
	
		$count_cancellations_array = count ( $cancellations_array );
		for($i = 0; $i < $count_cancellations_array; $i ++) {
			$time2 = date ( "Y-m-d H:i:s" );
			$status = 5;
				
			$query = $this->db->query ( "SELECT id as hms_reservation_id, room_id FROM deskofreservation WHERE deleted = 0 AND dc_reservationid = " . $cancellations_array [$i] ["dc_reservationid"] . " AND dc_roomreservation_id = " . $cancellations_array [$i] ["dc_roomreservation_id"] );
				
			if ($query->num_rows () > 0) {
				foreach ( $query->result () as $row ) {
					$hms_reservation_id = $row->hms_reservation_id;
					$query2 = $this->db->query ( "SELECT id FROM  services_main WHERE reservation_id = " . $hms_reservation_id . " AND type = 2" );
						
					if ($query2->num_rows () > 0) {
						$reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["response"] = "failed";
						$reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["text"] = "есть уже отмена";
						$reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["status"] = "cancel";
	
						$reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["hms_reservation_id"] = $hms_reservation_id;
						$reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["dc_reservationid"] = $cancellations_array [$i] ["dc_reservationid"] . "-" . $cancellations_array [$i] ["dc_roomreservation_id"];
						$k ++;
					} else {
						$query2 = $this->db->query ( "SELECT id FROM deskofreservation WHERE dc_roomreservation_id = " . $cancellations_array [$i] ["dc_roomreservation_id"] );
	
						if ($query2->num_rows () > 0) {
							$data_cancel = array ();
								
							$data_cancel ["res_id"] = $hms_reservation_id;
							$data_cancel ["charge"] = 0;
							$data_cancel ["status"] = $status;
							$data_cancel ["description"] = "cancel from HW";
							$data_cancel ["guestbe_request"] = 0;
							$data_cancel ["user"] = - 1;
							// ====================
							$this->Cancel->Insert ( $data_cancel );
							// ====================
							$reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["response"] = "ok";
							$reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["text"] = "";
							$reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["status"] = "cancel";
							$reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["hms_reservation_id"] = $hms_reservation_id;
							$reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["dc_reservationid"] = $cancellations_array [$i] ["dc_reservationid"] . "-" . $cancellations_array [$i] ["dc_roomreservation_id"];
							$k ++;
						} else {
							$reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["response"] = "failed";
							$reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["text"] = "нет брони для отмены";
							$reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["status"] = "cancel";
								
							$reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["hms_reservation_id"] = 0;
							$reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["dc_reservationid"] = $cancellations_array [$i] ["dc_reservationid"] . "-" . $cancellations_array [$i] ["dc_roomreservation_id"];
							$k ++;
						}
					}
				}
			} else {
				$reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["response"] = "failed";
				$reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["text"] = "нет брони для отмены";
				$reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["status"] = "cancel";
	
				$reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["hms_reservation_id"] = 0;
				$reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["dc_reservationid"] = $cancellations_array [$i] ["dc_reservationid"] . "-" . $cancellations_array [$i] ["dc_roomreservation_id"];
				$k ++;
			}
		}
		if ($debug == true) {
			print_r ( $reservationpush );
		}
		// die ();
		$result = array ();
		$result ["view_data"] = array ();
		$ack_bookings = array ();
		$i = 0;
		foreach ( $reservationpush as $key => $arg1 ) {
			foreach ( $arg1 as $arg ) {
				$data = array ();
				$data ["hms_reservation_id"] = $arg ["hms_reservation_id"];
				$data ['response'] = $arg ['response'];
				$data ['resid'] = $arg ['dc_reservationid'];
				$data ['dcname'] = "HW";
				$data ['text'] = $arg ['text'];
				$data ['status'] = $arg ['status'];
	
				$result ["view_data"] [$i] = $data;
	
				// $this->dc_model->send_notifyarray ( $data );
				if ($arg ['response'] == "ok" and ($arg ['status'] == "new" or $arg ['status'] == "update")) {
					$ack_bookings ["bookings"] [$arg ['dc_reservationid']] ['ref'] = $arg ['dc_reservationid'];
				}
	
				// must pull to LOG ORDERS
				$ack_bookings ["bookings"] [$arg ['dc_reservationid']] ['ref'] = $arg ['dc_reservationid'];
				// !!!!!
	
				// if ($arg ['response'] == "ok" and $arg ['status'] ==
				// "cancel") {
				// if ($arg ['response'] == "ok" ) {
				if ($arg ['status'] == "cancel") {
					$ack_bookings ["cancellations"] [$arg ['dc_reservationid']] ['ref'] = $arg ['dc_reservationid'];
				}
				$result ["ack_bookings"] = $ack_bookings;
				$i ++;
			}
		}
	
		foreach ( $reservationpush as $goupid => $arg1 ) {
			$msg = "";
			foreach ( $arg1 as $arg ) {
				if ($arg ["status"] == "new" or $arg ["status"] == "update" or $arg ["status"] == "cancel") {
					$data = array ();
					$data ["hms_reservation_id"] = $arg ["hms_reservation_id"];
					$data ['resid'] = $arg ['dc_reservationid'];
					$data ['response'] = $arg ['response'];
					$data ['text'] = $arg ['text'];
					if (isset ( $arg ['fff'] )) {
						$data ['fff'] = $arg ['fff'];
					}
					$data ['dcname'] = "HW";
					$data ['status'] = $arg ['status'];
					// $this->dc_model->send_notifyarray ( $data );
					// ==============================================
					if (isset ( $arg ['guest_name'] )) {
						$data ['guest_name'] = $arg ['guest_name'];
					}
					if (isset ( $arg ['guest_phone'] )) {
						$data ['guest_phone'] = $arg ['guest_phone'];
					}
					if (isset ( $arg ['guest_email'] )) {
						$data ['guest_email'] = $arg ['guest_email'];
					}
					if (isset ( $arg ['date'] )) {
						$data ['date'] = $arg ['date'];
					}
					if (isset ( $arg ['datein'] )) {
						$data ['arrival_date'] = $arg ['datein'];
					}
					if (isset ( $arg ['dateout'] )) {
						$data ['departure_date'] = $arg ['dateout'];
					}
					if (isset ( $arg ['rates'] )) {
						$data ['rates'] = $arg ['rates'];
					}
					$data ['template'] = 1;
					$data ['room_name'] = "";
					$dcname = $data ['dcname'];
					$data ['resid'] = $arg ["hms_reservation_id"];
					$msg .= $this->dc_model->msg_txt ( $data, false, $host );
				}
			}
			if ($msg != "") {
				$this->dc_model->send_notifyarray_dc ( $msg, $dcname, $goupid, false, $arg ["status"] );
			}
		}
	
		return $result;
	}
	
	function get_bookings($data, $host = "", $hms_id = 0) {
	    $debug = false;
	    if ($this->session->userdata ( 'global_debug' ) == 1) {
	        $debug = true;
	    }
	    $debug = true;
	    // echo $str_data;
	
	    // 	    $category_places_array = array ();
	    // 	    $query = $this->db->query ( "SELECT IF( baseplace> 0, baseplace, categories.places) as occupancy, categories.id FROM categories
	    // 				INNER JOIN ratetocategory ON ratetocategory.category_id = categories.id
	    // 				INNER JOIN dc_hostelworld_rate_link ON dc_hostelworld_rate_link.hms_rate_id = ratetocategory.rate_id " );
	
	    // 	    if ($query->num_rows () > 0) {
	    // 	        foreach ( $query->result () as $row ) {
	    // 	            $category_places_array [$row->id] = $row->occupancy;
	    // 	        }
	    // 	    }
	
	    $category_places_array = array ();
	    $query = $this->db->query ( "SELECT IF( baseplace> 0, baseplace, categories.places) as occupancy, categories.id FROM categories
                INNER JOIN dc_hostelworld_room_categories_link ON dc_hostelworld_room_categories_link.hms_category_id = categories.id
	            INNER JOIN dc_hostelworld_rate2category_link ON dc_hostelworld_rate2category_link.dc_category_id = dc_hostelworld_room_categories_link.dc_category_id
				INNER JOIN ratetocategory ON ratetocategory.category_id = dc_hostelworld_room_categories_link.hms_category_id
	            AND ratetocategory.rate_id = dc_hostelworld_rate2category_link.hms_rate_id" );
	
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            $category_places_array [$row->id] = $row->occupancy;
	        }
	    }
	
	    // 	    echo "<pre>";
	    // 	    print_r ( $category_places_array );
	
	    $currency_array = array ();
	    $query = $this->db->query ( "SELECT * FROM  `global_hotelix`.currency" );
	
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            $currency_array [$row->name] = $row->code;
	        }
	    }
	
	
	    //$hms_rate_id = 0;
	
	    $version = $this->get_version ();
	
	    switch ($version) {
	        case 1:
	            $rates = array ();
	            $query = $this->db->query ( "SELECT hms_rate_id, dc_rate_id FROM  dc_hostelworld_rate_link" );
	
	            if ($query->num_rows () > 0) {
	                foreach ( $query->result () as $row ) {
	                    $rates [$row->dc_rate_id] = $row->hms_rate_id;
	                }
	            }
	            break;
	        case 2:
	            $query = $this->db->query("SELECT hms_rate_id, dc_rate_id, dc_category_id FROM  dc_hostelworld_rate2category_link");
	            if ($query->num_rows() > 0) {
	                foreach ($query->result() as $row) {
	                    $rates[$row->dc_category_id][$row->dc_rate_id] = $row->hms_rate_id;
	                }
	            }
	            break;
	        default:
	            $rates = array ();
	            $query = $this->db->query ( "SELECT hms_rate_id, dc_rate_id FROM  dc_hostelworld_rate_link" );
	
	            if ($query->num_rows () > 0) {
	                foreach ( $query->result () as $row ) {
	                    $rates [$row->dc_rate_id] = $row->hms_rate_id;
	                }
	            }
	            break;
	    }
	
	    $categories = array ();
	
	    $query = $this->db->query ( "SELECT dc_category_id, hms_category_id FROM dc_hostelworld_room_categories_link" );
	
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            $categories [$row->dc_category_id] = $row->hms_category_id;
	        }
	    }
	
	    //print_r ( $categories );
	    $default_price_type = 0;
	    $query = $this->db->query ( "SELECT id FROM rate WHERE isdefault = 1" );
	
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $default_price_type = $row->id;
	    }
	
	    $query = $this->db->query ( "SELECT int_value FROM dc_hostelworld_xml_cfg WHERE name LIKE 'dealer_id'" );
	
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $dealer = $row->int_value;
	    }
	
	    $query = $this->db->query ( "SELECT int_value FROM dc_hostelworld_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
	
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $overbooking_category_id = $row->int_value;
	    }
	
	    $result_array = array ();
	    if (isset ( $data ["result"] ["bookings"] )) {
	
	        $count_reservations = count ( $data ["result"] ["bookings"] );
	        for($i = 0; $i < $count_reservations; $i ++) {
	            $dc_res_mass = explode ( "-", $data ["result"] ["bookings"] [$i] ["ref"] );
	
	            $result_array [$i] ["reservation"] ['groupid'] = $data ["result"] ["bookings"] [$i] ["ref"];
	            $result_array [$i] ['status'] = "new";
	            $result_array [$i] ["reservation"] ['dc_reservationid'] = $dc_res_mass [0];
	            $result_array [$i] ["reservation"] ['dc_roomreservation_id'] = $dc_res_mass [1];
	
	            // $result_array [$i] ["reservation"] ['dc_currencycode'] =
	            // $currency_array [$data ["result"] ["bookings"] [$i]
	            // ["currency"]];
	            $result_array [$i] ["reservation"] ['dc_currencycode'] = $data ["result"] ["bookings"] [$i] ["currency"];
	            $result_array [$i] ["reservation"] ['discount'] = 0;
	            $result_array [$i] ["reservation"] ["user"] = - 1;
	            $result_array [$i] ["reservation"] ["isNew"] = 1;
	            $result_array [$i] ["reservation"] ["dc_id"] = 8;
	            $result_array [$i] ["reservation"] ["dealer"] = $dealer;
	            //$result_array [$i] ["reservation"] ["price_type"] = $hms_rate_id;
	
	            $result_array [$i] ["reservation"] ["due"] = $data ["result"] ["bookings"] [$i] ["due"];
	            $result_array [$i] ["reservation"] ["paid"] = $data ["result"] ["bookings"] [$i] ["paid"];
	            $result_array [$i] ["reservation"] ["payment_amount"] = $data ["result"] ["bookings"] [$i] ["OTADue"];
	            // $result_array [$i] ["reservation"] ["dc_totalprice"] = (
	            // string )
	            // $response->ReservationsList->HotelReservation->ResGlobalInfo->Fees->Fee
	            // ['Amount'];
	            // $result_array [$i] ["reservation"] ["dc_totalprice"] = 0;
	             
	            // ========= CALCULATE PAX ===============
	            $pax = 0;
	            foreach ( $data ["result"] ["bookings"] [$i] ["roomnights"] as $dc_type_id => $dates ) {
	                foreach ( $dates as $key_date => $dates_prices ) {
	                    foreach ( $dates_prices as $key_price => $count_room_value ) {
	                        //$count_room = $count_room_value;
	                        $pax += $count_room_value['pax'];
	                        break;
	                    }
	                    break;
	                }
	            }
	             
	            if($pax == 0){
	                $pax = 1;
	            }
	            // ========= END CALCULATE PAX ===============
	            $j = 0;
	            $count_room = 0;
	            $dc_rate_id = 0;
	            foreach ( $data ["result"] ["bookings"] [$i] ["roomnights"] as $dc_type_id => $dates ) {
	                //echo 	$dc_type_id."<br>";
	                //$pax = 1;
	                foreach ( $dates as $key_date => $dates_prices ) {
	                    foreach ( $dates_prices as $key_price => $count_room_value ) {
	                        //$count_room = $count_room_value;
	                        //$pax = $count_room_value['pax'];
	                        if(isset($count_room_value['rooms'])){
	                           $count_room = $count_room_value['rooms'];
	                           $count_pax = $count_room_value['pax'];
	                        }else{
	                            $count_room = $count_room_value['pax'];
	                        }
	                        
	                        //$count_room = $count_room_value['pax'];
	                        $dc_rate_id = $count_room_value['rateplanid'];
	                        break;
	                    }
	                    break;
	                }
	
	                if (isset ( $category_places_array [$categories [$dc_type_id]] )) {
	                    //echo "--";
	                    $places = $category_places_array [$categories [$dc_type_id]];
	                    $result_array [$i] ["reservation"] ["count_room"] = ceil ( $count_room / $places );
	                }
	                
	                $result_array [$i] ["reservation"] ["count_room"] = $count_room;
	                
	                if (isset ( $result_array [$i] ["reservation"] ["count_room"] )) {
	                    for($r = 1; $r <= $result_array [$i] ["reservation"] ["count_room"]; $r ++) {
	                        if ($count_pax <= $places) {
	                            $result_array [$i] ["reservation"] ["count_guests"] [$r] = $count_pax;
	                            break;
	                        } else {
	                            $result_array [$i] ["reservation"] ["count_guests"] [$r] = $places;
	                            //$count_room = $count_room - $places;
	                        }
	                    }
	                }
	
	                if ($dc_rate_id > 0) {
	                    switch ($version) {
	                        case 1:
	                            if (isset($rates[$dc_rate_id])) {
	                                $hms_rate_id = $rates[$dc_rate_id];
	                            } else {
	                                $hms_rate_id = $default_price_type;
	                            }
	                            break;
	                        case 2:
	                            if (isset($rates[$dc_type_id][$dc_rate_id])) {
	                                $hms_rate_id = $rates[$dc_type_id][$dc_rate_id];
	                            } else {
	                                $hms_rate_id = $default_price_type;
	                            }
	                            break;
	                        default:
	                            if (isset($rates[$dc_rate_id])) {
	                                $hms_rate_id = $rates[$dc_rate_id];
	                            } else {
	                                $hms_rate_id = $default_price_type;
	                            }
	                            break;
	                    }
	                } else {
	                    $hms_rate_id = $default_price_type;
	                }
	
	                //echo $count_room . "++++++++++++++++++++++<br>";
	                if (isset ( $result_array [$i] ["reservation"] ["count_room"] )) {
	                    for($r = 1; $r <= $result_array [$i] ["reservation"] ["count_room"]; $r ++) {
	                        //echo $dc_type_id . "+$j<br>";
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ['dc_reservationid'] = $result_array [$i] ["reservation"] ['dc_reservationid'];
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ['dc_roomreservation_id'] = $result_array [$i] ["reservation"] ['dc_roomreservation_id'];
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ['dc_currencycode'] = $data ["result"] ["bookings"] [$i] ["currency"];
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["discount"] = 0;
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["user"] = - 1;
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["isNew"] = 1;
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_id"] = 8;
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dealer"] = $dealer;
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["price_type"] = $hms_rate_id;
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["due"] = $data ["result"] ["bookings"] [$i] ["due"];
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["paid"] = $data ["result"] ["bookings"] [$i] ["paid"];
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_totalprice"] = 0;
	
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_type_id"] = $dc_type_id;
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["hms_type_id"] = $categories [$dc_type_id];
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["type_id"] = $categories [$dc_type_id];
	
	                        // $result_array [$i] ["reservation"] ["count_room"] =
	                        // $count_room;
	
	                        $result_array [$i] ["reservation"] ["dc_guestname"] = $data ["result"] ["bookings"] [$i] ["firstname"] . " " . $data ["result"] ["bookings"] [$i] ["lastname"];
	
	                        $date = array_keys ( $dates );
	
	                        if (count ( $date ) > 1) {
	                            $datein = $date [0];
	                            $last = count ( $date ) - 1;
	                            $dateout_temp = $date [$last];
	                            list ( $year, $month, $day ) = explode ( "-", $dateout_temp );
	                            $intdate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	                            $dateout = date ( "Y-m-d", ($intdate + 1) * 86400 );
	                        } else {
	                            $datein = $date [0];
	                            list ( $year, $month, $day ) = explode ( "-", $datein );
	                            $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	                            $dateout = date ( "Y-m-d", ($intdatein + 1) * 86400 );
	                        }
	
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["datein"] = $datein;
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dateout"] = $dateout;
	
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_uuid"] = $result_array [$i] ["reservation"] ['dc_reservationid'] . "_" . $result_array [$i] ["reservation"] ['dc_roomreservation_id'] . "_" . $j;
	
	                        $temp_i = 0;
	                        $dc_rate_intdate_data = array ();
	                        foreach ( $dates as $key_date => $dates_prices ) {
	                            foreach ( $dates_prices as $key_price => $count_room_value ) {
	                                list ( $year, $month, $day ) = explode ( "-", $key_date );
	                                $date = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	                                $dc_rate_intdate_data [$temp_i] ["dc_roomreservation_id"] = $result_array [$i] ["reservation"] ['dc_roomreservation_id'];
	                                $dc_rate_intdate_data [$temp_i] ["dc_uuid"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_uuid"];
	                                $dc_rate_intdate_data [$temp_i] ["dc_rate_id"] = 1;
	                                $dc_rate_intdate_data [$temp_i] ["intdate"] = $date;
	                                $dc_rate_intdate_data [$temp_i] ["date_rate"] = $key_date;
	                                $dc_rate_intdate_data [$temp_i] ["price"] = $key_price;
	                                $dc_rate_intdate_data [$temp_i] ["dc_currencycode"] = $result_array [$i] ["reservation"] ['dc_currencycode'];
	
	                                //$result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_totalprice"] += $key_price;
	                                $temp_i ++;
	                            }
	                        }
	                        $paid_amount = $data ["result"] ["bookings"] [$i] ["paid"];
	                        $due_amount = round(($data ["result"] ["bookings"] [$i] ["due"] / $result_array [$i] ["reservation"] ["count_room"]),2);
	                        $commission_amount = $data ["result"] ["bookings"] [$i] ["OTAcommission"];
	
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_totalprice"] = ($paid_amount + $due_amount) - $commission_amount;
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["amount"] = ($paid_amount + $due_amount) - $commission_amount;
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_rate_intdate_data"] = $dc_rate_intdate_data;
	
	
	                        $j ++;
	                    }
	                }
	            }
	
	            $guest = array ();
	            $result_array [$i] ["guest"] ['firstname'] = $data ["result"] ["bookings"] [$i] ["firstname"];
	            $result_array [$i] ["guest"] ['lastname'] = $data ["result"] ["bookings"] [$i] ["lastname"];
	            $result_array [$i] ["guest"] ['phone'] = $data ["result"] ["bookings"] [$i] ["phone"];
	            $result_array [$i] ["guest"] ['email'] = $data ["result"] ["bookings"] [$i] ["email"];
	            $result_array [$i] ["guest"] ['nationality'] = $data ["result"] ["bookings"] [$i] ["nationality"];
	            switch ($data ["result"] ["bookings"] [$i] ["gender"] ["type"]) {
	                case "MALE" :
	                    $gender = 1;
	                    break;
	                case "FAMALE" :
	                    $gender = 2;
	                    break;
	            }
	            // $result_array [$i] ["reservation"] ['gender'] = $gender;
	        }
	    }
	    if ($debug == true) {
	        echo "<pre>";
	        print_r ( $result_array );
	    }
	    //die ();
	
	    $cancellations_array = array ();
	    if (isset ( $data ["result"] ["cancellations"] )) {
	
	        $count_cancellations_reservations = count ( $data ["result"] ["cancellations"] );
	        for($i = 0; $i < $count_cancellations_reservations; $i ++) {
	            $dc_res_mass = explode ( "-", $data ["result"] ["cancellations"] [$i] ["ref"] );
	            $cancellations_array [$i] ['groupid'] = $data ["result"] ["cancellations"] [$i] ["ref"];
	            $cancellations_array [$i] ['dc_reservationid'] = $dc_res_mass [0];
	            $cancellations_array [$i] ['dc_roomreservation_id'] = $dc_res_mass [1];
	            $cancellations_array [$i] ['reason'] = $data ["result"] ["cancellations"] [$i] ["reason"];
	        }
	    }
	    if ($debug == true) {
	        echo "<pre>";
	        print_r ( $cancellations_array );
	        //die();
	    }
	    $reservationpush = array ();
	    $k = 0;
	    if (isset ( $result_array )) {
	        $count_array = count ( $result_array );
	
	        for($i = 0; $i < $count_array; $i ++) {
	            $count_rooms = count ( $result_array [$i] ["reservation"] ["roomnights"] );
	            $payment_insert = 0;
	            for($j = 0; $j < $count_rooms; $j ++) {
	                $is_overbook = 0;
	                $bool_guest = 0;
	                $datein = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["datein"];
	                $dateout = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dateout"];
	                $type_id = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["hms_type_id"];
	                $result_array [$i] ["reservation"] ["datein"] = $datein;
	                $result_array [$i] ["reservation"] ["dateout"] = $dateout;
	                $result_array [$i] ["reservation"] ["type_id"] = $type_id;
	                $dc_uuid = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_uuid"];
	
	                if (isset ( $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_rate_intdate_data"] )) {
	                    $this->dc_rate_intdate_insert ( $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_rate_intdate_data"] );
	                }
	
	                $query = $this->db->query ( "SELECT id FROM deskofreservation WHERE deleted = 0 AND dc_reservationid = " . $result_array [$i] ["reservation"] ["dc_reservationid"] . " AND dc_uuid LIKE '" . $dc_uuid . "'" );
	                $hms_reservation_id = 0;
	                if ($query->num_rows () > 0) {
	                    $row = $query->row ();
	                    $hms_reservation_id = $row->id;
	                }
	
	                $sql = "SELECT id, room_id FROM deskofreservation WHERE deleted = 0 AND dc_reservationid = " . $result_array [$i] ["reservation"] ["dc_reservationid"] . " AND dc_uuid LIKE '" . $dc_uuid . "'";
	                // echo $sql . "<br>";
	                $query = $this->db->query ( $sql );
	
	                if ($query->num_rows () > 0) {
	
	                    foreach ( $query->result () as $row ) {
	
	                        $reservation_data = $this->frontdesk->GetReservation ( $row->id );
	
	                        // ===== INSERT PAYMENT =========
	                        $payment_amount = $result_array [$i] ["reservation"] ["payment_amount"];
	                        if($payment_amount > 0 && $payment_insert == 0){
	                            $id_partner = $this->db->select('id')
	                            ->get_where('partners', array(
	                                'isdefault' => 1
	                            ))
	                            ->row()->id;
	                            $insert_payment_arr = array(
	                                'id_user' => - 1,
	                                'reservation_id' => $row->id,
	                                'amount' => $payment_amount,
	                                'id_partner' => $id_partner,
	                                'type' => 5,
	                                'create_time' => date("Y-m-d H:i:s"),
	                                'operationtime' => date("Y-m-d H:i:s"),
	                                'description' => ""
	                            );
	                            $this->db->insert('payment', $insert_payment_arr);
	                            $pay_id = $this->db->insert_id();
	                            $payment_insert = 1;
	                        }
	                        // ===== END INSERT PAYMENT =========
	
	                        // echo "<pre>";
	                        // print_r($reservation_data);
	                        $reservation_data ["user"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["user"];
	                        $reservation_data ["firstname"] = $result_array [$i] ["guest"] ["firstname"];
	                        $reservation_data ["lastname"] = $result_array [$i] ["guest"] ["lastname"];
	                        $reservation_data ["phone"] = $result_array [$i] ["guest"] ["phone"];
	                        $reservation_data ["email"] = $result_array [$i] ["guest"] ["email"];
	                        $reservation_data ["datein"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["datein"];
	                        $reservation_data ["dateout"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dateout"];
	                        $reservation_data ["price_type"] = $hms_rate_id;
	                        //$reservation_data ["room_id"] = 0;
	
	                        // $reservation_data ["type_id"] = $type_id;
	                        $reservation_data ["guest_id_new"] = 0;
	                        $reservation_data ["free_places"] = 0;
	                        $reservation_data ["maid_description"] = "";
	                        $reservation_data ["isread"] = 0;
	                        $reservation_data ["dc_currencycode"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_currencycode"];
	
	                        if ($reservation_data ["type_id"] == $type_id) {
	                            $can_resize = $this->frontdesk->qd_canresize ( $row->id, $datein, $dateout );
	                        } else {
	                            $can_resize = 0;
	                            $reservation_data ["type_id"] = $type_id;
	                        }
	
	                        if ($can_resize == 1) {
	                            $calculate_data = array ();
	                            $calculate_data ["type_id"] = $reservation_data ["type_id"];
	                            $calculate_data ["datein"] = $reservation_data ["datein"];
	                            $calculate_data ["dateout"] = $reservation_data ["dateout"];
	                            $calculate_data ["add_places"] = 0;
	                            $calculate_data ["baby_places"] = 0;
	                            $calculate_data ["addbedplace"] = 0;
	                            $calculate_data ["babyplace2"] = 0;
	                            $calculate_data ["price_type"] = $hms_rate_id;
	
	                            $temp_amount = $this->frontdesk->getpricecalculation ( $calculate_data );
	                            $otelms_amount = 0;
	                            for($h = 0; $h < count ( $temp_amount ); $h ++) {
	                                $otelms_amount += $temp_amount [$h] ["amount"];
	                            }
	
	                            $booking_amount = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_totalprice"];
	                            $addons_sum = 0;
	                            if (($booking_amount - $addons_sum) != $otelms_amount) {
	                                if ($otelms_amount != 0) {
	                                    $reservation_data ["discount"] = $otelms_amount - ($booking_amount - $addons_sum);
	                                }
	                            }
	                            echo $otelms_amount;
	                            $reservation_data['is_overbook'] = $is_overbook;
	                            $reservation_data['hms_id'] = $hms_id;
	
	
	                            print_r($reservation_data);
	                            //die();
	                            $update_res = $this->frontdesk->UpdateReservation ( $reservation_data, 0, 1 );
	                            if ($update_res == "FreeError") {
	
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "error";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "Not Free rooms (overbooking not set)";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "update";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_status"] = "";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = $row->id;
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
	
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_name"] = $result_array [$i] ["reservation"] ["dc_guestname"];
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_phone"] = $result_array [$i] ["guest"] ['phone'];
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_email"] = $result_array [$i] ["guest"] ['email'];
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["date"] = "";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["datein"] = $datein;
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dateout"] = $dateout;
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["rates"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_rate_intdate_data"];
	                                $k ++;
	                            } else {
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "ok";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "update";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_status"] = "";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = $row->id;
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
	
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_name"] = $result_array [$i] ["reservation"] ["dc_guestname"];
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_phone"] = $result_array [$i] ["guest"] ['phone'];
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_email"] = $result_array [$i] ["guest"] ['email'];
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["date"] = "";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["datein"] = $datein;
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dateout"] = $dateout;
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["rates"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_rate_intdate_data"];
	                                $k ++;
	                            }
	                        } else {
	                            if ($type_id == 0 or $type_id == "") {
	                                $query2 = $this->db->query ( "SELECT int_value FROM dc_hostelworld_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
	                                if ($query->num_rows () > 0) {
	                                    $row2 = $query2->row ();
	                                    $type_id = $row2->int_value;
	                                }
	                            }
	                            if ($type_id == 0 or $type_id == "") {
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "error";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "UNKNOWN CATEGORY";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "update";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_status"] = "";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = $row->id;
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
	
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_name"] = $result_array [$i] ["reservation"] ["dc_guestname"];
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_phone"] = $result_array [$i] ["guest"] ['phone'];
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_email"] = $result_array [$i] ["guest"] ['email'];
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["date"] = "";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["datein"] = $datein;
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dateout"] = $dateout;
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["rates"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_rate_intdate_data"];
	                                $k ++;
	                            } else {
	                                $room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $type_id );
	                                if ($room_id == 0) {
	                                    $is_overbook = 1;
	                                    $reservation_data['is_overbook'] = $is_overbook;
	                                    if (isset ( $overbooking_category_id )) {
	                                        //$reservations [$i] ["reservation"] ["origin_categoryid"] = $reservation_data ["type_id"];
	                                        $reservation_data ["origin_categoryid"] = $reservation_data ["type_id"];
	                                        $room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $overbooking_category_id );
	
	                                        $insert_over_room_bool = 0;
	                                        if ($room_id == 0) {
	                                            $room_id = $this->dc_model->dc_make_overbooking_room ( $overbooking_category_id );
	                                            $insert_over_room_bool = 1;
	                                        }
	                                    } else {
	                                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "failed";
	                                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "no overbooking_category_id";
	                                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "new";
	                                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = 0;
	                                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
	                                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_room_id"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_type_id"];
	                                        // 											$result_array ["reservations"] [$reservations [$i] ["reservation"] ["category_id"] . "-" . $reservations [$i] ["reservation"] ["placement_id"]] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
	                                        // 											$result_array ["reservations"] [$reservations [$i] ["reservation"] ["category_id"] . "-" . $reservations [$i] ["reservation"] ["placement_id"]] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
	                                        // 											$result_array ["reservations"] [$reservations [$i] ["reservation"] ["category_id"] . "-" . $reservations [$i] ["reservation"] ["placement_id"]] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
	                                    }
	                                }
	                                $reservation_data ["room_id"] = $room_id;
	                                $reservation_data['hms_id'] = $hms_id;
	
	                                $update_res = $this->frontdesk->UpdateReservation ( $reservation_data, 0, 1 );
	
	                                // 									if (isset ( $otelms_rooms [$result_array [$i] ["reservation"] ["dc_uuid"]] )) {
	                                // 										$otelms_rooms [$reservations [$i] ["reservation"] ["dc_uuid"]] ["status"] = 1;
	                                // 									}
	
	                                if ($update_res == "FreeError") {
	                                    $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "error";
	                                    $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "";
	                                    $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "modified";
	                                    $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = $hms_reservation_id;
	                                    // 										$result_array ["reservations"] [$reservations [$i] ["reservation"] ["category_id"] . "-" . $reservations [$i] ["reservation"] ["placement_id"]] [$i] ["reservation"] ["reservation_alert"] = "";
	                                    // 										$result_array ["reservations"] [$reservations [$i] ["reservation"] ["category_id"] . "-" . $reservations [$i] ["reservation"] ["placement_id"]] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
	                                    // 										$result_array ["reservations"] [$reservations [$i] ["reservation"] ["category_id"] . "-" . $reservations [$i] ["reservation"] ["placement_id"]] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
	                                    $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
	                                    $k ++;
	                                } else {
	                                    $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "ok";
	                                    $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "";
	                                    $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["alert"] = "";
	                                    $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "modified";
	                                    $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = $hms_reservation_id;
	                                    // 										$result_array ["reservations"] [$reservations [$i] ["reservation"] ["category_id"] . "-" . $reservations [$i] ["reservation"] ["placement_id"]] [$i] ["reservation"] ["reservation_alert"] = "";
	                                    // 										$result_array ["reservations"] [$reservations [$i] ["reservation"] ["category_id"] . "-" . $reservations [$i] ["reservation"] ["placement_id"]] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
	                                    // 										$result_array ["reservations"] [$reservations [$i] ["reservation"] ["category_id"] . "-" . $reservations [$i] ["reservation"] ["placement_id"]] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
	                                    $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
	                                    $k ++;
	                                }
	                            }
	                        }
	
	
	                    }
	                } else {
	
	                    $room_id = 0;
	
	                    if ($type_id == 0 or $type_id == "") {
	                        $query2 = $this->db->query ( "SELECT int_value FROM dc_hostelworld_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
	                        if ($query->num_rows () > 0) {
	                            $row2 = $query2->row ();
	                            $type_id = $row2->int_value;
	                        }
	                    }
	
	                    if ($type_id == 0 or $type_id == "") {
	
	                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "failed";
	                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "UNKNOWN CATEGORY";
	                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "new";
	                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = 0;
	                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
	                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_room_id"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_type_id"];
	
	                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_name"] = $result_array [$i] ["reservation"] ["dc_guestname"];
	                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_phone"] = $result_array [$i] ["guest"] ['phone'];
	                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_email"] = $result_array [$i] ["guest"] ['email'];
	                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["date"] = "";
	                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["datein"] = $datein;
	                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dateout"] = $dateout;
	                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["rates"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_rate_intdate_data"];
	                        $k ++;
	                    } else {
	                        $room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $type_id );
	                        if ($room_id == 0) {
	                            $is_overbook = 1;
	
	                            if (isset ( $overbooking_category_id )) {
	                                //$reservations [$i] ["reservation"] ["origin_categoryid"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["hms_type_id"];
	                                //$result_array [$i] ["reservation"] ["roomnights"] [$j] ['origin_categoryid'] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["hms_type_id"];
	
	                                $room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $overbooking_category_id );
	
	                                $insert_over_room_bool = 0;
	                                if ($room_id == 0) {
	                                    $room_id = $this->dc_model->dc_make_overbooking_room ( $overbooking_category_id );
	                                    $insert_over_room_bool = 1;
	                                }
	                                $result_array [$i] ["reservation"] ["roomnights"] [$j] ["type_id"] = $type_id;
	                                $result_array [$i] ["reservation"] ["roomnights"] [$j] ["origin_categoryid"] = $type_id;
	                            } else {
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "failed";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "no overbooking_vcategory";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "new";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = 0;
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_room_id"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_type_id"];
	
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_name"] = $result_array [$i] ["reservation"] ["dc_guestname"];
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_phone"] = $result_array [$i] ["guest"] ['phone'];
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_email"] = $result_array [$i] ["guest"] ['email'];
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["date"] = "";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["datein"] = $datein;
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dateout"] = $dateout;
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["rates"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_rate_intdate_data"];
	                            }
	                        }
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["room_id"] = $room_id;
	
	                        if ($bool_guest == 0) {
	                            $guest_id = $this->frontdesk->Guest_insert ( $result_array [$i] ["guest"] );
	                            $bool_guest = 1;
	                        }
	
	                        $calculate_data = array ();
	                        $calculate_data ["type_id"] = $result_array [$i] ["reservation"] ["type_id"];
	                        $calculate_data ["datein"] = $result_array [$i] ["reservation"] ["datein"];
	                        $calculate_data ["dateout"] = $result_array [$i] ["reservation"] ["dateout"];
	                        $calculate_data ["add_places"] = 0;
	                        $calculate_data ["baby_places"] = 0;
	                        $calculate_data ["addbedplace"] = 0;
	                        $calculate_data ["babyplace2"] = 0;
	                        $calculate_data ["price_type"] = $hms_rate_id;
	
	                        $temp_amount = $this->frontdesk->getpricecalculation ( $calculate_data );
	                        $otelms_amount = 0;
	                        for($h = 0; $h < count ( $temp_amount ); $h ++) {
	                            $otelms_amount += $temp_amount [$h] ["amount"];
	                        }
	
	                        $booking_amount = $result_array [$i] ["reservation"] ["roomnights"] [$j]["dc_totalprice"];
	                        $addons_sum = 0;
	                        if (($booking_amount - $addons_sum) != $otelms_amount) {
	                            if ($otelms_amount != 0) {
	                                $result_array [$i] ["reservation"] ["discount"] = $otelms_amount - ($booking_amount - $addons_sum);
	                                $result_array [$i] ["reservation"] ["roomnights"] [$j]["service_main_amount_2"] = 1;
	                                $result_array [$i] ["reservation"] ["roomnights"] [$j]["service_main_amount"] = $booking_amount;
	                            }
	                        }
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_numberofguest"] = count($result_array [$i] ["reservation"] ["count_guests"]);
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["is_overbook"] = $is_overbook;
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ['hms_id'] = $hms_id;
	                        //$result_array [$i] ["reservation"] ["roomnights"] [$j]["service_main_amount_2"] = 2;
	                        print_r($result_array [$i] ["reservation"] ["roomnights"] [$j]);
	                        //die();
	                        $reservation_id = $this->frontdesk->Reservation_insert ( $result_array [$i] ["reservation"] ["roomnights"] [$j], $guest_id, 0, 1 );
	                        if (isset ( $result_array [$i] ["card"] )) {
	                            $this->frontdesk->insert_tbl_CreditCards ( $result_array [$i] ["card"], $guest_id, $reservation_id );
	                        }
	
	                        if ($reservation_id > 0) {
	                            // ===== INSERT PAYMENT =========
	                            $payment_amount = $result_array [$i] ["reservation"] ["payment_amount"];
	                            if($payment_amount > 0 && $payment_insert == 0){
	                                $id_partner = $this->db->select('id')
	                                ->get_where('partners', array(
	                                    'isdefault' => 1
	                                ))
	                                ->row()->id;
	                                $insert_payment_arr = array(
	                                    'id_user' => - 1,
	                                    'reservation_id' => $reservation_id,
	                                    'amount' => $payment_amount,
	                                    'id_partner' => $id_partner,
	                                    'type' => 5,
	                                    'create_time' => date("Y-m-d H:i:s"),
	                                    'operationtime' => date("Y-m-d H:i:s"),
	                                    'description' => ""
	                                );
	                                $this->db->insert('payment', $insert_payment_arr);
	                                $pay_id = $this->db->insert_id();
	                                $payment_insert = 1;
	                                 
	                                // calculate balance
	                                $this->frontdesk->SetReservationBalance ( $reservation_id );
	                            }
	                            // ===== END INSERT PAYMENT =========
	
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "ok";
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "";
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "new";
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_status"] = "";
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = $reservation_id;
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_room_id"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_type_id"];
	
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_name"] = $result_array [$i] ["reservation"] ["dc_guestname"];
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_phone"] = $result_array [$i] ["guest"] ['phone'];
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_email"] = $result_array [$i] ["guest"] ['email'];
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["date"] = "";
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["datein"] = $datein;
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dateout"] = $dateout;
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["rates"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_rate_intdate_data"];
	                            $k ++;
	                        } else {
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "failed";
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "undferror";
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "new";
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_status"] = "";
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = 0;
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_room_id"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_type_id"];
	
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_name"] = $result_array [$i] ["reservation"] ["dc_guestname"];
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_phone"] = $result_array [$i] ["guest"] ['phone'];
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_email"] = $result_array [$i] ["guest"] ['email'];
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["date"] = "";
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["datein"] = $datein;
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dateout"] = $dateout;
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["rates"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_rate_intdate_data"];
	                            $k ++;
	                        }
	                    }
	                }
	            }
	        }
	    }
	
	    $count_cancellations_array = count ( $cancellations_array );
	    for($i = 0; $i < $count_cancellations_array; $i ++) {
	        $time2 = date ( "Y-m-d H:i:s" );
	        $status = 5;
	
	        $query = $this->db->query ( "SELECT id as hms_reservation_id, room_id FROM deskofreservation WHERE deleted = 0 AND dc_reservationid = " . $cancellations_array [$i] ["dc_reservationid"] . " AND dc_roomreservation_id = " . $cancellations_array [$i] ["dc_roomreservation_id"] );
	
	        if ($query->num_rows () > 0) {
	            foreach ( $query->result () as $row ) {
	                $hms_reservation_id = $row->hms_reservation_id;
	                $query2 = $this->db->query ( "SELECT id FROM  services_main WHERE reservation_id = " . $hms_reservation_id . " AND type = 2" );
	
	                if ($query2->num_rows () > 0) {
	                    $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["response"] = "failed";
	                    $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["text"] = "есть уже отмена";
	                    $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["status"] = "cancel";
	
	                    $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["hms_reservation_id"] = $hms_reservation_id;
	                    $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["dc_reservationid"] = $cancellations_array [$i] ["dc_reservationid"] . "-" . $cancellations_array [$i] ["dc_roomreservation_id"];
	                    $k ++;
	                } else {
	                    $query2 = $this->db->query ( "SELECT id FROM deskofreservation WHERE dc_roomreservation_id = " . $cancellations_array [$i] ["dc_roomreservation_id"] );
	
	                    if ($query2->num_rows () > 0) {
	                        $data_cancel = array ();
	
	                        $data_cancel ["res_id"] = $hms_reservation_id;
	                        $data_cancel ["charge"] = 0;
	                        $data_cancel ["status"] = $status;
	                        $data_cancel ["description"] = "cancel from HW";
	                        $data_cancel ["guestbe_request"] = 0;
	                        $data_cancel ["user"] = - 1;
	                        // ====================
	                        $this->Cancel->Insert ( $data_cancel );
	                        // ====================
	                        $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["response"] = "ok";
	                        $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["text"] = "";
	                        $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["status"] = "cancel";
	                        $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["hms_reservation_id"] = $hms_reservation_id;
	                        $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["dc_reservationid"] = $cancellations_array [$i] ["dc_reservationid"] . "-" . $cancellations_array [$i] ["dc_roomreservation_id"];
	                        $k ++;
	                    } else {
	                        $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["response"] = "failed";
	                        $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["text"] = "нет брони для отмены";
	                        $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["status"] = "cancel";
	
	                        $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["hms_reservation_id"] = 0;
	                        $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["dc_reservationid"] = $cancellations_array [$i] ["dc_reservationid"] . "-" . $cancellations_array [$i] ["dc_roomreservation_id"];
	                        $k ++;
	                    }
	                }
	            }
	        } else {
	            $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["response"] = "failed";
	            $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["text"] = "нет брони для отмены";
	            $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["status"] = "cancel";
	
	            $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["hms_reservation_id"] = 0;
	            $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["dc_reservationid"] = $cancellations_array [$i] ["dc_reservationid"] . "-" . $cancellations_array [$i] ["dc_roomreservation_id"];
	            $k ++;
	        }
	    }
	    echo "+++++++";
	    if ($debug == true) {
	        print_r ( $reservationpush );
	    }
	    // die ();
	    $result = array ();
	    $result ["view_data"] = array ();
	    $ack_bookings = array ();
	    $i = 0;
	    foreach ( $reservationpush as $key => $arg1 ) {
	        foreach ( $arg1 as $arg ) {
	            $data = array ();
	            $data ["hms_reservation_id"] = $arg ["hms_reservation_id"];
	            $data ['response'] = $arg ['response'];
	            $data ['resid'] = $arg ['dc_reservationid'];
	            $data ['dcname'] = "HW";
	            $data ['text'] = $arg ['text'];
	            $data ['status'] = $arg ['status'];
	
	            $result ["view_data"] [$i] = $data;
	
	            // $this->dc_model->send_notifyarray ( $data );
	            if ($arg ['response'] == "ok" and ($arg ['status'] == "new" or $arg ['status'] == "update")) {
	                $ack_bookings ["bookings"] [$arg ['dc_reservationid']] ['ref'] = $arg ['dc_reservationid'];
	            }
	
	            // must pull to LOG ORDERS
	            $ack_bookings ["bookings"] [$arg ['dc_reservationid']] ['ref'] = $arg ['dc_reservationid'];
	            // !!!!!
	
	            // if ($arg ['response'] == "ok" and $arg ['status'] ==
	            // "cancel") {
	            // if ($arg ['response'] == "ok" ) {
	            if ($arg ['status'] == "cancel") {
	                $ack_bookings ["cancellations"] [$arg ['dc_reservationid']] ['ref'] = $arg ['dc_reservationid'];
	            }
	            $result ["ack_bookings"] = $ack_bookings;
	            $i ++;
	        }
	    }
	
	    foreach ( $reservationpush as $goupid => $arg1 ) {
	        $msg = "";
	        foreach ( $arg1 as $arg ) {
	            if ($arg ["status"] == "new" or $arg ["status"] == "update" or $arg ["status"] == "cancel") {
	                $data = array ();
	                $data ["hms_reservation_id"] = $arg ["hms_reservation_id"];
	                $data ['resid'] = $arg ['dc_reservationid'];
	                $data ['response'] = $arg ['response'];
	                $data ['text'] = $arg ['text'];
	                if (isset ( $arg ['fff'] )) {
	                    $data ['fff'] = $arg ['fff'];
	                }
	                $data ['dcname'] = "HW";
	                $data ['status'] = $arg ['status'];
	                // $this->dc_model->send_notifyarray ( $data );
	                // ==============================================
	                if (isset ( $arg ['guest_name'] )) {
	                    $data ['guest_name'] = $arg ['guest_name'];
	                }
	                if (isset ( $arg ['guest_phone'] )) {
	                    $data ['guest_phone'] = $arg ['guest_phone'];
	                }
	                if (isset ( $arg ['guest_email'] )) {
	                    $data ['guest_email'] = $arg ['guest_email'];
	                }
	                if (isset ( $arg ['date'] )) {
	                    $data ['date'] = $arg ['date'];
	                }
	                if (isset ( $arg ['datein'] )) {
	                    $data ['arrival_date'] = $arg ['datein'];
	                }
	                if (isset ( $arg ['dateout'] )) {
	                    $data ['departure_date'] = $arg ['dateout'];
	                }
	                if (isset ( $arg ['rates'] )) {
	                    $data ['rates'] = $arg ['rates'];
	                }
	                $data ['template'] = 1;
	                $data ['room_name'] = "";
	                $dcname = $data ['dcname'];
	                $data ['resid'] = $arg ["hms_reservation_id"];
	                $msg .= $this->dc_model->msg_txt ( $data, false, $host );
	            }
	        }
	        if ($msg != "") {
	            $this->dc_model->send_notifyarray_dc ( $msg, $dcname, $goupid, false, $arg ["status"] );
	        }
	    }
	
	    return $result;
	}
	
	function get_bookings_OLD_10_03_2025($data, $host = "", $hms_id = 0) {
	    $debug = false;
	    if ($this->session->userdata ( 'global_debug' ) == 1) {
	        $debug = true;
	    }
	    // echo $str_data;
	
	    // 	    $category_places_array = array ();
	    // 	    $query = $this->db->query ( "SELECT IF( baseplace> 0, baseplace, categories.places) as occupancy, categories.id FROM categories
	    // 				INNER JOIN ratetocategory ON ratetocategory.category_id = categories.id
	    // 				INNER JOIN dc_hostelworld_rate_link ON dc_hostelworld_rate_link.hms_rate_id = ratetocategory.rate_id " );
	
	    // 	    if ($query->num_rows () > 0) {
	    // 	        foreach ( $query->result () as $row ) {
	    // 	            $category_places_array [$row->id] = $row->occupancy;
	    // 	        }
	    // 	    }
	     
	    $category_places_array = array ();
	    $query = $this->db->query ( "SELECT IF( baseplace> 0, baseplace, categories.places) as occupancy, categories.id FROM categories
                INNER JOIN dc_hostelworld_room_categories_link ON dc_hostelworld_room_categories_link.hms_category_id = categories.id
	            INNER JOIN dc_hostelworld_rate2category_link ON dc_hostelworld_rate2category_link.dc_category_id = dc_hostelworld_room_categories_link.dc_category_id
				INNER JOIN ratetocategory ON ratetocategory.category_id = dc_hostelworld_room_categories_link.hms_category_id
	            AND ratetocategory.rate_id = dc_hostelworld_rate2category_link.hms_rate_id" );
	     
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            $category_places_array [$row->id] = $row->occupancy;
	        }
	    }
	
	    // 	    echo "<pre>";
	    // 	    print_r ( $category_places_array );
	
	    $currency_array = array ();
	    $query = $this->db->query ( "SELECT * FROM  `global_hotelix`.currency" );
	
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            $currency_array [$row->name] = $row->code;
	        }
	    }
	
	     
	    //$hms_rate_id = 0;
	     
	    $version = $this->get_version ();
	     
	    switch ($version) {
	        case 1:
	            $rates = array ();
	            $query = $this->db->query ( "SELECT hms_rate_id, dc_rate_id FROM  dc_hostelworld_rate_link" );
	
	            if ($query->num_rows () > 0) {
	                foreach ( $query->result () as $row ) {
	                    $rates [$row->dc_rate_id] = $row->hms_rate_id;
	                }
	            }
	            break;
	        case 2:
	            $query = $this->db->query("SELECT hms_rate_id, dc_rate_id, dc_category_id FROM  dc_hostelworld_rate2category_link");
	            if ($query->num_rows() > 0) {
	                foreach ($query->result() as $row) {
	                    $rates[$row->dc_category_id][$row->dc_rate_id] = $row->hms_rate_id;
	                }
	            }
	            break;
	        default:
	            $rates = array ();
	            $query = $this->db->query ( "SELECT hms_rate_id, dc_rate_id FROM  dc_hostelworld_rate_link" );
	
	            if ($query->num_rows () > 0) {
	                foreach ( $query->result () as $row ) {
	                    $rates [$row->dc_rate_id] = $row->hms_rate_id;
	                }
	            }
	            break;
	    }
	
	    $categories = array ();
	
	    $query = $this->db->query ( "SELECT dc_category_id, hms_category_id FROM dc_hostelworld_room_categories_link" );
	
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            $categories [$row->dc_category_id] = $row->hms_category_id;
	        }
	    }
	
	    //print_r ( $categories );
	    $default_price_type = 0;
	    $query = $this->db->query ( "SELECT id FROM rate WHERE isdefault = 1" );
	
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $default_price_type = $row->id;
	    }
	
	    $query = $this->db->query ( "SELECT int_value FROM dc_hostelworld_xml_cfg WHERE name LIKE 'dealer_id'" );
	
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $dealer = $row->int_value;
	    }
	
	    $query = $this->db->query ( "SELECT int_value FROM dc_hostelworld_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
	
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $overbooking_category_id = $row->int_value;
	    }
	
	    $result_array = array ();
	    if (isset ( $data ["result"] ["bookings"] )) {
	
	        $count_reservations = count ( $data ["result"] ["bookings"] );
	        for($i = 0; $i < $count_reservations; $i ++) {
	            $dc_res_mass = explode ( "-", $data ["result"] ["bookings"] [$i] ["ref"] );
	
	            $result_array [$i] ["reservation"] ['groupid'] = $data ["result"] ["bookings"] [$i] ["ref"];
	            $result_array [$i] ['status'] = "new";
	            $result_array [$i] ["reservation"] ['dc_reservationid'] = $dc_res_mass [0];
	            $result_array [$i] ["reservation"] ['dc_roomreservation_id'] = $dc_res_mass [1];
	
	            // $result_array [$i] ["reservation"] ['dc_currencycode'] =
	            // $currency_array [$data ["result"] ["bookings"] [$i]
	            // ["currency"]];
	            $result_array [$i] ["reservation"] ['dc_currencycode'] = $data ["result"] ["bookings"] [$i] ["currency"];
	            $result_array [$i] ["reservation"] ['discount'] = 0;
	            $result_array [$i] ["reservation"] ["user"] = - 1;
	            $result_array [$i] ["reservation"] ["isNew"] = 1;
	            $result_array [$i] ["reservation"] ["dc_id"] = 8;
	            $result_array [$i] ["reservation"] ["dealer"] = $dealer;
	            //$result_array [$i] ["reservation"] ["price_type"] = $hms_rate_id;
	
	            $result_array [$i] ["reservation"] ["due"] = $data ["result"] ["bookings"] [$i] ["due"];
	            $result_array [$i] ["reservation"] ["paid"] = $data ["result"] ["bookings"] [$i] ["paid"];
	            $result_array [$i] ["reservation"] ["payment_amount"] = $data ["result"] ["bookings"] [$i] ["OTADue"];
	            // $result_array [$i] ["reservation"] ["dc_totalprice"] = (
	            // string )
	            // $response->ReservationsList->HotelReservation->ResGlobalInfo->Fees->Fee
	            // ['Amount'];
	            // $result_array [$i] ["reservation"] ["dc_totalprice"] = 0;
	            
	            // ========= CALCULATE PAX ===============
	            $pax = 0;
	            foreach ( $data ["result"] ["bookings"] [$i] ["roomnights"] as $dc_type_id => $dates ) {
	                foreach ( $dates as $key_date => $dates_prices ) {
	                    foreach ( $dates_prices as $key_price => $count_room_value ) {
	                        //$count_room = $count_room_value;
	                        $pax += $count_room_value['pax'];
	                        break;
	                    }
	                    break;
	                }
	            }
	            
	           if($pax == 0){
	               $pax = 1;
	           }
	           // ========= END CALCULATE PAX ===============
	            $j = 0;
	            $count_room = 0;
	            $dc_rate_id = 0;
	            foreach ( $data ["result"] ["bookings"] [$i] ["roomnights"] as $dc_type_id => $dates ) {
	                //echo 	$dc_type_id."<br>";
	                //$pax = 1;
	                foreach ( $dates as $key_date => $dates_prices ) {
	                    foreach ( $dates_prices as $key_price => $count_room_value ) {
	                        //$count_room = $count_room_value;
	                        //$pax = $count_room_value['pax'];
	                        $count_room = $count_room_value['pax'];
	                        $dc_rate_id = $count_room_value['rateplanid'];
	                        break;
	                    }
	                    break;
	                }
	
	                if (isset ( $category_places_array [$categories [$dc_type_id]] )) {
	                    //echo "--";
	                    $places = $category_places_array [$categories [$dc_type_id]];
	                    $result_array [$i] ["reservation"] ["count_room"] = ceil ( $count_room / $places );
	                }
	                if (isset ( $result_array [$i] ["reservation"] ["count_room"] )) {
	                    for($r = 1; $r <= $result_array [$i] ["reservation"] ["count_room"]; $r ++) {
	                        if ($count_room <= $places) {
	                            $result_array [$i] ["reservation"] ["count_guests"] [$r] = $count_room;
	                            break;
	                        } else {
	                            $result_array [$i] ["reservation"] ["count_guests"] [$r] = $places;
	                            $count_room = $count_room - $places;
	                        }
	                    }
	                }
	                 
	                if ($dc_rate_id > 0) {
	                    switch ($version) {
	                        case 1:
	                            if (isset($rates[$dc_rate_id])) {
	                                $hms_rate_id = $rates[$dc_rate_id];
	                            } else {
	                                $hms_rate_id = $default_price_type;
	                            }
	                            break;
	                        case 2:
	                            if (isset($rates[$dc_type_id][$dc_rate_id])) {
	                                $hms_rate_id = $rates[$dc_type_id][$dc_rate_id];
	                            } else {
	                                $hms_rate_id = $default_price_type;
	                            }
	                            break;
	                        default:
	                            if (isset($rates[$dc_rate_id])) {
	                                $hms_rate_id = $rates[$dc_rate_id];
	                            } else {
	                                $hms_rate_id = $default_price_type;
	                            }
	                            break;
	                    }
	                } else {
	                    $hms_rate_id = $default_price_type;
	                }
	
	                //echo $count_room . "++++++++++++++++++++++<br>";
	                if (isset ( $result_array [$i] ["reservation"] ["count_room"] )) {
	                    for($r = 1; $r <= $result_array [$i] ["reservation"] ["count_room"]; $r ++) {
	                        //echo $dc_type_id . "+$j<br>";
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ['dc_reservationid'] = $result_array [$i] ["reservation"] ['dc_reservationid'];
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ['dc_roomreservation_id'] = $result_array [$i] ["reservation"] ['dc_roomreservation_id'];
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ['dc_currencycode'] = $data ["result"] ["bookings"] [$i] ["currency"];
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["discount"] = 0;
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["user"] = - 1;
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["isNew"] = 1;
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_id"] = 8;
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dealer"] = $dealer;
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["price_type"] = $hms_rate_id;
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["due"] = $data ["result"] ["bookings"] [$i] ["due"];
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["paid"] = $data ["result"] ["bookings"] [$i] ["paid"];
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_totalprice"] = 0;
	
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_type_id"] = $dc_type_id;
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["hms_type_id"] = $categories [$dc_type_id];
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["type_id"] = $categories [$dc_type_id];
	
	                        // $result_array [$i] ["reservation"] ["count_room"] =
	                        // $count_room;
	
	                        $result_array [$i] ["reservation"] ["dc_guestname"] = $data ["result"] ["bookings"] [$i] ["firstname"] . " " . $data ["result"] ["bookings"] [$i] ["lastname"];
	
	                        $date = array_keys ( $dates );
	
	                        if (count ( $date ) > 1) {
	                            $datein = $date [0];
	                            $last = count ( $date ) - 1;
	                            $dateout_temp = $date [$last];
	                            list ( $year, $month, $day ) = explode ( "-", $dateout_temp );
	                            $intdate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	                            $dateout = date ( "Y-m-d", ($intdate + 1) * 86400 );
	                        } else {
	                            $datein = $date [0];
	                            list ( $year, $month, $day ) = explode ( "-", $datein );
	                            $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	                            $dateout = date ( "Y-m-d", ($intdatein + 1) * 86400 );
	                        }
	
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["datein"] = $datein;
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dateout"] = $dateout;
	
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_uuid"] = $result_array [$i] ["reservation"] ['dc_reservationid'] . "_" . $result_array [$i] ["reservation"] ['dc_roomreservation_id'] . "_" . $j;
	
	                        $temp_i = 0;
	                        $dc_rate_intdate_data = array ();
	                        foreach ( $dates as $key_date => $dates_prices ) {
	                            foreach ( $dates_prices as $key_price => $count_room_value ) {
	                                list ( $year, $month, $day ) = explode ( "-", $key_date );
	                                $date = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	                                $dc_rate_intdate_data [$temp_i] ["dc_roomreservation_id"] = $result_array [$i] ["reservation"] ['dc_roomreservation_id'];
	                                $dc_rate_intdate_data [$temp_i] ["dc_uuid"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_uuid"];
	                                $dc_rate_intdate_data [$temp_i] ["dc_rate_id"] = 1;
	                                $dc_rate_intdate_data [$temp_i] ["intdate"] = $date;
	                                $dc_rate_intdate_data [$temp_i] ["date_rate"] = $key_date;
	                                $dc_rate_intdate_data [$temp_i] ["price"] = $key_price;
	                                $dc_rate_intdate_data [$temp_i] ["dc_currencycode"] = $result_array [$i] ["reservation"] ['dc_currencycode'];
	
	                                //$result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_totalprice"] += $key_price;
	                                $temp_i ++;
	                            }
	                        }
	                        $paid_amount = $data ["result"] ["bookings"] [$i] ["paid"];
	                        $due_amount = round(($data ["result"] ["bookings"] [$i] ["due"] / $pax),2);
	                        $commission_amount = $data ["result"] ["bookings"] [$i] ["OTAcommission"];
	                         
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_totalprice"] = ($paid_amount + $due_amount) - $commission_amount;
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["amount"] = ($paid_amount + $due_amount) - $commission_amount;
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_rate_intdate_data"] = $dc_rate_intdate_data;
	                         
	
	                        $j ++;
	                    }
	                }
	            }
	
	            $guest = array ();
	            $result_array [$i] ["guest"] ['firstname'] = $data ["result"] ["bookings"] [$i] ["firstname"];
	            $result_array [$i] ["guest"] ['lastname'] = $data ["result"] ["bookings"] [$i] ["lastname"];
	            $result_array [$i] ["guest"] ['phone'] = $data ["result"] ["bookings"] [$i] ["phone"];
	            $result_array [$i] ["guest"] ['email'] = $data ["result"] ["bookings"] [$i] ["email"];
	            $result_array [$i] ["guest"] ['nationality'] = $data ["result"] ["bookings"] [$i] ["nationality"];
	            switch ($data ["result"] ["bookings"] [$i] ["gender"] ["type"]) {
	                case "MALE" :
	                    $gender = 1;
	                    break;
	                case "FAMALE" :
	                    $gender = 2;
	                    break;
	            }
	            // $result_array [$i] ["reservation"] ['gender'] = $gender;
	        }
	    }
	    if ($debug == true) {
	        echo "<pre>";
	        print_r ( $result_array );
	    }
	    // die ();
	
	    $cancellations_array = array ();
	    if (isset ( $data ["result"] ["cancellations"] )) {
	
	        $count_cancellations_reservations = count ( $data ["result"] ["cancellations"] );
	        for($i = 0; $i < $count_cancellations_reservations; $i ++) {
	            $dc_res_mass = explode ( "-", $data ["result"] ["cancellations"] [$i] ["ref"] );
	            $cancellations_array [$i] ['groupid'] = $data ["result"] ["cancellations"] [$i] ["ref"];
	            $cancellations_array [$i] ['dc_reservationid'] = $dc_res_mass [0];
	            $cancellations_array [$i] ['dc_roomreservation_id'] = $dc_res_mass [1];
	            $cancellations_array [$i] ['reason'] = $data ["result"] ["cancellations"] [$i] ["reason"];
	        }
	    }
	    if ($debug == true) {
	        echo "<pre>";
	        print_r ( $cancellations_array );
	        //die();
	    }
	    $reservationpush = array ();
	    $k = 0;
	    if (isset ( $result_array )) {
	        $count_array = count ( $result_array );
	
	        for($i = 0; $i < $count_array; $i ++) {
	            $count_rooms = count ( $result_array [$i] ["reservation"] ["roomnights"] );
	            $payment_insert = 0;
	            for($j = 0; $j < $count_rooms; $j ++) {
	                $is_overbook = 0;
	                $bool_guest = 0;
	                $datein = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["datein"];
	                $dateout = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dateout"];
	                $type_id = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["hms_type_id"];
	                $result_array [$i] ["reservation"] ["datein"] = $datein;
	                $result_array [$i] ["reservation"] ["dateout"] = $dateout;
	                $result_array [$i] ["reservation"] ["type_id"] = $type_id;
	                $dc_uuid = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_uuid"];
	
	                if (isset ( $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_rate_intdate_data"] )) {
	                    $this->dc_rate_intdate_insert ( $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_rate_intdate_data"] );
	                }
	
	                $query = $this->db->query ( "SELECT id FROM deskofreservation WHERE deleted = 0 AND dc_reservationid = " . $result_array [$i] ["reservation"] ["dc_reservationid"] . " AND dc_uuid LIKE '" . $dc_uuid . "'" );
	                $hms_reservation_id = 0;
	                if ($query->num_rows () > 0) {
	                    $row = $query->row ();
	                    $hms_reservation_id = $row->id;
	                }
	
	                $sql = "SELECT id, room_id FROM deskofreservation WHERE deleted = 0 AND dc_reservationid = " . $result_array [$i] ["reservation"] ["dc_reservationid"] . " AND dc_uuid LIKE '" . $dc_uuid . "'";
	                // echo $sql . "<br>";
	                $query = $this->db->query ( $sql );
	
	                if ($query->num_rows () > 0) {
	
	                    foreach ( $query->result () as $row ) {
	
	                        $reservation_data = $this->frontdesk->GetReservation ( $row->id );
	
	                        // ===== INSERT PAYMENT =========
	                        $payment_amount = $result_array [$i] ["reservation"] ["payment_amount"];
	                        if($payment_amount > 0 && $payment_insert == 0){
	                            $id_partner = $this->db->select('id')
	                            ->get_where('partners', array(
	                                'isdefault' => 1
	                            ))
	                            ->row()->id;
	                            $insert_payment_arr = array(
	                                'id_user' => - 1,
	                                'reservation_id' => $row->id,
	                                'amount' => $payment_amount,
	                                'id_partner' => $id_partner,
	                                'type' => 5,
	                                'create_time' => date("Y-m-d H:i:s"),
	                                'operationtime' => date("Y-m-d H:i:s"),
	                                'description' => ""
	                            );
	                            $this->db->insert('payment', $insert_payment_arr);
	                            $pay_id = $this->db->insert_id();
	                            $payment_insert = 1;
	                        }
	                        // ===== END INSERT PAYMENT =========
	                         
	                        // echo "<pre>";
	                        // print_r($reservation_data);
	                        $reservation_data ["user"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["user"];
	                        $reservation_data ["firstname"] = $result_array [$i] ["guest"] ["firstname"];
	                        $reservation_data ["lastname"] = $result_array [$i] ["guest"] ["lastname"];
	                        $reservation_data ["phone"] = $result_array [$i] ["guest"] ["phone"];
	                        $reservation_data ["email"] = $result_array [$i] ["guest"] ["email"];
	                        $reservation_data ["datein"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["datein"];
	                        $reservation_data ["dateout"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dateout"];
	                        $reservation_data ["price_type"] = $hms_rate_id;
	                        //$reservation_data ["room_id"] = 0;
	
	                        // $reservation_data ["type_id"] = $type_id;
	                        $reservation_data ["guest_id_new"] = 0;
	                        $reservation_data ["free_places"] = 0;
	                        $reservation_data ["maid_description"] = "";
	                        $reservation_data ["isread"] = 0;
	                        $reservation_data ["dc_currencycode"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_currencycode"];
	
	                        if ($reservation_data ["type_id"] == $type_id) {
	                            $can_resize = $this->frontdesk->qd_canresize ( $row->id, $datein, $dateout );
	                        } else {
	                            $can_resize = 0;
	                            $reservation_data ["type_id"] = $type_id;
	                        }
	
	                        if ($can_resize == 1) {
	                            $calculate_data = array ();
	                            $calculate_data ["type_id"] = $reservation_data ["type_id"];
	                            $calculate_data ["datein"] = $reservation_data ["datein"];
	                            $calculate_data ["dateout"] = $reservation_data ["dateout"];
	                            $calculate_data ["add_places"] = 0;
	                            $calculate_data ["baby_places"] = 0;
	                            $calculate_data ["addbedplace"] = 0;
	                            $calculate_data ["babyplace2"] = 0;
	                            $calculate_data ["price_type"] = $hms_rate_id;
	
	                            $temp_amount = $this->frontdesk->getpricecalculation ( $calculate_data );
	                            $otelms_amount = 0;
	                            for($h = 0; $h < count ( $temp_amount ); $h ++) {
	                                $otelms_amount += $temp_amount [$h] ["amount"];
	                            }
	
	                            $booking_amount = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_totalprice"];
	                            $addons_sum = 0;
	                            if (($booking_amount - $addons_sum) != $otelms_amount) {
	                                if ($otelms_amount != 0) {
	                                    $reservation_data ["discount"] = $otelms_amount - ($booking_amount - $addons_sum);
	                                }
	                            }
	                            echo $otelms_amount;
	                            $reservation_data['is_overbook'] = $is_overbook;
	                            $reservation_data['hms_id'] = $hms_id;
	
	
	                            print_r($reservation_data);
	                            //die();
	                            $update_res = $this->frontdesk->UpdateReservation ( $reservation_data, 0, 1 );
	                            if ($update_res == "FreeError") {
	
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "error";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "Not Free rooms (overbooking not set)";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "update";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_status"] = "";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = $row->id;
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
	
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_name"] = $result_array [$i] ["reservation"] ["dc_guestname"];
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_phone"] = $result_array [$i] ["guest"] ['phone'];
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_email"] = $result_array [$i] ["guest"] ['email'];
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["date"] = "";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["datein"] = $datein;
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dateout"] = $dateout;
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["rates"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_rate_intdate_data"];
	                                $k ++;
	                            } else {
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "ok";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "update";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_status"] = "";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = $row->id;
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
	
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_name"] = $result_array [$i] ["reservation"] ["dc_guestname"];
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_phone"] = $result_array [$i] ["guest"] ['phone'];
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_email"] = $result_array [$i] ["guest"] ['email'];
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["date"] = "";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["datein"] = $datein;
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dateout"] = $dateout;
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["rates"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_rate_intdate_data"];
	                                $k ++;
	                            }
	                        } else {
	                            if ($type_id == 0 or $type_id == "") {
	                                $query2 = $this->db->query ( "SELECT int_value FROM dc_hostelworld_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
	                                if ($query->num_rows () > 0) {
	                                    $row2 = $query2->row ();
	                                    $type_id = $row2->int_value;
	                                }
	                            }
	                            if ($type_id == 0 or $type_id == "") {
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "error";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "UNKNOWN CATEGORY";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "update";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_status"] = "";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = $row->id;
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
	
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_name"] = $result_array [$i] ["reservation"] ["dc_guestname"];
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_phone"] = $result_array [$i] ["guest"] ['phone'];
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_email"] = $result_array [$i] ["guest"] ['email'];
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["date"] = "";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["datein"] = $datein;
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dateout"] = $dateout;
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["rates"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_rate_intdate_data"];
	                                $k ++;
	                            } else {
	                                $room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $type_id );
	                                if ($room_id == 0) {
	                                    $is_overbook = 1;
	                                    $reservation_data['is_overbook'] = $is_overbook;
	                                    if (isset ( $overbooking_category_id )) {
	                                        //$reservations [$i] ["reservation"] ["origin_categoryid"] = $reservation_data ["type_id"];
	                                        $reservation_data ["origin_categoryid"] = $reservation_data ["type_id"];
	                                        $room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $overbooking_category_id );
	
	                                        $insert_over_room_bool = 0;
	                                        if ($room_id == 0) {
	                                            $room_id = $this->dc_model->dc_make_overbooking_room ( $overbooking_category_id );
	                                            $insert_over_room_bool = 1;
	                                        }
	                                    } else {
	                                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "failed";
	                                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "no overbooking_category_id";
	                                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "new";
	                                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = 0;
	                                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
	                                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_room_id"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_type_id"];
	                                        // 											$result_array ["reservations"] [$reservations [$i] ["reservation"] ["category_id"] . "-" . $reservations [$i] ["reservation"] ["placement_id"]] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
	                                        // 											$result_array ["reservations"] [$reservations [$i] ["reservation"] ["category_id"] . "-" . $reservations [$i] ["reservation"] ["placement_id"]] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
	                                        // 											$result_array ["reservations"] [$reservations [$i] ["reservation"] ["category_id"] . "-" . $reservations [$i] ["reservation"] ["placement_id"]] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
	                                    }
	                                }
	                                $reservation_data ["room_id"] = $room_id;
	                                $reservation_data['hms_id'] = $hms_id;
	
	                                $update_res = $this->frontdesk->UpdateReservation ( $reservation_data, 0, 1 );
	
	                                // 									if (isset ( $otelms_rooms [$result_array [$i] ["reservation"] ["dc_uuid"]] )) {
	                                // 										$otelms_rooms [$reservations [$i] ["reservation"] ["dc_uuid"]] ["status"] = 1;
	                                // 									}
	
	                                if ($update_res == "FreeError") {
	                                    $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "error";
	                                    $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "";
	                                    $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "modified";
	                                    $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = $hms_reservation_id;
	                                    // 										$result_array ["reservations"] [$reservations [$i] ["reservation"] ["category_id"] . "-" . $reservations [$i] ["reservation"] ["placement_id"]] [$i] ["reservation"] ["reservation_alert"] = "";
	                                    // 										$result_array ["reservations"] [$reservations [$i] ["reservation"] ["category_id"] . "-" . $reservations [$i] ["reservation"] ["placement_id"]] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
	                                    // 										$result_array ["reservations"] [$reservations [$i] ["reservation"] ["category_id"] . "-" . $reservations [$i] ["reservation"] ["placement_id"]] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
	                                    $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
	                                    $k ++;
	                                } else {
	                                    $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "ok";
	                                    $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "";
	                                    $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["alert"] = "";
	                                    $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "modified";
	                                    $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = $hms_reservation_id;
	                                    // 										$result_array ["reservations"] [$reservations [$i] ["reservation"] ["category_id"] . "-" . $reservations [$i] ["reservation"] ["placement_id"]] [$i] ["reservation"] ["reservation_alert"] = "";
	                                    // 										$result_array ["reservations"] [$reservations [$i] ["reservation"] ["category_id"] . "-" . $reservations [$i] ["reservation"] ["placement_id"]] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
	                                    // 										$result_array ["reservations"] [$reservations [$i] ["reservation"] ["category_id"] . "-" . $reservations [$i] ["reservation"] ["placement_id"]] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
	                                    $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
	                                    $k ++;
	                                }
	                            }
	                        }
	
	
	                    }
	                } else {
	
	                    $room_id = 0;
	
	                    if ($type_id == 0 or $type_id == "") {
	                        $query2 = $this->db->query ( "SELECT int_value FROM dc_hostelworld_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
	                        if ($query->num_rows () > 0) {
	                            $row2 = $query2->row ();
	                            $type_id = $row2->int_value;
	                        }
	                    }
	
	                    if ($type_id == 0 or $type_id == "") {
	
	                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "failed";
	                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "UNKNOWN CATEGORY";
	                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "new";
	                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = 0;
	                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
	                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_room_id"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_type_id"];
	
	                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_name"] = $result_array [$i] ["reservation"] ["dc_guestname"];
	                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_phone"] = $result_array [$i] ["guest"] ['phone'];
	                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_email"] = $result_array [$i] ["guest"] ['email'];
	                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["date"] = "";
	                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["datein"] = $datein;
	                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dateout"] = $dateout;
	                        $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["rates"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_rate_intdate_data"];
	                        $k ++;
	                    } else {
	                        $room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $type_id );
	                        if ($room_id == 0) {
	                            $is_overbook = 1;
	
	                            if (isset ( $overbooking_category_id )) {
	                                //$reservations [$i] ["reservation"] ["origin_categoryid"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["hms_type_id"];
	                                //$result_array [$i] ["reservation"] ["roomnights"] [$j] ['origin_categoryid'] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["hms_type_id"];
	
	                                $room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $overbooking_category_id );
	
	                                $insert_over_room_bool = 0;
	                                if ($room_id == 0) {
	                                    $room_id = $this->dc_model->dc_make_overbooking_room ( $overbooking_category_id );
	                                    $insert_over_room_bool = 1;
	                                }
	                                $result_array [$i] ["reservation"] ["roomnights"] [$j] ["type_id"] = $type_id;
	                                $result_array [$i] ["reservation"] ["roomnights"] [$j] ["origin_categoryid"] = $type_id;
	                            } else {
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "failed";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "no overbooking_vcategory";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "new";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = 0;
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_room_id"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_type_id"];
	
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_name"] = $result_array [$i] ["reservation"] ["dc_guestname"];
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_phone"] = $result_array [$i] ["guest"] ['phone'];
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_email"] = $result_array [$i] ["guest"] ['email'];
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["date"] = "";
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["datein"] = $datein;
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dateout"] = $dateout;
	                                $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["rates"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_rate_intdate_data"];
	                            }
	                        }
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["room_id"] = $room_id;
	
	                        if ($bool_guest == 0) {
	                            $guest_id = $this->frontdesk->Guest_insert ( $result_array [$i] ["guest"] );
	                            $bool_guest = 1;
	                        }
	
	                        $calculate_data = array ();
	                        $calculate_data ["type_id"] = $result_array [$i] ["reservation"] ["type_id"];
	                        $calculate_data ["datein"] = $result_array [$i] ["reservation"] ["datein"];
	                        $calculate_data ["dateout"] = $result_array [$i] ["reservation"] ["dateout"];
	                        $calculate_data ["add_places"] = 0;
	                        $calculate_data ["baby_places"] = 0;
	                        $calculate_data ["addbedplace"] = 0;
	                        $calculate_data ["babyplace2"] = 0;
	                        $calculate_data ["price_type"] = $hms_rate_id;
	
	                        $temp_amount = $this->frontdesk->getpricecalculation ( $calculate_data );
	                        $otelms_amount = 0;
	                        for($h = 0; $h < count ( $temp_amount ); $h ++) {
	                            $otelms_amount += $temp_amount [$h] ["amount"];
	                        }
	
	                        $booking_amount = $result_array [$i] ["reservation"] ["roomnights"] [$j]["dc_totalprice"];
	                        $addons_sum = 0;
	                        if (($booking_amount - $addons_sum) != $otelms_amount) {
	                            if ($otelms_amount != 0) {
	                                $result_array [$i] ["reservation"] ["discount"] = $otelms_amount - ($booking_amount - $addons_sum);
	                                $result_array [$i] ["reservation"] ["roomnights"] [$j]["service_main_amount_2"] = 1;
	                                $result_array [$i] ["reservation"] ["roomnights"] [$j]["service_main_amount"] = $booking_amount;
	                            }
	                        }
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_numberofguest"] = count($result_array [$i] ["reservation"] ["count_guests"]);
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ["is_overbook"] = $is_overbook;
	                        $result_array [$i] ["reservation"] ["roomnights"] [$j] ['hms_id'] = $hms_id;
	                        //$result_array [$i] ["reservation"] ["roomnights"] [$j]["service_main_amount_2"] = 2;
	                        print_r($result_array [$i] ["reservation"] ["roomnights"] [$j]);
	                        //die();
	                        $reservation_id = $this->frontdesk->Reservation_insert ( $result_array [$i] ["reservation"] ["roomnights"] [$j], $guest_id, 0, 1 );
	                        if (isset ( $result_array [$i] ["card"] )) {
	                            $this->frontdesk->insert_tbl_CreditCards ( $result_array [$i] ["card"], $guest_id, $reservation_id );
	                        }
	
	                        if ($reservation_id > 0) {
	                            // ===== INSERT PAYMENT =========
	                            $payment_amount = $result_array [$i] ["reservation"] ["payment_amount"];
	                            if($payment_amount > 0 && $payment_insert == 0){
	                                $id_partner = $this->db->select('id')
	                                ->get_where('partners', array(
	                                    'isdefault' => 1
	                                ))
	                                ->row()->id;
	                                $insert_payment_arr = array(
	                                    'id_user' => - 1,
	                                    'reservation_id' => $reservation_id,
	                                    'amount' => $payment_amount,
	                                    'id_partner' => $id_partner,
	                                    'type' => 5,
	                                    'create_time' => date("Y-m-d H:i:s"),
	                                    'operationtime' => date("Y-m-d H:i:s"),
	                                    'description' => ""
	                                );
	                                $this->db->insert('payment', $insert_payment_arr);
	                                $pay_id = $this->db->insert_id();
	                                $payment_insert = 1;
	                                
	                                // calculate balance
	                                $this->frontdesk->SetReservationBalance ( $reservation_id );
	                            }
	                            // ===== END INSERT PAYMENT =========
	                             
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "ok";
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "";
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "new";
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_status"] = "";
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = $reservation_id;
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_room_id"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_type_id"];
	
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_name"] = $result_array [$i] ["reservation"] ["dc_guestname"];
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_phone"] = $result_array [$i] ["guest"] ['phone'];
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_email"] = $result_array [$i] ["guest"] ['email'];
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["date"] = "";
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["datein"] = $datein;
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dateout"] = $dateout;
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["rates"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_rate_intdate_data"];
	                            $k ++;
	                        } else {
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["response"] = "failed";
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["text"] = "undferror";
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["status"] = "new";
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_status"] = "";
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["hms_reservation_id"] = 0;
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_reservationid"] = $result_array [$i] ["reservation"] ['groupid'];
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dc_room_id"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_type_id"];
	
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_name"] = $result_array [$i] ["reservation"] ["dc_guestname"];
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_phone"] = $result_array [$i] ["guest"] ['phone'];
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["guest_email"] = $result_array [$i] ["guest"] ['email'];
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["date"] = "";
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["datein"] = $datein;
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["dateout"] = $dateout;
	                            $reservationpush [$result_array [$i] ["reservation"] ['groupid']] [$k] ["rates"] = $result_array [$i] ["reservation"] ["roomnights"] [$j] ["dc_rate_intdate_data"];
	                            $k ++;
	                        }
	                    }
	                }
	            }
	        }
	    }
	
	    $count_cancellations_array = count ( $cancellations_array );
	    for($i = 0; $i < $count_cancellations_array; $i ++) {
	        $time2 = date ( "Y-m-d H:i:s" );
	        $status = 5;
	
	        $query = $this->db->query ( "SELECT id as hms_reservation_id, room_id FROM deskofreservation WHERE deleted = 0 AND dc_reservationid = " . $cancellations_array [$i] ["dc_reservationid"] . " AND dc_roomreservation_id = " . $cancellations_array [$i] ["dc_roomreservation_id"] );
	
	        if ($query->num_rows () > 0) {
	            foreach ( $query->result () as $row ) {
	                $hms_reservation_id = $row->hms_reservation_id;
	                $query2 = $this->db->query ( "SELECT id FROM  services_main WHERE reservation_id = " . $hms_reservation_id . " AND type = 2" );
	
	                if ($query2->num_rows () > 0) {
	                    $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["response"] = "failed";
	                    $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["text"] = "есть уже отмена";
	                    $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["status"] = "cancel";
	
	                    $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["hms_reservation_id"] = $hms_reservation_id;
	                    $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["dc_reservationid"] = $cancellations_array [$i] ["dc_reservationid"] . "-" . $cancellations_array [$i] ["dc_roomreservation_id"];
	                    $k ++;
	                } else {
	                    $query2 = $this->db->query ( "SELECT id FROM deskofreservation WHERE dc_roomreservation_id = " . $cancellations_array [$i] ["dc_roomreservation_id"] );
	
	                    if ($query2->num_rows () > 0) {
	                        $data_cancel = array ();
	
	                        $data_cancel ["res_id"] = $hms_reservation_id;
	                        $data_cancel ["charge"] = 0;
	                        $data_cancel ["status"] = $status;
	                        $data_cancel ["description"] = "cancel from HW";
	                        $data_cancel ["guestbe_request"] = 0;
	                        $data_cancel ["user"] = - 1;
	                        // ====================
	                        $this->Cancel->Insert ( $data_cancel );
	                        // ====================
	                        $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["response"] = "ok";
	                        $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["text"] = "";
	                        $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["status"] = "cancel";
	                        $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["hms_reservation_id"] = $hms_reservation_id;
	                        $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["dc_reservationid"] = $cancellations_array [$i] ["dc_reservationid"] . "-" . $cancellations_array [$i] ["dc_roomreservation_id"];
	                        $k ++;
	                    } else {
	                        $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["response"] = "failed";
	                        $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["text"] = "нет брони для отмены";
	                        $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["status"] = "cancel";
	
	                        $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["hms_reservation_id"] = 0;
	                        $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["dc_reservationid"] = $cancellations_array [$i] ["dc_reservationid"] . "-" . $cancellations_array [$i] ["dc_roomreservation_id"];
	                        $k ++;
	                    }
	                }
	            }
	        } else {
	            $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["response"] = "failed";
	            $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["text"] = "нет брони для отмены";
	            $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["status"] = "cancel";
	
	            $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["hms_reservation_id"] = 0;
	            $reservationpush [$cancellations_array [$i] ['groupid']] [$k] ["dc_reservationid"] = $cancellations_array [$i] ["dc_reservationid"] . "-" . $cancellations_array [$i] ["dc_roomreservation_id"];
	            $k ++;
	        }
	    }
	    echo "+++++++";
	    if ($debug == true) {
	        print_r ( $reservationpush );
	    }
	    // die ();
	    $result = array ();
	    $result ["view_data"] = array ();
	    $ack_bookings = array ();
	    $i = 0;
	    foreach ( $reservationpush as $key => $arg1 ) {
	        foreach ( $arg1 as $arg ) {
	            $data = array ();
	            $data ["hms_reservation_id"] = $arg ["hms_reservation_id"];
	            $data ['response'] = $arg ['response'];
	            $data ['resid'] = $arg ['dc_reservationid'];
	            $data ['dcname'] = "HW";
	            $data ['text'] = $arg ['text'];
	            $data ['status'] = $arg ['status'];
	
	            $result ["view_data"] [$i] = $data;
	
	            // $this->dc_model->send_notifyarray ( $data );
	            if ($arg ['response'] == "ok" and ($arg ['status'] == "new" or $arg ['status'] == "update")) {
	                $ack_bookings ["bookings"] [$arg ['dc_reservationid']] ['ref'] = $arg ['dc_reservationid'];
	            }
	
	            // must pull to LOG ORDERS
	            $ack_bookings ["bookings"] [$arg ['dc_reservationid']] ['ref'] = $arg ['dc_reservationid'];
	            // !!!!!
	
	            // if ($arg ['response'] == "ok" and $arg ['status'] ==
	            // "cancel") {
	            // if ($arg ['response'] == "ok" ) {
	            if ($arg ['status'] == "cancel") {
	                $ack_bookings ["cancellations"] [$arg ['dc_reservationid']] ['ref'] = $arg ['dc_reservationid'];
	            }
	            $result ["ack_bookings"] = $ack_bookings;
	            $i ++;
	        }
	    }
	
	    foreach ( $reservationpush as $goupid => $arg1 ) {
	        $msg = "";
	        foreach ( $arg1 as $arg ) {
	            if ($arg ["status"] == "new" or $arg ["status"] == "update" or $arg ["status"] == "cancel") {
	                $data = array ();
	                $data ["hms_reservation_id"] = $arg ["hms_reservation_id"];
	                $data ['resid'] = $arg ['dc_reservationid'];
	                $data ['response'] = $arg ['response'];
	                $data ['text'] = $arg ['text'];
	                if (isset ( $arg ['fff'] )) {
	                    $data ['fff'] = $arg ['fff'];
	                }
	                $data ['dcname'] = "HW";
	                $data ['status'] = $arg ['status'];
	                // $this->dc_model->send_notifyarray ( $data );
	                // ==============================================
	                if (isset ( $arg ['guest_name'] )) {
	                    $data ['guest_name'] = $arg ['guest_name'];
	                }
	                if (isset ( $arg ['guest_phone'] )) {
	                    $data ['guest_phone'] = $arg ['guest_phone'];
	                }
	                if (isset ( $arg ['guest_email'] )) {
	                    $data ['guest_email'] = $arg ['guest_email'];
	                }
	                if (isset ( $arg ['date'] )) {
	                    $data ['date'] = $arg ['date'];
	                }
	                if (isset ( $arg ['datein'] )) {
	                    $data ['arrival_date'] = $arg ['datein'];
	                }
	                if (isset ( $arg ['dateout'] )) {
	                    $data ['departure_date'] = $arg ['dateout'];
	                }
	                if (isset ( $arg ['rates'] )) {
	                    $data ['rates'] = $arg ['rates'];
	                }
	                $data ['template'] = 1;
	                $data ['room_name'] = "";
	                $dcname = $data ['dcname'];
	                $data ['resid'] = $arg ["hms_reservation_id"];
	                $msg .= $this->dc_model->msg_txt ( $data, false, $host );
	            }
	        }
	        if ($msg != "") {
	            $this->dc_model->send_notifyarray_dc ( $msg, $dcname, $goupid, false, $arg ["status"] );
	        }
	    }
	
	    return $result;
	}
	
	
	
	function save_log($url, $request, $result) {
		$hotel_id = $this->gethotelid ();
		$data = array (
				'request' => $request,
				'url' => $url 
		);
		$this->db->insert ( 'dc_hostelworld_log', $data );
		$id = $this->db->insert_id ();
		// echo $id;
		$timestart = microtime ( true );
		$data = array (
				'response' => $result,
				'stime' => (microtime ( true ) - $timestart) 
		);
		
		$this->db->update ( 'dc_hostelworld_log', $data, array (
				'id' => $id 
		) );
		
		$sql = "INSERT INTO global_hotelix.dc_xml_log (hotel_id, db_name, log_id, dc_id, responsetext, responseint, time)
				VALUES('" . $hotel_id . "', DATABASE(), '" . $id . "','8','" . addslashes ( $result ) . "','',
						'" . date ( "Y-m-d H:i:s" ) . "')";
		$query = $this->db->query ( $sql );
		
		// local_log save
		
		$sql = "INSERT INTO dc_xml_log (log_id, dc_id, responsetext, responseint, time)
				VALUES('" . $id . "','8','" . addslashes ( $result ) . "','',
						'" . date ( "Y-m-d H:i:s" ) . "')";
		$query = $this->db->query ( $sql );
	}
	function dc_rate_intdate_insert($data) {
		$count = count ( $data );
		if ($count != 0) {
			$query = $this->db->query ( "DELETE FROM dc_hostelworld_rate_intdate WHERE dc_roomreservation_id = " . $data [0] ["dc_roomreservation_id"] );
			for($i = 0; $i < $count; $i ++) {
				$sql = "INSERT INTO dc_hostelworld_rate_intdate (dc_roomreservation_id, dc_rate_id, intdate, price) VALUES('" . $data [$i] ["dc_roomreservation_id"] . "',
		'" . $data [$i] ["dc_rate_id"] . "', '" . $data [$i] ["intdate"] . "', '" . $data [$i] ["price"] . "')
		ON DUPLICATE KEY UPDATE price = '" . $data [$i] ["price"] . "'";
				// echo $sql;
				$query = $this->db->query ( $sql );
			}
		}
	}
}
?>
