<?

function objectToArray_2($d)
{
    if (is_object($d)) {
        // Gets the properties of the given object
        // with get_object_vars function
        $d = get_object_vars($d);
    }
    
    if (is_array($d)) {
        // Return array converted to object Using __FUNCTION__ (Magic constant)
        // for recursive call
        return array_map('objectToArray_2', $d);
    } else {
        // Return array
        return $d;
    }
}

class dcm_booking extends CI_Model
{

    function __construct()
    {
        parent::__construct();
        
        if (isset($GLOBALS['cron_last_changed'])) {
            echo "CLC_on";
        
        } else {
        
        $this->load->model('Cancel');
        $this->load->model('dc_model');
        $this->load->model('dc_ostrovok_model');
        $this->load->model('dcm_expedia');
        $this->load->model('dcm_hostelsclub');
        $this->load->model('dcm_hostelworld');
        $this->load->model('dcm_101otel');
        // $this->load->model('dcm_hotels24');
        //$this->load->model('dcm_wubook');
        $this->load->model('dcm_vashotel');
        $this->load->model('dcm_eholiday');
        $this->load->model('service_model');
        $this->load->model('frontdesk');
        $this->load->model('Curl_model');
        $this->load->model('dcm_ozon');
        $this->load->model('dcm_hotelbook');
        $this->load->model('dcm_dobovo');
        $this->load->model('dcm_cbooking');
        $this->load->model('dcm_onetwotrip');
        $this->load->model('dcm_nashtravel');
        $this->load->model('dcm_ctrip');
        $this->load->model('releases');
        $this->load->model( 'pay' );
        $this->load->model('dcm_payment');
        $this->load->model('dcm_airbnb');
        $this->load->model('dcm_avito');
        $this->load->model('dcm_yandex');
        $this->load->model('dcm_su');
        //$this->load->model('dcm_academservice');
        }
    }

    function gethotelid()
    {
        $query = $this->db->query("SELECT int_value FROM dc_booking_xml_cfg WHERE name LIKE 'hotel_id'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $hotel_id = $row->int_value;
        } else {
            $hotel_id = "none";
        }
        return $hotel_id;
    }
    
    function get_booking_hotels(){
        $hotels = array();
        $sql = "SELECT str_value, int_value FROM dc_booking_xml_cfg WHERE name LIKE 'hotel_id' AND dc_account_id > 0";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $i = 0;
            foreach ( $query->result () as $row ) {
                $hotels [$i] ['hotel_id'] = $row->int_value;
                $hotels [$i] ['hotel_name'] = $row->str_value;
                $i++;
            }
        }
        
        return $hotels;
    }
    
    function get_booking_default_service()
    {
    	$extracomponent_type = 0;
    	$query = $this->db->query("SELECT int_value FROM dc_booking_xml_cfg WHERE name LIKE 'extracomponent_type'");
    	if ($query->num_rows() > 0) {
    		$row = $query->row();
    		$extracomponent_type = $row->int_value;
    	} else {
    		$extracomponent_type = 0;
    	}
    	$bool = false;
    	$query = $this->db->query("SELECT id FROM services_types WHERE id = ".$extracomponent_type);
    	if ($query->num_rows() > 0) {
    		$row = $query->row();
    		$bool = true;
    	}
    	return $bool;
    }

    function setrestrict($datein, $dateout, $returntype = 0)
    {
        list ($year, $month, $day) = explode("-", $datein);
        $intdatein = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
        list ($year, $month, $day) = explode("-", $dateout);
        $intdateout = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
        
        $restrict = array();
        
        /*
         * $sql = "SELECT * FROM `dc_booking_rooms_link` ";
         * $query = $this->db->query ( $sql );
         * $rooms = array ();
         * foreach ( $query->result () as $row ) {
         * $rooms [$row->dc_room_id] = $row->dc_room_id;
         * }
         *
         * $sql = "SELECT * FROM dc_booking_rates_link";
         * $query = $this->db->query ( $sql );
         * $rates = array ();
         * foreach ( $query->result () as $row ) {
         * $rates [$row->dc_rate_id] = $row->dc_rate_id;
         * }
         *
         * foreach ( $rooms as $room ) {
         * $restrict [$room] = array ();
         * foreach ( $rates as $rate ) {
         * $restrict [$room] [$rate] = array ();
         * for($i = $intdatein; $i <= $intdateout; $i ++) {
         * $cell = array ();
         * $cell ['date'] = gmdate ( "Y-m-d", $i * 86400 );
         * $cell ['closed'] = 0;
         * $cell ['minimumstay'] = 0;
         * $cell ['maximumstay'] = 0;
         * $cell ['closedonarrival'] = 0;
         * $cell ['closedondeparture'] = 0;
         * ksort ( $cell );
         * $restrict [$room] [$rate] [$i] = $cell;
         * }
         * }
         * }
         */
        $restrict = array();
        $sql = "SELECT dc_room_id, dc_rate_id,  ratetocategory.category_id, ratetocategory.rate_id, ratetocategory.onlinebook FROM ratetocategory
				INNER JOIN dc_booking_rates_link ON dc_booking_rates_link.hms_rate_id = ratetocategory.rate_id
				INNER JOIN dc_booking_rooms_link ON dc_booking_rooms_link.category_id = ratetocategory.category_id 
				WHERE onlinebook=1";
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            $restrict[$row->dc_room_id][$row->dc_rate_id] = array();
            for ($i = $intdatein; $i <= $intdateout; $i ++) {
                $cell = array();
                $cell['date'] = gmdate("Y-m-d", $i * 86400);
                $cell['closed'] = 0;
                $cell['minimumstay'] = 0;
                $cell['maximumstay'] = 0;
                $cell['closedonarrival'] = 0;
                $cell['closedondeparture'] = 0;
                ksort($cell);
                $restrict[$row->dc_room_id][$row->dc_rate_id][$i] = $cell;
            }
        }
        
        $sql = "SELECT deskofrate.*, dc_booking_rooms_link.dc_room_id as dc_category_id,
				dc_booking_rates_link.dc_rate_id as dc_rate_id FROM deskofrate INNER JOIN
				dc_booking_rooms_link ON deskofrate.category_id = dc_booking_rooms_link.category_id INNER JOIN
				dc_booking_rates_link ON dc_booking_rates_link.restrict_id = deskofrate.rate_id
				INNER JOIN ratetocategory ON ratetocategory.category_id = deskofrate.category_id AND ratetocategory.rate_id = dc_booking_rates_link.hms_rate_id 		
				WHERE ratetocategory.onlinebook = 1 AND intdate >=" . $intdatein . " AND intdate <=" . $intdateout;
        // echo $sql;
        
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            if ($row->maxstay != 0)
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['maximumstay'] = $row->maxstay;
            else
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['maximumstay'] = 0;
            
            if ($row->closed == 1)
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['closed'] = 1;
            else
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['closed'] = 0;
            
            if ($row->closedonarrival == 1)
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['closedonarrival'] = 1;
            else
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['closedonarrival'] = 0;
            
            if ($row->closedondeparture == 1)
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['closedondeparture'] = 1;
            else
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['closedondeparture'] = 0;
            
            if ($row->minstaythrought != 0)
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['minimumstay'] = $row->minstaythrought;
            else
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['minimumstay'] = 0;
        }
        
        $query = $this->db->query("SELECT int_value FROM dc_booking_xml_cfg WHERE name LIKE 'hotel_id'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $hotel_id = $row->int_value;
        } else {
            $hotel_id = "none";
        }
        // echo "<pre>";
        // print_r ( $restrict );
        // die();
        // echo "<pre>";
        
        $xml = "<request>";
        $xml .= "<username>" . $this->config->item('dc_booking_xml_user') . "</username>";
        $xml .= "<password>" . $this->config->item('dc_booking_xml_pwd') . "</password>";
        $xml .= "<hotel_id>" . $hotel_id . "</hotel_id>";
        
        /*
         * foreach ( $rooms as $room ) { foreach ( $rates as $rate ) { $xml .= "\n"; $xml .= '<room id="' . $room . '">'; $xml .= "\n"; $day = $rate; for($intday = $intdatein; $intday <= $intdateout; $intday ++) { $dayi = 0; $xmld = ""; $xmld .= '<date value="' . date ( 'Y-m-d', $intday * 3600 * 24 ) . '">'; $xmld .= "\n"; $xmld .= '<rate id="' . $rate . '"/>'; $xmld .= "\n"; $xmld .= '<minimumstay>' . $restrict [$room] [$rate] [$intday] ['minimumstay'] . '</minimumstay>'; $xmld .= "\n"; $xmld .= '<maximumstay>' . $restrict [$room] [$rate] [$intday] ['maximumstay'] . '</maximumstay>'; $xmld .= "\n"; $xmld .= '<closed>' . $restrict [$room] [$rate] [$intday] ['closed'] . '</closed>'; $xmld .= "\n"; $xmld .= '<closedonarrival>' . $restrict [$room] [$rate] [$intday] ['closedonarrival'] . '</closedonarrival>'; $xmld .= "\n"; $xmld .= '<closedondeparture>' . $restrict [$room] [$rate] [$intday] ['closedondeparture'] . '</closedondeparture>'; $xmld .= "\n"; $xmld .= '</date>'; $xmld .= "\n"; $xml .= $xmld; } $xml .= '</room>'; $xml .= "\n"; } }
         */
        
        foreach ($restrict as $room => $rates) {
            foreach ($rates as $rate => $cell) {
                
                $xml .= "\n";
                $xml .= '<room id="' . $room . '">';
                $xml .= "\n";
                $day = $rate;
                
                for ($intday = $intdatein; $intday <= $intdateout; $intday ++) {
                    $dayi = 0;
                    $xmld = "";
                    $xmld .= '<date value="' . gmdate('Y-m-d', $intday * 3600 * 24) . '">';
                    $xmld .= "\n";
                    
                    $xmld .= '<rate id="' . $rate . '"/>';
                    $xmld .= "\n";
                    
                    $xmld .= '<minimumstay>' . $restrict[$room][$rate][$intday]['minimumstay'] . '</minimumstay>';
                    $xmld .= "\n";
                    
                    $xmld .= '<maximumstay>' . $restrict[$room][$rate][$intday]['maximumstay'] . '</maximumstay>';
                    $xmld .= "\n";
                    
                    $xmld .= '<closed>' . $restrict[$room][$rate][$intday]['closed'] . '</closed>';
                    $xmld .= "\n";
                    
                    $xmld .= '<closedonarrival>' . $restrict[$room][$rate][$intday]['closedonarrival'] . '</closedonarrival>';
                    $xmld .= "\n";
                    
                    $xmld .= '<closedondeparture>' . $restrict[$room][$rate][$intday]['closedondeparture'] . '</closedondeparture>';
                    $xmld .= "\n";
                    
                    $xmld .= '</date>';
                    $xmld .= "\n";
                    $xml .= $xmld;
                }
                $xml .= '</room>';
                $xml .= "\n";
            }
        }
        
        $xml .= '</request>';
        
        $url = $this->config->item('dc_booking_xml_host') . "hotels/xml/availability";
        $data_result = $this->Curl_model->CurlPlugRAW($xml, $url, 1, array(
            "returntype" => "array"
        ));
        
        $request = $data_result["result"];
        
        $result = $request;
        if ((strpos($request, "<ok/>") === 0) || (strpos($request, "<ok></ok>") === 0)) {
            $result .= "Booking.com: Ограничения выгружены успешно";
        } else {
            $result .= "Booking.com: Выгрузка ограничений с ошибками";
            $this->dc_model->dc_save_error(1, $request . " datein = " . $datein . " dateout = " . $dateout . " uploadrooms restrict");
        }
        if ($returntype == 0) {
            return $result;
        } else {
            $data_result["result"] = $result;
            return $data_result;
        }
        // return $result;
    }

    function setrestrict_cron($returntype = 0, $db_name = "", $debug = "", $dc_hotel_id)
    {
        $restrict = array();
        
        $sql = "SELECT * FROM  `dc_log` WHERE dc_id = 1" . " AND dc_log.dc_hotel_id = $dc_hotel_id";
        $query = $this->db->query($sql);
        $dc_log_data = array();
        foreach ($query->result() as $row) {
            $dc_log_data[$row->intdate] = 1;
        }
        $dc_log_intdates = array_keys($dc_log_data);
        
        $sql = "SELECT dc_booking_rooms_link.* FROM  `dc_booking_rooms_link` INNER JOIN dc_log ON dc_log.categoryid = dc_booking_rooms_link.category_id 
            WHERE dc_log.dc_hotel_id = $dc_hotel_id";
        $query = $this->db->query($sql);
        $rooms = array();
        foreach ($query->result() as $row) {
            $rooms[$row->dc_room_id] = $row->dc_room_id;
        }
        
        $datein = "";
        $dateout = "";
        
        $restrict = array();
        
        $sql = "SELECT deskofrate.minstay, deskofrate.maxstay, deskofrate.minstayarrival, deskofrate.minstaythrought, deskofrate.closed,
		deskofrate.closedonarrival, deskofrate.minstay, deskofrate.closedondeparture, dc_log.intdate, dc_booking_rooms_link.dc_room_id as dc_category_id,
		dc_booking_rates_link.dc_rate_id as dc_rate_id FROM dc_log
		INNER JOIN dc_booking_rooms_link ON dc_log.categoryid = dc_booking_rooms_link.category_id
		INNER JOIN ratetocategory ON ratetocategory.category_id = dc_log.categoryid
		INNER JOIN categories ON categories.id = dc_log.categoryid
		INNER JOIN dc_booking_rates_link ON dc_booking_rates_link.hms_rate_id = ratetocategory.rate_id
		LEFT JOIN deskofrate ON deskofrate.intdate = dc_log.intdate AND deskofrate.category_id = dc_log.categoryid AND dc_booking_rates_link.restrict_id = deskofrate.rate_id
		WHERE dc_log.dc_id = 1 AND onlinebook = 1 AND categories.is_active = 1 ORDER BY dc_log.intdate ASC";
        
        $sql = "SELECT deskofrate.minstay, deskofrate.maxstay, deskofrate.minstayarrival, deskofrate.minstaythrought, deskofrate.closed,
		deskofrate.closedonarrival, deskofrate.minstay, deskofrate.closedondeparture, dc_log.intdate, dc_booking_rooms_link.dc_room_id as dc_category_id,
		dc_booking_rates_link.dc_rate_id as dc_rate_id FROM dc_log
		INNER JOIN dc_booking_rooms_link ON dc_log.categoryid = dc_booking_rooms_link.category_id AND dc_log.dc_hotel_id = dc_booking_rooms_link.dc_hotel_id
INNER JOIN dc_booking_rate2category_link ON dc_booking_rate2category_link.dc_category_id = dc_booking_rooms_link.dc_room_id
 AND dc_booking_rate2category_link.hms_rate_id != 0
		INNER JOIN dc_booking_rates_link ON dc_booking_rates_link.dc_rate_id = dc_booking_rate2category_link.dc_rate_id
		LEFT JOIN deskofrate ON deskofrate.intdate = dc_log.intdate AND deskofrate.category_id = dc_log.categoryid AND dc_booking_rates_link.restrict_id = deskofrate.rate_id
		WHERE dc_log.dc_id = 1  AND dc_log.dc_hotel_id = $dc_hotel_id  ORDER BY dc_log.intdate ASC";
        // echo $sql;
        
        // die();
        
        if ($debug == "debugon") {
            echo "<pre>";
            echo $sql;
        }
        
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['from'] = $row->intdate;
            $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['to'] = $row->intdate;
            if ($row->maxstay != 0)
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['maximumstay'] = $row->maxstay;
            else
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['maximumstay'] = 0;
            
            if ($row->closed == 1)
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['closed'] = 1;
            else
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['closed'] = 0;
            
            if ($row->closedonarrival == 1)
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['closedonarrival'] = 1;
            else
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['closedonarrival'] = 0;
            
            if ($row->closedondeparture == 1)
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['closedondeparture'] = 1;
            else
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['closedondeparture'] = 0;
            
            if ($row->minstaythrought != 0)
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['minimumstay'] = $row->minstaythrought;
            else
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['minimumstay'] = 0;
        }
        if ($debug == "debugon") {
            echo "<pre>";
            print_r($restrict);
        }
        $restrict_new = array();
        foreach ($restrict as $room => $rates) {
            foreach ($rates as $rate => $cell) {
                foreach ($cell as $intday => $cell2) {
                    if (true) {
                        $prev = $intday - 1;
                        if (isset($restrict[$room][$rate][$prev])) {
                            $obj_1 = $restrict[$room][$rate][$prev]["maximumstay"] . $restrict[$room][$rate][$prev]["closed"] . $restrict[$room][$rate][$prev]["closedonarrival"] . $restrict[$room][$rate][$prev]["closedondeparture"] . $restrict[$room][$rate][$prev]["minimumstay"];
                            $obj_2 = $restrict[$room][$rate][$intday]["maximumstay"] . $restrict[$room][$rate][$intday]["closed"] . $restrict[$room][$rate][$intday]["closedonarrival"] . $restrict[$room][$rate][$intday]["closedondeparture"] . $restrict[$room][$rate][$intday]["minimumstay"];
                            // echo $obj_1 . " " . $obj_2 . "<br>";
                            if (strcmp($obj_1, $obj_2) === 0) {
                                $restrict[$room][$rate][$intday]["from"] = $restrict[$room][$rate][$prev]["from"];
                                unset($restrict[$room][$rate][$prev]);
                            }
                        }
                    }
                }
            }
        }
        // echo "<pre>";
        // print_r ( $restrict );
        foreach ($restrict as $category_id => $rates) {
            foreach ($rates as $rate_id => $intdates) {
                foreach ($intdates as $intdate => $cell) {
                    // echo $category_id." ".$rate_id." ".$intdate."<br>";
                    
                    $intdate_to = $restrict[$category_id][$rate_id][$intdate]["to"];
                    
                    $intdate_to = $intdate_to + 1;
                    
                    $restrict[$category_id][$rate_id][$intdate]["to"] = $intdate_to;
                }
            }
        }
        
        if ($debug == "debugon") {
            echo "<pre>" . count($restrict);
            print_r($restrict);
            // die();
        }
        
        $query = $this->db->query("SELECT int_value FROM dc_booking_xml_cfg WHERE name LIKE 'hotel_id'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $hotel_id = $row->int_value;
        } else {
            $hotel_id = "none";
        }
        
        $hotel_id = $dc_hotel_id;
        
        // echo "<pre>";
        if (count($restrict) < 1) {
            if ($returntype == 0) {
                $result = "";
                return $result;
            } else {
                $data_result = array();
                $data_result["result"] = 0;
                $data_result["request_null"] = 1;
                $data_result["dc_log_id"] = 0;
                return $data_result;
            }
        }
        
        $xml = "<request>";
        $xml .= "<username>" . $this->config->item('dc_booking_xml_user') . "</username>";
        $xml .= "<password>" . $this->config->item('dc_booking_xml_pwd') . "</password>";
        $xml .= "<hotel_id>" . $hotel_id . "</hotel_id>";
        
        /*
         * foreach ( $rooms as $room ) { foreach ( $rates as $rate ) { $xml .= "\n"; $xml .= '<room id="' . $room . '">'; $xml .= "\n"; $day = $rate; for($intday = $intdatein; $intday <= $intdateout; $intday ++) { $dayi = 0; $xmld = ""; $xmld .= '<date value="' . date ( 'Y-m-d', $intday * 3600 * 24 ) . '">'; $xmld .= "\n"; $xmld .= '<rate id="' . $rate . '"/>'; $xmld .= "\n"; $xmld .= '<minimumstay>' . $restrict [$room] [$rate] [$intday] ['minimumstay'] . '</minimumstay>'; $xmld .= "\n"; $xmld .= '<maximumstay>' . $restrict [$room] [$rate] [$intday] ['maximumstay'] . '</maximumstay>'; $xmld .= "\n"; $xmld .= '<closed>' . $restrict [$room] [$rate] [$intday] ['closed'] . '</closed>'; $xmld .= "\n"; $xmld .= '<closedonarrival>' . $restrict [$room] [$rate] [$intday] ['closedonarrival'] . '</closedonarrival>'; $xmld .= "\n"; $xmld .= '<closedondeparture>' . $restrict [$room] [$rate] [$intday] ['closedondeparture'] . '</closedondeparture>'; $xmld .= "\n"; $xmld .= '</date>'; $xmld .= "\n"; $xml .= $xmld; } $xml .= '</room>'; $xml .= "\n"; } }
         */
        
        foreach ($restrict as $room => $rates) {
            foreach ($rates as $rate => $cell) {
                
                $xml .= "\n";
                $xml .= '<room id="' . $room . '">';
                $xml .= "\n";
                $day = $rate;
                foreach ($cell as $intday => $cell2) {
                    // for($intday = $intdatein; $intday <= $intdateout; $intday ++) {
                    $dayi = 0;
                    $xmld = "";
                    // $xmld .= '<date value="' . gmdate ( 'Y-m-d', $intday * 3600 * 24 ) . '">';
                    
                    $xmld .= '<date from="' . gmdate('Y-m-d', $restrict[$room][$rate][$intday]['from'] * 3600 * 24) . '" to="' . gmdate('Y-m-d', $restrict[$room][$rate][$intday]['to'] * 3600 * 24) . '">';
                    
                    $xmld .= "\n";
                    
                    $xmld .= '<rate id="' . $rate . '"/>';
                    $xmld .= "\n";
                    
                    $xmld .= '<minimumstay>' . $restrict[$room][$rate][$intday]['minimumstay'] . '</minimumstay>';
                    $xmld .= "\n";
                    
                    $xmld .= '<maximumstay>' . $restrict[$room][$rate][$intday]['maximumstay'] . '</maximumstay>';
                    $xmld .= "\n";
                    
                    $xmld .= '<closed>' . $restrict[$room][$rate][$intday]['closed'] . '</closed>';
                    $xmld .= "\n";
                    
                    $xmld .= '<closedonarrival>' . $restrict[$room][$rate][$intday]['closedonarrival'] . '</closedonarrival>';
                    $xmld .= "\n";
                    
                    $xmld .= '<closedondeparture>' . $restrict[$room][$rate][$intday]['closedondeparture'] . '</closedondeparture>';
                    $xmld .= "\n";
                    
                    $xmld .= '</date>';
                    $xmld .= "\n";
                    $xml .= $xmld;
                }
                $xml .= '</room>';
                $xml .= "\n";
            }
        }
        
        $xml .= '</request>';
        if ($debug == "debugon") {
            echo $xml;
        }
        // die();
        $data_result = array();
        
        $url = $this->config->item('dc_booking_xml_host') . "hotels/xml/availability";
        $data_result = $this->Curl_model->CurlPlugRAW($xml, $url, 1, array(
            "returntype" => "array"
        ));
        
        $request = $data_result["result"];
        
        $result = $request;
        //if ((strpos($request, "<ok/>") === 0) || (strpos($request, "<ok></ok>") === 0)) {
        if ((strpos ( $result, "<ok/>" ) > 0) || (strpos ( $result, "<ok></ok>" ) > 0)) {
            $result .= "Booking.com: Ограничения выгружены успешно";
        } else {
            $result .= "Booking.com: Выгрузка ограничений с ошибками";
            $this->dc_model->cron_dc_save_error($db_name, 1, $request . " datein = " . $datein . " dateout = " . $dateout . " uploadrooms restrict");
        }
        if ($returntype == 0) {
            return $result;
        } else {
            $data_result["result"] = $result;
            return $data_result;
        }
        // return $result;
    }

    function setrestrict_cron_OLD($returntype = 0, $db_name = "")
    {
        $restrict = array();
        
        $sql = "SELECT * FROM  `dc_log` WHERE dc_id = 1";
        $query = $this->db->query($sql);
        $dc_log_data = array();
        foreach ($query->result() as $row) {
            $dc_log_data[$row->intdate] = 1;
        }
        $dc_log_intdates = array_keys($dc_log_data);
        
        $sql = "SELECT dc_booking_rooms_link.* FROM  `dc_booking_rooms_link` INNER JOIN dc_log ON dc_log.categoryid = dc_booking_rooms_link.category_id ";
        $query = $this->db->query($sql);
        $rooms = array();
        foreach ($query->result() as $row) {
            $rooms[$row->dc_room_id] = $row->dc_room_id;
        }
        
        $datein = "";
        $dateout = "";
        
        $restrict = array();
        
        $sql = "SELECT deskofrate.minstay, deskofrate.maxstay, deskofrate.minstayarrival, deskofrate.minstaythrought, deskofrate.closed,
		deskofrate.closedonarrival, deskofrate.minstay, deskofrate.closedondeparture, dc_log.intdate, dc_booking_rooms_link.dc_room_id as dc_category_id,
		dc_booking_rates_link.dc_rate_id as dc_rate_id FROM dc_log
		INNER JOIN dc_booking_rooms_link ON dc_log.categoryid = dc_booking_rooms_link.category_id
		INNER JOIN ratetocategory ON ratetocategory.category_id = dc_log.categoryid
		INNER JOIN categories ON categories.id = dc_log.categoryid
		INNER JOIN dc_booking_rates_link ON dc_booking_rates_link.hms_rate_id = ratetocategory.rate_id
		LEFT JOIN deskofrate ON deskofrate.intdate = dc_log.intdate AND deskofrate.category_id = dc_log.categoryid AND dc_booking_rates_link.restrict_id = deskofrate.rate_id
		WHERE dc_log.dc_id = 1 AND onlinebook = 1 AND categories.is_active = 1";
        // echo $sql;
        
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            
            if ($row->maxstay != 0)
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['maximumstay'] = $row->maxstay;
            else
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['maximumstay'] = 0;
            
            if ($row->closed == 1)
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['closed'] = 1;
            else
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['closed'] = 0;
            
            if ($row->closedonarrival == 1)
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['closedonarrival'] = 1;
            else
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['closedonarrival'] = 0;
            
            if ($row->closedondeparture == 1)
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['closedondeparture'] = 1;
            else
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['closedondeparture'] = 0;
            
            if ($row->minstaythrought != 0)
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['minimumstay'] = $row->minstaythrought;
            else
                $restrict[$row->dc_category_id][$row->dc_rate_id][$row->intdate]['minimumstay'] = 0;
        }
        
        echo "<pre>" . count($restrict);
        print_r($restrict);
        die();
        
        $query = $this->db->query("SELECT int_value FROM dc_booking_xml_cfg WHERE name LIKE 'hotel_id'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $hotel_id = $row->int_value;
        } else {
            $hotel_id = "none";
        }
        
        // echo "<pre>";
        if (count($restrict) < 1) {
            if ($returntype == 0) {
                $result = "";
                return $result;
            } else {
                $data_result = array();
                $data_result["result"] = 0;
                $data_result["request_null"] = 1;
                $data_result["dc_log_id"] = 0;
                return $data_result;
            }
        }
        
        $xml = "<request>";
        $xml .= "<username>" . $this->config->item('dc_booking_xml_user') . "</username>";
        $xml .= "<password>" . $this->config->item('dc_booking_xml_pwd') . "</password>";
        $xml .= "<hotel_id>" . $hotel_id . "</hotel_id>";
        
        /*
         * foreach ( $rooms as $room ) { foreach ( $rates as $rate ) { $xml .= "\n"; $xml .= '<room id="' . $room . '">'; $xml .= "\n"; $day = $rate; for($intday = $intdatein; $intday <= $intdateout; $intday ++) { $dayi = 0; $xmld = ""; $xmld .= '<date value="' . date ( 'Y-m-d', $intday * 3600 * 24 ) . '">'; $xmld .= "\n"; $xmld .= '<rate id="' . $rate . '"/>'; $xmld .= "\n"; $xmld .= '<minimumstay>' . $restrict [$room] [$rate] [$intday] ['minimumstay'] . '</minimumstay>'; $xmld .= "\n"; $xmld .= '<maximumstay>' . $restrict [$room] [$rate] [$intday] ['maximumstay'] . '</maximumstay>'; $xmld .= "\n"; $xmld .= '<closed>' . $restrict [$room] [$rate] [$intday] ['closed'] . '</closed>'; $xmld .= "\n"; $xmld .= '<closedonarrival>' . $restrict [$room] [$rate] [$intday] ['closedonarrival'] . '</closedonarrival>'; $xmld .= "\n"; $xmld .= '<closedondeparture>' . $restrict [$room] [$rate] [$intday] ['closedondeparture'] . '</closedondeparture>'; $xmld .= "\n"; $xmld .= '</date>'; $xmld .= "\n"; $xml .= $xmld; } $xml .= '</room>'; $xml .= "\n"; } }
         */
        
        foreach ($restrict as $room => $rates) {
            foreach ($rates as $rate => $cell) {
                
                $xml .= "\n";
                $xml .= '<room id="' . $room . '">';
                $xml .= "\n";
                $day = $rate;
                foreach ($cell as $intday => $cell2) {
                    // for($intday = $intdatein; $intday <= $intdateout; $intday ++) {
                    $dayi = 0;
                    $xmld = "";
                    $xmld .= '<date value="' . gmdate('Y-m-d', $intday * 3600 * 24) . '">';
                    
                    $xmld .= '<date from="' . gmdate('Y-m-d', $intday * 3600 * 24) . '" to="' . gmdate('Y-m-d', $intday * 3600 * 24) . '">';
                    
                    $xmld .= "\n";
                    
                    $xmld .= '<rate id="' . $rate . '"/>';
                    $xmld .= "\n";
                    
                    $xmld .= '<minimumstay>' . $restrict[$room][$rate][$intday]['minimumstay'] . '</minimumstay>';
                    $xmld .= "\n";
                    
                    $xmld .= '<maximumstay>' . $restrict[$room][$rate][$intday]['maximumstay'] . '</maximumstay>';
                    $xmld .= "\n";
                    
                    $xmld .= '<closed>' . $restrict[$room][$rate][$intday]['closed'] . '</closed>';
                    $xmld .= "\n";
                    
                    $xmld .= '<closedonarrival>' . $restrict[$room][$rate][$intday]['closedonarrival'] . '</closedonarrival>';
                    $xmld .= "\n";
                    
                    $xmld .= '<closedondeparture>' . $restrict[$room][$rate][$intday]['closedondeparture'] . '</closedondeparture>';
                    $xmld .= "\n";
                    
                    $xmld .= '</date>';
                    $xmld .= "\n";
                    $xml .= $xmld;
                }
                $xml .= '</room>';
                $xml .= "\n";
            }
        }
        
        $xml .= '</request>';
        // echo $xml;
        // die();
        $data_result = array();
        
        $url = $this->config->item('dc_booking_xml_host') . "hotels/xml/availability";
        $data_result = $this->Curl_model->CurlPlugRAW($xml, $url, 1, array(
            "returntype" => "array"
        ));
        
        $request = $data_result["result"];
        
        $result = $request;
        if ((strpos($request, "<ok/>") === 0) || (strpos($request, "<ok></ok>") === 0)) {
            $result .= "Booking.com: Ограничения выгружены успешно";
        } else {
            $result .= "Booking.com: Выгрузка ограничений с ошибками";
            $this->dc_model->cron_dc_save_error($db_name, 1, $request . " datein = " . $datein . " dateout = " . $dateout . " uploadrooms restrict");
        }
        if ($returntype == 0) {
            return $result;
        } else {
            $data_result["result"] = $result;
            return $data_result;
        }
        // return $result;
    }

    function sync($days_cell, $array_date = array(), $datein = "", $dateout = "", $returntype = 0)
    {
        $query = $this->db->query("SELECT int_value FROM dc_booking_xml_cfg WHERE name LIKE 'hotel_id'");
        
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $hotel_id = $row->int_value;
        } else {
            $hotel_id = "none";
        }
        
        $response = "";
        
        // $sql = "select dc_booking_ra_param.* from dc_booking_ra_param";
        // $ra = array ();
        // $query = $this->db->query ( $sql );
        // if ($query->num_rows () > 0) {
        // foreach ( $query->result () as $row ) {
        // $ra [$row->dc_room_id] ['rates'] [$row->dc_rate_id] ['minstay'] =
        // $row->minstay;
        // $ra [$row->dc_room_id] ['rates'] [$row->dc_rate_id] ['maxstay'] =
        // $row->maxstay;
        // $ra [$row->dc_room_id] ['rates'] [$row->dc_rate_id] ['closed'] =
        // $row->closed;
        // }
        // }
        
        // $days_cell = 120;
        if ($datein == "") {
            $datein = gmdate("Y-m-d");
        }
        
        if ($dateout == "") {
            $dateout = gmdate("Y-m-d", gmmktime(0, 0, 0, gmdate("m"), gmdate("d") + $days_cell, gmdate("Y")));
        }
        if (isset($array_date["datein"])) {
            $datein = $array_date["datein"];
        }
        if (isset($array_date["dateout"])) {
            $dateout = $array_date["dateout"];
        }
        // $datein = "2013-12-30";
        // $dateout = "2014-01-02";
        
        $dcrates = array();
        $sql = "select * from dc_booking_rates_link WHERE hms_rate_id <> 0";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $arg) {
                $dcrates[$arg->dc_rate_id] = array(
                    'dc_rate_id' => $arg->dc_rate_id,
                    'hms_rate_id' => $arg->hms_rate_id
                );
                
                // $freeRooms = $this->frontdesk->GetFreeRooms_dc_booking (
                // $datein, $dateout, $arg->hms_rate_id, $arg->restrict_id );
                $freeRooms = $this->frontdesk->GetFreeRooms_dc_booking($datein, $dateout, $arg->hms_rate_id);
                // echo "<pre>";
                // echo $arg->hms_rate_id . "\n";
                // echo $arg->dc_rate_id . "\n";
                // print_r($freeRooms);
                // die();
                
                $roomslist = array();
                
                $sql = "SELECT dc_booking_rooms_link.*  FROM dc_booking_rooms_link ";
                $query = $this->db->query($sql);
                if ($query->num_rows() > 0) {
                    foreach ($query->result() as $row) {
                        if ($row->category_id != 0) {
                            if (isset($freeRooms[$row->category_id])) {
                                
                                array_push($roomslist, array(
                                    'dc_room_id' => $row->dc_room_id,
                                    // 'minstay' => $ra [$row->dc_room_id]
                                    // ['rates']
                                    // [$arg->dc_rate_id] ['minstay'],
                                    // 'maxstay' => $ra [$row->dc_room_id]
                                    // ['rates']
                                    // [$arg->dc_rate_id] ['maxstay'],
                                    // 'closed' => $ra [$row->dc_room_id]
                                    // ['rates']
                                    // [$arg->dc_rate_id] ['closed'],
                                    'dates' => $freeRooms[$row->category_id]
                                ));
                            }
                        }
                    }
                }
                // echo "<pre>";
                // print_r($roomslist);
                $xml_data = array(
                    'dcuser' => $this->config->item('dc_booking_xml_user'),
                    'dcpwd' => $this->config->item('dc_booking_xml_pwd'),
                    'hotel_id' => $hotel_id,
                    'dc_rateid' => $arg->dc_rate_id,
                    'roomslist' => $roomslist
                );
                $xml = $this->parser->parse('templates/dc_booking_xml_rates_tpl.html', $xml_data, true);
                // echo $xml;
                // die();
                $url = $this->config->item('dc_booking_xml_host') . "hotels/xml/availability";
                $data_result = $this->Curl_model->CurlPlugRAW($xml, $url, 1, array(
                    "returntype" => "array"
                ));
                $result = $data_result["result"];
                if ((strpos($result, "<ok/>") === 0) || (strpos($result, "<ok></ok>") === 0)) {
                    $response .= "Booking.com: (с " . $datein . " до " . $dateout . ") Тариф " . $arg->dc_rate_id . " - удачная выгрузка<br>";
                    $response .= $result . "<br>";
                } else {
                    $response .= "Booking.com: (с " . $datein . " до " . $dateout . ") Тариф " . $arg->dc_rate_id . " - выгрузка с ошибками<br>";
                    $response .= $result . "<br>";
                }
                $data_result["response"] = $response;
            }
        }
        
        if ($returntype == 0) {
            return $response;
        } else {
            return $data_result;
        }
        // return $response;
    }

    function xml_availability($datein, $dateout, $returntype = 0)
    {
        $query = $this->db->query("SELECT int_value FROM dc_booking_xml_cfg WHERE name LIKE 'hotel_id'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $hotel_id = $row->int_value;
        } else {
            $hotel_id = "none";
        }
        
        $query = $this->db->query("SELECT id FROM rate WHERE isdefault = 1");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $rate_id = $row->id;
        } else {
            $rate_id = 1;
        }
        
        $freeRooms = $this->frontdesk->GetFreeRooms_dc_booking($datein, $dateout, $rate_id, 1);
        $roomslist = array();
        $sql = "SELECT dc_booking_rooms_link.*  FROM dc_booking_rooms_link ";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                if ($row->category_id > 0) {
                    array_push($roomslist, array(
                        'dc_room_id' => $row->dc_room_id,
                        'dates' => $freeRooms[$row->category_id]
                    ));
                }
            }
        }
        // echo "<pre>";
        // print_r($roomslist);
        // die();
        $xml_data = array(
            'dcuser' => $this->config->item('dc_booking_xml_user'),
            'dcpwd' => $this->config->item('dc_booking_xml_pwd'),
            'hotel_id' => $hotel_id,
            'roomslist' => $roomslist
        );
        $xml = $this->parser->parse('templates/dc_booking_xml_availability_tpl.html', $xml_data, true);
        // echo $xml;
        $url = $this->config->item('dc_booking_xml_host') . "hotels/xml/availability";
        $data_result = $this->Curl_model->CurlPlugRAW($xml, $url, 1, array(
            "returntype" => "array"
        ));
        $result = $data_result["result"];
        
        if ($returntype == 0) {
            return $result;
        } else {
            return $data_result;
        }
        // return $result;
    }

    
    
    function bokking_xml_parse_list($request, $hotel_id = 0)
    {
        $xml_array = array();
        $result_array = array();
        $reservations = new SimpleXMLElement($request);
        // echo "<pre>";
        // print_r($reservations);
        // die();
        $i = 0;
        
        $services_types_dc = array();
        $query = $this->db->query("SELECT id, dc_booking_addon_typeid FROM services_types WHERE dc_booking_addon_typeid <> 0");
        
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $services_types_dc[$row->dc_booking_addon_typeid] = $row->id;
            }
        }
        
        $rates = array();
        
        $query = $this->db->query("SELECT hms_rate_id, dc_rate_id FROM dc_booking_rates_link");
        
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $rates[$row->dc_rate_id] = $row->hms_rate_id;
            }
        }
        
        $categories = array();
        
        $query = $this->db->query("SELECT dc_room_id, category_id FROM dc_booking_rooms_link");
        
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $categories[$row->dc_room_id] = $row->category_id;
            }
        }
        
        $categories_names = array();
        
        $query = $this->db->query("SELECT id, name FROM categories");
        
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $categories_names[$row->id] = $row->name;
            }
        }
        
        $query = $this->db->query("SELECT id FROM rate WHERE isdefault = 1");
        
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $price_type = $row->id;
        }
        
        $query = $this->db->query("SELECT int_value FROM dc_booking_xml_cfg WHERE name LIKE 'dealer_id'");
        
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $dealer = $row->int_value;
        }
        
        $query = $this->db->query("SELECT int_value FROM dc_booking_xml_cfg WHERE name LIKE 'overbooking_category_id'");
        
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $overbooking_category_id = $row->int_value;
        }
        
        $dc_counter = 0;
        foreach ($reservations->reservation as $reservation) {
            // if ($reservation->status <> "new"){
            // continue;
            // }
            // print_r($reservation);
            
            // comission ???
            // $xml_array ["reservations"] [$i] ["reservation"] ["commission"] =
            // ( int ) $reservation->commissionamount;
            
            // $xml_array ["reservations"] [$i] ["reservation"]
            // ["commissionamount"] = 0;
            $xml_array["reservations"][(int) $reservation->id]["dc_channel_name"] = "Booking.com";
            
            $xml_array["reservations"][(int) $reservation->id]["dc_rate_id"] = (int) $reservation->room->price["rate_id"];
            
            $xml_array["reservations"][(int) $reservation->id]["dc_rate_id"] = (int) $reservation->room->price["rate_id"];
            $xml_array["reservations"][(int) $reservation->id]["currencycode"] = $reservation->currencycode;
            $xml_array["reservations"][(int) $reservation->id]["guest"]["address"] = (string) $reservation->customer->address;
            $xml_array["reservations"][(int) $reservation->id]["card"]["cc_cvc"] = (string) $reservation->customer->cc_cvc;
            if ((string) $reservation->customer->cc_expiration_date === "") {
                $ExpMonth = 0;
                $ExpYear = 0;
            } else {
                list ($ExpMonth, $ExpYear) = explode("/", $reservation->customer->cc_expiration_date);
            }
            // $xml_array ["reservations"] [( int ) $reservation->id] ["card"]
            // ["cc_expiration_date"] =
            // $reservation->customer->cc_expiration_date;
            $xml_array["reservations"][(int) $reservation->id]["card"]["ExpMonth"] = $ExpMonth;
            $xml_array["reservations"][(int) $reservation->id]["card"]["ExpYear"] = $ExpYear;
            $xml_array["reservations"][(int) $reservation->id]["card"]["CardHolder"] = $reservation->customer->cc_name;
            $xml_array["reservations"][(int) $reservation->id]["card"]["CardNumber"] = $reservation->customer->cc_number;
            $xml_array["reservations"][(int) $reservation->id]["card"]["cc_type"] = $reservation->customer->cc_type;
            $xml_array["reservations"][(int) $reservation->id]["guest"]["city"] = (string) $reservation->customer->city;
            // $xml_array ["reservations"] [$i] ["guest"]["company"] =
            // $reservation->customer->company;
            $xml_array["reservations"][(int) $reservation->id]["guest"]["country"] = (string) $reservation->customer->countrycode;
            // $xml_array ["reservations"] [$i] ["guest"]["dc_issue_number"] =
            // $reservation->customer->dc_issue_number;
            // $xml_array ["reservations"] [$i] ["guest"]["dc_start_date"] =
            // $reservation->customer->dc_start_date;
            $xml_array["reservations"][(int) $reservation->id]["guest"]["email"] = (string) $reservation->customer->email;
            $xml_array["reservations"][(int) $reservation->id]["guest"]["firstname"] = (string) $reservation->customer->first_name;
            $xml_array["reservations"][(int) $reservation->id]["guest"]["lastname"] = (string) $reservation->customer->last_name;
            // $xml_array ["reservations"] [$i] ["guest"]["remarks"] =
            // $reservation->customer->remarks;
            $xml_array["reservations"][(int) $reservation->id]["guest"]["phone"] = (string) $reservation->customer->telephone;
            $xml_array["reservations"][(int) $reservation->id]["guest"]["passportid"] = (int) $reservation->customer->zip;
            
            $xml_array["reservations"][(int) $reservation->id]["guest_firstname"] = (string) $reservation->customer->first_name;
            $xml_array["reservations"][(int) $reservation->id]["guest_lastname"] = (string) $reservation->customer->last_name;
            $xml_array["reservations"][(int) $reservation->id]["guest_phone"] = (string) $reservation->customer->telephone;
            $xml_array["reservations"][(int) $reservation->id]["guest_email"] = (string) $reservation->customer->email;
            
            // $xml_array ["reservations"] [$i] ["reservation"] ["date"] = (
            // string ) $reservation->date;
            $xml_array["reservations"][(int) $reservation->id]["hotel_id"] = $reservation->hotel_id;
            $xml_array["reservations"][(int) $reservation->id]["hotel_name"] = $reservation->hotel_name;
            // $xml_array ["reservations"] [$i] ["reservation"]
            // ["dc_reservationid"] = ( int ) $reservation->id;
            $xml_array["reservations"][(int) $reservation->id]["status"] = (string) $reservation->status;
            // $xml_array ["reservations"] [$i] ["reservation"] ["time"] = (
            // string ) $reservation->time;
            
            if (isset($reservation->total_cancellation_fee)) {
                $xml_array["reservations"][(int) $reservation->id]["total_cancellation_fee"] = (int) $reservation->total_cancellation_fee;
            } else {
                $xml_array["reservations"][(int) $reservation->id]["total_cancellation_fee"] = 0;
            }
            $xml_array["reservations"][(int) $reservation->id]["totalprice"] = (int) $reservation->totalprice;
            // $xml_array ["reservations"] [$i] ["reservation"] ['isNew'] = 1;
            
            $j = 0;
            $xml_array["reservations"][(int) $reservation->id]["dc_reservationid"] = (int) $reservation->id;
            $result_array[$dc_counter]["dc_reservationid"] = (int) $reservation->id;
            $result_array[$dc_counter]["hid"] = $hotel_id;
            if ($xml_array["reservations"][(int) $reservation->id]["status"] == "modified") {
                $query = $this->db->query("SELECT id,dc_roomreservation_id, room_id FROM deskofreservation WHERE dc_reservationid = " . $xml_array["reservations"][(int) $reservation->id]["dc_reservationid"]);
                
                if ($query->num_rows() > 0) {
                    foreach ($query->result() as $row) {
                        $xml_array["reservations"][(int) $reservation->id]["todo"][$row->dc_roomreservation_id]["status"] = "cancelled";
                        $xml_array["reservations"][(int) $reservation->id]["todo"][$row->dc_roomreservation_id]["dc_roomreservation_id"] = $row->dc_roomreservation_id;
                        $xml_array["reservations"][(int) $reservation->id]["todo"][$row->dc_roomreservation_id]["hms_reservation_id"] = $row->id;
                        $xml_array["reservations"][(int) $reservation->id]["todo"][$row->dc_roomreservation_id]["dc_reservationid"] = (int) $reservation->id;
                        $xml_array["reservations"][(int) $reservation->id]["todo"][$row->dc_roomreservation_id]["room_id"] = $row->room_id;
                    }
                }
            }
            
            if (isset($reservation->room)) {
                $room_current = 1;
                foreach ($reservation->room as $room) {
                    $addons_sum = 0;
                    if (isset($room->addons)) {
                        $addon_inc = 0;
                        // print_r($room->addons);
                        // $sss = $room->addons;
                        // print_r($sss);
                        foreach ($room->addons->addon as $addon) {
                            // print_r($addon);
                            // echo $addon_inc."<br>";
                            // echo "+++++0000+++".$room->addons->addon->name;
                            $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["addons"][$addon_inc]["dc_roomreservation_id"] = (int) $room->roomreservation_id;
                            $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["addons"][$addon_inc]["name"] = (string) $addon->name;
                            $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["addons"][$addon_inc]["nights"] = (int) $addon->nights;
                            $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["addons"][$addon_inc]["persons"] = (int) $addon->persons;
                            $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["addons"][$addon_inc]["price_mode"] = (int) $addon->price_mode;
                            $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["addons"][$addon_inc]["price_per_unit"] = (int) $addon->price_per_unit;
                            $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["addons"][$addon_inc]["totalprice"] = (int) $addon->totalprice;
                            $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["addons"][$addon_inc]["type"] = (int) $addon->type;
                            $addons_sum += (int) $addon->totalprice;
                            $addon_inc ++;
                        }
                    }
                    
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["addons_sum"] = $addons_sum;
                    
                    // print_r($xml_array ["reservations"] [( int )
                    // $reservation->id] ["room"] [( int )
                    // $room->roomreservation_id] ["addons"]);
                    $temp_i = 0;
                    foreach ($room->price as $arr_price) {
                        list ($year, $month, $day) = explode("-", $arr_price["date"]);
                        $date = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
                        $xml_array["dc_rate_intdate_data"][(int) $room->roomreservation_id][$temp_i]["dc_reservation_id"] = (int) $room->roomreservation_id;
                        $xml_array["dc_rate_intdate_data"][(int) $room->roomreservation_id][$temp_i]["dc_rate_id"] = (int) $arr_price["rate_id"];
                        $xml_array["dc_rate_intdate_data"][(int) $room->roomreservation_id][$temp_i]["intdate"] = $date;
                        $xml_array["dc_rate_intdate_data"][(int) $room->roomreservation_id][$temp_i]["date_rate"] = $arr_price["date"];
                        $xml_array["dc_rate_intdate_data"][(int) $room->roomreservation_id][$temp_i]["price"] = (int) $arr_price;
                        
                        $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["dc_rate_intdate_data"][$temp_i]["dc_reservation_id"] = (int) $room->roomreservation_id;
                        $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["dc_rate_intdate_data"][$temp_i]["dc_rate_id"] = (int) $arr_price["rate_id"];
                        $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["dc_rate_intdate_data"][$temp_i]["intdate"] = $date;
                        $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["dc_rate_intdate_data"][$temp_i]["date_rate"] = $arr_price["date"];
                        $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["dc_rate_intdate_data"][$temp_i]["price"] = (int) $arr_price;
                        $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["dc_rate_intdate_data"][$temp_i]["dc_currencycode"] = (string) $reservation->currencycode;
                        
                        $temp_i ++;
                    }
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_id"] = 1;
                    
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["commissionamount"] = (int) $room->commissionamount;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["date"] = (string) $reservation->date;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_reservationid"] = (int) $reservation->id;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["time"] = (string) $reservation->time;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["isNew"] = 1;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["datein"] = (string) $room->arrival_date;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dateout"] = (string) $room->departure_date;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_roomreservation_id"] = (int) $room->roomreservation_id;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["category_id"] = (int) $room->id;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["add_places"] = 0;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["baby_places"] = 0;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["amount"] = (int) $room->totalprice;
                    
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["price_type"] = $rates[(int) $room->price["rate_id"]];
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["description"] = (string) $reservation->customer->remarks;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["user"] = - 1;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["type_id"] = $categories[(int) $room->id];
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dealer"] = $dealer;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_guestname"] = (string) $room->guest_name;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_numberofguest"] = (int) $room->numberofguests;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_countrycode"] = (string) $reservation->customer->countrycode;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_currencycode"] = (string) $reservation->currencycode;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_city"] = (string) $reservation->customer->city;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_customerremarks"] = (string) $reservation->customer->remarks;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_roomremarks"] = (string) $room->remarks;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_totalprice"] = (int) $room->totalprice;
                    
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation_datein"] = (string) $room->arrival_date;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation_dateout"] = (string) $room->departure_date;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation_date"] = (string) $reservation->date;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation_dc_roomreservation_id"] = (int) $room->roomreservation_id;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation_dc_reservationid"] = (int) $reservation->id;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation_type_id"] = $categories[(int) $room->id];
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation_category_id"] = (int) $room->id;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation_current"] = $room_current;
                    $room_current ++;
                    
                    if (isset($categories_names[$categories[(int) $room->id]])) {
                        $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation_type_name"] = $categories_names[$categories[(int) $room->id]];
                    } else {
                        $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation_type_name"] = "";
                    }
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation_dc_customerremarks"] = (string) $reservation->customer->remarks;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation_dc_totalprice"] = (int) $room->totalprice;
                    
                    if ((string) $room->smoking === "") {
                        $smoking = - 1;
                    } else {
                        $smoking = (int) $room->smoking;
                    }
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["smoking"] = $smoking;
                    
                    // ============================================================================================
                    
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["extra_info"] = $reservation->room->extra_info;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["facilities"] = $reservation->room->facilities;
                    
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["meal_plan"] = $reservation->room->meal_plan;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["name"] = $reservation->room->name;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["remarks"] = $reservation->room->remarks;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["roomreservation_id"] = (int) $room->roomreservation_id;
                    
                    $j ++;
                }
            }
            $dc_counter ++;
        }
        
        echo "<pre>";
        print_r($result_array);
        die();
    }
    
    function bokking_xml_parse($request, $hotel_id = 0, $reservationssummary = 0, $send_notification = 1, $special = array())
    {
        $skip_empty = false;
        $insert_over_room_bool = 0;
        $extracomponent_amount = 0;
        $is_payment_VC = 0;
        $xml_array = array();
        $compactmode = false;
        if (isset($special['compactmode'])) {
            if ($special['compactmode'] === true) {
                $compactmode = true;
            }
        }
        $reservations = new SimpleXMLElement($request);
        //echo "<pre>111";
        //print_r($reservations);
        //die("debug");
        if (! $compactmode) {
            echo "<pre>";
            print_r($reservations);
            // die();
        }
        $i = 0;
        
        if (isset($reservations->fault)) {
            $str = "hmsID:" . $hotel_id . ", " . $reservations->fault['code'] . " : " . $reservations->fault['string'];
            echo $str . "\n";
            $record = array();
            $record['hms_id'] = $hotel_id;
            $record['memo'] = $str;
            $this->db->insert('visitka.user_lost', $record);
        }
        
        $services_types_dc = array();
        $query = $this->db->query("SELECT id, dc_booking_addon_typeid FROM services_types WHERE dc_booking_addon_typeid <> 0");
        
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $services_types_dc[$row->dc_booking_addon_typeid] = $row->id;
            }
        }
        
        $rates = array();
        
        $query = $this->db->query("SELECT hms_rate_id, dc_rate_id FROM dc_booking_rates_link");
        
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $rates[$row->dc_rate_id] = $row->hms_rate_id;
            }
        }
        
        $rate2category = array();
        
        $query = $this->db->query("SELECT hms_rate_id, dc_rate_id, dc_category_id, hms_occupancy_id FROM dc_booking_rate2category_link");
        
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $rate2category[$row->dc_rate_id][$row->dc_category_id][$row->hms_occupancy_id] = $row->hms_rate_id;
            }
        }
        
        $dc_rates_names = array();
        
        $query = $this->db->query("SELECT * FROM dc_booking_rates");
        
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $dc_rates_names[$row->dc_rate_id] = $row->name;
            }
        }
        
        $categories = array();
        
        $query = $this->db->query("SELECT dc_room_id, category_id FROM dc_booking_rooms_link");
        
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $categories[$row->dc_room_id] = $row->category_id;
            }
        }
        
        $categories_names = array();
        
        $query = $this->db->query("SELECT id, name FROM categories");
        
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $categories_names[$row->id] = $row->name;
            }
        }
        
        $query = $this->db->query("SELECT id FROM rate WHERE isdefault = 1");
        
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $price_type = $row->id;
        }
        
        $query = $this->db->query("SELECT int_value FROM dc_booking_xml_cfg WHERE name LIKE 'dealer_id'");
        
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $dealer = $row->int_value;
        }
        
        $extracomponent_type = $this->service_model->get_first_service();
        
        if ($this->get_booking_default_service() == true){
        	$query = $this->db->query("SELECT int_value FROM dc_booking_xml_cfg WHERE name LIKE 'extracomponent_type'");
        	if ($query->num_rows() > 0) {
        		$row = $query->row();
        		$extracomponent_type = $row->int_value;
        	}
        }
        
        
        $query = $this->db->query("SELECT int_value FROM dc_booking_xml_cfg WHERE name LIKE 'overbooking_category_id'");
        
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $overbooking_category_id = $row->int_value;
        }
        
        foreach ($reservations->reservation as $reservation) {
            $xml_array["reservations"][(int) $reservation->id]["dc_channel_name"] = "Booking.com";
            
            $xml_array["reservations"][(int) $reservation->id]["dc_rate_id"] = (int) $reservation->room->price["rate_id"];
            
            $xml_array["reservations"][(int) $reservation->id]["dc_rate_id"] = (int) $reservation->room->price["rate_id"];
            $xml_array["reservations"][(int) $reservation->id]["currencycode"] = $reservation->currencycode;
            $xml_array["reservations"][(int) $reservation->id]["guest"]["address"] = (string) $reservation->customer->address;
            $xml_array["reservations"][(int) $reservation->id]["card"]["cc_cvc"] = (string) $reservation->customer->cc_cvc;
            if ((string) $reservation->customer->cc_expiration_date === "") {
                $ExpMonth = 0;
                $ExpYear = 0;
            } else {
                list ($ExpMonth, $ExpYear) = explode("/", $reservation->customer->cc_expiration_date);
            }
            $xml_array["reservations"][(int) $reservation->id]["card"]["ExpMonth"] = $ExpMonth;
            $xml_array["reservations"][(int) $reservation->id]["card"]["ExpYear"] = $ExpYear;
            $xml_array["reservations"][(int) $reservation->id]["card"]["CardHolder"] = $reservation->customer->cc_name;
            $xml_array["reservations"][(int) $reservation->id]["card"]["CardNumber"] = $reservation->customer->cc_number;
            $xml_array["reservations"][(int) $reservation->id]["card"]["cc_type"] = $reservation->customer->cc_type;
            
            $xml_array["reservations"][(int) $reservation->id]["card"]["cc_activation_date"] = $reservation->customer->cc_activation_date;
            $xml_array["reservations"][(int) $reservation->id]["card"]["cc_current_balance"] = $reservation->customer->cc_current_balance;
            $xml_array["reservations"][(int) $reservation->id]["card"]["vcc_expiration_date"] = $reservation->customer->vcc_expiration_date;
            
            if (isset ( $reservation->reservation_extra_info->payer->payments )) {
            	$CardHolder = $reservations [$i] ["RoomStay"] ["PaymentCard"] ["CardHolder"]["@attributes"];
            	if ($reservation->reservation_extra_info->payer->payments->payment["payment_type"] == "payment_on_Booking.com" && 
            	$reservation->reservation_extra_info->payer->payments->payment["payout_type"] == "Virtual credit card") {
            		$is_payment_VC = 1;
            	}
            	
            	$xml_array["reservations"][(int) $reservation->id]["payments_currencycode"] = $reservation->reservation_extra_info->payer->payments->payment["currency"];
            	$xml_array["reservations"][(int) $reservation->id]["payments_amount"] = $reservation->reservation_extra_info->payer->payments->payment["amount"];
            }
            
            $xml_array["reservations"][(int) $reservation->id]["guest"]["city"] = (string) $reservation->customer->city;
            $xml_array["reservations"][(int) $reservation->id]["date_time"] = (string) $reservation->date . " " . (string) $reservation->time;
            $xml_array["reservations"][(int) $reservation->id]["guest"]["country"] = (string) $reservation->customer->countrycode;
            $xml_array["reservations"][(int) $reservation->id]["guest"]["email"] = (string) $reservation->customer->email;
            $xml_array["reservations"][(int) $reservation->id]["guest"]["firstname"] = (string) $reservation->customer->first_name;
            $xml_array["reservations"][(int) $reservation->id]["guest"]["lastname"] = (string) $reservation->customer->last_name;
            $xml_array["reservations"][(int) $reservation->id]["guest"]["phone"] = (string) $reservation->customer->telephone;
            $xml_array["reservations"][(int) $reservation->id]["guest"]["passportid"] = (int) $reservation->customer->zip;
            
            $xml_array["reservations"][(int) $reservation->id]["guest_firstname"] = (string) $reservation->customer->first_name;
            $xml_array["reservations"][(int) $reservation->id]["guest_lastname"] = (string) $reservation->customer->last_name;
            $xml_array["reservations"][(int) $reservation->id]["guest_phone"] = (string) $reservation->customer->telephone;
            $xml_array["reservations"][(int) $reservation->id]["guest_email"] = (string) $reservation->customer->email;
            
            $extra_info = "";
            if(isset($reservation->reservation_extra_info->flags->flag)){
            	foreach ($reservation->reservation_extra_info->flags->flag as $flag_data) {
            		if(trim($flag_data["name"]) <> ""){
            			$extra_info .= "-".$flag_data["name"]."<br>";
            		}
            	}
            }
            
            if(isset($reservation->reservation_extra_info->guests->services->service)){
            	foreach ($reservation->reservation_extra_info->guests->services->service as $service_data) {
            		if(trim($service_data->text) <> ""){
            			$extra_info .= "-".$service_data->text."<br>";
            		}
            	}
            }
            
            // $xml_array ["reservations"] [$i] ["reservation"] ["date"] = (
            // string ) $reservation->date;
            $xml_array["reservations"][(int) $reservation->id]["hotel_id"] = $reservation->hotel_id;
            $xml_array["reservations"][(int) $reservation->id]["hotel_name"] = $reservation->hotel_name;
            
            $xml_array["reservations"][(int) $reservation->id]["status"] = (string) $reservation->status;
            if($this->session->userdata ( 'global_debug' ) == 1){
                $xml_array["reservations"][(int) $reservation->id]["status"] = "modified";
            }
            
            
            $xml_array["reservations"][(int) $reservation->id]["dc_updatetime"] = (string) $reservation->modified_at;
            
            if ($reservationssummary == 1) {
                $xml_array["reservations"][(int) $reservation->id]["status"] = "new";
            }
            // $xml_array ["reservations"] [$i] ["reservation"] ["time"] = (
            // string ) $reservation->time;
            
            if (isset($reservation->total_cancellation_fee)) {
                $xml_array["reservations"][(int) $reservation->id]["total_cancellation_fee"] = (int) $reservation->total_cancellation_fee;
            } else {
                $xml_array["reservations"][(int) $reservation->id]["total_cancellation_fee"] = 0;
            }
            $xml_array["reservations"][(int) $reservation->id]["totalprice"] = (float) $reservation->totalprice;
            // $xml_array ["reservations"] [$i] ["reservation"] ['isNew'] = 1;
            
            $j = 0;
//              if ($xml_array["reservations"][(int) $reservation->id]["status"] == "new") {
//                  $xml_array["reservations"][(int) $reservation->id]["status"] = "modified";
//              }
            $xml_array["reservations"][(int) $reservation->id]["dc_reservationid"] = (int) $reservation->id;
            if ($xml_array["reservations"][(int) $reservation->id]["status"] == "modified") {
                $query = $this->db->query("SELECT id,dc_roomreservation_id, room_id FROM deskofreservation WHERE dc_reservationid = " . $xml_array["reservations"][(int) $reservation->id]["dc_reservationid"]);
                
                if ($query->num_rows() > 0) {
                    foreach ($query->result() as $row) {
                        $xml_array["reservations"][(int) $reservation->id]["todo"][$row->dc_roomreservation_id]["status"] = "cancelled";
                        $xml_array["reservations"][(int) $reservation->id]["todo"][$row->dc_roomreservation_id]["dc_roomreservation_id"] = $row->dc_roomreservation_id;
                        $xml_array["reservations"][(int) $reservation->id]["todo"][$row->dc_roomreservation_id]["hms_reservation_id"] = $row->id;
                        $xml_array["reservations"][(int) $reservation->id]["todo"][$row->dc_roomreservation_id]["dc_reservationid"] = (int) $reservation->id;
                        $xml_array["reservations"][(int) $reservation->id]["todo"][$row->dc_roomreservation_id]["room_id"] = $row->room_id;
                    }
                }
            }
            
            if (isset($reservation->room)) {
                $room_current = 1;
                foreach ($reservation->room as $room) {
                    
                    
                    
                    $addons_sum = 0;
                    $extracomponent_sum = 0;
                    $addon_inc = 0;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["addons"] = array();
                    if (isset($room->addons)) {
                        //$addon_inc = 0;
                        // print_r($room->addons);
                        // $sss = $room->addons;
                        // print_r($sss);
                        foreach ($room->addons->addon as $addon) {
                            // print_r($addon);
                            // echo $addon_inc."<br>";
                            // echo "+++++0000+++".$room->addons->addon->name;
                            $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["addons"][$addon_inc]["dc_roomreservation_id"] = (int) $room->roomreservation_id;
                            $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["addons"][$addon_inc]["name"] = (string) $addon->name;
                            $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["addons"][$addon_inc]["nights"] = (int) $addon->totalprice / (int) $addon->price_per_unit;
                            $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["addons"][$addon_inc]["persons"] = (int) $addon->persons;
                            $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["addons"][$addon_inc]["price_mode"] = (int) $addon->price_mode;
                            $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["addons"][$addon_inc]["price_per_unit"] = (float) $addon->price_per_unit;
                            $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["addons"][$addon_inc]["totalprice"] = (float) $addon->totalprice;
                            $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["addons"][$addon_inc]["type"] = (int) $addon->type;
                            $addons_sum += (float) $addon->totalprice;
                            $addon_inc ++;
                        }
                    }
                    
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["extracomponent"] = array();
                    $extracomponent_inc = 0;
                    if (isset($room->price_details->hotel)){
                    	foreach ( $room->price_details->hotel->extracomponent as $extracomponent ) {
                    		
                    		$json_temp = json_encode($extracomponent, true);
                    		$extracomponent = json_decode($json_temp, true);
                    		
							if ($extracomponent["@attributes"]["included"] == "no") {
								$xml_array ["reservations"] [( int ) $reservation->id] ["room"] [( int ) $room->roomreservation_id] ["extracomponent"] [$extracomponent_inc] ["extracomponent"] = 1;
								$xml_array ["reservations"] [( int ) $reservation->id] ["room"] [( int ) $room->roomreservation_id] ["extracomponent"] [$extracomponent_inc] ["dc_roomreservation_id"] = ( int ) $room->roomreservation_id;
								$xml_array ["reservations"] [( int ) $reservation->id] ["room"] [( int ) $room->roomreservation_id] ["extracomponent"] [$extracomponent_inc] ["name"] = (string) $extracomponent ["@attributes"] ["text"]. "(". (string) $extracomponent ["@attributes"] ["percentage"].")";
								$xml_array ["reservations"] [( int ) $reservation->id] ["room"] [( int ) $room->roomreservation_id] ["extracomponent"] [$extracomponent_inc] ["nights"] = 1;
								$xml_array ["reservations"] [( int ) $reservation->id] ["room"] [( int ) $room->roomreservation_id] ["extracomponent"] [$extracomponent_inc] ["persons"] = 0;
								$xml_array ["reservations"] [( int ) $reservation->id] ["room"] [( int ) $room->roomreservation_id] ["extracomponent"] [$extracomponent_inc] ["price_mode"] = 0;
								$xml_array ["reservations"] [( int ) $reservation->id] ["room"] [( int ) $room->roomreservation_id] ["extracomponent"] [$extracomponent_inc] ["price_per_unit"] = ( float ) $extracomponent ["@attributes"] ["amount"];
								$xml_array ["reservations"] [( int ) $reservation->id] ["room"] [( int ) $room->roomreservation_id] ["extracomponent"] [$extracomponent_inc] ["totalprice"] = ( float ) $extracomponent ["@attributes"] ["amount"];
								$xml_array ["reservations"] [( int ) $reservation->id] ["room"] [( int ) $room->roomreservation_id] ["extracomponent"] [$extracomponent_inc] ["type"] = $extracomponent_type;
								$addons_sum += ( int ) $extracomponent ["@attributes"] ["amount"];
								$extracomponent_inc ++;
								$extracomponent_sum += ( int ) $extracomponent ["@attributes"] ["amount"];
								// $addons_sum += (int) $room->price_details->hotel->extracomponent["amount"];
							    ( float ) $room->totalprice = ( float ) $room->totalprice + ( int ) $extracomponent["@attributes"] ["amount"];
								
								// $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["amount"] += $room->price_details->hotel->extracomponent["amount"];
								// $extracomponent_amount = (int) $room->price_details->hotel->extracomponent["amount"];
							}
						}
                    }
                    
                    /*if (isset($room->price_details->guest)){
                    	foreach ( $room->price_details->guest->extracomponent as $extracomponent ) {
                    
                    		$json_temp = json_encode($extracomponent, true);
                    		$extracomponent = json_decode($json_temp, true);
                    
                    		if ($extracomponent["@attributes"]["included"] == "no") {
                    			$xml_array ["reservations"] [( int ) $reservation->id] ["room"] [( int ) $room->roomreservation_id] ["extracomponent"] [$extracomponent_inc] ["extracomponent"] = 1;
                    			$xml_array ["reservations"] [( int ) $reservation->id] ["room"] [( int ) $room->roomreservation_id] ["extracomponent"] [$extracomponent_inc] ["dc_roomreservation_id"] = ( int ) $room->roomreservation_id;
                    			$xml_array ["reservations"] [( int ) $reservation->id] ["room"] [( int ) $room->roomreservation_id] ["extracomponent"] [$extracomponent_inc] ["name"] = (string) $extracomponent ["@attributes"] ["text"]. "(". (string) $extracomponent ["@attributes"] ["percentage"].")";
                    			$xml_array ["reservations"] [( int ) $reservation->id] ["room"] [( int ) $room->roomreservation_id] ["extracomponent"] [$extracomponent_inc] ["nights"] = 1;
                    			$xml_array ["reservations"] [( int ) $reservation->id] ["room"] [( int ) $room->roomreservation_id] ["extracomponent"] [$extracomponent_inc] ["persons"] = 0;
                    			$xml_array ["reservations"] [( int ) $reservation->id] ["room"] [( int ) $room->roomreservation_id] ["extracomponent"] [$extracomponent_inc] ["price_mode"] = 0;
                    			$xml_array ["reservations"] [( int ) $reservation->id] ["room"] [( int ) $room->roomreservation_id] ["extracomponent"] [$extracomponent_inc] ["price_per_unit"] = ( float ) $extracomponent ["@attributes"] ["amount"];
                    			$xml_array ["reservations"] [( int ) $reservation->id] ["room"] [( int ) $room->roomreservation_id] ["extracomponent"] [$extracomponent_inc] ["totalprice"] = ( float ) $extracomponent ["@attributes"] ["amount"];
                    			$xml_array ["reservations"] [( int ) $reservation->id] ["room"] [( int ) $room->roomreservation_id] ["extracomponent"] [$extracomponent_inc] ["type"] = $extracomponent_type;
                    			$addons_sum += ( int ) $extracomponent ["@attributes"] ["amount"];
                    			$extracomponent_inc ++;
                    
                    			// $addons_sum += (int) $room->price_details->hotel->extracomponent["amount"];
                    			( float ) $room->totalprice = ( float ) $room->totalprice + ( int ) $extracomponent["@attributes"] ["amount"];
                    
                    			// $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["amount"] += $room->price_details->hotel->extracomponent["amount"];
                    			// $extracomponent_amount = (int) $room->price_details->hotel->extracomponent["amount"];
                    		}
                    	}
                    }
                    */
                    
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["addons_sum"] = $addons_sum;
                    
                    // print_r($xml_array ["reservations"] [( int )
                    // $reservation->id] ["room"] [( int )
                    // $room->roomreservation_id] ["addons"]);
                    list ( $year, $month, $day ) = explode ( "-", (string) $room->arrival_date );
                    $int_datein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
                    
                    $temp_i = 0;
                    foreach ($room->price as $arr_price) {
                        list ($year, $month, $day) = explode("-", $arr_price["date"]);
                        $date = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
                        $xml_array["dc_rate_intdate_data"][(int) $room->roomreservation_id][$temp_i]["dc_reservation_id"] = (int) $room->roomreservation_id;
                        $xml_array["dc_rate_intdate_data"][(int) $room->roomreservation_id][$temp_i]["dc_rate_id"] = (int) $arr_price["rate_id"];
                        $xml_array["dc_rate_intdate_data"][(int) $room->roomreservation_id][$temp_i]["intdate"] = $date;
                        $xml_array["dc_rate_intdate_data"][(int) $room->roomreservation_id][$temp_i]["date_rate"] = $arr_price["date"];
                        $xml_array["dc_rate_intdate_data"][(int) $room->roomreservation_id][$temp_i]["price"] = (float) $arr_price;
                        
                        $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["dc_rate_intdate_data"][$temp_i]["dc_reservation_id"] = (int) $room->roomreservation_id;
                        $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["dc_rate_intdate_data"][$temp_i]["dc_rate_id"] = (int) $arr_price["rate_id"];
                        $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["dc_rate_intdate_data"][$temp_i]["dc_rate_name"] = $dc_rates_names[(int) $arr_price["rate_id"]];
                        $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["dc_rate_intdate_data"][$temp_i]["intdate"] = $date;
                        $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["dc_rate_intdate_data"][$temp_i]["date_rate"] = $arr_price["date"];
                        $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["dc_rate_intdate_data"][$temp_i]["price"] = (float) $arr_price;
                        $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["dc_rate_intdate_data"][$temp_i]["dc_currencycode"] = (string) $reservation->currencycode;
                        
                        $temp_i ++;
                        
                        $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["day_price"][$int_datein] = (float) $arr_price;
                        $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["day_price"][$int_datein] = (float) $arr_price;
                        $int_datein ++;
                    }
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_id"] = 1;
                    
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["commissionamount"] = (int) $room->commissionamount;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["date"] = (string) $reservation->date;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_reservationid"] = (int) $reservation->id;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["time"] = (string) $reservation->time;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["isNew"] = 1;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["datein"] = (string) $room->arrival_date;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dateout"] = (string) $room->departure_date;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_roomreservation_id"] = (int) $room->roomreservation_id;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["category_id"] = (int) $room->id;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["add_places"] = 0;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["baby_places"] = 0;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["amount"] = (float) $room->totalprice;
                   // echo (int) $room->price["rate_id"] . "<br>";
                    if (isset($rate2category[(int) $room->price["rate_id"]][(int) $room->id][(int) $room->numberofguests])) {
                        $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["price_type"] = $rate2category[(int) $room->price["rate_id"]][(int) $room->id][(int) $room->numberofguests];
                    } else {
                        if (isset($rate2category[(int) $room->price["rate_id"]][(int) $room->id][2])) {
                            $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["price_type"] = $rate2category[(int) $room->price["rate_id"]][(int) $room->id][2];
                        } else {
                            $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["price_type"] = $price_type;
                        }
                    }
                    // $xml_array ["reservations"] [( int ) $reservation->id] ["room"] [( int ) $room->roomreservation_id] ["reservation"] ["price_type"] = $rates [( int ) $room->price ["rate_id"]];
                    //$xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["description"] = (string) $reservation->customer->remarks;
                    //$xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["extra_info"] = $extra_info;
                    
                    if (isset($_SESSION["user"]["id"])) {
                        $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["user"] = $_SESSION["user"]["id"];
                    } else {
                        $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["user"] = - 1;
                    }
                    
                    if (isset($categories[(int) $room->id])) {
                        $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["type_id"] = $categories[(int) $room->id];
                    } else {
                        $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["type_id"] = 0;
                    }
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dealer"] = $dealer;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_guestname"] = (string) $room->guest_name;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_numberofguest"] = (int) $room->numberofguests;
                    
                    if((int) $room->numberofguests > 0){
                        $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["adults"] = (int) $room->numberofguests;
                    }
                    
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_countrycode"] = (string) $reservation->customer->countrycode;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_currencycode"] = (string) $reservation->currencycode;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_city"] = (string) $reservation->customer->city;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_customerremarks"] = (string) $reservation->customer->remarks;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_roomremarks"] = "";
                    if(trim((string) $reservation->customer->remarks) <> ""){
                    	 $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_roomremarks"] .= (string) $reservation->customer->remarks."<br>";
                    }
                    if(trim((string) $room->remarks) <> ""){
                    	$xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_roomremarks"] .= (string) $room->remarks."<br>";
                    }
                    if(trim($extra_info) <> ""){
                    	$xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_roomremarks"] .= $extra_info;
                    }
                    //$xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_roomremarks"] = (string) $reservation->customer->remarks."<br>".(string) $room->remarks."<br>".$extra_info;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_roomremarks"] = str_replace("<br>", "\n", $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_roomremarks"]);
                    
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_totalprice"] = (float) $room->totalprice;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_date"] = (string) $reservation->date;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_time"] = (string) $reservation->time;
                    
                    //$d1 = strtotime((string) $reservation->modified_at); 
                    
                    //$xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_updatetime"] = date("Y-m-d H:i:s", $d1);
                    //$xml_array["reservations"][(int) $reservation->id]["dc_updatetime"] = date("Y-m-d H:i:s", $d1);
                    
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["dc_updatetime"] = (string) $reservation->modified_at;
                    
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation_datein"] = (string) $room->arrival_date;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation_dateout"] = (string) $room->departure_date;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation_date"] = (string) $reservation->date;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation_dc_roomreservation_id"] = (int) $room->roomreservation_id;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation_dc_reservationid"] = (int) $reservation->id;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation_type_id"] = $categories[(int) $room->id];
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation_category_id"] = (int) $room->id;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation_current"] = $room_current;
                    $room_current ++;
                    
                    if (isset($categories_names[$categories[(int) $room->id]])) {
                        $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation_type_name"] = $categories_names[$categories[(int) $room->id]];
                    } else {
                        $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation_type_name"] = "";
                    }
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation_dc_customerremarks"] = htmlspecialchars(addslashes((string) $reservation->customer->remarks));
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation_dc_totalprice"] = (float) $room->totalprice;
                    
                    if ((string) $room->smoking === "") {
                        $smoking = - 1;
                    } else {
                        $smoking = (int) $room->smoking;
                    }
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["smoking"] = $smoking;
                    
                    
                    if($hotel_id > 0){
                    	$xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]['hms_id'] = $hotel_id;
                    }
                    
                    // ============================================================================================
                    
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["extra_info"] = $reservation->room->extra_info;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["facilities"] = $reservation->room->facilities;
                    
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["meal_plan"] = $reservation->room->meal_plan;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["name"] = $reservation->room->name;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["remarks"] = $reservation->room->remarks;
                    $xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["roomreservation_id"] = (int) $room->roomreservation_id;
                   
                    if (isset($room->price_details->hotel)){
                    	if($room->price_details->hotel->extracomponent["included"] == "no"){
                    		//$xml_array["reservations"][(int) $reservation->id]["room"][(int) $room->roomreservation_id]["reservation"]["amount"] += $room->price_details->hotel->extracomponent["amount"];
                    		//$extracomponent_amount = (int) $room->price_details->hotel->extracomponent["amount"];
                    	}
                    }
                    $j ++;
                }
            }
        }
        
        
         //die ();
        
        if (isset($xml_array["reservations"])) {
            $arr_reservation_keys = array_keys($xml_array["reservations"]);
            foreach ($arr_reservation_keys as $dc_reservationid) {
                $create_intgroup_bool = 0;
                // echo $dc_reservationid . "\n";
                if (isset($xml_array["reservations"][$dc_reservationid]["room"])) {
                    $room_keys = array_keys($xml_array["reservations"][$dc_reservationid]["room"]);
                    $qty = count($room_keys);
                    foreach ($room_keys as $dc_roomreservation_id) {
                        // echo $dc_roomreservation_id;
                        if (isset($xml_array["reservations"][$dc_reservationid]["todo"][$dc_roomreservation_id]["status"])) {
                            if ($j > 1) {
                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["groupid"] = $dc_reservationid;
                            }
                            /*
                             * ============ BOOKING SET INT GROUP ======================
                             *
                             */
                            if ($qty > 1) {
                                if ($create_intgroup_bool == 0) {
                                    $group_name = "BOOKING-" . $dc_reservationid;
                                    $intgroupid = $this->group_res_model->makenewid($group_name);
                                    $create_intgroup_bool = 1;
                                }
                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["intgroupid"] = $intgroupid;
                            }
                            
                            $xml_array["reservations"][$dc_reservationid]["todo"][$dc_roomreservation_id]["status"] = "modified";
                        } else {
                            $xml_array["reservations"][$dc_reservationid]["todo"][$dc_roomreservation_id]["status"] = "new";
                            $xml_array["reservations"][$dc_reservationid]["todo"][$dc_roomreservation_id]["dc_roomreservation_id"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["dc_roomreservation_id"];
                            $xml_array["reservations"][$dc_reservationid]["todo"][$dc_roomreservation_id]["hms_reservation_id"] = 0;
                            $xml_array["reservations"][$dc_reservationid]["todo"][$dc_roomreservation_id]["dc_reservationid"] = $dc_reservationid;
                            if ($j > 1) {
                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["groupid"] = $dc_reservationid;
                            }
                            /*
                             * ============ BOOKING SET INT GROUP ======================
                             *
                             */
                            if ($qty > 1) {
                                if ($create_intgroup_bool == 0) {
                                    $group_name = "BOOKING-" . $dc_reservationid;
                                    $intgroupid = $this->group_res_model->makenewid($group_name);
                                    $create_intgroup_bool = 1;
                                }
                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["intgroupid"] = $intgroupid;
                            }
                            
                        }
                    }
                }
            }
        }
        //echo "<pre>";
        //print_r ( $xml_array );
        //die();
        // echo "<pre>";
        if (! $compactmode) {
            print_r($xml_array);
        }
        // die("DEBUG 1515 dcm_booking.php");
        // echo "<pre>";
        // print_r($_SERVER ["HTTP_HOST"]);
        // $hotel_id = 0;
         //echo "<pre>";
        // print_r ( $xml_array );
        // die ();
        if (isset($_SERVER["HTTP_HOST"])) {
            if ($_SERVER["HTTP_HOST"]) {
                $host = $_SERVER["HTTP_HOST"];
                
                $sql = "SELECT * FROM visitka.config WHERE host LIKE '$host'";
                $query = $this->db->query($sql);
                if ($query->num_rows() != 0) {
                    $row = $query->row();
                    $hotel_id = $row->id;
                }
            }
        } else {
            if ($hotel_id != 0) {
                $sql = "SELECT host FROM visitka.config WHERE id = '$hotel_id'";
                // echo $sql;
                $query = $this->db->query($sql);
                if ($query->num_rows() != 0) {
                    $row = $query->row();
                    $host = $row->host;
                }
            } else {
                $host = "";
            }
        }
        // echo $host;
        // die();
        $reservationpush = array();
        
        $is_failed = false;
        
        $k = 0;
        if (isset($xml_array["reservations"])) {
            $arr_reservation_keys = array_keys($xml_array["reservations"]);
            
            // echo "<pre>";
            // print_r ( $xml_array ["reservations"] );
            // die();
            
            foreach ($arr_reservation_keys as $dc_reservationid) {
                $bool_guest = 0;
                
                if (isset($xml_array["reservations"][$dc_reservationid]["room"]) && $xml_array["reservations"][$dc_reservationid]["status"] != "cancelled") {
                    
                    $bool_modified = 0;
                    $room_keys = array_keys($xml_array["reservations"][$dc_reservationid]["room"]);
                    foreach ($room_keys as $dc_roomreservation_id) {
                        echo "/" . $k . "*<br>";
                        if ($bool_modified == 1) {
                            break;
                        }
                        
                        $sql = "SELECT id, dc_updatetime FROM deskofreservation WHERE dc_id = 1 AND dc_roomreservation_id = " . $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["dc_roomreservation_id"];
                        
                        $query = $this->db->query( $sql);
                        
                        if ($query->num_rows() > 0) {
                            //echo "skip";
                            //die();
                        	$row_sql = $query->row();
                        	//echo "+++++";
                        	//echo $row_sql->dc_updatetime."||||".$xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["dc_updatetime"]."\n";
                        	if($row_sql->dc_updatetime == $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["dc_updatetime"]){
                        		
                        		
                        		//$this->del_addons($dc_roomreservation_id);
                        		//$this->del_extracomponent_from_services($row_sql->id);
                        		//$this->add_addons($xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["addons"], $row_sql->id, $services_types_dc, $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["extracomponent"]);
                        		
                        		
                        		$reservationpush[$k]["response"] = "skip";
                        		$reservationpush[$k]["text"] = "modified time is simple";
                        		$reservationpush[$k]["alert"] = "modified time is simple";
                        		$xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["response"] = $reservationpush[$k]["response"];
                        		$xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation_alert"] = $reservationpush[$k]["alert"];
                        		$xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["hms_reservation_id"] = $row_sql->id;
                        		$xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["url"] = "https://" . $host . "/reservations/ReservationViewForm/".$row_sql->id;
                        		$reservationpush[$k]["status"] = $xml_array["reservations"][$dc_reservationid]["status"];
                        		$reservationpush[$k]["hms_reservation_id"] = $row_sql->id;
                        		$reservationpush[$k]["dc_reservationid"] = $dc_reservationid;
                        		$reservationpush[$k]["dc_roomreservation_id"] = $dc_roomreservation_id;
                        		$reservationpush[$k]["dc_room_id"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["category_id"];
                        		unset($xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]);
                        		$k++;
                        		continue;
                        	}
                        }
                        if (isset($xml_array["dc_rate_intdate_data"][$dc_roomreservation_id])) {
                            $this->dc_rate_intdate_insert($xml_array["dc_rate_intdate_data"][$dc_roomreservation_id]);
                        }
                        switch ($xml_array["reservations"][$dc_reservationid]["status"]) {
                            case "new":
                                
                                if (isset($xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"])) {
                                    $room_id = 0;
                                    $room_id = $this->frontdesk->getfreeroomlist($xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["datein"], $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["dateout"], $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["type_id"]);
                                    if ($room_id == 0) {
                                    	$xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["is_overbook"] = 1;
                                        if (isset($overbooking_category_id)) {
                                            $type_id = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["type_id"];
                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["origin_categoryid"] = $type_id;
                                            // $room_id = $this->frontdesk->getfreeroomlist ( ( string ) $room->arrival_date, ( string ) $room->departure_date, $overbooking_category_id );
                                            $room_id = $this->frontdesk->getfreeroomlist($xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["datein"], $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["dateout"], $overbooking_category_id);
                                            $insert_over_room_bool = 0;
                                            if ($room_id == 0) {
                                                $room_id = $this->dc_model->dc_make_overbooking_room($overbooking_category_id);
                                                $insert_over_room_bool = 1;
                                            }
                                        } else {
                                            $reservationpush[$k]["response"] = "failed";
                                            $reservationpush[$k]["text"] = "no overbooking_category_id";
                                            $reservationpush[$k]["alert"] = "(! овербукинг !)";
                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["response"] = $reservationpush[$k]["response"];
                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation_alert"] = $reservationpush[$k]["alert"];
                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["hms_reservation_id"] = 0;
                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["url"] = "https://" . $host . "/reservations/ReservationViewForm/0";
                                            $reservationpush[$k]["status"] = "new";
                                            $reservationpush[$k]["hms_reservation_id"] = 0;
                                            $reservationpush[$k]["dc_reservationid"] = $xml_array["reservations"][$dc_reservationid]["dc_reservationid"];
                                            $reservationpush[$k]["dc_roomreservation_id"] = $dc_roomreservation_id;
                                            $reservationpush[$k]["dc_room_id"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["category_id"];
                                            $is_failed = true;
                                        }
                                    }
                                    $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["room_id"] = $room_id;
                                    $query = $this->db->query("SELECT id FROM deskofreservation WHERE deleted = 0 AND dc_reservationid = " . $xml_array["reservations"][$dc_reservationid]["dc_reservationid"] . " AND dc_roomreservation_id = " . $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["dc_roomreservation_id"]);
                                    
                                    if ($query->num_rows() > 0) {
                                        
                                        $reservationpush[$k]["response"] = "skip";
                                        $reservationpush[$k]["text"] = "room exist";
                                        $reservationpush[$k]["alert"] = "";
                                        $reservationpush[$k]["status"] = "new";
                                        $reservationpush[$k]["hms_reservation_id"] = 0;
                                        $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["response"] = $reservationpush[$k]["response"];
                                        $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation_alert"] = $reservationpush[$k]["alert"];
                                        $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                        $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                        $reservationpush[$k]["dc_reservationid"] = $xml_array["reservations"][$dc_reservationid]["dc_reservationid"];
                                        $reservationpush[$k]["dc_roomreservation_id"] = $dc_roomreservation_id;
                                        $reservationpush[$k]["dc_room_id"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["category_id"];
                                        unset($xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]);
                                    } else {
                                        if ($xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["room_id"] == 0) {
                                            $is_failed = true;
                                            $reservationpush[$k]["response"] = "failed";
                                            // $reservationpush [$k] ["text"] =
                                            // "room_id is NULL";
                                            $reservationpush[$k]["text"] = "dc_reservationid = " . $dc_reservationid . ", dc_roomreservation_id = " . $dc_roomreservation_id;
                                            $reservationpush[$k]["status"] = "new";
                                            $reservationpush[$k]["alert"] = "(??? 1)";
                                            $reservationpush[$k]["hms_reservation_id"] = 0;
                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["response"] = $reservationpush[$k]["response"];
                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation_alert"] = $reservationpush[$k]["alert"];
                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                            $reservationpush[$k]["dc_reservationid"] = $xml_array["reservations"][$dc_reservationid]["dc_reservationid"];
                                            $reservationpush[$k]["dc_roomreservation_id"] = $dc_roomreservation_id;
                                            $reservationpush[$k]["dc_room_id"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["category_id"];
                                            
                                            $this->dc_model->send_failed_rommisnull($dc_reservationid, $dc_roomreservation_id, $hotel_id);
                                        } else {
                                            if ($bool_guest == 0) {
                                                $guest_id = $this->frontdesk->Guest_insert($xml_array["reservations"][$dc_reservationid]["guest"]);
                                                $bool_guest = 1;
                                            }
                                            
                                            // "<pre>";
                                            // print_r($xml_array
                                            // ["reservations"]
                                            // [$dc_reservationid] ["room"]
                                            // [$dc_roomreservation_id]
                                            // ["reservation"]);
                                            // die();
                                            $calculate_data = array();
                                            $calculate_data["type_id"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["type_id"];
                                            $calculate_data["datein"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["datein"];
                                            $calculate_data["dateout"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["dateout"];
                                            $calculate_data["add_places"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["add_places"];
                                            $calculate_data["baby_places"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["baby_places"];
                                            if(isset($xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["adults"])){
                                                $calculate_data["adults"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["adults"];
                                            }
                                            
                                            $calculate_data["addbedplace"] = 0;
                                            $calculate_data["babyplace2"] = 0;
                                            $calculate_data["price_type"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["price_type"];
                                            
                                            $temp_amount = $this->frontdesk->getpricecalculation($calculate_data);
                                            $otelms_amount = 0;
                                            for ($i = 0; $i < count($temp_amount); $i ++) {
                                                $otelms_amount += $temp_amount[$i]["amount"];
                                            }
                                            
                                            $booking_amount = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["amount"];
                                            $_sum = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["addons_sum"];// бути _sum
                                            //echo $booking_amount."||".$otelms_amount;
                                            //if (($booking_amount - $_sum) != $otelms_amount) {
                                                if ($otelms_amount != 0) {
                                                    $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["discount"] = $otelms_amount - ($booking_amount - $_sum);
                                                    $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["service_main_amount_2"] = 2;
                                                }
                                            //}
                                            
                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]['is_payment_VC'] = $is_payment_VC;
                                            
                                            //if($this->releases->check_booking_daily_price() == 1){
                                                //$xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["service_main_amount_2"] = 2; // признак фіксованої ціни
                                                //$xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["service_main_amount"] = $booking_amount;
                                                //$xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["service_main_ismanual"] = 1;
                                            //}
                                            
                                            $reservation_id = $this->frontdesk->Reservation_insert($xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"], $guest_id, 0, 1);
                                            // echo "lolol" . $reservation_id .
                                            // "=====" . "<br>";
                                            if (isset ( $xml_array ["reservations"] [$dc_reservationid] ["card"] )) {
												$tcc_id = $this->frontdesk->insert_tbl_CreditCards ( $xml_array ["reservations"] [$dc_reservationid] ["card"], $guest_id, $reservation_id );
												
// 												if ($is_payment_VC) {
// 													$deffered_payment_data = array ();
// 													$deffered_payment_data ["tcc_id"] = $tcc_id;
// 													$deffered_payment_data ["currency"] = (string)$xml_array["reservations"][$dc_reservationid]["payments_currencycode"];
// 													$deffered_payment_data ["amount"] = $xml_array["reservations"][$dc_reservationid]["payments_amount"];
// 													$deffered_payment_data ["state"] = 0;
													
// 													$this->frontdesk->insert_payment_deffered ( $deffered_payment_data );
													
// 												    // insert_payment
//                                                 	if($this->releases->set_auto_vc_payment() == 1){
//                                                 	   $this->dcm_payment->make_payment_with_pd($reservation_id);
//                                                 	}
// 												}
												
												$bind_data = array('res_id' => $reservation_id);
												$this->frontdesk->dc_cc_bind($bind_data);
											}
                                            
                                            $this->del_addons($dc_roomreservation_id);
                                            $this->del_extracomponent_from_services($reservation_id);
                                            $this->add_addons($xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["addons"], $reservation_id, $services_types_dc, $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["extracomponent"]);
                                            
                                            
                                            /*if (isset($xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["addons"])) {
                                                $this->add_addons($xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["addons"], $reservation_id, $services_types_dc);
                                            } else {
                                                $this->del_addons($dc_roomreservation_id);
                                            }
                                            
                                            
                                            if (isset($xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["extracomponent"])) {
                                            	$this->add_addons($xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["extracomponent"], $reservation_id, $services_types_dc, 1);
                                            } else {
                                            	$this->del_extracomponent_from_services($reservation_id);
                                            }
                                            */
                                            
                                            if ($reservation_id > 0) {
                                                $reservationpush[$k]["response"] = "ok";
                                                $reservationpush[$k]["text"] = "";
                                                if ($insert_over_room_bool == 1) {
                                                    $reservationpush[$k]["alert"] = "Рассинхронизация системы! Свяжитесь со службой. (Тип №2)";
                                                } else {
                                                    $reservationpush[$k]["alert"] = "";
                                                }
                                                $reservationpush[$k]["status"] = "new";
                                                $reservationpush[$k]["hms_reservation_id"] = $reservation_id;
                                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["response"] = $reservationpush[$k]["response"];
                                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation_alert"] = $reservationpush[$k]["alert"];
                                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                                $reservationpush[$k]["dc_reservationid"] = $xml_array["reservations"][$dc_reservationid]["dc_reservationid"];
                                                $reservationpush[$k]["dc_roomreservation_id"] = $dc_roomreservation_id;
                                                $reservationpush[$k]["dc_room_id"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["category_id"];
                                            } else {
                                                $is_failed = true;
                                                $reservationpush[$k]["response"] = "failed";
                                                $reservationpush[$k]["alert"] = "(??? 2)";
                                                $reservationpush[$k]["text"] = "undferror";
                                                $reservationpush[$k]["status"] = "new";
                                                $reservationpush[$k]["hms_reservation_id"] = 0;
                                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["response"] = $reservationpush[$k]["response"];
                                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation_alert"] = $reservationpush[$k]["alert"];
                                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                                $reservationpush[$k]["dc_reservationid"] = $xml_array["reservations"][$dc_reservationid]["dc_reservationid"];
                                                $reservationpush[$k]["dc_roomreservation_id"] = $dc_roomreservation_id;
                                                $reservationpush[$k]["dc_room_id"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["category_id"];
                                            }
                                        }
                                    }
                                }
                                $k ++;
                                break;
                            case "modified":
                                $bool_modified = 1;
                                if (! isset($xml_array["reservations"][$dc_reservationid]["todo"])) {
                                    // echo $dc_reservationid . "===";
                                    $reservationpush[$k]["response"] = "skip";
                                    $reservationpush[$k]["text"] = "reservation not in system";
                                    $reservationpush[$k]["alert"] = "(! заказ не найден !)";
                                    $reservationpush[$k]["status"] = "modified";
                                    $reservationpush[$k]["dc_reservationid"] = $dc_reservationid;
                                    $k ++;
                                    break;
                                }
                                $keys_todo = $xml_array["reservations"][$dc_reservationid]["todo"];
                                foreach ($keys_todo as $cell) {
                                    $dc_roomreservation_id = $cell['dc_roomreservation_id'];
                                    switch ($cell["status"]) {
                                        case "new":
                                            if (isset($xml_array["dc_rate_intdate_data"][$dc_roomreservation_id])) {
                                                
                                                $this->dc_rate_intdate_insert($xml_array["dc_rate_intdate_data"][$dc_roomreservation_id]);
                                            }
                                            if (isset($xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"])) {
                                                $room_id = 0;
                                                $room_id = $this->frontdesk->getfreeroomlist($xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["datein"], $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["dateout"], $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["type_id"]);
                                                if ($room_id == 0) {
                                                	$xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["is_overbook"] = 1;
                                                    if (isset($overbooking_category_id)) {
                                                        $type_id = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["type_id"];
                                                        $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["origin_categoryid"] = $type_id;
                                                        $room_id = $this->frontdesk->getfreeroomlist($xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["datein"], $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["dateout"], $overbooking_category_id);
                                                        if ($room_id == 0) {
                                                            $room_id = $this->dc_model->dc_make_overbooking_room($overbooking_category_id);
                                                        }
                                                    } else {
                                                        $is_failed = true;
                                                        $reservationpush[$k]["response"] = "failed";
                                                        $reservationpush[$k]["text"] = "no overbooking_category_id";
                                                        $reservationpush[$k]["alert"] = "(! овербукинг (2) !)";
                                                        $reservationpush[$k]["status"] = "new";
                                                        $reservationpush[$k]["hms_reservation_id"] = 0;
                                                        $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["response"] = $reservationpush[$k]["response"];
                                                        $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation_alert"] = $reservationpush[$k]["alert"];
                                                        $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                                        $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                                        $reservationpush[$k]["dc_reservationid"] = $xml_array["reservations"][$dc_reservationid]["dc_reservationid"];
                                                        $reservationpush[$k]["dc_roomreservation_id"] = $dc_roomreservation_id;
                                                        $reservationpush[$k]["dc_room_id"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["category_id"];
                                                    }
                                                }
                                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["room_id"] = $room_id;
                                                $query = $this->db->query("SELECT id FROM deskofreservation WHERE deleted = 0 AND dc_reservationid = " . $xml_array["reservations"][$dc_reservationid]["dc_reservationid"] . " AND dc_roomreservation_id = " . $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["dc_roomreservation_id"]);
                                                
                                                if ($query->num_rows() > 0) {
                                                    
                                                    $reservationpush[$k]["response"] = "skip";
                                                    $reservationpush[$k]["text"] = "???";
                                                    $reservationpush[$k]["alert"] = "(??? 3)";
                                                    $reservationpush[$k]["status"] = "new";
                                                    $reservationpush[$k]["hms_reservation_id"] = 0;
                                                    $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["response"] = $reservationpush[$k]["response"];
                                                    $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation_alert"] = $reservationpush[$k]["alert"];
                                                    $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                                    $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                                    $reservationpush[$k]["dc_reservationid"] = $xml_array["reservations"][$dc_reservationid]["dc_reservationid"];
                                                    $reservationpush[$k]["dc_roomreservation_id"] = $dc_roomreservation_id;
                                                    $reservationpush[$k]["dc_room_id"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["category_id"];
                                                    
                                                    unset($xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]);
                                                } else {
                                                    
                                                    if ($xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["room_id"] == 0) {
                                                        $is_failed = true;
                                                        $reservationpush[$k]["response"] = "failed";
                                                        // $reservationpush [$k]
                                                        // ["text"] = "room_id
                                                        // is NULL";
                                                        $reservationpush[$k]["text"] = "dc_reservationid = " . $dc_reservationid . ", dc_roomreservation_id = " . $dc_roomreservation_id;
                                                        $reservationpush[$k]["status"] = "new";
                                                        $reservationpush[$k]["alert"] = "(! овербукинг (3)!)";
                                                        $reservationpush[$k]["hms_reservation_id"] = 0;
                                                        $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["response"] = $reservationpush[$k]["response"];
                                                        $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation_alert"] = $reservationpush[$k]["alert"];
                                                        $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                                        $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                                        $reservationpush[$k]["dc_reservationid"] = $xml_array["reservations"][$dc_reservationid]["dc_reservationid"];
                                                        $reservationpush[$k]["dc_roomreservation_id"] = $dc_roomreservation_id;
                                                        $reservationpush[$k]["dc_room_id"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["category_id"];
                                                        
                                                        $this->dc_model->send_failed_rommisnull($dc_reservationid, $dc_roomreservation_id, $hotel_id);
                                                    } else {
                                                        if ($bool_guest == 0) {
                                                            $guest_id = $this->frontdesk->Guest_insert($xml_array["reservations"][$dc_reservationid]["guest"]);
                                                            $bool_guest = 1;
                                                        }
                                                        
                                                        // echo "<pre>";
                                                        // print_r($xml_array
                                                        // ["reservations"]
                                                        // [$dc_reservationid]
                                                        // ["room"]
                                                        // [$dc_roomreservation_id]
                                                        // ["reservation"]);
                                                        // die();
                                                        
                                                        $calculate_data = array();
                                                        $calculate_data["type_id"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["type_id"];
                                                        $calculate_data["datein"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["datein"];
                                                        $calculate_data["dateout"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["dateout"];
                                                        $calculate_data["add_places"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["add_places"];
                                                        $calculate_data["baby_places"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["baby_places"];
                                                        if(isset($xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["adults"])){
                                                            $calculate_data["adults"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["adults"];
                                                        }
                                                        $calculate_data["addbedplace"] = 0;
                                                        $calculate_data["babyplace2"] = 0;
                                                        $calculate_data["price_type"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["price_type"];
                                                        
                                                        $temp_amount = $this->frontdesk->getpricecalculation($calculate_data);
                                                        $otelms_amount = 0;
                                                        for ($i = 0; $i < count($temp_amount); $i ++) {
                                                            $otelms_amount += $temp_amount[$i]["amount"];
                                                        }
                                                        
                                                        $booking_amount = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["amount"];
                                                        $addons_sum = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["addons_sum"];
                                                        //if (($booking_amount - $addons_sum) != $otelms_amount) {
                                                            if ($otelms_amount != 0) {
                                                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["discount"] = $otelms_amount - ($booking_amount - $addons_sum);
                                                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["service_main_amount_2"] = 2; // признак фіксованої ціни
                                                            }
                                                        //}
                                                        
                                                        $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]['is_payment_VC'] = $is_payment_VC;
                                                        
                                                        //if ($this->releases->check_booking_daily_price() == 1) {
                                                            //$xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["service_main_amount_2"] = 2; // признак фіксованої ціни
                                                            //$xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["service_main_amount"] = $booking_amount;
                                                            // $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["service_main_ismanual"] = 1;
                                                        //}
                                                        
                                                        $reservation_id = $this->frontdesk->Reservation_insert($xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"], $guest_id, 0, 1);
                                                        // echo "lolol" .
                                                        // $reservation_id .
                                                        // "=====" . "<br>";
                                                        if (isset($xml_array["reservations"][$dc_reservationid]["card"])) {
                                                            $tcc_id = $this->frontdesk->insert_tbl_CreditCards($xml_array["reservations"][$dc_reservationid]["card"], $guest_id, $reservation_id);
                                                            
//                                                             if ($is_payment_VC) {
//                                                             	$deffered_payment_data = array ();
//                                                             	$deffered_payment_data ["tcc_id"] = $tcc_id;
//                                                             	$deffered_payment_data ["currency"] = $xml_array["reservations"][$dc_reservationid]["payments_currencycode"];
//                                                             	$deffered_payment_data ["amount"] = $xml_array["reservations"][$dc_reservationid]["payments_amount"];
//                                                             	$deffered_payment_data ["state"] = 0;
                                                            		
//                                                             	$this->frontdesk->insert_payment_deffered($deffered_payment_data);
                                                                
//                                                                 // insert_payment
//                                                                 if ($this->releases->set_auto_vc_payment() == 1) {
//                                                                     $this->dcm_payment->make_payment_with_pd($reservation_id);
//                                                                 }
//                                                             }
                                                            
                                                            $bind_data = array('res_id' => $reservation_id);
                                                            $this->frontdesk->dc_cc_bind($bind_data);
                                                        }
                                                        
                                                        $this->del_addons($dc_roomreservation_id);
                                                        $this->del_extracomponent_from_services($reservation_id);
                                                        $this->add_addons($xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["addons"], $reservation_id, $services_types_dc, $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["extracomponent"]);
          
                                                        /*if (isset($xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["addons"])) {
                                                            $this->add_addons($xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["addons"], $reservation_id, $services_types_dc);
                                                        } else {
                                                            $this->del_addons($dc_roomreservation_id);
                                                        }
                                                        
                                                        if (isset($xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["extracomponent"])) {
                                                        	$this->add_addons($xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["extracomponent"], $reservation_id, $services_types_dc, 1);
                                                        } else {
                                                        	$this->del_extracomponent_from_services($reservation_id);
                                                        }
                                                        */
                                                        if ($reservation_id > 0) {
                                                            $reservationpush[$k]["response"] = "ok";
                                                            $reservationpush[$k]["text"] = "";
                                                            $reservationpush[$k]["status"] = "new";
                                                            if ($insert_over_room_bool == 1) {
                                                                $reservationpush[$k]["alert"] = "Рассинхронизация системы! Свяжитесь со службой. (Тип №3)";
                                                            } else {
                                                                $reservationpush[$k]["alert"] = "";
                                                            }
                                                            $reservationpush[$k]["hms_reservation_id"] = $reservation_id;
                                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["response"] = $reservationpush[$k]["response"];
                                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation_alert"] = $reservationpush[$k]["alert"];
                                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                                            $reservationpush[$k]["dc_reservationid"] = $xml_array["reservations"][$dc_reservationid]["dc_reservationid"];
                                                            $reservationpush[$k]["dc_roomreservation_id"] = $dc_roomreservation_id;
                                                            $reservationpush[$k]["dc_room_id"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["category_id"];
                                                        } else {
                                                            $is_failed = true;
                                                            $reservationpush[$k]["response"] = "failed";
                                                            $reservationpush[$k]["text"] = "undferror";
                                                            $reservationpush[$k]["status"] = "new";
                                                            $reservationpush[$k]["alert"] = "(! овербукинг (4)!)";
                                                            $reservationpush[$k]["hms_reservation_id"] = 0;
                                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["response"] = $reservationpush[$k]["response"];
                                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation_alert"] = $reservationpush[$k]["alert"];
                                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                                            $reservationpush[$k]["dc_reservationid"] = $xml_array["reservations"][$dc_reservationid]["dc_reservationid"];
                                                            $reservationpush[$k]["dc_roomreservation_id"] = $dc_roomreservation_id;
                                                            $reservationpush[$k]["dc_room_id"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation"]["category_id"];
                                                        }
                                                    }
                                                }
                                            }
                                            $k ++;
                                            break;
                                        case "cancelled":
                                            $time2 = date("Y-m-d H:i:s");
                                            $status = 5;
                                            $query2 = $this->db->query("SELECT id FROM  services_main WHERE reservation_id = " . $cell["hms_reservation_id"] . " AND type = 2");
                                            
                                            if ($query2->num_rows() > 0) {
                                                // $is_failed = true;
                                                /*
                                                 * $reservationpush [$k] ["response"] = "ok";
                                                 * $reservationpush [$k] ["text"] = "есть уже отмена";
                                                 * $reservationpush [$k] ["text"] = "";
                                                 * $reservationpush [$k] ["status"] = "cancel";
                                                 * $reservationpush [$k] ["alert"] = "(повторно)";
                                                 * $reservationpush [$k] ["alert"] = "";
                                                 * $reservationpush [$k] ["dc_roomreservation_id"] = $dc_roomreservation_id;
                                                 * $reservationpush [$k] ["hms_reservation_id"] = $cell ["hms_reservation_id"];
                                                 * $reservationpush [$k] ["dc_reservationid"] = $dc_reservationid;
                                                 */
                                                $query2 = $this->db->query("SELECT deskofreservation.datein, deskofreservation.dateout, rooms.category_id FROM deskofreservation INNER JOIN rooms ON rooms.id = deskofreservation.room_id WHERE deskofreservation.id = " . $cell["hms_reservation_id"]);
                                                
                                                if ($query2->num_rows() > 0) {
                                                    $row2 = $query2->row();
                                                    $datein = $row2->datein;
                                                    $dateout = $row2->dateout;
                                                    $type_id = $row2->category_id;
                                                }
                                                
                                                $dc_log_data = array();
                                                $dc_log_data["datein"] = $datein;
                                                $dc_log_data["dateout"] = $dateout;
                                                $dc_log_data["category_id"] = $type_id;
                                                $this->frontdesk->dc_log_update($dc_log_data);
                                            } else {
                                                
                                                $data_cancel = array();
                                                
                                                $data_cancel["res_id"] = $cell["hms_reservation_id"];
                                                $data_cancel["charge"] = $xml_array["reservations"][$dc_reservationid]["total_cancellation_fee"];
                                                $data_cancel["status"] = $status;
                                                $data_cancel["description"] = "cancel from booking";
                                                $data_cancel["guestbe_request"] = 0;
                                                $data_cancel["user"] = - 1;
                                                $this->Cancel->Insert($data_cancel);
                                                $reservationpush[$k]["response"] = "ok";
                                                $reservationpush[$k]["text"] = "";
                                                $reservationpush[$k]["alert"] = "";
                                                $reservationpush[$k]["status"] = "cancel";
                                                $reservationpush[$k]["hms_reservation_id"] = $cell["hms_reservation_id"];
                                                //$xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["response"] = $reservationpush[$k]["response"];
                                                //$xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation_alert"] = $reservationpush[$k]["alert"];
                                                //$xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                                //$xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                                $reservationpush[$k]["dc_reservationid"] = $dc_reservationid;
                                                $reservationpush[$k]["dc_roomreservation_id"] = $dc_roomreservation_id;
                                            }
                                            
                                            $k ++;
                                            
                                            break;
                                        case "modified":
                                            $type_id = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["type_id"];
                                            
                                            //$this->del_extracomponent_from_services($cell["hms_reservation_id"]);
                                            
                                            $datein = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["datein"];
                                            $dateout = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["dateout"];
                                            $reservation_data = $this->frontdesk->GetReservation($cell["hms_reservation_id"]);
                                            
                                            $reservation_data["user"] = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["user"];
                                            $reservation_data["firstname"] = $xml_array["reservations"][$dc_reservationid]["guest"]["firstname"];
                                            $reservation_data["lastname"] = $xml_array["reservations"][$dc_reservationid]["guest"]["lastname"];
                                            if (trim($xml_array["reservations"][$dc_reservationid]["guest"]["phone"]) != "") {
                                                $reservation_data["phone"] = $xml_array["reservations"][$dc_reservationid]["guest"]["phone"];
                                            }
                                            // $reservation_data["phone"] = $xml_array["reservations"][$dc_reservationid]["guest"]["phone"];
                                            if (trim($xml_array["reservations"][$dc_reservationid]["guest"]["address"]) == "") {} else {
                                                $reservation_data["address"] = $xml_array["reservations"][$dc_reservationid]["guest"]["address"];
                                            }
                                            // $reservation_data["address"] = $xml_array["reservations"][$dc_reservationid]["guest"]["address"];
                                            $reservation_data["country"] = $xml_array["reservations"][$dc_reservationid]["guest"]["country"];
                                            if (trim($xml_array["reservations"][$dc_reservationid]["guest"]["city"]) == "") {} else {
                                                $reservation_data["city"] = $xml_array["reservations"][$dc_reservationid]["guest"]["city"];
                                            }
                                            // $reservation_data["city"] = $xml_array["reservations"][$dc_reservationid]["guest"]["city"];
                                            $addons_sum = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["addons_sum"];
                                            $reservation_data["amount"] = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["amount"] - $addons_sum;
                                            $reservation_data["date"] = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["date"];
                                            $reservation_data["add_places"] = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["add_places"];
                                            
                                            //обнулялось к-сть гостей на фоліо тому закоментував, 
                                            //unset($reservation_data["adults"]);
                                            
                                            // чому було закоментовано dont now
                                            $dc_numberofguest = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["dc_numberofguest"];
                                            if($dc_numberofguest > 0){
                                                $reservation_data["adults"] = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["dc_numberofguest"];
                                            }
                                            // чому було закоментовано dont now
                                            
                                            $reservation_data["baby_places"] = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["baby_places"];
                                            $reservation_data["datein"] = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["datein"];
                                            $reservation_data["dateout"] = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["dateout"];
                                            
                                            $reservation_data["addons_sum"] = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["addons_sum"];
                                            if ($type_id == "" or $type_id == 0) {
                                            	$reservation_data ["is_overbook"] = 1;
                                                if (isset($overbooking_category_id)) {
                                                    $insert_into_overbooking = 1;
                                                    $type_id = $overbooking_category_id;
                                                    $reservation_data["origin_categoryid"] = $reservation_data["type_id"];
                                                    $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["type_id"] = $type_id;
                                                }
                                            }
                                            
                                            if ($reservation_data["type_id"] == $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["type_id"]) {
                                                $reservation_data["room_id"] = $cell["room_id"];
                                            } else {
                                                $reservation_data["room_id"] = $this->frontdesk->getfreeroomlist($datein, $dateout, $type_id);
                                            }
                                            
                                            // $reservation_data ["origin_categoryid"] = $xml_array ["reservations"] [$dc_reservationid] ["room"] [$cell ["dc_roomreservation_id"]] ["reservation"] ["type_id"];
                                            $reservation_data["type_id"] = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["type_id"];
                                            $reservation_data["price_type"] = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["price_type"];
                                            $reservation_data["guest_id_new"] = 0;
                                            $reservation_data["free_places"] = 0;
                                            $reservation_data["maid_description"] = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["dc_roomremarks"];
                                            $reservation_data["isread"] = 0;
                                            $reservation_data["dc_guestname"] = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["dc_guestname"];
                                            $reservation_data["dc_currencycode"] = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["dc_currencycode"];
                                            $reservation_data["dc_countrycode"] = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["dc_countrycode"];
                                            $reservation_data["dc_city"] = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["dc_city"];
                                            $reservation_data["dc_customerremarks"] = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["dc_customerremarks"];
                                            $reservation_data["dc_roomremarks"] = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["dc_roomremarks"];
                                            $reservation_data["dc_numberofguest"] = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["dc_numberofguest"];
                                            $reservation_data["dc_totalprice"] = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["dc_totalprice"];
                                            $reservation_data["smoking"] = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["smoking"];
                                            $reservation_data["dc_updatetime"] = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["dc_updatetime"];
                                            
                                            if(isset($xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["hms_id"])){
                                            	$reservation_data["hms_id"] = $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["reservation"]["hms_id"];
                                            }
                                            
                                            // print_r($reservation_data);
                                            // echo
                                            // $dc_roomreservation_id."<br>";
                                            // die();
                                            $this->del_addons($cell["dc_roomreservation_id"]);
                                            $this->del_extracomponent_from_services($cell["hms_reservation_id"]);
                                            $this->service_model->delete_addons_fromservices_byresid($cell["hms_reservation_id"]);
                                            $this->add_addons($xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["addons"], $cell["hms_reservation_id"], $services_types_dc, $xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["extracomponent"]);
                                            
                                            
                                            /*
                                            if (isset($xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["addons"])) {
                                                $this->add_addons($xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["addons"], $cell["hms_reservation_id"], $services_types_dc);
                                            } else {
                                                $this->del_addons($cell["dc_roomreservation_id"]);
                                            }
                                            
                                            if (isset($xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["extracomponent"])) {
                                            	$this->add_addons($xml_array["reservations"][$dc_reservationid]["room"][$cell["dc_roomreservation_id"]]["extracomponent"], $cell["hms_reservation_id"], $services_types_dc, 1);
                                            } else {
                                            	$this->del_extracomponent_from_services($reservation_id);
                                            }
                                            */
                                            
                                            $CreditCard_data_DB = $this->frontdesk->GetCreditCard($reservation_data["guest_id"], $reservation_data["reservation_id"]);
                                            
                                            if (isset($xml_array["reservations"][$dc_reservationid]["card"])) {
                                                $card_data = array();
                                                if ($xml_array["reservations"][$dc_reservationid]["card"]["CardHolder"] == "" or $xml_array["reservations"][$dc_reservationid]["card"]["CardHolder"] == " ") {
                                                    $card_data["CardHolder"] = $CreditCard_data_DB["CardHolder"];
                                                } else {
                                                    $card_data["CardHolder"] = $xml_array["reservations"][$dc_reservationid]["card"]["CardHolder"];
                                                }
                                                if ($xml_array["reservations"][$dc_reservationid]["card"]["CardNumber"] == "" or $xml_array["reservations"][$dc_reservationid]["card"]["CardNumber"] == " ") {
                                                    $card_data["CardNumber"] = $CreditCard_data_DB["CardNumber"];
                                                } else {
                                                    $card_data["CardNumber"] = $xml_array["reservations"][$dc_reservationid]["card"]["CardNumber"];
                                                }
                                                if ($xml_array["reservations"][$dc_reservationid]["card"]["cc_type"] == "" or $xml_array["reservations"][$dc_reservationid]["card"]["cc_type"] == " ") {
                                                    $card_data["cc_type"] = $CreditCard_data_DB["cc_type"];
                                                } else {
                                                    $card_data["cc_type"] = $xml_array["reservations"][$dc_reservationid]["card"]["cc_type"];
                                                }
                                                if ($xml_array["reservations"][$dc_reservationid]["card"]["cc_cvc"] == "" or $xml_array["reservations"][$dc_reservationid]["card"]["cc_cvc"] == " ") {
                                                    $card_data["cc_cvc"] = $CreditCard_data_DB["cc_cvc"];
                                                } else {
                                                    $card_data["cc_cvc"] = $xml_array["reservations"][$dc_reservationid]["card"]["cc_cvc"];
                                                }
                                                if ($xml_array["reservations"][$dc_reservationid]["card"]["ExpMonth"] == "" or $xml_array["reservations"][$dc_reservationid]["card"]["ExpMonth"] == " ") {
                                                    $card_data["ExpMonth"] = $CreditCard_data_DB["ExpMonth"];
                                                } else {
                                                    $card_data["ExpMonth"] = $xml_array["reservations"][$dc_reservationid]["card"]["ExpMonth"];
                                                }
                                                if ($xml_array["reservations"][$dc_reservationid]["card"]["ExpYear"] == "" or $xml_array["reservations"][$dc_reservationid]["card"]["ExpYear"] == " ") {
                                                    $card_data["ExpYear"] = $CreditCard_data_DB["ExpYear"];
                                                } else {
                                                    $card_data["ExpYear"] = $xml_array["reservations"][$dc_reservationid]["card"]["ExpYear"];
                                                }
                                                
                                                $tcc_id = $this->frontdesk->update_tbl_CreditCards($card_data, $reservation_data["guest_id"], $reservation_data["reservation_id"]);
                                                
                                                
                                                
//                                                 if ($is_payment_VC) {
//                                                 	$deffered_payment_data = array ();
//                                                 	$deffered_payment_data ["tcc_id"] = $tcc_id;
//                                                 	$deffered_payment_data ["currency"] = $xml_array["reservations"][$dc_reservationid]["payments_currencycode"];
//                                                 	$deffered_payment_data ["amount"] = $xml_array["reservations"][$dc_reservationid]["payments_amount"];
//                                                 	$deffered_payment_data ["state"] = 0;
                                                
//                                                 	$this->frontdesk->insert_payment_deffered ( $deffered_payment_data );
                                                	
//                                                 	// insert_payment
//                                                 	if($this->releases->set_auto_vc_payment() == 1){
//                                                 	   $this->dcm_payment->make_payment_with_pd($reservation_data["reservation_id"]);
//                                                 	}
//                                                 }
                                                
                                                $bind_data = array('res_id' => $reservation_data["reservation_id"]);
                                                $this->frontdesk->dc_cc_bind($bind_data);;
                                            }
                                            
                                            $calculate_data = array();
                                            $calculate_data["type_id"] = $reservation_data["type_id"];
                                            $calculate_data["datein"] = $reservation_data["datein"];
                                            $calculate_data["dateout"] = $reservation_data["dateout"];
                                            $calculate_data["add_places"] = $reservation_data["add_places"];
                                            $calculate_data["baby_places"] = $reservation_data["baby_places"];
                                            
                                            $calculate_data["addbedplace"] = 0;
                                            $calculate_data["babyplace2"] = 0;
                                            $calculate_data["price_type"] = $reservation_data["price_type"];
                                            
                                            $temp_amount = $this->frontdesk->getpricecalculation($calculate_data);
                                            $otelms_amount = 0;
                                            for ($i = 0; $i < count($temp_amount); $i ++) {
                                                $otelms_amount += $temp_amount[$i]["amount"];
                                            }
                                            
                                            $booking_amount = $reservation_data["amount"];
                                            //echo $otelms_amount."++++++++++".$booking_amount."||".$reservation_data["addons_sum"];
                                            //if (($booking_amount - $reservation_data["addons_sum"]) != $otelms_amount) {
                                                if ($otelms_amount != 0) {
                                                    $reservation_data["discount"] = $otelms_amount - ($booking_amount - $reservation_data["addons_sum"]);
                                                    $reservation_data["service_main_amount_2"] = 2; // признак фіксованої ціни
                                                    $reservation_data["day_price"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["day_price"];
                                                }
                                            //} else {
                                            //    $reservation_data["discount"] = 0;
                                            //}
                                            
                                            // print_r($reservation_data);
                                            $update_res = $this->frontdesk->UpdateReservation($reservation_data, 0, 1);
                                            echo "<br>" . $update_res . " ---------";
                                            // die();
                                            if ($update_res == "FreeError") {
                                                
                                                $room_id = $this->frontdesk->getfreeroomlist($datein, $dateout, $reservation_data["type_id"]);
                                                
                                                if ($room_id != 0) {
                                                    $reservation_data["room_id"] = $room_id;
                                                    
                                                    // print_r($reservation_data);
                                                    // die();
                                                    
                                                    $update_res = $this->frontdesk->UpdateReservation($reservation_data, 0, 1);
                                                    if ($update_res == "FreeError") {
                                                    	$reservation_data ["is_overbook"] = 1;
                                                        if (isset($overbooking_category_id)) {
                                                            $room_id = $this->frontdesk->getfreeroomlist($datein, $dateout, $overbooking_category_id);
                                                            $reservation_data["origin_categoryid"] = $reservation_data["type_id"];
                                                            $reservation_data["room_id"] = $room_id;
                                                            $reservation_data["type_id"] = $overbooking_category_id;
                                                            
                                                            $reservation_data["service_main_amount_2"] = 2; // признак фіксованої ціни
                                                            $reservation_data["day_price"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["day_price"];
                                                            $reservation_data["service_main_amount"] = $reservation_data["amount"];
                                                            $reservation_data["service_main_ismanual"] = 1;
                                                            // print_r($reservation_data);
                                                            // die();
                                                            
                                                            $update_res = $this->frontdesk->UpdateReservation($reservation_data, 0, 1);
                                                            if ($update_res == "FreeError") {
                                                                $is_failed = true;
                                                                $reservationpush[$k]["response"] = "error";
                                                                $reservationpush[$k]["text"] = "Not Free rooms";
                                                                $reservationpush[$k]["alert"] = "(!!! ошибка !!!)";
                                                                $reservationpush[$k]["status"] = "modified";
                                                                $reservationpush[$k]["hms_reservation_id"] = $xml_array["reservations"][$dc_reservationid]["todo"][$cell["dc_roomreservation_id"]]["hms_reservation_id"];
                                                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["response"] = $reservationpush[$k]["response"];
                                                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation_alert"] = $reservationpush[$k]["alert"];
                                                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                                                $reservationpush[$k]["dc_reservationid"] = $dc_reservationid;
                                                                $reservationpush[$k]["dc_roomreservation_id"] = $dc_roomreservation_id;
                                                                $k ++;
                                                            } else {
                                                                $reservationpush[$k]["response"] = "ok";
                                                                $reservationpush[$k]["text"] = "overbooking transfer";
                                                                $reservationpush[$k]["alert"] = "(перемещение в сверхбронь/очередь)";
                                                                $reservationpush[$k]["status"] = "modified";
                                                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["response"] = $reservationpush[$k]["response"];
                                                                $reservationpush[$k]["hms_reservation_id"] = $xml_array["reservations"][$dc_reservationid]["todo"][$cell["dc_roomreservation_id"]]["hms_reservation_id"];
                                                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation_alert"] = $reservationpush[$k]["alert"];
                                                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                                                $reservationpush[$k]["dc_reservationid"] = $dc_reservationid;
                                                                $reservationpush[$k]["dc_roomreservation_id"] = $dc_roomreservation_id;
                                                                $k ++;
                                                            }
                                                        } else {
                                                            $reservationpush[$k]["response"] = "error";
                                                            $reservationpush[$k]["text"] = "Not Free rooms (overbooking not set)";
                                                            $reservationpush[$k]["status"] = "modified";
                                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["response"] = $reservationpush[$k]["response"];
                                                            $reservationpush[$k]["hms_reservation_id"] = $xml_array["reservations"][$dc_reservationid]["todo"][$cell["dc_roomreservation_id"]]["hms_reservation_id"];
                                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation_alert"] = "";
                                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                                            $reservationpush[$k]["dc_reservationid"] = $dc_reservationid;
                                                            $reservationpush[$k]["dc_roomreservation_id"] = $dc_roomreservation_id;
                                                            $k ++;
                                                        }
                                                    } else {
                                                        $reservationpush[$k]["response"] = "ok";
                                                        $reservationpush[$k]["text"] = "New room " . $room_id;
                                                        $reservationpush[$k]["alert"] = "(перемещение в сверхбронь/очередь)";
                                                        $reservationpush[$k]["status"] = "modified";
                                                        $reservationpush[$k]["hms_reservation_id"] = $xml_array["reservations"][$dc_reservationid]["todo"][$cell["dc_roomreservation_id"]]["hms_reservation_id"];
                                                        $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["response"] = $reservationpush[$k]["response"];
                                                        $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation_alert"] = $reservationpush[$k]["alert"];
                                                        $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                                        $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                                        $reservationpush[$k]["dc_reservationid"] = $dc_reservationid;
                                                        $reservationpush[$k]["dc_roomreservation_id"] = $dc_roomreservation_id;
                                                        $k ++;
                                                    }
                                                } else {
                                                	$reservation_data ["is_overbook"] = 1;
                                                    if (isset($overbooking_category_id)) {
                                                        $room_id = $this->frontdesk->getfreeroomlist($datein, $dateout, $overbooking_category_id);
                                                        $reservation_data["origin_categoryid"] = $reservation_data["type_id"];
                                                        $reservation_data["room_id"] = $room_id;
                                                        $reservation_data["type_id"] = $overbooking_category_id;
                                                        
                                                        $reservation_data["service_main_amount_2"] = 2; // признак фіксованої ціни
                                                        $reservation_data["day_price"] = $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["day_price"];
                                                        $reservation_data["service_main_amount"] = $reservation_data["amount"];
                                                        $reservation_data["service_main_ismanual"] = 1;
                                                        // print_r($reservation_data);
                                                        // die();
                                                        
                                                        $update_res = $this->frontdesk->UpdateReservation($reservation_data, 0, 1);
                                                        if ($update_res == "FreeError") {
                                                            $is_failed = true;
                                                            $reservationpush[$k]["response"] = "error";
                                                            $reservationpush[$k]["text"] = "Not Free rooms";
                                                            $reservationpush[$k]["alert"] = "(!!!! ошибка !!!!)";
                                                            $reservationpush[$k]["status"] = "modified";
                                                            $reservationpush[$k]["dc_roomreservation_id"] = $dc_roomreservation_id;
                                                            $reservationpush[$k]["hms_reservation_id"] = $xml_array["reservations"][$dc_reservationid]["todo"][$cell["dc_roomreservation_id"]]["hms_reservation_id"];
                                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["response"] = $reservationpush[$k]["response"];
                                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation_alert"] = $reservationpush[$k]["alert"];
                                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                                            $reservationpush[$k]["dc_reservationid"] = $dc_reservationid;
                                                            $reservationpush[$k]["dc_roomreservation_id"] = $dc_roomreservation_id;
                                                            $k ++;
                                                        } else {
                                                            $reservationpush[$k]["response"] = "ok";
                                                            $reservationpush[$k]["text"] = "overbooking transfer";
                                                            $reservationpush[$k]["alert"] = "(перемещение в сверхбронь/очередь)";
                                                            $reservationpush[$k]["status"] = "modified";
                                                            $reservationpush[$k]["hms_reservation_id"] = $xml_array["reservations"][$dc_reservationid]["todo"][$cell["dc_roomreservation_id"]]["hms_reservation_id"];
                                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["response"] = $reservationpush[$k]["response"];
                                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation_alert"] = $reservationpush[$k]["alert"];
                                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                                            $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                                            $reservationpush[$k]["dc_reservationid"] = $dc_reservationid;
                                                            $reservationpush[$k]["dc_roomreservation_id"] = $dc_roomreservation_id;
                                                            $k ++;
                                                        }
                                                    } else {
                                                        $reservationpush[$k]["response"] = "error";
                                                        $reservationpush[$k]["text"] = "Not Free rooms (overbooking not set)";
                                                        $reservationpush[$k]["status"] = "modified";
                                                        $reservationpush[$k]["hms_reservation_id"] = $xml_array["reservations"][$dc_reservationid]["todo"][$cell["dc_roomreservation_id"]]["hms_reservation_id"];
                                                        $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation_alert"] = "";
                                                        $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                                        $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                                        $reservationpush[$k]["dc_reservationid"] = $dc_reservationid;
                                                        $reservationpush[$k]["dc_roomreservation_id"] = $dc_roomreservation_id;
                                                        $k ++;
                                                    }
                                                }
                                            } else {
                                                
                                                $reservationpush[$k]["response"] = "ok";
                                                $reservationpush[$k]["text"] = "";
                                                $reservationpush[$k]["alert"] = "";
                                                $reservationpush[$k]["status"] = "modified";
                                                $reservationpush[$k]["hms_reservation_id"] = $xml_array["reservations"][$dc_reservationid]["todo"][$cell["dc_roomreservation_id"]]["hms_reservation_id"];
                                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["response"] = $reservationpush[$k]["response"];
                                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation_alert"] = $reservationpush[$k]["alert"];
                                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                                $reservationpush[$k]["dc_reservationid"] = $dc_reservationid;
                                                $reservationpush[$k]["dc_roomreservation_id"] = $dc_roomreservation_id;
                                                $k ++;
                                            }
                                            if (isset($xml_array["reservations"][$dc_reservationid]["card"])) {
                                                // $this->frontdesk->update_tbl_CreditCards
                                                // ( $xml_array ["reservations"]
                                                // [$dc_reservationid]["card"],
                                                // $reservation_data
                                                // ["guest_id"],
                                                // $reservation_data
                                                // ["reservation_id"] );
                                            }
                                            break;
                                    }
                                }
                                
                                // ============================================================================
                                
                                break;
                        }
                    }
                } else {
                    switch ($xml_array["reservations"][$dc_reservationid]["status"]) {
                        
                        case "cancelled":
                            
                            $time2 = date("Y-m-d H:i:s");
                            $status = 5;
                            
                            $query = $this->db->query("SELECT id FROM deskofreservation WHERE dc_reservationid = " . $xml_array["reservations"][$dc_reservationid]["dc_reservationid"]);
                            
                            if ($query->num_rows() > 0) {
                                foreach ($query->result() as $row) {
                                    $res_id = $row->id;
                                    $query3 = $this->db->query("UPDATE deskofreservation SET dc_updatetime = '".$xml_array["reservations"][$dc_reservationid]["dc_updatetime"]."' WHERE deskofreservation.id = $res_id");
                                    
                                    $query2 = $this->db->query("SELECT deskofreservation.datein, deskofreservation.dateout, rooms.category_id FROM deskofreservation INNER JOIN rooms ON rooms.id = deskofreservation.room_id WHERE deskofreservation.id = $res_id");
                                    
                                    if ($query2->num_rows() > 0) {
                                        $row2 = $query2->row();
                                        $datein = $row2->datein;
                                        $dateout = $row2->dateout;
                                        $type_id = $row2->category_id;
                                    }
                                    
                                    $query2 = $this->db->query("SELECT id FROM  services_main WHERE reservation_id = $res_id AND type = 2");
                                    
                                    if ($query2->num_rows() > 0) {
                                        $skip_empty = true;
                                        // $is_failed = true;
                                        /*
                                         * $reservationpush [$k] ["response"] = "ok";
                                         * $reservationpush [$k] ["text"] = "";
                                         * $reservationpush [$k] ["status"] = "cancel";
                                         * $reservationpush [$k] ["alert"] = "";
                                         * //$reservationpush [$k] ["alert"] = "(повторно(2))";
                                         *
                                         * $reservationpush [$k] ["hms_reservation_id"] = $res_id;
                                         * $reservationpush [$k] ["dc_reservationid"] = $xml_array ["reservations"] [$dc_reservationid] ["dc_reservationid"];
                                         */
                                        $dc_log_data = array();
                                        $dc_log_data["datein"] = $datein;
                                        $dc_log_data["dateout"] = $dateout;
                                        $dc_log_data["category_id"] = $type_id;
                                        $this->frontdesk->dc_log_update($dc_log_data);
                                    } else {
                                        
                                        $data_cancel = array();
                                        
                                        $data_cancel["res_id"] = $res_id;
                                        $data_cancel["charge"] = $xml_array["reservations"][$dc_reservationid]["total_cancellation_fee"];
                                        $data_cancel["status"] = $status;
                                        $data_cancel["description"] = "cancel from booking";
                                        $data_cancel["guestbe_request"] = 0;
                                        $data_cancel["user"] = - 1;
                                        $this->Cancel->Insert($data_cancel);
                                        $reservationpush[$k]["response"] = "ok";
                                        $reservationpush[$k]["alert"] = "";
                                        $reservationpush[$k]["text"] = "";
                                        $reservationpush[$k]["status"] = "cancel";
                                        $reservationpush[$k]["hms_reservation_id"] = $res_id;
                                        $reservationpush[$k]["dc_reservationid"] = $xml_array["reservations"][$dc_reservationid]["dc_reservationid"];
                                    }
                                    $k ++;
                                }
                            } else {
                                $is_failed = true;
                                $reservationpush[$k]["response"] = "failed";
                                $reservationpush[$k]["text"] = "noorder";
                                $reservationpush[$k]["status"] = "cancel";
                                $reservationpush[$k]["alert"] = "(отмена (2))";
                                $reservationpush[$k]["hms_reservation_id"] = 0;
                                
                                $reservationpush[$k]["guest_name"] = $xml_array["reservations"][$dc_reservationid]["guest"]["lastname"] . " " . $xml_array["reservations"][$dc_reservationid]["guest"]["firstname"];
                                $reservationpush[$k]["guest_phone"] = $xml_array["reservations"][$dc_reservationid]["guest"]["phone"];
                                $reservationpush[$k]["guest_email"] = $xml_array["reservations"][$dc_reservationid]["guest"]["email"];
                                $reservationpush[$k]["date"] = $xml_array["reservations"][$dc_reservationid]["date_time"];
                                
                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["response"] = $reservationpush[$k]["response"];
                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["reservation_alert"] = $reservationpush[$k]["alert"];
                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                $xml_array["reservations"][$dc_reservationid]["room"][$dc_roomreservation_id]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                $reservationpush[$k]["dc_reservationid"] = $xml_array["reservations"][$dc_reservationid]["dc_reservationid"];
                            }
                            $k ++;
                            break;
                    }
                }
            }
            //echo "<pre>";
            //print_r($xml_array["reservations"]);
            //print_r($reservationpush);
            //die();
            
            /*
             * SEND NOTIFY
             */
            
            foreach ($xml_array["reservations"] as $cell) {
                if ($cell['status'] == "cancelled")
                    continue;
                
                if (isset($cell["todo"])) {
                    
                    $new_mass = array();
                    foreach ($cell["todo"] as $todo_cell) {
                        if ($todo_cell["status"] == "new" or $todo_cell["status"] == "modified") {
                            if (isset($xml_array["reservations"][$todo_cell["dc_reservationid"]]["room"][$todo_cell["dc_roomreservation_id"]])) {
                                if ($xml_array["reservations"][$todo_cell["dc_reservationid"]]["room"][$todo_cell["dc_roomreservation_id"]]["response"] != "skip") {
                                    $new_mass['dcname'] = "Booking.com";
                                    $new_mass['host'] = $host;
                                    $new_mass['status'] = $todo_cell["status"];
                                    $new_mass['dc_reservationid'] = $todo_cell["dc_reservationid"];
                                    $new_mass['dc_channel_name'] = $xml_array["reservations"][$todo_cell["dc_reservationid"]]["dc_channel_name"];
                                    $new_mass['hotel_name'] = $xml_array["reservations"][$todo_cell["dc_reservationid"]]["hotel_name"];
                                    $new_mass['guest_firstname'] = $xml_array["reservations"][$todo_cell["dc_reservationid"]]["guest_firstname"];
                                    $new_mass['guest_lastname'] = $xml_array["reservations"][$todo_cell["dc_reservationid"]]["guest_lastname"];
                                    $new_mass['guest_phone'] = $xml_array["reservations"][$todo_cell["dc_reservationid"]]["guest_phone"];
                                    $new_mass['guest_email'] = $xml_array["reservations"][$todo_cell["dc_reservationid"]]["guest_email"];
                                   
                                    // $todo_cell ["dc_roomreservation_id"]
                                    
                                    $new_mass["room"][$todo_cell["dc_roomreservation_id"]] = $xml_array["reservations"][$todo_cell["dc_reservationid"]]["room"][$todo_cell["dc_roomreservation_id"]];
                                    if ($new_mass["room"][$todo_cell["dc_roomreservation_id"]]["reservation"]["type_id"] == 0) {
                                        $new_mass['err_msg'] = "Неизвестная категория!!! (" . $new_mass["room"][$todo_cell["dc_roomreservation_id"]]["reservation_category_id"] . ") <br> Рассинхронизация системы, свяжитесь со службой поддержки.";
                                    }
                                    
                                    //$this->dc_model->send_notifyarray_new($new_mass);
                                }
                            }
                        }
                    }
                    
                    //echo "222333444";
                    if ($cell["status"] == "new" or $cell["status"] == "modified") {
                    	$cell['dcname'] = "Booking.com";
                    	$cell['host'] = $host;
                    	//echo "99990000";
                    	if(sizeof($cell["room"]) > 0){
                    	   if ($send_notification == 1 ) {
                    	       //if ($send_notification == 1 && $cell["response"] != "skip") {
                    	       
                    		  echo "check point 2638";
                    		  $this->dc_model->send_notifyarray_new($cell);
                    	   }
                    	}
                    }
                    
                    // if (count($new_mass) != 0)
                    // $this->dc_model->send_notifyarray_new($new_mass);
                    // break;
                } else {
                    echo "++++++++++++++++++++++++++++++++++++";
                    print_r($cell);
                    if ($cell["status"] == "new" or $cell["status"] == "modified") {
                        $cell['dcname'] = "Booking.com";
                        $cell['host'] = $host;
                        if ($send_notification == 1 && $cell["response"] != "skip") {
                            
                            $this->dc_model->send_notifyarray_new($cell);
                        }
                    }
                }
            }
            
            // die ();
        }
        if (isset($xml_array["reservations"])) {
            echo "<pre>";
            print_r($xml_array["reservations"]);
        }
//         echo $compactmode;
//         die();
        if (! $compactmode) {
            print_r($reservationpush);
            if (sizeof($reservationpush) == 0 && $skip_empty == false) {
                echo "--empty_reservation--";
            }
        }
        
        if ($compactmode) {
            if (sizeof($reservationpush) == 0) {} else {
                echo "\n-=NEW RECORD =-\n";
                echo gmdate("Y-m-d H:i:s") . "\n";
                echo $hotel_id . "\n";
                
                print_r($reservations);
            }
        }
        
        // die();
        foreach ($reservationpush as $arg) {
            // continue;
            if ($arg['status'] == "cancel") {
                $data = array();
                $data['host'] = $host;
                $data["hms_reservation_id"] = $arg["hms_reservation_id"];
                $data['resid'] = $arg['dc_reservationid'];
                if (isset($arg['dc_roomreservation_id'])) {
                    $data['dc_roomreservation_id'] = $arg['dc_roomreservation_id'];
                } else {
                    $data['dc_roomreservation_id'] = '';
                }
                $data['dc_reservationid'] = $arg['dc_reservationid'];
                $data['response'] = $arg['response'];
                $data['text'] = $arg['text'];
                $data['alert'] = $arg['alert'];
                $data['dcname'] = "Booking.com";
                $data['status'] = $arg['status'];
                if (isset($arg['dc_reservationid'])) {
                    $data['dc_reservationid'] = $arg['dc_reservationid'];
                }
                if (isset($arg['guest_name'])) {
                    $data['guest_name'] = $arg['guest_name'];
                }
                if (isset($arg['guest_phone'])) {
                    $data['guest_phone'] = $arg['guest_phone'];
                }
                if (isset($arg['guest_email'])) {
                    $data['guest_email'] = $arg['guest_email'];
                }
                if (isset($arg['date'])) {
                    $data['date'] = $arg['date'];
                }
                if ($send_notification == 1 && $arg['response'] != "skip")
                    $this->dc_model->send_notifyarray($data);
            }
        }
        
        if ($is_failed) {
            $this->dc_model->send_alert("[XML-OMS-BOOK-ALERT] Booking.com failed! ID (" . $dc_reservationid . "/" . $dc_roomreservation_id . "), hotel ID=" . $hotel_id, htmlspecialchars($request));
        }
        
        
        return json_encode($reservationpush, true);
    }

    function loaddesk($datein = "", $dateout = "", $dc_rates = array(), $dc_rooms = array())
    {
        if ($datein == "") {
            $days_line = 3;
            $datein = gmdate("Y-m-d");
            list ($year, $month, $day) = explode("-", $datein);
            $intdatein = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
            list ($year, $month, $day) = explode("-", $datein);
            $intdateout = round(gmmktime(0, 0, 0, $month, $day + $days_line - 1, $year) / 86400);
        } else {
            list ($year, $month, $day) = explode("-", $datein);
            $intdatein = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
            list ($year, $month, $day) = explode("-", $dateout);
            $intdateout = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
        }
        
        $select_rate = "";
        if (isset($dc_rates[0]) != 0) {
            $select_rate .= " dc_booking_rates_link.dc_rate_id IN (";
            for ($i = 0; $i < count($dc_rates); $i ++) {
                if ($i < count($dc_rates) - 1) {
                    $select_rate .= $dc_rates[$i] . ",";
                } else {
                    $select_rate .= $dc_rates[$i];
                }
            }
            $select_rate .= ") AND ";
        } else {
            $select_rate = "";
        }
        
        $select_room = "";
        if (isset($dc_rooms[0]) != 0) {
            $select_room .= " dc_booking_rooms_link.dc_room_id IN (";
            for ($i = 0; $i < count($dc_rooms); $i ++) {
                if ($i < count($dc_rooms) - 1) {
                    $select_room .= $dc_rooms[$i] . ",";
                } else {
                    $select_room .= $dc_rooms[$i];
                }
            }
            $select_room .= ") AND ";
        } else {
            $select_room = "";
        }
        
        $array_rates_names = array();
        
        $sql = "SELECT * FROM dc_booking_rates_link WHERE $select_rate 1";
        
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $i = 0;
            foreach ($query->result() as $row) {
                $array_rates_names[$i] = $row->dc_rate_name;
                $i ++;
            }
        }
        
        $array_rates = array();
        
        $sql = "SELECT * FROM dc_booking_rates_link WHERE $select_rate 1";
        
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $i = 0;
            foreach ($query->result() as $row) {
                $array_rates[$i] = $row->dc_rate_id;
                $i ++;
            }
        }
        
        $array_prices_seasons = array();
        
        $sql = "SELECT  dc_booking_rates_link.dc_rate_id, seasonspricelist.rate_id, seasonspricelist.season_id, seasonspricelist.category_id, 
		seasonspricelist.price, seasonspricelist.perperson_price, seasonspricelist.extrabed_price, 
		dc_booking_rooms_link.dc_room_id FROM seasonspricelist
		INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
		INNER JOIN rate ON rate.id = seasonspricelist.rate_id
		INNER JOIN categories ON categories.id = seasonspricelist.category_id
		INNER JOIN dc_booking_rooms_link ON dc_booking_rooms_link.category_id = categories.id
		INNER JOIN dc_booking_rates_link ON dc_booking_rates_link.hms_rate_id = seasonspricelist.rate_id
		WHERE $select_rate $select_room 1 
		GROUP BY seasonspricelist.category_id, seasonspricelist.rate_id, seasons.id
		";
        
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $array_prices_seasons[$row->dc_room_id][$row->dc_rate_id][$row->season_id]["price"] = $row->price;
            }
        }
        // echo "<pre>";
        // print_r ( $array_prices_seasons );
        // die ();
        $array_seasons_intdate = array();
        $sql = "SELECT  * FROM deskofdaysseason";
        
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $array_seasons_intdate[$row->intdate] = $row->seasonid;
            }
        }
        
        $categories_rooms_all = array();
        
        $sql = "SELECT categories.id, dc_booking_rooms_link.dc_room_id, categories.base_price, categories.name, COUNT( 1 ) AS count_rooms FROM `rooms`
		INNER JOIN categories ON categories.id = rooms.category_id
		INNER JOIN dc_booking_rooms_link ON dc_booking_rooms_link.category_id = categories.id
		WHERE $select_room 1 GROUP BY rooms.category_id";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            for ($j = 0; $j < count($array_rates); $j ++) {
                $categories_rooms_all["rate"][$array_rates[$j]]["dc_rate_name"] = $array_rates_names[$j];
                for ($i = $intdatein; $i <= $intdateout; $i ++) {
                    foreach ($query->result() as $row) {
                        
                        $categories_rooms_all["rate"][$array_rates[$j]]["intddatemain"][$i]["category"][$row->dc_room_id]["free_day"] = $row->count_rooms;
                        $categories_rooms_all["rate"][$array_rates[$j]]["intddatemain"][$i]["category"][$row->dc_room_id]["count_rooms"] = $row->count_rooms;
                        $categories_rooms_all["rate"][$array_rates[$j]]["intddatemain"][$i]["category"][$row->dc_room_id]["category_name"] = $row->name;
                        $categories_rooms_all["rate"][$array_rates[$j]]["intddatemain"][$i]["category"][$row->dc_room_id]["category_id"] = $row->dc_room_id;
                        
                        if (isset($array_prices_seasons[$row->dc_room_id][$array_rates[$j]][$array_seasons_intdate[$i]]["price"])) {
                            // echo "++++++";
                            $price = $array_prices_seasons[$row->dc_room_id][$array_rates[$j]][$array_seasons_intdate[$i]]["price"];
                        } else {
                            $price = $row->base_price;
                        }
                        $categories_rooms_all["rate"][$array_rates[$j]]["intddatemain"][$i]["category"][$row->dc_room_id]["price"] = $price;
                    }
                    
                    $date_year = gmdate("Y", $i * 86400);
                    $date_day = gmdate("d", $i * 86400);
                    $date_month = gmdate("m", $i * 86400);
                    $categories_rooms_all["rate"][$array_rates[$j]]["intddatemain"][$i]["intdate"] = $i;
                    $categories_rooms_all["rate"][$array_rates[$j]]["intddatemain"][$i]["date_year"] = $date_year;
                    $categories_rooms_all["rate"][$array_rates[$j]]["intddatemain"][$i]["date_day"] = $date_day;
                    $categories_rooms_all["rate"][$array_rates[$j]]["intddatemain"][$i]["date_month"] = $date_month;
                    $categories_rooms_all["rate"][$array_rates[$j]]["intddatemain"][$i]["rate_id"] = $array_rates[$j];
                }
            }
        }
        
        // echo "<pre>";
        // print_r($categories_rooms_all);
        
        $categories_rooms_deskofdays_intdate = array();
        $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms, dc_booking_rooms_link.dc_room_id FROM `rooms`
		INNER JOIN categories ON categories.id = rooms.category_id
		INNER JOIN dc_booking_rooms_link ON dc_booking_rooms_link.category_id = categories.id
		INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
		INNER JOIN deskofreservation ON deskofreservation.id = deskofdays.reservation_id
		WHERE $select_room deskofreservation.deleted = 0 AND deskofreservation.cancel = 0 AND deskofdays.intdate >= $intdatein AND deskofdays.intdate <= $intdateout
		GROUP BY deskofdays.intdate, rooms.category_id";
        
        // echo $sql;
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $categories_rooms_deskofdays_intdate[$row->intdate]["category"][$row->dc_room_id]["notfree_count"] = $row->count_rooms;
            }
        }
        // echo "<pre>";
        // print_r ( $categories_rooms_deskofdays_intdate );
        for ($j = 0; $j < count($array_rates); $j ++) {
            for ($i = $intdatein; $i <= $intdateout; $i ++) {
                $array_category_keys = array_keys($categories_rooms_all["rate"][$array_rates[$j]]["intddatemain"][$i]["category"]);
                foreach ($array_category_keys as $category) {
                    
                    if (isset($categories_rooms_deskofdays_intdate[$i]["category"][$category]["notfree_count"])) {
                        $free_rooms = $categories_rooms_all["rate"][$array_rates[$j]]["intddatemain"][$i]["category"][$category]["count_rooms"] - $categories_rooms_deskofdays_intdate[$i]["category"][$category]["notfree_count"];
                        $categories_rooms_all["rate"][$array_rates[$j]]["intddatemain"][$i]["category"][$category]["free_day"] = $free_rooms;
                    }
                }
            }
        }
        // print_r ( $categories_rooms_all );
        // die ();
        return $categories_rooms_all;
    }

    function add_addons($data, $reservation_id = 0, $services_types_dc, $extracomponent_data = array())
    {
        echo "<pre>";
        print_r($data);
        foreach ($data as $addons) {
            print_r($addons);
            $this->db->where('dc_roomreservation_id', $addons['dc_roomreservation_id']);
            $this->db->delete('dc_booking_addons');
            break;
        }
		$dealer = 0;
		$query = $this->db->query ( "SELECT int_value FROM dc_booking_xml_cfg WHERE name LIKE 'dealer_id'" );
		
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$dealer = $row->int_value;
		}
		
		foreach ( $data as $addons ) {
			
			$this->db->insert ( 'dc_booking_addons', $addons );
			if ($reservation_id != 0) {
				$data_services = array ();
				$data_services ["dc_addons"] = 1;
				$data_services ["res_id"] = $reservation_id;
				$data_services ["dealer"] = $dealer;
				$data_services ['partner'] = 0;
				$query = $this->db->query ( "SELECT id FROM partners WHERE isdefault = 1" );
				
				if ($query->num_rows () > 0) {
					$row = $query->row ();
					$data_services ['partner'] = $row->id;
				}
				
				$data_services ["price"] = $addons ["price_per_unit"];
				$data_services ["amount"] = $addons ["totalprice"];
				$data_services ["description"] = $addons ["name"];
				$data_services ["count"] = $addons ["nights"];
				if (isset ( $services_types_dc [$addons ["type"]] )) {
					$data_services ["type"] = $services_types_dc [$addons ["type"]];
				} else {
					
					if ($addons ["type"] == - 3) {
						$data_services ["type"] = 3;
						$time = date ( "Y-m-d H:i:s" );
						$sql = "INSERT INTO `services_main` (reservation_id, 
                            id_dealer, 
                            amount, 
                            type, 
                            description, 
                            time)  VALUES (" . $data_services ["res_id"] . ", " . $data_services ["dealer"] . ", " . $this->frontdesk->tofloat ( $data_services ["amount"] ) . ", " . $data_services ["type"] . ",
				'" . addslashes ( $data_services ["description"] ) . "', '" . $time . "')";
						
						$query = $this->db->query ( $sql );
						
						return;
					} else {
						$query = $this->db->query ( "SELECT * FROM services_types ORDER by id ASC LIMIT 0, 1" );
						
						if ($query->num_rows () > 0) {
							$row = $query->row ();
							
							$data_services ["type"] = $row->id;
							// echo $row->name;
							// echo $row->body;
						} else {
							$data_services ["type"] = 0;
						}
					}
				}
				if ($data_services ["type"] != 0 and $data_services ["type"] != "") {
					$this->service_model->Insert_Service ( $data_services, 1 );
				}
			}
		}
		
		foreach ( $extracomponent_data as $addons ) {
			$query = $this->db->query ( "SELECT id FROM dc_booking_addons WHERE dc_roomreservation_id = ".$addons ["dc_roomreservation_id"]." 
			AND type = ".$addons ["type"] );
			
			if ($query->num_rows () > 0) {
				$row = $query->row ();
				
			}else{
				$new_addons_array = array ();
				$new_addons_array ["dc_roomreservation_id"] = $addons ["dc_roomreservation_id"];
				$new_addons_array ["name"] = $addons ["name"];
				$new_addons_array ["nights"] = $addons ["nights"];
				$new_addons_array ["persons"] = $addons ["persons"];
				$new_addons_array ["price_mode"] = $addons ["price_mode"];
				$new_addons_array ["price_per_unit"] = $addons ["price_per_unit"];
				$new_addons_array ["totalprice"] = $addons ["totalprice"];
				$new_addons_array ["type"] = $addons ["type"];
				$this->db->insert ( 'dc_booking_addons', $new_addons_array );
			}
			if ($reservation_id != 0) {
				$data_services = array ();
				$data_services ["res_id"] = $reservation_id;
				$data_services ["dealer"] = $dealer;
				
				$query = $this->db->query ( "SELECT id FROM partners WHERE isdefault = 1" );
				
				if ($query->num_rows () > 0) {
					$row = $query->row ();
					$data_services ['partner'] = $row->id;
				}
				
				$data_services ["extracomponent"] = $addons ["extracomponent"];
				
				$data_services ["price"] = $addons ["price_per_unit"];
				$data_services ["amount"] = $addons ["totalprice"];
				$data_services ["description"] = $addons ["name"];
				$data_services ["count"] = $addons ["nights"];
				
				$data_services ["type"] = $addons ["type"];
				
				if ($data_services ["type"] != 0 and $data_services ["type"] != "") {
					$this->service_model->Insert_Service ( $data_services, 1 );
				}
			}
		}
		
	}

    function del_addons($dc_roomreservation_id)
    {
        $this->db->where('dc_roomreservation_id', $dc_roomreservation_id);
        $this->db->delete('dc_booking_addons');
    }
    
    function del_extracomponent_from_services($hms_reservation_id)
    {
    	$sql = "DELETE FROM services WHERE reservation_id = ".$hms_reservation_id." AND extracomponent = 1";
    	echo $sql;
    	$query = $this->db->query($sql);
    }

    function options_save($data)
    {
        $dc_table_name = "dc_booking_xml_cfg";
        
        $data_1 = array();
        $data_1["general_update"] = $this->dc_model->get_dc_cfg_value($dc_table_name, "general_update", "int");
        $data_1["dealer_id"] = $this->dc_model->get_dc_cfg_value($dc_table_name, "dealer_id", "int");
        $data_1["overbooking_category_id"] = $this->dc_model->get_dc_cfg_value($dc_table_name, "overbooking_category_id", "int");
        $data_1["payment_type"] = $this->dc_model->get_dc_cfg_value($dc_table_name, "payment_type", "int");
        $data_1["extracomponent_type"] = $this->dc_model->get_dc_cfg_value($dc_table_name, "extracomponent_type", "int");
        
        $sql = "INSERT INTO dc_booking_xml_cfg (dc_account_id, name, int_value) VALUES(0, 'dealer_id', '" . $data["dealer"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data["dealer"];
        $query = $this->db->query($sql);
        $sql = "INSERT INTO dc_booking_xml_cfg (dc_account_id, name, int_value) VALUES(0, 'overbooking_category_id', '" . $data["overbooking_category"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data["overbooking_category"];
        $query = $this->db->query($sql);
        $sql = "INSERT INTO dc_booking_xml_cfg (dc_account_id, name, int_value) VALUES(0, 'general_update', '" . $data["general_update"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data["general_update"];
        $query = $this->db->query($sql);
        $sql = "INSERT INTO dc_booking_xml_cfg (dc_account_id, name, int_value) VALUES(0, 'extracomponent_type', '" . $data["extracomponent_type"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data["extracomponent_type"];
        $query = $this->db->query($sql);
        
        $sql = "INSERT INTO dc_booking_xml_cfg (dc_account_id, name, int_value) VALUES(0, 'payment_type', '" . $data ["payment_type"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["payment_type"];
        $query = $this->db->query ( $sql );
        
        $sql = "INSERT INTO dc_booking_xml_cfg (dc_account_id, name, int_value) VALUES(0, 'price_version', '" . $data ["price_version"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["price_version"];
        $query = $this->db->query ( $sql );
        
        $data_2 = array();
        $data_2["general_update"] = $this->dc_model->get_dc_cfg_value($dc_table_name, "general_update", "int");
        $data_2["dealer_id"] = $this->dc_model->get_dc_cfg_value($dc_table_name, "dealer_id", "int");
        $data_2["overbooking_category_id"] = $this->dc_model->get_dc_cfg_value($dc_table_name, "overbooking_category_id", "int");
        $data_2["payment_type"] = $this->dc_model->get_dc_cfg_value($dc_table_name, "payment_type", "int");
        $data_2["extracomponent_type"] = $this->dc_model->get_dc_cfg_value($dc_table_name, "extracomponent_type", "int");
        
        $this->Loger_admin->SaveLog($data_1, $data_2, "loger_admin", 0, "dc_booking_xml_cfg", "edit");
    }
	function setavailability_lastchanged_1_zero($hotel_id = 0) {
		$general_update = 0;
		$sql = "SELECT int_value FROM dc_booking_xml_cfg WHERE name LIKE 'general_update'";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$general_update = $row->int_value;
		}
		$data_return = array ();
		if ($general_update == 1) {
		} else {
			$data_return ["response"] = 2;
			return $data_return;
		}
		
		$min_date = 0;
		$max_date = 0;
		$categories_rooms_all = array ();
		$data_return = array ();
		$intdate_today = floor ( time () / 86400 );
		$last_id = 0;
		$last_time = time ();
		
		$sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms  FROM categories
    	INNER JOIN dc_log ON dc_log.categoryid = categories.id
    	LEFT JOIN rooms ON rooms.category_id = categories.id AND rooms.dc_active = 1
    	WHERE dc_log.dc_id = 1 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.intdate >= " . $intdate_today . "
				GROUP BY dc_log.categoryid, dc_log.intdate";
		$query = $this->db->query ( $sql );
		
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				// count_rooms_booking
				if ($min_date == 0) {
					$min_date = $row->log_intdate;
				} else {
					if ($row->log_intdate < $min_date) {
						$min_date = $row->log_intdate;
					}
				}
				
				if ($max_date == 0) {
					$max_date = $row->log_intdate;
				} else {
					if ($row->log_intdate > $max_date) {
						$max_date = $row->log_intdate;
					}
				}
				
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["free"] = $row->count_rooms;
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["date"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
				
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["from"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["to"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
				// $last_id = $row->dc_log_id;
				if ($row->dc_log_id > $last_id) {
					$last_id = $row->dc_log_id;
				}
			}
		} else {
			$data_return ["response"] = 3;
			return $data_return;
		}
		
		// echo "<pre>";
		// print_r ( $categories_rooms_all );
		// die();
		$categories_rooms_intdate = array ();
		
		$sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
    	FROM  `rooms`
    	INNER JOIN categories ON categories.id = rooms.category_id
    	INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
    	INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
    	dc_log.categoryid = rooms.category_id
    	WHERE dc_log.dc_id = 1 AND dc_log.dc_hotel_id = $hotel_id
    	GROUP BY deskofdays.intdate, rooms.category_id";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				// count_rooms_booking
				$categories_rooms_intdate [$row->id] [$row->intdate] ["free"] = $row->count_rooms;
			}
		}
		
		$datein_out_mass = $this->dc_model->get_datein_dateout_dc_log ( 1 );
		$overbooking_reservations_array = array ();
		if (isset ( $datein_out_mass ["intdatein"] )) {
			$overbooking_reservations_array = $this->dc_model->get_overbooking_origincat ( $datein_out_mass ["intdatein"], $datein_out_mass ["intdateout"] );
		}
		
		$setrestrict_result = "";
		$result = "";
		$sql = "SELECT int_value FROM dc_booking_xml_cfg WHERE name LIKE 'general_update'";
		$query = $this->db->query ( $sql );
		
		if ($general_update == 1) {
			$category_keys = array_keys ( $categories_rooms_all );
			foreach ( $category_keys as $category_id ) {
				
				$sql = "select min, max from dc_booking_rooms_link where category_id =" . $category_id;
				$query = $this->db->query ( $sql );
				if ($query->num_rows () > 0) {
					$row2 = $query->row ();
					$min = $row2->min;
					$max = $row2->max;
				} else {
					$min = 0;
					$max = 999;
				}
				
				$arr_intdate_keys = array_keys ( $categories_rooms_all [$category_id] );
				foreach ( $arr_intdate_keys as $intdate ) {
					
					$categories_rooms_all [$category_id] [$intdate] ["free"] = 0;
					
					if (true) {
						$prev = $intdate - 1;
						if (isset ( $categories_rooms_all [$category_id] [$prev] )) {
							$free_1 = $categories_rooms_all [$category_id] [$prev] ["free"];
							$free_2 = $categories_rooms_all [$category_id] [$intdate] ["free"];
							
							if ($free_1 == $free_2) {
								$categories_rooms_all [$category_id] [$intdate] ["from"] = $categories_rooms_all [$category_id] [$prev] ["from"];
								unset ( $categories_rooms_all [$category_id] [$prev] );
							}
						}
					}
				}
			}
			
			foreach ( $categories_rooms_all as $category_id => $intdates ) {
				foreach ( $intdates as $intdate => $cell ) {
					$todate = $categories_rooms_all [$category_id] [$intdate] ["to"];
					list ( $year, $month, $day ) = explode ( "-", $todate );
					$intdate_to = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
					
					$intdate_to = $intdate_to + 1;
					
					$categories_rooms_all [$category_id] [$intdate] ["to"] = gmdate ( "Y-m-d", $intdate_to * 86400 );
				}
			}
			
			$freeRooms = $categories_rooms_all;
			// print_r ( $freeRooms );
			$roomslist = array ();
			$sql = "SELECT dc_booking_rooms_link.*  FROM dc_booking_rooms_link WHERE dc_hotel_id = $hotel_id";
			$query = $this->db->query ( $sql );
			if ($query->num_rows () > 0) {
				foreach ( $query->result () as $row ) {
					if (isset ( $freeRooms [$row->category_id] )) {
						array_push ( $roomslist, array (
								'dc_room_id' => $row->dc_room_id,
								'dates' => $freeRooms [$row->category_id] 
						) );
					}
				}
			}
			echo "<pre>";
			print_r ( $roomslist );
			// echo count ( $roomslist );
			// die ("DEBUG dcm_booking.php 3184");
			
			if (count ( $roomslist ) < 1) {
				$query = $this->db->query ( "DELETE FROM dc_log WHERE dc_id = 1 AND dc_log.dc_hotel_id = $hotel_id" );
				$data_return ["response"] = 4;
				return $data_return;
			}
			$xml_data = array (
					'dcuser' => $this->config->item ( 'dc_booking_xml_user' ),
					'dcpwd' => $this->config->item ( 'dc_booking_xml_pwd' ),
					'hotel_id' => $hotel_id,
					'roomslist' => $roomslist 
			);
			$xml = $this->parser->parse ( 'templates/dc_booking_xml_availability_tpl_2.html', $xml_data, true );
			
			$url = $this->config->item ( 'dc_booking_xml_host' ) . "hotels/xml/availability";
			$data_result = $this->Curl_model->CurlPlugRAW ( $xml, $url, 1, array (
					"returntype" => "array" 
			) );
			
			$result = $data_result ["result"];
			$dc_log_id = $data_result ["dc_log_id"];
		}
		
		if ($general_update != 0)
			
			// $this->dc_model->Delete_dclog_last_data ( 1 );
			$data_return ["dc_log_id"] = $dc_log_id;
		$data_return ["datein"] = gmdate ( "Y-m-d", $min_date * 86400 );
		$data_return ["dateout"] = gmdate ( "Y-m-d", $max_date * 86400 );
		if ($general_update == 0) {
			echo "Ban upload for booking service";
		} else {
			
			if ((strpos ( $result, "<ok/>" ) === 0) || (strpos ( $result, "<ok></ok>" ) === 0)) {
				$data_return ["response"] = 1;
				$data_return ["responsebody"] = "success";
				$sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 1 AND dc_log.dc_hotel_id = $hotel_id AND time < " . $last_time;
				echo $sql;
				$query = $this->db->query ( $sql );
			} else {
				if ((strpos ( $result, "<warning>" ) === 0) && (strpos ( $result, "error" ) == FALSE)) {
					$data_return ["warning"] = 1;
					$query = $this->db->query ( "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 1 AND dc_log.dc_hotel_id = $hotel_id AND time < " . $last_time . " AND dc_log.dc_hotel_id = $hotel_id" );
				}
				$data_return ["response"] = 0;
				$data_return ["errmsg"] = $result;
				$data_return ["responsebody"] = $result;
				$query = $this->db->query ( "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 1 AND dc_log.dc_hotel_id = $hotel_id AND time < " . $last_time . " AND dc_log.dc_hotel_id = $hotel_id" );
			}
			
			return $data_return;
		}
	}

    function setavailability_lastchanged_1($hotel_id = 0, $last_time = 0)
    {
        
        $general_update = 0;
        $sql = "SELECT int_value FROM dc_booking_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $general_update = $row->int_value;
        }
        $data_return = array();
        if ($general_update == 1) {} else {
            $data_return["response"] = 2;
            return $data_return;
        }
        
        $min_date = 0;
        $max_date = 0;
        $categories_rooms_all = array();
        $data_return = array();
        $intdate_today = floor(time() / 86400);
        
        $last_id = 0;
        if($last_time == 0){
            $last_time = time();
        }
        
        /*
         * $sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms FROM categories
         * INNER JOIN dc_log ON dc_log.categoryid = categories.id
         * LEFT JOIN rooms ON rooms.category_id = categories.id
         * WHERE dc_log.dc_id = 1 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.intdate >= " . $intdate_today . "
         * GROUP BY dc_log.categoryid, dc_log.intdate";
         * echo $sql;
         * $query = $this->db->query($sql);
         *
         * if ($query->num_rows() > 0) {
         * foreach ($query->result() as $row) {
         * $categories_rooms_all[$row->category_id][$row->log_intdate]["free"] = 0;
         * $categories_rooms_all[$row->category_id][$row->log_intdate]["date"] = gmdate("Y-m-d", $row->log_intdate * 86400);
         *
         * $categories_rooms_all[$row->category_id][$row->log_intdate]["from"] = gmdate("Y-m-d", $row->log_intdate * 86400);
         * $categories_rooms_all[$row->category_id][$row->log_intdate]["to"] = gmdate("Y-m-d", $row->log_intdate * 86400);
         * }
         * if ($row->dc_log_id > $last_id) {
         * $last_id = $row->dc_log_id;
         * }
         * }
         * echo "<pre>--".$last_id."---";
         * print_r ( $categories_rooms_all );
         */
        // die();
        $sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms  FROM categories
				INNER JOIN dc_log ON dc_log.categoryid = categories.id
				LEFT JOIN rooms ON rooms.category_id = categories.id AND rooms.dc_active = 1
				WHERE dc_log.dc_id = 1 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.intdate >= " . $intdate_today . " 
				GROUP BY dc_log.categoryid, dc_log.intdate";
        $query = $this->db->query($sql);
//         echo $sql;
//         die();
        // echo "start wait\n";
        // sleep(15);
        // echo "done wait\n";
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                if ($min_date == 0) {
                    $min_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate < $min_date) {
                        $min_date = $row->log_intdate;
                    }
                }
                
                if ($max_date == 0) {
                    $max_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate > $max_date) {
                        $max_date = $row->log_intdate;
                    }
                }
                
                $categories_rooms_all[$row->category_id][$row->log_intdate]["free"] = $row->count_rooms;
                $categories_rooms_all[$row->category_id][$row->log_intdate]["date"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                
                $categories_rooms_all[$row->category_id][$row->log_intdate]["from"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                $categories_rooms_all[$row->category_id][$row->log_intdate]["to"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                // $last_id = $row->dc_log_id;
                if ($row->dc_log_id > $last_id) {
                    $last_id = $row->dc_log_id;
                }
            }
        } else {
            $data_return["response"] = 3;
            return $data_return;
        }
        
        // echo "<pre>";
        // print_r ( $categories_rooms_all );
        // die();
        $categories_rooms_intdate = array();
        
        $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
FROM  `rooms` 
INNER JOIN categories ON categories.id = rooms.category_id
INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND 
dc_log.categoryid = rooms.category_id 
WHERE dc_log.dc_id = 1 AND dc_log.dc_hotel_id = $hotel_id
GROUP BY deskofdays.intdate, rooms.category_id";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                $categories_rooms_intdate[$row->id][$row->intdate]["free"] = $row->count_rooms;
            }
        }
        
        // echo "<pre>";
        // print_r ( $categories_rooms_all );
        /*
         * $query = $this->db->query("SELECT int_value FROM dc_booking_xml_cfg WHERE name LIKE 'hotel_id'");
         * if ($query->num_rows() > 0) {
         * $row = $query->row();
         * $hotel_id = $row->int_value;
         * } else {
         * $hotel_id = "none";
         * }
         */
        /*
         * GET OVERBOOKING_RESERVATIONS_ARRAY
         */
        $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log(1);
        $overbooking_reservations_array = array();
        if (isset($datein_out_mass["intdatein"])) {
            $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat($datein_out_mass["intdatein"], $datein_out_mass["intdateout"]);
        }
        
        // echo "<pre>";
        // print_r($overbooking_reservations_array);
        // die();
        
        /*
         * END GET OVERBOOKING_RESERVATIONS_ARRAY
         */
        
        /*
         * Выгрузка загружености с booking
         */
        
        $setrestrict_result = "";
        $result = "";
        $sql = "SELECT int_value FROM dc_booking_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        
        if ($general_update == 1) {
            $category_keys = array_keys($categories_rooms_all);
            foreach ($category_keys as $category_id) {
                
                $sql = "select min, max from dc_booking_rooms_link where category_id =" . $category_id;
                $query = $this->db->query($sql);
                if ($query->num_rows() > 0) {
                    $row2 = $query->row();
                    $min = $row2->min;
                    $max = $row2->max;
                } else {
                    $min = 0;
                    $max = 999;
                }
                
                $arr_intdate_keys = array_keys($categories_rooms_all[$category_id]);
                foreach ($arr_intdate_keys as $intdate) {
                    if (isset($categories_rooms_intdate[$category_id][$intdate])) {
                        $count_overbook_rooms = 0;
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                        }
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
                    } else {
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                            $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $count_overbook_rooms;
                        }
                    }
                    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
                    } else {
                        $categories_rooms_all[$category_id][$intdate]["free"] = 0;
                    }
                    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $max;
                    }
                    
                    // коррекція к-сті відповідно умовам ф-ї availability_count_correction
                    $startdate = $enddate = date("Y-m-d", $intdate*86400);
                    $categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
                                        
                    if (true) {
                        $prev = $intdate - 1;
                        if (isset($categories_rooms_all[$category_id][$prev])) {
                            $free_1 = $categories_rooms_all[$category_id][$prev]["free"];
                            $free_2 = $categories_rooms_all[$category_id][$intdate]["free"];
                            
                            if ($free_1 == $free_2) {
                                $categories_rooms_all[$category_id][$intdate]["from"] = $categories_rooms_all[$category_id][$prev]["from"];
                                unset($categories_rooms_all[$category_id][$prev]);
                            }
                        }
                    }
                }
            }
            
            foreach ($categories_rooms_all as $category_id => $intdates) {
                foreach ($intdates as $intdate => $cell) {
                    $todate = $categories_rooms_all[$category_id][$intdate]["to"];
                    list ($year, $month, $day) = explode("-", $todate);
                    $intdate_to = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
                    
                    $intdate_to = $intdate_to + 1;
                    
                    $categories_rooms_all[$category_id][$intdate]["to"] = gmdate("Y-m-d", $intdate_to * 86400);
                }
            }
            
            $freeRooms = $categories_rooms_all;
            // print_r ( $freeRooms );
            $roomslist = array();
            $sql = "SELECT dc_booking_rooms_link.*  FROM dc_booking_rooms_link WHERE dc_hotel_id = $hotel_id";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                foreach ($query->result() as $row) {
                    if (isset($freeRooms[$row->category_id])) {
                        array_push($roomslist, array(
                            'dc_room_id' => $row->dc_room_id,
                            'dates' => $freeRooms[$row->category_id]
                        ));
                    }
                }
            }
             echo "<pre>";
             print_r ( $roomslist );
            // echo count ( $roomslist );
             //die ("DEBUG dcm_booking.php 3184");
            
            if (count($roomslist) < 1) {
                $query = $this->db->query("DELETE FROM dc_log WHERE dc_id = 1 AND dc_log.dc_hotel_id = $hotel_id");
                $data_return["response"] = 4;
                return $data_return;
            }
            $xml_data = array(
                'dcuser' => $this->config->item('dc_booking_xml_user'),
                'dcpwd' => $this->config->item('dc_booking_xml_pwd'),
                'hotel_id' => $hotel_id,
                'roomslist' => $roomslist
            );
            $xml = $this->parser->parse('templates/dc_booking_xml_availability_tpl_2.html', $xml_data, true);
            // echo $xml;
            // die ();
            $url = $this->config->item('dc_booking_xml_host') . "hotels/xml/availability";
            
            $data_result = $this->Curl_model->CurlPlugRAW($xml, $url, 1, array(
                "returntype" => "array"
            ));
            // $data_return ["responsebody"] = $result;
            $result = $data_result["result"];
            $dc_log_id = $data_result["dc_log_id"];
            // echo $result;
            // return $result;
        }
        
        if ($general_update != 0)
            
            // $this->dc_model->Delete_dclog_last_data ( 1 );
            $data_return["dc_log_id"] = $dc_log_id;
        $data_return["datein"] = gmdate("Y-m-d", $min_date * 86400);
        $data_return["dateout"] = gmdate("Y-m-d", $max_date * 86400);
        if ($general_update == 0) {
            echo "Ban upload for booking service";
        } else {
            
            //if ((strpos($result, "<ok/>") === 0) || (strpos($result, "<ok></ok>") === 0)) {
            if ((strpos ( $result, "<ok/>" ) > 0) || (strpos ( $result, "<ok></ok>" ) > 0)) {
                $data_return["response"] = 1;
                $data_return["responsebody"] = "success";
                $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 1 AND dc_log.dc_hotel_id = $hotel_id AND time < " . $last_time;
                echo $sql;
                $query = $this->db->query($sql);
            } else {
                if ((strpos($result, "<warning>") === 0) && (strpos($result, "error") == FALSE)) {
                    $data_return["warning"] = 1;
                    $query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 1 AND dc_log.dc_hotel_id = $hotel_id AND time < " . $last_time . " AND dc_log.dc_hotel_id = $hotel_id");
                }
                $data_return["response"] = 0;
                $data_return["errmsg"] = $result;
                $data_return["responsebody"] = $result;
                $query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 1 AND dc_log.dc_hotel_id = $hotel_id AND time < " . $last_time . " AND dc_log.dc_hotel_id = $hotel_id");
            }
            
            return $data_return;
        }
    }
    
    function setavailability_lastchanged_25($hotel_id = 0)
    {
        $general_update = 0;
        $sql = "SELECT int_value FROM dc_onetwotrip_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $general_update = $row->int_value;
        }
        $data_return = array();
        if ($general_update == 1) {} else {
            $data_return["response"] = 2;
            return $data_return;
        }
        
        $min_date = 0;
        $max_date = 0;
        $categories_rooms_all = array();
        $data_return = array();
        $intdate_today = floor(time() / 86400);
        $last_id = 0;
        $last_time = time();
        
        $sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms  FROM categories
				INNER JOIN dc_log ON dc_log.categoryid = categories.id
				LEFT JOIN rooms ON rooms.category_id = categories.id AND rooms.dc_active = 1
				WHERE dc_log.dc_id = 25 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.intdate >= " . $intdate_today . " 
				GROUP BY dc_log.categoryid, dc_log.intdate";
        $query = $this->db->query($sql);
       
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                if ($min_date == 0) {
                    $min_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate < $min_date) {
                        $min_date = $row->log_intdate;
                    }
                }
                
                if ($max_date == 0) {
                    $max_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate > $max_date) {
                        $max_date = $row->log_intdate;
                    }
                }
                
                $categories_rooms_all[$row->category_id][$row->log_intdate]["free"] = $row->count_rooms;
                $categories_rooms_all[$row->category_id][$row->log_intdate]["date"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                
                $categories_rooms_all[$row->category_id][$row->log_intdate]["from"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                $categories_rooms_all[$row->category_id][$row->log_intdate]["to"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                if ($row->dc_log_id > $last_id) {
                    $last_id = $row->dc_log_id;
                }
            }
        } else {
            $data_return["response"] = 3;
            return $data_return;
        }
        
        // echo "<pre>";
        // print_r ( $categories_rooms_all );
        // die();
        $categories_rooms_intdate = array();
        
        $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
FROM  `rooms` 
INNER JOIN categories ON categories.id = rooms.category_id
INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND 
dc_log.categoryid = rooms.category_id 
WHERE dc_log.dc_id = 25 AND dc_log.dc_hotel_id = ".$hotel_id."
GROUP BY deskofdays.intdate, rooms.category_id";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                $categories_rooms_intdate[$row->id][$row->intdate]["free"] = $row->count_rooms;
            }
        }
      
        /*
         * GET OVERBOOKING_RESERVATIONS_ARRAY
         */
        $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log(25);
        $overbooking_reservations_array = array();
        if (isset($datein_out_mass["intdatein"])) {
            $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat($datein_out_mass["intdatein"], $datein_out_mass["intdateout"]);
        }
     
        /*
         * END GET OVERBOOKING_RESERVATIONS_ARRAY
         */
        
        /*
         * Выгрузка загружености с booking
         */
        
        $setrestrict_result = "";
        $result = "";
        $sql = "SELECT int_value FROM dc_onetwotrip_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        
        if ($general_update == 1) {
            $category_keys = array_keys($categories_rooms_all);
            foreach ($category_keys as $category_id) {
                
                $sql = "select min, max from dc_onetwotrip_rooms_link where category_id =" . $category_id;
                $query = $this->db->query($sql);
                if ($query->num_rows() > 0) {
                    $row2 = $query->row();
                    $min = $row2->min;
                    $max = $row2->max;
                } else {
                    $min = 0;
                    $max = 999;
                }
                
                $arr_intdate_keys = array_keys($categories_rooms_all[$category_id]);
                foreach ($arr_intdate_keys as $intdate) {
                    if (isset($categories_rooms_intdate[$category_id][$intdate])) {
                        $count_overbook_rooms = 0;
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                        }
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
                    } else {
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                            $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $count_overbook_rooms;
                        }
                    }
                    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
                    } else {
                        $categories_rooms_all[$category_id][$intdate]["free"] = 0;
                    }
                    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $max;
                    }
                    
                    // коррекція к-сті відповідно умовам ф-ї availability_count_correction
                    $startdate = $enddate = date("Y-m-d", $intdate*86400);
                    $categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
                    
                    if (true) {
                        $prev = $intdate - 1;
                        if (isset($categories_rooms_all[$category_id][$prev])) {
                            $free_1 = $categories_rooms_all[$category_id][$prev]["free"];
                            $free_2 = $categories_rooms_all[$category_id][$intdate]["free"];
                            
                            if ($free_1 == $free_2) {
                                $categories_rooms_all[$category_id][$intdate]["from"] = $categories_rooms_all[$category_id][$prev]["from"];
                                unset($categories_rooms_all[$category_id][$prev]);
                            }
                        }
                    }
                }
            }
            
            foreach ($categories_rooms_all as $category_id => $intdates) {
                foreach ($intdates as $intdate => $cell) {
                    $todate = $categories_rooms_all[$category_id][$intdate]["to"];
                    list ($year, $month, $day) = explode("-", $todate);
                    $intdate_to = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
                    
                    $intdate_to = $intdate_to + 1;
                    
                    $categories_rooms_all[$category_id][$intdate]["to"] = gmdate("Y-m-d", $intdate_to * 86400);
                }
            }
            
            $freeRooms = $categories_rooms_all;
            // print_r ( $freeRooms );
            $roomslist = array();
            $sql = "SELECT dc_onetwotrip_rooms_link.*  FROM dc_onetwotrip_rooms_link WHERE dc_hotel_id = $hotel_id";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                foreach ($query->result() as $row) {
                    if (isset($freeRooms[$row->category_id])) {
                        array_push($roomslist, array(
                            'dc_room_id' => $row->dc_room_id,
                            'dates' => $freeRooms[$row->category_id]
                        ));
                    }
                }
            }
            //echo "<pre>";
            //print_r ( $roomslist );
            //die ('<br>DIED by Y Development Department of HMS IT TEAM<br>23 нояб. 2018 г.  18:15:36 <br>dcm_booking.php');
            
            if (count($roomslist) < 1) {
                $query = $this->db->query("DELETE FROM dc_log WHERE dc_id = 25 AND dc_log.dc_hotel_id = $hotel_id");
                $data_return["response"] = 4;
                return $data_return;
            }
            $xml_data = array(
                'roomslist' => $roomslist,
                'hotel_id' => $hotel_id
            );
            
            $xml = $this->parser->parse('templates/dc_onetwotrip_c2/dc_onetwotrip_xml_availability_tpl.html', $xml_data, true);           
            
            echo $xml;
            $authparam = $this->dcm_onetwotrip->getauthparam();
            $url = $authparam["url"]."availability";
            //$url = "https://sandbox-28.extranet.travel/chanman/v1/channel-managers/otel_ms/availability";
            echo $url;
            $data_result = $this->Curl_model->CurlPlugRAW_onetwotrip($xml, $url, array(
                "returntype" => "array"
            ), $authparam);
            $result = $data_result["result"];
            echo $result;

            $dc_log_id = $data_result["dc_log_id"];
            $data_return["dc_log_id"] = $dc_log_id;
            $data_return["datein"] = gmdate("Y-m-d", $min_date * 86400);
            $data_return["dateout"] = gmdate("Y-m-d", $max_date * 86400);

        }
        
        if ($general_update == 0) {
            echo "Ban upload for booking service";
        } else {
            if (strpos($result, "<ok></ok>") > 0) {
                $data_return["response"] = 1;
                $data_return["responsebody"] = "success";
                $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 25 AND dc_log.dc_hotel_id = $hotel_id AND time < " . $last_time;
                //echo $sql;
                $query = $this->db->query($sql);
            } else {
                if ((strpos($result, "<warning>") === 0) && (strpos($result, "error") == FALSE)) {
                    $data_return["warning"] = 1;
                    //$query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 25 AND dc_log.dc_hotel_id = $hotel_id AND time < " . $last_time . " AND dc_log.dc_hotel_id = $hotel_id");
                }
                $data_return["response"] = 0;
                $data_return["errmsg"] = $result;
                $data_return["responsebody"] = $result;
                $query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 25 AND dc_log.dc_hotel_id = $hotel_id AND time < " . $last_time . " AND dc_log.dc_hotel_id = $hotel_id");
            }
            
            return $data_return;
        }
    }
    
	function setavailability_lastchanged_21($hotel_id = 0) {
		$general_update = 0;
		$sql = "SELECT int_value FROM dc_cbooking_xml_cfg WHERE name LIKE 'general_update'";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$general_update = $row->int_value;
		}
		$data_return = array ();
		if ($general_update == 1) {
		} else {
			$data_return ["response"] = 2;
			return $data_return;
		}
		
		$params = $this->dcm_cbooking->getauthparam();
		
		$min_date = 0;
		$max_date = 0;
		$categories_rooms_all = array ();
		$data_return = array ();
		$intdate_today = floor ( time () / 86400 );
		$last_id = 0;
		$last_time = time ();
		
		$sql = "SELECT dc_cbooking_room_categories_link.dc_category_id, dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms 
		FROM categories
    	INNER JOIN dc_log ON dc_log.categoryid = categories.id
		INNER JOIN dc_cbooking_room_categories_link ON dc_cbooking_room_categories_link.hms_category_id = dc_log.categoryid
    	LEFT JOIN rooms ON rooms.category_id = categories.id AND rooms.dc_active = 1
    	WHERE dc_log.dc_id = 21 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.intdate >= " . $intdate_today . "
		GROUP BY dc_log.categoryid, dc_log.intdate";
		$query = $this->db->query ( $sql );
		// echo $sql;

		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				if ($min_date == 0) {
					$min_date = $row->log_intdate;
				} else {
					if ($row->log_intdate < $min_date) {
						$min_date = $row->log_intdate;
					}
				}
				
				if ($max_date == 0) {
					$max_date = $row->log_intdate;
				} else {
					if ($row->log_intdate > $max_date) {
						$max_date = $row->log_intdate;
					}
				}
				
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["dc_room_id"] = $row->dc_category_id;
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["currency"] = "RUB";
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["free"] = $row->count_rooms;
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["date"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
				
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["from"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["to"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
				// $last_id = $row->dc_log_id;
				if ($row->dc_log_id > $last_id) {
					$last_id = $row->dc_log_id;
				}
			}
		} else {
			$data_return ["response"] = 3;
			return $data_return;
		}
		
		$categories_rooms_intdate = array ();
		
		$sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
    	FROM  `rooms`
    	INNER JOIN categories ON categories.id = rooms.category_id
    	INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
    	INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
    	dc_log.categoryid = rooms.category_id
    	WHERE dc_log.dc_id = 21 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.dc_hotel_id = $hotel_id
    	GROUP BY deskofdays.intdate, rooms.category_id";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				// count_rooms_booking
				$categories_rooms_intdate [$row->id] [$row->intdate] ["free"] = $row->count_rooms;
			}
		}
		
		$datein_out_mass = $this->dc_model->get_datein_dateout_dc_log ( 1 );
		$overbooking_reservations_array = array ();
		if (isset ( $datein_out_mass ["intdatein"] )) {
			$overbooking_reservations_array = $this->dc_model->get_overbooking_origincat ( $datein_out_mass ["intdatein"], $datein_out_mass ["intdateout"] );
		}
		
		$setrestrict_result = "";
		$result = "";
		$sql = "SELECT int_value FROM dc_cbooking_xml_cfg WHERE name LIKE 'general_update'";
		$query = $this->db->query ( $sql );
		
		if ($general_update == 1) {
			$category_keys = array_keys ( $categories_rooms_all );
			foreach ( $category_keys as $category_id ) {
				
				$sql = "select min, max from dc_cbooking_room_categories_link where hms_category_id = " . $category_id;
				$query = $this->db->query ( $sql );
				if ($query->num_rows () > 0) {
					$row2 = $query->row ();
					$min = $row2->min;
					$max = $row2->max;
				} else {
					$min = 0;
					$max = 999;
				}
				
				$arr_intdate_keys = array_keys ( $categories_rooms_all [$category_id] );
				foreach ( $arr_intdate_keys as $intdate ) {
					if (isset ( $categories_rooms_intdate [$category_id] [$intdate] )) {
						$count_overbook_rooms = 0;
						if (isset ( $overbooking_reservations_array [$category_id] [$intdate] )) {
							$count_overbook_rooms = $overbooking_reservations_array [$category_id] [$intdate];
						}
						$categories_rooms_all [$category_id] [$intdate] ["free"] = $categories_rooms_all [$category_id] [$intdate] ["free"] - ($categories_rooms_intdate [$category_id] [$intdate] ["free"] + $count_overbook_rooms);
					} else {
						if (isset ( $overbooking_reservations_array [$category_id] [$intdate] )) {
							$count_overbook_rooms = $overbooking_reservations_array [$category_id] [$intdate];
							$categories_rooms_all [$category_id] [$intdate] ["free"] = $categories_rooms_all [$category_id] [$intdate] ["free"] - $count_overbook_rooms;
						}
					}
					
					if ($categories_rooms_all [$category_id] [$intdate] ["free"] > $min) {
						$categories_rooms_all [$category_id] [$intdate] ["free"] = $categories_rooms_all [$category_id] [$intdate] ["free"] - $min;
					} else {
						$categories_rooms_all [$category_id] [$intdate] ["free"] = 0;
					}
					
					if ($categories_rooms_all [$category_id] [$intdate] ["free"] > $max) {
						$categories_rooms_all [$category_id] [$intdate] ["free"] = $max;
					}
					
					// коррекція к-сті відповідно умовам ф-ї availability_count_correction
					$startdate = $enddate = date("Y-m-d", $intdate*86400);
					$categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
					
					if (true) {
						$prev = $intdate - 1;
						if (isset ( $categories_rooms_all [$category_id] [$prev] )) {
							$free_1 = $categories_rooms_all [$category_id] [$prev] ["free"];
							$free_2 = $categories_rooms_all [$category_id] [$intdate] ["free"];
							
							if ($free_1 == $free_2) {
								$categories_rooms_all [$category_id] [$intdate] ["from"] = $categories_rooms_all [$category_id] [$prev] ["from"];
								unset ( $categories_rooms_all [$category_id] [$prev] );
							}
						}
					}
				}
			}
			
			/*foreach ( $categories_rooms_all as $category_id => $intdates ) {
				foreach ( $intdates as $intdate => $cell ) {
					$todate = $categories_rooms_all [$category_id] [$intdate] ["to"];
					list ( $year, $month, $day ) = explode ( "-", $todate );
					$intdate_to = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
					
					$intdate_to = $intdate_to + 1;
					
					$categories_rooms_all [$category_id] [$intdate] ["to"] = gmdate ( "Y-m-d", $intdate_to * 86400 );
				}
			}
			*/
			
			//echo "<pre>";
			//print_r ( $categories_rooms_all );
			//die();
			$roomslist = array ();
			foreach ( $categories_rooms_all as $category_id => $dates ) {
				foreach ( $dates as $intdate => $cell ) {
					array_push ( $roomslist, array (
							'from' => $cell["from"],
							'to' => $cell["to"],
							'dc_room_id' => $cell["dc_room_id"],
							'currency' => $cell["currency"],
							'free' => $cell["free"]
					) );
				}
			}
				
			echo "<pre>";
			print_r ( $roomslist );
			
			if (count ( $roomslist ) < 1) {
				$query = $this->db->query ( "DELETE FROM dc_log WHERE dc_id = 21 AND dc_hotel_id = $hotel_id" );
				$data_return ["response"] = 4;
				return $data_return;
			}
			$xml_data = array (
					'dcuser' => $params["dcuser"],
					'dcpwd' => $params["dcpwd"],
					'dc_hotel_id' => $hotel_id,
					'roomslist' => $roomslist 
			);
			$xml = $this->parser->parse ( 'templates/xml/dc_cbooking_xml_availability_tpl.html', $xml_data, true );
			echo $xml;
			//die ();
			$url = "http://".$params['dcurl']."/hotelgateway/service.asmx";
			$url = "https://cbooking.ru/cm/Otelms";
			
			$request_xml = '<?xml version="1.0" encoding="utf-8"?>';
			$request_xml .= $xml;
			
			$headers = array(
					"Content-type: text/xml;charset=\"utf-8\"",
					"Accept: text/xml",
					"Cache-Control: no-cache",
					"Pragma: no-cache",
					"SOAPAction: http://cbooking.ru/UpdateAction",
					"Content-length: ".strlen($request_xml),
			);
			
			//$request_xml .= '';
			$data_result = $this->Curl_model->CurlPlugRAW_cbooking ( $request_xml, $url, $headers, array("returntype" => "array"));
			echo $data_result["result"];
			print_r ( $data_result );
			$dc_log_id = $data_result["dc_log_id"];
			
			$data_return["dc_log_id"] = $dc_log_id;
			$data_return["datein"] = gmdate("Y-m-d", $min_date * 86400);
			$data_return["dateout"] = gmdate("Y-m-d", $max_date * 86400);
			
			$sxe = new SimpleXMLElement($data_result["result"]);
			$result = $sxe->children('http://schemas.xmlsoap.org/soap/envelope/')->Body->children('http://cbooking.ru/');
			
			$result = json_decode ( json_encode ( $result ), 1 );
			
			print_r ( $result );
			$response_success = "";
			if (isset($result["UpdateActionResponse"] ["UpdateActionResult"]["success"])){
				$response_success = $result["UpdateActionResponse"] ["UpdateActionResult"]["success"];
			}
			
			
		}

		if ($general_update == 0) {
			echo "Ban upload for booking service";
		} else {
			if ($response_success == "true") {
				$data_return ["response"] = 1;
				$data_return ["responsebody"] = "success";
				$sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 21 AND dc_hotel_id = $hotel_id AND time < " . $last_time;
				$query = $this->db->query ( $sql );
			} else {
				$data_return ["response"] = 0;
				$data_return ["errmsg"] = $result['error'];
				$data_return ["responsebody"] = $result['error'];
				//$query = $this->db->query ( "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 21 AND time < " . $last_time );
			}
			return $data_return;
		}
	}
	
	function setavailability_lastchanged_22($input_data) {
	    //updating data on page loading
        $this->dcm_airbnb->validate_token();
	
	    $general_update = 0;
	    $sql = "SELECT int_value FROM dc_airbnb_xml_cfg WHERE name LIKE 'general_update'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $general_update = $row->int_value;
	    }
	    $data_return = array ();
	    if ($general_update == 1) {
	    } else {
	        $data_return ["response"] = 2;
	        return $data_return;
	    }
	
	    $restrict_rate_id = 0;
	    $sql = "SELECT int_value FROM dc_airbnb_xml_cfg WHERE name LIKE 'restrict_rate_id'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $restrict_rate_id = $row->int_value;
	    }
	    
	    $listingtocounry = array();
	    $sql = "SELECT dc_airbnb_listingtocategory.listing_id as dc_category_id, property_information.country
		FROM categories
		INNER JOIN dc_airbnb_listingtocategory ON dc_airbnb_listingtocategory.category_id = categories.id
	    INNER JOIN property_information ON property_information.id = categories.property_id";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            $listingtocounry [$row->dc_category_id] = $row->country;
	        }
	    }
	    
	    $importtolisting = array();
	    $sql = "SELECT import_id, listing_id FROM  dc_airbnb_importtolisting";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            $importtolisting [$row->listing_id] = $row->import_id;
	        }
	    }
	
	    $min_date = 0;
	    $max_date = 0;
	    $categories_rooms_all = array ();
	
	    $intdate_today = floor ( time () / 86400 );
	    $last_id = 0;
	    $last_time = time ();
	
	    $sql = "SELECT deskofrate.closed, dc_airbnb_listingtocategory.listing_id as dc_category_id, dc_log.id as dc_log_id, categories.id as category_id,
		dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms
		FROM categories
		INNER JOIN dc_log ON dc_log.categoryid = categories.id
		INNER JOIN dc_airbnb_listingtocategory ON dc_airbnb_listingtocategory.category_id = dc_log.categoryid
	    INNER JOIN dc_airbnb_listings ON dc_airbnb_listings.listing_id = dc_airbnb_listingtocategory.listing_id
		LEFT JOIN rooms ON rooms.category_id = categories.id AND rooms.dc_active = 1
		LEFT JOIN deskofrate ON deskofrate.category_id = categories.id AND dc_log.intdate = deskofrate.intdate AND deskofrate.rate_id = " . $restrict_rate_id . "
		WHERE dc_log.dc_id = 22 AND dc_log.intdate >= " . $intdate_today . "
		GROUP BY dc_log.categoryid, dc_log.intdate";
	    $query = $this->db->query ( $sql );
	    // echo $sql;
	
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
// 	            if(isset($importtolisting [$row->dc_category_id])){
// 	                if($importtolisting [$row->dc_category_id] > 0){
// 	                    continue;
// 	                }
// 	            }
	            
	            if ($min_date == 0) {
	                $min_date = $row->log_intdate;
	            } else {
	                if ($row->log_intdate < $min_date) {
	                    $min_date = $row->log_intdate;
	                }
	            }
	
	            if ($max_date == 0) {
	                $max_date = $row->log_intdate;
	            } else {
	                if ($row->log_intdate > $max_date) {
	                    $max_date = $row->log_intdate;
	                }
	            }
	
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["closed"] = $row->closed;
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["dc_room_id"] = $row->dc_category_id;
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["free"] = $row->count_rooms;
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["from"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["to"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );

	            if ($row->dc_log_id > $last_id) {
	                $last_id = $row->dc_log_id;
	            }
	        }
	    } else {
	        $sql = "DELETE FROM dc_log WHERE dc_id = 22";
	        $query = $this->db->query ( $sql );
	        
	        $data_return ["response"] = 3;
	        return $data_return;
	    }
	
	    $categories_rooms_intdate = array ();
	
	    $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
	    FROM  `rooms`
	    INNER JOIN categories ON categories.id = rooms.category_id
	    INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
	    INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
	    dc_log.categoryid = rooms.category_id
	    WHERE dc_log.dc_id = 22 
	    GROUP BY deskofdays.intdate, rooms.category_id";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            $categories_rooms_intdate [$row->id] [$row->intdate] ["free"] = $row->count_rooms;
	        }
	    }
	
	    $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log ( 1 );
	    $overbooking_reservations_array = array ();
	    if (isset ( $datein_out_mass ["intdatein"] )) {
	        $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat ( $datein_out_mass ["intdatein"], $datein_out_mass ["intdateout"] );
	    }
	
	    $setrestrict_result = "";
	    $result = "";
	    $sql = "SELECT int_value FROM dc_airbnb_xml_cfg WHERE name LIKE 'general_update'";
	    $query = $this->db->query ( $sql );
	
	    if ($general_update == 1) {
	        $category_keys = array_keys ( $categories_rooms_all );
	        $min = 0;
	        $max = 999;
	        foreach ( $category_keys as $category_id ) {
	            $arr_intdate_keys = array_keys ( $categories_rooms_all [$category_id] );
	            foreach ( $arr_intdate_keys as $intdate ) {
	                if ($categories_rooms_all[$category_id][$intdate]["closed"] == 1) {
	                    $categories_rooms_all[$category_id][$intdate]["free"] = 0;
	                } else {
	                    if (isset($categories_rooms_intdate[$category_id][$intdate])) {
	                        $count_overbook_rooms = 0;
	                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
	                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
	                        }
	                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
	                    } else {
	                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
	                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
	                            $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $count_overbook_rooms;
	                        }
	                    }
	
	                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
	                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
	                    } else {
	                        $categories_rooms_all[$category_id][$intdate]["free"] = 0;
	                    }
	
	                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
	                        $categories_rooms_all[$category_id][$intdate]["free"] = $max;
	                    }
	
	                    // коррекція к-сті відповідно умовам ф-ї availability_count_correction
	                    $startdate = $enddate = date("Y-m-d", $intdate*86400);
	                    $categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
	                }
	
	                if (!false) {
	                    $prev = $intdate - 1;
	                    if (isset ( $categories_rooms_all [$category_id] [$prev] )) {
	                        $free_1 = $categories_rooms_all [$category_id] [$prev] ["free"];
	                        $free_2 = $categories_rooms_all [$category_id] [$intdate] ["free"];
	
	                        if ($free_1 == $free_2) {
	                            $categories_rooms_all [$category_id] [$intdate] ["from"] = $categories_rooms_all [$category_id] [$prev] ["from"];
	                            unset ( $categories_rooms_all [$category_id] [$prev] );
	                        }
	                    }
	                }
	            }
	        }

	        //echo "<pre>";
	        //print_r ( $categories_rooms_all );
	        //die();
	        
	        if (count ( $categories_rooms_all ) < 1) {
	            $query = $this->db->query ( "DELETE FROM dc_log WHERE dc_id = 22" );
	            $data_return ["response"] = 4;
	            return $data_return;
	        }
	        // ================================================================
	        $user_id = $this->dcm_airbnb->getxmlcfgvalue('user_id', 'int');
	        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
	        
	        $authparam = $this->dcm_airbnb->authparam();
	        
	        $curl_auth_param = array();
	        $curl_auth_param['clientid'] = $authparam['clientid'];
	        $curl_auth_param['access_token'] = $access_token;
	        $request_result = 1;
	        $dbname = $input_data ['db_name'];
	        foreach ( $categories_rooms_all as $category_id => $category_dates ) {
	            $roomslist = array ();
	            $dates = array();
	            foreach ( $category_dates as $intdate => $cell ) {
	                $dc_room_id = $cell ["dc_room_id"];
                    //echo $listingtocounry[$dc_room_id];
	                if (isset($listingtocounry[$dc_room_id])) {
                        switch ($listingtocounry[$dc_room_id]) {
                            case "POL":
                                /*
								$availability = "available";
                                $availability_key = "availability";
                                if ($cell["free"] == 0) {
                                    $availability = "unavailable";
                                }
									*/
								$period = [
									'dates' => [
										$cell["from"] . ":" . $cell["to"]
									],
									'availability' => $cell["free"] > 0 ? 'available' : 'unavailable'
								];
								if ($cell["free"] == 0) {
                                    $period['busy_subtype'] = "OUTSIDE_RESERVATION";
                                }
								array_push($dates, $period);
                                /*
                                array_push($dates, array(
                                    'dates' => array(
                                        $cell["from"] . ":" . $cell["to"]
                                    ),
                                    $availability_key => $availability
                                ));
								*/
                                break;
                            case "UKR":
								/*
                                $availability = "available";
                                $availability_key = "availability";
                                if ($cell["free"] == 0) {
                                    $availability = "unavailable";
                                }
                                
                                array_push($dates, array(
                                    'dates' => array(
                                        $cell["from"] . ":" . $cell["to"]
                                    ),
                                    $availability_key => $availability
                                ));
								*/
								$period = [
									'dates' => [
										$cell["from"] . ":" . $cell["to"]
									],
									'availability' => $cell["free"] > 0 ? 'available' : 'unavailable'
								];
								if ($cell["free"] == 0) {
                                    $period['busy_subtype'] = "OUTSIDE_RESERVATION";
                                }
								array_push($dates, $period);
                                break;
                            default:
								/*
                                $availability = $cell["free"];
                                $availability_key = "available_count";
                                
                                $availability_key_2 = "availability";
                                $availability_2 = "available";
                                if ($cell["free"] == 0) {
                                    $availability_2 = "unavailable";
                                }
                                
                                array_push($dates, array(
                                    'dates' => array(
                                        $cell["from"] . ":" . $cell["to"]
                                    ),
                                    $availability_key => $availability,
                                    $availability_key_2 => $availability_2
                                ));
								*/
								$period = [
									'dates' => [
										$cell["from"] . ":" . $cell["to"]
									],
									'availability' => $cell["free"] > 0 ? 'available' : 'unavailable',
								];
								
								if ($cell["free"] == 0) {
                                    $period['busy_subtype'] = "OUTSIDE_RESERVATION";
                                } elseif( $cell['free'] > 0 ){
									$period['available_count'] = $cell["free"];
								}

								array_push($dates, $period);
                                break;
                        }
                    } else {
						/*
                        $availability = $cell["free"];
                        $availability_key = "available_count";
                        
                        $availability_key_2 = "availability";
                        $availability_2 = "available";
                        if ($cell["free"] == 0) {
                            $availability_2 = "unavailable";
                        }
                        
                        array_push($dates, array(
                            'dates' => array(
                                $cell["from"] . ":" . $cell["to"]
                            ),
                            $availability_key => $availability,
                            $availability_key_2 => $availability_2
                        ));
						*/
						$period = [
							'dates' => [
								$cell["from"] . ":" . $cell["to"]
							],
							'availability' => $cell["free"] > 0 ? 'available' : 'unavailable',
						];
						
						if ($cell["free"] == 0) {
							$period['busy_subtype'] = "OUTSIDE_RESERVATION";
						} elseif( $cell['free'] > 0 ){
							$period['available_count'] = $cell["free"];
						}

						array_push($dates, $period);
                    }
	                

// 	                array_push ( $dates, array (
// 	                    'dates' => array($cell ["date"].":".$cell ["date"]),
// 	                    $availability_key => $availability,
// 	                ) );
	            }
	            
	            $roomslist['listing_id'] = $dc_room_id;
	            $roomslist['operations'] = $dates;
	            
	            $json_request = json_encode ( $roomslist );
	            //echo "<pre>" . $json_request;
	            //print_r($roomslist);
	            //die();
	            
	            $pricing_model = @$this->db->select('pricing_model')->get_where('dc_airbnb_listings_details', array('listing_id' => $dc_room_id))->row()->pricing_model;
	            
	            $url = "https://api.airbnb.com/v2/calendar_operations_requests?_allow_dates_overlap=true";
	            
	            $method = "POST";
	            $airbnb_version = 1;
	            if($pricing_model == 'STANDARD'){
	                $airbnb_version = 2;
	                $url = "https://api.airbnb.com/v2/pricing_and_availability/standard/calendar_operations_requests?_allow_dates_overlap=true";
	                //$method = "PUT";
	            }
	            //echo $dc_room_id." --- ".$pricing_model." | ".$url." | ".$method."<br>";
	            $curl_auth_param ['airbnb_version'] = $airbnb_version;
	            $data_result = $this->curl_model->curl_airbnb_v2($json_request, $curl_auth_param, $url, array (
	                "returntype" => "array"
	            ), $method);
                    
                    // ===============================================================
                    
	            print_r($data_result);
	            
                $result_array = json_decode($data_result["result"], 1);
                $dc_log_id = $data_result["dc_log_id"];
                
                $data_return["dc_log_id"] = $dc_log_id;
                
                if (isset($result_array["success"])) {
                    if ($result_array["success"] == true) {
                        $data_return["response"] = 1;
                        $data_return["responsebody"] = "success";
                    } else {
                        $request_result = 0;
                        $data_return["response"] = 0;
                        $data_return["errmsg"] = $result_array['error_message'];
                        $data_return["responsebody"] = $result_array['error_message'];
                    }
                } else {
                    $request_result = 0;
                    $data_return["response"] = 0;
                    $data_return["errmsg"] = $result_array['error_message'];
                    $data_return["responsebody"] = $result_array['error_message'];
                }
                
                if ($data_return['response'] != 2 and $data_return['response'] != 3 and $data_return['response'] != 4 and ! isset($data_return['hrs_error'])) {
                    $datein_d = gmdate("Y-m-d", $min_date * 86400);
                    $dateout_d = gmdate("Y-m-d", $max_date * 86400);
                    $this->Loger_admin->Save_SyncData($datein_d, $dateout_d, print_r($data_return["responsebody"], true), 22, 2, $data_result["dc_log_id"]);
                }
                
                switch ($data_return['response']) {
                    case 1:
                        echo $dbname . " 22 passed.\n";
                        break;
                    case 2:
                        echo $dbname . " 22 skip.\n";
                        break;
                    case 3:
                        echo $dbname . " 22 no data.\n";
                        break;
                    case 4:
                        echo $dbname . " 22 passed no data.\n";
                        break;
                    default:
                        echo $dbname . " 22 error:\n";
                        print_r($data_return);
                        echo "\n";
                        if (isset($data_return["errmsg"])) {
                            $error_body = $data_return["errmsg"];
                        } else {
                            if (isset($data_return["responsebody"])) {
                                $error_body = $data_return["responsebody"];
                            } else {
                                $error_body = "";
                            }
                        }
                        $warning = 0;
                        
                        $this->dc_model->cron_dc_save_error($dbname, 22, $error_body);
                        
                        break;
                }
            }            
        }
	
	    if ($general_update == 0) {
	        echo "Ban upload for booking service";
	    } else {
	         if ($request_result == 1) {
	            $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 22 AND time < " . $last_time;
	            $query = $this->db->query ( $sql );
	        } else {
	            $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 22 AND time < " . $last_time;
	            $query = $this->db->query ( $sql );
	        }
	        return $data_return;
	    }
	}
	
	function setavailability_lastchanged_35() {

	    $general_update = 0;
	    $sql = "SELECT int_value FROM dc_avito_xml_cfg WHERE name LIKE 'general_update'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $general_update = $row->int_value;
	    }
	    $data_return = array ();
	    if ($general_update == 1) {
	    } else {
	        $data_return ["response"] = 2;
	        return $data_return;
	    }
	
	    $restrict_rate_id = 0;
	    $sql = "SELECT int_value FROM dc_avito_xml_cfg WHERE name LIKE 'restrict_rate_id'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $restrict_rate_id = $row->int_value;
	    }
	
	    $min_date = 0;
	    $max_date = 0;
	    $categories_rooms_all = array ();
	
	    $intdate_today = floor ( time () / 86400 );
	    $last_id = 0;
	    $last_time = time ();
	
	    $sql = "SELECT deskofrate.closed, dc_avito_room_categories_link.dc_room_id as dc_category_id, dc_log.id as dc_log_id, categories.id as category_id,
		dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms
		FROM categories
		INNER JOIN dc_log ON dc_log.categoryid = categories.id
		INNER JOIN dc_avito_room_categories_link ON dc_avito_room_categories_link.hms_category_id = dc_log.categoryid
		LEFT JOIN rooms ON rooms.category_id = categories.id AND rooms.dc_active = 1
		LEFT JOIN deskofrate ON deskofrate.category_id = categories.id AND dc_log.intdate = deskofrate.intdate AND deskofrate.rate_id = " . $restrict_rate_id . "
		WHERE dc_log.dc_id = 35 AND dc_log.intdate >= " . $intdate_today . "
		GROUP BY dc_log.categoryid, dc_log.intdate";
	    $query = $this->db->query ( $sql );
	    // echo $sql;
	
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            if ($min_date == 0) {
	                $min_date = $row->log_intdate;
	            } else {
	                if ($row->log_intdate < $min_date) {
	                    $min_date = $row->log_intdate;
	                }
	            }
	
	            if ($max_date == 0) {
	                $max_date = $row->log_intdate;
	            } else {
	                if ($row->log_intdate > $max_date) {
	                    $max_date = $row->log_intdate;
	                }
	            }
	
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["closed"] = $row->closed;
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["dc_room_id"] = $row->dc_category_id;
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["free"] = $row->count_rooms;
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["date"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	
	            if ($row->dc_log_id > $last_id) {
	                $last_id = $row->dc_log_id;
	            }
	        }
	    } else {
	        $data_return ["response"] = 3;
	        return $data_return;
	    }
	
	    $categories_rooms_intdate = array ();
	
	    $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
	    FROM  `rooms`
	    INNER JOIN categories ON categories.id = rooms.category_id
	    INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
	    INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
	    dc_log.categoryid = rooms.category_id
	    WHERE dc_log.dc_id = 35
	    GROUP BY deskofdays.intdate, rooms.category_id";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            $categories_rooms_intdate [$row->id] [$row->intdate] ["free"] = $row->count_rooms;
	        }
	    }
	
	    $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log ( 35 );
	    $overbooking_reservations_array = array ();
	    if (isset ( $datein_out_mass ["intdatein"] )) {
	        $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat ( $datein_out_mass ["intdatein"], $datein_out_mass ["intdateout"] );
	    }
	
	    $setrestrict_result = "";
	    $result = "";
	
	    if ($general_update == 1) {
	        $category_keys = array_keys ( $categories_rooms_all );
	        $min = 0;
	        $max = 999;
	        foreach ( $category_keys as $category_id ) {
	            $arr_intdate_keys = array_keys ( $categories_rooms_all [$category_id] );
	            foreach ( $arr_intdate_keys as $intdate ) {
	                if ($categories_rooms_all[$category_id][$intdate]["closed"] == 1) {
	                    $categories_rooms_all[$category_id][$intdate]["free"] = 0;
	                } else {
	                    if (isset($categories_rooms_intdate[$category_id][$intdate])) {
	                        $count_overbook_rooms = 0;
	                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
	                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
	                        }
	                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
	                    } else {
	                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
	                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
	                            $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $count_overbook_rooms;
	                        }
	                    }
	
	                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
	                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
	                    } else {
	                        $categories_rooms_all[$category_id][$intdate]["free"] = 0;
	                    }
	
	                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
	                        $categories_rooms_all[$category_id][$intdate]["free"] = $max;
	                    }
	
	                    // коррекція к-сті відповідно умовам ф-ї availability_count_correction
	                    $startdate = $enddate = date("Y-m-d", $intdate*86400);
	                    $categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
	                }
	
	            }
	        }
	        echo "<pre>";
	        print_r ( $categories_rooms_all );
	        
	        
	        $user_data = $this->dcm_avito->get_user();
	        $user_id = $user_data['user_id'];
	        
	        
	        foreach ( $categories_rooms_all as $category_id => $category_dates ) {
	            $avail_array = array();
	            foreach ( $category_dates as $intdate => $cell ) {
	                $listing = $cell ["dc_room_id"];
	                if($cell ["free"] == 0 ){
	                    $avail_array [$intdate]['date_start'] = $cell ["date"];
	                    $avail_array [$intdate]['date_end'] = $cell ["date"];
	                    if (1) {
	                        $prev = $intdate - 1;
	                        if (isset($avail_array[$prev])) {
	                            $avail_array[$intdate]["date_start"] = $avail_array[$prev]["date_start"];
	                            unset($avail_array[$prev]);
	                        }
	                    }
	                }
                    
                }
                
                $curl_data = array();
                $curl_data ['bookings'] = array();
                foreach ( $avail_array as $cell ) {
                    array_push($curl_data ['bookings'], $cell);
                }
                echo "<pre>";
                print_r ( $curl_data );
                //die();
                $url = "https://api.avito.ru/core/v1/accounts/$user_id/items/$listing/bookings";
                $data_result = $this->curl_model->CurlPlugRAW_avito($url, $curl_data, $hms_id, array (
                    "returntype" => "array"
                ));
                echo '<pre>';
                print_r(array($url, json_encode($curl_data), $data_result['result']));
                
//                 echo "<pre>";
//                 print_r ( $data_result );
                die();
	        }

	        echo "<pre>" . json_encode($roomslist);
	        print_r($roomslist);
	        //die();
	        if (count ( $roomslist ) < 1) {
	            $query = $this->db->query ( "DELETE FROM dc_log WHERE dc_id = 35" );
	            $data_return ["response"] = 4;
	            return $data_return;
	        }
	
	        $json_request = json_encode ( $roomslist );
	        echo "<br>".$json_request."<br>";;
	
	        // ================================================================
	        
	        
	        // ================================================================
	
	        $url = "https://api.avito.ru/core/v1/accounts/$user/items/$listing/bookings";
	        $data_result = $this->curl_model->CurlPlugRAW_avito($url, $curl_data, array (
	            "returntype" => "array"
	        ));
	
	        $result_array = json_decode ( $data_result ["result"], 1 );
	
	        //echo $data_result ["result"]."++++";
	        print_r ( $data_result );
	        print_r ( $result_array );
	        die();
	        $dc_log_id = $data_result ["dc_log_id"];
	
	        $data_return ["dc_log_id"] = $dc_log_id;
	        $data_return ["datein"] = gmdate ( "Y-m-d", $min_date * 86400 );
	        $data_return ["dateout"] = gmdate ( "Y-m-d", $max_date * 86400 );
	
	    }
	
	    if ($general_update == 0) {
	        echo "Ban upload for booking service";
	    } else {
	        if ($result_array["success"] == true) {
	            $data_return ["response"] = 1;
	            $data_return ["responsebody"] = "success";
	            $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 35 AND time < " . $last_time;
	            $query = $this->db->query ( $sql );
	        } else {
	            $data_return ["response"] = 0;
	            $data_return ["errmsg"] = $result_array ['error'];
	            $data_return ["responsebody"] = $result_array ['error'];
	        }
	        return $data_return;
	    }
	}
	
	function setavailability_lastchanged_35_v2($db_name) {
	    $general_update = 0;
	    $sql = "SELECT int_value FROM dc_avito_xml_cfg WHERE name LIKE 'general_update'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $general_update = $row->int_value;
	    }
	    $data_return = array ();
	    if ($general_update == 1) {
	    } else {
	        $data_return ["response"] = 2;
	        return $data_return;
	    }
	
	    $restrict_rate_id = 0;
	    $sql = "SELECT int_value FROM dc_avito_xml_cfg WHERE name LIKE 'restrict_rate_id'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $restrict_rate_id = $row->int_value;
	    }
	
	    $date_today = date("Y-m-d");
	    $date_end = date("Y-m-d", strtotime("+1 year"));
	    list ( $year, $month, $day ) = explode ( "-", $date_today );
	    $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	    list ( $year, $month, $day ) = explode ( "-", $date_end );
	    $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	
	    $deskofrate = array();
	    $sql = "SELECT deskofrate.closed, dc_avito_room_categories_link.dc_room_id as dc_category_id, categories.id as category_id,
		deskofrate.intdate
		FROM categories
		INNER JOIN dc_avito_room_categories_link ON dc_avito_room_categories_link.hms_category_id = categories.id
		LEFT JOIN deskofrate ON deskofrate.category_id = categories.id AND deskofrate.rate_id = " . $restrict_rate_id . "
		WHERE deskofrate.intdate >= " . $intdatein ." AND deskofrate.intdate <= $intdateout";
	    // 	    echo $sql;
	    // 	    die();
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            $deskofrate[$row->category_id][$row->intdate]['closed'] = $row->closed;
	        }
	    }
	
	    $min_date = 0;
	    $max_date = 0;
	    $categories_rooms_all = array ();
	
	    $intdate_today = floor ( time () / 86400 );
	    $last_id = 0;
	    $last_time = time ();
	    $globsl_deskofdays_availibility = array();
	    $deskofdays_availibility_counter = 0;
	    //echo "++++".$general_update;
	    if ($general_update == 1) {
	        $hms_to_dc_categories = array();
	        $sql = "SELECT dc_avito_room_categories_link.dc_room_id as dc_category_id, categories.id as category_id
		            FROM dc_avito_room_categories_link
		            INNER JOIN categories ON dc_avito_room_categories_link.hms_category_id = categories.id
                    INNER JOIN dc_log ON dc_log.categoryid = categories.id AND dc_log.dc_id = 35
                    GROUP BY dc_avito_room_categories_link.dc_room_id";
	        $query = $this->db->query($sql);
	        if ($query->num_rows() > 0) {
	            foreach ($query->result() as $row) {
	                $deskofdays_availibility = $this->frontdesk_c2->get_deskofdays_availibility($date_today, $date_end, $row->category_id, 1);
	                if (isset($deskofdays_availibility[$row->category_id])) {
	                    $globsl_deskofdays_availibility[$row->category_id] = $deskofdays_availibility[$row->category_id];
	
	                    $hms_to_dc_categories[$row->category_id] = $row->dc_category_id;
	
	                    if (count($deskofdays_availibility[$row->category_id]) > 0) {
	                        $deskofdays_availibility_counter = 1;
	                    }
	                }
	            }
	        }
	
	        //echo "<pre>";
	        //print_r($deskofdays_availibility);
	        //print_r($globsl_deskofdays_availibility);
	        //print_r($hms_to_dc_categories);
	        // 	        die();
	
	        if ($deskofdays_availibility_counter == 0) {
	            $query = $this->db->query("DELETE FROM dc_log WHERE dc_id = 35");
	            $data_return["response"] = 4;
	            return $data_return;
	        }
	
	        $user_data = $this->dcm_avito->get_user();
	        $user_id = $user_data['user_id'];
	        $global_result = true;
	        foreach ($globsl_deskofdays_availibility as $category_id => $category_dates) {
	            $avail_array = array();
	            $listing = 0;
	            foreach ($category_dates as $intdate => $free) {
	                $listing = $hms_to_dc_categories[$category_id];
	                if(isset($deskofrate[$category_id][$intdate])){
	                    $closed = $deskofrate[$category_id][$intdate]['closed'];
	                    if($closed == 1){
	                        $free = 0;
	                    }
	                }
	
	                if ($free <= 0) {
	                    $avail_array[$intdate]['date_start'] = date('Y-m-d', $intdate * 86400);
	                    $avail_array[$intdate]['date_end'] = date('Y-m-d', ($intdate + 1) * 86400);
	                    if (1) {
	                        $prev = $intdate - 1;
	                        if (isset($avail_array[$prev])) {
	                            $avail_array[$intdate]["date_start"] = $avail_array[$prev]["date_start"];
	                            unset($avail_array[$prev]);
	                        }
	                    }
	                }
	            }
	
	            $curl_data = array();
	            $curl_data['bookings'] = array();
	            foreach ($avail_array as $cell) {
	                array_push($curl_data['bookings'], $cell);
	            }
	            if ($listing > 0) {
	                //if ($listing == 2613846248) {
	
	                echo "<pre>";
	                print_r($curl_data);
	                // die();
	                //}
	                $url = "https://api.avito.ru/core/v1/accounts/$user_id/items/$listing/bookings";
	                $data_result = $this->curl_model->CurlPlugRAW_avito($url, $curl_data, 0, array(
	                    "returntype" => "array"
	                ), 0, $listing);
	                echo '<pre>';
	                print_r(array(
	                    $url,
	                    json_encode($curl_data),
	                    $data_result['result']
	                ));
	
	                $result_array = json_decode($data_result["result"], 1);
	                $errmsg = "";
                    if ($result_array['result'] != "success") {
                        if (isset($result_array['result']['status'])) {
                            if ($result_array['result']['status'] == false) {
                                if ($result_array['result']['message'] == 'Bad bearer token') {
                                    $sql = "DELETE FROM dc_log WHERE dc_id = 35";
                                    $query = $this->db->query($sql);
                                }
                                
                                $errmsg = $result_array['result']['message'];
                                $responsebody = "LISTING: " . $listing . " " . $result_array['result']['message'];
                            }
                        }
                        
                        $response_state = 0;
                        if (isset($result_array['error']['message'])) {
                            $errmsg = $result_array['error']['message'];
                            $responsebody = "LISTING: " . $listing . " " . $result_array['error']['message'];
                        }
	                } else {
	                    $sql = "DELETE FROM dc_log WHERE dc_id = 35 AND categoryid = " . $category_id;
	                    // echo $sql;
	                    $query = $this->db->query($sql);
	                    $response_state = 1;
	                    $errmsg = "";
	                    $responsebody = "LISTING: " . $listing . " " . $data_result['result'];
	                }
	
	                switch ($response_state) {
	                    case 1:
	                        echo $db_name . " 35 passed.\n";
	                        break;
	                    case 2:
	                        echo $db_name . " 35 skip.\n";
	                        break;
	                    case 3:
	                        echo $db_name . " 35 no data.\n";
	                        break;
	                    case 4:
	                        echo $db_name . " 35 passed no data.\n";
	                        break;
	                    default:
	                        echo $db_name . " 35 error:\n";
	                        echo $responsebody;
	                        echo "\n";
	
	                        $this->dc_save_error(35, $responsebody, $db_name, 0);
	
	                        break;
	                }
	
	                $dc_log_id = $data_result["dc_log_id"];
	                if ($response_state != 2 and $response_state != 3 and $response_state != 4 and ! isset($return_data['hrs_error'])) {
	                    $this->Loger_admin->Save_SyncData("", "", $responsebody, 35, 2, $dc_log_id);
	                }
	            }
	            // die();
	        }
	
	
	
	        //             $data_return["dc_log_id"] = $dc_log_id;
	        //             $data_return["datein"] = gmdate("Y-m-d", $min_date * 86400);
	        //             $data_return["dateout"] = gmdate("Y-m-d", $max_date * 86400);
	    }
	
	    // 	    if ($general_update == 0) {
	    // 	        echo "Ban upload for booking service";
	    // 	    } else {
	    // 	        if ($global_result == true) {
	    // 	            $data_return ["response"] = 1;
	    // 	            $data_return ["responsebody"] = "success";
	    // 	            $sql = "DELETE FROM dc_log WHERE dc_id = 35 AND time < " . $last_time;
	    // 	            $query = $this->db->query ( $sql );
	    // 	        } else {
	    // 	            $data_return ["response"] = 0;
	    // 	            $data_return ["errmsg"] = $result_array ['error'];
	    // 	            $data_return ["responsebody"] = $result_array ['error'];
	    // 	        }
	    // 	        return $data_return;
	    // 	    }
	}
	
	function setavailability_lastchanged_24($dc_account_id = 0) {


		$authparam = $this->dcm_axistravel->getauthparam($dc_account_id);
		$hotel_id = $authparam ["hotel_auth_hotel_id"];
		
		$general_update = 0;
		$sql = "SELECT int_value FROM dc_axis_travel_xml_cfg WHERE name LIKE 'general_update'";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$general_update = $row->int_value;
		}
		$data_return = array ();
		if ($general_update == 1) {
		} else {
			$data_return ["response"] = 2;
			return $data_return;
		}
		
		$restrict_rate_id = 0;
		$sql = "SELECT int_value FROM dc_axis_travel_xml_cfg WHERE name LIKE 'restrict_rate_id'";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
		    $row = $query->row ();
		    $restrict_rate_id = $row->int_value;
		}
		
		$min_date = 0;
		$max_date = 0;
		$categories_rooms_all = array ();

		$intdate_today = floor ( time () / 86400 );
		$last_id = 0;
		$last_time = time ();
		
		$sql = "SELECT deskofrate.closed, dc_axis_travel_room_categories_link.dc_category_id, dc_log.id as dc_log_id, categories.id as category_id, 
		dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms
		FROM categories
		INNER JOIN dc_log ON dc_log.categoryid = categories.id
		INNER JOIN dc_axis_travel_room_categories_link ON dc_axis_travel_room_categories_link.hms_category_id = dc_log.categoryid
		LEFT JOIN rooms ON rooms.category_id = categories.id AND rooms.dc_active = 1
		LEFT JOIN deskofrate ON deskofrate.category_id = categories.id AND dc_log.intdate = deskofrate.intdate AND deskofrate.rate_id = " . $restrict_rate_id . "
		WHERE dc_log.dc_id = 24 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.intdate >= " . $intdate_today . "
		GROUP BY dc_log.categoryid, dc_log.intdate";
		$query = $this->db->query ( $sql );
		// echo $sql;
		
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				if ($min_date == 0) {
					$min_date = $row->log_intdate;
				} else {
					if ($row->log_intdate < $min_date) {
						$min_date = $row->log_intdate;
					}
				}
				
				if ($max_date == 0) {
					$max_date = $row->log_intdate;
				} else {
					if ($row->log_intdate > $max_date) {
						$max_date = $row->log_intdate;
					}
				}
				
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["closed"] = $row->closed;
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["dc_room_id"] = $row->dc_category_id;
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["currency"] = "RUB";
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["free"] = $row->count_rooms;
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["date"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
				
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["from"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["to"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
				// $last_id = $row->dc_log_id;
				if ($row->dc_log_id > $last_id) {
					$last_id = $row->dc_log_id;
				}
			}
		} else {
			$data_return ["response"] = 3;
			return $data_return;
		}
		
		$categories_rooms_intdate = array ();
		
		$sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
			FROM  `rooms`
			INNER JOIN categories ON categories.id = rooms.category_id
			INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
			INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
			dc_log.categoryid = rooms.category_id
			WHERE dc_log.dc_id = 24 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.dc_hotel_id = $hotel_id
			GROUP BY deskofdays.intdate, rooms.category_id";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				// count_rooms_booking
				$categories_rooms_intdate [$row->id] [$row->intdate] ["free"] = $row->count_rooms;
			}
		}
		
		$datein_out_mass = $this->dc_model->get_datein_dateout_dc_log ( 1 );
		$overbooking_reservations_array = array ();
		if (isset ( $datein_out_mass ["intdatein"] )) {
			$overbooking_reservations_array = $this->dc_model->get_overbooking_origincat ( $datein_out_mass ["intdatein"], $datein_out_mass ["intdateout"] );
		}
		
		$setrestrict_result = "";
		$result = "";
		$sql = "SELECT int_value FROM dc_axis_travel_xml_cfg WHERE name LIKE 'general_update'";
		$query = $this->db->query ( $sql );
		
		if ($general_update == 1) {
			$category_keys = array_keys ( $categories_rooms_all );
			foreach ( $category_keys as $category_id ) {
				
				$sql = "select min, max from dc_axis_travel_room_categories_link where hms_category_id = " . $category_id;
				$query = $this->db->query ( $sql );
				if ($query->num_rows () > 0) {
					$row2 = $query->row ();
					$min = $row2->min;
					$max = $row2->max;
				} else {
					$min = 0;
					$max = 999;
				}
				
				$arr_intdate_keys = array_keys ( $categories_rooms_all [$category_id] );
				foreach ( $arr_intdate_keys as $intdate ) {
				    if ($categories_rooms_all[$category_id][$intdate]["closed"] == 1) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = 0;
                    } else {
                        if (isset($categories_rooms_intdate[$category_id][$intdate])) {
                            $count_overbook_rooms = 0;
                            if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                                $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                            }
                            $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
                        } else {
                            if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                                $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                                $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $count_overbook_rooms;
                            }
                        }
                        
                        if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
                            $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
                        } else {
                            $categories_rooms_all[$category_id][$intdate]["free"] = 0;
                        }
                        
                        if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
                            $categories_rooms_all[$category_id][$intdate]["free"] = $max;
                        }
                        
                        // коррекція к-сті відповідно умовам ф-ї availability_count_correction
                        $startdate = $enddate = date("Y-m-d", $intdate*86400);
                        $categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
                    }
					
					if (true) {
						$prev = $intdate - 1;
						if (isset ( $categories_rooms_all [$category_id] [$prev] )) {
							$free_1 = $categories_rooms_all [$category_id] [$prev] ["free"];
							$free_2 = $categories_rooms_all [$category_id] [$intdate] ["free"];
							
							if ($free_1 == $free_2) {
								$categories_rooms_all [$category_id] [$intdate] ["from"] = $categories_rooms_all [$category_id] [$prev] ["from"];
								unset ( $categories_rooms_all [$category_id] [$prev] );
							}
						}
					}
				}
			}
			
			/*
			 * foreach ( $categories_rooms_all as $category_id => $intdates ) { foreach ( $intdates as $intdate => $cell ) { $todate = $categories_rooms_all [$category_id] [$intdate] ["to"]; list ( $year, $month, $day ) = explode ( "-", $todate ); $intdate_to = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 ); $intdate_to = $intdate_to + 1; $categories_rooms_all [$category_id] [$intdate] ["to"] = gmdate ( "Y-m-d", $intdate_to * 86400 ); } }
			 */
			
			// echo "<pre>";
			// print_r ( $categories_rooms_all );
			// die();
			$roomslist = array ();
			foreach ( $categories_rooms_all as $category_id => $dates ) {
				foreach ( $dates as $intdate => $cell ) {
					array_push ( $roomslist, array (
							'startDateYmd' => $cell ["from"],
							'endDateYmd' => $cell ["to"],
							'roomTypeId' => $cell ["dc_room_id"],
							'quota' => (string) $cell ["free"]
					) );
				}
			}
			
			echo "<pre>";
			print_r ( $roomslist );
			
			if (count ( $roomslist ) < 1) {
				$query = $this->db->query ( "DELETE FROM dc_log WHERE dc_id = 24 AND dc_hotel_id = $hotel_id" );
				$data_return ["response"] = 4;
				return $data_return;
			}
			
			$request = array ();
			$request ["username"] = $authparam ["hotel_auth_user"];
			$request ["password"] = $authparam ["hotel_auth_password"];
			$request ["action"] = "update";
			$request ["data"] ["hotelId"] = $authparam ["hotel_auth_hotel_id"];
			$request ["data"] ["updates"] = $roomslist;
			print_r ( $request );
			$json_request = json_encode ( $request );
			echo "<br>".$json_request."<br>";;
			$url = $authparam ["url"];
			$data_result = $this->Curl_model->CurlPlugRaw_axis_travel ( $json_request, $url, array("returntype" => "array") );
			
			$result_array = json_decode ( $data_result ["result"], 1 );
			
			echo $data_result ["result"]."++++";
			print_r ( $data_result );
			$dc_log_id = $data_result ["dc_log_id"];
			
			$data_return ["dc_log_id"] = $dc_log_id;
			$data_return ["datein"] = gmdate ( "Y-m-d", $min_date * 86400 );
			$data_return ["dateout"] = gmdate ( "Y-m-d", $max_date * 86400 );
			
			//$result = json_decode ( json_encode ( $data_result ["result"] ), 1 );
			
		}
		
		if ($general_update == 0) {
			echo "Ban upload for booking service";
		} else {
		    if ($result_array["success"] == true) {
				$data_return ["response"] = 1;
				$data_return ["responsebody"] = "success";
				$sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 24 AND dc_hotel_id = $hotel_id AND time < " . $last_time;
				$query = $this->db->query ( $sql );
			} else {
				$data_return ["response"] = 0;
				$data_return ["errmsg"] = $result_array ['error'];
				$data_return ["responsebody"] = $result_array ['error'];
				// $query = $this->db->query ( "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 21 AND time < " . $last_time );
			}
			return $data_return;
		}
	}

	function setavailability_lastchanged_29($dc_account_id = 0) {
	    $authparam = $this->dcm_nashtravel->getauthparam($dc_account_id);
	    $hotel_id = $authparam ["hotel_id"];
	
	    $general_update = 0;
	    $sql = "SELECT int_value FROM dc_nash_travel_xml_cfg WHERE name LIKE 'general_update'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $general_update = $row->int_value;
	    }
	    $data_return = array ();
	    if ($general_update == 1) {
	    } else {
	        $data_return ["response"] = 2;
	        return $data_return;
	    }
	
	    $restrict_rate_id = 0;
	    $sql = "SELECT int_value FROM dc_nash_travel_xml_cfg WHERE name LIKE 'restrict_rate_id'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $restrict_rate_id = $row->int_value;
	    }
	
	    $min_date = 0;
	    $max_date = 0;
	    $categories_rooms_all = array ();
	
	    $intdate_today = floor ( time () / 86400 );
	    $last_id = 0;
	    $last_time = time ();
	
	    $sql = "SELECT deskofrate.closed, dc_nash_travel_room_categories_link.dc_category_id, dc_log.id as dc_log_id, categories.id as category_id,
		dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms
		FROM categories
		INNER JOIN dc_log ON dc_log.categoryid = categories.id
		INNER JOIN dc_nash_travel_room_categories_link ON dc_nash_travel_room_categories_link.hms_category_id = dc_log.categoryid
		LEFT JOIN rooms ON rooms.category_id = categories.id AND rooms.dc_active = 1
		LEFT JOIN deskofrate ON deskofrate.category_id = categories.id AND dc_log.intdate = deskofrate.intdate AND deskofrate.rate_id = " . $restrict_rate_id . "
			WHERE dc_log.dc_id = 29 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.intdate >= " . $intdate_today . "
		GROUP BY dc_log.categoryid, dc_log.intdate";
	    $query = $this->db->query ( $sql );
	    // echo $sql;
	
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            if ($min_date == 0) {
	                $min_date = $row->log_intdate;
	            } else {
	                if ($row->log_intdate < $min_date) {
	                    $min_date = $row->log_intdate;
	                }
	            }
	
	            if ($max_date == 0) {
	                $max_date = $row->log_intdate;
	            } else {
	                if ($row->log_intdate > $max_date) {
	                    $max_date = $row->log_intdate;
	                }
	            }
	
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["closed"] = $row->closed;
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["dc_room_id"] = $row->dc_category_id;
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["currency"] = "RUB";
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["free"] = $row->count_rooms;
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["date"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	
	            //$categories_rooms_all [$row->category_id] [$row->log_intdate] ["from"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	            //$categories_rooms_all [$row->category_id] [$row->log_intdate] ["to"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	            // $last_id = $row->dc_log_id;
	            if ($row->dc_log_id > $last_id) {
	                $last_id = $row->dc_log_id;
	            }
	        }
	    } else {
	        $data_return ["response"] = 3;
	        return $data_return;
	    }
	
	    $categories_rooms_intdate = array ();
	
	    $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
	    FROM  `rooms`
	    INNER JOIN categories ON categories.id = rooms.category_id
	    INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
	    INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
	    dc_log.categoryid = rooms.category_id
	    WHERE dc_log.dc_id = 29 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.dc_hotel_id = $hotel_id
	    GROUP BY deskofdays.intdate, rooms.category_id";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            // count_rooms_booking
	            $categories_rooms_intdate [$row->id] [$row->intdate] ["free"] = $row->count_rooms;
	        }
	    }
	
	    $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log ( 29 );
	    $overbooking_reservations_array = array ();
	    if (isset ( $datein_out_mass ["intdatein"] )) {
	        $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat ( $datein_out_mass ["intdatein"], $datein_out_mass ["intdateout"] );
	    }
	
	    $setrestrict_result = "";
	    $result = "";
	    $sql = "SELECT int_value FROM dc_nash_travel_xml_cfg WHERE name LIKE 'general_update'";
	    $query = $this->db->query ( $sql );
	
	    if ($general_update == 1) {
	        $category_keys = array_keys ( $categories_rooms_all );
	        foreach ( $category_keys as $category_id ) {
	
	            $sql = "select min, max from dc_nash_travel_room_categories_link where hms_category_id = " . $category_id;
	            $query = $this->db->query ( $sql );
	            if ($query->num_rows () > 0) {
	                $row2 = $query->row ();
	                $min = $row2->min;
	                $max = $row2->max;
	            } else {
	                $min = 0;
	                $max = 999;
	            }
	
	            $arr_intdate_keys = array_keys ( $categories_rooms_all [$category_id] );
	            foreach ( $arr_intdate_keys as $intdate ) {
	                if ($categories_rooms_all[$category_id][$intdate]["closed"] == 1) {
	                    $categories_rooms_all[$category_id][$intdate]["free"] = 0;
	                } else {
	                    if (isset($categories_rooms_intdate[$category_id][$intdate])) {
	                        $count_overbook_rooms = 0;
	                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
	                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
	                        }
	                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
	                    } else {
	                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
	                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
	                            $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $count_overbook_rooms;
	                        }
	                    }
	
	                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
	                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
	                    } else {
	                        $categories_rooms_all[$category_id][$intdate]["free"] = 0;
	                    }
	
	                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
	                        $categories_rooms_all[$category_id][$intdate]["free"] = $max;
	                    }
	
	                    // коррекція к-сті відповідно умовам ф-ї availability_count_correction
	                    $startdate = $enddate = date("Y-m-d", $intdate*86400);
	                    $categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
	                }
	                	
	                if (false) {
	                    $prev = $intdate - 1;
	                    if (isset ( $categories_rooms_all [$category_id] [$prev] )) {
	                        $free_1 = $categories_rooms_all [$category_id] [$prev] ["free"];
	                        $free_2 = $categories_rooms_all [$category_id] [$intdate] ["free"];
	                        	
	                        if ($free_1 == $free_2) {
	                            $categories_rooms_all [$category_id] [$intdate] ["from"] = $categories_rooms_all [$category_id] [$prev] ["from"];
	                            unset ( $categories_rooms_all [$category_id] [$prev] );
	                        }
	                    }
	                }
	            }
	        }
	        	
	        /*
	         * foreach ( $categories_rooms_all as $category_id => $intdates ) { foreach ( $intdates as $intdate => $cell ) { $todate = $categories_rooms_all [$category_id] [$intdate] ["to"]; list ( $year, $month, $day ) = explode ( "-", $todate ); $intdate_to = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 ); $intdate_to = $intdate_to + 1; $categories_rooms_all [$category_id] [$intdate] ["to"] = gmdate ( "Y-m-d", $intdate_to * 86400 ); } }
	         */
	        	
	        // echo "<pre>";
	        // print_r ( $categories_rooms_all );
	        // die();
	        $roomslist = array ();
	        foreach ( $categories_rooms_all as $category_id => $category_dates ) {
	            $dates = array();
	            foreach ( $category_dates as $intdate => $cell ) {
	                $dc_room_id = $cell ["dc_room_id"];
	                array_push ( $dates, array (
	                    'date' => $cell ["date"],
	                    'quota' => $cell ["free"]
	                ) );
	            }
	            
	            array_push($roomslist, array(
	                'serial' => $dc_room_id,
	                'dates' => $dates
	            ));
	        }
	        	
// 	        echo "<pre>";
// 	        print_r ( $roomslist );
// 	        die();	
	        if (count ( $roomslist ) < 1) {
	            $query = $this->db->query ( "DELETE FROM dc_log WHERE dc_id = 29 AND dc_hotel_id = $hotel_id" );
	            $data_return ["response"] = 4;
	            return $data_return;
	        }
	        	
	        $request = array ();
	        $request ["rooms"] = $roomslist;
	        //print_r ( $request );
	        $json_request = json_encode ( $request );
	        echo "<br>".$json_request."<br>";;
	        
	        
	        
	        
	        $url = $authparam["url"]."/rooms/quota";
	        echo $url;
	        $data_result = $this->Curl_model->CurlPlugRaw_nash_travel ( $json_request, $url, $authparam["token"], array("returntype" => "array") );
	        	
	        $result_array = json_decode ( $data_result ["result"], 1 );
	        	
	        //echo $data_result ["result"]."++++";
	        print_r ( $data_result );
	        //die();
	        $dc_log_id = $data_result ["dc_log_id"];
	        	
	        $data_return ["dc_log_id"] = $dc_log_id;
	        $data_return ["datein"] = gmdate ( "Y-m-d", $min_date * 86400 );
	        $data_return ["dateout"] = gmdate ( "Y-m-d", $max_date * 86400 );
	        	
	        //$result = json_decode ( json_encode ( $data_result ["result"] ), 1 );
	        	
	    }
	
	    if ($general_update == 0) {
	        echo "Ban upload for booking service";
	    } else {
	        if ($result_array["success"] == true) {
	            $data_return ["response"] = 1;
	            $data_return ["responsebody"] = "success";
	            $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 29 AND dc_hotel_id = $hotel_id AND time < " . $last_time;
	            $query = $this->db->query ( $sql );
	        } else {
	            $data_return ["response"] = 0;
	            $data_return ["errmsg"] = $result_array ['error'];
	            $data_return ["responsebody"] = $result_array ['error'];
	            // $query = $this->db->query ( "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 21 AND time < " . $last_time );
	        }
	        return $data_return;
	    }
	}
	
	function setavailability_lastchanged_30($dc_account_id = 0, $hms_id = 0) {
	    $authparam = $this->dcm_sutochno->getauthparam($dc_account_id);
	    $hotel_id = $authparam ["hotel_id_int"];
	    $dc_id = 30;
	    $limit_array = $this->frontdesk->get_dc_log_limit_array ();
	    $sutochno_uploadperiod = $limit_array[$dc_id];
	    //$sutochno_uploadperiod = 365;
	    $general_update = 0;
	    $sql = "SELECT int_value FROM dc_sutochno_xml_cfg WHERE name LIKE 'general_update'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $general_update = $row->int_value;
	    }
	    
	    $data_return = array ();
	    if ($general_update == 1) {
	    } else {
	        $data_return ["response"] = 2;
	        return $data_return;
	    }
	
	    $restrict_rate_id = 0;
	    $sql = "SELECT restrict_id FROM dc_sutochno_rates WHERE dc_hotel_id = ".$hotel_id;
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $restrict_rate_id = $row->restrict_id;
	    }
	
	    $min_date = 0;
	    $max_date = 0;
	    $categories_rooms_all = array ();
	    
	    $timezone = $this->frontdesk->timezone_get();
//	    date_default_timezone_set($timezone);

	    $hotel_date = $this->frontdesk->convert_to_user_date(date('Y-m-d H:i:s'), "Y-m-d H:i:s", $timezone);

	    list ( $year, $month, $day ) = explode ( "-", $hotel_date );
	    $intdate_today = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );

	    //$intdate_today = floor ( time () / 86400 );
	    $last_id = 0;
	    $last_time = time ();
	    
	    $sql = "SELECT deskofrate.closed, dc_sutochno_room_categories_strtoint_link.dc_room_id as dc_category_id, dc_log.id as dc_log_id, 
	    categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms
		FROM categories
		INNER JOIN dc_log ON dc_log.categoryid = categories.id
		INNER JOIN dc_sutochno_room_categories_link ON dc_sutochno_room_categories_link.hms_category_id = dc_log.categoryid
	    INNER JOIN dc_sutochno_room_categories_strtoint_link ON dc_sutochno_room_categories_strtoint_link.id = dc_sutochno_room_categories_link.dc_category_id
		LEFT JOIN rooms ON rooms.category_id = categories.id AND rooms.dc_active = 1
		LEFT JOIN deskofrate ON deskofrate.category_id = categories.id AND dc_log.intdate = deskofrate.intdate AND deskofrate.rate_id = " . $restrict_rate_id . "
		WHERE dc_log.dc_id = 30 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.intdate >= " . $intdate_today . "
		GROUP BY dc_log.categoryid, dc_log.intdate ORDER BY dc_log.id, dc_log.intdate LIMIT 0, " . $sutochno_uploadperiod;
	    
	    //ORDER BY dc_log.id, dc_log.intdate
	    $query = $this->db->query ( $sql );
	     //echo $sql;
	
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            if ($min_date == 0) {
	                $min_date = $row->log_intdate;
	            } else {
	                if ($row->log_intdate < $min_date) {
	                    $min_date = $row->log_intdate;
	                }
	            }
	
	            if ($max_date == 0) {
	                $max_date = $row->log_intdate;
	            } else {
	                if ($row->log_intdate > $max_date) {
	                    $max_date = $row->log_intdate;
	                }
	            }
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["closed"] = $row->closed;
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["object_id"] = $row->dc_category_id;
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["date_begin"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["date_end"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["available"] = $row->count_rooms;
	            //$categories_rooms_all [$row->category_id] [$row->log_intdate] ["date"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );

	            if ($row->dc_log_id > $last_id) {
	                $last_id = $row->dc_log_id;
	            }
	        }
	    } else {
	        $sql = "DELETE FROM dc_log WHERE dc_hotel_id = $hotel_id AND dc_id = 30";
	        $query = $this->db->query ( $sql );
	        
	        $data_return ["response"] = 3;
	        return $data_return;
	    }
	    
	    $bugs_log_error_desc = json_encode($categories_rooms_all);
	
	    $categories_rooms_intdate = array ();
	
	    $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
	    FROM  `rooms`
	    INNER JOIN categories ON categories.id = rooms.category_id
	    INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
	    INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
	    dc_log.categoryid = rooms.category_id
	    WHERE dc_log.dc_id = 30 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.dc_hotel_id = $hotel_id
	    GROUP BY deskofdays.intdate, rooms.category_id";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            // count_rooms_booking
	            $categories_rooms_intdate [$row->id] [$row->intdate] ["available"] = $row->count_rooms;
	        }
	    }
	
	    $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log ( 30 );
	    $overbooking_reservations_array = array ();
	    if (isset ( $datein_out_mass ["intdatein"] )) {
	        $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat ( $datein_out_mass ["intdatein"], $datein_out_mass ["intdateout"] );
	    }
	
	    $setrestrict_result = "";
	    $result = "";
	    
	    if ($general_update == 1) {
	        $category_keys = array_keys ( $categories_rooms_all );
	        foreach ( $category_keys as $category_id ) {
	
	            $sql = "select min, max from dc_sutochno_room_categories_link where hms_category_id = " . $category_id;
	            $query = $this->db->query ( $sql );
	            if ($query->num_rows () > 0) {
	                $row2 = $query->row ();
	                $min = $row2->min;
	                $max = $row2->max;
	            } else {
	                $min = 0;
	                $max = 999;
	            }
	            
	            	        //echo "<pre>".$category_id;
	            	        //print_r ( $categories_rooms_all );
	            	        //die();
	            ksort($categories_rooms_all[$category_id]);
                $arr_intdate_keys = array_keys($categories_rooms_all[$category_id]);

                foreach ($arr_intdate_keys as $intdate) {
                    if ($categories_rooms_all[$category_id][$intdate]["closed"] == 1) {
                        $categories_rooms_all[$category_id][$intdate]["available"] = 0;
                    } else {
                        if (isset($categories_rooms_intdate[$category_id][$intdate])) {
                            $count_overbook_rooms = 0;
                            if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                                $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                            }
                            $categories_rooms_all[$category_id][$intdate]["available"] = $categories_rooms_all[$category_id][$intdate]["available"] - ($categories_rooms_intdate[$category_id][$intdate]["available"] + $count_overbook_rooms);
                        } else {
                            if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                                $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                                $categories_rooms_all[$category_id][$intdate]["available"] = $categories_rooms_all[$category_id][$intdate]["available"] - $count_overbook_rooms;
                            }
                        }
                        
                        if ($categories_rooms_all[$category_id][$intdate]["available"] > $min) {
                            $categories_rooms_all[$category_id][$intdate]["available"] = $categories_rooms_all[$category_id][$intdate]["available"] - $min;
                        } else {
                            $categories_rooms_all[$category_id][$intdate]["available"] = 0;
                        }
                        
                        if ($categories_rooms_all[$category_id][$intdate]["available"] > $max) {
                            $categories_rooms_all[$category_id][$intdate]["available"] = $max;
                        }
                        
                        // коррекція к-сті відповідно умовам ф-ї availability_count_correction
                        $startdate = $enddate = date("Y-m-d", $intdate * 86400);
                        $categories_rooms_all[$category_id][$intdate]["available"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["available"], $startdate, $enddate);
                    }
                    if (true) {
                        $prev = $intdate - 1;
                        if (isset($categories_rooms_all[$category_id][$prev])) {
                            $free_1 = $categories_rooms_all[$category_id][$prev]["available"];
                            $free_2 = $categories_rooms_all[$category_id][$intdate]["available"];
                            
                            if ($free_1 == $free_2) {
                                $categories_rooms_all[$category_id][$intdate]["date_begin"] = $categories_rooms_all[$category_id][$prev]["date_begin"];
                                unset($categories_rooms_all[$category_id][$prev]);
                            }
                        }
                    }
                }
	        }
	
	        /*
	         * foreach ( $categories_rooms_all as $category_id => $intdates ) { foreach ( $intdates as $intdate => $cell ) { $todate = $categories_rooms_all [$category_id] [$intdate] ["to"]; list ( $year, $month, $day ) = explode ( "-", $todate ); $intdate_to = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 ); $intdate_to = $intdate_to + 1; $categories_rooms_all [$category_id] [$intdate] ["to"] = gmdate ( "Y-m-d", $intdate_to * 86400 ); } }
	         */
	
// 	        echo "<pre>";
// 	        print_r ( $categories_rooms_all );
// 	        die();
	        $roomslist = array();
            foreach ($categories_rooms_all as $category_id => $category_dates) {
                $dates = array();
                foreach ($category_dates as $intdate => $cell) {
                    unset($cell["closed"]);
                    
                    array_push($roomslist, $cell);
                    
//                     if (count($cell) < 4){
//                         $insert_data = array(
//                             'hms_id' => $hms_id,
//                             'dc_id' => $dc_id,
//                             'state' => 0,
//                             'desc' => $bugs_log_error_desc." SUTOCHNO_2022 ".json_encode($cell)
//                         );
                        
//                         $this->db->insert('global_hotelix_analitycs.bugs_loger_logs', $insert_data);
//                     }
                }
            }
            
//             echo "<pre>";
//             print_r($roomslist);
//             die();
	        if (count ( $roomslist ) < 1) {
	            $query = $this->db->query ( "DELETE FROM dc_log WHERE dc_id = 30 AND dc_hotel_id = $hotel_id" );
	            $data_return ["response"] = 4;
	            return $data_return;
	        }
	
	        $request = array ();
	        $request ["availability"] = $roomslist;
	        //print_r ( $request );
	        $json_request = json_encode ( $request );
	        echo "<br>".$json_request."<br>";
	        //die(); 
	         
	         
	         
	        $url = $authparam ["url"]."/api/json/sync/setAvailability/";
	        echo $url;
	        $data_result = $this->Curl_model->CurlPlugRaw_sutochno ( $json_request, $url, $authparam["token"], array("returntype" => "array") );
	
	        $result_array = json_decode ( $data_result ["result"], 1 );
	
	        //echo $data_result ["result"]."++++";
	        print_r ( $data_result );
	        //die();
	        $dc_log_id = $data_result ["dc_log_id"];
	
	        $data_return ["dc_log_id"] = $dc_log_id;
	        $data_return ["datein"] = gmdate ( "Y-m-d", $min_date * 86400 );
	        $data_return ["dateout"] = gmdate ( "Y-m-d", $max_date * 86400 );
	
	        //$result = json_decode ( json_encode ( $data_result ["result"] ), 1 );
	
	    }
	
	    if ($general_update == 0) {
	        echo "Ban upload for booking service";
	    } else {
	        if ($result_array["success"] == true) {
	            $data_return ["response"] = 1;
	            $data_return ["responsebody"] = "success";
	            $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 30 AND dc_hotel_id = $hotel_id AND time < " . $last_time;
	            $query = $this->db->query ( $sql );
	        } else {
	            $data_return ["response"] = 0;
	            $data_return ["errmsg"] = $result_array ['errors'][0];
	            $data_return ["responsebody"] = $result_array ['errors'][0];
	            $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 30 AND dc_hotel_id = $hotel_id AND time < " . $last_time;
	            $query = $this->db->query ( $sql );
	        }
	        return $data_return;
	    }
	}
	
	function setavailability_lastchanged_31($data) {
	    $property_id = $data['property_id'];
	    
	    
	    $sql = "DELETE FROM dc_log WHERE dc_hotel_id != $property_id AND dc_id = 31";
	    $query = $this->db->query ( $sql );
	    
	    $db_name = $data['db_name'];
	    $dc_id = 31;
	    $limit_array = $this->frontdesk->get_dc_log_limit_array ();
	    $uploadperiod = $limit_array[$dc_id];
	    //$sutochno_uploadperiod = 365;
	    $general_update = 0;
	    $sql = "SELECT int_value FROM dc_google_xml_cfg WHERE name LIKE 'general_update'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $general_update = $row->int_value;
	    }
	     
	    $data_return = array ();
	    if ($general_update == 1) {
	    } else {
	        $data_return ["response"] = 2;
	        return $data_return;
	    }
	    
	    $hms_id = 0;
	    $sql = "SELECT id FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $hms_id = $row->id;
	    }
	
	    $min_date = 0;
	    $max_date = 0;
	    $categories_rooms_all = array ();
	
	    $intdate_today = floor ( time () / 86400 );
	    $last_id = 0;
	    $last_time = time ();
	     
	    $sql = "SELECT categories.id as category_id, dc_log.id as dc_log_id, 
	    categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms
		FROM categories
		INNER JOIN dc_log ON dc_log.categoryid = categories.id
		LEFT JOIN rooms ON rooms.category_id = categories.id AND rooms.dc_active = 1
		WHERE categories.web_booking = 1 AND dc_log.dc_id = $dc_id AND dc_log.dc_hotel_id = $property_id AND dc_log.intdate >= " . $intdate_today . "
		GROUP BY dc_log.categoryid, dc_log.intdate LIMIT 0, " . $uploadperiod;
	    $query = $this->db->query ( $sql );
	    // echo $sql;
	
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            if ($min_date == 0) {
	                $min_date = $row->log_intdate;
	            } else {
	                if ($row->log_intdate < $min_date) {
	                    $min_date = $row->log_intdate;
	                }
	            }
	
	            if ($max_date == 0) {
	                $max_date = $row->log_intdate;
	            } else {
	                if ($row->log_intdate > $max_date) {
	                    $max_date = $row->log_intdate;
	                }
	            }
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["room_id"] = $row->category_id;
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["date_start"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["date_end"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["rooms_available"] = $row->count_rooms;
	            
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["monday"] = "true";
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["tuesday"] = "true";
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["wednesday"] = "true";
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["thursday"] = "true";
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["friday"] = "true";
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["saturday"] = "true";
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["sunday"] = "true";
	            //$categories_rooms_all [$row->category_id] [$row->log_intdate] ["date"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	
	            if ($row->dc_log_id > $last_id) {
	                $last_id = $row->dc_log_id;
	            }
	        }
	    } else {
	        $sql = "DELETE FROM dc_log WHERE dc_hotel_id = $property_id AND dc_id = 31";
	        $query = $this->db->query ( $sql );
	        
	        $data_return ["response"] = 3;
	        return $data_return;
	    }
	
	    $categories_rooms_intdate = array ();
	
	    $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
	    FROM `rooms`
	    INNER JOIN categories ON categories.id = rooms.category_id
	    INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
	    INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
	    dc_log.categoryid = rooms.category_id
	    WHERE dc_log.dc_hotel_id = $property_id AND dc_log.dc_id = $dc_id
	    GROUP BY deskofdays.intdate, rooms.category_id";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            // count_rooms_booking
	            $categories_rooms_intdate [$row->id] [$row->intdate] ["rooms_available"] = $row->count_rooms;
	        }
	    }
	
	    $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log ( 31 );
	    $overbooking_reservations_array = array ();
	    if (isset ( $datein_out_mass ["intdatein"] )) {
	        $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat ( $datein_out_mass ["intdatein"], $datein_out_mass ["intdateout"] );
	    }
	
	    $setrestrict_result = "";
	    $result = "";
	     
	    if ($general_update == 1) {
	        $category_keys = array_keys ( $categories_rooms_all );
	        foreach ( $category_keys as $category_id ) {
	
	            $arr_intdate_keys = array_keys($categories_rooms_all[$category_id]);
                foreach ($arr_intdate_keys as $intdate) {
                    
                    if (isset($categories_rooms_intdate[$category_id][$intdate])) {
                        $count_overbook_rooms = 0;
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                        }
                        $categories_rooms_all[$category_id][$intdate]["rooms_available"] = $categories_rooms_all[$category_id][$intdate]["rooms_available"] - ($categories_rooms_intdate[$category_id][$intdate]["rooms_available"] + $count_overbook_rooms);
                    } else {
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                            $categories_rooms_all[$category_id][$intdate]["rooms_available"] = $categories_rooms_all[$category_id][$intdate]["rooms_available"] - $count_overbook_rooms;
                        }
                    }
                    
                    // коррекція к-сті відповідно умовам ф-ї availability_count_correction
                    $startdate = $enddate = date("Y-m-d", $intdate * 86400);
                    $categories_rooms_all[$category_id][$intdate]["rooms_available"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["rooms_available"], $startdate, $enddate);
                    
                    if($categories_rooms_all[$category_id][$intdate]["rooms_available"] < 0){
                        $categories_rooms_all[$category_id][$intdate]["rooms_available"] = 0;
                    }
                    
                    if (true) {
                        $prev = $intdate - 1;
                        if (isset($categories_rooms_all[$category_id][$prev])) {
                            $free_1 = $categories_rooms_all[$category_id][$prev]["rooms_available"];
                            $free_2 = $categories_rooms_all[$category_id][$intdate]["rooms_available"];
                            
                            if ($free_1 == $free_2) {
                                $categories_rooms_all[$category_id][$intdate]["date_start"] = $categories_rooms_all[$category_id][$prev]["date_start"];
                                unset($categories_rooms_all[$category_id][$prev]);
                            }
                        }
                    }
                }
	        }
	
	      
	        // 	        echo "<pre>";
	        // 	        print_r ( $categories_rooms_all );
	        // 	        die();
	        $roomslist = array();
	        foreach ($categories_rooms_all as $category_id => $category_dates) {
	            $dates = array();
	            foreach ($category_dates as $intdate => $cell) {
	                array_push($roomslist, $cell);
	            }
	        }
	
	        echo "<pre>";
	        
	        $request_data = array();
	        $request_data['timestamp'] = date('c');
	        $request_data['message_id'] = md5(strtotime('now'));
	        $request_data['partner_account_name'] = 'otelms_ari';
	        $request_data['hotel_id'] = $hms_id."_".$property_id;
	        $request_data['periods'] = $roomslist;
	        print_r($request_data);
	        //die();
	        if (count ( $roomslist ) < 1) {
	            $query = $this->db->query ( "DELETE FROM dc_log WHERE dc_id = $dc_id" );
	            $data_return ["response"] = 4;
	            return $data_return;
	        }
	        //die();
	        $request_json = json_encode($request_data);
	        
	        if($this->releases->check_log_big_data() == 1){
	            $big_log_data = array();
	            $big_log_data ['hms_id'] = $hms_id;
	            $big_log_data ['dc_id'] = 31;
	            $big_log_data ['dc_upload_type'] = "allotments";
	            $big_log_data ['sizeof'] = $this->dc_model->sizeofvar($request_json);
	            $this->db->insert('global_hotelix_analitycs.bugs_loger_logs', $big_log_data);
	        }
	        
	        $request_xml = '<?xml version="1.0" encoding="UTF-8"?>';
	        $request_xml .= $this->parser->parse('templates/dc_google/hotel_availability.html', $request_data, TRUE);
	
	        $url = "https://www.google.com/travel/hotels/uploads/ota/hotel_inv_count_notif";
	        $data_result = $this->Curl_model->CurlPlugRaw_google($request_xml, $request_json, $url, array(
	            "returntype" => "array"
	        ));

	        
	        
	        if ($data_result['responseint'] == 400) {
	            $data_return ["response"] = 0;
	            $data_return ["errmsg"] = $data_result['result'];
	            $data_return ["responsebody"] = $data_result['result'];
	            
	            $data_return ["dc_log_id"] = $data_result ["dc_log_id"];
	            $data_return ["datein"] = gmdate ( "Y-m-d", $min_date * 86400 );
	            $data_return ["dateout"] = gmdate ( "Y-m-d", $max_date * 86400 );
	            
	            $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_hotel_id = $property_id AND dc_id = 31 AND time < " . $last_time;
	            //echo "\n" . $sql . "\n";
	            $query = $this->db->query ( $sql );
	            
	            return $data_return;
	        }
	        
	        
	        
	        
	        
	        $result = new SimpleXMLElement($data_result ["result"]);

	        $dc_log_id = $data_result ["dc_log_id"];
	
	        $data_return ["dc_log_id"] = $dc_log_id;
	        $data_return ["datein"] = gmdate ( "Y-m-d", $min_date * 86400 );
	        $data_return ["dateout"] = gmdate ( "Y-m-d", $max_date * 86400 );
	
	        //$result = json_decode ( json_encode ( $data_result ["result"] ), 1 );
	
	    }
	
	    if ($general_update == 0) {
	        echo "Ban upload for booking service";
	    } else {
	        if(isset($result->Success)){
	            $data_return ["response"] = 1;
	            $data_return ["responsebody"] = "success";
	            $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_hotel_id = $property_id AND dc_id = 31 AND time < " . $last_time;
	            $query = $this->db->query ( $sql );
	        } else {
	            $data_return ["response"] = 0;
	            $data_return ["errmsg"] = $result->Errors->Error;
	            $data_return ["responsebody"] = $result->Errors->Error;
	            
	            $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_hotel_id = $property_id AND dc_id = 31 AND time < " . $last_time;
	            $query = $this->db->query ( $sql );
	        }
	        return $data_return;
	    }
	}
	
	function setavailability_lastchanged_31_OLD($dc_account_id = 0) {
	    $dc_id = 31;
	    $limit_array = $this->frontdesk->get_dc_log_limit_array ();
	    $uploadperiod = $limit_array[$dc_id];
	    //$sutochno_uploadperiod = 365;
	    $general_update = 0;
	    $sql = "SELECT int_value FROM dc_google_xml_cfg WHERE name LIKE 'general_update'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $general_update = $row->int_value;
	    }
	
	    $data_return = array ();
	    if ($general_update == 1) {
	    } else {
	        $data_return ["response"] = 2;
	        return $data_return;
	    }
	
	    $min_date = 0;
	    $max_date = 0;
	    $categories_rooms_all = array ();
	
	    $intdate_today = floor ( time () / 86400 );
	    $last_id = 0;
	    $last_time = time ();
	
	    $sql = "SELECT categories.id as category_id, dc_log.id as dc_log_id, property_information.id as property_id,
	    categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms
	    FROM categories
	    INNER JOIN dc_log ON dc_log.categoryid = categories.id
	    INNER JOIN property_information ON property_information.id = categories.property_id
	    LEFT JOIN rooms ON rooms.category_id = categories.id AND rooms.dc_active = 1
	    WHERE dc_log.dc_id = $dc_id AND dc_log.intdate >= " . $intdate_today . "
		GROUP BY dc_log.categoryid, dc_log.intdate ORDER BY dc_log.id, dc_log.intdate LIMIT 0, " . $uploadperiod;
	    $query = $this->db->query ( $sql );
	    // echo $sql;
	
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            if ($min_date == 0) {
	                $min_date = $row->log_intdate;
	            } else {
	                if ($row->log_intdate < $min_date) {
	                    $min_date = $row->log_intdate;
	                }
	            }
	
	            if ($max_date == 0) {
	                $max_date = $row->log_intdate;
	            } else {
	                if ($row->log_intdate > $max_date) {
	                    $max_date = $row->log_intdate;
	                }
	            }
	            $categories_rooms_all [$row->property_id] ['categories'] [$row->category_id] [$row->log_intdate] ["category_id"] = $row->category_id;
	            $categories_rooms_all [$row->property_id] ['categories'] [$row->category_id] [$row->log_intdate] ["date_start"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	            $categories_rooms_all [$row->property_id] ['categories'] [$row->category_id] [$row->log_intdate] ["date_end"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	            $categories_rooms_all [$row->property_id] ['categories'] [$row->category_id] [$row->log_intdate] ["rooms_available"] = $row->count_rooms;
	             
	            $categories_rooms_all [$row->property_id] ['categories'] [$row->category_id] [$row->log_intdate] ["monday"] = "true";
	            $categories_rooms_all [$row->property_id] ['categories'] [$row->category_id] [$row->log_intdate] ["tuesday"] = "true";
	            $categories_rooms_all [$row->property_id] ['categories'] [$row->category_id] [$row->log_intdate] ["wednesday"] = "true";
	            $categories_rooms_all [$row->property_id] ['categories'] [$row->category_id] [$row->log_intdate] ["thursday"] = "true";
	            $categories_rooms_all [$row->property_id] ['categories'] [$row->category_id] [$row->log_intdate] ["friday"] = "true";
	            $categories_rooms_all [$row->property_id] ['categories'] [$row->category_id] [$row->log_intdate] ["saturday"] = "true";
	            $categories_rooms_all [$row->property_id] ['categories'] [$row->category_id] [$row->log_intdate] ["sunday"] = "true";
	            //$categories_rooms_all [$row->category_id] [$row->log_intdate] ["date"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	
	            if ($row->dc_log_id > $last_id) {
	                $last_id = $row->dc_log_id;
	            }
	        }
	    } else {
	        $data_return ["response"] = 3;
	        return $data_return;
	    }
	
	    $categories_rooms_intdate = array ();
	
	    $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
	    FROM  `rooms`
	    INNER JOIN categories ON categories.id = rooms.category_id
	    INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
	    INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
	    dc_log.categoryid = rooms.category_id
	    WHERE dc_log.dc_id = $dc_id
	    GROUP BY deskofdays.intdate, rooms.category_id";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            // count_rooms_booking
	            $categories_rooms_intdate [$row->id] [$row->intdate] ["rooms_available"] = $row->count_rooms;
	        }
	    }
	
	    $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log ( 1 );
	    $overbooking_reservations_array = array ();
	    if (isset ( $datein_out_mass ["intdatein"] )) {
	        $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat ( $datein_out_mass ["intdatein"], $datein_out_mass ["intdateout"] );
	    }
	
	    $setrestrict_result = "";
	    $result = "";
	
	    if ($general_update == 1) {
	        foreach ($categories_rooms_all as $property_id => &$categories) {
	            $category_keys = array_keys($categories['categories']);
	            foreach ($category_keys as $category_id) {
	
	                $arr_intdate_keys = array_keys($categories['categories'][$category_id]);
	                foreach ($arr_intdate_keys as $intdate) {
	
	                    if (isset($categories_rooms_intdate[$category_id][$intdate])) {
	                        $count_overbook_rooms = 0;
	                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
	                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
	                        }
	                        $categories['categories'][$category_id][$intdate]["rooms_available"] = $categories['categories'][$category_id][$intdate]["rooms_available"] - ($categories_rooms_intdate[$category_id][$intdate]["rooms_available"] + $count_overbook_rooms);
	                    } else {
	                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
	                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
	                            $categories['categories'][$category_id][$intdate]["rooms_available"] = $categories['categories'][$category_id][$intdate]["rooms_available"] - $count_overbook_rooms;
	                        }
	                    }
	
	                    // коррекція к-сті відповідно умовам ф-ї availability_count_correction
	                    $startdate = $enddate = date("Y-m-d", $intdate * 86400);
	                    $categories['categories'][$category_id][$intdate]["rooms_available"] = $this->frontdesk_c2->availability_count_correction($categories['categories'][$category_id][$intdate]["rooms_available"], $startdate, $enddate);
	
	                    if (true) {
	                        $prev = $intdate - 1;
	                        if (isset($categories['categories'][$category_id][$prev])) {
	                            $free_1 = $categories['categories'][$category_id][$prev]["rooms_available"];
	                            $free_2 = $categories['categories'][$category_id][$intdate]["rooms_available"];
	
	                            if ($free_1 == $free_2) {
	                                $categories['categories'][$category_id][$intdate]["date_start"] = $categories['categories'][$category_id][$prev]["date_start"];
	                                unset($categories['categories'][$category_id][$prev]);
	                            }
	                        }
	                    }
	                }
	            }
	        }
	
	         
	        //echo "<pre>";
	        //print_r ( $categories_rooms_all );
	        //die();
	        $roomslist = array();
	        foreach ($categories_rooms_all as $property_id => $categories) {
	            $roomslist[$property_id]['hotel_id'] = $this->config->item('hotel_id')."_".$property_id;
	            $roomslist[$property_id]['periods'] = array();
	            foreach ($categories['categories'] as $category_id => $category_dates) {
	                foreach ($category_dates as $intdate => $cell) {
	                    array_push($roomslist[$property_id]['periods'], $cell);
	                }
	            }
	        }
	
	        echo "<pre>";
	         
	        $request_data = array();
	        $property_id = $this->db->query("SELECT id FROM property_information ORDER BY id ASC LIMIT 0, 1")->row()->id;
	
	        $request_data['timestamp'] = date('c');
	        $request_data['message_id'] = md5(strtotime('now'));
	        $request_data['partner_account_name'] = 'otelms_ari';
	        //$request_data['hotel_id'] = $this->config->item('hotel_id')."_".$property_id;
	        $request_data['property_data'] = $roomslist;
	        print_r($request_data);
	        //die();
	        if (count ( $roomslist ) < 1) {
	            $query = $this->db->query ( "DELETE FROM dc_log WHERE dc_id = $dc_id" );
	            $data_return ["response"] = 4;
	            return $data_return;
	        }
	        //die();
	
	        $request_xml = '<?xml version="1.0" encoding="UTF-8"?>';
	        $request_xml .= $this->parser->parse('templates/dc_google/hotel_availability.html', $request_data, TRUE);
	        echo $request_xml;
	         
	        $url = "https://www.google.com/travel/hotels/uploads/ota/hotel_inv_count_notif";
	        $data_result = $this->Curl_model->CurlPlugRaw_google($request_xml, $url, array(
	            "returntype" => "array"
	        ));
	
	        $result = new SimpleXMLElement($data_result ["result"]);
	
	        $dc_log_id = $data_result ["dc_log_id"];
	
	        $data_return ["dc_log_id"] = $dc_log_id;
	        $data_return ["datein"] = gmdate ( "Y-m-d", $min_date * 86400 );
	        $data_return ["dateout"] = gmdate ( "Y-m-d", $max_date * 86400 );
	
	        //$result = json_decode ( json_encode ( $data_result ["result"] ), 1 );
	
	    }
	
	    if ($general_update == 0) {
	        echo "Ban upload for booking service";
	    } else {
	        if(isset($result->Success)){
	            $data_return ["response"] = 1;
	            $data_return ["responsebody"] = "success";
	            $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 31 AND time < " . $last_time;
	            $query = $this->db->query ( $sql );
	        } else {
	            $data_return ["response"] = 0;
	            $data_return ["errmsg"] = $result->Errors->Error;
	            $data_return ["responsebody"] = $result->Errors->Error;
	            // $query = $this->db->query ( "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 21 AND time < " . $last_time );
	        }
	        return $data_return;
	    }
	}
	
	function setavailability_lastchanged_33($dc_account_id = 0) {
	    $authparam = $this->dcm_101hotels->getauthparam($dc_account_id);
        $api_key = $authparam ["api_key"];
        $hotel_id = $authparam['hotel_id'];

        $hms_id = 0;
        $sql = "SELECT id FROM visitka.config WHERE db_name LIKE '" . $this->db->database . "'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $hms_id = $row->id;
        }
        
	    $general_update = 0;
	    $sql = "SELECT int_value FROM dc_101hotels_xml_cfg WHERE name LIKE 'general_update'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $general_update = $row->int_value;
	    }
	    $data_return = array ();
	    if ($general_update == 1) {
	    } else {
	        $data_return ["response"] = 2;
	        return $data_return;
	    }
	
	    $restrict_rate_id = 0;
	    $sql = "SELECT int_value FROM dc_101hotels_xml_cfg WHERE name LIKE 'restrict_rate_id'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $restrict_rate_id = $row->int_value;
	    }
	
	    $min_date = 0;
	    $max_date = 0;
	    $categories_rooms_all = array ();
	
	    $intdate_today = floor ( time () / 86400 );
	    $last_id = 0;
	    $last_time = time ();
	
	    $sql = "SELECT dc_101hotels_room_categories_link.dc_category_id, dc_log.id as dc_log_id, categories.id as category_id,
	    dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms
	    FROM categories
	    INNER JOIN dc_log ON dc_log.categoryid = categories.id
	    INNER JOIN dc_101hotels_room_categories_link ON dc_101hotels_room_categories_link.hms_category_id = dc_log.categoryid
	    LEFT JOIN rooms ON rooms.category_id = categories.id AND rooms.dc_active = 1
	    WHERE dc_log.dc_id = 33 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.intdate >= " . $intdate_today . "
		GROUP BY dc_log.categoryid, dc_log.intdate";
	    $query = $this->db->query ( $sql );
	    // echo $sql;
	
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            if ($min_date == 0) {
	                $min_date = $row->log_intdate;
	            } else {
	                if ($row->log_intdate < $min_date) {
	                    $min_date = $row->log_intdate;
	                }
	            }
	
	            if ($max_date == 0) {
	                $max_date = $row->log_intdate;
	            } else {
	                if ($row->log_intdate > $max_date) {
	                    $max_date = $row->log_intdate;
	                }
	            }
	
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["dc_room_id"] = $row->dc_category_id;
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["free"] = $row->count_rooms;
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["from"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["to"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	            if ($row->dc_log_id > $last_id) {
	                $last_id = $row->dc_log_id;
	            }
	        }
	    } else {
	        $data_return ["response"] = 3;
	        return $data_return;
	    }

	    $categories_rooms_intdate = array ();
	
	    $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
	    FROM  `rooms`
	    INNER JOIN categories ON categories.id = rooms.category_id
	    INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
	    INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
	    dc_log.categoryid = rooms.category_id
	    WHERE dc_log.dc_id = 33 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.dc_hotel_id = $hotel_id
	    GROUP BY deskofdays.intdate, rooms.category_id";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            // count_rooms_booking
	            $categories_rooms_intdate [$row->id] [$row->intdate] ["free"] = $row->count_rooms;
	        }
	    }
	
	    $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log ( 33 );
	    $overbooking_reservations_array = array ();
	    if (isset ( $datein_out_mass ["intdatein"] )) {
	        $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat ( $datein_out_mass ["intdatein"], $datein_out_mass ["intdateout"] );
	    }

	    $result = "";
	    $sql = "SELECT int_value FROM dc_101hotels_xml_cfg WHERE name LIKE 'general_update'";
	    $query = $this->db->query ( $sql );
	
	    if ($general_update == 1) {
	        $category_keys = array_keys ( $categories_rooms_all );
	        foreach ( $category_keys as $category_id ) {
	
	            $sql = "select min, max from dc_101hotels_room_categories_link where hms_category_id = " . $category_id;
	            $query = $this->db->query ( $sql );
	            if ($query->num_rows () > 0) {
	                $row2 = $query->row ();
	                $min = $row2->min;
	                $max = $row2->max;
	            } else {
	                $min = 0;
	                $max = 999;
	            }
	
	            $arr_intdate_keys = array_keys ( $categories_rooms_all [$category_id] );
	            foreach ( $arr_intdate_keys as $intdate ) {
	                if (isset($categories_rooms_intdate[$category_id][$intdate])) {
	                    $count_overbook_rooms = 0;
	                    if (isset($overbooking_reservations_array[$category_id][$intdate])) {
	                        $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
	                    }
	                    $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
	                } else {
	                    if (isset($overbooking_reservations_array[$category_id][$intdate])) {
	                        $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
	                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $count_overbook_rooms;
	                    }
	                }
	
	                if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
	                    $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
	                } else {
	                    $categories_rooms_all[$category_id][$intdate]["free"] = 0;
	                }
	
	                if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
	                    $categories_rooms_all[$category_id][$intdate]["free"] = $max;
	                }
	                 
	                // коррекція к-сті відповідно умовам ф-ї availability_count_correction
	                $startdate = $enddate = date("Y-m-d", $intdate*86400);
	                $categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
	
	                if (true) {
	                    $prev = $intdate - 1;
	                    if (isset ( $categories_rooms_all [$category_id] [$prev] )) {
	                        $free_1 = $categories_rooms_all [$category_id] [$prev] ["free"];
	                        $free_2 = $categories_rooms_all [$category_id] [$intdate] ["free"];
	
	                        if ($free_1 == $free_2) {
	                            $categories_rooms_all [$category_id] [$intdate] ["from"] = $categories_rooms_all [$category_id] [$prev] ["from"];
	                            unset ( $categories_rooms_all [$category_id] [$prev] );
	                        }
	                    }
	                }
	            }
	        }
	
	        //echo "<pre>";
	        //print_r ( $categories_rooms_all );
	        //die();
	        $roomslist = array ();
	        foreach ( $categories_rooms_all as $category_id => $dates ) {
	            foreach ( $dates as $intdate => $cell ) {
	                array_push($roomslist, array(
	                    'start' => $cell ["from"],
	                    'end' => $cell ["to"],
	                    'availability' => array(
	                        '0' => array(
	                            'room_id' => $cell ["dc_room_id"],
	                            'quota' => $cell ["free"]
	                
	                        )
	                    )
	                ));
	            }
	        }
	
	        echo "<pre>";
	        print_r ( $roomslist );
	       //die();
	        if (count ( $roomslist ) < 1) {
	            $query = $this->db->query ( "DELETE FROM dc_log WHERE dc_id = 33 AND dc_hotel_id = $hotel_id" );
	            $data_return ["response"] = 4;
                return $data_return;
            }
            
            $final_array = array();
            $final_array['data'] = $roomslist;
            
            if($this->releases->check_log_big_data() == 1){
                $big_log_data = array();
                $big_log_data ['hms_id'] = $hms_id;
                $big_log_data ['dc_id'] = 33;
                $big_log_data ['dc_upload_type'] = "allotments";
                $big_log_data ['sizeof'] = $this->dc_model->sizeofvar($final_array);
                $this->db->insert('global_hotelix_analitycs.bugs_loger_logs', $big_log_data);
            }
            
            $url = $authparam['url'] . 'set_calendar';
            $data_result = $this->Curl_model->CurlPlugRAW_101hotels($url, $authparam['hotel_id'], $authparam['api_key'], $final_array, array(
                "returntype" => "array"
            ));
            
            $result_array = json_decode($data_result["result"], 1);
            
            echo $data_result["result"] . "++++";
            print_r($result_array);
            //print_r($data_result);
            //die();
            $dc_log_id = $data_result["dc_log_id"];
	
	        $data_return ["dc_log_id"] = $dc_log_id;
	        $data_return ["datein"] = gmdate ( "Y-m-d", $min_date * 86400 );
	        $data_return ["dateout"] = gmdate ( "Y-m-d", $max_date * 86400 );
	
	        //$result = json_decode ( json_encode ( $data_result ["result"] ), 1 );
	
	    }
	
	    if ($general_update == 0) {
	        echo "Ban upload for booking service";
	    } else {
	        if ($result_array["response"] == "OK") {
	            $data_return ["response"] = 1;
	            $data_return ["responsebody"] = "success";
	            $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 33 AND dc_hotel_id = $hotel_id AND time < " . $last_time;
	            $query = $this->db->query ( $sql );
	        } else {
	            $data_return ["response"] = 0;
	            $data_return ["errmsg"] = json_encode($result_array ['data'][0]);
	            $data_return ["responsebody"] = json_encode($result_array ['data'][0]);
	            
	            $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 33 AND dc_hotel_id = $hotel_id AND time < " . $last_time;
	            $query = $this->db->query ( $sql );
	            // $query = $this->db->query ( "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 21 AND time < " . $last_time );
	        }
	        return $data_return;
	    }
	}
	
	
	function setavailability_lastchanged_26($dc_account_id = 0) {
	
	
	    $authparam = $this->dcm_tvil->getauthparam($dc_account_id);
	    $hotel_id = $authparam ["hotel_id"];
	
	    $general_update = 0;
	    $sql = "SELECT int_value FROM dc_tvil_xml_cfg WHERE name LIKE 'general_update'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $general_update = $row->int_value;
	    }
	    $data_return = array ();
	    if ($general_update == 1) {
	    } else {
	        $data_return ["response"] = 2;
	        return $data_return;
	    }

	    $restrict_rate_id = 0;
	    $sql = "SELECT int_value FROM dc_tvil_xml_cfg WHERE name LIKE 'restrict_rate_id'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $restrict_rate_id = $row->int_value;
	    }
	
	    $min_date = 0;
	    $max_date = 0;
	    $categories_rooms_all = array ();
	
	    $intdate_today = floor ( time () / 86400 );
	    $last_id = 0;
	    $last_time = time ();
	
// 	    $sql_OLD = "SELECT deskofrate.closed, deskofrate.minstayarrival, dc_tvil_room_categories_link.dc_category_id,
// 	    dc_log.id as dc_log_id, categories.id as category_id,
// 		dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms
// 		FROM categories
// 		INNER JOIN dc_log ON dc_log.categoryid = categories.id
// 		INNER JOIN dc_tvil_room_categories_link ON dc_tvil_room_categories_link.hms_category_id = dc_log.categoryid
// 		LEFT JOIN rooms ON rooms.category_id = categories.id AND rooms.dc_active = 1
// 		LEFT JOIN deskofrate ON deskofrate.category_id = categories.id AND dc_log.intdate = deskofrate.intdate AND deskofrate.rate_id = " . $restrict_rate_id . "
// 	    		WHERE dc_log.dc_id = 26 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.intdate >= " . $intdate_today . "
// 		GROUP BY dc_log.categoryid, dc_log.intdate";
	    
	    $sql = "SELECT deskofrate.closed, dc_tvil_room_categories_link.dc_category_id, 
	    dc_log.id as dc_log_id, categories.id as category_id,
		dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms
		FROM categories
		INNER JOIN dc_log ON dc_log.categoryid = categories.id
		INNER JOIN dc_tvil_room_categories_link ON dc_tvil_room_categories_link.hms_category_id = dc_log.categoryid
		LEFT JOIN rooms ON rooms.category_id = categories.id AND rooms.dc_active = 1
		LEFT JOIN dc_tvil_restricts_link ON dc_tvil_restricts_link.dc_category_id = dc_tvil_room_categories_link.dc_category_id 
		LEFT JOIN deskofrate ON deskofrate.category_id = categories.id AND dc_log.intdate = deskofrate.intdate 
	    AND deskofrate.rate_id = dc_tvil_restricts_link.restrict_id
		WHERE dc_log.dc_id = 26 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.intdate >= " . $intdate_today . "
		GROUP BY dc_log.categoryid, dc_log.intdate";
	    $query = $this->db->query ( $sql );
	     //echo $sql;
	     //die();
	
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            if ($min_date == 0) {
	                $min_date = $row->log_intdate;
	            } else {
	                if ($row->log_intdate < $min_date) {
	                    $min_date = $row->log_intdate;
	                }
	            }
	
	            if ($max_date == 0) {
	                $max_date = $row->log_intdate;
	            } else {
	                if ($row->log_intdate > $max_date) {
	                    $max_date = $row->log_intdate;
	                }
	            }
	
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["closed"] = $row->closed;
	            //$categories_rooms_all [$row->category_id] [$row->log_intdate] ["min_stay_arrival"] = $row->minstayarrival;
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["dc_room_id"] = $row->dc_category_id;
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["currency"] = "RUB";
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["free"] = $row->count_rooms;
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["date"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["from"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["to"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	            // $last_id = $row->dc_log_id;
	            if ($row->dc_log_id > $last_id) {
	                $last_id = $row->dc_log_id;
	            }
	        }
	    } else {
	        $data_return ["response"] = 3;
	        return $data_return;
	    }
	
	    $categories_rooms_intdate = array ();
	
	    $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
	    FROM  `rooms`
	    INNER JOIN categories ON categories.id = rooms.category_id
	    INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
	    INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
	    dc_log.categoryid = rooms.category_id
	    WHERE dc_log.dc_id = 26 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.dc_hotel_id = $hotel_id
	    GROUP BY deskofdays.intdate, rooms.category_id";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            // count_rooms_booking
	            $categories_rooms_intdate [$row->id] [$row->intdate] ["free"] = $row->count_rooms;
	        }
	    }
	
	    $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log ( 26 );
	    $overbooking_reservations_array = array ();
	    if (isset ( $datein_out_mass ["intdatein"] )) {
	        $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat ( $datein_out_mass ["intdatein"], $datein_out_mass ["intdateout"] );
	    }
	
	    $setrestrict_result = "";
	    $result = "";

	    if ($general_update == 1) {
	        $category_keys = array_keys ( $categories_rooms_all );
	        foreach ( $category_keys as $category_id ) {
	
	            $sql = "select min, max from dc_tvil_room_categories_link where hms_category_id = " . $category_id;
	            $query = $this->db->query ( $sql );
	            if ($query->num_rows () > 0) {
	                $row2 = $query->row ();
	                $min = $row2->min;
	                $max = $row2->max;
	            } else {
	                $min = 0;
	                $max = 999;
	            }
	
	            $arr_intdate_keys = array_keys ( $categories_rooms_all [$category_id] );
	            foreach ( $arr_intdate_keys as $intdate ) {
	                if ($categories_rooms_all[$category_id][$intdate]["closed"] == 1) {
	                    $categories_rooms_all[$category_id][$intdate]["free"] = 0;
	                } else {
	                    if (isset($categories_rooms_intdate[$category_id][$intdate])) {
	                        $count_overbook_rooms = 0;
	                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
	                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
	                        }
	                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
	                    } else {
	                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
	                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
	                            $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $count_overbook_rooms;
	                        }
	                    }
	
	                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
	                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
	                    } else {
	                        $categories_rooms_all[$category_id][$intdate]["free"] = 0;
	                    }
	
	                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
	                        $categories_rooms_all[$category_id][$intdate]["free"] = $max;
	                    }
	                    
	                    // коррекція к-сті відповідно умовам ф-ї availability_count_correction
	                    $startdate = $enddate = date("Y-m-d", $intdate*86400);
	                    $categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
                        
	                }
	                	
	                if (true) {
	                    $prev = $intdate - 1;
	                    if (isset ( $categories_rooms_all [$category_id] [$prev] )) {
	                        $free_1 = $categories_rooms_all [$category_id] [$prev] ["free"];
	                        $free_2 = $categories_rooms_all [$category_id] [$intdate] ["free"];
	                        //$min_stay_arrival_1 = $categories_rooms_all [$category_id] [$prev] ["min_stay_arrival"];
	                        //$min_stay_arrival_2 = $categories_rooms_all [$category_id] [$intdate] ["min_stay_arrival"];
	                        	
	                        //if ($free_1 == $free_2 && $min_stay_arrival_1 == $min_stay_arrival_2) {
	                        if ($free_1 == $free_2) {
	                            $categories_rooms_all [$category_id] [$intdate] ["from"] = $categories_rooms_all [$category_id] [$prev] ["from"];
	                            unset ( $categories_rooms_all [$category_id] [$prev] );
	                        }
	                    }
	                }
	            }
	        }
	        	
	        /*
	         * foreach ( $categories_rooms_all as $category_id => $intdates ) { foreach ( $intdates as $intdate => $cell ) { $todate = $categories_rooms_all [$category_id] [$intdate] ["to"]; list ( $year, $month, $day ) = explode ( "-", $todate ); $intdate_to = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 ); $intdate_to = $intdate_to + 1; $categories_rooms_all [$category_id] [$intdate] ["to"] = gmdate ( "Y-m-d", $intdate_to * 86400 ); } }
	         */
	        	
	        // echo "<pre>";
	        // print_r ( $categories_rooms_all );
	        // die();
	        $roomslist = array ();
	        foreach ( $categories_rooms_all as $category_id => $dates ) {
	            foreach ( $dates as $intdate => $cell ) {
// 	                if ($cell["min_stay_arrival"] > 0) {
//                         array_push($roomslist, array(
//                             'startDateYmd' => $cell["from"],
//                             'endDateYmd' => $cell["to"],
//                             'roomTypeId' => $cell["dc_room_id"],
//                             'quota' => (string) $cell["free"],
//                             'min_stay_arrival' => (string) $cell["min_stay_arrival"]
//                         ));
//                     }else{
                        array_push($roomslist, array(
                            'startDateYmd' => $cell["from"],
                            'endDateYmd' => $cell["to"],
                            'roomTypeId' => $cell["dc_room_id"],
                            'quota' => (string) $cell["free"]
                        ));
                    //}
	            }
	        }
	        	
// 	        echo "<pre>";
// 	        print_r ( $roomslist );
// 	        die();	
	        if (count ( $roomslist ) < 1) {
	            $query = $this->db->query ( "DELETE FROM dc_log WHERE dc_id = 26 AND dc_hotel_id = $hotel_id" );
	            $data_return ["response"] = 4;
	            return $data_return;
	        }
	        	
	        $request = array ();
	        $request ["username"] = $authparam ["eqc_user"];
	        $request ["password"] = $authparam ["eqc_password"];
	        $request ["action"] = "update";
	        $request ["data"] ["hotelId"] = $authparam ["hotel_id"];
	        $request ["data"] ["updates"] = $roomslist;
	        echo "<pre>";
	        print_r ( $request );
	        $json_request = json_encode ( $request );
	        echo "<br>".$json_request."<br>";

	        // перевірка checksum START
	        $availability_checksum = $this->db->select('str_value')->
	                                            get_where('dc_tvil_xml_cfg', array('name' => 'availability_checksum'))->
	                                            row()->str_value;
	        
	        if($availability_checksum == md5($json_request)){
	            $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 26 AND dc_hotel_id = $hotel_id AND time < " . $last_time;
	            $query = $this->db->query ( $sql );
	            
	            $data_return ["response"] = 3;
	            return $data_return;
	        }
	        // перевірка checksum END
	        
	        // фіксація checksum
	        $data_checksum = array(
	            'name' => 'availability_checksum',
	            'str_value' => md5($json_request)
	        );
	        $keys = array('name');
	        $this->frontdesk_c2->db_insert_on_duplicate_key_update('`dc_tvil_xml_cfg`', $data_checksum, $keys);
	         
	        
	        $url = "https://chm.tvil.ru/otelms";
	        $data_result = $this->Curl_model->CurlPlugRaw_tvil ( $json_request, $url, array("returntype" => "array") );
	        	
	        $result_array = json_decode ( $data_result ["result"], 1 );
	        	
	        echo $data_result ["result"]."++++";
	        print_r ( $data_result );
	        $dc_log_id = $data_result ["dc_log_id"];
	        	
	        $data_return ["dc_log_id"] = $dc_log_id;
	        $data_return ["datein"] = gmdate ( "Y-m-d", $min_date * 86400 );
	        $data_return ["dateout"] = gmdate ( "Y-m-d", $max_date * 86400 );
	        	
	        //$result = json_decode ( json_encode ( $data_result ["result"] ), 1 );
	        	
	    }
	
	    if ($general_update == 0) {
	        echo "Ban upload for booking service";
	    } else {
	        if ($result_array["success"] == true) {
	            $data_return ["response"] = 1;
	            $data_return ["responsebody"] = "success";
	            $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 26 AND dc_hotel_id = $hotel_id AND time < " . $last_time;
	            $query = $this->db->query ( $sql );
	        } else {
	            $data_return ["response"] = 0;
	            $data_return ["errmsg"] = $result_array ['error'];
	            $data_return ["responsebody"] = $result_array ['error'];
	            // $query = $this->db->query ( "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 21 AND time < " . $last_time );

	            $error_checksum = $this->db->select('str_value')->
	                                         get_where('dc_tvil_xml_cfg', array('name' => 'error_checksum'))->
	                                         row()->str_value;
	            
	            if($error_checksum == md5($data_result ["result"])){
	                $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 26 AND dc_hotel_id = $hotel_id AND time < " . $last_time;
	                $query = $this->db->query ( $sql );    
	            }
	        }
	        return $data_return;
	    }
	}
	
	function setavailability_lastchanged_40($dc_account_id = 0){
	    $authparam = $this->dcm_su->getauthparam($dc_account_id);
	    $hotel_id = $authparam ["hotel_id_int"];
	    $hotel_id_str = $authparam ["hotel_id"];
	    $general_update = 1;
// 	    $sql = "SELECT int_value FROM dc_su_xml_cfg WHERE name LIKE 'general_update'";
// 	    $query = $this->db->query ( $sql );
// 	    if ($query->num_rows () > 0) {
// 	        $row = $query->row ();
// 	        $general_update = $row->int_value;
// 	    }
	    $data_return = array ();
	    if ($general_update == 1) {
	    } else {
	        $data_return ["response"] = 2;
	        return $data_return;
	    }
	    $min_date = 0;
	    $max_date = 0;
	    $categories_rooms_all = array ();
	
	    $intdate_today = floor ( time () / 86400 );
	    $last_id = 0;
	    $last_time = time ();

	    $sql = "SELECT dc_su_categories_strtoint.dc_room_id,
	    dc_log.id as dc_log_id, categories.id as category_id,
	    dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms
	    FROM categories
	    INNER JOIN dc_log ON dc_log.categoryid = categories.id
	    INNER JOIN dc_su_room_categories_link ON dc_su_room_categories_link.hms_category_id = dc_log.categoryid
	    INNER JOIN dc_su_categories_strtoint ON dc_su_categories_strtoint.id = dc_su_room_categories_link.dc_category_id
	    LEFT JOIN rooms ON rooms.category_id = categories.id AND rooms.dc_active = 1
	    WHERE dc_log.dc_id = 40 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.intdate >= " . $intdate_today . "
		GROUP BY dc_log.categoryid, dc_log.intdate";
	   
	    $query = $this->db->query ( $sql );
	    echo $sql;
	    //die();
	
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            if ($min_date == 0) {
	                $min_date = $row->log_intdate;
	            } else {
	                if ($row->log_intdate < $min_date) {
	                    $min_date = $row->log_intdate;
	                }
	            }
	
	            if ($max_date == 0) {
	                $max_date = $row->log_intdate;
	            } else {
	                if ($row->log_intdate > $max_date) {
	                    $max_date = $row->log_intdate;
	                }
	            }

	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["dc_room_id"] = $row->dc_room_id;
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["free"] = $row->count_rooms;
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["date"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["from"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["to"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	            // $last_id = $row->dc_log_id;
	            if ($row->dc_log_id > $last_id) {
	                $last_id = $row->dc_log_id;
	            }
	        }
	    } else {
	        $data_return ["response"] = 3;
	        return $data_return;
	    }
	    //echo "<pre>";
	    //print_r ( $categories_rooms_all );
	    $categories_rooms_intdate = array ();
	
	    $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
	    FROM  `rooms`
	    INNER JOIN categories ON categories.id = rooms.category_id
	    INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
	    INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
	    dc_log.categoryid = rooms.category_id
	    WHERE dc_log.dc_id = 40 AND dc_log.dc_hotel_id = $hotel_id 
	    GROUP BY deskofdays.intdate, rooms.category_id";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            // count_rooms_booking
	            $categories_rooms_intdate [$row->id] [$row->intdate] ["free"] = $row->count_rooms;
	        }
	    }
	    //echo "<pre>";
	    //print_r ( $categories_rooms_intdate );
	    $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log ( 40 );
	    $overbooking_reservations_array = array ();
	    if (isset ( $datein_out_mass ["intdatein"] )) {
	        $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat ( $datein_out_mass ["intdatein"], $datein_out_mass ["intdateout"] );
	    }

	    $result = "";
	
	    if ($general_update == 1) {
	        $category_keys = array_keys ( $categories_rooms_all );
	        foreach ( $category_keys as $category_id ) {
	
	            $sql = "select min, max from dc_su_room_categories_link where hms_category_id = " . $category_id;
	            $query = $this->db->query ( $sql );
	            if ($query->num_rows () > 0) {
	                $row2 = $query->row ();
	                $min = $row2->min;
	                $max = $row2->max;
	            } else {
	                $min = 0;
	                $max = 999;
	            }
	
	            $arr_intdate_keys = array_keys ( $categories_rooms_all [$category_id] );
	            foreach ( $arr_intdate_keys as $intdate ) {
// 	                if ($categories_rooms_all[$category_id][$intdate]["closed"] == 1) {
// 	                    $categories_rooms_all[$category_id][$intdate]["free"] = 0;
// 	                } else {
	                    if (isset($categories_rooms_intdate[$category_id][$intdate])) {
	                        $count_overbook_rooms = 0;
	                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
	                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
	                        }
	                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
	                    } else {
	                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
	                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
	                            $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $count_overbook_rooms;
	                        }
	                    }
	
	                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
	                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
	                    } else {
	                        $categories_rooms_all[$category_id][$intdate]["free"] = 0;
	                    }
	
	                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
	                        $categories_rooms_all[$category_id][$intdate]["free"] = $max;
	                    }
	                     
	                    // коррекція к-сті відповідно умовам ф-ї availability_count_correction
	                    $startdate = $enddate = date("Y-m-d", $intdate*86400);
	                    $categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
	
	                //}
	
	                if (true) {
	                    $prev = $intdate - 1;
	                    if (isset ( $categories_rooms_all [$category_id] [$prev] )) {
	                        $free_1 = $categories_rooms_all [$category_id] [$prev] ["free"];
	                        $free_2 = $categories_rooms_all [$category_id] [$intdate] ["free"];

	                        if ($free_1 == $free_2) {
	                            $categories_rooms_all [$category_id] [$intdate] ["from"] = $categories_rooms_all [$category_id] [$prev] ["from"];
	                            unset ( $categories_rooms_all [$category_id] [$prev] );
	                        }
	                    }
	                }
	            }
	        }
	        //echo "<pre>";
	        //print_r($categories_rooms_all);
	        $roomslist = array ();
	        foreach ( $categories_rooms_all as $category_id => $dates ) {
	            $room_dates = array();
	            foreach ( $dates as $intdate => $cell ) {
	                $room_id = $cell["dc_room_id"];
	                array_push($room_dates, array(
	                    'from' => $cell["from"],
	                    'to' => $cell["to"],
	                    'roomstosell' => $cell["free"]
	                ));

                }
                array_push($roomslist, array(
                    'id' => $room_id,
                    'date' => $room_dates
                ));
                
            }
                        
	        if (count ( $roomslist ) < 1) {
	            $query = $this->db->query ( "DELETE FROM dc_log WHERE dc_id = 40 AND dc_hotel_id = $hotel_id" );
	            $data_return ["response"] = 4;
	            return $data_return;
	        }
	
	        $curl_data = array();
	        $curl_data["url"] = $this->dcm_su->url . 'availability';
	        $curl_data["auth"] = $this->dcm_su->auth;
	        $curl_data["dc_id"] = $this->dcm_su->dc_id;
	        $curl_data["returntype"] = "full";
	        $curl_data['request'] = array('hotelid' => $hotel_id_str, 'room' => $roomslist);
	        $curl_data["test_mode"] = $this->dcm_su->test_mode;
	        //echo "<pre>";
	        //print_r ( $curl_data );
	        
	        $data_result = $this->Curl_model->curl_su($curl_data);
	
	        $result_array = json_decode ( $data_result ["result"], 1 );
	
	        echo $data_result ["result"]."++++";
	        print_r ( $result_array );
	        //die();
	        $dc_log_id = $data_result ["dc_log_id"];
	
	        $data_return ["dc_log_id"] = $dc_log_id;
	        $data_return ["datein"] = gmdate ( "Y-m-d", $min_date * 86400 );
	        $data_return ["dateout"] = gmdate ( "Y-m-d", $max_date * 86400 );
	    }
	
	    if ($general_update == 0) {
	        echo "Ban upload for booking service";
	    } else {
	        if ($result_array["Status"] == 'Success') {
	            $data_return ["response"] = 1;
	            $data_return ["responsebody"] = "success";
	            $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 40 AND dc_hotel_id = $hotel_id AND time < " . $last_time;
	            $query = $this->db->query ( $sql );
            } else {
                $data_return["response"] = 0;
                $data_return["errmsg"] = $data_result["result"];
                $data_return["responsebody"] = $data_result["result"];
                
                $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 40 AND dc_hotel_id = $hotel_id AND time < " . $last_time;
                $query = $this->db->query($sql);
            }
	        return $data_return;
	    }
	}
	
	function setavailability_lastchanged_40_notuse($hotel_id = 0, $hms_id = 0){
	    $data_return = array ();
	    $hotel_id_str = "hms-$hms_id-$hotel_id";
	    $min_date = 0;
	    $max_date = 0;
	    $categories_rooms_all = array ();
	
	    $intdate_today = floor ( time () / 86400 );
	    $last_id = 0;
	    $last_time = time ();
	
	    $sql = "SELECT dc_su_categories_strtoint.dc_room_id,
	    dc_log.id as dc_log_id, categories.id as category_id,
	    dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms
	    FROM categories
	    INNER JOIN dc_log ON dc_log.categoryid = categories.id
	    INNER JOIN dc_su_room_categories_link ON dc_su_room_categories_link.hms_category_id = dc_log.categoryid
	    INNER JOIN dc_su_categories_strtoint ON dc_su_categories_strtoint.id = dc_su_room_categories_link.dc_category_id
	    LEFT JOIN rooms ON rooms.category_id = categories.id AND rooms.dc_active = 1
	    WHERE dc_log.dc_id = 40 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.intdate >= " . $intdate_today . "
		GROUP BY dc_log.categoryid, dc_log.intdate";
	     
	    $sql = "SELECT dc_su_api_categories_active.hms_category_id as dc_room_id,
	    dc_log.id as dc_log_id, categories.id as category_id,
	    dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms
	    FROM categories
	    INNER JOIN dc_log ON dc_log.categoryid = categories.id
	    INNER JOIN dc_su_api_categories_active ON dc_su_api_categories_active.hms_category_id = dc_log.categoryid
	    LEFT JOIN rooms ON rooms.category_id = categories.id AND rooms.dc_active = 1
	    WHERE dc_log.dc_id = 40 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.intdate >= " . $intdate_today . "
		GROUP BY dc_log.categoryid, dc_log.intdate";
	    $query = $this->db->query ( $sql );
	    echo $sql;
	    //die();
	
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            if ($min_date == 0) {
	                $min_date = $row->log_intdate;
	            } else {
	                if ($row->log_intdate < $min_date) {
	                    $min_date = $row->log_intdate;
	                }
	            }
	
	            if ($max_date == 0) {
	                $max_date = $row->log_intdate;
	            } else {
	                if ($row->log_intdate > $max_date) {
	                    $max_date = $row->log_intdate;
	                }
	            }
	
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["dc_room_id"] = $hms_id."-".$hotel_id."-".$row->dc_room_id;
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["free"] = $row->count_rooms;
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["date"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["from"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["to"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	            // $last_id = $row->dc_log_id;
	            if ($row->dc_log_id > $last_id) {
	                $last_id = $row->dc_log_id;
	            }
	        }
	    } else {
	        $data_return ["response"] = 3;
	        return $data_return;
	    }
	    //echo "<pre>";
	    //print_r ( $categories_rooms_all );
	    $categories_rooms_intdate = array ();
	
	    $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
	    FROM  `rooms`
	    INNER JOIN categories ON categories.id = rooms.category_id
	    INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
	    INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
	    dc_log.categoryid = rooms.category_id
	    WHERE dc_log.dc_id = 40 AND dc_log.dc_hotel_id = $hotel_id
	    GROUP BY deskofdays.intdate, rooms.category_id";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            // count_rooms_booking
	            $categories_rooms_intdate [$row->id] [$row->intdate] ["free"] = $row->count_rooms;
	        }
	    }
	    //echo "<pre>";
	    //print_r ( $categories_rooms_intdate );
	    $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log ( 40 );
	    $overbooking_reservations_array = array ();
	    if (isset ( $datein_out_mass ["intdatein"] )) {
	        $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat ( $datein_out_mass ["intdatein"], $datein_out_mass ["intdateout"] );
	    }
	
	    $result = "";
	
	    //if ($general_update == 1 || 1 == 1) {
	        $category_keys = array_keys ( $categories_rooms_all );
	        foreach ( $category_keys as $category_id ) {
	
// 	            $sql = "select min, max from dc_su_room_categories_link where hms_category_id = " . $category_id;
// 	            $query = $this->db->query ( $sql );
// 	            if ($query->num_rows () > 0) {
// 	                $row2 = $query->row ();
// 	                $min = $row2->min;
// 	                $max = $row2->max;
// 	            } else {
// 	                $min = 0;
// 	                $max = 999;
// 	            }

	            $min = 0;
	            $max = 999;
	
	            $arr_intdate_keys = array_keys ( $categories_rooms_all [$category_id] );
	            foreach ( $arr_intdate_keys as $intdate ) {
	                // 	                if ($categories_rooms_all[$category_id][$intdate]["closed"] == 1) {
	                // 	                    $categories_rooms_all[$category_id][$intdate]["free"] = 0;
	                // 	                } else {
	                if (isset($categories_rooms_intdate[$category_id][$intdate])) {
	                    $count_overbook_rooms = 0;
	                    if (isset($overbooking_reservations_array[$category_id][$intdate])) {
	                        $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
	                    }
	                    $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
	                } else {
	                    if (isset($overbooking_reservations_array[$category_id][$intdate])) {
	                        $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
	                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $count_overbook_rooms;
	                    }
	                }
	
	                if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
	                    $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
	                } else {
	                    $categories_rooms_all[$category_id][$intdate]["free"] = 0;
	                }
	
	                if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
	                    $categories_rooms_all[$category_id][$intdate]["free"] = $max;
	                }
	
	                // коррекція к-сті відповідно умовам ф-ї availability_count_correction
	                $startdate = $enddate = date("Y-m-d", $intdate*86400);
	                $categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
	
	                //}
	
	                if (true) {
	                    $prev = $intdate - 1;
	                    if (isset ( $categories_rooms_all [$category_id] [$prev] )) {
	                        $free_1 = $categories_rooms_all [$category_id] [$prev] ["free"];
	                        $free_2 = $categories_rooms_all [$category_id] [$intdate] ["free"];
	
	                        if ($free_1 == $free_2) {
	                            $categories_rooms_all [$category_id] [$intdate] ["from"] = $categories_rooms_all [$category_id] [$prev] ["from"];
	                            unset ( $categories_rooms_all [$category_id] [$prev] );
	                        }
	                    }
	                }
	            }
	        }
	        //echo "<pre>";
	        //print_r($categories_rooms_all);
	        $roomslist = array ();
	        foreach ( $categories_rooms_all as $category_id => $dates ) {
	            $room_dates = array();
	            foreach ( $dates as $intdate => $cell ) {
	                $room_id = $cell["dc_room_id"];
	                array_push($room_dates, array(
	                    'from' => $cell["from"],
	                    'to' => $cell["to"],
	                    'roomstosell' => $cell["free"]
	                ));
	
	            }
	            array_push($roomslist, array(
	                'id' => $room_id,
	                'date' => $room_dates
	            ));
	
	        }
	
	        if (count ( $roomslist ) < 1) {
	            $query = $this->db->query ( "DELETE FROM dc_log WHERE dc_id = 40 AND dc_hotel_id = $hotel_id" );
	            $data_return ["response"] = 4;
	            return $data_return;
	        }
	
	        $curl_data = array();
	        $curl_data["url"] = $this->dcm_su->url . 'availability';
	        $curl_data["auth"] = $this->dcm_su->auth;
	        $curl_data["dc_id"] = $this->dcm_su->dc_id;
	        $curl_data["returntype"] = "full";
	        $curl_data['request'] = array('hotelid' => $hotel_id_str, 'room' => $roomslist);
	        $curl_data["test_mode"] = $this->dcm_su->test_mode;
	        echo "<pre>";
	        print_r ( $curl_data );
	        // die();
	        $data_result = $this->Curl_model->curl_su($curl_data);
	
	        $result_array = json_decode ( $data_result ["result"], 1 );
	
	        echo $data_result ["result"]."++++";
	        print_r ( $result_array );
	        //die();
	        $dc_log_id = $data_result ["dc_log_id"];
	
	        $data_return ["dc_log_id"] = $dc_log_id;
	        $data_return ["datein"] = gmdate ( "Y-m-d", $min_date * 86400 );
	        $data_return ["dateout"] = gmdate ( "Y-m-d", $max_date * 86400 );
	    //}
	
// 	    if ($general_update == 0) {
// 	        echo "Ban upload for booking service";
// 	    } else {
	        if ($result_array["Status"] == 'Success') {
	            $data_return ["response"] = 1;
	            $data_return ["responsebody"] = "success";
	            $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 40 AND dc_hotel_id = $hotel_id AND time < " . $last_time;
	            $query = $this->db->query ( $sql );
	        } else {
	            $data_return["response"] = 0;
	            $data_return["errmsg"] = $data_result["result"];
	            $data_return["responsebody"] = $data_result["result"];
	
	            $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 40 AND dc_hotel_id = $hotel_id AND time < " . $last_time;
	            $query = $this->db->query($sql);
	        }
	        return $data_return;
	    //}
	}
	
	function setavailability_lastchanged_36($dc_account_id = 0) {
        $authparam = $this->dcm_yandex->getauthparam($dc_account_id);
        $hotel_id = $authparam["hotel_id"];
        $access_token = $authparam["token"];
        $url = $authparam["url"] . "/extranet/v1/hotels/$hotel_id/inventory/availability";
        
            	
	    $general_update = 0;
	    $sql = "SELECT int_value FROM dc_yandex_xml_cfg WHERE name LIKE 'general_update'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $general_update = $row->int_value;
	    }
	    $data_return = array ();
	    if ($general_update == 1) {
	    } else {
	        $data_return ["response"] = 2;
	        return $data_return;
	    }
	
	    $min_date = 0;
	    $max_date = 0;
	    $categories_rooms_all = array ();
	
	    $intdate_today = floor ( time () / 86400 );
	    $last_id = 0;
	    $last_time = time ();
	
	    $sql = "SELECT dc_yandex_room_categories_link.dc_category_id, dc_log.id as dc_log_id, categories.id as category_id,
		dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms
		FROM dc_log
		INNER JOIN categories ON dc_log.categoryid = categories.id
		INNER JOIN dc_yandex_room_categories_link ON dc_yandex_room_categories_link.hms_category_id = dc_log.categoryid
		LEFT JOIN rooms ON rooms.category_id = categories.id AND rooms.dc_active = 1
		WHERE dc_log.dc_id = 36 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.intdate >= " . $intdate_today . "
		GROUP BY dc_log.categoryid, dc_log.intdate";
	    $query = $this->db->query ( $sql );
	    // echo $sql;
	   
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            if ($min_date == 0) {
	                $min_date = $row->log_intdate;
	            } else {
	                if ($row->log_intdate < $min_date) {
	                    $min_date = $row->log_intdate;
	                }
	            }
	
	            if ($max_date == 0) {
	                $max_date = $row->log_intdate;
	            } else {
	                if ($row->log_intdate > $max_date) {
	                    $max_date = $row->log_intdate;
	                }
	            }
	
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["dc_room_id"] = $row->dc_category_id;
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["currency"] = "RUB";
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["free"] = $row->count_rooms;
	            //$categories_rooms_all [$row->category_id] [$row->log_intdate] ["date"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["from"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["to"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	            // $last_id = $row->dc_log_id;
	            if ($row->dc_log_id > $last_id) {
	                $last_id = $row->dc_log_id;
	            }
	        }
	    } else {
	        $sql = "DELETE FROM dc_log WHERE dc_id = 36 AND dc_hotel_id = $hotel_id";
	        $query = $this->db->query ( $sql );
	        $data_return ["response"] = 3;
	        return $data_return;
	    }
	
	    $categories_rooms_intdate = array ();
	
	    $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
	    FROM  `rooms`
	    INNER JOIN categories ON categories.id = rooms.category_id
	    INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
	    INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
	    dc_log.categoryid = rooms.category_id
	    WHERE dc_log.dc_id = 36 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.dc_hotel_id = $hotel_id
	    GROUP BY deskofdays.intdate, rooms.category_id";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            // count_rooms_booking
	            $categories_rooms_intdate [$row->id] [$row->intdate] ["free"] = $row->count_rooms;
	        }
	    }
	
	    $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log ( 36 );
	    $overbooking_reservations_array = array ();
	    if (isset ( $datein_out_mass ["intdatein"] )) {
	        $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat ( $datein_out_mass ["intdatein"], $datein_out_mass ["intdateout"] );
	    }
	
	    $setrestrict_result = "";
	    $result = "";
	    $sql = "SELECT int_value FROM dc_yandex_xml_cfg WHERE name LIKE 'general_update'";
	    $query = $this->db->query ( $sql );
	
	    if ($general_update == 1) {
	        $category_keys = array_keys ( $categories_rooms_all );
	        foreach ( $category_keys as $category_id ) {
	
	            $sql = "select min, max from dc_yandex_room_categories_link where hms_category_id = " . $category_id;
	            $query = $this->db->query ( $sql );
	            if ($query->num_rows () > 0) {
	                $row2 = $query->row ();
	                $min = $row2->min;
	                $max = $row2->max;
	            } else {
	                $min = 0;
	                $max = 999;
	            }
	
	            $arr_intdate_keys = array_keys ( $categories_rooms_all [$category_id] );
	            foreach ( $arr_intdate_keys as $intdate ) {
	                //if ($categories_rooms_all[$category_id][$intdate]["closed"] == 1) {
	                //    $categories_rooms_all[$category_id][$intdate]["free"] = 0;
	                //} else {
	                    if (isset($categories_rooms_intdate[$category_id][$intdate])) {
	                        $count_overbook_rooms = 0;
	                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
	                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
	                        }
	                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
	                    } else {
	                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
	                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
	                            $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $count_overbook_rooms;
	                        }
	                    }
	
	                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
	                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
	                    } else {
	                        $categories_rooms_all[$category_id][$intdate]["free"] = 0;
	                    }
	
	                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
	                        $categories_rooms_all[$category_id][$intdate]["free"] = $max;
	                    }
	
	                    // коррекція к-сті відповідно умовам ф-ї availability_count_correction
	                    $startdate = $enddate = date("Y-m-d", $intdate*86400);
	                    $categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
	                //}
	
	                if (true) {
	                    $prev = $intdate - 1;
	                    if (isset ( $categories_rooms_all [$category_id] [$prev] )) {
	                        $free_1 = $categories_rooms_all [$category_id] [$prev] ["free"];
	                        $free_2 = $categories_rooms_all [$category_id] [$intdate] ["free"];
	
	                        if ($free_1 == $free_2) {
	                            $categories_rooms_all [$category_id] [$intdate] ["from"] = $categories_rooms_all [$category_id] [$prev] ["from"];
	                            unset ( $categories_rooms_all [$category_id] [$prev] );
	                        }
	                    }
	                }
	            }
	        }
	
	        //echo "<pre>";
	        //print_r ( $categories_rooms_all );
	        //die();
	        
	        $roomslist = array ();
	        foreach ( $categories_rooms_all as $category_id => $category_dates ) {
	            
	            $date_full = array();
	            foreach ( $category_dates as $intdate => $cell ) {
	                $dc_room_id = $cell ["dc_room_id"];
	                list ( $year, $month, $day ) = explode ( "-", $cell ["to"] );
	                $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day+1, $year ) / 86400 );
	                $cell ["to"] = date('Y-m-d', $intdatein*86400);
	                
	                $dates = array (
	                    'start' => $cell ["from"],
	                    'end' => $cell ["to"]
	                );
	                
	                array_push ( $date_full, array (
	                    'range' => $dates,
	                    'rooms_available' => $cell ["free"]
	                ) );
	            }
	             
	            array_push($roomslist, array(
	                'category_id' => $dc_room_id,
	                'updates' => $date_full
	            ));
	        }
            //echo "<pre>";
            //print_r($roomslist);
	        //die();
	        if (count ( $roomslist ) < 1) {
	            $query = $this->db->query ( "DELETE FROM dc_log WHERE dc_id = 36 AND dc_hotel_id = $hotel_id" );
	            $data_return ["response"] = 4;
	            return $data_return;
	        }
	
	        $request = array ();
	        $request ["categories"] = $roomslist;
	        $json_request = json_encode( $request);
	        //echo "<br>".$json_request."<br>";

	        
	        $curl_data = array();
            $curl_data ['access_token'] = $access_token;
            $curl_data ['url'] = $url;
            $curl_data ["returntype"] = "array";
            $curl_data ["request"] = $json_request;
	        $data_result = $this->Curl_model->curl_yandex_uploads ( $curl_data );
	
	        $result_array = json_decode ( $data_result ["result"], 1 );
	        
            unset($curl_data['access_token']);
            unset($curl_data['returntype']);
            
            if ($this->session->userdata('global_debug') == 1) {
                echo "<h3>set quota ($hotel_id)</h3>";
                echo "<b>REQUEST:</b>";
                echo "<br>";
                echo json_encode($curl_data, true);
                echo "<br>";
                echo "<b>RESPONSE:</b>";
                echo "<br>";
                echo json_encode($result_array, true);
                echo "<hr>";
            }
	        
	        
	        //echo $data_result ["result"]."++++";
	        //print_r ( $data_result );
	        //die();
	        $dc_log_id = $data_result ["dc_log_id"];
	
	        $data_return ["dc_log_id"] = $dc_log_id;
	        $data_return ["datein"] = gmdate ( "Y-m-d", $min_date * 86400 );
	        $data_return ["dateout"] = gmdate ( "Y-m-d", $max_date * 86400 );
	
	        //$result = json_decode ( json_encode ( $data_result ["result"] ), 1 );
	
	    }
	
	    if ($general_update == 0) {
	        echo "Ban upload for booking service";
	    } else {
	        $no_success = 0;
	        if(isset($result_array["status"])){
	            if ($result_array["status"] == 408 || $result_array["status"] == 400){
	               $no_success = 1; 
	            }
	        }
	        
	        if($data_result ["responseint"] != 200 && $data_result ["responseint"] != 201 && $data_result ["responseint"] != 202 && $data_result ["responseint"] != 204){
	            $no_success = 1;
	        }
	        
	        if (count($result_array["errors"]) == 0 && $no_success == 0) {
	            $data_return ["response"] = 1;
	            $data_return ["responsebody"] = "success";
	            $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 36 AND dc_hotel_id = $hotel_id AND time < " . $last_time;
	            $query = $this->db->query ( $sql );
	        } else {
	            $result_array['http_code'] = $data_result ["responseint"];
	            $data_return ["response"] = 0;
	            $data_return ["errmsg"] = json_encode($result_array, true);
	            $data_return ["responsebody"] = json_encode($result_array, true);
	            $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 36 AND dc_hotel_id = $hotel_id AND time < " . $last_time;
	            $query = $this->db->query ( $sql );
	        }
	        return $data_return;
	    }
	}
	
	function setavailability_lastchanged_27($dc_account_id = 0) {
	    
// 	    $query = $this->db->query ( "DELETE FROM dc_log WHERE dc_id = 27" );
// 	    $query = $this->db->query ( "DELETE FROM dc_log_rate WHERE dc_id = 27" );
// 	    $query = $this->db->query ( "DELETE FROM dc_log_restrict WHERE dc_id = 27" );
// 	    $query = $this->db->query ( "DELETE FROM dc_log_yieldprice WHERE dc_id = 27" );;
	    
	    
	    $authparam = $this->dcm_academservice->getauthparam($dc_account_id);
	    $dc_hotel_id = $authparam ["hotel_id"];
	
	    $general_update = 0;
	    $sql = "SELECT int_value FROM dc_academ_service_xml_cfg WHERE name LIKE 'general_update'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $general_update = $row->int_value;
	    }
	    $data_return = array ();
	    if ($general_update == 1) {
	    } else {
	        $data_return ["response"] = 2;
	        return $data_return;
	    }
	
	    
	    $restrict_rate_id = 0;
	    $sql = "SELECT int_value FROM dc_academ_service_xml_cfg WHERE name LIKE 'restrict_rate_id'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $restrict_rate_id = $row->int_value;
	    }
	    
	    $rate2category_link = array();
	    $sql = "SELECT dc_rate_id, dc_category_id, hms_rate_id FROM dc_academ_service_rate2category_link WHERE 1";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                if ($row->hms_rate_id > 0) {
                    $rate2category_link[$row->dc_rate_id][$row->dc_category_id] = 1;
                }
            }
        }
	    
	    //print_r($rate2category_link);
	    	
	    $min_date = 0;
	    $max_date = 0;
	    $categories_rooms_all = array ();
	
	    $intdate_today = floor ( time () / 86400 );
	    $last_id = 0;
	    $last_time = time ();
	    //dc_academ_service_rate2category_link.dc_rate_id, dc_academ_service_rate2category_link.hms_restrict_id, 
	    
	    // 		LEFT JOIN dc_academ_service_rate2category_link ON dc_academ_service_rate2category_link.dc_category_id = dc_academ_service_room_categories.dc_room_id
	    // 		LEFT JOIN deskofrate ON deskofrate.intdate = dc_log.intdate AND deskofrate.category_id = dc_academ_service_room_categories_link.hms_category_id
	    // 	            AND dc_academ_service_rate2category_link.hms_restrict_id = deskofrate.rate_id
	    $sql = "SELECT deskofrate.closed,
	    dc_academ_service_room_categories_link.dc_category_id, dc_log.id as dc_log_id, categories.id as category_id,
		dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms
		FROM categories
		INNER JOIN dc_log ON dc_log.categoryid = categories.id
		INNER JOIN dc_academ_service_room_categories_link ON dc_academ_service_room_categories_link.hms_category_id = dc_log.categoryid
		INNER JOIN dc_academ_service_room_categories ON 
		dc_academ_service_room_categories.dc_room_id = dc_academ_service_room_categories_link.dc_category_id 
		AND dc_academ_service_room_categories.dc_hotel_id = $dc_hotel_id
		LEFT JOIN rooms ON rooms.category_id = categories.id AND rooms.dc_active = 1
        LEFT JOIN deskofrate ON deskofrate.category_id = categories.id AND dc_log.intdate = deskofrate.intdate AND deskofrate.rate_id = " . $restrict_rate_id . "
		WHERE dc_log.dc_id = 27 AND dc_log.dc_hotel_id = $dc_hotel_id AND dc_log.intdate >= " . $intdate_today . "
		GROUP BY dc_log.categoryid, dc_log.intdate";
	    $query = $this->db->query ( $sql );
// 	    echo $sql;
// 	    die();
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            if ($min_date == 0) {
	                $min_date = $row->log_intdate;
	            } else {
	                if ($row->log_intdate < $min_date) {
	                    $min_date = $row->log_intdate;
	                }
	            }
	
	            if ($max_date == 0) {
	                $max_date = $row->log_intdate;
	            } else {
	                if ($row->log_intdate > $max_date) {
	                    $max_date = $row->log_intdate;
	                }
	            }
	
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["dc_room_id"] = $row->dc_category_id;
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["free"] = $row->count_rooms;
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["closed"] = $row->closed;
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["date"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["from"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["to"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	            // $last_id = $row->dc_log_id;
	            if ($row->dc_log_id > $last_id) {
	                $last_id = $row->dc_log_id;
	            }
	        }
	    } else {
	        $data_return ["response"] = 3;
	        return $data_return;
	    }
	
	    $categories_rooms_intdate = array ();
	
	    $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
	    FROM  `rooms`
	    INNER JOIN categories ON categories.id = rooms.category_id
	    INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
	    INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
	    dc_log.categoryid = rooms.category_id
	    WHERE dc_log.dc_id = 27 AND dc_log.dc_hotel_id = $dc_hotel_id AND dc_log.dc_hotel_id = $dc_hotel_id
	    GROUP BY deskofdays.intdate, rooms.category_id";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            // count_rooms_booking
	            $categories_rooms_intdate [$row->id] [$row->intdate] ["free"] = $row->count_rooms;
	        }
	    }
	
	    $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log ( 27 );
	    $overbooking_reservations_array = array ();
	    if (isset ( $datein_out_mass ["intdatein"] )) {
	        $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat ( $datein_out_mass ["intdatein"], $datein_out_mass ["intdateout"] );
	    }
	
	    $setrestrict_result = "";
	    $result = "";
	    $sql = "SELECT int_value FROM dc_academ_service_xml_cfg WHERE name LIKE 'general_update'";
	    $query = $this->db->query ( $sql );
	
	    if ($general_update == 1) {
	        $category_keys = array_keys ( $categories_rooms_all );
	        foreach ( $category_keys as $category_id ) {
	
	            $sql = "select min, max from dc_academ_service_room_categories_link where hms_category_id = " . $category_id;
	            $query = $this->db->query ( $sql );
	            if ($query->num_rows () > 0) {
	                $row2 = $query->row ();
	                $min = $row2->min;
	                $max = $row2->max;
	            } else {
	                $min = 0;
	                $max = 999;
	            }
	
	            $arr_intdate_keys = array_keys ( $categories_rooms_all [$category_id] );
	            foreach ($arr_intdate_keys as $intdate) {
                    if ($categories_rooms_all[$category_id][$intdate]["closed"] == 1) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = "close";
                    } else {
                        
                        if (isset($categories_rooms_intdate[$category_id][$intdate])) {
                            $count_overbook_rooms = 0;
                            if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                                $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                            }
                            $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
                        } else {
                            if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                                $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                                $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $count_overbook_rooms;
                            }
                        }
                        
                        if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
                            $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
                        } else {
                            $categories_rooms_all[$category_id][$intdate]["free"] = 0;
                        }
                        
                        if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
                            $categories_rooms_all[$category_id][$intdate]["free"] = $max;
                        }
                        
                        // коррекція к-сті відповідно умовам ф-ї availability_count_correction
                        $startdate = $enddate = date("Y-m-d", $intdate * 86400);
                        $categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
                    }
	                
                    if (true) {
                        $prev = $intdate - 1;
                        if (isset($categories_rooms_all[$category_id][$prev])) {
                            $free_1 = $categories_rooms_all[$category_id][$prev]["free"];
                            $free_2 = $categories_rooms_all[$category_id][$intdate]["free"];
                            
                            if ($free_1 == $free_2) {
                                $categories_rooms_all[$category_id][$intdate]["from"] = $categories_rooms_all[$category_id][$prev]["from"];
                                unset($categories_rooms_all[$category_id][$prev]);
                            }
                        }
                    }
                }
	        }
	        	        
// 	       $sql = "SELECT dc_academ_service_room_categories_link.dc_category_id, dc_academ_service_rate2category_link.dc_rate_id, 
// 	                  dc_academ_service_rate2category_link.hms_restrict_id, deskofrate.closed, dc_log.intdate as log_intdate
// 		              FROM categories
// 		              INNER JOIN dc_log ON dc_log.categoryid = categories.id
// 		              INNER JOIN dc_academ_service_room_categories_link ON dc_academ_service_room_categories_link.hms_category_id = dc_log.categoryid
// 	                  INNER JOIN dc_academ_service_rate2category_link ON dc_academ_service_rate2category_link.dc_category_id = dc_academ_service_room_categories_link.dc_category_id
// 	                  INNER JOIN dc_academ_service_rates ON dc_academ_service_rates.dc_rate_id = dc_academ_service_rate2category_link.dc_rate_id 
// 	                  AND dc_academ_service_rates.dc_hotel_id = $dc_hotel_id
// 		              LEFT JOIN deskofrate ON deskofrate.category_id = categories.id AND dc_log.intdate = deskofrate.intdate AND deskofrate.rate_id = dc_academ_service_rate2category_link.hms_restrict_id
// 	        		  WHERE dc_log.dc_id = 27 AND dc_log.dc_hotel_id = $dc_hotel_id AND dc_log.intdate >= " . $intdate_today . "
// 		              GROUP BY dc_log.categoryid, dc_academ_service_rate2category_link.dc_rate_id, dc_log.intdate";
// 	        echo $sql;
// 	        die();
	        
// 	        $restricts_array = array();
// 	        $query = $this->db->query ( $sql );
// 	        if ($query->num_rows () > 0) {
// 	            foreach ( $query->result () as $row ) {
// 	                $restricts_array[$row->dc_category_id][$row->dc_rate_id][$row->log_intdate]['closed']  = $row->closed;
// 	            }
// 	        }
	        
	        
	        $dc_rates = array();
	        $sql = "SELECT dc_rate_id FROM dc_academ_service_rates 
	        WHERE dc_hotel_id = ".$dc_hotel_id;
	        $query = $this->db->query ( $sql );
	        if ($query->num_rows () > 0) {
	            foreach ( $query->result () as $row ) {
	                $dc_rates[$row->dc_rate_id] = $row->dc_rate_id;
	            }
	        }
	        
	        $roomslist = array ();
	        foreach ($categories_rooms_all as $category_id => $dates) {
                foreach ($dates as $intdate => $cell) {
                    foreach ($dc_rates as $dc_rate_id) {
                        $availibility = (string) $cell["free"];
                        
//                         if(isset($restricts_array[$cell["dc_room_id"]][$dc_rate_id][$intdate]['closed'])){
//                             $closed = $restricts_array[$cell["dc_room_id"]][$dc_rate_id][$intdate]['closed'];
//                             if($closed == 1){
//                                 $availibility = "close";
//                             }
//                         }
                        if (isset($rate2category_link[$dc_rate_id][$cell["dc_room_id"]])) {
                            array_push($roomslist, array(
                                'roomId' => $cell["dc_room_id"],
                                'rateId' => $dc_rate_id,
                                'startDate' => $cell["from"],
                                'endDate' => $cell["to"],
                                'availability' => $availibility
                            ));
                        }
                    }
                }
            }
            
            
//             if (! true) {
//                 $record_count = count($roomslist);
//                 for ($i = 0; $i < $record_count; $i ++) {
//                     $prev = $i - 1;
//                     if (isset($roomslist[$prev])) {
//                         $dc_room_1 = $roomslist[$prev]["roomId"];
//                         $dc_room_2 = $roomslist[$i]["roomId"];
//                         $dc_rate_1 = $roomslist[$prev]["rateId"];
//                         $dc_rate_2 = $roomslist[$i]["rateId"];
//                         $availability_1 = $roomslist[$prev]["availability"];
//                         $availability_2 = $roomslist[$i]["availability"];
                        
//                         if ($availability_1 == $availability_2 && $dc_room_1 == $dc_room_2 && $dc_rate_1 == $dc_rate_2) {
//                             $roomslist[$i]["startDate"] = $roomslist[$prev]["startDate"];
//                             unset($roomslist[$prev]);
//                         }
//                     }
//                 }
//             }
	        	
// 	        echo "<pre>";
// 	        print_r ( $roomslist );
// 	        die();	
	        if (count ( $roomslist ) < 1) {
	            $query = $this->db->query ( "DELETE FROM dc_log WHERE dc_id = 27 AND dc_hotel_id = $dc_hotel_id" );
	            $data_return ["response"] = 4;
	            return $data_return;
	        }
	        
	        $username = $authparam["eqc_user"];
	        $password = $authparam["eqc_password"];
	        
	        $currency = $this->dcm_academservice->get_currency();
	        
	        $request = array ();
	        $request ["jsonrpc"] = "2.0";
	        $request ["method"] = "ARIPush";
	        $request ["params"]["systemId"] = 13;
	        $request ["params"]["systemName"] = "otelms";
	        $request ["params"]["login"] = $username;
	        $request ["params"]["password"] = $password;
	        $request ["params"]["language"] = "ru";
	        $request ["params"]["hotelId"] = intval($dc_hotel_id);
	        $request ["params"]["currency"] = $currency;
	        $request ["params"]["ari"] = $roomslist;
	        $request ["id"] = md5( "3170" . microtime(true) * 1000 );
	        
	        echo "<pre>";
	        print_r($request);
	         
	        $json_request =  json_encode( $request);
	        echo "<br>".$json_request."<br>";;
	        $url = $authparam["url"];
	        $data_result = $this->Curl_model->CurlPlugRaw_academservice ( $json_request, $url, array("returntype" => "array"));
	        	
	        $result_array = json_decode ( $data_result ["result"], 1 );
	        	
	        echo $data_result ["result"]."++++";
	        print_r ( $result_array );
	        //die();
	        $dc_log_id = $data_result ["dc_log_id"];
	        	
	        $data_return ["dc_log_id"] = $dc_log_id;
	        $data_return ["datein"] = gmdate ( "Y-m-d", $min_date * 86400 );
	        $data_return ["dateout"] = gmdate ( "Y-m-d", $max_date * 86400 );
	        	
	        //$result = json_decode ( json_encode ( $data_result ["result"] ), 1 );
	        	
	    }
	
	    if ($general_update == 0) {
	        echo "Ban upload for booking service";
	    } else {
	        if ($result_array["result"]["hotelId"] == $dc_hotel_id) {
	            $data_return ["response"] = 1;
	            $data_return ["responsebody"] = "success";
	            $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 27 AND dc_hotel_id = $dc_hotel_id AND time < " . $last_time;
	            $query = $this->db->query ( $sql );
	        } else {
	            $data_return ["response"] = 0;
	            $data_return ["errmsg"] = $result_array ['error'];
	            $data_return ["responsebody"] = $result_array ['error'];
	            $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 27 AND dc_hotel_id = $dc_hotel_id AND time < " . $last_time;
	            $query = $this->db->query ( $sql );
	            // $query = $this->db->query ( "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 21 AND time < " . $last_time );
	        }
	        return $data_return;
	    }
	}
	
	function setavailability_lastchanged_28($dc_account_id = 0) {
        $authparam = $this->dcm_aanda->getauthparam($dc_account_id);
        
	    $auth_key = $authparam ["auth_key"];
	    $hotel_id = $authparam ["hotel_auth_hotel_id"];
	
	    $general_update = 0;
	    $sql = "SELECT int_value FROM dc_aanda_xml_cfg WHERE name LIKE 'general_update'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $general_update = $row->int_value;
	    }
	    $data_return = array ();
	    if ($general_update == 1) {
	    } else {
	        $data_return ["response"] = 2;
	        return $data_return;
	    }
	
	    $restrict_rate_id = 0;
	    $sql = "SELECT int_value FROM dc_aanda_xml_cfg WHERE name LIKE 'restrict_rate_id'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $restrict_rate_id = $row->int_value;
	    }
	
	    $min_date = 0;
	    $max_date = 0;
	    $categories_rooms_all = array ();
	
	    $intdate_today = floor ( time () / 86400 );
	    $last_id = 0;
	    $last_time = time ();
	
	    $sql = "SELECT dc_aanda_room_categories_link.dc_category_id, dc_log.id as dc_log_id, categories.id as category_id,
		dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms
		FROM categories
		INNER JOIN dc_log ON dc_log.categoryid = categories.id
		INNER JOIN dc_aanda_room_categories_link ON dc_aanda_room_categories_link.hms_category_id = dc_log.categoryid
		LEFT JOIN rooms ON rooms.category_id = categories.id AND rooms.dc_active = 1
			WHERE dc_log.dc_id = 28 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.intdate >= " . $intdate_today . "
		GROUP BY dc_log.categoryid, dc_log.intdate";
	    $query = $this->db->query ( $sql );
	    // echo $sql;
	
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            if ($min_date == 0) {
	                $min_date = $row->log_intdate;
	            } else {
	                if ($row->log_intdate < $min_date) {
	                    $min_date = $row->log_intdate;
	                }
	            }
	
	            if ($max_date == 0) {
	                $max_date = $row->log_intdate;
	            } else {
	                if ($row->log_intdate > $max_date) {
	                    $max_date = $row->log_intdate;
	                }
	            }
	
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["dc_room_id"] = $row->dc_category_id;
	            //$categories_rooms_all [$row->category_id] [$row->log_intdate] ["currency"] = "RUB";
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["free"] = $row->count_rooms;
	            $categories_rooms_all [$row->category_id] [$row->log_intdate] ["date"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	
	            //$categories_rooms_all [$row->category_id] [$row->log_intdate] ["from"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	            //$categories_rooms_all [$row->category_id] [$row->log_intdate] ["to"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
	            // $last_id = $row->dc_log_id;
	            if ($row->dc_log_id > $last_id) {
	                $last_id = $row->dc_log_id;
	            }
	        }
	    } else {
	        $data_return ["response"] = 3;
	        return $data_return;
	    }
	
	    $categories_rooms_intdate = array ();
	
	    $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
	    FROM  `rooms`
	    INNER JOIN categories ON categories.id = rooms.category_id
	    INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
	    INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
	    dc_log.categoryid = rooms.category_id
	    WHERE dc_log.dc_id = 28 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.dc_hotel_id = $hotel_id
	    GROUP BY deskofdays.intdate, rooms.category_id";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            // count_rooms_booking
	            $categories_rooms_intdate [$row->id] [$row->intdate] ["free"] = $row->count_rooms;
	        }
	    }
	
	    $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log ( 28 );
	    $overbooking_reservations_array = array ();
	    if (isset ( $datein_out_mass ["intdatein"] )) {
	        $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat ( $datein_out_mass ["intdatein"], $datein_out_mass ["intdateout"] );
	    }
	
	    $setrestrict_result = "";
	    $result = "";
	    $sql = "SELECT int_value FROM dc_aanda_xml_cfg WHERE name LIKE 'general_update'";
	    $query = $this->db->query ( $sql );
	
	    if ($general_update == 1) {
	        $category_keys = array_keys ( $categories_rooms_all );
	        foreach ( $category_keys as $category_id ) {
	
	            $sql = "select min, max from dc_aanda_room_categories_link where hms_category_id = " . $category_id;
	            $query = $this->db->query ( $sql );
	            if ($query->num_rows () > 0) {
	                $row2 = $query->row ();
	                $min = $row2->min;
	                $max = $row2->max;
	            } else {
	                $min = 0;
	                $max = 999;
	            }
	
	            $arr_intdate_keys = array_keys ( $categories_rooms_all [$category_id] );
	            foreach ( $arr_intdate_keys as $intdate ) {
// 	                if ($categories_rooms_all[$category_id][$intdate]["closed"] == 1) {
// 	                    $categories_rooms_all[$category_id][$intdate]["free"] = 0;
// 	                } else {
	                    if (isset($categories_rooms_intdate[$category_id][$intdate])) {
	                        $count_overbook_rooms = 0;
	                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
	                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
	                        }
	                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
	                    } else {
	                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
	                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
	                            $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $count_overbook_rooms;
	                        }
	                    }
	
	                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
	                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
	                    } else {
	                        $categories_rooms_all[$category_id][$intdate]["free"] = 0;
	                    }
	
	                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
	                        $categories_rooms_all[$category_id][$intdate]["free"] = $max;
	                    }
	                    
	                    // коррекція к-сті відповідно умовам ф-ї availability_count_correction
	                    $startdate = $enddate = date("Y-m-d", $intdate*86400);
	                    $categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
	                //}
	                	
	                if (!true) {
	                    $prev = $intdate - 1;
	                    if (isset ( $categories_rooms_all [$category_id] [$prev] )) {
	                        $free_1 = $categories_rooms_all [$category_id] [$prev] ["free"];
	                        $free_2 = $categories_rooms_all [$category_id] [$intdate] ["free"];
	                        	
	                        if ($free_1 == $free_2) {
	                            $categories_rooms_all [$category_id] [$intdate] ["from"] = $categories_rooms_all [$category_id] [$prev] ["from"];
	                            unset ( $categories_rooms_all [$category_id] [$prev] );
	                        }
	                    }
	                }
	            }
	        }
	        	
	        /*
	         * foreach ( $categories_rooms_all as $category_id => $intdates ) { foreach ( $intdates as $intdate => $cell ) { $todate = $categories_rooms_all [$category_id] [$intdate] ["to"]; list ( $year, $month, $day ) = explode ( "-", $todate ); $intdate_to = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 ); $intdate_to = $intdate_to + 1; $categories_rooms_all [$category_id] [$intdate] ["to"] = gmdate ( "Y-m-d", $intdate_to * 86400 ); } }
	         */
	        	
	        // echo "<pre>";
	        // print_r ( $categories_rooms_all );
	        // die();
	        $roomslist = array ();
	        foreach ( $categories_rooms_all as $category_id => $dates ) {
	            foreach ( $dates as $intdate => $cell ) {
	                array_push ( $roomslist, array (
	                    //'startDateYmd' => $cell ["from"],
	                    'date' => $cell ["date"],
	                    'room_id' => $cell ["dc_room_id"],
	                    'quota' => (string) $cell ["free"]
	                ) );
	            }
	        }
	        	
	        echo "<pre>";
	        print_r ( $roomslist );
	        	
	        if (count ( $roomslist ) < 1) {
	            $query = $this->db->query ( "DELETE FROM dc_log WHERE dc_id = 28 AND dc_hotel_id = $hotel_id" );
	            $data_return ["response"] = 4;
	            return $data_return;
	        }
	        	
	        $request = array ();
	        $request ["key"] = $auth_key;
	        $request ["method"] = "update";
	        $request ["data"] [0] ["hotel_id"] = $hotel_id;
	        $request ["data"] [0] ["description"]["quotas"] = $roomslist;
	        print_r ( $request );
	        $json_request = json_encode ( $request );
	        print_r ( $authparam );
	        $url = $authparam ["url"];
	        echo "<br>".$url."<br>".$json_request."<br>";
	        $data_result = $this->Curl_model->CurlPlugRaw_aanda ( $json_request, $url, array("returntype" => "array") );
	        	
	        $result_array = json_decode ( $data_result ["result"], 1 );
	        	
	        echo $data_result ["result"]."++++";
	        print_r ( $result_array );
	        print_r ( $data_result );
	        $dc_log_id = $data_result ["dc_log_id"];
	        	
	        $data_return ["dc_log_id"] = $dc_log_id;
	        $data_return ["datein"] = gmdate ( "Y-m-d", $min_date * 86400 );
	        $data_return ["dateout"] = gmdate ( "Y-m-d", $max_date * 86400 );
	        	
	        //$result = json_decode ( json_encode ( $data_result ["result"] ), 1 );
	        	
	    }
	
	    if ($general_update == 0) {
	        echo "Ban upload for booking service";
	    } else {
	        if ($result_array["success"] == true) {
	            $data_return ["response"] = 1;
	            $data_return ["responsebody"] = "success";
	            $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 28 AND dc_hotel_id = $hotel_id AND time < " . $last_time;
	            $query = $this->db->query ( $sql );
	        } else {
	            $data_return ["response"] = 0;
	            $data_return ["errmsg"] = $result_array ['message'];
	            $data_return ["responsebody"] = $result_array ['message'];
	            // $query = $this->db->query ( "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 21 AND time < " . $last_time );
	        }
	        return $data_return;
	    }
	}
	
	function setavailability_lastchanged_23($dc_account_id){
	
	
		$authparam = $this->dcm_roomp_v2->getauthparam($dc_account_id);
		$dc_hotel_id = $authparam ["hotel_auth_hotel_id"];
		$debug = false;
		$general_update = 0;
		$sql = "SELECT int_value FROM dc_roomp_xml_cfg WHERE name LIKE 'general_update'";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$general_update = $row->int_value;
		}
		$data_return = array ();
		if ($general_update == 1) {
		} else {
			$data_return ["response"] = 2;
			return $data_return;
		}
	
		$min_date = 0;
		$max_date = 0;
		$categories_rooms_all = array ();
		$intdate_today = floor ( time () / 86400 );
		$last_id = 0;
		$last_time = time ();
		//========== SET roomp_uploadperiod ============
		$roomp_uploadperiod = 150;
		
		$sql = "SELECT dc_log.id as dc_log_id, dc_roomp_room_categories.id as dc_room_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms  FROM categories
				INNER JOIN dc_log ON dc_log.categoryid = categories.id
				INNER JOIN dc_roomp_room_categories_link ON dc_roomp_room_categories_link.hms_category_id = dc_log.categoryid
				INNER JOIN dc_roomp_room_categories ON dc_roomp_room_categories_link.dc_category_id = dc_roomp_room_categories.id
				INNER JOIN rooms ON rooms.category_id = categories.id
				WHERE rooms.dc_active=1 AND dc_log.dc_id = 23 AND dc_log.intdate >= " . $intdate_today . " AND dc_roomp_room_categories.dc_hotel_id = ".$dc_hotel_id."
				GROUP BY dc_log.categoryid, dc_log.intdate ORDER BY dc_log.id, dc_log.intdate  LIMIT 0, " . $roomp_uploadperiod;
		if ($debug) {
			echo "<br><br><br>";
			echo $sql . "<br><br><br>";
		}
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				if ($min_date == 0) {
					$min_date = $row->log_intdate;
				} else {
					if ($row->log_intdate < $min_date) {
						$min_date = $row->log_intdate;
					}
				}
	
				if ($max_date == 0) {
					$max_date = $row->log_intdate;
				} else {
					if ($row->log_intdate > $max_date) {
						$max_date = $row->log_intdate;
					}
				}
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ['dfrom'] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ['dto'] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
				
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["room_id"] = $row->dc_room_id;
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["avail"] = $row->count_rooms;
				if ($row->dc_log_id > $last_id) {
					$last_id = $row->dc_log_id;
				}
			}
		} else {
			$query = $this->db->query ( "DELETE dc_log FROM dc_log
					INNER JOIN dc_roomp_room_categories_link ON dc_roomp_room_categories_link.hms_category_id = dc_log.categoryid
				 	INNER JOIN dc_roomp_room_categories ON dc_roomp_room_categories_link.dc_category_id = dc_roomp_room_categories.id
					WHERE dc_id = 23 AND time < $last_time" . " AND dc_roomp_room_categories.dc_hotel_id = " . $dc_hotel_id );
			
			$data_return ["response"] = 3;
			return $data_return;
		}
		echo "<pre>";
		if ($debug) {
			print_r ( $categories_rooms_all );
		}
	
		// echo $sql;
	
		$categories_rooms_intdate = array ();
		$sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
		FROM `rooms`
		INNER JOIN categories ON categories.id = rooms.category_id
		INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
		INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
dc_log.categoryid = rooms.category_id
		INNER JOIN dc_roomp_room_categories_link ON dc_roomp_room_categories_link.hms_category_id = dc_log.categoryid
		INNER JOIN dc_roomp_room_categories ON dc_roomp_room_categories_link.dc_category_id = dc_roomp_room_categories.id
		WHERE dc_log.dc_id = 23 AND dc_log.intdate >= " . $intdate_today . "
		GROUP BY deskofdays.intdate, rooms.category_id ORDER BY dc_log.id, dc_log.intdate LIMIT 0, " . $roomp_uploadperiod;
	
		$sql2 = "SELECT categories.id, dc_log.intdate, COUNT( 1 ) AS count_rooms
		FROM
            dc_log
            INNER JOIN categories ON categories.id = dc_log.categoryid
            inner JOIN `rooms` ON categories.id = rooms.category_id
		INNER JOIN deskofdays ON dc_log.intdate = deskofdays.intdate AND
deskofdays.room_id = rooms.id
		WHERE dc_log.dc_id = 23 AND dc_log.intdate >= " . $intdate_today . " AND dc_roomp_room_categories.dc_hotel_id = ".$dc_hotel_id."
		GROUP BY deskofdays.intdate, rooms.category_id ORDER BY dc_log.id, dc_log.intdate LIMIT 0, " . $roomp_uploadperiod;
	
		if ($debug) {
			echo $sql;
		}
	
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$categories_rooms_intdate [$row->id] [$row->intdate] = $row->count_rooms;
			}
		}
	
		if ($debug) {
			print_r ( $categories_rooms_intdate );
		}
	
		/*
		 * GET OVERBOOKING_RESERVATIONS_ARRAY
		*/
	
		$datein_out_mass = $this->dc_model->get_datein_dateout_dc_log ( 23 );
		$overbooking_reservations_array = array ();
		if (isset ( $datein_out_mass ["intdatein"] )) {
			$overbooking_reservations_array = $this->dc_model->get_overbooking_origincat ( $datein_out_mass ["intdatein"], $datein_out_mass ["intdateout"] );
		}
	
		// echo "<pre>";
		// print_r($overbooking_reservations_array);
		// die();
	
		/*
		 * END GET OVERBOOKING_RESERVATIONS_ARRAY
		*/
	
		/*
		 * Выгрузка загружености с expedia
		*/
	
	
		$dc_rooms = array ();
		$sql = "SELECT  dc_roomp_room_categories_link.*  FROM  dc_roomp_room_categories_link
		INNER JOIN dc_roomp_room_categories ON dc_roomp_room_categories.id = dc_roomp_room_categories_link.dc_category_id
		WHERE dc_roomp_room_categories.dc_hotel_id = ".$dc_hotel_id;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$dc_rooms [$row->hms_category_id] = $row->dc_category_id;
			}
		}
	
		$category_keys = array_keys ( $categories_rooms_all );
		$roomsresult = array ();
		foreach ( $category_keys as $category_id ) {
				
			ksort ( $categories_rooms_all [$category_id] );
				
			$sql = "select min, max from dc_roomp_room_categories_link where hms_category_id =" . $category_id;
			$query = $this->db->query ( $sql );
			if ($query->num_rows () > 0) {
				$row2 = $query->row ();
				$min = $row2->min;
				$max = $row2->max;
			} else {
				$min = 0;
				$max = 999;
			}
				
			if (! isset ( $dc_rooms [$category_id] )) {
				unset ( $categories_rooms_all [$category_id] );
				continue;
			}
			$arr_intdate_keys = array_keys ( $categories_rooms_all [$category_id] );
			foreach ( $arr_intdate_keys as $intdate ) {
				if (! isset ( $categories_rooms_all [$category_id] [$intdate] )) {
					continue;
				}
				if (isset ( $categories_rooms_intdate [$category_id] [$intdate] )) {
					$count_overbook_rooms = 0;
					if (isset ( $overbooking_reservations_array [$category_id] [$intdate] )) {
						$count_overbook_rooms = $overbooking_reservations_array [$category_id] [$intdate];
					}
					$categories_rooms_all [$category_id] [$intdate] ["avail"] = $categories_rooms_all [$category_id] [$intdate] ["avail"] - ($categories_rooms_intdate [$category_id] [$intdate] + $count_overbook_rooms);
				} else {
					$count_overbook_rooms = 0;
					if (isset ( $overbooking_reservations_array [$category_id] [$intdate] )) {
						$count_overbook_rooms = $overbooking_reservations_array [$category_id] [$intdate];
					}
					$categories_rooms_all [$category_id] [$intdate] ["avail"] = $categories_rooms_all [$category_id] [$intdate] ["avail"] - ($count_overbook_rooms);
				}
	
				if ($categories_rooms_all [$category_id] [$intdate] ["avail"] > $min) {
					$categories_rooms_all [$category_id] [$intdate] ["avail"] = $categories_rooms_all [$category_id] [$intdate] ["avail"] - $min;
				} else {
					$categories_rooms_all [$category_id] [$intdate] ["avail"] = 0;
				}
	
				if ($categories_rooms_all [$category_id] [$intdate] ["avail"] > $max) {
					$categories_rooms_all [$category_id] [$intdate] ["avail"] = $max;
				}
				
				// коррекція к-сті відповідно умовам ф-ї availability_count_correction
				$startdate = $enddate = date("Y-m-d", $intdate*86400);
				$categories_rooms_all[$category_id][$intdate]["avail"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["avail"], $startdate, $enddate);
				
				$prev = $intdate - 1;
				if (true) {
					if (isset ( $categories_rooms_all [$category_id] [$prev] )) {
						$free_1 = $categories_rooms_all [$category_id] [$prev] ["avail"];
						$free_2 = $categories_rooms_all [$category_id] [$intdate] ["avail"];
	
						if ($free_1 == $free_2 && ! false) {
							$categories_rooms_all [$category_id] [$intdate] ["dfrom"] = $categories_rooms_all [$category_id] [$prev] ["dfrom"];
							unset ( $categories_rooms_all [$category_id] [$prev] );
						}
					}
				}
				// array_push ( $roomsresult, $categories_rooms_all [$category_id] [$intdate] );
			}
		}
		// echo "<pre>";
		//print_r ( $categories_rooms_all );
		// die();
		$category_keys = array_keys ( $categories_rooms_all );
		$roomsresult = array ();
		foreach ( $category_keys as $category_id ) {
			$intday_keys = array_keys ( $categories_rooms_all [$category_id] );
			foreach ( $intday_keys as $intdate ) {
				if (isset ( $categories_rooms_all [$category_id] [$intdate] ))
					array_push ( $roomsresult, $categories_rooms_all [$category_id] [$intdate] );
			}
		}
		$rooms ["availability"] = $roomsresult;
		echo "<pre>111";
		print_r ( $rooms );
		
		
		if (count ( $rooms ) < 1) {
			$query = $this->db->query ( "DELETE dc_log FROM dc_log
					INNER JOIN dc_roomp_room_categories_link ON dc_roomp_room_categories_link.hms_category_id = dc_log.categoryid
				 	INNER JOIN dc_roomp_room_categories ON dc_roomp_room_categories_link.dc_category_id = dc_roomp_room_categories.id
					WHERE dc_id = 23 AND time < $last_time" . "AND dc_roomp_room_categories.dc_hotel_id = " . $dc_hotel_id );
			$data_return ["response"] = 4;
			return $data_return;
		}

		$curl_data = array (
				'cm_auth' => array (
						'login' => $authparam ["cm_auth_login"],
						'password' => $authparam ["cm_auth_password"]
				),
				'hotel_auth' => array (
						'hotel_id' => $authparam ["hotel_auth_hotel_id"],
						'email' => $authparam ["hotel_auth_email"],
						'password' => $authparam ["hotel_auth_password"]
				),
				'action' => "update_data",
				'data' => $rooms
		);
		print_r ( $curl_data );
		
		$url = 'https://api.roomp.co/v1/woodoo';
		//$data_result = $this->Curl_model->CurlGET_Roomp ( $curl_data, $url, array("returntype" => "array"));
		$data_result = $this->Curl_model->CurlPOST_Roomp ( $curl_data, $url, array("returntype" => "array"));
		print_r ( $data_result );
		//die ( " - DEBUG!!! - " );
		
		$result = $data_result["result"];
		$dc_log_id = $data_result["dc_log_id"];
		
		$array = json_decode($result, true);
		
		$data_return["dc_log_id"] = $dc_log_id;
		
		$datein = gmdate("Y-m-d", $min_date * 86400);
		$dateout = gmdate("Y-m-d", $max_date * 86400);
		
		$data_return["datein"] = $datein;
		$data_return["dateout"] = $dateout;
		//die();
		if ($array['code'] == 200) {
			$sql = "DELETE dc_log FROM dc_log 
			 INNER JOIN dc_roomp_room_categories_link ON dc_roomp_room_categories_link.hms_category_id = dc_log.categoryid
			 INNER JOIN dc_roomp_room_categories ON dc_roomp_room_categories_link.dc_category_id = dc_roomp_room_categories.id
			 WHERE dc_log.id <=" . $last_id . " AND dc_log.dc_id = 23 AND dc_roomp_room_categories.dc_hotel_id = ".$dc_hotel_id;
			// echo $sql;
			$query = $this->db->query($sql);
			$data_return["response"] = 1;
			$data_return["responsebody"] = "success";
		} else {
			$sql = "DELETE dc_log FROM dc_log 
			 INNER JOIN dc_roomp_room_categories_link ON dc_roomp_room_categories_link.hms_category_id = dc_log.categoryid
			 INNER JOIN dc_roomp_room_categories ON dc_roomp_room_categories_link.dc_category_id = dc_roomp_room_categories.id
			 WHERE dc_log.id <=" . $last_id . " AND dc_log.dc_id = 23 AND dc_roomp_room_categories.dc_hotel_id = ".$dc_hotel_id;
			// echo $sql;
			$query = $this->db->query($sql);
			$data_return["response"] = 0;
			$data_return["errmsg"] = "";
		
			$data_return["errmsg"] = "datein = $datein; dateout = $dateout; " . print_r($array["result"]["errors"], true);
			$data_return["responsebody"] = "datein = $datein; dateout = $dateout; " . $data_return["errmsg"];
		}

		return $data_return;
	}
	
    function setavailability_lastchanged_8()
    {
        $general_update = 0;
        $sql = "SELECT int_value FROM dc_hostelworld_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $general_update = $row->int_value;
        }
        $data_return = array();
        if ($general_update == 1) {} else {
            $data_return["response"] = 2;
            return $data_return;
        }
        
        $intdate_today = floor(time() / 86400);
        $last_id = 0;
        $last_time = time();
        // echo $intdate_today . "\n";
        
        $sql = "SELECT dc_log.id as dc_log_id, dc_log.intdate as log_intdate  FROM dc_log
				WHERE dc_log.dc_id = 8 AND dc_log.intdate >= " . $intdate_today . "
				GROUP BY dc_log.categoryid, dc_log.intdate";
        
        $query = $this->db->query($sql);
        
        // echo $sql;
        
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                if ($row->dc_log_id > $last_id) {
                    $last_id = $row->dc_log_id;
                }
            }
        } else {
            $data_return["response"] = 3;
            return $data_return;
        }
        
        $hw_result = "";
        
        // echo $general_update_HsClub;
        $data_return = array();
        
        if ($general_update == 1) {
            /*
             * GET OVERBOOKING_RESERVATIONS_ARRAY
             */
            
            $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log(8);
            
            $datein = gmdate("Y-m-d", $datein_out_mass["intdatein"] * 86400);
            $dateout = gmdate("Y-m-d", $datein_out_mass["intdateout"] * 86400);
            // echo "<pre>";
            // print_r($overbooking_reservations_array);
            // die();
            
            /*
             * END GET OVERBOOKING_RESERVATIONS_ARRAY
             */
            
            // echo $datein . "\n";
            // echo $dateout . "\n";
            
            $data = array();
            
            $authparam = $this->dcm_hostelworld->getauthparam();
            
            $consumer_key = $authparam["consumer_key"];
            $secret = $authparam["secret"];
            $propN = $authparam["hotel_id"];
            $prop_user = 'manager';
            $prop_pass = $authparam["prop_pass"];
            $data["currency"] = $authparam["currency"];
            $consumer_signature = sha1($consumer_key . "--" . $secret . "--" . $prop_pass);
            
            // $rateavail = $this->dcm_hostelworld->getrateavail ( $datein, $dateout );
            $rateavail = $this->dcm_hostelworld->getrateavail_2($datein, $dateout);
            // echo "<pre>";
            // print_r ( $rateavail );
            // die();
            if (count($rateavail) < 1) {
                $data_return["response"] = 3;
                return $data_return;
            }
            if (isset($rateavail["response"])) {
                if ($rateavail["response"] == 3) {
                    $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 8 AND time < " . $last_time;
                    $data_return["response"] = 3;
                    $query = $this->db->query($sql);
                    return $data_return;
                }
            }
            
            $data["rooms"] = $rateavail;
                     
			$url = "https://property.xsapi.webresint.com/1.2/setavailability/" . $propN . ".json?consumer_key=" . $consumer_key . "&consumer_signature=" . $consumer_signature;
			$txt = $this->parser->parse('templates/dc_hostelsworld_rateavail.html', $data, true);
			echo $url."<br>";
			echo $txt;
            $data_result = $this->Curl_model->CurlPlugRAW($txt, $url, 8, array(
                "returntype" => "array"
            ));
            // echo $result;
            // return $result;
            $result = $data_result["result"];
            $dc_log_id = $data_result["dc_log_id"];
            // echo $result;
            // echo "<pre>";
            // print_r ( $result );
            $array = json_decode($result);
            // $array = new SimpleXMLElement ( $result );
            // print_r ( $array );
            $array = objectToArray_2($array);
            
            $reservationdata = array();
            if (isset($array["api"]["status"])) {
                if ($array["api"]["status"] == "Success") {
                    if (isset($array["result"]["errors"])) {
                        $reservationdata['success'] = false;
                    } else {
                        $reservationdata['success'] = true;
                    }
                } else {
                    $reservationdata['success'] = false;
                }
            } else {
                $reservationdata['success'] = false;
            }
            $data_return["dc_log_id"] = $dc_log_id;
            $data_return["datein"] = $datein;
            $data_return["dateout"] = $dateout;
            
            if ($reservationdata['success'] == true) {
                $hw_result = "HW: Success";
                $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 8 AND time < " . $last_time;
                // echo $sql;
                $query = $this->db->query($sql);
                $data_return["response"] = 1;
                $data_return["responsebody"] = "success";
                
                // $this->dc_model->Delete_dclog_last_data ( 4 );
            } else {
                // echo "<pre>";
                // $hsClub_result = "HsClub: " . $reservationdata ['errmsg'];
                $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 8 AND time < " . $last_time;
                // echo $sql;
                $query = $this->db->query($sql);
                $data_return["response"] = 0;
                $data_return["errmsg"] = "";
                
                $data_return["errmsg"] = "datein = $datein; dateout = $dateout; " . print_r($array["result"]["errors"], true);
                $data_return["responsebody"] = "datein = $datein; dateout = $dateout; " . $data_return["errmsg"];
            }
            
            // echo "<pre>";
            // print_r ( $data );
        } else {}
        return $data_return;
    }
    
    function setavailability_lastchanged_8_v2()
    {
    	$general_update = 0;
    	$sql = "SELECT int_value FROM dc_hostelworld_xml_cfg WHERE name LIKE 'general_update'";
    	$query = $this->db->query($sql);
    	if ($query->num_rows() > 0) {
    		$row = $query->row();
    		$general_update = $row->int_value;
    	}
    	$data_return = array();
    	if ($general_update == 1) {} else {
    		$data_return["response"] = 2;
    		return $data_return;
    	}
    
    	$intdate_today = floor(time() / 86400);
    	//$last_id = 0;
    	$last_time = time();
    
    	$sql = "SELECT dc_log.id as dc_log_id, dc_log.intdate as log_intdate  FROM dc_log
				WHERE dc_log.dc_id = 8 AND dc_log.intdate >= " . $intdate_today . "
				GROUP BY dc_log.categoryid, dc_log.intdate";
    
    	$query = $this->db->query($sql);
    
    	if ($query->num_rows() > 0) {
//     		foreach ($query->result() as $row) {
//     			if ($row->dc_log_id > $last_id) {
//     				$last_id = $row->dc_log_id;
//     			}
//     		}
    	} else {
    		$data_return["response"] = 3;
    		return $data_return;
    	}
    
    	$hw_result = "";
    	$data_return = array();
    
    	if ($general_update == 1) {
    		/*
    		 * GET OVERBOOKING_RESERVATIONS_ARRAY
    		*/
    
    		$datein_out_mass = $this->dc_model->get_datein_dateout_dc_log(8);
    
    		$datein = gmdate("Y-m-d", $datein_out_mass["intdatein"] * 86400);
    		$dateout = gmdate("Y-m-d", $datein_out_mass["intdateout"] * 86400);
    
    		$data = array();
    
    		$authparam = $this->dcm_hostelworld->getauthparam();
    
    		$consumer_key = $authparam["consumer_key"];
    		$secret = $authparam["secret"];
    		$propN = $authparam["hotel_id"];
    		$prop_user = 'manager';
    		$prop_pass = $authparam["prop_pass"];
    		$data["currency"] = $authparam["currency"];
    		$consumer_signature = sha1($consumer_key . "--" . $secret . "--" . $prop_pass);

    		$hw_data = $this->dcm_hostelworld->getavailability_v2($datein, $dateout);
    		
    		$availability = $hw_data['data'];
    		$last_id = $hw_data['last_id'];
    		 echo "<pre>";
    		 print_r ( $availability );
    		 //die();
    		if (count($availability) < 1) {
    			$data_return["response"] = 3;
    			return $data_return;
    		}
    		if (isset($availability["response"])) {
    			if ($rateavail["response"] == 3) {
    				$sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 8 AND time < " . $last_time;
    				$data_return["response"] = 3;
    				$query = $this->db->query($sql);
    				return $data_return;
    			}
    		}
    
    		$data["rooms"] = $availability;
    		 
    		$url = "https://property.xsapi.webresint.com/2.0/setbeds/" . $propN . ".json?consumer_key=" . $consumer_key . "&consumer_signature=" . $consumer_signature;
    		$txt = $this->parser->parse('templates/dc_hostelworld_availability_v2.html', $data, true);
    			//echo $txt;
    		$data_result = $this->Curl_model->CurlPlugRAW($txt, $url, 8, array(
    				"returntype" => "array"
    		));
    		
    		// return $result;
    		$result = $data_result["result"];
    		$dc_log_id = $data_result["dc_log_id"];
    		
    		echo "++" . $result;
    		
    		$array = json_decode($result, true);
    		// $array = new SimpleXMLElement ( $result );
    		print_r ( $array );
    		
    
    		$reservationdata = array();
    		if (isset($array["api"]["status"])) {
    			if ($array["api"]["status"] == "Success") {
    				if (isset($array["result"]["errors"])) {
    					$reservationdata['success'] = false;
    				} else {
    					$reservationdata['success'] = true;
    				}
    			} else {
    				$reservationdata['success'] = false;
    			}
    		} else {
    			$reservationdata['success'] = false;
    		}
    		$data_return["dc_log_id"] = $dc_log_id;
    		$data_return["datein"] = $datein;
    		$data_return["dateout"] = $dateout;
    		//die();
    		if ($reservationdata['success'] == true) {
    			$hw_result = "HW: Success";
    			$sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 8 AND time < " . $last_time;
    			// echo $sql;
    			$query = $this->db->query($sql);
    			$data_return["response"] = 1;
    			$data_return["responsebody"] = "success";
    		} else {
    			$sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 8 AND time < " . $last_time;
    			$query = $this->db->query($sql);
    			$data_return["response"] = 0;
    			$data_return["errmsg"] = "";
    
    			$data_return["errmsg"] = "datein = $datein; dateout = $dateout; " . print_r($array["result"]["errors"], true);
    			$data_return["responsebody"] = "datein = $datein; dateout = $dateout; " . $data_return["errmsg"];
    		}
    
    		// echo "<pre>";
    		// print_r ( $data );
    	} else {}
    	return $data_return;
    }

    function setavailability_lastchanged_9_multy($upload_restrict, $dc_account_id){
    	$authparam = $this->dcm_101otel->getauthparam($dc_account_id);
    	$dc_hotel_id = $authparam ["hotel_id"];
    
    	$general_update = 0;
    	$sql = "SELECT int_value FROM dc_101otel_xml_cfg WHERE name LIKE 'general_update'";
    	$query = $this->db->query($sql);
    	if ($query->num_rows() > 0) {
    		$row = $query->row();
    		$general_update = $row->int_value;
    	}
    	$data_return = array();
    	if ($general_update == 1) {} else {
    		$data_return["response"] = 2;
    		return $data_return;
    	}
    
    	$intdate_today = floor(time() / 86400);
    
    	$now_date = date("Y-m-d");
    	list ($year, $month, $day) = explode("-", $now_date);
    	$intdate_today = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
    
    	$last_id = 0;
    	$last_restrict_id = 0;
    	// echo " - " . $intdate_today . "\n";
    	$last_time = time();
    	$sql = "SELECT dc_log.id as dc_log_id, dc_log.intdate as log_intdate  FROM dc_log
        		INNER JOIN dc_101otel_room_categories_link ON dc_101otel_room_categories_link.hms_category_id = dc_log.categoryid
        		INNER JOIN dc_101otel_room_categories ON dc_101otel_room_categories.id = dc_101otel_room_categories_link.dc_category_id
				WHERE dc_log.dc_id = 9 AND dc_log.intdate >= " . $intdate_today . " AND dc_log.dc_hotel_id = ".$dc_hotel_id."
				GROUP BY dc_log.categoryid, dc_log.intdate";
    
    	$query = $this->db->query($sql);
    
    	// echo $sql;
    
    	if ($query->num_rows() > 0) {
    		foreach ($query->result() as $row) {
    			if ($row->dc_log_id > $last_id) {
    				$last_id = $row->dc_log_id;
    			}
    		}
    	} else {
    		$data_return["response"] = 3;
    		//return $data_return;
    	}
    
    	/*$sql = "SELECT dc_log_restrict.id as dc_log_id, dc_log_restrict.intdate as log_intdate  FROM dc_log_restrict
        		INNER JOIN dc_101otel_room_categories_link ON dc_101otel_room_categories_link.hms_category_id = dc_log_restrict.category_id
        		INNER JOIN dc_101otel_room_categories ON dc_101otel_room_categories.id = dc_101otel_room_categories_link.dc_category_id
				WHERE dc_log_restrict.dc_id = 9 AND dc_log_restrict.intdate >= " . $intdate_today . " AND dc_101otel_room_categories.dc_hotel_id = ".$dc_hotel_id."
				GROUP BY dc_log_restrict.restrict_id, dc_log_restrict.category_id, dc_log_restrict.intdate";
    
    	$query = $this->db->query($sql);
    	if ($query->num_rows() > 0) {
    		foreach ($query->result() as $row) {
    			if ($row->dc_log_id > $last_restrict_id) {
    				$last_restrict_id = $row->dc_log_id;
    			}
    		}
    	}else{
    		$sql = "SELECT id FROM dc_101otel_room_categories";
    		$query = $this->db->query ( $sql );
    		if ($query->num_rows () > 0) {
    			
    		}else{
    			$sql = "DELETE dc_log_restrict FROM dc_log_restrict
                WHERE dc_log_restrict.dc_id = 9";
    			$query = $this->db->query($sql);
    		}
    	}
    	*/
    	
    
    	if(isset($data_return["response"])){
    		if($data_return["response"] == 3){
    			return $data_return;
    		}
    	}
    	
    	$result_101otel = "";
    
    	// echo $general_update_HsClub;
    	$data_return = array();
    
    	if ($general_update == 1) {
    		/*
    		 * GET OVERBOOKING_RESERVATIONS_ARRAY
    		*/
    
    		$datein_out_mass = $this->dc_model->get_datein_dateout_dc_log(9);
    
    		list ($year, $month, $day) = explode("-", date("Y-m-d"));
    		$intdatein_now = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
    		if ($intdatein_now > $datein_out_mass["intdatein"]) {
    			$datein_101otel = gmdate("Y-m-d", $intdatein_now * 86400);
    		} else {
    			$datein_101otel = gmdate("Y-m-d", $datein_out_mass["intdatein"] * 86400);
    		}
    
    		$dateout = gmdate("Y-m-d", $datein_out_mass["intdateout"] * 86400);
    
    		// echo "\n" . $datein_101otel . "----" . $dateout . "\n";
    
    		// if ($upload_restrict == 1) {
    		// $restrict = $this->dcm_101otel->GetRestrict ( $datein_101otel, $dateout );
    		// } else
    		// $restrict = array ();
    
    		// $rooms = $this->dcm_101otel->GetFreeRooms_dc_101otel ( $datein_101otel, $dateout );
    
    		list ($year, $month, $day) = explode("-", $datein_101otel);
    		$intdatein = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
    		list ($year, $month, $day) = explode("-", $dateout);
    		$intdateout = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
    
    		$restrict = array();
    		$rooms = array();
    		$dc_rooms_new = array();
    
    		$overbooking_reservations_array = $this->dc_model->get_overbooking_origincat($intdatein, $intdateout);
    		$cell = array();
    		/*
    		 * $sql = "SELECT dc_log.intdate, deskofrate.closed, deskofrate.minstay, deskofrate.maxstay,
    		* deskofrate.minstayarrival, deskofrate.minstaythrought, deskofrate.closedonarrival, deskofrate.closedondeparture,
    		* dc_oktogo_rooms_link.dc_room_id as dc_category_id, dc_oktogo_rooms_link.category_id,
    		* dc_oktogo_rates.dc_rate_id as dc_rate_id FROM dc_log
    		* INNER JOIN dc_oktogo_rooms_link ON dc_log.categoryid = dc_oktogo_rooms_link.category_id
    		* INNER JOIN dc_oktogo_rates ON dc_oktogo_rates.room_id = dc_oktogo_rooms_link.dc_room_id
    		* INNER JOIN dc_oktogo_rates_link ON (dc_oktogo_rates_link.room_id = dc_oktogo_rooms_link.dc_room_id AND dc_oktogo_rates_link.dc_rate_id = dc_oktogo_rates.dc_rate_id)
    		* LEFT JOIN deskofrate ON (dc_oktogo_rates_link.restrict_id = deskofrate.rate_id AND dc_log.categoryid = deskofrate.category_id AND dc_log.intdate = deskofrate.intdate)
    		* WHERE dc_log.dc_id = 7";
    		* $sql = "SELECT dc_101otel_room_categories_link.min, dc_101otel_room_categories_link.max, dc_101otel_room_categories_link.hms_category_id,
    		* count(rooms.id) as rooms_count, count(deskofdays.room_id) as reserved_rooms_count,
    		* deskofrate.minstay, deskofrate.maxstay, deskofrate.minstayarrival, deskofrate.minstaythrought, deskofrate.closed,
    		* deskofrate.closedonarrival, deskofrate.minstay, deskofrate.closedondeparture, dc_log.intdate,
    		* dc_101otel_room_categories_link.dc_category_id as dc_category_id, dc_101otel_rates.rate_id as dc_rate_id
    		* FROM dc_log
    		* INNER JOIN dc_101otel_room_categories_link ON dc_log.categoryid = dc_101otel_room_categories_link.hms_category_id
    		* LEFT JOIN ratetocategory ON ratetocategory.category_id = dc_log.categoryid
    		* INNER JOIN categories ON categories.id = dc_log.categoryid
    		* INNER JOIN rooms ON rooms.category_id = categories.id
    		* LEFT JOIN deskofdays ON deskofdays.room_id = rooms.id AND deskofdays.intdate = dc_log.intdate
    		* LEFT JOIN dc_101otel_rates_link ON dc_101otel_rates_link.hms_rate_id = ratetocategory.rate_id
    		* INNER JOIN dc_101otel_rates ON dc_101otel_rates.room_category = dc_101otel_room_categories_link.dc_category_id AND dc_101otel_rates_link.dc_rate_id = dc_101otel_rates.rate_id
    		* LEFT JOIN deskofrate ON deskofrate.intdate = dc_log.intdate AND deskofrate.category_id = dc_log.categoryid AND dc_101otel_rates.restricted_id = deskofrate.rate_id
    		*
    		* WHERE dc_log.dc_id = 9 AND onlinebook > -1 AND categories.is_active = 1 AND rooms.is_active > -1
    		* GROUP BY dc_101otel_room_categories_link.dc_category_id, dc_101otel_rates.rate_id, dc_log.intdate";
    		*/
    		$sql = "SELECT dc_101otel_room_categories_link.min, dc_101otel_room_categories_link.max, dc_101otel_room_categories_link.hms_category_id,
				count(rooms.id) as rooms_count, count(deskofdays.room_id) as reserved_rooms_count,
				deskofrate.minstay, deskofrate.maxstay, deskofrate.minstayarrival, deskofrate.minstaythrought, deskofrate.closed,
				deskofrate.closedonarrival, deskofrate.minstay, deskofrate.closedondeparture, dc_log.restrict, dc_log.intdate, 
				dc_101otel_room_categories_link.dc_category_id as dc_category_id, dc_101otel_rates.rate_id as dc_rate_id
				FROM dc_log
				INNER JOIN dc_101otel_room_categories_link ON dc_log.categoryid = dc_101otel_room_categories_link.hms_category_id
            	INNER JOIN dc_101otel_room_categories ON dc_101otel_room_categories.id = dc_101otel_room_categories_link.dc_category_id
				INNER JOIN  dc_101otel_rates ON dc_101otel_rates.room_category = dc_101otel_room_categories_link.dc_category_id
				INNER JOIN categories ON categories.id = dc_log.categoryid
				INNER JOIN rooms ON rooms.category_id = categories.id
				LEFT JOIN deskofdays ON deskofdays.room_id = rooms.id AND deskofdays.intdate = dc_log.intdate
       
				LEFT JOIN deskofrate ON deskofrate.intdate = dc_log.intdate AND deskofrate.category_id = dc_log.categoryid
                AND dc_101otel_rates.restricted_id = deskofrate.rate_id

				WHERE dc_log.dc_id = 9 AND categories.is_active = 1  AND dc_log.dc_hotel_id = ".$dc_hotel_id."
				GROUP BY dc_101otel_room_categories_link.dc_category_id, dc_101otel_rates.rate_id, dc_log.intdate";
//     		echo $sql;
//     		die();
    		$query = $this->db->query($sql);
    
    		foreach ($query->result() as $row) {
    			// =============================rooms====================
    			$min = $row->min;
    			$max = $row->max;
    			$hms_category_id = $row->hms_category_id;
    
    			$count_overbook_rooms = 0;
    			if (isset($overbooking_reservations_array[$hms_category_id][$row->intdate])) {
    				$count_overbook_rooms = $overbooking_reservations_array[$hms_category_id][$row->intdate];
    			}
    			$free_rooms = $row->rooms_count - ($row->reserved_rooms_count + $count_overbook_rooms);
    
    			if ($free_rooms > $min) {
    				$free_rooms = $free_rooms - $min;
    			} else {
    				$free_rooms = 0;
    			}
    
    			if ($free_rooms > $max) {
    				$free_rooms = $max;
    			}
    
    			// коррекція к-сті відповідно умовам ф-ї availability_count_correction
    			$startdate = $enddate = date("Y-m-d", $row->intdate*86400);
    			$free_rooms = $this->frontdesk_c2->availability_count_correction($free_rooms, $startdate, $enddate);
                
    			// ============================restrict==================
    
    			if ($row->closed == 1) {
    				$closed = 1;
    			} else {
    				$closed = 0;
    			}
    
    			if ($row->closedonarrival == 1) {
    				$closed_on_arrival = 1;
    			} else {
    				$closed_on_arrival = 0;
    			}
    			if ($row->closedondeparture == 1) {
    				$closed_on_departure = 1;
    			} else {
    				$closed_on_departure = 0;
    			}
    			if ($row->minstaythrought != 0) {
    				$min_stay = $row->minstaythrought;
    			} else {
    				$min_stay = 0;
    			}
    
    			// ==============PUSH Data to Array=======================
    			/*if ($upload_restrict == 1 && $row->restrict_intdate != NULL) {
    
    				$cell[$row->intdate]["start"] = gmdate("Y-m-d", $row->intdate * 86400);
    				$cell[$row->intdate]["end"] = gmdate("Y-m-d", $row->intdate * 86400);
    				$cell[$row->intdate]["quota"][$row->dc_category_id] = $free_rooms;
    
    				$cell[$row->intdate]["closed"][$row->dc_category_id] = $closed;
    
    				$cell[$row->intdate]["closed_to_arrival"][$row->dc_category_id][$row->dc_rate_id] = $closed_on_arrival;
    				$cell[$row->intdate]["closed_to_departure"][$row->dc_category_id][$row->dc_rate_id] = $closed_on_departure;
    				$cell[$row->intdate]["min_stay"][$row->dc_category_id][$row->dc_rate_id] = $min_stay;
    			} else {
    			*/
    				$cell[$row->intdate]["start"] = gmdate("Y-m-d", $row->intdate * 86400);
    				$cell[$row->intdate]["end"] = gmdate("Y-m-d", $row->intdate * 86400);
    				$cell[$row->intdate]["quota"][$row->dc_category_id] = $free_rooms;
    			//}
    			// array_push ( $dc_rooms_new, $cell );
    		}
    		// echo "<pre>";
    		// print_r($cell);
    
    		ksort($cell);
    		foreach ($cell as $intdate => $value) {
    			array_push($dc_rooms_new, $cell[$intdate]);
    		}
    
    		echo "<pre>";
    		print_r($dc_rooms_new);
    		// die();
    
    		// ===========================start optimized==========
    
    		if (true) {
    			$count_req = count($dc_rooms_new);
    			for ($i = 1; $i < $count_req; $i ++) {
    
    				$bool = 0;
    				$prev = $i - 1;
    
    				list ($year, $month, $day) = explode("-", $dc_rooms_new[$prev]["end"]);
    				$prev_date_end_int = mktime(0, 0, 0, $month, $day, $year) / 86400;
    				list ($year, $month, $day) = explode("-", $dc_rooms_new[$i]["start"]);
    				$date_start_int = mktime(0, 0, 0, $month, $day, $year) / 86400;
    
    				if (($prev_date_end_int + 1) != $date_start_int) {
    					continue;
    				}
    
    				$temp_1 = $dc_rooms_new[$prev];
    				$temp_2 = $dc_rooms_new[$i];
    
    				unset($temp_1["start"]);
    				unset($temp_1["end"]);
    				unset($temp_2["start"]);
    				unset($temp_2["end"]);
    
    				// echo var_dump($temp_1 === $temp_2);
    				if ($temp_1 === $temp_2) {
    					$dc_rooms_new[$i]["start"] = $dc_rooms_new[$prev]["start"];
    					unset($dc_rooms_new[$prev]);
    				}
    			}
    			$dc_rooms_new2 = array();
    			foreach ($dc_rooms_new as $intdate => $value) {
    				array_push($dc_rooms_new2, $dc_rooms_new[$intdate]);
    			}
    			$dc_rooms_new = $dc_rooms_new2;
    		}
    
    		// ===========================end optimized==========
    
    		// echo "<pre>============================";
    		// print_r ( $dc_rooms_new );
    		// die();
    
    		if (sizeof($dc_rooms_new) == 0) {
    			$sql = "DELETE dc_log FROM dc_log
                WHERE id <=" . $last_id . " AND dc_id = 9 AND time < " . $last_time. " AND dc_hotel_id = " . $dc_hotel_id;
    			$query = $this->db->query($sql);
    			
    			
    			$data_return["response"] = 4;
    			$data_return["responsebody"] = "skipped, empty data" . "datein = $datein_101otel; dateout = $dateout;";
    			return $data_return;
    		}
    
    		$data_result = $this->dcm_101otel->update_rooms($dc_rooms_new, array(), 1, $dc_account_id);
    		// $data_return ["responsebody"] = $response;
    		// echo "<pre>";
    		// print_r ( $response );
    		$result = $data_result["result"];
    		$dc_log_id = $data_result["dc_log_id"];
    		// print_r ( $data_result );
    		// echo $result;
    		// die();
    		$data_return["dc_log_id"] = $dc_log_id;
    		$data_return["datein"] = $datein_101otel;
    		$data_return["dateout"] = $dateout;
    
    		if ($result->response == 1) {
    
    			$result_101otel = "101otel: Success";
    			$sql = "DELETE dc_log FROM dc_log
                WHERE dc_log.id <=" . $last_id . " AND dc_log.dc_id = 9 AND dc_log.time < " . $last_time. " AND dc_hotel_id = " . $dc_hotel_id;
    			$query = $this->db->query($sql);
    
    			//$sql = "DELETE dc_log_restrict FROM dc_log_restrict
                //WHERE dc_log_restrict.id <=" . $last_restrict_id . " AND dc_log_restrict.dc_id = 9 AND dc_hotel_id = " . $dc_hotel_id;
    			//$query = $this->db->query($sql);
    
    			$data_return["response"] = 1;
    			$data_return["responsebody"] = "success";
    		} else {
    			if (isset($result->errors[0]->code)) {
    				if ($result->errors[0]->code == 10) {
    					$sql = "DELETE dc_log FROM dc_log                        
                		WHERE dc_log.id <=" . $last_id . " AND dc_log.dc_id = 9 AND time < " . $last_time. " AND dc_hotel_id = " . $dc_hotel_id;
    					$query = $this->db->query($sql);
    
    					//$sql = "DELETE dc_log_restrict FROM dc_log_restrict
                		//WHERE dc_log_restrict.id <=" . $last_restrict_id . " AND dc_log_restrict.dc_id = 9 AND dc_hotel_id = " . $dc_hotel_id;
    					//$query = $this->db->query($sql);
    				}
    				if ($result->errors[0]->code == 6) {
    					$this->dcm_101otel->set_general_update(0);
    				}
    			}
    			$data_return["response"] = 0;
    			$data_return["errmsg"] = $result->errors;
    
    			$data_return["errmsg"] = "datein = $datein_101otel; dateout = $dateout; " . print_r($result->errors, true);
    			$data_return["responsebody"] = "datein = $datein_101otel; dateout = $dateout; " . print_r($data_return["errmsg"], true);
    		}
    
    		// echo "<pre>";
    		// print_r ( $data );
    	} else {}
    
    	return $data_return;
    }
    
    function setavailability_lastchanged_9($upload_restrict){
		
        $general_update = 0;
        $sql = "SELECT int_value FROM dc_101otel_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $general_update = $row->int_value;
        }
        $data_return = array();
        if ($general_update == 1) {} else {
            $data_return["response"] = 2;
            return $data_return;
        }
        
        $intdate_today = floor(time() / 86400);
        
        $now_date = date("Y-m-d");
        list ($year, $month, $day) = explode("-", $now_date);
        $intdate_today = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
        
        $last_id = 0;
        $last_restrict_id = 0;

        $last_time = time();
        $sql = "SELECT dc_log.id as dc_log_id, dc_log.intdate as log_intdate  FROM dc_log
        		INNER JOIN dc_101otel_room_categories_link ON dc_101otel_room_categories_link.hms_category_id = dc_log.categoryid    
        		INNER JOIN dc_101otel_room_categories ON dc_101otel_room_categories.id = dc_101otel_room_categories_link.dc_category_id
				WHERE dc_log.dc_id = 9 AND dc_log.intdate >= " . $intdate_today . " 
				GROUP BY dc_log.categoryid, dc_log.intdate";
        
        $query = $this->db->query($sql);
        
        // echo $sql;
        //die();
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                if ($row->dc_log_id > $last_id) {
                    $last_id = $row->dc_log_id;
                }
            }
        } else {
            $data_return["response"] = 3;
            return $data_return;
        }
        
        $sql = "SELECT dc_log_restrict.id as dc_log_id, dc_log_restrict.intdate as log_intdate  FROM dc_log_restrict
        		INNER JOIN dc_101otel_room_categories_link ON dc_101otel_room_categories_link.hms_category_id = dc_log_restrict.category_id    
        		INNER JOIN dc_101otel_room_categories ON dc_101otel_room_categories.id = dc_101otel_room_categories_link.dc_category_id
				WHERE dc_log_restrict.dc_id = 9 AND dc_log_restrict.intdate >= " . $intdate_today . " 
				GROUP BY dc_log_restrict.restrict_id, dc_log_restrict.category_id, dc_log_restrict.intdate";
        
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                if ($row->dc_log_id > $last_restrict_id) {
                    $last_restrict_id = $row->dc_log_id;
                }
            }
        }
        $result_101otel = "";
        $data_return = array();
        
        if ($general_update == 1) {
            /*
             * GET OVERBOOKING_RESERVATIONS_ARRAY
             */
            
            $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log(9);
            
            list ($year, $month, $day) = explode("-", date("Y-m-d"));
            $intdatein_now = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
            if ($intdatein_now > $datein_out_mass["intdatein"]) {
                $datein_101otel = gmdate("Y-m-d", $intdatein_now * 86400);
            } else {
                $datein_101otel = gmdate("Y-m-d", $datein_out_mass["intdatein"] * 86400);
            }
            
            $dateout = gmdate("Y-m-d", $datein_out_mass["intdateout"] * 86400);
            
            list ($year, $month, $day) = explode("-", $datein_101otel);
            $intdatein = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
            list ($year, $month, $day) = explode("-", $dateout);
            $intdateout = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
            
            $restrict = array();
            $rooms = array();
            $dc_rooms_new = array();
            
            $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat($intdatein, $intdateout);
            $cell = array();
            
            $sql = "SELECT dc_101otel_room_categories_link.min, dc_101otel_room_categories_link.max, dc_101otel_room_categories_link.hms_category_id,
				count(rooms.id) as rooms_count, count(deskofdays.room_id) as reserved_rooms_count,
				deskofrate.minstay, deskofrate.maxstay, deskofrate.minstayarrival, deskofrate.minstaythrought, deskofrate.closed,
				deskofrate.closedonarrival, deskofrate.minstay, deskofrate.closedondeparture, dc_log.restrict, dc_log.intdate, dc_log_restrict.intdate as restrict_intdate,
				dc_101otel_room_categories_link.dc_category_id as dc_category_id, dc_101otel_rates.rate_id as dc_rate_id
				FROM dc_log
				INNER JOIN dc_101otel_room_categories_link ON dc_log.categoryid = dc_101otel_room_categories_link.hms_category_id
            	INNER JOIN dc_101otel_room_categories ON dc_101otel_room_categories.id = dc_101otel_room_categories_link.dc_category_id
				INNER JOIN  dc_101otel_rates ON dc_101otel_rates.room_category = dc_101otel_room_categories_link.dc_category_id
				INNER JOIN categories ON categories.id = dc_log.categoryid
				INNER JOIN rooms ON rooms.category_id = categories.id
				LEFT JOIN deskofdays ON deskofdays.room_id = rooms.id AND deskofdays.intdate = dc_log.intdate
                LEFT JOIN dc_log_restrict ON dc_log_restrict.intdate = dc_log.intdate AND dc_101otel_rates.restricted_id = dc_log_restrict.restrict_id 
                AND dc_101otel_room_categories_link.hms_category_id = dc_log_restrict.category_id AND dc_log_restrict.dc_id = 9 
				LEFT JOIN deskofrate ON deskofrate.intdate = dc_log.intdate AND deskofrate.category_id = dc_log.categoryid 
                AND dc_101otel_rates.restricted_id = deskofrate.rate_id
				WHERE dc_log.dc_id = 9 AND categories.is_active = 1 
				GROUP BY dc_101otel_room_categories_link.dc_category_id, dc_101otel_rates.rate_id, dc_log.intdate";
            //echo $sql;
            // die();
            $query = $this->db->query($sql);
            
            foreach ($query->result() as $row) {
                // =============================rooms====================
                $min = $row->min;
                $max = $row->max;
                $hms_category_id = $row->hms_category_id;
                
                $count_overbook_rooms = 0;
                if (isset($overbooking_reservations_array[$hms_category_id][$row->intdate])) {
                    $count_overbook_rooms = $overbooking_reservations_array[$hms_category_id][$row->intdate];
                }
                $free_rooms = $row->rooms_count - ($row->reserved_rooms_count + $count_overbook_rooms);
                
                if ($free_rooms > $min) {
                    $free_rooms = $free_rooms - $min;
                } else {
                    $free_rooms = 0;
                }
                
                if ($free_rooms > $max) {
                    $free_rooms = $max;
                }
                
                // коррекція к-сті відповідно умовам ф-ї availability_count_correction
                $startdate = $enddate = date("Y-m-d", $row->intdate*86400);
                $free_rooms = $this->frontdesk_c2->availability_count_correction($free_rooms, $startdate, $enddate);
                
                // ============================restrict==================
                
                if ($row->closed == 1) {
                    $closed = 1;
                } else {
                    $closed = 0;
                }
                
                if ($row->closedonarrival == 1) {
                    $closed_on_arrival = 1;
                } else {
                    $closed_on_arrival = 0;
                }
                if ($row->closedondeparture == 1) {
                    $closed_on_departure = 1;
                } else {
                    $closed_on_departure = 0;
                }
                if ($row->minstaythrought != 0) {
                    $min_stay = $row->minstaythrought;
                } else {
                    $min_stay = 0;
                }
                
                // ==============PUSH Data to Array=======================
                if ($upload_restrict == 1 && $row->restrict_intdate != NULL) {
                    
                    $cell[$row->intdate]["start"] = gmdate("Y-m-d", $row->intdate * 86400);
                    $cell[$row->intdate]["end"] = gmdate("Y-m-d", $row->intdate * 86400);
                    $cell[$row->intdate]["quota"][$row->dc_category_id] = $free_rooms;
                    
                    $cell[$row->intdate]["closed"][$row->dc_category_id] = $closed;
                    
                    $cell[$row->intdate]["closed_to_arrival"][$row->dc_category_id][$row->dc_rate_id] = $closed_on_arrival;
                    $cell[$row->intdate]["closed_to_departure"][$row->dc_category_id][$row->dc_rate_id] = $closed_on_departure;
                    $cell[$row->intdate]["min_stay"][$row->dc_category_id][$row->dc_rate_id] = $min_stay;
                } else {
                    
                    $cell[$row->intdate]["start"] = gmdate("Y-m-d", $row->intdate * 86400);
                    $cell[$row->intdate]["end"] = gmdate("Y-m-d", $row->intdate * 86400);
                    $cell[$row->intdate]["quota"][$row->dc_category_id] = $free_rooms;
                }
            }
            
            ksort($cell);
            foreach ($cell as $intdate => $value) {
                array_push($dc_rooms_new, $cell[$intdate]);
            }
            
            echo "<pre>";
            print_r($dc_rooms_new);
            // die();
            
            // ===========================start optimized==========
            
            if (true) {
                $count_req = count($dc_rooms_new);
                for ($i = 1; $i < $count_req; $i ++) {
                    
                    $bool = 0;
                    $prev = $i - 1;
                    
                    list ($year, $month, $day) = explode("-", $dc_rooms_new[$prev]["end"]);
                    $prev_date_end_int = mktime(0, 0, 0, $month, $day, $year) / 86400;
                    list ($year, $month, $day) = explode("-", $dc_rooms_new[$i]["start"]);
                    $date_start_int = mktime(0, 0, 0, $month, $day, $year) / 86400;
                    
                    if (($prev_date_end_int + 1) != $date_start_int) {
                        continue;
                    }
                    
                    $temp_1 = $dc_rooms_new[$prev];
                    $temp_2 = $dc_rooms_new[$i];
                    
                    unset($temp_1["start"]);
                    unset($temp_1["end"]);
                    unset($temp_2["start"]);
                    unset($temp_2["end"]);
                    
                    // echo var_dump($temp_1 === $temp_2);
                    if ($temp_1 === $temp_2) {
                        $dc_rooms_new[$i]["start"] = $dc_rooms_new[$prev]["start"];
                        unset($dc_rooms_new[$prev]);
                    }
                }
                $dc_rooms_new2 = array();
                foreach ($dc_rooms_new as $intdate => $value) {
                    array_push($dc_rooms_new2, $dc_rooms_new[$intdate]);
                }
                $dc_rooms_new = $dc_rooms_new2;
            }
            
            // ===========================end optimized==========
			print_r($dc_rooms_new);
			//die();
            if (sizeof($dc_rooms_new) == 0) {
                $sql = "DELETE dc_log FROM dc_log	
                WHERE id <=" . $last_id . " AND dc_id = 9 AND time < " . $last_time;              
                // echo $sql;
                $query = $this->db->query($sql);
                $data_return["response"] = 4;
                $data_return["responsebody"] = "skipped, empty data" . "datein = $datein_101otel; dateout = $dateout;";
                return $data_return;
            }
            
            $data_result = $this->dcm_101otel->update_rooms($dc_rooms_new, array(), 1);
            
            $result = $data_result["result"];
            $dc_log_id = $data_result["dc_log_id"];
            
            $data_return["dc_log_id"] = $dc_log_id;
            $data_return["datein"] = $datein_101otel;
            $data_return["dateout"] = $dateout;
            //echo $result->response;
            //die();
            if ($result->response == 1) {
                
                $result_101otel = "101otel: Success";
                $sql = "DELETE dc_log FROM dc_log
                WHERE dc_log.id <=" . $last_id . " AND dc_log.dc_id = 9 AND dc_log.time < " . $last_time;  
                $query = $this->db->query($sql);
                
                $sql = "DELETE dc_log_restrict FROM dc_log_restrict
                WHERE dc_log_restrict.id <=" . $last_restrict_id . " AND dc_log_restrict.dc_id = 9";  
                $query = $this->db->query($sql);
                
                $data_return["response"] = 1;
                $data_return["responsebody"] = "success";
            } else {
                if (isset($result->errors[0]->code)) {
                    if ($result->errors[0]->code == 10) {
                        $sql = "DELETE dc_log FROM dc_log
                		WHERE dc_log.id <=" . $last_id . " AND dc_log.dc_id = 9 AND time < " . $last_time; 
                        $query = $this->db->query($sql);
                        
                        $sql = "DELETE dc_log_restrict FROM dc_log_restrict
                		WHERE dc_log_restrict.id <=" . $last_restrict_id . " AND dc_log_restrict.dc_id = 9";  
                		$query = $this->db->query($sql);
                    }
                    if ($result->errors[0]->code == 6) {
                        $this->dcm_101otel->set_general_update(0);
                    }
                }
                $data_return["response"] = 0;
                $data_return["errmsg"] = $result->errors;
                
                $data_return["errmsg"] = "datein = $datein_101otel; dateout = $dateout; " . print_r($result->errors, true);
                $data_return["responsebody"] = "datein = $datein_101otel; dateout = $dateout; " . print_r($data_return["errmsg"], true);
            }
        } else {}
        
        return $data_return;
    }

    function setavailability_lastchanged_10()
    {
        $general_update = 0;
        $sql = "SELECT int_value FROM dc_wubook_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $general_update = $row->int_value;
        }
        $data_return = array();
        if ($general_update == 1) {} else {
            $data_return["response"] = 2;
            return $data_return;
        }
        
        $min_date = 0;
        $max_date = 0;
        $data_return = array();
        $intdate_today = floor(time() / 86400);
        $last_id = 0;
        $last_time = time();
        $sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms  FROM categories
				INNER JOIN dc_log ON dc_log.categoryid = categories.id
				INNER JOIN rooms ON rooms.category_id = categories.id 
				WHERE dc_log.dc_id = 10 AND dc_log.intdate >= " . $intdate_today . " 
				GROUP BY dc_log.categoryid, dc_log.intdate";
        $query = $this->db->query($sql);
        
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                if ($min_date == 0) {
                    $min_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate < $min_date) {
                        $min_date = $row->log_intdate;
                    }
                }
                
                if ($max_date == 0) {
                    $max_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate > $max_date) {
                        $max_date = $row->log_intdate;
                    }
                }
                
                if ($row->dc_log_id > $last_id) {
                    $last_id = $row->dc_log_id;
                }
            }
        } else {
            $data_return["response"] = 3;
            return $data_return;
        }
        
        $result_wubook = "";
        
        // echo $general_update_HsClub;
        $data_return = array();
        
        if ($general_update == 1) {
            
            $wubook_conf = $this->dcm_wubook->GetWubookParameters();
            $rpc = $wubook_conf["wubook_url"];
            $wubook_user = $wubook_conf["wubook_user"];
            $wubook_pass = $wubook_conf["wubook_pass"];
            $wubook_lcode = $wubook_conf["wubook_lcode"];
            $params = array(
                'url' => $rpc,
                'autoload' => ! true
            );
            $this->load->library('xmlrpc_client', $params, 'wubookclient');
            
            $response = $this->wubookclient->call('get_token', array(
                $wubook_user,
                $wubook_pass
            ), false);
            $token = $response[1];
            $lcode = $wubook_lcode;
            // die();
            
            $free_rooms = $this->dcm_wubook->GetFreeRooms_from_dc_log();
            // echo "<pre>";
            // print_r ( $free_rooms );
            
            $rooms = $free_rooms;
            $count_rooms = count($rooms);
            
            $array = array();
            
            $k = 0;
            $category_keys = array_keys($rooms);
            foreach ($category_keys as $dc_category_id) {
                $array[$k]["id"] = $dc_category_id;
                $j = 0;
                $intdate_keys = array_keys($rooms[$dc_category_id]);
                foreach ($intdate_keys as $intdate) {
                    $array[$k]["days"][$j]["avail"] = $rooms[$dc_category_id][$intdate]["free"];
                    $array[$k]["days"][$j]["date"] = gmdate("d/m/Y", $intdate * 86400);
                    $j ++;
                }
                $k ++;
            }
            // echo "<pre>";
            // print_r ( $array );
            $data_log = array(
                'request' => print_r($array, true)
            );
            
            $this->db->insert('dc_wubook_log', $data_log);
            $dc_log_id = $this->db->insert_id();
            
            $resp = $this->wubookclient->call('update_sparse_rooms_values', array(
                $token,
                $lcode,
                $array
            ), false);
            $timestart = microtime(true);
            $data_log = array(
                'response' => print_r($resp, true),
                'stime' => (microtime(true) - $timestart)
            );
            
            $this->db->update('dc_wubook_log', $data_log, array(
                'id' => $dc_log_id
            ));
            
            $datein = gmdate("Y-m-d", $min_date * 86400);
            $dateout = gmdate("Y-m-d", $max_date * 86400);
            $data_return["dc_log_id"] = $dc_log_id;
            $data_return["datein"] = gmdate("Y-m-d", $min_date * 86400);
            $data_return["dateout"] = gmdate("Y-m-d", $max_date * 86400);
            
            if ($resp[0] == 0) {
                
                $result_101otel = "Wubook: Success";
                $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 10 AND time < " . $last_time;
                // echo $sql;
                $query = $this->db->query($sql);
                $data_return["response"] = 1;
                $data_return["responsebody"] = "success";
                
                // $this->dc_model->Delete_dclog_last_data ( 4 );
            } else {
                // echo "<pre>";
                // $hsClub_result = "HsClub: " . $reservationdata ['errmsg'];
                $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 10 AND time < " . $last_time;
                // echo $sql;
                $query = $this->db->query($sql);
                $data_return["response"] = 0;
                
                $data_return["errmsg"] = "datein = $datein; dateout = $dateout; " . print_r($resp, true);
                $data_return["responsebody"] = "datein = $datein; dateout = $dateout; " . print_r($resp, true);
            }
            
            // echo "<pre>";
            // print_r ( $data );
        } else {}
        return $data_return;
    }

    function setavailability_lastchanged_11($db_name)
    {
        $general_update = 0;
        $sql = "SELECT int_value FROM dc_hrs_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $general_update = $row->int_value;
        }
        $data_return = array();
        if ($general_update == 1) {} else {
            $data_return["response"] = 2;
            return $data_return;
        }
        return $this->dc_model->set_rate_lastchanged_11('l', $db_name);
    }

    function setavailability_lastchanged_12()
    {
        $general_update = 0;
        $sql = "SELECT int_value FROM dc_vashotel_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $general_update = $row->int_value;
        }
        $data_return = array();
        if ($general_update == 1) {} else {
            $data_return["response"] = 2;
            return $data_return;
        }
        
        $dc_rates_link = array();
        $sql = "SELECT dc_vashotel_rates_link.*  FROM dc_vashotel_rates_link ";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $dc_rates_link[$row->dc_rate_id] = $row->hms_rate_id;
            }
        }
        
        $dc_categories = array();
        $categories = array();
        $sql = "SELECT dc_vashotel_rooms_link.*  FROM dc_vashotel_rooms_link ";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $dc_categories[$row->category_id] = $row->dc_room_id;
                $categories[$row->dc_room_id] = $row->category_id;
            }
        }
        
        $dc_rates = array();
        $dc_rates_restrict = array();
        $sql = "SELECT dc_rate_id, restrict_id  FROM dc_vashotel_rates_link ";
        $query = $this->db->query($sql);
        $dc_rate_id = 0;
        $restrict_id = 0;
        if ($query->num_rows() > 0) {
            $r_i = 0;
            foreach ($query->result() as $row) {
                $dc_rates[$r_i] = $row->dc_rate_id;
                $dc_rate_id = $row->dc_rate_id;
                $restrict_id = $row->restrict_id;
                $dc_rates_restrict[$row->dc_rate_id] = $row->restrict_id;
                $r_i ++;
            }
        }
        
        $min_date = 0;
        $max_date = 0;
        $categories_rooms_all = array();
        $data_return = array();
        $intdate_today = floor(time() / 86400);
        $last_id = 0;
        $last_time = time();
        $first_intdate = 0;
        $last_intdate = 0;
        $sql = "SELECT deskofrate.closed, dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms  
				FROM
				(SELECT * FROM dc_log WHERE dc_log.dc_id = 12 ORDER BY id LIMIT 0, 1600) as dc_log
				INNER JOIN categories ON dc_log.categoryid = categories.id
				INNER JOIN rooms ON rooms.category_id = categories.id
            
                LEFT JOIN deskofrate ON deskofrate.intdate = dc_log.intdate 
                    AND deskofrate.category_id = dc_log.categoryid 
                    AND deskofrate.rate_id = " . $restrict_id .  "
            
				WHERE rooms.dc_active=1 AND dc_log.dc_id = 12 AND dc_log.intdate >= " . $intdate_today . "
				GROUP BY dc_log.categoryid, dc_log.intdate ORDER BY dc_log.id";
        
        echo "\n\n" . $sql . "\n\n";
        // die();
        
        $query = $this->db->query($sql);
        
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                if ($min_date == 0) {
                    $min_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate < $min_date) {
                        $min_date = $row->log_intdate;
                    }
                }
                
                if ($max_date == 0) {
                    $max_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate > $max_date) {
                        $max_date = $row->log_intdate;
                    }
                }
                // echo $min_date + 350 ."<". $max_date."<br>";
                if ($min_date + 350 < $max_date) {
                    echo "\n\n overload 360 \n\n";
                    // die();
                    break;
                }
                $categories_rooms_all[$row->category_id][$row->log_intdate]["free"] = $row->count_rooms;
                $categories_rooms_all[$row->category_id][$row->log_intdate]["date"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                if ($row->closed == 1) {
                    $categories_rooms_all[$row->category_id][$row->log_intdate]["closed"] = 1;
                } else {
                    $categories_rooms_all[$row->category_id][$row->log_intdate]["closed"] = 0;
                }
                // $last_id = $row->dc_log_id;
                if ($row->dc_log_id > $last_id) {
                    $last_id = $row->dc_log_id;
                }
            }
            echo "=====================" . $last_id;
            // die();
        } else {
            $data_return["response"] = 3;
            echo "\n\n return #1\n\n" . $last_id;
            return $data_return;
        }
        
        // echo "<pre>";
        // print_r ( $categories_rooms_all );
        // die();
        $categories_rooms_intdate = array();
        
        $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
FROM  `rooms`
INNER JOIN categories ON categories.id = rooms.category_id
INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
dc_log.categoryid = rooms.category_id
WHERE dc_log.dc_id = 12
GROUP BY deskofdays.intdate, rooms.category_id";
        ;
        
        echo "\n\n" . $sql . "\n\n";
        // die();
        
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                $categories_rooms_intdate[$row->id][$row->intdate]["free"] = $row->count_rooms;
            }
        }
        
        // echo "<pre>";
        // print_r ( $categories_rooms_all );
        
        $query = $this->db->query("SELECT int_value FROM dc_vashotel_xml_cfg WHERE name LIKE 'hotel_id'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $hotel_id = $row->int_value;
        } else {
            $hotel_id = "none";
        }
        
        echo "+++++++++++++++";
        $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log(12);
        echo "+++++++++++++++==========================";
        $overbooking_reservations_array = array();
        if (isset($datein_out_mass["intdatein"])) {
            $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat($datein_out_mass["intdatein"], $datein_out_mass["intdateout"]);
        }
        
        $setrestrict_result = "";
        $result = "";
        $sql = "SELECT int_value FROM dc_vashotel_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        
        if ($general_update == 1) {
            $category_keys = array_keys($categories_rooms_all);
            foreach ($category_keys as $category_id) {
                
                $sql = "select min, max from dc_vashotel_rooms_link where category_id =" . $category_id;
                $query = $this->db->query($sql);
                if ($query->num_rows() > 0) {
                    $row2 = $query->row();
                    $min = $row2->min;
                    $max = $row2->max;
                } else {
                    $min = 0;
                    $max = 999;
                }
                
                $arr_intdate_keys = array_keys($categories_rooms_all[$category_id]);
                foreach ($arr_intdate_keys as $intdate) {
                    if (isset($categories_rooms_intdate[$category_id][$intdate])) {
                        $count_overbook_rooms = 0;
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                        }
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
                    } else {
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                            $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $count_overbook_rooms;
                        }
                    }
                    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
                    } else {
                        $categories_rooms_all[$category_id][$intdate]["free"] = 0;
                    }
                    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $max;
                    }
                    
                    // коррекція к-сті відповідно умовам ф-ї availability_count_correction
                    $startdate = $enddate = date("Y-m-d", $intdate*86400);
                    $categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
                    
                }
            }
            echo "++++++++0000000000+++++++";
            $freeRooms = $categories_rooms_all;
            // echo "<pre>";
            // print_r ( $freeRooms );
            // die ();
            $roomslist = array();
            foreach ($freeRooms as $category_id => $intdate_array) {
                foreach ($intdate_array as $intdate => $cell) {
                    if (isset($dc_categories[$category_id])) {
                        $dc_room_id = $dc_categories[$category_id];
                        $date = gmdate("Y-m-d", $intdate * 86400);
                        $roomslist[$dc_room_id][$date]["sellquantity"] = $freeRooms[$category_id][$intdate]["free"];
                        if ($roomslist[$dc_room_id][$date]["sellquantity"] == 0) {
                            $roomslist[$dc_room_id][$date]["closed"] = 1;
                        } else {
                            $roomslist[$dc_room_id][$date]["closed"] = 0;
                        }
                    }
                }
            }
            // echo "<pre>";
            // print_r ( $roomslist );
            // die ();
            
            if (count($roomslist) < 1) {
                $query = $this->db->query("DELETE FROM dc_log WHERE dc_id = 12");
                $data_return["response"] = 4;
                return $data_return;
            }
            
            
            echo "++++++++11111111111+++++++";
            //$restrict_array = $this->dcm_vashotel->select_restrict();
            echo "++++++++22222222222222222+++++++";
            // echo "===";
            // print_r($restrict_array);
            // die();
            $script_name = 'set_availability.php';
            $api_key = "fWjh8ms4X6Zyn40rFPDK";
            $api_key = $this->dcm_vashotel->get_api_key();
            $count_dc_rates = count($dc_rates);
            for ($i = 0; $i < $count_dc_rates; $i ++) {
                $roomslist_new = array();
                foreach ($roomslist as $dc_room_id => $dates) {
                    foreach ($dates as $date => $cell) {
                        
                        $roomslist_new[$dc_rates[$i]][$dc_room_id][$date] = $cell;
                        
                        /*
                        if (isset($restrict_array[$dc_rates_restrict[$dc_rates[$i]]][$categories[$dc_room_id]][$date]["closed"])) {
                            $roomslist_new[$dc_rates[$i]][$dc_room_id][$date] = $cell;
                            if ($roomslist_new[$dc_rates[$i]][$dc_room_id][$date]["sellquantity"] == 0) {
                                $roomslist_new[$dc_rates[$i]][$dc_room_id][$date]["closed"] = 1;
                            } else {
                                $roomslist_new[$dc_rates[$i]][$dc_room_id][$date]["closed"] = $restrict_array[$dc_rates_restrict[$dc_rates[$i]]][$categories[$dc_room_id]][$date]["closed"];
                            }
                        } else {
                            $roomslist_new[$dc_rates[$i]][$dc_room_id][$date] = $cell;
                        }
                        
                        */
                    }
                }
                $data = array();
                $data['salt'] = 'juik';
                $data['rate_id'] = $dc_rates[$i];
                $data['hotel_id'] = $this->dcm_vashotel->gethotelid();
                $data['rooms'] = $roomslist_new[$dc_rates[$i]];
                
                echo "<pre>";
                print_r ( $data );
                
                //die();
                $rooms = $this->dcm_vashotel->signaturalizer($data, $script_name, $api_key);
                // echo "<pre>";
                // print_r ( $rooms );
                
                // die();
                
                echo "\n";
                
                $mode = $this->dcm_vashotel->get_api_url();
                $url = "https://" . $mode . "/hotel_xml/" . $script_name; // https://www.vashotel.ru/hotel_xml/get_availability.php
                
                $xml = '<?xml version="1.0" encoding="utf-8"?>
<request>
' . $rooms['xml'] . '
</request>';
                
                // echo $xml . "\n";
                $data_result = $this->Curl_model->CurlPlugRAW($xml, $url, 12, array(
                    "returntype" => "array"
                ));
                
                echo "<pre>";
                print_r($data_result);
                
                // $data_return ["responsebody"] = $result;
                $result = $data_result["result"];
                $dc_log_id = $data_result["dc_log_id"];
                // echo $result;
                // return $result;
                
                if ($general_update != 0)
                    
                    // $this->dc_model->Delete_dclog_last_data ( 1 );
                    $data_return["array"][$i]["dc_log_id"] = $dc_log_id;
                $data_return["array"][$i]["datein"] = gmdate("Y-m-d", $min_date * 86400);
                $data_return["array"][$i]["dateout"] = gmdate("Y-m-d", $max_date * 86400);
                if ($general_update == 0) {
                    echo "Ban upload for booking service";
                } else {
                    
                    $xml = simplexml_load_string($result);
                    if ($xml === false) {
                        $data_return["array"][$i]["response"] = 0;
                        $data_return["array"][$i]["errmsg"] = "Ошибка XML 12!";
                        $data_return["array"][$i]["responsebody"] = "Ошибка XML 12!";
                        $query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 12 AND time < " . $last_time);
                    } else {
                        if ($xml->status == "ok") {
                            $data_return["array"][$i]["response"] = 1;
                            $data_return["array"][$i]["responsebody"] = "success";
                            if (isset($xml->warning)) {
                                $data_return["array"][$i]["responsebody"] = "success" . "<br>" . $xml->warning;
                            }
                            $query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 12 AND time < " . $last_time);
                        } else {
                            if (isset($xml->error_code)) {
                                $data_return["array"][$i]["response"] = 0;
                                $data_return["array"][$i]["errmsg"] = $xml->status . " error_code: " . $xml->error_code . " error_description:" . $xml->error_description;
                                $data_return["array"][$i]["responsebody"] = $xml->status . " error_code: " . $xml->error_code . " error_description:" . $xml->error_description;
                                $query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 12 AND time < " . $last_time);
                            }
                        }
                    }
                }
            }
        }
        echo "/*/*/*/*/**/*/*/*/\n\n" . $last_id . "\n\n";
        return $data_return;
    }

    function setavailability_lastchanged_13($dc_hotel_id = 0)
    {
        $dc_account_id = 0;
        $sql = "SELECT dc_account_id FROM dc_bronevik_xml_cfg WHERE int_value = ".$dc_hotel_id;
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $dc_account_id = $row->dc_account_id;
        }
        $authparam = $this->dcm_bronevik->getauthparam_v2($dc_account_id);
        $api_key = $authparam["api_key"];
        
        $general_update = 0;
        $sql = "SELECT int_value FROM dc_bronevik_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $general_update = $row->int_value;
        }
        $data_return = array();
        if ($general_update == 1) {} else {
            $data_return["response"] = 2;
            return $data_return;
        }
        
        $query = $this->db->query("SELECT value FROM hotelix_config WHERE name LIKE 'overbooking_category_id'");
        
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $overbookcatid = $row->value;
        }
        
        $restrict_rate_id = 0;
        $sql = "SELECT int_value FROM dc_bronevik_xml_cfg WHERE name LIKE 'restrict_rate_id'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $restrict_rate_id = $row->int_value;
        }
        
        $categories = array();
        
        $query = $this->db->query("SELECT dc_category_id, hms_category_id FROM dc_bronevik_room_categories_link");
        
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $categories[$row->hms_category_id] = $row->dc_category_id;
            }
        }
        
        $min_date = 0;
        $max_date = 0;
        $categories_rooms_all = array();
        $data_return = array();
        $intdate_today = floor(time() / 86400);
        $last_id = 0;
        $last_time = time();
        
        $sql = "SELECT id as dc_log_id FROM dc_log WHERE dc_id = 13 AND dc_log.dc_hotel_id = ".$dc_hotel_id." ORDER BY id ASC";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
        	foreach ($query->result() as $row) {
        		$last_id = $row->dc_log_id;
        		
        	}
        }
        
        $sql = "select count_rooms, booked, if (if (((count_rooms-IFNULL(booked,0)) ) > min, ((count_rooms-IFNULL(booked,0)) ) - min, 0) > max, max,  
if (((count_rooms-IFNULL(booked,0)) ) > min, ((count_rooms-IFNULL(booked,0)) ) - min, 0))
 as free,
 days.category_id, log_intdate as intdate, min, max, dc_log_id, closed from 
(SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms,
min, max, dc_bronevik_room_categories_link.dc_category_id
 FROM categories
				INNER JOIN dc_log ON dc_log.categoryid = categories.id
				INNER JOIN rooms ON rooms.category_id = categories.id
INNER JOIN dc_bronevik_room_categories_link on dc_bronevik_room_categories_link.hms_category_id = dc_log.categoryid


				WHERE rooms.dc_active=1 AND dc_log.dc_id = 13 AND dc_log.dc_hotel_id = ".$dc_hotel_id." 
				GROUP BY dc_log.categoryid, dc_log.intdate) as days
left join (SELECT  count(deskofdays.intdate) as booked, sum(1) as bookedr,
dc_log.`categoryid`, dc_log.`intdate` FROM 
deskofdays 
inner join rooms on (deskofdays.room_id=rooms.id)
left join deskofreservation on (deskofreservation.id = deskofdays.reservation_id)
inner join dc_log on 
(rooms.id=deskofdays.room_id and rooms.category_id=dc_log.categoryid and dc_log.intdate=deskofdays.intdate)
or 
(rooms.id=deskofdays.room_id and rooms.category_id = " . $overbookcatid . " and dc_log.intdate=deskofdays.intdate and deskofreservation.origin_categoryid=dc_log.`categoryid`)
inner join dc_bronevik_room_categories_link on dc_bronevik_room_categories_link.hms_category_id = dc_log.categoryid

WHERE dc_log.dc_id=13 AND dc_log.dc_hotel_id = ".$dc_hotel_id."
group by dc_log.`categoryid`, dc_log.`intdate`) as tbooked
on days.category_id = tbooked.categoryid and days.log_intdate = tbooked.intdate

inner join (select dc_category_id, hms_restrict_id from dc_bronevik_rate2category_link group by dc_category_id) as dc_bronevik_rate2category_link_
on dc_bronevik_rate2category_link_.dc_category_id = days.dc_category_id

LEFT JOIN deskofrate ON deskofrate.intdate = log_intdate AND deskofrate.category_id = days.category_id  AND deskofrate.rate_id = ".$restrict_rate_id;
//AND dc_bronevik_rate2category_link_.hms_restrict_id = deskofrate.rate_id";
        echo $sql;
        $query = $this->db->query($sql);
        // die();
        // echo "start wait\n";
        // sleep(15);
        // echo "done wait\n";
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                if ($row->intdate != Null) {
                    if ($min_date == 0) {
                        $min_date = $row->intdate;
                    } else {
                        if ($row->intdate < $min_date) {
                            $min_date = $row->intdate;
                        }
                    }
                    
                    if ($max_date == 0) {
                        $max_date = $row->intdate;
                    } else {
                        if ($row->intdate > $max_date) {
                            $max_date = $row->intdate;
                        }
                    }
                    
                    $categories_rooms_all[$row->category_id][$row->intdate]["free"] = $row->free;
                    // коррекція к-сті відповідно умовам ф-ї availability_count_correction
                    $startdate = $enddate = date("Y-m-d", $row->intdate*86400);
                    $categories_rooms_all[$row->category_id][$row->intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$row->category_id][$row->intdate]["free"], $startdate, $enddate);
                    
                    if ($row->closed == 1) {
                        $categories_rooms_all[$row->category_id][$row->intdate]["closed"] = "true";
                    } else {
                        $categories_rooms_all[$row->category_id][$row->intdate]["closed"] = "false";
                    }
                    
                    $categories_rooms_all[$row->category_id][$row->intdate]["date"] = gmdate("Y-m-d", $row->intdate * 86400);
                    
                    $categories_rooms_all[$row->category_id][$row->intdate]["from"] = gmdate("Y-m-d", $row->intdate * 86400);
                    $categories_rooms_all[$row->category_id][$row->intdate]["to"] = gmdate("Y-m-d", $row->intdate * 86400);
                }
                
                if ($row->dc_log_id > $last_id) {
                    $last_id = $row->dc_log_id;
                }
            }
        } else {
        	$sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 13 AND dc_hotel_id = ".$dc_hotel_id;
        	// echo $sql;
        	$query = $this->db->query($sql);
            $data_return["response"] = 3;
            return $data_return;
        }
        
        echo "<pre>";
        print_r($categories_rooms_all);
        // die();
        
                
        /*
         * Выгрузка загружености с booking
         */
        
        $result = "";
        
        //if ($general_update == 1) {
            $category_keys = array_keys($categories_rooms_all);
            foreach ($category_keys as $category_id) {
                
                $arr_intdate_keys = array_keys($categories_rooms_all[$category_id]);
                foreach ($arr_intdate_keys as $intdate) {
                    
                    $prev = $intdate - 1;
                    if (isset($categories_rooms_all[$category_id][$prev])) {
                        $free_1 = $categories_rooms_all[$category_id][$prev]["free"];
                        $free_2 = $categories_rooms_all[$category_id][$intdate]["free"];
                        
                        $closed_1 = $categories_rooms_all[$category_id][$prev]["closed"];
                        $closed_2 = $categories_rooms_all[$category_id][$intdate]["closed"];
                        
                        if ($free_1 == $free_2 && $closed_1 == $closed_2) {
                            $categories_rooms_all[$category_id][$intdate]["from"] = $categories_rooms_all[$category_id][$prev]["from"];
                            unset($categories_rooms_all[$category_id][$prev]);
                        }
                    }
                }
            }
            
            $roomslist = array();
            foreach ($categories_rooms_all as $dc_category_id => $cell) {
                array_push($roomslist, array(
                    'dc_room_id' => $categories[$dc_category_id],
                    'dates' => $cell
                ));
            }
            
            echo "<pre>";
            print_r($roomslist);
//             echo count ( $roomslist );
//             die ('<br>DIED by Y Development Department of HMS IT TEAM<br>11 февр. 2019 г.  17:29:15 <br>dcm_booking.php');
            
            if (count($roomslist) < 1) {
                $query = $this->db->query("DELETE FROM dc_log WHERE dc_id = 13 AND dc_hotel_id = ".$dc_hotel_id);
                $data_return["response"] = 4;
                return $data_return;
            }
            $xml_data = array(
                'hotel_id' => $dc_hotel_id,
                'api_key' => $api_key,
                'roomslist' => $roomslist
            );
            $xml = $this->parser->parse('templates/xml/dc_bronevik_xml_availability.html', $xml_data, true);
            // echo $xml;
            $url = $authparam["url"]."/hotel/channel-manager/xml/";
            $data_result = $this->Curl_model->CurlPostBronevik($xml, $url, array(
                "returntype" => "array"
            ));
            // $data_return ["responsebody"] = $result;
            $result = $data_result["result"];
            $dc_log_id = $data_result["dc_log_id"];
            // print_r($data_result);
            echo $result;
            // die();
            // return $result;
        //}
        // die();
        // if ($general_update != 0)
        
        // $this->dc_model->Delete_dclog_last_data ( 1 );
        $data_return["dc_log_id"] = $dc_log_id;
        $data_return["datein"] = gmdate("Y-m-d", $min_date * 86400);
        $data_return["dateout"] = gmdate("Y-m-d", $max_date * 86400);
        if ($general_update == 0) {
            echo "Ban upload for booking service";
        } else {
            
            $xml = simplexml_load_string($result);
            if ($xml === false) {
                $data_return["response"] = 0;
                $data_return["errmsg"] = $result;
                $data_return["responsebody"] = $result;
            } else {
                print_r($xml);
                echo $xml["Status"];
                // die();
                if (isset($xml["Status"])) {
                    if ($xml["Status"] == "success") {
                        $data_return["response"] = 1;
                        $data_return["responsebody"] = "success";
                        $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 13 AND dc_hotel_id = ".$dc_hotel_id." AND time < " . $last_time;
                        // echo $sql;
                        $query = $this->db->query($sql);
                    } else {
                        $data_return["response"] = 0;
                        $data_return["errmsg"] = $result;
                        $data_return["responsebody"] = $result;
                        
                        $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 13 AND dc_hotel_id = ".$dc_hotel_id." AND time < " . $last_time;
                        $query = $this->db->query($sql);
                    }
                } else {
                    $data_return["response"] = 0;
                    $data_return["errmsg"] = $result;
                    $data_return["responsebody"] = $result;
                    $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 13 AND dc_hotel_id = ".$dc_hotel_id." AND time < " . $last_time;
                    $query = $this->db->query($sql);
                }
            }

            return $data_return;
        }
        
    }
    
    function setavailability_lastchanged_13_OLD2019_02_11()
    {
        $general_update = 0;
        $sql = "SELECT int_value FROM dc_bronevik_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $general_update = $row->int_value;
        }
        $data_return = array();
        if ($general_update == 1) {} else {
            $data_return["response"] = 2;
            return $data_return;
        }
    
        $query = $this->db->query("SELECT value FROM hotelix_config WHERE name LIKE 'overbooking_category_id'");
    
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $overbookcatid = $row->value;
        }
    
        $categories = array();
    
        $query = $this->db->query("SELECT dc_category_id, hms_category_id FROM dc_bronevik_room_categories_link");
    
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $categories[$row->hms_category_id] = $row->dc_category_id;
            }
        }
    
        $min_date = 0;
        $max_date = 0;
        $categories_rooms_all = array();
        $data_return = array();
        $intdate_today = floor(time() / 86400);
        $last_id = 0;
        $last_time = time();
    
        $sql = "SELECT id as dc_log_id FROM dc_log WHERE dc_id = 13 ORDER BY id ASC";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $last_id = $row->dc_log_id;
    
            }
        }
        /*
         * $sql = "select count_rooms, if (if (((count_rooms-IFNULL(booked,0)) ) > min, ((count_rooms-IFNULL(booked,0)) ) - min, 0) > max, max,
         * if (((count_rooms-IFNULL(booked,0)) ) > min, ((count_rooms-IFNULL(booked,0)) ) - min, 0))
             * as free,
             * days.category_id, log_intdate as intdate, min, max, dc_log_id, closed from
             * (SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms,
             * min, max, dc_bronevik_room_categories_link.dc_category_id
             * FROM categories
             * INNER JOIN dc_log ON dc_log.categoryid = categories.id
             * INNER JOIN rooms ON rooms.category_id = categories.id
             * INNER JOIN dc_bronevik_room_categories_link on dc_bronevik_room_categories_link.hms_category_id = dc_log.categoryid
             *
             *
             * WHERE rooms.dc_active=1 AND dc_log.dc_id = 13
             * GROUP BY dc_log.categoryid, dc_log.intdate) as days
             * left join (SELECT count(deskofdays.intdate) as booked, sum(1) as bookedr,
             * dc_log.`categoryid`, dc_log.`intdate` FROM
             * deskofdays
             * inner join rooms on (deskofdays.room_id=rooms.id)
             * inner join deskofreservation on (deskofreservation.id = deskofdays.reservation_id)
             * inner join dc_log on
             * (rooms.id=deskofdays.room_id and rooms.category_id=dc_log.categoryid and dc_log.intdate=deskofdays.intdate)
             * or
             * (rooms.id=deskofdays.room_id and rooms.category_id = ".$overbookcatid." and dc_log.intdate=deskofdays.intdate and deskofreservation.origin_categoryid=dc_log.`categoryid`)
             * inner join dc_bronevik_room_categories_link on dc_bronevik_room_categories_link.hms_category_id = dc_log.categoryid
             *
             * WHERE dc_log.dc_id=13
             * group by dc_log.`categoryid`, dc_log.`intdate`) as tbooked
             * on days.category_id = tbooked.categoryid and days.log_intdate = tbooked.intdate
             *
             * INNER JOIN dc_bronevik_rate2category_link on dc_bronevik_rate2category_link.dc_category_id = days.dc_category_id
             * LEFT JOIN deskofrate ON deskofrate.intdate = days.log_intdate AND deskofrate.category_id = days.category_id AND dc_bronevik_rate2category_link.hms_restrict_id = deskofrate.rate_id
             * GROUP BY days.category_id, log_intdate";
             */
        $sql = "select count_rooms, booked, if (if (((count_rooms-IFNULL(booked,0)) ) > min, ((count_rooms-IFNULL(booked,0)) ) - min, 0) > max, max,
if (((count_rooms-IFNULL(booked,0)) ) > min, ((count_rooms-IFNULL(booked,0)) ) - min, 0))
 as free,
 days.category_id, log_intdate as intdate, min, max, dc_log_id, closed from
(SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms,
min, max, dc_bronevik_room_categories_link.dc_category_id
 FROM categories
				INNER JOIN dc_log ON dc_log.categoryid = categories.id
				INNER JOIN rooms ON rooms.category_id = categories.id
INNER JOIN dc_bronevik_room_categories_link on dc_bronevik_room_categories_link.hms_category_id = dc_log.categoryid
    
    
				WHERE rooms.dc_active=1 AND dc_log.dc_id = 13
				GROUP BY dc_log.categoryid, dc_log.intdate) as days
left join (SELECT  count(deskofdays.intdate) as booked, sum(1) as bookedr,
dc_log.`categoryid`, dc_log.`intdate` FROM
deskofdays
inner join rooms on (deskofdays.room_id=rooms.id)
left join deskofreservation on (deskofreservation.id = deskofdays.reservation_id)
inner join dc_log on
(rooms.id=deskofdays.room_id and rooms.category_id=dc_log.categoryid and dc_log.intdate=deskofdays.intdate)
or
(rooms.id=deskofdays.room_id and rooms.category_id = " . $overbookcatid . " and dc_log.intdate=deskofdays.intdate and deskofreservation.origin_categoryid=dc_log.`categoryid`)
inner join dc_bronevik_room_categories_link on dc_bronevik_room_categories_link.hms_category_id = dc_log.categoryid
    
WHERE dc_log.dc_id=13
group by dc_log.`categoryid`, dc_log.`intdate`) as tbooked
on days.category_id = tbooked.categoryid and days.log_intdate = tbooked.intdate
    
inner join (select dc_category_id, hms_restrict_id from dc_bronevik_rate2category_link group by dc_category_id) as dc_bronevik_rate2category_link_
on dc_bronevik_rate2category_link_.dc_category_id = days.dc_category_id
    
LEFT JOIN deskofrate ON deskofrate.intdate = log_intdate AND deskofrate.category_id = days.category_id
AND dc_bronevik_rate2category_link_.hms_restrict_id = deskofrate.rate_id";
        echo $sql;
        $query = $this->db->query($sql);
        // die();
        // echo "start wait\n";
        // sleep(15);
        // echo "done wait\n";
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                if ($row->intdate != Null) {
                    if ($min_date == 0) {
                        $min_date = $row->intdate;
                    } else {
                        if ($row->intdate < $min_date) {
                            $min_date = $row->intdate;
                        }
                    }
    
                    if ($max_date == 0) {
                        $max_date = $row->intdate;
                    } else {
                        if ($row->intdate > $max_date) {
                            $max_date = $row->intdate;
                        }
                    }
    
                    $categories_rooms_all[$row->category_id][$row->intdate]["free"] = $row->free;
                    if ($row->closed == 1) {
                        $categories_rooms_all[$row->category_id][$row->intdate]["closed"] = "true";
                    } else {
                        $categories_rooms_all[$row->category_id][$row->intdate]["closed"] = "false";
                    }
    
                    $categories_rooms_all[$row->category_id][$row->intdate]["date"] = gmdate("Y-m-d", $row->intdate * 86400);
    
                    $categories_rooms_all[$row->category_id][$row->intdate]["from"] = gmdate("Y-m-d", $row->intdate * 86400);
                    $categories_rooms_all[$row->category_id][$row->intdate]["to"] = gmdate("Y-m-d", $row->intdate * 86400);
                }
    
                $last_id = $row->dc_log_id;
            }
        } else {
            $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 13";
            // echo $sql;
            $query = $this->db->query($sql);
            $data_return["response"] = 3;
            return $data_return;
        }
    
        echo "<pre>";
        print_r($categories_rooms_all);
        // die();
    
        $query = $this->db->query("SELECT int_value FROM dc_bronevik_xml_cfg WHERE name LIKE 'hotel_id'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $hotel_id = $row->int_value;
        } else {
            $hotel_id = "none";
        }
    
        $query = $this->db->query("SELECT str_value FROM dc_bronevik_xml_cfg WHERE name LIKE 'api_key'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $api_key = $row->str_value;
        } else {
            $api_key = "none";
        }
    
        /*
         * Выгрузка загружености с booking
         */
    
        $result = "";
    
        if ($general_update == 1) {
            $category_keys = array_keys($categories_rooms_all);
            foreach ($category_keys as $category_id) {
    
                $arr_intdate_keys = array_keys($categories_rooms_all[$category_id]);
                foreach ($arr_intdate_keys as $intdate) {
    
                    $prev = $intdate - 1;
                    if (isset($categories_rooms_all[$category_id][$prev])) {
                        $free_1 = $categories_rooms_all[$category_id][$prev]["free"];
                        $free_2 = $categories_rooms_all[$category_id][$intdate]["free"];
    
                        $closed_1 = $categories_rooms_all[$category_id][$prev]["closed"];
                        $closed_2 = $categories_rooms_all[$category_id][$intdate]["closed"];
    
                        if ($free_1 == $free_2 && $closed_1 == $closed_2) {
                            $categories_rooms_all[$category_id][$intdate]["from"] = $categories_rooms_all[$category_id][$prev]["from"];
                            unset($categories_rooms_all[$category_id][$prev]);
                        }
                    }
                }
            }
    
            $roomslist = array();
            foreach ($categories_rooms_all as $dc_category_id => $cell) {
                array_push($roomslist, array(
                    'dc_room_id' => $categories[$dc_category_id],
                    'dates' => $cell
                ));
            }
    
            echo "<pre>";
            print_r($roomslist);
            // echo count ( $roomslist );
            //die ();
    
            if (count($roomslist) < 1) {
                $query = $this->db->query("DELETE FROM dc_log WHERE dc_id = 13");
                $data_return["response"] = 4;
                return $data_return;
            }
            $xml_data = array(
                'hotel_id' => $hotel_id,
                'api_key' => $api_key,
                'roomslist' => $roomslist
            );
            $xml = $this->parser->parse('templates/xml/dc_bronevik_xml_availability.html', $xml_data, true);
            // echo $xml;
            $url = "https://xml.bronevik.com/hotel/channel-manager/xml/";
            $data_result = $this->Curl_model->CurlPostBronevik($xml, $url, array(
                "returntype" => "array"
            ));
            // $data_return ["responsebody"] = $result;
            $result = $data_result["result"];
            $dc_log_id = $data_result["dc_log_id"];
            // print_r($data_result);
            echo $result;
            // die();
            // return $result;
        }
        // die();
        // if ($general_update != 0)
    
        // $this->dc_model->Delete_dclog_last_data ( 1 );
        $data_return["dc_log_id"] = $dc_log_id;
        $data_return["datein"] = gmdate("Y-m-d", $min_date * 86400);
        $data_return["dateout"] = gmdate("Y-m-d", $max_date * 86400);
        if ($general_update == 0) {
            echo "Ban upload for booking service";
        } else {
    
            $xml = simplexml_load_string($result);
            if ($xml === false) {
                $data_return["response"] = 0;
                $data_return["errmsg"] = $result;
                $data_return["responsebody"] = $result;
            } else {
                print_r($xml);
                echo $xml["Status"];
                // die();
                if (isset($xml["Status"])) {
                    if ($xml["Status"] == "success") {
                        $data_return["response"] = 1;
                        $data_return["responsebody"] = "success";
                        $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 13 AND time < " . $last_time;
                        // echo $sql;
                        $query = $this->db->query($sql);
                    } else {
                        $data_return["response"] = 0;
                        $data_return["errmsg"] = $result;
                        $data_return["responsebody"] = $result;
                    }
                } else {
                    $data_return["response"] = 0;
                    $data_return["errmsg"] = $result;
                    $data_return["responsebody"] = $result;
                }
            }
    
            return $data_return;
        }
    }

    function setavailability_lastchanged_13_OLD()
    {
        $general_update = 0;
        $sql = "SELECT int_value FROM dc_bronevik_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $general_update = $row->int_value;
        }
        $data_return = array();
        if ($general_update == 1) {} else {
            $data_return["response"] = 2;
            return $data_return;
        }
        
        $min_date = 0;
        $max_date = 0;
        $categories_rooms_all = array();
        $data_return = array();
        $intdate_today = floor(time() / 86400);
        $last_id = 0;
        $last_time = time();
        
        $sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms  FROM categories
				INNER JOIN dc_log ON dc_log.categoryid = categories.id
				INNER JOIN rooms ON rooms.category_id = categories.id
				WHERE rooms.dc_active=1 AND dc_log.dc_id = 13 AND dc_log.intdate >= " . $intdate_today . "
				GROUP BY dc_log.categoryid, dc_log.intdate";
        $query = $this->db->query($sql);
        // echo $sql;
        // echo "start wait\n";
        // sleep(15);
        // echo "done wait\n";
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                if ($min_date == 0) {
                    $min_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate < $min_date) {
                        $min_date = $row->log_intdate;
                    }
                }
                
                if ($max_date == 0) {
                    $max_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate > $max_date) {
                        $max_date = $row->log_intdate;
                    }
                }
                
                $categories_rooms_all[$row->category_id][$row->log_intdate]["free"] = $row->count_rooms;
                $categories_rooms_all[$row->category_id][$row->log_intdate]["date"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                
                $categories_rooms_all[$row->category_id][$row->log_intdate]["from"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                $categories_rooms_all[$row->category_id][$row->log_intdate]["to"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                // $last_id = $row->dc_log_id;
                if ($row->dc_log_id > $last_id) {
                    $last_id = $row->dc_log_id;
                }
            }
        } else {
            $data_return["response"] = 3;
            return $data_return;
        }
        
        // echo "<pre>";
        // print_r ( $categories_rooms_all );
        // die();
        $categories_rooms_intdate = array();
        
        $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
FROM  `rooms`
INNER JOIN categories ON categories.id = rooms.category_id
INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
dc_log.categoryid = rooms.category_id
WHERE dc_log.dc_id = 13
GROUP BY deskofdays.intdate, rooms.category_id";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                $categories_rooms_intdate[$row->id][$row->intdate]["free"] = $row->count_rooms;
            }
        }
        
        // echo "<pre>";
        // print_r ( $categories_rooms_intdate );
        
        $query = $this->db->query("SELECT int_value FROM dc_bronevik_xml_cfg WHERE name LIKE 'hotel_id'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $hotel_id = $row->int_value;
        } else {
            $hotel_id = "none";
        }
        
        $query = $this->db->query("SELECT str_value FROM dc_bronevik_xml_cfg WHERE name LIKE 'api_key'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $api_key = $row->str_value;
        } else {
            $api_key = "none";
        }
        
        /*
         * GET OVERBOOKING_RESERVATIONS_ARRAY
         */
        $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log(13);
        $overbooking_reservations_array = array();
        if (isset($datein_out_mass["intdatein"])) {
            $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat($datein_out_mass["intdatein"], $datein_out_mass["intdateout"]);
        }
        
        // echo "<pre>";
        // print_r($overbooking_reservations_array);
        // die();
        
        /*
         * END GET OVERBOOKING_RESERVATIONS_ARRAY
         */
        
        /*
         * Выгрузка загружености с booking
         */
        
        $setrestrict_result = "";
        $result = "";
        
        if ($general_update == 1) {
            $category_keys = array_keys($categories_rooms_all);
            foreach ($category_keys as $category_id) {
                
                $sql = "select min, max from dc_bronevik_room_categories_link where hms_category_id =" . $category_id;
                $query = $this->db->query($sql);
                if ($query->num_rows() > 0) {
                    $row2 = $query->row();
                    $min = $row2->min;
                    $max = $row2->max;
                } else {
                    $min = 0;
                    $max = 999;
                }
                
                $arr_intdate_keys = array_keys($categories_rooms_all[$category_id]);
                foreach ($arr_intdate_keys as $intdate) {
                    if (isset($categories_rooms_intdate[$category_id][$intdate])) {
                        $count_overbook_rooms = 0;
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                        }
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
                    } else {
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                            $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $count_overbook_rooms;
                        }
                    }
                    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
                    } else {
                        $categories_rooms_all[$category_id][$intdate]["free"] = 0;
                    }
                    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $max;
                    }
                    
                    $prev = $intdate - 1;
                    if (isset($categories_rooms_all[$category_id][$prev])) {
                        $free_1 = $categories_rooms_all[$category_id][$prev]["free"];
                        $free_2 = $categories_rooms_all[$category_id][$intdate]["free"];
                        
                        if ($free_1 == $free_2) {
                            $categories_rooms_all[$category_id][$intdate]["from"] = $categories_rooms_all[$category_id][$prev]["from"];
                            unset($categories_rooms_all[$category_id][$prev]);
                        }
                    }
                }
            }
            
            $freeRooms = $categories_rooms_all;
            // print_r ( $freeRooms );
            // die();
            $roomslist = array();
            $sql = "SELECT dc_bronevik_room_categories_link.*  FROM dc_bronevik_room_categories_link ";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                foreach ($query->result() as $row) {
                    if (isset($freeRooms[$row->hms_category_id])) {
                        array_push($roomslist, array(
                            'dc_room_id' => $row->dc_category_id,
                            'dates' => $freeRooms[$row->hms_category_id]
                        ));
                    }
                }
            }
            // echo "<pre>";
            // print_r ( $roomslist );
            // echo count ( $roomslist );
            // die ();
            
            if (count($roomslist) < 1) {
                $query = $this->db->query("DELETE FROM dc_log WHERE dc_id = 13");
                $data_return["response"] = 4;
                return $data_return;
            }
            $xml_data = array(
                'hotel_id' => $hotel_id,
                'api_key' => $api_key,
                'roomslist' => $roomslist
            );
            $xml = $this->parser->parse('templates/xml/dc_bronevik_xml_availability.html', $xml_data, true);
            // echo $xml;
            $url = "https://xml.bronevik.com/hotel/channel-manager/xml/";
            $data_result = $this->Curl_model->CurlPostBronevik($xml, $url, array(
                "returntype" => "array"
            ));
            // $data_return ["responsebody"] = $result;
            $result = $data_result["result"];
            $dc_log_id = $data_result["dc_log_id"];
            // print_r($data_result);
            echo $result;
            // die();
            // return $result;
        }
        // die();
        if ($general_update != 0)
            
            // $this->dc_model->Delete_dclog_last_data ( 1 );
            $data_return["dc_log_id"] = $dc_log_id;
        $data_return["datein"] = gmdate("Y-m-d", $min_date * 86400);
        $data_return["dateout"] = gmdate("Y-m-d", $max_date * 86400);
        if ($general_update == 0) {
            echo "Ban upload for booking service";
        } else {
            
            $xml = simplexml_load_string($result);
            if ($xml === false) {
                $data_return["response"] = 0;
                $data_return["errmsg"] = $result;
                $data_return["responsebody"] = $result;
            } else {
                print_r($xml);
                echo $xml["Status"];
                // die();
                if (isset($xml["Status"])) {
                    if ($xml["Status"] == "success") {
                        $data_return["response"] = 1;
                        $data_return["responsebody"] = "success";
                        $query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 13 AND time < " . $last_time);
                    } else {
                        $data_return["response"] = 0;
                        $data_return["errmsg"] = $result;
                        $data_return["responsebody"] = $result;
                    }
                } else {
                    $data_return["response"] = 0;
                    $data_return["errmsg"] = $result;
                    $data_return["responsebody"] = $result;
                }
            }
            
            return $data_return;
        }
    }

    function setavailability_lastchanged_14($hotel_id = 0)
    {
        $general_update = 0;
        $sql = "SELECT int_value FROM dc_hotels24_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $general_update = $row->int_value;
        }
        $data_return = array();
        if ($general_update == 1) {} else {
            $data_return["response"] = 2;
            return $data_return;
        }
        
        $min_date = 0;
        $max_date = 0;
        $categories_rooms_all = array();
        $data_return = array();
        $intdate_today = floor(time() / 86400);
        $last_id = 0;
        $last_time = time();
        
        $dc_rooms = array();
        $sql = "SELECT dc_hotels24_rooms_link.*  FROM dc_hotels24_rooms_link ";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $dc_rooms[$row->category_id] = $row->dc_room_id;
            }
        }
        $sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms  FROM categories
				INNER JOIN dc_log ON dc_log.categoryid = categories.id
				INNER JOIN rooms ON rooms.category_id = categories.id
				WHERE rooms.dc_active=1 AND dc_log.dc_id = 14 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.intdate >= " . $intdate_today . "
				GROUP BY dc_log.categoryid, dc_log.intdate";
        //echo $sql."<br>";
        $query = $this->db->query($sql);
        // echo $sql;
        // echo "start wait\n";
        // sleep(15);
        // echo "done wait\n";
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                if ($min_date == 0) {
                    $min_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate < $min_date) {
                        $min_date = $row->log_intdate;
                    }
                }
                
                if ($max_date == 0) {
                    $max_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate > $max_date) {
                        $max_date = $row->log_intdate;
                    }
                }
                
                $categories_rooms_all[$row->category_id][$row->log_intdate]["free"] = $row->count_rooms;
                $categories_rooms_all[$row->category_id][$row->log_intdate]["date"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                
                $categories_rooms_all[$row->category_id][$row->log_intdate]["from"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                $categories_rooms_all[$row->category_id][$row->log_intdate]["to"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                // $last_id = $row->dc_log_id;
                if ($row->dc_log_id > $last_id) {
                    $last_id = $row->dc_log_id;
                }
            }
        } else {
            $query = $this->db->query("DELETE FROM dc_log WHERE dc_id = 14 AND dc_log.dc_hotel_id = ".$hotel_id ." AND time < " . $last_time);
            echo "cleared";
            $data_return["response"] = 3;
            return $data_return;
        }
        
       // echo "<pre>";
       // print_r ( $categories_rooms_all );
        // die();
        $categories_rooms_intdate = array();
        
        $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
FROM  `rooms`
INNER JOIN categories ON categories.id = rooms.category_id
INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
dc_log.categoryid = rooms.category_id
WHERE dc_log.dc_id = 14 AND dc_log.dc_hotel_id = $hotel_id  
GROUP BY deskofdays.intdate, rooms.category_id";
       // echo $sql."<br>";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                $categories_rooms_intdate[$row->id][$row->intdate]["free"] = $row->count_rooms;
            }
        }
        
        // echo "<pre>";
        // print_r ( $categories_rooms_intdate );
        
       /* $query = $this->db->query("SELECT int_value FROM dc_hotels24_xml_cfg WHERE name LIKE 'hotel_id'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $hotel_id = $row->int_value;
        } else {
            $hotel_id = "none";
        }
        */
        /*
         * GET OVERBOOKING_RESERVATIONS_ARRAY
         */
        $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log(14);
        $overbooking_reservations_array = array();
        if (isset($datein_out_mass["intdatein"])) {
            $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat($datein_out_mass["intdatein"], $datein_out_mass["intdateout"]);
        }
        
        /*
         * Выгрузка загружености с booking
         */
        
        $setrestrict_result = "";
        $result = "";
        $sql = "SELECT int_value FROM dc_hotels24_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        
        if ($general_update == 1) {
            $category_keys = array_keys($categories_rooms_all);
            foreach ($category_keys as $category_id) {
                
                $sql = "select min, max from dc_hotels24_rooms_link where category_id =" . $category_id." AND dc_hotel_id = ".$hotel_id;
                $query = $this->db->query($sql);
                if ($query->num_rows() > 0) {
                    $row2 = $query->row();
                    $min = $row2->min;
                    $max = $row2->max;
                } else {
                    $min = 0;
                    $max = 999;
                }
                
                $arr_intdate_keys = array_keys($categories_rooms_all[$category_id]);
                foreach ($arr_intdate_keys as $intdate) {
                    if (isset($categories_rooms_intdate[$category_id][$intdate])) {
                        $count_overbook_rooms = 0;
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                        }
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
                    } else {
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                            $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $count_overbook_rooms;
                        }
                    }
                    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
                    } else {
                        $categories_rooms_all[$category_id][$intdate]["free"] = 0;
                    }
                    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $max;
                    }
                    
                    // коррекція к-сті відповідно умовам ф-ї availability_count_correction
                    $startdate = $enddate = date("Y-m-d", $intdate*86400);
                    $categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
                    
                    if (true) {
                        $prev = $intdate - 1;
                        if (isset($categories_rooms_all[$category_id][$prev])) {
                            $free_1 = $categories_rooms_all[$category_id][$prev]["free"];
                            $free_2 = $categories_rooms_all[$category_id][$intdate]["free"];
                            
                            if ($free_1 == $free_2) {
                                $categories_rooms_all[$category_id][$intdate]["from"] = $categories_rooms_all[$category_id][$prev]["from"];
                                unset($categories_rooms_all[$category_id][$prev]);
                            }
                        }
                    }
                }
            }
            if (! true) {
                foreach ($categories_rooms_all as $category_id => $intdates) {
                    foreach ($intdates as $intdate => $cell) {
                        $todate = $categories_rooms_all[$category_id][$intdate]["to"];
                        list ($year, $month, $day) = explode("-", $todate);
                        $intdate_to = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
                        
                        $intdate_to = $intdate_to - 1;
                        
                        $categories_rooms_all[$category_id][$intdate]["to"] = gmdate("Y-m-d", $intdate_to * 86400);
                    }
                }
            }
             echo "<pre>";
             print_r ( $categories_rooms_all );
            $roomslist = array();
            foreach ($categories_rooms_all as $category_id => $intdates) {
                // $roomslist = array();
                foreach ($intdates as $intdate => $cell) {
                    if (isset($dc_rooms[$category_id])) {
                        $params = array(
                            // "bookingTypeId" => 3,
                            // "discount" => 0,
                            // "places" => $cell["free"],
                            // "prepay" => 0,
                            "placesAvailable" => $cell["free"],
                            "dateStart" => $cell["from"],
                            "dateEnd" => $cell["to"],
                            "roomId" => (integer) $dc_rooms[$category_id]
                        );
                        // ,
                        // "unavailable" => false,
                        // "minNights" => 1,
                        // "penalty" => array(
                        // "days" => 10,
                        // "percent" => 50
                        // )
                        
                        array_push($roomslist, $params);
                    }
                }
            }
            
            echo "<pre>";
            print_r($roomslist);
            $authparam = $this->dcm_hotels24->getauthparam();
            //$hotel_id = $authparam['hotel_id'];
            // die();
            $url = $authparam["api_url"] . "/cm/hotel/" . $hotel_id . "/calendar/";
            //echo $url."<br>";
            $data_result = $this->Curl_model->CurlPlugRaw_hotels24((json_encode($roomslist)), $url, "", array(
                "returntype" => "array"
            ));
            // echo "<pre>";
            $result = $data_result["result"];
            $dc_log_id = $data_result["dc_log_id"];
            $data_return["dc_log_id"] = $dc_log_id;
            echo $result;
            print_r(json_decode($result, true));
            $respa = json_decode($result, true);
            if (isset($respa['code'])) {
                if ($respa['success'] == 1) {
                    $data_return["datein"] = gmdate("Y-m-d", $min_date * 86400);
                    $data_return["dateout"] = gmdate("Y-m-d", $max_date * 86400);
                    $query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 14 AND dc_log.dc_hotel_id = ".$hotel_id ." AND time < " . $last_time);
                    $data_return["response"] = 1;
                    $data_return["responsebody"] = "success";
                    return $data_return;
                } else {
                    $data_return["response"] = 0;
                    $data_return["errmsg"] = $resp;
                    $data_return["responsebody"] = "error 1";
                    $query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 14 AND dc_log.dc_hotel_id = ".$hotel_id ." AND time < " . $last_time);
                    return $data_return;
                }
            } else {
                $data_return["response"] = 0;
                $data_return["errmsg"] = $resp;
                $data_return["responsebody"] = "error 2";
                $query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 14 AND dc_log.dc_hotel_id = ".$hotel_id ." AND time < " . $last_time);
                return $data_return;
            }
        } else {
            $data_return["response"] = 3;
            $data_return["responsebody"] = "skip";
            return $data_return;
        }
    }

    function setavailability_lastchanged_15()
    {
        $general_update = 0;
        $sql = "SELECT int_value FROM dc_ozon_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $general_update = $row->int_value;
        }
        $data_return = array();
        if ($general_update == 1) {} else {
            $data_return["response"] = 2;
            return $data_return;
        }
        
        $min_date = 0;
        $max_date = 0;
        $categories_rooms_all = array();
        $data_return = array();
        $intdate_today = floor(time() / 86400);
        $last_id = 0;
        $last_time = time();
        
        $dc_rooms = array();
        $sql = "SELECT dc_ozon_rooms_link.*  FROM dc_ozon_rooms_link ";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $dc_rooms[$row->category_id] = $row->dc_room_id;
            }
        }
        $sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms  FROM categories
				INNER JOIN dc_log ON dc_log.categoryid = categories.id
				INNER JOIN rooms ON rooms.category_id = categories.id
				WHERE rooms.dc_active=1 AND dc_log.dc_id = 15 AND dc_log.intdate >= " . $intdate_today . "
				GROUP BY dc_log.categoryid, dc_log.intdate";
        $query = $this->db->query($sql);
        echo $sql;
        // echo "start wait\n";
        // sleep(15);
        // echo "done wait\n";
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                if ($min_date == 0) {
                    $min_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate < $min_date) {
                        $min_date = $row->log_intdate;
                    }
                }
                
                if ($max_date == 0) {
                    $max_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate > $max_date) {
                        $max_date = $row->log_intdate;
                    }
                }
                
                $categories_rooms_all[$row->category_id][$row->log_intdate]["free"] = $row->count_rooms;
                // $categories_rooms_all[$row->category_id][$row->log_intdate]["date"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                
                $categories_rooms_all[$row->category_id][$row->log_intdate]["from"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                $categories_rooms_all[$row->category_id][$row->log_intdate]["to"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                // $last_id = $row->dc_log_id;
                if ($row->dc_log_id > $last_id) {
                    $last_id = $row->dc_log_id;
                }
            }
        } else {
            $data_return["response"] = 3;
            // delete from log too
            return $data_return;
        }
        
        // echo "<pre>";
        // print_r ( $categories_rooms_all );
        // die();
        $categories_rooms_intdate = array();
        
        $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
FROM  `rooms`
INNER JOIN categories ON categories.id = rooms.category_id
INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
dc_log.categoryid = rooms.category_id
WHERE dc_log.dc_id = 15
GROUP BY deskofdays.intdate, rooms.category_id";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                $categories_rooms_intdate[$row->id][$row->intdate]["free"] = $row->count_rooms;
            }
        }
        
        // echo "<pre>";
        // print_r ( $categories_rooms_intdate );
        
        $query = $this->db->query("SELECT int_value FROM dc_ozon_xml_cfg WHERE name LIKE 'hotel_id'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $hotel_id = $row->int_value;
        } else {
            $hotel_id = "none";
        }
        
        /*
         * GET OVERBOOKING_RESERVATIONS_ARRAY
         */
        $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log(15);
        $overbooking_reservations_array = array();        
        if (isset($datein_out_mass["intdatein"])) {            
            $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat($datein_out_mass["intdatein"], $datein_out_mass["intdateout"]);
        }
        
        /*
         * Выгрузка загружености с booking
         */
        
        $result = "";
        
        if ($general_update == 1) {
            $category_keys = array_keys($categories_rooms_all);
            foreach ($category_keys as $category_id) {
                
                $sql = "select min, max from dc_ozon_rooms_link where category_id =" . $category_id;
                $query = $this->db->query($sql);
                if ($query->num_rows() > 0) {
                    $row2 = $query->row();
                    $min = $row2->min;
                    $max = $row2->max;
                } else {
                    $min = 0;
                    $max = 999;
                }
                
                $arr_intdate_keys = array_keys($categories_rooms_all[$category_id]);
                foreach ($arr_intdate_keys as $intdate) {                    
                    if (isset($categories_rooms_intdate[$category_id][$intdate])) {
                        $count_overbook_rooms = 0;
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                        }
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
                    } else {
                         if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                            $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $count_overbook_rooms;
                         }
                    }
                    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
                    } else {
                        $categories_rooms_all[$category_id][$intdate]["free"] = 0;
                    }
                    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $max;
                    }
                    
                    // коррекція к-сті відповідно умовам ф-ї availability_count_correction
                    $startdate = $enddate = date("Y-m-d", $intdate*86400);
                    $categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
                    
                    if (true) {
                        $prev = $intdate - 1;
                        if (isset($categories_rooms_all[$category_id][$prev])) {
                            $free_1 = $categories_rooms_all[$category_id][$prev]["free"];
                            $free_2 = $categories_rooms_all[$category_id][$intdate]["free"];
                            
                            if ($free_1 == $free_2) {
                                $categories_rooms_all[$category_id][$intdate]["from"] = $categories_rooms_all[$category_id][$prev]["from"];
                                unset($categories_rooms_all[$category_id][$prev]);
                            }
                        }
                    }
                }
            }
            if (! true) {
                foreach ($categories_rooms_all as $category_id => $intdates) {
                    foreach ($intdates as $intdate => $cell) {
                        $todate = $categories_rooms_all[$category_id][$intdate]["to"];
                        list ($year, $month, $day) = explode("-", $todate);
                        $intdate_to = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
                        
                        $intdate_to = $intdate_to - 1;
                        
                        $categories_rooms_all[$category_id][$intdate]["to"] = gmdate("Y-m-d", $intdate_to * 86400);
                    }
                }
            }
            // echo "<pre>";
            // print_r ( $dc_rooms );
            // print_r ( $categories_rooms_all );
            // die();
            $roomslist = array();
            foreach ($categories_rooms_all as $category_id => $intdates) {
            	// $roomslist = array();
            	foreach ($intdates as $intdate => $cell) {
            		if (isset($dc_rooms[$category_id])) {
            			$params = array(
            					"from" => $cell["from"],
            					"to" => $cell["to"],
            					"quota" => $cell["free"],
            					"room_id" => $dc_rooms[$category_id]
            			);
            
            			array_push($roomslist, $params);
            		}
            	}
            }
            
            if (count($roomslist) < 1) {
            	
            	$query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 15 AND time < " . $last_time); // delete last_id 
            	$data_return["response"] = 4;
            	return $data_return;
            }
            
            $authparam = $this->dcm_ozon->getauthparam();
            $json_array = array();
            $json_array["user"] = $authparam["user"];
            $json_array["pwd"] = $authparam["pwd"];
            $json_array = json_encode($json_array);
            $url = $authparam["api_url"] . "/auth/" . $authparam["hotel_str"];
            $resp = $this->Curl_model->CurlPlug_Ozon_authtoken($json_array, $url);
            
            $auth_param_token = json_decode($resp, true);
            $token = $auth_param_token["Response"]["token"];
            
            
            $json_data = array();
            $json_data["allotments"] = $roomslist;
            
            echo "<pre>";
            print_r($roomslist);
            // die();
            // $authparam = $this->dcm_ozon->getauthparam();
            // $hotel_id = $authparam['hotel_id'];
            // die();
            // echo json_encode ( $json_data )."<br><br><br><br>";
            // die();
            if (isset($auth_param_token["Response"]["token"])) {
                $token = $auth_param_token["Response"]["token"];
                // echo $token."<br>";
                $url = $authparam["api_url"] . "/hotel/" . $authparam["hotel_id"] . "?from=" . gmdate("Y-m-d", $min_date * 86400) . "&to=" . gmdate("Y-m-d", $max_date * 86400);
                // $url = urlencode($url);
                // echo $url."<br>";
                echo json_encode($json_data);
                $data_result = $this->Curl_model->CurlPlugRaw_ozon((json_encode($json_data)), $url, "", array(
                    "returntype" => "array"
                ), $token);
                // print_r($data_result);
                // die();
                // echo "<pre>";
                $result = $data_result["result"];
                $dc_log_id = $data_result["dc_log_id"];
                $data_return["dc_log_id"] = $dc_log_id;
                $data_return["datein"] = gmdate("Y-m-d", $min_date * 86400);
                $data_return["dateout"] = gmdate("Y-m-d", $max_date * 86400);
                if ($data_result['result'] == "{}") {
                    if ($data_result['responseint'] == 200) {
                        
                        $query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 15 AND time < " . $last_time);
                        $data_return["response"] = 1;
                        $data_return["responsebody"] = "success";
                        return $data_return;
                    } else {
                        $data_return["response"] = 0;
                        $data_return["errmsg"] = $data_result['result'];
                        $data_return["responsebody"] = "error";
                        return $data_return;
                    }
                } else {
                	
                    $data_return["response"] = 0;
                    $data_return["errmsg"] = $data_result['result'];
                    $data_return["responsebody"] = "error";
                    return $data_return;
                }
            } else {
                $query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 15 AND time < " . $last_time);
                $data_return["response"] = 3;
                $data_return["responsebody"] = "skip";
                $data_return["foo"] = "skip 1";
                return $data_return;
            }
        } else {
            $data_return["response"] = 3;
            $data_return["responsebody"] = "skip";
            $data_return["foo"] = "skip 2";
            return $data_return;
        }
    }

    function setavailability_lastchanged_16($db_name = "")
    {
    	$host = "";
    	$sql = "SELECT host FROM `visitka`.config WHERE db_name LIKE '".$db_name."'";
    	//echo $sql;
    	$query = $this->db->query($sql);
    	if ($query->num_rows() > 0) {
    		$row = $query->row();
    		$host = $row->host;
    	}
    	$data_return = array();
    	if (trim($host) == "") {
    		$data_return["response"] = 2;
    		return $data_return;
    	}
    	
    	$general_update = 0;
        $sql = "SELECT int_value FROM dc_tripadvisor_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $general_update = $row->int_value;
        }
        $data_return = array();
        if ($general_update == 1) {} else {
            $data_return["response"] = 2;
            return $data_return;
        }
        
        $min_date = 0;
        $max_date = 0;
        $categories_rooms_all = array();
        $data_return = array();
        $intdate_today = floor(time() / 86400);
        $last_id = 0;
        $last_time = time();
        
        $dc_rooms = array();
        $sql = "SELECT dc_tripadvisor_rooms_link.*  FROM dc_tripadvisor_rooms_link ";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $dc_rooms[$row->category_id] = $row->dc_room_id;
            }
        }
        $sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms FROM categories
				INNER JOIN dc_log ON dc_log.categoryid = categories.id
				INNER JOIN rooms ON rooms.category_id = categories.id
				WHERE rooms.dc_active=1 AND dc_log.dc_id = 16 AND dc_log.intdate >= " . $intdate_today . "
				GROUP BY dc_log.categoryid, dc_log.intdate";
        $query = $this->db->query($sql);
        // echo $sql;
        // echo "start wait\n";
        // sleep(15);
        // echo "done wait\n";
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                if ($min_date == 0) {
                    $min_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate < $min_date) {
                        $min_date = $row->log_intdate;
                    }
                }
                
                if ($max_date == 0) {
                    $max_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate > $max_date) {
                        $max_date = $row->log_intdate;
                    }
                }
                
                $categories_rooms_all[$row->category_id][$row->log_intdate]["free"] = $row->count_rooms;
                // $categories_rooms_all[$row->category_id][$row->log_intdate]["date"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                
                $categories_rooms_all[$row->category_id][$row->log_intdate]["from"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                $categories_rooms_all[$row->category_id][$row->log_intdate]["to"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                // $last_id = $row->dc_log_id;
                if ($row->dc_log_id > $last_id) {
                    $last_id = $row->dc_log_id;
                }
            }
        } else {
            $data_return["response"] = 3;
            return $data_return;
        }
        
        // echo "<pre>";
        // print_r ( $categories_rooms_all );
        // die();
        $categories_rooms_intdate = array();
        
        $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
FROM  `rooms`
INNER JOIN categories ON categories.id = rooms.category_id
INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
dc_log.categoryid = rooms.category_id
WHERE dc_log.dc_id = 16
GROUP BY deskofdays.intdate, rooms.category_id";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                $categories_rooms_intdate[$row->id][$row->intdate]["free"] = $row->count_rooms;
            }
        }
        
        // echo "<pre>";
        // print_r ( $categories_rooms_intdate );
        
        $query = $this->db->query("SELECT int_value FROM dc_tripadvisor_xml_cfg WHERE name LIKE 'hotel_id'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $hotel_id = $row->int_value;
        } else {
            $hotel_id = "none";
        }
        
        /*
         * GET OVERBOOKING_RESERVATIONS_ARRAY
         */
        $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log(14);
        $overbooking_reservations_array = array();
        if (isset($datein_out_mass["intdatein"])) {
            $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat($datein_out_mass["intdatein"], $datein_out_mass["intdateout"]);
        }
        
        /*
         * Выгрузка загружености с booking
         */
        
        $result = "";
        
        if ($general_update == 1) {
            $category_keys = array_keys($categories_rooms_all);
            foreach ($category_keys as $category_id) {
                
                $sql = "select min, max from dc_tripadvisor_rooms_link where category_id =" . $category_id;
                $query = $this->db->query($sql);
                if ($query->num_rows() > 0) {
                    $row2 = $query->row();
                    $min = $row2->min;
                    $max = $row2->max;
                } else {
                    $min = 0;
                    $max = 999;
                }
                
                $arr_intdate_keys = array_keys($categories_rooms_all[$category_id]);
                foreach ($arr_intdate_keys as $intdate) {
                    if (isset($categories_rooms_intdate[$category_id][$intdate])) {
                        $count_overbook_rooms = 0;
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                        }
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
                    } else {
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                            $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $count_overbook_rooms;
                        }
                    }
                    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
                    } else {
                        $categories_rooms_all[$category_id][$intdate]["free"] = 0;
                    }
                    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $max;
                    }
                    
                    // коррекція к-сті відповідно умовам ф-ї availability_count_correction
                    $startdate = $enddate = date("Y-m-d", $intdate*86400);
                    $categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
                    
                    if (true) {
                        $prev = $intdate - 1;
                        if (isset($categories_rooms_all[$category_id][$prev])) {
                            $free_1 = $categories_rooms_all[$category_id][$prev]["free"];
                            $free_2 = $categories_rooms_all[$category_id][$intdate]["free"];
                            
                            if ($free_1 == $free_2) {
                                $categories_rooms_all[$category_id][$intdate]["from"] = $categories_rooms_all[$category_id][$prev]["from"];
                                unset($categories_rooms_all[$category_id][$prev]);
                            }
                        }
                    }
                }
            }
            if (! true) {
                foreach ($categories_rooms_all as $category_id => $intdates) {
                    foreach ($intdates as $intdate => $cell) {
                        $todate = $categories_rooms_all[$category_id][$intdate]["to"];
                        list ($year, $month, $day) = explode("-", $todate);
                        $intdate_to = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
                        
                        $intdate_to = $intdate_to - 1;
                        
                        $categories_rooms_all[$category_id][$intdate]["to"] = gmdate("Y-m-d", $intdate_to * 86400);
                    }
                }
            }
            echo "<pre>";
            // print_r ( $dc_rooms );
            print_r($categories_rooms_all);
            // die ();
            $arr = array();
            $arr['token'] = "112";
            $arr['sign'] = "";
            $arr['type'] = 1;
            //$arr['hotel_id'] = $this->config->item('hotel_id');
            $dc_param = $this->dcm_tripadvisor->getparam($db_name);
            $arr ['hotel_id'] = $dc_param['hotel_id'];
            $host = $dc_param['host'];
            // ====================URL=======================
            $url = "https://". $host . "/echannel/rna";
            //echo $url;
            // ====================/URL======================
            $data_log = array(
                'param' => $arr['token'] . " " . $arr['sign'],
                'url' => $url,
                'time' => date("Y-m-d H:i:s"),
                'request' => print_r(json_encode($categories_rooms_all), true)
            );
            $this->db->insert('dc_tripadvisor_log', $data_log);
            
            // $url.="?token=".$token."&sign=".$sign;
            $dc_log_id = $this->db->insert_id();
            
            $result = $this->Curl_model->CurlPlugPOST($arr, json_encode($categories_rooms_all), $url, "POST", "array");
            echo $result;
            echo "<pre>";
            print_r($result);
            
            /*
             * INSERT UPDATE LOG
             *
             */
            $data_log = array(
                'response' => $result['result'],
                'responseint' => $result['http_code'],
                'time' => date("Y-m-d H:i:s")
            );
            $this->db->update('dc_tripadvisor_log', $data_log, array(
                'id' => $dc_log_id
            ));
            
            $hotel_id = 1;
            
            // global_hotelix log save
            
            $sql = "INSERT INTO global_hotelix.dc_xml_log (hotel_id, db_name, log_id, dc_id, responsetext, responseint, time)
				VALUES('" . $hotel_id . "', DATABASE(), '" . $dc_log_id . "','16','" . addslashes($result['result']) . "','',
						'" . date("Y-m-d H:i:s") . "')";
            $query = $this->db->query($sql);
            
            // local_log save
            
            $sql = "INSERT INTO dc_xml_log (log_id, dc_id, responsetext, responseint, time)
				VALUES('" . $dc_log_id . "','16','" . addslashes($result['result']) . "','',
						'" . date("Y-m-d H:i:s") . "')";
            $query = $this->db->query($sql);
            /*
             * DELETE DC LOG DATA
             */
            $data_return = array();
            $data_return["dc_log_id"] = $dc_log_id;
            $data_return["datein"] = gmdate("Y-m-d", $min_date * 86400);
            $data_return["dateout"] = gmdate("Y-m-d", $max_date * 86400);
            
            if ($result['result'] == "success") {
                $data_return["response"] = 1;
                $data_return["responsebody"] = "success";
                $query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 16 AND time < " . $last_time);
            } else {
                $data_return["response"] = 0;
                $data_return["responsebody"] = $result['result'];
                // $query = $this->db->query ( "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 2 AND time < " . $last_time );
            }
            
            if ($general_update != 0)
                if ($general_update == 0) {
                    echo "Ban upload for booking service";
                } else {
                    return $data_return;
                }
        }
    }
    
    function setavailability_lastchanged_echannel($db_name = "")
    {
        $echannel_id = ($this->config->item('echannel_id') > 0) ? $this->config->item('echannel_id') : 16;
        $host = "";
        $sql = "SELECT host FROM `visitka`.config WHERE db_name LIKE '".$db_name."'";
        //echo $sql;
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $host = $row->host;
        }
        $data_return = array();
        if (trim($host) == "") {
            $data_return["response"] = 2;
            return $data_return;
        }
         
//         $general_update = 0;
//         $sql = "SELECT value FROM hotelix_config WHERE name LIKE 'echannel'";
//         $query = $this->db->query($sql);
//         if ($query->num_rows() > 0) {
//             $row = $query->row();
//             $general_update = $row->value;
//         }
        
        $general_update = $this->releases->get_echannel_state();
        
        $data_return = array();
        if ($general_update == 1) {} else {
            $data_return["response"] = 2;
            return $data_return;
        }
    
        $min_date = 0;
        $max_date = 0;
        $categories_rooms_all = array();
        $data_return = array();
        $intdate_today = floor(time() / 86400);
        $last_id = 0;
        $last_time = time();
    
        $dc_rooms = array();
        $sql = "SELECT dc_tripadvisor_rooms_link.*  FROM dc_tripadvisor_rooms_link ";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $dc_rooms[$row->category_id] = $row->dc_room_id;
            }
        }
        $sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms FROM categories
				INNER JOIN dc_log ON dc_log.categoryid = categories.id
				INNER JOIN rooms ON rooms.category_id = categories.id
				WHERE rooms.is_active = 1 AND rooms.dc_active = 1 AND dc_log.dc_id = $echannel_id AND dc_log.intdate >= " . $intdate_today . "
				GROUP BY dc_log.categoryid, dc_log.intdate";
        $query = $this->db->query($sql);
        // echo $sql;
        // echo "start wait\n";
        // sleep(15);
        // echo "done wait\n";
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                if ($min_date == 0) {
                    $min_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate < $min_date) {
                        $min_date = $row->log_intdate;
                    }
                }
    
                if ($max_date == 0) {
                    $max_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate > $max_date) {
                        $max_date = $row->log_intdate;
                    }
                }
    
                $categories_rooms_all[$row->category_id][$row->log_intdate]["free"] = $row->count_rooms;
                // $categories_rooms_all[$row->category_id][$row->log_intdate]["date"] = gmdate("Y-m-d", $row->log_intdate * 86400);
    
                $categories_rooms_all[$row->category_id][$row->log_intdate]["from"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                $categories_rooms_all[$row->category_id][$row->log_intdate]["to"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                // $last_id = $row->dc_log_id;
                if ($row->dc_log_id > $last_id) {
                    $last_id = $row->dc_log_id;
                }
            }
        } else {
            $data_return["response"] = 3;
            return $data_return;
        }
    
//         echo "<pre>";
//         print_r ( $categories_rooms_all );
//         die();
        $categories_rooms_intdate = array();
    
        $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
FROM  `rooms`
INNER JOIN categories ON categories.id = rooms.category_id
INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
dc_log.categoryid = rooms.category_id
WHERE dc_log.dc_id = $echannel_id
GROUP BY deskofdays.intdate, rooms.category_id";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                $categories_rooms_intdate[$row->id][$row->intdate]["free"] = $row->count_rooms;
            }
        }
    
        // echo "<pre>";
        // print_r ( $categories_rooms_intdate );
    
        $query = $this->db->query("SELECT int_value FROM dc_tripadvisor_xml_cfg WHERE name LIKE 'hotel_id'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $hotel_id = $row->int_value;
        } else {
            $hotel_id = "none";
        }
    
        /*
         * GET OVERBOOKING_RESERVATIONS_ARRAY
         */
        $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log($echannel_id);
        $overbooking_reservations_array = array();
        if (isset($datein_out_mass["intdatein"])) {
            $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat($datein_out_mass["intdatein"], $datein_out_mass["intdateout"]);
        }
    
        /*
         * Выгрузка загружености с booking
         */
    
        $result = "";
    
        if ($general_update == 1) {
            $category_keys = array_keys($categories_rooms_all);
            foreach ($category_keys as $category_id) {
    
                $min = 0;
                $max = 999;
    
                $arr_intdate_keys = array_keys($categories_rooms_all[$category_id]);
                foreach ($arr_intdate_keys as $intdate) {
                    if (isset($categories_rooms_intdate[$category_id][$intdate])) {
                        $count_overbook_rooms = 0;
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                        }
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
                    } else {
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                            $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $count_overbook_rooms;
                        }
                    }
    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
                    } else {
                        $categories_rooms_all[$category_id][$intdate]["free"] = 0;
                    }
    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $max;
                    }
    
                    // коррекція к-сті відповідно умовам ф-ї availability_count_correction
                    $startdate = $enddate = date("Y-m-d", $intdate*86400);
                    $categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
    
                    if (true) {
                        $prev = $intdate - 1;
                        if (isset($categories_rooms_all[$category_id][$prev])) {
                            $free_1 = $categories_rooms_all[$category_id][$prev]["free"];
                            $free_2 = $categories_rooms_all[$category_id][$intdate]["free"];
    
                            if ($free_1 == $free_2) {
                                $categories_rooms_all[$category_id][$intdate]["from"] = $categories_rooms_all[$category_id][$prev]["from"];
                                unset($categories_rooms_all[$category_id][$prev]);
                            }
                        }
                    }
                }
            }
            if (! true) {
                foreach ($categories_rooms_all as $category_id => $intdates) {
                    foreach ($intdates as $intdate => $cell) {
                        $todate = $categories_rooms_all[$category_id][$intdate]["to"];
                        list ($year, $month, $day) = explode("-", $todate);
                        $intdate_to = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
    
                        $intdate_to = $intdate_to - 1;
    
                        $categories_rooms_all[$category_id][$intdate]["to"] = gmdate("Y-m-d", $intdate_to * 86400);
                    }
                }
            }
            echo "<pre>";
            // print_r ( $dc_rooms );
            print_r($categories_rooms_all);
            // die ();
            
            $dc_id = 501; // echannel dc_id
            $arr = array();
            $arr['token'] = "112";
            $arr['sign'] = "";
            $arr['type'] = 1;
            //$arr['hotel_id'] = $this->config->item('hotel_id');
            $dc_param = $this->dcm_tripadvisor->getparam($db_name);
            $arr ['hotel_id'] = $dc_param['hotel_id'];
            $arr ['dc_id'] = $dc_id;
            $host = $dc_param['host'];
            // ====================URL=======================
            $url = "https://". $host . "/echannel/rna";
            echo $url;
            // ====================/URL======================
            $data_log = array(
                'param' => $arr['token'] . " " . $arr['sign'],
                'url' => $url,
                'time' => date("Y-m-d H:i:s"),
                'request' => print_r(json_encode($categories_rooms_all), true)
            );
            $this->db->insert('dc_tripadvisor_log', $data_log);
    
            // $url.="?token=".$token."&sign=".$sign;
            $dc_log_id = $this->db->insert_id();
    
            $result = $this->Curl_model->CurlPlugPOST($arr, json_encode($categories_rooms_all), $url, "POST", "array");
            //echo $result;
             echo "<pre>";
             print_r($result);
    
            /*
             * INSERT UPDATE LOG
             *
             */
            $data_log = array(
                'response' => $result['result'],
                'responseint' => $result['http_code'],
                'time' => date("Y-m-d H:i:s")
            );
            $this->db->update('dc_tripadvisor_log', $data_log, array(
                'id' => $dc_log_id
            ));
    
            $hotel_id = 1;
    
            // global_hotelix log save
    
            $sql = "INSERT INTO global_hotelix.dc_xml_log (hotel_id, db_name, log_id, dc_id, responsetext, responseint, time)
				VALUES('" . $hotel_id . "', DATABASE(), '" . $dc_log_id . "','$echannel_id','" . addslashes($result['result']) . "','',
						'" . date("Y-m-d H:i:s") . "')";
            $query = $this->db->query($sql);
    
            // local_log save
    
            $sql = "INSERT INTO dc_xml_log (log_id, dc_id, responsetext, responseint, time)
				VALUES('" . $dc_log_id . "','16','" . addslashes($result['result']) . "','',
						'" . date("Y-m-d H:i:s") . "')";
            $query = $this->db->query($sql);
            /*
             * DELETE DC LOG DATA
             */
            $data_return = array();
            $data_return["dc_log_id"] = $dc_log_id;
            $data_return["datein"] = gmdate("Y-m-d", $min_date * 86400);
            $data_return["dateout"] = gmdate("Y-m-d", $max_date * 86400);
    
            if ($result['result'] == "success") {
                $data_return["response"] = 1;
                $data_return["responsebody"] = "success";
                $query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = $echannel_id AND time < " . $last_time);
            } else {
                $data_return["response"] = 0;
                $data_return["responsebody"] = $result['result'];
                // $query = $this->db->query ( "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 2 AND time < " . $last_time );
            }
    
            if ($general_update != 0)
                if ($general_update == 0) {
                    echo "Ban upload for booking service";
                } else {
                    return $data_return;
                }
        }
    }
    
    function setavailability_lastchanged_clearnet($db_name = "")
    {
        $clearnet_id = ($this->config->item('clearnet_id') > 0) ? $this->config->item('clearnet_id') : 16;
        $host = "";
        $sql = "SELECT host FROM `visitka`.config WHERE db_name LIKE '".$db_name."'";
        //echo $sql;
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $host = $row->host;
        }
        $data_return = array();
        if (trim($host) == "") {
            $data_return["response"] = 2;
            return $data_return;
        }

        $general_update = $this->releases->get_clearnet_state();
    
        $data_return = array();
        if ($general_update == 1) {} else {
            $data_return["response"] = 2;
            return $data_return;
        }
    
        $min_date = 0;
        $max_date = 0;
        $categories_rooms_all = array();
        $data_return = array();
        $intdate_today = floor(time() / 86400);
        $last_id = 0;
        $last_time = time();

        $sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms FROM categories
        INNER JOIN dc_log ON dc_log.categoryid = categories.id
        INNER JOIN rooms ON rooms.category_id = categories.id
        WHERE rooms.is_active = 1 AND rooms.dc_active = 1 AND dc_log.dc_id = $clearnet_id AND dc_log.intdate >= " . $intdate_today . "
				GROUP BY dc_log.categoryid, dc_log.intdate";
        $query = $this->db->query($sql);
        // echo $sql;
        // echo "start wait\n";
        // sleep(15);
        // echo "done wait\n";
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                if ($min_date == 0) {
                    $min_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate < $min_date) {
                        $min_date = $row->log_intdate;
                    }
                }
    
                if ($max_date == 0) {
                    $max_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate > $max_date) {
                        $max_date = $row->log_intdate;
                    }
                }
    
                $categories_rooms_all[$row->category_id][$row->log_intdate]["free"] = $row->count_rooms;
                // $categories_rooms_all[$row->category_id][$row->log_intdate]["date"] = gmdate("Y-m-d", $row->log_intdate * 86400);
    
                $categories_rooms_all[$row->category_id][$row->log_intdate]["from"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                $categories_rooms_all[$row->category_id][$row->log_intdate]["to"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                // $last_id = $row->dc_log_id;
                if ($row->dc_log_id > $last_id) {
                    $last_id = $row->dc_log_id;
                }
            }
        } else {
            $data_return["response"] = 3;
            return $data_return;
        }
    
        //         echo "<pre>";
        //         print_r ( $categories_rooms_all );
        //         die();
        $categories_rooms_intdate = array();
    
        $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
        FROM  `rooms`
        INNER JOIN categories ON categories.id = rooms.category_id
        INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
        INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
        dc_log.categoryid = rooms.category_id
        WHERE dc_log.dc_id = $clearnet_id
        GROUP BY deskofdays.intdate, rooms.category_id";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                $categories_rooms_intdate[$row->id][$row->intdate]["free"] = $row->count_rooms;
            }
        }

        /*
         * GET OVERBOOKING_RESERVATIONS_ARRAY
         */
        $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log($clearnet_id);
        $overbooking_reservations_array = array();
        if (isset($datein_out_mass["intdatein"])) {
            $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat($datein_out_mass["intdatein"], $datein_out_mass["intdateout"]);
        }
    
        /*
         * Выгрузка загружености с booking
         */
    
        $result = "";
    
        if ($general_update == 1) {
            $category_keys = array_keys($categories_rooms_all);
            foreach ($category_keys as $category_id) {
    
                $min = 0;
                $max = 999;
    
                $arr_intdate_keys = array_keys($categories_rooms_all[$category_id]);
                foreach ($arr_intdate_keys as $intdate) {
                    if (isset($categories_rooms_intdate[$category_id][$intdate])) {
                        $count_overbook_rooms = 0;
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                        }
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
                    } else {
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                            $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $count_overbook_rooms;
                        }
                    }
    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
                    } else {
                        $categories_rooms_all[$category_id][$intdate]["free"] = 0;
                    }
    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $max;
                    }
    
                    // коррекція к-сті відповідно умовам ф-ї availability_count_correction
                    $startdate = $enddate = date("Y-m-d", $intdate*86400);
                    $categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
    
                    if (true) {
                        $prev = $intdate - 1;
                        if (isset($categories_rooms_all[$category_id][$prev])) {
                            $free_1 = $categories_rooms_all[$category_id][$prev]["free"];
                            $free_2 = $categories_rooms_all[$category_id][$intdate]["free"];
    
                            if ($free_1 == $free_2) {
                                $categories_rooms_all[$category_id][$intdate]["from"] = $categories_rooms_all[$category_id][$prev]["from"];
                                unset($categories_rooms_all[$category_id][$prev]);
                            }
                        }
                    }
                }
            }
            if (! true) {
                foreach ($categories_rooms_all as $category_id => $intdates) {
                    foreach ($intdates as $intdate => $cell) {
                        $todate = $categories_rooms_all[$category_id][$intdate]["to"];
                        list ($year, $month, $day) = explode("-", $todate);
                        $intdate_to = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
    
                        $intdate_to = $intdate_to - 1;
    
                        $categories_rooms_all[$category_id][$intdate]["to"] = gmdate("Y-m-d", $intdate_to * 86400);
                    }
                }
            }
            echo "<pre>";
            // print_r ( $dc_rooms );
            print_r($categories_rooms_all);
            // die ();
    
            $dc_id = 501; // echannel dc_id
            $arr = array();
            $arr['token'] = "112";
            $arr['sign'] = "";
            $arr['type'] = 1;
            //$arr['hotel_id'] = $this->config->item('hotel_id');
            $dc_param = $this->dcm_tripadvisor->getparam($db_name);
            $arr ['hotel_id'] = $dc_param['hotel_id'];
            $arr ['dc_id'] = $dc_id;
            $host = $dc_param['host'];
            // ====================URL=======================
            $url = "https://". $host . "/echannel/rna";
            echo $url;
            // ====================/URL======================
            $data_log = array(
                'param' => $arr['token'] . " " . $arr['sign'],
                'url' => $url,
                'time' => date("Y-m-d H:i:s"),
                'request' => print_r(json_encode($categories_rooms_all), true)
            );
            $this->db->insert('dc_clearnet_log', $data_log);
    
            // $url.="?token=".$token."&sign=".$sign;
            $dc_log_id = $this->db->insert_id();
    
            $result = $this->Curl_model->CurlPlugPOST($arr, json_encode($categories_rooms_all), $url, "POST", "array");
            //echo $result;
            echo "<pre>";
            print_r($result);
    
            /*
             * INSERT UPDATE LOG
             *
             */
            $data_log = array(
                'response' => $result['result'],
                'responseint' => $result['http_code'],
                'time' => date("Y-m-d H:i:s")
            );
            $this->db->update('dc_clearnet_log', $data_log, array(
                'id' => $dc_log_id
            ));
    
            $hotel_id = 1;
    
            // global_hotelix log save
    
            $sql = "INSERT INTO global_hotelix.dc_xml_log (hotel_id, db_name, log_id, dc_id, responsetext, responseint, time)
				VALUES('" . $hotel_id . "', DATABASE(), '" . $dc_log_id . "','$clearnet_id','" . addslashes($result['result']) . "','',
						'" . date("Y-m-d H:i:s") . "')";
            $query = $this->db->query($sql);
    
            // local_log save
    
            $sql = "INSERT INTO dc_xml_log (log_id, dc_id, responsetext, responseint, time)
				VALUES('" . $dc_log_id . "','16','" . addslashes($result['result']) . "','',
						'" . date("Y-m-d H:i:s") . "')";
            $query = $this->db->query($sql);
            /*
             * DELETE DC LOG DATA
             */
            $data_return = array();
            $data_return["dc_log_id"] = $dc_log_id;
            $data_return["datein"] = gmdate("Y-m-d", $min_date * 86400);
            $data_return["dateout"] = gmdate("Y-m-d", $max_date * 86400);
    
            if ($result['result'] == "success") {
                $data_return["response"] = 1;
                $data_return["responsebody"] = "success";
                $query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = $clearnet_id AND time < " . $last_time);
            } else {
                $data_return["response"] = 0;
                $data_return["responsebody"] = $result['result'];
                // $query = $this->db->query ( "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 2 AND time < " . $last_time );
            }
    
            if ($general_update != 0)
                if ($general_update == 0) {
                    echo "Ban upload for booking service";
                } else {
                    return $data_return;
                }
        }
    }
    
    function setavailability_lastchanged_17($dc_hotel_id = 0)
    {
    	$general_update = 0;
    	$sql = "SELECT int_value FROM dc_hotelbook_xml_cfg WHERE name LIKE 'general_update'";
    	$query = $this->db->query($sql);
    	if ($query->num_rows() > 0) {
    		$row = $query->row();
    		$general_update = $row->int_value;
    	}
    	$data_return = array();
    	if ($general_update == 1) {} else {
    		$data_return["response"] = 2;
    		return $data_return;
    	}
    	
    	$dc_account_id = 0;
    	$sql = "SELECT dc_account_id FROM dc_hotelbook_xml_cfg WHERE int_value = ".$dc_hotel_id;
    	$query = $this->db->query($sql);
    	if ($query->num_rows() > 0) {
    		$row = $query->row();
    		$dc_account_id = $row->dc_account_id;
    	}
    	
    	$restrict_rate_id = 0;
    	$sql = "SELECT int_value FROM dc_hotelbook_xml_cfg WHERE name LIKE 'restrict_rate_id'";
    	$query = $this->db->query($sql);
    	if ($query->num_rows() > 0) {
    		$row = $query->row();
    		$restrict_rate_id = $row->int_value;
    	}
    	
    	$debug_mode = 0;
    	$sql = "SELECT int_value FROM dc_hotelbook_xml_cfg WHERE dc_account_id = ".$dc_account_id." AND name LIKE 'debug_mode'";
    	$query = $this->db->query($sql);
    	if ($query->num_rows() > 0) {
    		$row = $query->row();
    		$debug_mode = $row->int_value;
    	}
    	
    	//$dc_hotel_id = $this->dcm_hotelbook->gethotelid ();
    
    	$min_date = 0;
    	$max_date = 0;
    	$categories_rooms_all = array();
    	$data_return = array();
    	$intdate_today = floor(time() / 86400);
    	$last_id = 0;
    	$last_time = time();
    
    	$dc_rooms = array();
    	$sql = "SELECT dc_hotelbook_room_categories_link.*  FROM dc_hotelbook_room_categories_link ";
    	$query = $this->db->query($sql);
    	if ($query->num_rows() > 0) {
    		foreach ($query->result() as $row) {
    			$dc_rooms[$row->hms_category_id] = $row->dc_category_id;
    		}
    	}
    	$sql = "SELECT deskofrate.closed, dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms FROM categories
				INNER JOIN dc_log ON dc_log.categoryid = categories.id
				INNER JOIN rooms ON rooms.category_id = categories.id
				LEFT JOIN deskofrate ON deskofrate.category_id = categories.id AND dc_log.intdate = deskofrate.intdate AND deskofrate.rate_id = ".$restrict_rate_id."
				WHERE rooms.dc_active=1 AND dc_log.dc_id = 17 AND dc_log.dc_hotel_id = $dc_hotel_id AND dc_log.intdate >= " . $intdate_today . "
				GROUP BY dc_log.categoryid, dc_log.intdate";
    	$query = $this->db->query($sql);
    	// echo $sql;
    	// echo "start wait\n";
    	// sleep(15);
    	// echo "done wait\n";
    	if ($query->num_rows() > 0) {
    		foreach ($query->result() as $row) {
    			// count_rooms_booking
    			if ($min_date == 0) {
    				$min_date = $row->log_intdate;
    			} else {
    				if ($row->log_intdate < $min_date) {
    					$min_date = $row->log_intdate;
    				}
    			}
    
    			if ($max_date == 0) {
    				$max_date = $row->log_intdate;
    			} else {
    				if ($row->log_intdate > $max_date) {
    					$max_date = $row->log_intdate;
    				}
    			}
    			$categories_rooms_all[$row->category_id][$row->log_intdate]["closed"] = $row->closed;
    			$categories_rooms_all[$row->category_id][$row->log_intdate]["free"] = $row->count_rooms;
    			// $categories_rooms_all[$row->category_id][$row->log_intdate]["date"] = gmdate("Y-m-d", $row->log_intdate * 86400);
    
    			$categories_rooms_all[$row->category_id][$row->log_intdate]["from"] = gmdate("Y-m-d", $row->log_intdate * 86400);
    			$categories_rooms_all[$row->category_id][$row->log_intdate]["to"] = gmdate("Y-m-d", $row->log_intdate * 86400);
    			// $last_id = $row->dc_log_id;
    			if ($row->dc_log_id > $last_id) {
    				$last_id = $row->dc_log_id;
    			}
    		}
    	} else {
    		$data_return["response"] = 3;
    		return $data_return;
    	}
    
    	 //echo "<pre>";
    	// print_r ( $categories_rooms_all );
    	// die();
    	$categories_rooms_intdate = array();
    
    	$sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
FROM  `rooms`
INNER JOIN categories ON categories.id = rooms.category_id
INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
dc_log.categoryid = rooms.category_id
WHERE dc_log.dc_id = 17 AND dc_log.dc_hotel_id = $dc_hotel_id
GROUP BY deskofdays.intdate, rooms.category_id";
    	$query = $this->db->query($sql);
    	if ($query->num_rows() > 0) {
    		foreach ($query->result() as $row) {
    			// count_rooms_booking
    			$categories_rooms_intdate[$row->id][$row->intdate]["free"] = $row->count_rooms;
    		}
    	}
    
    	// echo "<pre>";
    	// print_r ( $categories_rooms_intdate );
    
    	/*$query = $this->db->query("SELECT int_value FROM dc_hotelbook_xml_cfg WHERE name LIKE 'hotel_id'");
    	if ($query->num_rows() > 0) {
    		$row = $query->row();
    		$hotel_id = $row->int_value;
    	} else {
    		$hotel_id = "none";
    	}
    */
    	/*
    	 * GET OVERBOOKING_RESERVATIONS_ARRAY
    	*/
    	$datein_out_mass = $this->dc_model->get_datein_dateout_dc_log(14);
    	$overbooking_reservations_array = array();
    	if (isset($datein_out_mass["intdatein"])) {
    		$overbooking_reservations_array = $this->dc_model->get_overbooking_origincat($datein_out_mass["intdatein"], $datein_out_mass["intdateout"]);
    	}
    
    	/*
    	 * Выгрузка загружености с booking
    	*/
    
    	$result = "";
    
    	if ($general_update == 1) {
    		$category_keys = array_keys($categories_rooms_all);
    		foreach ($category_keys as $category_id) {
    
    			$sql = "select min, max from dc_hotelbook_room_categories_link where hms_category_id =" . $category_id;
    			$query = $this->db->query($sql);
    			if ($query->num_rows() > 0) {
    				$row2 = $query->row();
    				$min = $row2->min;
    				$max = $row2->max;
    			} else {
    				$min = 0;
    				$max = 999;
    			}
    
    			$arr_intdate_keys = array_keys($categories_rooms_all[$category_id]);
    			foreach ($arr_intdate_keys as $intdate) {
    				if ($categories_rooms_all [$category_id] [$intdate] ["closed"] == 1) {
						$categories_rooms_all [$category_id] [$intdate] ["free"] = 0;
					} else {
						if (isset ( $categories_rooms_intdate [$category_id] [$intdate] )) {
							$count_overbook_rooms = 0;
							if (isset ( $overbooking_reservations_array [$category_id] [$intdate] )) {
								$count_overbook_rooms = $overbooking_reservations_array [$category_id] [$intdate];
							}
							$categories_rooms_all [$category_id] [$intdate] ["free"] = $categories_rooms_all [$category_id] [$intdate] ["free"] - ($categories_rooms_intdate [$category_id] [$intdate] ["free"] + $count_overbook_rooms);
						} else {
							if (isset ( $overbooking_reservations_array [$category_id] [$intdate] )) {
								$count_overbook_rooms = $overbooking_reservations_array [$category_id] [$intdate];
								$categories_rooms_all [$category_id] [$intdate] ["free"] = $categories_rooms_all [$category_id] [$intdate] ["free"] - $count_overbook_rooms;
							}
						}
						
						if ($categories_rooms_all [$category_id] [$intdate] ["free"] > $min) {
							$categories_rooms_all [$category_id] [$intdate] ["free"] = $categories_rooms_all [$category_id] [$intdate] ["free"] - $min;
						} else {
							$categories_rooms_all [$category_id] [$intdate] ["free"] = 0;
						}
						
						if ($categories_rooms_all [$category_id] [$intdate] ["free"] > $max) {
							$categories_rooms_all [$category_id] [$intdate] ["free"] = $max;
						}
						
						// коррекція к-сті відповідно умовам ф-ї availability_count_correction
						$startdate = $enddate = date("Y-m-d", $intdate*86400);
						$categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
						
					}
    
    				if (true) {
    					$prev = $intdate - 1;
    					if (isset($categories_rooms_all[$category_id][$prev])) {
    						$free_1 = $categories_rooms_all[$category_id][$prev]["free"];
    						$free_2 = $categories_rooms_all[$category_id][$intdate]["free"];
    
    						if ($free_1 == $free_2) {
    							$categories_rooms_all[$category_id][$intdate]["from"] = $categories_rooms_all[$category_id][$prev]["from"];
    							unset($categories_rooms_all[$category_id][$prev]);
    						}
    					}
    				}
    			}
    		}
    		echo "<pre>";
    		// print_r ( $dc_rooms );
    		print_r ( $categories_rooms_all );
    		$data = array();
    		if ( true) {
    			foreach ($categories_rooms_all as $category_id => $intdates) {
    				foreach ($intdates as $intdate => $cell) {
    					/*$todate = $categories_rooms_all[$category_id][$intdate]["to"];
    					list ($year, $month, $day) = explode("-", $todate);
    					$intdate_to = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
    
    					$intdate_to = $intdate_to - 1;
    
    					$categories_rooms_all[$category_id][$intdate]["to"] = gmdate("Y-m-d", $intdate_to * 86400);
    					*/
    					if (isset ( $dc_rooms [$category_id] )) {
							array_push ( $data, array (
									"hotelId" => $dc_hotel_id,
									"startDateYmd" => $categories_rooms_all [$category_id] [$intdate] ["from"],
									"endDateYmd" => $categories_rooms_all [$category_id] [$intdate] ["to"],
									"roomId" => $dc_rooms [$category_id],
									"avail" => $categories_rooms_all [$category_id] [$intdate] ["free"] 
							));
						}
    				}
				}
			}
			echo "==============================================";
			// print_r ( $dc_rooms );
			print_r ( $categories_rooms_all );
			// die ();
			if (count($data) < 1) {
				$query = $this->db->query("DELETE FROM dc_log WHERE dc_id = 17 AND dc_hotel_id = ".$dc_hotel_id);
				$data_return["response"] = 4;
				return $data_return;
			}
			$curl_data = array ();
			$curl_data ["hotelId"] = $dc_hotel_id;			
			$curl_data ["updates"] = $data;
			 print_r ( $curl_data );
			$post = json_encode ( array (
					"data" => $curl_data 
			) );
			$auth_data = $this->dcm_hotelbook->get_api_url();
			
			//$url = $auth_data["api_url"].'/gate/v1/availability?apiKey='.$dc_hotel_id;
			if($debug_mode == 0){
				$url = $auth_data["api_url"].'/gate/v1/availability/update?apiKey='.$dc_hotel_id;
				$data_result = $this->Curl_model->curl_hotelbook ( $post, $url, array (
						"returntype" => "array" 
				) );
				$result = $data_result ["result"];
				$dc_log_id = $data_result ["dc_log_id"];
			}else{
			    
			    $url = $auth_data["api_url"].'/gate/v1/availability/update?apiKey='.$dc_hotel_id;
			    $data_result = $this->Curl_model->curl_hotelbook ( $post, $url, array (
			        "returntype" => "array", "debug_mode" =>true
			    ) );
			    $result = $data_result ["result"];
			    $dc_log_id = $data_result ["dc_log_id"];
			    
				//$result = "DEBUG MODE";
				//$dc_log_id = 0;
			}
			
			echo $result;
			
			$result_array = (json_decode ( $result, true ));
			//die ();
			
			$hotel_id = 1;
			
			$data_return = array ();
			$data_return ["dc_log_id"] = $dc_log_id;
			$data_return ["datein"] = gmdate ( "Y-m-d", $min_date * 86400 );
			$data_return ["dateout"] = gmdate ( "Y-m-d", $max_date * 86400 );
			
			if ($result_array ['status'] == 200) {
				$data_return ["response"] = 1;
				$data_return ["responsebody"] = "success";
				$query = $this->db->query ( "DELETE FROM dc_log WHERE dc_hotel_id = " . $dc_hotel_id . " AND id <=" . $last_id . " AND dc_id = 17 AND time < " . $last_time );
			} else {
				$data_return ["response"] = 0;
				$data_return ["responsebody"] = $result;
				$query = $this->db->query ( "DELETE FROM dc_log WHERE dc_hotel_id = " . $dc_hotel_id . " AND id <=" . $last_id . " AND dc_id = 17 AND time < " . $last_time );
			}
			
			if ($general_update == 0) {
				echo "Ban upload for booking service";
			} else {
				return $data_return;
			}
		}
	}
	
	function setavailability_lastchanged_17_v2($dc_hotel_id = 0) {
		$general_update = 0;
		$sql = "SELECT int_value FROM dc_hotelbook_xml_cfg WHERE name LIKE 'general_update'";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$general_update = $row->int_value;
		}
		$data_return = array ();
		if ($general_update == 1) {
		} else {
			$data_return ["response"] = 2;
			return $data_return;
		}
		
		$dc_account_id = 0;
		$sql = "SELECT dc_account_id FROM dc_hotelbook_xml_cfg WHERE int_value = " . $dc_hotel_id;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$dc_account_id = $row->dc_account_id;
		}
		
		$restrict_rate_id = 0;
		$sql = "SELECT int_value FROM dc_hotelbook_xml_cfg WHERE name LIKE 'restrict_rate_id'";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$restrict_rate_id = $row->int_value;
		}
		
		
		
		// $dc_hotel_id = $this->dcm_hotelbook->gethotelid ();
		
		$min_date = 0;
		$max_date = 0;
		$categories_rooms_all = array ();
		$data_return = array ();
		$intdate_today = floor ( time () / 86400 );
		$last_id = 0;
		$last_time = time ();
		
		$dc_rooms = array ();
		$sql = "SELECT dc_hotelbook_room_categories_link.*  FROM dc_hotelbook_room_categories_link ";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$dc_rooms [$row->hms_category_id] = $row->dc_category_id;
			}
		}
		$sql = "SELECT deskofrate.closed, dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms 
		    FROM categories
			INNER JOIN dc_log ON dc_log.categoryid = categories.id
			INNER JOIN rooms ON rooms.category_id = categories.id
			LEFT JOIN deskofrate ON deskofrate.category_id = categories.id AND dc_log.intdate = deskofrate.intdate AND deskofrate.rate_id = " . $restrict_rate_id . "
			WHERE rooms.dc_active=1 AND dc_log.dc_id = 17 AND dc_log.dc_hotel_id = $dc_hotel_id AND dc_log.intdate >= " . $intdate_today . "
			GROUP BY dc_log.categoryid, dc_log.intdate";
		$query = $this->db->query ( $sql );
		// echo $sql;
		// echo "start wait\n";
		// sleep(15);
		// echo "done wait\n";
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				// count_rooms_booking
				if ($min_date == 0) {
					$min_date = $row->log_intdate;
				} else {
					if ($row->log_intdate < $min_date) {
						$min_date = $row->log_intdate;
					}
				}
				
				if ($max_date == 0) {
					$max_date = $row->log_intdate;
				} else {
					if ($row->log_intdate > $max_date) {
						$max_date = $row->log_intdate;
					}
				}
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["closed"] = $row->closed;
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["free"] = $row->count_rooms;
				// $categories_rooms_all[$row->category_id][$row->log_intdate]["date"] = gmdate("Y-m-d", $row->log_intdate * 86400);
				
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["from"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
				$categories_rooms_all [$row->category_id] [$row->log_intdate] ["to"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
				// $last_id = $row->dc_log_id;
				if ($row->dc_log_id > $last_id) {
					$last_id = $row->dc_log_id;
				}
			}
		} else {
			$data_return ["response"] = 3;
			return $data_return;
		}
		
		// echo "<pre>";
		// print_r ( $categories_rooms_all );
		// die();
		$categories_rooms_intdate = array ();
		
		$sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
		FROM  `rooms`
		INNER JOIN categories ON categories.id = rooms.category_id
		INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
		INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
		dc_log.categoryid = rooms.category_id
		WHERE dc_log.dc_id = 17 AND dc_log.dc_hotel_id = $dc_hotel_id
		GROUP BY deskofdays.intdate, rooms.category_id";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				// count_rooms_booking
				$categories_rooms_intdate [$row->id] [$row->intdate] ["free"] = $row->count_rooms;
			}
		}
		
		// echo "<pre>";
		// print_r ( $categories_rooms_intdate );
		
		/*
		 * $query = $this->db->query("SELECT int_value FROM dc_hotelbook_xml_cfg WHERE name LIKE 'hotel_id'"); if ($query->num_rows() > 0) { $row = $query->row(); $hotel_id = $row->int_value; } else { $hotel_id = "none"; }
		 */
		/*
		* GET OVERBOOKING_RESERVATIONS_ARRAY
		*/
		$datein_out_mass = $this->dc_model->get_datein_dateout_dc_log ( 14 );
		$overbooking_reservations_array = array ();
		if (isset ( $datein_out_mass ["intdatein"] )) {
			$overbooking_reservations_array = $this->dc_model->get_overbooking_origincat ( $datein_out_mass ["intdatein"], $datein_out_mass ["intdateout"] );
		}
		
		/*
		 * Выгрузка загружености с booking
		 */
		
		$result = "";
		
		if ($general_update == 1) {
			$category_keys = array_keys ( $categories_rooms_all );
			foreach ( $category_keys as $category_id ) {
				
				$sql = "select min, max from dc_hotelbook_room_categories_link where hms_category_id =" . $category_id;
				$query = $this->db->query ( $sql );
				if ($query->num_rows () > 0) {
					$row2 = $query->row ();
					$min = $row2->min;
					$max = $row2->max;
				} else {
					$min = 0;
					$max = 999;
				}
				
				$arr_intdate_keys = array_keys ( $categories_rooms_all [$category_id] );
				foreach ( $arr_intdate_keys as $intdate ) {
					if ($categories_rooms_all [$category_id] [$intdate] ["closed"] == 1) {
						$categories_rooms_all [$category_id] [$intdate] ["free"] = 0;
					} else {
						if (isset ( $categories_rooms_intdate [$category_id] [$intdate] )) {
							$count_overbook_rooms = 0;
							if (isset ( $overbooking_reservations_array [$category_id] [$intdate] )) {
								$count_overbook_rooms = $overbooking_reservations_array [$category_id] [$intdate];
							}
							$categories_rooms_all [$category_id] [$intdate] ["free"] = $categories_rooms_all [$category_id] [$intdate] ["free"] - ($categories_rooms_intdate [$category_id] [$intdate] ["free"] + $count_overbook_rooms);
						} else {
							if (isset ( $overbooking_reservations_array [$category_id] [$intdate] )) {
								$count_overbook_rooms = $overbooking_reservations_array [$category_id] [$intdate];
								$categories_rooms_all [$category_id] [$intdate] ["free"] = $categories_rooms_all [$category_id] [$intdate] ["free"] - $count_overbook_rooms;
							}
						}
						
						if ($categories_rooms_all [$category_id] [$intdate] ["free"] > $min) {
							$categories_rooms_all [$category_id] [$intdate] ["free"] = $categories_rooms_all [$category_id] [$intdate] ["free"] - $min;
						} else {
							$categories_rooms_all [$category_id] [$intdate] ["free"] = 0;
						}
						
						if ($categories_rooms_all [$category_id] [$intdate] ["free"] > $max) {
							$categories_rooms_all [$category_id] [$intdate] ["free"] = $max;
						}
						
						// коррекція к-сті відповідно умовам ф-ї availability_count_correction
						$startdate = $enddate = date("Y-m-d", $intdate*86400);
						$categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
						
					}
					
					if (true) {
						$prev = $intdate - 1;
						if (isset ( $categories_rooms_all [$category_id] [$prev] )) {
							$free_1 = $categories_rooms_all [$category_id] [$prev] ["free"];
							$free_2 = $categories_rooms_all [$category_id] [$intdate] ["free"];
							
							if ($free_1 == $free_2) {
								$categories_rooms_all [$category_id] [$intdate] ["from"] = $categories_rooms_all [$category_id] [$prev] ["from"];
								unset ( $categories_rooms_all [$category_id] [$prev] );
							}
						}
					}
				}
			}
			echo "<pre>";
			// print_r ( $dc_rooms );
			print_r ( $categories_rooms_all );
			$data = array ();
			if (true) {
				foreach ( $categories_rooms_all as $category_id => $intdates ) {
					foreach ( $intdates as $intdate => $cell ) {
						/*
						 * $todate = $categories_rooms_all[$category_id][$intdate]["to"]; list ($year, $month, $day) = explode("-", $todate); $intdate_to = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400); $intdate_to = $intdate_to - 1; $categories_rooms_all[$category_id][$intdate]["to"] = gmdate("Y-m-d", $intdate_to * 86400);
						 */
						if (isset ( $dc_rooms [$category_id] )) {
							array_push ( $data, array (
									"dateFrom" => $categories_rooms_all [$category_id] [$intdate] ["from"],
									"dateTo" => $categories_rooms_all [$category_id] [$intdate] ["to"],
									"roomId" => $dc_rooms [$category_id],
									"quota" => $categories_rooms_all [$category_id] [$intdate] ["free"] 
							) );
						}
					}
				}
			}
			echo "==============================================";
			// print_r ( $dc_rooms );
			print_r ( $categories_rooms_all );
			// die ();
			if (count ( $data ) < 1) {
				$query = $this->db->query ( "DELETE FROM dc_log WHERE dc_id = 17 AND dc_hotel_id = " . $dc_hotel_id );
				$data_return ["response"] = 4;
				return $data_return;
			}
			$curl_data = array ();
			$curl_data ["action"] = "update";
			$curl_data ["data"]["hotelId"] = $dc_hotel_id;
			$curl_data ["data"]["avail"] = $data;
			print_r ( $curl_data );
			$post = json_encode ( $curl_data );
                
                // $url = $auth_data["api_url"].'/gate/v1/availability?apiKey='.$dc_hotel_id;
            $param = $this->dcm_hotelbook->get_api_url($dc_account_id);
            $url = $param['api_url'];
            echo $url;
            $data_result = $this->Curl_model->CurlPlugRaw_auth_hotelbook($post, $url, array(
                "returntype" => "array"
            ));
            $result = $data_result["result"];
            $dc_log_id = $data_result["dc_log_id"];
			
			
			
			
			echo $result;
			
			
			$result_array = (json_decode ( $result, true ));

			print_r ( $result_array );
			
			//die ();
			
			$hotel_id = 1;
			
			$data_return = array ();
			$data_return ["dc_log_id"] = $dc_log_id;
			$data_return ["datein"] = gmdate ( "Y-m-d", $min_date * 86400 );
			$data_return ["dateout"] = gmdate ( "Y-m-d", $max_date * 86400 );
			
			if (count($result_array ['errors']) == 0) {
				$data_return ["response"] = 1;
				$data_return ["responsebody"] = "success";
				$query = $this->db->query ( "DELETE FROM dc_log WHERE dc_hotel_id = " . $dc_hotel_id . " AND id <=" . $last_id . " AND dc_id = 17 AND time < " . $last_time );
			} else {
				$data_return ["response"] = 0;
				$data_return ["responsebody"] = $result;
				$query = $this->db->query ( "DELETE FROM dc_log WHERE dc_hotel_id = " . $dc_hotel_id . " AND id <=" . $last_id . " AND dc_id = 17 AND time < " . $last_time );
			}
			
			if ($general_update == 0) {
				echo "Ban upload for booking service";
			} else {
				return $data_return;
			}
		}
	}
	
	function setavailability_lastchanged_18_OLD()
	{
		$general_update = 0;
		$sql = "SELECT int_value FROM dc_eholiday_xml_cfg WHERE name LIKE 'general_update'";
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0) {
			$row = $query->row();
			$general_update = $row->int_value;
		}
		$data_return = array();
		if ($general_update == 1) {} else {
			$data_return["response"] = 2;
			return $data_return;
		}
	
		$min_date = 0;
		$max_date = 0;
		$categories_rooms_all = array();
		$data_return = array();
		$intdate_today = floor(time() / 86400);
		$last_id = 0;
		$last_time = time();
	
		$dc_rooms = array();
		$sql = "SELECT  dc_eholiday_rooms_link.*  FROM  dc_eholiday_rooms_link ";
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$dc_rooms[$row->category_id] = $row->dc_room_id;
			}
		}
			
		$sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate,
				
				COUNT(rooms.id) as count_rooms FROM categories
				INNER JOIN dc_log ON dc_log.categoryid = categories.id
				INNER JOIN rooms ON rooms.category_id = categories.id
				WHERE rooms.dc_active=1 AND dc_log.dc_id = 18 AND dc_log.intdate >= " . $intdate_today . "
				GROUP BY dc_log.categoryid, dc_log.intdate ";
		//echo $sql;
		//die();
		$query = $this->db->query($sql);
		
		// echo "start wait\n";
		//die("DEBUG");
		// echo "done wait\n";
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				// count_rooms_booking
				if ($min_date == 0) {
					$min_date = $row->log_intdate;
				} else {
					if ($row->log_intdate < $min_date) {
						$min_date = $row->log_intdate;
					}
				}
	
				if ($max_date == 0) {
					$max_date = $row->log_intdate;
				} else {
					if ($row->log_intdate > $max_date) {
						$max_date = $row->log_intdate;
					}
				}
	
				//$categories_rooms_all[$row->category_id][$row->log_intdate]["closed"] = $row->closed;
				$categories_rooms_all[$row->category_id][$row->log_intdate]["free"] = $row->count_rooms;
				// $categories_rooms_all[$row->category_id][$row->log_intdate]["date"] = gmdate("Y-m-d", $row->log_intdate * 86400);
	
				$categories_rooms_all[$row->category_id][$row->log_intdate]["from"] = gmdate("Y-m-d", $row->log_intdate * 86400);
				$categories_rooms_all[$row->category_id][$row->log_intdate]["to"] = gmdate("Y-m-d", $row->log_intdate * 86400);
				// $last_id = $row->dc_log_id;
				if ($row->dc_log_id > $last_id) {
					$last_id = $row->dc_log_id;
				}
			}
		} else {
			$data_return["response"] = 3;
			return $data_return;
		}
	
		// echo "<pre>";
		// print_r ( $categories_rooms_all );
		// die();
		$categories_rooms_intdate = array();
	
		$sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
FROM  `rooms`
INNER JOIN categories ON categories.id = rooms.category_id
INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
dc_log.categoryid = rooms.category_id
WHERE dc_log.dc_id = 18
GROUP BY deskofdays.intdate, rooms.category_id";
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				// count_rooms_booking
				$categories_rooms_intdate[$row->id][$row->intdate]["free"] = $row->count_rooms;
			}
		}
	
		// echo "<pre>";
		// print_r ( $categories_rooms_intdate );
	
		$query = $this->db->query("SELECT int_value FROM dc_eholiday_xml_cfg WHERE name LIKE 'hotel_id'");
		if ($query->num_rows() > 0) {
			$row = $query->row();
			$hotel_id = $row->int_value;
		} else {
			$hotel_id = "none";
		}
	
		/*
		 * GET OVERBOOKING_RESERVATIONS_ARRAY
		*/
		$datein_out_mass = $this->dc_model->get_datein_dateout_dc_log(18);
		$overbooking_reservations_array = array();
		if (isset($datein_out_mass["intdatein"])) {
			$overbooking_reservations_array = $this->dc_model->get_overbooking_origincat($datein_out_mass["intdatein"], $datein_out_mass["intdateout"]);
		}
	
		/*
		 * Выгрузка загружености с booking
		*/
	
		$result = "";
	
		if ($general_update == 1) {
			$category_keys = array_keys($categories_rooms_all);
			foreach ($category_keys as $category_id) {
	
				$sql = "select min, max from dc_eholiday_rooms_link where category_id =" . $category_id;
				$query = $this->db->query($sql);
				if ($query->num_rows() > 0) {
					$row2 = $query->row();
					$min = $row2->min;
					$max = $row2->max;
				} else {
					$min = 0;
					$max = 999;
				}
	
				$arr_intdate_keys = array_keys($categories_rooms_all[$category_id]);
				foreach ($arr_intdate_keys as $intdate) {
					if (isset($categories_rooms_intdate[$category_id][$intdate])) {
						$count_overbook_rooms = 0;
						if (isset($overbooking_reservations_array[$category_id][$intdate])) {
							$count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
						}
						$categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
					} else {
						if (isset($overbooking_reservations_array[$category_id][$intdate])) {
							$count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
							$categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $count_overbook_rooms;
						}
					}
	
					if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
						$categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
					} else {
						$categories_rooms_all[$category_id][$intdate]["free"] = 0;
					}
	
					if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
						$categories_rooms_all[$category_id][$intdate]["free"] = $max;
					}
	
					if (true) {
						$prev = $intdate - 1;
						if (isset($categories_rooms_all[$category_id][$prev])) {
							$free_1 = $categories_rooms_all[$category_id][$prev]["free"];
							$free_2 = $categories_rooms_all[$category_id][$intdate]["free"];
	
							if ($free_1 == $free_2) {
								$categories_rooms_all[$category_id][$intdate]["from"] = $categories_rooms_all[$category_id][$prev]["from"];
								unset($categories_rooms_all[$category_id][$prev]);
							}
						}
					}
				}
			}
			//echo "<pre>";
			//print_r ( $categories_rooms_all );
			//die();
			$data = array();
			if ( true) {
				foreach ($categories_rooms_all as $category_id => $intdates) {
					foreach ($intdates as $intdate => $cell) {
						//if($categories_rooms_all[$category_id][$intdate]["closed"] == 1){
						//	$categories_rooms_all[$category_id][$intdate]["free"] = 0;
						//}
						array_push($data, array(
						//"closed"=> $categories_rooms_all[$category_id][$intdate]["closed"],
						"categoryID"=> $dc_rooms[$category_id],
						"startDateYmd"=> $categories_rooms_all[$category_id][$intdate]["from"],
						"endDateYmd"=> $categories_rooms_all[$category_id][$intdate]["to"],
						"avail" => $categories_rooms_all[$category_id][$intdate]["free"]
	
						));
					}
				}
			}
			echo "<pre>";
			// print_r ( $dc_rooms );
			print_r ( $data );
			die ();
				
			$dc_eholiday_rooms2rates = array();
			$sql = "SELECT dc_rate_id, dc_category_id FROM dc_eholiday_rate2category_link";
			$query = $this->db->query ( $sql );
			if ($query->num_rows () > 0) {
				$i = 0;
				foreach ( $query->result () as $row ) {
					$dc_eholiday_rooms2rates [$row->dc_category_id]["rates"][$i] = $row->dc_rate_id;
					$i++;
				}
			}
			
			
			$this->load->library('api_otaSoapClient');
			$ota = new api_otaSoapClient();
			$auth_chmgr=new AuthChannelManager();
			$auth_chmgr->chmgr_login="otelms";
			$auth_chmgr->chmgr_key="975b8f8a445dfb6db1f6b4c6399d3e21e86562759d13fa6dc3a259a3881b454f";
			
			$params = $this->dcm_eholiday->getauthparam();
			$dc_hotel_id = $params["dc_hotel_id"];
			$o_id = $dc_hotel_id;
			
			
			$json_request = "";
			$success_request_array = array();
			$result_response_array = array();
			$errors_response_array = array();
			$r = 0;
			foreach ( $data as $cell ) {
				// setAllotment
				if (isset ( $dc_eholiday_rooms2rates [$cell ["categoryID"]] )) {
					foreach ( $dc_eholiday_rooms2rates [$cell ["categoryID"]] ["rates"] as $dc_rate_id ) {
						$setAllotmentParams = new setAllotmentParams ();
						
						$setAllotmentParams->vr_id = $cell ["categoryID"];
						$setAllotmentParams->rp_id = $dc_rate_id;
						$DateRange = new DateRange ();
						list ( $year, $month, $day ) = explode ( "-", $cell ["startDateYmd"] );
						$DateRange->start_ts = gmmktime ( 0, 0, 0, $month, $day, $year );
						list ( $year, $month, $day ) = explode ( "-", $cell ["endDateYmd"] );
						$DateRange->stop_ts = gmmktime ( 0, 0, 0, $month, $day, $year );
						
						$setAllotmentParams->pr_date_range = $DateRange;
						$setAllotmentParams->pr_allotment = $cell ["avail"];
						
						$json_request .= json_encode($setAllotmentParams)."<br>";
						$setAllotment = $ota->setAllotment ( $auth_chmgr, $setAllotmentParams );
						$result = json_decode(json_encode($setAllotment), true);
						
						print_r ( $result );
						
						if($result["status"] == 1){
							$success_request_array [$r] = $setAllotmentParams;
							$result_response_array [$r] = $setAllotment;
							$r++;
						}else{
							//============= SAVE DC LOG ====================
							
							$this->dc_model->dc_log_data_errors_update($cell ["startDateYmd"], $cell ["endDateYmd"], 18, $cell ["categoryID"]);
							
							//============== SAVE LOG ======================
							
							$log_update_id = $this->dcm_eholiday->save_eholiday_log ( json_encode($setAllotmentParams), json_encode($setAllotment) );
							$this->Loger_admin->Save_SyncData ( "", "", "ERROR", 18, 2, $log_update_id );
						}
					}
					
				}
			}
			
			$log_update_id = $this->dcm_eholiday->save_eholiday_log ( json_encode($success_request_array), json_encode($result_response_array) );
			$this->Loger_admin->Save_SyncData ( "", "", "success", 18, 2, $log_update_id );
			
			$query = $this->db->query ( "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 18 AND time < " . $last_time );
		}
	}
	function setavailability_lastchanged_18()
	{
		$general_update = 0;
		$sql = "SELECT int_value FROM dc_eholiday_xml_cfg WHERE name LIKE 'general_update'";
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0) {
			$row = $query->row();
			$general_update = $row->int_value;
		}
		$data_return = array();
		if ($general_update == 1) {} else {
			$data_return["response"] = 2;
			return $data_return;
		}
	
		$min_date = 0;
		$max_date = 0;
		$categories_rooms_all = array();
		$data_return = array();
		$intdate_today = floor(time() / 86400);
		$last_id = 0;
		$last_time = time();
	
		$sql222 = "SELECT dc_log.id as dc_log_id, dc_eholiday_rooms_link.dc_room_id, categories.id as category_id, dc_log.intdate as log_intdate,
				deskofrate.closed, dc_eholiday_rates.dc_rate_id, dc_eholiday_rates.restrict_id, rooms.id as room_id,
				COUNT(rooms.id) as count_rooms FROM dc_log
	
				INNER JOIN dc_eholiday_rooms_link ON dc_eholiday_rooms_link.category_id = dc_log.categoryid
				INNER JOIN dc_eholiday_rate2category_link ON dc_eholiday_rate2category_link.dc_category_id = dc_eholiday_rooms_link.dc_room_id
				INNER JOIN dc_eholiday_rates ON dc_eholiday_rates.dc_rate_id = dc_eholiday_rate2category_link.dc_rate_id
				INNER JOIN categories ON dc_log.categoryid = categories.id
				INNER JOIN rooms ON rooms.category_id = categories.id
				LEFT JOIN deskofrate ON deskofrate.intdate = dc_log.intdate AND deskofrate.category_id = dc_log.categoryid AND deskofrate.rate_id = dc_eholiday_rates.restrict_id
				WHERE rooms.dc_active=1 AND dc_log.dc_id = 18 AND dc_log.intdate >= " . $intdate_today . "
				GROUP BY dc_eholiday_rate2category_link.dc_rate_id, dc_eholiday_rooms_link.dc_room_id, dc_log.intdate ";
		
		$sql = "SELECT dc_eholiday_rooms_link.dc_room_id, t1.*, deskofrate.closed, dc_eholiday_rates.dc_rate_id, dc_eholiday_rates.restrict_id
				FROM (
				SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms
				FROM categories
				INNER JOIN dc_log ON dc_log.categoryid = categories.id
				INNER JOIN rooms ON rooms.category_id = categories.id
				WHERE rooms.dc_active=1 AND dc_log.dc_id = 18 AND dc_log.intdate >= " . $intdate_today . "
				GROUP BY dc_log.categoryid, dc_log.intdate ORDER BY dc_log.id, dc_log.intdate
				) as t1
		
				INNER JOIN dc_eholiday_rooms_link ON dc_eholiday_rooms_link.category_id = t1.category_id
				INNER JOIN dc_eholiday_rate2category_link ON dc_eholiday_rate2category_link.dc_category_id = dc_eholiday_rooms_link.dc_room_id
				INNER JOIN dc_eholiday_rates ON dc_eholiday_rates.dc_rate_id = dc_eholiday_rate2category_link.dc_rate_id
				LEFT JOIN deskofrate ON deskofrate.intdate = t1.log_intdate AND deskofrate.category_id = t1.category_id AND deskofrate.rate_id = dc_eholiday_rates.restrict_id
				GROUP BY dc_eholiday_rate2category_link.dc_rate_id, dc_eholiday_rooms_link.dc_room_id, t1.log_intdate";
	
		//echo $sql;
		$query = $this->db->query($sql);
	
		// echo "start wait\n";
		//die("DEBUG");
		// echo "done wait\n";
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				// count_rooms_booking
				if ($min_date == 0) {
					$min_date = $row->log_intdate;
				} else {
					if ($row->log_intdate < $min_date) {
						$min_date = $row->log_intdate;
					}
				}
	
				if ($max_date == 0) {
					$max_date = $row->log_intdate;
				} else {
					if ($row->log_intdate > $max_date) {
						$max_date = $row->log_intdate;
					}
				}
	
				$categories_rooms_all[$row->dc_rate_id][$row->dc_room_id][$row->log_intdate]["closed"] = $row->closed;
				$categories_rooms_all[$row->dc_rate_id][$row->dc_room_id][$row->log_intdate]["free"] = $row->count_rooms;
				$categories_rooms_all[$row->dc_rate_id][$row->dc_room_id][$row->log_intdate]["from"] = gmdate("Y-m-d", $row->log_intdate * 86400);
				$categories_rooms_all[$row->dc_rate_id][$row->dc_room_id][$row->log_intdate]["to"] = gmdate("Y-m-d", $row->log_intdate * 86400);
				// $last_id = $row->dc_log_id;
				if ($row->dc_log_id > $last_id) {
					$last_id = $row->dc_log_id;
				}
			}
		} else {
			$data_return["response"] = 3;
			return $data_return;
		}
	
		// echo "<pre>";
		// print_r ( $categories_rooms_all );
		// die();
		$categories_rooms_intdate = array();
	
		$sql = "SELECT dc_eholiday_rooms_link.dc_room_id, categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
FROM  `rooms`
INNER JOIN categories ON categories.id = rooms.category_id
INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND dc_log.categoryid = rooms.category_id
INNER JOIN dc_eholiday_rooms_link ON dc_eholiday_rooms_link.category_id = dc_log.categoryid
WHERE dc_log.dc_id = 18
GROUP BY deskofdays.intdate, rooms.category_id";
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				// count_rooms_booking
				$categories_rooms_intdate[$row->dc_room_id][$row->intdate]["free"] = $row->count_rooms;
			}
		}
	
		// echo "<pre>";
		// print_r ( $categories_rooms_intdate );
	
		$query = $this->db->query("SELECT int_value FROM dc_eholiday_xml_cfg WHERE name LIKE 'hotel_id'");
		if ($query->num_rows() > 0) {
			$row = $query->row();
			$hotel_id = $row->int_value;
		} else {
			$hotel_id = "none";
		}
	
		/*
		 * GET OVERBOOKING_RESERVATIONS_ARRAY
		*/
		$datein_out_mass = $this->dc_model->get_datein_dateout_dc_log(18);
		$overbooking_reservations_array = array();
		if (isset($datein_out_mass["intdatein"])) {
			$overbooking_reservations_array = $this->dc_model->get_overbooking_origincat($datein_out_mass["intdatein"], $datein_out_mass["intdateout"]);
		}
	
		/*
		 * Выгрузка загружености с booking
		*/
	
		$result = "";
	
		if ($general_update == 1) {
			$rates_keys = array_keys($categories_rooms_all);
			foreach ( $rates_keys as $rate_id ) {
				$category_keys = array_keys($categories_rooms_all[$rate_id]);
				foreach ( $category_keys as $category_id ) {
					
					$sql = "select min, max from dc_eholiday_rooms_link where category_id =" . $category_id;
					$query = $this->db->query ( $sql );
					if ($query->num_rows () > 0) {
						$row2 = $query->row ();
						$min = $row2->min;
						$max = $row2->max;
					} else {
						$min = 0;
						$max = 999;
					}
					
					$arr_intdate_keys = array_keys ( $categories_rooms_all [$rate_id][$category_id] );
					foreach ( $arr_intdate_keys as $intdate ) {
						if (isset ( $categories_rooms_intdate [$category_id] [$intdate] )) {
							$count_overbook_rooms = 0;
							if (isset ( $overbooking_reservations_array [$category_id] [$intdate] )) {
								$count_overbook_rooms = $overbooking_reservations_array [$category_id] [$intdate];
							}
							$categories_rooms_all [$rate_id][$category_id] [$intdate] ["free"] = $categories_rooms_all [$rate_id][$category_id] [$intdate] ["free"] - ($categories_rooms_intdate [$category_id] [$intdate] ["free"] + $count_overbook_rooms);
						} else {
							if (isset ( $overbooking_reservations_array [$category_id] [$intdate] )) {
								$count_overbook_rooms = $overbooking_reservations_array [$category_id] [$intdate];
								$categories_rooms_all [$rate_id][$category_id] [$intdate] ["free"] = $categories_rooms_all [$rate_id][$category_id] [$intdate] ["free"] - $count_overbook_rooms;
							}
						}
						
						if ($categories_rooms_all [$rate_id][$category_id] [$intdate] ["free"] > $min) {
							$categories_rooms_all [$rate_id][$category_id] [$intdate] ["free"] = $categories_rooms_all [$rate_id][$category_id] [$intdate] ["free"] - $min;
						} else {
							$categories_rooms_all [$rate_id][$category_id] [$intdate] ["free"] = 0;
						}
						
						if ($categories_rooms_all [$rate_id][$category_id] [$intdate] ["free"] > $max) {
							$categories_rooms_all [$rate_id][$category_id] [$intdate] ["free"] = $max;
						}
						
						// коррекція к-сті відповідно умовам ф-ї availability_count_correction
						$startdate = $enddate = date("Y-m-d", $intdate*86400);
						$categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
						
						if (true) {
							$prev = $intdate - 1;
							if (isset ( $categories_rooms_all [$rate_id][$category_id] [$prev] )) {
								$free_1 = $categories_rooms_all [$rate_id][$category_id] [$prev] ["free"];
								$free_2 = $categories_rooms_all [$rate_id][$category_id] [$intdate] ["free"];
								
								if ($free_1 == $free_2) {
									$categories_rooms_all [$rate_id][$category_id] [$intdate] ["from"] = $categories_rooms_all [$rate_id][$category_id] [$prev] ["from"];
									unset ( $categories_rooms_all [$rate_id][$category_id] [$prev] );
								}
							}
						}
					}
				}
			}
			echo "<pre>";
			print_r ( $categories_rooms_all );
			//die();
			$data = array();
			
			$this->load->library('api_otaSoapClient');
			$ota = new api_otaSoapClient();
			$auth_chmgr=new AuthChannelManager();
			$auth_chmgr->chmgr_login="otelms";
			$auth_chmgr->chmgr_key="975b8f8a445dfb6db1f6b4c6399d3e21e86562759d13fa6dc3a259a3881b454f";
				
			$params = $this->dcm_eholiday->getauthparam();
			$dc_hotel_id = $params["dc_hotel_id"];
			$o_id = $dc_hotel_id;
				
				
			$json_request = "";
			$success_request_array = array();
			$result_response_array = array();
			$errors_response_array = array();
			$r = 0;
			foreach ( $categories_rooms_all as $dc_rate_id => $dc_categories ) {
				// setAllotment
				foreach ( $dc_categories as $dc_room_id => $intdates ) {
					foreach ( $intdates as $intdate => $cell ) {
						$setAllotmentParams = new setAllotmentParams ();
						
						$setAllotmentParams->vr_id = $dc_room_id;
						$setAllotmentParams->rp_id = $dc_rate_id;
						$DateRange = new DateRange ();
						list ( $year, $month, $day ) = explode ( "-", $cell ["from"] );
						$DateRange->start_ts = gmmktime ( 0, 0, 0, $month, $day, $year );
						list ( $year, $month, $day ) = explode ( "-", $cell ["to"] );
						$DateRange->stop_ts = gmmktime ( 0, 0, 0, $month, $day, $year );
						
						$setAllotmentParams->pr_date_range = $DateRange;
						if ($cell ["closed"] == 1) {
							$setAllotmentParams->pr_allotment = 0;
						} else {
							$setAllotmentParams->pr_allotment = $cell ["free"];
						}
						$json_request .= json_encode ( $setAllotmentParams ) . "<br>";
						$setAllotment = $ota->setAllotment ( $auth_chmgr, $setAllotmentParams );
						$result = json_decode ( json_encode ( $setAllotment ), true );
						
						print_r ( $result );
						
						if ($result ["status"] == 1) {
							$success_request_array [$r] = $setAllotmentParams;
							$result_response_array [$r] = $setAllotment;
							$r ++;
						} else {
							// ============= SAVE DC LOG ====================
							
							$this->dc_model->dc_log_data_errors_update ( $cell ["from"], $cell ["to"], 18, $dc_room_id );
							
							// ============== SAVE LOG ======================
							
							$log_update_id = $this->dcm_eholiday->save_eholiday_log ( json_encode ( $setAllotmentParams ), json_encode ( $setAllotment ) );
							$this->Loger_admin->Save_SyncData ( "", "", "ERROR", 18, 2, $log_update_id );
						}
					}
				}
			}
				
			$log_update_id = $this->dcm_eholiday->save_eholiday_log ( json_encode($success_request_array), json_encode($result_response_array) );
			$this->Loger_admin->Save_SyncData ( "", "", "success", 18, 2, $log_update_id );
				
			$query = $this->db->query ( "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 18 AND time < " . $last_time );
		}
	}
	function setavailability_lastchanged_19()
	{
	    $debug = 0;
		$general_update = 0;
		$sql = "SELECT int_value FROM dc_dobovo_xml_cfg WHERE name LIKE 'general_update'";
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0) {
			$row = $query->row();
			$general_update = $row->int_value;
		}
		$data_return = array();
		if ($general_update == 1) {} else {
			$data_return["response"] = 2;
			return $data_return;
		}
	
		$dc_hms_cat = array();
		$dc2hms_cat = array();
		//$hms2dc_cat = array();
		$sql = "SELECT dc_dobovo_room_categories_link.*  FROM dc_dobovo_room_categories_link ";
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$dc_hms_cat[$row->hms_category_id] = $row->dc_category_id;
				$dc2hms_cat[$row->dc_category_id] = $row->hms_category_id;
				//$hms2dc_cat[$row->hms_category_id] = $row->dc_category_id;
			}
		}
		
		if ($debug) {
		    echo "<pre> \n dc_hms_cat \n";
		    print_r ( $dc_hms_cat );
		    print_r ( $dc2hms_cat );
		}
	
		$min_date = 0;
		$max_date = 0;
		$categories_rooms_all = array();
		$data_return = array();
		$intdate_today = floor(time() / 86400);
		$last_id = 0;
		$last_time = time();
	
		$sql = "SELECT id as dc_log_id FROM dc_log WHERE dc_id = 19 ORDER BY id ASC";
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$last_id = $row->dc_log_id;
		
			}
		}
		
		$sql = "SELECT dc_log.id as dc_log_id, dc_category_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms  FROM categories
				INNER JOIN dc_log ON dc_log.categoryid = categories.id	
				INNER JOIN dc_dobovo_room_categories_link on dc_dobovo_room_categories_link.hms_category_id = categories.id	
				INNER JOIN dc_dobovo_room_categories on dc_dobovo_room_categories.dc_room_id = dc_dobovo_room_categories_link.dc_category_id	    
		        INNER JOIN rooms ON rooms.category_id = categories.id  
		    
		    
				WHERE rooms.dc_active=1 AND dc_log.dc_id = 19 AND dc_log.intdate >= " . $intdate_today . "
				GROUP BY dc_category_id, dc_log.categoryid, dc_log.intdate";
		//echo $sql;
		$query = $this->db->query($sql);
		
		// echo "start wait\n";
		// sleep(15);
		// echo "done wait\n";
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				// count_rooms_booking
				if ($min_date == 0) {
					$min_date = $row->log_intdate;
				} else {
					if ($row->log_intdate < $min_date) {
						$min_date = $row->log_intdate;
					}
				}
	
				if ($max_date == 0) {
					$max_date = $row->log_intdate;
				} else {
					if ($row->log_intdate > $max_date) {
						$max_date = $row->log_intdate;
					}
				}
				if (isset($dc_hms_cat[$row->dc_category_id])) {
					$categories_rooms_all[$row->dc_category_id][$row->log_intdate]["dc_room_id"] = $row->dc_category_id;
				} else {
					$categories_rooms_all[$row->dc_category_id][$row->log_intdate]["dc_room_id"] = 0;
				}
				$categories_rooms_all[$row->dc_category_id][$row->log_intdate]["dc_room_id"] = $row->dc_category_id;
				$categories_rooms_all[$row->dc_category_id][$row->log_intdate]["hms_category_id"] = $row->category_id;
				$categories_rooms_all[$row->dc_category_id][$row->log_intdate]["free"] = $row->count_rooms;
				$categories_rooms_all[$row->dc_category_id][$row->log_intdate]["date"] = gmdate("Y-m-d", $row->log_intdate * 86400);
	
				$categories_rooms_all[$row->dc_category_id][$row->log_intdate]["from"] = gmdate("Y-m-d", $row->log_intdate * 86400);
				$categories_rooms_all[$row->dc_category_id][$row->log_intdate]["to"] = gmdate("Y-m-d", $row->log_intdate * 86400);
				// $last_id = $row->dc_log_id;
				if ($row->dc_log_id > $last_id) {
					$last_id = $row->dc_log_id;
				}
			}
		} else {
			$sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 19 AND time < " . $last_time;
			$query = $this->db->query($sql);
			
			$data_return["response"] = 3;
			return $data_return;
		}
	
		if ($debug) {
		echo "<pre> \n categories_rooms_all \n";
		print_r ( $categories_rooms_all );
		}
		// die();
	
		$categories_rooms_intdate = array();
	
		$sql = "SELECT dc_category_id,categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
FROM  `rooms`
INNER JOIN categories ON categories.id = rooms.category_id
INNER JOIN dc_dobovo_room_categories_link on dc_dobovo_room_categories_link.hms_category_id = categories.id
INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
dc_log.categoryid = rooms.category_id
WHERE dc_log.dc_id = 19
GROUP BY deskofdays.intdate, dc_category_id, rooms.category_id";
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				// count_rooms_booking
				$categories_rooms_intdate[$row->dc_category_id][$row->intdate]["free"] = $row->count_rooms;
			}
		}
	
		// echo "<pre>";
		
		if ($debug) {
		    echo "categories_rooms_intdate ";
		  print_r($categories_rooms_intdate);
		}
	
		$query = $this->db->query("SELECT int_value FROM dc_dobovo_xml_cfg WHERE name LIKE 'hotel_id'");
		if ($query->num_rows() > 0) {
			$row = $query->row();
			$hotel_id = $row->int_value;
		} else {
			$hotel_id = "none";
		}
	
		$query = $this->db->query("SELECT str_value FROM dc_dobovo_xml_cfg WHERE name LIKE 'api_key'");
		if ($query->num_rows() > 0) {
			$row = $query->row();
			$api_key = $row->str_value;
		} else {
			$api_key = "none";
		}
	
		/*
		 * GET OVERBOOKING_RESERVATIONS_ARRAY
		*/
		$datein_out_mass = $this->dc_model->get_datein_dateout_dc_log(19);
		$overbooking_reservations_array = array();
		if (isset($datein_out_mass["intdatein"])) {
			$overbooking_reservations_array = $this->dc_model->get_overbooking_origincat($datein_out_mass["intdatein"], $datein_out_mass["intdateout"]);
		}
		
		if ($debug) {
		    echo "overbooking_reservations_array ";
		    print_r($overbooking_reservations_array);
		}
	
		$deskofrate_array = array();
		$sql = "SELECT dc_log.intdate, deskofrate.closed, dc_dobovo_room_categories_link.dc_category_id 
				FROM dc_log
				INNER JOIN dc_dobovo_room_categories_link ON dc_log.categoryid = dc_dobovo_room_categories_link.hms_category_id
				INNER JOIN dc_dobovo_rate2category_link ON (dc_dobovo_rate2category_link.dc_category_id = dc_dobovo_room_categories_link.dc_category_id)
				LEFT JOIN deskofrate ON (dc_dobovo_rate2category_link.hms_restrict_id = deskofrate.rate_id AND dc_log.categoryid = deskofrate.category_id AND dc_log.intdate = deskofrate.intdate)
				WHERE dc_log.dc_id = 19";
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				// count_rooms_booking
				$deskofrate_array[$row->dc_category_id][$row->intdate]["closed"] = $row->closed;
			}
		}
		
		$result = "";
		$sql = "SELECT int_value FROM dc_dobovo_xml_cfg WHERE name LIKE 'general_update'";
		$query = $this->db->query($sql);
		if ($general_update == 1) {
			$category_keys = array_keys($categories_rooms_all);
			foreach ($category_keys as $category_id) {
	
				$sql = "select min, max from dc_dobovo_room_categories_link where dc_category_id =" . $category_id;
				$query = $this->db->query($sql);
	
				if ($query->num_rows() > 0) {
					$row2 = $query->row();
					$min = $row2->min;
					$max = $row2->max;
				} else {
					$min = 0;
					$max = 999;
				}
	
				$arr_intdate_keys = array_keys($categories_rooms_all[$category_id]);
				foreach ($arr_intdate_keys as $intdate) {
					if (isset($categories_rooms_intdate[$category_id][$intdate])) {
						$count_overbook_rooms = 0;
						if (isset($overbooking_reservations_array[$dc2hms_cat[$category_id]][$intdate])) {
							$count_overbook_rooms = $overbooking_reservations_array[$dc2hms_cat[$category_id]][$intdate];
						}
						$categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
					} else {
						if (isset($overbooking_reservations_array[$dc2hms_cat[$category_id]][$intdate])) {
							$count_overbook_rooms = $overbooking_reservations_array[$dc2hms_cat[$category_id]][$intdate];
							$categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $count_overbook_rooms;
						}
					}
	
					if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
						$categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
					} else {
						$categories_rooms_all[$category_id][$intdate]["free"] = 0;
					}
	
					if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
						$categories_rooms_all[$category_id][$intdate]["free"] = $max;
					}
					
					// коррекція к-сті відповідно умовам ф-ї availability_count_correction
					$startdate = $enddate = date("Y-m-d", $intdate*86400);
					$categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
					
					if(isset($deskofrate_array[$category_id][$intdate]["closed"])){
						if($deskofrate_array[$category_id][$intdate]["closed"] == 1){
							$categories_rooms_all[$category_id][$intdate]["free"] = 0;
						}
					}
	
					$prev = $intdate - 1;
					if (isset($categories_rooms_all[$category_id][$prev])) {
						$free_1 = $categories_rooms_all[$category_id][$prev]["free"];
						$free_2 = $categories_rooms_all[$category_id][$intdate]["free"];
	
						if ($free_1 == $free_2) {
							$categories_rooms_all[$category_id][$intdate]["from"] = $categories_rooms_all[$category_id][$prev]["from"];
							unset($categories_rooms_all[$category_id][$prev]);
						}
					}
				}
			}
	
			$freeRooms = $categories_rooms_all;
			if ($debug) {
			    echo "categories_rooms_all <pre>";
			print_r ( $freeRooms );
			}
			
			//die();
			$roomsresult = array();
			$sql = "SELECT dc_dobovo_room_categories_link.*  FROM dc_dobovo_room_categories_link ";
			$query = $this->db->query($sql);
			if ($query->num_rows() > 0) {
				foreach ($query->result() as $row) {
					if (isset($freeRooms[$row->dc_category_id])) {
						
						foreach ($freeRooms[$row->dc_category_id] as $cell) {
								array_push($roomsresult, array(
									"avail" => $cell["free"],
									"dfrom" => $cell["from"],
									"dto" => $cell["to"],
									"room_id" => $cell["dc_room_id"]
								));
						}
					}
				}
			}
			
			$params = $this->dcm_dobovo->getauthparam();
			$result_data = array();
			$result_data ["action"] = "update_data";
			$result_data ["hotel_auth"]["channelmanager_token"] = $params["channelmanager_token"];
			$result_data ["hotel_auth"]["hotel_id"] = $params["dc_hotel_id"];
			
			$result_data ["cm_auth"]["api_key"] = $params["api_key"];
			$result_data ["cm_auth"]["channelmanager_name"] = $params["channelmanager_name"];
			
			$result_data ["data"]["availability"] = $roomsresult;
			
			
			if (1) {
			    echo "+++++++<pre>";
			print_r($roomsresult);
			echo "+++++++<pre>";
			}
			
	
			if (count($roomsresult) < 1) {
			    //die("debug mode!!!");
				$query = $this->db->query("DELETE FROM dc_log WHERE dc_id = 19");
				$data_return["response"] = 4;
				return $data_return;
			}
			$txt = json_encode($result_data);
			//$url = "http://dev.dobovo.com/api/channelmanager/connect";
			$url = $params["url"];
			$data_result = $this->Curl_model->CurlPlugRAW ( $txt, $url, 19, array("returntype" => "array") );
			
			// $data_return ["responsebody"] = $result;
			$result_json = $data_result["result"];
			$result = json_decode($result_json, true);
			$dc_log_id = $data_result["dc_log_id"];
			//echo $result;
			//print_r($data_result);
			//die ();
			
			$data_return["dc_log_id"] = $dc_log_id;
			$data_return["datein"] = gmdate("Y-m-d", $min_date * 86400);
			$data_return["dateout"] = gmdate("Y-m-d", $max_date * 86400);
		}
		
		//die("debug mode!!!");
		
		if ($general_update == 0) {
			echo "Ban upload for booking service";
		} else {
			if ($result["code"] == 200) {
				$data_return ["response"] = 1;
				$data_return ["responsebody"] = "success";
				$sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 19 AND time < " . $last_time;
				$query = $this->db->query ( $sql );
			} else {	
				$data_return ["response"] = 0;
				$data_return ["errmsg"] = $result['error'];
				$data_return ["responsebody"] = $result['error'];
				$query = $this->db->query ( "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 19 AND time < " . $last_time );
			}
			return $data_return;
		}
	}
	
	function setavailability_lastchanged_20()
	{
		$general_update = 0;
		$sql = "SELECT int_value FROM dc_dorms_xml_cfg WHERE name LIKE 'general_update'";
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0) {
			$row = $query->row();
			$general_update = $row->int_value;
		}
		$data_return = array();
		if ($general_update == 1) {} else {
			$data_return["response"] = 2;
			return $data_return;
		}
	
		$dc_hms_cat = array();
		$sql = "SELECT dc_dorms_room_categories_link.*  FROM dc_dorms_room_categories_link ";
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$dc_hms_cat[$row->hms_category_id] = $row->dc_category_id;
			}
		}
		
		$dc_room_types = array();
		$sql = "SELECT dc_room_id, room_type  FROM dc_dorms_room_categories";
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$dc_room_types[$row->dc_room_id] = $row->room_type;
			}
		}
	
		$min_date = 0;
		$max_date = 0;
		$categories_rooms_all = array();
		$data_return = array();
		$intdate_today = floor(time() / 86400);
		$last_id = 0;
		$last_time = time();
	
		$sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms  FROM categories
				INNER JOIN dc_log ON dc_log.categoryid = categories.id
				INNER JOIN rooms ON rooms.category_id = categories.id
				WHERE rooms.dc_active=1 AND dc_log.dc_id = 20 AND dc_log.intdate >= " . $intdate_today . "
				GROUP BY dc_log.categoryid, dc_log.intdate";
		$query = $this->db->query($sql);
		// echo $sql;
		// echo "start wait\n";
		// sleep(15);
		// echo "done wait\n";
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				// count_rooms_booking
				if ($min_date == 0) {
					$min_date = $row->log_intdate;
				} else {
					if ($row->log_intdate < $min_date) {
						$min_date = $row->log_intdate;
					}
				}
	
				if ($max_date == 0) {
					$max_date = $row->log_intdate;
				} else {
					if ($row->log_intdate > $max_date) {
						$max_date = $row->log_intdate;
					}
				}
				if (isset($dc_hms_cat[$row->category_id])) {
					$categories_rooms_all[$row->category_id][$row->log_intdate]["dc_room_id"] = $dc_hms_cat[$row->category_id];
				} else {
					$categories_rooms_all[$row->category_id][$row->log_intdate]["dc_room_id"] = 0;
				}
				if (isset($dc_room_types[$dc_hms_cat[$row->category_id]])) {
					$categories_rooms_all[$row->category_id][$row->log_intdate]["base"] = $dc_room_types[$dc_hms_cat[$row->category_id]];
				} else {
					$categories_rooms_all[$row->category_id][$row->log_intdate]["base"] = "";
				}
				$categories_rooms_all[$row->category_id][$row->log_intdate]["free"] = $row->count_rooms;
				$categories_rooms_all[$row->category_id][$row->log_intdate]["date"] = gmdate("Y-m-d", $row->log_intdate * 86400);
	
				$categories_rooms_all[$row->category_id][$row->log_intdate]["from"] = gmdate("Y-m-d", $row->log_intdate * 86400);
				$categories_rooms_all[$row->category_id][$row->log_intdate]["to"] = gmdate("Y-m-d", $row->log_intdate * 86400);
				// $last_id = $row->dc_log_id;
				if ($row->dc_log_id > $last_id) {
					$last_id = $row->dc_log_id;
				}
			}
		} else {
			$data_return["response"] = 3;
			return $data_return;
		}
	
		// echo "<pre>";
		// print_r ( $categories_rooms_all );
		// die();
	
		$categories_rooms_intdate = array();
	
		$sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
FROM  `rooms`
INNER JOIN categories ON categories.id = rooms.category_id
INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
dc_log.categoryid = rooms.category_id
WHERE dc_log.dc_id = 20
GROUP BY deskofdays.intdate, rooms.category_id";
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				// count_rooms_booking
				$categories_rooms_intdate[$row->id][$row->intdate]["free"] = $row->count_rooms;
			}
		}
	
		// echo "<pre>";
		//print_r($categories_rooms_intdate);
	
		
		/*
		 * GET OVERBOOKING_RESERVATIONS_ARRAY
		*/
		$datein_out_mass = $this->dc_model->get_datein_dateout_dc_log(20);
		$overbooking_reservations_array = array();
		if (isset($datein_out_mass["intdatein"])) {
			$overbooking_reservations_array = $this->dc_model->get_overbooking_origincat($datein_out_mass["intdatein"], $datein_out_mass["intdateout"]);
		}
	
		$setrestrict_result = "";
		$result = "";
		$sql = "SELECT int_value FROM dc_dorms_xml_cfg WHERE name LIKE 'general_update'";
		$query = $this->db->query($sql);
		if ($general_update == 1) {
			$category_keys = array_keys($categories_rooms_all);
			foreach ($category_keys as $category_id) {
	
				$sql = "select min, max from dc_dorms_room_categories_link where hms_category_id =" . $category_id;
				$query = $this->db->query($sql);
	
				if ($query->num_rows() > 0) {
					$row2 = $query->row();
					$min = $row2->min;
					$max = $row2->max;
				} else {
					$min = 0;
					$max = 999;
				}
	
				$arr_intdate_keys = array_keys($categories_rooms_all[$category_id]);
				foreach ($arr_intdate_keys as $intdate) {
					if (isset($categories_rooms_intdate[$category_id][$intdate])) {
						$count_overbook_rooms = 0;
						if (isset($overbooking_reservations_array[$category_id][$intdate])) {
							$count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
						}
						$categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
					} else {
						if (isset($overbooking_reservations_array[$category_id][$intdate])) {
							$count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
							$categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $count_overbook_rooms;
						}
					}
	
					if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
						$categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
					} else {
						$categories_rooms_all[$category_id][$intdate]["free"] = 0;
					}
	
					if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
						$categories_rooms_all[$category_id][$intdate]["free"] = $max;
					}
	
					// коррекція к-сті відповідно умовам ф-ї availability_count_correction
					$startdate = $enddate = date("Y-m-d", $intdate*86400);
					$categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
					
					$prev = $intdate - 1;
					if (isset($categories_rooms_all[$category_id][$prev])) {
						$free_1 = $categories_rooms_all[$category_id][$prev]["free"];
						$free_2 = $categories_rooms_all[$category_id][$intdate]["free"];
	
						if ($free_1 == $free_2) {
							$categories_rooms_all[$category_id][$intdate]["from"] = $categories_rooms_all[$category_id][$prev]["from"];
							unset($categories_rooms_all[$category_id][$prev]);
						}
					}
				}
			}
	
			$freeRooms = $categories_rooms_all;
			//echo "<pre>";
			//print_r ( $freeRooms );
			//die();
			$roomsresult = array();
			$sql = "SELECT dc_dorms_room_categories_link.*  FROM dc_dorms_room_categories_link ";
			$query = $this->db->query($sql);
			if ($query->num_rows() > 0) {
				foreach ($query->result() as $row) {
					if (isset($freeRooms[$row->hms_category_id])) {
	
						foreach ($freeRooms[$row->hms_category_id] as $cell) {
							array_push($roomsresult, array(
							"arrival" => $cell["from"],
							"departure" => $cell["to"],
							"room_id" => $cell["dc_room_id"],
							"base" => $cell["base"],
							"avail" => $cell["free"]
							));
						}
					}
				}
			}
			
			//echo "<pre>";
			//print_r ( $roomsresult );
			//die();
			//=============================================
			if (count($roomsresult) < 1) {
				$query = $this->db->query("DELETE FROM dc_log WHERE dc_id = 20");
				$data_return["response"] = 4;
				return $data_return;
			}
			//=============================================
			$url = "https://www.dorms.com/ch/ch/index";
			echo "<pre>";
			
			$params = $this->dcm_dorms->getauthparam();
		    $data = array();
		    $data['channel_auth'] = array();
		    $data['channel_auth']['channel_key'] = $params["channel_key"];
		    $data['auth'] = array();
		    $data['auth']['property_secret'] = $params["property_secret"];
		    $data['auth']['property_id'] = $params["dc_hotel_id"];
			
			$data['action'] = "update_data";
			
			$data['data'] = array();
			$data['data']['currency'] = $params["currency"];
			$data['data']['availability'] = array();

							
			$data ["data"]["availability"] = $roomsresult;
			echo "<pre>";
			print_r($data);
				
	
			
			$txt = json_encode($data);
			$data_result = $this->Curl_model->CurlJson ( $txt, $url, 20, array("returntype" => "array") );

			$result_json = $data_result["result"];
			$result = json_decode($result_json, true);
			$dc_log_id = $data_result["dc_log_id"];
			echo $result;
			print_r($data_result);
			//die ();
				
			$data_return["dc_log_id"] = $dc_log_id;
			$data_return["datein"] = gmdate("Y-m-d", $min_date * 86400);
			$data_return["dateout"] = gmdate("Y-m-d", $max_date * 86400);
		}
	
		if ($general_update == 0) {
			echo "Ban upload for booking service";
		} else {
			if ($result["code"] == 200) {
				$data_return ["response"] = 1;
				$data_return ["responsebody"] = "success";
				$sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 20 AND time < " . $last_time;
				$query = $this->db->query ( $sql );
			} else {
				$data_return ["response"] = 0;
				$data_return ["errmsg"] = $result['error'];
				$data_return ["responsebody"] = $result['error'];
				//$query = $this->db->query ( "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 19 AND time < " . $last_time );
			}
			return $data_return;
		}
	}
	
    function setavailability_lastchanged_6()
    {
        $general_update = 0;
        $sql = "SELECT int_value FROM dc_hotel_inn_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $general_update = $row->int_value;
        }
        $data_return = array();
        if ($general_update == 1) {} else {
            $data_return["response"] = 2;
            return $data_return;
        }
        
        $min_date = 0;
        $max_date = 0;
        $categories_rooms_all = array();
        $data_return = array();
        $intdate_today = floor(time() / 86400);
        $last_id = 0;
        $last_time = time();
        $sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms  FROM categories
				INNER JOIN dc_log ON dc_log.categoryid = categories.id
				INNER JOIN rooms ON rooms.category_id = categories.id
				WHERE rooms.dc_active=1 AND dc_log.dc_id = 6 AND dc_log.intdate >= " . $intdate_today . "
				GROUP BY dc_log.categoryid, dc_log.intdate";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                if ($min_date == 0) {
                    $min_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate < $min_date) {
                        $min_date = $row->log_intdate;
                    }
                }
                
                if ($max_date == 0) {
                    $max_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate > $max_date) {
                        $max_date = $row->log_intdate;
                    }
                }
                
                $categories_rooms_all[$row->category_id][$row->log_intdate]["free"] = $row->count_rooms;
                $categories_rooms_all[$row->category_id][$row->log_intdate]["date"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                // $last_id = $row->dc_log_id;
                if ($row->dc_log_id > $last_id) {
                    $last_id = $row->dc_log_id;
                }
            }
        } else {
            $data_return["response"] = 3;
            return $data_return;
        }
        
        $categories_rooms_intdate = array();
        
        $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
FROM  `rooms` 
INNER JOIN categories ON categories.id = rooms.category_id
INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND 
dc_log.categoryid = rooms.category_id
WHERE dc_log.dc_id = 6
GROUP BY deskofdays.intdate, rooms.category_id";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                $categories_rooms_intdate[$row->id][$row->intdate]["free"] = $row->count_rooms;
            }
        }
        
        /*
         * GET OVERBOOKING_RESERVATIONS_ARRAY
         */
        $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log(6);
        $overbooking_reservations_array = array();
        if (isset($datein_out_mass["intdatein"])) {
            $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat($datein_out_mass["intdatein"], $datein_out_mass["intdateout"]);
        }
        
        // echo "<pre>";
        // print_r($overbooking_reservations_array);
        // die();
        
        /*
         * END GET OVERBOOKING_RESERVATIONS_ARRAY
         */
        
        /*
         * Выгрузка загружености с booking
         */
        
        $setrestrict_result = "";
        $result = "";
        $sql = "SELECT int_value FROM dc_hotel_inn_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        
        if ($general_update == 1) {
            $category_keys = array_keys($categories_rooms_all);
            foreach ($category_keys as $category_id) {
                
                $sql = "select min, max from dc_hotel_inn_rooms_link where category_id =" . $category_id;
                $query = $this->db->query($sql);
                if ($query->num_rows() > 0) {
                    $row2 = $query->row();
                    $min = $row2->min;
                    $max = $row2->max;
                } else {
                    $min = 0;
                    $max = 999;
                }
                
                $arr_intdate_keys = array_keys($categories_rooms_all[$category_id]);
                foreach ($arr_intdate_keys as $intdate) {
                    if (isset($categories_rooms_intdate[$category_id][$intdate])) {
                        $count_overbook_rooms = 0;
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                        }
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
                    } else {}
                    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
                    } else {
                        $categories_rooms_all[$category_id][$intdate]["free"] = 0;
                    }
                    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $max;
                    }
                    
                    // коррекція к-сті відповідно умовам ф-ї availability_count_correction
                    $startdate = $enddate = date("Y-m-d", $intdate*86400);
                    $categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
                }
            }
            
            $freeRooms = $categories_rooms_all;
            // print_r ( $freeRooms );
            $roomslist = array();
            $sql = "SELECT dc_hotel_inn_rooms_link.*  FROM dc_hotel_inn_rooms_link ";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                foreach ($query->result() as $row) {
                    if (isset($freeRooms[$row->category_id])) {
                        array_push($roomslist, array(
                            'dc_room_id' => $row->dc_room_id,
                            'dates' => $freeRooms[$row->category_id]
                        ));
                    }
                }
            }
            // echo "<pre>";
            // print_r ( $roomslist );
            // die ();
            
            if (count($roomslist) < 1) {
                $query = $this->db->query("DELETE FROM dc_log WHERE dc_id = 6");
                $data_return["response"] = 4;
                return $data_return;
            }
            
            $authparam = $this->dcm_hotel_inn->getauthparam();
            $password = $authparam['password'];
            $username = $authparam['username'];
            
            $xml_data = array(
                'dcuser' => $username,
                'dcpwd' => $password,
                'roomslist' => $roomslist
            );
            $xml = $this->parser->parse('templates/dc_hotel_inn_xml_availability_tpl.html', $xml_data, true);
            // echo $xml;
            $url = "https://hotel-inn.ru/api/hotels/xml/availability/";
            $data_result = $this->Curl_model->CurlPlugRAW("xml=" . $xml, $url, 6, array(
                "returntype" => "array"
            ));
            // $data_return ["responsebody"] = $result;
            $result = $data_result["result"];
            $dc_log_id = $data_result["dc_log_id"];
            // echo $result;
            // return $result;
        }
        
        if ($general_update != 0)
            
            // $this->dc_model->Delete_dclog_last_data ( 1 );
            $data_return["dc_log_id"] = $dc_log_id;
        $data_return["datein"] = gmdate("Y-m-d", $min_date * 86400);
        $data_return["dateout"] = gmdate("Y-m-d", $max_date * 86400);
        if ($general_update == 0) {
            echo "Ban upload for booking service";
        } else {
            
            if ((strpos($result, "<ok />") === 0) || (strpos($result, "<ok/>") === 0) || (strpos($result, "<ok></ok>") === 0)) {
                $data_return["response"] = 1;
                $data_return["responsebody"] = "success";
                $query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 6 AND time < " . $last_time);
            } else {
                // temp delete
                $query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 6 AND time < " . $last_time);
                
                $result_arr = new SimpleXMLElement($result);
                // echo "<pre>";
                // print_r($result_arr);
                // die();
                if (isset($result_arr->fault["code"])) {
                    if ($result_arr->fault["code"] == 401) {
                        $result = $result_arr->fault["string"];
                    } else {
                        $result = $result_arr->fault["string"];
                    }
                }
                
                $data_return["response"] = 0;
                $data_return["errmsg"] = $result;
                $data_return["responsebody"] = $result;
            }
            
            return $data_return;
        }
    }

    function setavailability_lastchanged_7_OLD($upload_restrict)
    {
        $general_update = 0;
        $sql = "SELECT int_value FROM dc_oktogo_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $general_update = $row->int_value;
        }
        $data_return = array();
        if ($general_update == 1) {} else {
            $data_return["response"] = 2;
            return $data_return;
        }
        
        $min_date = 0;
        $max_date = 0;
        $categories_rooms_all = array();
        $data_return = array();
        $intdate_today = floor(time() / 86400);
        $last_id = 0;
        $last_time = time();
        $sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms  FROM categories
				INNER JOIN dc_log ON dc_log.categoryid = categories.id
				INNER JOIN rooms ON rooms.category_id = categories.id
				WHERE rooms.dc_active=1 AND dc_log.dc_id = 7 AND dc_log.intdate >= " . $intdate_today . "
				GROUP BY dc_log.categoryid, dc_log.intdate";
        // echo $sql;
        // die();
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                if ($min_date == 0) {
                    $min_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate < $min_date) {
                        $min_date = $row->log_intdate;
                    }
                }
                
                if ($max_date == 0) {
                    $max_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate > $max_date) {
                        $max_date = $row->log_intdate;
                    }
                }
                
                $categories_rooms_all[$row->category_id][$row->log_intdate]["free"] = $row->count_rooms;
                $categories_rooms_all[$row->category_id][$row->log_intdate]["date"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                
                $categories_rooms_all[$row->category_id][$row->log_intdate]["from"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                $categories_rooms_all[$row->category_id][$row->log_intdate]["to"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                // $last_id = $row->dc_log_id;
                if ($row->dc_log_id > $last_id) {
                    $last_id = $row->dc_log_id;
                }
            }
        } else {
            $data_return["response"] = 3;
            return $data_return;
        }
        
        $deskofrate_array = array();
        
        /*
         * $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
         * FROM `rooms`
         * INNER JOIN categories ON categories.id = rooms.category_id
         * INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
         * INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
         * dc_log.categoryid = rooms.category_id
         * WHERE dc_log.dc_id = 7
         * GROUP BY deskofdays.intdate, rooms.category_id";
         */
        $sql = "SELECT dc_log.intdate, deskofrate.closed, deskofrate.minstay, deskofrate.maxstay,
			    deskofrate.minstayarrival, deskofrate.minstaythrought, deskofrate.closedonarrival, deskofrate.closedondeparture,
			    dc_oktogo_rooms_link.dc_room_id as dc_category_id, dc_oktogo_rooms_link.category_id,
				dc_oktogo_rates.dc_rate_id as dc_rate_id FROM dc_log
				INNER JOIN dc_oktogo_rooms_link ON dc_log.categoryid = dc_oktogo_rooms_link.category_id
				INNER JOIN  dc_oktogo_rates ON   dc_oktogo_rates.room_id = dc_oktogo_rooms_link.dc_room_id
				INNER JOIN  dc_oktogo_rates_link ON (dc_oktogo_rates_link.room_id = dc_oktogo_rooms_link.dc_room_id AND dc_oktogo_rates_link.dc_rate_id =  dc_oktogo_rates.dc_rate_id)
				LEFT JOIN deskofrate ON (dc_oktogo_rates_link.restrict_id = deskofrate.rate_id AND dc_log.categoryid = deskofrate.category_id AND dc_log.intdate = deskofrate.intdate)
				WHERE dc_log.dc_id = 7";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                $deskofrate_array[$row->category_id][$row->intdate]["closed"] = $row->closed;
            }
        }
        
        $categories_rooms_intdate = array();
        
        $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
FROM  `rooms`
INNER JOIN categories ON categories.id = rooms.category_id
INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
dc_log.categoryid = rooms.category_id
WHERE dc_log.dc_id = 7
GROUP BY deskofdays.intdate, rooms.category_id";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                $categories_rooms_intdate[$row->id][$row->intdate]["free"] = $row->count_rooms;
            }
        }
        
        /*
         * GET OVERBOOKING_RESERVATIONS_ARRAY
         */
        $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log(7);
        $overbooking_reservations_array = array();
        if (isset($datein_out_mass["intdatein"])) {
            $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat($datein_out_mass["intdatein"], $datein_out_mass["intdateout"]);
        }
        
        // echo "<pre>";
        // print_r($overbooking_reservations_array);
        // die();
        
        /*
         * END GET OVERBOOKING_RESERVATIONS_ARRAY
         */
        
        /*
         * Выгрузка загружености с oktogo
         */
        
        $setrestrict_result = "";
        $result = "";
        
        if ($general_update == 1) {
            $category_keys = array_keys($categories_rooms_all);
            foreach ($category_keys as $category_id) {
                
                $sql = "select min, max from dc_oktogo_rooms_link where category_id =" . $category_id;
                $query = $this->db->query($sql);
                if ($query->num_rows() > 0) {
                    $row2 = $query->row();
                    $min = $row2->min;
                    $max = $row2->max;
                } else {
                    $min = 0;
                    $max = 999;
                }
                
                $arr_intdate_keys = array_keys($categories_rooms_all[$category_id]);
                foreach ($arr_intdate_keys as $intdate) {
                    if (isset($categories_rooms_intdate[$category_id][$intdate])) {
                        $count_overbook_rooms = 0;
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                        }
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
                    } else {}
                    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
                    } else {
                        $categories_rooms_all[$category_id][$intdate]["free"] = 0;
                    }
                    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $max;
                    }
                    
                    $prev = $intdate - 1;
                    if (isset($categories_rooms_all[$category_id][$prev])) {
                        $free_1 = $categories_rooms_all[$category_id][$prev]["free"];
                        $free_2 = $categories_rooms_all[$category_id][$intdate]["free"];
                        
                        if ($free_1 == $free_2) {
                            $categories_rooms_all[$category_id][$intdate]["from"] = $categories_rooms_all[$category_id][$prev]["from"];
                            unset($categories_rooms_all[$category_id][$prev]);
                        }
                    }
                    if ($upload_restrict == 1) {
                        if (isset($deskofrate_array[$category_id][$intdate]["closed"])) {
                            $categories_rooms_all[$category_id][$intdate]["closed"] = "<closed>" . $deskofrate_array[$category_id][$intdate]["closed"] . "</closed>";
                        } else {
                            $categories_rooms_all[$category_id][$intdate]["closed"] = "";
                        }
                    } else {
                        $categories_rooms_all[$category_id][$intdate]["closed"] = "";
                    }
                }
            }
            
            $freeRooms = $categories_rooms_all;
            echo "<pre>";
            print_r($freeRooms);
            die();
            $roomslist = array();
            $sql = "SELECT dc_oktogo_rooms_link.*  FROM dc_oktogo_rooms_link ";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                foreach ($query->result() as $row) {
                    if (isset($freeRooms[$row->category_id])) {
                        array_push($roomslist, array(
                            'dc_room_id' => $row->dc_room_id,
                            'dates' => $freeRooms[$row->category_id]
                        ));
                    }
                }
            }
            // echo "<pre>";
            // print_r ( $roomslist );
            // die ();
            
            if (count($roomslist) < 1) {
                $query = $this->db->query("DELETE FROM dc_log WHERE dc_id = 7");
                $data_return["response"] = 4;
                return $data_return;
            }
            
            $authparam = $this->dcm_oktogo->getauthparam();
            $password = $authparam['password'];
            $username = $authparam['username'];
            
            $xml_data = array(
                'dcuser' => $username,
                'dcpwd' => $password,
                'roomslist' => $roomslist
            );
            $xml = "xml=" . $this->parser->parse('templates/dc_oktogo_xml_availability_fromto_tpl.html', $xml_data, true);
            // echo $xml;
            
            $url = $this->config->item('dc_oktogo_url') . "availability/";
            $special = array();
            $special['auth'] = true;
            $special["returntype"] = "array";
            $data_result = $this->Curl_model->CurlPlugRAW($xml, $url, 7, $special);
            
            // echo $result;
            // return $result;
            $result = $data_result["result"];
            $dc_log_id = $data_result["dc_log_id"];
            $data_return["dc_log_id"] = $dc_log_id;
        }
        
        // echo $result;
        // die();
        
        if ($general_update == 0) {
            echo "Ban upload for booking service";
        } else {
            
            $xml = simplexml_load_string($result);
            if ($xml === false) {
                $data_return["response"] = 0;
                $data_return["errmsg"] = $result;
                $data_return["responsebody"] = $result;
            } else {
                if ($xml->getName() == "ok") {
                    $data_return["response"] = 1;
                    $data_return["responsebody"] = "success";
                    if (isset($xml->warning)) {
                        $data_return["responsebody"] = "success" . "<br>" . $xml->warning;
                    }
                    $query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 7 AND time < " . $last_time);
                }
            }
            
            // if ((strpos ( $result, "<ok />" ) === 0) || (strpos ( $result, "<ok/>" ) === 0) || (strpos ( $result, "<ok></ok>" ) === 0)) {
            // $data_return ["response"] = 1;
            // $data_return ["responsebody"] = "success";
            // $query = $this->db->query ( "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 7" );
            // } else {
            // $data_return ["response"] = 0;
            // $data_return ["errmsg"] = $result;
            // $data_return ["responsebody"] = $result;
            // }
            
            return $data_return;
        }
    }

    function setavailability_lastchanged_7($upload_restrict)
    {
        // fuck OKTOGO
        if ($this->config->item('dc_oktogo_delete_force') == true) {
            $query = $this->db->query("DELETE FROM dc_log WHERE dc_id = 7");
        }
        
        $general_update = 0;
        $sql = "SELECT int_value FROM dc_oktogo_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $general_update = $row->int_value;
        }
        $data_return = array();
        if ($general_update == 1) {} else {
            $data_return["response"] = 2;
            return $data_return;
        }
        
        $min_date = 0;
        $max_date = 0;
        $categories_rooms_all = array();
        $data_return = array();
        $intdate_today = floor(time() / 86400);
        $last_id = 0;
        $last_time = time();
        
        $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log(7);
        
        list ($year, $month, $day) = explode("-", date("Y-m-d"));
        $intdatein_now = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
        if ($intdate_today > $datein_out_mass["intdatein"]) {
            $datein = gmdate("Y-m-d", $intdate_today * 86400);
        } else {
            $datein = gmdate("Y-m-d", $datein_out_mass["intdatein"] * 86400);
        }
        
        $dateout = gmdate("Y-m-d", $datein_out_mass["intdateout"] * 86400);
        
        $sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms  FROM categories
				INNER JOIN dc_log ON dc_log.categoryid = categories.id
				INNER JOIN rooms ON rooms.category_id = categories.id
				WHERE rooms.dc_active=1 AND dc_log.dc_id = 7 AND dc_log.intdate >= " . $intdate_today . "
				GROUP BY dc_log.categoryid, dc_log.intdate";
        // echo $sql;
        // die();
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                if ($min_date == 0) {
                    $min_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate < $min_date) {
                        $min_date = $row->log_intdate;
                    }
                }
                
                if ($max_date == 0) {
                    $max_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate > $max_date) {
                        $max_date = $row->log_intdate;
                    }
                }
                
                $categories_rooms_all[$row->category_id][$row->log_intdate]["free"] = $row->count_rooms;
                $categories_rooms_all[$row->category_id][$row->log_intdate]["date"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                
                $categories_rooms_all[$row->category_id][$row->log_intdate]["from"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                $categories_rooms_all[$row->category_id][$row->log_intdate]["to"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                // $last_id = $row->dc_log_id;
                if ($row->dc_log_id > $last_id) {
                    $last_id = $row->dc_log_id;
                }
            }
        } else {
            $data_return["response"] = 3;
            return $data_return;
        }
        
        $deskofrate_array = array();
        
        /*
         * $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
         * FROM `rooms`
         * INNER JOIN categories ON categories.id = rooms.category_id
         * INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
         * INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
         * dc_log.categoryid = rooms.category_id
         * WHERE dc_log.dc_id = 7
         * GROUP BY deskofdays.intdate, rooms.category_id";
         */
        $sql = "SELECT dc_log.intdate, deskofrate.closed, deskofrate.minstay, deskofrate.maxstay,
			    deskofrate.minstayarrival, deskofrate.minstaythrought, deskofrate.closedonarrival, deskofrate.closedondeparture,
			    dc_oktogo_rooms_link.dc_room_id as dc_category_id, dc_oktogo_rooms_link.category_id,
				dc_oktogo_rates.dc_rate_id as dc_rate_id FROM dc_log
				INNER JOIN dc_oktogo_rooms_link ON dc_log.categoryid = dc_oktogo_rooms_link.category_id
				INNER JOIN  dc_oktogo_rates ON   dc_oktogo_rates.room_id = dc_oktogo_rooms_link.dc_room_id
				INNER JOIN  dc_oktogo_rates_link ON (dc_oktogo_rates_link.room_id = dc_oktogo_rooms_link.dc_room_id AND dc_oktogo_rates_link.dc_rate_id =  dc_oktogo_rates.dc_rate_id)
				LEFT JOIN deskofrate ON (dc_oktogo_rates_link.restrict_id = deskofrate.rate_id AND dc_log.categoryid = deskofrate.category_id AND dc_log.intdate = deskofrate.intdate)
				WHERE dc_log.dc_id = 7";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                $deskofrate_array[$row->category_id][$row->intdate]["closed"] = $row->closed;
            }
        }
        // echo "<pre>";
        // print_r ( $deskofrate_array );
        // die();
        $categories_rooms_intdate = array();
        
        $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
FROM  `rooms`
INNER JOIN categories ON categories.id = rooms.category_id
INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
dc_log.categoryid = rooms.category_id
WHERE dc_log.dc_id = 7
GROUP BY deskofdays.intdate, rooms.category_id";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                $categories_rooms_intdate[$row->id][$row->intdate]["free"] = $row->count_rooms;
            }
        }
        
        /*
         * GET OVERBOOKING_RESERVATIONS_ARRAY
         */
        $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log(7);
        $overbooking_reservations_array = array();
        if (isset($datein_out_mass["intdatein"])) {
            $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat($datein_out_mass["intdatein"], $datein_out_mass["intdateout"]);
        }
        
        // echo "<pre>";
        // print_r($overbooking_reservations_array);
        // die();
        
        /*
         * END GET OVERBOOKING_RESERVATIONS_ARRAY
         */
        
        /*
         * Выгрузка загружености с oktogo
         */
        
        $setrestrict_result = "";
        $result = "";
        
        if ($general_update == 1) {
            $category_keys = array_keys($categories_rooms_all);
            foreach ($category_keys as $category_id) {
                
                $sql = "select min, max from dc_oktogo_rooms_link where category_id =" . $category_id;
                $query = $this->db->query($sql);
                if ($query->num_rows() > 0) {
                    $row2 = $query->row();
                    $min = $row2->min;
                    $max = $row2->max;
                } else {
                    $min = 0;
                    $max = 999;
                }
                
                $arr_intdate_keys = array_keys($categories_rooms_all[$category_id]);
                foreach ($arr_intdate_keys as $intdate) {
                    if (isset($categories_rooms_intdate[$category_id][$intdate])) {
                        $count_overbook_rooms = 0;
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                        }
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
                    } else {}
                    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
                    } else {
                        $categories_rooms_all[$category_id][$intdate]["free"] = 0;
                    }
                    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $max;
                    }
                    
                    // коррекція к-сті відповідно умовам ф-ї availability_count_correction
                    $startdate = $enddate = date("Y-m-d", $intdate*86400);
                    $categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
                    
                    if ($upload_restrict == 1) {
                        if (isset($deskofrate_array[$category_id][$intdate]["closed"])) {
                            $categories_rooms_all[$category_id][$intdate]["closed"] = "<closed>" . $deskofrate_array[$category_id][$intdate]["closed"] . "</closed>";
                        } else {
                            $categories_rooms_all[$category_id][$intdate]["closed"] = "<closed>0</closed>";
                        }
                    } else {
                        $categories_rooms_all[$category_id][$intdate]["closed"] = "<closed>0</closed>";
                    }
                    
                    $prev = $intdate - 1;
                    if (isset($categories_rooms_all[$category_id][$prev])) {
                        $free_1 = $categories_rooms_all[$category_id][$prev]["free"];
                        $free_2 = $categories_rooms_all[$category_id][$intdate]["free"];
                        
                        $closed_1 = $categories_rooms_all[$category_id][$prev]["closed"];
                        $closed_2 = $categories_rooms_all[$category_id][$intdate]["closed"];
                        
                        if ($free_1 == $free_2 && $closed_1 == $closed_2) {
                            $categories_rooms_all[$category_id][$intdate]["from"] = $categories_rooms_all[$category_id][$prev]["from"];
                            unset($categories_rooms_all[$category_id][$prev]);
                        }
                    }
                }
            }
            
            $freeRooms = $categories_rooms_all;
            // echo "<pre>";
            // print_r ( $freeRooms );
            // die();
            $roomslist = array();
            $sql = "SELECT dc_oktogo_rooms_link.*  FROM dc_oktogo_rooms_link ";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                foreach ($query->result() as $row) {
                    if (isset($freeRooms[$row->category_id])) {
                        array_push($roomslist, array(
                            'dc_room_id' => $row->dc_room_id,
                            'dates' => $freeRooms[$row->category_id]
                        ));
                    }
                }
            }
            // echo "<pre>";
            // print_r ( $roomslist );
            // die ();
            
            if (count($roomslist) < 1) {
                $query = $this->db->query("DELETE FROM dc_log WHERE dc_id = 7");
                $data_return["response"] = 4;
                return $data_return;
            }
            
            $authparam = $this->dcm_oktogo->getauthparam();
            $url = $authparam ['url']."/availability";
            $password = $authparam['password'];
            $username = $authparam['username'];
            
            $xml_data = array(
                'dcuser' => $username,
                'dcpwd' => $password,
                'roomslist' => $roomslist
            );
            $xml = "xml=" . $this->parser->parse('templates/dc_oktogo_xml_availability_fromto_tpl.html', $xml_data, true);
            // echo $xml;
            
            //$url = $this->config->item('dc_oktogo_url') . "availability/";
            $special = array();
            $special['auth'] = true;
            $special["returntype"] = "array";
            $data_result = $this->Curl_model->CurlPlugRAW($xml, $url, 7, $special);
            
            // echo $result;
            // return $result;
            $result = $data_result["result"];
            $dc_log_id = $data_result["dc_log_id"];
            $data_return["dc_log_id"] = $dc_log_id;
        }
        
        // echo $result;
        // die();
        
        $data_return["datein"] = $datein;
        $data_return["dateout"] = $dateout;
        
        if ($general_update == 0) {
            echo "Ban upload for booking service";
        } else {
            
            $xml = simplexml_load_string($result);
            if ($xml === false) {
                $data_return["response"] = 0;
                $data_return["errmsg"] = $result;
                $data_return["responsebody"] = $result;
                $query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 7 AND time < " . $last_time);
            } else {
                if ($xml->getName() == "ok") {
                    $data_return["response"] = 1;
                    $data_return["responsebody"] = "success";
                    if (isset($xml->warning)) {
                        $data_return["responsebody"] = "success" . "<br>" . $xml->warning;
                    }
                    $query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 7 AND time < " . $last_time);
                } else {
                    $data_return["response"] = 0;
                    $data_return["responsebody"] = $result;
                    $query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 7 AND time < " . $last_time);
                }
            }
            
            // if ((strpos ( $result, "<ok />" ) === 0) || (strpos ( $result, "<ok/>" ) === 0) || (strpos ( $result, "<ok></ok>" ) === 0)) {
            // $data_return ["response"] = 1;
            // $data_return ["responsebody"] = "success";
            // $query = $this->db->query ( "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 7" );
            // } else {
            // $data_return ["response"] = 0;
            // $data_return ["errmsg"] = $result;
            // $data_return ["responsebody"] = $result;
            // }
            // print_r ( $data_return );
            return $data_return;
        }
    }
    
    function setavailability_lastchanged_34($dc_account_id = 0) {
	    $auth_data = $this->dcm_ctrip->getauthparam($dc_account_id);
	    $hotel_id = $auth_data['hotel_id'];
	    $dc_id = 34;
	    
	    $limit_array = $this->frontdesk->get_dc_log_limit_array ();
	    $ctrip_uploadperiod = $limit_array[$dc_id];
    
        $general_update = 0;
        $sql = "SELECT int_value FROM dc_ctrip_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $general_update = $row->int_value;
        }
        $data_return = array();
        if ($general_update == 1) {} else {
            $data_return["response"] = 2;
            return $data_return;
        }
        $min_date = 0;
        $max_date = 0;
        $categories_rooms_all_ctrip = array();
        $intdate_today = floor(time() / 86400);
        $last_id = 0;
        $last_time = time();
        $sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms  FROM categories
        INNER JOIN dc_log ON dc_log.categoryid = categories.id
        INNER JOIN rooms ON rooms.category_id = categories.id
        WHERE rooms.dc_active=1 AND dc_log.dc_id = 34 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.intdate >= " . $intdate_today . "
		GROUP BY dc_log.categoryid, dc_log.intdate";
        echo $sql."<br><br>";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_ctrip
                if ($min_date == 0) {
                    $min_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate < $min_date) {
                        $min_date = $row->log_intdate;
                    }
                }
    
                if ($max_date == 0) {
                    $max_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate > $max_date) {
                        $max_date = $row->log_intdate;
                    }
                }
    
                $categories_rooms_all_ctrip[$row->category_id][$row->log_intdate]["count"] = $row->count_rooms;
                $categories_rooms_all_ctrip[$row->category_id][$row->log_intdate]["date"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                if ($row->dc_log_id > $last_id) {
                    $last_id = $row->dc_log_id;
                }
            }
        } else {
    
            $data_return["response"] = 3;
            return $data_return;
        }
    
        $categories_rooms_intdate_ctrip = array();
        $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
        FROM  `rooms`
        INNER JOIN categories ON categories.id = rooms.category_id
        INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
        INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
        dc_log.categoryid = rooms.category_id
        WHERE dc_log.dc_id = 34 AND dc_log.dc_hotel_id = $hotel_id
        GROUP BY deskofdays.intdate, rooms.category_id";
    
        //echo $sql."<br>";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_ctrip
                $categories_rooms_intdate_ctrip[$row->id][$row->intdate] = $row->count_rooms;
            }
        }

    
        $ctrip_result = array();
        if ($general_update == 1) {
    
            $dc_rooms = array();
            $sql = "SELECT  dc_ctrip_room_categories_link.*  FROM  dc_ctrip_room_categories_link
            INNER JOIN dc_ctrip_room_categories ON dc_ctrip_room_categories.id = dc_ctrip_room_categories_link.dc_category_id AND dc_ctrip_room_categories.hotel = ".$hotel_id;
            //echo $sql;
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                foreach ($query->result() as $row) {
                    $dc_rooms[$row->hms_category_id] = $row->dc_category_id;
                }
            }

            $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log( 34 );
            $overbooking_reservations_array = array();
            if (isset($datein_out_mass["intdatein"])) {
                $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat($datein_out_mass["intdatein"], $datein_out_mass["intdateout"]);
            }

            $category_keys = array_keys($categories_rooms_all_ctrip);
            $roomsresult = array();
            foreach ($category_keys as $category_id) {
    
                $sql = "select min, max from dc_ctrip_room_categories_link where hms_category_id =" . $category_id;
                $query = $this->db->query($sql);
                if ($query->num_rows() > 0) {
                    $row2 = $query->row();
                    $min = $row2->min;
                    $max = $row2->max;
                } else {
                    $min = 0;
                    $max = 999;
                }
    
                if (! isset($dc_rooms[$category_id])) {
                    unset($categories_rooms_all_ctrip[$category_id]);
                    continue;
                }
                $arr_intdate_keys = array_keys($categories_rooms_all_ctrip[$category_id]);
                foreach ($arr_intdate_keys as $intdate) {
                    if (isset($categories_rooms_intdate_ctrip[$category_id][$intdate])) {
                        $count_overbook_rooms = 0;
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                        }
                        $categories_rooms_all_ctrip[$category_id][$intdate]["count"] = $categories_rooms_all_ctrip[$category_id][$intdate]["count"] - ($categories_rooms_intdate_ctrip[$category_id][$intdate] + $count_overbook_rooms);
                    } else {
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                            $categories_rooms_all_ctrip[$category_id][$intdate]["count"] = $categories_rooms_all_ctrip[$category_id][$intdate]["count"] - $count_overbook_rooms;
                        }
                    }
    
                    if ($categories_rooms_all_ctrip[$category_id][$intdate]["count"] > $min) {
                        $categories_rooms_all_ctrip[$category_id][$intdate]["count"] = $categories_rooms_all_ctrip[$category_id][$intdate]["count"] - $min;
                    } else {
                        $categories_rooms_all_ctrip[$category_id][$intdate]["count"] = 0;
                    }
    
                    if ($categories_rooms_all_ctrip[$category_id][$intdate]["count"] > $max) {
                        $categories_rooms_all_ctrip[$category_id][$intdate]["count"] = $max;
                    }
    
                    // коррекція к-сті відповідно умовам ф-ї availability_count_correction
                    $startdate = $enddate = date("Y-m-d", $intdate*86400);
                    $categories_rooms_all_ctrip[$category_id][$intdate]["count"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all_ctrip[$category_id][$intdate]["count"], $startdate, $enddate);
    
                    $categories_rooms_all_ctrip[$category_id][$intdate]['plan_date_start_at'] = gmdate("Y-m-d", $intdate * 86400);
                    $categories_rooms_all_ctrip[$category_id][$intdate]['plan_date_end_at'] = gmdate("Y-m-d", $intdate * 86400);
    
                    $categories_rooms_all_ctrip[$category_id][$intdate]['room_category'] = $dc_rooms[$category_id];
                    $categories_rooms_all_ctrip[$category_id][$intdate]['hotel'] = $hotel_id;
                    ksort($categories_rooms_all_ctrip[$category_id][$intdate]);
                    if (true) {
                        $prev = $intdate - 1;
                        if (isset($categories_rooms_all_ctrip[$category_id][$prev])) {
                            $free_1 = $categories_rooms_all_ctrip[$category_id][$prev]["count"];
                            $free_2 = $categories_rooms_all_ctrip[$category_id][$intdate]["count"];
    
                            if ($free_1 == $free_2) {
                                $categories_rooms_all_ctrip[$category_id][$intdate]["plan_date_start_at"] = $categories_rooms_all_ctrip[$category_id][$prev]["plan_date_start_at"];
                                unset($categories_rooms_all_ctrip[$category_id][$prev]);
                            }
                        }
                    }
                }
            }
            if (true) {
                $category_keys = array_keys($categories_rooms_all_ctrip);
                $roomsresult = array();
                foreach ($category_keys as $category_id) {
                    $intday_keys = array_keys($categories_rooms_all_ctrip[$category_id]);
                    foreach ($intday_keys as $intdate) {
                        if (isset($categories_rooms_all_ctrip[$category_id][$intdate]))
                            array_push($roomsresult, $categories_rooms_all_ctrip[$category_id][$intdate]);
                    }
                }
            }
    
    
    
            $request_data = array();
            $request_data ['id'] = $auth_data['id'];
            $request_data ['password'] = $auth_data['password'];
            $request_data ['codecontext'] = $auth_data['codecontext'];
            $request_data ['timestamp'] = $auth_data['timestamp'];
            $request_data ['hotel_id'] = $hotel_id;
            $request_data ['avail_data'] = $roomsresult;
            echo "<pre>";
            print_r ( $request_data );
            //die();
            if (count($roomsresult) < 1) {
                $query = $this->db->query("DELETE FROM dc_log WHERE dc_id = 34 AND dc_log.dc_hotel_id = $hotel_id");
                $data_return["response"] = 4;
                return $data_return;
            }
            $ctrip_result = array();
    

            $request = $this->parser->parse ( 'templates/dc_ctrip/get_availability.html', $request_data, true );
            //echo $request;
            $data_result = $this->Curl_model->CurlPlugRaw_ctrip($request, $auth_data['url_get_availability']);

             $result_xml = $data_result['result'];
             
             $response = simplexml_load_string($result_xml, "SimpleXMLElement", LIBXML_NOCDATA);
             $response = json_decode( json_encode($response), true );
             echo '<pre>';
             print_r($response);
             //die();

            $dc_log_id = $data_result["dc_log_id"];
            $data_return["dc_log_id"] = $dc_log_id;
            $data_return["datein"] = gmdate("Y-m-d", $min_date * 86400);
            $data_return["dateout"] = gmdate("Y-m-d", $max_date * 86400);
    
            if (isset($response['Success'])) {
                $data_return["response"] = 1;
                $data_return["responsebody"] = "success";
                $query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_log.dc_hotel_id = ".$hotel_id." AND dc_id = 34 AND time < " . $last_time);      
            } else {
                $data_return["response"] = 0;
                $data_return["errmsg"] = print_r($response['Errors'], true);
                $data_return["responsebody"] = $response['origin'];
                
            }
        }
        
        if ($general_update == 0) {
            echo "Ban upload for booking service";
        } else {
            return $data_return;
        }
    }

    function setavailability_lastchanged_2($hotel_id = 0, $clearlog = 0)
    {
        
        if ($clearlog) {
            $query = $this->db->query("DELETE FROM dc_log WHERE dc_id = 2 AND dc_log.dc_hotel_id = $hotel_id");
        }
        
        $general_update = 0;
        $sql = "SELECT int_value FROM dc_ostrovok_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $general_update = $row->int_value;
        }
        $data_return = array();
        if ($general_update == 1) {} else {
            $data_return["response"] = 2;
            return $data_return;
        }
        $min_date = 0;
        $max_date = 0;
        $categories_rooms_all_ostrovok = array();
        $intdate_today = floor(time() / 86400);
        $last_id = 0;
        $last_time = time();
        $sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms  FROM categories
				INNER JOIN dc_log ON dc_log.categoryid = categories.id
				INNER JOIN rooms ON rooms.category_id = categories.id
				WHERE rooms.dc_active=1 AND dc_log.dc_id = 2 AND dc_log.dc_hotel_id = $hotel_id AND dc_log.intdate >= " . $intdate_today . " 
				GROUP BY dc_log.categoryid, dc_log.intdate";
        echo $sql."<br><br>";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_ostrovok
                if ($min_date == 0) {
                    $min_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate < $min_date) {
                        $min_date = $row->log_intdate;
                    }
                }
                
                if ($max_date == 0) {
                    $max_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate > $max_date) {
                        $max_date = $row->log_intdate;
                    }
                }
                
                $categories_rooms_all_ostrovok[$row->category_id][$row->log_intdate]["count"] = $row->count_rooms;
                $categories_rooms_all_ostrovok[$row->category_id][$row->log_intdate]["date"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                if ($row->dc_log_id > $last_id) {
                    $last_id = $row->dc_log_id;
                }
            }
        } else {
            $sql = "DELETE FROM dc_log WHERE dc_id = 2 AND dc_hotel_id = $hotel_id";
            $query = $this->db->query ( $sql );
            
            $data_return["response"] = 3;
            return $data_return;
        }
        
        $categories_rooms_intdate_ostrovok = array();
        $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
FROM  `rooms` 
INNER JOIN categories ON categories.id = rooms.category_id
INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND 
dc_log.categoryid = rooms.category_id
WHERE dc_log.dc_id = 2 AND dc_log.dc_hotel_id = $hotel_id  
GROUP BY deskofdays.intdate, rooms.category_id";
        
         //echo $sql."<br>";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_ostrovok
                $categories_rooms_intdate_ostrovok[$row->id][$row->intdate] = $row->count_rooms;
            }
        }
        
        /*
         * Выгрузка загружености с ostrovok
         */
        
        $ostrovok_result = array();
        if ($general_update == 1) {
            
            $dc_rooms = array();
            $sql = "SELECT  dc_ostrovok_room_categories_link.*  FROM  dc_ostrovok_room_categories_link 
            INNER JOIN dc_ostrovok_room_categories ON dc_ostrovok_room_categories.id = dc_ostrovok_room_categories_link.dc_category_id AND dc_ostrovok_room_categories.hotel = ".$hotel_id;
            //echo $sql;
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                foreach ($query->result() as $row) {
                    $dc_rooms[$row->hms_category_id] = $row->dc_category_id;
                }
            }
            
            /*
             * GET OVERBOOKING_RESERVATIONS_ARRAY
             */
            
            $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log(2);
            $overbooking_reservations_array = array();
            if (isset($datein_out_mass["intdatein"])) {
                $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat($datein_out_mass["intdatein"], $datein_out_mass["intdateout"]);
            }
            
            // echo "<pre>";
            // print_r($overbooking_reservations_array);
            // die();
            
            /*
             * END GET OVERBOOKING_RESERVATIONS_ARRAY
             */
            
            $category_keys = array_keys($categories_rooms_all_ostrovok);
            $roomsresult = array();
            foreach ($category_keys as $category_id) {
                if (! isset($dc_rooms[$category_id])) {
                    unset($categories_rooms_all_ostrovok[$category_id]);
                    continue;
                }
                
                $sql = "select min, max from dc_ostrovok_room_categories_link where dc_category_id = " . $dc_rooms[$category_id];
                $query = $this->db->query($sql);
                if ($query->num_rows() > 0) {
                    $row2 = $query->row();
                    $min = $row2->min;
                    $max = $row2->max;
                } else {
                    $min = 0;
                    $max = 999;
                }
                
                $arr_intdate_keys = array_keys($categories_rooms_all_ostrovok[$category_id]);
                foreach ($arr_intdate_keys as $intdate) {                    
                    if (isset($categories_rooms_intdate_ostrovok[$category_id][$intdate])) {
                        $count_overbook_rooms = 0;
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {                            
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                        }
                        $categories_rooms_all_ostrovok[$category_id][$intdate]["count"] = $categories_rooms_all_ostrovok[$category_id][$intdate]["count"] - ($categories_rooms_intdate_ostrovok[$category_id][$intdate] + $count_overbook_rooms);
                    } else {                        
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                            $categories_rooms_all_ostrovok[$category_id][$intdate]["count"] = $categories_rooms_all_ostrovok[$category_id][$intdate]["count"] - $count_overbook_rooms;
                        }
                    }
                    
                    if ($categories_rooms_all_ostrovok[$category_id][$intdate]["count"] > $min) {
                        $categories_rooms_all_ostrovok[$category_id][$intdate]["count"] = $categories_rooms_all_ostrovok[$category_id][$intdate]["count"] - $min;
                    } else {
                        $categories_rooms_all_ostrovok[$category_id][$intdate]["count"] = 0;
                    }
                    
                    if ($categories_rooms_all_ostrovok[$category_id][$intdate]["count"] > $max) {
                        $categories_rooms_all_ostrovok[$category_id][$intdate]["count"] = $max;
                    }
                    
                    // коррекція к-сті відповідно умовам ф-ї availability_count_correction
                    $startdate = $enddate = date("Y-m-d", $intdate*86400);
                    $categories_rooms_all_ostrovok[$category_id][$intdate]["count"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all_ostrovok[$category_id][$intdate]["count"], $startdate, $enddate);
                    
                    $categories_rooms_all_ostrovok[$category_id][$intdate]['plan_date_start_at'] = gmdate("Y-m-d", $intdate * 86400);
                    $categories_rooms_all_ostrovok[$category_id][$intdate]['plan_date_end_at'] = gmdate("Y-m-d", $intdate * 86400);
                    
                    $categories_rooms_all_ostrovok[$category_id][$intdate]['room_category'] = $dc_rooms[$category_id];
                    $categories_rooms_all_ostrovok[$category_id][$intdate]['hotel'] = $hotel_id;
                    ksort($categories_rooms_all_ostrovok[$category_id][$intdate]);
                    if (true) {
                        $prev = $intdate - 1;
                        if (isset($categories_rooms_all_ostrovok[$category_id][$prev])) {
                            $free_1 = $categories_rooms_all_ostrovok[$category_id][$prev]["count"];
                            $free_2 = $categories_rooms_all_ostrovok[$category_id][$intdate]["count"];
                            
                            if ($free_1 == $free_2) {
                                $categories_rooms_all_ostrovok[$category_id][$intdate]["plan_date_start_at"] = $categories_rooms_all_ostrovok[$category_id][$prev]["plan_date_start_at"];
                                unset($categories_rooms_all_ostrovok[$category_id][$prev]);
                            }
                        }
                    }
                    
                    // array_push ( $roomsresult, $categories_rooms_all_ostrovok [$category_id] [$intdate] );
                }
            }
            if (true) {
                $category_keys = array_keys($categories_rooms_all_ostrovok);
                $roomsresult = array();
                foreach ($category_keys as $category_id) {
                    $intday_keys = array_keys($categories_rooms_all_ostrovok[$category_id]);
                    foreach ($intday_keys as $intdate) {
                        if (isset($categories_rooms_all_ostrovok[$category_id][$intdate]))
                            array_push($roomsresult, $categories_rooms_all_ostrovok[$category_id][$intdate]);
                    }
                }
            }
            
            
            
            $rooms = $roomsresult;
            
             echo "<pre>";
            // print_r ( $restrict );
             print_r ( $rooms );
            // die();
            // print_r($rooms);
            if (count($rooms) < 1) {
                $query = $this->db->query("DELETE FROM dc_log WHERE dc_id = 2 AND dc_log.dc_hotel_id = $hotel_id");
                $data_return["response"] = 4;
                return $data_return;
            }
            $ostrovok_result = array();
            
             $other_data = array('categories_rooms_intdate_ostrovok' => $categories_rooms_intdate_ostrovok, 
                'categories_rooms_all_ostrovok' => $categories_rooms_all_ostrovok
            );
            $data_result = $this->dc_ostrovok_model->update_rooms($rooms, array(), 1, $other_data);
            // $data_return ["responsebody"] = $response;
             echo "<pre>+++++";
             print_r ( $data_result );
            // die();
            $response = $data_result["result"];
            $dc_log_id = $data_result["dc_log_id"];
            $data_return["dc_log_id"] = $dc_log_id;
            $data_return["datein"] = gmdate("Y-m-d", $min_date * 86400);
            $data_return["dateout"] = gmdate("Y-m-d", $max_date * 86400);
            
            if (isset($response['error'])) {
                $data_return["response"] = 0;
                if (is_array($response['origin'])) {
                    $data_return["errmsg"] = print_r($response['origin'], true);
                } else {
                    $data_return["errmsg"] = $response['origin'];
                }
                $data_return["responsebody"] = $response['origin'];
                array_push($ostrovok_result, array(
                    "cell" => "Ostrovok.ru: выгрузка с ошибками - " . $response['origin']
                ));
                
                if ($response['origin']['http_code'] == 401 || $response['origin']['http_code'] == 400) {
                    echo "clear queue on ERROR 401\n";
                    $query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_log.dc_hotel_id = ".$hotel_id ." AND dc_id = 2 AND time < " . $last_time);
                }
            } else {
                if (isset($response['rate_plans'])) {
                    array_push($ostrovok_result, array(
                        "cell" => "Ostrovok.ru: Ограничения выгружены успешно (" . $response['rate_plans']['updated'] . ")"
                    ));
                }
                if (isset($response['room_categories'])) {
                    array_push($ostrovok_result, array(
                        "cell" => "Ostrovok.ru: Номера выгружены успешно (" . $response['room_categories']['updated'] . ")"
                    ));
                }
                if (sizeof($ostrovok_result) == 0) {
                    $data_return["response"] = 0;
                    if (isset($response["origin"])) {
                        if (is_array($response['origin'])) {
                            $data_return["errmsg"] = print_r($response['origin'], true);
                        } else {
                            $data_return["errmsg"] = $response['origin'];
                        }
                        $data_return["responsebody"] = $response["origin"];
                    } else {
                        if (is_array($response['origin'])) {
                            $data_return["errmsg"] = print_r($response['origin'], true);
                        } else {
                            $data_return["errmsg"] = $response['origin'];
                        }
                        $data_return["responsebody"] = $response;
                    }
                } else {
                    $data_return["response"] = 1;
                    $data_return["responsebody"] = "success";
                    // DEBUG
                    $query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_log.dc_hotel_id = ".$hotel_id." AND dc_id = 2 AND time < " . $last_time);
                }
                // $this->dc_model->Delete_dclog_last_data ( 2 );
            }
        }
        if ($general_update != 0)
            // $query = $this->db->query ( "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 2" );
            if ($general_update == 0) {
                echo "Ban upload for booking service";
            } else {
                return $data_return;
            }
    }
    function setavailability_lastchanged_3_multy($dc_account_id){
        
        
        $dc_hotel_id = $this->dcm_expedia->gethotelid($dc_account_id);
        
		$debug = false;
		$general_update = 0;
		$sql = "SELECT int_value FROM dc_expedia_xml_cfg WHERE name LIKE 'general_update'";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$general_update = $row->int_value;
		}
		
		$data_return = array ();
		if ($general_update == 1) {
		} else {
			$data_return ["response"] = 2;
			return $data_return;
		}
		
		$sql = "SELECT value FROM hotelix_config WHERE name LIKE 'expedia_uploadperiod'";
		$query = $this->db->query ( $sql );
		
		if ($query->num_rows () > 0) {
			$row = $query->row_array ();
			
			$expedia_uploadperiod = $row ["value"];
		} else {
			$expedia_uploadperiod = 180;
			$sql = "INSERT INTO hotelix_config (name, value) VALUES('expedia_uploadperiod', " . $expedia_uploadperiod . ") ON DUPLICATE KEY UPDATE value = " . $expedia_uploadperiod;
			$query = $this->db->query ( $sql );
		}
		
		$expedia_result = array ();
		
		// $intdate_today = round ( time () / 86400 );
		
		// echo $intdate_today . " ---\n";
		$min_date = 0;
		$max_date = 0;
		$categories_rooms_all_expedia = array ();
		$intdate_today = floor ( time () / 86400 );
		$last_id = 0;
		$last_time = time ();

		$sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms  FROM categories
				INNER JOIN dc_log ON dc_log.categoryid = categories.id
				INNER JOIN dc_expedia_room_categories_link ON dc_expedia_room_categories_link.hms_category_id = dc_log.categoryid
				INNER JOIN dc_expedia_room_categories ON dc_expedia_room_categories_link.dc_category_id = dc_expedia_room_categories.id
				INNER JOIN rooms ON rooms.category_id = categories.id
				WHERE rooms.dc_active = 1 AND dc_log.dc_id = 3 AND dc_log.intdate >= " . $intdate_today . " AND dc_expedia_room_categories.dc_hotel_id = ".$dc_hotel_id."
				GROUP BY dc_log.categoryid, dc_log.intdate ORDER BY dc_log.id, dc_log.intdate  LIMIT 0, " . $expedia_uploadperiod;
		if ($debug) {
		    echo "<br><br><br>";
			echo $sql . "<br><br><br>";
		}
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				// count_rooms_expedia
				if ($min_date == 0) {
					$min_date = $row->log_intdate;
				} else {
					if ($row->log_intdate < $min_date) {
						$min_date = $row->log_intdate;
					}
				}
				
				if ($max_date == 0) {
					$max_date = $row->log_intdate;
				} else {
					if ($row->log_intdate > $max_date) {
						$max_date = $row->log_intdate;
					}
				}
				
				$categories_rooms_all_expedia [$row->category_id] [$row->log_intdate] ["count"] = $row->count_rooms;
				$categories_rooms_all_expedia [$row->category_id] [$row->log_intdate] ["date"] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
				
				$categories_rooms_all_expedia [$row->category_id] [$row->log_intdate] ['plan_date_start_at'] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
				$categories_rooms_all_expedia [$row->category_id] [$row->log_intdate] ['plan_date_end_at'] = gmdate ( "Y-m-d", $row->log_intdate * 86400 );
				if ($row->dc_log_id > $last_id) {
					$last_id = $row->dc_log_id;
				}
			}
		} else {
		    $sql = "SELECT MAX(dc_log.id) as max_id
		        FROM categories
				INNER JOIN dc_log ON dc_log.categoryid = categories.id
				INNER JOIN dc_expedia_room_categories_link ON dc_expedia_room_categories_link.hms_category_id = dc_log.categoryid
				INNER JOIN dc_expedia_room_categories ON dc_expedia_room_categories_link.dc_category_id = dc_expedia_room_categories.id
				INNER JOIN rooms ON rooms.category_id = categories.id
				ORDER BY dc_log.id, dc_log.intdate";
		    
		    $query = $this->db->query ( $sql );
		    if ($query->num_rows () > 0) {
		        $row = $query->row_array ();
		        	
		        $last_id = (int)$row ["max_id"];
		    }
		    
		    $sql = "DELETE dc_log FROM dc_log
			 INNER JOIN dc_expedia_room_categories_link ON dc_expedia_room_categories_link.hms_category_id = dc_log.categoryid
			 INNER JOIN dc_expedia_room_categories ON dc_expedia_room_categories_link.dc_category_id = dc_expedia_room_categories.id
			 WHERE dc_log.id <= " . $last_id . " AND dc_log.dc_id = 3 AND dc_expedia_room_categories.dc_hotel_id = ".$dc_hotel_id;
		    $query = $this->db->query ( $sql );
		    
			$data_return ["response"] = 3;
			return $data_return;
		}
		//echo "<pre>";
		if ($debug) {
			print_r ( $categories_rooms_all_expedia );
		}
		
		// echo $sql;
		
		$categories_rooms_intdate_expedia = array ();
		$sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
		FROM `rooms`
		INNER JOIN categories ON categories.id = rooms.category_id
		INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
		INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
dc_log.categoryid = rooms.category_id
		INNER JOIN dc_expedia_room_categories_link ON dc_expedia_room_categories_link.hms_category_id = dc_log.categoryid
		INNER JOIN dc_expedia_room_categories ON dc_expedia_room_categories_link.dc_category_id = dc_expedia_room_categories.id
		WHERE dc_log.dc_id = 3 AND dc_log.intdate >= " . $intdate_today . "
		GROUP BY deskofdays.intdate, rooms.category_id ORDER BY dc_log.id, dc_log.intdate";
		
		$sql2 = "SELECT categories.id, dc_log.intdate, COUNT( 1 ) AS count_rooms
		FROM
            dc_log
            INNER JOIN categories ON categories.id = dc_log.categoryid
            inner JOIN `rooms` ON categories.id = rooms.category_id
		INNER JOIN deskofdays ON dc_log.intdate = deskofdays.intdate AND
deskofdays.room_id = rooms.id
		WHERE dc_log.dc_id = 3 AND dc_log.intdate >= " . $intdate_today . " AND dc_expedia_room_categories.dc_hotel_id = ".$dc_hotel_id."
		GROUP BY deskofdays.intdate, rooms.category_id ORDER BY dc_log.id, dc_log.intdate";
		
		if ($debug) {
			echo $sql;
		}
		
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				// count_rooms_expedia
				$categories_rooms_intdate_expedia [$row->id] [$row->intdate] = $row->count_rooms;
			}
		}
		
		if ($debug) {
			print_r ( $categories_rooms_intdate_expedia );
		}
		
		/*
		 * GET OVERBOOKING_RESERVATIONS_ARRAY
		 */
		
		$datein_out_mass = $this->dc_model->get_datein_dateout_dc_log ( 3 );
		$overbooking_reservations_array = array ();
		if (isset ( $datein_out_mass ["intdatein"] )) {
			$overbooking_reservations_array = $this->dc_model->get_overbooking_origincat ( $datein_out_mass ["intdatein"], $datein_out_mass ["intdateout"] );
		}
		
		// echo "<pre>";
		// print_r($overbooking_reservations_array);
		// die();
		
		/*
		 * END GET OVERBOOKING_RESERVATIONS_ARRAY
		 */
		
		/*
		 * Выгрузка загружености с expedia
		*/
		
		
		$dc_rooms = array ();
		$sql = "SELECT  dc_expedia_room_categories_link.*  FROM  dc_expedia_room_categories_link 
		INNER JOIN dc_expedia_room_categories ON dc_expedia_room_categories.id = dc_expedia_room_categories_link.dc_category_id
		WHERE dc_expedia_room_categories.dc_hotel_id = ".$dc_hotel_id;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$dc_rooms [$row->hms_category_id] = $row->dc_category_id;
			}
		}
		
		$category_keys = array_keys ( $categories_rooms_all_expedia );
		$roomsresult = array ();
		foreach ( $category_keys as $category_id ) {
			
			ksort ( $categories_rooms_all_expedia [$category_id] );
			
			$sql = "select min, max from dc_expedia_room_categories_link where hms_category_id =" . $category_id;
			$query = $this->db->query ( $sql );
			if ($query->num_rows () > 0) {
				$row2 = $query->row ();
				$min = $row2->min;
				$max = $row2->max;
			} else {
				$min = 0;
				$max = 999;
			}
			
			if (! isset ( $dc_rooms [$category_id] )) {
				unset ( $categories_rooms_all_expedia [$category_id] );
				continue;
			}
			$arr_intdate_keys = array_keys ( $categories_rooms_all_expedia [$category_id] );
			foreach ( $arr_intdate_keys as $intdate ) {
				if (! isset ( $categories_rooms_all_expedia [$category_id] [$intdate] )) {
					continue;
				}
				if (isset ( $categories_rooms_intdate_expedia [$category_id] [$intdate] )) {
					$count_overbook_rooms = 0;
					if (isset ( $overbooking_reservations_array [$category_id] [$intdate] )) {
						$count_overbook_rooms = $overbooking_reservations_array [$category_id] [$intdate];
					}
					$categories_rooms_all_expedia [$category_id] [$intdate] ["count"] = $categories_rooms_all_expedia [$category_id] [$intdate] ["count"] - ($categories_rooms_intdate_expedia [$category_id] [$intdate] + $count_overbook_rooms);
				} else {
					$count_overbook_rooms = 0;
					if (isset ( $overbooking_reservations_array [$category_id] [$intdate] )) {
						$count_overbook_rooms = $overbooking_reservations_array [$category_id] [$intdate];
					}
					$categories_rooms_all_expedia [$category_id] [$intdate] ["count"] = $categories_rooms_all_expedia [$category_id] [$intdate] ["count"] - ($count_overbook_rooms);
				}
				
				if ($categories_rooms_all_expedia [$category_id] [$intdate] ["count"] > $min) {
					$categories_rooms_all_expedia [$category_id] [$intdate] ["count"] = $categories_rooms_all_expedia [$category_id] [$intdate] ["count"] - $min;
				} else {
					$categories_rooms_all_expedia [$category_id] [$intdate] ["count"] = 0;
				}
				
				if ($categories_rooms_all_expedia [$category_id] [$intdate] ["count"] > $max) {
					$categories_rooms_all_expedia [$category_id] [$intdate] ["count"] = $max;
				}
				
				// коррекція к-сті відповідно умовам ф-ї availability_count_correction
				$startdate = $enddate = date("Y-m-d", $intdate*86400);
				$categories_rooms_all_expedia[$category_id][$intdate]["count"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all_expedia[$category_id][$intdate]["count"], $startdate, $enddate);
				
				$categories_rooms_all_expedia [$category_id] [$intdate] ['room_category'] = $dc_rooms [$category_id];
				$categories_rooms_all_expedia [$category_id] [$intdate] ['hotel'] = $dc_hotel_id;
				ksort ( $categories_rooms_all_expedia [$category_id] [$intdate] );
				
				$prev = $intdate - 1;
				if (true) {
					if (isset ( $categories_rooms_all_expedia [$category_id] [$prev] )) {
						$free_1 = $categories_rooms_all_expedia [$category_id] [$prev] ["count"];
						$free_2 = $categories_rooms_all_expedia [$category_id] [$intdate] ["count"];
						
						if ($free_1 == $free_2 && ! false) {
							$categories_rooms_all_expedia [$category_id] [$intdate] ["plan_date_start_at"] = $categories_rooms_all_expedia [$category_id] [$prev] ["plan_date_start_at"];
							unset ( $categories_rooms_all_expedia [$category_id] [$prev] );
						}
					}
				}
				// array_push ( $roomsresult, $categories_rooms_all_expedia [$category_id] [$intdate] );
			}
		}
		// echo "<pre>";
		//print_r ( $categories_rooms_all_expedia );
		// die();
		$category_keys = array_keys ( $categories_rooms_all_expedia );
		$roomsresult = array ();
		foreach ( $category_keys as $category_id ) {
			$intday_keys = array_keys ( $categories_rooms_all_expedia [$category_id] );
			foreach ( $intday_keys as $intdate ) {
				if (isset ( $categories_rooms_all_expedia [$category_id] [$intdate] ))
					array_push ( $roomsresult, $categories_rooms_all_expedia [$category_id] [$intdate] );
			}
		}
		
		$rooms = $roomsresult;
		//echo "<pre>111";
		//print_r ( $rooms );
		// die(" - DEBUG!!! - ");
		
		if (count ( $rooms ) < 1) {
			$query = $this->db->query ( "DELETE dc_log FROM dc_log 
INNER JOIN dc_expedia_room_categories_link ON dc_expedia_room_categories_link.hms_category_id = dc_log.categoryid
			 INNER JOIN dc_expedia_room_categories ON dc_expedia_room_categories_link.dc_category_id = dc_expedia_room_categories.id
WHERE dc_id = 3 AND time < $last_time" . "AND dc_expedia_room_categories.dc_hotel_id = ".$dc_hotel_id);
			$data_return ["response"] = 4;
			return $data_return;
		}
		
		$data_result = $this->dcm_expedia->update_rooms_v2 ($dc_account_id,  $rooms, array (), 1 );
		$response = $data_result ["result"];
		$dc_log_id = $data_result ["dc_log_id"];
		// $data_return ["responsebody"] = $response;
		$respcode = $response ['response'];
		$responseint = $response ['responseint'];
		$sql = "INSERT INTO dc_xml_log (dc_id, responsetext, responseint, time)
				VALUES('3','" . addslashes ( $response ['origin'] ) . "', $respcode ,
						'" . gmdate ( "Y-m-d H:i:s" ) . "')";
		$query = $this->db->query ( $sql );
		$data = array ();
		
		$data_return ["delete_log"] = $data_result ["delete_log"];
		$data_return ["dc_log_id"] = $dc_log_id;
		$data_return ["datein"] = gmdate ( "Y-m-d", $min_date * 86400 );
		$data_return ["dateout"] = gmdate ( "Y-m-d", $max_date * 86400 );
		$data_return ["last_id"] = $last_id;
		$data_return ["last_time"] = $last_time;
		
		if ($respcode == 1) {
			// echo "Expedia passed\n";
			 $sql = "DELETE dc_log FROM dc_log 
			 INNER JOIN dc_expedia_room_categories_link ON dc_expedia_room_categories_link.hms_category_id = dc_log.categoryid
			 INNER JOIN dc_expedia_room_categories ON dc_expedia_room_categories_link.dc_category_id = dc_expedia_room_categories.id
			 WHERE dc_log.id <=" . $last_id . " AND dc_log.dc_id = 3 AND dc_expedia_room_categories.dc_hotel_id = ".$dc_hotel_id;
			 
			 $sql2 = "DELETE dc_log FROM dc_expedia_room_categories_link
			 INNER JOIN dc_log ON (dc_log.categoryid = dc_expedia_room_categories_link.hms_category_id AND dc_log.id <=" . $last_id . " AND dc_log.dc_id = 3)
			 INNER JOIN dc_expedia_room_categories ON dc_expedia_room_categories_link.dc_category_id = dc_expedia_room_categories.id
			 WHERE dc_expedia_room_categories.dc_hotel_id = ".$dc_hotel_id;
			 
			 //echo $sql . "\n";
			 //die();
			 $query = $this->db->query ( $sql );
			
			$data_return ["response"] = 1;
			$data_return ["responsebody"] = "success";
			// if ((strpos ( $respcode, "Warning" ) === 0)) {
			if (isset ( $response ["warning"] )) {
				$data_return ["warning"] = 1;
				$data_return ["responsebody"] = $response ["responsebody"];
				$data_return ["response"] = 0;
			}
			
			// $this->dc_model->Delete_dclog_last_data ( 3 );
			// return 1;
		} else {
			// $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 3";
			// $query = $this->db->query ( $sql );
			
		    $sql = "DELETE dc_log FROM dc_log
			 INNER JOIN dc_expedia_room_categories_link ON dc_expedia_room_categories_link.hms_category_id = dc_log.categoryid
			 INNER JOIN dc_expedia_room_categories ON dc_expedia_room_categories_link.dc_category_id = dc_expedia_room_categories.id
			 WHERE dc_log.id <=" . $last_id . " AND dc_log.dc_id = 3 AND dc_expedia_room_categories.dc_hotel_id = ".$dc_hotel_id;		    
		    $query = $this->db->query ( $sql );
		    
			$data_return ["response"] = 0;
			$data_return ["errmsg"] = $response ['errmsg'];
			$data_return ["responsebody"] = $response ['errmsg'];
			//echo "<pre>\n--- !!! Expedia Error !!! ---\n";
			// sleep(5);
			//print_r ( $response );
			// return 0;
		}
		//echo "<pre>";
		print_r($data_return);
		return $data_return;
	}
    function setavailability_lastchanged_3()
    {
        
        $debug  = false;
        $general_update = 0;
        $sql = "SELECT int_value FROM dc_expedia_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $general_update = $row->int_value;
        }
        $data_return = array();
        if ($general_update == 1) {} else {
            $data_return["response"] = 2;
            return $data_return;
        }
        
        $sql = "SELECT value FROM hotelix_config WHERE name LIKE 'expedia_uploadperiod'";
        $query = $this->db->query($sql);
        
        if ($query->num_rows() > 0) {
            $row = $query->row_array();
            
            $expedia_uploadperiod = $row["value"];
        } else {
            $expedia_uploadperiod = 180;
            $sql = "INSERT INTO hotelix_config (name, value) VALUES('expedia_uploadperiod', " . $expedia_uploadperiod . ") ON DUPLICATE KEY UPDATE value = " . $expedia_uploadperiod;
            $query = $this->db->query($sql);
        }
        
        $expedia_result = array();
        
        // $intdate_today = round ( time () / 86400 );
        
        // echo $intdate_today . " ---\n";
        $min_date = 0;
        $max_date = 0;
        $categories_rooms_all_expedia = array();
        $intdate_today = floor(time() / 86400);
        $last_id = 0;
        $last_time = time();
        $sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms  FROM categories
				INNER JOIN dc_log ON dc_log.categoryid = categories.id
				INNER JOIN rooms ON rooms.category_id = categories.id
				WHERE rooms.dc_active=1 AND dc_log.dc_id = 3 AND dc_log.intdate >= " . $intdate_today . "
				GROUP BY dc_log.categoryid, dc_log.intdate ORDER BY dc_log.id, dc_log.intdate  LIMIT 0, " . $expedia_uploadperiod;
        if ($debug) {
        echo $sql."<br>";
        }
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_expedia
                if ($min_date == 0) {
                    $min_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate < $min_date) {
                        $min_date = $row->log_intdate;
                    }
                }
                
                if ($max_date == 0) {
                    $max_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate > $max_date) {
                        $max_date = $row->log_intdate;
                    }
                }
                
                $categories_rooms_all_expedia[$row->category_id][$row->log_intdate]["count"] = $row->count_rooms;
                $categories_rooms_all_expedia[$row->category_id][$row->log_intdate]["date"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                
                $categories_rooms_all_expedia[$row->category_id][$row->log_intdate]['plan_date_start_at'] = gmdate("Y-m-d", $row->log_intdate * 86400);
                $categories_rooms_all_expedia[$row->category_id][$row->log_intdate]['plan_date_end_at'] = gmdate("Y-m-d", $row->log_intdate * 86400);
                if ($row->dc_log_id > $last_id) {
                    $last_id = $row->dc_log_id;
                }
            }
        } else {
            
            $data_return["response"] = 3;
            return $data_return;
        }
         echo "<pre>";
         if ($debug) {
             print_r($categories_rooms_all_expedia);
         }
         
        // echo $sql;
        
        $categories_rooms_intdate_expedia = array();
        $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
		FROM `rooms`
		INNER JOIN categories ON categories.id = rooms.category_id
		INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
		INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
dc_log.categoryid = rooms.category_id
		WHERE dc_log.dc_id = 3 AND dc_log.intdate >= " . $intdate_today . "
		GROUP BY deskofdays.intdate, rooms.category_id ORDER BY dc_log.id, dc_log.intdate LIMIT 0, " . $expedia_uploadperiod;
        
        
        $sql2 = "SELECT categories.id, dc_log.intdate, COUNT( 1 ) AS count_rooms
		FROM 
            dc_log 
            INNER JOIN categories ON categories.id = dc_log.categoryid
            inner JOIN `rooms` ON categories.id = rooms.category_id
		INNER JOIN deskofdays ON dc_log.intdate = deskofdays.intdate AND
deskofdays.room_id = rooms.id
		WHERE dc_log.dc_id = 3 AND dc_log.intdate >= " . $intdate_today . "
		GROUP BY deskofdays.intdate, rooms.category_id ORDER BY dc_log.id, dc_log.intdate LIMIT 0, " . $expedia_uploadperiod;
        
        
        if ($debug) {
            echo $sql;
        }
        
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_expedia
                $categories_rooms_intdate_expedia[$row->id][$row->intdate] = $row->count_rooms;
            }
        }
         
         if ($debug) {
             print_r($categories_rooms_intdate_expedia);
         }
        
        /*
         * GET OVERBOOKING_RESERVATIONS_ARRAY
         *
         *
         */
        
        $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log(3);
        $overbooking_reservations_array = array();
        if (isset($datein_out_mass["intdatein"])) {
            $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat($datein_out_mass["intdatein"], $datein_out_mass["intdateout"]);
        }
        
        // echo "<pre>";
        // print_r($overbooking_reservations_array);
        // die(); 
        
        /*
         * END GET OVERBOOKING_RESERVATIONS_ARRAY
         */
        
        /*
         * Выгрузка загружености с expedia
         */ 
        
        $query = $this->db->query("SELECT int_value FROM dc_expedia_xml_cfg WHERE name LIKE 'hotel_id'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $hotel_id = $row->int_value;
        } else {
            $hotel_id = "none";
        }
        $dc_rooms = array();
        $sql = "SELECT  dc_expedia_room_categories_link.*  FROM  dc_expedia_room_categories_link ";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $dc_rooms[$row->hms_category_id] = $row->dc_category_id;
            }
        }
        
        $category_keys = array_keys($categories_rooms_all_expedia);
        $roomsresult = array();
        foreach ($category_keys as $category_id) {
            
            ksort($categories_rooms_all_expedia[$category_id]);
            
            $sql = "select min, max from dc_expedia_room_categories_link where hms_category_id =" . $category_id;
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $row2 = $query->row();
                $min = $row2->min;
                $max = $row2->max;
            } else {
                $min = 0;
                $max = 999;
            }
            
            if (! isset($dc_rooms[$category_id])) {
                unset($categories_rooms_all_expedia[$category_id]);
                continue;
            }
            $arr_intdate_keys = array_keys($categories_rooms_all_expedia[$category_id]);
            foreach ($arr_intdate_keys as $intdate) {
                if (! isset($categories_rooms_all_expedia[$category_id][$intdate])) {
                   continue;
                }
                if (isset($categories_rooms_intdate_expedia[$category_id][$intdate])) {
                    $count_overbook_rooms = 0;                    
                    if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                        $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                    }
                    $categories_rooms_all_expedia[$category_id][$intdate]["count"] = $categories_rooms_all_expedia[$category_id][$intdate]["count"] - ($categories_rooms_intdate_expedia[$category_id][$intdate] + $count_overbook_rooms);
                } else {
                    $count_overbook_rooms = 0;
                    if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                        $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                    }
                    $categories_rooms_all_expedia[$category_id][$intdate]["count"] = $categories_rooms_all_expedia[$category_id][$intdate]["count"] - ($count_overbook_rooms);
                }
                
                if ($categories_rooms_all_expedia[$category_id][$intdate]["count"] > $min) {
                    $categories_rooms_all_expedia[$category_id][$intdate]["count"] = $categories_rooms_all_expedia[$category_id][$intdate]["count"] - $min;
                } else {
                    $categories_rooms_all_expedia[$category_id][$intdate]["count"] = 0;
                }
                
                if ($categories_rooms_all_expedia[$category_id][$intdate]["count"] > $max) {
                    $categories_rooms_all_expedia[$category_id][$intdate]["count"] = $max;
                }
                
                // коррекція к-сті відповідно умовам ф-ї availability_count_correction
                $startdate = $enddate = date("Y-m-d", $intdate*86400);
                $categories_rooms_all_expedia[$category_id][$intdate]["count"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all_expedia[$category_id][$intdate]["count"], $startdate, $enddate);
                
                $categories_rooms_all_expedia[$category_id][$intdate]['room_category'] = $dc_rooms[$category_id];
                $categories_rooms_all_expedia[$category_id][$intdate]['hotel'] = $hotel_id;
                ksort($categories_rooms_all_expedia[$category_id][$intdate]);
                
                $prev = $intdate - 1;
                if (true) {
                if (isset($categories_rooms_all_expedia[$category_id][$prev])) {
                    $free_1 = $categories_rooms_all_expedia[$category_id][$prev]["count"];
                    $free_2 = $categories_rooms_all_expedia[$category_id][$intdate]["count"];
                    
                    if ($free_1 == $free_2 && !false) {
                        $categories_rooms_all_expedia[$category_id][$intdate]["plan_date_start_at"] = $categories_rooms_all_expedia[$category_id][$prev]["plan_date_start_at"];
                        unset($categories_rooms_all_expedia[$category_id][$prev]);
                    }
                }
                }
                // array_push ( $roomsresult, $categories_rooms_all_expedia [$category_id] [$intdate] );
            }
        }
//         echo "<pre>";
         print_r($categories_rooms_all_expedia);
        // die();
        $category_keys = array_keys($categories_rooms_all_expedia);
        $roomsresult = array();
        foreach ($category_keys as $category_id) {
            $intday_keys = array_keys($categories_rooms_all_expedia[$category_id]);
            foreach ($intday_keys as $intdate) {
                if (isset($categories_rooms_all_expedia[$category_id][$intdate]))
                    array_push($roomsresult, $categories_rooms_all_expedia[$category_id][$intdate]);
            }
        }
        
        $rooms = $roomsresult;
         echo "<pre>111";
         print_r($rooms);
       //die(" - DEBUG!!! - ");
        
        if (count($rooms) < 1) {
            $query = $this->db->query("DELETE FROM dc_log WHERE dc_id = 3 AND time < $last_time");
            $data_return["response"] = 4;
            return $data_return;
        }
        
        $data_result = $this->dcm_expedia->update_rooms($rooms, array(), 1);
        $response = $data_result["result"];
        $dc_log_id = $data_result["dc_log_id"];
        // $data_return ["responsebody"] = $response;
        $respcode = $response['response'];
        $responseint = $response['responseint'];
        $sql = "INSERT INTO dc_xml_log (dc_id, responsetext, responseint, time)
				VALUES('3','" . addslashes($response['origin']) . "', $respcode ,
    				'" . gmdate("Y-m-d H:i:s") . "')";
        $query = $this->db->query($sql);
        $data = array();
        
        $data_return["delete_log"] = $data_result["delete_log"];
        $data_return["dc_log_id"] = $dc_log_id;
        $data_return["datein"] = gmdate("Y-m-d", $min_date * 86400);
        $data_return["dateout"] = gmdate("Y-m-d", $max_date * 86400);
        $data_return["last_id"] = $last_id;
        $data_return["last_time"] = $last_time;
        
        if ($respcode == 1) {
            // echo "Expedia passed\n";
            // $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 3";
            // $query = $this->db->query ( $sql );
            // echo $sql . "\n";
            $data_return["response"] = 1;
            $data_return["responsebody"] = "success";
            // if ((strpos ( $respcode, "Warning" ) === 0)) {
            if (isset($response["warning"])) {
                $data_return["warning"] = 1;
                $data_return["responsebody"] = $response["responsebody"];
                $data_return["response"] = 0;
            }
            
            // $this->dc_model->Delete_dclog_last_data ( 3 );
            // return 1;
        } else {
            if ($data_return["delete_log"] == 1) {
                
            }
            // $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 3";
            // $query = $this->db->query ( $sql );
            $data_return["response"] = 0;
            $data_return["errmsg"] = $response['errmsg'];
            $data_return["responsebody"] = $response['errmsg'];
            // echo "--- !!! Expedia Error !!! ---\n";
            // sleep(5);
            // print_r ( $response ['origin'] );
            // return 0;
        }
        
        // print_r($data_return);
        return $data_return;
    }

    function setavailability_lastchanged_4()
    {
        $general_update = 0;
        $sql = "SELECT int_value FROM dc_hostelsclub_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $general_update = $row->int_value;
        }
        $data_return = array();
        if ($general_update == 1) {} else {
            $data_return["response"] = 2;
            return $data_return;
        }
        
        $hsclub_uploadperiod = 10;
        $sql = "SELECT value FROM hotelix_config WHERE name LIKE 'hsclub_uploadperiod'";
        $query = $this->db->query($sql);
        
        if ($query->num_rows() > 0) {
            $row = $query->row_array();
            
            $hsclub_uploadperiod = $row["value"];
        }
        
        $intdate_today = floor(time() / 86400);
        $last_id = 0;
        $last_time = time();
        // echo $intdate_today . "\n";
        $sql = "SELECT dc_log.id as dc_log_id, dc_log.intdate as log_intdate  FROM dc_log								
				WHERE dc_log.dc_id = 4 AND dc_log.intdate >= " . $intdate_today . "
				GROUP BY dc_log.categoryid, dc_log.intdate LIMIT 0, " . $hsclub_uploadperiod;
        $query = $this->db->query($sql);
        
         echo $sql."<br>";
        
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                if ($row->dc_log_id > $last_id) {
                    $last_id = $row->dc_log_id;
                }
            }
        } else {
            $data_return["response"] = 3;
            return $data_return;
        }
        
        $hsClub_result = "";
        
        // echo $general_update_HsClub;
        $data_return = array();
        
        if ($general_update == 1) {
            /*
             * GET OVERBOOKING_RESERVATIONS_ARRAY
             */
            
            $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log(4);
            
            $datein = gmdate("Y-m-d", $datein_out_mass["intdatein"] * 86400);
            $dateout = gmdate("Y-m-d", $datein_out_mass["intdateout"] * 86400);
            // echo "<pre>";
            // print_r($overbooking_reservations_array);
            // die();
            
            /*
             * END GET OVERBOOKING_RESERVATIONS_ARRAY
             */
            
            // echo $datein . "\n";
            // echo $dateout . "\n";
            $data = array();
            $authparam = $this->dcm_hostelsclub->getauthparam();
            // $rateavail = $this->dcm_hostelsclub->getrateavail ( $datein, $dateout );
            $rateavail = $this->dcm_hostelsclub->getrateavail_2($datein, $dateout, 1, $hsclub_uploadperiod);
            // echo "<pre>";
            // print_r($rateavail);
            // die();
            $data['RequestorID'] = $authparam['RequestorID'];
            $data['Password'] = $authparam['Password'];
            $data['HotelCode'] = $authparam['HotelCode'];
            $data['RateAvail'] = $rateavail;
            if (isset($rateavail["response"])) {
                if ($rateavail["response"] == 3) {
                    $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 4";
                    $data_return["response"] = 3;
                    $query = $this->db->query($sql);
                    return $data_return;
                }
            }
            if (count($rateavail) < 1) {
                $query = $this->db->query("DELETE FROM dc_log WHERE dc_id = 4");
                $data_return["response"] = 4;
                return $data_return;
            }
            
            $request = $this->parser->parse('templates/xml/dc_hostelsclub_rateavail.xml', $data, true);
            $request = '<?xml version="1.0" encoding="UTF-8"?>' . $request;
            // echo $request;
            
            $url = "https://www.hostelspoint.com/xml/xml.php";
            $arr["OTA_request"] = $request;
            
            $data_result = $this->Curl_model->CurlPlug($arr, $url, 4, array(
                "returntype" => "array"
            ));
            
            // echo $result;
            // return $result;
            $result = $data_result["result"];
            $dc_log_id = $data_result["dc_log_id"];
            
            $response = simplexml_load_string($result);
            // $data_return ["responsebody"] = $result;
            
            // echo "<pre>";
            // echo $result;
            // echo $request;
            // print_r($data);
            $reservationdata = array();
            if (isset($response->Success)) {
                $reservationdata['success'] = true;
            } else {
                $reservationdata['success'] = false;
            }
            
            $data_return["dc_log_id"] = $dc_log_id;
            $data_return["datein"] = $datein;
            $data_return["dateout"] = $dateout;
            
            if ($reservationdata['success'] == true) {
                $hsClub_result = "HsClub: Success";
                $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 4 AND time < " . $last_time;
                // echo $sql;
                $query = $this->db->query($sql);
                $data_return["response"] = 1;
                $data_return["responsebody"] = "success";
                
                // $this->dc_model->Delete_dclog_last_data ( 4 );
            } else {
                // echo "<pre>";
                // $hsClub_result = "HsClub: " . $reservationdata ['errmsg'];
                $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 4 AND time < " . $last_time;
                // echo $sql;
                $query = $this->db->query($sql);
                $data_return["response"] = 0;
                $data_return["errmsg"] = "";
                foreach ($response->Errors as $err) {
                    $data_return["errmsg"] .= "datein = $datein; dateout = $dateout; <br>" . $err->Error;
                }
                
                $data_return["responsebody"] = "datein = $datein; dateout = $dateout; " . $data_return["errmsg"];
            }
            
            // echo "<pre>";
            // print_r ( $data );
        } else {}
        return $data_return;
    }

    function setavailability_lastchanged_5($upload_restrict)
    {
        $general_update = 0;
        $sql = "SELECT int_value FROM dc_agoda_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $general_update = $row->int_value;
        }
        $data_return = array();
        if ($general_update == 1) {} else {
            $data_return["response"] = 2;
            return $data_return;
        }
        
        $dc_hms_cat = array();
        $sql = "SELECT dc_agoda_room_categories_link.*  FROM dc_agoda_room_categories_link ";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $dc_hms_cat[$row->hms_category_id] = $row->dc_category_id;
            }
        }
        
        $min_date = 0;
        $max_date = 0;
        $categories_rooms_all = array();
        $data_return = array();
        $intdate_today = floor(time() / 86400);
        $last_id = 0;
        $last_time = time();
        
        $sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms  FROM categories
				INNER JOIN dc_log ON dc_log.categoryid = categories.id
				INNER JOIN rooms ON rooms.category_id = categories.id
				WHERE rooms.dc_active=1 AND dc_log.dc_id = 5 AND dc_log.intdate >= " . $intdate_today . "
				GROUP BY dc_log.categoryid, dc_log.intdate";
        $query = $this->db->query($sql);
        // echo $sql;
        // echo "start wait\n";
        // sleep(15);
        // echo "done wait\n";
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                if ($min_date == 0) {
                    $min_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate < $min_date) {
                        $min_date = $row->log_intdate;
                    }
                }
                
                if ($max_date == 0) {
                    $max_date = $row->log_intdate;
                } else {
                    if ($row->log_intdate > $max_date) {
                        $max_date = $row->log_intdate;
                    }
                }
                if (isset($dc_hms_cat[$row->category_id])) {
                    $categories_rooms_all[$row->category_id][$row->log_intdate]["dc_room_id"] = $dc_hms_cat[$row->category_id];
                } else {
                    $categories_rooms_all[$row->category_id][$row->log_intdate]["dc_room_id"] = 0;
                }
                $categories_rooms_all[$row->category_id][$row->log_intdate]["free"] = $row->count_rooms;
                $categories_rooms_all[$row->category_id][$row->log_intdate]["date"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                
                $categories_rooms_all[$row->category_id][$row->log_intdate]["from"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                $categories_rooms_all[$row->category_id][$row->log_intdate]["to"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                // $last_id = $row->dc_log_id;
                if ($row->dc_log_id > $last_id) {
                    $last_id = $row->dc_log_id;
                }
            }
        } else {
            $data_return["response"] = 3;
            return $data_return;
        }
        
        // echo "<pre>";
        // print_r ( $categories_rooms_all );
        // die();
        
//         $deskofrate_array = array();
        
//         $sql = "SELECT deskofrate.closed, deskofrate.closedonarrival, deskofrate.closedondeparture, dc_log.intdate, dc_agoda_room_categories_link.dc_category_id, dc_agoda_room_categories_link.hms_category_id,
// 		dc_agoda_rates_link.dc_rate_id as dc_rate_id FROM dc_log
// 		INNER JOIN dc_agoda_room_categories_link ON dc_log.categoryid = dc_agoda_room_categories_link.hms_category_id
// 		INNER JOIN ratetocategory ON ratetocategory.category_id = dc_log.categoryid
// 		INNER JOIN categories ON categories.id = dc_log.categoryid
// 		INNER JOIN dc_agoda_rates_link ON dc_agoda_rates_link.hms_rate_id = ratetocategory.rate_id
// 		LEFT JOIN deskofrate ON deskofrate.intdate = dc_log.intdate AND deskofrate.category_id = dc_log.categoryid AND dc_agoda_rates_link.restrict_id = deskofrate.rate_id
// 		WHERE dc_log.dc_id = 5 AND onlinebook = 1 AND categories.is_active = 1";
//         $query = $this->db->query($sql);
//         if ($query->num_rows() > 0) {
//             foreach ($query->result() as $row) {
//                 // count_rooms_booking
//                 $deskofrate_array[$row->hms_category_id][$row->intdate]["closed"] = $row->closed;
//                 $deskofrate_array[$row->hms_category_id][$row->intdate]["ctd"] = $row->closedondeparture;
//                 $deskofrate_array[$row->hms_category_id][$row->intdate]["cta"] = $row->closedonarrival;
//             }
//         }
        
        $categories_rooms_intdate = array();
        
        $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
FROM  `rooms`
INNER JOIN categories ON categories.id = rooms.category_id
INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate AND
dc_log.categoryid = rooms.category_id
WHERE dc_log.dc_id = 5
GROUP BY deskofdays.intdate, rooms.category_id";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                $categories_rooms_intdate[$row->id][$row->intdate]["free"] = $row->count_rooms;
            }
        }
        
        // echo "<pre>";
        print_r($categories_rooms_intdate);
        
//         $query = $this->db->query("SELECT int_value FROM dc_agoda_xml_cfg WHERE name LIKE 'hotel_id'");
//         if ($query->num_rows() > 0) {
//             $row = $query->row();
//             $hotel_id = $row->int_value;
//         } else {
//             $hotel_id = "none";
//         }
        
//         $query = $this->db->query("SELECT str_value FROM dc_agoda_xml_cfg WHERE name LIKE 'api_key'");
//         if ($query->num_rows() > 0) {
//             $row = $query->row();
//             $api_key = $row->str_value;
//         } else {
//             $api_key = "none";
//         }
        
        /*
         * GET OVERBOOKING_RESERVATIONS_ARRAY
         */
        $datein_out_mass = $this->dc_model->get_datein_dateout_dc_log(5);
        $overbooking_reservations_array = array();
        if (isset($datein_out_mass["intdatein"])) {
            $overbooking_reservations_array = $this->dc_model->get_overbooking_origincat($datein_out_mass["intdatein"], $datein_out_mass["intdateout"]);
        }
        
        $setrestrict_result = "";
        $result = "";
        $sql = "SELECT int_value FROM dc_agoda_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        if ($general_update == 1) {
            $category_keys = array_keys($categories_rooms_all);
            foreach ($category_keys as $category_id) {
                
                $sql = "select min, max from dc_agoda_room_categories_link where hms_category_id =" . $category_id;
                $query = $this->db->query($sql);
                
                if ($query->num_rows() > 0) {
                    $row2 = $query->row();
                    $min = $row2->min;
                    $max = $row2->max;
                } else {
                    $min = 0;
                    $max = 999;
                }
                
                $arr_intdate_keys = array_keys($categories_rooms_all[$category_id]);
                foreach ($arr_intdate_keys as $intdate) {
                    if (isset($categories_rooms_intdate[$category_id][$intdate])) {
                        $count_overbook_rooms = 0;
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                        }
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - ($categories_rooms_intdate[$category_id][$intdate]["free"] + $count_overbook_rooms);
                    } else {
                        if (isset($overbooking_reservations_array[$category_id][$intdate])) {
                            $count_overbook_rooms = $overbooking_reservations_array[$category_id][$intdate];
                            $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $count_overbook_rooms;
                        }
                    }
                    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
                    } else {
                        $categories_rooms_all[$category_id][$intdate]["free"] = 0;
                    }
                    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $max;
                    }
                    
                    // коррекція к-сті відповідно умовам ф-ї availability_count_correction
                    $startdate = $enddate = date("Y-m-d", $intdate*86400);
                    $categories_rooms_all[$category_id][$intdate]["free"] = $this->frontdesk_c2->availability_count_correction($categories_rooms_all[$category_id][$intdate]["free"], $startdate, $enddate);
                    
                    /*
                     * if ($upload_restrict == 1) {
                     * if (isset($deskofrate_array[$category_id][$intdate]["closed"])) {
                     * $categories_rooms_all[$category_id][$intdate]["closed"] = "<closed>" . $deskofrate_array[$category_id][$intdate]["closed"] . "</closed>";
                     * } else {
                     * $categories_rooms_all[$category_id][$intdate]["closed"] = "<closed>0</closed>";
                     * }
                     * if (isset($deskofrate_array[$category_id][$intdate]["ctd"])) {
                     * $categories_rooms_all[$category_id][$intdate]["closedtodeparture"] = "<ctd>" . $deskofrate_array[$category_id][$intdate]["ctd"] . "</ctd>";
                     * } else {
                     * $categories_rooms_all[$category_id][$intdate]["closedtodeparture"] = "<ctd>0</ctd>";
                     * }
                     * if (isset($deskofrate_array[$category_id][$intdate]["cta"])) {
                     * $categories_rooms_all[$category_id][$intdate]["closedtoarrival"] = "<cta>" . $deskofrate_array[$category_id][$intdate]["cta"] . "</cta>";
                     * } else {
                     * $categories_rooms_all[$category_id][$intdate]["closedtoarrival"] = "<cta>0</cta>";
                     * }
                     * } else {
                     * $categories_rooms_all[$category_id][$intdate]["closed"] = "<closed>0</closed>";
                     * $categories_rooms_all[$category_id][$intdate]["closedtodeparture"] = "<ctd>0</ctd>";
                     * $categories_rooms_all[$category_id][$intdate]["closedtoarrival"] = "<cta>0</cta>";
                     * }
                     */
                    
                    $prev = $intdate - 1;
                    if (isset($categories_rooms_all[$category_id][$prev])) {
                        $free_1 = $categories_rooms_all[$category_id][$prev]["free"];
                        $free_2 = $categories_rooms_all[$category_id][$intdate]["free"];
                        
//                         $closed_1 = $categories_rooms_all[$category_id][$prev]["closed"];
//                         $closed_2 = $categories_rooms_all[$category_id][$intdate]["closed"];
                        
//                         $closedtodeparture_1 = $categories_rooms_all[$category_id][$prev]["closedtodeparture"];
//                         $closedtodeparture_2 = $categories_rooms_all[$category_id][$intdate]["closedtodeparture"];
                        
//                         $closedtoarrival_1 = $categories_rooms_all[$category_id][$prev]["closedtoarrival"];
//                         $closedtoarrival_2 = $categories_rooms_all[$category_id][$intdate]["closedtoarrival"];
                        
                        //if ($free_1 == $free_2 && $closed_1 == $closed_2 && $closedtodeparture_1 == $closedtodeparture_2 && $closedtoarrival_1 == $closedtoarrival_2) {
                        if ($free_1 == $free_2) {
                            $categories_rooms_all[$category_id][$intdate]["from"] = $categories_rooms_all[$category_id][$prev]["from"];
                            unset($categories_rooms_all[$category_id][$prev]);
                        }
                    }
                }
            }
            
            $freeRooms = $categories_rooms_all;
            // print_r ( $freeRooms );
            $roomslist = array();
            $sql = "SELECT dc_agoda_room_categories_link.*  FROM dc_agoda_room_categories_link ";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                foreach ($query->result() as $row) {
                    if (isset($freeRooms[$row->hms_category_id])) {
                        array_push($roomslist, array(
                            'dc_room_id' => $row->dc_category_id,
                            'dates' => $freeRooms[$row->hms_category_id]
                        ));
                    }
                }
            }
            echo "<pre>";
            print_r($roomslist);
            // die ();
            
            if (count($roomslist) < 1) {
                $query = $this->db->query("DELETE FROM dc_log WHERE dc_id = 5");
                $data_return["response"] = 4;
                return $data_return;
            }
           
            // die ();
            //$url = "https://sandbox-distribution-xml.agoda.com/api/ari?apiKey=" . $api_key;
            
            $params = $this->dcm_agoda->get_config_data();
            $api_key = $params["api_key"];
            $hotel_id = $params["hotel_id"];
            $url_ari = $params["url_ari"];
            
            $url = $url_ari . $api_key;
            
            $xml_data = array(
                'hotel_id' => $hotel_id,
                'roomslist' => $roomslist
            );
            $xml = $this->parser->parse('templates/xml/dc_agoda_xml_availability.xml', $xml_data, true);
            echo $xml;

            $data_result = $this->Curl_model->CurlPostAgoda($xml, $url, array(
                "returntype" => "array"
            ));
            // $data_return ["responsebody"] = $result;
            $result = $data_result["result"];
            $dc_log_id = $data_result["dc_log_id"];
            // echo $result;
            // return $result;
            
            $data_return["dc_log_id"] = $dc_log_id;
            $data_return["datein"] = gmdate("Y-m-d", $min_date * 86400);
            $data_return["dateout"] = gmdate("Y-m-d", $max_date * 86400);
        }
        echo $result;
        echo "<pre>";
        // print_r ( $data_return );
        // print_r ( $data_result );
        // die ();
        // die();
        if ($general_update == 0) {
            echo "Ban upload for booking service";
        } else {
            libxml_use_internal_errors(true);
            $xml = @simplexml_load_string($result);
            if (! $xml) {
                echo "xml_not_valid!!!!";
                
                $xml_errors = "";
                foreach (libxml_get_errors() as $error) {
                    $xml_errors .= $error->message;
                }
                $data_return["response"] = 0;
                $data_return["errmsg"] = $xml_errors;
                $data_return["responsebody"] = $xml_errors;
            } else {
                echo "xml_valid!!!!";
                print_r($xml);
                // die();
                if (! isset($xml->errors)) {
                    $data_return["response"] = 1;
                    $data_return["responsebody"] = "success";
                    $sql = "DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 5 AND time < " . $last_time;
                    $query = $this->db->query($sql);
                } else {
                    
                    $data_return["response"] = 0;
                    $data_return["errmsg"] = $result;
                    $data_return["responsebody"] = $result;
                    $query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 5 AND time < " . $last_time);
                }
            }
            // print_r($xml);
            // die();
            
            return $data_return;
        }
        
        /*
         * $xml2 = <<<EOT
         * <?xml version="1.0" encoding="UTF-8"?>
         * <request timestamp="1436931804" type="1">
         * <criteria from="2015-12-11" to="2015-12-20">
         * <property id="255902" type="inventory" />
         * </criteria>
         * </request>
         * EOT;
         *
         * $url = "https://sandbox-distribution-xml.agoda.com/api/ari/search?apiKey=132d539e-1ac5-4a5d-8809-237633937c95";
         * $resp = $this->Curl_model->CurlPostAgoda ( $xml2, $url );
         * echo $resp;
         * echo "00000000000000000000000000000000000000000000<br>";
         */
        // die ();
    }

    function setavailability_lastchanged()
    {
        $categories_rooms_all = array();
        $categories_rooms_all_ostrovok = array();
        $categories_rooms_all_expedia = array();
        $last_id = 0;
        
        $sql = "SELECT dc_log.id as dc_log_id, categories.id as category_id, dc_log.intdate as log_intdate, COUNT(rooms.id) as count_rooms  FROM categories
				INNER JOIN dc_log ON dc_log.categoryid = categories.id
				INNER JOIN rooms ON rooms.category_id = categories.id
				GROUP BY dc_log.categoryid, dc_log.intdate";
        // echo $sql;
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                
                // count_rooms_booking
                $categories_rooms_all[$row->category_id][$row->log_intdate]["free"] = $row->count_rooms;
                $categories_rooms_all[$row->category_id][$row->log_intdate]["date"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                
                // count_rooms_ostrovok
                $categories_rooms_all_ostrovok[$row->category_id][$row->log_intdate]["count"] = $row->count_rooms;
                $categories_rooms_all_ostrovok[$row->category_id][$row->log_intdate]["date"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                
                // count_rooms_expedia
                $categories_rooms_all_expedia[$row->category_id][$row->log_intdate]["count"] = $row->count_rooms;
                $categories_rooms_all_expedia[$row->category_id][$row->log_intdate]["date"] = gmdate("Y-m-d", $row->log_intdate * 86400);
                $last_id = $row->dc_log_id;
            }
        } else {
            echo "no data for upload LC\n\n";
            return;
        }
        
        $categories_rooms_intdate = array();
        $categories_rooms_intdate_ostrovok = array();
        $categories_rooms_intdate_expedia = array();
        $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
		FROM `rooms`
		INNER JOIN categories ON categories.id = rooms.category_id
		INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
		INNER JOIN dc_log ON dc_log.intdate = deskofdays.intdate
		GROUP BY deskofdays.intdate, rooms.category_id";
        
        // echo $sql;
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                // count_rooms_booking
                $categories_rooms_intdate[$row->id][$row->intdate]["free"] = $row->count_rooms;
                // count_rooms_ostrovok
                $categories_rooms_intdate_ostrovok[$row->id][$row->intdate] = $row->count_rooms;
                // count_rooms_expedia
                $categories_rooms_intdate_expedia[$row->id][$row->intdate] = $row->count_rooms;
            }
        }
        echo "<pre>";
        print_r($categories_rooms_all_ostrovok);
        print_r($categories_rooms_intdate_ostrovok);
        die();
        $query = $this->db->query("SELECT int_value FROM dc_booking_xml_cfg WHERE name LIKE 'hotel_id'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $hotel_id = $row->int_value;
        } else {
            $hotel_id = "none";
        }
        
        /*
         * Выгрузка загружености с booking
         */
        
        $general_update_booking = 0;
        $setrestrict_result = "";
        $result = "";
        $sql = "SELECT int_value FROM dc_booking_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $general_update_booking = $row->int_value;
        }
        if ($general_update_booking == 1) {
            $category_keys = array_keys($categories_rooms_all);
            foreach ($category_keys as $category_id) {
                
                $sql = "select min, max from dc_booking_rooms_link where category_id =" . $category_id;
                $query = $this->db->query($sql);
                if ($query->num_rows() > 0) {
                    $row2 = $query->row();
                    $min = $row2->min;
                    $max = $row2->max;
                } else {
                    $min = 0;
                    $max = 999;
                }
                
                $arr_intdate_keys = array_keys($categories_rooms_all[$category_id]);
                foreach ($arr_intdate_keys as $intdate) {
                    if (isset($categories_rooms_intdate[$category_id][$intdate])) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $categories_rooms_intdate[$category_id][$intdate]["free"];
                        // echo "-";
                    } else {
                        // $categories_rooms_all [$category_id] [$intdate]
                        // ["free"]
                        // = 0;
                        // ??
                        // echo "+";
                    }
                    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
                    } else {
                        $categories_rooms_all[$category_id][$intdate]["free"] = 0;
                    }
                    
                    if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
                        $categories_rooms_all[$category_id][$intdate]["free"] = $max;
                    }
                }
            }
            
            $freeRooms = $categories_rooms_all;
            // print_r ( $freeRooms );
            $roomslist = array();
            $sql = "SELECT dc_booking_rooms_link.*  FROM dc_booking_rooms_link ";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                foreach ($query->result() as $row) {
                    if (isset($freeRooms[$row->category_id])) {
                        array_push($roomslist, array(
                            'dc_room_id' => $row->dc_room_id,
                            'dates' => $freeRooms[$row->category_id]
                        ));
                    }
                }
            }
            // echo "<pre>";
            // print_r ( $roomslist );
            // die ();
            $xml_data = array(
                'dcuser' => $this->config->item('dc_booking_xml_user'),
                'dcpwd' => $this->config->item('dc_booking_xml_pwd'),
                'hotel_id' => $hotel_id,
                'roomslist' => $roomslist
            );
            $xml = $this->parser->parse('templates/dc_booking_xml_availability_tpl.html', $xml_data, true);
            // echo $xml;
            $url = $this->config->item('dc_booking_xml_host') . "hotels/xml/availability";
            $result = $this->Curl_model->CurlPlugRAW($xml, $url);
            
            $result_data["booking"] = $result;
            echo $result;
            // return $result;
        }
        
        /*
         * Выгрузка загружености с ostrovok
         */
        
        $general_update_ostrovok = 0;
        $sql = "SELECT int_value FROM dc_ostrovok_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $general_update_ostrovok = $row->int_value;
        }
        
        $ostrovok_result = array();
        if ($general_update_ostrovok == 1) {
            
            $query = $this->db->query("SELECT int_value FROM dc_ostrovok_xml_cfg WHERE name LIKE 'hotel_id'");
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $hotel_id = $row->int_value;
            } else {
                $hotel_id = "none";
            }
            $dc_rooms = array();
            $sql = "SELECT  dc_ostrovok_room_categories_link.*  FROM  dc_ostrovok_room_categories_link ";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                foreach ($query->result() as $row) {
                    $dc_rooms[$row->hms_category_id] = $row->dc_category_id;
                }
            }
            
            // $rooms = $this->dc_ostrovok_model->GetFreeRooms ( $datein,
            // $dateout, $dc_hotelid );
            
            $category_keys = array_keys($categories_rooms_all_ostrovok);
            $roomsresult = array();
            foreach ($category_keys as $category_id) {
                
                $sql = "select min, max from dc_ostrovok_room_categories_link where hms_category_id =" . $category_id;
                $query = $this->db->query($sql);
                if ($query->num_rows() > 0) {
                    $row2 = $query->row();
                    $min = $row2->min;
                    $max = $row2->max;
                } else {
                    $min = 0;
                    $max = 999;
                }
                
                if (! isset($dc_rooms[$category_id])) {
                    unset($categories_rooms_all_ostrovok[$category_id]);
                    continue;
                }
                $arr_intdate_keys = array_keys($categories_rooms_all_ostrovok[$category_id]);
                foreach ($arr_intdate_keys as $intdate) {
                    if (isset($categories_rooms_intdate_ostrovok[$category_id][$intdate])) {
                        $categories_rooms_all_ostrovok[$category_id][$intdate]["count"] = $categories_rooms_all_ostrovok[$category_id][$intdate]["count"] - $categories_rooms_intdate_ostrovok[$category_id][$intdate];
                        // echo "-";
                    } else {
                        // $categories_rooms_all [$category_id] [$i] ["free"] =
                        // 0;
                        // ??
                        // echo "+";
                    }
                    
                    if ($categories_rooms_all_ostrovok[$category_id][$intdate]["count"] > $min) {
                        $categories_rooms_all_ostrovok[$category_id][$intdate]["count"] = $categories_rooms_all_ostrovok[$category_id][$intdate]["count"] - $min;
                    } else {
                        $categories_rooms_all_ostrovok[$category_id][$intdate]["count"] = 0;
                    }
                    
                    if ($categories_rooms_all_ostrovok[$category_id][$intdate]["count"] > $max) {
                        $categories_rooms_all_ostrovok[$category_id][$intdate]["count"] = $max;
                    }
                    
                    $categories_rooms_all_ostrovok[$category_id][$intdate]['plan_date_start_at'] = gmdate("Y-m-d", $intdate * 86400);
                    $categories_rooms_all_ostrovok[$category_id][$intdate]['plan_date_end_at'] = gmdate("Y-m-d", $intdate * 86400);
                    // $categories_rooms_all [$category_id] [$i] ['hms_cat_id']
                    // =
                    // $category_id;
                    $categories_rooms_all_ostrovok[$category_id][$intdate]['room_category'] = $dc_rooms[$category_id];
                    $categories_rooms_all_ostrovok[$category_id][$intdate]['hotel'] = $hotel_id;
                    ksort($categories_rooms_all_ostrovok[$category_id][$intdate]);
                    array_push($roomsresult, $categories_rooms_all_ostrovok[$category_id][$intdate]);
                }
            }
            
            $rooms = $roomsresult;
            
            echo "<pre>";
            // print_r ( $restrict );
            print_r($rooms);
            // die();
            $response = $this->dc_ostrovok_model->update_rooms($rooms);
            echo "<pre>";
            print_r($response);
            $result_data["ostrovok"] = $response;
        }
        
        /*
         * Выгрузка загружености с expedia
         */
        
        $general_update_expedia = 0;
        $sql = "SELECT int_value FROM dc_expedia_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query($sql);
        
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $general_update_expedia = $row->int_value;
        }
        
        $expedia_result = array();
        if ($general_update_expedia == 1) {
            
            $query = $this->db->query("SELECT int_value FROM dc_expedia_xml_cfg WHERE name LIKE 'hotel_id'");
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $hotel_id = $row->int_value;
            } else {
                $hotel_id = "none";
            }
            $dc_rooms = array();
            $sql = "SELECT  dc_expedia_room_categories_link.*  FROM  dc_expedia_room_categories_link ";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                foreach ($query->result() as $row) {
                    $dc_rooms[$row->hms_category_id] = $row->dc_category_id;
                }
            }
            
            // $rooms = $this->dc_expedia_model->GetFreeRooms ( $datein,
            // $dateout, $dc_hotelid );
            
            $category_keys = array_keys($categories_rooms_all_expedia);
            $roomsresult = array();
            foreach ($category_keys as $category_id) {
                
                $sql = "select min, max from dc_expedia_room_categories_link where hms_category_id =" . $category_id;
                $query = $this->db->query($sql);
                if ($query->num_rows() > 0) {
                    $row2 = $query->row();
                    $min = $row2->min;
                    $max = $row2->max;
                } else {
                    $min = 0;
                    $max = 999;
                }
                
                if (! isset($dc_rooms[$category_id])) {
                    unset($categories_rooms_all_expedia[$category_id]);
                    continue;
                }
                $arr_intdate_keys = array_keys($categories_rooms_all_expedia[$category_id]);
                foreach ($arr_intdate_keys as $intdate) {
                    if (isset($categories_rooms_intdate_expedia[$category_id][$intdate])) {
                        $categories_rooms_all_expedia[$category_id][$intdate]["count"] = $categories_rooms_all_expedia[$category_id][$intdate]["count"] - $categories_rooms_intdate_expedia[$category_id][$intdate];
                        // echo "-";
                    } else {
                        // $categories_rooms_all [$category_id] [$i] ["free"] =
                        // 0;
                        // ??
                        // echo "+";
                    }
                    
                    if ($categories_rooms_all_expedia[$category_id][$intdate]["count"] > $min) {
                        $categories_rooms_all_expedia[$category_id][$intdate]["count"] = $categories_rooms_all_expedia[$category_id][$intdate]["count"] - $min;
                    } else {
                        $categories_rooms_all_expedia[$category_id][$intdate]["count"] = 0;
                    }
                    
                    if ($categories_rooms_all_expedia[$category_id][$intdate]["count"] > $max) {
                        $categories_rooms_all_expedia[$category_id][$intdate]["count"] = $max;
                    }
                    
                    $categories_rooms_all_expedia[$category_id][$intdate]['plan_date_start_at'] = gmdate("Y-m-d", $intdate * 86400);
                    $categories_rooms_all_expedia[$category_id][$intdate]['plan_date_end_at'] = gmdate("Y-m-d", $intdate * 86400);
                    // $categories_rooms_all [$category_id] [$i] ['hms_cat_id']
                    // =
                    // $category_id;
                    $categories_rooms_all_expedia[$category_id][$intdate]['room_category'] = $dc_rooms[$category_id];
                    $categories_rooms_all_expedia[$category_id][$intdate]['hotel'] = $hotel_id;
                    ksort($categories_rooms_all_expedia[$category_id][$intdate]);
                    array_push($roomsresult, $categories_rooms_all_expedia[$category_id][$intdate]);
                }
            }
            
            $rooms = $roomsresult;
            
            echo "<pre>";
            // print_r ( $restrict );
            print_r($rooms);
            // die();
            $response = $this->dcm_expedia->update_rooms($rooms);
            echo "<pre>";
            print_r($response);
            $result_data["expedia"] = $response;
        }
        
        if ($general_update_ostrovok != 0 or $general_update_booking != 0 or $general_update_expedia != 0)
            $query = $this->db->query("DELETE FROM dc_log WHERE id <=" . $last_id . " AND dc_id = 4");
        if ($general_update_ostrovok == 0 and $general_update_booking == 0 and $general_update_expedia == 0) {
            echo "Ban upload for 2 services";
        } else {
            return $result_data;
        }
    }

    function dc_log_delete()
    {
        $this->frontdesk->dc_log_delete();
    }

    function GetFreeRooms_dc_booking_array($array)
    {
        // echo "<pre>";
        // print_r ( $array );
        if (count($array) != 0) {
            $select_categories = " categories.id IN (";
            $arr_caegory_keys = array_keys($array);
            $i = 0;
            foreach ($arr_caegory_keys as $category) {
                $i ++;
                if ($i == count($array)) {
                    $select_categories .= $category;
                } else {
                    $select_categories .= $category . ",";
                }
            }
            $select_categories .= ") ";
            // echo strlen ( $select_categories );
        } else {
            $select_categories = " categories. is_active = 1";
        }
        // echo $select_categories;
        // die();
        $select_intdays = " 1 ";
        $select_deskofdaysseason_intdays = " ";
        $categories_rooms_all = array();
        $sql = "SELECT categories.id, COUNT(rooms.id) as count_rooms FROM `rooms` INNER JOIN categories ON categories.id = rooms.category_id  WHERE rooms.dc_active=1 AND $select_categories GROUP BY rooms.category_id";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $select_intdays = " deskofdays.intdate IN (";
            $select_deskofdaysseason_intdays = " deskofdaysseason.intdate IN (";
            
            foreach ($query->result() as $row) {
                $arr_intdate_keys = array_keys($array[$row->id]);
                $i = 0;
                foreach ($arr_intdate_keys as $intdate) {
                    $i ++;
                    // echo count ( $array [$row->id] ) . "<br>";
                    if ($i == count($array[$row->id])) {
                        $select_intdays .= $intdate;
                        $select_deskofdaysseason_intdays .= $intdate;
                    } else {
                        $select_intdays .= $intdate . ",";
                        $select_deskofdaysseason_intdays .= $intdate . ",";
                    }
                    
                    $categories_rooms_all[$row->id][$intdate]["free"] = $row->count_rooms;
                    $categories_rooms_all[$row->id][$intdate]["date"] = gmdate("Y-m-d", $intdate * 86400);
                }
            }
            $select_intdays .= ") ";
            $select_deskofdaysseason_intdays .= ") ";
        }
        
        // echo "<pre>";
        // print_r($categories_rooms_all);
        
        $categories_rooms_intdate = array();
        $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms
		FROM `rooms`
		INNER JOIN categories ON categories.id = rooms.category_id
		INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
		WHERE $select_intdays 
		GROUP BY deskofdays.intdate, rooms.category_id";
        
        // echo $sql;
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $categories_rooms_intdate[$row->id][$row->intdate]["free"] = $row->count_rooms;
            }
        }
        // echo "<pre>";
        // print_r($categories_rooms_intdate);
        
        $category_keys = array_keys($categories_rooms_all);
        foreach ($category_keys as $category_id) {
            
            $sql = "select min, max from dc_booking_rooms_link where category_id =" . $category_id;
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $row2 = $query->row();
                $min = $row2->min;
                $max = $row2->max;
            } else {
                $min = 0;
                $max = 999;
            }
            
            $arr_intdate_keys = array_keys($array[$category_id]);
            foreach ($arr_intdate_keys as $intdate) {
                if (isset($categories_rooms_intdate[$category_id][$intdate])) {
                    $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $categories_rooms_intdate[$category_id][$intdate]["free"];
                    // echo "-";
                } else {
                    // $categories_rooms_all [$category_id] [$intdate] ["free"]
                    // = 0;
                    // ??
                    // echo "+";
                }
                
                if ($categories_rooms_all[$category_id][$intdate]["free"] > $min) {
                    $categories_rooms_all[$category_id][$intdate]["free"] = $categories_rooms_all[$category_id][$intdate]["free"] - $min;
                } else {
                    $categories_rooms_all[$category_id][$intdate]["free"] = 0;
                }
                
                if ($categories_rooms_all[$category_id][$intdate]["free"] > $max) {
                    $categories_rooms_all[$category_id][$intdate]["free"] = $max;
                }
            }
        }
        // echo "<pre>";
        echo "<pre>";
        print_r($categories_rooms_all);
        
        return $categories_rooms_all;
    }

    function dc_currency($arg)
    {
        return number_format($arg, 2, '.', '');
        // return round($arg / 1);
    }

    function dc_rate_intdate_insert($data)
    {
        $count = count($data);
        if ($count != 0) {
            $query = $this->db->query("DELETE FROM dc_booking_rate_intdate WHERE dc_reservation_id = " . $data[0]["dc_reservation_id"]);
            for ($i = 0; $i < $count; $i ++) {
                $sql = "INSERT INTO dc_booking_rate_intdate (dc_reservation_id, dc_rate_id, intdate, price) VALUES('" . $data[$i]["dc_reservation_id"] . "',
		'" . $data[$i]["dc_rate_id"] . "', '" . $data[$i]["intdate"] . "', '" . $data[$i]["price"] . "')
		ON DUPLICATE KEY UPDATE price = '" . $data[$i]["price"] . "'";
                // echo $sql."<br>";
                $query = $this->db->query($sql);
            }
        }
    }

    function dc_save_error($dc_id, $body, $db_name = "", $warning = 0)
    {
        $hotel_id = 0;
        $sql = "SELECT * FROM visitka.config WHERE db_name LIKE '$db_name'";
        $query = $this->db->query($sql);
        if ($query->num_rows() != 0) {
            $row = $query->row();
            $hotel_id = $row->id;
        }
        $query = $this->db->query("INSERT INTO dc_log_errors (dc_id, time, body, warning) VALUES(" . $dc_id . ", " . time() . ", '" . addslashes($body) . "', $warning)");
        $query = $this->db->query("INSERT INTO  global_hotelix.dc_log_errors (dc_id,hotel_id, time, body, warning) VALUES(" . $dc_id . ", " . $hotel_id . ", " . time() . ", '" . addslashes($body) . "', $warning)");
    }
    
    function booking_import_room_rates($dc_hotel_id)
    {
        $url = $this->config->item('dc_booking_xml_host') . "hotels/xml/roomrates";
        $dc_user = $this->config->item ( 'dc_booking_xml_user' );
        $dc_password = $this->config->item ( 'dc_booking_xml_pwd' );
    
        $txt = <<<EOT
<request>
<username>$dc_user</username>
<password>$dc_password</password>
<hotel_id>$dc_hotel_id</hotel_id>
<version>1.0</version>
</request>
EOT;
        $data_result = $this->Curl_model->CurlPlugRAW ( $txt, $url, 1, array (
            "returntype" => "array"
        ));
    
        $result = $data_result["result"];
        $responce_data = new SimpleXMLElement ( $result );
        //echo "<pre>";
        //print_r($responce_data);
    
        $responce_data_array = json_decode(json_encode($responce_data, true), true);
        //echo "<pre>";
        //print_r($responce_data_array);
        //die();
        $booking_data_link = array();
        //$booking_data_rates = array();
        //$booking_data_rooms = array();
        
        if (isset($responce_data_array["room"])) {
            $response_valid = $responce_data_array["room"];
        }elseif(isset($responce_data_array["rooms"]["room"])){
            $response_valid = $responce_data_array["rooms"]["room"];
        }
        //print_r($response_valid);
        if (isset($response_valid)) {
            $room_cell = array();
            if (isset($response_valid[0])) {
                $room_cell = $response_valid;
            } else {
                $room_cell[0] = $response_valid;
            }
            foreach ($room_cell as $cell) {
                $dc_room_id = $cell["@attributes"]["id"];
                if (isset($cell["rates"]["rate"])) {
                    if (isset($cell["rates"]["rate"][0])) {
                        foreach ($cell["rates"]["rate"] as $rate_data) {
                            $dc_rate_id = $rate_data["@attributes"]["id"];
                            $booking_data_link[$dc_room_id][$dc_rate_id] = 1;
                        }
                    } else {
                        $dc_rate_id = $cell["rates"]["rate"]["@attributes"]["id"];
                        $booking_data_link[$dc_room_id][$dc_rate_id] = 1;
                    }
                }
            }
        }
         
        // get hms rooms rates links from DB
        $hms_booking_data_link = array();
        $sql = "SELECT dc_booking_rate2category_link.dc_rate_id, dc_booking_rate2category_link.dc_category_id FROM dc_booking_rate2category_link 
        INNER JOIN dc_booking_rates ON dc_booking_rates.dc_rate_id = dc_booking_rate2category_link.dc_rate_id 
        INNER JOIN dc_booking_rooms_link ON dc_booking_rooms_link.dc_room_id = dc_booking_rate2category_link.dc_category_id 
        WHERE dc_booking_rates.dc_hotel_id = $dc_hotel_id AND dc_booking_rooms_link.dc_hotel_id = $dc_hotel_id";
        $query = $this->db->query ( $sql );
        foreach ( $query->result () as $row ) {
            $hms_booking_data_link[$row->dc_category_id][$row->dc_rate_id] = 1;
        }
         
//         echo "<pre>";
//         print_r($booking_data_link);
//         echo "++++";
//         print_r($hms_booking_data_link);
//         die();
        
        // get hms rooms rates from DB
        //             $hms_booking_data_rates = array();
        //             $sql = "SELECT dc_rate_id FROM dc_booking_rates WHERE dc_hotel_id = ".$dc_hotel_id;
        //             $query = $this->db->query ( $sql );
        //             foreach ( $query->result () as $row ) {
        //                 $hms_booking_data_rates[$row->dc_rate_id] = 1;
        //             }
         
//         echo "<pre>";
//         print_r($booking_data_link);
//         print_r($hms_booking_data_link);
//         die(); 
        // delete hms rates
        // 	        foreach($hms_booking_data_rates as $dc_rate_id => $value){
        // 	           if(!isset($booking_data_rates[$dc_rate_id])){
        // 	               $sql = "DELETE FROM dc_booking_rates WHERE dc_rate_id = $dc_rate_id AND dc_hotel_id = $dc_hotel_id";
        // 	               $query = $this->db->query ( $sql );
        // 	               $sql = "DELETE FROM dc_booking_rates_link WHERE dc_rate_id = $dc_rate_id AND dc_hotel_id = $dc_hotel_id";
        // 	               $query = $this->db->query ( $sql );
        // 	           }
        // 	        }
         
        foreach($hms_booking_data_link as $dc_room_id => $rate_cell){
            // delete hms rooms
            // 	            if(!isset($booking_data_link[$dc_room_id])){
            // 	                $sql = "DELETE FROM dc_booking_rooms_link WHERE dc_room_id = $dc_room_id AND dc_hotel_id = $dc_hotel_id";
            // 	                $query = $this->db->query ( $sql );
            // 	                $sql = "DELETE FROM dc_booking_category2occupancy WHERE dc_category_id = $dc_room_id";
            // 	                $query = $this->db->query ( $sql );
            // 	            }
            // delete hms rooms-rates links
            foreach($rate_cell as $dc_rate_id => $value){
                if(!isset($booking_data_link[$dc_room_id][$dc_rate_id])){
                    $sql = "DELETE FROM dc_booking_rate2category_link WHERE dc_rate_id = $dc_rate_id AND dc_category_id = $dc_room_id";
                    $query = $this->db->query ( $sql );
                }
            }
        }
         
    }
    
    function get_reviews($property_id = null)
    {
    
        //$property_id = 361674;
        if ($property_id == null) {
            exit('No hotel_id provided');
        }
    
        $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
        // $auth = html_entity_decode('otelmsxml3:1-L^&#43;!bOE31e&gt;BZbXBM=Z2AUx8M(wF');
         
    
        $headers = array(
            'Authorization: Basic ' . base64_encode($auth)
        );
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://supply-xml.booking.com/review-api/properties/' . $property_id . '/reviews?from_date=2012-05-01&limit=100');
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $buffer = curl_exec($ch);
        curl_close($ch);
        $result = json_decode($buffer, true);
//         echo "<pre>";
//         print_r($result);
//         die();
        
        return $result;
    }
    
    function get_reviews_data($property_id = null, $review_id = null)
    {
        if( $property_id == null || $review_id == null ){ exit('No hotel_id or review_id provided'); }
        
        $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
        //$auth = html_entity_decode('otelmsxml3:1-L^&#43;!bOE31e&gt;BZbXBM=Z2AUx8M(wF');
         $headers = array(
            'Authorization: Basic ' . base64_encode($auth)
        );
        $ch = curl_init();
        curl_setopt(
            $ch,
            CURLOPT_URL,
            'https://supply-xml.booking.com/review-api/properties/' . $property_id . '/reviews/' . $review_id
            );
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $buffer = curl_exec($ch);
        curl_close($ch);
        $result = json_decode($buffer, true);
        
        return $result;
    }
    
    function save_is_no_show_option($data){
        $this->db->insert("dc_booking_is_no_show", $data);
    }
    
    function get_payment_data($data){
        $dc_reservation_id = $data ['dc_reservationid'];
        $dc_roomreservation_id = $data ['dc_roomreservation_id'];
    
        if ($dc_reservation_id != "") {
            $dc_hotel_id = 0;
            $sql = "SELECT dc_booking_rooms_link.dc_hotel_id FROM deskofreservation as t_1
            INNER JOIN rooms ON rooms.id = t_1.room_id
            INNER JOIN categories ON categories.id = rooms.category_id
            INNER JOIN dc_booking_rooms_link ON dc_booking_rooms_link.category_id = categories.id
            WHERE t_1.dc_reservationid = $dc_reservation_id";
            //echo $sql;
            $query = $this->db->query( $sql );
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $dc_hotel_id = $row->dc_hotel_id;
            }
            if ($dc_hotel_id > 0) {
                // $hotel_id = "4956";
                $output = array();
                $url = $this->config->item('dc_booking_xml_secure_host') . "hotels/xml/reservations";
                $xml = "<request>";
                $xml .= "<username>" . $this->config->item('dc_booking_xml_user') . "</username>";
                $xml .= "<password>" . $this->config->item('dc_booking_xml_pwd') . "</password>";
                $xml .= "<hotel_id>" . $dc_hotel_id . "</hotel_id>";
                $xml .= "<id>" . $dc_reservation_id . "</id>";
                $xml .= "</request>";
    
                $headers = array();
                $headers[] = "Features: include_price_details";
                $headers[] = "Cache-Control: no-cache";
                $data_result = $this->Curl_model->CurlPlugRAW($xml, $url, 1, array(
                    "returntype" => "array",
                    "headers" => $headers
                ));
                $result = $data_result["result"];
    
                $reservations = new SimpleXMLElement($result);
                echo "<pre>111";
                print_r($reservations);
                //die("debug");
                $cc_cvc = "";
                $cc_expmonth = "";
                $cc_expyear = "";
                $cardholder = "";
                $cardnumber = "";
                $cc_type = "";
                $cc_activation_date = "";
                $cc_current_balance = "";
                $vcc_expiration_date = "";
    
                $payments_currencycode = "";
                $payments_amount = 0;
                foreach ($reservations->reservation as $reservation) {
                    if (isset ( $reservation->reservation_extra_info->payer->payments )) {
                        $payments_currencycode = $reservation->reservation_extra_info->payer->payments->payment["currency"];
                        $payments_amount = $reservation->reservation_extra_info->payer->payments->payment["amount"];
                        
                        $cc_cvc = (string) $reservation->customer->cc_cvc;
                        if ((string) $reservation->customer->cc_expiration_date !== "") {
                            list ($cc_expmonth, $cc_expyear) = explode("/", $reservation->customer->cc_expiration_date);
                        }
                        $cardholder = (string) $reservation->customer->cc_name;
                        $cardnumber = (string) $reservation->customer->cc_number;
                        $cc_type = (string) $reservation->customer->cc_type;
                        $cc_activation_date = (string) $reservation->customer->cc_activation_date;
                        $cc_current_balance = (string) $reservation->customer->cc_current_balance;
                        $vcc_expiration_date = (string) $reservation->customer->vcc_expiration_date;
                        break;
                    }
                    
                    
                }
    
                $return_data = array();
                $return_data ['card'] = array();
                $return_data ['card']['cc_cvc'] = $cc_cvc;
                $return_data ['card']['ExpMonth'] = $cc_expmonth;
                $return_data ['card']['ExpYear'] = $cc_expyear;
                $return_data ['card']['CardHolder'] = $cardholder;
                $return_data ['card']['CardNumber'] = $cardnumber;
                $return_data ['card']['cc_type'] = $cc_type;
                $return_data ['card']['cc_activation_date'] = $cc_activation_date;
                $return_data ['card']['cc_current_balance'] = $cc_current_balance;
                $return_data ['card']['vcc_expiration_date'] = $vcc_expiration_date;
                $return_data ['payments_amount'] = $payments_amount;
                $return_data ['payments_currencycode'] = $payments_currencycode;
                return $return_data;
            }
        }
    }
    
    public function get_property_score( $property_id = null )
    {
        if( $property_id == null ){ exit('No hotel_id provided'); }
    
        $auth = $this->config->item('dc_booking_xml_user').':'.$this->config->item('dc_booking_xml_pwd');
        //$auth = html_entity_decode('otelmsxml3:1-L^&#43;!bOE31e&gt;BZbXBM=Z2AUx8M(wF');
        $headers = array(
            'Authorization: Basic ' . base64_encode($auth),
        );
        $ch = curl_init();
        curl_setopt(
            $ch,
            CURLOPT_URL,
            'https://supply-xml.booking.com/property-scores/properties/' . $property_id . '/breakdown'
            );
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $buffer = curl_exec($ch);
        curl_close($ch);
        $result = json_decode($buffer, true);
        //echo "<pre>";
        //print_r($result);
        //die();
        
        return $result;
        //var_dump( $result );
    }
    
    function get_dc_hotel_ids($return_format = 0){
        $data = array();
        $sql = "SELECT int_value FROM dc_booking_xml_cfg WHERE name LIKE 'hotel_id' AND dc_account_id > 0";
        $query = $this->db->query ( $sql );
        foreach ( $query->result () as $row ) {
            if($return_format == 0){
                array_push($data, $row->int_value);
            }else{
                $data[$row->int_value] = 1;
            }
        }
        
        return $data;
    }
}
	 
