<?php

class dcm_airbnb extends CI_Model
{
    private $daily_price_new; // нова ціна з врахуванням $daily_price_percent
    private $daily_price_percent = 25; // відсоток по daily_price
    public function __construct()
    {
        parent::__construct();
        $this->load->model ( 'curl_model' );
    }
    
    function get_sync_type() {
        $data = array();
        
        $data [0] ['sync_type_id'] = 0;
        $data [0] ['sync_type_caption'] = "---";
        $data [0] ['sync_type_selected'] = "";
        $data [1] ['sync_type_id'] = 1;
        $data [1] ['sync_type_caption'] = "sync_all";
        $data [1] ['sync_type_selected'] = "";
        $data [2] ['sync_type_id'] = 2;
        $data [2] ['sync_type_caption'] = "sync_rates_and_availability";
        $data [2] ['sync_type_selected'] = "";
        
        return $data;
    }
    
    function get_sync_type2() {
        $data = array();
        $data [0] ['sync_type_caption'] = "{clt_sync_all}";
        $data [0] ['sync_type_selected'] = "";
        $data [1] ['sync_type_caption'] = "{clt_sync_rates_and_availability}";
        $data [1] ['sync_type_selected'] = "";
        
        return $data;
    }
    function get_sync_type_select_arr() {
        $data = array();
        $data ['sync_all'] ['type_val'] = "sync_all";
        $data ['sync_all'] ['type_clt'] = "{clt_sync_all}";
        $data ['sync_all'] ['selected'] = "";
        $data ['sync_rates_and_availability'] ['type_val'] = "sync_rates_and_availability";
        $data ['sync_rates_and_availability'] ['type_clt'] = "{clt_sync_rates_and_availability}";
        $data ['sync_rates_and_availability'] ['selected'] = "";
        
        return $data;
    }
    
    function authparam() {
        $data = array();
        
        $airbnb_testmode = $this->frontdesk_c2->get_airbnb_testmode_value();
        if($airbnb_testmode == 1){// test mode
            $data['clientid'] = '358mz0fhnvyqrbh8hh6t0zuno';
            $data['clientsecret'] = 'au6i28gjyei0gh8ruhauwce8';
        }else{
            $data['clientid'] = 'awkk3fb3oa4o67f5zbjg8eees';
            $data['clientsecret'] = '39qswxnwqbatb6mipl0ahktyl';
        }
        return $data;
    }
    
    function get_airbnb_state(){
        $sql = "SELECT value FROM hotelix_config WHERE name LIKE 'airbnb_state'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows()) {
            $row = $query->row();
            return $row->value;
        } else {
            return 0;
        }
    }
    
    function is_room($room_id) {
        $sql = "SELECT id FROM rooms WHERE id =" . (integer) $room_id;
        $query = $this->db->query ( $sql );
        if ($query->num_rows()) {
            return 1;
        } else {
            return 0;
        }
    }
    
    function get_dc_airbnb_xml_cfg_value($name, $valuename = "str")
    {
        $query = $this->db->query("SELECT * FROM `dc_airbnb_xml_cfg` WHERE name LIKE '" . $name . "'");
        $result = "";
        if ($valuename == "int") {
            $result = 0;
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $result = $row->int_value;
            }
        } elseif ($valuename == "str") {
            $result = "";
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $result = $row->str_value;
            }
        }
        return $result;
    }
    
    function deactivate(){
        //з конфігу
        
        $refresh_token = $this->dcm_airbnb->getxmlcfgvalue('refresh_token', 'str');
        
        $authparam = $this->dcm_airbnb->authparam();
        $clientid = $authparam['clientid'];
        $clientsecret = $authparam['clientsecret'];
        
        $auth = $clientid . ':' . $clientsecret;
        
        $headers = array(
            'Content-Type:application/json',
            'Authorization: Basic ' . base64_encode($auth),
        );
        $url = 'https://api.airbnb.com/v2/oauth2/authorizations/' . $refresh_token . '?_unwrapped=true';
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');
        $buffer = curl_exec($ch);
        curl_close($ch);
        $result = json_decode($buffer, true);
        
        if ($result['valid'] == false) {
            $query = $this->db->query("UPDATE `dc_airbnb_xml_cfg` SET str_value = '' WHERE name LIKE 'authcode'");
            $query = $this->db->query("TRUNCATE dc_airbnb_importtolisting");
            $query = $this->db->query("TRUNCATE dc_airbnb_listings");
            $query = $this->db->query("TRUNCATE dc_airbnb_listings_details");
            $query = $this->db->query("TRUNCATE dc_airbnb_listingtocategory");
            //$query = $this->db->query("UPDATE `dc_airbnb_xml_cfg` SET str_value = '' WHERE name LIKE 'refresh_token'");
            //$query = $this->db->query("UPDATE `dc_airbnb_xml_cfg` SET str_value = '' WHERE name LIKE 'access_token'");
        }
        
    }
    
    function set_state($state){
        $sql = "INSERT INTO  hotelix_config (name, value) VALUES('airbnb_state', '" . $state . "') ON DUPLICATE KEY UPDATE value = " . $state;
        $query = $this->db->query ( $sql );
    }
    
    function get_beds_list() {
        $data = array();
        //         $data[1] = "king_bed";
        //         $data[2] = "queen_bed";
        //         $data[3] = "double_bed";
        //         $data[4] = "single_bed";
        //         $data[5] = "sofa_bed";
        //         $data[6] = "futon_bed";
        //         $data[7] = "floor_mattress";
        //         $data[8] = "bunk_bed";
        //         $data[9] = "toddler_bed";
        //         $data[10] = "crib";
        //         $data[11] = "hammock";
        //         $data[12] = "air_mattress";
        //         $data[13] = "water_bed";
        //         $data[14] = "couch";
        
        $query_res = $this->db->get_where('global_hotelix_common.bed_types', 'airbnb IS NOT NULL')->result();
        foreach ($query_res as $bed_type_data) {
            $data[$bed_type_data->airbnb] = $bed_type_data->clt_name;
        }
        
        return $data;
    }
    
    function get_beds_list_options() {
        $data = array();
        //     	$data[1]["bed_id"] = 1;
        //     	$data[1]["bed_name"] = "{-king_bed-}";
        //     	$data[1]["bed_selected"] = "";
        //     	$data[2]["bed_id"] = 2;
        //     	$data[2]["bed_name"] = "{-queen_bed-}";
        //     	$data[2]["bed_selected"] = "";
        //     	$data[3]["bed_id"] = 3;
        //     	$data[3]["bed_name"] = "{-double_bed-}";
        //     	$data[3]["bed_selected"] = "";
        //     	$data[4]["bed_id"] = 4;
        //     	$data[4]["bed_name"] = "{-single_bed-}";
        //     	$data[4]["bed_selected"] = "";
        //     	$data[5]["bed_id"] = 5;
        //     	$data[5]["bed_name"] = "{-sofa_bed-}";
        //     	$data[5]["bed_selected"] = "";
        //     	$data[6]["bed_id"] = 6;
        //     	$data[6]["bed_name"] = "{-futon_bed-}";
        //     	$data[6]["bed_selected"] = "";
        //     	$data[7]["bed_id"] = 7;
        //     	$data[7]["bed_name"] = "{-floor_mattress-}";
        //     	$data[7]["bed_selected"] = "";
        //     	$data[8]["bed_id"] = 8;
        //     	$data[8]["bed_name"] = "{-bunk_bed-}";
        //     	$data[8]["bed_selected"] = "";
        //     	$data[9]["bed_id"] = 9;
        //     	$data[9]["bed_name"] = "{-toddler_bed-}";
        //     	$data[9]["bed_selected"] = "";
        //     	$data[10]["bed_id"] = 10;
        //     	$data[10]["bed_name"] = "{-crib-}";
        //     	$data[10]["bed_selected"] = "";
        //     	$data[11]["bed_id"] = 11;
        //     	$data[11]["bed_name"] = "{-hammock-}";
        //     	$data[11]["bed_selected"] = "";
        //     	$data[12]["bed_id"] = 12;
        //     	$data[12]["bed_name"] = "{-air_mattress-}";
        //     	$data[12]["bed_selected"] = "";
        //     	$data[13]["bed_id"] = 13;
        //     	$data[13]["bed_name"] = "{-water_bed-}";
        //     	$data[13]["bed_selected"] = "";
        //     	$data[14]["bed_id"] = 14;
        //     	$data[14]["bed_name"] = "{-couch-}";
        //     	$data[14]["bed_selected"] = "";
        
        $query_res = $this->db->get_where('global_hotelix_common.bed_types', 'airbnb IS NOT NULL')->result();
        foreach ($query_res as $bed_type_data) {
            $data[$bed_type_data->airbnb]["bed_id"] = $bed_type_data->airbnb;
            $data[$bed_type_data->airbnb]["bed_name"] = "{-$bed_type_data->clt_name-}";
            $data[$bed_type_data->airbnb]["bed_selected"] = "";
        }
        return $data;
    }
    
    function options_save($data) {
        $data_1 = $this->Loger_admin->get_values_col("dc_airbnb_xml_cfg");
        $data ["room_page_version"] = 1; //вибір версії, версія має бути 2, хардкорно при збережені ставити 2, форсувати збереження в версію 2// ver2 - id=1
        
        $sql = "INSERT INTO dc_airbnb_xml_cfg (name, int_value) VALUES('dealer_id', '" . $data ["dealer"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["dealer"];
        $query = $this->db->query ( $sql );
        $sql = "INSERT INTO dc_airbnb_xml_cfg (name, int_value) VALUES('rate_id', '" . $data ["rate"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["rate"];
        $query = $this->db->query ( $sql );
        $sql = "INSERT INTO dc_airbnb_xml_cfg (name, int_value) VALUES('restrict_rate_id', '" . $data ["restrict_rate"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["restrict_rate"];
        $query = $this->db->query ( $sql );
        $sql = "INSERT INTO dc_airbnb_xml_cfg (name, int_value) VALUES('overbooking_category_id', '" . $data ["overbooking_category"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["overbooking_category"];
        $query = $this->db->query ( $sql );
        $sql = "INSERT INTO dc_airbnb_xml_cfg (name, int_value) VALUES('general_update', '" . $data ["general_update"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["general_update"];
        $query = $this->db->query ( $sql );
        $sql = "INSERT INTO dc_airbnb_xml_cfg (name, int_value) VALUES('room_page_version', '" . $data ["room_page_version"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["room_page_version"];
        $query = $this->db->query ( $sql );
        $sql = "INSERT INTO dc_airbnb_xml_cfg (name, int_value) VALUES('upload_deep', '" . $data ["upload_deep"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["upload_deep"];
        $query = $this->db->query ( $sql );
        $sql = "INSERT INTO dc_airbnb_xml_cfg (name, int_value) VALUES('service_type_id', '" . $data ["service_type_id"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["service_type_id"];
        $query = $this->db->query ( $sql );
        
        $data_2 = $this->Loger_admin->get_values_col("dc_airbnb_xml_cfg");
        $this->Loger_admin->SaveLog_col($data_1, $data_2, "loger_admin", "dc_airbnb_xml_cfg", "edit");
    }
    
    function getxmlcfgvalue($name, $type)
    {
        if ($type == 'str') {
            $query = $this->db->query("select str_value as value from dc_airbnb_xml_cfg where name = '$name'");
            if ($query->num_rows()) {
                $row = $query->row();
                return $row->value;
            } else {
                return 0;
            }
        }
        
        if ($type == 'int') {
            $query = $this->db->query("select int_value as value from dc_airbnb_xml_cfg where name = '$name'");
            if ($query->num_rows()) {
                $row = $query->row();
                return $row->value;
            } else {
                return 0;
            }
        }
    }
    
    function get_RA($room_id, $rate_id, $shift_from, $shift_to) {
        $today_date = date("Y-m-d");
        
        list ( $year, $month, $day ) = explode ( "-", $today_date );
        $intdate_today = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        
        $intdate_from = $intdate_today + $shift_from;
        $intdate_to = $intdate_today + $shift_to;
        $date_from = date( "Y-m-d", ($intdate_today + $shift_from) * 86400 );
        $date_to = date( "Y-m-d", ($intdate_today + $shift_to) * 86400 );
        
        $sql = "SELECT category_id FROM rooms WHERE id = ".$room_id;
        $query = $this->db->query( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $category_id = $row->category_id;
        }
        
        
        $availability_array = array();
        $price_array = array();
        for($i = $intdate_from; $i <= $intdate_to; $i++){
            $availability_array[$i]["date"] = date( "Y-m-d", $i * 86400 );
            $availability_array[$i]["availability"] = 1;
            
            $price_array[$i]["date"] = date( "Y-m-d", $i * 86400 );
            $price_array[$i]["price"] = 0;
        }
        
        $not_available_array = array();
        $sql = "SELECT * from deskofdays WHERE room_id = ".$room_id." AND intdate >= ".$intdate_from." AND intdate <= ".$intdate_to;
        //echo $sql;
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $k = 0;
            foreach ( $query->result () as $row ) {
                if (isset($availability_array[$row->intdate])){
                    $availability_array[$i]["availability"] = 0;
                }
            }
        }
        
        $prices = $this->frontdesk_c2->get_prices($intdate_from, $intdate_to, $category_id, $rate_id);
        
        $yield_prices = $this->frontdesk_c2->get_yield_prices($intdate_from, $intdate_to, $category_id, $rate_id);
        
        foreach($price_array as $intdate => $cell){
            if(isset($prices[$category_id][$rate_id][$intdate])){
                $price_array[$intdate]["price"] = $prices[$category_id][$rate_id][$intdate]["price"];
            }
            if(isset($yield_prices[$category_id][$rate_id][$intdate])){
                $price_array[$intdate]["price"] = $yield_prices[$category_id][$rate_id][$intdate]["price"];
            }
        }
        
        $result_array = array();
        
        $result_array ["start_date"] = $date_from;
        $result_array ["end_date"] = $date_to;
        
        $result_array ["availability"] = $availability_array;
        $result_array ["prices"] = $price_array;
        
        //         echo "<pre>";
        //         print_r($result_array);
        //         die();
        
        return $result_array;
    }
    
    function get_prices($room_id, $rate_id, $shift_from, $shift_to, $category_id = 0) {
        $today_date = date("Y-m-d");
        
        list ( $year, $month, $day ) = explode ( "-", $today_date );
        //$intdate_today = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        $intdate_today = round ( gmmktime ( 0, 0, 0, $month, $day - 1, $year ) / 86400 );
        
        $intdate_from = $intdate_today + $shift_from;
        $intdate_to = $intdate_today + $shift_to;
        $date_from = date( "Y-m-d", ($intdate_today + $shift_from) * 86400 );
        $date_to = date( "Y-m-d", ($intdate_today + $shift_to) * 86400 );
        
        if ($category_id == 0) {
            $sql = "SELECT category_id FROM rooms WHERE id = " . $room_id;
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $category_id = $row->category_id;
            }
        }
        
        
        $availability_array = array();
        $price_array = array();
        for($i = $intdate_from; $i <= $intdate_to; $i++){
            $price_array[$i]["from"] = date( "Y-m-d", $i * 86400 );
            $price_array[$i]["to"] = date( "Y-m-d", $i * 86400 );
            $price_array[$i]["price"] = 0;
            $price_array[$i]["price_line"] = "";
        }
        
        $prices = $this->frontdesk_c2->get_prices($intdate_from, $intdate_to, $category_id, $rate_id);
        
        $yield_prices = $this->frontdesk_c2->get_yield_prices($intdate_from, $intdate_to, $category_id, $rate_id);
        
        foreach($price_array as $intdate => $cell){
            if(isset($prices[$category_id][$rate_id][$intdate])){
                $price_array[$intdate]["price"] = round($prices[$category_id][$rate_id][$intdate]["price"]);
            }
            if(isset($yield_prices[$category_id][$rate_id][$intdate])){
                $price_array[$intdate]["price"] = round($yield_prices[$category_id][$rate_id][$intdate]["price"]);
            }
            
            if( $price_array[$intdate]["price"] == 0){
                unset( $price_array[$intdate]);
            }
        }
        
        foreach ($price_array as $intdate => $cell) {
            $prev = $intdate - 1;
            if (isset($price_array[$prev])) {
                $price_1 = $price_array[$prev]["price"];
                $price_2 = $price_array[$intdate]["price"];
                
                if ($price_1 == $price_2) {
                    $price_array[$intdate]["from"] = $price_array[$prev]["from"];
                    unset($price_array[$prev]);
                }
            }
        }
        
        foreach ($price_array as $intdate => $cell) {
            list ( $year, $month, $day ) = explode ( "-", $cell["from"] );
            $int_from = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
            
            list ( $year, $month, $day ) = explode ( "-", $cell["to"] );
            $int_to = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
            
            for($i = $int_from; $i <= $int_to; $i++){
                if($i == $int_to){
                    $price_array[$intdate]["price_line"] .= $price_array[$intdate]["price"];
                }else{
                    $price_array[$intdate]["price_line"] .= $price_array[$intdate]["price"].",";
                }
            }
        }
        
        $result_array = array();
        
        $result_array ["start_date"] = $date_from;
        $result_array ["end_date"] = $date_to;
        
        $result_array ["prices"] = $price_array;
        
        
        return $result_array;
    }
    
    function get_availability($room_id, $shift_from, $shift_to) {
        $today_date = date("Y-m-d");
        
        list ( $year, $month, $day ) = explode ( "-", $today_date );
        $intdate_today = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        
        $intdate_from = $intdate_today + $shift_from;
        $intdate_to = $intdate_today + $shift_to;
        $date_from = date( "Y-m-d", ($intdate_today + $shift_from) * 86400 );
        $date_to = date( "Y-m-d", ($intdate_today + $shift_to) * 86400 );
        
        $restrict_rate_id = 0;
        $sql = "SELECT int_value FROM dc_airbnb_xml_cfg WHERE name LIKE 'restrict_rate_id'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $restrict_rate_id = $row->int_value;
        }
        
        
        $availability_array = array();
        $price_array = array();
        for($i = $intdate_from; $i <= $intdate_to; $i++){
            $availability_array[$i]["from"] = date( "Y-m-d", $i * 86400 );
            $availability_array[$i]["to"] = date( "Y-m-d", $i * 86400 );
            $availability_array[$i]["availability"] = 1;
            $availability_array[$i]["period_min_nights"] = 1;
            $availability_array[$i]["availability_line"] = "";
            $availability_array[$i]["dailyChangeOver_line"] = "";
        }
        
        $not_available_array = array();
        $sql = "SELECT * from deskofdays WHERE room_id = ".$room_id." AND intdate >= ".$intdate_from." AND intdate <= ".$intdate_to;
        //echo $sql;
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $k = 0;
            foreach ( $query->result () as $row ) {
                if (isset($availability_array[$row->intdate])){
                    $availability_array[$row->intdate]["availability"] = 0;
                }
                
                // коррекція к-сті відповідно умовам ф-ї availability_count_correction
                $availability_array[$row->intdate]["availability"] = $this->frontdesk_c2->availability_count_correction($availability_array[$i]["availability"], $availability_array[$i]["from"], $availability_array[$i]["to"]);
            }
        }
        
        $restrict_data = array();
        $sql = "SELECT deskofrate.* from deskofrate
        INNER JOIN categories ON categories.id = deskofrate.category_id
        INNER JOIN rooms ON rooms.category_id = categories.id
        WHERE rooms.id = ".$room_id." AND deskofrate.rate_id = ".$restrict_rate_id." AND deskofrate.intdate >= ".$intdate_from." AND deskofrate.intdate <= ".$intdate_to;
        //echo $sql;
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $restrict_data[$row->intdate]["closed"] = $row->closed;
                $restrict_data[$row->intdate]["closedonarrival"] = $row->closedonarrival;
                $restrict_data[$row->intdate]["closedondeparture"] = $row->closedondeparture;
                $restrict_data[$row->intdate]["minstaythrought"] = $row->minstaythrought;
            }
        }
        
        foreach ($availability_array as $intdate => $cell) {
            $prev = $intdate - 1;
            if (isset($availability_array[$prev])) {
                $availability_1 = $availability_array[$prev]["availability"];
                $availability_2 = $availability_array[$intdate]["availability"];
                
                $minstaythrought_1 = "";
                $minstaythrought_2 = "";
                if(isset($restrict_data[$prev]["minstaythrought"])){
                    if($restrict_data[$prev]["minstaythrought"] > 0){
                        $minstaythrought_1 = $restrict_data[$prev]["minstaythrought"];
                    }
                }
                if(isset($restrict_data[$intdate]["minstaythrought"])){
                    if($restrict_data[$intdate]["minstaythrought"] > 0){
                        $minstaythrought_2 = $restrict_data[$intdate]["minstaythrought"];
                    }
                }
                
                if ($availability_1 == $availability_2 && $minstaythrought_1 == $minstaythrought_2) {
                    $availability_array[$intdate]["from"] = $availability_array[$prev]["from"];
                    unset($availability_array[$prev]);
                }
            }
        }
        
        foreach ($availability_array as $intdate => $cell) {
            list ( $year, $month, $day ) = explode ( "-", $cell["from"] );
            $int_from = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
            
            list ( $year, $month, $day ) = explode ( "-", $cell["to"] );
            $int_to = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
            
            if(isset($restrict_data[$intdate])){
                if($restrict_data[$intdate]["minstaythrought"] > 0){
                    $availability_array[$intdate]["period_min_nights"] = $restrict_data[$intdate]["minstaythrought"];
                }
            }
            
            for($i = $int_from; $i <= $int_to; $i++){
                if($i == $int_to){
                    if(isset($restrict_data[$i])){
                        if($restrict_data[$i]["closedonarrival"] == 0 && $restrict_data[$i]["closedondeparture"] == 0){
                            $availability_array[$intdate]["dailyChangeOver_line"] .= "D";
                        }
                        if($restrict_data[$i]["closedonarrival"] == 0 && $restrict_data[$i]["closedondeparture"] == 1){
                            $availability_array[$intdate]["dailyChangeOver_line"] .= "I";
                        }
                        if($restrict_data[$i]["closedonarrival"] == 1 && $restrict_data[$i]["closedondeparture"] == 0){
                            $availability_array[$intdate]["dailyChangeOver_line"] .= "O";
                        }
                        if($restrict_data[$i]["closedonarrival"] == 1 && $restrict_data[$i]["closedondeparture"] == 1){
                            $availability_array[$intdate]["dailyChangeOver_line"] .= "N";
                        }
                    }else{
                        $availability_array[$intdate]["dailyChangeOver_line"] .= "D";
                    }
                }else{
                    if(isset($restrict_data[$i])){
                        if($restrict_data[$i]["closedonarrival"] == 0 && $restrict_data[$i]["closedondeparture"] == 0){
                            $availability_array[$intdate]["dailyChangeOver_line"] .= "D,";
                        }
                        if($restrict_data[$i]["closedonarrival"] == 0 && $restrict_data[$i]["closedondeparture"] == 1){
                            $availability_array[$intdate]["dailyChangeOver_line"] .= "I,";
                        }
                        if($restrict_data[$i]["closedonarrival"] == 1 && $restrict_data[$i]["closedondeparture"] == 0){
                            $availability_array[$intdate]["dailyChangeOver_line"] .= "O,";
                        }
                        if($restrict_data[$i]["closedonarrival"] == 1 && $restrict_data[$i]["closedondeparture"] == 1){
                            $availability_array[$intdate]["dailyChangeOver_line"] .= "N,";
                        }
                    }else{
                        $availability_array[$intdate]["dailyChangeOver_line"] .= "D,";
                    }
                }
                if($availability_array[$intdate]["availability"] == 1){
                    if($i == $int_to){
                        if(isset($restrict_data[$i]["closed"])){
                            if($restrict_data[$i]["closed"] == 1){
                                $availability_array[$intdate]["availability_line"] .= "U";
                            }else{
                                $availability_array[$intdate]["availability_line"] .= "A";
                            }
                        }else{
                            $availability_array[$intdate]["availability_line"] .= "A";
                        }
                    }else{
                        if(isset($restrict_data[$i]["closed"])){
                            if($restrict_data[$i]["closed"] == 1){
                                $availability_array[$intdate]["availability_line"] .= "U,";
                            }else{
                                $availability_array[$intdate]["availability_line"] .= "A,";
                            }
                        }else{
                            $availability_array[$intdate]["availability_line"] .= "A,";
                        }
                    }
                }else{
                    if($i == $int_to){
                        $availability_array[$intdate]["availability_line"] .= "U";
                    }else{
                        $availability_array[$intdate]["availability_line"] .= "U,";
                    }
                }
            }
        }
        
        $result_array = array();
        
        $result_array ["start_date"] = $date_from;
        $result_array ["end_date"] = $date_to;
        
        $result_array ["availability"] = $availability_array;
        
        return $result_array;
    }
    
    function get_availability_v3($category_id, $shift_from, $shift_to) {
        $today_date = date("Y-m-d");
        
        list ( $year, $month, $day ) = explode ( "-", $today_date );
        //$intdate_today = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        $intdate_today = round ( gmmktime ( 0, 0, 0, $month, $day - 1, $year ) / 86400 );
        
        $intdate_from = $intdate_today + $shift_from;
        $intdate_to = $intdate_today + $shift_to;
        $date_from = date( "Y-m-d", ($intdate_today + $shift_from) * 86400 );
        $date_to = date( "Y-m-d", ($intdate_today + $shift_to) * 86400 );
        
        $restrict_rate_id = 0;
        $sql = "SELECT int_value FROM dc_airbnb_xml_cfg WHERE name LIKE 'restrict_rate_id'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $restrict_rate_id = $row->int_value;
        }
        
        $category_active_rooms_count = $this->frontdesk_c2->get_category_active_rooms_count();
        
        $availability_category_counts = $this->frontdesk->get_categories_freerooms_period($date_from, $date_to, 1, 1, $category_id);
        
        $global_country = @$this->db->select('str_value')->get_where('hotelix_config', array('name' => 'global_country'))->row()->str_value;
        
        $availability_array = array();
        $price_array = array();
        for($i = $intdate_from; $i <= $intdate_to; $i++){
            $availability_array[$i]["from"] = date( "Y-m-d", $i * 86400 );
            $availability_array[$i]["to"] = date( "Y-m-d", $i * 86400 );
            
            if(isset($availability_category_counts[$category_id][$i]) && $availability_category_counts[$category_id][$i]["availability"] > 0){
                $availability_array[$i]["availability"] = $availability_category_counts[$category_id][$i]["availability"];
            }else{
                $availability_category_counts[$category_id][$i]["availability"] = 0;
                $availability_array[$i]["availability"] = 0;
            }
            
            // коррекція к-сті відповідно умовам ф-ї availability_count_correction
            $availability_array[$i]["availability"] = $this->frontdesk_c2->availability_count_correction($availability_array[$i]["availability"], $availability_array[$i]["from"], $availability_array[$i]["to"]);
            
            $availability_array[$i]["period_min_nights"] = 1;
            $availability_array[$i]["availability_line"] = "";
            $availability_array[$i]["availability_count_line"] = "";
            $availability_array[$i]["dailyChangeOver_line"] = "";
        }
        
        $restrict_data = array();
        $sql = "SELECT deskofrate.* from deskofrate
        INNER JOIN categories ON categories.id = deskofrate.category_id
        INNER JOIN rooms ON rooms.category_id = categories.id
        WHERE categories.id = ".$category_id." AND deskofrate.rate_id = ".$restrict_rate_id." AND deskofrate.intdate >= ".$intdate_from." AND deskofrate.intdate <= ".$intdate_to;
        //echo $sql;
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $restrict_data[$row->intdate]["closed"] = $row->closed;
                $restrict_data[$row->intdate]["closedonarrival"] = $row->closedonarrival;
                $restrict_data[$row->intdate]["closedondeparture"] = $row->closedondeparture;
                $restrict_data[$row->intdate]["minstaythrought"] = $row->minstaythrought;
            }
        }
        
        //         echo "<pre>";
        //         print_r($availability_array);
        
        
        foreach ($availability_array as $intdate => $cell) {
            $prev = $intdate - 1;
            if (isset($availability_array[$prev])) {
                $availability_1 = $availability_array[$prev]["availability"];
                $availability_2 = $availability_array[$intdate]["availability"];
                
                $minstaythrought_1 = "";
                $minstaythrought_2 = "";
                if(isset($restrict_data[$prev]["minstaythrought"])){
                    if($restrict_data[$prev]["minstaythrought"] > 0){
                        $minstaythrought_1 = $restrict_data[$prev]["minstaythrought"];
                    }
                }
                if(isset($restrict_data[$intdate]["minstaythrought"])){
                    if($restrict_data[$intdate]["minstaythrought"] > 0){
                        $minstaythrought_2 = $restrict_data[$intdate]["minstaythrought"];
                    }
                }
                
                if ($availability_1 == $availability_2 && $minstaythrought_1 == $minstaythrought_2) {
                    $availability_array[$intdate]["from"] = $availability_array[$prev]["from"];
                    unset($availability_array[$prev]);
                }
            }
        }
        
        //         echo "<pre>";
        //         print_r($availability_array);
        
        foreach ($availability_array as $intdate => $cell) {
            list ( $year, $month, $day ) = explode ( "-", $cell["from"] );
            $int_from = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
            
            list ( $year, $month, $day ) = explode ( "-", $cell["to"] );
            $int_to = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
            
            if(isset($restrict_data[$intdate])){
                if($restrict_data[$intdate]["minstaythrought"] > 0){
                    $availability_array[$intdate]["period_min_nights"] = $restrict_data[$intdate]["minstaythrought"];
                }
            }
            
            for($i = $int_from; $i <= $int_to; $i++){
                
                if($i == $int_to){
                    if( isset($availability_category_counts[$category_id][$i]) && ($global_country != 'POL' && $global_country != 'UKR') ){
                        $availability_array[$intdate]["availability_count_line"] .= $availability_category_counts[$category_id][$i]["availability"];
                    }
                    
                    if(isset($restrict_data[$i])){
                        if($restrict_data[$i]["closedonarrival"] == 0 && $restrict_data[$i]["closedondeparture"] == 0){
                            $availability_array[$intdate]["dailyChangeOver_line"] .= "D";
                        }
                        if($restrict_data[$i]["closedonarrival"] == 0 && $restrict_data[$i]["closedondeparture"] == 1){
                            $availability_array[$intdate]["dailyChangeOver_line"] .= "I";
                        }
                        if($restrict_data[$i]["closedonarrival"] == 1 && $restrict_data[$i]["closedondeparture"] == 0){
                            $availability_array[$intdate]["dailyChangeOver_line"] .= "O";
                        }
                        if($restrict_data[$i]["closedonarrival"] == 1 && $restrict_data[$i]["closedondeparture"] == 1){
                            $availability_array[$intdate]["dailyChangeOver_line"] .= "N";
                        }
                    }else{
                        $availability_array[$intdate]["dailyChangeOver_line"] .= "D";
                    }
                }else{
                    if(isset($availability_category_counts[$category_id][$i]) && ($global_country != 'POL' && $global_country != 'UKR')){
                        $availability_array[$intdate]["availability_count_line"] .= $availability_category_counts[$category_id][$i]["availability"].",";
                    }
                    
                    if(isset($restrict_data[$i])){
                        if($restrict_data[$i]["closedonarrival"] == 0 && $restrict_data[$i]["closedondeparture"] == 0){
                            $availability_array[$intdate]["dailyChangeOver_line"] .= "D,";
                        }
                        if($restrict_data[$i]["closedonarrival"] == 0 && $restrict_data[$i]["closedondeparture"] == 1){
                            $availability_array[$intdate]["dailyChangeOver_line"] .= "I,";
                        }
                        if($restrict_data[$i]["closedonarrival"] == 1 && $restrict_data[$i]["closedondeparture"] == 0){
                            $availability_array[$intdate]["dailyChangeOver_line"] .= "O,";
                        }
                        if($restrict_data[$i]["closedonarrival"] == 1 && $restrict_data[$i]["closedondeparture"] == 1){
                            $availability_array[$intdate]["dailyChangeOver_line"] .= "N,";
                        }
                    }else{
                        $availability_array[$intdate]["dailyChangeOver_line"] .= "D,";
                    }
                }
                if($availability_array[$intdate]["availability"] > 0){
                    if($i == $int_to){
                        if(isset($restrict_data[$i]["closed"])){
                            if($restrict_data[$i]["closed"] == 1){
                                $availability_array[$intdate]["availability_line"] .= "U";
                            }else{
                                $availability_array[$intdate]["availability_line"] .= "A";
                            }
                        }else{
                            $availability_array[$intdate]["availability_line"] .= "A";
                        }
                    }else{
                        if(isset($restrict_data[$i]["closed"])){
                            if($restrict_data[$i]["closed"] == 1){
                                $availability_array[$intdate]["availability_line"] .= "U,";
                            }else{
                                $availability_array[$intdate]["availability_line"] .= "A,";
                            }
                        }else{
                            $availability_array[$intdate]["availability_line"] .= "A,";
                        }
                    }
                }else{
                    if($i == $int_to){
                        $availability_array[$intdate]["availability_line"] .= "U";
                    }else{
                        $availability_array[$intdate]["availability_line"] .= "U,";
                    }
                }
            }
            
            if($availability_array[$intdate]["availability_count_line"] != ''){
                $availability_array[$intdate]["dailyAvailableCount"] = '<dailyAvailableCount>'.$availability_array[$intdate]["availability_count_line"].'</dailyAvailableCount>';
            }else{
                $availability_array[$intdate]["dailyAvailableCount"] = '';
            }
        }
        
        if(isset($category_active_rooms_count[$category_id])){
            $totalInventoryCount = $category_active_rooms_count[$category_id];
        }else{
            $totalInventoryCount = 0;
        }
        
        $result_array = array();
        
        $result_array ["start_date"] = $date_from;
        $result_array ["end_date"] = $date_to;
        
        $result_array ["availability"] = $availability_array;
        $result_array ["totalInventoryCount"] = $totalInventoryCount;
        
        return $result_array;
    }
    
    function get_bookings($json_str = "") {
        $insert_over_room_bool = 0;
        echo "- Rawpost method -";
        $response = array ();
        $response = json_decode ( $json_str, true );
        
        echo "<pre>";
        echo $json_str;
        print_r ( $response );
        //die();
        // =====================================================
        
        if(isset($response["reservation"])){
            $room_page_version = $this->get_room_page_version();
            
            $category_id = 0;
            
            switch($room_page_version){
                case 0:
                    $sql = "SELECT categories.id as category_id FROM dc_airbnb_room2listing
			                INNER JOIN rooms ON dc_airbnb_room2listing.room_id = rooms.id AND listing_id2 = " . $response ["reservation"] ["listing_id"] . "
			                INNER JOIN categories ON categories.id = rooms.category_id";
                    break;
                case 1:
                    $sql = "SELECT categories.id as category_id FROM dc_airbnb_listingtocategory
			                INNER JOIN categories ON dc_airbnb_listingtocategory.category_id = categories.id
		                    AND listing_id = " . $response ["reservation"] ["listing_id"];
                    break;
                default:
                    $sql = "SELECT categories.id as category_id FROM dc_airbnb_listingtocategory
			                INNER JOIN categories ON dc_airbnb_listingtocategory.category_id = categories.id
		                    AND listing_id = " . $response ["reservation"] ["listing_id"];
                    break;
            }
            $query = $this->db->query ( $sql );
            
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $category_id = $row->category_id;
            }
            
            $query = $this->db->query ( "SELECT int_value FROM dc_airbnb_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
            
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $overbooking_category_id = $row->int_value;
            }
            
            $query = $this->db->query ( "SELECT id FROM rate WHERE isdefault = 1" );
            
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $price_type = $row->id;
            }
            
            $query = $this->db->query ( "SELECT int_value FROM dc_airbnb_xml_cfg WHERE name LIKE 'rate_id'" );
            
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $price_type = $row->int_value;
            }
            
            $query = $this->db->query ( "SELECT int_value FROM dc_airbnb_xml_cfg WHERE name LIKE 'dealer_id'" );
            
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $dealer = $row->int_value;
            }
            
            $reservations = array();
            $reservations[0] = $response["reservation"];
            $result_array = array ();
            for($i = 0; $i < count ( $reservations ); $i ++) {
                $result_array ["reservations"] [$i] ["dc_rate_id"] = $price_type;
                $result_array ["reservations"] [$i] ["currencycode"] = $reservations [$i] ["host_currency"];
                $result_array ["reservations"] [$i] ["listing_cleaning_fee_accurate"] = $reservations [$i] ["listing_cleaning_fee_accurate"];
                if(isset($reservations [$i] ["listing_cleaning_fee_accurate"])){
                    $addon_inc = 0;
                    $result_array ["reservations"] [$i] ["addons"] [$addon_inc] ["name"] = "cleaning_fee_accurate";
                    $result_array ["reservations"] [$i] ["addons"] [$addon_inc] ["amount"] = $reservations [$i] ["listing_cleaning_fee_accurate"];;
                }
                //$addon_inc ++;
                
                $result_array ["reservations"] [$i] ["card"] ["cc_cvc"] = "";
                if (isset ( $reservations [$i] ["guest_email"] )) {
                    $email = $reservations [$i] ["guest_email"];
                } else {
                    $email = "";
                }
                
                if (isset ( $reservations [$i] ["guest_phone_numbers"][0] )) {
                    $phone = $reservations [$i] ["guest_phone_numbers"][0];
                } else {
                    $phone = "";
                }
                
                $result_array ["reservations"] [$i] ["card"] ["ExpMonth"] = "";
                $result_array ["reservations"] [$i] ["card"] ["ExpYear"] = "";
                $result_array ["reservations"] [$i] ["card"] ["CardHolder"] = "";
                $result_array ["reservations"] [$i] ["card"] ["CardNumber"] = "";
                $result_array ["reservations"] [$i] ["card"] ["cc_type"] = "";
                
                $result_array ["reservations"] [$i] ["guest"] ["address"] = "";
                $result_array ["reservations"] [$i] ["guest"] ["city"] = "";
                $result_array ["reservations"] [$i] ["guest"] ["country"] = "";
                $result_array ["reservations"] [$i] ["guest"] ["email"] = $email;
                $result_array ["reservations"] [$i] ["guest"] ["firstname"] = $reservations [$i] ["guest_first_name"];
                $result_array ["reservations"] [$i] ["guest"] ["lastname"] = $reservations [$i] ["guest_last_name"];
                $result_array ["reservations"] [$i] ["guest"] ["phone"] = $phone;
                $result_array ["reservations"] [$i] ["guest"] ["passportid"] = "";
                
                $result_array ["reservations"] [$i] ["status"] = $response ["action"];
                
                $result_array ["reservations"] [$i] ["dc_reservationid"] = $reservations [$i] ["listing_id"];
                
                $cleanup_days = $reservations [$i] ["cleanup_days"];
                
                $result_array ["reservations"] [$i] ["reservation"] ["dc_id"] = 22;
                
                $result_array ["reservations"] [$i] ["reservation"] ["commissionamount"] = 0;
                $result_array ["reservations"] [$i] ["reservation"] ["date"] = "";
                $result_array ["reservations"] [$i] ["reservation"] ["dc_reservationid"] = "";
                $result_array ["reservations"] [$i] ["reservation"] ["time"] = "";
                $result_array ["reservations"] [$i] ["reservation"] ["isNew"] = 1;
                $result_array ["reservations"] [$i] ["reservation"] ["datein"] = $reservations [$i] ["start_date"];
                
                $result_array ["reservations"] [$i] ["reservation"] ["dc_roomreservation_id"] = "";
                $result_array ["reservations"] [$i] ["reservation"] ["dc_uuid"] = $reservations [$i] ["confirmation_code"];
                $result_array ["reservations"] [$i] ["reservation"] ["category_id"] = $category_id;
                $result_array ["reservations"] [$i] ["reservation"] ["adults"] = $reservations [$i] ["guest_details"]["number_of_adults"];
                $result_array ["reservations"] [$i] ["reservation"] ["add_places"] = 0;
                $result_array ["reservations"] [$i] ["reservation"] ["baby_places"] = $reservations [$i] ["guest_details"]["number_of_children"];
                $result_array ["reservations"] [$i] ["reservation"] ["babyplace2"] = $reservations [$i] ["guest_details"]["number_of_infants"];
                $result_array ["reservations"] [$i] ["reservation"] ["amount"] = $reservations [$i] ["listing_base_price_accurate"];
                $result_array ["reservations"] [$i] ["reservation"] ["price_type"] = $price_type;
                
                if(isset($_SESSION["user"]["id"])){
                    $result_array ["reservations"] [$i] ["reservation"] ["user"]  = $_SESSION["user"]["id"];
                }else{
                    $result_array ["reservations"] [$i] ["reservation"] ["user"] = - 1;
                }
                $result_array ["reservations"] [$i] ["reservation"] ["type_id"] = $category_id;
                
                $result_array ["reservations"] [$i] ["reservation"] ["dealer"] = $dealer;
                $result_array ["reservations"] [$i] ["reservation"] ["dc_guestname"] = $reservations [$i] ["guest_first_name"] . " " . $reservations [$i] ["guest_last_name"];
                $result_array ["reservations"] [$i] ["reservation"] ["dc_numberofguest"] = $reservations [$i] ["number_of_guests"];
                $result_array ["reservations"] [$i] ["reservation"] ["dc_countrycode"] = "";
                $result_array ["reservations"] [$i] ["reservation"] ["dc_currencycode"] = $reservations [$i] ["host_currency"];
                $result_array ["reservations"] [$i] ["reservation"] ["dc_city"] = "";
                $result_array ["reservations"] [$i] ["reservation"] ["dc_customerremarks"] = $reservations [$i] ["guest_details"]["localized_description"];
                $result_array ["reservations"] [$i] ["reservation"] ["dc_roomremarks"] = "";
                
                $result_array ["reservations"] [$i] ["reservation"] ["dc_totalprice"] = $reservations [$i] ["listing_base_price_accurate"];
                
                $result_array ["reservations"] [$i] ["reservation"] ["smoking"] = "";
                $result_array ["reservations"] [$i] ["roomreservation_id"] = "";
                
                $per_day_price = $reservations [$i] ["listing_base_price_accurate"] / $reservations [$i] ["nights"];
                
                list ( $year, $month, $day ) = explode ( "-", $reservations [$i] ["start_date"] );
                $intdate_in = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
                list ( $year, $month, $day ) = explode ( "-", $reservations [$i] ["end_date"] );
                $intdate_out = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
                
                $intdate_out -= $cleanup_days;
                $result_array ["reservations"] [$i] ["reservation"] ["dateout"] = gmdate ( "Y-m-d", $intdate_out * 86400 );
                
                $k = 0;
                for($j = $intdate_in; $j < $intdate_out; $j ++) {
                    $result_array ["reservations"] [$i] ["rate_per_day"] [$k] ["dc_reservation_id"] = $reservations [$i] ["confirmation_code"];
                    $result_array ["reservations"] [$i] ["rate_per_day"] [$k] ["price"] = $per_day_price;
                    $result_array ["reservations"] [$i] ["rate_per_day"] [$k] ["dc_rate_id"] = $price_type;
                    $result_array ["reservations"] [$i] ["rate_per_day"] [$k] ["intdate"] = $j;
                    $result_array ["reservations"] [$i] ["rate_per_day"] [$k] ["date_rate"] = gmdate ( "Y-m-d", $j * 86400 );
                    
                    $result_array ["reservations"] [$i] ["reservation"] ["day_price"][$j] = $per_day_price;
                    $k ++;
                }
                
                
            }
            
        }
        
        print_r ( $result_array );
        //die();
        
        $reservationpush = array ();
        
        $k = 0;
        if (isset ( $result_array ["reservations"] )) {
            echo "---------------------------";
            echo "<pre>";
            print_r ( $result_array ["reservations"] );
            // die ();
            for($i = 0; $i < count ( $result_array ["reservations"] ); $i ++) {
                echo "00000000";
                $bool_guest = 0;
                
                $datein = $result_array ["reservations"] [$i] ["reservation"] ["datein"];
                $dateout = $result_array ["reservations"] [$i] ["reservation"] ["dateout"];
                $type_id = $result_array ["reservations"] [$i] ["reservation"] ["type_id"];
                $sql = "SELECT id FROM deskofreservation WHERE dc_uuid LIKE '" . $result_array ["reservations"] [$i] ["reservation"]["dc_uuid"]."'";
                echo $sql;
                $query = $this->db->query ( $sql );
                $hms_reservation_id = 0;
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $hms_reservation_id = $row->id;
                }
                
                if (isset ( $result_array ["reservations"] [$i] ["rate_per_day"] )) {
                    $this->dc_rate_intdate_insert ( $result_array ["reservations"] [$i] ["rate_per_day"] );
                }
                
                if ($result_array ["reservations"] [$i] ["status"] == "reservation_cancellation_confirmation"
                    || $result_array ["reservations"] [$i] ["status"] == "reservation_request_voided") {
                        echo "++";
                        $time2 = date ( "Y-m-d H:i:s" );
                        $status = 5;
                        $query2 = $this->db->query ( "SELECT id FROM  services_main WHERE reservation_id = " . $hms_reservation_id . " AND type = 2" );
                        
                        if ($query2->num_rows () > 0) {
                            $reservationpush [$k] ["response"] = "failed";
                            $reservationpush [$k] ["text"] = "есть уже отмена";
                            $reservationpush [$k] ["status"] = "cancel";
                            
                            $reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
                            $reservationpush [$k] ["dc_reservationid"] = $result_array ["reservations"] [$i] ["dc_reservationid"];
                            $k ++;
                        } else {
                            $query2 = $this->db->query ( "SELECT id FROM deskofreservation WHERE dc_uuid LIKE '" . $result_array ["reservations"] [$i] ["reservation"]["dc_uuid"]."'" );
                            
                            if ($query2->num_rows () > 0) {
                                $data_cancel = array ();
                                
                                $data_cancel ["res_id"] = $hms_reservation_id;
                                $data_cancel ["charge"] = 0;
                                $data_cancel ["status"] = $status;
                                $data_cancel ["description"] = "cancel from airbnb";
                                $data_cancel ["guestbe_request"] = 0;
                                $data_cancel ["user"] = - 1;
                                // ====================
                                $this->Cancel->Insert ( $data_cancel );
                                // ====================
                                $reservationpush [$k] ["response"] = "ok";
                                $reservationpush [$k] ["text"] = "";
                                $reservationpush [$k] ["status"] = "cancel";
                                $reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
                                $reservationpush [$k] ["dc_reservationid"] = $result_array ["reservations"] [$i] ["dc_reservationid"];
                                $k ++;
                            } else {
                                $reservationpush [$k] ["response"] = "failed";
                                $reservationpush [$k] ["text"] = "нет брони для отмены";
                                $reservationpush [$k] ["status"] = "cancel";
                                
                                $reservationpush [$k] ["hms_reservation_id"] = 0;
                                $reservationpush [$k] ["dc_reservationid"] = $result_array ["reservations"] [$i] ["dc_reservationid"];
                                $k ++;
                            }
                        }
                    } else {
                        if ($result_array["reservations"][$i]["status"] == "reservation_requested"
                            || $result_array["reservations"][$i]["status"] == "reservation_alteration_created"
                            || $result_array["reservations"][$i]["status"] == "reservation_alteration_voided") {
                                $reservationpush[$k]["response"] = "ok";
                                $reservationpush[$k]["text"] = "airbnb_status = ". $result_array["reservations"][$i]["status"];
                                $reservationpush[$k]["status"] = "";
                                $reservationpush[$k]["hms_reservation_id"] = 0;
                                $reservationpush[$k]["dc_reservationid"] = $result_array["reservations"][$i]["dc_reservationid"];
                                $k ++;
                            } else {
                                echo "12134";
                                $room_id = 0;
                                $sql = "SELECT id, room_id FROM deskofreservation WHERE deleted = 0 AND dc_uuid LIKE '" . $result_array["reservations"][$i]["reservation"]["dc_uuid"] . "'";
                                echo $sql;
                                $query = $this->db->query($sql);
                                
                                if ($query->num_rows() > 0) {
                                    $row = $query->row();
                                    if ($type_id == 0 or $type_id == "") {
                                        $query2 = $this->db->query("SELECT int_value FROM dc_airbnb_xml_cfg WHERE name LIKE 'overbooking_category_id'");
                                        if ($query2->num_rows() > 0) {
                                            $row2 = $query2->row();
                                            $type_id = $row2->int_value;
                                        }
                                    }
                                    if ($type_id == 0 or $type_id == "") {
                                        $reservationpush[$k]["response"] = "error";
                                        $reservationpush[$k]["text"] = "UNKNOWN CATEGORY";
                                        $reservationpush[$k]["status"] = "update";
                                        $reservationpush[$k]["hms_reservation_id"] = $row->id;
                                        $reservationpush[$k]["dc_reservationid"] = $result_array["reservations"][$i]["dc_reservationid"];
                                        $k ++;
                                    } else {
                                        $reservation_data = $this->frontdesk->GetReservation($row->id);
                                        
                                        $reservation_data["user"] = $result_array["reservations"][$i]["reservation"]["user"];
                                        $reservation_data["firstname"] = $result_array["reservations"][$i]["guest"]["firstname"];
                                        $reservation_data["lastname"] = $result_array["reservations"][$i]["guest"]["lastname"];
                                        $reservation_data["phone"] = $result_array["reservations"][$i]["guest"]["phone"];
                                        $reservation_data["address"] = $result_array["reservations"][$i]["guest"]["address"];
                                        $reservation_data["country"] = $result_array["reservations"][$i]["guest"]["country"];
                                        $reservation_data["city"] = $result_array["reservations"][$i]["guest"]["city"];
                                        $reservation_data["amount"] = $result_array["reservations"][$i]["reservation"]["amount"];
                                        $reservation_data["date"] = $result_array["reservations"][$i]["reservation"]["date"];
                                        $reservation_data["add_places"] = $result_array["reservations"][$i]["reservation"]["add_places"];
                                        $reservation_data["baby_places"] = $result_array["reservations"][$i]["reservation"]["baby_places"];
                                        $reservation_data["datein"] = $result_array["reservations"][$i]["reservation"]["datein"];
                                        $reservation_data["dateout"] = $result_array["reservations"][$i]["reservation"]["dateout"];
                                        
                                        if ($reservation_data["type_id"] == $result_array["reservations"][$i]["reservation"]["type_id"]) {
                                            $reservation_data["room_id"] = $row->room_id;
                                        } else {
                                            $reservation_data["room_id"] = $this->frontdesk->getfreeroomlist($datein, $dateout, $type_id);
                                        }
                                        $reservation_data["type_id"] = $result_array["reservations"][$i]["reservation"]["type_id"];
                                        
                                        $reservation_data["price_type"] = $result_array["reservations"][$i]["reservation"]["price_type"];
                                        $reservation_data["guest_id_new"] = 0;
                                        $reservation_data["free_places"] = 0;
                                        $reservation_data["maid_description"] = "";
                                        $reservation_data["isread"] = 0;
                                        $reservation_data["dc_guestname"] = $result_array["reservations"][$i]["reservation"]["dc_guestname"];
                                        $reservation_data["dc_currencycode"] = $result_array["reservations"][$i]["reservation"]["dc_currencycode"];
                                        $reservation_data["dc_countrycode"] = $result_array["reservations"][$i]["reservation"]["dc_countrycode"];
                                        $reservation_data["dc_city"] = $result_array["reservations"][$i]["reservation"]["dc_city"];
                                        $reservation_data["dc_customerremarks"] = $result_array["reservations"][$i]["reservation"]["dc_customerremarks"];
                                        $reservation_data["dc_roomremarks"] = $result_array["reservations"][$i]["reservation"]["dc_roomremarks"];
                                        $reservation_data["dc_numberofguest"] = $result_array["reservations"][$i]["reservation"]["dc_numberofguest"];
                                        $reservation_data["dc_uuid"] = $result_array["reservations"][$i]["reservation"]["dc_uuid"];
                                        $reservation_data["dc_totalprice"] = $result_array["reservations"][$i]["reservation"]["dc_totalprice"];
                                        $reservation_data["smoking"] = $result_array["reservations"][$i]["reservation"]["smoking"];
                                        // print_r($reservation_data);
                                        // echo
                                        // $dc_roomreservation_id."<br>";
                                        // die();
                                        
                                        $calculate_data = array();
                                        $calculate_data["type_id"] = $result_array["reservations"][$i]["reservation"]["type_id"];
                                        $calculate_data["datein"] = $result_array["reservations"][$i]["reservation"]["datein"];
                                        $calculate_data["dateout"] = $result_array["reservations"][$i]["reservation"]["dateout"];
                                        $calculate_data["add_places"] = $result_array["reservations"][$i]["reservation"]["add_places"];
                                        $calculate_data["baby_places"] = $result_array["reservations"][$i]["reservation"]["baby_places"];
                                        $calculate_data["adults"] = $result_array["reservations"][$i]["reservation"]["adults"];
                                        $calculate_data["baby_places2"] = $result_array["reservations"][$i]["reservation"]["babyplace2"];
                                        $calculate_data["addbedplace"] = 0;
                                        $calculate_data["babyplace2"] = 0;
                                        $calculate_data["price_type"] = $result_array["reservations"][$i]["reservation"]["price_type"];
                                        
                                        $temp_amount = $this->frontdesk->getpricecalculation($calculate_data);
                                        $otelms_amount = 0;
                                        for ($res = 0; $res < count($temp_amount); $res ++) {
                                            $otelms_amount += $temp_amount[$res]["amount"];
                                        }
                                        
                                        $booking_amount = $result_array["reservations"][$i]["reservation"]["dc_totalprice"];
                                        //echo $otelms_amount . " " . $booking_amount;
                                        //if ($booking_amount != $otelms_amount) {
                                        if ($otelms_amount != 0) {
                                            $reservation_data["discount"] = $otelms_amount - $booking_amount;
                                            
                                            $reservation_data["discount"] = $otelms_amount - $booking_amount;
                                            $reservation_data["service_main_amount_2"] = 2; // признак фіксованої ціни
                                            $reservation_data["day_price"] = $result_array["reservations"][$i]["reservation"]["day_price"];
                                        }
                                        //                                 } else {
                                        //                                     $reservation_data["discount"] = 0;
                                        //                                 }
                                        
                                        print_r($reservation_data);
                                        $update_res = $this->frontdesk->UpdateReservation($reservation_data, 0, 1);
                                        if ($update_res == "FreeError") {
                                            if (isset($overbooking_category_id)) {
                                                $reservation_data["origin_categoryid"] = $reservation_data["type_id"];
                                                $room_id = $this->frontdesk->getfreeroomlist($datein, $dateout, $overbooking_category_id);
                                                $reservation_data["room_id"] = $room_id;
                                                $reservation_data["type_id"] = $overbooking_category_id;
                                                $update_res = $this->frontdesk->UpdateReservation($reservation_data, 0, 1);
                                                if ($update_res == "FreeError") {
                                                    $reservationpush[$k]["response"] = "error";
                                                    $reservationpush[$k]["text"] = "Not Free rooms";
                                                    $reservationpush[$k]["status"] = "update";
                                                    $reservationpush[$k]["hms_reservation_id"] = $row->id;
                                                    $reservationpush[$k]["dc_reservationid"] = $result_array["reservations"][$i]["dc_reservationid"];
                                                    $k ++;
                                                } else {
                                                    $reservationpush[$k]["response"] = "ok";
                                                    $reservationpush[$k]["text"] = "overbooking transfer";
                                                    $reservationpush[$k]["status"] = "update";
                                                    $reservationpush[$k]["hms_reservation_id"] = $row->id;
                                                    $reservationpush[$k]["dc_reservationid"] = $result_array["reservations"][$i]["dc_reservationid"];
                                                    $k ++;
                                                }
                                            } else {
                                                
                                                $reservationpush[$k]["response"] = "error";
                                                $reservationpush[$k]["text"] = "Not Free rooms (overbooking not set)";
                                                $reservationpush[$k]["status"] = "update";
                                                $reservationpush[$k]["hms_reservation_id"] = $row->id;
                                                $reservationpush[$k]["dc_reservationid"] = $result_array["reservations"][$i]["dc_reservationid"];
                                                $k ++;
                                            }
                                        } else {
                                            /*
                                             * ==== ADD SERVICES ======
                                             */
                                            $this->add_addons($result_array["reservations"][$i]["addons"], $row->id);
                                            /*
                                             * =========================
                                             */
                                            $reservationpush[$k]["response"] = "ok";
                                            $reservationpush[$k]["text"] = "";
                                            $reservationpush[$k]["status"] = "update";
                                            $reservationpush[$k]["hms_reservation_id"] = $row->id;
                                            $reservationpush[$k]["dc_reservationid"] = $result_array["reservations"][$i]["dc_reservationid"];
                                            $k ++;
                                        }
                                    }
                                } else {
                                    
                                    if ($type_id == 0 or $type_id == "") {
                                        $query2 = $this->db->query("SELECT int_value FROM dc_airbnb_xml_cfg WHERE name LIKE 'overbooking_category_id'");
                                        if ($query2->num_rows() > 0) {
                                            $row2 = $query2->row();
                                            $type_id = $row2->int_value;
                                        }
                                    }
                                    if ($type_id == 0 or $type_id == "") {
                                        $reservationpush[$k]["response"] = "error";
                                        $reservationpush[$k]["text"] = "UNKNOWN CATEGORY";
                                        $reservationpush[$k]["status"] = "update";
                                        $reservationpush[$k]["hms_reservation_id"] = 0;
                                        $reservationpush[$k]["dc_reservationid"] = $result_array["reservations"][$i]["dc_reservationid"];
                                        $k ++;
                                    } else {
                                        $room_id = $this->frontdesk->getfreeroomlist($datein, $dateout, $type_id);
                                        if ($room_id == 0) {
                                            
                                            if (isset($overbooking_category_id)) {
                                                $result_array["reservations"][$i]["reservation"]["origin_categoryid"] = $type_id;
                                                $room_id = $this->frontdesk->getfreeroomlist($datein, $dateout, $overbooking_category_id);
                                                $insert_over_room_bool = 0;
                                                if ($room_id == 0) {
                                                    $room_id = $this->dc_model->dc_make_overbooking_room($overbooking_category_id);
                                                    $insert_over_room_bool = 1;
                                                }
                                            } else {
                                                $reservationpush[$k]["response"] = "failed";
                                                $reservationpush[$k]["text"] = "no overbooking_category_id";
                                                $reservationpush[$k]["status"] = "new";
                                                $reservationpush[$k]["hms_reservation_id"] = 0;
                                                $reservationpush[$k]["dc_reservationid"] = $result_array["reservations"][$i]["dc_reservationid"];
                                                $reservationpush[$k]["dc_room_id"] = $result_array["reservations"][$i]["reservation"]["category_id"];
                                            }
                                        }
                                        $result_array["reservations"][$i]["reservation"]["room_id"] = $room_id;
                                        
                                        if ($result_array["reservations"][$i]["reservation"]["room_id"] == 0) {
                                            $reservationpush[$k]["response"] = "failed not free rooms";
                                            // $reservationpush [$k] ["text"] = "room_id is
                                            // NULL";
                                            $reservationpush[$k]["text"] = "dc_reservationid = " . $result_array["reservations"][$i]["dc_reservationid"];
                                            $reservationpush[$k]["status"] = "new";
                                            $reservationpush[$k]["hms_reservation_id"] = 0;
                                            $reservationpush[$k]["dc_reservationid"] = $result_array["reservations"][$i]["dc_reservationid"];
                                            $reservationpush[$k]["dc_room_id"] = $result_array["reservations"][$i]["reservation"]["category_id"];
                                        } else {
                                            if ($bool_guest == 0) {
                                                $guest_id = $this->frontdesk->Guest_insert($result_array["reservations"][$i]["guest"]);
                                                $bool_guest = 1;
                                            }
                                            
                                            $calculate_data = array();
                                            $calculate_data["type_id"] = $result_array["reservations"][$i]["reservation"]["type_id"];
                                            $calculate_data["datein"] = $result_array["reservations"][$i]["reservation"]["datein"];
                                            $calculate_data["dateout"] = $result_array["reservations"][$i]["reservation"]["dateout"];
                                            
                                            $calculate_data["add_places"] = $result_array["reservations"][$i]["reservation"]["add_places"];
                                            $calculate_data["baby_places"] = $result_array["reservations"][$i]["reservation"]["baby_places"];
                                            $calculate_data["addbedplace"] = 0;
                                            $calculate_data["babyplace2"] = 0;
                                            $calculate_data["price_type"] = $result_array["reservations"][$i]["reservation"]["price_type"];
                                            
                                            $temp_amount = $this->frontdesk->getpricecalculation($calculate_data);
                                            $otelms_amount = 0;
                                            for ($res = 0; $res < count($temp_amount); $res ++) {
                                                $otelms_amount += $temp_amount[$res]["amount"];
                                            }
                                            $booking_amount = $result_array["reservations"][$i]["reservation"]["dc_totalprice"];
                                            
                                            //if ($booking_amount != $otelms_amount) {
                                            if ($otelms_amount != 0) {
                                                $result_array["reservations"][$i]["reservation"]["discount"] = $otelms_amount - $booking_amount;
                                                $result_array["reservations"][$i]["reservation"]["service_main_amount_2"] = 2; // признак фіксованої ціни
                                            }
                                            //                                     } else {
                                            //                                         $result_array["reservations"][$i]["reservation"]["discount"] = 0;
                                            //                                     }
                                            
                                            $reservation_id = $this->frontdesk->Reservation_insert($result_array["reservations"][$i]["reservation"], $guest_id, 0, 1);
                                            
                                            if ($reservation_id > 0) {
                                                /*
                                                 * ==== ADD SERVICES ======
                                                 */
                                                $this->add_addons($result_array["reservations"][$i]["addons"], $reservation_id);
                                                /*
                                                 * =========================
                                                 */
                                                
                                                if ($insert_over_room_bool == 1) {
                                                    $reservationpush[$k]["alert"] = "Рассинхронизация системы! Свяжитесь со службой. (Тип №2)";
                                                } else {
                                                    $reservationpush[$k]["alert"] = "";
                                                }
                                                $reservationpush[$k]["response"] = "ok";
                                                $reservationpush[$k]["text"] = "";
                                                $reservationpush[$k]["status"] = "new";
                                                $reservationpush[$k]["hms_reservation_id"] = $reservation_id;
                                                $reservationpush[$k]["dc_reservationid"] = $result_array["reservations"][$i]["dc_reservationid"];
                                                $reservationpush[$k]["dc_room_id"] = $result_array["reservations"][$i]["reservation"]["category_id"];
                                                $k ++;
                                            } else {
                                                $reservationpush[$k]["response"] = "failed";
                                                $reservationpush[$k]["text"] = "undferror";
                                                $reservationpush[$k]["status"] = "new";
                                                $reservationpush[$k]["hms_reservation_id"] = 0;
                                                $reservationpush[$k]["dc_reservationid"] = $result_array["reservations"][$i]["dc_reservationid"];
                                                $reservationpush[$k]["dc_room_id"] = $result_array["reservations"][$i]["reservation"]["category_id"];
                                                $k ++;
                                            }
                                        }
                                    }
                                }
                            }
                    }
            }
        }
        print_r ( $reservationpush );
        foreach ( $reservationpush as $arg ) {
            $data = array ();
            $data ["hms_reservation_id"] = $arg ["hms_reservation_id"];
            $data ['response'] = $arg ['response'];
            $data ['resid'] = $arg ['dc_reservationid'];
            $data ['dcname'] = "Airbnb";
            $data ['status'] = $arg ['status'];
            $this->dc_model->send_notifyarray ( $data );
        }
        
        return json_encode($reservationpush, true);
    }
    
    function dc_rate_intdate_insert($data) {
        //die();
        $count = count ( $data );
        if ($count != 0) {
            $query = $this->db->query ( "DELETE FROM dc_airbnb_rate_intdate WHERE dc_reservation_id LIKE '" . $data [0] ["dc_reservation_id"]."'" );
            for($i = 0; $i < $count; $i ++) {
                $sql = "INSERT INTO dc_airbnb_rate_intdate (dc_reservation_id, dc_rate_id, intdate, price) VALUES('" . $data [$i] ["dc_reservation_id"] . "',
		'" . $data [$i] ["dc_rate_id"] . "', '" . $data [$i] ["intdate"] . "', '" . $data [$i] ["price"] . "')
		ON DUPLICATE KEY UPDATE price = '" . $data [$i] ["price"] . "'";
                // echo $sql;
                $query = $this->db->query ( $sql );
            }
        }
        
    }
    
    function add_addons($data, $reservation_id = 0)
    {
        $dealer = $this->db->select('int_value')->get_where('dc_airbnb_xml_cfg', array('name' => 'dealer_id'))->row()->int_value;
        $service_type_id = $this->db->select('int_value')->get_where('dc_airbnb_xml_cfg', array('name' => 'service_type_id'))->row()->int_value;
        $partner = $this->db->select('int_value')->get_where('dc_airbnb_xml_cfg', array('name' => 'service_type_id'))->row()->int_value;
        $query = $this->db->query ( "SELECT int_value FROM dc_airbnb_xml_cfg WHERE name LIKE 'dealer_id'" );
        
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $dealer = $row->int_value;
        }
        
        $service_type_id = 0;
        $query = $this->db->query ( "SELECT int_value FROM dc_airbnb_xml_cfg WHERE name LIKE 'service_type_id'" );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $service_type_id = $row->int_value;
        }
        
        $partner = 0;
        $query = $this->db->query ( "SELECT id FROM partners WHERE isdefault = 1" );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $partner = $row->id;
        }
        
        foreach ( $data as $addons ) {
            if ($reservation_id != 0) {
                $data_services = array ();
                $data_services ["dc_addons"] = 1;
                $data_services ["res_id"] = $reservation_id;
                $data_services ["dealer"] = $dealer;
                $data_services ["partner"] = $partner;
                $data_services ["price"] = $addons ["amount"];
                $data_services ["amount"] = $addons ["amount"];
                $data_services ["description"] = $addons ["name"];
                $data_services ["count"] = 1;
                $data_services ["addons_date"] = "";
                $data_services ["type"] = $service_type_id;
                if ($data_services ["type"] != 0 and $data_services ["type"] != "") {
                    $this->service_model->Insert_Service ( $data_services, 1 );
                }
            }
        }
    }
    
    function get_beds2rooms($catID){
        $beds2rooms = array ();
        $sql = "SELECT * FROM beds2rooms WHERE catID = ".$catID;
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $beds2rooms[$row->roomID][$row->bedID] = $row->value;
            }
        }
        return $beds2rooms;
    }
    
    function get_roomConfigurations($category_id){
        $roomConfigurations = array();
        $beds_names = $this->get_beds_list();
        $beds2rooms_array = $this->get_beds2rooms($category_id);
        //echo "<pre>";
        //print_r($beds2rooms_array);
        //die();
        $i = 0;
        $j = 0;
        $bedscount = 0;
        foreach ( $beds2rooms_array as $roomID => $beds ) {
            $roomConfigurations [$i] ["roomConfiguration"] [0] ["roomNumber"] = $roomID;
            foreach ( $beds as $bedID => $value ) {
                if ($value > 0) {
                    $roomConfigurations [$i] ["roomConfiguration"] [0] ["rc_beds"] [$j] ["type"] = $beds_names [$bedID];
                    $roomConfigurations [$i] ["roomConfiguration"] [0] ["rc_beds"] [$j] ["quantity"] = $value;
                    $bedscount = $bedscount + $value;
                    $j ++;
                }
            }
            if (! isset ( $roomConfigurations [$i] ["roomConfiguration"] [0] ["rc_beds"] )) {
                unset ( $roomConfigurations [$i] );
            }
            $i ++;
        }
        
        $result = array();
        $result['roomConfigurations'] = $roomConfigurations;
        $result['beds'] = $bedscount;
        return $result;
    }
    
    /*  ф-я is_correct_price - перевірка цін base_price, cleaningfee, securedeposit, extraperson
     *  вхідні дані: $room_id - ІД номера
     *  вихідні дані: масив $return_array з мітками
     *                         - result - 0/1 ( 1 - ціна коректна, 0 - ціна не коректна)
     *                         - price_type - тип не коректної ціни
     */
    
    function is_correct_price($room_id, $category_id = 0)
    {
        $rate_id = $this->getxmlcfgvalue("rate_id", "int");
        
        // ф-я перевірки цін
        $upload_deep = $this->getxmlcfgvalue("upload_deep", "int");
        
        if($category_id == 0){
            $prices = $this->get_prices($room_id, $rate_id, 0, $upload_deep);
        }else{
            $prices = $this->get_prices(0, $rate_id, 0, $upload_deep, $category_id);
        }
        
        $daily_price = 0;
        foreach($prices['prices'] as $cell_price){
            $daily_price += $cell_price['price'];
        }
        
        $this->daily_price_new = ($daily_price / 100) * $this->daily_price_percent;
        
        
        $return_array = array();
        
        if($category_id == 0){
            $sql = "SELECT rooms.category_id, categories.base_price FROM rooms
	                INNER JOIN categories on categories.id = rooms.category_id
	                WHERE rooms.id = " . $room_id;
        }else{
            $sql = "SELECT id as category_id, base_price FROM categories
	                WHERE id = " . $category_id;
        }
        
        //echo $sql;
        $query = $this->db->query($sql);
        
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $category_id = $row->category_id;
            $base_price = $row->base_price;
            
            $sql2 = "SELECT cleaningfee, securedeposit, extraperson
		            FROM dc_airbnb_room_param
		            WHERE category_id = ".$category_id;
            $query2 = $this->db->query($sql2);
            if ($query2->num_rows() > 0) {
                $row2 = $query2->row();
                // перевірка ціни cleaningfee
                $check_data = array(
                    'price_type' => 'cleaningfee',
                    'price' => $row2->cleaningfee
                );
                $check_cleaningfee = $this->check_correct_price($check_data);
                if ($check_cleaningfee == 0){
                    $return_array['result'] = 0;
                    $return_array['price_type'] = "cleaningfee";
                    return $return_array;
                }
                // перевірка ціни securedeposit
                $check_data = array(
                    'price_type' => 'securedeposit',
                    'price' => $row2->securedeposit
                );
                $check_securedeposit = $this->check_correct_price($check_data);
                if ($check_securedeposit == 0){
                    $return_array['result'] = 0;
                    $return_array['price_type'] = "securedeposit";
                    return $return_array;
                }
                
                // перевірка ціни securedeposit
                $check_data = array(
                    'price_type' => 'extraperson',
                    'price' => $row2->extraperson
                );
                $check_extraperson = $this->check_correct_price($check_data);
                if ($check_extraperson == 0){
                    $return_array['result'] = 0;
                    $return_array['price_type'] = "extraperson";
                    return $return_array;
                }
            }
            
            $check_data = array(
                'price_type' => 'base_price',
                'price' => $base_price
            );
            $check_base_price = $this->check_correct_price($check_data);
            if ($check_base_price == 0) {
                $return_array['result'] = 0;
                $return_array['price_type'] = "base_price";
                return $return_array;
            }
        }
        
        $return_array['result'] = 1;
        return $return_array;
    }
    
    /* ф-я check_correct_price - перевірка цін по діапазонам
     *
     * вхідні дані масив data  з мітками:
     *     price - ціна,
     *     price_type - тип ціни ( base_price, extraperson, cleaningfee, securedeposit)
     *
     * вихідні дані - 0/1 (0 - ціна не коректна, 1 - ціна коректна)
     *
     */
    function check_correct_price($data)
    {
        $price = $data['price'];
        
        $rate_id = $this->getxmlcfgvalue("rate_id", "int");
        $currency_code_from = $this->db->select('currency')->get_where('rate', array('id' => $rate_id))->row()->currency;
        
        $currency_name_from = $this->db->select('name')->get_where('global_hotelix.currency', array('code' => $currency_code_from))->row()->name;
        $currency_name_to = "USD";
        //echo $currency_name_from." ".$currency_name_to;
        //die();
        if ($currency_name_to != "" && $currency_name_from != "") {
            $props = array();
            $props['currency_to'] = $currency_name_to;
            $props['currency_from'] = $currency_name_from;
            $props['amount'] = $data['price'];
            
            $price_result = $this->frontdesk_c2->convert_currencies($props);
            if(isset($price_result['amount'])){
                $price = $price_result['amount'];
            }
        }
        
        switch ($data['price_type']) {
            case "base_price":
                if($price < 10 || $price > 150000){
                    return 0;
                }
                break;
            case "extraperson":
                if(($price < 5 && $price != 0) || $price > 150000){
                    return 0;
                }
                break;
            case "cleaningfee":
                if(($price < 5 && $price != 0) || $price > (150000 + $this->daily_price_new)){
                    return 0;
                }
                break;
            case "securedeposit":
                if(($price < 100 && $price != 0) || $price > 150000){
                    return 0;
                }
                break;
        }
        
        return 1;
    }
    
    function getdata4xml($category_id, $room_id){
        $data = array();
        $category_data_db = $this->frontdesk->get_category_full_data($category_id);
        
        $category_fotos_db = $this->frontdesk->get_category_fotos($category_id);
        $category_prop_fotos = $this->frontdesk->get_category_property_fotos($category_id);
        $category_fotos_db = array_merge($category_fotos_db, $category_prop_fotos);
        
        $category_amenity_types_db = $this->frontdesk->get_category_amenity_types($category_id);
        
        $property_amenity_types_db = $this->frontdesk->get_property_amenity_types($category_data_db ["property_id"]);
        
        $category_descriptions_db = $this->get_category_descriptions($category_id, "");
        $xml_descriptions = "";
        $aiabnb_SupportedLocales = $this->get_aiabnb_SupportedLocales();
        if (count($category_descriptions_db)>0){
            foreach ($category_descriptions_db as $category_description){
                if (in_array ( $category_description ['language'], $aiabnb_SupportedLocales ) &&
                    $category_description ['name'] != "" && $category_description ['summary'] != "") {
                        $xml_descriptions .= "<description>\n";
                        foreach ( $category_description as $descript_key => $descript_value ) {
                            if ($descript_value != "") {
                                $xml_descriptions .= "<" . $descript_key . ">" . $descript_value . "</" . $descript_key . ">\n";
                            }
                        }
                        $xml_descriptions .= "</description>\n";
                    }
            }
        }
        
        $roomConfigurations = $this->get_roomConfigurations($category_id);
        
        $category_roomConfigurations_db = $roomConfigurations['roomConfigurations'];
        
        $room_types = $this->frontdesk->get_room_types();
        
        $property_types = $this->frontdesk->get_property_types();
        
        $listing_types = $this->frontdesk->get_listing_types();
        $dc_airbnb_cancelation_policy = $this->frontdesk->get_dc_airbnb_cancelation_policy();
        //================ unique amenities start===============
        $temp_unique_amenities = array();
        $all_unique_amenities = array();
        foreach ($property_amenity_types_db as $value){
            if (!in_array($value['amenity'], $temp_unique_amenities)) {
                array_push($temp_unique_amenities, $value['amenity']);
                array_push($all_unique_amenities, $value);
            }
        }
        foreach ($category_amenity_types_db as $value){
            if (!in_array($value['amenity'], $temp_unique_amenities)) {
                array_push($temp_unique_amenities, $value['amenity']);
                array_push($all_unique_amenities, $value);
            }
        }
        //================ unique amenities end===============
        // 		$tmp_max = count($category_amenity_types_db);
        // 		$tmp_max++;
        // 		//echo $tmp_max;
        // 		$count_property_amenity_types = count($property_amenity_types_db);
        // 		for($i = 0; $i < $count_property_amenity_types; $i++){
        // 			$category_amenity_types_db[$tmp_max+$i]["amenity"] = $property_amenity_types_db[$i]["amenity"];
        // 		}
        
        // 		echo "<pre>";
        // 		print_r($all_unique_amenities);
        // 		die();
        
        $listing_type_id = 0;
        $cancelation_policy_id = 0;
        $cleaningfee = 0;
        $securedeposit = 0;
        $extraperson = 0;
        $hours = 0;
        $bookconfirm = 0;
        $monthly_price_factor = 1;
        $weekly_price_factor = 1;
        $display_location = 0;
        $sql = "SELECT monthly_price_factor, weekly_price_factor, listing_type_id, cancelation_policy, cleaningfee, securedeposit, extraperson, hours,
		bookconfirm, display_location
		FROM dc_airbnb_room_param
		WHERE category_id = ".$category_id;
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row= $query->row();
            $listing_type_id = $row->listing_type_id;
            $cancelation_policy_id = $row->cancelation_policy;
            $cleaningfee = $row->cleaningfee;
            $securedeposit = $row->securedeposit;
            $extraperson = $row->extraperson;
            $hours = $row->hours;
            $bookconfirm = $row->bookconfirm;
            $display_location = $row->display_location;
            $monthly_price_factor = number_format((float)(100-$row->monthly_price_factor)/100, 2, '.', '');
            $weekly_price_factor = number_format((float)(100-$row->weekly_price_factor)/100, 2, '.', '');
        }
        
        
        //echo $sql;
        
        $data ["cleaningfee"] = $cleaningfee;
        $data ["securedeposit"] = $securedeposit;
        $data ["extraperson"] = $extraperson;
        $data ["hours"] = $hours;
        $data ["bookconfirm"] = $bookconfirm;
        $data ["monthly_price_factor"] = $monthly_price_factor;
        $data ["weekly_price_factor"] = $weekly_price_factor;
        
        if($display_location == 1){
            $data ["display_location"] = "true";
        }else{
            $data ["display_location"] = "false";
        }
        
        $listingType = "";
        if(isset($listing_types[$listing_type_id])){
            $listingType = $listing_types[$listing_type_id]["airbnb"];
        }
        
        $cancelation_policy = "";
        if(isset($dc_airbnb_cancelation_policy[$cancelation_policy_id])){
            $cancelation_policy = $dc_airbnb_cancelation_policy[$cancelation_policy_id]["cancelation_policy_name"];
        }
        
        $data ["lastUpdated"] = date("Y-m-dTH:i:s ");
        $data ["basicDetails"] = array();
        
        $data ["basicDetails"] = array();
        
        $data ["basicDetails"] [0] ["bathrooms"] = (int)$category_data_db ["bathrooms"];
        $data ["basicDetails"] [0] ["bedrooms"] = $category_data_db ["bedrooms"];
        
        $propertyType = "";
        if (isset ( $room_types [$category_data_db ["room_type_id"]] )) {
            if ($room_types [$category_data_db ["room_type_id"]] ["airbnb"] != 'other' && $room_types [$category_data_db ["room_type_id"]] ["airbnb"] != '') {
                $propertyType = $room_types [$category_data_db ["room_type_id"]] ["airbnb"];
            } else {
                if (isset ( $property_types [$category_data_db ["property_type"]] )) {
                    $propertyType = $property_types [$category_data_db ["property_type"]] ["airbnb"];
                }
            }
        } else {
            if (isset ( $property_types [$category_data_db ["property_type"]] )) {
                $propertyType = $property_types [$category_data_db ["property_type"]] ["airbnb"];
            }
        }
        $data ["basicDetails"] [0] ["propertyType"] = $propertyType;
        $data ["basicDetails"] [0] ["listingType"] = $listingType;
        $data ["basicDetails"] [0] ["amenities"] = array();
        $data ["basicDetails"] [0] ["amenities"] = $all_unique_amenities;
        $data ["basicDetails"] [0] ["cancellationPolicy"] = $cancelation_policy;
        $data ["basicDetails"] [0] ["personCapacity"] = $category_data_db ["add_places"];
        $data ["basicDetails"] [0] ["guestsIncluded"] = $category_data_db ["places"];
        $data ["basicDetails"] [0] ["beds"] = $roomConfigurations['beds'];
        $data ["basicDetails"] [0] ["checkInTime"] = substr($category_data_db ["check_in_time"], 0,2 );
        $data ["basicDetails"] [0] ["checkOutTime"] = substr($category_data_db ["check_out_time"], 0,2 );
        
        // ??????????????????????????????????????????????????????
        $data ["basicDetails"] [0] ["directions"] = "Under construct";
        $data ["basicDetails"] [0] ["houseManual"] = "Under construct";
        
        $data ["basicDetails"] [0] ["roomConfigurations"] = array();
        $data ["basicDetails"] [0] ["roomConfigurations"] = $category_roomConfigurations_db;
        
        //$data ["descriptions"] = array();
        $data ["descriptions"] = $xml_descriptions;//$category_descriptions_db;
        
        
        $gps_coordinates = explode(",", $category_data_db['gps_coordinates']);
        
        if(isset($gps_coordinates[0])){
            $data ["location_lat"] = $gps_coordinates[0];
        }else{
            $data ["location_lat"] = "";
        }
        
        if(isset($gps_coordinates[1])){
            $data ["location_lng"] = $gps_coordinates[1];
        }else{
            $data ["location_lng"] = "";
        }
        
        $data ["guestsIncluded"] = $category_data_db ["places"];
        
        $data ["location_apt"] = $category_data_db ["additional_information"]; //????
        $data ["location_streetAddress"] = $category_data_db ["street"];
        $data ["location_city"] = $category_data_db ["city"];
        $data ["location_administrativeDivision"] = $category_data_db ["state"]; //????
        $data ["location_postalCode"] = $category_data_db ["post_code"];
        //$data ["location_countryCode"] = $this->get_country_2chr($category_data_db ["country"]);
        
        $data ["location_countryCode"] = $this->get_country_2chr_v2($category_data_db ["country"]);
        
        $data ["photos"] = array();
        $data ["photos"] = $category_fotos_db;
        
        $data ["hms_id"] = $this->config->item ( 'hotel_id' );
        return $data;
        //echo "<pre>";
        //print_r($data);
        //die();
    }
    function build_data_url($room_id) {
        
        $hotel_id = $this->config->item ( 'hotel_id' );
        if ($hotel_id != "") {
            $sql = "SELECT host, db_name FROM visitka.config WHERE id = " . $hotel_id;
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $host = $row->host;
            }
        }
        
        $url = "https://" . $host . "/gatepublic/dcairbnb_listing/" . $room_id . "/data.xml";
        return  $url;
        
    }
    
    function build_data_url_category($cat_id) {
        
        $hotel_id = $this->config->item ( 'hotel_id' );
        if ($hotel_id != "") {
            $sql = "SELECT host, db_name FROM visitka.config WHERE id = " . $hotel_id;
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $host = $row->host;
            }
        }
        
        $dc_user_id = $this->get_dc_airbnb_xml_cfg_value('user_id', "int");
        $url = "https://" . $host . "/gatepublic/dcairbnb_listing_v3/" . $cat_id . "/" . $dc_user_id . "_data.xml";
        //$url = "https://" . $host . "/gatepublic/dcairbnb_listing_v3/" . $cat_id . "/debug";
        return  $url;
        
    }
    
    function listcreate($room_id)
    {
        
        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
        $authparam = $this->dcm_airbnb->authparam();
        $clientid = $authparam['clientid'];
        $main_url = "https://api.airbnb.com/v2/listing_imports/"; // сюда юзек з gettoken()
        
        
        
        
        $ch = curl_init();
        // set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $main_url);
        curl_setopt($ch, CURLOPT_POST, 1);
        
        $url = $this->dcm_airbnb->build_data_url($room_id);
        
        $import_data = array();
        $import_data["document_format"] = "airbnb-xml-v1";
        $import_data["document_uri"] = $url;
        $import_data["synchronization_frequency"] = "hourly";
        //log data
        $datalog = array(
            'request' => json_encode($import_data),
            'url' => $url
        );
        $this->db->insert('dc_airbnb_log', $datalog);
        $id = $this->db->insert_id();
        
        
        //curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"document_format\":\"airbnb-xml-v1\",\"document_uri\":\"" . $main_url . "\",\"synchronization_frequency\":\"hourly\"}");
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($import_data));
        
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            "X-Airbnb-Oauth-Token: " . $access_token, // сюда токен з gettoken()
            "X-Airbnb-API-Key: " . $clientid,
            "X-AIRBNB-REQ-API-VERSION: 2022.03.31"
        ));
        
        
        $timestart = time();
        $response = curl_exec ( $ch );
        $result = json_decode($response, true);
        
        $data = array(
            'response' => $response,
            'stime' => (microtime(true) - $timestart)
        );
        $this->db->update('dc_airbnb_log', $data, array(
            'id' => $id
        ));
        
        //echo "<pre>";
        //print_r($result);
        //die();
        curl_close ( $ch );
        $status_category = "processing";
        $listing_id = "";
        if (isset($result['listing_import'])) {
            $listing_id = $result['listing_import']['id'];
            $sql = "insert into dc_airbnb_room2listing (room_id, listing_id, status_category, response)
			values (" . (integer) $room_id . ", " . (integer) $listing_id . ", '".$status_category."', '".$response."')
	        on duplicate key update listing_id=" . (integer) $listing_id.", response = '".$response."', status_category = '".$status_category."'";
            $this->db->query($sql);
        }
        /*else{
         $sql = "insert into dc_airbnb_room2listing (room_id, status_category, response)
         values (" . (integer) $room_id . ", '".$status_category."', '".$response."')
         on duplicate key update response = '".$response."', status_category = '".$status_category."'";
         $this->db->query($sql);
         }
         */
        $data_return = array();
        $data_return ["response"] = $response;
        $data_return ["status_category"] = $status_category;
        $data_return ["listing_id"] = $listing_id;
        return $data_return;
    }
    
    function listing_imports_create($cat_id, $listing_id = 0, $view_info = 0, $sync_type = ""){ // view_info if == 1 - info for one listing_id on display
        $this->validate_token();
        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
        $authparam = $this->dcm_airbnb->authparam();
        $clientid = $authparam['clientid'];
        $main_url = "https://api.airbnb.com/v2/listing_imports/"; // сюда юзек з gettoken()
        
        $import_data = array();
        $import_data["document_format"] = "airbnb-xml-v1";
        $import_data["document_uri"] = $this->build_data_url_category($cat_id);
        $import_data["synchronization_frequency"] = "hourly";
        $import_data["synchronization_category"] = $sync_type;
        if($listing_id != 0){
            $import_data["listing_id"] = $listing_id;
        }
        //logging data at dc_airbnb_log START
        $datalog = array (
            'request' => json_encode ( $import_data ),
            'url' => $main_url
        );
        $this->db->insert('dc_airbnb_log', $datalog);
        $log_id = $this->db->insert_id();
        //logging data at dc_airbnb_log FINAL
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $main_url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($import_data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            "X-Airbnb-Oauth-Token: " . $access_token, // сюда токен з gettoken()
            "X-Airbnb-API-Key: " . $clientid,
            "X-AIRBNB-REQ-API-VERSION: 2022.03.31"
        ));
        $timestart = time();
        $response = curl_exec ( $ch );
        curl_close ( $ch );
        $result = json_decode($response, true);
        //updating logged data at dc_airbnb_log START
        $data = array(
            'response' => $response,
            'stime' => (microtime(true) - $timestart)
        );
        $this->db->update('dc_airbnb_log', $data, array('id' => $log_id));
        //updating logged data at dc_airbnb_log FINAL
        $status_category = "";
        $import_id = "";
        $ls_status = "";
        if (isset($result['listing_import'])) {
            $import_id = $result['listing_import']['id'];
            $status_category = $result['listing_import']['listing_approval_status']['status_category'];
            $ls_status = $result['listing_import']['last_synchronization_status'];
            if($listing_id == 0){
                $listing_id = $result['listing_import']['listing_id'];
            }
            $sql = "INSERT INTO dc_airbnb_listings(listing_id, name, active) VALUES('" . $listing_id . "', '{clt_new_listing_created}', 1)
	        		ON DUPLICATE KEY UPDATE name = '{clt_new_listing_created}', active = 1";
            $query = $this->db->query($sql);
            $sql = "INSERT INTO dc_airbnb_listingtocategory(category_id, listing_id, status_category, sync_type)
            		VALUES('" . $cat_id . "', '" . $listing_id . "', '" . $status_category . "', '" . $sync_type . "')
            		ON DUPLICATE KEY UPDATE listing_id = $listing_id, status_category = '$status_category', sync_type = '$sync_type'";
            $query = $this->db->query($sql);
            $sql = "INSERT INTO dc_airbnb_importtolisting(import_id, listing_id, ls_status, response)
	        		VALUES('" . $import_id . "', '" . $listing_id . "', '" . $ls_status . "', '" . $response . "')
	        		ON DUPLICATE KEY UPDATE ls_status = '$ls_status', response = '$response'";
            $query = $this->db->query($sql);
            // view only info for one listing_id on display ХНЯ ЯКАСЬ НЕПОТРІБНА...
            // 	        if ($view_info == 1) {
            //                 $response_array = array();
            //                 if (isset($result['listing_import'][0])) {
            //                     $response_array = $result['listing_import'];
            //                 } else {
            //                     $response_array[0] = $result['listing_import'];
            //                 }
            
            //                 foreach ($response_array as $cell) {
            //                     if($cell["listing_id"] == $listing_id){
            //                         $response = json_decode($cell, true);
            //                         break;
            //                     }
            //                 }
            //             }
        }
        $data_return = array();
        $data_return ["response"] = $response;
        $data_return ["status_category"] = $status_category;
        $data_return ["listing_id"] = $listing_id;
        $data_return["response_status"] = $ls_status;
        return $data_return;
    }
    
    
    
    public function migrate($import_id)
    {
        
        $this->validate_token();
        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
        $authparam = $this->dcm_airbnb->authparam();
        $clientid = $authparam['clientid'];
        
        $headers = array(
            'Content-Type:application/json',
            'X-Airbnb-Oauth-Token:'. $access_token,
            'X-Airbnb-API-Key:' . $clientid,
            'X-AIRBNB-REQ-API-VERSION: 2022.03.31'
        );
        
        $curl = curl_init();
        
        $url = "https://api.airbnb.com/v2/listing_imports/" . $import_id . "/import_convert_to_rest";
        
        $datalog = array (
            'request' => "???",
            'url' => $url
        );
        $this->db->insert('dc_airbnb_log', $datalog);
        $log_id = $this->db->insert_id();
        
        
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "DELETE",
            CURLOPT_HTTPHEADER =>  $headers,
        ));
        
        $timestart = time();
        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        curl_close($curl);
        
        if ($err) {
            //echo "cURL Error #:" . $err;
        } else {
            //echo $response;
            //echo '<hr>';
            //echo $tosend;
        }
        
        $result = json_decode($response, true);
        //updating logged data at dc_airbnb_log START
        $data = array(
            'response' => $response,
            'stime' => (microtime(true) - $timestart)
        );
        
        $this->db->update('dc_airbnb_log', $data, array('id' => $log_id));
        //updating logged data at dc_airbnb_log FINAL
        $status_category = "";
        $ls_status = "???";
        if (isset($result['listing_import'])) {
            
            $status_category = $result['listing_import']['listing_approval_status']['status_category'];
            $listing_id = $result['listing_import']['listing_id'];
            
            $this->db->delete("dc_airbnb_importtolisting", array("listing_id"=>$listing_id));
            
        }
        $data_return = array();
        $data_return ["response"] = $response;
        $data_return ["status_category"] = $status_category;
        $data_return ["listing_id"] = $listing_id;
        $data_return["response_status"] = $ls_status;
        return $data_return;
        
        
    }
    
    public function deletelisting_rest($listing_id)
    {
        
        $this->validate_token();
        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
        $authparam = $this->dcm_airbnb->authparam();
        $clientid = $authparam['clientid'];
        
        $headers = array(
            'Content-Type:application/json',
            'X-Airbnb-Oauth-Token:'. $access_token,
            'X-Airbnb-API-Key:' . $clientid,
            "X-AIRBNB-REQ-API-VERSION: 2023.06.30"            
        );
        
        $curl = curl_init();
        
        $url = "https://api.airbnb.com/v2/listings/{$listing_id}/";
        
        $datalog = array (
            'request' => "delete listing rest",
            'url' => $url
        );
        $this->db->insert('dc_airbnb_log', $datalog);
        $log_id = $this->db->insert_id();
        
        
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "DELETE",
            CURLOPT_HTTPHEADER =>  $headers,
        ));
        
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        
        $timestart = time();
        $response = curl_exec($curl);
        
        
        $info = curl_getinfo($curl);
        $http_code = $info['http_code'];
        
        
        $err = curl_error($curl);
        
        curl_close($curl);
        
        if ($err) {
            //echo "cURL Error #:" . $err;
        } else {
            //echo $response;
            //echo '<hr>';
            //echo $tosend;
        }
        
        $result = json_decode($response, true);
        //updating logged data at dc_airbnb_log START
        $data = array(
            'response' => $response,
            'responseint' => $http_code,
            'stime' => (microtime(true) - $timestart)
        );
        
        $this->db->update('dc_airbnb_log', $data, array('id' => $log_id));
        //updating logged data at dc_airbnb_log FINAL
        $status_category = "";
        $ls_status = "???";
        if ($http_code == 200) {
            
            //$status_category = $result['listing']['listing_approval_status']['status_category'];
            
            $this->db->delete("dc_airbnb_listings", array("listing_id"=>$listing_id));
            $this->db->delete("dc_airbnb_listings_details", array("listing_id"=>$listing_id));
            $this->db->delete("dc_airbnb_listingtocategory", array("listing_id"=>$listing_id));
            
            
        }
        
        $this->db->delete("dc_airbnb_listingtocategory", array("listing_id"=>$listing_id));
        
        $data_return = array();
        $data_return ["response"] = $response;
        $data_return ["status_category"] = $status_category;
        $data_return ["listing_id"] = $listing_id;
        $data_return["response_status"] = $ls_status;
        return $data_return;
        
        
    }
    
    public function detach_listing($listing_id)
    {
        
        $this->validate_token();
        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
        $authparam = $this->dcm_airbnb->authparam();
        $clientid = $authparam['clientid'];
        
        $headers = array(
            'Content-Type:application/json',
            'X-Airbnb-Oauth-Token:'. $access_token,
            'X-Airbnb-API-Key:' . $clientid,
            "X-AIRBNB-REQ-API-VERSION: 2023.06.30"
        );
        
        $curl = curl_init();
        
        $url = "https://api.airbnb.com/v2/listings/$listing_id";
        $data = array(
            'synchronization_category'		=> null // sync_all, sync_rates_and_availabylity
        );
        
        $tosend = json_encode($data);
        
        $datalog = array (
            'request' => "detach listing rest",
            'url' => $url
        );
        $this->db->insert('dc_airbnb_log', $datalog);
        $log_id = $this->db->insert_id();
        
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "PUT",
            CURLOPT_POSTFIELDS => $tosend,
            CURLOPT_HTTPHEADER =>  $headers,
        ));
        
        $timestart = time();
        $response = curl_exec($curl);
        
        $info = curl_getinfo($curl);
        $http_code = $info['http_code'];
        
        $err = curl_error($curl);
        
        curl_close($curl);
        
        if ($err) {
            //echo "cURL Error #:" . $err;
        } else {
            //echo $response;
            //echo '<hr>';
            //echo $tosend;
        }
        
        $result = json_decode($response, true);
        //updating logged data at dc_airbnb_log START
        $data = array(
            'response' => $response,
            'responseint' => $http_code,
            'stime' => (microtime(true) - $timestart)
        );
        
        $this->db->update('dc_airbnb_log', $data, array('id' => $log_id));
        //updating logged data at dc_airbnb_log FINAL
        $status_category = "";
        $ls_status = "???";
        if ($http_code == 200) {
            
            //$status_category = $result['listing']['listing_approval_status']['status_category'];
            
            $this->db->delete("dc_airbnb_listings", array("listing_id"=>$listing_id));
            $this->db->delete("dc_airbnb_listings_details", array("listing_id"=>$listing_id));
            $this->db->delete("dc_airbnb_listingtocategory", array("listing_id"=>$listing_id));
            
            
        }
        
        $this->db->delete("dc_airbnb_listingtocategory", array("listing_id"=>$listing_id));
        
        $data_return = array();
        $data_return ["response"] = $response;
        $data_return ["status_category"] = $status_category;
        $data_return ["listing_id"] = $listing_id;
        $data_return["response_status"] = $ls_status;
        return $data_return;
        
        
    }
    
    public function create_listing($cat_id, $sync_type)
    {
        
        $this->validate_token();
        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
        $authparam = $this->dcm_airbnb->authparam();
        $clientid = $authparam['clientid'];
        
        $headers = array(
            'Content-Type:application/json',
            'X-Airbnb-Oauth-Token:'. $access_token,
            'X-Airbnb-API-Key:' . $clientid,
            'X-AIRBNB-REQ-API-VERSION: 2023.06.30'
        );
        
        $headers2 = array(
            'Content-Type:application/json',
            'X-Airbnb-Oauth-Token:'. $access_token,
            'X-Airbnb-API-Key:' . $clientid,
            "X-AIRBNB-REQ-API-VERSION: 2022.12.31"
        );
        
        
        
        $data = array(
            'name'	=> $this->dcm_airbnb->get_category_name($cat_id),
        );
        
        $tosend = json_encode($data);
        
        $curl = curl_init();
        
        $datalog = array (
            'request' => $tosend,
            'url' => "https://api.airbnb.com/v2/listings"
        );
        $this->db->insert('dc_airbnb_log', $datalog);
        $log_id = $this->db->insert_id();
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.airbnb.com/v2/listings",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $tosend,
            CURLOPT_HTTPHEADER => $headers,
        ));
        
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        
        $timestart = time();
        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        //echo $response;
                
        //die();
        
        $http_code = - 1;
        
        if (! curl_errno($curl)) {
            $info = curl_getinfo($curl);
            $http_code = $info['http_code'];
        }
        
        curl_close($curl);
        
        if ($err) {
            //echo "cURL Error #:" . $err;
        } else {
            //echo $response;
            //echo '<hr>';
            //echo $tosend;
        }
        
        $result = json_decode($response, true);
        //updating logged data at dc_airbnb_log START
        $data = array(
            'response' => $response." ".json_encode(array('http_code' => $http_code)),
            'responseint' => $http_code,
            'stime' => (microtime(true) - $timestart)
        );
        $this->db->update('dc_airbnb_log', $data, array('id' => $log_id));
        //updating logged data at dc_airbnb_log FINAL
        $status_category = "";
        $ls_status = "???";
        if (isset($result['listing'])) {
            
            $status_category = $result['listing']['listing_approval_status']['status_category'];
            $listing_id = $result['listing']['id'];
            $sql = "INSERT INTO dc_airbnb_listings(listing_id, name, active) VALUES('" . $listing_id . "', '{clt_new_listing_created}', 1)
	        		ON DUPLICATE KEY UPDATE name = '{clt_new_listing_created}', active = 1";
            $query = $this->db->query($sql);
            $sql = "INSERT INTO dc_airbnb_listingtocategory(category_id, listing_id, status_category, sync_type)
            		VALUES('" . $cat_id . "', '" . $listing_id . "', '" . $status_category . "', '" . $sync_type . "')
            		ON DUPLICATE KEY UPDATE listing_id = $listing_id, status_category = '$status_category', sync_type = '$sync_type'";
            $query = $this->db->query($sql);
            
            
        } else {
            if (isset($result['id'])) {
                $status_category = "???";
                $listing_id = $result['id'];
                $sql = "INSERT INTO dc_airbnb_listings(listing_id, name, active) VALUES('" . $listing_id . "', '{clt_new_listing_created}', 1)
	        		ON DUPLICATE KEY UPDATE name = '{clt_new_listing_created}', active = 1";
                $query = $this->db->query($sql);
                $sql = "INSERT INTO dc_airbnb_listingtocategory(category_id, listing_id, status_category, sync_type)
            		VALUES('" . $cat_id . "', '" . $listing_id . "', '" . $status_category . "', '" . $sync_type . "')
            		ON DUPLICATE KEY UPDATE listing_id = $listing_id, status_category = '$status_category', sync_type = '$sync_type'";
                $query = $this->db->query($sql);
            }
        }
        
        
        $data_return = array();
        $data_return ["response"] = $response;
        $data_return ["status_category"] = $status_category;
        $data_return ["listing_id"] = (string) $listing_id;
        $data_return["response_status"] = $ls_status;
        return $data_return;
        
        
    }
    
    public function connect_listing_rest($listing_id, $cat_id, $sync_type)
    {
        
        $this->validate_token();
        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
        $authparam = $this->dcm_airbnb->authparam();
        $clientid = $authparam['clientid'];
        
        $headers = array(
            'Content-Type:application/json',
            'X-Airbnb-Oauth-Token:'. $access_token,
            'X-Airbnb-API-Key:' . $clientid
        );
        
        $data = array(
            'synchronization_category'		=> $sync_type // sync_all, sync_rates_and_availabylity
        );
        
        $tosend = json_encode($data);
        $curl = curl_init();
        
        $url = "https://api.airbnb.com/v2/listings/$listing_id";
        
        $datalog = array (
            'request' => $tosend,
            'url' => $url
        );
        $this->db->insert('dc_airbnb_log', $datalog);
        $log_id = $this->db->insert_id();
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "PUT",
            CURLOPT_POSTFIELDS => $tosend,
            CURLOPT_HTTPHEADER =>  $headers,
        ));
        
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        
        $timestart = time();
        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        $http_code = - 1;
        
        if (! curl_errno($curl)) {
            $info = curl_getinfo($curl);
            $http_code = $info['http_code'];
        }
        
        curl_close($curl);
        
        if ($err) {
            //echo "cURL Error #:" . $err;
        } else {
            //echo $response;
            //echo '<hr>';
            //echo $tosend;
        }
        
        $result = json_decode($response, true);
        //updating logged data at dc_airbnb_log START
        $result['http_code'] = $http_code;
        
        $data = array(
            'response' => $response." ".json_encode(array('http_code' => $http_code)),
            'responseint' => $http_code,
            'stime' => (microtime(true) - $timestart)
        );
        $this->db->update('dc_airbnb_log', $data, array('id' => $log_id));
        //updating logged data at dc_airbnb_log FINAL
        $status_category = "";
        $ls_status = $http_code;
        //if (array_key_exists("listing", $result) || 1) {
        if ($http_code == 200) {
            $status_category = "connect";
            $sql = "INSERT INTO dc_airbnb_listings(listing_id, name, active) VALUES('" . $listing_id . "', '{clt_new_listing_created}', 1)
	        		ON DUPLICATE KEY UPDATE name = '{clt_new_listing_created}', active = 1";
            $query = $this->db->query($sql);
            $sql = "INSERT INTO dc_airbnb_listingtocategory(category_id, listing_id, status_category, sync_type, response)
            		VALUES('" . $cat_id . "', '" . $listing_id . "', '" . $status_category . "', '" . $sync_type . "', '".addslashes(json_encode($result))."')
            		ON DUPLICATE KEY UPDATE listing_id = $listing_id, status_category = '$status_category', sync_type = '$sync_type', response = '".addslashes(json_encode($result))."'";
            $query = $this->db->query($sql);
            
            
        }
        $data_return = array();
        $data_return ["response"] = $response;
        $data_return ["status_category"] = $status_category;
        $data_return ["listing_id"] = $listing_id;
        $data_return["response_status"] = $ls_status;
        return $data_return;
        
        
    }
    
    public function listupdate_rest($listing_id, $cat_id, $sync_type)
    {
        
        $this->validate_token();
        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
        $authparam = $this->dcm_airbnb->authparam();
        $clientid = $authparam['clientid'];
        
        $headers = array(
            'Content-Type:application/json',
            'X-Airbnb-Oauth-Token:'. $access_token,
            'X-Airbnb-API-Key:' . $clientid,
            "X-AIRBNB-REQ-API-VERSION: 2023.06.30"            
        );
        
        $data = array(
            'synchronization_category'		=> $sync_type // sync_all, sync_rates_and_availabylity
        );
        
        $tosend = json_encode($data);
        $curl = curl_init();
        
        $url = "https://api.airbnb.com/v2/listings/$listing_id";
        
        $datalog = array (
            'request' => json_encode($headers) . $tosend,
            'url' => $url
        );
        $this->db->insert('dc_airbnb_log', $datalog);
        $log_id = $this->db->insert_id();
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "PUT",
            CURLOPT_POSTFIELDS => $tosend,
            CURLOPT_HTTPHEADER =>  $headers,
        ));
        
        $timestart = time();
        $response = curl_exec($curl);
        $http_code = - 1;
        
        if (! curl_errno($curl)) {
            $info = curl_getinfo($curl);
            $http_code = $info['http_code'];
        }
        
        $err = curl_error($curl);
        
        curl_close($curl);
        
        if ($err) {
            //echo "cURL Error #:" . $err;
        } else {
            //echo $response;
            //echo '<hr>';
            //echo $tosend;
        }
        
        $result = json_decode($response, true);
        //updating logged data at dc_airbnb_log START
        $data = array(
            'response' => $response." ".json_encode(array('http_code' => $http_code)),
            'responseint' => $http_code,
            'stime' => (microtime(true) - $timestart)
        );
        $this->db->update('dc_airbnb_log', $data, array('id' => $log_id));
        //updating logged data at dc_airbnb_log FINAL
        $status_category = "";
        
        
        //$ls_status = "???";
        $ls_status = $http_code;
        //if (array_key_exists("listing", $result)) {
        if ($http_code == 200) {
            
            $status_category = "update";
            
            $sql = "INSERT INTO dc_airbnb_listingtocategory(category_id, listing_id, status_category, sync_type)
            		VALUES('" . $cat_id . "', '" . $listing_id . "', '" . $status_category . "', '" . $sync_type . "')
            		ON DUPLICATE KEY UPDATE listing_id = $listing_id, status_category = '$status_category', sync_type = '$sync_type'";
            $query = $this->db->query($sql);
            
            
        }
        $data_return = array();
        $data_return ["response"] = $response;
        $data_return ["status_category"] = $status_category;
        $data_return ["listing_id"] = $listing_id;
        $data_return["response_status"] = $ls_status;
        return $data_return;
        
        
    }
    
    function listimport($import_listing_id = 0, $save_session_room_list = 0)
    {
        $user_id = $this->dcm_airbnb->getxmlcfgvalue('user_id', 'int');
        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
        
        $authparam = $this->authparam();
        $clientid = $authparam['clientid'];
        
        $url = "https://api.airbnb.com/v2/listing_imports/?user_id=" . $user_id; // сюда юзек з gettoken()
        
        $curl_auth_param = array();
        $curl_auth_param ['clientid'] = $authparam['clientid'];
        $curl_auth_param ['access_token'] = $access_token;
        
        $datalog = array(
            'request' => json_encode($curl_auth_param),
            'url' => $url
        );
        $this->db->insert('dc_airbnb_log', $datalog);
        $id = $this->db->insert_id();
        
        $ch = curl_init();
        // set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            "X-Airbnb-Oauth-Token: " . $access_token, // сюда токен з gettoken()
            "X-Airbnb-API-Key: " . $clientid,
            "X-AIRBNB-REQ-API-VERSION: 2022.03.31"
        ));
        
        $timestart = microtime(true);
        $response = curl_exec($ch);
        curl_close($ch);
        //echo "<pre>";
        $result = json_decode($response, true);
        //print_r($result);
        
        $data = array(
            'response' => $response,
            'stime' => (microtime(true) - $timestart)
        );
        $this->db->update('dc_airbnb_log', $data, array(
            'id' => $id
        ));
        
        $session_array = array ();
        if ($save_session_room_list == 1) {
            $room2listing = array ();
            $sql = "SELECT listing_id FROM dc_airbnb_room2listing";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result () as $row ) {
                    $room2listing [$row->listing_id] = 1;
                }
            }
        }
        
        $rooms_statuses = array();
        $current_get_status = "";
        
        $way = 2;
        if (isset($result['listing_imports'])) {
            $i = 0;
            $s_i = 0;
            foreach($result['listing_imports'] as $cell){
                $json_result = json_encode($cell);
                $listing_id = $cell['id'];
                $listing_id2 = $cell['listing_id'];
                
                $room_id = 0;
                if ($way == 2) {
                    $document_uri_arr = explode("dcairbnb_listing/", $cell['document_uri']);
                    if (isset($document_uri_arr[1])) {
                        $room_id = str_replace("/data.xml", "", $document_uri_arr[1]);
                    }
                }
                
                //                 if ($room_id == 5) {
                //                     $room_id = "405";
                //                 }
                
                if($import_listing_id > 0){
                    if($import_listing_id == $listing_id){
                        //echo "<pre>";
                        //print_r($cell);
                        $response = $json_result;
                        $current_get_status = $cell['last_synchronization_status'];
                    }
                }
                
                
                if ($this->is_room($room_id) == 0) {
                    if ($save_session_room_list == 1 && ! isset($room2listing[$listing_id])) {
                        $session_array[$s_i] = $cell;
                        $s_i ++;
                    }
                    
                    if ($save_session_room_list == 1 ) {
                        $session_array[$s_i] = $cell;
                        $s_i ++;
                    }
                }
                
                
                $last_synchronization_status = "";
                $last_synchronization_status = $cell['last_synchronization_status'];
                if ($way == 2) {
                    $sql = "INSERT INTO dc_airbnb_room2listing (room_id, listing_id, listing_id2, status_category, response)
				VALUES('" . $room_id . "', '" . $listing_id . "', '" . $listing_id2 . "', '" . $last_synchronization_status . "', '" . addslashes($json_result) . "')
				ON DUPLICATE KEY UPDATE listing_id2 = '" . $listing_id2 . "', response = '" . addslashes($json_result) . "', status_category = '" . $last_synchronization_status . "'";
                } else {
                    $sql = "update dc_airbnb_room2listing set response = '" . addslashes($json_result) . "',
				status_category = '" . $last_synchronization_status . "' WHERE listing_id = " . $listing_id;
                }
                
                $this->db->query($sql);
                
                $rooms_statuses[$i]["listing_id"] = $listing_id;
                $rooms_statuses[$i]["status_category"] = $last_synchronization_status;
                $i++;
            }
        }
        
        $data_return = array();
        $data_return ["response"] = $response;
        $data_return ["rooms_statuses"] = $rooms_statuses;
        $data_return ["current_get_status"] = $current_get_status;
        $data_return ["session_array"] = $session_array;
        return $data_return;
        
    }
    
    function listimport_v3($import_listing_id = 0, $save_session_room_list = 0)
    {
        $user_id = $this->dcm_airbnb->getxmlcfgvalue('user_id', 'int');
        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
        
        $authparam = $this->authparam();
        $clientid = $authparam['clientid'];
        
        $url = "https://api.airbnb.com/v2/listing_imports/?user_id=" . $user_id; // сюда юзек з gettoken()
        
        $headers = array(
            'Content-Type: application/json',
            "X-Airbnb-Oauth-Token: " . $access_token, // сюда токен з gettoken()
            "X-Airbnb-API-Key: " . $clientid,
            'X-AIRBNB-REQ-API-VERSION: 2022.03.31'
        );
        
        $curl_auth_param = array();
        $curl_auth_param ['clientid'] = $authparam['clientid'];
        $curl_auth_param ['access_token'] = $access_token;
        $curl_auth_param ['headers'] = $headers;
        $curl_auth_param ['endpoint'] = $url;
        
        $datalog = array(
            'request' => json_encode($curl_auth_param),
            'url' => $url
        );
        $this->db->insert('dc_airbnb_log', $datalog);
        $id = $this->db->insert_id();
        
        $ch = curl_init();
        // set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        
        $timestart = microtime(true);
        $response = curl_exec($ch);
        curl_close($ch);
        //echo "<pre>";
        $result = json_decode($response, true);
        //print_r($result);
        
        $data = array(
            'response' => $response,
            'stime' => (microtime(true) - $timestart)
        );
        $this->db->update('dc_airbnb_log', $data, array(
            'id' => $id
        ));
        
        $session_array = array ();
        if ($save_session_room_list == 1) {
            $room2listing = array ();
            $sql = "SELECT listing_id FROM dc_airbnb_listingtocategory";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result () as $row ) {
                    $room2listing [$row->listing_id] = 1;
                }
            }
        }
        
        $rooms_statuses = array();
        $current_get_status = "";
        
        $way = 2;
        if (isset($result['listing_imports'])) {
            $i = 0;
            $s_i = 0;
            foreach($result['listing_imports'] as $cell){
                $cell ['headers'] = $headers;
                $cell ['endpoint'] = $url;
                
                $json_result = json_encode($cell);
                $listing_id = $cell['id'];
                $listing_id2 = $cell['listing_id'];
                
                $category_id = 0;
                if ($way == 2) {
                    $document_uri_arr = explode("dcairbnb_listing/", $cell['document_uri']);
                    if (isset($document_uri_arr[1])) {
                        $category_id = str_replace("/data.xml", "", $document_uri_arr[1]);
                    }
                }
                
                //                 if ($room_id == 5) {
                //                     $room_id = "405";
                //                 }
                
                if($import_listing_id > 0){
                    if($import_listing_id == $listing_id){
                        //echo "<pre>";
                        //print_r($cell);
                        $response = $json_result;
                        $current_get_status = $cell['last_synchronization_status'];
                    }
                }
                
                
                if ($this->is_room($room_id) == 0) {
                    if ($save_session_room_list == 1 && ! isset($room2listing[$listing_id])) {
                        $session_array[$s_i] = $cell;
                        $s_i ++;
                    }
                    
                    if ($save_session_room_list == 1 ) {
                        $session_array[$s_i] = $cell;
                        $s_i ++;
                    }
                }
                
                
                $last_synchronization_status = "";
                $last_synchronization_status = $cell['last_synchronization_status'];
                if ($way == 2) {
                    $sql = "INSERT INTO dc_airbnb_listingtocategory (category_id, listing_id, status_category, response)
				VALUES('" . $category_id . "', '" . $listing_id . "', '" . $last_synchronization_status . "', '" . addslashes($json_result) . "')
				ON DUPLICATE KEY UPDATE response = '" . addslashes($json_result) . "', status_category = '" . $last_synchronization_status . "'";
                } else {
                    $sql = "update dc_airbnb_listingtocategory set response = '" . addslashes($json_result) . "',
				status_category = '" . $last_synchronization_status . "' WHERE listing_id = " . $listing_id;
                }
                
                $this->db->query($sql);
                
                $rooms_statuses[$i]["listing_id"] = $listing_id;
                $rooms_statuses[$i]["status_category"] = $last_synchronization_status;
                $i++;
            }
        }
        
        $data_return = array();
        $data_return ["response"] = $response;
        $data_return ["rooms_statuses"] = $rooms_statuses;
        $data_return ["current_get_status"] = $current_get_status;
        $data_return ["session_array"] = $session_array;
        return $data_return;
        
    }
    
    function listupdate($listing_id, $room_id)
    {
        
        $user_id = $this->dcm_airbnb->getxmlcfgvalue('user_id', 'int');
        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
        
        $authparam = $this->dcm_airbnb->authparam();
        $clientid = $authparam['clientid'];
        
        $list_id = 450448; //LIST ID !!!!!   ["id"]=>int(437175)
        $list_id = $listing_id;
        
        $url = "https://api.airbnb.com/v2/listing_imports/" . $list_id; // сюда юзек з gettoken()
        
        $ch = curl_init();
        
        // set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $url);
        
        
        //$xml = "https://dev-ul2.otelms.com/gatepublic/dcairbnb_listing/" . $room_id . "/data.xml";
        
        $xml = $this->dcm_airbnb->build_data_url($room_id);
        
        
        //    curl_setopt($ch, CURLOPT_PUT, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        curl_setopt($ch, CURLOPT_POSTFIELDS, '{
  "document_format": "airbnb-xml-v1",
  "document_uri": "' . $xml . '",
  "synchronization_frequency": "hourly",
  "on_demand_synchronization_requested": true
}');
        
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            "X-Airbnb-Oauth-Token: " . $access_token, // сюда токен з gettoken()
            "X-Airbnb-API-Key: " . $clientid,
            'X-AIRBNB-REQ-API-VERSION: 2022.03.31'
        ));
        
        $response = curl_exec($ch);
        
        $info = curl_getinfo($ch);
        curl_close($ch);
        
        
        $result = json_decode($response, true);
        
        
        if (isset($result['listing_import'])) {
            $listing_id = $result['listing_import']['id'];
            $sql = "update dc_airbnb_room2listing set status_category = 'processing', response = '".addslashes($response)."' WHERE room_id = ".$room_id." AND listing_id = ".$listing_id;
            $this->db->query($sql);
        }else{
            $sql = "update dc_airbnb_room2listing set status_category = 'processing', response = '".addslashes($response)."' WHERE room_id = ".$room_id;
            $this->db->query($sql);
        }
        $data_return = array();
        $data_return ["response"] = $response;
        $data_return ["status_category"] = 'processing';
        return $data_return;
    }
    
    function get_import_id($listing_id){
        $import_id = 0;
        $sql = "SELECT import_id FROM dc_airbnb_importtolisting WHERE listing_id = ".(int) $listing_id;
        $query = $this->db->query( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $import_id = $row->import_id;
        }
        
        return $import_id;
    }
    
    function listupdate_v3($import_id, $category_id, $sync_type = "")
    {
        $user_id = $this->dcm_airbnb->getxmlcfgvalue('user_id', 'int');
        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
        $authparam = $this->dcm_airbnb->authparam();
        $clientid = $authparam['clientid'];
        $main_url = "https://api.airbnb.com/v2/listing_imports/" . $import_id; // сюда юзек з gettoken()
        $url = $this->build_data_url_category($category_id);
        $import_data = array();
        $import_data["document_format"] = "airbnb-xml-v1";
        $import_data["document_uri"] = $url;
        $import_data["synchronization_frequency"] = "hourly";
        $import_data["synchronization_category"] = $sync_type;
        //logging data at dc_airbnb_log START
        $datalog = array (
            'request' => json_encode ( $import_data ),
            'url' => $main_url
        );
        $this->db->insert('dc_airbnb_log', $datalog);
        $log_id = $this->db->insert_id();
        //logging data at dc_airbnb_log FINAL
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $main_url);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($import_data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            "X-Airbnb-Oauth-Token: " . $access_token, // сюда токен з gettoken()
            "X-Airbnb-API-Key: " . $clientid,
            'X-AIRBNB-REQ-API-VERSION: 2023.06.30'
        ));
        $timestart = time();
        $response = curl_exec($ch);
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
        }
        
        curl_close($ch);
        //updating logged data at dc_airbnb_log START
        $data = array(
            'response' => $response." ".json_encode(array('http_code' => $http_code)),
            'responseint' => $http_code,
            'stime' => (microtime(true) - $timestart)
        );
        $this->db->update('dc_airbnb_log', $data, array(
            'id' => $log_id
        ));
        //updating logged data at dc_airbnb_log FINAL
        $result = json_decode($response, true);
        $status_category = "";
        $ls_status = "";
        
        $listing_name = "???";
        
        if (isset($result['listing_import'])) {
            $listing_id = $result['listing_import']['listing_id'];
            $all_listings = $this->get_listings();
            $all_listings = json_decode($all_listings, true);
            $listing_name = "";
            foreach ($all_listings["listings"] as $listing) {
                if ($listing['id'] == $listing_id){
                    $listing_name = $listing['name'];
                };
            }
            $status_category = $result['listing_import']['listing_approval_status']['status_category'];
            $ls_status = $result['listing_import']['last_synchronization_status'];
            $sql = "UPDATE dc_airbnb_listingtocategory SET listing_id = $listing_id, status_category = '$status_category', sync_type = '$sync_type'
            WHERE category_id = $category_id";
            $this->db->query($sql);
            $sql = "UPDATE dc_airbnb_importtolisting SET ls_status = '$ls_status', response = '".addslashes($response)."'
            WHERE import_id = $import_id";
            $this->db->query($sql);
            if (!empty($listing_name)){
                // 	        	$sql = "UPDATE dc_airbnb_listings SET name = '$listing_name' WHERE listing_id = $listing_id";
                // 	        	$this->db->query($sql);
                $this->db->update('dc_airbnb_listings', array('name' => $listing_name), array('listing_id' => $listing_id));
            }
        }
        $data_return = array();
        $data_return ["response"] = $response;
        $data_return ["status_category"] = $status_category;
        $data_return["response_status"] = $ls_status;
        $data_return["listing_name"] = $listing_name;
        return $data_return;
    }
    
    function deletelisting($listing_id, $room_id){
        //echo "<pre>";
        //https://api.airbnb.com/v2/listing_imports/:id
        
        
        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
        
        $authparam = $this->dcm_airbnb->authparam();
        $clientid = $authparam['clientid'];
        
        
        $url = "https://api.airbnb.com/v2/listing_imports/" . $listing_id;  //сюда юзек з gettoken()
        
        $ch = curl_init ();
        
        // set the url, number of POST vars, POST data
        curl_setopt ( $ch, CURLOPT_SSL_VERIFYPEER, FALSE );
        curl_setopt ( $ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)" );
        curl_setopt ( $ch, CURLOPT_FOLLOWLOCATION, 1 );
        curl_setopt ( $ch, CURLOPT_RETURNTRANSFER, 1 );
        curl_setopt ( $ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt' );
        curl_setopt ( $ch, CURLOPT_COOKIEFILE, 'cookie.txt' );
        curl_setopt ( $ch, CURLOPT_URL, $url );
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
        curl_setopt ( $ch, CURLOPT_POST, 1 );
        //$xml = "https://dev-ul2.otelms.com/gatepublic/dcairbnb_listing/6/data.xml";
        //curl_setopt ( $ch, CURLOPT_POSTFIELDS, "{\"document_format\":\"airbnb-xml-v1\",\"document_uri\":\"" . $xml . "\",\"synchronization_frequency\":\"hourly\"}" );
        
        curl_setopt ( $ch, CURLOPT_HTTPHEADER, array (
            'Content-Type: application/json' ,
            "X-Airbnb-Oauth-Token: " . $access_token, //сюда токен з gettoken()
            "X-Airbnb-API-Key: " . $clientid,
            'X-AIRBNB-REQ-API-VERSION: 2022.03.31'
        ) );
        $response = curl_exec ( $ch );
        $result = json_decode($response, true);
        //print_r($result);
        //die();
        curl_close ( $ch );
        if (isset($result['listing_import'])) {
            $this->db->query("delete from dc_airbnb_room2listing where room_id=" . $room_id);
        }
        
        $data_return = array();
        $data_return ["response"] = $response;
        return $data_return;
    }
    
    function deletelisting_v3($import_id, $cat_id, $entity_type = "", $listing_id = 0){
        $this->validate_token();
        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
        $authparam = $this->dcm_airbnb->authparam();
        $clientid = $authparam['clientid'];
        
        $url = "https://api.airbnb.com/v2/listing_imports/" . $import_id."/".$entity_type;  //сюда юзек з gettoken()
        
        $log_data = array();
        $log_data["access_token"] = $access_token;
        $log_data["clientid"] = $clientid;
        
        $datalog = array(
            'request' => json_encode($log_data),
            'url' => "DELETE: " . $url
        );
        $this->db->insert('dc_airbnb_log', $datalog);
        $id = $this->db->insert_id();
        
        $ch = curl_init ();
        
        // set the url, number of POST vars, POST data
        curl_setopt ( $ch, CURLOPT_SSL_VERIFYPEER, FALSE );
        curl_setopt ( $ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)" );
        curl_setopt ( $ch, CURLOPT_FOLLOWLOCATION, 1 );
        curl_setopt ( $ch, CURLOPT_RETURNTRANSFER, 1 );
        curl_setopt ( $ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt' );
        curl_setopt ( $ch, CURLOPT_COOKIEFILE, 'cookie.txt' );
        curl_setopt ( $ch, CURLOPT_URL, $url );
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
        //curl_setopt ( $ch, CURLOPT_POST, 1 );
        //$xml = "https://dev-ul2.otelms.com/gatepublic/dcairbnb_listing/6/data.xml";
        //curl_setopt ( $ch, CURLOPT_POSTFIELDS, "{\"document_format\":\"airbnb-xml-v1\",\"document_uri\":\"" . $xml . "\",\"synchronization_frequency\":\"hourly\"}" );
        
        curl_setopt ( $ch, CURLOPT_HTTPHEADER, array (
            'Content-Type: application/json',
            "X-Airbnb-Oauth-Token: " . $access_token, //сюда токен з gettoken()
            "X-Airbnb-API-Key: " . $clientid,
            'X-AIRBNB-REQ-API-VERSION: 2022.03.31'
        ) );
        
        $timestart = time();
        $response = curl_exec ( $ch );
        
        $data = array(
            'response' => $response,
            'stime' => (microtime(true) - $timestart)
        );
        $this->db->update('dc_airbnb_log', $data, array(
            'id' => $id
        ));
        $result = json_decode($response, true);
        curl_close ( $ch );
        if (isset($result['listing_import'])) {
            switch ($entity_type) {
                case "import":
                    $this->db->query("delete from dc_airbnb_importtolisting where import_id=" . $import_id);
                    break;
                default:
                    $this->db->query("delete from dc_airbnb_listingtocategory where category_id=" . $cat_id);
                    $this->db->query("delete from dc_airbnb_importtolisting where import_id=" . $import_id);
                    $this->db->query("delete from dc_airbnb_listings where listing_id = " . $listing_id);
                    break;
            }
        }
        
        if (isset($result['error_code'])) {
            if ($result['error_code'] == 400) {
                
            }
            // 21-06-2022
            $this->db->query("delete from dc_airbnb_listingtocategory where category_id=" . $cat_id);
            $this->db->query("delete from dc_airbnb_importtolisting where import_id=" . $import_id);
            $this->db->query("delete from dc_airbnb_listings where listing_id = " . $listing_id);
            // 21-06-2022
            
        } else {
            $this->db->query("delete from dc_airbnb_listingtocategory where category_id=" . $cat_id);
            $this->db->query("delete from dc_airbnb_importtolisting where import_id=" . $import_id);
            $this->db->query("delete from dc_airbnb_listings where listing_id = " . $listing_id);
        }
        
        
        
        $data_return = array();
        $data_return ["response"] = $response;
        return $data_return;
    }
    
    function get_room_error( $room_id){
        $response = "";
        $sql = "SELECT response FROM dc_airbnb_room2listing WHERE room_id = ".$room_id;
        $query = $this->db->query( $sql );
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $response = $row->response;
        }
        return $response;
    }
    
    function get_room_error_v3( $category_id ){
        $response = "";
        $sql = "SELECT dc_airbnb_importtolisting.response FROM dc_airbnb_importtolisting
	    		JOIN dc_airbnb_listingtocategory ON dc_airbnb_listingtocategory.listing_id = dc_airbnb_importtolisting.listing_id
	    		WHERE category_id = ".$category_id;
        $query = $this->db->query( $sql );
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $response = $row->response;
        }
        return $response;
        
        
        $response = "";
        $sql = "SELECT dc_airbnb_importtolisting.response FROM dc_airbnb_importtolisting
	    		JOIN dc_airbnb_listingtocategory ON dc_airbnb_listingtocategory.listing_id = dc_airbnb_importtolisting.listing_id
	    		WHERE category_id = ".$category_id;
        $query = $this->db->query( $sql );
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $response = $row->response;
        }
        return $response;
    }
    
    function get_sync_type_v3( $category_id ){
        $sync_type = "";
        $sql = "SELECT sync_type FROM dc_airbnb_listingtocategory WHERE category_id = ".$category_id;
        $query = $this->db->query( $sql );
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $sync_type = $row->sync_type;
        }
        return $sync_type;
    }
    
    function gettoken()
    {
        $url = "https://api.airbnb.com/v2/oauth2/authorizations?_unwrapped=true";
        
        $authcode = $this->getxmlcfgvalue('authcode', 'str');
        
        $authparam = $this->authparam();
        $clientid = $authparam['clientid'];
        $clientsecret = $authparam['clientsecret'];
        
        // $params=array( "code"=> "35gx77nb7q0m9r9ici6sqc2ya");
        $params = array(
            "code" => $authcode
        );
        
        $ch = curl_init();
        
        // set the url, number of POST vars, POST data
        $headers = [
            'Content-Type:application/json'];
        
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_USERPWD, $clientid . ":" . $clientsecret);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
        $response = curl_exec($ch);
        curl_close($ch);
        //echo "<pre>";
        $result = json_decode($response, true);
        //print_r($result);
        if (isset($result['error_code'])) {
            return;
        }
        $access_token = $result['access_token'];
        $refresh_token = $result['refresh_token'];
        $expires_at = $result['expires_at'];
        $user_id = $result['user_id'];
        
        $this->db->query("insert into dc_airbnb_xml_cfg (name, str_value) values ('access_token', '$access_token') on duplicate key update
            str_value='$access_token'");
        
        $this->db->query("insert into dc_airbnb_xml_cfg (name, str_value) values ('refresh_token', '$refresh_token') on duplicate key update
            str_value='$refresh_token'");
        
        $this->db->query("insert into dc_airbnb_xml_cfg (name, int_value) values ('expires_at', '$expires_at') on duplicate key update
            int_value='$expires_at'");
        
        $this->db->query("insert into dc_airbnb_xml_cfg (name, int_value) values ('user_id', '$user_id') on duplicate key update
            int_value='$user_id'");
        
        
        $hotel_id = $this->config->item ( 'hotel_id' );
        if ($hotel_id != "") {
            $sql = "SELECT host, db_name FROM visitka.config WHERE id = " . $hotel_id;
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $host = $row->host;
            }
        }
        
        $db_host = $this->config->item ( 'xml_gate_db_host' );
        $db_user = $this->config->item ( 'xml_gate_db_user' );
        $db_pass = $this->config->item ( 'xml_gate_db_password' );
        
        $link = mysqli_connect ( $db_host, $db_user, $db_pass, 'dc_booking' );
        if (! $link) {
            
            echo "db error (3595)";            
            return "db error (3595)";
            // die ( 'Could not connect: ' . mysql_error () );
        }
        // выбор базы даных
        
        mysqli_query ($link, 'SET NAMES utf8' );
        
        $sql_s = "SELECT hms_url FROM dc_booking.airbnb_hms_hotels WHERE user_id = $user_id";
        $result_s = $link->query($sql_s);
        if ($result_s->num_rows == 0) {
            $sql = "INSERT INTO dc_booking.airbnb_hms_hotels (user_id, hms_url)
	        VALUES('" . $result['user_id'] . "', 'https://" . $host . "/') ON DUPLICATE KEY UPDATE hms_url = 'https://" . $host . "/'";
            mysqli_query ( $link, $sql);
        }else{
            $row = $result_s->fetch_assoc();
            $hms_url = $row->hms_url;
            $_SESSION["dc_msg"]["text"] = "missmath ID HMS_ID: $hms_url => CHANNEL_ID: ".$user_id;
            $newdata = array (
                'header_msg_text' => "missmath ID HMS_ID: $hms_url => CHANNEL_ID: ".$user_id,
            );
            $this->session->set_userdata ( $newdata );
        }
        
    }
    
    function clear_listing(){
        $sql = "DELETE FROM dc_airbnb_room2listing";
        $this->db->query( $sql );
    }
    
    function clear_listing_v3(){
        $sql = "DELETE FROM dc_airbnb_listingtocategory";
        $this->db->query( $sql );
        
        $sql = "DELETE FROM dc_airbnb_importtolisting";
        $this->db->query( $sql );
        
        $sql = "DELETE FROM dc_airbnb_listings";
        $this->db->query( $sql );
    }
    
    function refreshtoken()
    {
        
        $refreshtoken = $this->dcm_airbnb->getxmlcfgvalue('refresh_token', 'str');
        $url = "https://api.airbnb.com/v2/oauth2/authorizations?_unwrapped=true";
        $params = array(
            "refresh_token" => $refreshtoken,
            "reset_refresh_token" => 0
        );
        // echo "URl="+$url+$params."<br>";
        $ch = curl_init();
        
        $authparam = $this->dcm_airbnb->authparam();
        $clientid = $authparam['clientid'];
        $clientsecret = $authparam['clientsecret'];
        
        // set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_USERPWD, $clientid . ":" . $clientsecret);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
        
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'X-AIRBNB-REQ-API-VERSION: 2023.06.30'
        ));
        
        $response = curl_exec($ch);
        //var_dump($result);
        curl_close($ch);
        
        // 	    $newdata = array (
        // 	        'air_bnb_last' => $result
        // 	    );
        // 	    $this->session->set_userdata ( $newdata );
        
        
        
        
        $result = json_decode($response, true);
        //echo "<pre>";
        //print_r($result);
        $_SESSION["connecttoairbnb_refresh_token"] = $result;
        if (isset($result['error_code'])) {
            //die ( "<meta http-equiv='refresh' content='0;url=/dc_airbnb_c2/roomdetails/" . $room_id . "'>" );
        }
        
        $access_token = $result['access_token'];
        $expires_at = $result['expires_at'];
        $user_id = $result['user_id'];
        
        $this->db->query("insert into dc_airbnb_xml_cfg (name, str_value) values ('access_token', '$access_token') on duplicate key update
            str_value='$access_token'");
        
        $this->db->query("insert into dc_airbnb_xml_cfg (name, int_value) values ('expires_at', '$expires_at') on duplicate key update
            int_value='$expires_at'");
        
        $this->db->query("insert into dc_airbnb_xml_cfg (name, int_value) values ('user_id', '$user_id') on duplicate key update
            int_value='$user_id'");
        
        
        $hotel_id = $this->config->item ( 'hotel_id' );
        if ($hotel_id != "") {
            $sql = "SELECT host, db_name FROM visitka.config WHERE id = " . $hotel_id;
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $host = $row->host;
            }
        }
        
        $db_host = $this->config->item ( 'xml_gate_db_host' );
        $db_user = $this->config->item ( 'xml_gate_db_user' );
        $db_pass = $this->config->item ( 'xml_gate_db_password' );
        
        $link = mysqli_connect ( $db_host, $db_user, $db_pass, 'dc_booking' );
        if (! $link) {
            return 'Could not connect: ' . mysql_error ();
            // die ( 'Could not connect: ' . mysql_error () );
        }
        // выбор базы даных
        
        mysqli_query ( $link, 'SET NAMES utf8' );
        
        $sql_s = "SELECT hms_url FROM dc_booking.airbnb_hms_hotels WHERE user_id = $user_id";
        $result_s = $link->query($sql_s);
        if ($result_s->num_rows == 0) {
            $sql = "INSERT INTO dc_booking.airbnb_hms_hotels (user_id, hms_url)
	        VALUES('" . $result['user_id'] . "', 'https://" . $host . "/') ON DUPLICATE KEY UPDATE hms_url = 'https://" . $host . "/'";
            mysqli_query ( $link, $sql  );
        }else{
            $row = $result_s->fetch_assoc();
            $hms_url = $row->hms_url;
            $_SESSION["dc_msg"]["text"] = "missmath ID HMS_ID: $hms_url => CHANNEL_ID: ".$user_id;
            $newdata = array (
                'header_msg_text' => "missmath ID HMS_ID: $hms_url => CHANNEL_ID: ".$user_id,
            );
            $this->session->set_userdata ( $newdata );
        }
    }
    
    function get_country_2chr($chr3){
        $chr2 = $chr3;
        switch (strtolower($chr3)) {
            case "ukr" :
                $chr2 = strtoupper ( "ua" );
                break;
            case "rus" :
                $chr2 = strtoupper("ru");
                break;
        }
        return $chr2;
    }
    
    function get_country_2chr_v2($chr3){
        $chr2 = $chr3;
        $sql = "SELECT 2char as str_2char FROM global_fms.dict_country WHERE id LIKE '".$chr3."'";
        //echo $sql;
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $chr2 = strtoupper($row->str_2char);
        }
        
        switch (strtolower($chr3)) {
            case "ukr" :
                $chr2 = strtoupper ( "ua" );
                break;
            case "rus" :
                $chr2 = strtoupper("ru");
                break;
        }
        return $chr2;
    }
    
    function get_aiabnb_SupportedLocales() {
        $SupportedLocales = array (
            "id",
            "ms",
            "ca",
            "da",
            "de",
            "en",
            "es",
            "el",
            "fr",
            "hr",
            "it",
            "hu",
            "nl",
            "no",
            "pl",
            "pt",
            "fi",
            "sv",
            "tl",
            "is",
            "cs",
            "ru",
            "he",
            "th",
            "zh",
            "ja",
            "ko"
        );
        return $SupportedLocales;
    }
    function get_category_descriptions($category_id, $lang = "") {
        $data_category = array ();
        $sql = "SELECT language_id, name as fild_name, value
        FROM internationalfields
        WHERE internationalfields.table_id = $category_id AND internationalfields.table_type = 'category'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                if ($lang != "") {
                    if ($lang == $row->lang_name) {
                    } else {
                        continue;
                    }
                }
                $data_category [$row->language_id][str_replace("international_", "", $row->fild_name)] = $row->value;
            }
        }
        $data = array ();
        $dwelling = 0;
        $sql = "SELECT language_id, descriptionlanguages.name as lang_name, internationalfields.name as fild_name, value,
        property_information.dwelling
        FROM internationalfields
        JOIN categories ON categories.id = $category_id
        JOIN descriptionlanguages ON descriptionlanguages.id = internationalfields.language_id
        JOIN property_information ON property_information.id = categories.property_id
        WHERE internationalfields.table_id = property_information.id AND internationalfields.table_type = 'property_custom'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                if ($lang != "") {
                    if ($lang == $row->lang_name) {
                    } else {
                        continue;
                    }
                }
                $dwelling = $row->dwelling;
                $data [$row->language_id]["language"] = $row->lang_name;
                $data [$row->language_id][str_replace("international_", "", $row->fild_name)] = $row->value;
            }
        }
        $descriptions_nodes_ordered = array (
            "language",
            "name",
            "summary",
            "space",
            "access",
            "interaction",
            "neighborhood",
            "transit",
            "houseRules",
            "notes"
        );
        $rez_arr = array();
        foreach ($data as $key_lang_id => $val_arr){
            if($dwelling == 2){
                $data[$key_lang_id]["name"] = $data_category[$key_lang_id]["name"].". ".$val_arr["name"];
            }
            if(isset($data_category[$key_lang_id]["comment"])){
                $data[$key_lang_id]["summary"] .= $data_category[$key_lang_id]["comment"];
            }
            // витираєм коммент з проперті так як його не має в аірбнб, а в нас на формі є, можливо з часом
            // його треба буде кудись клеїти
            if(isset($data[$key_lang_id]["comment"])){
                unset($data[$key_lang_id]["comment"]);
            }
            foreach ($descriptions_nodes_ordered as $node){
                if (isset($val_arr[$node])){
                    $rez_arr[$key_lang_id][$node] = $data[$key_lang_id][$node];
                }
            }
        }
        
        return $rez_arr;
    }
    
    function get_listing_imports(){
        $user_id = $this->dcm_airbnb->getxmlcfgvalue('user_id', 'int');
        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
        
        $authparam = $this->authparam();
        $clientid = $authparam['clientid'];
        
        $url = "https://api.airbnb.com/v2/listing_imports/?user_id=" . $user_id; // сюда юзек з gettoken()
        
        $curl_auth_param = array();
        $curl_auth_param ['clientid'] = $authparam['clientid'];
        $curl_auth_param ['access_token'] = $access_token;
        
        $datalog = array(
            'request' => json_encode($curl_auth_param),
            'url' => $url
        );
        $this->db->insert('dc_airbnb_log', $datalog);
        $id = $this->db->insert_id();
        
        $ch = curl_init();
        // set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            "X-Airbnb-Oauth-Token: " . $access_token, // сюда токен з gettoken()
            "X-Airbnb-API-Key: " . $clientid,
            'X-AIRBNB-REQ-API-VERSION: 2022.03.31'
        ));
        
        $timestart = microtime(true);
        $response = curl_exec($ch);
        curl_close($ch);
        
        $result = json_decode($response, true);
        $data = array(
            'response' => $response,
            'stime' => (microtime(true) - $timestart)
        );
        $this->db->update('dc_airbnb_log', $data, array(
            'id' => $id
        ));
        if(isset($result["listing_imports"])){
            if(count($result["listing_imports"]) > 0){
                $lis_imports_tbl = "dc_airbnb_importtolisting";
                $this->db->empty_table($lis_imports_tbl);
                foreach($result["listing_imports"] as $import_data){
                    $insert_arr = array (
                        'import_id' => $import_data ["id"],
                        'listing_id' => $import_data ["listing_id"],
                        'ls_status' => $import_data["last_synchronization_status"],
                        'response'=> addslashes(json_encode($import_data))
                    );
                    $this->db->insert($lis_imports_tbl, $insert_arr);
                    $this->update_global_listing2imports_table ($insert_arr);
                }
            }
        }
        return $response;
    }
    
    private function update_global_listing2imports_table($data) {
        $tbl = 'dc_booking.dc_airbnb_hmsid2listing2imports';
        $hms_id = $this->config->item("hotel_id");
        $insert_arr = array(
            'hms_id'=>$hms_id,
            'import_id' => isset($data ["import_id"]) ? $data ["import_id"] : '',
            'listing_id' => isset($data ["listing_id"]) ? $data ["listing_id"] : '',
            'ls_status' => isset($data["ls_status"]) ? $data ["ls_status"] : '',
        );
        
        // ======== DELETE =========
        $this->db->where(array('listing_id' => $insert_arr['listing_id'], 'hms_id <>' => $hms_id));
        $this->db->delete($tbl);
        // ======== UPDATE / INSERT =========
        $where_arr = array('listing_id'=>$insert_arr['listing_id'], 'hms_id'=>$hms_id);
        
        $exist_hmsid_to_listingid = $this->db->get_where($tbl, $where_arr)->row();
        
        if ($exist_hmsid_to_listingid){
            $this->db->update($tbl, $insert_arr, $where_arr);
        }else{
            $this->db->insert($tbl, $insert_arr);
        }
    }
    
    function get_listings(){
        $user_id = $this->getxmlcfgvalue('user_id', 'int');
        $access_token = $this->getxmlcfgvalue('access_token', 'str');
        
        $authparam = $this->authparam();
        
        $curl_auth_param = array();
        $curl_auth_param ['clientid'] = $authparam['clientid'];
        $curl_auth_param ['access_token'] = $access_token;
        
        $all_listings = array();
        $all_pricing = array();
        $all_response = array();
        $max_loop_cycles = 10;
        $next_cursor = '';
        $listing_tbl = "dc_airbnb_listings";
        $listing_details_tbl = "dc_airbnb_listings_details";
        $this->db->empty_table($listing_tbl);
        if ($this->db->table_exists($listing_details_tbl)){
            $this->db->empty_table($listing_details_tbl);
        }
        
        do {
            $max_loop_cycles --;
            $url = "https://api.airbnb.com/v2/listings/?user_id=$user_id&has_availability=false&exclude_cohosted_listings=true&_limit=50$next_cursor"; // сюда юзек з gettoken()
            $data_result = $this->curl_model->curl_airbnb(array(), $curl_auth_param, $url, array (
                "returntype" => "array", "header"=> true
            ));
            $result = $data_result["result"];
            $result = json_decode($result, true);
            
            array_push($all_response, $data_result);
            
            
            
            
            if (isset($result["listings"])) {
                $all_listings = array_merge($all_listings, $result["listings"]);
                foreach($result["listings"] as $listing){
                    $url_pricing = "https://api.airbnb.com/v2/pricing_and_availability/".$listing["id"];
                    $result_pricing = $this->curl_model->curl_airbnb(array(), $curl_auth_param, $url_pricing, array (
                        "returntype" => "array", "header"=> true
                    ));
                    $result_pricing = $result_pricing["result"];
                    $result_pricing = json_decode($result_pricing, true);
                    
                    array_push($all_pricing, $result_pricing);
                    //$all_pricing = array_merge($all_pricing, $result_pricing);
                    
                    $insert_arr = array (
                        'listing_id' => $listing ["id"],
                        'name' => $listing ["name"],
                        'active'=> 1
                    );
                    $this->db->insert($listing_tbl, $insert_arr);
                    
                    $pricing_model = isset($result_pricing["pricing_availability_model_type"]) ? $result_pricing["pricing_availability_model_type"] : "";
                    $sync_type = @$this->db->select('sync_type')->get_where('dc_airbnb_listingtocategory', array('listing_id' => $listing ["id"]))->row()->sync_type;
                    
                    if($pricing_model != 'STANDARD' && $sync_type == 'sync_all'){
                        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
                        $authparam = $this->dcm_airbnb->authparam();
                        
                        $curl_auth_param = array();
                        $curl_auth_param ['clientid'] = $authparam['clientid'];
                        $curl_auth_param ['access_token'] = $access_token;
                        
                        $curl_data = array();
                        $curl_data ['pricing_model'] = 'STANDARD';
                        
                        $url = "https://api.airbnb.com/v2/pricing_and_availability/".$listing ["id"];
                        $data_result = $this->curl_model->curl_airbnb_set_pricing($curl_data, $curl_auth_param, $url, array (
                            "returntype" => "array"
                        ));
                        
                        $result = json_decode($data_result['result'], true);
                        
                        if ($result['success'] == true) {
                            $pricing_model = "STANDART";
                        }
                    }
                    
                    
                    $property_type_category = isset($listing ["property_type_category"]) ? $listing ["property_type_category"] : "";
                    $city = isset($listing ["city"]) ? $listing ["city"] : "";
                    $street = isset($listing ["street"]) ? $listing ["street"] : "";
                    
                    $insert_arr = array (
                        'listing_id' => $listing ["id"],
                        'property_type_category' => $property_type_category,
                        'pricing_model' => $pricing_model,
                        'city' => $city,
                        'street' => $street
                    );
                    
                    if ($this->db->table_exists($listing_details_tbl)){
                        $this->db->insert($listing_details_tbl, $insert_arr);
                    }
                    $this->update_global_listing2imports_table($insert_arr);
                }
                
                
            }
            $need_looping = false;
            if(isset($result['paging']['next_cursor']) && ($result['paging']['next_cursor'] != '' || $result['paging']['next_cursor'] != null)){
                $need_looping = true;
                $next_cursor = '&_cursor='.$result['paging']['next_cursor'];
            }
        } while ($need_looping && $max_loop_cycles > 0);
        if ($this->session->userdata ( 'global_debug' ) == 1) {
            $debug_data = array();
            $debug_data ['all_listings'] = $all_listings;
            $debug_data ['all_pricing'] = $all_pricing;
            $debug_data ['all_response'] = $all_response;
            $_SESSION["dc_msg"]["text"] = print_r($debug_data, true);
        }
        
        return json_encode(array('listings' => $all_listings));
    }
    
    function save_category_listing($data){
        if(isset($data["listing"])){
            foreach($data["listing"] as $category_id => $listing_id){
                if ($listing_id != 0){
                    $sql = "INSERT INTO dc_airbnb_listingtocategory(category_id, listing_id, sync_type)
						VALUES('" . $category_id . "', '" . $listing_id . "', '".$data["sync_type"][$category_id]."')
						ON DUPLICATE KEY UPDATE listing_id = listing_id, sync_type = '".$data["sync_type"][$category_id]."'";
                    $query = $this->db->query($sql);
                }
            }
        }
    }
    
    function transfer_hms_config(){
        $db_host = $this->config->item ( 'xml_gate_db_host' );
        $db_user = $this->config->item ( 'xml_gate_db_user' );
        $db_pass = $this->config->item ( 'xml_gate_db_password' );
        
        @$mysqli = new mysqli($db_host, $db_user, $db_pass, "dc_booking");
        if ($mysqli->connect_errno) {
            echo "Не удалось подключиться к MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
        }
        
        $hms_id = $this->config->item("hotel_id");
        $sql = "SELECT id FROM `dc_booking`.config WHERE `dc_booking`.config.id = ".$hms_id;
        $res = $mysqli->query($sql);
        $row = $res->fetch_assoc();
        
        if(!isset($row["id"])){
            $host = "";
            // fetch from `visitka`.config
            $sql = "SELECT host, db_name FROM visitka.config WHERE id = " . $hms_id;
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $host = $row->host;
            }
            // insert into `dc_booking`.config
            $db_name = $this->db->database;
            $sql = "INSERT INTO `dc_booking`.config (id, host, base_url, db_name) VALUES('" . $hms_id . "', '" . $host . "', '" . $host . "', '" . $db_name . "')";
            // 	        echo $sql;
            // 	        die();
            $mysqli->query($sql);
        }
    }
    
    function get_room_page_version(){
        $sql = "SELECT int_value FROM dc_airbnb_xml_cfg WHERE name LIKE 'room_page_version'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows()) {
            return $query->row()->int_value;
        } else {
            return 0;
        }
    }
    
    public function validate_token(){
        $authparam = $this->dcm_airbnb->authparam();
        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
        $headers = array(
            'Content-Type:application/json',
            'Authorization: Basic ' . base64_encode($authparam['clientid'] . ':' . $authparam['clientsecret']),
        );
        $url = 'https://api.airbnb.com/v2/oauth2/authorizations/' .$access_token. '?_unwrapped=true';
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $responce = curl_exec($ch);
        curl_close($ch);
        $result = json_decode($responce, true);
        
        
        if( ! isset( $result['valid'] ) || $result['valid'] == 0 ){
            $refresh_token = $this->dcm_airbnb->getxmlcfgvalue('refresh_token', 'str');
            $url = 'https://api.airbnb.com/v2/oauth2/authorizations?_unwrapped=true';
            $data = array(
                'refresh_token' => $refresh_token,
                'reset_refresh_token' => 0,
            );
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
            $buffer = curl_exec($ch);
            curl_close($ch);
            $result = json_decode($buffer, true);
            if (isset($result['error_code'])) {
                return "error_" . $result['error_code'] . " - ";
            }
            $access_token = $result['access_token'];
            //$refresh_token = $result['refresh_token'];
            $expires_at = $result['expires_at'];
            $user_id = $result['user_id'];
            $this->db->query("insert into dc_airbnb_xml_cfg (name, str_value) values ('access_token', '$access_token') on duplicate key update str_value='$access_token'");
        }
    }
    
    public function get_category_name($category_id) {//return category name in global settings lang
        $global_default_lang = 45;//eng
        $global_lang = $this->hotelix_config->get_record('global_language', 'int');
        
        
        $sql = "SELECT language_id, name as fild_name, value
        FROM internationalfields
        WHERE internationalfields.table_id = $category_id AND internationalfields.table_type = 'category'";
        $query = $this->db->query($sql);
        $discriptions = array();
        foreach ($query->result() as $row) {
            $discriptions[$row->language_id][str_replace("international_", "", $row->fild_name)] = $row->value;
        }
        $category_name = isset($discriptions[$global_lang]) ? $discriptions[$global_lang]['name'] : $discriptions[$global_default_lang]['name'];
        return $category_name;
    }
    
    function do_migrate($import_id, $listing_id, $category_id){
        return "OK";
    }
}

