<?php
class CurlUrls {
    public $booking_request = "/gate_ta/booking_request";
    public $cancel_booking = "/gate_ta/cancel_booking";
    public $sync_booking = "/gate_ta/sync_booking";
    public $availability_data = "/gate_ta/availability_data";
    public $hotel_inventory = "/gate_ta/hotel_inventory";
}
class Ta_ib_ep_model extends CI_Model {
    const  ta_to_hms_hotels_table = "`global_hotelix`.`dc_ta_hotels`";
    public function __construct(){
        parent::__construct();
    }
    function log_http_push () {
        $data = array (
            'get' => $_SERVER ['QUERY_STRING'],
            'post' => json_encode ( $_POST ),
            'rawpost' => file_get_contents ( "php://input" ),
            'server' => json_encode ( $_SERVER )
        );
        $this->db->insert ( 'dc_booking.ta_http_push', $data );
    }
    function curl_get_requested_data($requested_data, $url) {
        $headers = array('Content-Type: application/json');
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $requested_data);
        $result = curl_exec($ch);
        curl_close($ch);
        if (Ta_ib_ep::$die_in_curl_debug_mode){
            echo "<pre>";
            print_r($result);
            die("DIED by A Department on ta_ib_ep_model.php curl_get_requested_data() coz Ta_ib_ep::die_in_curl_debug_mode == TRUE");
        }
        return $result;
    }
    
    function get_ta_hotels_inventory($single_hotel_partner_hotel_code = "") {
        $tbl = $this::ta_to_hms_hotels_table;
        $where_arr = array('active' => 1, 'hms_id !=' => 92);
        if (!empty($single_hotel_partner_hotel_code)){
            $parsed_ids_arr = explode('_', $single_hotel_partner_hotel_code);
            $where_arr['hms_id'] = $parsed_ids_arr[0];
            $where_arr['prop_id'] = $parsed_ids_arr[1];
        }
        $hotels_list = $this->db->get_where($tbl, $where_arr)->result_array();
        return (!empty($single_hotel_partner_hotel_code)) ? $hotels_list[0] : $hotels_list;
    }
    
    function get_ta_hotels($single_hotel_partner_hotel_code = "") {
        $tbl = $this::ta_to_hms_hotels_table;
        $where_arr = array('availability' => 1);
        if (!empty($single_hotel_partner_hotel_code)){
            $parsed_ids_arr = explode('_', $single_hotel_partner_hotel_code);
            $where_arr['hms_id'] = $parsed_ids_arr[0];
            $where_arr['prop_id'] = $parsed_ids_arr[1];
        }
        $hotels_list = $this->db->get_where($tbl, $where_arr)->result_array();
        return (!empty($single_hotel_partner_hotel_code)) ? $hotels_list[0] : $hotels_list;
    }
    function get_hotel_inventory_data($requested_hotel) {
        $curl_url = $requested_hotel['host']. $this->curl_urls->hotel_inventory;
        $curl_url = "https://" . $curl_url;
        $hotel_inventory_data = json_decode($this->curl_get_requested_data(json_encode($requested_hotel), $curl_url));
        return $hotel_inventory_data;
    }
    function get_hotel_availability_data($availability_requested_data) {
        $curl_url = $this->curl_urls->availability_data;
        $curl_url = $availability_requested_data['host'].$curl_url;
        $curl_url = "https://" . $curl_url;
        $hms_availability_data = json_decode($this->curl_get_requested_data(json_encode($availability_requested_data), $curl_url));
        return $hms_availability_data;//json_decode(json_encode($result_arr), FALSE);//(object)$result_arr;
    }
}

class Response{
    protected $request = "";
    public $api_version = 8;
    public function __construct($request){
        if (!empty($request)){
            $this->request = $request;
        }else{
            exit('{Cannot Parse Request}');
        }
    }
    private function validate(&$obj_or_arr) {
        foreach ( $obj_or_arr as $p => $v ) {
            if (is_array($v) || is_object($v)){
                $this->validate($v);
                if (!count((array)$v)){
                    unset($obj_or_arr->$p);
                }
            }elseif (is_null($v)) {
                unset($obj_or_arr->$p);
            }
        }
    }
    private function __validate() {
        self::validate($this);
    }
    public function get_request(){
        return json_decode($this->request);
    }
    public function makelog() {
        $data = array (
            'rawpost' => json_encode($this, true)
        );
        $this->db->insert ( 'dc_booking.ta_http_response', $data );
    }
    public function get_response() {
        return json_encode($this, true);
    }
    public function send($debug_mode = FALSE) {
        if ($debug_mode){
            echo "<pre>";
            print_r($this);
            die("DIED. Controller class Ta_ib_ep {static debug_mode = TRUE}");
        }else{
            self::__validate();
            header ( 'Content-Type: application/json' );
            echo json_encode($this, true);
        }
    }
}

class ConfigResponse extends Response {
    public $configuration = 'required';
    public $debug_info = "debug mode";
    public function __construct(){
        $this->configuration = new Configuration;
    }
}

class InventoryResponse extends Response {
    public $lang = "en_US";
    public $hotels = 'required';
    public function __construct($request){
        parent::__construct($request);
    }
    public function add_hotel($hotel_data) {
        if (!is_array($this->hotels)){
            $this->hotels = array();
        }
        $this->hotels[] = new InventoryHotel ($hotel_data);
    }
}

class BookingSubmitResponse extends Response {
    public $problems;
    public $reference_id;
    public $status;
    public $reservation;
    public $customer_support;
    public function __construct($request){
        parent::__construct($request);
        if (!empty($request)){
            $request = json_decode($request);
            $this->reference_id = $request->reference_id;
            $this->reservation = new Reservation($request);
            $this->customer_support = new CustomerSupport();
        }else{
            exit('Cannot Parse Booking Submit Response');
        }
    }
    // 	public function get_requested_rooms_count (){
    // 		return count($this->reservation->rooms);
    // 	}
    // 	public function get_start_intday(){
    // 		return round (strtotime($this->reservation->start_date)/86400);
    // 	}
    // 	public function get_end_intday(){
    // 		return round (strtotime($this->reservation->end_date)/86400);
    // 	}
}

class BookingCancelResponse extends Response {
    public $booking_cancel_request;
    public $status;//Success, AlreadyCancelled, CannotBeCancelled, UnknownReference, Error
    public $cancellation_number;
    public $customer_support;
    public function __construct($request){
        parent::__construct($request);
        if (!empty($request)){
            $request = json_decode($request);
            $this->booking_cancel_request = $request;
            $this->customer_support = new CustomerSupport();
        }else{
            exit('Cannot Parse Booking Submit Response');
        }
    }
}

class BookingSyncResponse extends Response {
    private $SingleHotelResponses_array = array();
    public function __construct($request){
        parent::__construct($request);
    }
    public function add_SyncSingleHotelResponse($sync_data) {
        $this->SingleHotelResponses_array[] = new BookingSyncSingleHotelResponse ($sync_data);
    }
    public function send($debug_mode = FALSE) {
        if ($debug_mode){
            echo "<pre>";
            print_r($this);
            die("DIED. Controller class Ta_ib_ep {static debug_mode = TRUE}");
        }else{
            header ( 'Content-Type: application/json' );
            echo json_encode($this->SingleHotelResponses_array, true);
        }
    }
}

class BookingSyncSingleHotelResponse {
    public $reservation_id;
    public $partner_hotel_code;
    public $status;//Booked, Cancelled, CheckedIn, CheckedOut, NoShow, UnknownReference
    public $checkin_date;
    public $checkout_date;
    public $cancelled_date;
    public $cancellation_number;
    public $total_rate;
    public $total_taxes;
    public $total_fees;
    public function __construct($request){
        if (!empty($request)){
            foreach ($this as $p => $v) {
                if (isset($request->$p) && $request->$p != ""){
                    $this->$p = $request->$p;
                }else{
                    unset($this->$p);
                }
            }
        }else{
            exit('Cannot Parse SyncBookingSingleHotelResponse');
        }
    }
}

class AvailabilityResponse extends Response {
    public $language = "en_US";
    public $availability_request;
    public $response_payload;
    public $hotels;
    public function __construct($request){
        if (!empty($request)){
            $request = json_decode($request);
            $this->response_payload = $request->requested_payload;
            $this->availability_request = $request;
            $this->hotels = new stdClass();
            foreach ($this->availability_request->hotels as $requested_hotel) {
                $partner_hotel_code = $requested_hotel->partner_hotel_code;
                $this->hotels->$partner_hotel_code = new SingleHotelResponse();
            }
        }else{
            exit('Cannot Parse Availability Request');
        }
    }
    public function get_start_intday(){
        return round (strtotime($this->availability_request->start_date)/86400);
    }
    public function get_end_intday(){
        return round (strtotime($this->availability_request->end_date)/86400);
    }
    public function get_requested_flags ($flag = ""){
        $rezult = new stdClass();
        if (! is_null ( $this->availability_request )) {
            foreach ( $this->availability_request->requested_payload->categories as $flag_name => $flag_val ) {
                $rezult->$flag_name = $flag_val;
            }
            foreach ( $this->availability_request->requested_payload->category_modifiers as $flag_name => $flag_val ) {
                $rezult->$flag_name = $flag_val;
            }
            if (!empty($flag)){
                return $rezult->$flag;
            }
        } else {
            echo "NO requested_payload";
        }
        return $rezult;
    }
    public function get_requested_rooms_count (){
        return count($this->availability_request->party);
    }
    public function get_requested_guests_count (){
        $max_guests_count = 1;
        foreach ($this->availability_request->party as $room_party) {
            $children_count = (isset($room_party->children)) ? count($room_party->children) : 0;
            $room_guests_count = $room_party->adults + $children_count;
            if ($room_guests_count > $max_guests_count){ $max_guests_count = $room_guests_count;}
        }
        return $max_guests_count;
    }
}

class ContactInfo {
    // full_name	string 		The full name of the contact
    // email		string 		The email address for the contact. Maximum of 256 characters.
    // phone_number	string 		The phone number for the contact. maximum of 50 characters.
    public $full_name;
    public $email;
    public $phone_number;
    public function __construct($full_name = 'required', $email = 'required', $phone_number = 'required'){
        $this->full_name = $full_name;
        $this->email = $email;
        $this->phone_number = $phone_number;
    }
}


class Configuration {
    // 	emergency_contacts	ContactInfo array Array of Technical Contact Info objects. Must be present. Must include technical contacts to be notified in case of urgent API issues.
    // 	info_contacts	ContactInfo array	Array of Contact Info objects. Must be present.
    // 	languages	string array	[Optional] Array of strings. This is a list of languages that the partner supports. Use the least specific language possible, e.g. If the partner supports all English regardless of country, list only “en”. Do not list all the currently supported variants of English. TripAdvisor may still send requests that do not use one of the partner’s supported languages. If this happens, the response can be any language the partner chooses; however, TripAdvisor will not allow this property to be displayed in Instant Booking for that particular locale.
    // 	pref_hotels	number	[Optional] Preferred number of hotels per availability request. TripAdvisor may still request a different number of hotels in one request. This is a suggestion to TripAdvisor.
    // 	five_min_rate_limit	number	[Optional] Preferred rate limit, number of requests over 5 minutes. This is a suggestion to TripAdvisor
    public $emergency_contacts = 'required';
    public $info_contacts = 'required';
    public $languages = array();
    public $pref_hotels = 50;
    public $five_min_rate_limit = 10000;
    
    public function __construct(){
        // 		unset($this->pref_hotels);
        // 		$this->languages = array();
        // 		$this->info_contacts = new ContactInfo;
    }
    
    public function add_emergency_contact($full_name = 'required', $email = 'required', $phone_number = 'required') {
        if (!is_array($this->emergency_contacts)){
            $this->emergency_contacts = array();
        }
        $this->emergency_contacts[] = new ContactInfo ($full_name, $email, $phone_number);
    }
    public function add_info_contact($full_name = 'required', $email = 'required', $phone_number = 'required') {
        if (!is_array($this->info_contacts)){
            $this->info_contacts = array();
        }
        $this->info_contacts[] = new ContactInfo ($full_name, $email, $phone_number);
    }
}

class InventoryHotel{
    public $ta_id			;//= 0;
    public $partner_id		;//= 'required';
    public $name			;//= 'required';
    public $street			;//= 'required';
    public $city			;//= 'required';
    public $postal_code		;//= '';
    public $state			;//= 'required';
    public $country			;//= 'required';
    public $latitude		;//= 0;
    public $longitude		;//= 0;
    public $desc			;//= '';
    public $url				;//= 'required';
    public $email			;//= '';
    public $phone			;//= '';
    public $fax				;//= '';
    public $room_types		;//= '';
    
    public function __construct($hotel_data){
        foreach ($this as $p => $v) {
            if (isset($hotel_data->$p)){
                $this->$p = $hotel_data->$p;
            }
        }
        $this->latitude = !is_null($this->latitude) ? (double)$this->latitude : NULL;
        $this->longitude = !is_null($this->longitude) ? (double)$this->longitude : NULL;
        $this->ta_id = !is_null($this->ta_id) ? (int)$this->ta_id : NULL;
        // 		$this->room_types = (object) array('RoomShortName' => new InventoryRoomType);
    }
}

class InventoryRoomType {
    // 	Field			Type			Description
    // 	url				string		 	[Optional] The URL of the hotel on the partner site. Make this URL as specific as possible. This URL must be accessible with a GET request. Maximum 2000 characters.
    // 	desc			string		 	[Optional] Description of the room type. Maximum 1000 characters.
    
    public $url		= "";
    public $desc	= "";
    public function __construct(){
    }
}
class SingleHotelResponse  {
    // 	Field			Type			Description
    // 	response_type	string			The type of response returned for a hotel. Must be one of "available",  "unavailable" or "error"
    // 	available		SingleHotel map	Representation of an individual hotel. Only if response_type is "available".
    // 	error			Error object	Only if response_type is "error". See Error.
    public $response_type;
    public $available;
    public $error;
    public function __construct(){
    }
}
class RoomType {
    public $persistent_room_type_code;
    public $name;
    public $description;
    public $photos;
    public $room_amenities;
    public $max_occupancy;
    public $room_size;
    public $bed_configurations;
    public $extra_bed_configurations;
    public $room_view_types;
    public $accessibility_features;
    public $room_smoking_policy;
    
    public function __construct($room_data=array()){
        foreach ($this as $p => $v) {
            if (isset($room_data[$p])){
                $this->$p = $room_data[$p];
            }
        }
    }
}
class RatePlan {
    public $persistent_rate_plan_code;
    public $name;
    public $description;
    public $photos;
    public $rate_amenities;
    public $cancellation_policy ;
    public $meal_plan;
    
    public function __construct($rate_data=array()){
        foreach ($this as $p => $v) {
            if (isset($rate_data[$p])){
                $this->$p = $rate_data[$p];
            }
        }
    }
}
class RoomRates {
    public $persistent_room_rate_code;
    public $room_type_key;
    public $rate_plan_key;
    public $line_items;
    public $payment_policy;
    public $rooms_remaining;
    public $other_policy;
    public $url;
    public $partner_data;
    
    public function __construct($room_rate_data=array()){
        foreach ($this as $p => $v) {
            if (isset($room_rate_data[$p])){
                $this->$p = $room_rate_data[$p];
            }
        }
    }
}
class LineItems {
    public $price;
    public $type;
    public $sub_type;
    public $paid_at_checkout;
    
    public function __construct($line_item_data=array()){
        foreach ($this as $p => $v) {
            if (isset($line_item_data[$p])){
                $this->$p = $line_item_data[$p];
            }
        }
    }
}
class HotelDetails {
    public $name;
    public $address1;
    public $address2;
    public $city;
    public $state;
    public $postal_code;
    public $country;
    public $latitude;
    public $longitude;
    public $phone;
    public $url;//URL for general hotel contact, not a booking page.
    public $hotel_amenities;
    public $photos;
    public $checkin_checkout_policy;
    public $checkin_time;
    public $checkout_time;
    public $hotel_smoking_policy;
    public $child_policy;
    public $pet_policy;
    public $parking_shuttle;
    public $hotel_extra_bed_policy;
    
    public function __construct($hotel_details=stdClass){
        foreach ($this as $p => $v) {
            if (isset($hotel_details->$p)){
                $this->$p = $hotel_details->$p;
            }
        }
    }
}
class PartnerBookingDetails {
    public $accepted_credit_cards;
    public $terms_and_conditions;
    public $terms_and_conditions_url;
    public $payment_policy;
    public $other_policy;
    public $customer_support;
    public function __construct($partner_booking_details=stdClass){
        $this->accepted_credit_cards = array('Visa', 'MasterCard', 'AmericanExpress', 'Discover');
        $this->customer_support = new CustomerSupport();
        foreach ($this as $p => $v) {
            if (isset($partner_booking_details->$p)){
                $this->$p = $partner_booking_details->$p;
            }
        }
    }
}
class Error {
    
    // 	error_code			number			One of these error codes:
    // 										1	Unknown Error
    // 										2	Cannot Parse Request
    // 										3	Invalid Hotel ID. If partner_hotel_code is unknown, return this.
    // 										4	Timeout requested. Stops requests for the specified time.
    // 										5	Recoverable Error. Equivalent to http 503.
    // 	message				string			String describing the error. Used for debugging. Maximum length is 1000 characters.
    // 	timeout				number			Number of seconds we should stop sending requests for use with Error Code 4
    
    public $error_code;
    public $message;
    public $timeout;
    
    public function __construct(){
    }
}
class Photo {
    public $url;
    public $caption;
    public $width;
    public $height;
    public function __construct($photo_details=array()){
        foreach ($this as $p => $v) {
            if (isset($photo_details[$p])){
                $this->$p = $photo_details[$p];
            }
        }
    }
}
class Customer {
    public $first_name;
    public $last_name;
    public $phone_number;
    public $email;
    public $country;
    public function __construct(){
    }
}
class RoomStay {
    public $party;
    public $traveler_first_name;
    public $traveler_last_name;
    public function __construct(){
    }
}
class PaymentMethod {
    public $card_type;
    public $card_number;
    public $cardholder_name;
    public $expiration_month;
    public $expiration_year;
    public $cvv;
    public $billing_address;
    public function __construct(){
    }
}
class Address {
    public $address1;
    public $address2;
    public $city;
    public $state;
    public $postal_code;//U.S. Address: Required Other Address: Optional. Zip code or postal code
    public $country;//ISO 3166 country code
    public function __construct(){
    }
}
class Reservation {
    public $reservation_id;
    public $status;// The status of the reservation, must be one of:Booked, Cancelled, CheckedIn, CheckedOut
    public $confirmation_url = "NONE";
    public $start_date;
    public $end_date;
    public $partner_hotel_code;
    public $hotel;//HotelDetails object
    public $customer;
    public $rooms;
    public $legal_text;
    public $comments;
    public $line_items;//An array of LineItem objects will contain a separate LineItem for rate, tax, and fee types with each corresponding sub_type
    public function __construct($request_data = stdClass){
        foreach ($this as $p => $v) {
            if (isset($request_data->$p)){
                $this->$p = $request_data->$p;
            }
        }
    }
}
class PriceItems {
    public $requested_currency_price;
    public $currency_of_charge_price;
    public function __construct($price_item_data){
        foreach ($this as $p => $v) {
            if (isset($price_item_data[$p])){
                $this->$p = $price_item_data[$p];
            }
        }
    }
}
class Price {
    public $amount;// number The value of the price.
    public $currency;// string ISO 4217 currency code for the price
    public function __construct($amount=NULL, $currency=NULL){
        $this->amount = $amount;
        $this->currency = $currency;
    }
}
class Problem {
    public $problem;
    public $explanation;
    public $detail;
    public function __construct(){
    }
}
class Contact {
    public $contact;//string	The contact detail, e.g. phone number or email address
    public $description;//string A description for this contact.
    public function __construct(){
    }
}
class CustomerSupport {
    public $phone_numbers;
    public $emails;
    public $urls;
    public function __construct(){
        $this->phone_numbers->standard = array (array(
            'description' => 'Short description of the phone number',
            'country_code' => '4',
            'number' => 03228764932 )
        );
        $this->phone_numbers->custom = array ();
        $this->emails = array(array('description'=>'', 'email'=>'info@otelms.com'));
        
    }
}
class ProblemTypes {
    public $problem_type = array (
        'CreditCardDeclined',
        'CreditCardTypeNotSupported',
        'MissingTravelerFirstName',
        'MissingTravelerLastName',
        'MissingEmail',
        'MissingReservationFirstName',
        'MissingReservationLastName',
        'MissingWorkPhone',
        'MissingHomePhone',
        'MissingAddress',
        'MissingCity',
        'MissingStateProvince',
        'MissingCountry',
        'MissingPostalCode',
        'MissingCardholderName',
        'InvalidTravelerFirstName',
        'InvalidTravelerLastName',
        'InvalidEmail',
        'InvalidReservationFirstName',
        'InvalidReservationLastName',
        'InvalidWorkPhone',
        'InvalidHomePhone',
        'InvalidAddress',
        'InvalidCity',
        'InvalidStateProvince',
        'InvalidCountry',
        'InvalidPostalCode',
        'InvalidCardholderName',
        'UnknownUserProblem',
        'RoomNotAvailable',
        'PartnerDown',
        'PartnerTimeout',
        'AgentAttention',
        'PropertyNotSupported',
        'PriceMismatch',
        'UnknownReference',
        'UnknownPartnerProblem'
    );
}