<?php

class Curl_model extends CI_model
{
    
    function __construct()
    {
        parent::__construct();
        $this->load->model('loger_dc');
    }
    
    function curl_su_test($data){
        if ($this->config->item('loger_v2') == 0) {
            $log_data = array(
                'request' => json_encode($data),
                'url' => $data['url']
            );
        
            $this->db->insert('dc_su_log', $log_data);
            $id = $this->db->insert_id();
        }
        
        $headers = array(
            'Authorization: Basic ' . $data['auth'],
            'Content-Type: application/json'
        );
        
        $curl = curl_init();
		
		curl_setopt($curl, CURLOPT_URL, $data['url']);
		curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 0);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
		curl_setopt($curl, CURLINFO_HEADER_OUT, true);
		curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($curl, CURLOPT_POST, 1);
		curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data['request']) );
		
        
        $information = curl_getinfo($curl);
        $timestart = microtime(true);
        $response = curl_exec($curl);
        $http_code = - 1;
        if (! curl_errno($curl)) {
            $info = curl_getinfo($curl);
            $http_code = $info['http_code'];
        }
        
        curl_close($curl);
        
        $log_data = array(
            'response' => $response,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_su_log', $log_data, array(
                'id' => $id
            ));
        } else {
            $log_data["request"] = json_encode($data);
            $log_data["url"] = $data['url'];
            $log_data["dc_id"] = 40;
            $id = $this->loger_dc->SaveLog_v2($log_data);
        }
        
        if (isset($data["returntype"])) {
            if ($data["returntype"] == "array") {
                $return_data = array();
                $return_data["result"] = json_decode($response, 1);
                $return_data["responseint"] = $http_code;
                $return_data["dc_log_id"] = $id;
                return $return_data;
            } else {
                return json_decode($response, 1);
            }
        } else {
            return json_decode($response, 1);
        } 
    }
    
    function curl_hotelbeds($data)
    {
        if ($this->config->item('loger_v2') == 0) {
            $log_data = array(
                'request' => json_encode($data),
                'url' => $data['url']
            );
            
            $this->db->insert('dc_hotelbeds_log', $log_data);
            $id = $this->db->insert_id();
        }
        
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $data['url'],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_USERPWD => $data['user'] . ':' . $data['password'],
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1
        ));
        
        $information = curl_getinfo($curl);
        $timestart = microtime(true);
        $response = curl_exec($curl);
        $http_code = - 1;
        if (! curl_errno($curl)) {
            $info = curl_getinfo($curl);
            $http_code = $info['http_code'];
        }

        curl_close($curl);
        
        $log_data = array(
            'response' => $response,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_hotelbeds_log', $log_data, array(
                'id' => $id
            ));
        } else {
            $log_data["request"] = json_encode($data);
            $log_data["url"] = $data['url'];
            $log_data["dc_id"] = 39;
            $id = $this->loger_dc->SaveLog_v2($log_data);
        }
        
        if (isset($data["returntype"])) {
            if ($data["returntype"] == "array") {
                $return_data = array();
                $return_data["result"] = json_decode($response, 1);
                $return_data["responseint"] = $http_code;
                $return_data["dc_log_id"] = $id;
                return $return_data;
            } else {
                return json_decode($response, 1);
            }
        } else {
            return json_decode($response, 1);
        }
    }

    function curl_booking_get_missed_bookings($data)
    {
        if ($this->config->item('loger_v2') == 0) {
            $log_data = array(
                'request' => json_encode($data),
                'url' => $data['url']
            );
            
            $this->db->insert('dc_booking_log', $log_data);
            $id = $this->db->insert_id();
        }
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $data['url'].'/hotels/ota/OTA_HotelResNotif?id=' . $data['reservation_id']);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        
        $information = curl_getinfo($ch);
        $timestart = microtime(true);
        $response = curl_exec($ch);
        $http_code = - 1;
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
        }
        
        curl_close($ch);
        
        $log_data = array(
            'response' => $response,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_booking_log', $log_data, array(
                'id' => $id
            ));
        } else {
            $log_data["request"] = json_encode($data);
            $log_data["url"] = $data['url'];
            $log_data["dc_id"] = 1;
            $id = $this->loger_dc->SaveLog_v2($log_data);
        }
        
        if (isset($data["returntype"])) {
            if ($data["returntype"] == "array") {
                $return_data = array();
                $return_data["result"] = json_decode($response, 1);
                $return_data["responseint"] = $http_code;
                $return_data["dc_log_id"] = $id;
                return $return_data;
            } else {
                return json_decode($response, 1);
            }
        } else {
            return json_decode($response, 1);
        }
    }
        
    function curl_hotelbeds_uploads($data)
    {
        if ($this->config->item('loger_v2') == 0) {
            $log_data = array(
                'request' => json_encode($data),
                'url' => $data['url']
            );
    
            $this->db->insert('dc_hotelbeds_log', $log_data);
            $id = $this->db->insert_id();
        }
    
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $data ['url'],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $data ['xml'],
            CURLOPT_HTTPHEADER => array(
                'Content-Type: text/xml'
            ),
        ));
    
        $information = curl_getinfo($curl);
        $timestart = microtime(true);
        $response = curl_exec($curl);
        $http_code = - 1;
        if (! curl_errno($curl)) {
            $info = curl_getinfo($curl);
            $http_code = $info['http_code'];
        }
         //echo "CURL RESPONSE: ".$response;
         
$decoded_result = htmlspecialchars_decode($response);

	            $xml = new SimpleXMLElement($decoded_result);
	            $xml->registerXPathNamespace('c', 'http://www.hotelbeds.com/schemas/2005/06/messages');
	            $contractDetail = $xml->xpath('//c:HSI_ContractInventoryModificationRS');
	            echo "<pre>";
	            print_r($contractDetail);

         die();
         
         print_r($info);
        curl_close($curl);
    
        $log_data = array(
            'response' => $response,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_hotelbeds_log', $log_data, array(
                'id' => $id
            ));
        } else {
            $log_data["request"] = json_encode($data);
            $log_data["url"] = $data['url'];
            $log_data["dc_id"] = 39;
            $id = $this->loger_dc->SaveLog_v2($log_data);
        }
    
        if (isset($data["returntype"])) {
            if ($data["returntype"] == "array") {
                $return_data = array();
                $return_data["result"] = json_decode($response, 1);
                $return_data["responseint"] = $http_code;
                $return_data["dc_log_id"] = $id;
                return $return_data;
            } else {
                return json_decode($response, 1);
            }
        } else {
            return json_decode($response, 1);
        }
    }
    
    function curl_mandarin_get_account($data)
    {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $data['url'],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 60,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLINFO_HEADER_OUT => true,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_POSTFIELDS => json_encode($data['body']),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'X-Auth: ' . $data['auth_token']
            )
        ));
        $information = curl_getinfo($curl);
        $response = curl_exec($curl);
        $error = curl_error($curl);
        curl_close($curl);
        
        return $response;
    }
    
    function curl_stripe_api_call($data)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $data['url']);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_USERPWD, $data['secret_key'] . ": ");
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, 'payment_method=' . $data['payment_method']);
        $buffer = curl_exec($ch);
        curl_close($ch);
        
        $response = json_decode($buffer, true);
        
        return $response;
    }
    
    function Curl_airbnb($data, $auth_data, $url, $special = array())
    {
        $dc_id = 22;
        
        // ----- START LOG -----------
        $start_hide_pos = 3;
        $hide_len = 15;
        
        
        if (isset($special["header"])) {            
            $headers_for_log = array(
                'Content-Type: application/json',
                "X-Airbnb-Oauth-Token: " . $this->frontdesk_c2->hide_data($auth_data["access_token"], $start_hide_pos, $hide_len),
                "X-Airbnb-API-Key: " . $this->frontdesk_c2->hide_data($auth_data["clientid"], $start_hide_pos, $hide_len),
                "X-AIRBNB-REQ-API-VERSION: 2023.06.30"
            );
        } else {
            $headers_for_log = array(
                'Content-Type: application/json',
                "X-Airbnb-Oauth-Token: " . $this->frontdesk_c2->hide_data($auth_data["access_token"], $start_hide_pos, $hide_len),
                "X-Airbnb-API-Key: " . $this->frontdesk_c2->hide_data($auth_data["clientid"], $start_hide_pos, $hide_len),
                "X-AIRBNB-REQ-API-VERSION: 2022.12.31"
            );
        }
        
        $request_log = array();
        $request_log['headers'] = $headers_for_log;
        $request_log['endpoint'] = $url;
        
        if ($this->config->item('loger_v2') == 1) {} else {
            $datalog = array(
                'request' => json_encode($request_log),
                'url' => $url
            );
            $this->db->insert('dc_airbnb_log', $datalog);
            $id = $this->db->insert_id();
        }
        // ----- END LOG -----------
        
        $headers = array(
            'Content-Type: application/json',
            "X-Airbnb-Oauth-Token: " . $auth_data["access_token"], // сюда токен з gettoken()
            "X-Airbnb-API-Key: " . $auth_data["clientid"],
            "X-AIRBNB-REQ-API-VERSION: 2022.12.31"
        );
        
        $ch = curl_init();
        // set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        
        $timestart = microtime(true);
        $response = curl_exec($ch);
        
        $info = curl_getinfo($ch);
        $http_code = $info['http_code'];
        
        
        curl_close($ch);
        
        $data = array(
            'response' => $response,
            'stime' => (microtime(true) - $timestart)
        );
        
//         echo $http_code . $this->config->item('loger_v2');
//         die($http_code);
        
        $data['responseint'] = $http_code;
        
        // ----- START LOG -----------
        if ($this->config->item('loger_v2') == 1) {
            $data["request"] = json_encode($request_log);
            $data["url"] = $url;
            $data["dc_id"] = $dc_id;
            $id = $this->loger_dc->SaveLog_v2($data);
        } else {            
            $this->db->update('dc_airbnb_log', $data, array(
                'id' => $id
            ));
        }
        // ----- END LOG -----------
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $response;
                $data["dc_log_id"] = $id;
                $data['http_code'] = $http_code;
                return $data;
            } else {
                return $response;
            }
        } else {
            return $response;
        }
    }
    
    function curl_airbnb_set_pricing($data, $auth_data, $url, $special = array())
    {
        $dc_id = 22;
        
        $curl_request = array(
            'pricing_availability_model_type' => $data['pricing_model'],
            'clear_incompatible_settings' => true
        );
        
        // ----- START LOG -----------
        $start_hide_pos = 3;
        $hide_len = 15;
        $headers_for_log = array(
            'Content-Type: application/json',
            "X-Airbnb-Oauth-Token: " . $this->frontdesk_c2->hide_data($auth_data["access_token"], $start_hide_pos, $hide_len),
            "X-Airbnb-API-Key: " . $this->frontdesk_c2->hide_data($auth_data["clientid"], $start_hide_pos, $hide_len),
            "X-AIRBNB-REQ-API-VERSION: 2023.06.30"            
        );
        
        $request_log = array();
        $request_log['headers'] = $headers_for_log;
        $request_log['curl_request'] = $curl_request;
        $request_log['endpoint'] = $url;
        
        if ($this->config->item('loger_v2') == 1) {} else {
            $datalog = array(
                'request' => json_encode($request_log),
                'url' => $url
            );
            $this->db->insert('dc_airbnb_log', $datalog);
            $id = $this->db->insert_id();
        }
        // ----- END LOG -----------
        
        $headers = array(
            'Content-Type: application/json',
            "X-Airbnb-Oauth-Token: " . $auth_data["access_token"], // сюда токен з gettoken()
            "X-Airbnb-API-Key: " . $auth_data["clientid"],
            "X-AIRBNB-REQ-API-VERSION: 2023.06.30"            
        );
        
        $ch = curl_init();
        
        curl_setopt_array($ch, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_CUSTOMREQUEST => "PUT",
            CURLOPT_POSTFIELDS => json_encode($curl_request)
        ));
        
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        
        $timestart = microtime(true);
        $response = curl_exec($ch);
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
        }
        
        curl_close($ch);
        
        $data = array(
            'response' => $response . " " . json_encode(array(
                'http_code' => $http_code
            )),
            'responseint' => $http_code,
            'stime' => (microtime(true) - $timestart)
        );
        
        // ----- START LOG -----------
        if ($this->config->item('loger_v2') == 1) {
            $data["request"] = json_encode($request_log);
            $data["url"] = $url;
            $data["dc_id"] = $dc_id;
            $id = $this->loger_dc->SaveLog_v2($data);
        } else {
            $this->db->update('dc_airbnb_log', $data, array(
                'id' => $id
            ));
        }
        // ----- END LOG -----------
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $response;
                $data["dc_log_id"] = $id;
                return $data;
            } else {
                return $response;
            }
        } else {
            return $response;
        }
    }
    
    function curl_airbnb_v222($data, $auth_data, $url, $special = array()) // не використовується, на видалення
    {
        $dc_id = 22;
        $request = json_encode($data);
        if ($this->config->item('loger_v2') == 1) {} else {
            $datalog = array(
                'request' => $request,
                'url' => $url
            );
            $this->db->insert('dc_airbnb_log', $datalog);
            $id = $this->db->insert_id();
        }
        
        $headers = array(
            'Content-Type:application/json',
            'X-Airbnb-Oauth-Token:' . $auth_data["access_token"], // сюда токен з gettoken()
            'X-Airbnb-API-Key:' . $auth_data["clientid"],
            "X-AIRBNB-REQ-API-VERSION: 2023.06.30"
        );
        
        $ch = curl_init();
        curl_setopt_array($ch, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $request,
            CURLOPT_HTTPHEADER => $headers
        ));
        
        $timestart = microtime(true);
        $response = curl_exec($ch);
        curl_close($ch);
        
        $data = array(
            'response' => $response,
            'stime' => (microtime(true) - $timestart)
        );
        
        if ($this->config->item('loger_v2') == 1) {
            $data["request"] = $request;
            $data["url"] = $url;
            $data["dc_id"] = $dc_id;
            $id = $this->loger_dc->SaveLog_v2($data);
        } else {
            $this->db->update('dc_airbnb_log', $data, array(
                'id' => $id
            ));
        }
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $response;
                $data["dc_log_id"] = $id;
                return $data;
            } else {
                return $response;
            }
        } else {
            return $response;
        }
    }
    
    function curl_airbnb_v2($request_data, $auth_data, $url, $special = array(), $method = "POST")
    {
        $dc_id = 22;
        
        
        if (isset($auth_data['airbnb_version'])) {
            if ($auth_data['airbnb_version'] == 1) {
                $header_version = '"X-AIRBNB-REQ-API-VERSION: 2023.06.30"';
            }
        }
        
        $header_version = 'X-AIRBNB-REQ-API-VERSION: 2022.12.31';
        $header_version = 'X-AIRBNB-REQ-API-VERSION: 2023.06.30';
        
        // ----- START LOG -----------
        $start_hide_pos = 3;
        $hide_len = 15;
        $headers_for_log = array(
            'Content-Type: application/json',
            "X-Airbnb-Oauth-Token: " . $this->frontdesk_c2->hide_data($auth_data["access_token"], $start_hide_pos, $hide_len),
            "X-Airbnb-API-Key: " . $this->frontdesk_c2->hide_data($auth_data["clientid"], $start_hide_pos, $hide_len),
            $header_version
        );
        
        $request_log = array();
        $request_log['headers'] = $headers_for_log;
        $request_log['curl_request'] = $request_data;
        $request_log['endpoint'] = $url;
        
        if ($this->config->item('loger_v2') == 1) {} else {
            $datalog = array(
                'request' => json_encode($request_log),
                'url' => $url
            );
            $this->db->insert('dc_airbnb_log', $datalog);
            $id = $this->db->insert_id();
        }
        // ----- END LOG -----------
        
        $headers = array(
            'Content-Type:application/json',
            'X-Airbnb-Oauth-Token:' . $auth_data["access_token"], // сюда токен з gettoken()
            'X-Airbnb-API-Key:' . $auth_data["clientid"],
            $header_version
        );
        
        $ch = curl_init();
        curl_setopt_array($ch, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => $method,
            CURLOPT_POSTFIELDS => $request_data,
            CURLOPT_HTTPHEADER => $headers
        ));
        
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        
        $timestart = microtime(true);
        $response = curl_exec($ch);
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                $result = "500, Internal Server Error" . $result;
            }
        }
        
        curl_close($ch);
        
        $data = array(
            'response' => $response,
            'responseint' => $http_code,
            'stime' => (microtime(true) - $timestart)
        );
        
        if ($this->config->item('loger_v2') == 1) {
            $data["request"] = json_encode($request_log);
            $data["url"] = $url;
            $data["dc_id"] = $dc_id;
            $id = $this->loger_dc->SaveLog_v2($data);
        } else {
            $this->db->update('dc_airbnb_log', $data, array(
                'id' => $id
            ));
        }
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $response;
                $data["dc_log_id"] = $id;
                return $data;
            } else {
                return $response;
            }
        } else {
            return $response;
        }
    }
    
    function CurlAppex($get, $fields, $url)
    {
        $datalog = array(
            'request' => json_encode($fields),
            'url' => $url
        );
        $this->db->insert('appex_payments_log', $datalog);
        $id = $this->db->insert_id();
        
        $ch = curl_init();
        
        $postvars = '';
        foreach ($fields as $key => $value) {
            $postvars .= $key . "=" . $value . "&";
        }
        
        // echo "\n\n" . $postvars . "\n\n";
        
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1); // 0 for a get request
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 3);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_TIMEOUT, 20);
        $response = curl_exec($ch);
        curl_close($ch);
        
        $datalog = array(
            'response' => $response
        );
        $this->db->update('appex_payments_log', $datalog, array(
            'id' => $id
        ));
        return $response;
    }
    
    function CurlPlug($data, $url, $dc_id = 0, $special = array())
    {
        $fields_string = "";
        foreach ($data as $key => $value) {
            $fields_string .= $key . '=' . $value . '&';
        }
        $fields_string = rtrim($fields_string, '&');
        
        if ($dc_id == 4) {
            if ($this->config->item('loger_v2') == 1) {} else {
                $datalog = array(
                    'request' => $fields_string,
                    'url' => $url
                );
                
                $this->db->insert('dc_hostelsclub_log', $datalog);
                $id = $this->db->insert_id();
            }
        }
        // echo $fields_string . "+";
        // die();
        // open connection
        $ch = curl_init();
        
        // set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Expect:'
        ));
        
        // curl_setopt ( $ch, CURLOPT_FAILONERROR, 1 );
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        // curl_setopt ( $ch, CURLOPT_TIMEOUT, 3 );
        // curl_setopt ( $ch, CURLOPT_SSL_VERIFYHOST, FALSE );
        // curl_setopt($ch, CURLOPT_COOKIEJAR, "/tmp/cookieFileName");
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, count($data));
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
        
        // execute post
        $timestart = microtime(true);
        $result = curl_exec($ch);
        // save log
        $ci = curl_getinfo($ch);
        //print_r($ci);
        $stime = (microtime(true) - $timestart);
        $data = array(
            'response' => $result,
            'stime' => (microtime(true) - $timestart)
        );
        if ($dc_id == 4) {
            
            if ($this->config->item('loger_v2') == 1) {
                $data["request"] = $fields_string;
                $data["url"] = $url;
                $data["dc_id"] = $dc_id;
                $id = $this->loger_dc->SaveLog_v2($data);
            } else {
                $this->db->update('dc_hostelsclub_log', $data, array(
                    'id' => $id
                ));
            }
            $hotel_id = $this->gethotelid();
            $sql = "INSERT INTO global_hotelix.dc_xml_log (hotel_id, db_name, log_id, dc_id, responsetext, responseint, time, stime)
				VALUES('" . $hotel_id . "', DATABASE(), '" . $id . "','4','" . addslashes($result) . "','',
						'" . date("Y-m-d H:i:s") . "', " . $stime . ")";
            // $sql = "";
            // $query = $this->db->query($sql);
            
            // local_log save
            
            $sql = "INSERT INTO dc_xml_log (log_id, dc_id, responsetext, responseint, time)
				VALUES('" . $id . "','4','" . addslashes($result) . "','',
						'" . date("Y-m-d H:i:s") . "')";
            $query = $this->db->query($sql);
        }
        
        // close connection
        curl_close($ch);
        //echo "++++++++".$result."-------------";
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["dc_log_id"] = $id;
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
        // return $result;
    }
    
    function CurlPlugMass($data, $url)
    {
        $fields_string = "";
        $fields_string .= 'order_data=' . $data . '&';
        rtrim($fields_string, '&');
        // open connection
        $ch = curl_init();
        // set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        // curl_setopt ( $ch, CURLOPT_FAILONERROR, 1 );
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        // curl_setopt ( $ch, CURLOPT_TIMEOUT, 3 );
        // curl_setopt ( $ch, CURLOPT_SSL_VERIFYHOST, FALSE );
        // curl_setopt($ch, CURLOPT_COOKIEJAR, "/tmp/cookieFileName");
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $url);
        // curl_setopt($ch, CURLOPT_POST, count($data));
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
        
        // execute post
        $result = curl_exec($ch);
        // close connection
        curl_close($ch);
        return $result;
    }
    
    function CurlPlugSS($data, $url, $bool = 0)
    {
        // echo $url . "<br>";
        $fields_string = "";
        foreach ($data as $key => $value) {
            $fields_string .= $key . '=' . $value . '&';
        }
        $fields_string = rtrim($fields_string, '&');
        
        // echo $fields_string . "+";
        // die();
        // open connection
        $ch = curl_init();
        
        // set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        // curl_setopt ( $ch, CURLOPT_FAILONERROR, 1 );
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        // curl_setopt ( $ch, CURLOPT_TIMEOUT, 3 );
        // curl_setopt ( $ch, CURLOPT_SSL_VERIFYHOST, FALSE );
        // curl_setopt ( $ch, CURLOPT_SSL_VERIFYPEER, TRUE );
        // curl_setopt($ch, CURLOPT_COOKIEJAR, "/tmp/cookieFileName");
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, count($data));
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
        curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
        
        // execute post
        $result = curl_exec($ch);
        // $ci = curl_getinfo($ch);
        
        // close connection
        curl_close($ch);
        
        return $result;
    }
    
    function CurlPostAgoda($xml, $url, $special = array())
    {
        $data = array(
            'request' => $xml,
            'url' => $url
        );
        if (isset($special['db_local_log'])) {
            $db_local_log = $special['db_local_log'];
        } else {
            $db_local_log = TRUE;
        }
        
        if ($this->config->item('loger_v2') == 0) {
            if ($db_local_log) {
                $this->db->insert('dc_agoda_log', $data);
                $id = $this->db->insert_id();
            } else {
                $id = - 1;
            }
        }
        
        // echo "<br>***<br>";
        $headers = array(
            "Content-type: text/xml",
            "Content-length: " . strlen($xml),
            "Connection: close"
        );
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $xml);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        
        $timestart = microtime(true);
        $result = curl_exec($ch);
        
        // echo $data;
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                $result = "500, Internal Server Error" . $result;
            }
        }
        
        $stime = (microtime(true) - $timestart);
        $data = array(
            'response' => $result,
            'responseint' => $http_code,
            'stime' => (microtime(true) - $timestart)
        );
        
        if ($this->config->item('loger_v2') == 0) {
            if ($db_local_log) {
                $this->db->update('dc_agoda_log', $data, array(
                    'id' => $id
                ));
            }
        } else {
            if ($db_local_log) {
                $dc_id = 5;
                $data["request"] = $xml;
                $data["url"] = $url;
                $data["dc_id"] = $dc_id;
                $id = $this->loger_dc->SaveLog_v2($data);
            } else {
                $id = - 1;
            }
        }
        
        if ($db_local_log) {
            $hotel_id = $this->gethotelid();
            $sql = "INSERT INTO global_hotelix.dc_xml_log (hotel_id, db_name, log_id, dc_id, responsetext, responseint, time, stime)
				VALUES('" . $hotel_id . "', DATABASE(), '" . $id . "','5','" . addslashes($result) . "','',
						'" . date("Y-m-d H:i:s") . "', " . $stime . ")";
            // $sql = "";
            // $query = $this->db->query($sql);
        } else {
            $hotel_id = - 1;
            $sql = "INSERT INTO global_hotelix.dc_xml_log (hotel_id, db_name, log_id, dc_id, responsetext, responseint, time, stime)
				VALUES('" . $hotel_id . "', 'dc_cron', '" . $id . "','5','" . addslashes($result) . "','',
						'" . date("Y-m-d H:i:s") . "', " . $stime . ")";
            // $sql = "";
            // $query = $this->db->query($sql);
        }
        
        // local_log save
        
        $sql = "INSERT INTO dc_xml_log (log_id, dc_id, responsetext, responseint, time)
				VALUES('" . $id . "','5','" . addslashes($result) . "','',
						'" . date("Y-m-d H:i:s") . "')";
        if ($db_local_log)
            $query = $this->db->query($sql);
            // close connection
            curl_close($ch);
            if (isset($special["returntype"])) {
                if ($special["returntype"] == "array") {
                    $data = array();
                    $data["result"] = $result;
                    $data["responseint"] = $http_code;
                    // $data["responseint"] = 500;
                    $data["dc_log_id"] = $id;
                    // print_r($data);
                    return $data;
                } else {
                    return $result;
                }
            } else {
                return $result;
            }
            // return $data;
    }
    
    function CurlPostBronevik($xml, $url, $special = array())
    {
        $post["xml"] = $xml;
        if ($this->config->item('loger_v2') == 0) {
            $data = array(
                'request' => $xml,
                'url' => $url
            );
            
            $this->db->insert('dc_bronevik_log', $data);
            $id = $this->db->insert_id();
        }
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        // curl_setopt ( $ch, CURLOPT_HTTPHEADER, $headers );
        
        $timestart = microtime(true);
        $result = curl_exec($ch);
        
        // echo $data;
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                $result = "500, Internal Server Error" . $result;
            }
        }
        
        $stime = (microtime(true) - $timestart);
        $data = array(
            'response' => $result,
            'responseint' => $http_code,
            'stime' => (microtime(true) - $timestart)
        );
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_bronevik_log', $data, array(
                'id' => $id
            ));
        } else {
            $dc_id = 13;
            $data["request"] = $xml;
            $data["url"] = $url;
            $data["dc_id"] = $dc_id;
            $id = $this->loger_dc->SaveLog_v2($data);
        }
        
        $hotel_id = $this->gethotelid();
        $sql = "INSERT INTO global_hotelix.dc_xml_log (hotel_id, db_name, log_id, dc_id, responsetext, responseint, time, stime)
				VALUES('" . $hotel_id . "', DATABASE(), '" . $id . "','13','" . addslashes($result) . "','',
						'" . date("Y-m-d H:i:s") . "', " . $stime . ")";
        // $sql = "";
        // $query = $this->db->query($sql);
        
        // local_log save
        
        $sql = "INSERT INTO dc_xml_log (log_id, dc_id, responsetext, responseint, time)
				VALUES('" . $id . "','13','" . addslashes($result) . "','',
						'" . date("Y-m-d H:i:s") . "')";
        $query = $this->db->query($sql);
        // close connection
        curl_close($ch);
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                // $data["responseint"] = 500;
                $data["dc_log_id"] = $id;
                // print_r($data);
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
        // return $data;
    }
    
    function CurlPost_custom($data, $url)
    {
        // $post["xml"] = $xml;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        // curl_setopt ( $ch, CURLOPT_HTTPHEADER, $headers );
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($data)
        ));
        $timestart = microtime(true);
        $result = curl_exec($ch);
        
        // echo $data;
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                $result = "500, Internal Server Error" . $result;
            }
        }
        // close connection
        curl_close($ch);
        
        return $result;
    }
    
    // function CurlPostTvil($data, $url)
    // {
    // $ch = curl_init();
    // curl_setopt($ch, CURLOPT_URL, $url);
    // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    // curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    // curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    // curl_setopt($ch, CURLOPT_POST, true);
    // curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    // $result = curl_exec($ch);
    
    // $http_code = - 1;
    
    // if (! curl_errno($ch)) {
    // $info = curl_getinfo($ch);
    // $http_code = $info['http_code'];
    // if ($http_code == 500) {
    // $result = "500, Internal Server Error" . $result;
    // }
    // }
    // // close connection
    // curl_close($ch);
    
    // return $result;
    // }
    function CurlPost_custom_post($data, $url)
    {
        // $post["xml"] = $xml;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        
        $result = curl_exec($ch);
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                $result = "500, Internal Server Error" . $result;
            }
        }
        // close connection
        curl_close($ch);
        
        return $result;
    }
    
    function CurlPostBronevik_2($xml, $url, $special = array())
    {
        $post["xml"] = $xml;
        $sql = "INSERT INTO global_hotelix.dc_bronevik_sync (request, time)
				VALUES('" . $xml . "',  '" . date("Y-m-d H:i:s") . "')";
        $query = $this->db->query($sql);
        $id = $this->db->insert_id();
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 120);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        // curl_setopt ( $ch, CURLOPT_HTTPHEADER, $headers );
        
        $timestart = microtime(true);
        $result = curl_exec($ch);
        $http_code = 0;
        if (curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                $result = "500, Internal Server Error" . $result;
            }
        }
        
        // close connection
        curl_close($ch);
        
        $data = array(
            'response' => $http_code . ":". $result
        );
        
        $this->db->update('global_hotelix.dc_bronevik_sync', $data, array(
            'id' => $id
        ));
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
        // return $data;
    }
    
    function CurlPostBronevik_bookings($data, $url, $hms_id)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($data)
        ));
        
        $timestart = microtime(true);
        $result = curl_exec($ch);
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                $result = "500, Internal Server Error" . $result;
            }
        }
        
        // close connection
        curl_close($ch);
        
        $sql = "INSERT INTO global_hotelix.dc_bronevik_hotels_sync (hms_id, url, response, time)
				VALUES('" . $hms_id . "', '" . $url . "', '" . addslashes($result) . "',  '" . date("Y-m-d H:i:s") . "')";
        $query = $this->db->query($sql);
        
        return $result;
    }
    
    function CurlJson($data_string, $url, $dc_id = 0, $special = array())
    {
        if ($this->config->item('loger_v2') == 0) {
            $data = array(
                'request' => $data_string,
                'url' => $url
            );
            if ($dc_id == 1) {
                $this->db->insert('dc_booking_log', $data);
            }
            if ($dc_id == 3) {
                $this->db->insert('dc_expedia_log', $data);
            }
            if ($dc_id == 5) {
                $this->db->insert('dc_agoda_log', $data);
            }
            if ($dc_id == 6) {
                $this->db->insert('dc_hotel_inn_log', $data);
            }
            if ($dc_id == 7) {
                $this->db->insert('dc_oktogo_log', $data);
            }
            if ($dc_id == 8) {
                $this->db->insert('dc_hostelworld_log', $data);
            }
            
            if ($dc_id == 9) {
                $this->db->insert('dc_101otel_log', $data);
            }
            
            if ($dc_id == 12) {
                $this->db->insert('dc_vashotel_log', $data);
            }
            
            if ($dc_id == 19) {
                $this->db->insert('dc_dobovo_log', $data);
            }
            
            if ($dc_id == 20) {
                $this->db->insert('dc_dorms_log', $data);
            }
            
            // echo "<pre>";
            // echo $txt;
            
            // echo "+++++++" . "<br>";
            
            // die();
            
            $id = $this->db->insert_id();
        }
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_TIMEOUT, 15);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)');
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($data_string)
        ));
        
        $timestart = microtime(true);
        $result = curl_exec($ch);
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                // $result = "500, Internal Server Error" . $result;
            }
        }
        $stime = (microtime(true) - $timestart);
        $data = array(
            'response' => $result,
            'responseint' => $http_code,
            'stime' => (microtime(true) - $timestart)
        );
        if ($this->config->item('loger_v2') == 0) {
            if ($dc_id == 1) {
                $this->db->update('dc_booking_log', $data, array(
                    'id' => $id
                ));
            }
            if ($dc_id == 3) {
                $this->db->update('dc_expedia_log', $data, array(
                    'id' => $id
                ));
            }
            if ($dc_id == 5) {
                $this->db->update('dc_agoda_log', $data, array(
                    'id' => $id
                ));
            }
            if ($dc_id == 6) {
                $this->db->update('dc_hotel_inn_log', $data, array(
                    'id' => $id
                ));
            }
            if ($dc_id == 7) {
                $this->db->update('dc_oktogo_log', $data, array(
                    'id' => $id
                ));
            }
            if ($dc_id == 8) {
                $this->db->update('dc_hostelworld_log', $data, array(
                    'id' => $id
                ));
            }
            if ($dc_id == 9) {
                $this->db->update('dc_101otel_log', $data, array(
                    'id' => $id
                ));
            }
            if ($dc_id == 12) {
                $this->db->update('dc_vashotel_log', $data, array(
                    'id' => $id
                ));
                
                $start = strpos($result, "<?xml");
                if ($start !== false)
                    $result = substr($result, $start);
            }
            
            if ($dc_id == 19) {
                $this->db->update('dc_dobovo_log', $data, array(
                    'id' => $id
                ));
                
                $start = strpos($result, "<?xml");
                if ($start !== false)
                    $result = substr($result, $start);
            }
            if ($dc_id == 20) {
                $this->db->update('dc_dorms_log', $data, array(
                    'id' => $id
                ));
                
                $start = strpos($result, "<?xml");
                if ($start !== false)
                    $result = substr($result, $start);
            }
        } else {
            $data["request"] = $data_string;
            $data["url"] = $url;
            $data["dc_id"] = $dc_id;
            $id = $this->loger_dc->SaveLog_v2($data);
            
            if ($dc_id == 12) {
                $start = strpos($result, "<?xml");
                if ($start !== false)
                    $result = substr($result, $start);
            }
            
            if ($dc_id == 19) {
                $start = strpos($result, "<?xml");
                if ($start !== false)
                    $result = substr($result, $start);
            }
            if ($dc_id == 20) {
                $start = strpos($result, "<?xml");
                if ($start !== false)
                    $result = substr($result, $start);
            }
        }
        
        curl_close($ch);
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                // $data["responseint"] = 500;
                $data["dc_log_id"] = $id;
                // print_r($data);
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
    }
    
    function CurlPlugRAW_test_clean($txt, $url, $special = array())
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $txt);
        curl_setopt($ch, CURLOPT_VERBOSE, true);
        // curl_setopt( $ch, CURLOPT_HTTPHEADER, array('Content-Type: text/xml'));
        
        $result = curl_exec($ch);
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                $result = "500, Internal Server Error" . $result;
            }
        }
        
        curl_close($ch);
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                $data["dc_log_id"] = 0;
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
    }
    
    function CurlPlugRAW_expedia($txt, $url, $special = array())
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $txt);
        curl_setopt($ch, CURLOPT_VERBOSE, true);
        // curl_setopt( $ch, CURLOPT_HTTPHEADER, array('Content-Type: text/xml'));
        
        $result = curl_exec($ch);
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                $result = "500, Internal Server Error" . $result;
            }
        }
        
        curl_close($ch);
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                $data["dc_log_id"] = 0;
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
    }
    
    private function createXmlFromArray( $array, &$xml )
    {
        foreach ($array as $key => $value) {
            if (is_array($value)) {
                if (is_numeric($key)) {
                    $key = 'item' . $key; // Change numeric key to a valid XML element name
                }
    
                if ( isset($value[0]) && is_array($value[0])) {
                    foreach ($value as $item) {
                        $subnode = $xml->addChild($key);
                        $this->createXmlFromArray($item, $subnode);
                    }
                } else {
                    $subnode = $xml->addChild($key);
                    $this->createXmlFromArray($value, $subnode);
                }
            } else {
                if (strpos($key, '@') === 0) {
                    if ($key === "@xmlns:xsi") {
                        $xml->addAttribute("xmlns:xsi", $value);
                    } else {
                        $xml->addAttribute(substr($key, 1), htmlspecialchars($value));
                    }
                } else {
                    if( is_numeric( $key) ){
                        $xml->$key = $value;
                    } else {
                        $xml->addChild($key, htmlspecialchars($value));
                    }
                }
            }
        }
    }
    
    function CurlPlugRAW_booking_obp($request_data, $url){
        $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
        $dc_id = 1;
        $headers = array(
            'Authorization: Basic ' . base64_encode($auth),
            'Accept-Version: 1.1'
        );
        
        // === log ====
        if ($this->config->item('loger_v2') == 1) {
            $request = json_encode($request_data);
        } else {
            
            $data = array(
                'request' => json_encode($request_data),
                'url' => $url
            );
            $this->db->insert('dc_booking_log', $data);
            
            $id = $this->db->insert_id();
        }
        // === END log ====
        
        $xml = new SimpleXMLElement('<request></request>');
        foreach($request_data as $room_data){
            $this->createXmlFromArray($room_data, $xml);
        }
        
        // Output the formatted XML string
        $data = $xml->asXML();
        //echo $data;
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        $timestart = microtime(true);
        $result = curl_exec($ch);
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                $result = "500, Internal Server Error" . $result;
            }
        }
        $stime = (microtime(true) - $timestart);
        
        // === log ====
        $log_data = array(
            'response' => $result,
            'responseint' => $http_code,
            'stime' => (microtime(true) - $timestart)
        );
        
        if ($this->config->item('loger_v2') == 1) {
            $log_data["request"] = $request;
            $log_data["url"] = $url;
            $log_data["dc_id"] = $dc_id;
            $id = $this->loger_dc->SaveLog_v2($log_data);
        } else {
            $this->db->update('dc_booking_log', $log_data, array(
                'id' => $id
            ));
        }
        // === END log ====

        curl_close($ch);

        // global_hotelix save
        $hotel_id = $this->gethotelid();
        
        if ($http_code != 200) {
            $sql = "INSERT INTO global_hotelix.dc_xml_log_errors (hotel_id, db_name, log_id, dc_id, responsetext, responseint, time, stime)
				VALUES('" . $hotel_id . "', DATABASE(), '" . $id . "','" . $dc_id . "','" . addslashes($result) . "',
				    '" . $http_code . "',
						'" . date("Y-m-d H:i:s") . "', " . $stime . ")";
        } else {
            $sql = "INSERT INTO global_hotelix.dc_xml_log_2 (hotel_id, db_name, log_id, dc_id, responsetext, responseint, time, stime)
				VALUES('" . $hotel_id . "', DATABASE(), '" . $id . "','" . $dc_id . "','" . addslashes($result) . "',
				    '" . $http_code . "',
						'" . date("Y-m-d H:i:s") . "', " . $stime . ")";
        }
        
        $return_data = array();
        $return_data["result"] = $result;
        $return_data["responseint"] = $http_code;
        $return_data["dc_log_id"] = $id;
        return $return_data;
    }
    
    function CurlPlugRAW_booking_create_room_rate($request_data, $url){
        $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
        $dc_id = 1;
        $headers = array(
            'Authorization: Basic ' . base64_encode($auth),
        );
        
        // === log ====
        if ($this->config->item('loger_v2') == 1) {
            $request = json_encode($request_data);
        } else {
            
            $data = array(
                'request' => json_encode($request_data),
                'url' => $url
            );
            $this->db->insert('dc_booking_log', $data);
            
            $id = $this->db->insert_id();
        }
        // === END log ====
        
        $xml = new SimpleXMLElement('<OTA_HotelProductNotifRQ></OTA_HotelProductNotifRQ>');
        $this->createXmlFromArray($request_data, $xml);
        $data = $xml->asXML();
        echo htmlentities($data);
        echo "<hr>";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        $timestart = microtime(true);
        $result = curl_exec($ch);
        echo '<pre>';
        echo htmlentities($result);
        echo "<hr>";
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                $result = "500, Internal Server Error" . $result;
            }
        }
        $stime = (microtime(true) - $timestart);
        
        // === log ====
        $log_data = array(
            'response' => $result,
            'responseint' => $http_code,
            'stime' => (microtime(true) - $timestart)
        );
        
        if ($this->config->item('loger_v2') == 1) {
            $log_data["request"] = $request;
            $log_data["url"] = $url;
            $log_data["dc_id"] = $dc_id;
            $id = $this->loger_dc->SaveLog_v2($log_data);
        } else {
            $this->db->update('dc_booking_log', $log_data, array(
                'id' => $id
            ));
        }
        // === END log ====

        curl_close($ch);

        // global_hotelix save
        $hotel_id = $this->gethotelid();
        
        if ($http_code != 200) {
            $sql = "INSERT INTO global_hotelix.dc_xml_log_errors (hotel_id, db_name, log_id, dc_id, responsetext, responseint, time, stime)
				VALUES('" . $hotel_id . "', DATABASE(), '" . $id . "','" . $dc_id . "','" . addslashes($result) . "',
				    '" . $http_code . "',
						'" . date("Y-m-d H:i:s") . "', " . $stime . ")";
        } else {
            $sql = "INSERT INTO global_hotelix.dc_xml_log_2 (hotel_id, db_name, log_id, dc_id, responsetext, responseint, time, stime)
				VALUES('" . $hotel_id . "', DATABASE(), '" . $id . "','" . $dc_id . "','" . addslashes($result) . "',
				    '" . $http_code . "',
						'" . date("Y-m-d H:i:s") . "', " . $stime . ")";
        }
        
        $return_data = array();
        $return_data["result"] = $result;
        $return_data["responseint"] = $http_code;
        $return_data["dc_log_id"] = $id;
        return $return_data;
    }
    
    function CurlPlugRAW($txt, $url, $dc_id = 1, $special = array())
    {
        if ($dc_id == 8) {
            $txt = str_replace(array(
                "\n",
                "\r"
            ), '', $txt);
            $txt = str_replace(array(
                "\t"
            ), ' ', $txt);
            $txt = str_replace(array(
                "  ",
                "   ",
                "    "
            ), ' ', $txt);
            $txt = str_replace(array(
                "  ",
                "   ",
                "    "
            ), ' ', $txt);
            $txt = str_replace(array(
                "  ",
                "   ",
                "    "
            ), ' ', $txt);
            $txt = str_replace(array(
                "  ",
                "   ",
                "    "
            ), ' ', $txt);
        }
        
        if ($dc_id == 1 && $this->config->item('booking_version') == 1) {
            $headers = array(
                'Accept-Version: 1.1',
                'Authorization: Basic THVjLVNhbXVlbMblhWTdlOCghQ29qaU9pNmxlWSpIWXU9OigvS2meQpQ12puj',
                'Content-Type: application/xml'
            );
        }
        
        if ($this->config->item('loger_v2') == 1) {
            $request = $txt;
        } else {
            
            $data = array(
                'request' => $txt,
                'url' => $url
            );
            if ($dc_id == 1) {
                $this->db->insert('dc_booking_log', $data);
            }
            if ($dc_id == 3) {
                $this->db->insert('dc_expedia_log', $data);
            }
            if ($dc_id == 5) {
                $this->db->insert('dc_agoda_log', $data);
            }
            if ($dc_id == 6) {
                $this->db->insert('dc_hotel_inn_log', $data);
            }
            if ($dc_id == 7) {
                $this->db->insert('dc_oktogo_log', $data);
            }
            if ($dc_id == 8) {
                $this->db->insert('dc_hostelworld_log', $data);
            }
            
            if ($dc_id == 9) {
                $this->db->insert('dc_101otel_log', $data);
            }
            
            if ($dc_id == 12) {
                $this->db->insert('dc_vashotel_log', $data);
            }
            
            if ($dc_id == 19) {
                $this->db->insert('dc_dobovo_log', $data);
            }
            
            // echo "<pre>";
            // echo $txt;
            
            // echo "+++++++" . "<br>";
            
            // die();
            
            $id = $this->db->insert_id();
        }
        
        $ch = curl_init();
        
        if (! empty($special) && isset($special['headers'])) {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $special['headers']);
        }
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        
        if (isset($special['auth'])) {
            if ($this->config->item('dc_oktogo_test_mode') == true) {
                $user = "otelms_api";
                $password = "tAnG38tics";
                // $user = "otelms";
                // $password = "otelms2018";
            } else {
                $user = ".hotelms_api";
                $password = "Rx7yK7D=5w";
            }
            
            $user = "otelms";
            $password = "otelms2018";
            
            // echo $user." ".$password;
            curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
            curl_setopt($ch, CURLOPT_USERPWD, $user . ":" . $password);
        }
        // curl_setopt ( $ch, CURLOPT_FAILONERROR, 1 );
        // curl_setopt ( $ch, CURLOPT_FOLLOWLOCATION, 1 );
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        // curl_setopt ( $ch, CURLOPT_TIMEOUT, 3 );
        
        if ($dc_id == 12) {
            $mode = 0;
            $query = $this->db->query("SELECT value FROM hotelix_config WHERE name LIKE 'dc_vashotel_test_mode'");
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $mode = $row->value;
            }
            switch ($mode) {
                case 0:
                    break;
                case 1:
                    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
                    break;
                default:
                    break;
            }
        }
        
        // curl_setopt($ch, CURLOPT_COOKIEJAR, "/tmp/cookieFileName");
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $txt);
        if ($dc_id == 1 && $this->config->item('booking_version') == 1) {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        }
        curl_setopt($ch, CURLOPT_VERBOSE, true);
        
        // $verbose = fopen('/tmp/a1', 'w+');
        // curl_setopt($ch, CURLOPT_STDERR, $verbose);
        
        // execute post
        $timestart = microtime(true);
        $result = "test";
        $result = curl_exec($ch);
        // save log
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
//             print_r($info);
//             die();
            if ($http_code == 500) {
                $result = "500, Internal Server Error" . $result;
            }
        }
        
        $stime = (microtime(true) - $timestart);
        $data = array(
            'response' => $result,
            'responseint' => $http_code,
            'stime' => (microtime(true) - $timestart)
        );
        
        if ($this->config->item('loger_v2') == 1) {
            $data["request"] = $request;
            $data["url"] = $url;
            $data["dc_id"] = $dc_id;
            $id = $this->loger_dc->SaveLog_v2($data);
            
            if ($dc_id == 12) {
                $start = strpos($result, "<?xml");
                if ($start !== false)
                    $result = substr($result, $start);
            }
            
            if ($dc_id == 19) {
                $start = strpos($result, "<?xml");
                if ($start !== false)
                    $result = substr($result, $start);
            }
        } else {
            
            if ($dc_id == 1) {
                $this->db->update('dc_booking_log', $data, array(
                    'id' => $id
                ));
            }
            if ($dc_id == 3) {
                $this->db->update('dc_expedia_log', $data, array(
                    'id' => $id
                ));
            }
            if ($dc_id == 5) {
                $this->db->update('dc_agoda_log', $data, array(
                    'id' => $id
                ));
            }
            if ($dc_id == 6) {
                $this->db->update('dc_hotel_inn_log', $data, array(
                    'id' => $id
                ));
            }
            if ($dc_id == 7) {
                $this->db->update('dc_oktogo_log', $data, array(
                    'id' => $id
                ));
            }
            if ($dc_id == 8) {
                $this->db->update('dc_hostelworld_log', $data, array(
                    'id' => $id
                ));
            }
            if ($dc_id == 9) {
                $this->db->update('dc_101otel_log', $data, array(
                    'id' => $id
                ));
            }
            if ($dc_id == 12) {
                $this->db->update('dc_vashotel_log', $data, array(
                    'id' => $id
                ));
                
                $start = strpos($result, "<?xml");
                if ($start !== false)
                    $result = substr($result, $start);
            }
            
            if ($dc_id == 19) {
                $this->db->update('dc_dobovo_log', $data, array(
                    'id' => $id
                ));
                
                $start = strpos($result, "<?xml");
                if ($start !== false)
                    $result = substr($result, $start);
            }
        }
        
        // global_hotelix save
        $hotel_id = $this->gethotelid();
        
        if ($dc_id == 1 && $http_code != 200) {
            $sql = "INSERT INTO global_hotelix.dc_xml_log_errors (hotel_id, db_name, log_id, dc_id, responsetext, responseint, time, stime)
				VALUES('" . $hotel_id . "', DATABASE(), '" . $id . "','" . $dc_id . "','" . addslashes($result) . "',
				    '" . $http_code . "',
						'" . date("Y-m-d H:i:s") . "', " . $stime . ")";
        } else {
            $sql = "INSERT INTO global_hotelix.dc_xml_log_2 (hotel_id, db_name, log_id, dc_id, responsetext, responseint, time, stime)
				VALUES('" . $hotel_id . "', DATABASE(), '" . $id . "','" . $dc_id . "','" . addslashes($result) . "',
				    '" . $http_code . "',
						'" . date("Y-m-d H:i:s") . "', " . $stime . ")";
            // $sql = "";
        }
        
        // $query = $this->db->query($sql);
        
        // local_log save
        
        $sql = "INSERT INTO dc_xml_log (log_id, dc_id, responsetext, responseint, time)
				VALUES('" . $id . "','" . $dc_id . "','" . addslashes($result) . "','',
						'" . date("Y-m-d H:i:s") . "')";
        $query = $this->db->query($sql);
        // close connection
        curl_close($ch);
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                // $data["responseint"] = 500;
                $data["dc_log_id"] = $id;
                // print_r($data);
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
        // return $result;
    }
    
    function CurlPlugRAW_cron($txt, $url, $dc_id = 0, $dbname = "")
    {
        $data = array(
            'request' => $txt,
            'url' => $url
        );
        
        if ($dc_id == 1) {
            $this->db->insert('dc_booking_log', $data);
        }
        $id = $this->db->insert_id();
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        // curl_setopt ( $ch, CURLOPT_FAILONERROR, 1 );
        // curl_setopt ( $ch, CURLOPT_FOLLOWLOCATION, 1 );
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        // curl_setopt ( $ch, CURLOPT_TIMEOUT, 3 );
        // curl_setopt ( $ch, CURLOPT_SSL_VERIFYHOST, FALSE );
        // curl_setopt($ch, CURLOPT_COOKIEJAR, "/tmp/cookieFileName");
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $txt);
        
        // execute post
        
        $timestart = microtime(true);
        // $result = "test";
        $result = curl_exec($ch);
        
        $stime = (microtime(true) - $timestart);
        
        $http_code = - 1;
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            // print_r($info);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                // $result = "500, Internal Server Error" . $result;
            }
        }
        // echo $result;
        if ($dc_id == 1) {
            $hotel_id = $this->gethotelid();
        } else {
            $hotel_id = - 1;
        }
        if ($dc_id == 1 && $http_code != 200) {
            $sql = "INSERT INTO global_hotelix.dc_xml_log_errors (hotel_id, db_name, log_id, dc_id, responsetext, responseint, time, stime)
				VALUES('" . $hotel_id . "', DATABASE(), '" . $id . "','" . $dc_id . "','" . addslashes($result) . "',
				    '" . $http_code . "',
						'" . date("Y-m-d H:i:s") . "', " . $stime . ")";
        } else {
            $sql = "INSERT INTO global_hotelix.dc_xml_log_diff (hotel_id, db_name, log_id, dc_id, responsetext, responseint, time, stime)
				VALUES('" . $hotel_id . "', DATABASE(), '" . $id . "','" . $dc_id . "','" . addslashes("success") . "',
				    '" . $http_code . "',
						'" . date("Y-m-d H:i:s") . "', " . $stime . ")";
        }
        $query = $this->db->query($sql);
        // save log
        $data = array(
            'response' => 'result_skiped',
            'stime' => (microtime(true) - $timestart)
        );
        if ($dc_id == 1) {
            $this->db->update('dc_booking_log', $data, array(
                'id' => $id
            ));
        }
        
        curl_close($ch);
        return $result;
    }
    
    function gethotelid()
    {
        $query = $this->db->query("SELECT int_value FROM dc_booking_xml_cfg WHERE name LIKE 'hotel_id'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $hotel_id = $row->int_value;
        } else {
            $hotel_id = "none";
        }
        return $hotel_id;
    }
    
    function CurlGET($data, $url, $return_type = "")
    {
        $params = http_build_query($data);
        // echo "URl=".$url.'?'.$params."<br>";
        
        $ch = curl_init();
        
        // set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $url . '?' . $params);
        
        $result = curl_exec($ch);
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                // $result = "500, Internal Server Error" . $result;
            }
            // echo "Post code=" . $http_code . "\n";
        }
        
        curl_close($ch);
        
        if ($return_type == "array") {
            $data = array();
            $data['result'] = $result;
            $data['http_code'] = $http_code;
            $data["responseint"] = $http_code;
            
            return $data;
        } else {
            return $result;
        }
    }
    
    function CurlGET_Roomp($data, $url, $special = array())
    {
        $params = http_build_query($data);
        
        if (isset($data["cm_auth"]["login"])) {
            $data["cm_auth"]["login"] = "***";
        }
        
        if (isset($data["cm_auth"]["password"])) {
            $data["cm_auth"]["password"] = "***";
        }
        
        if (isset($data["hotel_auth"]["email"])) {
            $data["hotel_auth"]["email"] = "***";
        }
        
        if (isset($data["hotel_auth"]["password"])) {
            $data["hotel_auth"]["password"] = "***";
        }
        
        $log_data = array(
            'request' => print_r($data, true),
            'url' => $url
        );
        
        $this->db->insert('dc_roomp_log', $log_data);
        $id = $this->db->insert_id();
        
        $ch = curl_init();
        
        // set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $url . '?' . $params);
        
        $timestart = microtime(true);
        $result = curl_exec($ch);
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                // $result = "500, Internal Server Error" . $result;
            }
            // echo "Post code=" . $http_code . "\n";
        }
        
        curl_close($ch);
        
        $stime = (microtime(true) - $timestart);
        $log_data = array(
            'response' => $result,
            'responseint' => $http_code
        );
        
        $this->db->update('dc_roomp_log', $log_data, array(
            'id' => $id
        ));
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                // $data["responseint"] = 500;
                $data["dc_log_id"] = $id;
                // print_r($data);
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
    }
    
    function CurlPOST_Roomp($data, $url, $special = array())
    {
        $params = http_build_query($data);
        $postdata = $params;
        if (isset($data["cm_auth"]["login"])) {
            $data["cm_auth"]["login"] = "***";
        }
        
        if (isset($data["cm_auth"]["password"])) {
            $data["cm_auth"]["password"] = "***";
        }
        
        if (isset($data["hotel_auth"]["email"])) {
            $data["hotel_auth"]["email"] = "***";
        }
        
        if (isset($data["hotel_auth"]["password"])) {
            $data["hotel_auth"]["password"] = "***";
        }
        
        $log_data = array(
            'request' => print_r($data, true),
            'url' => $url
        );
        
        $this->db->insert('dc_roomp_log', $log_data);
        $id = $this->db->insert_id();
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_setopt($ch, CURLOPT_POST, 1);
        
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        // 'Content-Type: application/json',
        // 'Content-Length: ' . strlen($postdata)
        // ));
        
        $result = curl_exec($ch);
        
        $timestart = microtime(true);
        $result = curl_exec($ch);
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                // $result = "500, Internal Server Error" . $result;
            }
            // echo "Post code=" . $http_code . "\n";
        }
        
        curl_close($ch);
        
        $stime = (microtime(true) - $timestart);
        $log_data = array(
            'response' => $result,
            'responseint' => $http_code
        );
        
        $this->db->update('dc_roomp_log', $log_data, array(
            'id' => $id
        ));
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                // $data["responseint"] = 500;
                $data["dc_log_id"] = $id;
                // print_r($data);
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
    }
    
    function CurlGET_POST($data, $post, $url, $dc_id = 1, $special = array())
    {
        $data_log = array(
            'request' => print_r($post, true),
            'url' => $url
        );
        if ($dc_id == 2) {
            $this->db->insert('dc_ostrovok_log', $data_log);
        }
        // ============================================
        $id = $this->db->insert_id();
        
        $params = http_build_query($data);
        // echo "URl=".$url.'?'.$params."<br>";
        $ch = curl_init();
        
        // set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $url . '?' . $params);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json"
        ));
        
        $timestart = microtime(true);
        $result = curl_exec($ch);
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                // $result = "500, Internal Server Error" . $result;
            }
            // echo "Post code=" . $http_code . "\n";
        }
        
        curl_close($ch);
        
        $stime = (microtime(true) - $timestart);
        
        if ($dc_id == 2) {
            $data = array(
                'param' => $url . '?' . $params,
                'response' => $result,
                'responseint' => $http_code
            );
        } else {
            $data = array(
                'response' => $result,
                'responseint' => $http_code
            );
        }
        
        if ($dc_id == 2) {
            $this->db->update('dc_ostrovok_log', $data, array(
                'id' => $id
            ));
        }
        
        // global_hotelix save
        $hotel_id = $this->gethotelid();
        
        if ($dc_id == 1 && $http_code != 200) {
            $sql = "INSERT INTO global_hotelix.dc_xml_log_errors (hotel_id, db_name, log_id, dc_id, responsetext, responseint, time)
				VALUES('" . $hotel_id . "', DATABASE(), '" . $id . "','" . $dc_id . "','" . addslashes($result) . "',
				    '" . $http_code . "',
						'" . date("Y-m-d H:i:s") . "')";
        } else {
            $sql = "INSERT INTO global_hotelix.dc_xml_log_2 (hotel_id, db_name, log_id, dc_id, responsetext, responseint, time)
				VALUES('" . $hotel_id . "', DATABASE(), '" . $id . "','" . $dc_id . "','" . addslashes($result) . "',
				    '" . $http_code . "',
						'" . date("Y-m-d H:i:s") . "')";
            // $sql = "";
        }
        
        // $query = $this->db->query($sql);
        
        // local_log save
        
        $sql = "INSERT INTO dc_xml_log (log_id, dc_id, responsetext, responseint, time)
				VALUES('" . $id . "','" . $dc_id . "','" . addslashes($result) . "','',
						'" . date("Y-m-d H:i:s") . "')";
        $query = $this->db->query($sql);
        // close connection
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                // $data["responseint"] = 500;
                $data["dc_log_id"] = $id;
                // print_r($data);
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
    }
    
    function CurlPlugPOST_stcrm($get, $post, $url, $method = "POST", $return_type = "")
    {
        $params = http_build_query($get);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        //curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $url . "?" . $params);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json'
        ));

        $result = curl_exec($ch);
       
    
        $http_code = - 1;
    
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                // $result = "500, Internal Server Error" . $result;
            }
            // echo "Post code=" . $http_code . "\n";
        }
//                         echo "<pre>$http_code.$result";
//                         print_r($info);
//                         die();
        curl_close($ch);
        if ($return_type == "array") {
            $data = array();
            $data['result'] = $result;
            $data['http_code'] = $http_code;
            return $data;
        } else {
            return $result;
        }
    }
    
    function CurlPlugPOST($get, $post, $url, $method = "POST", $return_type = "")
    {
        // Ostrovok.ru
        $params = http_build_query($get);
        
        // echo $params;
        // echo "<br>";
        // echo $post;
        // echo "<br>";
        // echo $url;
        // echo "<br>";
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        // curl_setopt ( $ch, CURLOPT_FAILONERROR, 1 );
        // curl_setopt ( $ch, CURLOPT_FOLLOWLOCATION, 1 );
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        // curl_setopt ( $ch, CURLOPT_SSL_VERIFYHOST, FALSE );
        // curl_setopt($ch, CURLOPT_COOKIEJAR, "/tmp/cookieFileName");
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $url . "?" . $params);
        // echo $url."?".$params."<br>";
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json'
        ));
        // var_dump($post);
        // execute post
        $result = curl_exec($ch);
        // close connection
        
        $http_code = - 1;

        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                // $result = "500, Internal Server Error" . $result;
            }
            // echo "Post code=" . $http_code . "\n";
        }
//                 echo "<pre>$http_code $result";
//                 print_r($info);
//                 die();
        curl_close($ch);
        if ($return_type == "array") {
            $data = array();
            $data['result'] = $result;
            $data['http_code'] = $http_code;
            return $data;
        } else {
            return $result;
        }
    }
    
    function CurlPlugPOST2($post, $url, $method = "POST")
    {
        $post = '{"foo-bar": 12345}';
        $headers = array(
            'Content-Type: application/json'
        );
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        
        $result = curl_exec($ch);
        // close connection
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                // $result = "500, Internal Server Error" . $result;
            }
            // echo "Post code=" . $http_code . "\n";
        }
        
        curl_close($ch);
        
        return $result;
    }
    
    function CurlGET_hotels24($data, $url, $debug = false, $special = array())
    {
        $param = $this->dcm_hotels24->getauthparam();
        $nonce = md5(rand(1, time()));
        //$created = date('Y-m-dTH:i:sP');
        $created = date('c');
        $digest = base64_encode(sha1(base64_decode($nonce) . $created . $param['api_key'], true));
        $headerStr = sprintf('serviceProvider Username="otelms", PasswordDigest="%s", Nonce="%s", Created="%s"', $digest, $nonce, $created);
        $headers = array(
            'Authorization: WSSE profile="serviceProvider"',
            'x-wsse: ' . $headerStr
        );
        
        if ($this->config->item('loger_v2') == 0) {
            $data_log = array(
                'request' => print_r($data, true),
                'url' => $url
            );
            
            $this->db->insert('dc_hotels24_log', $data_log);
            $id = $this->db->insert_id();
        }
        if ($debug) {
            echo $url;
            echo "\n";
            echo $headerStr;
        }
        // return;
        
        $params = http_build_query($data);
        // echo "URl=".$url.'?'.$params."<br>";
        $ch = curl_init();
        
        // set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        // curl_setopt($ch, CURLOPT_URL, $url . '?' . $params);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        
        $timestart = microtime(true);
        $result = curl_exec($ch);
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                $result = "500, Internal Server Error" . $result;
            }
        }
        // echo $result;
        curl_close($ch);
        
        $data_log = array(
            'response' => $result,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_hotels24_log', $data_log, array(
                'id' => $id
            ));
        } else {
            $dc_id = 14;
            $data_log["request"] = print_r($data, true);
            $data_log["url"] = $url;
            $data_log["dc_id"] = $dc_id;
            $id = $this->loger_dc->SaveLog_v2($data_log);
        }
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                // $data["responseint"] = 500;
                $data["dc_log_id"] = $id;
                // print_r($data);
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
    }
    
    function CurlPlugRaw_hotels24($post, $url, $method = "POST", $special = array())
    {
        $param = $this->dcm_hotels24->getauthparam();
        $nonce = md5(rand(1, time()));
        //$created = date('Y-m-dTH:i:sP');
        $created = date('c');
        $digest = base64_encode(sha1(base64_decode($nonce) . $created . $param['api_key'], true));
        $headerStr = sprintf('serviceProvider Username="otelms", PasswordDigest="%s", Nonce="%s", Created="%s"', $digest, $nonce, $created);
        $headers = array(
            'Authorization: WSSE profile="serviceProvider"',
            'x-wsse: ' . $headerStr
        );
        
        $data_log = array(
            'request' => print_r($post, true),
            'url' => $url
        );
        
        $this->db->insert('dc_hotels24_log', $data_log);
        $id = $this->db->insert_id();
        
        echo $headerStr;
        echo "<br>" . $post;
        echo "<br>" . $url;
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        
        $timestart = microtime(true);
        $result = curl_exec($ch);
        // close connection
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                // $result = "500, Internal Server Error" . $result;
            }
            // echo "Post code=" . $http_code . "\n";
        }
        
        curl_close($ch);
        
        $data_log = array(
            'response' => $result,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        $this->db->update('dc_hotels24_log', $data_log, array(
            'id' => $id
        ));
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                // $data["responseint"] = 500;
                $data["dc_log_id"] = $id;
                // print_r($data);
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
    }
    
    function CurlPlugRaw_ozon($post, $url, $method = "POST", $special = array(), $token)
    {
        $data_log = array(
            'request' => print_r($post, true),
            'url' => $url
        );
        
        $this->db->insert('dc_ozon_log', $data_log);
        $id = $this->db->insert_id();
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        if (isset($special["method"])) {
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $special["method"]);
        } else {
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        }
        
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "X-Access-Token: " . $token
        ));
        $timestart = microtime(true);
        $result = curl_exec($ch);
        // close connection
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                // $result = "500, Internal Server Error" . $result;
            }
            // echo "Post code=" . $http_code . "\n";
        }
        
        curl_close($ch);
        
        $data_log = array(
            'response' => $result,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        $this->db->update('dc_ozon_log', $data_log, array(
            'id' => $id
        ));
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                // $data["responseint"] = 500;
                $data["dc_log_id"] = $id;
                // print_r($data);
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
    }
    
    function CurlPlugRaw_sutochno($post, $url, $token, $special = array())
    {
        if ($this->config->item('loger_v2') == 0) {
            $data_log = array(
                'request' => $post,
                'url' => $url
            );
            
            $this->db->insert('dc_sutochno_log', $data_log);
            $id = $this->db->insert_id();
        }
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'api-version: 1.5',
            'api-uuid: ' . md5(time()),
            'api-platform: OtelMS',
            'api-token: ' . $token,
            'Content-type: application/json'
        ));
        $timestart = microtime(true);
        $result = curl_exec($ch);
        // close connection
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
        }
        
        curl_close($ch);
        
        $data_log = array(
            'response' => $result,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_sutochno_log', $data_log, array(
                'id' => $id
            ));
        } else {
            
            $dc_id = 30;
            $data_log["request"] = $post;
            $data_log["url"] = $url;
            $data_log["dc_id"] = $dc_id;
            $id = $this->loger_dc->SaveLog_v2($data_log);
        }
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                $data["dc_log_id"] = $id;
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
    }
    
    
    function curl_su($data)
    {
//         echo "<pre>";
//         print_r($data);
//         die();
        $request = json_encode($data['request']);

        if($data['test_mode'] == 1){
            $headers = array(
                'Authorization: Basic ' . $data['auth'],
                'Content-Type: application/json'
            );
        }else{
            $headers = array(
                'Authorization: Basic ' . $data['auth'],
                'app-id: b3RlbG1zLnN1aXNzdS5jb20=',
                'Content-Type: application/json'
            );
        }
        
        echo "REQUEST : <br>".$request."<br>";
        if ($this->config->item('loger_v2') == 0) {
            $data_log = array(
                'request' => "request: ".$request." headers: ".json_encode($headers),
                'url' => $data['url']
            );
        
            $this->db->insert('dc_su_log', $data_log);
            $id = $this->db->insert_id();
        }
    
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $data['url']);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $request );
        curl_setopt($ch, CURLOPT_USERAGENT, 'Otelms');
        $timestart = microtime(true);
        $result = curl_exec($ch);
        echo "RESPONSE : <br>".$result."<br>";
        $http_code = - 1;
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
        }
    
        curl_close($ch);
    
        $data_log = array(
            'response' => $result,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_su_log', $data_log, array(
                'id' => $id
            ));
        } else {
            $data_log["request"] = $request;
            $data_log["url"] = $data['url'];
            $data_log["dc_id"] = $data['dc_id'];
            $id = $this->loger_dc->SaveLog_v2($data_log);
        }
    
        switch($data["returntype"]){
            case "full":
                $return_data = array();
                $return_data["result"] = $result;
                $return_data["responseint"] = $http_code;
                $return_data["dc_log_id"] = $id;
                return $return_data;
                break;
            case "onlyresult":
                return $result;
                break;
            default:
                return $result;
                break;
        }
    }
    
    function CurlPlugRaw_google($xml, $json, $url, $special = array())
    {
        $dc_id = 31;
        if ($this->config->item('loger_v2') == 0) {
            $data_log = array(
                'request' => $json,
                'url' => $url
            );
            
            $this->db->insert('dc_google_log', $data_log);
            $id = $this->db->insert_id();
        }
        
        $headers = array(
            'Content-Type: application/xml'
        );
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $xml);
        $timestart = microtime(true);
        $result = curl_exec($ch);
        // close connection
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
        }
        
        curl_close($ch);
        
        $data_log = array(
            'response' => $result,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_google_log', $data_log, array(
                'id' => $id
            ));
        } else {
            $data_log["request"] = $json;
            $data_log["url"] = $url;
            $data_log["dc_id"] = $dc_id;
            $id = $this->loger_dc->SaveLog_v2($data_log);
        }
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                $data["dc_log_id"] = $id;
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
    }
    
    function CurlPlugRaw_echannel($post, $url)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json"
        ));
        
        $result = curl_exec($ch);
        // close connection
//         echo $result;
//         die();
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {}
        }
        
        curl_close($ch);
        
        return $result;
    }
    
    function CurlPlugRaw_ctrip($request, $url)
    {
        if ($this->config->item('loger_v2') == 0) {
            $data_log = array(
                'request' => $request,
                'url' => $url
            );
            
            $this->db->insert('dc_ctrip_log', $data_log);
            $id = $this->db->insert_id();
        }
        
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $request,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/xml'
            )
        ));
        $timestart = microtime(true);
        $result = curl_exec($curl);
        
        $http_code = - 1;
        
        if (! curl_errno($curl)) {
            $info = curl_getinfo($curl);
            $http_code = $info['http_code'];
            if ($http_code == 500) {}
        }
        
        curl_close($curl);
        
        $data_log = array(
            'response' => $result,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_ctrip_log', $data_log, array(
                'id' => $id
            ));
        } else {
            $dc_id = 34;
            $data_log["request"] = $request;
            $data_log["url"] = $url;
            $data_log["dc_id"] = $dc_id;
            $id = $this->loger_dc->SaveLog_v2($data_log);
        }
        
        $data = array();
        $data["result"] = $result;
        $data["responseint"] = $http_code;
        $data["dc_log_id"] = $id;
        return $data;
    }
    
    function CurlPost_Gomio($xml, $url, $username = "", $password = "", $login = "")
    {
        $headers = array(
            "Content-type: application/soap+xml; charset=utf-8",
            "Content-length: " . strlen($xml),
            "Authorization:Basic $username,$password:$login"
        );
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $xml);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        
        $timestart = microtime(true);
        $result = curl_exec($ch);
        
        // echo $data;
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                $result = "500, Internal Server Error" . $result;
            }
        }
        return $result;
    }
    
    function CurlPlugRaw_clean($post, $url, $method = "POST", $headers = "", $skip_headers = 0)
    {
        if ($headers == "" && $skip_headers == 0) {
            $headers = array(
                'Content-Type: application/json'
            );
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        if ($skip_headers == 0) {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        }
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        
        $result = curl_exec($ch);
        // close connection
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                // $result = "500, Internal Server Error" . $result;
            }
            // echo "Post code=" . $http_code . "\n";
        }
        
        // echo $http_code;
        
        curl_close($ch);
        
        return $result;
    }
    
    function CurlPlugRaw_clean_booking($post, $url, $method = "POST", $headers = "", $skip_headers = 0)
    {
        if ($headers == "" && $skip_headers == 0) {
            $headers = array(
                'Content-Type: application/json'
            );
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        if ($skip_headers == 0) {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        }
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        
        $result = curl_exec($ch);
        // close connection
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                // $result = "500, Internal Server Error" . $result;
            }
            // echo "Post code=" . $http_code . "\n";
        }
        
        if ($http_code != 200) {
            echo "http_code_error:" . $http_code;
        } else {
            echo "http_code:" . $http_code;
        }
        
        curl_close($ch);
        
        return $result;
    }
    
    function CurlPlugRaw_HW($post, $url, $authparam, $special = array())
    {
        $headers = array(
            'Content-Type: application/json',
            'consumer_key: ' . $authparam["consumer_key"],
            'consumer_signature: ' . $authparam["consumer_signature"]
        );
        
        if ($this->config->item('loger_v2') == 0) {
            $data_log = array(
                'request' => $post,
                'url' => $url
            );
            
            $this->db->insert('dc_hostelworld_log', $data_log);
            $id = $this->db->insert_id();
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        // curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
        $timestart = microtime(true);
        $result = curl_exec($ch);
        // close connection
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                // $result = "500, Internal Server Error" . $result;
            }
            // echo "Post code=" . $http_code . "\n";
        }
        
        curl_close($ch);
        $data_log = array(
            'response' => $result,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_hostelworld_log', $data_log, array(
                'id' => $id
            ));
        } else {
            $dc_id = 8;
            $data_log["request"] = $post;
            $data_log["url"] = $url;
            $data_log["dc_id"] = $dc_id;
            $id = $this->loger_dc->SaveLog_v2($data_log);
        }
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                $data["dc_log_id"] = $id;
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
    }
    
    function CurlPlugRaw_nash_travel($post, $url, $token, $special = array(), $skip_post_fields = 0, $curl_custemerrequest = '')
    {
        if ($this->config->item('loger_v2') == 0) {
            $data_log = array(
                'request' => $post,
                'url' => $url
            );
            
            $this->db->insert('dc_nash_travel_log', $data_log);
            $id = $this->db->insert_id();
        }
        
        $headers = array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $token
        );
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        if ($curl_custemerrequest != '') {
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');
        }
        
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        if ($skip_post_fields == 0) {
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        }
        $timestart = microtime(true);
        $result = curl_exec($ch);
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                // $result = "500, Internal Server Error" . $result;
            }
            // echo "Post code=" . $http_code . "\n";
        }
        
        curl_close($ch);
        
        $data_log = array(
            'response' => $result,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_nash_travel_log', $data_log, array(
                'id' => $id
            ));
        } else {
            $dc_id = 29;
            $data_log["request"] = $post;
            $data_log["url"] = $url;
            $data_log["dc_id"] = $dc_id;
            $id = $this->loger_dc->SaveLog_v2($data_log);
        }
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                $data["dc_log_id"] = $id;
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
    }
    
    function CurlPlugRaw_nash_travel_clean($post, $url, $token, $skip_post_fields = 0)
    {
        $headers = array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $token
        );
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        if ($skip_post_fields == 0) {
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        }
        $timestart = microtime(true);
        $result = curl_exec($ch);
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
        }
        curl_close($ch);
        
        return $result;
    }
    
    function CurlPlugRaw_clean_auth($post, $url, $method = "POST")
    {
        $headers = array(
            'Content-Type: application/json'
        );
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($ch, CURLOPT_USERPWD, "otelms_dev:aAS6%$7sa");
        
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        
        $result = curl_exec($ch);
        // close connection
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                // $result = "500, Internal Server Error" . $result;
            }
            echo "Post code=" . $http_code . "\n";
        }
        
        curl_close($ch);
        
        return $result;
    }
    
    function CurlPlugRaw_auth_hotelbook($post = array(), $url, $special = array())
    {
        if ($post == "") {
            $data_log = array(
                'url' => $url,
                'time' => date("Y-m-d H:i:s")
            );
        } else {
            $data_log = array(
                'url' => $url,
                'time' => date("Y-m-d H:i:s"),
                'request' => $post
            );
        }
        
        if (isset($special['login'])) {
            $login = $special['login'];
            $pass = $special['pass'];
        } else {
            $login = "otelms_dev";
            $pass = "aAS6%$7sa";
        }
        
        $hotelbookpro_test_mode = 0;
        
        $hotelbookpro_test_mode = $this->hotelix_config->get_record("hotelbookpro_test_mode", "int");
        
        switch ($hotelbookpro_test_mode) {
            case 0:
                $login = "otelms";
                $pass = "m6rOWI";
                break;
            case 1:
                $login = "otelms_dev";
                $pass = "aAS6%$7sa";
                break;
            default:
                $login = "otelms";
                $pass = "m6rOWI";
                break;
        }
        // $login = "otelms";
        // $pass = "m6rOWI";
        
        // $login = "otelms_dev";
        // $pass = "aAS6%$7sa";
        if ($this->config->item('loger_v2') == 0) {
            $this->db->insert('dc_hotelbook_log', $data_log);
            $dc_log_id = $this->db->insert_id();
        }
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($ch, CURLOPT_USERPWD, $login . ":" . $pass);
        
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json"
        ));
        
        $skip = false;
        if (isset($special["debug_mode"])) {
            if ($special["debug_mode"] == true) {
                $skip = true;
            }
        }
        if ($skip) {
            $result = "DEBUG MODE";
        } else {
            $result = curl_exec($ch);
        }
        
        // close connection
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {}
        }
        
        curl_close($ch);
        
        /*
         * INSERT UPDATE LOG
         */
        $data_log = array(
            'response' => $result,
            'responseint' => $http_code,
            'time' => date("Y-m-d H:i:s")
        );
        
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_hotelbook_log', $data_log, array(
                'id' => $dc_log_id
            ));
        } else {
            $dc_id = 17;
            $data_log["request"] = $post;
            $data_log["url"] = $url;
            $data_log["dc_id"] = $dc_id;
            $dc_log_id = $this->loger_dc->SaveLog_v2($data_log);
        }
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                $data["dc_log_id"] = $dc_log_id;
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
    }
    
    function CurlPlugRaw_axis_travel($post, $url, $special = array())
    {
        $data_log = array(
            'request' => $post,
            'url' => $url
        );
        
        $this->db->insert('dc_axis_travel_log', $data_log);
        $id = $this->db->insert_id();
        
        $headers = array(
            'Content-Type: application/json'
        );
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        
        $timestart = microtime(true);
        $result = curl_exec($ch);
        // close connection
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                // $result = "500, Internal Server Error" . $result;
            }
            // echo "Post code=" . $http_code . "\n";
        }
        
        curl_close($ch);
        
        $data_log = array(
            'response' => $result,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        $this->db->update('dc_axis_travel_log', $data_log, array(
            'id' => $id
        ));
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                $data["dc_log_id"] = $id;
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
    }
    
    function CurlPlugRaw_aanda($post, $url, $special = array())
    {
        if ($this->config->item('loger_v2') == 0) {
            $data_log = array(
                'request' => $post,
                'url' => $url
            );
            
            $this->db->insert('dc_aanda_log', $data_log);
            $id = $this->db->insert_id();
        }
        
        $headers = array(
            'Content-Type: application/json'
        );
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        
        $timestart = microtime(true);
        $result = curl_exec($ch);
        // close connection
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                // $result = "500, Internal Server Error" . $result;
            }
            // echo "Post code=" . $http_code . "\n";
        }
        
        curl_close($ch);
        
        $data_log = array(
            'response' => $result,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        // $this->db->update('dc_aanda_log', $data_log, array(
        // 'id' => $id
        // ));
        
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_aanda_log', $data_log, array(
                'id' => $id
            ));
        } else {
            $dc_id = 28;
            $data_log["request"] = $post;
            $data_log["url"] = $url;
            $data_log["dc_id"] = $dc_id;
            $id = $this->loger_dc->SaveLog_v2($data_log);
        }
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                $data["dc_log_id"] = $id;
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
    }
    
    function CurlPlugRaw_tvil($post, $url, $special = array())
    {
        if ($this->config->item('loger_v2') == 0) {
            $data_log = array(
                'request' => $post,
                'url' => $url
            );
            
            $this->db->insert('dc_tvil_log', $data_log);
            $id = $this->db->insert_id();
        }
        $headers = array(
            'Content-Type: application/json'
        );
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        
        curl_setopt($ch, CURLOPT_URL, $url);
        //curl_setopt($ch, CURLOPT_TIMEOUT, 20);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        
        $timestart = microtime(true);
        $result = curl_exec($ch);
        // close connection
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                // $result = "500, Internal Server Error" . $result;
            }
            // echo "Post code=" . $http_code . "\n";
        }
        
        curl_close($ch);
        
        $data_log = array(
            'response' => $result,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_tvil_log', $data_log, array(
                'id' => $id
            ));
        } else {
            $dc_id = 26;
            $data_log["request"] = $post;
            $data_log["url"] = $url;
            $data_log["dc_id"] = $dc_id;
            $id = $this->loger_dc->SaveLog_v2($data_log);
        }
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                $data["dc_log_id"] = $id;
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
    }
    
    function CurlPlugRaw_academservice($post, $url, $special = array())
    {
        if ($this->config->item('loger_v2') == 0) {
            $data_log = array(
                'request' => $post,
                'url' => $url
            );
            
            $this->db->insert('dc_academ_service_log', $data_log);
            $id = $this->db->insert_id();
        }
        $headers = array(
            'Content-Type: application/json'
        );
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        $timestart = microtime(true);
        $result = curl_exec($ch);
        // close connection
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                // $result = "500, Internal Server Error" . $result;
            }
            // echo "Post code=" . $http_code . "\n";
        }
        
        curl_close($ch);
        
        $data_log = array(
            'response' => $result,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_academ_service_log', $data_log, array(
                'id' => $id
            ));
        } else {
            $dc_id = 27;
            $data_log["request"] = $post;
            $data_log["url"] = $url;
            $data_log["dc_id"] = $dc_id;
            $id = $this->loger_dc->SaveLog_v2($data_log);
        }
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                $data["dc_log_id"] = $id;
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
    }
    
    function CurlPlug_Ozon($token, $url, $special = array())
    {
        $data = array(
            'request' => $token,
            'url' => $url
        );
        
        $this->db->insert('dc_ozon_log', $data);
        $id = $this->db->insert_id();
        
        $ch = curl_init();
        
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "X-Access-Token: " . $token
        ));
        
        $timestart = microtime(true);
        $result = curl_exec($ch);
        // close connection
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                // $result = "500, Internal Server Error" . $result;
            }
            // echo "Post code=" . $http_code . "\n";
        }
        
        curl_close($ch);
        
        $data = array(
            'response' => $result,
            'responseint' => $http_code,
            'stime' => (microtime(true) - $timestart)
        );
        
        $this->db->update('dc_ozon_log', $data, array(
            'id' => $id
        ));
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                // $data["responseint"] = 500;
                $data["dc_log_id"] = $id;
                // print_r($data);
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
    }
    
    function CurlPlug_hotelbook_authtoken($post, $url)
    {
        $data = array(
            'request' => $post,
            'url' => $url
        );
        
        $this->db->insert('dc_ozon_log', $data);
        $id = $this->db->insert_id();
        
        $ch = curl_init();
        
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json"
        ));
        $timestart = microtime(true);
        $result = curl_exec($ch);
        // close connection
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                // $result = "500, Internal Server Error" . $result;
            }
        }
        
        curl_close($ch);
        
        $data = array(
            'response' => $result,
            'responseint' => $http_code,
            'stime' => (microtime(true) - $timestart)
        );
        
        $this->db->update('dc_ozon_log', $data, array(
            'id' => $id
        ));
        
        return $result;
    }
    
    function CurlPlug_Ozon_authtoken($post, $url, $special = array())
    {
        $data = array(
            'request' => $post,
            'url' => $url
        );
        
        $this->db->insert('dc_ozon_log', $data);
        $id = $this->db->insert_id();
        
        $ch = curl_init();
        
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json"
        ));
        $timestart = microtime(true);
        $result = curl_exec($ch);
        // close connection
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                // $result = "500, Internal Server Error" . $result;
            }
            // echo "Post code=" . $http_code . "\n";
        }
        
        curl_close($ch);
        
        $data = array(
            'response' => $result,
            'responseint' => $http_code,
            'stime' => (microtime(true) - $timestart)
        );
        
        $this->db->update('dc_ozon_log', $data, array(
            'id' => $id
        ));
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                // $data["responseint"] = 500;
                $data["dc_log_id"] = $id;
                // print_r($data);
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
    }
    
    function curl_hotelbook($post = array(), $url, $special = array())
    {
        $dc_id = 17;
        if ($post == "") {
            $request = "";
            $data_log = array(
                'url' => $url,
                'time' => date("Y-m-d H:i:s")
            );
        } else {
            $data_log = array(
                'url' => $url,
                'time' => date("Y-m-d H:i:s"),
                'request' => $post
            );
            $request = $post;
        }
        if ($this->config->item('loger_v2') == 0) {
            $this->db->insert('dc_hotelbook_log', $data_log);
            $dc_log_id = $this->db->insert_id();
        }
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($ch, CURLOPT_USERPWD, "otelms:m6rOWI");
        
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json"
        ));
        
        $skip = false;
        if (isset($special["debug_mode"])) {
            if ($special["debug_mode"] == true) {
                $skip = true;
            }
        }
        if ($skip) {
            $result = "DEBUG MODE";
        } else {
            $result = curl_exec($ch);
        }
        
        // close connection
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {}
        }
        
        curl_close($ch);
        
        /*
         * INSERT UPDATE LOG
         */
        $data_log = array(
            'response' => $result,
            'responseint' => $http_code,
            'time' => date("Y-m-d H:i:s")
        );
        
        if ($this->config->item('loger_v2') == 1) {
            $data_log["request"] = $request;
            $data_log["url"] = $url;
            $data_log["dc_id"] = $dc_id;
            $dc_log_id = $this->loger_dc->SaveLog_v2($data_log);
        } else {
            $this->db->update('dc_hotelbook_log', $data_log, array(
                'id' => $dc_log_id
            ));
        }
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                $data["dc_log_id"] = $dc_log_id;
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
    }
    
    function CurlPlugRAW_onetwotrip($xml_post_string, $url, $special = array(), $authparam = array())
    {
        if ($this->config->item('loger_v2') == 0) {
            $data = array(
                'request' => $xml_post_string,
                'url' => $url
            );
            
            $this->db->insert('dc_onetwotrip_log', $data);
            $id = $this->db->insert_id();
        }
        
        // $login = "volodimir@otelms.com";
        // $pass = "000000";
        $login = $authparam["login"];
        $pass = $authparam["pass"];
        
        // PHP cURL for https connection with auth
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($ch, CURLOPT_USERPWD, $login . ":" . $pass);
        
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $xml_post_string); // the SOAP request
        // curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        
        $timestart = microtime(true);
        // converting
        $result = curl_exec($ch);
        
        // close connection
        // echo $result."++++";
        $http_code = - 1;
        $http_error = 0;
        $info = array();
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                $result = "500, Internal Server Error" . $result;
            }
        } else {
            $info = curl_error($ch);
            $http_error = 1;
        }
        
        $stime = (microtime(true) - $timestart);
        $data = array(
            'response' => str_replace('<?xml version="1.0" encoding="UTF-8"?>', '', $result),
            'responseint' => $http_code,
            'stime' => (microtime(true) - $timestart)
        );
        
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_onetwotrip_log', $data, array(
                'id' => $id
            ));
        } else {
            $dc_id = 25;
            $data["request"] = $xml_post_string;
            $data["url"] = $url;
            $data["dc_id"] = $dc_id;
            $id = $this->loger_dc->SaveLog_v2($data);
        }
        
        curl_close($ch);
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                $data["http_error"] = $http_error;
                $data["dc_log_id"] = $id;
                $data["curl_response_info"] = $info;
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
    }
    
    function CurlPlugRAW_cbooking($xml_post_string, $url, $headers, $special = array())
    {
        if ($this->config->item('loger_v2') == 0) {
            $data_log = array(
                'request' => $xml_post_string,
                'url' => $url
            );
            
            $this->db->insert('dc_cbooking_log', $data_log);
            $id = $this->db->insert_id();
        }
        
        // PHP cURL for https connection with auth
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // curl_setopt($ch, CURLOPT_USERPWD, $soapUser.":".$soapPassword); // username and password - declared at the top of the doc
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $xml_post_string); // the SOAP request
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        
        $timestart = microtime(true);
        // converting
        $result = curl_exec($ch);
        
        // close connection
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {}
        }
        
        curl_close($ch);
        
        $data_log = array(
            'response' => $result,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_cbooking_log', $data_log, array(
                'id' => $id
            ));
        } else {
            $dc_id = 21;
            $data_log["request"] = $xml_post_string;
            $data_log["url"] = $url;
            $data_log["dc_id"] = $dc_id;
            $id = $this->loger_dc->SaveLog_v2($data_log);
        }
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                $data["dc_log_id"] = $id;
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
    }
    
    function CurlPlugRAW_hotelbeds($xml_post_string, $url, $headers = array(), $special = array())
    {
        $headers = array(
            "Content-type: text/xml",
            "Content-length: " . strlen($xml_post_string),
            "Connection: keep-alive"
        );
        
        // PHP cURL for https connection with auth
        $ch = curl_init();
        // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // curl_setopt($ch, CURLOPT_USERPWD, $soapUser.":".$soapPassword); // username and password - declared at the top of the doc
        // curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
        // curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $xml_post_string); // the SOAP request
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        
        $result = curl_exec($ch);
        
        curl_close($ch);
        
        return $result;
    }
    
    function CurlPlugRAW_hotelbeds_my($xml_post_string, $url, $headers, $special = array())
    {
        $headers = array(
            "Content-type: text/xml",
            "Content-length: " . strlen($xml_post_string),
            "Connection: keep-alive"
        );
        // PHP cURL for https connection with auth
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $xml_post_string); // the SOAP request
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        
        $timestart = microtime(true);
        // converting
        $result = curl_exec($ch);
        
        // close connection
        
        $http_code = - 1;
        
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {}
        }
        
        curl_close($ch);
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                // $data["dc_log_id"] = $id;
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
    }
    
    function CurlPlug_category_fotos_online_module($url)
    {
        $ch = curl_init();
        $POSTFIELDS = "";
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        // curl_setopt ( $ch, CURLOPT_FAILONERROR, 1 );
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 20);
        // curl_setopt ( $ch, CURLOPT_SSL_VERIFYHOST, FALSE );
        // curl_setopt($ch, CURLOPT_COOKIEJAR, "/tmp/cookieFileName");
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $url);
        // curl_setopt ( $ch, CURLOPT_POST, 1 );
        // curl_setopt ( $ch, CURLOPT_POSTFIELDS, $POSTFIELDS );
        // curl_setopt ($ch, CURLOPT_INTERFACE, "65.61.130.234");
        $result = curl_exec($ch); // execute the curl command
        if (curl_errno($ch)) {
            echo 'Curl error: ' . curl_error($ch);
        }
        curl_close($ch);
        unset($ch);
        return $result;
    }
    
    public function get_expedia_token($user, $pass)
    {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            // CURLOPT_URL => 'https://apis.expediaconnectivity.com/oauth/token',
            CURLOPT_URL => 'https://api.expediagroup.com/identity/oauth2/v3/token',
            
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_POSTFIELDS => 'grant_type=client_credentials',
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/x-www-form-urlencoded',
                'Authorization: Basic ' . base64_encode($user . ":" . $pass)
            )
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $res = json_decode($response, true);
        
        return $res['access_token'];
    }
    
    public function get_yandex_token($data)
    {
        $headers = array(
            'Content-type: application/x-www-form-urlencoded'
        );
        $request = "grant_type=client_credentials";
        
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $data['url'],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            // CURLOPT_SSL_VERIFYPEER => false,
            // CURLOPT_USERPWD => $data['client_id'] . ':' . $data['client_secret'],
            CURLOPT_POSTFIELDS => $request,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/x-www-form-urlencoded',
                'Authorization: Basic ' . base64_encode($data['client_id'] . ":" . $data['client_secret'])
            )
        ));
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        $response = curl_exec($curl);
        // echo $response;
        // die();
        curl_close($curl);
        $res = json_decode($response, true);
        
        return $res['access_token'];
    }
    
    public function expedia_send($token, $query, $url, $special = array())
    {
        if ($this->config->item('loger_v2') == 0) {
            $data = array(
                'request' => "token: $token" . json_encode(array(
                    'query' => $query
                )),
                'url' => $url
            );
            
            $this->db->insert('dc_expedia_log', $data);
            $id = $this->db->insert_id();
        }
        
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            // CURLOPT_URL => 'https://apis.expediaconnectivity.com/graphql',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode(array(
                'query' => $query
            )),
            CURLOPT_HTTPHEADER => array(
                'Authorization: Bearer ' . $token,
                'Content-Type: application/json'
            )
        ));
        
        $timestart = microtime(true);
        $response = curl_exec($curl);
        
        $http_code = - 1;
        if (! curl_errno($curl)) {
            $info = curl_getinfo($curl);
            $http_code = $info['http_code'];
        }
        
        curl_close($curl);
        $data_log = array(
            'response' => $response,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_expedia_log', $data_log, array(
                'id' => $id
            ));
        } else {
            
            $dc_id = 3;
            $data_log["request"] = "token: $token" . json_encode(array(
                'query' => $query
            ));
            $data_log["url"] = $url;
            $data_log["dc_id"] = 3;
            $id = $this->loger_dc->SaveLog_v2($data_log);
        }
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $response;
                $data["responseint"] = $http_code;
                $data["dc_log_id"] = $id;
                return $data;
            } else {
                return $response;
            }
        } else {
            return $response;
        }
        
        return $response;
    }
    
    function curl_airbnb_messages($data, $url, $post_data = array())
    {
        if ($this->config->item('loger_v2') == 0) {
            $data = array(
                'request' => json_encode($data),
                'url' => $url
            );
            
            $this->db->insert('dc_airbnb_log', $data);
            $id = $this->db->insert_id();
        }
        
        $curl = curl_init();
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_HTTPHEADER => array(
                "Content-Type: application/json",
                "Accept: application/json",
                "User-Agent: Test App",
                "X-Airbnb-API-Key: " . $data['client_id'],
                "X-Airbnb-OAuth-Token: " . $data['token'],
                "X-AIRBNB-REQ-API-VERSION: 2022.12.31"
            )
        ));
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        if (count($post_data) > 0) {
            curl_setopt($curl, CURLOPT_POST, true);
            curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($post_data));
        } else {
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "GET");
        }
        $timestart = microtime(true);
        $response = curl_exec($curl);
        $information = curl_getinfo($curl);
        $err = curl_error($curl);
        
        curl_close($curl);
        
        $data_log = array(
            'response' => $response,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_airbnb_log', $data_log, array(
                'id' => $id
            ));
        } else {
            
            $dc_id = 3;
            $data_log["request"] = json_encode($data);
            $data_log["url"] = $url;
            $data_log["dc_id"] = 22;
            $id = $this->loger_dc->SaveLog_v2($data_log);
        }
        
        $data_return = array();
        if ($err) {
            $data_return['response_int'] = 0;
            $data_return['error'] = $err;
        } else {
            $data_return['response_int'] = 1;
            $data_return['response_data'] = json_decode($response, true);
        }
        
        return $data_return;
    }
    
    public function CurlPlugRAW_101v2($url, $hotel_id, $api_key, $query = null, $special = array())
    {
        if ($this->config->item('loger_v2') == 0) {
            $data = array(
                'request' => json_encode($query),
                'url' => $url
            );
            
            $this->db->insert('dc_101otel_log', $data);
            $id = $this->db->insert_id();
        }
        
        $headers = array(
            'Content-Type: application/json'
        );
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_USERPWD, $hotel_id . ":" . $api_key);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($query));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $timestart = microtime(true);
        $response = curl_exec($ch);
        $http_code = - 1;
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
        }
        
        curl_close($ch);
        
        $data_log = array(
            'response' => $response,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_101otel_log', $data_log, array(
                'id' => $id
            ));
        } else {
            
            $dc_id = 9;
            $data_log["request"] = json_encode($query);
            $data_log["url"] = $url;
            $data_log["dc_id"] = 9;
            $id = $this->loger_dc->SaveLog_v2($data_log);
        }
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $response;
                $data["responseint"] = $http_code;
                $data["dc_log_id"] = $id;
                return $data;
            } else {
                return $response;
            }
        } else {
            return $response;
        }
        
        return $response;
    }
    
    public function CurlPlugRAW_101hotels($url, $hotel_id, $api_key, $query = null, $special = array())
    {
        if ($this->config->item('loger_v2') == 0) {
            $data = array(
                'request' => json_encode($query),
                'url' => $url
            );
            
            $this->db->insert('dc_101hotels_log', $data);
            $id = $this->db->insert_id();
        }
        
        $headers = array(
            'Content-Type: application/json'
        );
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_USERPWD, $hotel_id . ":" . $api_key);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($query));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $timestart = microtime(true);
        $response = curl_exec($ch);
        $http_code = - 1;
        $info = curl_getinfo($ch);
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
        }
        //echo "$api_key<pre>+++$url".$response;
        //print_r($info);
        curl_close($ch);
        
        $data_log = array(
            'response' => $response,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_101hotels_log', $data_log, array(
                'id' => $id
            ));
        } else {
            
            $dc_id = 9;
            $data_log["request"] = json_encode($query);
            $data_log["url"] = $url;
            $data_log["dc_id"] = 33;
            $id = $this->loger_dc->SaveLog_v2($data_log);
        }
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $response;
                $data["responseint"] = $http_code;
                $data["dc_log_id"] = $id;
                return $data;
            } else {
                return $response;
            }
        } else {
            return $response;
        }
        
        return $response;
    }
    
    public function CurlPlugRAW_avito($url, $curl_data, $hms_id, $special = array(), $skip_log = 0, $listing = 0)
    {
        $token = $this->dcm_avito->get_token($hms_id);
        
        if ($skip_log == 0) {
            if ($this->config->item('loger_v2') == 0) {
                $data = array(
                    'request' => $listing . " " . json_encode($curl_data),
                    'url' => $url
                );
                
                $this->db->insert('dc_avito_log', $data);
                $id = $this->db->insert_id();
            }
        }
        
        $headers = array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $token
        );
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        if (count($curl_data) > 0) {
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($curl_data));
        }
        $timestart = microtime(true);
        $response = curl_exec($ch);
        $http_code = - 1;
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
        }
        
        curl_close($ch);
        
        if ($skip_log == 0) {
            $data_log = array(
                'response' => $response,
                'responseint' => "",
                'stime' => (microtime(true) - $timestart)
            );
            if ($this->config->item('loger_v2') == 0) {
                $this->db->update('dc_avito_log', $data_log, array(
                    'id' => $id
                ));
            } else {
                $data_log["request"] = $listing . " " . json_encode($curl_data);
                $data_log["url"] = $url;
                $data_log["dc_id"] = 35;
                $id = $this->loger_dc->SaveLog_v2($data_log);
            }
        }
        
        if (isset($special["returntype"])) {
            if ($special["returntype"] == "array") {
                $data = array();
                $data["result"] = $response;
                $data["responseint"] = $http_code;
                if ($skip_log == 0) {
                    $data["dc_log_id"] = $id;
                }
                return $data;
            } else {
                return $response;
            }
        } else {
            return $response;
        }
        
        return $response;
    }
    
    function curl_plug_get_booking_msg($data)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $data['url']);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $data['headers']);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
        $buffer = curl_exec($ch);
        curl_close($ch);
        $result = json_decode($buffer, true);
        
        return $result;
    }
    
    public function get_booking_message_by_conversation($data)
    {
        $property = $data['property'];
        // $res_id = $data ['res_id'];
        $conversation_id = $data['conversation_id'];
        
        $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
        
        $headers = array(
            'Authorization: Basic ' . base64_encode($auth)
        );
        
        // $url = 'https://supply-xml.booking.com/messaging/properties/' . $property . '/conversations/type/reservation?conversation_reference=' . $res_id;
        $url = "https://supply-xml.booking.com/messaging/properties/$property/conversations/$conversation_id";
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
        $buffer = curl_exec($ch);
        curl_close($ch);
        $result = json_decode($buffer, true);
        
        return $result;
    }
    
    function curl_yandex_get($data)
    {
        $headers = array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $data['access_token'],
            'X-Channel-Manager: otelms'
        );
        
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $data['url'],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_SSL_VERIFYPEER => false,
            // CURLOPT_POSTFIELDS => $request,
            CURLOPT_HTTPHEADER => $headers
        ));
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        
        $information = curl_getinfo($curl);
        $timestart = microtime(true);
        $response = curl_exec($curl);
        $http_code = - 1;
        if (! curl_errno($curl)) {
            $info = curl_getinfo($curl);
            $http_code = $info['http_code'];
        }
        curl_close($curl);
        
        return json_decode($response, 1);
    }
    
    function curl_yandex($data)
    {
        if ($this->config->item('loger_v2') == 0) {
            $log_data = array(
                'request' => json_encode($data),
                'url' => $data['url']
            );
            
            $this->db->insert('dc_yandex_log', $log_data);
            $id = $this->db->insert_id();
        }
        
        $headers = array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $data['access_token'],
            'X-Channel-Manager: otelms'
        );
        
        $curl = curl_init();
        // echo $url."<br>";
        curl_setopt_array($curl, array(
            CURLOPT_URL => $data['url'],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_SSL_VERIFYPEER => false,
            // CURLOPT_POSTFIELDS => $request,
            CURLOPT_HTTPHEADER => $headers
        ));
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        
        $information = curl_getinfo($curl);
        $timestart = microtime(true);
        $response = curl_exec($curl);
        $http_code = - 1;
        if (! curl_errno($curl)) {
            $info = curl_getinfo($curl);
            $http_code = $info['http_code'];
        }
        // echo "CURL RESPONSE: ".$response;
        curl_close($curl);
        
        $log_data = array(
            'response' => $response,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_yandex_log', $log_data, array(
                'id' => $id
            ));
        } else {
            $log_data["request"] = json_encode($data);
            $log_data["url"] = $data['url'];
            $log_data["dc_id"] = 36;
            $id = $this->loger_dc->SaveLog_v2($log_data);
        }
        
        if (isset($data["returntype"])) {
            if ($data["returntype"] == "array") {
                $return_data = array();
                $return_data["result"] = json_decode($response, 1);
                $return_data["responseint"] = $http_code;
                $return_data["dc_log_id"] = $id;
                return $return_data;
            } else {
                return json_decode($response, 1);
            }
        } else {
            return json_decode($response, 1);
        }
    }
    
    function curl_yandex_post($data)
    {
        if ($this->config->item('loger_v2') == 0) {
            $log_data = array(
                'request' => json_encode($data),
                'url' => $data['url']
            );
            
            $this->db->insert('dc_yandex_log', $log_data);
            $id = $this->db->insert_id();
        }
        
        $headers = array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $data['access_token'],
            'X-Channel-Manager: otelms'
        );
        
        $curl = curl_init();
        // echo $url."<br>";
        curl_setopt_array($curl, array(
            CURLOPT_URL => $data['url'],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_POSTFIELDS => $data['request'],
            CURLOPT_HTTPHEADER => $headers
        ));
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        
        $timestart = microtime(true);
        $response = curl_exec($curl);
        // echo "++++".$response."----";
        $http_code = - 1;
        if (! curl_errno($curl)) {
            $info = curl_getinfo($curl);
            $http_code = $info['http_code'];
        }
        // echo "CURL RESPONSE: ".$response;
        curl_close($curl);
        
        $log_data = array(
            'response' => $response,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_yandex_log', $log_data, array(
                'id' => $id
            ));
        } else {
            $log_data["request"] = json_encode($data);
            $log_data["url"] = $data['url'];
            $log_data["dc_id"] = 36;
            $id = $this->loger_dc->SaveLog_v2($log_data);
        }
        
        if (isset($data["returntype"])) {
            if ($data["returntype"] == "array") {
                $return_data = array();
                $return_data["result"] = json_decode($response, 1);
                $return_data["responseint"] = $http_code;
                $return_data["dc_log_id"] = $id;
                return $return_data;
            } else {
                return json_decode($response, 1);
            }
        } else {
            return json_decode($response, 1);
        }
    }
    
    function curl_yandex_uploads($curl_data)
    {
        $data = PHP_MAJOR_VERSION < 7 ? openssl_random_pseudo_bytes(16) : random_bytes(16);
        $data[6] = chr(ord($data[6]) & 0x0f | 0x40); // Set version to 0100
        $data[8] = chr(ord($data[8]) & 0x3f | 0x80); // Set bits 6-7 to 10
        $uuid = vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
        
        $headers = array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $curl_data['access_token'],
            'X-Request-ID: ' . $uuid,
            'accept: application/json',
            'X-Channel-Manager: otelms'
        );
        //print_r($headers);
        if ($this->config->item('loger_v2') == 0) {
            $log_data = array(
                'request' => $curl_data['request'],
                'url' => $curl_data['url']
            );
            
            $this->db->insert('dc_yandex_log', $log_data);
            $id = $this->db->insert_id();
        }
        
        $curl = curl_init();
        // echo $url."<br>";
        curl_setopt_array($curl, array(
            CURLOPT_URL => $curl_data['url'],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_CONNECTTIMEOUT => 60,
            CURLOPT_TIMEOUT => 1000,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'PUT',
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_POSTFIELDS => $curl_data['request'],
            CURLOPT_HTTPHEADER => $headers
        ));
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        
        $timestart = microtime(true);
        $response = curl_exec($curl);
        $http_code = - 1;
        $info = curl_getinfo($curl);
        //print_r($info);
        if (! curl_errno($curl)) {
            $info = curl_getinfo($curl);
            $http_code = $info['http_code'];
        }
        //echo $http_code;
        // echo "CURL RESPONSE: ".$response;
        curl_close($curl);
        
        $log_data = array(
            'response' => $response,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_yandex_log', $log_data, array(
                'id' => $id
            ));
        } else {
            $log_data["request"] = $curl_data['request'];
            $log_data["url"] = $curl_data['url'];
            $log_data["dc_id"] = 36;
            $id = $this->loger_dc->SaveLog_v2($log_data);
        }
        
        if (isset($curl_data["returntype"])) {
            if ($curl_data["returntype"] == "array") {
                $return_data = array();
                $return_data["result"] = $response;
                $return_data["responseint"] = $http_code;
                $return_data["dc_log_id"] = $id;
                return $return_data;
            } else {
                return json_decode($response, 1);
            }
        } else {
            return json_decode($response, 1);
        }
    }
    
    function curl_yandex_put($curl_data)
    {
        $headers = array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $curl_data['access_token'],
            'X-Channel-Manager: otelms'
        );
        
        if ($this->config->item('loger_v2') == 0) {
            $log_data = array(
                'request' => $curl_data['request'],
                'url' => $curl_data['url']
            );
            
            $this->db->insert('dc_yandex_log', $log_data);
            $id = $this->db->insert_id();
        }
        
        $curl = curl_init();
        // echo $url."<br>";
        curl_setopt_array($curl, array(
            CURLOPT_URL => $curl_data['url'],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'PUT',
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_POSTFIELDS => $curl_data['request'],
            CURLOPT_HTTPHEADER => $headers
        ));
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        
        $timestart = microtime(true);
        $response = curl_exec($curl);
        $http_code = - 1;
        if (! curl_errno($curl)) {
            $info = curl_getinfo($curl);
            $http_code = $info['http_code'];
        }
        // echo "CURL RESPONSE: ".$response;
        curl_close($curl);
        
        $log_data = array(
            'response' => $response,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_yandex_log', $log_data, array(
                'id' => $id
            ));
        } else {
            $log_data["request"] = $curl_data['request'];
            $log_data["url"] = $curl_data['url'];
            $log_data["dc_id"] = 36;
            $id = $this->loger_dc->SaveLog_v2($log_data);
        }
        
        if (isset($curl_data["returntype"])) {
            if ($curl_data["returntype"] == "array") {
                $return_data = array();
                $return_data["result"] = $response;
                $return_data["responseint"] = $http_code;
                $return_data["dc_log_id"] = $id;
                return $return_data;
            } else {
                return json_decode($response, 1);
            }
        } else {
            return json_decode($response, 1);
        }
    }
    
    function curl_post_booking_fsi($data)
    {
        $user = $this->config->item('dc_booking_xml_user');
        $pwd = $this->config->item('dc_booking_xml_pwd');
        $auth = "$user:$pwd";
        
        if ($this->config->item('loger_v2') == 0) {
            $data_log = array(
                'request' => $data ['post'],
                'url' => $data ['url']
            );
    
            $this->db->insert('dc_booking_log', $data_log);
            $id = $this->db->insert_id();
        }
        
        $headers = array(
            'Authorization: Basic ' . base64_encode($auth),
            'Content-Type: application/json'
        );
       
        $curl = curl_init();
    
        curl_setopt_array($curl, array(
            CURLOPT_URL => $data ['url'],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $data ['post']
        ));
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        $timestart = microtime(true);
        $result = curl_exec($curl);
    
        $http_code = - 1;
    
        if (! curl_errno($curl)) {
            $info = curl_getinfo($curl);
            $http_code = $info['http_code'];
        }
    
        curl_close($curl);
        
        $data_log = array(
            'response' => $result,
            'responseint' => "",
            'stime' => (microtime(true) - $timestart)
        );
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_booking_log', $data_log, array(
                'id' => $id
            ));
        } else {
            $dc_id = 1;
            $data_log["request"] = $data ['post'];
            $data_log["url"] = $data ['url'];
            $data_log["dc_id"] = $dc_id;
            $id = $this->loger_dc->SaveLog_v2($data_log);
        }
    
        if (isset($data["returntype"])) {
            if ($data["returntype"] == "array") {
                $data = array();
                $data["result"] = $result;
                $data["responseint"] = $http_code;
                $data["dc_log_id"] = $id;
                return $data;
            } else {
                return $result;
            }
        } else {
            return $result;
        }
    }
    
    function curl_booking_license($data, $url){
        $user = $this->config->item('dc_booking_xml_user');
        $pwd = $this->config->item('dc_booking_xml_pwd');
        $auth = "$user:$pwd";
        //$auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
        $headers = array(
            'Authorization: Basic ' . base64_encode($auth),
            'Content-type: application/json'
        );
        $tosend = json_encode( $data );
        $log_data = array(
            'request' => $tosend
        );
        
        $this->db->insert('dc_booking_license_log', $log_data);
        $id = $this->db->insert_id();
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $tosend);
        $response = curl_exec($ch);
        curl_close($ch);
        
        $log_data = array(
            'response' => $response
        );
        $this->db->update('dc_booking_license_log', $log_data, array(
            'id' => $id
        ));
        
        return $response;
    }
    
    function CurlMonobank_test_token($data){
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $data['endpoint'] . 'api/merchant/details',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_POSTFIELDS => json_encode($data['body']),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'X-Token: ' . $data['token'],
                'X-Cms: OtelMS'
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
    
        return json_decode($response);
    }
}
?>