<?php 
class cst_model extends CI_Model {
    function __construct() {
        parent::__construct ();

    }
    function get_edit_block($cst_id) {
        $data = array('cst_id' => $cst_id);
        $this->load->library('parser');
        return $this->load->view('/cst_c2/cst_edit_block_view.php', $data, true);
    }
    
    function get_cst_list(){
        return $this->db->select('id as cst_id, name as cst_name')->get('hk_cleaning_schedule')->result_array();
    }
    
    function get_cst_data($cst_id){
        return $this->db->select('*')->get_where('hk_cleaning_schedule', array('id' => $cst_id))->row_array();
    }
    
    function get_cst_tasks(){
        return $this->db->select('*')->get('hk_cleaning_tasks')->result_array();
    }
    
    function get_tasks2cst($cst_id){
        return $this->db->select('ct_id as task_id')->get_where('hk_ct2cs', array('cst_id' => $cst_id))->result_array();
    }
    
//     function get_ct_data(){
//         return $this->db->select('*')->get('hk_cleaning_tasks')->row();
//     }
    
    function get_ct_data($ct_id = 0){
        if($ct_id > 0){
            return $this->db->select('*')->get_where('hk_cleaning_tasks', array('id' => $ct_id))->row();
        }else{
            return $this->db->select('*')->get('hk_cleaning_tasks')->row();
        }
    }
    
    function get_cs_tasks_from_db($intdate){
        $tasks2cs = array();
        $sql = "SELECT cs_id, intdate, room_id
        FROM hk_tasks2cs
        WHERE intdate = $intdate";
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            $tasks2cs[$row->cs_id][$row->room_id][$row->intdate] = 1;
        }
         
        return $tasks2cs;
    }
    
    /*
     * $cs_type = 1 - departure
     * $cs_type = 2 - arrival
     * $cs_type = 3 - living
     */
    function get_cs_id_by_type($cs_type){
        $result = $this->db->select('id')->get_where('hk_cleaning_schedule', array('start_rule' => $cs_type))->row();
        if ($result) {
            return $result->id;
        } else {
            return 0;
        }
        
    }
    
    function get_cs_living_data(){
        $living_type_id = $this->config->item('cs_living_type');
        return $this->db->select('loop_check, loop_type, loop_value')->get_where('hk_cleaning_schedule', array('start_rule' => $living_type_id))->row_array();
    }
     
    function set_cs_tasks($data){
        $date = $data['date'];
        $return_type = 0;
        if(isset($data['return_type'])){
          $return_type = $data['return_type'];  
        }
        
        $select = "";
        if(isset($data['room_id'])){
            $select .= " AND deskofreservation.room_id = ".$data['room_id'];
        }
        
        list($year, $month, $day) = explode("-", $date);
        $intdate = round ( mktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
         
        $tasks2cs = $this->get_cs_tasks_from_db($intdate);

        $cs_living_data = $this->get_cs_living_data();
        
        $return_data = array();
        $sql = "SELECT deskofreservation.id as reservation_id, deskofreservation.datein, deskofreservation.dateout,
        deskofreservation.room_id
        FROM deskofreservation
        WHERE deskofreservation.cancel = 0 AND deskofreservation.deleted = 0 AND
        deskofreservation.datein <= '$date' AND deskofreservation.dateout >= '$date' $select";
        //echo $sql;
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            $cs_array = array();
            list($year, $month, $day) = explode("-", $row->datein);
            $intdatein = round ( mktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
            list($year, $month, $day) = explode("-", $row->dateout);
            $intdateout = round ( mktime ( 0, 0, 0, $month, $day, $year ) / 86400 );;
             
            if($intdate == $intdatein){
                $cs_type = 2; // Уборка на Заезд
                $cs_status_int = $this->get_cs_id_by_type($cs_type);
            if($cs_status_int > 0){
                    array_push($cs_array, $cs_status_int);
                }
            }
            if ($intdate == $intdateout) {
                $cs_type = 1; // Уборка на Выезд
                $cs_status_int = $this->get_cs_id_by_type($cs_type);
                if ($cs_status_int > 0) {
                    array_push($cs_array, $cs_status_int);
                }
            }
            if ($intdate != $intdatein && $intdate != $intdateout) {
                $cs_type = $this->config->item('cs_living_type'); // 3 Уборка на Проживание
                
                if (isset($cs_living_data['loop_check'])) {
                    if ($cs_living_data['loop_value'] > 0) {
                        $loop_mod = ($intdate - $intdatein + 1) % $cs_living_data['loop_value'];
                        if ($loop_mod == 0) {
                            $cs_status_int = $this->get_cs_id_by_type($cs_type);
                            if ($cs_status_int > 0) {
                                array_push($cs_array, $cs_status_int);
                            }
                        }
                    } else {
                        $cs_status_int = $this->get_cs_id_by_type($cs_type);
                        if ($cs_status_int > 0) {
                            array_push($cs_array, $cs_status_int);
                        }
                    }
                } else {
                    $cs_status_int = $this->get_cs_id_by_type($cs_type);
                    if ($cs_status_int > 0) {
                        array_push($cs_array, $cs_status_int);
                    }
                }
            }
            
            foreach ($cs_array as $cs_id) {
                $cs_data = $this->db->select('name, id as cs_id')
                    ->get_where('hk_cleaning_schedule', array(
                    'id' => $cs_id
                ))
                    ->row_array();
                $cs_name = $cs_data['name'];
                //$cs_id = $cs_data['cs_id'];
                
                if (! isset($tasks2cs[$cs_id][$row->room_id][$intdate])) {
                    if ($return_type == 1) {
                        $return_data[$row->room_id][$intdate][$cs_id]['cs_id'] = $cs_id;
                        $return_data[$row->room_id][$intdate][$cs_id]['cs_name'] = $cs_name;
                    } else {
                        array_push($return_data, array(
                            //'reservation_id' => $row->reservation_id,
                            'room_id' => $row->room_id,
                            'date' => $date,
                            'cs_name' => $cs_name,
                            'cs_id' => $cs_id
                        ));
                    }
                }
            }
        }
         
        return $return_data;
    }
    
    function get_cs_rooms_status(){ // cs cleanly, dirty
        $last_tasks_cs = array();
        $sql = "SELECT t1.*, hk_tasks.status FROM (SELECT max(task_id) as last_task_id, room_id FROM `hk_tasks2cs`
        WHERE 1
        GROUP BY `room_id`) as t1
        INNER JOIN hk_tasks ON hk_tasks.id = t1.last_task_id";
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            $last_tasks_cs[$row->room_id] = $row->status;
        }
        
        return $last_tasks_cs;
    }
}
?>