<?php
class Booking_api_mdl extends CI_model{
    public $is_test_env;
    public $hms_id;
    public $debug;
    public function __construct()
    {
        parent::__construct();
        $this->is_test_env = 1;
        $this->hms_id = 92;
        $this->fsi_request_to_session = (bool) $this->session->userdata('fsi_request_to_session');
        $this->debug = (bool) $this->session->userdata('global_debug');
    }
    
    public $contract_set_for_creating = array(
        'legal_contact_email',
        'legal_contact_name',
        'legal_contact_phone_number',
        'legal_name',
        'preferred_language',
        'company_name',
        'website',
        'total_number_of_properties',
        'country',
        'city',
        'zipcode',
        'street',
        'contract_countries',
        'is_test'
    );
    
    public $contract_info_set = array(
        'legal_entity_id',
        'legal_name',
        'legal_contact_email',
        'legal_contact_name',
        'legal_contact_phone_number',
        'company_name',
        'total_number_of_properties',
        'country',
        'city',
        'contract_countries',
    );
            
    public function create_contract($p)
    {
        $contract_data = array(
            'legal_contact_email' 			=> 'vyachmenev@otelms.com',
            'legal_contact_name'			=> 'Oleksandr Slolyarchuk',
            'legal_contact_phone_number'	=> '+380679865740',
            'legal_name'					=> 'Terem Carpathians LLC',
            'preferred_language'			=> 'uk',
            'company_name'					=> 'Hotel Terem',
            'website'						=> 'https://hotelterem.com',
            'total_number_of_properties'	=> '1', // скільки проперті в обліковці
            'country'						=> 'UA',
            'city'							=> 'Slavsk',
            'zipcode'						=> '82660',
            'street'						=> 'Ustiyanovicha, 155a',
            'contract_countries'			=> array('UA'),
            'is_test'                       => $this->is_test_env
        );
        
        $data = array(
            'api_url' => 'https://supply-xml.booking.com/contracts-api/partners/invite',
            'post_data' => $contract_data
        );
        $result = $this->request_api($data);
        return $result;
    }
    
    public function get_contracts_by_email($p)
    {
        $result = array();
        if (isset($p['email'])) {
            $data = array(
                'api_url' => 'https://supply-xml.booking.com/contracts-api/partners/legal-details',
                'post_data' => array(
                    'legal_contact_email' => $p['email'],//'vyachmenev@otelms.com',
                    'is_test' => $this->is_test_env
                )
            );
            
            $result = json_decode($this->request_api($data));
        } elseif (isset($p['legal_entity_id'])) {
            $data = array(
                'api_url' => 'https://supply-xml.booking.com/contracts-api/partners/legal-details',
                'post_data' => array(
                    'legal_entity_id' => $p['legal_entity_id'],
                    'is_test' => 0
                )
            );
            
            $result = json_decode($this->request_api($data));
        }
        return $result;
        //print_r(array($data, json_decode($result, 1)));
    }
    
//     public function resend_email( $env = 'test' )
//     {
//         $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
//         $url = 'https://supply-xml.booking.com/contracts-api/partners/resend-invite';
        
//         $headers = [
//             'Authorization: Basic ' . base64_encode($auth),
//             'Content-Type: application/json'
//         ];
        
//         $contract_data = [
//             'legal_contact_email' => 'vyachmenev@otelms.com'
//         ];
        
//         $contract_data['is_test'] = $env == 'test' ? 1 : 0;
        
//         $data = json_encode( $contract_data );
        
//         $ch = curl_init();
//         curl_setopt($ch, CURLOPT_URL, $url);
//         curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
//         curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
//         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//         curl_setopt($ch, CURLOPT_POST, true);
//         curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
//         curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
//         $buffer = curl_exec($ch);
//         curl_close($ch);
//         echo '<pre>';
//         print_r([$data, json_decode($buffer, 1)]);
//     }
    
//     public function add_country( $env = 'test' )
//     {
//         $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
//         $url = 'https://supply-xml.booking.com/contracts-api/partners/addendum';
        
//         $headers = [
//             'Authorization: Basic ' . base64_encode($auth),
//             'Content-Type: application/json'
//         ];
        
//         $contract_data = [
//             'legal_contact_email' 	=> 'vyachmenev@otelms.com',
//             'additional_countries'	=> ['XC']
//         ];
        
//         $contract_data['is_test'] = $env == 'test' ? 1 : 0;
        
//         $data = json_encode( $contract_data );
        
//         $ch = curl_init();
//         curl_setopt($ch, CURLOPT_URL, $url);
//         curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
//         curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
//         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//         curl_setopt($ch, CURLOPT_POST, true);
//         curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
//         curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
//         $buffer = curl_exec($ch);
//         curl_close($ch);
//         echo '<pre>';
//         print_r([$data, json_decode($buffer, 1)]);
//     }
    
//         $this->createXmlFromArray($property, $xml);
        
//         // Output the formatted XML string
//         $data = $xml->asXML();
//         echo htmlentities($data);
//         echo "<hr>";
        
//         $ch = curl_init();
//         curl_setopt($ch, CURLOPT_URL, $url);
//         curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
//         curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
//         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//         curl_setopt($ch, CURLOPT_POST, true);
//         curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
//         curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
//         $buffer = curl_exec($ch);
//         curl_close($ch);
//         echo '<pre>';
//         echo htmlentities($buffer);
        
//     }
    
//     public function property_status( $hotel = 4386613, $status = 'Check' )
//     {
//         $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
//         $url = 'https://supply-xml.booking.com/hotels/ota/OTA_HotelSummaryNotif';
        
//         $headers = [
//             'Authorization: Basic ' . base64_encode($auth),
//         ];
        
//         $property = [
//             "@HotelCode" => $hotel,
//             "HotelSummaryMessages" => [
//                 "HotelSummaryMessage" => [
//                     "@StatusType" => $status
//                 ]
//             ]
//         ];
        
//         $xml = new SimpleXMLElement('<OTA_HotelSummaryNotifRQ></OTA_HotelSummaryNotifRQ>');
//         $this->createXmlFromArray($property, $xml);
        
//         // Output the formatted XML string
//         $data = $xml->asXML();
//         echo htmlentities($data);
//         echo "<hr>";
        
//         $ch = curl_init();
//         curl_setopt($ch, CURLOPT_URL, $url);
//         curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
//         curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
//         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//         curl_setopt($ch, CURLOPT_POST, true);
//         curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
//         curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
//         $buffer = curl_exec($ch);
//         curl_close($ch);
//         echo '<pre>';
//         echo htmlentities($buffer);
//     }
    
//     public function get_license_requirements( $property_id = 4386613 )
//     {
//         $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
//         $url = "https://supply-xml.booking.com/licenses/rules/properties/$property_id";
        
//         $headers = [
//             'Authorization: Basic ' . base64_encode($auth),
//         ];
        
//         $ch = curl_init();
//         curl_setopt($ch, CURLOPT_URL, $url);
//         curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
//         curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
//         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//         curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
//         $buffer = curl_exec($ch);
//         curl_close($ch);
        
//         echo '<pre>';
//         print_r(json_decode($buffer, 1));
//     }
    
//     public function get_host_profile( $property_id = 4386613 )
//     {
//         $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
//         $url = "https://supply-xml.booking.com/property-profile/properties/$property_id";
        
//         $headers = [
//             'Authorization: Basic ' . base64_encode($auth),
//         ];
        
//         $ch = curl_init();
//         curl_setopt($ch, CURLOPT_URL, $url);
//         curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
//         curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
//         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//         curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
//         $buffer = curl_exec($ch);
//         curl_close($ch);
        
//         echo '<pre>';
//         print_r(json_decode($buffer, 1));
//     }
    
//     public function update_profile_photo( $property_id = 4386613 )
//     {
//         $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
//         $url = "https://supply-xml.booking.com/property-profile/properties/$property_id/photo";
        
//         $headers = [
//             'Authorization: Basic ' . base64_encode($auth),
//             'Content-Type: multipart/form-data'
//         ];
        
//         $file = 'https://booking-hms-media.otelms.com/himages/109_1_5prop_500.jpg';
//         $url = "https://studyserver.otelms.com/index.php/test";
        
//         $data = [
//             'host_photo' => file_get_contents($file)
//         ];
        
//         $curl = curl_init();
        
//         curl_setopt_array($curl, array(
//             CURLOPT_URL => $url,
//             CURLOPT_RETURNTRANSFER => true,
//             CURLOPT_ENCODING => '',
//             CURLOPT_MAXREDIRS => 10,
//             CURLOPT_TIMEOUT => 0,
//             CURLOPT_FOLLOWLOCATION => true,
//             CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
//             CURLOPT_CUSTOMREQUEST => 'PUT',
//             CURLOPT_POSTFIELDS => $data,
//             CURLOPT_HTTPHEADER => $headers
//         ));
//         curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        
//         $response = curl_exec($curl);
//         $information = curl_getinfo($curl);
//         curl_close($curl);
        
//         echo '<pre>';
//         print_r([$information, json_decode($response, 1) ]);
//     }
    
//     public function set_property_profile( $property_id = 4386613 )
//     {
//         $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
//         $url = "https://supply-xml.booking.com/property-profile/properties/$property_id";
        
//         $headers = [
//             'Authorization: Basic ' . base64_encode($auth),
//             'Content-Type: application/json'
//         ];
        
//         $profile = [
//             'host_location' 		=> 'onsite', // onsite, offsite
//             'name_or_company' 		=> 'ТОВ "Карпати Резорт"',
//             'renting_date' 			=> '2008-01-01',
//             'renovating_date' 		=> '2019-12-01',
//             'built_date'			=> '1976-11-25',
//             'is_company_profile'	=> 1,
//             'photo_uri'				=> 'https://booking-hms-media.otelms.com/himages/109_1_logo_original.jpg'
//         ];
//         $request = json_encode( $profile );
        
//         $curl = curl_init();
        
//         curl_setopt_array($curl, array(
//             CURLOPT_URL => $url,
//             CURLOPT_RETURNTRANSFER => true,
//             CURLOPT_ENCODING => '',
//             CURLOPT_MAXREDIRS => 10,
//             CURLOPT_TIMEOUT => 0,
//             CURLOPT_FOLLOWLOCATION => true,
//             CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
//             CURLOPT_CUSTOMREQUEST => 'POST',
//             CURLOPT_POSTFIELDS => $request,
//             CURLOPT_HTTPHEADER => $headers
//         ));
//         curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        
//         $response = curl_exec($curl);
//         curl_close($curl);
        
//         echo '<pre>';
//         print_r( json_decode($response, 1) );
//     }
    
//     public function delete_profile_photo( $property_id = 4386613 )
//     {
//         $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
//         $url = "https://supply-xml.booking.com/property-profile/properties/$property_id/photo";
        
//         $headers = [
//             'Authorization: Basic ' . base64_encode($auth),
//         ];
        
//         $curl = curl_init();
        
//         curl_setopt_array($curl, array(
//             CURLOPT_URL => $url,
//             CURLOPT_RETURNTRANSFER => true,
//             CURLOPT_ENCODING => '',
//             CURLOPT_MAXREDIRS => 10,
//             CURLOPT_TIMEOUT => 0,
//             CURLOPT_FOLLOWLOCATION => true,
//             CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
//             CURLOPT_CUSTOMREQUEST => 'DELETE',
//             CURLOPT_HTTPHEADER => $headers
//         ));
//         curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        
//         $response = curl_exec($curl);
//         curl_close($curl);
        
//         echo '<pre>';
//         print_r( json_decode($response, 1) );
//     }
    
//     public function get_hotelier_messages( $property_id = 4386613 )
//     {
//         $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
//         $url = "https://supply-xml.booking.com/property-profile/properties/$property_id/hotelier_messages";
        
//         $headers = [
//             'Authorization: Basic ' . base64_encode($auth),
//         ];
        
//         $ch = curl_init();
//         curl_setopt($ch, CURLOPT_URL, $url);
//         curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
//         curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
//         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//         curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
//         $buffer = curl_exec($ch);
//         curl_close($ch);
        
//         echo '<pre>';
//         print_r(json_decode($buffer, 1));
//     }
    
//     public function set_hotelier_message( $property_id = 4386613 )
//     {
//         $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
//         $url = "https://supply-xml.booking.com/property-profile/properties/$property_id/hotelier_messages";
        
//         $headers = [
//             'Authorization: Basic ' . base64_encode($auth),
//             'Content-Type: application/json'
//         ];
        
//         $profile = [
//             'language_code' 		=> 'uk', // onsite, offsite
//             'message_type' 			=> 'welcome_message', //welcome_message, neighborhood_info, owner_info, family_tips
//             'message' 				=> 'Путін хуйло',
//         ];
        
//         $request = json_encode( $profile );
        
//         $curl = curl_init();
        
//         curl_setopt_array($curl, array(
//             CURLOPT_URL => $url,
//             CURLOPT_RETURNTRANSFER => true,
//             CURLOPT_ENCODING => '',
//             CURLOPT_MAXREDIRS => 10,
//             CURLOPT_TIMEOUT => 0,
//             CURLOPT_FOLLOWLOCATION => true,
//             CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
//             CURLOPT_CUSTOMREQUEST => 'POST',
//             CURLOPT_POSTFIELDS => $request,
//             CURLOPT_HTTPHEADER => $headers
//         ));
//         curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        
//         $response = curl_exec($curl);
//         curl_close($curl);
        
//         echo '<pre>';
//         print_r( json_decode($response, 1) );
//     }
    
//     public function delete_hotelier_message( $property_id = 4386613, $message_id = 9641812 )
//     {
//         $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
//         $url = "https://supply-xml.booking.com/property-profile/properties/$property_id/hotelier_messages/$message_id";
        
//         $headers = [
//             'Authorization: Basic ' . base64_encode($auth),
//         ];
        
//         $curl = curl_init();
        
//         curl_setopt_array($curl, array(
//             CURLOPT_URL => $url,
//             CURLOPT_RETURNTRANSFER => true,
//             CURLOPT_ENCODING => '',
//             CURLOPT_MAXREDIRS => 10,
//             CURLOPT_TIMEOUT => 0,
//             CURLOPT_FOLLOWLOCATION => true,
//             CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
//             CURLOPT_CUSTOMREQUEST => 'DELETE',
//             CURLOPT_HTTPHEADER => $headers
//         ));
//         curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        
//         $response = curl_exec($curl);
//         curl_close($curl);
        
//         echo '<pre>';
//         print_r( json_decode($response, 1) );
//     }
    
//     public function get_checkin_methods_dictionary( $type = 'primary' )
//     {
//         $variation = $type == 'primary' ? 'primary_checkin_method' : 'alternative_checkin_method';
        
//         $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
//         $url = "https://supply-xml.booking.com/checkin-methods-api/checkin-methods?stream_variation_name=$variation";
        
//         $headers = [
//             'Authorization: Basic ' . base64_encode($auth),
//         ];
        
        
        
//         $ch = curl_init();
//         curl_setopt($ch, CURLOPT_URL, $url);
//         curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
//         curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
//         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//         curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
//         $buffer = curl_exec($ch);
//         curl_close($ch);
        
//         echo '<pre>';
//         print_r(json_decode($buffer, 1));
//     }
    
//     public function get_checkin_variations_dictionary()
//     {
//         $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
//         $url = "https://supply-xml.booking.com/checkin-methods-api/stream-variations";
        
//         $headers = [
//             'Authorization: Basic ' . base64_encode($auth),
//         ];
        
//         $ch = curl_init();
//         curl_setopt($ch, CURLOPT_URL, $url);
//         curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
//         curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
//         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//         curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
//         $buffer = curl_exec($ch);
//         curl_close($ch);
        
//         echo '<pre>';
//         print_r(json_decode($buffer, 1));
//     }
    
//     public function get_checkin_methods( $property_id = 4386613 )
//     {
//         $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
//         $url = "https://supply-xml.booking.com/checkin-methods-api/properties/$property_id";
        
//         $headers = [
//             'Authorization: Basic ' . base64_encode($auth),
//             'Accept: application/json'
//         ];
        
//         $ch = curl_init();
//         curl_setopt($ch, CURLOPT_URL, $url);
//         curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
//         curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
//         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//         curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
//         curl_setopt($ch, CURLINFO_HEADER_OUT, true);
//         curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
//         $buffer = curl_exec($ch);
//         $information = curl_getinfo($ch);
//         curl_close($ch);
        
//         echo '<pre>';
//         print_r(json_decode($buffer,1));
//     }
    
//     public function set_checkin_methods( $property_id = 4386613 )
//     {
//         $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
//         $url = "https://supply-xml.booking.com/checkin-methods-api/properties/$property_id";
        
//         $headers = [
//             'Authorization: Basic ' . base64_encode($auth),
//             'Content-Type: application/json'
//         ];
        
//         $methods = [
//             'checkin_methods'	=> [
//                 [
//                     'stream_variation_name'	=> 'primary_checkin_method', // alternative_checkin_method
//                     'checkin_method'		=> 'reception'
//                 ],
//                 [
//                     'stream_variation_name'	=> 'alternative_checkin_method', // primary_checkin_method
//                     'checkin_method'		=> 'lock_box',
//                     'additional_info'		=> [
//                         'brand_name'			=> 'Deposit safebox',
//                         'location'				=> [
//                             'off_location'			=> 1,
//                             'address' 				=> 'Khreshchatyk, 1',
//                             'city'					=> 'Kyiv'
//                         ],
//                         'other_text'			=> [
//                             'lang'					=> 'uk',
//                             'text'					=> 'Забрати у алкаша на Майдані'
//                         ]
//                     ]
//                 ],
//                 /*[
//                  'stream_variation_name'	=> 'alternative_checkin_method', // primary_checkin_method
//                  'checkin_method'		=> 'instruction_contact_us',
//                  'additional_info'		=> [
//                  'instruction'			=> [
//                  'how'					=> 'other',
//                  'identifier' 			=> '+12345678987',
//                  'other'					=> 'Telegram',
//                  'when'					=> 'week_before'// day_of_arrival, immediate, month_before, week_before
//                  ],
//                  'other_text'			=> [
//                  'lang'					=> 'uk',
//                  'text'					=> 'Забрати у алкаша на Майдані'
//                  ]
//                  ]
//                  ]*/
//             ]
//         ];
        
//         $request = json_encode( $methods );
        
//         $curl = curl_init();
        
//         curl_setopt_array($curl, array(
//             CURLOPT_URL => $url,
//             CURLOPT_RETURNTRANSFER => true,
//             CURLOPT_ENCODING => '',
//             CURLOPT_MAXREDIRS => 10,
//             CURLOPT_TIMEOUT => 0,
//             CURLOPT_FOLLOWLOCATION => true,
//             CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
//             CURLOPT_CUSTOMREQUEST => 'POST',
//             CURLOPT_POSTFIELDS => $request,
//             CURLOPT_HTTPHEADER => $headers
//         ));
//         curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        
//         $response = curl_exec($curl);
//         $information = curl_getinfo($curl);
//         curl_close($curl);
        
//         echo '<pre>';
//         print_r( [$information, $request, json_decode($response, 1) ] );
//     }
    
//     public function set_checkin_photo( $property_id = 4386613 )
//     {
//         $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
//         $url = "https://supply-xml.booking.com/checkin-methods-api/properties/$property_id/photos";
//         //$url = "https://studyserver.otelms.com/index.php/test";
//         //$url = 'https://xml.otelms.com/migration/push';
        
//         $headers = [
//             'Authorization: Basic ' . base64_encode($auth),
//             'Content-Type: multipart/form-data'
//         ];
        
//         $file = 'https://booking-hms-media.otelms.com/himages/109_1_5prop_500.jpg';
        
//         $extension = pathinfo(parse_url($file, PHP_URL_PATH), PATHINFO_EXTENSION);
        
//         $local = "image.$extension";
        
//         file_put_contents($local, fopen($file, 'r'));
        
//         $curl = curl_init();
        
//         curl_setopt_array($curl, array(
//             CURLOPT_URL => $url,
//             CURLOPT_RETURNTRANSFER => true,
//             CURLOPT_MAXREDIRS => 10,
//             CURLOPT_FOLLOWLOCATION => true,
//             CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
//             CURLOPT_HTTPHEADER => $headers,
//             CURLOPT_CUSTOMREQUEST => 'POST',
//             CURLOPT_POSTFIELDS => array('photo'=> new CURLFILE($local)),
//         ));
//         curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        
//         $response = curl_exec($curl);
        
//         $err = curl_error($curl);
//         $information = curl_getinfo($curl);
//         curl_close($curl);
        
//         unlink($local);
        
//         echo '<pre>';
//         print_r( [$err, $information, http_response_code(), $response]);
//     }
    
//     public function get_checkin_photos( $property_id = 4386613 )
//     {
//         $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
//         $url = "https://supply-xml.booking.com/checkin-methods-api/properties/$property_id/photos";
        
//         $headers = [
//             'Authorization: Basic ' . base64_encode($auth)
//         ];
        
//         $ch = curl_init();
//         curl_setopt($ch, CURLOPT_URL, $url);
//         curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
//         curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
//         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//         curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
//         curl_setopt($ch, CURLINFO_HEADER_OUT, true);
//         $buffer = curl_exec($ch);
//         $information = curl_getinfo($ch);
//         curl_close($ch);
        
//         echo '<pre>';
//         print_r([$information, json_decode($buffer, 1)]);
//     }
    
//     public function delete_checkin_photo( $property_id = 4386613, $photo_id = null )
//     {
//         $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
//         $url = "https://supply-xml.booking.com/checkin-methods-api/properties/$property_id/photos/$photo_id";
        
//         $headers = [
//             'Authorization: Basic ' . base64_encode($auth),
//         ];
        
//         $curl = curl_init();
        
//         curl_setopt_array($curl, array(
//             CURLOPT_URL => $url,
//             CURLOPT_RETURNTRANSFER => true,
//             CURLOPT_ENCODING => '',
//             CURLOPT_MAXREDIRS => 10,
//             CURLOPT_TIMEOUT => 0,
//             CURLOPT_FOLLOWLOCATION => true,
//             CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
//             CURLOPT_CUSTOMREQUEST => 'DELETE',
//             CURLOPT_HTTPHEADER => $headers
//         ));
//         curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        
//         $response = curl_exec($curl);
//         $information = curl_getinfo($curl);
//         curl_close($curl);
        
//         echo '<pre>';
//         print_r( [$information, json_decode($response, 1) ] );
//     }
    
//     // тільки для Booking Home property types https://connect.booking.com/user_guide/site/en-US/codes-pct/
//     public function get_house_rules ( $property_id = 4386613 )
//     {
//         $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
//         $url = "https://supply-xml.booking.com/house-rules/properties/$property_id";
        
//         $headers = [
//             'Authorization: Basic ' . base64_encode($auth)
//         ];
        
//         $ch = curl_init();
//         curl_setopt($ch, CURLOPT_URL, $url);
//         curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
//         curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
//         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//         curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
//         curl_setopt($ch, CURLINFO_HEADER_OUT, true);
//         $buffer = curl_exec($ch);
//         $information = curl_getinfo($ch);
//         curl_close($ch);
        
//         echo '<pre>';
//         print_r([$information, json_decode($buffer, 1)]);
//     }
    
//     public function set_house_rules ( $property_id = 4386613 )
//     {
//         $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
//         $url = "https://supply-xml.booking.com/house-rules/properties/$property_id";
        
//         $headers = [
//             'Authorization: Basic ' . base64_encode($auth),
//             'Content-Type: application/json'
//         ];
        
//         $rules = [
//             'smoking_allowed'			=> 0,
//             'parties_allowed'			=> 0,
//             'pets_allowed'				=> 'on_request', // Accepts: yes, no, on_request
//             'pets_price_type'			=> 'free',// Accepts: free, charges_may_apply
//             'quiet_hours_set'			=> 1,
//             'quiet_hours_start_time'	=> '22:00', // крок година
//             'quiet_hours_end_time'		=> '09:00' // крок година
            
//         ];
        
//         $data = json_encode( $rules );
        
//         $ch = curl_init();
//         curl_setopt($ch, CURLOPT_URL, $url);
//         curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
//         curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
//         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//         curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
//         curl_setopt($ch, CURLINFO_HEADER_OUT, true);
//         curl_setopt($ch, CURLOPT_POST, true);
//         curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
//         $buffer = curl_exec($ch);
//         $information = curl_getinfo($ch);
//         curl_close($ch);
        
//         echo '<pre>';
//         print_r([$information, $data, json_decode($buffer, 1)]);
//     }
    
    private function request_api($p) {
        $method = isset($p['method']) ? $p['method'] : 'POST';
        $content_type = isset($p['content_type']) ? $p['content_type'] : false;
        $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
        
        $headers = array(
            'Authorization: Basic ' . base64_encode($auth),
        );
        if ($content_type) {
            array_push($headers, "Content-Type: $content_type");
        }
        $url = $p['api_url'];
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        switch (strtoupper($method)) {
            case 'POST':
                $post_data = $content_type == 'application/json' ? json_encode($p['post_data']) : $p['post_data'];
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
                break;
        }
        $curl_response = curl_exec($ch);
        //         $curl_info = curl_getinfo($ch);
        curl_close($ch);
        $log_tbl = 'global_hotelix_analitycs.booking_fsi_log';
        $req_to_log = isset($post_data) ? $post_data : 'no post request';
        if (is_array($req_to_log)) {
            $req_to_log = json_encode($req_to_log);
        }
        $this->db->insert($log_tbl, array(
            'request' => $req_to_log,
            'response' => $curl_response
        ));
        return $curl_response;
    }
    
    private function createXmlFromArray( $array, &$xml )
    {
        foreach ($array as $key => $value) {
            if (is_array($value)) {
                if (is_numeric($key)) {
                    $key = 'item' . $key; // Change numeric key to a valid XML element name
                }
                
                if ( isset($value[0])) {
                    if (is_array($value[0])) {
                        foreach ($value as $item) {
                            $subnode = $xml->addChild($key);
                            if (isset($item['_NodeTextValue'])) {
                                $subnode[0] = htmlspecialchars($item['_NodeTextValue']);
                                unset($item['_NodeTextValue']);
                            }
                            $this->createXmlFromArray($item, $subnode);
                        }
                    }else{
                        foreach ($value as $node_value) {
                            if (!is_array($node_value)) {
                                $xml->addChild($key, htmlspecialchars($node_value));
                            }
                        }
                    }
                } else {
                    $subnode = $xml->addChild($key);
                    $this->createXmlFromArray($value, $subnode);
                }
            } else {
                if (strpos($key, '@') === 0) {
                    if ($key === "@xmlns:xsi") {
                        $xml->addAttribute("xmlns:xsi", $value);
                    } else {
                        $xml->addAttribute(substr($key, 1), htmlspecialchars($value));
                    }
                } else {
                    $xml->addChild($key, htmlspecialchars($value));
                }
            }
        }
    }
    
    private function createXmlFromArray_old( $array, &$xml )
    {
        foreach ($array as $key => $value) {
            if (is_array($value)) {
                if (is_numeric($key)) {
                    $key = 'item' . $key; // Change numeric key to a valid XML element name
                }
                
                if ( isset($value[0]) && is_array($value[0])) {
                    foreach ($value as $item) {
                        $subnode = $xml->addChild($key);
                        $this->createXmlFromArray($item, $subnode);
                    }
                } else {
                    $subnode = $xml->addChild($key);
                    $this->createXmlFromArray($value, $subnode);
                }
            } else {
                if (strpos($key, '@') === 0) {
                    if ($key === "@xmlns:xsi") {
                        $xml->addAttribute("xmlns:xsi", $value);
                    } else {
                        $xml->addAttribute(substr($key, 1), htmlspecialchars($value));
                    }
                } else {
                    $xml->addChild($key, htmlspecialchars($value));
                }
            }
        }
    }
    
    public function get_active_partners() {
        $partners = array();
        $query_partners = $this->db->select('*')->get_where('partners', array('is_active'=>1))->result();
        if ($query_partners) {
            $partners = $query_partners;
        }
        return $partners;
    }//$partner_id//
    
    public function get_partner_data_by_id($partner_id) {
        $partner = array();
        $query_partner = $this->db->select('*')->get_where('partners', array('id'=>$partner_id))->row();
        if ($query_partner) {
            $partner = $query_partner;
        }
        return $partner;
    }
    
    public function get_properties_conections() {
        $tbl = 'dc_booking_xml_cfg';
        $query_properties_ids_in_xml_cfg = $this->db->select('int_value as id')->like(array('name' => 'hotel_id'))->get($tbl)->result();        
        $tbl = 'dc_booking2hms_properties';
        $query_properties_conections = $this->db->get($tbl)->result();

        $result = array();
        $properties_conections = array();
        foreach ($query_properties_conections as $conections) {
            $properties_conections[$conections->booking_property_id] = $conections;
        }
        foreach ($query_properties_ids_in_xml_cfg as $property) {
            if (!in_array($property->id, array_keys($properties_conections))) {
                $result[$property->id] = (object)array(
                    'booking_property_id' => $property->id,
                    'hms_property_id' => 0
                );
            }else{
                $result[$property->id] = $properties_conections[$property->id];
            }
        }
        if (count($properties_conections) > count($result)) {
            foreach ($properties_conections as $conection) {
                if (!isset($result[$conection->booking_property_id])) {
                    $result[$conection->booking_property_id] = $conection;
                    $result[$conection->booking_property_id]->recoverable = true;
                }
            }
        }
        return $result;
    }
    
    public function get_property_details($property_id = NULL) {
        $data = array(
            'HotelDescriptiveInfos' => array(
                'HotelDescriptiveInfo' => array(
                    '@HotelCode' => $property_id
                )
            )
        );
        $xml = new SimpleXMLElement('<OTA_HotelDescriptiveInfoRQ></OTA_HotelDescriptiveInfoRQ>');
        $this->createXmlFromArray($data, $xml);
        $response = $this->request_api(array(
            'post_data' => $xml->asXML(),
            'api_url' => 'https://supply-xml.booking.com/hotels/ota/OTA_HotelDescriptiveInfo'
        ));
        $response = new SimpleXMLElement($response);
        if (isset($response->Errors) && $this->is_test_env) {
            echo '<pre>';
            print_r($response);
            die("Died by Andrew at booking_api_mdl.php in get_property_details()");;
        }
        return $response;
    }
    
    public function get_property_attributes($property_id = NULL) {
        $data = array(
            'Criteria' => array(
                'Criterion' => array(
                    'HotelRef' => array(
                        '@HotelCode' => $property_id
                    )
                
                )
            )
        );
        $xml = new SimpleXMLElement('<OTA_HotelSearchRQ></OTA_HotelSearchRQ>');
        $this->createXmlFromArray($data, $xml);
        $post_data = $xml->asXML();
        
        $response = $this->request_api(array(
            'post_data' => $post_data,
            'api_url' => 'https://supply-xml.booking.com/hotels/ota/OTA_HotelSearch'
        ));
        return new SimpleXMLElement($response);
    }
    
    public function get_hms_properties($p = array()) {
        $tbl = 'property_information';
        $property_filds = array(
            'id',
            'property_name',
            'property_name_english',
            'dwelling',
            'property_type',
            'street',
            'additional_information',
            'city',
            'state',
            'post_code',
            'country',
            'gps_coordinates',
            'reception_phone',
            'email',
            'web_address',
            'star_rating',
            'check_in_time',
            'check_out_time',
            'timezone',
            'logo_small',
            'logo_original',
            'property_name_lat',
            'street_lat',
            'additional_information_lat',
            'city_lat',
            'state_lat',
            'range_id',
        );
        
        if (isset($p['property_filds_to_select']) && count($p['property_filds_to_select'])) {
            $property_filds_to_select = $p['property_filds_to_select'];
        }else{
            $property_filds_to_select = array(
                'id',
                'property_name',
                'dwelling',
                'property_type',
                'post_code',
                'country',
                'gps_coordinates',
                'reception_phone',
                'email',
                'web_address',
                'check_in_time',
                'check_out_time',
                'timezone',
                'property_name_lat',
                'street_lat',
                'additional_information_lat',
                'city_lat',
                'state_lat',
            );
        }
        
        $query_properties = $this->db->select(implode(', ', $property_filds_to_select))->get($tbl)->result();
        $properties = array();
        foreach ($query_properties as $property) {
            $properties[$property->id] = $property;
        }
        return $properties;
    }
    
    public function bind_properties($p = array('hms_property_id', 'booking_property_id')) {
        $tbl = 'dc_booking2hms_properties';
        $this->db->insert($tbl, $p);
        return;
    }
    
    public function validate_booking_property_id($p = array('booking_property_id')) {
        $validating_result = $this->get_property_attributes($p['booking_property_id']);
        return $validating_result;
    }
    
    public function update_booking_properties_tbl($p = array('booking_property_id')) {
        $booking_property_id = $p['booking_property_id'];
        $tbl = 'dc_booking_xml_cfg';
        $query_booking_properties_ids_in_xml_cfg = $this->db->select('int_value as id')->like(array('name' => 'hotel_id'))->get($tbl)->result();
        $id_allready_in_tbl = false;
        foreach ($query_booking_properties_ids_in_xml_cfg as $booking_property) {
            if ($booking_property->id == $booking_property_id) {
                $id_allready_in_tbl = true;
            }
        }
        if (!$id_allready_in_tbl) {
            $dc_account_id = count((array)$query_booking_properties_ids_in_xml_cfg) + 1;
            $ins_arr = array(
                'dc_account_id' => $dc_account_id,
                'name' => 'hotel_id',
                'int_value' => $booking_property_id,
            );
            $this->db->insert($tbl, $ins_arr);
        }        
        return;
    }
    
    public function unbind_properties($p = array('booking_property_id')) {
        $tbl = 'dc_booking2hms_properties';
        $this->db->delete($tbl, $p);
        return;
    }
    
    public function property_already_binded($p = array('booking_property_id')) {
        $tbl = 'dc_booking2hms_properties';
        return (bool) $this->db->get_where($tbl, $p)->row();
    }
    
    public function get_booking_property_rooms($booking_property_id) {
        $booking_rooms = array();
        $property_details = $this->get_property_details($booking_property_id);
        $property_details->registerXPathNamespace('c', 'http://www.opentravel.org/OTA/2003/05');
        $booking_rooms_content = $property_details->xpath('//c:GuestRoom');
        foreach ($booking_rooms_content as $room_content) {
            $booking_room = array();
            foreach ($room_content->attributes() as $attribute_name => $attribute_val) {
                $booking_room[$attribute_name] = (string)$attribute_val;
            }
            $booking_room['DescriptiveText'] = (string)$room_content->DescriptiveText;
            $booking_rooms[$booking_room['ID']] = (object)$booking_room;
        }
        return $booking_rooms;
    }
    
    public function delete_properties_conections($p = array('booking_property_id')) {
        //!!!!!!!!!! USE dc_model::delete_booking_account($dc_account_id, $simple_tab_id=0) : void - RemoteSystemsTempFiles 
        $booking_property_id = $p['booking_property_id'];
        $this->unbind_properties(array('booking_property_id' => $booking_property_id));
        
        $tbl = 'dc_booking_xml_cfg';
        $whr_arr = array(
            'name' => 'hotel_id',
            'int_value' => $booking_property_id,
        );
        $this->db->delete($tbl, $whr_arr);
        
        $glob_tbl = 'global_hotelix_analitycs.dc_channels_simple_ids';
        $whr_arr = array(
            'dc_id' => 1,
            'hms_id' => $this->hms_id,
            'dc_account_id' => $booking_property_id,
        );
        $this->db->delete($glob_tbl, $whr_arr);
        
        return;
    }
    
    public function get_rooms_conections($booking_property_id) {
        $conections = array();
        $tbl = 'dc_booking_rooms_link';
        $where_arr = array('dc_hotel_id' => $booking_property_id, 'category_id !=' => '0');
        $query_rooms = $this->db->get_where($tbl, $where_arr)->result();
        foreach ($query_rooms as $room) {
            $conections[$room->dc_room_id] = $room;
        }
        return $conections;
    }
    
    public function get_hms_property_rooms($hms_property_id) {
        $fields_all = array(
            'id',
            'is_active',
            'unlimited',
            'web_booking',
            'property_id',
            'room_type_id',
            'size',
            'size_type',
            'is_coomon_room',
            'room_location',
            'property_type_id',
            'listing_type_id',
            'name',
            'name_ru',
            'name_eng',
            'name_ua',
            'name_pl',
            'shortname',
            'settlementtype',
            'places',
            'add_places',
            'baby_places',
            'base_price',
            'add_price',
            'baby_price',
            'additional_bed_price',
            'baby_2price',
            'rooms',
            'order',
            'comment'
        );
        $fields_to_select = array(
            'id',
            'is_active',
            'name',
            'shortname'
        );
            
        $tbl = 'categories';
        $where_arr = array('property_id' => $hms_property_id, 'is_active' => 1);
        $query_rooms = $this->db->select(implode(', ', $fields_to_select))->get_where($tbl, $where_arr)->result();
        $rooms = array();
        foreach ($query_rooms as $room_data) {
            $rooms[$room_data->id] = $room_data;
        }
        return $rooms;
    }
    
    public function get_hms_room_data($p = array('hms_room_id')) {
        echo '<pre>!!!! Not done';
        
        die("Died by Andrew at booking_api_mdl.php on 4 груд. 2023 р.  18:06:11");
        $hms_room_id = $p['hms_room_id'];
    }
    
    public function room_already_binded($p = array('booking_room_id')) {
        $tbl = 'dc_booking_rooms_link';
        $where_arr = array(
            'dc_room_id' => $p['booking_room_id'],
            'category_id !=' => 0
        );
        return (bool) $this->db->get_where($tbl, $where_arr)->row();
    }
    
    public function bind_rooms($p = array('hms_room_id', 'booking_room_id', 'booking_property_id', 'dc_room_name')) {
        $tbl = 'dc_booking_rooms_link';
        $whr_arr = array(
            'dc_hotel_id' => $p['booking_property_id'],
            'dc_room_id' => $p['booking_room_id'],
        );
        $booking_room_id_exist = $this->db->get_where($tbl, $whr_arr)->row();
        if ($booking_room_id_exist) {
            $upd_arr = array(
                'category_id' => $p['hms_room_id']
            );
            $this->db->update($tbl, $upd_arr, $whr_arr);
        }else {
            if (!isset($p['dc_room_name'])) {
                $prop_rooms = $this->get_booking_property_rooms($p['booking_property_id']);
                $p['dc_room_name'] = $prop_rooms[$p['booking_room_id']]->DescriptiveText;
            }
            $ins_arr = $whr_arr + array('category_id' => $p['hms_room_id'], 'dc_room_name' => $p['dc_room_name']);
            $this->db->insert($tbl, $ins_arr);
        }
        return;
    }
    
    public function unbind_rooms($p = array('booking_room_id')) {
        $tbl = 'dc_booking_rooms_link';
        $where_arr = array(
            'dc_room_id' => $p['booking_room_id'],
        );
        $this->db->delete($tbl, $where_arr);
        return;
    }
    
    public function get_hms_rates() {
        $tbl = 'rate';
        $rates = array();
        $rate_fields_all = array(
            'id',
            'table_name',
            'caption',
            'currency',
            'nonrefundable',
            'breakfast',
            'isactive',
            'ccforce',
            'isdefault',
            'cancellation_policy_id',
            'parent_rate',
            'discount_type',
            'discount_value',
            'discount_singleuse_value',
            'discount_perperson_value',
            'discount_additional_bed_value',
            'discount_extrabed_value',
            'discount_baby_2price_value',
            'meal_policy_id'
        );
        $rate_fields_to_select = array(
            'id',
            'caption',
            'currency',
            'nonrefundable',
            'breakfast',
            'isactive',
            'isdefault',
            'cancellation_policy_id',
            'parent_rate',
            'meal_policy_id'
        );
        $where_arr = array();
        $query_rates = $this->db->select(implode(', ', $rate_fields_to_select))->get_where($tbl, $where_arr)->result();
        foreach ($query_rates as $rate_data) {
            $rates[$rate_data->id] = $rate_data;
        }
        return $rates;
    }
    
    public function get_rates_conections($booking_property_id) {
        $conections = array();
        $tbl_rates = 'dc_booking_rates';
        $tbl_rates_link = 'dc_booking_rates_link';
        $where_arr = array(
            "$tbl_rates.dc_hotel_id" => $booking_property_id,
            "$tbl_rates_link.hms_rate_id !=" => 0
        );
        $query_rates = $this->db->select("$tbl_rates_link.*, $tbl_rates.dc_hotel_id")
            ->join($tbl_rates_link, "$tbl_rates_link.dc_rate_id = $tbl_rates.dc_rate_id")
            ->where($where_arr)
            ->get($tbl_rates)->result();
        foreach ($query_rates as $rate) {
            $conections[$rate->dc_rate_id] = $rate;
        }
        return $conections;
    }
    
    public function get_booking_property_rates($booking_property_id, $return_type = 1) {
//         1: Returns all rate plans.
//         3: Returns all active rate plans.
//         6: Returns all deactivated rate plans.
        $data = array(
            'hotel_id' => $booking_property_id,
            'show_rates_status' => $return_type
        );
        $xml = new SimpleXMLElement('<request></request>');
        $this->createXmlFromArray($data, $xml);
        $response = $this->request_api(array(
            'post_data' => $xml->asXML(),
            'api_url' => 'https://supply-xml.booking.com/hotels/xml/rates'
        ));
        $response = new SimpleXMLElement($response);
        $rates = array();
        foreach ($response as $rate) {
            $rate_data = array();
            $rate_data['name'] = (string)$rate[0];
            foreach ($rate->attributes() as $attribute_key => $attribute_value) {
                $rate_data[$attribute_key] = (string)$attribute_value;
            }
            $rates[(string)$rate->attributes()->id] = (object)$rate_data;
        }
        return $rates;
    }
    
//     public function get_booking_property_rates_saved_in_hms ($p = array('booking_property_id')) {
//         return ;
//     }
    
    public function rate_already_binded($p = array('booking_rate_id', 'booking_property_id')) {
        $conections = $this->get_rates_conections($p['booking_property_id']);
        return (bool) array_key_exists($p['booking_rate_id'], $conections);
    }
    
    public function bind_rates($p = array('hms_rate_id', 'booking_rate_id', 'booking_property_id')) {
        $tbl = 'dc_booking_rates_link';
        $where_arr = array(
            'dc_rate_id' => $p['booking_rate_id'],
        );
        $dc_rate_is_in_tbl = $this->db->get_where($tbl, $where_arr)->row();
        if ($dc_rate_is_in_tbl) {
            $upd_arr = array(
                'hms_rate_id' => $p['hms_rate_id'],
            );
            $this->db->update($tbl, $upd_arr, $where_arr);
        }else{
            $ins_arr = array(
                'hms_rate_id' => $p['hms_rate_id'],
                'dc_rate_id' => $p['booking_rate_id'],
            );
            $this->db->insert($tbl, $ins_arr);
        }
        
//         $tbl = 'dc_booking_rates';
//         $ins_arr = array(
//             'dc_hotel_id' => $p['booking_property_id'],
//             'dc_rate_id' => $p['booking_rate_id'],
//         );
//         $this->db->insert($tbl, $ins_arr);
        return;
    }
    
    public function unbind_rates($p = array('booking_rate_id, booking_property_id')) {
        $tbl = 'dc_booking_rates_link';
        $where_arr = array(
            'dc_rate_id' => $p['booking_rate_id'],
        );
        $this->db->delete($tbl, $where_arr);
        
        $tbl = 'dc_booking_rates';
        $where_arr = array(
            'dc_hotel_id' => $p['booking_property_id'],
            'dc_rate_id' => $p['booking_rate_id'],
        );
        $this->db->delete($tbl, $where_arr);
        return;
    }
    
    public function activate_booking_rate($p = array('booking_rate_id', 'booking_property_id')) {
        $data = array(
            'RatePlans' => array(
                '@HotelCode' => $p['booking_property_id'],
                'RatePlan' => array(
                    '@RatePlanNotifType' => 'Activate',
                    '@RatePlanCode' => $p['booking_rate_id'],
                )
            )
        );
        $xml = new SimpleXMLElement('<OTA_HotelRatePlanNotifRQ></OTA_HotelRatePlanNotifRQ>');
        $this->createXmlFromArray($data, $xml);
        $post_data = $xml->asXML();
        
        $response = $this->request_api(array(
            'post_data' => $post_data,
            'api_url' => 'https://supply-xml.booking.com/hotels/ota/OTA_HotelRatePlanNotif'
        ));
        return;// new SimpleXMLElement($response);
    }
    
    public function deactivate_booking_rate($p = array('booking_rate_id', 'booking_property_id')) {
        $data = array(
            'RatePlans' => array(
                '@HotelCode' => $p['booking_property_id'],
                'RatePlan' => array(
                    '@RatePlanNotifType' => 'Remove',
                    '@RatePlanCode' => $p['booking_rate_id'],
                )
            )
        );
        $xml = new SimpleXMLElement('<OTA_HotelRatePlanNotifRQ></OTA_HotelRatePlanNotifRQ>');
        $this->createXmlFromArray($data, $xml);
        $post_data = $xml->asXML();
        
        $response = $this->request_api(array(
            'post_data' => $post_data,
            'api_url' => 'https://supply-xml.booking.com/hotels/ota/OTA_HotelRatePlanNotif'
        ));
        return;// new SimpleXMLElement($response);
    }
    
    public function create_or_update_booking_rate($p = array()) {
        $data_for_xml =  $this->parse_structure($this->structure_RatePlans(array()), $p);
        $xml = new SimpleXMLElement('<OTA_HotelRatePlanNotifRQ></OTA_HotelRatePlanNotifRQ>');
        $this->createXmlFromArray($data_for_xml, $xml);
        $post_data = $xml->asXML();
        $api_url = 'https://supply-xml.booking.com/hotels/ota/OTA_HotelRatePlanNotif';
        
        if($this->debug){
            $response = 'Have not been sent to Booking API, DEBUG is ON!';
        }else {
            $response = $this->request_api(array(
                'post_data' => $post_data,
                'api_url' => $api_url,
            ));
            $response = new SimpleXMLElement($response);
        }
        if ($this->fsi_request_to_session) {
            $this->session->set_userdata(array('fsi_rate_upd_last_req' => $this->prettyPrint(json_encode(array('url' => $api_url, 'data' => $data_for_xml)))));
            $upd_result = print_r($response, 1);
            $this->session->set_userdata(array('fsi_rate_upd_last_res' => $upd_result));
        }
        
        return $response;
    }
    
    public function activate_booking_room($p = array('booking_room_id', 'booking_property_id')) {
        $data = array(
            'SellableProducts' => array(
                '@HotelCode' => $p['booking_property_id'],
                'SellableProduct' => array(
                    '@InvNotifType' => 'Overlay',
                    '@InvStatusType' => 'Active',
                    '@InvCode' => $p['booking_room_id'],
                    'GuestRoom' => array()
                )
            )
        );
        $xml = new SimpleXMLElement('<OTA_HotelInvNotifRQ></OTA_HotelInvNotifRQ>');
        $this->createXmlFromArray($data, $xml);
        $post_data = $xml->asXML();
        
        $response = $this->request_api(array(
            'post_data' => $post_data,
            'api_url' => 'https://supply-xml.booking.com/hotels/ota/OTA_HotelInvNotif'
        ));
        return;// new SimpleXMLElement($response);
    }
    
    public function deactivate_booking_room($p = array('booking_room_id', 'booking_property_id')) {
        $data = array(
            'SellableProducts' => array(
                '@HotelCode' => $p['booking_property_id'],
                'SellableProduct' => array(
                    '@InvNotifType' => 'Overlay',
                    '@InvStatusType' => 'Deactivated',
                    '@InvCode' => $p['booking_room_id'],
                    'GuestRoom' => array()
                )
            )
        );
        $xml = new SimpleXMLElement('<OTA_HotelInvNotifRQ></OTA_HotelInvNotifRQ>');
        $this->createXmlFromArray($data, $xml);
        $post_data = $xml->asXML();
        
        $response = $this->request_api(array(
            'post_data' => $post_data,
            'api_url' => 'https://supply-xml.booking.com/hotels/ota/OTA_HotelInvNotif'
        ));
        return;// new SimpleXMLElement($response);
    }

    public function create_or_update_booking_room($p = array()){
        $data_for_xml = array(
            'SellableProducts' => array(
                '@HotelCode' => $p['HotelCode'],
                'SellableProduct' => array(
                    '@InvNotifType' => $p['InvNotifType'],
                )
            )
        );
        if (isset($p['InvCode']) && $p['InvCode']) {
            $data_for_xml['SellableProducts']['SellableProduct'] += array('@InvCode' => $p['InvCode']);
        }
        if (isset($p['GuestRoom'])) {
            $data_for_xml['SellableProducts']['SellableProduct'] += 
                        $this->parse_structure($this->structure_SellableProductGuestRoom(array()), array('GuestRoom' => $p['GuestRoom']));
        }
        $xml = new SimpleXMLElement('<OTA_HotelInvNotifRQ></OTA_HotelInvNotifRQ>');
        $this->createXmlFromArray($data_for_xml, $xml);
        $post_data = $xml->asXML();
        $api_url = 'https://supply-xml.booking.com/hotels/ota/OTA_HotelInvNotif';
        
        if($this->debug){
            $response = 'Have not been sent to Booking API, DEBUG is ON!';
        }else {
            $response = $this->request_api(array(
                'post_data' => $post_data,
                'api_url' => $api_url,
            ));
            $response = new SimpleXMLElement($response);
        }
        
        if ($this->fsi_request_to_session) {
            $this->session->set_userdata(array('fsi_room_upd_last_req' => ''));
            $this->session->set_userdata(array('fsi_room_upd_last_res' => ''));
            $this->session->set_userdata(array('fsi_room_upd_last_req' => $this->prettyPrint(json_encode(array('url' => $api_url, 'data' => $data_for_xml)))));
            $this->session->set_userdata(array('fsi_room_upd_last_res' => print_r($response, 1)));
        }
        
        return $response;
    }
    
    public function get_booking_room_types() {
        return array(
            1 => array(
                'id' => 1,
                'description' => 'Apartment',
                'notes' => 'Separate unit with own bathroom and kitchen/kitchenette.'
            ),
            4 => array(
                'id' => 4,
                'description' => 'Quadruple',
                'notes' => 'Unit for 4 persons'
            ),
            5 => array(
                'id' => 5,
                'description' => 'Suite',
                'notes' => 'Only "Suite" units. "Suite" have to be mentioned in the Unit name.'
            ),
            7 => array(
                'id' => 7,
                'description' => 'Triple',
                'notes' => 'Unit for 3 persons.'
            ),
            8 => array(
                'id' => 8,
                'description' => 'Twin',
                'notes' => 'Unit for 2 persons with 2 beds.'
            ),
            9 => array(
                'id' => 9,
                'description' => 'Double',
                'notes' => 'Unit for 2 persons with Double/Queen/King bed.'
            ),
            10 => array(
                'id' => 10,
                'description' => 'Single',
                'notes' => 'Unit for 1 person.'
            ),
            12 => array(
                'id' => 12,
                'description' => 'Studio',
                'notes' => 'Unit with kitchenette or kitchen.'
            ),
            13 => array(
                'id' => 13,
                'description' => 'Family',
                'notes' => 'Unit with "Family" in the unit name. It must have 2+ occupancy.'
            ),
            24 => array(
                'id' => 24,
                'description' => 'Twin/Double',
                'notes' => 'Standard Double or Twin Room.'
            ),
            25 => array(
                'id' => 25,
                'description' => 'Dormitory room',
                'notes' => 'Whole dormitory unit that is sold as one unit. "Dormitory room" needs to be mentioned in the room name.'
            ),
            26 => array(
                'id' => 26,
                'description' => 'Bed in Dormitory',
                'notes' => 'Unit for 1 person only. Please specify number of beds in the availability calls.
            Note : Do not include the term "Dormitory room" in the room name. It might have collision with the above room type and might experience issues while opening the property.
            Example :
            "Single Bed in Dormitory Room" -> this naming causes problem,
            "Single Bed in Dormitory" -> this naming works fine.'
            ),
            27 => array(
                'id' => 27,
                'description' => 'Bungalow',
                'notes' => 'Any type of bungalow units.'
            ),
            28 => array(
                'id' => 28,
                'description' => 'Chalet',
                'notes' => 'Any type of Chalet units.'
            ),
            29 => array(
                'id' => 29,
                'description' => 'Holiday home',
                'notes' => 'House, Town House, Holiday home units.'
            ),
            31 => array(
                'id' => 31,
                'description' => 'Villa',
                'notes' => 'Only Villa units. "Villa" have to be mentioned in the unit name.'
            ),
            32 => array(
                'id' => 32,
                'description' => 'Mobile home',
                'notes' => 'Any type of Mobile Home units.'
            ),
            33 => array(
                'id' => 33,
                'description' => 'Tent',
                'notes' => 'Any type of tents.'
            ),
        );
    }

    public function get_hotel_amenity_codes($p=array()) {
        $tbl = 'global_hotelix_common.property_ameneties';
        $query_amenities = $this->db->select('booking as code, name, type_id')->get($tbl)->result();
        $amenities = array();
        foreach ($query_amenities as $amenitiy) {
            $amenities[$amenitiy->code] = $amenitiy;
        }
        return $amenities;
    }
    
    public function get_breakfast_types() {
        $set = array(
            array(
                't_code' => '5001',
                't_name' => 'Continental'
            ),
            array(
                't_code' => '5002',
                't_name' => 'Italian'
            ),
            array(
                't_code' => '5003',
                't_name' => 'Full English'
            ),
            array(
                't_code' => '5004',
                't_name' => 'Vegetarian'
            ),
            array(
                't_code' => '5005',
                't_name' => 'Vegan'
            ),
            array(
                't_code' => '5006',
                't_name' => 'Halal'
            ),
            array(
                't_code' => '5007',
                't_name' => 'Gluten free'
            ),
            array(
                't_code' => '5008',
                't_name' => 'Kosher'
            ),
            array(
                't_code' => '5009',
                't_name' => 'Asian'
            ),
            array(
                't_code' => '5010',
                't_name' => 'American'
            ),
            array(
                't_code' => '5011',
                't_name' => 'Buffet'
            ),
            array(
                't_code' => '5012',
                't_name' => 'A la carte'
            )
        );
        $result = array();
        foreach ($set as $set_data) {
            $result[$set_data['t_code']] = $set_data;
        }
        return $result;
    }
    
    public function get_breakfast_items() {
        $set = array(
            array('i_code' => '5001',
                'i_name' => 'Bread'),
            array('i_code' => '5002',
                'i_name' => 'Pastries'),
            array('i_code' => '5003',
                'i_name' => 'Pancakes'),
            array('i_code' => '5004',
                'i_name' => 'Butter'),
            array('i_code' => '5005',
                'i_name' => 'Cheese'),
            array('i_code' => '5006',
                'i_name' => 'Cold meat'),
            array('i_code' => '5007',
                'i_name' => 'Eggs'),
            array('i_code' => '5008',
                'i_name' => 'Yogurt'),
            array('i_code' => '5009',
                'i_name' => 'Fruits'),
            array('i_code' => '5010',
                'i_name' => 'Coffee'),
            array('i_code' => '5011',
                'i_name' => 'Tea'),
            array('i_code' => '5012',
                'i_name' => 'Hot chocolate'),
            array('i_code' => '5013',
                'i_name' => 'Champagne'),
            array('i_code' => '5014',
                'i_name' => 'A la carte menu'),
            array('i_code' => '5015',
                'i_name' => 'Local specialities'),
            array('i_code' => '5016',
                'i_name' => 'Cooked/warm meals'),
            array('i_code' => '5017',
                'i_name' => 'Fruit juice'),
            array('i_code' => '5018',
                'i_name' => 'Jam'),
            array('i_code' => '5019',
                'i_name' => 'Cereal'),
        );
        $result = array();
        foreach ($set as $set_data) {
            $result[$set_data['i_code']] = $set_data;
        }
        return $result;
    }
    
    public function get_currencies() {
        $result = array();
        $tbl = 'global_hotelix.currency';
        $query_currencies = $this->db->select('name as c_code, full_name as c_name')->get($tbl)->result();
        foreach ($query_currencies as $currency) {
            $currency->c_selected = '';
            $result[$currency->c_code] = $currency;
        }
        return $result;
    }
    
    
    public function structure_AffiliationInfo($p = array()) {
        $structure = array(
            'AffiliationInfo' => array(
                'type' => 'array',
                'content' => array(
                    'Awards' => array(
                        'type' => 'array',
                        'content' => array(
                            'Award' => array(
                                'type' => 'array',
                                'attributes' => array(
                                    'Provider',
                                    'Rating'
                                ),
                                'content' => array()
                            )
                        )
                    )
                )
            )
        );
        return $structure;
    }
    
    public function structure_TPA_Extensions($p = array()) {//for PROPERTY root !!!!
        $structure = array(
            'TPA_Extensions' => array(
                'type' => 'array',
                'content' => array(
                    'PricingType' => array(
                        'type' => 'array',
                        'attributes' => array(
                            'Value',
                        ),
                        'content' => array(),
                    ),
                    'StandardPhrases' => array(
                        'type' => 'array',
                        'content' => array(
                            'StandardPhrase' => array(
                                'type' => 'array_of_nodes',
                                'attributes' => array(
                                    'Enabled',
                                    'Name',
                                ),
                                'content' => array(
                                    'Options' => array(
                                        'type' => 'array',
                                        'content' => array(
                                            'Option' => array(
                                                'type' => 'array_of_nodes',
                                                'attributes' => array(
                                                    'Name',
                                                ),
                                                'content' => array(
                                                    '_NodeTextValue' => array(
                                                        'type' => 'node',
                                                        'content' => ''
                                                    )
                                                ),
                                            ),
                                        ),
                                    ),
                                ),
                            ),
                        ),
                    ),
                )
            )
        );
        return $structure;
    }
    
    
    public function structure_FacilityInfo($p = array()) {
        $structure = array(
            'FacilityInfo' => array(
                'type' => 'array',
                'content' => array(
                    'GuestRooms' => array(
                        'type' => 'array',
                        'content' => array(
                            'GuestRoom' => array(
                                'type' => 'array',
                                'content' => array(
                                    'Amenities' => array(
                                        'type' => 'array',
                                        'content' => array(
                                            'Amenity' => array(
                                                'type' => 'array_of_nodes',
                                                'attributes' => array(
                                                    'RoomAmenityCode',
                                                    'AmenityCode',
                                                    'Quantity',
                                                    'Value',
                                                    'Configuration',
                                                ),
                                                'content' => array()
                                            ),
                                        )
                                    ),
                                )
                            ),
                        )
                    ),
                    'Restaurants' => array(
                        'type' => 'array',
                        'content' => $this->structure_Restaurant(array())
                    ),
                )
            )
        );
        return $structure;
    }
    
    public function structure_Restaurant($p = array()) {
        $structure = array(
            'Restaurant' => array(
                'type' => 'array_of_nodes',
                'attributes' => array(
                    'OfferBreakfast',
                    'OfferBrunch',
                    'OfferDinner',
                    'OfferLunch',
                    'RestaurantName',
                ),
                'content' => array(
                    'CuisineCodes' => array(
                        'type' => 'array',
                        'content' => array(
                            'CuisineCode' => array(
                                'type' => 'array_of_nodes',
                                'attributes' => array(
                                    'Code',
                                ),
                                'content' => array()
                            ),
                        )
                    ),
                    'OperationSchedules' => array(
                        'type' => 'array',
                        'content' => array(
                            'OperationSchedule' => array(
                                'type' => 'array',
                                'content' => array(
                                    'OperationTimes' => array(
                                        'type' => 'array',
                                        'content' => array(
                                            'OperationTime' => array(
                                                'type' => 'array_of_nodes',
                                                'attributes' => array(
                                                    'Mon',
                                                    'Tue',
                                                    'Weds',
                                                    'Thur',
                                                    'Fri',
                                                    'Sat',
                                                    'Sun',
                                                    'Start',
                                                    'End',
                                                ),
                                                'content' => array()
                                            ),
                                        )
                                    ),
                                ),
                            ),
                        )
                    ),
                    'Features' => array(
                        'type' => 'array',
                        'content' => array(
                            'Feature' => array(
                                'type' => 'array_of_nodes',
                                'attributes' => array(
                                    'DescriptiveText',
                                ),
                                'content' => array()
                            ),
                        )
                    ),
                    'TPA_Extensions' => array(
                        'type' => 'array',
                        'content' => array(
                            'Ambiances' => array(
                                'type' => 'array',
                                'content' => array(
                                    'Ambiance' => array(
                                        'type' => 'array_of_nodes',
                                        'attributes' => array(
                                            'Name',
                                        ),
                                        'content' => array()
                                    ),
                                )
                            ),
                            'DietaryOptions' => array(
                                'type' => 'array',
                                'content' => array(
                                    'DietaryOption' => array(
                                        'type' => 'array_of_nodes',
                                        'attributes' => array(
                                            'Name',
                                        ),
                                        'content' => array()
                                    ),
                                )
                            ),
                        )
                    ),
                ),
            ),
        );
        return $structure;
    }
    
    public function structure_HotelInfo($p = array()) {
        $structure = array(
            'HotelInfo' => array(
                'type' => 'array',
                'content' => array(
                    'CategoryCodes' => array(
                        'type' => 'array',
                        'content' => array(
                            'GuestRoomInfo' => array(
                                'type' => 'array',
                                'attributes' => array(
                                    'Quantity',
                                ),
                                'content' => array()
                            ),
                            'HotelCategory' => array(
                                'type' => 'array',
                                'attributes' => array(
                                    'Code',
                                    'ExistsCode',
                                ),
                                'content' => array()
                            ),
                        )
                    ),
                    'Languages' => array(
                        'type' => 'array',
                        'content' => array(
                            'Language' => array(
                                'type' => 'array_of_nodes',
                                'attributes' => array(
                                    'LanguageCode',
                                ),
                                'content' => ''
                            )
                        )
                    ),
                    'Position' => array(
                        'type' => 'array',
                        'attributes' => array(
                            'Latitude',
                            'Longitude',
                        ),
                        'content' => array()
                    ),
                    'Services' => array(
                        'type' => 'array',
                        'content' => array(
                            'Service' => array(
                                'type' => 'array_of_nodes',
                                'attributes' => array(
                                    'Code',
                                    'Price',
                                    'CurrencyCode'
                                ),
                                'content' => array(
                                    'Features' => array(
                                        'type' => 'array',
                                        'content' => array(
                                            'Feature' => array(
                                                'type' => 'array_of_nodes',
                                                'attributes' => array(
                                                    'DescriptiveText',
                                                ),
                                                'content' => array()
                                            ),
                                        )
                                    ),
                                    'Types' => array(
                                        'type' => 'array',
                                        'content' => array(
                                            'Type' => array(
                                                'type' => 'array_of_nodes',
                                                'attributes' => array(
                                                    'Code',
                                                ),
                                                'content' => array()
                                            ),
                                        )
                                    ),
                                    'Items' => array(
                                        'type' => 'array',
                                        'content' => array(
                                            'Item' => array(
                                                'type' => 'array_of_nodes',
                                                'attributes' => array(
                                                    'Code',
                                                ),
                                                'content' => array()
                                            ),
                                        )
                                    ),
                                )
                            ),
                        )
                    ),
                )
            )
        );
        return $structure;
    }
    
    public function structure_ContactInfos($p = array()) {
        $structure = array(
            'ContactInfos' => array(
                'type' => 'array',
                'content' => array(
                    'ContactInfo' => array(
                        'type' => 'array_of_nodes',
                        'attributes' => array(
                            'ContactProfileType'
                        ),
                        'content' => array(
                            'HiddenAddress' => array(
                                'type' => 'array',
                                'attributes' => array(
                                    'ShouldHideAddress'
                                ),
                                'content' => array()
                            ),
                            'Addresses' => array(
                                'type' => 'array',
                                'content' => array(
                                    'Address' => array(
                                        'type' => 'array_of_nodes',
                                        'content' => array(
                                            'Language' => array(
                                                'type' => 'node',
                                                'content' => array()
                                            ),
                                            'AddressLine' => array(
                                                'type' => 'node',
                                                'content' => array()
                                            ),
                                            'CityName' => array(
                                                'type' => 'node',
                                                'content' => array()
                                            ),
                                            'CountryName' => array(
                                                'type' => 'node',
                                                'content' => array()
                                            ),
                                            'HotelName' => array(
                                                'type' => 'node',
                                                'content' => array()
                                            ),
                                            'PostalCode' => array(
                                                'type' => 'node',
                                                'content' => array()
                                            ),
                                            'StateProv' => array(
                                                'type' => 'node',
                                                'attributes' => array(
                                                    'StateCode'
                                                ),
                                                'content' => array()
                                            ),
                                        )
                                    ),
                                )
                            ),
                            'Emails' => array(
                                'type' => 'array',
                                'content' => array(
                                    'Email' => array(
                                        'type' => 'array_of_nodes',
                                        'content' => ''
                                    ),
                                )
                            ),
                            'Names' => array(
                                'type' => 'array',
                                'content' => array(
                                    'Name' => array(
                                        'type' => 'array_of_nodes',
                                        'attributes' => array(
                                            'Language',
                                            'Gender',
                                        ),
                                        'content' => array(
                                            'GivenName' => array(
                                                'type' => 'node',
                                                'content' => array()
                                            ),
                                            'SurName' => array(
                                                'type' => 'node',
                                                'content' => array()
                                            ),
                                            'JobTitle' => array(
                                                'type' => 'node',
                                                'content' => array()
                                            )
                                        )
                                    ),
                                )
                            ),
                            'Phones' => array(
                                'type' => 'array',
                                'content' => array(
                                    'Phone' => array(
                                        'type' => 'array_of_nodes',
                                        'attributes' => array(
                                            'Extension',
                                            'PhoneNumber',
                                            'PhoneTechType',
                                        ),
                                        'content' => array()
                                    ),
                                )
                            ),
                        )
                    )
                )
            )
        );
        return $structure;
    }
    
    public function structure_Policies($p = array()) {
        $structure = array(
            'Policies' => array(
                'type' => 'array',
                'content' => array(
                    'Policy' => array(
                        'type' => 'array',
                        'content' => array(
                            'PolicyInfo' => array(
                                'type' => 'array',
                                'attributes' => array(
                                    'CheckInTime',
                                    'CheckOutTime',
                                    'TotalGuestCount',
                                    'AcceptedGuestType',
                                    'MinGuestAge',
                                ),
                                'content' => array()
                            ),
                            'CancelPolicy' => array(
                                'type' => 'array',
                                'content' => array(
                                    'CancelPenalty' => array(
                                        'type' => 'array_of_nodes',
                                        'attributes' => array(
                                            'PolicyCode',
                                        ),
                                        'content' => array(
                                            'TPA_Extensions' => array(
                                                'type' => 'array',
                                                'content' => array(
                                                    'NoShowPolicy' => array(
                                                        'type' => 'array',
                                                        'attributes' => array(
                                                            'Penalty',
                                                        ),
                                                        'content' => array(),
                                                    )
                                                ),
                                            )
                                        )
                                    ),
                                ),
                            ),
                            'PetsPolicies' => array(
                                'type' => 'array',
                                'attributes' => array(
                                    'PetsAllowedCode',
                                ),
                                'content' => array(
                                    'PetsPolicy' => array(
                                        'type' => 'array',
                                        'attributes' => array(
                                            'NonRefundableFee',
                                        ),
                                        'content' => array()
                                    ),
                                ),
                            ),
                            'GuaranteePaymentPolicy' => array(
                                'type' => 'array',
                                'content' => array(
                                    'GuaranteePayment' => array(
                                        'type' => 'array_of_nodes',
                                        'attributes' => array(
                                            'PolicyCode',
                                        ),
                                        'content' => array(
                                            'TPA_Extensions' => array(
                                                'type' => 'array',
                                                'content' => array(
                                                    'PrepaymentPolicy' => array(
                                                        'type' => 'array',
                                                        'attributes' => array(
                                                            'EffectiveFrom',
                                                        ),
                                                        'content' => array(),
                                                    )
                                                ),
                                            )
                                        )
                                    ),
                                ),
                            ),
                        )
                    )
                )
            )
        );
        return $structure;
    }

    public function parse_structure($structure, $data)
    {
        $result = array();
        foreach ($structure as $structure_name => $structure_data) {
            if (isset($data[$structure_name])) {
                $result[$structure_name] = array();
                switch ($structure_data['type']) {
                    case 'array_of_nodes':
                        foreach ($data[$structure_name] as $node_data) {
                            $attributes_arr = array();
                            if (isset($structure_data['attributes'])) {
                                foreach ($structure_data['attributes'] as $attribute) {
                                    if (isset($node_data[$attribute])) {
                                        $attributes_arr["@$attribute"] = $node_data[$attribute];
                                    }
                                }
                            }
                            if (!is_array($structure_data['content'])) {
                                $result[$structure_name][] = $node_data;
                            }else{
                                $result[$structure_name][] = array_merge($attributes_arr, $this->parse_structure($structure_data['content'], $node_data));
                            }
                        }
                        break;
                        
                    case 'array':
                        if (isset($structure_data['attributes'])) {
                            foreach ($structure_data['attributes'] as $attribute) {
                                if (isset($data[$structure_name][$attribute])) {
                                    $result[$structure_name]["@$attribute"] = $data[$structure_name][$attribute];
                                }
                            }
                        }
                        $result[$structure_name] += $this->parse_structure($structure_data['content'], $data[$structure_name]);
                        break;
                        
                    case 'node':
                        $result[$structure_name] = $data[$structure_name];
                        break;
                    
                    default:
                        ;
                        break;
                }
            }
        }
        return $result;
    }
    
    public function get_HotelDescriptiveContent_parsed_structure($p = array('data')) {
        $structure = array();
        $sub_structures = array(
            'AffiliationInfo' => array(),
            'AreaInfo' => array(),
            'ContactInfos' => array(),
            'FacilityInfo' => array(),
            'HotelInfo' => array(),
            'Policies' => array(),
            'TPA_Extensions' => array(),
        );
        foreach ($sub_structures as $structure_name => $structure_data) {
            if (isset($p['data'][$structure_name])) {
                $function_name = "structure_{$structure_name}";
                if (method_exists(__CLASS__, $function_name)) {
                    $structure += $this->parse_structure($this->$function_name(array()), $p['data']);
                }
            }
        }
        return $structure;
    }
    
    public function update_property($p = array('data', 'booking_property_id', 'action'/* create, update */))
    {
        $booking_property_id = $p['booking_property_id'];
        
        switch ($p['action']) {
            case 'create':
                $HotelDescriptiveContent = array(
//                 "@HotelCode" => "4386613", // remove node for a new property
//                 "@HotelName" => "Vit Hotel",
//                 "@LanguageCode" => "uk",
//                 "@CurrencyCode" => "INR",
//                 "@HotelDescriptiveContentNotifType" => "New"
                
                );
            break;
            case 'update':
                $HotelDescriptiveContent = array(
                "@HotelCode" => $booking_property_id, // remove node for a new property
                "@LanguageCode" => "uk",
                "@HotelDescriptiveContentNotifType" => "Overlay"
                );
                break;
            
            default:
                echo '<pre>';
                print_r('Invalid action!');
                die("Died by Andrew at booking_api_mdl.php on 3 лист. 2023 р.  16:18:32");
            break;
        }
        
        $HotelDescriptiveContent += $this->get_HotelDescriptiveContent_parsed_structure(array('data' => $p['data']));
        $data_for_xml = array(
            '@xmlns' => 'http://www.opentravel.org/OTA/2003/05',
            '@xmlns:xsi' => 'http://www.w3.org/2001/XMLSchema-instance',
            '@xsi:schemaLocation' => 'http://www.opentravel.org/2014B/OTA_HotelDescriptiveContentNotifRQ.xsd',
            '@TimeStamp' => date('c'),
            '@Target' => $this->is_test_env ? 'Test' : 'Production',
            'HotelDescriptiveContents' => array(
                'HotelDescriptiveContent' => $HotelDescriptiveContent,
            )
        );
        $xml = new SimpleXMLElement('<OTA_HotelDescriptiveContentNotifRQ></OTA_HotelDescriptiveContentNotifRQ>');
        $this->createXmlFromArray($data_for_xml, $xml);
        $post_data = $xml->asXML();
        
        $api_url = 'https://supply-xml.booking.com/hotels/ota/OTA_HotelDescriptiveContentNotif';
        
        if ($this->fsi_request_to_session) {
//             $this->session->set_userdata(array('fsi_prop_upd_last_req' => ''));
//             $this->session->set_userdata(array('fsi_prop_upd_last_req' => $this->prettyPrint(json_encode(array('url' => $api_url, 'data' => $data_for_xml)))));

            $_SESSION['fsi_prop_upd_last_req'] = $this->prettyPrint(json_encode(array('url' => $api_url, 'data' => $data_for_xml)));
        }

        if($this->debug){
            $response = 'Have not been sent to Booking API, DEBUG is ON!';
        }else {
            $response = $this->request_api(array(
                'post_data' => $post_data,
                'api_url' => $api_url
            ));
            $response = new SimpleXMLElement($response);
        }
        return $response;
    }
    
    public function crup_property($p = array('data', 'booking_property_id', 'action'/* create, update */))
    {
        $booking_property_id = $p['booking_property_id'];
        
        switch ($p['action']) {
            case 'create':
                $HotelDescriptiveContent = array(
                //                 "@HotelCode" => "4386613", // remove node for a new property
                //                 "@HotelName" => "Vit Hotel",
                //                 "@LanguageCode" => "uk",
                //                 "@CurrencyCode" => "INR",
                //                 "@HotelDescriptiveContentNotifType" => "New"
                
                );
                break;
            case 'update':
                $HotelDescriptiveContent = array(
                    "@HotelCode" => $booking_property_id,
                    "@HotelDescriptiveContentNotifType" => "Overlay"
                );
                if (isset($p['data']['LanguageCode'])) {
                    $HotelDescriptiveContent['@LanguageCode'] = $p['data']['LanguageCode'];
                }
                if (isset($p['data']['HotelName'])) {
                    $HotelDescriptiveContent['@HotelName'] = $p['data']['HotelName'];
                }
                break;
                
            default:
                echo '<pre>';
                print_r('Invalid action!');
                die("Died by Andrew at booking_api_mdl.php on 3 лист. 2023 р.  16:18:32");
                break;
        }
        
        $HotelDescriptiveContent += $this->get_HotelDescriptiveContent_parsed_structure(array('data' => $p['data']));
                
        $data_for_xml = array(
            '@xmlns' => 'http://www.opentravel.org/OTA/2003/05',
            '@xmlns:xsi' => 'http://www.w3.org/2001/XMLSchema-instance',
            '@xsi:schemaLocation' => 'http://www.opentravel.org/2014B/OTA_HotelDescriptiveContentNotifRQ.xsd',
            '@TimeStamp' => date('c'),
            '@Target' => $this->is_test_env ? 'Test' : 'Production',
            'HotelDescriptiveContents' => array(
                'HotelDescriptiveContent' => $HotelDescriptiveContent,
            )
        );
        $xml = new SimpleXMLElement('<OTA_HotelDescriptiveContentNotifRQ></OTA_HotelDescriptiveContentNotifRQ>');
        $this->createXmlFromArray($data_for_xml, $xml);
        $post_data = $xml->asXML();
        
        $api_url = 'https://supply-xml.booking.com/hotels/ota/OTA_HotelDescriptiveContentNotif';
        
        if ($this->fsi_request_to_session) {
            //             $this->session->set_userdata(array('fsi_prop_upd_last_req' => ''));
            //             $this->session->set_userdata(array('fsi_prop_upd_last_req' => $this->prettyPrint(json_encode(array('url' => $api_url, 'data' => $data_for_xml)))));
            
            $_SESSION['fsi_prop_upd_last_req'] = $this->prettyPrint(json_encode(array('url' => $api_url, 'data' => $data_for_xml)));
        }
        
        if($this->debug){
            $response = 'Have not been sent to Booking API, DEBUG is ON!';
        }else {
            $response = $this->request_api(array(
                'post_data' => $post_data,
                'api_url' => $api_url
            ));
            $response = new SimpleXMLElement($response);
        }
        return $response;
    }
    
    function prettyPrint( $json )
    {
        $result = '';
        $level = 0;
        $in_quotes = false;
        $in_escape = false;
        $ends_line_level = NULL;
        $json_length = strlen( $json );
        
        for( $i = 0; $i < $json_length; $i++ ) {
            $char = $json[$i];
            $new_line_level = NULL;
            $post = "";
            if( $ends_line_level !== NULL ) {
                $new_line_level = $ends_line_level;
                $ends_line_level = NULL;
            }
            if ( $in_escape ) {
                $in_escape = false;
            } else if( $char === '"' ) {
                $in_quotes = !$in_quotes;
            } else if( ! $in_quotes ) {
                switch( $char ) {
                    case '}': case ']':
                        $level--;
                        $ends_line_level = NULL;
                        $new_line_level = $level;
                        break;
                        
                    case '{': case '[':
                        $level++;
                    case ',':
                        $ends_line_level = $level;
                        break;
                        
                    case ':':
                        $post = " ";
                        break;
                        
                    case " ": case "\t": case "\n": case "\r":
                        $char = "";
                        $ends_line_level = $new_line_level;
                        $new_line_level = NULL;
                        break;
                }
            } else if ( $char === '\\' ) {
                $in_escape = true;
            }
            if( $new_line_level !== NULL ) {
                $result .= "\n".str_repeat( "\t", $new_line_level );
            }
            $result .= $char.$post;
        }
        
        return $result;
    }
    
    public function get_booking_property_mealtype_services_codes() {
        return array('173', '6000', '6001');
    }
    
    public function get_contact_profile_types_enum ($p = array()) {
        $enum = array(
            array(
                'prof_type' => 'general',
                'description' => 'Primary point of contact for the property.',
                'required' => 1
            ),
            array(
                'prof_type' => 'contract',
                'description' => 'Contact for contract matters.',
                'required' => 0
            ),
            array(
                'prof_type' => 'reservations',
                'description' => 'Contact for reservations.',
                'required' => 0
            ),
            array(
                'prof_type' => 'invoices',
                'description' => 'Contact for accounts payable.',
                'required' => 1
            ),
            array(
                'prof_type' => 'availability',
                'description' => 'Contact for questions about availability.',
                'required' => 0
            ),
            array(
                'prof_type' => 'site_content',
                'description' => 'Contact for photos, descriptions, and other website content.',
                'required' => 0
            ),
            array(
                'prof_type' => 'parity',
                'description' => 'Contact for pricing and rate matters.',
                'required' => 0
            ),
            array(
                'prof_type' => 'requests',
                'description' => 'Contact for special requests.',
                'required' => 0
            ),
            array(
                'prof_type' => 'central_reservations',
                'description' => 'Contact for central reservations. Applies to properties that manage reservations from another location.',
                'required' => 0
            ),
            array(
                'prof_type' => 'PhysicalLocation',
                'description' => "Address details for the property's physical location.",
                'required' => 1
            ),
        );
        return $enum;
    }
    
    public function get_booking_cancel_penalties($p=array()) {
        $tbl = 'global_hotelix_common.dc_cancelationpolicy_list';
        $query_penalties = $this->db->select('booking_code as code, description')->get($tbl)->result();
        $penalties = array();
        foreach ($query_penalties as $penalty) {
            $penalties[$penalty->code] = $penalty;
        }
        return $penalties;
    }
    
    public function get_RoomAmenityTypeCodes($p = array()) {
        $amenities = array();
        $tbl = 'global_hotelix_common.category_ameneties';
        $query_amenities = $this->db->select('booking as code, name')->get($tbl)->result();
        foreach ($query_amenities as $amenity) {
            $amenities[$amenity->code] = $amenity;
        }
        return $amenities;
    }
    
    public function get_HotelCategoryCodes($p = array()){
        $result = array();
        $tbl = 'global_hotelix_common.property_type';
        $query_types = $this->db->select('booking as hc_code, name as hc_name')->get_where($tbl, "booking != ''")->result();
        foreach ($query_types as &$type) {
            $type->hc_selected = '';
            $result[] = $type;
        }
        unset($type);
        return $result;
    }
    
    public function get_hms_hotel_supported_languages($p = array()) {
        $result = array();
            $tbl = 'descriptionlanguages';
            $query_languages = $this->db->select('name as hlang_code, name_original as hlang_name_original')->get($tbl)->result();
            foreach ($query_languages as &$language) {
                $language->hlang_checked = '';
            $result[] = $language;
        }
        unset($language);

        return $result;
    }
    
    public function structure_RatePlans($param) {
        $structure = array(
            'RatePlans' => array(
                'type' => 'array',
                'attributes' => array(
                    'HotelCode',
                ),
                'content' => array(
                    'RatePlan' => array(
                        'type' => 'array',
                        'attributes' => array(
                            'RatePlanNotifType',
                            'RatePlanCode',
                            'RatePlanID',
                        ),
                        'content' => array(
                            'Description' => array(
                                'type' => 'array',
                                'attributes' => array(
                                    'Name',
                                ),
                                'content' => array()
                            ),
                            'RateRelation' => array(
                                'type' => 'array',
                                'attributes' => array(
                                    'ParentRateId',
                                    'Percentage',
                                    'FollowsPrice',
                                    'FollowsRestrictions',
                                    'FollowsPolicyGroup',
                                    'FollowsClosed',
                                ),
                                'content' => array()
                            ),
                        )
                    ),
                )
            ),
        );
        return $structure;
    }
    
    public function structure_SellableProductGuestRoom($param) {
        $structure = array(
            'GuestRoom' => array(
                'type' => 'array',
                'content' => array(
                    'Description' => array(
                        'type' => 'array',
                        'content' => array(
                            'Text' => array(
                                'type' => 'node',
                                'content' => ''
                            ),
                        )
                    ),
                    'Occupancy' => array(
                        'type' => 'array',
                        'attributes' => array(
                            'MaxOccupancy',
                            'MaxAdultOccupancy',
                            'MaxChildOccupancy',
                        ),
                        'content' => array(),
                    ),
                    'TPA_Extensions' => array(
                        'type' => 'array',
                        'content' => array(
                            'Occupancy' => array(
                                'type' => 'array',
                                'attributes' => array(
                                    'MaxChildPayableOccupancy',
                                ),
                                'content' => array()
                            ),
                            'SubRooms' => array(
                                /* You can create subrooms only for rooms with the following room types (RoomType):
                                 - Apartment
                                 - Suite
                                 - Chalet
                                 - Bungalow
                                 - Holiday home
                                 - Villa
                                 - Mobile home
                                 Or, apartment_room_capacity is > 0. */
                                'type' => 'array',
                                'content' => array(
                                    'SubRoom' => array(
                                        'type' => 'array_of_nodes',
                                        'attributes' => array(
                                            'MaxGuests',
                                            'Number',//Only available for Bathroom or Living room
                                            'PrivateBathroom',//Accepts: Bedroom, Living room, Bathroom
                                            'RoomType',
                                        ),
                                        'content' => array(
                                            'Amenities' => array(
                                                'type' => 'array',
                                                'content' => array(
                                                    'Amenity' => array(
                                                        'type' => 'array_of_nodes',
                                                        'attributes' => array(
                                                            'RoomAmenityCode',
                                                            'AmenityCode',
                                                            'Quantity',
                                                            'Value',
                                                            'Configuration',
                                                        ),
                                                        'content' => array()
                                                    ),
                                                )
                                            ),
                                        )
                                    ),
                                )
                            ),
                        )
                    ),
                    'Room' => array(//required if InvNotifType="New"
                        'type' => 'array',
                        'attributes' => array(
                            'RoomID',
                            'RoomType',//required if InvNotifType="New"
                            'SizeMeasurement',
                            'SizeMeasurementUnit',
                            'NonSmoking',
                            'Quantity',
                        ),
                        'content' => array()
                    ),
                    'Quantities' => array(
                        'type' => 'array',
                        'attributes' => array(
                            'MaximumAdditionalGuests',
                            'MaxCribs',
                            'MaxRollaways',
                        ),
                        'content' => array()
                    ),
                    'Amenities' => array(
                        'type' => 'array',
                        'content' => array(
                            'Amenity' => array(
                                'type' => 'array_of_nodes',
                                'attributes' => array(
                                    'RoomAmenityCode',
                                    'AmenityCode',
                                    'Quantity',
                                    'Value',
                                    'Configuration',
                                ),
                                'content' => array()
                            ),
                        )
                    ),
                )
            ),
        );
        return $structure;
    }
    
    public function get_booking_roomname($room_type_code){
        $data = array(
            /* 'languages' => array(
                'language' => array('@code' => 'uk'),
            ),  */
            'roomtypes' => array(
                'roomtype' => array('@code' => "$room_type_code")
            ),
        );
        $xml = new SimpleXMLElement('<request></request>');
        $this->createXmlFromArray($data, $xml);
        $post_data = $xml->asXML();

        $response = $this->request_api(array(
            'post_data' => $post_data,
            'api_url' => 'https://supply-xml.booking.com/hotels/xml/roomname'
        ));
        return new SimpleXMLElement($response);
    }
    
    public function get_bk_CuisineCodes() {
        return array(
            1 => 'American',
            2 => 'French',
            3 => 'Italian',
            4 => 'Seafood',
            5 => 'Indian',
            6 => 'Asian',
            8 => 'Mexican',
            9 => 'Greek',
            10 => 'Thai',
            11 => 'Chinese',
            12 => 'Vietnamese',
            13 => 'Middle eastern',
            14 => 'Japanese',
            15 => 'Moroccan',
            17 => 'European',
            18 => 'Ethiopian',
            19 => 'Spanish',
            22 => 'Turkish',
            23 => 'Russian',
            24 => 'German',
            26 => 'Texmex',
            29 => 'Irish',
            30 => 'Scottish',
            33 => 'Argentinian',
            34 => 'Brazilian',
            41 => 'Creole',
            42 => 'Korean',
            43 => 'Latin american',
            44 => 'Steakhouse',
            49 => 'International',
            51 => 'Mediterranean',
            53 => 'Pizza',
            66 => 'Austrian',
            67 => 'Australian',
            73 => 'Indonesian',
            74 => 'Grill bbq',
            76 => 'Polish',
            78 => 'African',
            79 => 'Belgian',
            80 => 'Portuguese',
            5000 => 'British',
            5001 => 'Cambodian',
            5002 => 'Cantonese',
            5003 => 'Croation',
            5004 => 'Dutch',
            5005 => 'Hungarian',
            5006 => 'Local',
            5007 => 'Malaysian',
            5008 => 'Nepalese',
            5009 => 'Peruvian',
            5010 => 'Sichuan',
            5011 => 'Singaporean',
            5012 => 'South African',
            5013 => 'Sushi'
        );
   }
   
   public function get_cuisines_pars_arr() {
       $cuisines = array();
       $CuisineCodes = $this->get_bk_CuisineCodes();
       foreach ($CuisineCodes as $CuisineCode => $CuisineName) {
           array_push($cuisines, array('cui_code' => $CuisineCode, 'cui_name' => $CuisineName, 'cui_checked' => ''));
       }
       return $cuisines;
   }
   
   public function get_bk_RestaurantFeatures() {
       return array(
           'a la carte' =>'The restaurant offers à la carte dining',
           'buffet'	=> 'The restaurant has a buffet',
           'guests only' =>	'The restaurant only serves guests of the property',
           'accepts reservations' => 'Customers can reserve a table at the restaurant',
           'outdoor seating' => 'The restaurant offers outdoor seating',
       );
   }
   
   public function get_features_pars_arr() {
       $features = array();
       $RestaurantFeatures = $this->get_bk_RestaurantFeatures();
       foreach ($RestaurantFeatures as $RestaurantFeatureCode => $RestaurantFeatureName) {
           array_push($features, array('f_code' => $RestaurantFeatureCode, 'f_name' => $RestaurantFeatureName, 'f_checked' => ''));
       }
       return $features;
   }
   
   public function get_bk_RestaurantAmbiances() {
       return array(
           'family/kids friendly',
           'modern',
           'romantic',
           'traditional',
       );
   }
   
   public function get_ambiances_pars_arr() {
       $ambiances = array();
       $RestaurantAmbiances = $this->get_bk_RestaurantAmbiances();
       foreach ($RestaurantAmbiances as $Ambiance) {
           array_push($ambiances, array('amb_checked' => '', 'amb_name' => $Ambiance));
       }
       return $ambiances;
   }
   
   public function get_bk_RestaurantDietaryOptions() {
       return array(
           'dairy free',
           'gluten free',
           'halal',
           'kosher',
           'vegan',
           'vegetarian',
       );
   }
   
   public function get_dietaries_pars_arr() {
       $dietaries = array();
       $RestaurantDietaryOptions = $this->get_bk_RestaurantDietaryOptions();
       foreach ($RestaurantDietaryOptions as $DietaryOption) {
           array_push($dietaries, array('diet_checked' => '', 'diet_name' => $DietaryOption));
       }
       return $dietaries;
   }
   
   public function get_operation_days_pars_arr() {
        return array(
            array(
                'day_name' => 'Monday',
                'day_code' => 'Mon',
                'day_checked' => ''
            ),
            array(
                'day_name' => 'Tuesday',
                'day_code' => 'Tue',
                'day_checked' => ''
            ),
            array(
                'day_name' => 'Wednesday',
                'day_code' => 'Weds',
                'day_checked' => ''
            ),
            array(
                'day_name' => 'Thursday',
                'day_code' => 'Thur',
                'day_checked' => ''
            ),
            array(
                'day_name' => 'Friday',
                'day_code' => 'Fri',
                'day_checked' => ''
            ),
            array(
                'day_name' => 'Saturday',
                'day_code' => 'Sat',
                'day_checked' => ''
            ),
            array(
                'day_name' => 'Sunday',
                'day_code' => 'Sun',
                'day_checked' => ''
            ),
        );
   }
   
   public function get_bk_StandardPhrases() {
        return array(
            'GuestIdentification' => 'Guests must show photo identification and credit card when checking in.',
            'InformArrivalTime' => 'Guests must inform the property in advance of their expected arrival time.',
            'KeyCollection' => 'Guests must collect their key at a specified address. Use Option elements to specify the address details.',
            'PayBeforeStay' => 'Guests must pay for their stay in advance with a bank transfer.',
            'HotelChainBedLinen' => 'Bed linens and towels are not included in the room rate. Guests can rent them at the property for an additional charge or bring their own. Use an Option element to specify the amount.',
            'Renovation' => 'The property will be undergoing renovations during a specified period. Use Option elements to specify the start and end date.',
            'AccomodationTax' => 'An accommodation tax per person per night is not included in the price and needs to be paid at the property.',
            'IsraeliCitizensVat' => 'Only visible for properties based in Israel. Based on local tax laws, guests who are Israeli citizens must pay VAT. This tax is not automatically calculated in the total cost of the reservation and must be paid to the property.',
            'SecurityDeposit' => 'Guests must pay a specified amount as a refundable deposit, to cover any damages they cause to the property. Use an Option element to specify the amount.',
            'TattooRestriction' => 'Guests with tattoos are not allowed to use certain facilities at the hotel, such as communal baths.',
            'RequireInvoice' => 'If guests require an invoice when booking a prepaid rate, they must write this request and their company details in the Ask a question box.',
            'EarlyDeparture' => 'In the event of an early departure, the property will charge guests the full amount for their stay.',
            'PedestrianZoneOnly' => 'This property is located within a pedestrian-only zone.',
            'LimitedParking' => 'Parking is subject to availability due to limited spaces.',
            'AccessByUnpavedRoad' => 'This property is accessible via an unpaved road, which may be unsuitable for some vehicles.',
            'OnsiteFunctions' => 'This property may host on-site functions and some rooms may be affected by noise.',
            'NoHenStagParty' => 'This property will not accommodate hen, stag or similar parties.',
            'ResidentialArea' => 'This property is located in a residential area and guests are asked to refrain from excessive noise.',
            'BusyArea' => 'This property is located in a busy area and guests may experience noise.',
            'HalfBoardNoDrinks' => 'When booking half board, please note that drinks are not included.',
            'NoPublicTransport' => 'Guests are advised to bring their own vehicle as this property is not serviced by public transport.',
            'WaterCrisis' => 'Dear Visitor, this region is currently experiencing drought conditions. Please be aware that certain properties are subject to comply with local water usage restrictions.',
            'RussiaAntiHostelRegulations' => 'This property provides premises for short term stays and does not provide hotel services.',
            'LongStayDisclaimerJapan' => 'While this property offers long stays beyond one month, the property does not offer a lease to any guests. Accordingly, any guests who participate in this offering do not have any rights or interests as lessee for the offered property but are subject to applicable hotel stay/lodging terms and conditions.',
            'GuestRentalAgreement' => 'Guests will receive a rental agreement which must be signed and returned to the property prior to arrival. If guests do not receive the agreement on time, then they should contact the property management company at the number on the booking confirmation.',
            'GuestUnder18' => 'Guests under the age of 18 can only check in with a parent or official guardian.'
        );
   }
   
   public function get_std_phrases_pars_arr() {
       $std_phrases = array();
       $StandardPhrases = $this->get_bk_StandardPhrases();
       ksort($StandardPhrases);
       $StandardPhrases_with_options = array('KeyCollection', 'Renovation', 'HotelChainBedLinen', 'SecurityDeposit');
       $i = 0;
       foreach ($StandardPhrases as $StandardPhrase_name => $StandardPhrases_disc) {
           $phrase_has_options = in_array($StandardPhrase_name, $StandardPhrases_with_options) ? true : false;
            array_push($std_phrases, array(
                'phr_name' => $StandardPhrase_name,
                'phr_disc' => $StandardPhrases_disc,
                'prh_has_options' => $phrase_has_options,
                'phr_options_div_class' => $phrase_has_options ? "{$StandardPhrase_name}_options_div" : '',
                'phr_counter' => $i++
            ));
       }
       return $std_phrases;
   }
   
   public function create_or_update_restaurant($post = array()) {
       $restaurant_id = $post['hms_restaurant_id'] ? $post['hms_restaurant_id'] : null;//
       $hms_property_id = $post['hms_property_id'] ? $post['hms_property_id'] : null;
       $Restaurant_data = $post['Restaurant'] ? $post['Restaurant'] : array();
       $data = json_encode($Restaurant_data);
       $tbl = 'restaurants';
       if ($restaurant_id) {//update
           $update_arr = array(
               'data' => $data
           );
            $whr_arr = array(
                'id' => $restaurant_id
            );
            $this->db->update($tbl, $update_arr, $whr_arr);
       }else{ // create
            $create_arr = array(
                'hms_property_id' => $hms_property_id,
                'data' => $data
            );
            $this->db->insert($tbl, $create_arr);
            $restaurant_id = $this->db->insert_id();
       }
        $crup_result = array(
            'hms_restaurant_id' => $restaurant_id
        );
       return $crup_result;
   }
   
   public function get_bk_genders_enum() {
       return array('Male', 'Female');
   }
   
   public function get_bk_PhoneTechnologyTypeCodes() {
        return array(
            1 => 'Voice',
            3 => 'Fax',
            5 => 'Mobile'
        );
   }
   
   public function get_bk_JobTitles() {
        $JobTitles = array(
            array(
                'id' => 1,
                'name' => 'Administration Employee'
            ),
            array(
                'id' => 2,
                'name' => 'Director of Business Development'
            ),
            array(
                'id' => 3,
                'name' => 'E-Commerce Manager'
            ),
            array(
                'id' => 4,
                'name' => 'Finance Manager'
            ),
            array(
                'id' => 5,
                'name' => 'Front Office Employee'
            ),
            array(
                'id' => 6,
                'name' => 'General Manager'
            ),
            array(
                'id' => 7,
                'name' => 'Marketing Manager'
            ),
            array(
                'id' => 8,
                'name' => 'Owner'
            ),
            array(
                'id' => 9,
                'name' => 'Reservations Employee'
            ),
            array(
                'id' => 10,
                'name' => 'Reservations Manager'
            ),
            array(
                'id' => 11,
                'name' => 'Revenue Manager'
            ),
            array(
                'id' => 12,
                'name' => 'Rooms Division Manager'
            ),
            array(
                'id' => 13,
                'name' => 'Sales & Marketing Manager'
            ),
            array(
                'id' => 14,
                'name' => 'Sales Executive'
            ),
            array(
                'id' => 15,
                'name' => 'Sales Manager'
            ),
            array(
                'id' => 16,
                'name' => 'Unknown'
            ),
        );
        return $JobTitles;
   }
}