<?php

class Acquiring_model extends CI_Model
{
    
    public $validator;
    public $hotelix_config_fild_name = 'is_acquiring_valid';

    public function __construct()
    {
        parent::__construct();
        $this->load->model ( 'stripe' );
        $this->load->model ( 'releases' );
        $this->load->model ( 'hotelix_config' );
        $this->load->model ( 'visitka_model' );
    }

    public function set_state_as_valid()
    {        
        $this->hotelix_config->set_record($this->hotelix_config_fild_name, '1');
        return;
    }
    
    public function set_state_as_invalid()
    {
        $this->hotelix_config->set_record($this->hotelix_config_fild_name, '0');
        return;
    }

    public function is_valid()
    {
        $this->validator = 1;
        
        if ($this->releases->acquiring_validation_is_on()) {
            $this->validator = $this->hotelix_config->get_record($this->hotelix_config_fild_name);
        }
        
        return $this->validator;
    }
    
    public function liqpay_valid(){
        $liqpay_privat_key = @$this->db->get_where('gatewayoforder_personal', array('name' => 'liqpay_privat_key'))->row()->str_text;
        $ligpay_publickey = @$this->db->get_where('gatewayoforder_personal', array('name' => 'publickey'))->row()->str_text;
        return ($liqpay_privat_key != '' && $ligpay_publickey != '') ? 1 : 0;
    }
    
    public function monobank_valid(){
        $monobank_token = $this->hotelix_config->get_record("monobank_token");
        return ($monobank_token != '') ? 1 : 0;
    }
    
    public function przelewy24_valid(){
        $prlwy24_client_id = $this->hotelix_config->get_record("prlwy24_client_id");
        $prlwy24_client_secret = $this->hotelix_config->get_record("prlwy24_client_secret");
        $prlwy24_crc = $this->hotelix_config->get_record("prlwy24_crc");
        return ($prlwy24_client_id != '' && $prlwy24_client_secret != '' && $prlwy24_crc != '') ? 1 : 0;
    }
    
    public function mandarin_valid(){
        $mandarin_token = $this->hotelix_config->get_record("mandarin_token");
        $mandarin_account_id = $this->hotelix_config->get_record("mandarin_account_id");
        return ($mandarin_token != '' && $mandarin_account_id != '') ? 1 : 0;
    }
    
    public function paypal_valid(){
        $paypal_clientID = $this->hotelix_config->get_record("paypal_clientID");
        return ($paypal_clientID != '') ? 1 : 0;
    }
    
    public function bog_valid(){
        $bog_clientId = $this->hotelix_config->get_record("bog_clientId");
        $bog_secretKey = $this->hotelix_config->get_record("bog_secretKey");
        return ($bog_clientId != '' && $bog_secretKey != '') ? 1 : 0;
    }
    
    public function transbank_valid(){
        $transbank_client_id = $this->hotelix_config->get_record("transbank_client_id");
        $transbank_client_api_key = $this->hotelix_config->get_record("transbank_client_api_key");
        return ($transbank_client_id != '' && $transbank_client_api_key != '') ? 1 : 0;
    }
    
    public function stripe_valid(){
        $stripe_valid = 1;
        $param = $this->stripe->get_standart_stripe_param();

        if(!isset($param['stripe_secret']) || $param['stripe_secret'] == ''){
            $stripe_valid = 0;
        }
        if(!isset($param['stripe_publishable']) || $param['stripe_publishable'] == ''){
            $stripe_valid = 0;
        }
        if(!isset($param['client_id']) || $param['client_id'] == ''){
            $stripe_valid = 0;
        }
        if(!isset($param['connected_stripeAccount']) || $param['connected_stripeAccount'] == ''){
            $stripe_valid = 0;
        }
        if(!isset($param['ca_access_token']) || $param['ca_access_token'] == ''){
            $stripe_valid = 0;
        }
        if(!isset($param['ca_stripe_user_id']) || $param['ca_stripe_user_id'] == ''){
            $stripe_valid = 0;
        }
        return $stripe_valid;
    }
    
    // ====== перевірка стану еквайрінга для поточної країни готеля ======
    public function check_acquiring_valid(){
        $country_3c = $this->visitka_model->get_config_value($this->config->item("hotel_id"), "id_country_3c");
        switch ($country_3c) {
            case 'UKR':
                $liqpay_valid = $this->liqpay_valid();
                $monobank_valid = $this->monobank_valid();
                $paypal_valid = $this->paypal_valid();
                $acquiring_valid = ($liqpay_valid == 1 || $monobank_valid == 1 || $paypal_valid == 1) ? 1 : 0;
                break;
            case 'GEO':
                $bog_valid = $this->bog_valid();
                $paypal_valid = $this->paypal_valid();
                $acquiring_valid = ($bog_valid == 1 || $paypal_valid == 1) ? 1 : 0;
                break;
            case 'RUS':
                $acquiring_valid = $this->mandarin_valid();
                break;
            case 'CHL':
                $transbank_valid = $this->transbank_valid();
                $paypal_valid = $this->paypal_valid();
                $acquiring_valid = ($transbank_valid == 1 || $paypal_valid == 1) ? 1 : 0;
                break;
            default:
                $stripe_valid = $this->stripe_valid();
                $paypal_valid = $this->paypal_valid();
                $przelewy24_valid = $this->przelewy24_valid();
                $acquiring_valid = ($stripe_valid == 1 || $paypal_valid == 1 || $przelewy24_valid == 1) ? 1 : 0;
                break;
        }

        return $acquiring_valid;
    }
    
    // ====== встановлення стану еквайрінга ====== 
    public function set_acquiring_state(){
        if($this->check_acquiring_valid()){
            $this->set_state_as_valid();
        }else{
            $this->set_state_as_invalid();
        }
    }
    
    // ====== URL еквайрінга ======
    public function get_settings_page_link(){
        $equiring_url = "";
        $country_3c = $this->visitka_model->get_config_value($this->config->item("hotel_id"), "id_country_3c");
        switch ($country_3c) {
            case "GEO":
                $equiring_url = "/bog/settings";
                if ($this->releases->paypal_v2_aquring() && $this->config->item('paypal_version_aquring') == 2) {
                    $equiring_url = "/paypal/settings_v2";
                }
                if ($this->releases->paypal_aquring() && $this->config->item('paypal_version_aquring') == 1) {
                    $equiring_url = "/paypal/settings";
                }
                break;
            case "RUS":
                $equiring_url = "/mandarin/settings";
                break;
            case "UKR":
                $equiring_url = "/reservation_c2/active_liqpay";
                break;
            case "CHL":
                
                $equiring_url = "/transbank/settings";
                if ($this->releases->paypal_v2_aquring() && $this->config->item('paypal_version_aquring') == 2) {
                    $equiring_url = "/paypal/settings_v2";
                }
                if ($this->releases->paypal_aquring() && $this->config->item('paypal_version_aquring') == 1) {
                    $equiring_url = "/paypal/settings";
                    
                }
                break;
            default:
                $id_country_3c = strtoupper($this->visitka_model->get_visitka_id_country_3c());
                if ($this->stripe->get_stripe_acquiring_available_in_country($id_country_3c)){
                    $stripe_subaccount = 0;
                    $stripe_subaccount = $this->hotelix_config->get_record("stripe_subaccount", "int");
                    switch ($stripe_subaccount) {
                        case 1:
                            $equiring_url = "/cc_c2/stripe_partner";
                            break;
                        case 2:
                            $equiring_url = "/stripe_standart/connect";
                            break;
                        default:
                            $equiring_url = "/stripe_standart/connect";
                    }
                }
        
                if ($this->releases->paypal_v2_aquring() && $this->config->item('paypal_version_aquring') == 2) {
                    $equiring_url = "/paypal/settings_v2";
                }
        
                if ($this->releases->paypal_aquring() && $this->config->item('paypal_version_aquring') == 1) {
                    $equiring_url = "/paypal/settings";
                }
                break;
        }
        
//         if ($this->releases->przelewy_aquring()) {
//             $equiring_url = "/przelewy/settings";
//         }
        return $equiring_url;
    }
}