<?php
class Access extends CI_model {
	function __construct() {
		parent::__construct ();
		
		$this->load->model ( 'releases' );
	}
		
	/*
	 *  GET BASIC USERS ACCESS DATA FROM GLOBAL_HOTELIX DATABASE
	 *  TABLES
	 *     - user_access_groups
	 *     - user_access
	 */
	public function get_user_access_groups() {
	    $access_array = array ();
	    $sql = "SELECT user_access_groups.id as groups_id, user_access.id as access_id,
	           user_access.name as access_name, user_access.caption as access_caption,
	           user_access_groups.name as groups_name, user_access_groups.caption as groups_caption
	           FROM `global_hotelix`.user_access_groups 
	           INNER JOIN `global_hotelix`.user_access ON user_access.type_id = user_access_groups.id";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            $access_array[$row->groups_id]['groups_id'] = $row->groups_id;
	            $access_array[$row->groups_id]['groups_name'] = $row->groups_name;
	            $access_array[$row->groups_id]['groups_caption'] = $row->groups_caption;
	            
	            $access_array[$row->groups_id]['access'][$row->access_id]['access_id'] = $row->access_id;
	            $access_array[$row->groups_id]['access'][$row->access_id]['access_name'] = $row->access_name;
	            $access_array[$row->groups_id]['access'][$row->access_id]['access_caption'] = $row->access_caption;
	        }
	    }
	
	    return $access_array;
	}
	
	/*
	 *  GET USER ACCESS RIGHTS FROM LOCAL DATABASE
	 *  TABLES
	 *     - access_rights
	 */
	public function get_user_access_rights($user_id){
	    $return_data = array ();
	    $sql = "SELECT access_id, status FROM access_rights WHERE user_id = $user_id";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            $return_data[$row->access_id]['status'] = $row->status;
	        }
	    }
	    
	    return $return_data;
	}
	
	/*
	 *  GET USER ACCESS statuses
	 */
	public function get_user_access_statuses(){
	    $return_data = array ();
	    $return_data [0]['status_id'] = 1;
	    $return_data [0]['status_caption'] = '{только чтение}';
	    $return_data [1]['status_id'] = 2;
	    $return_data [1]['status_caption'] = '{полный доступ}';
	    $return_data [2]['status_id'] = 3;
	    $return_data [2]['status_caption'] = '{запрещено}';
	    
	    return $return_data;
	}
	
	public function save_user_access_rights($data){
	    $user_id = $data ['user_id'];
	    foreach($data['access'] as $access_id => $status){
	        $sql = "INSERT INTO  access_rights (user_id, access_id, status) VALUES ('$user_id', '$access_id', '$status')
	                ON DUPLICATE KEY UPDATE status = '$status'";
	        $query = $this->db->query ( $sql );
	    }
	}
	
	function get_access_pages($interface_version = 1) {
	    $select = "";
	    if($interface_version == 2){
	        $select = " WHERE name NOT LIKE 'reporttotalbalane' AND name NOT LIKE 'reportdealerbalane'";
	    }
		$access_pages = array ();
		$sql = "SELECT accesspages.* FROM `global_hotelix`.accesspages $select";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			
			foreach ( $query->result () as $row ) {
				array_push ( $access_pages, array (
						"id" => $row->id,
						"page_name" => $row->name,
						"caption" => $row->caption
				) );
			}
		}
		
		return $access_pages;
	}
	
	function get_page_access($page, $type){
		$user_id = $_SESSION ['user']["id"];
		$access = 0;
		$sql = "SELECT access.".$type." FROM access INNER JOIN `global_hotelix`.accesspages ON accesspages.id = access.page WHERE access.userid = " . $user_id." AND accesspages.name LIKE '".$page."'";
		$query = $this->db->query ( $sql );
		// die($sql);
		if ($query->num_rows () > 0) {
			$row = $query->row();
			$access = $row->$type;
		}
	
		return $access;
	}
	
	function get_user_data($user_id, $interface_version = 1) {
		$user_data = array ();
	
		$access_pages = $this->get_access_pages($interface_version);
	
		$sql = "SELECT * FROM users WHERE id = " . $user_id;
		$query = $this->db->query ( $sql );
		// die($sql);
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$user_data["login"] = $row->login;
			$user_data["user_id"] = $user_id;
			$user_data["user_name"] = $row->login;
			$count = count($access_pages);
			for($i = 0; $i < $count; $i++){
				$user_data["pages"][$access_pages[$i]["id"]] = $access_pages[$i];
				$user_data["pages"][$access_pages[$i]["id"]]["view"] = 0;
				$user_data["pages"][$access_pages[$i]["id"]]["edit"] = 0;
			}
		}
	
		$select = "";
		if($interface_version == 2){
		    $select = " AND page NOT IN(1,2)";
		}
		
		$sql = "SELECT * FROM access WHERE userid = " . $user_id." ".$select;
		$query = $this->db->query ( $sql );
		// die($sql);
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$user_data["pages"][$row->page]["view"] = $row->view;
				$user_data["pages"][$row->page]["edit"] = $row->edit;
			}
		}
	
		return $user_data;
	}
	
	function save_user($user_data){
		//echo "<pre>";
		//print_r ( $user_data );
		//die ();
		$user_id = $user_data["user_id"];
		foreach ( $user_data["page"] as $id_page => $value ) {
			$sql = "INSERT INTO  access (userid, page, edit, view) VALUES ('".$user_id."', $id_page, '".$value["edit"]."', '".$value["view"]."')
			ON DUPLICATE KEY UPDATE view = '".$value["view"]."', edit = '".$value["edit"]."'";
			$query = $this->db->query ( $sql );
		}
	}
	
	function get_access($data){
	    $page_name = $data['page_name'];
	    $type = $data['type']; // view|edit
	    $access = $this->get_page_access($page_name, $type);
	    if($access == 2){
	        die ( "<meta http-equiv='refresh' content='0;url=/errors/FreeError/30'>" );
	    }
	}
	
	function get_billing_plans(){
	    $levels = array(
	        'free'=>1, 
	        'base'=>1, 
	        'premium'=>1, 
	        'ultra'=>1
	        
	    );
	    return $levels;
	}
	
	function get_billing_plan_access($data){
	    $levels = $this->get_billing_plans();	    
	    if($this->releases->active_billing_plan_access() == 1){
	       $module_name = $data['module_name'];
	       $billing_plan = @$this->db->select('str_value')->get_where('hotelix_config', array('name' => 'stripe_plan_level'))->row()->str_value;
	       //print_r($levels);
	       //echo $billing_plan;
	       //die();
	       if (isset($levels[$billing_plan])) {
	           
	       } else {
	           //$billing_plan = 'premium';
	           $billing_plan = 'base';
	       }
	       //echo $billing_plan." ".$module_name;
	       if ($billing_plan != "")
	           $bool = $this->db->select("$billing_plan")->get_where('global_hotelix_common.billing_plan_levels', array('name' => $module_name))->row()->$billing_plan;
	    }else{
	        $bool = 1;
	    }
	    //echo $bool;
	    //die();
	    return $bool;
	}
	
	function check_billing_plan_access($module_name){
	    $bool = 0;
	    $levels = array('free'=>1, 'base'=>1, 'premium'=>1, 'ultra'=>1);
	    if($this->releases->active_billing_plan_access() == 1){	        
	        $billing_plan = $this->db->select('str_value')->get_where('hotelix_config', array('name' => 'stripe_plan_level'))->row()->str_value;
	        
	        if (isset($levels[$billing_plan])) {
	            
	        } else {
	            $billing_plan = 'base';
	        }
	        
	        if ($billing_plan)
	            $bool = $this->db->select($billing_plan)->get_where('global_hotelix_common.billing_plan_levels', array('name' => $module_name))->row()->$billing_plan;
	    }else{
	        $bool = 1;
	    }
	    if ($bool == 0) {
	        die ( "<meta http-equiv='refresh' content='0;url=/errors_c2/view_error/52'>" );
	    }
	    return $bool;
	}
}