<?php
class Xlsfactory extends CI_Controller {
	public function __construct() {
		parent::__construct ();
		$this->load->model ( 'Authorization' );
		$newdata = array (
				'REQUEST_URI' => $_SERVER ["REQUEST_URI"]
		);
		$this->session->set_userdata ( $newdata );
		$this->Authorization->IsLogined ();
		$this->load->model ( 'xlsfactory_model' );
		$this->load->model ( 'fms_core' );
		$this->load->model ( 'mlanguages' );
		$this->load->model ( 'wifi_radius');
	}
	function uploadxls_reservationlist() {
		$prefix = $this->mlanguages->get_language_prefix();
		$status_table_name = "global_hotelix_languages.".$prefix."_statusofreservation";
		$dealer = $this->session->userdata ( 'dealers' );
		$startintdate = $this->session->userdata ( 'startintdate' );
		$endintdate = $this->session->userdata ( 'endintdate' );
		$str_dealer = '';
		if ($dealer != '') {
			$str_dealer = "deskofreservation.id_dealer=$dealer AND";
		}
		if ($this->session->userdata ( 'categories' ) != "") {
			// echo "---";
			// print_r($this->session->userdata ( 'categories' ));
			$categories = $this->session->userdata ( 'categories' );
		} else {
			// echo "+++";
			$categories = array ();
			$query = $this->db->query ( "SELECT id FROM categories ORDER BY id ASC" );
			// $i = 0;
			foreach ( $query->result () as $row ) {
				$categories [$row->id] = $row->id;
				// $i ++;
			}
		}
		$calendar = "(";
		$count = count($categories);
		$i = 1;
		//print_r($categories);
		foreach ( $categories as $key => $value ) {
		    if ($value == 'all_categories') {
		        $i++;
		        continue;
		    }
			if ($count > $i) {
				$calendar .= ' rooms.category_id = ' . $value . ' OR';
			} else {
				$calendar .= ' rooms.category_id = ' . $value . ")";
			}
			$i++;
		}

		$fields_list = array(
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_order}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_guest}" ) =>'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_createdate}" ) =>'datetime',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_assigned_to}" ) =>'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_category}" ) =>'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_room}" ) =>'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_status}" ) =>'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_sum}" ) =>'#,##0.00',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_balance}" ) =>'#,##0.00',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_car}" ) =>'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_checkin}" ) =>'date',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_days}" ) =>'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_checkout}" ) =>'date'
		);
		$sql = "SELECT deskofreservation.id, CONCAT(guests.firstname, ' ', guests.lastname) as guestname, deskofreservation.date, CONCAT(users.fullname, ' ', users.lastname) as username,
		categories.name as categories_name, rooms.name as room_name, ".$status_table_name.".name as status_name, deskofreservation.amount, deskofreservation.balance, deskofreservation.car_name,
		deskofreservation.datein, deskofreservation.duration, deskofreservation.dateout
		FROM guests
		INNER JOIN deskofreservation ON deskofreservation.guest_id=guests.id
		INNER JOIN deskofdays ON deskofdays.reservation_id=deskofreservation.id
		LEFT JOIN users ON deskofreservation.id_user=users.id
		INNER JOIN rooms ON rooms.id=deskofreservation.room_id
		INNER JOIN categories ON categories.id=rooms.category_id
		LEFT JOIN ".$status_table_name." ON ".$status_table_name.".id = deskofreservation.status
		LEFT JOIN payment ON payment.reservation_id=deskofreservation.id
		LEFT JOIN services_main ON services_main.reservation_id=deskofreservation.id
		LEFT JOIN discount ON discount.reservation_id=deskofreservation.id
		WHERE $str_dealer intdate>=" . $startintdate . " AND intdate <" . $endintdate . " AND deskofreservation.cancel <> 1 AND deskofreservation.deleted <> 1 AND $calendar
		GROUP BY deskofreservation.id";
		//echo $sql;
		//die();
		$filename = "reservationlist.xlsx";

		$this->xlsfactory_model->uploadxlsbyquery ($fields_list, $sql, $filename);
	}
	function uploadxls_listofreservation() {
		// echo "<pre>";
		// print_r($_POST);
		// die();
		$prefix = $this->mlanguages->get_language_prefix ();
		$status_table_name = "global_hotelix_languages." . $prefix . "_statusofreservation";

		if (isset ( $_POST ['selected_reservation'] )) {

			$checkcontract = array ();

			$checkcontract = $_POST ['selected_reservation'];

			$len = count ( $checkcontract );
			$select = " WHERE deskofreservation.id IN (";
			for($i = 0; $i < $len; $i ++) {
				if ($i < ($len - 1)) {
					$select .= $checkcontract [$i] . ",";
				} else {
					$select .= $checkcontract [$i] . ")";
				}
			}
		} else {
			$user = $this->session->userdata ( 'user' );
			$date_type = $this->session->userdata ( 'datetype' );
			$datein = $this->session->userdata ( 'datein' );
			$dateout = $this->session->userdata ( 'dateout' );
			$select = " WHERE deskofreservation.deleted=0 AND";
			if ($user != "") {
				$select .= " deskofreservation.id_user = '" . $user . "' AND";
			}
			if ($date_type != "") {
				switch ($date_type) {
					case "0" :
						if ($datein != "" and $dateout == "") {

							$select .= " deskofreservation.datein BETWEEN '" . $datein . " 00:00:00' AND '2054-01-01 23:59:59' AND";
						}
						if ($datein == "" and $dateout != "") {
							$select .= " deskofreservation.datein BETWEEN '2009-01-01 00:00:00' AND '" . $dateout . " 23:59:59' AND";
						}

						if ($datein != "" and $dateout != "") {
							$select .= " deskofreservation.datein BETWEEN '" . $datein . " 00:00:00' AND '" . $dateout . " 23:59:59' AND";
						}
						break;
					case "1" :
						if ($datein != "" and $dateout == "") {

							$select .= " deskofreservation.date BETWEEN '" . $datein . " 00:00:00' AND '2054-01-01 23:59:59' AND";
						}
						if ($datein == "" and $dateout != "") {
							$select .= " deskofreservation.date BETWEEN '2009-01-01 00:00:00' AND '" . $dateout . " 23:59:59' AND";
						}

						if ($datein != "" and $dateout != "") {
							$select .= " deskofreservation.date BETWEEN '" . $datein . " 00:00:00' AND '" . $dateout . " 23:59:59' AND";
						}
						break;
				}
			}

			if ($this->session->userdata ( 'dealers' ) != "") {
				$dealers = $this->session->userdata ( 'dealers' );
				$select .= " dealers.id = " . $dealers . " AND ";
			}
			if ($this->session->userdata ( 'room' ) != "") {
				$room = $this->session->userdata ( 'room' );
				$select .= " deskofreservation.room_id = " . $room . " AND ";
			}
			if ($this->session->userdata ( 'reservation_status' ) != "") {
				$reservation_status = $this->session->userdata ( 'reservation_status' );
				$select .= " deskofreservation.status = " . $reservation_status . " AND ";
			}

			if ($this->session->userdata ( 'category' ) != "") {
				$category = $this->session->userdata ( 'category' );
				$select .= " rooms.category_id = " . $category . " AND ";
			}
			$select .= " 1=1";
		}



				$fields_list = array ($this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_order}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_guest}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_createdate}" ) => 'datetime',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_assigned_to}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_category}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_room}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_status}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_sum}" ) => '#,##0.00',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_balance}" ) => '#,##0.00',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_car}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_checkin}" ) => 'date',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_days}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_checkout}" ) => 'date',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_description}" ) => 'string'
		);

		//echo "<pre>";
		//print_r($fields_list);
		//die();
		$sql = "SELECT  deskofreservation.id, CONCAT(guests.firstname, ' ', guests.lastname) as guestname, deskofreservation.date, CONCAT(users.fullname, ' ', users.lastname) as username,
				categories.name as categories_name, rooms.name as room_name, " . $status_table_name . ".name as status_name, deskofreservation.amount, deskofreservation.balance,
				CONCAT(deskofreservation.car_name, ' ', deskofreservation.car_number) as car_data,
				deskofreservation.datein, deskofreservation.duration, deskofreservation.dateout, deskofreservation.description
				FROM deskofreservation
				INNER JOIN guests ON deskofreservation.guest_id=guests.id
				LEFT JOIN users ON deskofreservation.id_user=users.id
				INNER JOIN rooms ON rooms.id=deskofreservation.room_id
				INNER JOIN categories ON categories.id=rooms.category_id
				LEFT JOIN " . $status_table_name . " ON " . $status_table_name . ".id = deskofreservation.status
								LEFT JOIN payment ON payment.reservation_id=deskofreservation.id
								LEFT JOIN discount ON discount.reservation_id=deskofreservation.id
								$select
								GROUP BY deskofreservation.id";

		$filename = "reservationoflist.xlsx";
		$this->xlsfactory_model->uploadxlsbyquery ( $fields_list, $sql, $filename );
	}

	function uploadxls_listofreservation_c2() {
		
		$main_rlist_sql = $_SESSION['rlist_main_sql'];
		//echo $main_rlist_sql."<br><br><br>";
		//die();
		$prefix = $this->mlanguages->get_language_prefix ();
		$status_table_name = "global_hotelix_languages." . $prefix . "_statusofreservation";
        
		$pos_where = strpos($main_rlist_sql, "WHERE");
		$pos_group = strpos($main_rlist_sql, "GROUP BY");
		
		
		
		if (isset ( $_POST ['selected_reservation'] )) {

			$checkcontract = array ();

			$checkcontract = $_POST ['selected_reservation'];

			$len = count ( $checkcontract );
			$select = " WHERE deskofreservation.id IN (";
			for($i = 0; $i < $len; $i ++) {
				if ($i < ($len - 1)) {
					$select .= $checkcontract [$i] . ",";
				} else {
					$select .= $checkcontract [$i] . ") ";
				}
			}
			$main_rlist_sql = substr_replace($main_rlist_sql, $select, $pos_where, $pos_group - $pos_where);
 			//echo $main_rlist_sql;
 			//die();
		} else {
			$user = $this->session->userdata ( 'user' );
			$date_type = $this->session->userdata ( 'datetype' );
			$datein = $this->session->userdata ( 'datein' );
			$dateout = $this->session->userdata ( 'dateout' );
			$select = " WHERE deskofreservation.deleted=0 AND";
			if ($user != "") {
				$select .= " deskofreservation.id_user = '" . $user . "' AND";
			}
			if ($date_type != "") {
				switch ($date_type) {
					case "0" :
						if ($datein != "" and $dateout == "") {

							$select .= " deskofreservation.datein BETWEEN '" . $datein . " 00:00:00' AND '2054-01-01 23:59:59' AND";
						}
						if ($datein == "" and $dateout != "") {
							$select .= " deskofreservation.datein BETWEEN '2009-01-01 00:00:00' AND '" . $dateout . " 23:59:59' AND";
						}

						if ($datein != "" and $dateout != "") {
							$select .= " deskofreservation.datein BETWEEN '" . $datein . " 00:00:00' AND '" . $dateout . " 23:59:59' AND";
						}
						break;
					case "1" :
						if ($datein != "" and $dateout == "") {

							$select .= " deskofreservation.date BETWEEN '" . $datein . " 00:00:00' AND '2054-01-01 23:59:59' AND";
						}
						if ($datein == "" and $dateout != "") {
							$select .= " deskofreservation.date BETWEEN '2009-01-01 00:00:00' AND '" . $dateout . " 23:59:59' AND";
						}

						if ($datein != "" and $dateout != "") {
							$select .= " deskofreservation.date BETWEEN '" . $datein . " 00:00:00' AND '" . $dateout . " 23:59:59' AND";
						}
						break;
				}
			}

			if ($this->session->userdata ( 'dealers' ) != "") {
				$dealers = $this->session->userdata ( 'dealers' );
				$select .= " dealers.id = " . $dealers . " AND ";
			}
			if ($this->session->userdata ( 'room' ) != "") {
				$room = $this->session->userdata ( 'room' );
				$select .= " deskofreservation.room_id = " . $room . " AND ";
			}
			if ($this->session->userdata ( 'reservation_status' ) != "") {
				$reservation_status = $this->session->userdata ( 'reservation_status' );
				$select .= " deskofreservation.status = " . $reservation_status . " AND ";
			}

			if ($this->session->userdata ( 'category' ) != "") {
				$category = $this->session->userdata ( 'category' );
				$select .= " rooms.category_id = " . $category . " AND ";
			}
			$select .= " 1=1";
		}

		$fields_rlist_session = $this->session->userdata ( 'fields_rlist' );

		$fields = array ();
		$fields ["number"] = 1;
		$fields ["reservation_id"] = 1;
		$fields ["cat_room_name"] = 1;
		$fields ["cat_name"] = 1;
		$fields ["room_name"] = 1;
		$fields ["guest_name"] = 1;
		$fields ["base_places"] = 1;
		$fields ["additional_places"] = 1;
		$fields ["baby_places"] = 1;
		$fields ["istochnik"] = 1;
		$fields ["price_type"] = 1;
		$fields ["status_name"] = 1;
		$fields ["datein"] = 1;
		$fields ["duration"] = 1;
		$fields ["dateout"] = 1;
		$fields ["amount"] = 1;
		$fields ["discount"] = 1;
		$fields ["pay_amount"] = 1;
		$fields ["balance"] = 1;
		$fields ["date"] = 1;
		$fields ["phone"] = 1;
		$fields ["email"] = 1;
		if ($fields_rlist_session == "") {
			$sql2 = "SELECT str_value FROM hotelix_interface_config WHERE name LIKE 'rlist_fields' AND userid = ".$_SESSION["user"]["id"];
			$query2 = $this->db->query($sql2);

			if ($query2->num_rows () > 0) {
				$row2 = $query2->row();
				$json_fields = $row2->str_value;
				$fields_rlist_session = json_decode($json_fields, true);
			}else{
				$fields_rlist_session = $fields;
			}
		}
		//echo "<pre>";
		//print_r($fields_rlist_session);
		$fields_list = array ();
		if(isset($fields_rlist_session["number"])){
			$fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_number}" )] = 'string';
		}
		if(isset($fields_rlist_session["reservation_id"])){
			$fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_order}" )] = 'string';
		}
		if(isset($fields_rlist_session["cat_room_name"])){
			$fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_cat_room_name}" )] = 'string';
		}
		if(isset($fields_rlist_session["cat_name"])){
		    $fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_category}" )] = 'string';
		}
		if(isset($fields_rlist_session["room_name"])){
		    $fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_room}" )] = 'string';
		}
		if(isset($fields_rlist_session["guest_name"])){
			$fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_guest}" )] = 'string';
		}
		if(isset($fields_rlist_session["base_places"])){
			$fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_base_places}" )] = 'string';
		}
		if(isset($fields_rlist_session["additional_places"])){
			$fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_additional_places}" )] = 'string';
		}
		if(isset($fields_rlist_session["baby_places"])){
			$fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_baby_places}" )] = 'string';
		}
		if(isset($fields_rlist_session["istochnik"])){
			$fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_istochnik}" )] = 'string';
		}
		if(isset($fields_rlist_session["price_type"])){
			$fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_price_type}" )] = 'string';
		}
		if(isset($fields_rlist_session["status_name"])){
			$fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_status}" )] = 'string';
		}
		if(isset($fields_rlist_session["datein"])){
			$fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_checkin}" )] = 'date';
		}
		if(isset($fields_rlist_session["duration"])){
			$fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_days}" )] = 'string';
		}
		if(isset($fields_rlist_session["dateout"])){
			$fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_checkout}" )] = 'date';
		}
		if(isset($fields_rlist_session["amount"])){
			$fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_sum}" )] = '#,##0.00';
		}
		if(isset($fields_rlist_session["discount"])){
			$fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_discount}" )] = '#,##0.00';
		}
		if(isset($fields_rlist_session["pay_amount"])){
			$fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_pay_amount}" )] = '#,##0.00';
		}
		if(isset($fields_rlist_session["balance"])){
			$fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_balance}" )] = '#,##0.00';
		}
		if(isset($fields_rlist_session["date"])){
			$fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_createdate}" )] = 'datetime';
		}
		if(isset($fields_rlist_session["phone"])){
			$fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_phone}" )] = 'string';
		}
		if(isset($fields_rlist_session["email"])){
			$fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_email}" )] = 'string';
		}

// 		$sql = $sql = "SELECT 1 as number, deskofreservation.guest_id, deskofreservation.intgroupid, groupreservations.name as group_name,
// deskofreservation.id as reservation_id, CONCAT(rooms.name, ' (', categories.name, ')') as cat_room_name,
// CONCAT(guests.lastname, ' ', guests.firstname) as guest_name, deskofreservation.adults as base_places,
// deskofreservation.addbedplace as additional_places, deskofreservation.baby_places as baby_places,
// dealers.name as istochnik, rate.caption as price_type, ".$status_table_name.".name as status_name,
// deskofreservation.datein, deskofreservation.duration, deskofreservation.dateout, deskofreservation.amount, deskofreservation.discount,
// SUM(IFNULL(payment.amount,0)) as pay_amount, deskofreservation.balance, deskofreservation.date, guests.phone, guests.email
// FROM deskofreservation
// INNER JOIN guests ON deskofreservation.guest_id=guests.id
// INNER JOIN rooms ON rooms.id=deskofreservation.room_id
// INNER JOIN categories ON categories.id=rooms.category_id
// INNER JOIN ".$status_table_name." ON ".$status_table_name.".id = deskofreservation.status
// 	LEFT JOIN dealers ON dealers.id = deskofreservation.id_dealer
// 	LEFT JOIN payment ON  payment.reservation_id = deskofreservation.id
// 	LEFT JOIN groupreservations ON  groupreservations.id = deskofreservation.intgroupid
// 	LEFT JOIN rate ON  rate.id = deskofreservation.price_type
// 	$select
// 		GROUP BY deskofreservation.id";


		$filename = "reservationoflist.xlsx";
		$sum_record = 1; // стрічка загальних сум
		$this->xlsfactory_model->uploadxlsbyquery_c2 ( $fields_list, $main_rlist_sql, $filename, $fields_rlist_session, $sum_record );
	}

	function uploadxls_fms_list_c2(){
// 	    echo "<pre>";
// 	    print_r($_POST);
// 	    die();

	    $main_rlist_sql = $_SESSION['fms_list_main_sql'];

	    $prefix = $this->mlanguages->get_language_prefix ();

	    $fields_list = array ();
	    $fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_order}" )] = 'string';
	    $fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_guest}" )] = 'string';
	    $fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_citizenship}" )] = 'string';
	    $fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_datein}" )] = 'date';
	    $fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_dateout}" )] = 'date';
	    $fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_registryto}" )] = 'date';
	    $fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_createtime}" )] = 'date';
	    $fields_list[$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_status}" )] = 'string';

	    //die();

	    $array = array();
	    $i = 0;
        if ($main_rlist_sql != '') {
            $query = $this->db->query($main_rlist_sql);
            foreach ($query->result() as $row) {
                $fms_indata = array();
                $fms_indata['reservation_id'] = $row->reservation_id ?? '';
                $fms_indata['guest_id'] = $row->guest_id ?? '';
                $fms_indata['status_code'] = $row->state ?? '';
                $fms_indata['citizenship_code'] = $row->citizenship_code ?? '';
                $fms_indata['datein'] = $row->datein ?? '';
                $fms_indata['dateout'] = $row->dateout ?? '';
                $fms_indata['fms_dateout'] = $row->fms_dateout ?? '';
                $fms_indata['fms_createtime'] = $row->time ?? '';
                $fms_indata['skip_registry'] = $row->skip_registry ?? '';
                $fms_indata['opencases'] = $row->opencases ?? '';
                $data =  $this->fms_core->get_fms_parsing_status_data_arr($fms_indata);

                $array[$i]["id"] = $row->reservation_id ?? '';
                $array[$i]["guestname"] = $row->firstname ?? '' ." ".$row->lastname ?? '';
                $array[$i]["citizenship_code"] = $row->citizenship_code ?? '';
                $array[$i]["datein"] = $row->datein ?? '';
                $array[$i]["dateout"] = $row->dateout ?? '';
                $array[$i]["fms_dateout"] = $row->fms_dateout ?? '';
                $array[$i]["time"] = $row->time ?? '';
                $array[$i]["fms_state"] = $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, ($data["fms_gist_clt"] ?? '') )
					." ".$data["fms_state"];
                $i ++;
            }
        }

// 	    echo "<pre>";
// 	    print_r($fields_list);
// 	    print_r($array);
// 	    die();
	    $filename = "fms_list.xlsx";

	    $this->xlsfactory_model->uploadxlsbyarray ( $fields_list, $array, $filename );

	}
	function uploadxls_guest_list_c2() {
// 	    echo "<pre>";
// 	    print_r($_POST);
// 	    die();

	    $main_rlist_sql = $_SESSION['guestslist_main_sql'];

	    $sql_temp = explode("LIMIT", $main_rlist_sql);
	    $main_rlist_sql = $sql_temp[0];

	    $prefix = $this->mlanguages->get_language_prefix ();
	    $selected_records = "";
	    if (isset ( $_POST ['selected_reservation'] )) {

	        $checkcontract = array ();

	        $checkcontract = $_POST ['selected_reservation'];

	        $len = count ( $checkcontract );
	        $selected_records = " WHERE guests.id IN (";
	        for($i = 0; $i < $len; $i ++) {
	            if ($i < ($len - 1)) {
	                $selected_records .= $checkcontract [$i] . ",";
	            } else {
	                $selected_records .= $checkcontract [$i] . ")";
	            }
	        }

	        $selected_records .= " AND ";
	    }

	    if($selected_records != "")
	       $main_rlist_sql = str_replace("WHERE", $selected_records, $main_rlist_sql);

        $fields_rlist_session = $this->session->userdata('fields_guestslist');

        $fields = array ();
$fields ["number"] = 1;
$fields ["guest_id"] = 1;
$fields ["reservation_id"] = 1;
$fields ["room_name"] = 1;
$fields ["category_name"] = 1;
$fields ["datein"] = 1;
$fields ["dateout"] = 1;
$fields ["firstname"] = 1;
$fields ["lastname"] = 1;
$fields ["middlename"] = 1;
$fields ["gender"] = 1;
$fields ["guest_type"] = 1;
$fields ["guest_dob"] = 1;
$fields ["phone"] = 1;
$fields ["email"] = 1;
//$fields ["nationality"] = 1;
$fields ["citizenship_code"] = 1;
//$fields ["country"] = 1;
//$fields ["citizenship"] = 1;
$fields ["city"] = 1;
$fields ["address"] = 1;
$fields ["addrbuilding"] = 1;
$fields ["addrapt"] = 1;
$fields ["postcode"] = 1;
$fields ["doc_type"] = 1;
$fields ["doc_precode"] = 1;
$fields ["passportid"] = 1;

$fields ["doc_date_open"] = 1;
$fields ["doc_date_till"] = 1;
$fields ["passportissuedby"] = 1;
$fields ["scan"] = 1;
$fields ["reservations_count"] = 1;
$fields ["amount"] = 1;
$fields ["balance"] = 1;
        if ($fields_rlist_session == "") {
            $sql2 = "SELECT str_value FROM hotelix_interface_config WHERE name LIKE 'guestslist_fields' AND userid = " . $_SESSION["user"]["id"];
            $query2 = $this->db->query($sql2);

            if ($query2->num_rows() > 0) {
                $row2 = $query2->row();
                $json_fields = $row2->str_value;
                $fields_rlist_session = json_decode($json_fields, true);
            } else {
                $fields_rlist_session["number"] = $fields["number"];
                $fields_rlist_session["room_name"] = $fields["room_name"];
                $fields_rlist_session["category_name"] = $fields["category_name"];
                $fields_rlist_session["datein"] = $fields ["datein"];
                $fields_rlist_session["dateout"] = $fields ["dateout"];
                $fields_rlist_session["firstname"] = $fields["firstname"];
                $fields_rlist_session["lastname"] = $fields["lastname"];
                $fields_rlist_session["middlename"] = $fields ["middlename"];
                $fields_rlist_session["gender"] = $fields ["gender"];
                $fields_rlist_session["guest_type"] = $fields ["guest_type"];
                $fields_rlist_session["guest_dob"] = $fields ["guest_dob"];
                $fields_rlist_session["phone"] = $fields["phone"];
                $fields_rlist_session["email"] = $fields["email"];
                $fields_rlist_session["citizenship_code"] = $fields["citizenship_code"];
                //$fields_rlist_session["country"] = $fields["country"];
                //$fields_rlist_session["citizenship"] = $fields["citizenship"];
                $fields_rlist_session["city"] = $fields["city"];
                $fields_rlist_session["addrapt"] =   $fields ["addrapt"];
                $fields_rlist_session ["doc_type"] = $fields["doc_type"];
                $fields_rlist_session ["doc_precode"] = $fields["doc_precode"];
                $fields_rlist_session ["passportid"] = $fields["passportid"];
                $fields_rlist_session ["doc_date_open"] = $fields["doc_date_open"];
                $fields_rlist_session ["doc_date_till"] = $fields["doc_date_till"];
                $fields_rlist_session ["passportissuedby"] = $fields["passportissuedby"];
                $fields_rlist_session ["scan"] = $fields["scan"];
                $fields_rlist_session ["reservations_count"] = $fields["reservations_count"];
                $fields_rlist_session ["amount"] = $fields["amount"];
                $fields_rlist_session ["balance"] = $fields["balance"];
                // $fields_rlist_session = $fields;
            }
        }
        // echo "<pre>";
        // print_r($fields_rlist_session);

        $fields_data = array();
        $fields_data["number"]["name"] = "#";
        $fields_data["guest_id"]["name"] = "{caption_guest_id}";
        $fields_data["reservation_id"]["name"] = "{caption_order}";
        $fields_data["room_name"]["name"] = "{caption_room}";
        $fields_data["category_name"]["name"] = "{caption_category}";
        $fields_data["datein"] ["name"] = "{caption_checkin}";
        $fields_data["dateout"] ["name"] = "{caption_checkout}";
        $fields_data["firstname"]["name"] = "{caption_firstname}";
        $fields_data["lastname"]["name"] = "{caption_lastname}";
        $fields_data["middlename"]["name"] = "{caption_middlename}";
        $fields_data["gender"]["name"] = "{caption_gender}";
        $fields_data["guest_type"]["name"] = "{caption_guest_type}";
        $fields_data["dob"]["name"] = "{caption_dob}";
        $fields_data["phone"]["name"] = "{caption_phone}";
        $fields_data["email"]["name"] = "{caption_email}";
        // $fields_data ["nationality"] ["name"] = "{caption_nationality}";
        $fields_data["citizenship_code"]["name"] = "{caption_citizenship}";
        $fields_data["country"]["name"] = "{caption_country}";
        $fields_data["city"]["name"] = "{caption_city}";
        $fields_data["address"]["name"] = "{caption_street}";
        $fields_data["addrbuilding"]["name"] = "{caption_house}";
        $fields_data["postcode"]["name"] = "{caption_zip}";
        $fields_data["doc_type"]["name"] = "{caption_doc_type}";
        $fields_data["doc_precode"]["name"] = "{caption_doc_precode}";
        $fields_data["passportid"]["name"] = "{caption_passportid}";
        $fields_data["doc_date_open"]["name"] = "{caption_doc_date_open}";
        $fields_data["doc_date_till"]["name"] = "{caption_doc_date_till}";
        $fields_data["passportissuedby"]["name"] = "{caption_passportissuedby}";
        $fields_data["scan"]["name"] = "{caption_scan}";
        $fields_data["reservations_count"]["name"] = "{caption_reservations_count}";
        $fields_data["amount"]["name"] = "{caption_amount}";
        $fields_data["balance"]["name"] = "{caption_balance}";


        $fields_list = array();
        if (isset($fields_rlist_session["number"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_number}")] = 'string';
        }
        if (isset($fields_rlist_session["guest_id"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_guest_id}")] = 'string';
        }
        if (isset($fields_rlist_session["reservation_id"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_order}")] = 'string';
        }
        if (isset($fields_rlist_session["room_name"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_room}")] = 'string';
        }
        if (isset($fields_rlist_session["category_name"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_category}")] = 'string';
        }
        if (isset($fields_rlist_session["datein"])) {
            $fields_list[$this->mlanguages->getdictionaryword("reservations_rlist", $prefix, "{caption_checkin}")] = 'string';
        }
        if (isset($fields_rlist_session["dateout"])) {
            $fields_list[$this->mlanguages->getdictionaryword("reservations_rlist", $prefix, "{caption_checkout}")] = 'string';
        }
        if (isset($fields_rlist_session["firstname"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_firstname}")] = 'string';
        }
        if (isset($fields_rlist_session["lastname"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_lastname}")] = 'string';
        }
        if (isset($fields_rlist_session["middlename"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_middlename}")] = 'string';
        }
        if (isset($fields_rlist_session["gender"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_gender}")] = 'string';
        }
        if (isset($fields_rlist_session["guest_type"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_guest_type}")] = 'string';
        }
        if (isset($fields_rlist_session["guest_dob"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_dob}")] = 'string';
        }
        if (isset($fields_rlist_session["phone"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_phone}")] = 'string';
        }
        if (isset($fields_rlist_session["email"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_email}")] = 'string';
        }
        if (isset($fields_rlist_session["citizenship_code"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_citizenship}")] = 'string';
        }
        if (isset($fields_rlist_session["country"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_country}")] = 'string';
        }
        if (isset($fields_rlist_session["city"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_city}")] = 'string';
        }
        if (isset($fields_rlist_session["address"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_street}")] = 'string';
        }
        if (isset($fields_rlist_session["addrbuilding"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_house}")] = 'string';
        }
        if (isset($fields_rlist_session["addrapt"])) {
            $fields_list[$this->mlanguages->getdictionaryword("reservation_guestedit", $prefix, "{caption_apartment}")] = 'string';
        }
        if (isset($fields_rlist_session["postcode"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_zip}")] = 'string';
        }
        if (isset($fields_rlist_session["doc_type"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_doc_type}")] = 'string';
        }
        if (isset($fields_rlist_session["doc_precode"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_doc_precode}")] = 'string';
        }
        if (isset($fields_rlist_session["passportid"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_passportid}")] = 'string';
        }
        if (isset($fields_rlist_session["doc_date_open"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_doc_date_open}")] = 'date';
        }
        if (isset($fields_rlist_session["doc_date_till"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_doc_date_till}")] = 'date';
        }
        if (isset($fields_rlist_session["passportissuedby"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_passportissuedby}")] = 'string';
        }
        if (isset($fields_rlist_session["scan"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_scan}")] = 'string';
        }
        if (isset($fields_rlist_session["reservations_count"])) {
            //echo "-----".$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_reservations_count}");

            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_reservations_count}")."2"] = 'string';
            //print_r($fields_list);
            //die();
        }
        if (isset($fields_rlist_session["amount"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_amount}")] = '#,##0.00';
        }
        if (isset($fields_rlist_session["balance"])) {
            $fields_list[$this->mlanguages->getdictionaryword("xlsmodel", $prefix, "{caption_balance}")] = '#,##0.00';
        }

        // $sql = $sql = "SELECT 1 as number, deskofreservation.guest_id, deskofreservation.intgroupid, groupreservations.name as group_name,
        // deskofreservation.id as reservation_id, CONCAT(rooms.name, ' (', categories.name, ')') as cat_room_name,
        // CONCAT(guests.lastname, ' ', guests.firstname) as guest_name, deskofreservation.adults as base_places,
        // deskofreservation.addbedplace as additional_places, deskofreservation.baby_places as baby_places,
        // dealers.name as istochnik, rate.caption as price_type, ".$status_table_name.".name as status_name,
        // deskofreservation.datein, deskofreservation.duration, deskofreservation.dateout, deskofreservation.amount, deskofreservation.discount,
        // SUM(IFNULL(payment.amount,0)) as pay_amount, deskofreservation.balance, deskofreservation.date, guests.phone, guests.email
        // FROM deskofreservation
        // INNER JOIN guests ON deskofreservation.guest_id=guests.id
        // INNER JOIN rooms ON rooms.id=deskofreservation.room_id
        // INNER JOIN categories ON categories.id=rooms.category_id
        // INNER JOIN ".$status_table_name." ON ".$status_table_name.".id = deskofreservation.status
        // LEFT JOIN dealers ON dealers.id = deskofreservation.id_dealer
        // LEFT JOIN payment ON payment.reservation_id = deskofreservation.id
        // LEFT JOIN groupreservations ON groupreservations.id = deskofreservation.intgroupid
        // LEFT JOIN rate ON rate.id = deskofreservation.price_type
        // $select
        // GROUP BY deskofreservation.id";

        $filename = "guestlist2.xlsx";
//         echo $main_rlist_sql;
//         echo "<pre>";
//         print_r($fields_list);
//         print_r($fields_rlist_session);
        //die();
        $this->xlsfactory_model->uploadxlsbyquery_c2($fields_list, $main_rlist_sql, $filename, $fields_rlist_session);
	}

	function uploadxls_listofreservation_guests() {
		//echo "<pre>";
		//print_r($_POST);
		//die();
		$prefix = $this->mlanguages->get_language_prefix();
		$status_table_name = "global_hotelix_languages.".$prefix."_statusofreservation";

		if (isset ( $_POST ['selected_reservation'] )) {

			$checkcontract = array ();

			$checkcontract = $_POST ['selected_reservation'];

			$len = count ( $checkcontract );
			$select = " WHERE deskofreservation.id IN (";
			for($i = 0; $i < $len; $i ++) {
				if($i < ($len-1)){
					$select .= $checkcontract [$i].",";
				}else{
					$select .= $checkcontract [$i].")";
				}

			}


		} else {
			$user = $this->session->userdata ( 'user' );
			$date_type = $this->session->userdata ( 'datetype' );
			$datein = $this->session->userdata ( 'datein' );
			$dateout = $this->session->userdata ( 'dateout' );
			$select = " WHERE deskofreservation.deleted=0 AND";
			if ($user != "") {
				$select .= " deskofreservation.id_user = '" . $user . "' AND";
			}
			if ($date_type != "") {
				switch ($date_type) {
					case "0" :
						if ($datein != "" and $dateout == "") {

							$select .= " deskofreservation.datein BETWEEN '" . $datein . " 00:00:00' AND '2054-01-01 23:59:59' AND";
						}
						if ($datein == "" and $dateout != "") {
							$select .= " deskofreservation.datein BETWEEN '2009-01-01 00:00:00' AND '" . $dateout . " 23:59:59' AND";
						}

						if ($datein != "" and $dateout != "") {
							$select .= " deskofreservation.datein BETWEEN '" . $datein . " 00:00:00' AND '" . $dateout . " 23:59:59' AND";
						}
						break;
					case "1" :
						if ($datein != "" and $dateout == "") {

							$select .= " deskofreservation.date BETWEEN '" . $datein . " 00:00:00' AND '2054-01-01 23:59:59' AND";
						}
						if ($datein == "" and $dateout != "") {
							$select .= " deskofreservation.date BETWEEN '2009-01-01 00:00:00' AND '" . $dateout . " 23:59:59' AND";
						}

						if ($datein != "" and $dateout != "") {
							$select .= " deskofreservation.date BETWEEN '" . $datein . " 00:00:00' AND '" . $dateout . " 23:59:59' AND";
						}
						break;
				}
			}

			if ($this->session->userdata ( 'dealers' ) != "") {
				$dealers = $this->session->userdata ( 'dealers' );
				$select .= " dealers.id = " . $dealers . " AND ";
			}
			if ($this->session->userdata ( 'room' ) != "") {
				$room = $this->session->userdata ( 'room' );
				$select .= " deskofreservation.room_id = " . $room . " AND ";
			}
			if ($this->session->userdata ( 'reservation_status' ) != "") {
				$reservation_status = $this->session->userdata ( 'reservation_status' );
				$select .= " deskofreservation.status = " . $reservation_status . " AND ";
			}

			if ($this->session->userdata ( 'category' ) != "") {
				$category = $this->session->userdata ( 'category' );
				$select .= " rooms.category_id = " . $category . " AND ";
			}
			$select .= " 1=1";
		}

				$fields_list = array (
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_order}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_guest}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_checkin}" ) => 'date',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_checkout}" ) => 'date',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_country}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_pob_city}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_dob}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_passportid}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_doc_precode}" ) => 'string',

				);




				$sql = "SELECT deskofreservation.id, CONCAT(guests.firstname, ' ', guests.lastname) as guestname,
				deskofreservation.datein, deskofreservation.dateout, guests.country, guests.pob_city, guests.dob,
				if(guests.passportid = 0, '', guests.passportid) as pass_id, guests.doc_precode
				FROM deskofreservation
				INNER JOIN guests ON deskofreservation.guest_id=guests.id
				LEFT JOIN users ON deskofreservation.id_user=users.id
				INNER JOIN rooms ON rooms.id=deskofreservation.room_id
				INNER JOIN categories ON categories.id=rooms.category_id
				LEFT JOIN " . $status_table_name . " ON " . $status_table_name . ".id = deskofreservation.status
					LEFT JOIN payment ON payment.reservation_id=deskofreservation.id
					LEFT JOIN discount ON discount.reservation_id=deskofreservation.id
					$select
					GROUP BY deskofreservation.guest_id
					UNION
					SELECT deskofreservation.id, CONCAT(guests.firstname, ' ', guests.lastname) as guestname,
					deskofreservation.datein, deskofreservation.dateout, guests.country, guests.pob_city, guests.dob,
					if(guests.passportid = 0, '', guests.passportid) as pass_id, guests.doc_precode
					FROM deskofreservation
					INNER JOIN guests_deskofreservation ON deskofreservation.id = guests_deskofreservation.reservation_id
					INNER JOIN guests ON guests_deskofreservation.guest_id=guests.id
					LEFT JOIN users ON deskofreservation.id_user=users.id
					INNER JOIN rooms ON rooms.id=deskofreservation.room_id
					INNER JOIN categories ON categories.id=rooms.category_id
					LEFT JOIN " . $status_table_name . " ON " . $status_table_name . ".id = deskofreservation.status
					LEFT JOIN payment ON payment.reservation_id=deskofreservation.id
					LEFT JOIN discount ON discount.reservation_id=deskofreservation.id
					$select
					GROUP BY deskofreservation.guest_id";
					//echo $sql;
					//die();
		$filename = "listofguest.xlsx";
				//die();
				$this->xlsfactory_model->uploadxlsbyquery ( $fields_list, $sql, $filename );
	}
	function uploadxls_reservationtodaylist() {
		if ($this->session->userdata ( 'date' ) != "") {
			$date = $this->session->userdata ( 'date' );
		} else {
			$date = date ( "Y-m-d" );
		}
		$session_state = $this->session->userdata ( 'state_map' );

		$prefix = $this->mlanguages->get_language_prefix();

		$fields_list = array (
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_order}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_guest}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_room}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_status}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_state}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_sum}" ) => '#,##0.00',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_balance}" ) => '#,##0.00',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_checkin}" ) => 'date',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_days}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_checkout}" ) => 'date'
		);

		$array = array();
		$i = 0;
		if ($_SESSION["reservationtodayList_sql"] <> '') {
			$sum_amount = 0;
			$sum_balance = 0;
			$sql = $_SESSION["reservationtodayList_sql"];
			 //echo $sql;
			 //die();
			$query = $this->db->query ( $sql );
			foreach ( $query->result () as $row ) {
				if ($date != "") {
					$today = $date;
				} else {
					$today = date ( "Y-m-d" );
				}
				list ( $year, $month, $day ) = explode ( "-", $today );
				$todate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
				list ( $year_in, $month_in, $day_in ) = explode ( "-", $row->datein );
				$indate = round ( gmmktime ( 0, 0, 0, $month_in, $day_in, $year_in ) / 86400 );
				list ( $year_out, $month_out, $day_out ) = explode ( "-", $row->dateout );
				$outdate = round ( gmmktime ( 0, 0, 0, $month_out, $day_out, $year_out ) / 86400 );
				$state = "";

				if ($todate == $indate) {
					$state = "Заезд";
					$state_int = 0;
				}
				if ($todate == $outdate) {
					$state = "Выезд";
					$state_int = 1;
				}
				if ($todate > $indate and $todate < $outdate) {
					$state = "Проживание";
					$state_int = 2;
				}
				$amount = $row->smtotal;
				if ($session_state != "") {
					if ($session_state == $state_int) {
						$array [$i] ["id"] = $row->reservation_id;
						$array [$i] ["guestname"] = $row->guestname;
						$array [$i] ["roomname"] = $row->roomname;
						$array [$i] ["status_name"] = $row->status_name;
						$array [$i] ["state"] = $state;
						$array [$i] ["amount"] = $row->amount;
						$array [$i] ["balance"] = $row->balance;
						$array [$i] ["datein"] = $row->datein;
						$array [$i] ["duration"] = $row->duration;
						$array [$i] ["dateout"] = $row->dateout;
						$i ++;
						$sum_amount += $amount;
						$sum_balance += $row->balance;
					}
				} else {
					$array [$i] ["id"] = $row->reservation_id;
					$array [$i] ["guestname"] = $row->guestname;
					$array [$i] ["roomname"] = $row->roomname;
					$array [$i] ["status_name"] = $row->status_name;
					$array [$i] ["state"] = $state;
					$array [$i] ["amount"] = $row->amount;
					$array [$i] ["balance"] = $row->balance;
					$array [$i] ["datein"] = $row->datein;
					$array [$i] ["duration"] = $row->duration;
					$array [$i] ["dateout"] = $row->dateout;
					$i ++;
					$sum_amount += $amount;
					$sum_balance += $row->balance;
				}
			}
		}
		$array [$i] ["id"] = "";
		$array [$i] ["guestname"] = "";
		$array [$i] ["roomname"] = "";
		$array [$i] ["status_name"] = "";
		$array [$i] ["state"] = "";
		$array [$i] ["amount"] = $sum_amount;
		$array [$i] ["balance"] = $sum_balance;
		$array [$i] ["datein"] = "";
		$array [$i] ["duration"] = "";
		$array [$i] ["dateout"] = "";
		// echo "<pre>";
		// print_r($fields_list);
		// print_r($array);
		// die();
		$filename = "reservationotodaylist.xlsx";

		$this->xlsfactory_model->uploadxlsbyarray ( $fields_list, $array, $filename );
	}
	function uploadxls_reservationtodaylist_OLD() {
		$prefix = $this->mlanguages->get_language_prefix();
		$status_table_name = "global_hotelix_languages.".$prefix."_statusofreservation";
		if ($this->session->userdata ( 'date' ) != "") {
			$date = $this->session->userdata ( 'date' );
		} else {
			$date = date ( "Y-m-d" );
		}
		if ($date != "") {
			$today = $date;
		} else {
			$today = date ( "Y-m-d" );
		}
		list ( $year, $month, $day ) = explode ( "-", $today );
		$todate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		if (isset ( $_POST ['selected_reservation'] )) {

			$checkcontract = array ();

			$checkcontract = $_POST ['selected_reservation'];

			$len = count ( $checkcontract );
			$select = " WHERE deskofreservation.id IN (";
			for($i = 0; $i < $len; $i ++) {
				if($i < ($len-1)){
					$select .= $checkcontract [$i].",";
				}else{
					$select .= $checkcontract [$i].")";
				}

			}


		} else {
			$sort_room = $this->session->userdata ( 'sort_room' );
			$sort_datein = $this->session->userdata ( 'sort_datein' );
			$sort_dateout = $this->session->userdata ( 'sort_dateout' );
			if ($this->session->userdata ( 'date' ) != "") {
				$date = $this->session->userdata ( 'date' );
				$search_date = $this->session->userdata ( 'date' );
			} else {
				$date = date ( "Y-m-d" );
				$search_date = date ( "Y-m-d" );
			}
			$search = $this->session->userdata ( 'search' );
			$category = $this->session->userdata ( 'category' );
			$room = $this->session->userdata ( 'room' );
			$dealer = $this->session->userdata ( 'reservation_dealers' );
			$session_state = $this->session->userdata ( 'state_map' );
			$reservation_status = $this->session->userdata ( 'reservation_status' );

			$select_sort = "";
			if ($sort_room != "" or $sort_datein != "" or $sort_dateout != "") {
				switch ($sort_room) {
					case "11" :
						$select_sort = "ORDER by rooms.id ASC";

						break;
					case "12" :
						echo "+++";
						$select_sort = "ORDER by rooms.id DESC";

						break;
					default :

						break;
				}
				switch ($sort_datein) {

					case "21" :
						$select_sort = "ORDER by deskofreservation.datein ASC";

						break;
					case "22" :
						$select_sort = "ORDER by deskofreservation.datein DESC";

						break;
					default :

						break;
				}
				switch ($sort_dateout) {
					case "31" :
						$select_sort = "ORDER by deskofreservation.dateout ASC";

						break;
					case "32" :
						$select_sort = "ORDER by deskofreservation.dateout DESC";

						break;
					default :

						break;
				}
			} else {
				$select_sort = "ORDER by deskofreservation.id DESC";

			}
			echo $select_sort;
			$select = "";
			// if (isset ($_POST)){
			$select .= " WHERE ";
			if ($search != "") {
				if ($_POST ["search"] != "") {
					$select .= "(guests.firstname LIKE '%" . $_POST ["search"] . "%' OR guests.lastname LIKE '%" . $_POST ["search"] . "%') AND";
				}
			}
			if ($date != "") {

				$select .= " (deskofreservation.datein <= '" . $date . "' AND";
				$select .= " deskofreservation.dateout >= '" . $date . "') AND";
			}

			if ($dealer != "") {
				if ($dealer == 'all_dealers') {
					$select .= " deskofreservation.id_dealer <> 0 AND";
				} else {
					$select .= " deskofreservation.id_dealer = " . $dealer . " AND";
				}
			}

			if ($category != "") {
				$select .= " rooms.category_id = '" . $category . "' AND";
			}
			if ($room != "") {
				$select .= " rooms.id = '" . $room . "' AND";
			}
			$select .= " deskofreservation.deleted=0 AND deskofreservation.cancel=0";
		}

		$fields_list = array (
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_order}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_guest}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_room}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_status}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_state}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_sum}" ) => '#,##0.00',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_balance}" ) => '#,##0.00',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_checkin}" ) => 'date',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_days}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_checkout}" ) => 'date'
		);

		$array = array();
		$i = 0;
		$sql = "SELECT  deskofreservation.id, CONCAT(guests.firstname, ' ', guests.lastname) as guestname, CONCAT(rooms.name, ' | ', categories.name) as roomname,
				" . $status_table_name . ".name as status_name,  deskofreservation.amount, deskofreservation.balance,
				deskofreservation.datein, deskofreservation.duration, deskofreservation.dateout
				FROM deskofreservation
				INNER JOIN guests ON deskofreservation.guest_id=guests.id
				LEFT JOIN users ON deskofreservation.id_user=users.id
				LEFT JOIN rooms ON rooms.id=deskofreservation.room_id
				LEFT JOIN categories ON categories.id=rooms.category_id
				LEFT JOIN " . $status_table_name . " ON " . $status_table_name . ".id = deskofreservation.status
				LEFT JOIN payment ON payment.reservation_id=deskofreservation.id

				LEFT JOIN discount ON discount.reservation_id=deskofreservation.id
				LEFT JOIN rate ON deskofreservation.price_type = rate.id
				LEFT JOIN fms_records ON deskofreservation.id = fms_records.reservation_id AND guests.id = fms_records.guest_id
				" . $select . " GROUP BY deskofreservation.id " . $select_sort;
		//echo $sql;
		//die();
		$query = $this->db->query ( $sql );
		foreach ( $query->result () as $row ) {
			list ( $year_in, $month_in, $day_in ) = explode ( "-", $row->datein );
			$indate = round ( gmmktime ( 0, 0, 0, $month_in, $day_in, $year_in ) / 86400 );
			list ( $year_out, $month_out, $day_out ) = explode ( "-", $row->dateout );
			$outdate = round ( gmmktime ( 0, 0, 0, $month_out, $day_out, $year_out ) / 86400 );
			$state = "";

			if ($todate == $indate) {
				$state = "Заезд";
			}
			if ($todate == $outdate) {
				$state = "Выезд";
			}
			if ($todate > $indate and $todate < $outdate) {
				$state = "Проживание";
			}

			$array [$i]["id"] = $row->id;
			$array [$i]["guestname"] = $row->guestname;
			$array [$i]["roomname"] = $row->roomname;
			$array [$i]["status_name"] = $row->status_name;
			$array [$i]["state"] = $state;
			$array [$i]["amount"] = $row->amount;
			$array [$i]["balance"] = $row->balance;
			$array [$i]["datein"] = $row->datein;
			$array [$i]["duration"] = $row->duration;
			$array [$i]["dateout"] = $row->dateout;
			$i++;

		}
		//echo "<pre>";
		//print_r($fields_list);
		//print_r($array);
		//die();
		$filename = "reservationotodaylist.xlsx";

		$this->xlsfactory_model->uploadxlsbyarray ( $fields_list, $array, $filename );
	}
	function uploadxls_loading() {
		$prefix = $this->mlanguages->get_language_prefix();
		if ($this->session->userdata ( 'datein_loading' ) != "") {
			$datein = $this->session->userdata ( 'datein_loading' );
			$dateout = $this->session->userdata ( 'dateout_loading' );
		} else {
			$datein = date ( "Y-m-d", mktime ( 0, 0, 0, date ( "m" ), 1, date ( "Y" ) ) );
			$dateout = date ( "Y-m-d", mktime ( 0, 0, 0, date ( "m" ), date ( "t" ), date ( "Y" ) ) );
		}

		list ( $year, $month, $day ) = explode ( "-", $datein );
		$intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		list ( $year, $month, $day ) = explode ( "-", $dateout );
		$intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );

		$intdateout_2 = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		$duration = $intdateout_2 + 1 - $intdatein;

		$overbooking_category_id = 0;
		$query = $this->db->query ( "SELECT value FROM hotelix_config WHERE name LIKE 'overbooking_category_id'" );

		if ($query->num_rows () > 0) {
			$row = $query->row ();

			$overbooking_category_id = $row->value;
		}

		$categories = array ();
		$sql = "SELECT categories.name, categories.id, count(rooms.id) as room_count FROM categories
		INNER JOIN rooms ON rooms.category_id = categories.id
		WHERE categories.is_active = 1 AND categories.id <> $overbooking_category_id GROUP BY categories.id";
		$query = $this->db->query ( $sql );

		if ($query->num_rows () > 0) {
			foreach ( $query->result_array () as $row ) {
				$categories [$row ["id"]] ["id"] = $row ["id"];
				$categories [$row ["id"]] ["name"] = $row ["name"];
				$categories [$row ["id"]] ["room_count"] = $row ["room_count"];
			}
		}

		$categories_reservation = array ();
		$sql = "SELECT categories.name, categories.id, count(deskofdays.id) as deskofdays_count FROM categories
		INNER JOIN rooms ON rooms.category_id = categories.id
		INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
		WHERE categories.is_active = 1 AND deskofdays.intdate >= $intdatein AND deskofdays.intdate <= $intdateout AND categories.id <> $overbooking_category_id
		GROUP BY categories.id";
		$query = $this->db->query ( $sql );

		if ($query->num_rows () > 0) {
			foreach ( $query->result_array () as $row ) {
				$categories_reservation [$row ["id"]] ["name"] = $row ["name"];
				$categories_reservation [$row ["id"]] ["deskofdays_count"] = $row ["deskofdays_count"];
			}
		}

		$loading_mass = array ();
		$all_rooms_days_c = 0;
		$all_deskofdays_count = 0;
		foreach ( $categories as $cell ) {
			$all_rooms_days = $cell ["room_count"] * $duration;
			$all_rooms_days_c += $all_rooms_days;
			// $temp = $all_rooms_days - $categories_reservation[$cell["id"]];
			$percent_count = $all_rooms_days / 100;
			$loading_nights_reserved = 0;
			if (isset ( $categories_reservation [$cell ["id"]] ["deskofdays_count"] )) {
				$loading_nights_reserved = $categories_reservation [$cell ["id"]] ["deskofdays_count"];
				$all_deskofdays_count += $categories_reservation [$cell ["id"]] ["deskofdays_count"];
				$loading = floor ( $categories_reservation [$cell ["id"]] ["deskofdays_count"] / $percent_count );
			} else {
				$loading = 0;
			}
			$categories [$cell ["id"]] ["loading"] = $loading;
			$categories [$cell ["id"]] ["loading_nights"] = $all_rooms_days;
			$categories [$cell ["id"]] ["loading_nights_reserved"] = $loading_nights_reserved;
			// $loading_mass
		}

		// ==============================================================================================================
		// ==============================================================================================================
		// ==============================================================================================================

		$categories_reservation_today = array ();
		$sql = "SELECT categories.name, categories.id, deskofdays.intdate, count(deskofdays.id) as deskofdays_count FROM categories
		INNER JOIN rooms ON rooms.category_id = categories.id
		INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
		WHERE categories.is_active = 1 AND deskofdays.intdate >= $intdatein AND deskofdays.intdate <= $intdateout AND categories.id <> $overbooking_category_id
		GROUP BY categories.id, deskofdays.intdate";
		// echo $sql;
		$query = $this->db->query ( $sql );

		if ($query->num_rows () > 0) {
			foreach ( $query->result_array () as $row ) {
				$categories_reservation_today [$row ["id"]] [$row ["intdate"]] ["deskofdays_count"] = $row ["deskofdays_count"];
			}
		}
		//echo "<pre>";
		//print_r ( $categories_reservation_today );

		 //die();
		$k = 0;
		$array = array();
		$array_2 = array();
		//$categories_today = array();
		$loading_mass = array ();
		$all_rooms_days_c = 0;
		$all_deskofdays_count = 0;

		for($i = $intdatein; $i <= $intdateout; $i ++) {
			$array [$k] ["date"] = date ( "Y-m-d", $i * 86400 );
			foreach ( $categories as $cell ) {
				$all_rooms_days = $cell ["room_count"];
				$all_rooms_days_c += $all_rooms_days;
				$percent_count = $all_rooms_days / 100;
				$loading_nights_reserved = 0;
				if (isset ( $categories_reservation_today [$cell ["id"]] [$i] ["deskofdays_count"] )) {
					$loading_nights_reserved = $categories_reservation_today [$cell ["id"]] [$i] ["deskofdays_count"];
					$all_deskofdays_count += $categories_reservation_today [$cell ["id"]] [$i] ["deskofdays_count"];
					$loading = floor ( $categories_reservation_today [$cell ["id"]] [$i] ["deskofdays_count"] / $percent_count );
				} else {
					$loading = 0;
				}

				$array [$k] [$cell ["id"]] = $loading;

			}
			$k++;
		}


		$percent_count_all = $all_rooms_days_c / 100;
		$all_loading = floor ( $all_deskofdays_count / $percent_count_all );
		$all_loading_nights = $all_rooms_days_c;
		$all_loading_nights_reserved = $all_deskofdays_count;

		$k = 0;
		foreach ( $categories as $cell ) {
			$array_2 [$k]["name"] = $cell["name"];
			$array_2 [$k]["loading_nights"] = $cell["loading_nights"];
			$array_2 [$k]["loading_nights_reserved"] = $cell["loading_nights_reserved"];
			$array_2 [$k]["loading"] = $cell["loading"];
			$k++;
		}
		$array_2 [$k]["name"] = $this->mlanguages->getdictionaryword ( "reservations_loading", $prefix, "{caption_total}" );
		$array_2 [$k]["loading_nights"] = $all_loading_nights;
		$array_2 [$k]["loading_nights_reserved"] = $all_loading_nights_reserved;
		$array_2 [$k]["loading"] = $all_loading;

		$fields_list = array(
				 $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_day_by_category}" ) => 'date'

		);
		foreach ( $categories as $cell ) {
			$fields_list[$cell["name"]] = 'string';
		}


		$fields_list_2 = array(
				$this->mlanguages->getdictionaryword ( "reservations_loading", $prefix, "{caption_category}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "reservations_loading", $prefix, "{caption_total_nights}" ) => 'integer',
				$this->mlanguages->getdictionaryword ( "reservations_loading", $prefix, "{caption_nights_occupied}" ) => 'integer',
				'%' => 'integer'

		);
		$filename = "loading.xlsx";

		$this->xlsfactory_model->uploadxlsbydoublearray ($fields_list, $array, $fields_list_2, $array_2, $filename, "total", "details");
	}

	function uploadxls_payments_services(){
		$prefix = $this->mlanguages->get_language_prefix();
		$i = 0;
		$query = $this->db->query ( "SELECT id, name FROM services_types" );
		foreach ( $query->result () as $row ) {
			$services [$i] ["id"] = $row->id;
			$services [$i] ["name"] = $row->name;
			$i ++;
		}
		if (isset ( $_POST ['selected_payment'] )) {

			$checkcontract = array ();

			$checkcontract = $_POST ['selected_payment'];

			$len = count ( $checkcontract );
			$select = " services.id IN (";
			for($i = 0; $i < $len; $i ++) {
				if($i < ($len-1)){
					$select .= $checkcontract [$i].",";
				}else{
					$select .= $checkcontract [$i].") AND ";
				}

			}
			$count = count ( $services );
			if($count > 0){
				$select .= "( ";
				for($i = 0; $i < $count; $i ++) {
					if ($i <> $count - 1) {
						$select .= " services.type = " . $services [$i] ["id"] . " OR";
					} else {
						$select .= " services.type = " . $services [$i] ["id"] . " ) AND ";
					}
				}
			}

			$select_sort_s = "";
		} else {
			$sort_service_datein = $this->session->userdata ( 'sort_service_datein' );
			$sort_service_date = $this->session->userdata ( 'sort_service_date' );
			$sort_service_due_time = $this->session->userdata ( 'sort_service_due_time' );
			$datein = $this->session->userdata ( 'datein_pay' );
			$dateout = $this->session->userdata ( 'dateout_pay' );
			$search_datein = $this->session->userdata ( 'datein_pay' );
			$search_dateout = $this->session->userdata ( 'dateout_pay' );
			$search_type = $this->session->userdata ( 'type2_service' );
			$search_payment_type = $this->session->userdata ( 'payment_type' );
			$dealer = $this->session->userdata ( 'dealers' );
			$category = $this->session->userdata ( 'category' );
			$room = $this->session->userdata ( 'room' );
			$reservation_status = $this->session->userdata ( 'reservation_status' );

			$select_sort = "";
			if ($sort_service_datein != "" or $sort_service_date != "" or $sort_service_due_time != "") {
				switch ($sort_service_datein) {
					case "21" :
						$select_sort_s = "ORDER by deskofreservation.datein ASC";
						$select_sort_smain = "ORDER by deskofreservation.datein ASC";

						break;
					case "22" :
						$select_sort_s = "ORDER by deskofreservation.datein DESC";
						$select_sort_smain = "ORDER by deskofreservation.datein DESC";

						break;

				}
				switch ($sort_service_date) {
					case "11" :
						$select_sort_s = "ORDER by services.time ASC";
						$select_sort_smain = "ORDER by services_main.time ASC";

						break;
					case "12" :
						$select_sort_s = "ORDER by services.time DESC";
						$select_sort_smain = "ORDER by services_main.time DESC";

						break;

				}
				switch ($sort_service_due_time) {
					case "31" :
						$select_sort_s = "ORDER by services.action_time ASC";

						break;
					case "32" :
						$select_sort_s = "ORDER by services.action_time DESC";

						break;

				}
			} else {
				$select_sort_s = "ORDER by deskofreservation.id DESC";
				$select_sort_smain = "ORDER by deskofreservation.id DESC";

			}



			$select = "";

			if ($this->session->userdata ( 'type2_service' ) == "") {
				for($i = 0; $i < count ( $services ); $i ++) {

					if ($select == "") {
						$select .= "( services.type = " . $services [$i] ["id"] . " OR";
					} else {
						$select .= " services.type = " . $services [$i] ["id"] . " OR";
					}
				}
			} else {
				for($i = 0; $i < count ( $services ); $i ++) {
					$bool = 0;
					for($j = 0; $j < count ( $search_type ); $j ++) {
						if ($services [$i] ["id"] == $search_type [$j]) {

							if ($select == "") {
								$select .= "( services.type = " . $services [$i] ["id"] . " OR";
							} else {
								$select .= " services.type = " . $services [$i] ["id"] . " OR";
							}
							$bool = 1;
						}

						if ($bool == 1) {
							break;
						}
					}

				}
			}
			$select = substr_replace ( $select, "", strlen ( $select ) - 2, 2 );
			if ($select != "")
				$select .= ") AND";


			if ($category != "") {
				$select .= " categories.id = $category AND";
			}
			if ($dealer != '') {
				$select .= " services.id_dealer=$dealer AND";
			}

			if ($reservation_status != "") {
				$select .= " deskofreservation.status = $reservation_status AND";
			}
			if ($room != "") {
				$select .= " rooms.id = '" . $room . "' AND";
			}

			if ($datein != "") {
				$select .= " deskofreservation.datein BETWEEN '" . $datein . "' AND '" . $dateout . "' AND";
			}
		}

		$fields_list = array (
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_order}" ) => 'string',
				 "Услуга" => 'string',
				"Кво"  => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_createdate}" ) => 'datetime',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_guest}" ) => 'string',
				 "Тип"  => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_room}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_checkin}" ) => 'date',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_checkout}" ) => 'date',
				"Сума" => '#,##0.00'
		);

		$sql = "SELECT deskofreservation.id as res_id, services.id as services_id, services.count as services_count, services.action_time as services_action_time,
		CONCAT(guests.lastname, ' ', guests.firstname) as guestname, services_types.name, CONCAT(rooms.name, ' | ', categories.shortname) as room,
		 deskofreservation.datein, deskofreservation.dateout, services.amount as services_total
		 FROM services
	INNER JOIN services_types ON services_types.id = services.type
	INNER JOIN deskofreservation ON deskofreservation.id=services.reservation_id
	INNER JOIN rooms ON rooms.id=deskofreservation.room_id INNER JOIN categories ON categories.id=rooms.category_id
	INNER JOIN guests ON guests.id = deskofreservation.guest_id
	WHERE $select deskofreservation.deleted=0 $select_sort_s";
		//echo $sql;
		//die();
		$filename = "paymentservices_list.xlsx";
		$array = array();
		$this->xlsfactory_model->uploadxlsbysqlarray ( $fields_list, $sql, $array, $filename );
	}


	function uploadxls_paymentlistdate_c2() {
	    // 		echo "<pre>";
	    // 		print_r($_POST);
	    // 		print_r($_SESSION);
	    // 		die();
	    $prefix = $this->mlanguages->get_language_prefix();

	    $array = array();
	    $total_amount = 0;
	    $total_balance = 0;

	    if(isset($_POST["selected_payment"])){
	        $count_selected_pays = count($_POST["selected_payment"]);
	        if($count_selected_pays > 0){
	            //echo "+++++";
	            $select_payment = " payment.id IN (";
	            $p = 1;
	            foreach($_POST["selected_payment"] as $pay_id){
	                if($p == $count_selected_pays){
	                    $select_payment .= $pay_id.")";
	                }else{
	                    $select_payment .= $pay_id.",";
	                }
	                $p++;
	            }
	            $sql_selected_pays = "SELECT 1 as payment_type, guests.firstname, guests.lastname, guests.phone, users.fullname as user_firstname, users.lastname as user_lastname,
				dealers.name as dealer_name, deskofreservation.balance,deskofreservation.datein,
				deskofreservation.discount, deskofreservation.dateout, deskofreservation.duration, deskofreservation.id as res_id, payment.confirm_time, payment.confirm_userid,
				payment.id as pay_id, payment_types.name as payment_name, payment.create_time, payment.amount as pay_total, payment.isclosed as pay_isclosed,
				rooms.name as room_name, categories.shortname as categories_name, payment.operationtime
                FROM payment
				INNER JOIN deskofreservation ON deskofreservation.id = payment.reservation_id
				INNER JOIN rooms ON rooms.id=deskofreservation.room_id
				INNER JOIN categories ON categories.id=rooms.category_id
				LEFT JOIN users ON users.id = payment.id_user
				INNER JOIN dealers ON dealers.id=deskofreservation.id_dealer
				INNER JOIN guests ON guests.id = deskofreservation.guest_id
				INNER JOIN payment_types ON payment_types.id = payment.type
				WHERE ".$select_payment;


	        }
	    }

	    if(isset($_POST["selected_refund"])){
	        if(count($_POST["selected_refund"]) > 0){

	        }
	    }

	    if (isset($_SESSION["paymentlistdate_payments_sql"])) {
            if ($_SESSION["paymentlistdate_payments_sql"] != '') {
                if (isset($sql_selected_pays)) {
                    $sql = $sql_selected_pays;
                } else {
                    $sql = $_SESSION["paymentlistdate_payments_sql"];
                }
                // echo $sql;
                // die();

                $query = $this->db->query($sql);
                foreach ($query->result() as $row) {
                    switch ($row->payment_type) {
                        case 1:
                            $payment_type = $this->mlanguages->getdictionaryword("mlw", $prefix, "{mlw_Payment}");
                            break;
                        case 2:
                            $payment_type = $this->mlanguages->getdictionaryword("mlw", $prefix, "{mlw_refund}");
                            break;
                        default:
                            $payment_type = $this->mlanguages->getdictionaryword("mlw", $prefix, "{mlw_Payment}");
                            break;
                    }

                    if (isset($row->pay_isclosed)) {
                        if ($row->pay_isclosed == 0) {
                            $isclosed_str = $this->mlanguages->getdictionaryword("mlw", $prefix, "{mlw_notapproved}");
                        } else {
                            $isclosed_str = $this->mlanguages->getdictionaryword("mlw", $prefix, "{mlw_approved}");
                        }
                    }

                    if (isset($row->refund_isclosed)) {
                        if ($row->refund_isclosed == 0) {
                            $isclosed_str = "{mlw_notapproved}";
                        } else {
                            $isclosed_str = "{mlw_approved}";
                        }
                    }


                    $confirm_user = "";
                    if (isset($row->confirm_userid)) {
                        $sql = "SELECT fullname, lastname FROM users WHERE id = " . $row->confirm_userid;
                        // echo $sql;

                        $query2 = $this->db->query($sql);
                        if ($query2->num_rows() != 0) {
                            $row2 = $query2->row();
                            $confirm_user = $row2->fullname . " " . $row2->lastname;
                        }
                    }

                    $confirm_time = "";
                    if (isset($row->confirm_time)) {
                        if ($row->confirm_time === "0000-00-00 00:00:00") {
                            $confirm_time = "";
                        } else {
                            $confirm_time = $row->confirm_time;
                        }
                    }

	                array_push ( $array, array (
	                    'pay_id' => $row->pay_id,
	                    'res_id' => $row->res_id,
	                    'firstname' => $row->firstname." ".$row->lastname,
	                    'datein' => $row->datein,
	                    'create_time' => $row->create_time != 0 ? $row->create_time : '',
	                    'user' => $row->user_firstname." ".$row->user_lastname,
	                    'payment_type' => $payment_type,
	                    'name' => $row->payment_name,
	                    'isclosed_str' => $isclosed_str,
	                    'confirm_user' => $confirm_user,
	                    'confirm_time' => $confirm_time,
	                    //'lastname' => $row->lastname,
// 	                    'room_name' => $row->room_name,
// 	                    'categories_name' => $row->categories_name,

// 	                    'dateout' => $row->dateout,
	                    // 'dealer_name' => $row->dealer_name,
	                    //'duration' => $row->duration,
	                    //'operationtime' => $row->operationtime != 0 ?  $row->operationtime : '',
	                    //'operationtime' => $row->operationtime,

	                    //'create_time' => $row->create_time,



// 	                    'services_main_amount' => $row->services_main_amount,
// 	                    'discount' => $row->discount,
// 	                    'balance' => $row->balance,
	                    'pay_total' => $row->pay_total
	                ) );
	                $total_amount += $row->pay_total;
	                $total_balance += $row->balance;
	            }
	            array_push ( $array,array('','','','','','','','','','','', $total_amount));
	        }
	    }

	    $fields_list = array (
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_payment}" ) => 'string',
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_order}" ) => 'string',
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_guest}" ) => 'string',
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_checkin}" ) => 'date',
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_operationtime}" ) => 'date',
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_username}" ) => 'string',
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_operationtype}" ) => 'string',
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_type}" ) => 'string',
	        $this->mlanguages->getdictionaryword ( "payment_paymentlistdate", $prefix, "{caption_state}" ) => 'string',
	        $this->mlanguages->getdictionaryword ( "payment_paymentlistdate", $prefix, "{caption_assignedto}" )."2" => 'string',
	        $this->mlanguages->getdictionaryword ( "payment_paymentlistdate", $prefix, "{caption_create_time}" ) => 'string',
	        // 				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_checkin}" ) => 'date',
	    // 				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_checkout}" ) => 'date',
	        //$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_dealer}" ) => 'string',
	    // 				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_days}" ) => 'string',

	    // 				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_createdate}" ) => 'datetime',//'YYYY-MM-DD h:mm:ss',



	    // 				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_accommodation}" ) => '#,##0.00',
	    // 				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_accommodation_discount}" ) => '#,##0.00',
	    // 				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_balance}" ) => '#,##0.00',
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_sum}" ) => '#,##0.00',

	    );
// 	    echo "<pre>";
// 	    print_r($fields_list);
// 	    print_r($array);
// 	    die();
	    $filename = "paymentlistdate.xlsx";

	    $this->xlsfactory_model->uploadxlsbyarray ( $fields_list, $array, $filename );
	}

	function uploadxls_paymentlistdate() {
// 		echo "<pre>";
// 		print_r($_POST);
// 		print_r($_SESSION);
// 		die();
		$prefix = $this->mlanguages->get_language_prefix();

		$array = array();
		$total_amount = 0;
		$total_balance = 0;

		if(isset($_POST["selected_payment"])){
			$count_selected_pays = count($_POST["selected_payment"]);
			if($count_selected_pays > 0){
				//echo "+++++";
				$select_payment = " payment.id IN (";
				$p = 1;
				foreach($_POST["selected_payment"] as $pay_id){
					if($p == $count_selected_pays){
						$select_payment .= $pay_id.")";
					}else{
						$select_payment .= $pay_id.",";
					}
					$p++;
				}
				$sql_selected_pays = "SELECT 1 as payment_type, guests.firstname, guests.lastname, guests.phone, users.fullname as user_firstname, users.lastname as user_lastname,
				services_main.amount as services_main_amount, dealers.name as dealer_name, deskofreservation.balance,deskofreservation.datein,
				deskofreservation.discount, deskofreservation.dateout, deskofreservation.duration, deskofreservation.id as res_id, payment.confirm_time, payment.confirm_userid,
				payment.id as pay_id, payment_types.name as payment_name, payment.create_time, payment.amount as pay_total, payment.isclosed as pay_isclosed,
				rooms.name as room_name, categories.shortname as categories_name, payment.operationtime FROM payment
				INNER JOIN deskofreservation ON deskofreservation.id = payment.reservation_id
				INNER JOIN rooms ON rooms.id=deskofreservation.room_id
				INNER JOIN categories ON categories.id=rooms.category_id
				LEFT JOIN users ON users.id = payment.id_user
				LEFT JOIN services_main ON services_main.reservation_id=deskofreservation.id
				INNER JOIN dealers ON dealers.id=deskofreservation.id_dealer
				INNER JOIN guests ON guests.id = deskofreservation.guest_id
				INNER JOIN payment_types ON payment_types.id = payment.type
				WHERE ".$select_payment;


			}
		}

		if(isset($_POST["selected_refund"])){
			if(count($_POST["selected_refund"]) > 0){

			}
		}

		if (isset ( $_SESSION ["paymentlistdate_payments_sql"] )) {
			if ($_SESSION ["paymentlistdate_payments_sql"] != '') {
				if(isset($sql_selected_pays)){
					$sql = $sql_selected_pays;
				}else{
					$sql = $_SESSION ["paymentlistdate_payments_sql"];
				}
				// echo $sql;
				// die();

				$query = $this->db->query ( $sql );
				foreach ( $query->result () as $row ) {
					switch ($row->payment_type) {
						case 1 :
							$payment_type = $this->mlanguages->getdictionaryword ( "mlw", $prefix, "{mlw_Payment}" );
							break;
						case 2 :
							$payment_type = $this->mlanguages->getdictionaryword ( "mlw", $prefix, "{mlw_refund}" );
							break;
						default :
							$payment_type = $this->mlanguages->getdictionaryword ( "mlw", $prefix, "{mlw_Payment}" );
							break;
					}
					array_push ( $array, array (
							'pay_id' => $row->pay_id,
							'res_id' => $row->res_id,
							'firstname' => $row->firstname,
							'lastname' => $row->lastname,
							'room_name' => $row->room_name,
							'categories_name' => $row->categories_name,
							'datein' => $row->datein,
							'dateout' => $row->dateout,
							// 'dealer_name' => $row->dealer_name,
							'duration' => $row->duration,
							'operationtime' => $row->operationtime != 0 ?  $row->operationtime : '',
							//'operationtime' => $row->operationtime,
					        'create_time' => $row->create_time != 0 ? $row->create_time : '',
							//'create_time' => $row->create_time,
							'user' => $row->user_firstname." ".$row->user_lastname,
							'payment_type' => $payment_type,
							'name' => $row->payment_name,
							'services_main_amount' => $row->services_main_amount,
							'discount' => $row->discount,
							'balance' => $row->balance,
							'pay_total' => $row->pay_total
					) );
					$total_amount += $row->pay_total;
					$total_balance += $row->balance;
				}
				array_push ( $array,array('','','','','','','','','','','','','','','','', $total_balance, $total_amount));
			}
		}

		$fields_list = array (
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_payment}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_order}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_name}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_surname}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_room}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_category}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_checkin}" ) => 'date',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_checkout}" ) => 'date',
				//$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_dealer}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_days}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_operationtime}" ) => 'date',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_createdate}" ) => 'datetime',//'YYYY-MM-DD h:mm:ss',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_username}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_operationtype}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_type}" ) => 'string',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_accommodation}" ) => '#,##0.00',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_accommodation_discount}" ) => '#,##0.00',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_balance}" ) => '#,##0.00',
				$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_sum}" ) => '#,##0.00',

		);
// 		echo "<pre>";
// 		print_r($fields_list);
// 		print_r($array);
// 		die();
		$filename = "paymentlistdate.xlsx";

		$this->xlsfactory_model->uploadxlsbyarray ( $fields_list, $array, $filename );
	}

	function uploadxls_wifi_reports() {
	    // 		echo "<pre>";
	    // 		print_r($_POST);
	    // 		print_r($_SESSION);
	    // 		die();
	    $prefix = $this->mlanguages->get_language_prefix();

	    $array = array();
	    $total_amount = 0;
	    $total_balance = 0;

	    if(isset($_POST["selected_payment"])){
	        $count_selected_pays = count($_POST["selected_payment"]);
	        if($count_selected_pays > 0){
	            //echo "+++++";
	            $select_payment = " payment.id IN (";
	            $p = 1;
	            foreach($_POST["selected_payment"] as $pay_id){
	                if($p == $count_selected_pays){
	                    $select_payment .= $pay_id.")";
	                }else{
	                    $select_payment .= $pay_id.",";
	                }
	                $p++;
	            }
	            $sql_selected_pays = "SELECT 1 as payment_type, guests.firstname, guests.lastname, guests.phone, users.fullname as user_firstname, users.lastname as user_lastname,
				services_main.amount as services_main_amount, dealers.name as dealer_name, deskofreservation.balance,deskofreservation.datein,
				deskofreservation.discount, deskofreservation.dateout, deskofreservation.duration, deskofreservation.id as res_id, payment.confirm_time, payment.confirm_userid,
				payment.id as pay_id, payment_types.name as payment_name, payment.create_time, payment.amount as pay_total, payment.isclosed as pay_isclosed,
				rooms.name as room_name, categories.shortname as categories_name, payment.operationtime FROM payment
				INNER JOIN deskofreservation ON deskofreservation.id = payment.reservation_id
				INNER JOIN rooms ON rooms.id=deskofreservation.room_id
				INNER JOIN categories ON categories.id=rooms.category_id
				LEFT JOIN users ON users.id = payment.id_user
				LEFT JOIN services_main ON services_main.reservation_id=deskofreservation.id
				INNER JOIN dealers ON dealers.id=deskofreservation.id_dealer
				INNER JOIN guests ON guests.id = deskofreservation.guest_id
				INNER JOIN payment_types ON payment_types.id = payment.type
				WHERE ".$select_payment;


	        }
	    }

	    if(isset($_POST["selected_refund"])){
	        if(count($_POST["selected_refund"]) > 0){

	        }
	    }

	    if (isset ( $_SESSION ["paymentlistdate_payments_sql"] )) {
	        if ($_SESSION ["paymentlistdate_payments_sql"] != '') {
	            if(isset($sql_selected_pays)){
	                $sql = $sql_selected_pays;
	            }else{
	                $sql = $_SESSION ["paymentlistdate_payments_sql"];
	            }
	            // echo $sql;
	            // die();

	            $query = $this->db->query ( $sql );
	            foreach ( $query->result () as $row ) {
	                switch ($row->payment_type) {
	                    case 1 :
	                        $payment_type = $this->mlanguages->getdictionaryword ( "mlw", $prefix, "{mlw_Payment}" );
	                        break;
	                    case 2 :
	                        $payment_type = $this->mlanguages->getdictionaryword ( "mlw", $prefix, "{mlw_refund}" );
	                        break;
	                    default :
	                        $payment_type = $this->mlanguages->getdictionaryword ( "mlw", $prefix, "{mlw_Payment}" );
	                        break;
	                }
	                array_push ( $array, array (
	                    'pay_id' => $row->pay_id,
	                    'res_id' => $row->res_id,
	                    'firstname' => $row->firstname,
	                    'lastname' => $row->lastname,
	                    'room_name' => $row->room_name,
	                    'categories_name' => $row->categories_name,
	                    'datein' => $row->datein,
	                    'dateout' => $row->dateout,
	                    // 'dealer_name' => $row->dealer_name,
	                    'duration' => $row->duration,
	                    'operationtime' => $row->operationtime != 0 ?  $row->operationtime : '',
	                    //'operationtime' => $row->operationtime,
	                    'create_time' => $row->create_time != 0 ? $row->create_time : '',
	                    //'create_time' => $row->create_time,
	                    'user' => $row->user_firstname." ".$row->user_lastname,
	                    'payment_type' => $payment_type,
	                    'name' => $row->payment_name,
	                    'services_main_amount' => $row->services_main_amount,
	                    'discount' => $row->discount,
	                    'balance' => $row->balance,
	                    'pay_total' => $row->pay_total
	                ) );
	                $total_amount += $row->pay_total;
	                $total_balance += $row->balance;
	            }
	            array_push ( $array,array('','','','','','','','','','','','','','','','', $total_balance, $total_amount));
	        }
	    }

	    $fields_list = array (
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_payment}" ) => 'string',
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_order}" ) => 'string',
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_name}" ) => 'string',
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_surname}" ) => 'string',
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_room}" ) => 'string',
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_category}" ) => 'string',
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_checkin}" ) => 'date',
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_checkout}" ) => 'date',
	        //$this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_dealer}" ) => 'string',
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_days}" ) => 'string',
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_operationtime}" ) => 'date',
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_createdate}" ) => 'datetime',//'YYYY-MM-DD h:mm:ss',
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_username}" ) => 'string',
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_operationtype}" ) => 'string',
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_type}" ) => 'string',
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_accommodation}" ) => '#,##0.00',
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_accommodation_discount}" ) => '#,##0.00',
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_balance}" ) => '#,##0.00',
	        $this->mlanguages->getdictionaryword ( "xlsmodel", $prefix, "{caption_sum}" ) => '#,##0.00',

	    );
	    // echo "<pre>";
	    // print_r($fields_list);
	    // print_r($array);
	    // die();
	    $filename = "paymentlistdate.xlsx";

	    $this->xlsfactory_model->uploadxlsbyarray ( $fields_list, $array, $filename );
	}

    function uploadxls_wifi_reports_2()
    {
        $prefix = $this->mlanguages->get_language_prefix();
        $ap_name = 0;
        $ap_name = $ap_name == 0 ? "hms_" . $this->config->item('hotel_id') : "hms_" . $ap_name;
        $result_array = $this->wifi_radius->get_reports($ap_name);
        $result_array = json_decode($result_array, true);
        //print_r($result_array);
        $inc = 1;
        $wifi_auth_data = array();
        foreach ($result_array as $cell) {
            $wifi_login = $cell['login'];
            $guest_data = $this->wifi_radius->get_guest_data_by_wifi_login($wifi_login);
            
            array_push($wifi_auth_data, array(
                'inc' => $inc,
                'auth_time' => date('Y-m-d H:i:s', $cell['unixtime']),
                'dateout' => $guest_data['dateout'],
                'firstname' => $guest_data['firstname'],
                'lastname' => $guest_data['lastname'],
                'middlename' => $guest_data['middlename'],
                'dob' => $guest_data['dob'],
                'citizenship' => $guest_data['citizenship'],
                //'doc_type' => $guest_data['doc_type'],
                'doc_precode' => $guest_data['doc_precode'],
                'doc_name' => isset($dict_documents[$guest_data['doc_type']]) ? $dict_documents[$guest_data['doc_type']]['name'] : '---',
                'passportid' => $guest_data['passportid'],
                'user_mac' => $cell['user_mac']
            ));
            $inc ++;
        }
        
        $fields_list = array(
            '#' => 'string',
            $this->mlanguages->getdictionaryword("wifi_settings", $prefix, "{clt_auth_date}") => 'string',
            $this->mlanguages->getdictionaryword("wifi_settings", $prefix, "{clt_access_date_end}") => 'date',
            $this->mlanguages->getdictionaryword("reservations_reservationedit", $prefix, "{caption_firstname}") => 'string',
            $this->mlanguages->getdictionaryword("reservations_reservationedit", $prefix, "{caption_lastname}") => 'string',
            $this->mlanguages->getdictionaryword("reservations_reservationedit", $prefix, "{caption_middlename}") => 'string',
            $this->mlanguages->getdictionaryword("reservations_reservationedit", $prefix, "{caption_dob}") => 'date',
            $this->mlanguages->getdictionaryword("reservations_reservationedit", $prefix, "{caption_citizenship}") => 'string',
            $this->mlanguages->getdictionaryword("reservations_reservationedit", $prefix, "{caption_doc_type}") => 'string',
            $this->mlanguages->getdictionaryword("reservations_reservationedit", $prefix, "{caption_mg_precode}") => 'string',
            $this->mlanguages->getdictionaryword("reservations_reservationedit", $prefix, "{caption_mg_number}") => 'string', // 'YYYY-MM-DD h:mm:ss',
            $this->mlanguages->getdictionaryword("wifi_settings", $prefix, "{clt_user_mac}") => 'string'
        );
        
//         echo "<pre>";
//         print_r($fields_list);
//         print_r($wifi_auth_data);
//         die();
        $filename = "wifi_reports.xlsx";
        
        $this->xlsfactory_model->uploadxlsbyarray($fields_list, $wifi_auth_data, $filename);
    }
    
    public function upload_reservations_list() {
        $this->load->model ( 'list_reports/rlist_mdl' );
        $post = $this->input->post();
        
        $cells_data = $this->xlsfactory_model->prepare_rlist_data_for_uploading(array('post' => $post));
        
        $filename_datetime = date('Ymd_Hi');
        $filename = "reservations_list_$filename_datetime.xlsx";
        
        $data_for_uploading = array(
            'filename' => $filename,
            'cells_headers' => $cells_data['headers'],
            'cells_content' => $cells_data['content'],
            'sheetname' => 'Sheet1',
        );
        
        $this->xlsfactory_model->uploadxls($data_for_uploading);//array('filename', 'sheetname' => 'Sheet1', 'cells_headers', 'cells_content')
    }
}