<?php
class Wizard_fms extends CI_Controller {
	public function __construct() {
		parent::__construct ();
		$this->load->model ( 'htmltpl' );
		$this->load->model ( 'frontdesk' );
		$this->load->model ( 'frontdesk_c2' );
		$this->load->model ( 'Authorization' );
		$this->load->model ( 'hotelix_config' );
		$this->load->model ( 'releases' );
		$this->load->model('Access');
		$this->Authorization->IsLogined ();

		$this->Access->check_billing_plan_access("fms");
	}
	function step1($reservation_id, $guest_id) {
		//print_r($_GET);
		//die();
		if(isset($_GET["landing_page"])){
			$newdata = array (
					'wizard_fms_landing_page' => $_GET["landing_page"]
			);
			$this->session->set_userdata ( $newdata );
		}
		$data = array (
			'reservation_id' => $reservation_id,
			'guest_id' => $guest_id
		);
		$this->load->library ( 'parser' );
		$this->load->view ( 'wizard_fms_step1_view', $data );
	}
	function step1_post() {
		$post = $_POST;
		$reservation_id = $post["reservation_id"];
		$guest_id = $post["guest_id"];
		$citizenship_code = "";

		if (trim ( $post ['citizenship'] ) != "") {
			$query = $this->db->query ( "SELECT id FROM global_fms_base.dict_country
										WHERE NAME LIKE '" . trim ($post ['citizenship']) . "'
										OR NAME_LAT LIKE '" .  trim ($post ['citizenship']) . "'
										OR name_spa LIKE '" .  trim ($post ['citizenship']) . "'" );

			if ($query->num_rows () > 0) {
				$row = $query->row ();
				$citizenship_code = $row->id;
				$sql = "UPDATE `guests` SET `citizenship_code` = '" . $citizenship_code . "', `citizenship`='" . $post ['citizenship'] . "'
		 				WHERE `id` = ".$post["guest_id"];
				$query = $this->db->query ( $sql );
				die ( "<meta http-equiv='refresh' content='0;url=/wizard_fms/step2/$reservation_id/$guest_id'>" );
			}
		}
		die ( "<meta http-equiv='refresh' content='0;url=/wizard_fms/step1/$reservation_id/$guest_id'>" );
	}

	function step2($reservation_id, $guest_id) {
		$data = array (
				'reservation_id' => $reservation_id,
				'guest_id' => $guest_id
		);
		$this->load->library ( 'parser' );
		$this->load->view ( 'wizard_fms_step2_view', $data );
	}

	function step5($reservation_id, $guest_id) {
	    $data = array (
	        'reservation_id' => $reservation_id,
	        'guest_id' => $guest_id
	    );
	    $this->load->library ( 'parser' );
	    $this->load->view ( 'wizard_fms_step5_view', $data );
	}

	function step5_post() {
	    $post = $_POST;
// 	    echo "<pre>";
// 	    print_r($post);
	    //die();
	    $reservation_id = $post["reservation_id"];
	    $guest_id = $post["guest_id"];

	    if($post ['representative_id'] == 0){
	        die ( "<meta http-equiv='refresh' content='0;url=/wizard_fms/step5/$reservation_id/$guest_id'>" );
	    }


	    $sql = "UPDATE `guests` SET `representative_id`= '" . $post ['representative_id'] . "' WHERE `id` = ".$post["guest_id"];
	    $query = $this->db->query ( $sql );

	    die ( "<meta http-equiv='refresh' content='0;url=/wizard_fms/step4/$reservation_id/$guest_id'>" );
	}

	function step2_post() {
		$post = $_POST;
		$reservation_id = (isset($post["reservation_id"]) && $post["reservation_id"] != '') ? $post["reservation_id"] : 0;
		$guest_id = (isset($post["guest_id"]) && $post["guest_id"] != '') ? $post["guest_id"] : 0;
		if ($guest_id && $reservation_id) {
		    $sql = "UPDATE `guests` SET `doc_type`='" . $post ['doc_type'] . "' WHERE `id` = ".$post["guest_id"];
		    $query = $this->db->query ( $sql );
		    die ( "<meta http-equiv='refresh' content='0;url=/wizard_fms/step3/$reservation_id/$guest_id'>" );
		}else{
		    //need to signalise user somehow!!
		    die ( "<meta http-equiv='refresh' content='0;url=/reservation_c2/calendar'>" );
		}		
	}

	function step3($reservation_id, $guest_id) {
		$data = array (
				'reservation_id' => $reservation_id,
				'guest_id' => $guest_id
		);
		$this->load->library ( 'parser' );
		$this->load->view ( 'wizard_fms_step3_view', $data );
	}

	function step3_post() {
		$post = $this->input->post();
// 		echo "<pre>";
// 		print_r($post);
// 		die();
		$guest_id = $post ["guest_id"];
		$reservation_id = $post ["reservation_id"];
		if (!$guest_id || $guest_id == '' || is_null($guest_id)) {
		    if (!$reservation_id || $reservation_id == '' || is_null($reservation_id)) {
		        die ( "<meta http-equiv='refresh' content='0;url=/reservation_c2/calendar'>" );
		    }else {
		        die ( "<meta http-equiv='refresh' content='0;url=/reservation_c2/folio/".$reservation_id."/1'>" );
		    }
		}
		$db_guest_data = $this->frontdesk->GetGuest($guest_id);
		$db_reservation_details_data = $this->frontdesk->GetGuest_reservation_details($guest_id, $reservation_id);
		if(!isset($post["address_lastliving"])){
		    $post["address_lastliving"] = $db_reservation_details_data["address_lastliving"];
		}
		if(!isset($post["profession"])){
		    $post["profession"] = $db_guest_data["profession"];
		}
		if(!isset($post["firstname_lat"])){
			$post["firstname_lat"] = $db_guest_data["firstname_lat"];
		}
		if(!isset($post["lastname_lat"])){
			$post["lastname_lat"] = $db_guest_data["lastname_lat"];
		}
		if(!isset($post["docResidence_authority"])){
			$post["docResidence_authority"] = $db_guest_data["docResidence_authority"];
		}
		if(!isset($post["docResidence_decisionNumber"])){
			$post["docResidence_decisionNumber"] = $db_guest_data["docResidence_decisionNumber"];
		}
		if(!isset($post["docResidence_decisionDate"])){
			$post["docResidence_decisionDate"] = $db_guest_data["docResidence_decisionDate"];
		}
		if(!isset($post["resdoc_identitifier"])){
			$post["resdoc_identitifier"] = $db_reservation_details_data["resdoc_identitifier"];
		}
		if(!isset($post["officialorgan_kpp"])){
			$post["officialorgan_kpp"] = $db_reservation_details_data["officialorgan_kpp"];
		}
		if(!isset($post["officialorgan_kpp_code"])){
			$post["officialorgan_kpp_code"] = $db_reservation_details_data["officialorgan_kpp_code"];
		}
		if(!isset($post["visitpurpose"])){
			$post["visitpurpose"] = $db_reservation_details_data["visitpurpose"];
		}
		if(!isset($post["visamultiplicity"])){
			$post["visamultiplicity"] = $db_reservation_details_data["visamultiplicity"];
		}
		if(!isset($post["reg_visa_num"])){
			$post["reg_visa_num"] = $db_guest_data["reg_visa_num"];
		}
		if(!isset($post["reg_visa_date_till"])){
			$post["reg_visa_date_till"] = $db_guest_data["reg_visa_date_till"];
		}
		if(!isset($post["reg_visa_type"])){
			$post["reg_visa_type"] = $db_guest_data["reg_visa_type"];
		}
		if(!isset($post["reg_date_in"])){
			$post["reg_date_in"] = $db_guest_data["reg_date_in"];
		}
		if(!isset($post["nationality"])){
			$post["nationality"] = $db_guest_data["nationality"];
		}
		if(!isset($post["reg_visa_precode"])){
			$post["reg_visa_precode"] = $db_reservation_details_data["reg_visa_precode"];
		}
		if(!isset($post["reg_date_out"])){
			$post["reg_date_out"] = $db_reservation_details_data["reg_date_out"];
		}
		if(!isset($post["migration_card_precode"])){
			$post["migration_card_precode"] = $db_reservation_details_data["migration_card_precode"];
		}
		if(!isset($post["migration_card_num"])){
			$post["migration_card_num"] = $db_reservation_details_data["migration_card_num"];
		}
		if(!isset($post["card_date_of_issue"])){
			$post["card_date_of_issue"] = $db_reservation_details_data["card_date_of_issue"];
		}
		if(!isset($post["goal"])){
			$post["goal"] = $db_reservation_details_data["goal_id"];
		}
//============= перевірка валідності країни народження та коду підрозділу СТАРТ ========================
		$need_reload_page = false;
		$post ['country'] = trim ($post ['country']);
		$query = $this->db->query ( "SELECT id FROM global_fms_base.dict_country
									WHERE NAME LIKE '" . $post ['country'] . "'
									OR NAME_LAT LIKE '" . $post ['country'] . "'
									OR name_spa LIKE '" . $post ['country'] . "'" );
		if ($query->num_rows () == 0) {
			$post ['country'] = "";
			$need_reload_page = true;
		}
		if (isset($post ['dict_officialorgan_fmsCODE'])) {
		    $query = $this->db->query ( "SELECT id FROM global_fms.dict_officialorgan_fms
									WHERE CODE LIKE '" . $post ['dict_officialorgan_fmsCODE'] . "'" );
		    if ($query->num_rows () == 0) {
		        $post ['dict_officialorgan_fmsCODE'] = "";
		        $need_reload_page = true;
		    }
		}
//============= перевірка валідності країни народження та коду підрозділу ФІНІШ ========================
// ============ перетворення дат до формату бази даних START ======================
		$temp_arr_filds_with_date_format = array ( // поля з датами, зібрати ВСІ поля зі всіx масивів у вюсі!
				//'pob_registration_date',
				'dob',
				'doc_date_open',
				'doc_date_till',
				'reg_date_in',
				'reg_date_out',
				'decision_date',
				'docResidence_decisionDate',
				'card_date_of_issue',
				'reg_visa_date_till',
		);
		foreach ($temp_arr_filds_with_date_format as $fild_with_date_format) {
			if (isset($post[$fild_with_date_format]) && $post[$fild_with_date_format] != ""){
				$post[$fild_with_date_format] = date('Y-m-d', strtotime($post[$fild_with_date_format]));
			}else{
				$post[$fild_with_date_format] = '0000-00-00';
			}
		}
//============ перетворення дат до формату бази даних END ======================

		//  логіка ФІАС ІД
		if(isset($post['use_fias'])){
		    if($post['fias'] == ""){
		        $fias_data = array();
		        $fias_data['type'] = "address";
		        $fias_data['address_str'] = $post['state']." ".$post['city']." ".$post['address'];
		        //." ".$post['addrbuilding'];

		        // ф-я отримання ФМС даних по адресу (виклик curl)
		        $result_array = $this->fms_core->get_fias_data($fias_data);
		        if(isset($result_array[0]['data']['fias_id'])){
		            $post['fias'] = $result_array[0]['data']['fias_id'];
		        }
		    }
		}else{
		    $post['fias'] = "";
		}

		foreach ($post as $post_key => $post_value) {
		    $post[$post_key] = trim($post_value);
		}

		$this->frontdesk->Guest_update ( $post, $post ["guest_id"] );
		$this->frontdesk->guests_reservation_details ( $post, $reservation_id, $guest_id );

		$res_data = $this->db->select('datein')->get_where('deskofreservation', array('id' => $reservation_id))->row_array();
		$datein = $res_data['datein'];

		$representative_bool = $this->frontdesk_c2->check_representative($post['dob'], $datein);
		if($representative_bool == 1){
		    die ( "<meta http-equiv='refresh' content='0;url=/wizard_fms/step5/$reservation_id/$guest_id'>" );
		}

		if($post['just_save_page_data'] == 1){
			die ( "<meta http-equiv='refresh' content='0;url=/wizard_fms/step3/$reservation_id/$guest_id'>" );
		}
		if($need_reload_page){
			die ( "<meta http-equiv='refresh' content='0;url=/wizard_fms/step3/$reservation_id/$guest_id'>" );
		}else {
			die ( "<meta http-equiv='refresh' content='0;url=/wizard_fms/step4/$reservation_id/$guest_id'>" );
		}
	}

	function step4($reservation_id, $guest_id) {
		$data = array (
				'reservation_id' => $reservation_id,
				'guest_id' => $guest_id
		);
		$this->load->library ( 'parser' );
		$this->load->view ( 'wizard_fms_step4_view', $data );
	}
	function step4_post($reservation_id, $guest_id) {
		echo $reservation_id." ".$guest_id;
	}

	function fms_registration_command(){
		$this->frontdesk_c2->fms_registration_command($_POST);
		$landing_page = "";
		if($this->session->userdata ( 'wizard_fms_landing_page' ) <> ""){
			$landing_page = $this->session->userdata ( 'wizard_fms_landing_page' );
		}
		if ($_POST['skip_registry'] == 1 && $landing_page != ""){
			switch ($landing_page) {
				case "folio" :
					die ( "<meta http-equiv='refresh' content='0;url=/reservation_c2/folio/" . $_POST["reservation_id"] . "/1'>" );
					break;
				case "fms_map" :
					die ( "<meta http-equiv='refresh' content='0;url=/reservation_c2/fms_map/1'>" );
					break;
				case "fms_c2_recordlist" :
					die ( "<meta http-equiv='refresh' content='0;url=/fms_c2/recordlist/1'>" );
					break;
			}
		}else{
			die ( "<meta http-equiv='refresh' content='0;url=/wizard_fms/step1/".$_POST["reservation_id"]."/".$_POST["guest_id"]."'>" );
		}
	}
}