<?php
class cClearTaskType {
    var $id = -1;
    var $name = "";
    var $icon = "";
    var $color = "";
}
class cClearTaskSubtype {
    var $id = -1;
    var $name = "";
    var $type_id = 0;
}
class tasks_c2 extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model ( 'tasks_model' );
        $this->load->model ( 'musers_c2' );
        $this->load->model ( 'htmltpl' );
        $this->load->model('Authorization');
        $this->Authorization->IsLogined();
    }

    function tasks_desk($date = "") {
        // ==== billing plan access start ==========
        $data_access = array('module_name' => 'housekeeping');
        $billing_plan_access = $this->Access->get_billing_plan_access($data_access);
        if($billing_plan_access == 0){
            die ( "<meta http-equiv='refresh' content='0;url=/errors_c2/view_error/52'>" );
        }
        // ==== billing plan access end ==========
        if($date != "")
            $this->session->set_userdata (array('tasks_list_date' => $date));

        $data = array ();
        $this->load->library('parser');;
        $this->load->view('/tasks_c2/tasks_c2_tasks_desk_view.php', $data);
    }

    function ajax_add_task(){
        echo $this->htmltpl->get_modal_ajax_add_task($_POST);
    }

    function add_task_post(){
//         echo "<pre>";
//         print_r($_POST);
//         die();
        $post = $_POST;

        list ( $year, $month, $day ) = explode ( "-", $post['startdate'] );
        $intdate = round ( mktime ( 0, 0, 0, $month, $day, $year ) / 86400 );

        $post['duedate'] = $post['startdate']." ".$post['duedate_time'].":00";
        $post['startdate'] .= " ".$post['startdate_time'].":00";

        if(!isset($post['is_urgent'])){
            $post['is_urgent'] = 0;
        }

        $db_data = array();
        $db_data['id'] = $post['task_id'];
        $db_data['room_id'] = $post['room_id'];
        $db_data['task_type'] = $post['task_type'];
        $db_data['description'] = $post['description'];
        $db_data['resolution'] = $post['resolution'];
        $db_data['assignedto'] = $post['assignedto'];
        $db_data['startdate'] = $post['startdate'];
        $db_data['duedate'] = $post['duedate'];
        $db_data['status'] = $post['status'];
        $db_data['is_urgent'] = $post['is_urgent'];

        if($post['task_id'] == -1){
            unset($db_data['id']);
            $task_id = $this->tasks_model->hk_tasks_insert($db_data);

            // ====== SCHEDULE =====
            //if($post['task_type'] == 1){
                $tasks2cs_data = array();
                $tasks2cs_data['task_id'] = $task_id;
                $tasks2cs_data['cs_id'] = $post['task_subtype'];
                $tasks2cs_data['room_id'] = $post['room_id'];
                $tasks2cs_data['intdate'] = $intdate;

                $this->tasks_model->hk_tasks2cs_insert($tasks2cs_data);
            //}
        }else{
            $task_id = $post['task_id'];
            $this->tasks_model->hk_tasks_update($task_id, $db_data);

            // ====== SCHEDULE =====
            $this->tasks_model->hk_tasks2cs_delete($task_id);
            //if($post['task_type'] == 1){
                $tasks2cs_data = array();
                $tasks2cs_data['task_id'] = $task_id;
                $tasks2cs_data['cs_id'] = $post['task_subtype'];
                $tasks2cs_data['room_id'] = $post['room_id'];
                $tasks2cs_data['intdate'] = $intdate;

                $this->tasks_model->hk_tasks2cs_insert($tasks2cs_data);
            //}
        }

        switch ($post['die_url']) {
            case "tasks_list":
                die("<meta http-equiv='refresh' content='0;url=/tasks_c2/tasks_list'>");
                break;
            case "cst_desk":
                die("<meta http-equiv='refresh' content='0;url=/cst_c2/cst_desk'>");
                break;
            default:
                die("<meta http-equiv='refresh' content='0;url=/tasks_c2/tasks_desk'>");
                break;
        }

    }

    function delete_task($task_id)
    {
        $this->tasks_model->hk_tasks_delete($task_id);


        $post = $_POST;
        switch ($post['die_url']) {
            case "tasks_list":
                die("<meta http-equiv='refresh' content='0;url=/tasks_c2/tasks_list'>");
                break;
            case "cst_desk":
                die("<meta http-equiv='refresh' content='0;url=/cst_c2/cst_desk'>");
                break;
            default:
                die("<meta http-equiv='refresh' content='0;url=/tasks_c2/tasks_desk'>");
                break;
        }
        //die("<meta http-equiv='refresh' content='0;url=/tasks_c2/tasks_desk'>");
    }

    function ajax_get_subtypes(){
        $post = $_POST;
        $type_id = $post['type_id'];

        $task_subtypes = $this->tasks_model->getTask_subtypes($type_id);

        $task_subtypes_select = array();
        $task_subtypes_select[0]['id'] = 0;
        $task_subtypes_select[0]['name'] = "---";
        foreach($task_subtypes as $cell){
            array_push($task_subtypes_select, $cell);
        }

        echo json_encode($task_subtypes_select);
    }

    function set_cs_tasks(){
        //echo "<pre>";
        //print_r($_POST);
        //die();
        $cs_needtodo_data = array();
        if(isset($_POST['cs_needtodo'])){
            $cs_needtodo_data = $_POST['cs_needtodo'];
        }

        $assignedto = 0;
        if(isset($_POST['assignedto'])){
            $assignedto = $_POST['assignedto'];
        }

        $task_type = 1; // CS
        $task_status = 1; // new

        foreach ($cs_needtodo_data as $room_id => $cell_date) {
            foreach ($cell_date as $intdate => $cell_cs) {
                foreach ($cell_cs as $cs_id => $value) {
                    $db_data = array();
                    $db_data['room_id'] = $room_id;
                    $db_data['task_type'] = $task_type; // CS
                    $db_data['description'] = "";
                    $db_data['assignedto'] = $assignedto;
                    $db_data['startdate'] = date('Y-m-d H:i:s',  $intdate*86400);
                    $db_data['duedate'] = date('Y-m-d H:i:s',  $intdate*86400);
                    $db_data['status'] = $task_status;
                    $db_data['is_urgent'] = 0;
                    $task_id = $this->tasks_model->hk_tasks_insert($db_data);

                    $tasks2cs_data = array();
                    $tasks2cs_data['task_id'] = $task_id;
                    $tasks2cs_data['cs_id'] = $cs_id;
                    $tasks2cs_data['room_id'] = $room_id;
                    $tasks2cs_data['intdate'] = $intdate;
                    $this->tasks_model->hk_tasks2cs_insert($tasks2cs_data);
                }
            }
        }

        die("<meta http-equiv='refresh' content='0;url=/cst_c2/cst_desk'>");
    }


    function tasks_list($page = 1) {
        // ==== billing plan access start ==========
        $data_access = array('module_name' => 'housekeeping');
        $billing_plan_access = $this->Access->get_billing_plan_access($data_access);
        if($billing_plan_access == 0){
            die ( "<meta http-equiv='refresh' content='0;url=/errors_c2/view_error/52'>" );
        }
        // ==== billing plan access end ==========
        
        $reset = 0;
        if (isset ( $_POST ["reset_search_form"] )) {
            if ($_POST ["reset_search_form"] == 1) {
                $array_items = array (
                    'cs_list_date' => '',
                    'cs_list_categories' => '',
                    'cs_list_room' => '',
                    'cs_list_assignedto' => '',
                    'cs_list_statuses' => '',
                    'cs_list_urgent' => '',
                    'cs_list_type' => ''
                );

                $this->session->unset_userdata ( $array_items );
                $reset = 1;
            }
        }
        if ($reset == 0) {
            if (isset($_POST["date"])) {
                $date = $_POST["date"];
                $newdata = array(
                    'cs_list_date' => $date
                );
                $this->session->set_userdata($newdata);
            } else {
                if (isset($_GET["date"])) {
                    $date = $_GET["date"];
                    $newdata = array(
                        'cs_list_date' => $date
                    );
                    $this->session->set_userdata($newdata);
                }
            }

            if (isset($_POST["task_type"])) {
                $newdata = array(
                    'cs_list_type' => $_POST["task_type"]
                );
                $this->session->set_userdata($newdata);
            }

            if (isset($_POST["categories"])) {
                foreach ($_POST["categories"] as $val) {
                    $categories[$val] = $val;
                }
                $newdata = array(
                    'cs_list_categories' => $categories
                );
                $this->session->set_userdata($newdata);
            }

            if (isset($_POST["room"])) {
                $newdata = array(
                    'cs_list_room' => $_POST["room"]
                );
                $this->session->set_userdata($newdata);
            } else {
                if (isset($_GET["room_id"])) {
                    $newdata = array(
                        'cs_list_room' => $_GET["room_id"]
                    );
                    $this->session->set_userdata($newdata);
                }
            }

            if (isset($_POST["assignedto"])) {
                $newdata = array(
                    'cs_list_assignedto' => $_POST["assignedto"]
                );
                $this->session->set_userdata($newdata);
            }

            if (isset($_POST["statuses"])) {
                foreach ($_POST["statuses"] as $val) {
                    $statuses[$val] = $val;
                }
                $newdata = array(
                    'cs_list_statuses' => $statuses
                );
                $this->session->set_userdata($newdata);
            }

            if (isset($_POST["urgent"])) {
                $newdata = array(
                    'cs_list_urgent' => $_POST["urgent"]
                );
                $this->session->set_userdata($newdata);
            }
        }
        if (isset ( $_POST ["lines_per_page"] )) {
            $lines_per_page = $_POST ["lines_per_page"];
            $newdata = array ('cs_list_lines_per_page' => $lines_per_page);
            $this->session->set_userdata ( $newdata );
        }

        if (isset ( $_POST ["goto_page"] )) {
            $page = $_POST ["goto_page"];
        }
        $data = array ('current_page' => $page);
        $this->load->library('parser');
        $this->load->view('/tasks_c2/tasks_list_view.php', $data);
    }

    function tasks_types_list()
    {
        $data = array();
        $this->load->library('parser');
        $this->load->view('/tasks_c2/tasks_types_list_view.php', $data);
    }

    function insert_tasktype() {
        $type_record = new cClearTaskType ();
        $data = array (
            'type_record' => $type_record
        );
        $this->load->view ( '/tasks_c2/tasks_types_edit_view', $data );
    }

    function edit_tasktype($id) {
        //if($id == 1){
        //    die ( "<meta http-equiv='refresh' content='0;url=/tasks_c2/tasks_types_list'>" );
        //}
		$result = $this->tasks_model->get_tasktype ( $id );
		$data = array (
				'type_record' => $result
		);
        $this->load->view ( '/tasks_c2/tasks_types_edit_view', $data );
    }

    function update_task_type(){
//         echo "<pre>";
//         print_r($_POST);
//         die();
        if (isset($_POST['name'])) {
            $data = array(
                'name' => $_POST['name'],
                'icon' => $_POST['icon'],
                'color' => $_POST['color']
            );
        }else{
            $data = array(
                'icon' => $_POST['icon'],
                'color' => $_POST['color']
            );
        }

        if ($_POST ['id'] != - 1) {
            $this->tasks_model->updateTaskType ( $data, $_POST ['id'] );
        } else {
            $this->tasks_model->insertTaskType ( $data );
        }

        die ( "<meta http-equiv='refresh' content='0;url=/tasks_c2/tasks_types_list'>" );
    }

    function tasks_types_delete(){
        if (isset($_POST['selected_type'])) {
            foreach (array_keys($_POST['selected_type']) as $id) {
                if ($id != 1) $this->tasks_model->deleteTaskType($id);//id != 1 rest except Uborka = 1
            }
        }

        die("<meta http-equiv='refresh' content='0;url=/tasks_c2/tasks_types_list'>");
    }

    //==================================================

    function tasks_subtypes_list()
    {
//         $array_items = array (
//            'task_subtypes_list_type' => ''
//         );
//         $this->session->unset_userdata ( $array_items );

        if (isset($_POST["task_type"])) {
            $newdata = array(
                'task_subtypes_list_type' => $_POST["task_type"]
            );
            $this->session->set_userdata($newdata);
        }

        $data = array();
        $this->load->library('parser');
        $this->load->view('/tasks_c2/tasks_subtypes_list_view.php', $data);
    }

    function insert_tasksubtype() {
        $subtype_record = new cClearTaskType ();
        $data = array (
            'subtype_record' => $subtype_record
        );
        $this->load->view ( '/tasks_c2/tasks_subtypes_edit_view', $data );
    }

    function edit_tasksubtype($id) {
        $result = $this->tasks_model->get_tasksubtype ( $id );
        $data = array (
            'subtype_record' => $result
        );
        $this->load->view ( '/tasks_c2/tasks_subtypes_edit_view', $data );
    }

    function update_task_subtype(){
        //echo "<pre>";
        //print_r($_POST);

        $data = array (
            'name' => $_POST ['name'],
            'type_id' => $_POST ['type_id'],
        );
        if ($_POST ['id'] != -1) {
            $this->tasks_model->updateTaskSubType ( $data, $_POST ['id'] );
        } else {
            $this->tasks_model->insertTaskSubType ( $data );
        }

        die ( "<meta http-equiv='refresh' content='0;url=/tasks_c2/tasks_subtypes_list'>" );
    }

    function tasks_subtypes_delete(){
        if (isset($_POST['selected_type'])) {
            foreach (array_keys($_POST['selected_type']) as $id) {
                $this->tasks_model->deleteTaskSubType($id);
            }
        }

        die("<meta http-equiv='refresh' content='0;url=/tasks_c2/tasks_subtypes_list'>");
    }
}
?>