<?php 
class Stripe_subaccount extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('Stripe');
		$this->load->model('hotelix_config');
	}


	public function create_account()
    {
        $stripe_account_id = $this->hotelix_config->get_record('stripe_account_id');
        if ($stripe_account_id == "") {
            require_once (APPPATH . 'libraries/stripe/init.php');
            
            $stripe = $this->Stripe->get_param_global();
            
            \Stripe\Stripe::setApiKey($stripe['secret_key']);
            
            $acct = \Stripe\Account::create(array(
                "country" => "IT",
                "type" => "custom"
            ));
            $result = json_decode(json_encode($acct), 1);
            echo "<pre>" . $acct->id . "<br>".$acct->keys->secret;
             print_r($result);
            // die();
             var_dump($acct);
            
            if (isset($acct->id)) {
                $this->hotelix_config->set_record('stripe_account_id', $acct->id);
                $this->hotelix_config->set_record('stripe_secret', $acct->keys->secret);
                $this->hotelix_config->set_record('stripe_publishable', $acct->keys->publishable);
            }
        } else {
            echo "account already exist!";
        }
    }
	
    public function accept_agreement($stripe_account_id = "")
	{
	    
	    require_once (APPPATH . 'libraries/stripe/init.php');
	    
	    $stripe = $this->Stripe->get_param_global();
	    
	    \Stripe\Stripe::setApiKey($stripe['secret_key']);
	    if($stripe_account_id == "")
	       $stripe_account_id = $this->hotelix_config->get_record('stripe_account_id');
	    
	    $acct = \Stripe\Account::retrieve($stripe_account_id);
	    $acct->tos_acceptance->date = time();
	    $acct->tos_acceptance->ip = $_SERVER['REMOTE_ADDR'];
	    $accept = $acct->save();
	    echo "<pre>";
	    print_r($accept);
	}
	
	public function update_account($stripe_account_id = "")
	{
	    require_once (APPPATH . 'libraries/stripe/init.php');
	    
	    $stripe = $this->Stripe->get_param_global();
	    
	    \Stripe\Stripe::setApiKey($stripe['secret_key']);
	    
	    if($stripe_account_id == "")
	       $stripe_account_id = $this->hotelix_config->get_record('stripe_account_id');
	    
	    $acct = \Stripe\Account::retrieve($stripe_account_id);
	    $acct->business_name = 'Test Company';
	    $acct->business_url ='https://dc-booking-test-book.otelms.com/bookit/step1';
	    $acct->business_primary_color  = '#000000'; // dOES IT INFLUENCE ATHING?
	    $acct->decline_charge_on = array(
	        "avs_failure"=> false, 
	        "cvc_failure" => true
	    );
	    $acct->account_holder_type = 'individual';
	     
	    /*$acct->legal_entity  = array(
	        'type'=>'company', 
	        'business_name'=>'Test Company',
	        'business_tax_id_provided'=>false,
	        'business_tax_id'=>'21-3212321', 
	        'first_name'=>'Mister', 
	        'last_name'=>'Test', 
	        'dob' => '1988-09-01'
	        
	    );
	    */
	    
	    $acct->metadata = array(
	        'hms_id'=>'1918', 
	        'hotelix'=>'dc-booking-test'
	    );
	    $accept = $acct->save();
	    
	    echo "<pre>";
	    print_r($accept);
	}
	
	public function update_account2($stripe_account_id = "")
	{
	    require_once (APPPATH . 'libraries/stripe/init.php');
	    
	    $stripe = $this->Stripe->get_param_global();
	    
	    \Stripe\Stripe::setApiKey($stripe['secret_key']);
	    
	    if($stripe_account_id == "")
	        $stripe_account_id = $this->hotelix_config->get_record('stripe_account_id');
	        
	        $acct = \Stripe\Account::retrieve($stripe_account_id);
	        $acct->business_name = 'Test Company';
	        $acct->business_url ='https://dc-booking-test-book.otelms.com/bookit/step1';
	        $acct->business_primary_color  = '#000000'; // dOES IT INFLUENCE ATHING?
	        
	        $acct->charges_enabled  = false;
	        $acct->country  = 'US';
	        $acct->created  = time();
	        $acct->debit_negative_balances  = true;
	        $acct->default_currency = "usd";
	        $acct->details_submitted = false;
	        $acct->display_name = "Stripe.com";
	        $acct->email = "site@stripe.com";
	        $acct->external_accounts = array(
	            "object"=> "list",
	            "data" => array(),
	            "has_more"=> false,
	            "total_count"=> 0,
	            "url"=> "/v1/accounts/acct_1032D82eZvKYlo2C/external_accounts",
	        );
	        $acct->legal_entity  = array(
	            'additional_owners' => array(),
	            'address' => array(
	                "city" => null,
	                "country" => "US",
	                "line1" => null,
	                "line2" => null,
	                "postal_code" => null,
	                "state" => null,
	                
	            ),
	            'type'=>'company',
	            'business_name'=>'Test Company',
	            'business_tax_id_provided'=>false,
	            'business_tax_id'=>'21-3212321',
	            'first_name'=>'Mister',
	            'last_name'=>'Test',
	            'dob' => '1988-09-01'
	            
	        );
	        $acct->details_submitted = false;
	        $acct->details_submitted = false;
	        $acct->details_submitted = false;
	        
	        
	        $acct->decline_charge_on = array(
	            "avs_failure"=> false,
	            "cvc_failure" => true
	        );
	        
	        
	        $acct->account_holder_type = 'individual';
	        
	       
	         
	        
	        $acct->metadata = array(
	            'hms_id'=>'1918',
	            'hotelix'=>'dc-booking-test'
	        );
	        $accept = $acct->save();
	        
	        echo "<pre>";
	        print_r($accept);
	}
	
	public function link($stripe_account_id = "")
	{
	    require_once (APPPATH . 'libraries/stripe/init.php');
	     
	    $stripe = $this->Stripe->get_param_global("uk");
	     
	    \Stripe\Stripe::setApiKey($stripe['secret_key']);
	     
	    if($stripe_account_id == "")
	        $stripe_account_id = $this->hotelix_config->get_record('stripe_account_id');
	         
	        $acct = \Stripe\Account::retrieve($stripe_account_id);
	        
	        $accept = $acct->login_links->create();
	        
	         
	        echo "<pre>";
	        print_r($accept);
	}
	
	public function delete_account($stripe_account_id = "")
	 {
	     require_once (APPPATH . 'libraries/stripe/init.php');
	     
	     $stripe = $this->Stripe->get_param_global();
	     
	     \Stripe\Stripe::setApiKey($stripe['secret_key']);
	     
	     if($stripe_account_id == ""){
	       $stripe_account_id = $this->hotelix_config->get_record('stripe_account_id');
	       $this->hotelix_config->delete_record('stripe_account_id');
	       $this->hotelix_config->delete_record('stripe_secret');
	       $this->hotelix_config->delete_record('stripe_publishable');
	     }
	     
	     $account = \Stripe\Account::retrieve($stripe_account_id);
	     $delete_response = $account->delete();
	     
	     echo "<pre>";
	     print_r($delete_response);
	     
	 }
	 
	 function list_of_accounts()
    {
        require_once (APPPATH . 'libraries/stripe/init.php');
        
        $stripe = $this->Stripe->get_param_global();
        
        \Stripe\Stripe::setApiKey($stripe['secret_key']);
        
        $accounts_list = \Stripe\Account::all();
        echo count($accounts_list->data) . "----" . $accounts_list->data[0]->id . "<br>";
        
        $accounts_data = array();
        foreach ($accounts_list->data as $key => $account_cell) {
            
            $accounts_data[$key]["account_id"] = $account_cell->id;
            $accounts_data[$key]["apiKey"] = $stripe['secret_key'];
        }
        
        echo "<pre>";
        //echo $stripe['secret_key'];
        
        //print_r($accounts_data);
        //echo "<br><br><br><br>";
        print_r($accounts_list);
        
        $data = array(
            "accounts_data" => $accounts_data
        );
        $this->load->library('parser');
        $this->load->view('stripe_subaccount_list_of_accounts_view.php', $data);
    }
	 
	 function test() {
	     $data = array();
	     $tmpl = $this->parser->parse ( 'templates/stripe_subaccount_test_view.html', $data, true );
	     echo $tmpl;
	 }
}
?>