<?php
require_once (APPPATH . 'libraries/stripe/init.php');
class Stripe_billing extends CI_Controller {

	public function __construct()
       {
            parent::__construct();
            $this->load->model('stripe_billing_m');
            $this->load->model('hotelix_config');
            $this->stripe = new \Stripe\Stripe();
            $this->customer = new \Stripe\Customer();
            $this->plan = new \Stripe\Plan();
            $this->subscription = new \Stripe\Subscription();
            $this->invoice = new \Stripe\Invoice();
            $this->charge = new \Stripe\Charge();
            //$this->payments = new \Stripe\Payments();
	}


	function index() {

		$stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
		$data = array();
		$data['$stripe_billing_customer_id'] = $stripe_billing_customer_id;
		$this->parser->parse ( 'templates/stripe_billing/index.html', $data );

	}

	function customer_info() {
	    $stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
	    $secret_key = $this->stripe_billing_m->get_secret_key();

	    $this->stripe->setApiKey($secret_key);
	    $customer_obj = $this->customer->retrieve($stripe_billing_customer_id);

	    $customer = $customer_obj->__toArray(true);

	    echo '<table border="1">';
	    echo '
    			<tr>
    				<td>subscription id</td>
					<td>plan</td>
		    		<td>unsubscribing</td>
	        <td>change</td>
    			</tr>
	    	';
	    foreach ($customer['subscriptions']['data'] as $subscription) {
	    	echo '
    			<tr>
    				<td>'.$subscription['id'].'</td>
					<td>'.$subscription['plan']['id'].'</td>
					<td><a target="_blank" href="/stripe_billing/unsubscribe/'.$subscription['id'].'">unsubscribe</a></td>
					    <td><a target="_blank"  href="/stripe_billing/change_quantity/'.$subscription['id'].'">change</a></td>

    			</tr>
	    	';
	    }
	    echo '</table>';
	    echo '<pre>';

	    $is_main_id = -1;
	    if (isset($customer['subscriptions'])) {
	        foreach ($customer['subscriptions']['data'] as $id=>$cell) {
	            if (isset($cell['metadata']['is_main'])) {
	                if ($cell['metadata']['is_main'] == 1) {
	                    $is_main_id = $id;
	                    break;
	                }
	            }
	        }
	    }

	    echo date("F j, Y, g:i a", $customer['subscriptions']['data'][$is_main_id]['current_period_start']);
	    echo "\n";

	    echo date("F j, Y, g:i a", $customer['subscriptions']['data'][$is_main_id]['current_period_end']);
	    echo "\n";

	    echo date("F j, Y, g:i a", $customer['subscriptions']['data'][$is_main_id]['created']);
	    echo "\n";

	    echo $customer['subscriptions']['data'][$is_main_id]['billing'];
	    echo "\n";

	    echo $is_main_id . "---";

	    print_r($customer);

	}

	function create_customer() {

	    $host = "";
	    $sql = "SELECT host FROM visitka.config WHERE id = '".$this->config->item('hotel_id')."'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () != 0) {
	        $row = $query->row ();
	        $host = $row->host;
	    }

	    $stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
	    $secret_key = $this->stripe_billing_m->get_secret_key();

	    \Stripe\Stripe::setApiKey($secret_key);
	    $data = array();

	    $data['email'] = "hms_customer_" . $this->config->item('hotel_id') . "@otelms.com";
	    $data['description'] = "HMS customer " . $this->config->item('hotel_id') . "";
	    $data['metadata'] = array(
	        'hms_id' 	=> $this->config->item('hotel_id'),
	        'hms_url' 	=> $host,
	    );

	    $this->stripe->setApiKey("sk_test_D44UtbmH0yoFWIh8mj7q3Jcc");

	    $object = \Stripe\Customer::create($data);
	    $customer = $object->__toArray(true);

	    echo '<pre>';
	    print_r($customer);

	    if (isset($customer['id'])) {
	        $this->hotelix_config->set_record('stripe_billing_customer_id', $customer['id'], 'str');
	    }

	}

    function add_new_card( $customer = null )
	{
	    $publish_key = $this->stripe_billing_m->get_publish_key();
	    $secret_key = $this->stripe_billing_m->get_secret_key();
		if( $customer == null ){ exit( 'Please provide a customer' ); }
		if( $this->input->post() == null ){
			echo '
				<script src="https://js.stripe.com/v3/"></script>
				<form action="" method="post" id="payment-form">
				  <div class="form-row">
					<label for="card-element">
					  Credit or debit card
					</label>
					<div id="card-element">
					</div>
					<div id="card-errors" role="alert"></div>
				  </div>
				  <button>Submit Payment</button>
				</form>
				<script type="text/javascript">
					var stripe = Stripe("' . $publish_key . '");
					var elements = stripe.elements();
					var style = {
					  base: {
						color: "#32325d",
						lineHeight: "18px",
						fontFamily: "\"Helvetica Neue\", Helvetica, sans-serif",
						fontSmoothing: "antialiased",
						fontSize: "16px",
						"::placeholder": {
						  color: "#aab7c4"
						}
					  },
					  invalid: {
						color: "#fa755a",
						iconColor: "#fa755a"
					  }
					};
					var card = elements.create("card", {style: style});
					card.mount("#card-element");
					card.addEventListener("change", function(event) {
					  var displayError = document.getElementById("card-errors");
					  if (event.error) {
						displayError.textContent = event.error.message;
					  } else {
						displayError.textContent = "";
					  }
					});
					var form = document.getElementById("payment-form");
					form.addEventListener("submit", function(event) {
					  event.preventDefault();
					  stripe.createToken(card).then(function(result) {
						if (result.error) {
						  var errorElement = document.getElementById("card-errors");
						  errorElement.textContent = result.error.message;
						} else {
						  stripeTokenHandler(result.token);
						}
					  });
					});
					function stripeTokenHandler(token) {
					  var form = document.getElementById("payment-form");
					  var hiddenInput = document.createElement("input");
					  hiddenInput.setAttribute("type", "hidden");
					  hiddenInput.setAttribute("name", "stripeToken");
					  hiddenInput.setAttribute("value", token.id);
					  form.appendChild(hiddenInput);
					  form.submit();
					}
				</script>
			';
		}
		else {
			$this->stripe->setApiKey($secret_key);
			$customer = \Stripe\Customer::retrieve($customer);
			$customer->source = $this->input->post('stripeToken');
			$object = $customer->save();

			$result = $object->__toArray(true);
			echo '<pre>';
			print_r($result);
		}
	}


	function get_plans( $product = null ) {
		$stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
	    $publish_key = $this->stripe_billing_m->get_publish_key();
	    $secret_key = $this->stripe_billing_m->get_secret_key();

	    if( $product == null ){ exit( 'Please provide a proguct' ); }
	    $this->stripe->setApiKey($secret_key);
	    //$object = $this->plan->all( array( 'product' => $product ) );
	    $object = $this->plan->all(  );

	    $result = $object->__toArray(true);
	    echo '<table border="1">';
	    echo '
    			<tr>
    				<td>id</td>
					<td>nickname</td>
					<td>amount</td>
					<td>billing_scheme</td>
					<td>currency</td>
					<td>interval</td>
					<td>interval_count</td>
		    		<td>adding</td>
    			</tr>
	    	';
	    foreach ($result['data'] as $plan) {
	    	echo '
    			<tr>
    				<td>'.$plan['id'].'</td>
					<td>'.$plan['nickname'].'</td>
					<td>'.$plan['amount'].'</td>
					<td>'.$plan['billing_scheme'].'</td>
					<td>'.$plan['currency'].'</td>
					<td>'.$plan['interval'].'</td>
					<td>'.$plan['interval_count'].'</td>
					<td><a href="/stripe_billing/subscribe/'.$plan['id'].'/'.$stripe_billing_customer_id.'">add to subscriptions</a></td>
    			</tr>
	    	';
	    }
	    echo '</table>';
	    echo '<pre>';
	    print_r($result);
	}

	function charge_once( $customer = null, $summ = null, $currency = null ) {
	    $secret_key = $this->stripe_billing_m->get_secret_key();

	    if( $customer == null || $summ == null || $currency == null){exit( 'Plese provide a customer, summ and currency' );}
	    $curency = strtolower($currency);

	    \Stripe\Stripe::setApiKey($secret_key);



	    \Stripe\InvoiceItem::create(array(
	        'customer' => $customer,
	        'amount' => $summ,
	        'currency' => $curency,
	        'description' => 'Test payment ' . date('Y-m-d H:i:s'),  ));

	    $invoice = \Stripe\Invoice::create(array(
	        'customer' => $customer,
	        'auto_advance' => true,
	        'billing' => 'charge_automatically',));


	    $result = $invoice->__toArray(true);
	    echo '<pre>';
	    print_r($result);
	}


	public function unsubscribe( $subscription = null )
	{
	    if( $subscription == null ){exit( 'Please provide a subscription' );}
	    $secret_key = $this->stripe_billing_m->get_secret_key();
	    $this->stripe->setApiKey($secret_key);

	    $sub = \Stripe\Subscription::retrieve( $subscription );
	    $response_obj = $sub->cancel();

	    $response = $response_obj->__toArray(true);
	    echo '<pre>';
	    print_r($response);
	}

	public function get_balance( $customer_id = null )
	{
	    if( $customer_id == null ){exit('Please provide a customer');}
	    $this->stripe->setApiKey("sk_test_D44UtbmH0yoFWIh8mj7q3Jcc");
	    $customer_obj = \Stripe\Customer::retrieve($customer_id);
	    $balance = intval($customer_obj->account_balance)/-100;
	    echo '<pre>';
	    print_r($balance);
	}

	public function subscribe( $plan = null, $customer = null )
	{
	    if( $plan == null || $customer == null ){exit( 'Plese provide a plan and a customer' );}

	    $secret_key = $this->stripe_billing_m->get_secret_key();
	    $this->stripe->setApiKey($secret_key);

	    $subscription = \Stripe\Subscription::create(array(
	        'customer' => $customer,
	        'items' => array(array('plan' => $plan))));
	    $result = $subscription->__toArray(true);
	    echo '<pre>';
	    print_r($result);
	}

	public function update_customer( $customer_id = null )
	{
	    if( $customer_id == null ){ exit( 'Please provide customer_id' );}
	    if( $this->input->post() == null ){
	        $this->stripe->setApiKey("sk_test_D44UtbmH0yoFWIh8mj7q3Jcc");
	        $customer_obj = \Stripe\Customer::retrieve($customer_id);
	        $customer = json_decode(json_encode($customer_obj), true);
	        echo '
				<form method="post" action="">
					<table style="width: 500px">
						<tr>
							<td> Email </td>
							<td><input type="email" readonly name="email" value="' . $customer['email'] . '"/></td>
						</tr>
						<tr>
							<td> Subdomain </td>
							<td><input type="text" name="hotelix"/></td>
						</tr>
						<tr>
							<td> HMS_ID </td>
							<td><input type="number" name="hms_id"/></td>
						</tr>
					</table>
					<button type="submit"> Create </button>
				</form>
			';}
	        else {
	            $this->stripe->setApiKey("sk_test_D44UtbmH0yoFWIh8mj7q3Jcc");
	            $customer = \Stripe\Customer::retrieve($customer_id);
	            $customer->email = $this->input->post('email');
	            $customer->metadata = array(
	                'hotelix' => $this->input->post('hotelix'),
	                'hms_id' => $this->input->post('hms_id'),
	            );
	            $updated = $customer->save();
	            $result = json_decode(json_encode($updated), true);
	            echo '<pre>';
	            print_r($result);
	        }
	}

	public function charge_customer( $customer = null, $summ = null, $currency = null )
	{
	    if( $customer == null || $summ == null || $currency == null){exit( 'Plese provide a customer, summ and currency' );}
	    \Stripe\Stripe::setApiKey("sk_test_D44UtbmH0yoFWIh8mj7q3Jcc");

	    $charge = \Stripe\Charge::create(array(
	        'amount' => intval( $summ ),
	        'currency' => strtolower( $currency ),
	        'customer' => $customer,
	    ));
	    $result = json_decode( json_encode( $charge ), true );
	    echo '<pre>';
	    print_r($result);
	}

	public function change_quantity( $subscription = null, $quantity =
	    null )
	{
	    if( $subscription == null || $quantity == null ){exit( 'Plese
provide a subscription and a quantity' );}

	    $this->stripe->setApiKey("sk_test_D44UtbmH0yoFWIh8mj7q3Jcc");

	    $to_change = $this->subscription->retrieve( $subscription );
	    $to_change->quantity = intval( $quantity );
	    $to_change->prorate = true;
	    $to_change->save();

	    $result = $to_change->__toArray(true);

	    echo '<pre>';
	    print_r($result);

	}

	function save_plans_to_db( $product = null, $account_id = 0 ) {
	    //$stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
	    $publish_key = $this->stripe_billing_m->get_publish_key($account_id);
	    $secret_key = $this->stripe_billing_m->get_secret_key($account_id);
	    
	    
	    echo $publish_key . "-" . $secret_key;
	    echo "<br>";

	    if( $product == null ){ exit( 'Please provide a proguct' ); }
	    $this->stripe->setApiKey($secret_key);
	    //$object = $this->plan->all( array( 'product' => $product ) );
	    $conditions['limit'] = 100;
	    if ($product != null) {
	       $conditions['product'] = $product;
	    }
	    $object = $this->plan->all( $conditions );

	    $result = $object->__toArray(true);
	    echo "<pre>";
	    print_r($result);
	    //$result['data']
	    $tbl_tiers_name ='`global_hotelix`.`stripe_plans_tiers`';
	    foreach ($result['data'] as $plan) {
	        $has_tiers = 0;
	        $this->db->delete($tbl_tiers_name, array('plan_id' => $plan ['id']));
	        if(count($plan['tiers']) > 0){
	            $has_tiers = 1;
	            foreach ($plan ['tiers'] as $tier_id => $tier) {
	            	$insert_tier_arr = array (
	            			'plan_id' => $plan ['id'],
	            			'tier_id' => $tier_id,
	            			'flat_amount' => (int)$tier ['flat_amount']/100,
	            			'unit_amount' => (int)$tier ['unit_amount']/100,
	            			'up_to' => $tier ['up_to'] != "" ? $tier ['up_to'] : 999,//999 == max, said zapatustra
	            	);
	            	$this->db->insert($tbl_tiers_name, $insert_tier_arr);
	            }
	        }

	        $region_id = 0;
	        if(isset($plan['metadata']['region_id'])){
	            $region_id = $plan['metadata']['region_id'];
	        }

	        $type_id = 0;
	        if(isset($plan['metadata']['type_id'])){
	            $type_id = $plan['metadata']['type_id'];
	        }

	        $mcount = 0;
	        if(isset($plan['metadata']['mcount'])){
	            $mcount = $plan['metadata']['mcount'];
	        }

	        $is_premium = 0;
	        if(isset($plan['metadata']['is_premium'])){
	            $is_premium = $plan['metadata']['is_premium'];
	        }

	        $amount = $plan['amount']/100;
	        //$amount = $plan['amount'];

	        if ($this->config->item('hms_stripe_billing_test') == 1) {


	        }
	        $table_stripe_plans = "stripe_plans_temp";
	        //stripe_plans
	        $sql = "INSERT INTO `global_hotelix`." . $table_stripe_plans . " (plan_id, name, product_id,
	        is_active, has_tiers, amount, currency, interval_str, interval_count, region_id,
	        type_id, mcount, is_premium)
	        VALUES ('".$plan['id']."', '".$plan['nickname']."', '".$plan['product']."', '".$plan['active']."',
	        '".$has_tiers."', '".$amount."', '".$plan['currency']."',
	        '".$plan['interval']."', '".$plan['interval_count']."', '".$region_id."',
	        '".$type_id."', '".$mcount."', '".$is_premium."')
	        ON DUPLICATE KEY UPDATE
	        name = '".$plan['nickname']."',
	        product_id = '".$plan['product']."',
	        is_active = '".$plan['active']."',
	        has_tiers = '".$plan['nickname']."',
	        amount = '".$amount."',
	        currency = '".$plan['currency']."',
	        interval_str = '".$plan['interval']."',
	        interval_count = '".$plan['interval_count']."',
	        region_id = '".$region_id."',
	        type_id = '".$type_id."',
	        mcount = '".$mcount."',
	        is_premium = '".$is_premium."'";
	        $this->db->query( $sql );

	    }

	}

	public function get_invoices( $customer = null )
	{
	    if( $customer == null ){ exit( 'Please provide a customer' ); }
	    $this->stripe->setApiKey("sk_test_D44UtbmH0yoFWIh8mj7q3Jcc");

	    $list = $this->invoice->all(array("customer" => $customer));

	    $result = $list->__toArray(true);

	    echo '<pre>';
	    print_r( $result );

	}

	public function get_payments( $customer = null )
	{
	    if( $customer == null ){ exit( 'Please provide a customer' ); }
	    $this->stripe->setApiKey("sk_test_D44UtbmH0yoFWIh8mj7q3Jcc");

	    $list = $this->payment->all(array("customer" => $customer));

	    $result = $list->__toArray(true);

	    echo '<pre>';
	    print_r( $result );

	}


}

?>