<?php
class Stage_maintenance extends CI_Controller {
    public function __construct() {
        parent::__construct ();
        if (php_sapi_name() !== "cli") {
            $this->load->model ( 'Authorization' );
            $this->Authorization->IsLogined ();//this also load: model('frontdesk');
        }else{
            $this->load->model('frontdesk');
        }
        $this->load->model ( 'stripe_billing_m2' );//this also load:model('hotelix_config');model ( 'hms_routing_m2' );
    }
    
    public function index (){
        echo '<pre> in index';
    }
    
    public function test_analise($custom_db = null) {
        $where_arr = ['db_name !=' => ''];
        if (!is_null($custom_db)) {
            $where_arr['db_name'] = $custom_db;
        }
        $list = $this->db->select('db_name')->limit(10)->get_where('visitka.config', $where_arr)->result();
        foreach ($list as $hotel) {
            $this->analise_hotelstate_and_update_visitka($hotel->db_name);
        }
    }
    
    public function analise_hotelstate_and_update_visitka ($db_name = "local") {
        $hms_id = 0;
        if (!in_array($db_name, array("local", ""))){
            $query_hotel_row = $this->db->select('id')->get_where('visitka.config', ['db_name' => $db_name])->row();
            if ($query_hotel_row) {
                $hms_id = $query_hotel_row->id;
                $this->config->set_item('hotel_id', $hms_id);
                $config = array();
                $config['hostname'] = $this->config->item('visitka_host');
                $config['username'] = $this->config->item('visitka_user');
                $config['password'] = $this->config->item('visitka_pass');
                $config['database'] = $db_name;
                $config['dbdriver'] = "mysqli";
                $config['dbprefix'] = "";
                $config['pconnect'] = FALSE;
                $config['db_debug'] = TRUE;
                $config['cache_on'] = FALSE;
                $config['cachedir'] = "";
                $config['char_set'] = "utf8";
                $config['dbcollat'] = "utf8_general_ci";
                $this->db = $this->load->database($config, true);
            }else {
                echo '<pre>No db_name: '.$db_name;
            }
        }else {
            $hms_id = $this->config->item('hotel_id');
        }
        
        if ($hms_id) {
            $states_to_skip = [10];//[10] => Test Internal
            $current_state_id = $this->get_visitka_hotelstate(['hms_id' => $hms_id]);
            if (in_array($current_state_id, $states_to_skip)) {
                return;
            }
            $state_id_to_update = '-1';
            $invoice_for_pay_days = $this->hotelix_config->get_global_hotelix_record("stripe_opened_invoices_expired_days", 'int');
            $set_lost_status_days = 25;
            $set_todelete_status_days = 241;
            $hotelix_config_vars_values = [];
            $hotelix_config_vars = [
                ['name' => "stripe_billing_customer_id", 'format' => 'str'],
                ['name' => "stripe_subscription_id", 'format' => 'str'],
                ['name' => "stripe_sub_current_period_start", 'format' => 'int'],
                ['name' => "stripe_sub_current_period_end", 'format' => 'int'],
                ['name' => "hms_allowed", 'format' => 'int'],
                ['name' => "stripe_has_expired_invoices", 'format' => 'int'],
                ['name' => "stripe_has_opened_invoices", 'format' => 'int'],
                ['name' => "lock_till_open", 'format' => 'str'],
                ['name' => "stripe_access_be_closed_date", 'format' => 'str'],
                ['name' => "trial_date_start", 'format' => 'str'],
                ['name' => "trial_days_felt", 'format' => 'int'],
            ];
            
            foreach ($hotelix_config_vars as $hotelix_config_var) {
                $hotelix_config_vars_values[$hotelix_config_var['name']] = $this->hotelix_config->get_record($hotelix_config_var['name'], $hotelix_config_var['format']);
            }
            $hotelix_config_vars_values['stripe_sub_current_period_start'] = date('Y-m-d', $hotelix_config_vars_values['stripe_sub_current_period_start']);
            $hotelix_config_vars_values['stripe_sub_current_period_end'] = date('Y-m-d', $hotelix_config_vars_values['stripe_sub_current_period_end']);
            
            $body = [
                'hotelix_config_vars_values' => $hotelix_config_vars_values,
                'reason' => 'starting analise...'
            ];
            
            if ($hotelix_config_vars_values['trial_days_felt'] > 0) {
                $state_id_to_update = 0; //'trial';
                $body['reason'] = 'trial_days_felt >= '.$hotelix_config_vars_values['trial_days_felt'];
            } else {
                $hms_allowed = $this->hotelix_config->get_record('hms_allowed', 'int');
                
                if ($hms_allowed) {
                    $body['reason'] = 'hms_allowed = 1';
                    //$customer_id = $hotelix_config_vars_values['stripe_billing_customer_id'];
                    try {
                        $customer = $this->stripe_billing_m2->get_stripe_customer_info_obj();
                        
                        $body['customer'] = $customer;
                        
                        $main_subscription = false;
                        foreach ($customer->subscriptions->data as $subscription) {
                            if ($subscription->metadata->is_main) {
                                $main_subscription = $subscription;
                            }
                        }
                        if ($main_subscription->items->data{0}->plan->metadata->level == 'free') {
                            $state_id_to_update = 1; // 'free' coz plan is FREE
                            $body['reason'] .= ' and $main_subscription->items->data{0}->plan->metadata->level == free';
                            //dont forget set FREE in plan set if plan level free is set
                        } else {
                            $state_id_to_update = 4;//'active' coz plan level else that free is set;
                            $body['reason'] .= ' and ($main_subscription->items->data{0}->plan->metadata->level != free';
                        }
                    } catch (Exception $e) {
                        $body['reason'] .= ' Stripe ERROR: '.print_r($e->getHttpBody(), true);
                    }
                    
                }else {
                    //$state_id_to_update = 'LOST or TODELETE or smthg else...';
                    //dont forget unset LOSTDATE in plan set
                    $body['reason'] = 'hms_allowed = 0';
                    if ($hotelix_config_vars_values['stripe_has_expired_invoices']) {
                        $body['reason'] .= ' and stripe_has_expired_invoices';
                        
                        $closing_date = $hotelix_config_vars_values['stripe_access_be_closed_date'];
                        $days_past_after_closing = date_diff(date_create($closing_date), date_create())->days;
                        if ($days_past_after_closing > $set_todelete_status_days) {
                            $state_id_to_update = 7;//'to delete';
                            $body['reason'] .= " and days_past_after_closing $days_past_after_closing > $set_todelete_status_days days";
                        } elseif ($days_past_after_closing > $set_lost_status_days){
                            $state_id_to_update = 5;//'lost';
                            $body['reason'] .= " and days_past_after_closing $days_past_after_closing > $set_lost_status_days days";
                        }else{
                            $state_id_to_update = 6;//Blocked (Non Payment)
                            $body['reason'] .= " and days_past_after_closing $days_past_after_closing < $set_lost_status_days days";
                        }
                    } else {
                        if ($hotelix_config_vars_values['stripe_billing_customer_id'] == '' || 
                            $hotelix_config_vars_values['stripe_subscription_id'] == '') {
                            $body['reason'] .= '  and customer_id EMPTY or NO SUBSCRIPTION';
                            $state_id_to_update = 7;
                        }else{
                            $body['reason'] .= ' some else reason LOST OR TODELETE';
                            try {
                                $customer = $this->stripe_billing_m2->get_stripe_customer_info_obj();
                                
                                $body['customer'] = $customer->__toString();
                                
                                if (!count($customer->subscriptions->data)) {
                                    $state_id_to_update = 12;
                                    $body['reason'] .= ', NO SUBSCRIPTION!';
                                }
                            } catch (Exception $e) {
                                $body['reason'] .= ' Stripe ERROR: '.print_r($e->getHttpBody(), true);
                            }
                        }
                    }
                }
            }
            
            $hotelstates = $this->get_visitka_hotelstates();
                        
            $body['before'] = $current_state_id;
            $body['after'] = $state_id_to_update;
            
            if (php_sapi_name() !== "cli") {
                echo '<pre> hms_id: ';
                print_r($hms_id);
                echo '<br>';
                print_r($hotelix_config_vars_values);
                echo '<br>CURRENT STATE: ';
                print_r($current_state_id);
                echo ' -- ';
                print_r($hotelstates[$current_state_id]);
                echo '<br>ANALIZED STATE: ';
                print_r($state_id_to_update);
                echo ' -- ';
                if (isset($hotelstates[$state_id_to_update])) {
                    print_r($hotelstates[$state_id_to_update]);
                }else {
                    echo $state_id_to_update . ': undefined';
                }
                echo '<br>';
                print_r($body);
            }else {
                echo "hms_id: $hms_id, CURRENT STATE: $current_state_id, ANALIZED STATE: $state_id_to_update \n\n";
            }
            
            if ((int)$current_state_id !== (int)$state_id_to_update) {
                //$this->update_visitka_hotelstate();//$p = ['hms_id'=>null, 'hotelstate_id'=>null]
                $this->log_updateting_visitka_hotelstate(['hms_id'=>$hms_id, 'body'=>$body]);//$p = ['hms_id'=>null, 'body'=>null]
            }
        }else {
            echo 'No hms_id';
        }
   }
   
   public function update_visitka_hotelstate($p = ['hms_id'=>null, 'hotelstate_id'=>null]) {
       if (!is_null($p['hms_id']) && !is_null($p['hotelstate_id'])) {
           //$this->db->update('visitka.config', ['hotelstateid' => $p['hotelstate_id']], ['id' => $p['hms_id']]);
       }
   }
   
   private function log_updateting_visitka_hotelstate($p = ['hms_id'=>null, 'body'=>null]) {
       $tbl = 'global_hotelix_analitycs.hotelstate_updateting_visitka_log';
       if (!is_null($p['hms_id']) && !is_null($p['body'])) {
            $upd_arr = [
                'hms_id' => $p['hms_id'],
                'body' => json_encode($p['body']),
                'state_before' => isset($p['body']['before']) ? $p['body']['before'] : '',
                'state_after' => isset($p['body']['after']) ? $p['body']['after'] : '',
            ];
            $this->db->insert($tbl, $upd_arr);
       }
   }
   
   private function get_visitka_hotelstate($p = ['hms_id'=>null]) {
       $hotelstate_id = 'undefined';
       if (!is_null($p['hms_id'])) {
           $query_hotelstate = $this->db->get_where('visitka.config', ['id' => $p['hms_id']])->row();
           if ($query_hotelstate) {
               $hotelstate_id = $query_hotelstate->hotelstateid;
           }
       }
       return $hotelstate_id;
   }
   
   private function get_visitka_hotelstates() {
       $hotelstates = [];
       $query_hotelstates = $this->db->get('visitka.hotelstates')->result();
       foreach ($query_hotelstates as $hotelstate) {
           $hotelstates[$hotelstate->id] = $hotelstate->name;
       }
       return $hotelstates;
   }
}

/* Array
(
    [0] => Trial New
    [2] => ФМС
    [1] => Free
    [4] => Active
    [5] => Lost Client
    [6] => Blocked (Non Payment)
    [7] => To Delete
    [9] => Perm. Closure
    [10] => Test Internal
    [8] => Temp. Closure
    [11] => Mono Status
    [12] => NotSubscribed
) */