<?php

class Reviews_c2 extends CI_Controller
{

    public $review_id;

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Curl_model');
        $this->load->model('frontdesk');
        $this->load->model('htmltpl');
        $this->load->model('hotelix_config');
        $this->load->model('Authorization');
        $this->load->model('navigation');
        $this->load->model('mreviews');
        $this->load->model('Access');
        $this->load->model('releases');
        
        $this->Authorization->IsLogined();
    }

    public function set_review_id($review_id)
    {
        $this->review_id = $review_id;
    }

    function review_view($reservation_id)
    {
        $curl_data = array();
        $curl_data["reservation_id"] = $reservation_id;
        $curl_data["hotel_id"] = $this->config->item('hotel_id');
        $curl_data["return_with_services"] = 1;
        $output = json_encode($curl_data);
        
        $reviews_host = $this->config->item('reviews_host');
        $url = "https://" . $reviews_host . "/reviews_c2/get_review";
        
        $result = $this->Curl_model->CurlPlugMass($output, $url);
        $review_data = json_decode($result, true);
        // echo $result;
        // echo "<pre>";
        // print_r($review_data);
        // die();
        
        $active_questions = array();
        if (isset($review_data["active_questions"])) {
            $active_questions = $review_data["active_questions"];
        }
        $data = array();
        $data = array_merge($data, $review_data["review_data"]);
        $data["service_array"] = $review_data["service_array"];
        $data["reservation_id"] = $reservation_id;
        $data["active_questions"] = $active_questions;
        // $data = array_merge($data["service_array"], $review_data["service_array"]);
        // echo "<pre>";
        // print_r($data);
        // die();
        $this->load->library('parser');
        $this->load->view('reviews_c2/reviews_c2_review_view.php', $data);
    }

    function review_view_v2($reservation_id)
    {
        // $global_language = 0;
        // $query = $this->db->query("SELECT value FROM hotelix_config WHERE name LIKE 'global_language'");
        // if ($query->num_rows() > 0) {
        // $row = $query->row();
        // $global_language = $row->value;
        // }
        // $language_3char = "eng";
        // $sql = "SELECT global_hotelix.dic_languages.code, global_hotelix.dic_languages.3char as s_3char
        // FROM global_hotelix.dic_languages
        // WHERE global_hotelix.dic_languages.code = " . $global_language;
        // $query = $this->db->query($sql);
        // if ($query->num_rows() > 0) {
        // $row = $query->row();
        // if ($global_language == $row->code) {
        // $language_3char = $row->s_3char;
        // }
        // }
        $curl_data = array();
        $curl_data["reservation_id"] = $reservation_id;
        $curl_data["hotel_id"] = $this->config->item('hotel_id');
        $curl_data["return_with_services"] = 1;
        $curl_data["language_3char"] = $_SESSION['user']['language'];
        $output = json_encode($curl_data);
        
        $reviews_host = $this->config->item('reviews_host');
        $url = "https://" . $reviews_host . "/reviews_c2/get_review";
        
        $result = $this->Curl_model->CurlPlugMass($output, $url);
        $review_data = json_decode($result, true);
        
        // echo $result;
        // echo "<pre>";
        // print_r($curl_data);
        // print_r($review_data);
        // die();
        
        $active_questions = array();
        if (isset($review_data["active_questions"])) {
            $active_questions = $review_data["active_questions"];
        }
        $data = array();
        $data = array_merge($data, $review_data["review_data"]);
        $data["service_array"] = $review_data["service_array"];
        $data["reservation_id"] = $reservation_id;
        $data["active_questions"] = $active_questions;
        // $data = array_merge($data["service_array"], $review_data["service_array"]);
        // echo "<pre>";
        // print_r($data);
        // die();
        $this->load->library('parser');
        $this->load->view('reviews_c2/reviews_c2_review_view_v2.php', $data);
    }

    function reviews_list($page = 1)
    {
        /*   echo "<pre>";
         print_r($_POST);
         die();  */
        
        // ==== billing plan access start ==========
        $data_access = array(
            'module_name' => 'reputation'
        );
        $billing_plan_access = $this->Access->get_billing_plan_access($data_access);
        if ($billing_plan_access == 0) {
            die("<meta http-equiv='refresh' content='0;url=/errors_c2/view_error/52'>");
        }
        // ==== billing plan access end ==========
        
        $reset = 0;
        if (isset($_POST["reset_search_form"])) {
            if ($_POST["reset_search_form"] == 1) {
                $array_items = array(
                    'reviews_c2_list_date' => '',
                    'reviews_c2_list_reservation_id' => '',
                    'reviews_c2_list_status' => '',
                    'reviews_c2_list_experience_value' => ''
                );
                
                $this->session->unset_userdata($array_items);
                $reset = 1;
            }
        }
        
        if ($reset == 0) {
            if (isset($_POST["date"])) {
                $date = $_POST["date"];
                $newdata = array(
                    'reviews_c2_list_date' => $date
                );
                $this->session->set_userdata($newdata);
            }
            
            if (isset($_POST["reservation_id"])) {
                $newdata = array(
                    'reviews_c2_list_reservation_id' => $_POST["reservation_id"]
                );
                $this->session->set_userdata($newdata);
            }
            
            if (isset($_POST["status"])) {
                $newdata = array(
                    'reviews_c2_list_status' => $_POST["status"]
                );
                $this->session->set_userdata($newdata);
            }
            if(isset($_POST['lines_per_page'])){
                
                $newdata = array(
                    'reviews_c2_list_lines_per_page' => $_POST["lines_per_page"]
                );
                $this->session->set_userdata($newdata);
            }
            
            if (isset($_POST["experience_value"])) {
                // echo "<pre>";
                // print_r($_POST["experience_value"]);
                // die("DIED by A Department at reviews_c2.php reviews_list() on 2 июл. 2021 г. 11:26:57");
                foreach ($_POST["experience_value"] as $val) {
                    $statuses[$val] = $val;
                }
                $this->session->set_userdata(array(
                    'reviews_c2_list_experience_value' => $statuses
                ));
            }
        }
        if (isset($_POST["goto_page"])) {
            $page = $_POST["goto_page"];
        }
        
        $data = array();
        $data["current_page"] = $page;
        
        $this->load->library('parser');
        $this->load->view('reviews_c2/reviews_c2_reviews_list_view.php', $data);
    }

    function settings()
    {
        // ==== billing plan access start ==========
        $data_access = array(
            'module_name' => 'reputation'
        );
        $billing_plan_access = $this->Access->get_billing_plan_access($data_access);

        if ($billing_plan_access == 0) {
            die("<meta http-equiv='refresh' content='0;url=/errors_c2/view_error/52'>");
        }
        //die('end');
        // ==== billing plan access end ==========
        $data = array();
        $this->load->library('parser');
        $this->load->view('reviews_c2/reviews_c2_settings_view.php', $data);
    }

    function settings_post()
    {
        $this->mreviews->update_settings($_POST);
        die("<meta http-equiv='refresh' content='0;url=/reviews_c2/settings'>");
    }

    function ajax_sendrequest($return_json = 0)
    {
        
          $res= $this->mreviews->send_review_request( $_POST["reservation_id"],$return_json);
          if ($return_json == 0) {
          echo $res;
          } else {
          echo json_encode($res, true);
         
          }
          die();
       /*  
        $rid = $_POST["reservation_id"];
        $hotel_id = 0;
        $host = $_SERVER["HTTP_HOST"];
        
        $sql = "SELECT * FROM visitka.config WHERE host LIKE '$host'";
        $query = $this->db->query($sql);
        if ($query->num_rows() != 0) {
            $row = $query->row();
            $hotel_id = $row->id;
        }
        
        $reviews_is_active = 0;
        $sql = "SELECT is_active FROM modules WHERE name LIKE 'reviews_v2'";
        $query = $this->db->query($sql);
        if ($query->num_rows() != 0) {
            $row = $query->row();
            $reviews_is_active = $row->is_active;
        }
        
        $success_send = 0;
        
        if ($reviews_is_active == 1) {
            if ($hotel_id != 0 and $rid != 0) {
                $guest_citizenship_code = "";
                $property_id = 1;
                $sql = "SELECT categories.property_id, guests.firstname, guests.lastname, guests.email, guests.city, guests.citizenship_code, deskofreservation.datein, deskofreservation.dateout 
                FROM deskofreservation
                INNER JOIN guests ON guests.id = deskofreservation.guest_id
                INNER JOIN rooms ON rooms.id=deskofreservation.room_id
		        INNER JOIN categories ON categories.id=rooms.category_id
                WHERE deskofreservation.id = $rid";
                $query = $this->db->query($sql);
                
                if ($query->num_rows() > 0) {
                    $row = $query->row();
                    
                    $email = str_replace("%40", "@", $row->email);
                    $firstname = $row->firstname;
                    $lastname = $row->lastname;
                    $city_name = $row->city;
                    $datein = $row->datein;
                    $dateout = $row->dateout;
                    $guest_citizenship_code = $row->citizenship_code;
                    $property_id = $row->property_id;
                }
                
                // $query = $this->db->query ( "SELECT * FROM logo" );
                // $hotel_name = "";
                // if ($query->num_rows () > 0) {
                // $row = $query->row ();
                // $hotel_name = stripslashes ( $row->logo_title );
                // }
                
                $query = $this->db->query("SELECT property_name FROM  property_information WHERE id = $property_id");
                $hotel_name = "";
                if ($query->num_rows() > 0) {
                    $row = $query->row();
                    $hotel_name = stripslashes($row->property_name);
                }
                
                if ($guest_citizenship_code == "") {
                    $lang = "eng";
                } else {
                    $lang = strtolower($guest_citizenship_code);
                    if ($lang == "esp") {
                        $lang = "spa";
                    }
                    $localization_languages = $this->frontdesk_c2->get_local_active_localization_languages();
                    
                    if (! isset($localization_languages[$lang])) {
                        $lang = "eng";
                    }
                }
                
                $reviews_host = $this->config->item('reviews_host');
                
                $url_1 = "https://" . $reviews_host . "/reviews_c2/new_review/" . $rid . "/" . $hotel_id . "/2/" . uniqid($rid) . "?lang=" . $lang;
                $url_reviews_guest_book = $url_1;
                $url_2 = "https://" . $reviews_host . "/reviews_c2/new_review/" . $rid . "/" . $hotel_id . "/4/" . uniqid($rid);
                $url_3 = "https://" . $reviews_host . "/reviews_c2/new_review/" . $rid . "/" . $hotel_id . "/3/" . uniqid($rid);
                
                $url_img_email = "";
                $query = $this->db->query("SELECT str_value FROM hotelix_config WHERE name LIKE 'url_img_email'");
                if ($query->num_rows() > 0) {
                    $row = $query->row();
                    $url_img_email = stripslashes($row->str_value);
                }
                
                $data = array(
                    "hotel_id" => $hotel_id,
                    "host" => $host,
                    // "dbname" => $dbname,
                    "rid" => $rid,
                    // "uid" => "simplestring",
                    "uid" => uniqid($rid),
                    // "url" => $url,
                    "url_img_email" => $url_img_email,
                    "email" => $email,
                    "firstname" => $firstname,
                    "lastname" => $lastname,
                    "city_name" => $city_name,
                    "datein" => $datein,
                    "dateout" => $dateout,
                    "hotel_name" => $hotel_name
                );
                
                $output = json_encode($data);
                $url = "https://" . $reviews_host . "/reviews_c2/save_request_review";
                $result = $this->Curl_model->CurlPlugMass($output, $url);
                
                // send email
                ;
                $subj = $this->mlanguages->getdictionaryword("project_review ", $lang, "{clt_hotel_opinion}") . " " . $hotel_name . " (" . $rid . ")";
                
                $data_msg = array(
                    // "url" => $url,
                    "url_1" => $url_1,
                    "url_reviews_guest_book" => $url_reviews_guest_book,
                    "url_2" => $url_2,
                    "url_3" => $url_3,
                    "uid" => $data["uid"],
                    "url_img_email" => $data["url_img_email"],
                    
                    "reservation_id" => $data["rid"],
                    "hotel_id" => $data["hotel_id"],
                    "hotel_name" => $data["hotel_name"],
                    "firstname" => $data["firstname"],
                    "lastname" => $data["lastname"],
                    "datein" => $data["datein"],
                    "dateout" => $data["dateout"],
                    "city_name" => $data["city_name"]
                );
                
                $this->load->library('parser');
                $mail_body = $this->mreviews->get_record("mail_body");
                $this->mlanguages->getdictionary("project_review", $lang, $data_msg);
                
                $message = $this->parser->parse('templates/reviews_c2/reviews_c2_send_request.html', $data_msg, true);
                
                $this->load->library('email');
                
                $use_user_smtp = $this->hotelix_config->get_record("use_user_smtp", "int");
                
                $config = array();
                if ($use_user_smtp == 1) {
                    $config = $this->hms_mail->getparam(4);
                } else {
                    $config = $this->hms_mail->getparam(3);
                }
                
                // $url = "https://" . $host . "/outside_gate/Test/send_email";
                // //echo $url."<br>";;
                // $curl_data = array();
                // $curl_data["hotel_id"] = $this->config->item('hotel_id');
                // $curl_data["subject"] = $subj;
                // $curl_data["message"] = $message;
                // $curl_data["use_us"] = "";
                // $curl_data["email"] = $email;
                // $curl_data["property_name"] = "";
                
                // $curl_data["use_user_smtp"] = $this->hotelix_config->get_record("use_user_smtp", "int");
                
                // $email_config = array();
                // $email_config[4] = $this->hms_mail->getparam(4);
                // $email_config[3] = $this->hms_mail->getparam(3);
                // $email_config[2] = $this->hms_mail->getparam(2);
                // $email_config[1] = $this->hms_mail->getparam(1);
                
                // $curl_data["email_config"] = $email_config;
                
                // $output = json_encode($curl_data);
                
                // $result = $this->Curl_model->CurlPlugRaw_clean($output, $url);
                
                $this->email->initialize($config);
                $this->email->set_mailtype("html");
                
                $this->email->to($email);
                $this->email->set_mailtype("html");
                $this->email->subject($subj);
                $this->email->message($message);
                $from_caption = $this->mlanguages->getdictionaryword("state_lock", $lang, "{caption_customer_support}");
                $this->email->from($config['from'], $from_caption . ' OtelMS');
                
                if (! $this->email->send()) {
                    
                    $data_msg = array(
                        "id" => 103,
                        "message_text" => $this->email->print_debugger()
                    );
                    $header_messages = $this->load->view('header_msg_view', $data_msg, true);
                } else {
                    $success_send = 1;
                    $query = $this->db->query("UPDATE deskofreservation SET review_status = 1 WHERE id = " . $rid);
                    $data_msg = array(
                        "id" => 106
                    );
                    
                    // save review pending status
                    $pending_status = 3;
                    $sql = "INSERT INTO reviews_new(reservation_id, status) VALUES(" . $rid . ", " . $pending_status . ")
                    ON DUPLICATE KEY UPDATE status = " . $pending_status;
                    $query = $this->db->query($sql);
                    
                    $header_messages = $this->load->view('header_msg_view', $data_msg, true);
                }
            } else {
                $data_msg = array(
                    "id" => 104
                );
                $header_messages = $this->load->view('header_msg_view', $data_msg, true);
            }
        } else {
            $data_msg = array(
                "id" => 105
            );
            $header_messages = $this->load->view('header_msg_view', $data_msg, true);
        }
        
        if ($return_json == 0) {
            echo $header_messages;
        } else {
            $json_data = array();
            $json_data["header_messages"] = $header_messages;
            $json_data["success_send"] = $success_send;
            echo json_encode($json_data, true);
        }*/
    }

    function sendrequest_OLD($rid, $back_reservation = 0)
    {
        $hotel_id = 0;
        $host = $_SERVER["HTTP_HOST"];
        
        $sql = "SELECT * FROM visitka.config WHERE host LIKE '$host'";
        $query = $this->db->query($sql);
        if ($query->num_rows() != 0) {
            $row = $query->row();
            $hotel_id = $row->id;
        }
        
        $reviews_is_active = 0;
        $sql = "SELECT is_active FROM modules WHERE name LIKE 'reviews'";
        $query = $this->db->query($sql);
        if ($query->num_rows() != 0) {
            $row = $query->row();
            $reviews_is_active = $row->is_active;
        }
        
        if ($reviews_is_active == 1) {
            if ($hotel_id != 0 and $rid != 0) {
                $sql = "SELECT guests.firstname, guests.lastname, guests.email, guests.city, deskofreservation.datein, deskofreservation.dateout FROM deskofreservation
                INNER JOIN guests ON guests.id = deskofreservation.guest_id
                WHERE deskofreservation.id = $rid";
                $query = $this->db->query($sql);
                
                if ($query->num_rows() > 0) {
                    $row = $query->row();
                    
                    $email = str_replace("%40", "@", $row->email);
                    $firstname = $row->firstname;
                    $lastname = $row->lastname;
                    $city_name = $row->city;
                    $datein = $row->datein;
                    $dateout = $row->dateout;
                }
                $query = $this->db->query("SELECT * FROM logo");
                $hotel_name = "";
                if ($query->num_rows() > 0) {
                    $row = $query->row();
                    $hotel_name = stripslashes($row->logo_title);
                }
                
                // $url = "dev-ul2.otelms.com";
                $reviews_host = $this->config->item('reviews_host');
                $url_1 = "https://" . $reviews_host . "/reviews_c2/new_review/" . $rid . "/" . $hotel_id . "/2/" . uniqid($rid);
                $url_2 = "https://" . $reviews_host . "/reviews_c2/new_review/" . $rid . "/" . $hotel_id . "/4/" . uniqid($rid);
                $url_3 = "https://" . $reviews_host . "/reviews_c2/new_review/" . $rid . "/" . $hotel_id . "/3/" . uniqid($rid);
                // $query = $this->db->query ( "SELECT str_value FROM hotelix_config WHERE name LIKE 'feedback_emailurl'" );
                // if ($query->num_rows () > 0) {
                // $row = $query->row ();
                // $url = stripslashes ( $row->str_value );
                // }
                
                $url_img_email = "";
                $query = $this->db->query("SELECT str_value FROM hotelix_config WHERE name LIKE 'url_img_email'");
                if ($query->num_rows() > 0) {
                    $row = $query->row();
                    $url_img_email = stripslashes($row->str_value);
                }
                
                $data = array(
                    "hotel_id" => $hotel_id,
                    "host" => $host,
                    "rid" => $rid,
                    // "uid" => "simplestring",
                    "uid" => uniqid($rid),
                    // "url" => $url,
                    "url_img_email" => $url_img_email,
                    "email" => $email,
                    "firstname" => $firstname,
                    "lastname" => $lastname,
                    "city_name" => $city_name,
                    "datein" => $datein,
                    "dateout" => $dateout,
                    "hotel_name" => $hotel_name
                );
                
                $output = json_encode($data);
                $url = "https://" . $reviews_host . "/reviews_c2/save_request_review";
                $result = $this->Curl_model->CurlPlugMass($output, $url);
                // $array = json_decode ( $result, true );
                
                // send email
                $subj = "Ваше мнение об отеле " . $hotel_name . " (" . $rid . ")";
                $data_msg = array(
                    // "url" => $url,
                    "url_1" => $url_1,
                    "url_2" => $url_2,
                    "url_3" => $url_3,
                    "uid" => $data["uid"],
                    "url_img_email" => $data["url_img_email"],
                    
                    "reservation_id" => $data["rid"],
                    "hotel_id" => $data["hotel_id"],
                    "hotel_name" => $data["hotel_name"],
                    "firstname" => $data["firstname"],
                    "lastname" => $data["lastname"],
                    "datein" => $data["datein"],
                    "dateout" => $data["dateout"],
                    "city_name" => $data["city_name"]
                );
                
                $this->load->library('parser');
                // $message = $this->parser->parse ( 'templates/reviews_c2/reviews_orders_sendmail_view.html', $data_msg, true );
                $mail_body = $this->mreviews->get_record("mail_body");
                $message = $this->parser->parse_string(stripslashes($mail_body), $data_msg, true);
                
                $this->load->library('email');
                
                $config = array();
                $config = $this->hms_mail->getparam(3);
                
                $this->email->initialize($config);
                $this->email->set_mailtype("html");
                
                $this->email->to($email);
                $this->email->set_mailtype("html");
                $this->email->subject($subj);
                $this->email->message($message);
                $this->email->from($config['from'], 'Служба поддержки HMS OtelMS');
                
                if (! $this->email->send()) {
                    // $return_data ["send"] = 0;
                    // $return_data ["error"] = $this->email->print_debugger ();
                    die("<meta http-equiv='refresh' content='0;url=/errors/FreeError/23'>");
                } else {
                    $query = $this->db->query("UPDATE deskofreservation SET review_status = 1 WHERE id = " . $rid);
                    if ($back_reservation == 0) {
                        die("<meta http-equiv='refresh' content='0;url=/reviews_c2/reviews_list/1'>");
                    } else {
                        die("<meta http-equiv='refresh' content='0;url=/reservation_c2/folio/" . $rid . "/1'>");
                    }
                }
            } else {
                die("<meta http-equiv='refresh' content='0;url=/errors/FreeError/18'>");
            }
        } else {
            die("<meta http-equiv='refresh' content='0;url=/errors/FreeError/24'>");
        }
    }

    function new_review($rid, $hid, $status, $uid, $lang = "")
    {
        // echo "<pre>";
        // print_r($_SERVER["REQUEST_URI"]);
        if ($lang != "") {
            switch ($lang) {
                case "ua":
                    $_SESSION["lang"] = $lang;
                    break;
                case "ru":
                    $_SESSION["lang"] = $lang;
                    break;
                case "en":
                    $_SESSION["lang"] = $lang;
                    break;
                default:
                    $_SESSION["lang"] = "ru";
                    break;
            }
        }
        $host = "";
        // $host = "dev-ul2.otelms.com";
        // $query = $this->db->query ( "SELECT host, status FROM reservations WHERE hid = " . $hid . " AND rid = " . $rid . " AND uid = '" . $uid . "'" );
        // if ($query->num_rows () > 0 || 1 == 1) {
        if (1 == 1) {
            // $row = $query->row ();
            // $host = $row->host;
            // $status_db = $row->status;
            $status_db = 1; // test value
            
            if ($status_db != 1) {
                // die ( "Already done!" );
                $data = array(
                    "review_clone" => 1
                );
                $this->load->library('parser');
                $this->load->view('/reviews_c2/reviews_feedbacksave_view.php', $data);
            } else {
                switch ($status) {
                    case 4:
                        $sql = "INSERT INTO reviews_new (reservation_id, status) VALUES('" . $rid . "', '" . $status . "')";
                        $query = $this->db->query($sql);
                        
                        // $query = $this->db->query ( "UPDATE reservations SET status = 4 WHERE hid = $hid AND rid = $rid" );
                        /*
                         * $query = $this->db->query ( "SELECT hotel_id FROM orders WHERE id = $id AND pincode = $pincode" ); if ($query->num_rows () > 0) { $row = $query->row (); $hotel_id = $row->hotel_id; $data_curl = array (); $data_curl ["case_id"] = 0; $data_curl ["subject"] = "Сделано отзыв"; $data_curl ["email"] = ""; $data_curl ["firstname"] = ""; $data_curl ["lastname"] = ""; $data_curl ["description"] = ""; $data_curl ["phone"] = ""; $data_curl ["type"] = 4; $data_curl ["text"] = "http://sandbox-vps2.guestbe.com/bookit/step1/$hotel_id"; $data_curl ["referer_link"] = "http://sandbox-vps2.guestbe.com/bookit/step1/$hotel_id"; $this->Crmmodels->newmessage ( $data_curl ); } die ( "<meta http-equiv='refresh' content='0;url=/bookit/Messages/7'>" );
                         */
                        // $data = array (
                        // "status" => $status,
                        // "rid" => $rid,
                        // "uid" => $uid
                        // );
                        
                        // $output = json_encode ( $data );
                        // $url = "https://" . $host . "/gate/pushreview";
                        // // echo $url;
                        // $result = $this->Curl_model->CurlPlugMass ( $output, $url );
                        
                        $result = "";
                        $data = array(
                            "result" => $result
                        );
                        $this->load->library('parser');
                        $this->load->view('/reviews_c2/reviews_feedbacksave_view.php', $data);
                        break;
                    case 3:
                        $sql = "INSERT INTO reviews_new (reservation_id, status) VALUES('" . $rid . "', '" . $status . "')";
                        $query = $this->db->query($sql);
                        
                        // $query = $this->db->query ( "UPDATE reservations SET status = 3 WHERE hid = $hid AND rid = $rid" );
                        /*
                         * $query = $this->db->query ( "SELECT hotel_id FROM orders WHERE id = $id" ); if ($query->num_rows () > 0) { $row = $query->row (); $hotel_id = $row->hotel_id; $data_curl = array (); $data_curl ["case_id"] = 0; $data_curl ["subject"] = "Сделано отзыв"; $data_curl ["email"] = ""; $data_curl ["type"] = 4; $data_curl ["firstname"] = ""; $data_curl ["lastname"] = ""; $data_curl ["description"] = ""; $data_curl ["phone"] = ""; $data_curl ["text"] = "http://sandbox-vps2.guestbe.com/bookit/step1/$hotel_id"; $data_curl ["referer_link"] = "http://sandbox-vps2.guestbe.com/bookit/step1/$hotel_id"; $this->Crmmodels->newmessage ( $data_curl ); } die ( "<meta http-equiv='refresh' content='0;url=/bookit/Messages/7'>" );
                         */
                        // $data = array (
                        // "status" => $status,
                        // "rid" => $rid,
                        // "uid" => $uid
                        // );
                        
                        // $output = json_encode ( $data );
                        // $url = "https://" . $host . "/gate/pushreview";
                        // // echo $url;
                        // $result = $this->Curl_model->CurlPlugMass ( $output, $url );
                        
                        $result = "";
                        $data = array(
                            "result" => $result
                        );
                        $this->load->library('parser');
                        $this->load->view('/reviews_c2/reviews_feedbacksave_view.php', $data);
                        break;
                    default:
                        $data = array(
                            'rid' => $rid,
                            'hid' => $hid,
                            'host' => $host,
                            'status' => $status,
                            'uid' => $uid
                        );
                        $this->load->library('parser');
                        $this->load->view('/reviews_c2/reviews_c2_step1_view.php', $data);
                        break;
                }
            }
        } else {
            // die ( "Stop Spam!" );
            
            $data = array(
                "review_clone" => 1
            );
            $this->load->library('parser');
            $this->load->view('/reviews_c2/reviews_feedbacksave_view.php', $data);
        }
    }

    function FeedbackSave()
    {
        if (ISSET($_POST["main_reason"])) {
            $data = $_POST;
            // print_r($data);
            // die();
            unset($data["word_description"]);
            
            $data["main_reason"] = addslashes($data["main_reason"]);
            $data["guest_category"] = addslashes($data["guest_category"]);
            $data["hotel_positive"] = addslashes($data["hotel_positive"]);
            
            $data["hotel_not_positive"] = addslashes($data["hotel_not_positive"]);
            if (! isset($data["guestbe_easyuse"][0])) {
                $data["guestbe_easyuse"][0] = 0;
            }
            if (! isset($data["guestbe_hotelsprice"][0])) {
                $data["guestbe_hotelsprice"][0] = 0;
            }
            
            if (! isset($data["recomend_opinion"][0])) {
                $data["recomend_opinion"][0] = 0;
            }
            if (! isset($data["hotel_staff"])) {
                $data["hotel_staff"] = 0;
            }
            if (! isset($data["hotel_service"])) {
                $data["hotel_service"] = 0;
            }
            if (! isset($data["comfort"])) {
                $data["comfort"] = 0;
            }
            if (! isset($data["room_clean"])) {
                $data["room_clean"] = 0;
            }
            if (! isset($data["performence_price_ratio"])) {
                $data["performence_price_ratio"] = 0;
            }
            if (! isset($data["hotel_location"])) {
                $data["hotel_location"] = 0;
            }
            if (! isset($data["guestbe_hotelsinformation"][0])) {
                $data["guestbe_hotelsinformation"][0] = 0;
            }
            
            if (! isset($data["recommend"][0])) {
                $data["recommend"][0] = 0;
            }
            
            if (! isset($data["sign_name"])) {
                $data["sign_name"] = "";
            }
            
            if (isset($_SERVER['HTTP_X_REAL_IP'])) {
                $data["ip"] = $_SERVER['HTTP_X_REAL_IP'];
            } else {
                $data["ip"] = $_SERVER['REMOTE_ADDR'];
            }
            // print_r($data);
            $date = date("U");
            $query = $this->db->query("INSERT INTO reviews (timestamp, sign, sign_name, hotel_id, reservation_id, ip_address, main_reason, guest_category,
                hotel_staff,hotel_service, comfort,	room_clean, performence_price_ratio, hotel_location, hotel_positive,
                hotel_not_positive, recommend, guestbe_easyuse, guestbe_hotelsprice,
                guestbe_hotelsinformation, recomend_opinion) VALUES($date, '" . $data["sign"] . "', '" . $data["sign_name"] . "', " . $data["hid"] . ", " . $data["rid"] . ", '" . $data["ip"] . "', '" . $data["main_reason"] . "',
		'" . $data["guest_category"] . "', '" . $data["hotel_staff"] . "', '" . $data["hotel_service"] . "',
		'" . $data["comfort"] . "', '" . $data["room_clean"] . "', '" . $data["performence_price_ratio"] . "',
		'" . $data["hotel_location"] . "',
		'" . $data["hotel_positive"] . "', '" . $data["hotel_not_positive"] . "', '" . $data["recommend"][0] . "',
		'" . $data["guestbe_easyuse"][0] . "', '" . $data["guestbe_hotelsprice"][0] . "',
		'" . $data["guestbe_hotelsinformation"][0] . "', '" . $data["recomend_opinion"][0] . "')");
            
            $query = $this->db->query("UPDATE reservations SET status = " . $data["status"] . " WHERE hid = " . $data["hid"] . " AND rid = " . $data["rid"]);
            
            /*
             * $query = $this->db->query("SELECT hotel_id FROM orders WHERE id = $id"); if ($query->num_rows() > 0) { $row = $query->row(); $hotel_id = $row->hotel_id; $data_curl = array(); $data_curl["case_id"] = 0; $data_curl["subject"] = "Сделано отзыв"; $data_curl["email"] = ""; $data_curl["firstname"] = ""; $data_curl["lastname"] = ""; $data_curl["description"] = ""; $data_curl["phone"] = ""; $data_curl["type"] = 4; $data_curl["text"] = "http://sandbox-vps2.guestbe.com/bookit/step1/$hotel_id"; $data_curl["referer_link"] = "http://sandbox-vps2.guestbe.com/bookit/step1/$hotel_id"; $this->Crmmodels->newmessage($data_curl); }
             */
            $host = "";
            $host = "dev-ul2.otelms.com";
            $query = $this->db->query("SELECT host FROM visitka.config WHERE id = " . $data["hid"]);
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $host = $row->host;
            }
            
            $output = json_encode($data);
            $url = "https://" . $host . "/gate/pushreview";
            // echo $url;
            $result = $this->Curl_model->CurlPlugMass($output, $url);
            echo $result;
            $data = array(
                "result" => $result
            );
        } else {
            $data = array(
                "review_clone" => 1
            );
        }
        $this->load->library('parser');
        $this->load->view('reviews_feedbacksave_view.php', $data);
    }

    function step1()
    {
        $data = array();
        $this->load->library('parser');
        $this->load->view('/reviews_c2/reviews_c2_step1_view.php', $data);
    }

    function step1_post()
    {
        echo "<pre>";
        print_r($_POST);
        // die();
        $post = $_POST;
        
        $sql = "INSERT INTO reviews_new (reservation_id, status, experience_value, experience_title, experience_text, trip_type)
        VALUES('" . $post["reservation_id"] . "', '" . $post["status"] . "', '" . $post["experience_value"] . "', '" . addslashes($post["experience_title"]) . "',
        '" . addslashes($post["experience_text"]) . "', '" . $post["trip_type"] . "')";
        $query = $this->db->query($sql);
        
        $review_id = $this->db->insert_id();
        
        // $this->set_review_id($review_id);
        $_SESSION["review_id"] = $review_id;
        // die();
        die("<meta http-equiv='refresh' content='0;url=/reviews_c2/step2'>");
    }

    function step2()
    {
        $data = array();
        $this->load->library('parser');
        $this->load->view('/reviews_c2/reviews_c2_step2_view.php', $data);
    }

    function step2_post()
    {
        echo "<pre>";
        print_r($_POST);
        // die();
        $post = $_POST;
        
        $stay_problems = 0;
        if ($post["stay_problems"] == "select1yes") {
            $stay_problems = 1;
        }
        
        if ($_SESSION["review_id"] > 0) {
            $sql = "UPDATE reviews_new SET choice_types = '" . json_encode($post["choice_types"]) . "', wishes_of_stay = '" . json_encode($post["wishes_of_stay"]) . "',
            wishes_of_stay_specify = '" . addslashes($post["wishes_of_stay_specify"]) . "', stay_problems = '" . $stay_problems . "',
            bedroom_heating = '" . $post["bedroom_heating"] . "', bedroom_cleanliness = '" . $post["bedroom_cleanliness"] . "', bedroom_smell = '" . $post["bedroom_smell"] . "',
            bedroom_internet = '" . $post["bedroom_internet"] . "', stay_problems_specify = '" . $post["stay_problems_specify"] . "'
            WHERE id = " . $_SESSION["review_id"];
            $query = $this->db->query($sql);
        } else {
            $sql = "INSERT INTO reviews_new (choice_types, wishes_of_stay, wishes_of_stay_specify, stay_problems, bedroom_heating, bedroom_cleanliness,
            bedroom_smell, bedroom_internet, stay_problems_specify)
            VALUES('" . json_encode($post["choice_types"]) . "', '" . json_encode($post["wishes_of_stay"]) . "', '" . addslashes($post["wishes_of_stay_specify"]) . "',
            '" . $stay_problems . "', '" . $post["bedroom_heating"] . "', '" . $post["bedroom_cleanliness"] . "', '" . $post["bedroom_smell"] . "',
            '" . $post["bedroom_internet"] . "', '" . $post["stay_problems_specify"] . "')";
            $query = $this->db->query($sql);
            
            $review_id = $this->db->insert_id();
            $_SESSION["review_id"] = $review_id;
        }
        
        die("<meta http-equiv='refresh' content='0;url=/reviews_c2/step3'>");
    }

    function step3()
    {
        $data = array();
        $this->load->library('parser');
        $this->load->view('/reviews_c2/reviews_c2_step3_view.php', $data);
    }

    function step3_post()
    {
        echo "<pre>";
        print_r($_POST);
        // die();
        $post = $_POST;
        
        $arrival_check_in = "";
        if ($post["arrival_check_in"] != "") {
            $arrival_check_in = substr($post["arrival_check_in"], - 1);
        }
        
        $accommodation = "";
        if ($post["accommodation"] != "") {
            $accommodation = substr($post["accommodation"], - 1);
        }
        
        $breakfast = "";
        if ($post["breakfast"] != "") {
            $breakfast = substr($post["breakfast"], - 1);
        }
        
        if ($_SESSION["review_id"] > 0) {
            $sql = "UPDATE reviews_new SET recommend = '" . $post["recommend"] . "', arrival_check_in = '" . $arrival_check_in . "',
            accommodation = '" . $accommodation . "', breakfast = '" . $breakfast . "', checkin_type = '" . $post["checkin_type"] . "',
            checkin_improve = '" . json_encode($post["checkin_improve"]) . "', checkin_improve_specify = '" . addslashes($post["checkin_improve_specify"]) . "',
            accommodation_improve = '" . json_encode($post["accommodation_improve"]) . "',
            accommodation_improve_specify = '" . addslashes($post["accommodation_improve_specify"]) . "',
            breakfast_improve = '" . json_encode($post["breakfast_improve"]) . "',
            breakfast_improve_specify = '" . addslashes($post["breakfast_improve_specify"]) . "', staff = '" . $post["staff"] . "',
            departure_check_out = '" . $post["departure_check_out"] . "', money_value = '" . $post["money_value"] . "'
            WHERE id = " . $_SESSION["review_id"];
            $query = $this->db->query($sql);
        } else {
            $sql = "INSERT INTO reviews_new (recommend, arrival_check_in, checkin_type, checkin_improve, checkin_improve_specify, accommodation,
            accommodation_improve, accommodation_improve_specify, breakfast, breakfast_improve, breakfast_improve_specify, staff, departure_check_out, money_value)
            VALUES('" . $post["recommend"] . "', '" . $arrival_check_in . "', '" . addslashes($post["checkin_type"]) . "',
            '" . json_encode($post["checkin_improve"]) . "', '" . addslashes($post["checkin_improve_specify"]) . "', '" . $accommodation . "',
            '" . json_encode($post["accommodation_improve"]) . "', '" . addslashes($post["accommodation_improve_specify"]) . "',
            '" . $breakfast . "', '" . json_encode($post["breakfast_improve"]) . "', '" . addslashes($post["breakfast_improve_specify"]) . "',
            '" . $post["staff"] . "', '" . $post["departure_check_out"] . "', '" . $post["money_value"] . "' )";
            $query = $this->db->query($sql);
            
            $review_id = $this->db->insert_id();
            $_SESSION["review_id"] = $review_id;
        }
        
        die("<meta http-equiv='refresh' content='0;url=/reviews_c2/step4'>");
    }

    function step4()
    {
        $data = array();
        $this->load->library('parser');
        $this->load->view('/reviews_c2/reviews_c2_step4_view.php', $data);
    }

    function step4_post()
    {
        echo "<pre>";
        print_r($_POST);
        // die();
        $post = $_POST;
        
        if (isset($post["service_rating"])) {
            foreach ($post["service_rating"] as $service_id => $rating_value) {
                $rating = substr($rating_value, - 1);
                
                $sql = "INSERT INTO reviews_service_rating (review_id, service_id, rating)
                VALUES('" . $_SESSION["review_id"] . "', '" . $service_id . "', '" . $rating . "')
                ON DUPLICATE KEY UPDATE rating = '" . $rating . "'";
                $query = $this->db->query($sql);
            }
        }
        
        if (isset($post["service_improve"])) {
            foreach ($post["service_improve"] as $service_id => $improves) {
                foreach ($improves as $improve_id => $value) {
                    $sql = "INSERT INTO reviews_service_improve (review_id, service_id, improve_id)
                    VALUES('" . $_SESSION["review_id"] . "', '" . $service_id . "', '" . $improve_id . "')
                    ON DUPLICATE KEY UPDATE improve_id = '" . $improve_id . "'";
                    $query = $this->db->query($sql);
                }
            }
        }
        
        die("<meta http-equiv='refresh' content='0;url=/reviews_c2/step5'>");
    }

    function step5()
    {
        $data = array();
        $this->load->library('parser');
        $this->load->view('/reviews_c2/reviews_c2_step5_view.php', $data);
    }

    function step5_post()
    {
        echo "<pre>";
        print_r($_POST);
        // die();
        $post = $_POST;
        if ($_SESSION["review_id"] > 0) {
            $sql = "UPDATE reviews_new SET gender = '" . $post["gender"] . "', birth_year = '" . $post["birth_year"] . "', name = '" . $post["name"] . "'
            WHERE id = " . $_SESSION["review_id"];
            $query = $this->db->query($sql);
        } else {
            $sql = "INSERT INTO reviews_new (gender, birth_year, name)
            VALUES('" . $post["gender"] . "', '" . $post["birth_year"] . "', '" . $post["name"] . "')";
            $query = $this->db->query($sql);
            
            $review_id = $this->db->insert_id();
            $_SESSION["review_id"] = $review_id;
        }
        
        echo "Review is completed";
    }

    function questions_activity()
    {
        $data = array();
        $this->load->library('parser');
        $this->load->view('reviews_c2/reviews_c2_questions_activity_view.php', $data);
    }

    function ajax_question_isactive_check()
    {
        $post = $_POST;
        if ($post["bool_checked"] == "true") {
            $this->mreviews->insert_active_question($post["question_id"]);
        } else {
            $this->mreviews->delete_active_question($post["question_id"]);
        }
    }

    function ajax_update_reviews()
    {
        $TEST_MODE = 0;
        $post = $_POST;
        switch ($post['dc_id']) {
            case '0':
                $this->mreviews->update_otelms_reviews();
                break;
            case '1':
                $this->mreviews->get_reviews_from_booking($TEST_MODE);
                break;
            case '22':
                $this->mreviews->get_reviews_from_airbnb($TEST_MODE);
                break;
            case 'all':
                $this->mreviews->update_otelms_reviews();
                $this->mreviews->get_reviews_from_booking($TEST_MODE);
                $this->mreviews->get_reviews_from_airbnb($TEST_MODE);
                break;
        }
        $data = $this->mreviews->get_affected_channels();
        // $data[2]->error = null;
        echo json_encode($data);
    }

    function page_1()
    {
        $data = array();
        $this->load->library('parser');
        $this->load->view('reviews_c2/reviews_c2_page_1_view.php', $data);
    }

    function page_2()
    {
        $data = array();
        $this->load->library('parser');
        $this->load->view('reviews_c2/reviews_c2_page_2_view.php', $data);
    }

    function dashboard($page = 1)
    {
        // ==== billing plan access start ==========
        $data_access = array(
            'module_name' => 'reputation'
        );
        
        $billing_plan_access = $this->Access->get_billing_plan_access($data_access);
        if ($billing_plan_access == 0) {
            die("<meta http-equiv='refresh' content='0;url=/errors_c2/view_error/52'>");
        }
        // ==== billing plan access end ==========
        // $this->output->enable_profiler(TRUE);
        $post = $this->input->post();
        $this->load->model('dc_model');
        $data = array();
        if (isset($post["lines_per_page"])) {
            $this->session->set_userdata(array(
                'rws_dashboard_lines_per_page' => $post["lines_per_page"]
            ));
        }
        if (isset($post["goto_page"])) {
            $page = $post["goto_page"];
        }
        $data["current_page"] = $page;
        $this->load->view('reviews_c2/dashboard_view.php', $data);
    }

    function dashboard_post($dc_id_from_shapka = "")
    {
        $post = $this->input->post();
        if (! $post) {
            $post = (array) $this->session->userdata('rws_dashboard_session_data');
        }
        if ($dc_id_from_shapka != '') {
            $post['dc_id'] = $dc_id_from_shapka;
        }
        if (isset($post['reset_search_form']) && $post['reset_search_form'] == 1) {
            $ses_data = '';
        } else {
            $ses_data = $post;
        }
        $this->session->set_userdata(array(
            'rws_dashboard_session_data' => $ses_data
        ));
        die("<meta http-equiv='refresh' content='0; url=/reviews_c2/dashboard'>");
    }

    function configuration()
    {
        $data = array();
        $this->load->view('reviews_c2/configuration_view.php', $data);
    }

    function ajax_update_configuration()
    {
        $post = $this->input->post();
        if (isset($post['fild']) && isset($post['dc_id']) && isset($post['state'])) {
            $this->db->update('reviews_channels_config', array(
                $post['fild'] => $post['state']
            ), array(
                'dc_id' => $post['dc_id']
            ));
        }
    }

    function ajax_update_module_blocks()
    {
        $post = $this->input->post();
        $post['block_1'] = (isset($post['block_1']) && $post['block_1'] == 'true') ? 1 : 0;
        $post['block_2'] = (isset($post['block_2']) && $post['block_2'] == 'true') == 'true' ? 1 : 0;
        $post['hms_id'] = $this->config->item('hotel_id');
        $row_rw_data = $this->db->select('body, dc_id, score')
            ->get_where('reviews_all_channels', array(
            'id' => $post['id']
        ))
            ->row();
        $post['body'] = $row_rw_data->body;
        $post['dc_id'] = $row_rw_data->dc_id;
        $post['score'] = $row_rw_data->score;
        $post['hms_review_id'] = $post['id'];
        unset($post['id']);
        $url = "https://fr-online-booking.otelms.com/reviews/update_blocks_by_curl";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        $resronce = curl_exec($ch);
        $decoded_resronce = json_decode($resronce);
        $this->db->update('reviews_all_channels', $decoded_resronce->blocks, array(
            'id' => $post['hms_review_id']
        ));
        echo $resronce;
    }

    public function ajax_get_ch_error_description()
    {
        $post = $this->input->post();
        $tbl = "reviews_channels_config";
        $err_row = $this->db->get_where($tbl, array(
            'dc_id' => $post['dc_id']
        ))->row();
        $error_txt = "No errors";
        if ($err_row->error) {
            $error = json_decode($err_row->error);
            $error = json_decode($error->ch_resp);
            switch ($post['dc_id']) {
                case 1:
                    $error_txt = $error->errors[0]->message . '. ' . $error->errors[0]->code;
                    break;
                case 22:
                    $error_txt = $error->error_message;
                    break;
            }
        }
        echo $error_txt;
    }
    public function show_log($res_id=''){
        print_r($this->mreviews->show_sending_log($res_id));
    }
    public function auto_send_reviews($debug = 0)
    {
        $is_auto_send = $this->mreviews->get_record("auto_send", "int");
        $reservation_array = $this->mreviews->get_not_send_reviews_reservation();
        
        if ($is_auto_send == '1') {
            if ($debug == 1) {
                echo "<pre>";
                print_r($reservation_array);
                die();
            }
            foreach ($reservation_array as $reservation) {
                $this->mreviews->send_review_request($reservation->id);
            }
        }
        die();
    }
}
?>