<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Monobank extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('mlanguages');
        $this->load->model('htmltpl');
        $this->load->model('curl_model');
        $this->load->model('Authorization');
        $this->Authorization->IsLogined();

        $this->endpoint = "https://api.monobank.ua/";
            
    }

    public function settings()
    {

        $this->load->view ( 'monobank/settings_view.php');
    }

    public function settings_post()
    {
        $post = $this->input->post();
        
        $this->hotelix_config->set_record("monobank_token", $post['monobank_token']);
        $this->hotelix_config->set_record("monobank_partner", $post['id_partner'], 'int');
        $this->hotelix_config->set_record("monobank_payment_type", $post['type'], 'int');

        $this->load->view ( 'monobank/settings_view.php');
    }
    
    public function settings_test_token() {
        $ajax_post = json_decode(file_get_contents('php://input'));
        
        $curl_data = array();
        $curl_data['endpoint'] = $this->endpoint;
        $curl_data['token'] = $ajax_post->token;
        $curl_data['body'] = '';
        $result = $this->curl_model->CurlMonobank_test_token($curl_data);
        //print_r($result);
        $merchantName = '';
        if (isset($result->errCode)) {//so error
            $testing_result = $result->errorDescription;
            $merchantName = '';
            $this->hotelix_config->delete_record("monobank_merchant_name");
        }else{
            $testing_result = 'success';
            $merchantName = $result->merchantName;
            $this->hotelix_config->set_record("monobank_merchant_name", $merchantName);
        }
        echo json_encode(array('result_testing' => $testing_result, 'merchant_name' => $merchantName));
    }
}