<?php
class Factura extends CI_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('htmltpl');
		$this->load->model('Authorization');
		$this->load->model('factura_model');
		$this->load->library('m_pdf');
		$this->Authorization->IsLogined();
	}
	
	function facrura_list($page = 1){
	    if (isset ( $_POST ["lines_per_page"] )) {
	        $lines_per_page = $_POST ["lines_per_page"];
	        $newdata = array ('serviceslist_lines_per_page' => $lines_per_page);
	        $this->session->set_userdata ( $newdata );
	    }
	    if (isset ( $_POST ["goto_page"] )) {
	        $page = $_POST ["goto_page"];
	    }
	    $data = array();
	    $data["current_page"] = $page;
	    $this->load->library('parser');
	    $this->load->view('/factura/facrura_list_view.php', $data);
	}
		
	function create_pdf($factura_id){
	    
	    
	    $get_data = array();
	    $get_data ['factura_id'] = $factura_id;
	    $ServicesList = $this->factura_model->get_factura_items($get_data);
	    $summ_netto_val = 0;
	    $summ_vat = 0;
	    $summ_brutto_val = 0;
	    foreach($ServicesList as $cell){
	        $summ_brutto_val += $cell['summ_value'];
	        $summ_netto_val += $cell['amount_without_vat_value'];
	        $summ_vat += $cell['vat_amount_value'];
	    }
	    $factura_data = $this->db->select('res_id, number, date')->get_where('tbl_factura', array('id' => $factura_id))->row_array();
	    
	    $get_data = array();
	    $get_data ['res_id'] = $factura_data['res_id'];
	    $get_data ['factura_pdf_version'] = $this->releases->get_factura_pdf_version();
	    //print_r($get_data);
	    $factura_list = $this->factura_model->get_factura_amounts($get_data);
	    
	    $summ_total_pay_amount_brutto = 0;
	    $summ_total_pay_amount_netto = 0;
	    $summ_pay_all_amount = 0;
	    $sum_all_vat = 0;
	    $current_factura_sum_brutto = 0;
	    $current_factura_sum_netto = 0;
	    $current_factura_sum_vat = 0;
	    foreach($factura_list as $key => &$cell){
	        if($cell['total_pay_amount_brutto'] == 0){
	            unset($factura_list[$key]);
	        }
	        $summ_total_pay_amount_brutto += $cell['total_pay_amount_brutto'];
	        $summ_total_pay_amount_netto += $cell['total_pay_amount_netto'];
	        $summ_pay_all_amount += $cell['pay_all_amount'];
	        $sum_all_item_vat += $cell['sum_all_vat'];
	        
	        $cell['sum_all_vat'] = $this->frontdesk->showcurrency( $cell['sum_all_vat'] );
	        $cell['total_pay_amount_brutto'] = $this->frontdesk->showcurrency( $cell['total_pay_amount_brutto'] );
	        $cell['total_pay_amount_netto'] = $this->frontdesk->showcurrency( $cell['total_pay_amount_netto'] );
	        
	        if($cell['factura_id_list'] == $factura_id){
	            $current_factura_sum_brutto += $cell['total_pay_amount_brutto'];
	            $current_factura_sum_netto += $cell['total_pay_amount_netto'];
	            $current_factura_sum_vat += $cell['sum_all_vat'];
	        }
	    }
	    
	    $data = array();
	    $data ['factura_id'] = $factura_id;
	    $data ['factura_name'] = $factura_data['number'];
	    $data ['factura_date'] = $factura_data['date'];
	    $data ['services'] = $ServicesList;
	    $data ['factura_list'] = $factura_list;
	    $data ['summ_brutto_val'] = $this->frontdesk->showcurrency( $summ_brutto_val );
	    $data ['summ_netto_val'] = $this->frontdesk->showcurrency( $summ_netto_val );
	    $data ['summ_vat'] = $this->frontdesk->showcurrency( $summ_vat );
	    $data ['summ_total_pay_amount_brutto'] = $this->frontdesk->showcurrency( $summ_total_pay_amount_brutto );
	    $data ['summ_total_pay_amount_netto'] = $this->frontdesk->showcurrency( $summ_total_pay_amount_netto );
	    $data ['summ_pay_all_amount'] = $this->frontdesk->showcurrency( $summ_pay_all_amount );
	    $data ['summ_all_item_vat'] = $this->frontdesk->showcurrency( $sum_all_item_vat );
	    $data ['current_factura_sum_brutto'] = $this->frontdesk->showcurrency( $current_factura_sum_brutto );
	    $data ['current_factura_sum_netto'] = $this->frontdesk->showcurrency( $current_factura_sum_netto );
	    $data ['current_factura_sum_vat'] = $this->frontdesk->showcurrency( $current_factura_sum_vat );
	    
	    $this->mlanguages->getdictionary("payment", "", $data);
	    $content = $this->parser->parse('templates/factura/factura_pdf.html', $data, true);
	    
	    $filename = "factura.pdf";
	    
	    $this->m_pdf->pdf->WriteHTML($content);
	    $this->m_pdf->pdf->Output($filename, "I");
	}
	
	function ajax_get_parent_data(){
	    $res_id = $_POST["res_id"];
	    $parents = $this->factura_model->get_parent_data($res_id);
	    $output = array();
	    $output ['parents'] = $parents;
	    echo json_encode($output);
	}
}
?>