<?php
class Tvg_eb extends CI_Controller {
	static $debug_mode = FALSE;
	static $die_in_curl_debug_mode = FALSE;
	static $model_name = "Tvg_eb_mdl";
	static $model_path = "dc_tvg_eb/";
	public $test_av_req = '{
  "api_version": 8,
  "start_date": "2020-04-06",
  "end_date": "2020-04-08",
  "party": [
    {
      "adults": 3
    },
    {
      "adults": 2,
      "children": [
        9,
        5
      ]
    }
  ],
  "language": "en_US",
  "query_key": "6167a22d1f87d2028bf60a8e5e27afa7_191_1360299600000_2_2",
  "currency": "USD",
  "user_country": "US",
  "device_type": "Desktop",
  "availability_id": "a2fd740a-ad02-476d-b314-925a125509be",
  "requested_payload": {
    "categories": {
      "room_type_details": true,
      "rate_plan_details": true,
      "room_rate_details": true,
      "hotel_details": false
    },
    "category_modifiers": {
      "partner_booking_data": false,
      "real_time_pricing": false,
      "multiple_room_rates": true,
      "photos": true,
      "text": true
    }
  },
  "hotels": [{
      "ta_hotel_id": 258705,
      "partner_hotel_code": "92_1"
    },
    {
      "ta_hotel_id": 730099,
      "partner_hotel_code": "92_2"
    },
    {
      "ta_hotel_id": 555555,
      "partner_hotel_code": "92_3"
    }]

}';
	public $test_expanded_av_request = '{
  "api_version": 8,
  "start_date": "2020-04-08",
  "end_date": "2020-04-11",
  "party": [
    {
      "adults": 1
    },
    {
      "adults": 2,
      "children": [
        9,
        12
      ]
    }
  ],
  "language": "en_US",
  "currency": "USD",
  "user_country": "US",
  "device_type": "Desktop",
  "query_key": "TripAdvisorAPITest_795e8dbb-5aec-446a-94ae-71ff90ad3123",
  "availability_id": "TestAvailabilityId_32a79f78-70a2-416d-8eea-9eaa9d96de11",
  "requested_payload": {
    "categories": {
      "room_type_details": true,
      "rate_plan_details": true,
      "room_rate_details": true,
      "hotel_details": true
    },
    "category_modifiers": {
      "partner_booking_data": true,
      "real_time_pricing": true,
      "multiple_room_rates": true,
      "photos": true,
      "text": true
    }
  },
  "debug": false,
  "hotels": [
    {
      "ta_hotel_id": 1,
      "partner_hotel_code": "92_2"
    }
  ]
}';
	public $test_booking_request = '
	 {
  "api_version": 8,
  "start_date": "2020-04-08",
  "end_date": "2020-04-11",
  "partner_hotel_code": "92_2",
  "reference_id": "fbe3f396-3490-4d6f-94ee-5aa8c3a13938",
  "customer": {
    "first_name": "Lois",
    "last_name": "Spencer",
    "phone_number": "0-(109)767-8334",
    "email": "Lois.Spencer@test.tripadvisor.com",
    "country": "US"
  },
  "rooms": [
    {
      "party": {
        "adults": 2,
        "children": []
      },
      "traveler_first_name": "Lois",
      "traveler_last_name": "Spencer"
    }
  ],
  "payment_method": {
    "card_type": "AmericanExpress",
    "card_number": "378282246310005",
    "cardholder_name": "Lois Spencer",
    "expiration_month": "07",
    "expiration_year": "2025",
    "cvv": "2358",
    "billing_address": {
      "address1": "90883 Lyons Drive",
      "city": "Cotati",
      "state": "CO",
      "postal_code": "93394-6116",
      "country": "US"
    }
  },
  "final_price_at_booking": {
    "amount": 0,
    "currency": "UAH"
  },
  "final_price_at_checkout": {
    "amount": 369,
    "currency": "UAH"
  },
  "partner_data": {
    "rate_id": "119",
    "category_id": "3",
    "prop_id": "2",
    "requested_currency": "USD",
    "responsed_lang": "45"
  }
}
                                ';
	public $test_booking_cancel = '{
									  "api_version": 8,
									  "partner_hotel_code": "92_1",
									  "reservation_id": "19218_19219_19220"
									}';
	public $test_sync_booking = '[{"partner_hotel_code":"92_2","reservation_id":"19703"},{"partner_hotel_code":"92_2","reservation_id":"19704"},{"partner_hotel_code":"92_2","reservation_id":"19705"},
									{"partner_hotel_code":"92_2","reservation_id":"19706"},{"partner_hotel_code":"92_2","reservation_id":"19707_19708"}]';
	public $curl_urls;
    public function __construct() {
        parent::__construct();
        ini_set('error_reporting', E_STRICT);
        $model_name = self::$model_name;
        $model_path = self::$model_path;
        $this->load->model ( "$model_path$model_name" );
        $this->curl_urls = new CurlUrls();
    }
	function config() {//There are no request parameters on this GET request
    	$response = new ConfigResponse;
    	$response->configuration->add_emergency_contact('Volodimir Yadlovskiy','volodimir@otelms.com', '+380503718572');
    	$response->configuration->add_info_contact('Volodimir Yadlovskiy','volodimir@otelms.com', '+380503718572');
    	$response->send(self::$debug_mode);
    }

    function hotel_inventory () {//sending the parameters in a GET request
    	$model_name = self::$model_name;
    	$request = $_GET;
    	$response = new InventoryResponse($request);
    	$hotels_list = $this->$model_name->get_ta_hotels_inventory();
    	foreach ($hotels_list as $hotel) {
     		$hotel_inventory_data = $this->$model_name->get_hotel_inventory_data($hotel);
    		$response->add_hotel($hotel_inventory_data);
    	}
    	$response->send(self::$debug_mode);
    }

    function availability() { // sending the parameters in a POST request
    	$model_name = self::$model_name;
     	$this->$model_name->log_http_push();
		$postdata = (self::$debug_mode) ? $this->test_expanded_av_request : file_get_contents ( "php://input" );
    	$response = new AvailabilityResponse($postdata);//$this->test_av_req
		$requested_data = array (
				'start_intday' => $response->get_start_intday(),
				'end_intday'  => $response->get_end_intday(),
				'start_date' => $response->availability_request->start_date,
				'end_date' => $response->availability_request->end_date,
				'parties' => $response->availability_request->party,
				'language' => $response->availability_request->language,
				'currency' => $response->availability_request->currency,
				'persons' => $response->get_requested_guests_count(),
				'requested_flags' => $response->get_requested_flags()
		);
    	foreach ($response->hotels as $partner_hotel_code => $single_hotel_response) {
    		$hotel = $this->$model_name->get_ta_hotels($partner_hotel_code);
//     		if (empty($hotel)){return NULL;}
    		if($hotel['availability'] == 1){
    		    $requested_data['partner_hotel_code'] = $partner_hotel_code;
    		    $requested_data['hms_id'] = $hotel['hms_id'];
    		    $requested_data['host'] = $hotel['host'];
    		    $requested_data['prop_id'] = $hotel['prop_id'];
    		    $availability_data = $this->$model_name->get_hotel_availability_data ($requested_data);
    		    if (!empty($availability_data)){
    		        $single_hotel_response->response_type = 'available';
    		        if (isset($availability_data->hotel_details)){
    		            $availability_data->hotel_details = new HotelDetails($availability_data->hotel_details);
    		        }
    		        if (isset($availability_data->partner_booking_details)){
    		            $availability_data->partner_booking_details = new PartnerBookingDetails($availability_data->partner_booking_details);
    		        }
    		        $single_hotel_response->available = $availability_data;
    		    } else {
    		        $single_hotel_response->response_type = 'unavailable';
    		    }
    		}else {
    		    $single_hotel_response->response_type = 'unavailable';
    		}
    	}
     	$response->send(self::$debug_mode);
    }

    function booking_submit () {//sending the parameters in a POST request
    	$model_name = self::$model_name;
    	$booking_request_data = (self::$debug_mode) ? $this->test_booking_request : file_get_contents ( "php://input" );
    	$curl_url = $this->curl_urls->booking_request;
    	$response = new BookingSubmitResponse($booking_request_data);
    	$request = $response->get_request();
    	$hotel = $this->$model_name->get_ta_hotels($request->partner_hotel_code);
    	$curl_url = $hotel['host'].$curl_url;
    	$curl_url = "https://" . $curl_url;
     	$hms_reservation_data = json_decode($this->$model_name->curl_get_requested_data($booking_request_data, $curl_url));
    	$response->status = "Success";
    	$response->reservation->status = "Booked";
    	$response->reservation->reservation_id = $hms_reservation_data->hms_reservation_id;
    	$response->reservation->hotel = new HotelDetails($hms_reservation_data->hotel_details);
    	$response->reservation->line_items = $hms_reservation_data->line_items;
    	$response->reservation->confirmation_url = "https://book-".$hotel['host']."/reservations/ta_confirmation/?bid=".$hms_reservation_data->confirmation_url.
    												"&lang=".intval($hms_reservation_data->responsed_lang)."&currency=".$hms_reservation_data->requested_currency;
    	$response->send(self::$debug_mode);

    	$data = array (
    	    'partner_hotel_code' => $request->partner_hotel_code,
    	    'reservation_id' => $response->reservation->reservation_id,
    	    'response' => $response->get_response()
    	);
    	$this->db->insert ( 'dc_booking.ta_http_response', $data );
    }

    function booking_verify () {//sending the parameters in a GET request
        $where_arr = array('reservation_id' => $_GET['reservation_id'], 'partner_hotel_code' => $_GET['partner_hotel_code']);
        $row = $this->db->get_where('dc_booking.ta_http_response', $where_arr)->row();
        header ( 'Content-Type: application/json' );
        echo $row->response;
    	//$model_name = self::$model_name;
    }

    function booking_cancel () {//sending the parameters in a POST request
    	$model_name = self::$model_name;
    	$cancel_requested_data = (self::$debug_mode) ? $this->test_booking_cancel : file_get_contents ( "php://input" );
    	$response = new BookingCancelResponse($cancel_requested_data);
    	$request = $response->get_request();
    	$hotel = $this->$model_name->get_ta_hotels($request->partner_hotel_code);
    	$curl_url = $this->curl_urls->cancel_booking;
    	$curl_url = $hotel['host'].$curl_url;
    	$curl_url = "https://" . $curl_url;
    	$hms_cancelation_data = json_decode($this->$model_name->curl_get_requested_data($cancel_requested_data, $curl_url));
    	$response->status = $hms_cancelation_data->status;
    	$response->cancellation_number = $hms_cancelation_data->cancellation_number;
    	$response->send(self::$debug_mode);
    }

    function booking_sync () {//sending the parameters in a POST request
    	$model_name = self::$model_name;
    	$this->$model_name->log_http_push();
    	$sync_requested_data = (self::$debug_mode) ? $this->test_sync_booking : file_get_contents ( "php://input" );
    	$response = new BookingSyncResponse ($sync_requested_data);
    	$request = $response->get_request();
    	$curl_url = $this->curl_urls->sync_booking;
    	foreach ($request as $sync_single_hotel_data_set) {
    		$hotel = $this->$model_name->get_ta_hotels($sync_single_hotel_data_set->partner_hotel_code);
    		$single_hotel_curl_url = "https://" . $hotel['host'].$curl_url;
    		$hms_sync_data = json_decode($this->$model_name->curl_get_requested_data(json_encode($sync_single_hotel_data_set), $single_hotel_curl_url));
    		$response->add_SyncSingleHotelResponse($hms_sync_data);
    	}
    	$response->send(self::$debug_mode);
    }

    function room_information() {
//     	api_version=8&hotel={
//     		"ta_id": 0,
//     		"partner_hotel_code": "92_1",
//     		"partner_url": "www.test-dev.com"
//     	}&language_request=en_US

    }
}