<?php

class dc_onetwotrip_gate extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model ( 'dcm_abstract' );
        $this->load->model ( 'frontdesk' );
        $this->load->model ( 'dc_model' );
        $this->load->model ('Curl_model');
        $this->load->model ('dcm_onetwotrip');
        $this->load->model ('Loger_admin');
        $this->load->model ( 'bugs_loger' );
    }

    function get_booking($dc_hotel_id, $dc_reservation_id, $dc_status = "")
    {
        $account_id = array();
        $sql = "SELECT int_value FROM dc_onetwotrip_xml_cfg WHERE name LIKE 'hotel_id' AND int_value = " . $dc_hotel_id;
        $query = $this->db->query($sql);
        if ($query->num_rows() == 0) {
            echo "Wrong hotel_id " . $dc_hotel_id;
            die();
        }
        
        $txt = <<<EOT
<request>
<hotel_id>$dc_hotel_id</hotel_id>
<id>$dc_reservation_id</id>
</request>
EOT;
        
        $authparam = $this->dcm_onetwotrip->getauthparam();
        $url = $authparam["url"]."reservations";
        //$url = "https://sandbox-28.extranet.travel/chanman/v1/channel-managers/otel_ms/reservations";
        //echo $url;
        $data_result = $this->Curl_model->CurlPlugRAW_onetwotrip($txt, $url, array(
            "returntype" => "array"
        ), $authparam);
        
        // bugs log start
        if ($data_result['responseint'] == -1 || $data_result['http_error'] == 1) {
            $bugs_data = array();
            $bugs_data['http_code'] = $data_result['responseint'];
            $bugs_data['error_description'] = $data_result['curl_response_info'];
            $bugs_data['dc_id'] = 25;
            $this->bugs_loger->save_log($bugs_data);
        }
        // bugs log end
        
        $result = $data_result["result"];
        $reservations = new SimpleXMLElement($result);
        if (isset($reservations->reservation)) {
            $reservation_result = $this->dcm_onetwotrip->get_bookings($result, "", $dc_status);
        } else {
            $reservation_result = $result;
        }
        $this->Loger_admin->Save_SyncData("", "", $reservation_result, 25, 10, $data_result["dc_log_id"]);
        
        echo $reservation_result;
    }
}
?>