<?php
function objectToArray($d) {
	if (is_object ( $d )) {
		// Gets the properties of the given object
		// with get_object_vars function
		$d = get_object_vars ( $d );
	}
	
	if (is_array ( $d )) {
		// Return array converted to object Using __FUNCTION__ (Magic constant)
		// for recursive call
		return array_map ( __FUNCTION__, $d );
	} else {
		// Return array
		return $d;
	}
}
class dc_hostelworld_c2 extends CI_Controller {
	function __construct() {
		parent::__construct ();
		$this->load->model ( 'Curl_model' );
		$this->load->model ( 'dcm_hostelworld' );
		$this->load->model ( 'dcm_hostelworld_v2' );
		$this->load->model ( 'htmltpl' );
		$this->load->model ( 'dc_model' );
		$this->load->model ( 'frontdesk' );
		$this->load->model ( 'Authorization' );
		$this->load->model ( 'Loger_admin' );
		$this->Authorization->IsLogined ( "admin_access" );
		
		// ==== billing plan access start ==========
		$data_access = array('module_name' => 'channel_manager');
		$billing_plan_access = $this->Access->get_billing_plan_access($data_access);
		if($billing_plan_access == 0){
		    die ( "<meta http-equiv='refresh' content='0;url=/errors_c2/view_error/52'>" );
		}
		// ==== billing plan access end ==========
	}
	
	function test_bookings(){
	    $book = '{"api":{"status":"Success","callsremaining":1,"version":"3.86.18.2"},"result":{"bookingscount":1,"bookings":[{"ref":"317359-565798625","firstname":"Felix","lastname":"Kehm","email":"felixkehm@web.de","nationality":"Germany","phone":"","arrivaltime":"0","creationDateTime":"2024-11-29 03:11:03","roomnights":{"902630":{"2025-01-03":{"1032.75":{"pax":2,"rooms":1,"nonrefundable":0,"isbreakfastincluded":"0","rateplanid":730738}},"2025-01-04":{"1032.75":{"pax":2,"rooms":1,"nonrefundable":0,"isbreakfastincluded":"0","rateplanid":730738}}}},"due":"3511.35","paid":"619.65","paymenttype":"Deposit","OTAcommission":"619.65","OTADue":"0.00","nonrefundable":0,"currency":"PHP","card":"n\/a","gender":{"type":"MIXED","mixed":"2"},"cancellationrules":{"cancellableuntil":"2025-01-02 16:00:00","freeuntil":"2024-12-19 15:59:59"}}],"bookingstotal":1,"currency":"PHP","cancellationcount":0,"cancellationstotal":0}}';
	    $bookings_array = json_decode($book, true);
	    $this->dcm_hostelworld->get_bookings($bookings_array);
	}
	
	function catgories_edit() {
		$data = array ();
		$this->load->library ( 'parser' );
		
		$this->load->view ( 'dc_hostelworld_c2_catgories_edit_view_v2.php', $data );
	
	}
	function categories_edit_post() {
		echo "<pre>";
		print_r($_POST);
		$categories_link = $this->input->post ( 'categories', true );
		$data_1 = $this->Loger_admin->get_dccategories_multivalues ( "dc_hostelworld_room_categories_link" );
		// echo "<pre>";
		// print_r($categories_link);
		// die();
		$array_keys = array_keys ( $categories_link );
		foreach ( $array_keys as $key ) {
			
			$sql = "INSERT INTO dc_hostelworld_room_categories_link (dc_category_id, hms_category_id)
			values ('$key', $categories_link[$key])
			on duplicate key update hms_category_id = $categories_link[$key]";
			// echo $sql . "<br>";
			$this->db->query ( $sql );
		}
		$data_2 = $this->Loger_admin->get_dccategories_multivalues ( "dc_hostelworld_room_categories_link" );
		$this->Loger_admin->SaveLog_dc_multicol ( $data_1, $data_2, "loger_admin", "dc_hostelworld_room_categories_link", "edit" );
		 exit();
		die ( "<meta http-equiv='refresh' content='0;url=/dc_hostelworld_c2/catgories_edit'>" );
	}
	
	function categories_edit_post_v2() {
		$categories_link = $this->input->post ( 'c2o', true );
		$data_1 = $this->Loger_admin->get_dccategories_multivalues ( "dc_hostelworld_room_categories_link" );
		$data_category2occupancy_1 = $this->Loger_admin->get_dccategories_multivalues ( "dc_hostelworld_category2occupancy", 1 );
		$c2o = $_POST ['c2o'];
		$this->dcm_hostelworld_v2->category2occupancy_save_hostelworld ( $c2o );
		
		$data_2 = $this->Loger_admin->get_dccategories_multivalues ( "dc_hostelworld_room_categories_link" );
		$data_category2occupancy_2 = $this->Loger_admin->get_dccategories_multivalues ( "dc_hostelworld_category2occupancy", 1 );
		
		$this->Loger_admin->SaveLog_dc_multicol ( $data_1, $data_2, "loger_admin", "dc_hostelworld_room_categories_link", "edit" );
		$this->Loger_admin->SaveLog_dc_multicol ( $data_category2occupancy_1, $data_category2occupancy_2, "loger_admin", "dc_hostelworld_category2occupancy", "edit", 2 );
		//exit();
		die ( "<meta http-equiv='refresh' content='0;url=/dc_hostelworld_c2/catgories_edit'>" );
	}
	
	function rates_edit() {
		$data = array ();
		$this->load->library ( 'parser' );
		$version = $this->dcm_hostelworld->get_version ();
		
		$this->load->view ( 'dc_hostelworld_c2_rates_edit_view_v2.php', $data );
			
	}
	function rates_edit_post() {
		$rates = $this->input->post ( 'rates', TRUE );
		$rates_restrict = $this->input->post ( 'rates_restrict', TRUE );
		// print_r($rates_restrict);
		// die();
		
		$data_1 = $this->Loger_admin->get_dcrate_multivalues ( "dc_hostelworld_rate_link" );
		
		foreach ( $rates as $key => $value ) {
			$sql = "INSERT INTO dc_hostelworld_rate_link (dc_rate_id, hms_rate_id, restrict_id) values ($key, $value, " . $rates_restrict [$key] . ")
			on duplicate key update hms_rate_id=$value, restrict_id = " . $rates_restrict [$key];
			$this->db->query ( $sql );
		}
		
		$data_2 = $this->Loger_admin->get_dcrate_multivalues ( "dc_hostelworld_rate_link" );
		$this->Loger_admin->SaveLog_dc_multicol ( $data_1, $data_2, "loger_admin", "dc_hostelworld_rate_link", "edit" );
		
		die ( "<meta http-equiv='refresh' content='0;url=/dc_hostelworld_c2/rates_edit'>" );
	}
	
	function rates_edit_post_v2() {
		$r2c = $_POST['r2c'];
		$this->dcm_hostelworld_v2->rate2category_save($r2c);
		
		die ( "<meta http-equiv='refresh' content='0;url=/dc_hostelworld_c2/rates_edit'>" );
	}
	
	function options() {
		$data = array ();
		$this->load->library ( 'parser' );
		$this->load->view ( 'dc_hostelworld_c2_options_view.php', $data );
	}
	function options_post() {
		$post = $_POST;
		$this->dcm_hostelworld->options_save ( $post );
		die ( "<meta http-equiv='refresh' content='0;url=/dc_hostelworld_c2/options'>" );
	}
	function ra_params_edit() {
		$data = array ();
		$this->load->library ( 'parser' );
		$this->load->view ( 'dc_hostelworld_c2_ra_params_edit_view.php', $data );
	}
	function ra_params_edit_post() {
		// echo "<pre>";
		// print_r($_POST);
		$ra_params = $this->input->post ( 'ra' );
		$rooms = $this->input->post ( 'rooms' );
		foreach ( $rooms as $dc_room_id => $cell ) {
			$this->db->update ( 'dc_hostelworld_room_categories_link', array (
					'min' => $cell ['min'],
					'max' => $cell ['max'] 
			), array (
					'dc_category_id' => $dc_room_id 
			) );
		}
		
		die ( "<meta http-equiv='refresh' content='0;url=/dc_hostelworld_c2/ra_params_edit'>" );
	}
	
	function reservations_form() {
		$data = array ();
		$this->load->library ( 'parser' );
		$this->load->view ( 'dc_hostelworld_c2_reservations_form_view.php', $data );
	}
	function reservations_post() {
		$debug = false;
		if ($this->session->userdata ( 'global_debug' ) == 1) {
			$debug = true;
		}
		
		$data = array ();
		
		/*
		 * get authparam
		 */
		
		$authparam = $this->dcm_hostelworld->getauthparam ();
		
		$consumer_key = $authparam ["consumer_key"];
		$secret = $authparam ["secret"];
		$propN = $authparam ["hotel_id"];
		$prop_user = 'manager';
		$prop_pass = $authparam ["prop_pass"];
		
		$consumer_signature = sha1 ( $consumer_key . "--" . $secret . "--" . $prop_pass );
		$data ['consumer_key'] = $consumer_key;
		$data ['consumer_signature'] = $consumer_signature;
		$txt = '<request></request>';
		$url = "https://property.xsapi.webresint.com/1.2/getnewbookingscount/" . $propN . ".json?consumer_key=" . $consumer_key . "&consumer_signature=" . $consumer_signature;
		$result = $this->Curl_model->CurlPlugRAW ( $txt, $url, 8 );
		
		// $result = '{"api":{"status":"Success","callsremaining":1,"version":"1.2.22.7"},"result":{"properties":{"85991":{"cancellations":"0","bookings":"4"}},"requirecall":1,"count":1}}';
		
		// echo $result;
		
		$array = json_decode ( $result );
		$array = objectToArray ( $array );
		
		if ($debug == true) {
			echo "<pre>";
			print_r ( $array );
		}
		
		$totalcount = 0;
		if (isset ( $array ["result"] ["properties"] [$propN] ["bookings"] )) {
			$totalcount += $array ["result"] ["properties"] [$propN] ["bookings"];
		}
		if (isset ( $array ["result"] ["properties"] [$propN] ["bookings"] )) {
			$totalcount += $array ["result"] ["properties"] [$propN] ["cancellations"];
		}
		
		if ($totalcount > 0) {
			//echo $result;
		} else {
			$this->Loger_admin->Save_SyncData ( "", "", "nothing", 8, 10, 0 );
			//echo "nothing";
			$data = array (
			    "result" => "nothing"
			);
			$this->load->library ( 'parser' );
			$this->load->view ( 'dc_hostelworld_c2_reservations_form_view.php', $data );
			return;
		}
		
		$url = "https://property.xsapi.webresint.com/1.2/getnewbookings/" . $propN . ".json?consumer_key=" . $consumer_key . "&consumer_signature=" . $consumer_signature;
		$txt = '<request></request>';
		$data_result = $this->Curl_model->CurlPlugRAW ( $txt, $url, 8, array("returntype" => "array"));
		// echo $url;
		// print_r ( $result );
		// die();
		$result = $data_result["result"];
		$array = json_decode ( $result );
		$array = objectToArray ( $array );
		if ($debug == true) {
			echo "<pre>";
			print_r ( $array );
		}
		
		$result_arr = $this->dcm_hostelworld->get_bookings ( $array );
		$this->Loger_admin->Save_SyncData ( "", "", json_encode($result_arr, true), 8, 10, $data_result ["dc_log_id"] );
		if ($debug == true)
			print_r ( $result_arr );
		
		$totalack = 0;
		$bookings_ack_block = "";
		$bookings_ack_cancel_block = "";
		
		if (isset ( $result_arr ["ack_bookings"] ["bookings"] )) {
			if (sizeof ( $result_arr ["ack_bookings"] ["bookings"] ) > 0) {
				$data = array ();
				$data ['ack_booking'] = $result_arr ["ack_bookings"] ["bookings"];
				$txt = $this->parser->parse ( 'templates/xml/dc_hostelsworld_ack.xml', $data, true );
				$bookings_ack_block = $txt;
				$totalack ++;
			}
		}
		if (isset ( $result_arr ["ack_bookings"] ["cancellations"] )) {
			if (sizeof ( $result_arr ["ack_bookings"] ["cancellations"] ) > 0) {
				$data = array ();
				$data ['ack_booking'] = $result_arr ["ack_bookings"] ["cancellations"];
				$txt = $this->parser->parse ( 'templates/xml/dc_hostelsworld_ack_cancel.xml', $data, true );
				$bookings_ack_cancel_block = $txt;
				$totalack ++;
			}
		}
		
		if ($totalack > 0) {
			$url = "https://property.xsapi.webresint.com/1.2/ackbookings/" . $propN . ".json?consumer_key=" . $consumer_key . "&consumer_signature=" . $consumer_signature;
			$data = array ();
			$data ['bookings'] = $bookings_ack_block;
			$data ['cancellations'] = $bookings_ack_cancel_block;
			$txt = $this->parser->parse ( 'templates/xml/dc_hostelsworld_ack_all.xml', $data, true );
			$result = $this->Curl_model->CurlPlugRAW ( $txt, $url, 8 );
			if ($debug == true)
				print_r ( $result );
			$array = json_decode ( $result );
			$array = objectToArray ( $array );
			if ($debug == true)
				print_r ( $array );
		}
		
		$data = array (
				"result" => $result_arr ["view_data"] 
		);
		$this->load->library ( 'parser' );
		$this->load->view ( 'dc_hostelworld_c2_reservations_form_view.php', $data );
	}
	function get_bookings_formfile() {
		$str_data = file_get_contents ( $_FILES ['file_data'] ['tmp_name'] );
		// echo $str_data;
		$array = json_decode ( $str_data );
		
		$array = objectToArray ( $array );
		echo "<pre>";
		print_r ( $array );
		//die();
		$ack_bookings = $this->dcm_hostelworld->get_bookings ( $array );
	}
	
	function get_room_categories($die_option = 0) {
		$data = array ();
		
		$authparam = $this->dcm_hostelworld->getauthparam ();
		
		$consumer_key = $authparam ["consumer_key"];
		$secret = $authparam ["secret"];
		$propN = $authparam ["hotel_id"];
		$prop_user = 'manager';
		$prop_pass = $authparam ["prop_pass"];
		
		$consumer_signature = sha1 ( $consumer_key . "--" . $secret . "--" . $prop_pass );
		
		$data ['consumer_key'] = $consumer_key;
		$data ['consumer_signature'] = $consumer_signature;
		
		$txt = <<<EOT
<request>
  
</request>
	
EOT;
		$url = "https://property.xsapi.webresint.com/1.2/getavailabilityrequest/" . $propN . ".json?consumer_key=" . $consumer_key . "&consumer_signature=" . $consumer_signature;
		
		$txt = "<request></request>";
		$url = "https://property.xsapi.webresint.com/1.2/getroomtypes/" . $propN . ".json?consumer_key=" . $consumer_key . "&consumer_signature=" . $consumer_signature;
		// echo $url."<br>";
		$data_result = $this->Curl_model->CurlPlugRAW ( $txt, $url, 8, array (
					"returntype" => "array"
		));
		$result = $data_result["result"];
		
		$array = json_decode ( $result );
		// $array = new SimpleXMLElement ( $result );
		
		$array = objectToArray ( $array );
		if($die_option == 0){
			echo "<pre>";
			print_r ( $array );
			die();
		}
		$count_rooms = count ( $array );
		// echo $count_rooms;
		// die();
		if (isset ( $array ["api"] )) {
			if ($array ["api"] ["status"] == "Success") {
				foreach ( $array ["result"] ["roomtypes"] as $key => $value ) {
					$sql = "SET NAMES 'utf8';";
					$query = $this->db->query ( $sql );
					
					$value ["displayname"] = addslashes($value ["displayname"]);
					$value ["roomtypename"] = addslashes($value ["roomtypename"]);
					
					$sql = "INSERT INTO dc_hostelworld_room_categories_link(dc_category_id, dc_name, displayname, basictype, beds)
					VALUES('" . $value ["roomtypeid"] . "',
					'" . utf8_decode($value ["roomtypename"]) . "', '" . $value ["displayname"] . "', '" . $value ["basictype"] . "', '" . $value ["beds"] . "')
					ON DUPLICATE KEY UPDATE dc_name = '" . utf8_decode($value ["roomtypename"]) . "', displayname = '" . $value ["displayname"] . "',
					basictype = '" . $value ["basictype"] . "', beds = '" . $value ["beds"] . "'";
					// echo $sql;
					$query = $this->db->query ( $sql );
				}
			}
		}
		
		$this->Loger_admin->Save_SyncData ( "", "", $data_result['result'], 8, 13, $data_result ["dc_log_id"] );
		
		if($die_option == 1){
			$_SESSION["dc_msg"]["text"] = $result;
			die ( "<meta http-equiv='refresh' content='0;url=/dc_hostelworld_c2/catgories_edit'>" );
		}
	}
	
function get_rates($die_option = 0) {
		$data = array ();
		
		$authparam = $this->dcm_hostelworld->getauthparam ();
		
		$consumer_key = $authparam ["consumer_key"];
		$secret = $authparam ["secret"];
		$propN = $authparam ["hotel_id"];
		$prop_user = 'manager';
		$prop_pass = $authparam ["prop_pass"];
		
		$consumer_signature = sha1 ( $consumer_key . "--" . $secret . "--" . $prop_pass );
		
		$data ['consumer_key'] = $consumer_key;
		$data ['consumer_signature'] = $consumer_signature;
		
		$txt = "<request></request>";
		$url = "https://property.xsapi.webresint.com/1.2/getrateplans/" . $propN . ".json?consumer_key=" . $consumer_key . "&consumer_signature=" . $consumer_signature;
		//echo $url . "<br>";
		
		$data_result = $this->Curl_model->CurlPlugRAW ( $txt, $url, 8, array("returntype" => "array") );
		$result = $data_result['result'];
		
		$array = json_decode ( $result );
		// $array = new SimpleXMLElement ( $result );
		
		$array = objectToArray ( $array );
		if ($die_option == 0) {
			echo "<pre>" . $result;
			print_r ( $array );
			//die();
		}
		$count_rooms = count ( $array );
		// echo $count_rooms;
		// die();
		if (isset ( $array ["api"] )) {
			if ($array ["api"] ["status"] == "Success") {
			    $rates = array();
				if(isset($array ["result"]["ratePlans"])){
					$rates = $array ["result"]["ratePlans"];
				}else{
				    if(isset($array ["result"]["rateplans"])){
				        $rates = $array ["result"]["rateplans"];
				    }else{
					   $rates = $array ["result"];
				    }
				}
				foreach ( $rates as $rate_id => $rate_data ) {
					$sql = "SET NAMES 'utf8';";
					$query = $this->db->query ( $sql );
					
					$weekendrate = 0;
					if(isset($rate_data ["weekendrate"])){
					    $weekendrate = $rate_data ["weekendrate"];
					}
					
					$weekdayrate = 0;
					if(isset($rate_data ["weekdayrate"])){
					    $weekdayrate = $rate_data ["weekdayrate"];
					}
					
					$sql = "INSERT INTO dc_hostelworld_rates(dc_rate_id, name, weekendrate, weekdayrate, nonrefundable, active)
					VALUES('" . $rate_id . "', '" . $rate_data ["name"] . "', '" . $weekendrate . "', 
					'" . $weekdayrate . "', '" . $rate_data ["nonrefundable"] . "', '" . $rate_data ["active"] . "')
					ON DUPLICATE KEY UPDATE name = '" . $rate_data ["name"] . "', weekendrate = '" . $weekendrate . "', 
					weekdayrate = '" . $weekdayrate . "', nonrefundable = '" . $rate_data ["nonrefundable"] . "', 
					active = '" . $rate_data ["active"] . "'";
					$query = $this->db->query ( $sql );
					
					
					$sql = "SELECT hms_occupancy_id FROM dc_hostelworld_category2occupancy WHERE dc_category_id = ".$rate_data ["roomtypeid"];
					$query = $this->db->query ( $sql );
					foreach ( $query->result () as $row ) {
						$sql = "INSERT INTO dc_hostelworld_rate2category_link(dc_rate_id, dc_category_id, hms_occupancy_id)
						VALUES('" . $rate_id . "', '" . $rate_data ["roomtypeid"] . "', '" . $row->hms_occupancy_id . "')
						ON DUPLICATE KEY UPDATE hms_rate_id = hms_rate_id ";
						$query = $this->db->query ( $sql );
					}
					
					
				}
			}
		}
		
		$this->Loger_admin->Save_SyncData ( "", "", print_r (json_decode($data_result['result'], true), true ), 8, 13, $data_result ["dc_log_id"] );
		 
		//die();
		if ($die_option == 1) {
			$_SESSION ["dc_msg"] ["text"] = $result;
			die ( "<meta http-equiv='refresh' content='0;url=/dc_hostelworld_c2/rates_edit'>" );
		}
	}
	
	private function stdToArray($obj) {
		$rc = ( array ) $obj;
		foreach ( $rc as $key => &$field ) {
			if (is_object ( $field ))
				$field = $this->stdToArray ( $field );
		}
		return $rc;
	}
	function category_delete($dc_category_id) {
		$sql = "DELETE FROM dc_hostelworld_room_categories_link WHERE dc_category_id = " . $dc_category_id;
		$query = $this->db->query ( $sql );
		die ( "<meta http-equiv='refresh' content='0;url=/dc_hostelworld_c2/catgories_edit'>" );
	}
	function category_delete_v2($dc_category_id) {
		$sql = "DELETE FROM dc_hostelworld_room_categories_link WHERE dc_category_id = " . $dc_category_id;
		$query = $this->db->query ( $sql );
		$sql = "DELETE FROM dc_hostelworld_category2occupancy WHERE dc_category_id = " . $dc_category_id;
		$query = $this->db->query ( $sql );
		$sql = "DELETE FROM dc_hostelworld_rate2category_link WHERE dc_category_id = " . $dc_category_id;
		$query = $this->db->query ( $sql );
		die ( "<meta http-equiv='refresh' content='0;url=/dc_hostelworld_c2/catgories_edit'>" );
	}
	
	function rate_full_delete($dc_rate_id) {
		$sql = "DELETE FROM  dc_hostelworld_rate2category_link WHERE dc_rate_id = " . $dc_rate_id;
		$query = $this->db->query ( $sql );
		$sql = "DELETE FROM  dc_hostelworld_rates WHERE dc_rate_id = " . $dc_rate_id;
		$query = $this->db->query ( $sql );
		die ( "<meta http-equiv='refresh' content='0;url=/dc_hostelworld_c2/rates_edit'>" );
	}
	
	function truncate_categories(){
		$sql = "DELETE FROM dc_hostelworld_category2occupancy WHERE 1";
		$query = $this->db->query ( $sql );
		$sql = "DELETE FROM  dc_hostelworld_room_categories_link WHERE 1";
		$query = $this->db->query ( $sql );
		die ( "<meta http-equiv='refresh' content='0;url=/dc_hostelworld_c2/catgories_edit'>" );
	}
	function truncate_rates(){
		$sql = "DELETE FROM dc_hostelworld_rates WHERE 1";
		$query = $this->db->query ( $sql );
		$sql = "DELETE FROM dc_hostelworld_rate2category_link WHERE 1";
		$query = $this->db->query ( $sql );
		die ( "<meta http-equiv='refresh' content='0;url=/dc_hostelworld_c2/rates_edit'>" );
	}
	function rate_delete($dc_rate_id) {
		$sql = "DELETE FROM dc_hostelworld_rate_link WHERE dc_rate_id = " . $dc_rate_id;
		$query = $this->db->query ( $sql );
		die ( "<meta http-equiv='refresh' content='0;url=/dc_hostelworld_c2/rates_edit'>" );
	}
	function rate_delete_v2($dc_rate_id, $dc_category_id) {
		$sql = "DELETE FROM  dc_hostelworld_rate2category_link WHERE dc_rate_id = '" . $dc_rate_id . "' AND dc_category_id = '" . $dc_category_id."'";
		$query = $this->db->query ( $sql );
		die ( "<meta http-equiv='refresh' content='0;url=/dc_hostelworld_c2/rates_edit'>" );
	}
	
	function get_dc_invenory(){
		//===================================================
		//===================================================
		//===================================================
		//GET ROOMS
		$data = array ();
		
		$authparam = $this->dcm_hostelworld->getauthparam ();
		
		$consumer_key = $authparam ["consumer_key"];
		$secret = $authparam ["secret"];
		$propN = $authparam ["hotel_id"];
		$prop_user = 'manager';
		$prop_pass = $authparam ["prop_pass"];
		
		$consumer_signature = sha1 ( $consumer_key . "--" . $secret . "--" . $prop_pass );
		
		$data ['consumer_key'] = $consumer_key;
		$data ['consumer_signature'] = $consumer_signature;
		
		$txt = <<<EOT
<request>
  
</request>
	
EOT;
		$url = "https://property.xsapi.webresint.com/1.2/getavailabilityrequest/" . $propN . ".json?consumer_key=" . $consumer_key . "&consumer_signature=" . $consumer_signature;
		
		$txt = "<request></request>";
		$url = "https://property.xsapi.webresint.com/1.2/getroomtypes/" . $propN . ".json?consumer_key=" . $consumer_key . "&consumer_signature=" . $consumer_signature;
		// echo $url."<br>";
		$result = $this->Curl_model->CurlPlugRAW ( $txt, $url, 8 );
		$array = json_decode ( $result );
		// $array = new SimpleXMLElement ( $result );
		echo "<pre>";
		$array = objectToArray ( $array );
		print_r ( $array );
		$count_rooms = count ( $array );
		// echo $count_rooms;
		// die();
		
		if (isset ( $array ["api"] )) {
			if ($array ["api"] ["status"] == "Success") {
				if(count ( $array ["result"] ["roomtypes"] ) > 0){
					$sql = "UPDATE dc_hostelworld_room_categories_link SET active = 0 WHERE 1";
					$query = $this->db->query ( $sql );
				}
				
				foreach ( $array ["result"] ["roomtypes"] as $key => $value ) {
					$sql = "SET NAMES 'utf8';";
					$query = $this->db->query ( $sql );
					
					$sql = "INSERT INTO dc_hostelworld_room_categories_link(dc_category_id, dc_name, displayname, basictype, active)
					VALUES('" . $value ["roomtypeid"] . "',
					'" . utf8_decode($value ["roomtypename"]) . "', '" . $value ["displayname"] . "', '" . $value ["basictype"] . "', '1')
					ON DUPLICATE KEY UPDATE dc_name = '" . utf8_decode($value ["roomtypename"]) . "', displayname = '" . $value ["displayname"] . "', basictype = '" . $value ["basictype"] . "', active = '1'";
					// echo $sql;
					$query = $this->db->query ( $sql );
				}
			}
		}
	}
}
?>