<?php

class Dc_echannel_gate extends CI_Controller {
	public function __construct() {
		parent::__construct ();
		$this->load->model ( 'Curl_model' );
		$this->load->model ( 'frontdesk' );
		$this->load->model ( 'frontdesk_c2' );
		$this->load->model ( 'dc_model' );
		$this->load->model ( 'cancel' );
		$this->load->model ( 'property_model' );
		$this->load->model ( 'echannel_model' );
	}
	
	function get_rna($from = "", $to = "",  $hms_id = "") {
		//echo "++++";
		list ( $year, $month, $day ) = explode ( "-", $from );
		$intdate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		list ( $year, $month, $day ) = explode ( "-", $to );
		$outdate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		$data = array();
		
		$sql = "SELECT global_hotelix_echannel.restricts.*, global_hotelix_echannel.allotments.*, global_hotelix_echannel.rates.* FROM  global_hotelix_echannel.allotments 
		LEFT JOIN global_hotelix_echannel.rates ON global_hotelix_echannel.rates.category_id = global_hotelix_echannel.allotments.category_id 
		AND global_hotelix_echannel.rates.hms_hotel_id = $hms_id AND global_hotelix_echannel.rates.intdate = global_hotelix_echannel.allotments.intdate
		LEFT JOIN global_hotelix_echannel.restricts ON global_hotelix_echannel.restricts.category_id = global_hotelix_echannel.allotments.category_id 
		AND global_hotelix_echannel.restricts.hms_hotel_id = $hms_id AND global_hotelix_echannel.restricts.intdate = global_hotelix_echannel.allotments.intdate 
		AND global_hotelix_echannel.restricts.rate_id = global_hotelix_echannel.rates.rate_id
		WHERE global_hotelix_echannel.allotments.hms_hotel_id = ".$hms_id." AND global_hotelix_echannel.allotments.intdate >= ".$intdate." 
		AND global_hotelix_echannel.allotments.intdate <= ".$outdate;
		
		//echo $sql;
		$query = $this->db->query ( $sql );
		foreach ( $query->result () as $row ) {
			$date = gmdate ( "Y-m-d", $row->intdate * 86400 );
			//$data[$hms_id][$row->category_id]["allotments"][$date] = $row->count;
			//$data[$hms_id][$row->category_id]["rates"]["rate_id"] = $row->rate_id;
			//$data[$hms_id][$row->category_id]["rates"]["days_price"][$date] = $row->price;
			
			$data[$hms_id][$row->category_id]["daylist"][$date]["count"] = $row->count;
			$data[$hms_id][$row->category_id]["daylist"][$date]["ratelist"][$row->rate_id]["ocupoancyprice"] = $row->price;
			$data[$hms_id][$row->category_id]["daylist"][$date]["ratelist"][$row->rate_id]["restritcs"]["closed"] = $row->closed;
			$data[$hms_id][$row->category_id]["daylist"][$date]["ratelist"][$row->rate_id]["restritcs"]["minstay"] = $row->minstay;
			$data[$hms_id][$row->category_id]["daylist"][$date]["ratelist"][$row->rate_id]["restritcs"]["maxstay"] = $row->maxstay;
			$data[$hms_id][$row->category_id]["daylist"][$date]["ratelist"][$row->rate_id]["restritcs"]["minstayarrival"] = $row->minstayarrival;
			$data[$hms_id][$row->category_id]["daylist"][$date]["ratelist"][$row->rate_id]["restritcs"]["minstaythrought"] = $row->minstaythrought;
			$data[$hms_id][$row->category_id]["daylist"][$date]["ratelist"][$row->rate_id]["restritcs"]["closedonarrival"] = $row->closedonarrival;
			$data[$hms_id][$row->category_id]["daylist"][$date]["ratelist"][$row->rate_id]["restritcs"]["closedondeparture"] = $row->closedondeparture;
		}
		
		/*$sql = "SELECT * FROM  global_hotelix_echannel.rates WHERE hotel_id = ".$hms_id." AND intdate >= ".$intdate." AND intdate <= ".$outdate;
		
		//echo $sql;
		$query = $this->db->query ( $sql );
		foreach ( $query->result () as $row ) {
			$data[$hms_id][$row->category_id]["rates"]["rate_id"] = $row->rate_id;
			$data[$hms_id][$row->category_id]["rates"]["days_price"][$row->intdate] = $row->price;
		}
		*/
		
		//echo "<pre>";
		//print_r($data);
		$output = json_encode($data);
		
		echo $output;
	}
	
	function get_rna_personal($from = "", $to = "",  $hms_id = ""){
		list ( $year, $month, $day ) = explode ( "-", $from );
		$intdate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		list ( $year, $month, $day ) = explode ( "-", $to );
		$outdate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		$data = array();
		//echo "<br>".$intdate." ".$outdate."<br>";
		$sql_OLD = "SELECT global_hotelix_echannel.allotments.category_id, global_hotelix_echannel.allotments.intdate, MIN(global_hotelix_echannel.allotments.count) as mincount, 
		SUM(global_hotelix_echannel.rates.price) as amount, global_hotelix_echannel.rates.rate_id, global_hotelix_echannel.rates.occupancy_id, global_hotelix_echannel.rates.price
		FROM  global_hotelix_echannel.allotments
		LEFT JOIN global_hotelix_echannel.rates ON global_hotelix_echannel.rates.category_id = global_hotelix_echannel.allotments.category_id
		AND global_hotelix_echannel.rates.hms_hotel_id = $hms_id AND global_hotelix_echannel.rates.intdate = global_hotelix_echannel.allotments.intdate
		WHERE global_hotelix_echannel.allotments.hms_hotel_id = ".$hms_id." AND global_hotelix_echannel.allotments.intdate >= ".$intdate."
		AND global_hotelix_echannel.allotments.intdate <= ".$outdate." GROUP BY global_hotelix_echannel.allotments.category_id, global_hotelix_echannel.rates.rate_id, 
		global_hotelix_echannel.allotments.intdate";
		
		$sql = "SELECT global_hotelix_echannel.allotments.category_id, global_hotelix_echannel.allotments.intdate, MIN(global_hotelix_echannel.allotments.count) as mincount,
		0 as amount, 0 as rate_id, 0 as occupancy_id 
		FROM  global_hotelix_echannel.allotments 
		WHERE global_hotelix_echannel.allotments.intdate >= ".$intdate." AND global_hotelix_echannel.allotments.intdate <= ".$outdate." GROUP BY global_hotelix_echannel.allotments.category_id
				
		UNION 
		
		SELECT global_hotelix_echannel.rates.category_id, global_hotelix_echannel.rates.intdate, 0 as mincount,
		SUM(global_hotelix_echannel.rates.price) as amount, global_hotelix_echannel.rates.rate_id, global_hotelix_echannel.rates.occupancy_id 
		FROM  global_hotelix_echannel.rates 
		WHERE global_hotelix_echannel.rates.intdate >= ".$intdate." AND global_hotelix_echannel.rates.intdate <= ".$outdate." GROUP BY global_hotelix_echannel.rates.category_id, global_hotelix_echannel.rates.rate_id";
		//echo $sql;
		$query = $this->db->query ( $sql );
		foreach ( $query->result () as $row ) {
			$date = gmdate ( "Y-m-d", $row->intdate * 86400 );
			if($row->rate_id <> 0){
				$data ["categories"] [$row->category_id] ["rates"] [$row->rate_id] ["baseplace"] = 1;
				$data ["categories"] [$row->category_id] ["rates"] [$row->rate_id] ["amount"] = $row->amount;
				$data ["categories"] [$row->category_id] ["rates"] [$row->rate_id] ["addplaces"] = "";
				$data ["categories"] [$row->category_id] ["rates"] [$row->rate_id] ["add_price"] = "";
				$data ["categories"] [$row->category_id] ["rates"] [$row->rate_id] ["time"] = "";
			
				$data ["categories"] [$row->category_id] ["rates"] [$row->rate_id] ["description"] = "";
				$data ["categories"] [$row->category_id] ["rates"] [$row->rate_id] ["nonrefundable"] = 1;
				$data ["categories"] [$row->category_id] ["rates"] [$row->rate_id] ["breakfast"] = 0;
				$data ["categories"] [$row->category_id] ["rates"] [$row->rate_id] ["c_row_bool_count"] = 0;
			}else{
				$data ["categories"] [$row->category_id] ["count"] = $row->mincount;
				$data ["categories"] [$row->category_id] ["name"] = $row->category_id;
				$data ["categories"] [$row->category_id] ["comment"] = $row->category_id;
				$data ["categories"] [$row->category_id] ["online_name"] = $row->category_id;
				$data ["categories"] [$row->category_id] ["shortname"] = $row->category_id;
				$data ["categories"] [$row->category_id] ["places"] = 0;
				$data ["categories"] [$row->category_id] ["settlementtype"] = 1;
			}
		}
		
		$output = json_encode($data);
		
		echo $output;
	}
	
	function get_rna_personal_2($from = "", $to = "", $hms_id = "") {
		list ( $year, $month, $day ) = explode ( "-", $from );
		$intdate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		list ( $year, $month, $day ) = explode ( "-", $to );
		$outdate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		$data = array ();
		
		$sql = "SELECT global_hotelix_echannel.allotments.category_id, global_hotelix_echannel.allotments.intdate, MIN(global_hotelix_echannel.allotments.count) as mincount,
		0 as amount, 0 as rate_id, 0 as occupancy_id
		FROM  global_hotelix_echannel.allotments
		WHERE global_hotelix_echannel.allotments.intdate >= " . $intdate . " AND global_hotelix_echannel.allotments.intdate <= " . $outdate . " GROUP BY global_hotelix_echannel.allotments.category_id
	
		UNION
	
		SELECT global_hotelix_echannel.rates.category_id, global_hotelix_echannel.rates.intdate, 0 as mincount,
		SUM(global_hotelix_echannel.rates.price) as amount, global_hotelix_echannel.rates.rate_id, global_hotelix_echannel.rates.occupancy_id
		FROM  global_hotelix_echannel.rates
		WHERE global_hotelix_echannel.rates.intdate >= " . $intdate . " AND global_hotelix_echannel.rates.intdate <= " . $outdate . " GROUP BY global_hotelix_echannel.rates.category_id, global_hotelix_echannel.rates.rate_id";
		// echo $sql;
		$query = $this->db->query ( $sql );
		foreach ( $query->result () as $row ) {
			$date = gmdate ( "Y-m-d", $row->intdate * 86400 );
			if(!isset($data ["categories"] [$row->category_id] ["bar"])){
				if($row->amount > 0){
					$data ["categories"] [$row->category_id] ["bar"] ["rate_id"] = $row->rate_id;
					$data ["categories"] [$row->category_id] ["bar"] ["amount"] = $row->amount;
				}
			}
			if ($row->rate_id != 0) {
				//$data ["categories"] [$row->category_id] ["rates"] [$row->rate_id] ["baseplace"] = 1;
				$data ["categories"] [$row->category_id] ["rates"] [$row->rate_id] ["amount"] = $row->amount;
				if($row->amount > 0){
					if($data ["categories"] [$row->category_id] ["bar"] ["amount"] > $row->amount){
						$data ["categories"] [$row->category_id] ["bar"] ["rate_id"] = $row->rate_id;
						$data ["categories"] [$row->category_id] ["bar"] ["amount"] = $row->amount;
					}
				}
			} else {
				$data ["categories"] [$row->category_id] ["count"] = $row->mincount;
				$data ["categories"] [$row->category_id] ["name"] = $row->category_id;
				$data ["categories"] [$row->category_id] ["places"] = 0;
			}
		}
		
		$output = json_encode ( $data );
		
		echo $output;
	}
	
	function get_rna_personal_new($from = "", $to = "", $hms_id = "") {
		list ( $year, $month, $day ) = explode ( "-", $from );
		$intdate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		list ( $year, $month, $day ) = explode ( "-", $to );
		$outdate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		$data = array ();
		$duration = $outdate - $intdate;
		$sql = "
		SELECT global_hotelix_echannel.rates.category_id, global_hotelix_echannel.rates.rate_id, global_hotelix_echannel.rates.occupancy_id, global_hotelix_echannel.rates.intdate, 
		count(global_hotelix_echannel.rates.intdate) as count_intdate, SUM(global_hotelix_echannel.rates.price) as amount
		FROM  global_hotelix_echannel.rates
		WHERE global_hotelix_echannel.rates.occupancy_id = 2 AND global_hotelix_echannel.rates.intdate >= " . $intdate . " AND global_hotelix_echannel.rates.intdate < " . $outdate . " GROUP BY global_hotelix_echannel.rates.category_id, global_hotelix_echannel.rates.rate_id, global_hotelix_echannel.rates.occupancy_id";
		// echo $sql;
		$query = $this->db->query ( $sql );
		foreach ( $query->result () as $row ) {
			if ($duration == $row->count_intdate) {
				$date = gmdate ( "Y-m-d", $row->intdate * 86400 );
				if (! isset ( $data ["categories"] [$row->category_id] ["bar"] )) {
					if ($row->amount > 0) {
						$data ["categories"] [$row->category_id] ["bar"] ["rate_id"] = $row->rate_id;
						$data ["categories"] [$row->category_id] ["bar"] ["amount"] = $row->amount;
					}
				}
				if ($row->rate_id != 0) {
					// $data ["categories"] [$row->category_id] ["rates"] [$row->rate_id] ["baseplace"] = 1;
					$data ["categories"] [$row->category_id] ["rates"] [$row->rate_id] ["amount"] = $row->amount;
					if ($row->amount > 0) {
						if ($data ["categories"] [$row->category_id] ["bar"] ["amount"] > $row->amount) {
							$data ["categories"] [$row->category_id] ["bar"] ["rate_id"] = $row->rate_id;
							$data ["categories"] [$row->category_id] ["bar"] ["amount"] = $row->amount;
						}
					}
				} else {
					$data ["categories"] [$row->category_id] ["count"] = $row->mincount;
					$data ["categories"] [$row->category_id] ["name"] = $row->category_id;
					$data ["categories"] [$row->category_id] ["places"] = 0;
				}
			}
		}
		
		$json_data = array();
		
		$json_data["api_version"] = 7;
		$json_data["hotel_ids"][0] = $hms_id;
		$json_data["start_date"] = $from;
		$json_data["end_date"] = $to;
		$json_data["party"]["adults"] = 2;
		$json_data["currency"] = "USD";
		$json_data["user_country"] = "US";
		$json_data["device_type"] = "d";
		$json_data["query_key"] = "6167a22d1f87d2028bf60a8e5e27afa7_191_1360299600000_2_2";
		$json_data["lang"] = "en_US";
		$json_data["num_hotels"] = 1;
		$json_data["hotels"]["hotel_id"] = $hms_id;
		
		foreach($data ["categories"] as $category_id => $cell){
			$json_data["hotels"]["room_types"][$category_id]["url"] = "http: //www.partner-site.com/hotel_commonwealth/fenway_room?start_date=2015-07-01&end_date=2015-07-03&num_adults=2";
			$json_data["hotels"]["room_types"][$category_id]["price"] = $cell["bar"]["amount"];
			$json_data["hotels"]["room_types"][$category_id]["fees"] = 0;
			$json_data["hotels"]["room_types"][$category_id]["fees_at_checkout"] = 0;
			$json_data["hotels"]["room_types"][$category_id]["taxes"] = 0;
			$json_data["hotels"]["room_types"][$category_id]["taxes_at_checkout"] = 0;
			$json_data["hotels"]["room_types"][$category_id]["final_price"] = $cell["bar"]["amount"];
			
			$json_data["hotels"]["room_types"][$category_id]["discounts"] = array();
			
			$json_data["hotels"]["room_types"][$category_id]["currency"] = "USD";
			$json_data["hotels"]["room_types"][$category_id]["num_rooms"] = 1;
			$json_data["hotels"]["room_types"][$category_id]["room_code"] = "SINGLE";
			$json_data["hotels"]["room_types"][$category_id]["room_amenities"][0] = "BREAKFAST_AND_LUNCH_INCLUDED";
			$json_data["hotels"]["room_types"][$category_id]["room_amenities"][1] = "ROOM_WITH_A_VIEW";
			
		}
		
	
		$output = json_encode ( $json_data );
	
		echo $output;
	}
	
	function get_rna_tripadvisor() {
		$postdata = file_get_contents("php://input");
		$request = json_decode($postdata, true);
		//echo "Start OK!<pre>";
		//print_r($request);
		$party = json_decode($request["party"], true);
		$hotels = json_decode($request["hotels"], true);
		//print_r($party);
		//print_r($hotels);
		//die();
		list ( $year, $month, $day ) = explode ( "-", $request["start_date"] );
		$intdate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		list ( $year, $month, $day ) = explode ( "-", $request["end_date"] );
		$outdate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		$data = array ();
		$duration = $outdate - $intdate;
		$sql = "
		SELECT global_hotelix_echannel.rates.category_id, global_hotelix_echannel.rates.rate_id, global_hotelix_echannel.rates.occupancy_id, global_hotelix_echannel.rates.intdate,
		count(global_hotelix_echannel.rates.intdate) as count_intdate, SUM(global_hotelix_echannel.rates.price) as amount
		FROM  global_hotelix_echannel.rates
		WHERE global_hotelix_echannel.rates.occupancy_id = 2 AND global_hotelix_echannel.rates.intdate >= " . $intdate . " AND global_hotelix_echannel.rates.intdate < " . $outdate . " GROUP BY global_hotelix_echannel.rates.category_id, global_hotelix_echannel.rates.rate_id, global_hotelix_echannel.rates.occupancy_id";
		// echo $sql;
		$query = $this->db->query ( $sql );
		foreach ( $query->result () as $row ) {

			//if ($duration == $row->count_intdate) {
				$date = gmdate ( "Y-m-d", $row->intdate * 86400 );
				if (! isset ( $data ["categories"] [$row->category_id] ["bar"] )) {
					
					if ($row->amount > 0) {
						$data ["categories"] [$row->category_id] ["bar"] ["rate_id"] = $row->rate_id;
						$data ["categories"] [$row->category_id] ["bar"] ["amount"] = $row->amount;
					}
				}
			
				if ($row->rate_id != 0) {
					
					// $data ["categories"] [$row->category_id] ["rates"] [$row->rate_id] ["baseplace"] = 1;
					$data ["categories"] [$row->category_id] ["rates"] [$row->rate_id] ["amount"] = $row->amount;
					if ($row->amount > 0) {
						if ($data ["categories"] [$row->category_id] ["bar"] ["amount"] > $row->amount) {
							$data ["categories"] [$row->category_id] ["bar"] ["rate_id"] = $row->rate_id;
							$data ["categories"] [$row->category_id] ["bar"] ["amount"] = $row->amount;
						}
					}
				} else {
					$data ["categories"] [$row->category_id] ["count"] = $row->mincount;
					$data ["categories"] [$row->category_id] ["name"] = $row->category_id;
					$data ["categories"] [$row->category_id] ["places"] = 0;
				}
			//}
		}
		
	
		$json_data = array();
	
		$json_data["api_version"] = (int)$request["api_version"];
		$json_data["hotel_ids"][0] = (int)$hotels[0]["ta_id"];
		$json_data["start_date"] = $request["start_date"];
		$json_data["end_date"] = $request["end_date"];
		$json_data["party"][0]["adults"] = $party[0]["adults"];
		$json_data["currency"] = $request["currency"];
		$json_data["user_country"] = $request["user_country"];
		$json_data["device_type"] = $request["device_type"];
		$json_data["query_key"] = $request["query_key"];
		$json_data["lang"] = $request["lang"];
		$json_data["num_hotels"] = 1;
		$json_data["hotels"][0]["hotel_id"] = (int)$hotels[0]["ta_id"];
		if (isset ( $data ["categories"] )) {
			foreach ( $data ["categories"] as $category_id => $cell ) {
				$json_data ["hotels"] [0]["room_types"] [$category_id] ["url"] = "http://www.partner-site.com/hotel_commonwealth/fenway_room?start_date=".$request["start_date"]."&end_date=".$request["end_date"]."&num_adults=".$party[0]["adults"];
				$json_data ["hotels"] [0]["room_types"] [$category_id] ["price"] = (int)number_format ( $cell ["bar"] ["amount"], 2, '.', ' ' );
				$json_data ["hotels"] [0]["room_types"] [$category_id] ["fees"] = 0;
				$json_data ["hotels"] [0]["room_types"] [$category_id] ["fees_at_checkout"] = 0;
				$json_data ["hotels"] [0]["room_types"] [$category_id] ["taxes"] = 0;
				$json_data ["hotels"] [0]["room_types"] [$category_id] ["taxes_at_checkout"] = 0;
				$json_data ["hotels"] [0]["room_types"] [$category_id] ["final_price"] = (int)number_format ( $cell ["bar"] ["amount"], 2, '.', ' ' );
				
				$json_data ["hotels"] [0]["room_types"] [$category_id] ["discounts"] = array ();
				
				$json_data ["hotels"] [0]["room_types"] [$category_id] ["currency"] = "USD";
				$json_data ["hotels"] [0]["room_types"] [$category_id] ["num_rooms"] = 1;
				$json_data ["hotels"] [0]["room_types"] [$category_id] ["room_code"] = "SINGLE";
				$json_data ["hotels"] [0]["room_types"] [$category_id] ["room_amenities"] [0] = "BREAKFAST_AND_LUNCH_INCLUDED";
				$json_data ["hotels"] [0]["room_types"] [$category_id] ["room_amenities"] [1] = "ROOM_WITH_A_VIEW";
			}
		}
	
	
		$output = json_encode ( $json_data );
	
		echo $output;
	}
	
	function get_rna_tripadvisor_2() {
		$postdata = file_get_contents("php://input");
		$request = json_decode($postdata, true);
		//echo "Start OK!<pre>";
		//print_r($request);
		if(false){
			$party = json_decode($request["party"], true);
			$hotels = json_decode($request["hotels"], true);
		}else{
			$party[0]["adults"] = 2;
			$hotels[0]["ta_id"] = 258705;
		}
		//print_r($party);
		//print_r($hotels);
		//die();
		list ( $year, $month, $day ) = explode ( "-", $request["start_date"] );
		$intdate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		list ( $year, $month, $day ) = explode ( "-", $request["end_date"] );
		$outdate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		$data = array ();
		$duration = $outdate - $intdate;
		$sql = "
		SELECT global_hotelix_echannel.rates.category_id, global_hotelix_echannel.rates.rate_id, global_hotelix_echannel.rates.occupancy_id, global_hotelix_echannel.rates.intdate,
		count(global_hotelix_echannel.rates.intdate) as count_intdate, SUM(global_hotelix_echannel.rates.price) as amount
		FROM  global_hotelix_echannel.rates
		WHERE global_hotelix_echannel.rates.occupancy_id = 2 AND global_hotelix_echannel.rates.intdate >= " . $intdate . " AND global_hotelix_echannel.rates.intdate < " . $outdate . " GROUP BY global_hotelix_echannel.rates.category_id, global_hotelix_echannel.rates.rate_id, global_hotelix_echannel.rates.occupancy_id";
		// echo $sql;
		$query = $this->db->query ( $sql );
		foreach ( $query->result () as $row ) {
	
			//if ($duration == $row->count_intdate) {
			$date = gmdate ( "Y-m-d", $row->intdate * 86400 );
			if (! isset ( $data ["categories"] [$row->category_id] ["bar"] )) {
					
				if ($row->amount > 0) {
					$data ["categories"] [$row->category_id] ["bar"] ["rate_id"] = $row->rate_id;
					$data ["categories"] [$row->category_id] ["bar"] ["amount"] = $row->amount;
				}
			}
				
			if ($row->rate_id != 0) {
					
				// $data ["categories"] [$row->category_id] ["rates"] [$row->rate_id] ["baseplace"] = 1;
				$data ["categories"] [$row->category_id] ["rates"] [$row->rate_id] ["amount"] = $row->amount;
				if ($row->amount > 0) {
					if ($data ["categories"] [$row->category_id] ["bar"] ["amount"] > $row->amount) {
						$data ["categories"] [$row->category_id] ["bar"] ["rate_id"] = $row->rate_id;
						$data ["categories"] [$row->category_id] ["bar"] ["amount"] = $row->amount;
					}
				}
			} else {
				$data ["categories"] [$row->category_id] ["count"] = $row->mincount;
				$data ["categories"] [$row->category_id] ["name"] = $row->category_id;
				$data ["categories"] [$row->category_id] ["places"] = 0;
			}
			//}
		}
	
	
		$json_data = array();
	
		$json_data["api_version"] = (int)$request["api_version"];
		$json_data["hotel_ids"][0] = (int)$hotels[0]["ta_id"];
		$json_data["start_date"] = $request["start_date"];
		$json_data["end_date"] = $request["end_date"];
		$json_data["party"][0]["adults"] = $party[0]["adults"];
		$json_data["currency"] = $request["currency"];
		$json_data["user_country"] = $request["user_country"];
		$json_data["device_type"] = $request["device_type"];
		$json_data["query_key"] = $request["query_key"];
		$json_data["lang"] = $request["lang"];
		$json_data["num_hotels"] = 1;
		$json_data["hotels"][0]["hotel_id"] = (int)$hotels[0]["ta_id"];
		if (isset ( $data ["categories"] )) {
			foreach ( $data ["categories"] as $category_id => $cell ) {
				$json_data ["hotels"] [0]["room_types"] [$category_id] ["url"] = "http://www.partner-site.com/hotel_commonwealth/fenway_room?start_date=".$request["start_date"]."&end_date=".$request["end_date"]."&num_adults=".$party[0]["adults"];
				$json_data ["hotels"] [0]["room_types"] [$category_id] ["price"] = (int)number_format ( $cell ["bar"] ["amount"], 2, '.', ' ' );
				$json_data ["hotels"] [0]["room_types"] [$category_id] ["fees"] = 0;
				$json_data ["hotels"] [0]["room_types"] [$category_id] ["fees_at_checkout"] = 0;
				$json_data ["hotels"] [0]["room_types"] [$category_id] ["taxes"] = 0;
				$json_data ["hotels"] [0]["room_types"] [$category_id] ["taxes_at_checkout"] = 0;
				$json_data ["hotels"] [0]["room_types"] [$category_id] ["final_price"] = (int)number_format ( $cell ["bar"] ["amount"], 2, '.', ' ' );
	
				$json_data ["hotels"] [0]["room_types"] [$category_id] ["discounts"] = array ();
	
				$json_data ["hotels"] [0]["room_types"] [$category_id] ["currency"] = "USD";
				$json_data ["hotels"] [0]["room_types"] [$category_id] ["num_rooms"] = 1;
				$json_data ["hotels"] [0]["room_types"] [$category_id] ["room_code"] = "SINGLE";
				$json_data ["hotels"] [0]["room_types"] [$category_id] ["room_amenities"] [0] = "BREAKFAST_AND_LUNCH_INCLUDED";
				$json_data ["hotels"] [0]["room_types"] [$category_id] ["room_amenities"] [1] = "ROOM_WITH_A_VIEW";
			}
		}
	
	
		$output = json_encode ( $json_data );
	
		echo $output;
	}
	
	function get_room_information() {
		$postdata = file_get_contents("php://input");
		$request = json_decode($postdata, true);
		echo "Start OK!<pre>";
		print_r($request);
		
		
	}
	
	function get_rooms_rates_information($hms_id){
	    $json_data = array();
	    $sql = "SELECT rateslist.category_id as room_id, rooms_details.name as room_name,
	            rateslist.rate_id, rates_details.name as rate_name
	            FROM global_hotelix_echannel.rooms_details 
	            LEFT JOIN global_hotelix_echannel.rateslist ON rateslist.category_id = rooms_details.dc_room_id
	            INNER JOIN global_hotelix_echannel.rates_details ON rates_details.dc_rate_id = rateslist.rate_id
	            WHERE rooms_details.hms_hotel_id = $hms_id";
	    $query = $this->db->query ( $sql );
	    foreach ( $query->result () as $row ) {
	        $json_data['categories'][$row->room_id]['category_id'] = $row->room_id;
	        $json_data['categories'][$row->room_id]['category_name'] = $row->room_name;
	        $json_data['categories'][$row->room_id]['rates'][$row->rate_id]['rate_id'] = $row->rate_id;
	        $json_data['categories'][$row->room_id]['rates'][$row->rate_id]['rate_name'] = $row->rate_name;
	    }
	    $output = json_encode ( $json_data );
	    
	    echo $output;
	}
	
	function get_rooms_info(){
	    $postdata = file_get_contents("php://input");
	    $data = json_decode($postdata, true);
	    $hms_id = $data['hms_id'];
	    $json_data = array();
	    $sql = "SELECT rateslist.category_id as room_id, rooms_details.name as room_name,
	            rateslist.rate_id, rates_details.name as rate_name
	            FROM global_hotelix_echannel.rooms_details 
	            LEFT JOIN global_hotelix_echannel.rateslist ON rateslist.category_id = rooms_details.dc_room_id
	            INNER JOIN global_hotelix_echannel.rates_details ON rates_details.dc_rate_id = rateslist.rate_id
	            WHERE rooms_details.hms_hotel_id = $hms_id";
	    //echo $sql;
	    $query = $this->db->query ( $sql );
	    foreach ( $query->result () as $row ) {
	        $json_data['categories'][$row->room_id]['category_id'] = $row->room_id;
	        $json_data['categories'][$row->room_id]['category_name'] = $row->room_name;
	        $json_data['categories'][$row->room_id]['rates'][$row->rate_id]['rate_id'] = $row->rate_id;
	        $json_data['categories'][$row->room_id]['rates'][$row->rate_id]['rate_name'] = $row->rate_name;
	    }
	    $output = json_encode ( $json_data );
	    
	    echo $output;
	}
	
	function dc_rate_intdate_insert($data) {
	    $count = count ( $data );
	    if ($count != 0) {
	        foreach ( $data as $cell ) {
	            $query = $this->db->query ( "DELETE FROM dc_echannel_intdate WHERE dc_reservation_id LIKE '" . $cell ["dc_reservation_id"]."'" );
	            break;
	        }
	        foreach ( $data as $cell ) {
	            $sql = "INSERT INTO dc_echannel_intdate (dc_reservation_id, dc_rate_id, intdate, price) VALUES('" . $cell ["dc_reservation_id"] . "',
		'" . $cell ["dc_rate_id"] . "', '" . $cell ["intdate"] . "', '" . $cell ["price"] . "')
		ON DUPLICATE KEY UPDATE price = '" . $cell ["price"] . "'";
	            // echo $sql;
	            $query = $this->db->query ( $sql );
	        }
	    }
	}

	function set_reservation($debug = 0)
	{
	    $json = file_get_contents("php://input");
	    $postdata = json_decode($json, true);
	    $hms_id = $postdata['hms_id'];
	
	    $data = array(
	        'request' => $json,
	        'url' => ""
	    );
	    $this->db->insert('dc_echannel_log', $data);
	    $dc_log_id = $this->db->insert_id();
	    $timestart = microtime(true);
	    
	    $categories_names = array();
	    $query = $this->db->query("SELECT id, name FROM categories");
	    if ($query->num_rows() > 0) {
	        foreach ($query->result() as $row) {
	            $categories_names[$row->id] = $row->name;
	        }
	    }
	
	    $rates_names = array();
	    $query = $this->db->query("SELECT caption, id FROM  rate");
	    if ($query->num_rows() > 0) {
	        foreach ($query->result() as $row) {
	            $rates_names[$row->id]["dc_rate_name"] = $row->caption;
	        }
	    }
	
// 	    $query = $this->db->query("SELECT int_value FROM dc_tripadvisor_xml_cfg WHERE name LIKE 'dealer_id'");
// 	    if ($query->num_rows() > 0) {
// 	        $row = $query->row();
// 	        $dealer = $row->int_value;
// 	    }
	    
// 	    $query = $this->db->query("SELECT value FROM hotelix_config WHERE name LIKE 'echannel_source_id'");
// 	    if ($query->num_rows() > 0) {
// 	        $row = $query->row();
// 	        $dealer = $row->value;
// 	    }

	    $query = $this->db->query("SELECT value FROM hotelix_config WHERE name LIKE 'overbooking_category_id'");
	    if ($query->num_rows() > 0) {
	        $row = $query->row();
	        $overbooking_category_id = $row->value;
	    }
	
	    $timezone = "";
	    $query = $this->db->query("SELECT str_value FROM hotelix_config WHERE name LIKE 'timezone'");
	    if ($query->num_rows() > 0) {
	        $row = $query->row();
	        $timezone = $row->str_value;
	    } else {
	        $timezone = "America/Los_Angeles";
	    }
	
	    $checkin_checkout_arr = $this->frontdesk->get_check_in_out_time();

	    $result_array = array();
	    if (isset($postdata["booking"])) {
	        $reservation = $postdata["booking"];
	        $dc_id = $postdata["dc_id"];
	        
	        $dealer = 0;
	        $dealer_id_query_row = $this->db->like('name', 'dealer_id')
	        ->get_where('echannel_clients_data', array(
	            'dc_id' => $dc_id,
	            'name' => 'dealer_id'
	        ))
	        ->row();
	        $dealer = ($dealer_id_query_row) ? $dealer_id_query_row->int_value : 0;
	        
	        if (isset($reservation["id"])) {
	            
	            if (isset($reservation["payments"])) {
	                $payments_refunds = $reservation["payments"];
	            }
	            
	            $reservation["dc_uuid"] = $reservation["id"];
	            $dc_room_id = $reservation["room_id"];
	            $dc_rate_id = $reservation["rate_id"];
	
	            $datein = $reservation["date_in"];
	            $dateout = $reservation["date_out"];
	
	            list ($year, $month, $day) = explode("-", $datein);
	            $intdate_start = round(mktime(0, 0, 0, $month, $day, $year) / 86400);
	            list ($year, $month, $day) = explode("-", $dateout);
	            $intdate_end = round(mktime(0, 0, 0, $month, $day, $year) / 86400);
	            $duration = $intdate_end - $intdate_start;
	
	            $guest_count = 1;
	            $result_array["guests"] = array();
	            if($reservation["guest_count"] > 0){
	                $guest_count = $reservation["guest_count"];
	                $result_array["guests"] = $reservation['guest_data'];
	            }
	
	            if($reservation["price"] > 0){
	                $amount = $reservation["price"];
	                $per_day_price = $reservation["price"] / $duration;
	            }else{
	                $calc_data = array();
	                $calc_data ["datein"] = $datein;
	                $calc_data ["dateout"] = $dateout;
	                $calc_data ["type_id"] = $dc_room_id;
	                $calc_data ["price_type"] = $dc_rate_id;
	                $calc_data ["adults"] = $reservation["guest_count"];
	                $calc_data ["add_places"] = 0;
	                $calc_data ["baby_places"] = 0;
	                $calc_data ["addbedplace"] = 0;
	                $calc_data ["babyplace2"] = 0;
	                //echo "<pre>";
	                //print_r($calc_data);
	                $temp_amount = $this->frontdesk->getpricecalculation ( $calc_data );
	                $amount = 0;
	                foreach ( $temp_amount as $cell ) {
	                    $amount += $cell ["amount"];
	                }
	
	                $per_day_price = $amount / $duration;
	            }
	
	            $dc_total_price = 0;
	            $k = 0;
	            for ($date_inc = $intdate_start; $date_inc < $intdate_end; $date_inc ++) {
	                $date = date('Y-m-d', $date_inc * 86400);
	
	
	
	                $result_array["per_day"][$k]["dc_currencycode"] = "";
	                $result_array["per_day"][$k]["dc_reservation_id"] = $reservation["dc_uuid"];
	                $result_array["per_day"][$k]["price"] = $per_day_price;
	                $result_array["per_day"][$k]["dc_rate_id"] = "";
	
	                $result_array["per_day"][$k]["dc_rate_name"] = "";
	                if(isset($rates_names[$dc_rate_id]["dc_rate_name"])){
	                    $result_array["per_day"][$k]["dc_rate_name"] = $rates_names[$dc_rate_id]["dc_rate_name"];
	                }
	
	                $result_array["per_day"][$k]["intdate"] = $date_inc;
	                $result_array["per_day"][$k]["date_rate"] = $date;
	
	                $dc_total_price += $per_day_price;
	                $k ++;
	            }
	
	            // ========================================
	
	
	            $result_array["dc_rate_id"] = $dc_rate_id;
	            $result_array["currencycode"] = "";
	
	            $result_array["card"]["cc_cvc"] = "";
	
	            $result_array["card"]["ExpMonth"] = "";
	            $result_array["card"]["ExpYear"] = "";
	            $result_array["card"]["CardHolder"] = "";
	            $result_array["card"]["CardNumber"] = "";
	            $result_array["card"]["cc_type"] = "";
	
	            $result_array["guest"]["address"] = "";
	            $result_array["guest"]["city"] = "";
	            $result_array["guest"]["email"] = $reservation["email"];
	            $result_array["guest"]["firstname"] = $reservation["first_name"];
	            $result_array["guest"]["lastname"] = $reservation["last_name"];
	            $result_array["guest"]["phone"] = $reservation["phone"];
	            $result_array["guest"]["country"] = "";
	            $result_array["guest"]["passportid"] = "";
	
	            $result_array["status"] = $reservation["status"];
	            // $result_array [$i] ["status"] = "cancelled";
	            $result_array["dc_reservationid"] = "";
	
	            $created_datetime = explode(" ", $reservation["created"]);
	            $created_date = $created_datetime[0];
	            $created_time = $created_datetime[1];
	
	            $result_array["reservation"]["dc_id"] = $dc_id;
	
	            $result_array["reservation"]["commissionamount"] = 0;
	            $result_array["reservation"]["date"] = $created_date;
	            $result_array["reservation"]["dc_reservationid"] = "";
	            $result_array["reservation"]["time"] = $created_time;
	            $result_array["reservation"]["dc_date"] = $created_date;
	            $result_array["reservation"]["dc_time"] = $created_time;
	
	            $result_array["reservation"]["dc_updatetime"] = "";
	
	            $result_array["reservation"]["isNew"] = 1;
	
	            $result_array["reservation"]["datein"] = $datein;
	            $result_array["reservation"]["checkintime"] = "";
	
	            $result_array["reservation"]["dateout"] = $dateout;
	            $result_array["reservation"]["checkouttime"] = "";
	
	            $result_array["reservation"]["dc_roomreservation_id"] = "";
	            // $result_array["reservation"]["dc_uuid"] = $reservation["booking_id"] . "_" . $dc_room_id . "_" . $j;
	            $result_array["reservation"]["dc_uuid"] = $reservation["dc_uuid"];
	            $result_array["reservation"]["category_id"] = $dc_room_id;
	            if (isset($categories_names[$dc_room_id])) {
	                $result_array["reservation"]["reservation_type_name"] = $categories_names[$dc_room_id];
	            } else {
	                $result_array["reservation"]["reservation_type_name"] = "";
	            }
	
	            $result_array["reservation"]["placement_id"] = "";
	            $result_array["reservation"]["add_places"] = 0;
	            $result_array["reservation"]["baby_places"] = 0;
	            $result_array["reservation"]["adults"] = $guest_count;
	            $result_array["reservation"]["amount"] = $amount;
	            //$result_array["reservation"]["service_main_amount"] = $amount;
	            $result_array["reservation"]["price_type"] = $dc_rate_id;
	
	            $result_array["reservation"]["description"] = "";
	            if (isset($_SESSION["user"]["id"])) {
	                $result_array["reservation"]["user"] = $_SESSION["user"]["id"];
	            } else {
	                $result_array["reservation"]["user"] = - 1;
	            }
	            $result_array["reservation"]["type_id"] = $dc_room_id;
	            $result_array["reservation"]["dc_type_id"] = $dc_room_id;
	
	            $result_array["reservation"]["dealer"] = $dealer;
	            $result_array["reservation"]["dc_guestname"] = $reservation["first_name"] . " " . $reservation["last_name"];
	            $result_array["reservation"]["dc_numberofguest"] = $guest_count;
	            $result_array["reservation"]["dc_countrycode"] = "";
	            $result_array["reservation"]["dc_currencycode"] = "";
	            $result_array["reservation"]["dc_city"] = "";
	            $result_array["reservation"]["dc_customerremarks"] = "";
	            $result_array["reservation"]["dc_roomremarks"] = "";
	            $result_array["reservation"]["description"] = $reservation["comment"];
	
	            $result_array["reservation"]["dc_totalprice"] = $dc_total_price;
	
	            $result_array["reservation"]["smoking"] = "";
	
	            $result_array["roomreservation_id"] = "";
	
	            // =============================================================================
	            $result_array["reservation"]["early_check_in_close"] = 0;
	            $result_array["reservation"]["late_check_out_close"] = 0;
	        }
	    }
	
	    if ($debug) {
	        echo "<pre>";
	        print_r($result_array);
	        // die ();
	    }
	
	    $host = "";
	
	    $reservationpush = array();
	    if (isset($result_array["reservation"])) {
	        $k = 0;
	
	        $bool_cancel = 0;
	        $guest_array = array();
	        $guest_counter = 1;
	
	        $dc_reservationid = $result_array["reservation"]["dc_reservationid"];
	        $dc_status = $result_array["status"];
	        $bool_guest = 0;
	
	        $calculate_data = array();
	        $calculate_data["type_id"] = $result_array["reservation"]["type_id"];
	        $calculate_data["datein"] = $result_array["reservation"]["datein"];
	        $calculate_data["dateout"] = $result_array["reservation"]["dateout"];
	        $calculate_data["add_places"] = $result_array["reservation"]["add_places"];
	        $calculate_data["baby_places"] = $result_array["reservation"]["baby_places"];
	        $calculate_data["addbedplace"] = 0;
	        $calculate_data["babyplace2"] = 0;
	        $calculate_data["price_type"] = $result_array["reservation"]["price_type"];
	        $calculate_data["adults"] = $result_array["reservation"]["adults"];
	        $temp_amount = $this->frontdesk->getpricecalculation($calculate_data);
	        $otelms_amount = 0;
	        for ($p = 0; $p < count($temp_amount); $p ++) {
	            $otelms_amount += $temp_amount[$p]["amount"];
	        }
	        $booking_amount = $result_array["reservation"]["amount"];
	        // $reservations [$i] ["reservation"] ["discount"] = 0;
	        if ($booking_amount != $otelms_amount) {
	            $result_array["reservation"]["discount"] = $otelms_amount - $booking_amount;
	        }
	
	        $datein = $result_array["reservation"]["datein"];
	        $dateout = $result_array["reservation"]["dateout"];
	        $type_id = $result_array["reservation"]["type_id"];
	        $sql = "SELECT id, room_id FROM deskofreservation WHERE dc_id = $dc_id AND cancel=0 AND deleted = 0 AND dc_uuid LIKE '" . $result_array["reservation"]["dc_uuid"] . "' ORDER BY id DESC ";
	        // echo $sql;
	        $query = $this->db->query($sql);
	        $hms_reservation_id = 0;
	        $otelms_room_id = 0;
	        if ($query->num_rows() > 0) {
	            $row = $query->row();
	            $hms_reservation_id = $row->id;
	            $otelms_room_id = $row->room_id;
	            $reservationpush["response"] = "fail";
	            $reservationpush["text"] = "order_exist";
	            $reservationpush["status"] = $result_array["status"];
	            $reservationpush["hms_reservation_id"] = $row->id;
	            $result_array["reservation"]["reservation_alert"] = "order_exist";
	            $result_array["reservation"]["hms_reservation_id"] = $hms_reservation_id;
	            $result_array["reservation"]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $hms_reservation_id;
	        } else {
	
	
	            /*
	             * NEW RESERVATION BLOCK
	             */
	
	            $room_id = 0;
	
	            if ($type_id == 0 or $type_id == "") {
	                $query2 = $this->db->query("SELECT value FROM hotelix_config WHERE name LIKE 'overbooking_category_id'");
	                if ($query->num_rows() > 0) {
	                    $row2 = $query2->row();
	                    $type_id = $row2->value;
	                }
	            }
	            if ($type_id == 0 or $type_id == "") {
	                $reservationpush["response"] = "fail";
	                $reservationpush["text"] = "UNKNOWN CATEGORY";
	                $reservationpush["status"] = "new";
	                $reservationpush["hms_reservation_id"] = $row->id;
	                $result_array["status"] = "new";
	                $result_array["reservation"]["reservation_alert"] = $reservationpush["text"];
	                $result_array["reservation"]["hms_reservation_id"] = $reservationpush["hms_reservation_id"];
	                $result_array["reservation"]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush["hms_reservation_id"];
	                $k ++;
	            } else {
	                $room_id = $this->frontdesk->getfreeroomlist($datein, $dateout, $type_id, 0, 0, $result_array["reservation"]["early_check_in_close"], $result_array["reservation"]["late_check_out_close"]);
	                if ($room_id == 0) {
	
	                    if (isset($overbooking_category_id)) {
	                        $result_array["reservation"]["origin_categoryid"] = $type_id;
	                        $room_id = $this->frontdesk->getfreeroomlist($datein, $dateout, $overbooking_category_id, 0, 0, $result_array["reservation"]["early_check_in_close"], $result_array["reservation"]["late_check_out_close"]);
	
	                        $insert_over_room_bool = 0;
	                        if ($room_id == 0) {
	                            $room_id = $this->dc_model->dc_make_overbooking_room($overbooking_category_id);
	                            $insert_over_room_bool = 1;
	                        }
	                    } else {
	                        $reservationpush["response"] = "fail";
	                        $reservationpush["text"] = "no overbooking_category_id";
	                        $reservationpush["status"] = "new";
	                        $reservationpush["hms_reservation_id"] = 0;
	                        $result_array["status"] = "new";
	                        $result_array["reservation"]["reservation_alert"] = $reservationpush["text"];
	                        $result_array["reservation"]["hms_reservation_id"] = $reservationpush["hms_reservation_id"];
	                        $result_array["reservation"]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush["hms_reservation_id"];
	                    }
	                }
	                $result_array["reservation"]["room_id"] = $room_id;
	
	                if ($bool_guest == 0) {
	                    $guest_id = $this->frontdesk->Guest_insert ( $result_array["guest"] );
	                    $add_guests = array ();
	                    $add_g_i = 0;
	                    for($g_i = 0; $g_i < $guest_count; $g_i ++) {
	                        $add_guests [$add_g_i] = $this->frontdesk->Guest_insert ( $result_array ["guests"] [$g_i] );
	                        $add_g_i ++;
	                    }
	
	                    //$guest_id = $this->frontdesk->Guest_insert($result_array["guest"]);
	                    $bool_guest = 1;
	                }
	                $hms_reservation_id = $this->frontdesk->Reservation_insert($result_array["reservation"], $guest_id, 0, 1);
	
	                if (isset($otelms_rooms[$dc_reservationid][$result_array["reservation"]["dc_uuid"]])) {
	                    $otelms_rooms[$dc_reservationid][$result_array["reservation"]["dc_uuid"]]["status"] = 1;
	                }
	
	                $count_add_guests = count ( $add_guests );
	                for($add_g_i = 0; $add_g_i < $count_add_guests; $add_g_i ++) {
	                    $this->frontdesk->guests_reservation_insert ( $add_guests [$add_g_i], $hms_reservation_id );
	                }
	
	                if (isset($result_array["card"])) {
	                    $this->frontdesk->insert_tbl_CreditCards($result_array["card"], $guest_id, $hms_reservation_id);
	                }
	
	                if ($hms_reservation_id > 0) {
	                    /*
	                     *
	                     * === INSERT PAYMENT =====
	                     *
	                     */
	                    if(isset($payments_refunds)){
	                        foreach($payments_refunds as $pay_data){
	                            switch($pay_data["payment"]["type"]){
	                                case 'payment':
	                                    $data_payment = array();
	                                    $data_payment["reservation_id"] = $hms_reservation_id;
	                                    $data_payment["amount"] = $pay_data["payment"]["amount"];
	                                    $data_payment["payment_date"] = $pay_data["payment"]["payment_date"];
	                                    $data_payment["description"] = $pay_data["payment"]["description"];
	                                    $this->echannel_model->insert_payment($data_payment);
	                                    break;
	                                case 'refund':
	                                    $data_refund = array();
	                                    $data_refund["res_id"] = $hms_reservation_id;
	                                    $data_refund["amount"] = $pay_data["payment"]["amount"];
	                                    $data_refund["id_partner"] = 0;
	                                    $data_refund["type"] = 1;
	                                    $data_refund["reason"] = "";
	                                    $data_refund["operationtime"] = $pay_data["payment"]["payment_date"];
	                                    $data_refund["description"] = $pay_data["payment"]["description"];
	                                    $this->frontdesk->insert_refund($data_refund, 1);
	                                    break;
	                            }
	                        }   
	                    }
	                    
	                    
	                    $reservationpush["response"] = "ok";
	                    $reservationpush["text"] = "order_created";
	                    $reservationpush["status"] = "new";
	                    $reservationpush["hms_reservation_id"] = $hms_reservation_id;
	                    $result_array["status"] = "new";
	                    $result_array["reservation"]["reservation_alert"] = $reservationpush["text"];
	                    $result_array["reservation"]["hms_reservation_id"] = $reservationpush["hms_reservation_id"];
	                    $result_array["reservation"]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush["hms_reservation_id"];
	                    $k ++;
	                } else {
	                    // $confirm_fail = 1;
	                    $reservationpush["response"] = "fail";
	                    $reservationpush["text"] = "undferror";
	                    $reservationpush["status"] = "new";
	                    $reservationpush["hms_reservation_id"] = 0;
	                    $result_array["status"] = "new";
	                    $result_array["reservation"]["reservation_alert"] = $reservationpush["text"];
	                    $result_array["reservation"]["hms_reservation_id"] = $reservationpush["hms_reservation_id"];
	                    $result_array["reservation"]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush["hms_reservation_id"];
	                    $k ++;
	                }
	            }
	        }
	
	        $hotel_name = "";
	        $query = $this->db->query("SELECT * FROM logo");
	        if ($query->num_rows() > 0) {
	            $row = $query->row();
	            $hotel_name = stripslashes($row->logo_title);
	        }
	
	        $counter_r = 0;
	        $new_mass = array();
	
	        if ($result_array["status"] == "new") {
	            $new_mass['dcname'] = "Echannel";
	            $new_mass['status'] = $result_array["status"];
	            $new_mass['dc_reservationid'] = $result_array["reservation"]["hms_reservation_id"];
	            $new_mass['dc_channel_name'] = "Echannel";
	            $new_mass['hotel_name'] = $hotel_name;
	            $new_mass['guest_firstname'] = $result_array["guest"]["firstname"];
	            $new_mass['guest_lastname'] = $result_array["guest"]["lastname"];
	            $new_mass['guest_phone'] = $result_array["guest"]["phone"];
	            $new_mass['guest_email'] = $result_array["guest"]["email"];
	
	            $new_mass["room"][$counter_r]["reservation_current"] = 0;
	            $new_mass["room"][$counter_r]["reservation_alert"] = $result_array["reservation"]["reservation_alert"];
	            $new_mass["room"][$counter_r]["hms_reservation_id"] = $result_array["reservation"]["hms_reservation_id"];
	            $new_mass["room"][$counter_r]["url"] = $result_array["reservation"]["url"];
	            $new_mass["room"][$counter_r]["dc_channel_name"] = "Echannel";
	
	            $new_mass["room"][$counter_r]["reservation_dc_reservationid"] = $result_array["reservation"]["dc_reservationid"];
	            $new_mass["room"][$counter_r]["reservation_dc_roomreservation_id"] = $result_array["reservation"]["dc_roomreservation_id"];
	            $new_mass["room"][$counter_r]["hotel_name"] = "hotel_name";
	            $new_mass["room"][$counter_r]["reservation_date"] = $result_array["reservation"]["date"];
	            $new_mass["room"][$counter_r]["status"] = $result_array["status"];
	            $new_mass["room"][$counter_r]["reservation_datein"] = $result_array["reservation"]["datein"];
	            $new_mass["room"][$counter_r]["reservation_dateout"] = $result_array["reservation"]["dateout"];
	            $new_mass["room"][$counter_r]["reservation_type_name"] = $result_array["reservation"]["reservation_type_name"];
	            $new_mass["room"][$counter_r]["reservation_category_id"] = $result_array["reservation"]["type_id"];
	            $new_mass["room"][$counter_r]["reservation_dc_totalprice"] = $result_array["reservation"]["dc_totalprice"];
	            $new_mass["room"][$counter_r]["reservation_dc_customerremarks"] = $result_array["reservation"]["dc_customerremarks"];
	
	            $new_mass["room"][$counter_r]["dc_rate_intdate_data"] = $result_array["per_day"];
	        }
	
	        if (count($new_mass) > 0) {
	            $this->dc_model->send_notifyarray_new($new_mass, $debug);
	        }
	    }
	    
	    $data = array(
	        'response' => json_encode($reservationpush),
	        'responseint' => "",
	        'stime' => (microtime(true) - $timestart)
	    );
	    
	    $this->db->update('dc_echannel_log', $data, array(
	        'id' => $dc_log_id
	    ));
	    
	    $this->Loger_admin->Save_SyncData ( "", "", json_encode($reservationpush), 16, 10, $dc_log_id );
	
	    if ($debug) {
	        echo "<pre>";
	        echo "\n\n --- XML reservationpush START --- \n\n";
	        print_r($reservationpush);
	        echo "\n\n --- XML reservationpush END --- \n\n";
	    }
	
	    //         if ($reservationpush['status'] == "cancel") {
	    //             $data = array();
	    //             $data["hms_reservation_id"] = $reservationpush["hms_reservation_id"];
	    //             $data['response'] = $reservationpush['response'];
	    //             $data['resid'] = $reservationpush['dc_reservationid'];
	    //             $data['dcname'] = "Echannel";
	    //             $data['status'] = $reservationpush['status'];
	    //             $data['text'] = $reservationpush['text'];
	    //             $this->dc_model->send_notifyarray($data);
	    //         }
	
	    echo json_encode($reservationpush, true);
	}
	
	function set_reservations($debug = 0)
	{
	    $postdata = file_get_contents("php://input");
	    $postdata = json_decode($postdata, true);
	    $hms_id = $postdata['hms_id'];
	
	    $categories_names = array();
	    $query = $this->db->query("SELECT id, name FROM categories");
	    if ($query->num_rows() > 0) {
	        foreach ($query->result() as $row) {
	            $categories_names[$row->id] = $row->name;
	        }
	    }
	
	    $rates_names = array();
	    $query = $this->db->query("SELECT caption, id FROM  rate");
	    if ($query->num_rows() > 0) {
	        foreach ($query->result() as $row) {
	            $rates_names[$row->id]["dc_rate_name"] = $row->caption;
	        }
	    }
	
	    $query = $this->db->query("SELECT int_value FROM dc_tripadvisor_xml_cfg WHERE name LIKE 'dealer_id'");
	    if ($query->num_rows() > 0) {
	        $row = $query->row();
	        $dealer = $row->int_value;
	    }
	
	    $query = $this->db->query("SELECT value FROM hotelix_config WHERE name LIKE 'overbooking_category_id'");
	    if ($query->num_rows() > 0) {
	        $row = $query->row();
	        $overbooking_category_id = $row->value;
	    }
	
	    $timezone = "";
	    $query = $this->db->query("SELECT str_value FROM hotelix_config WHERE name LIKE 'timezone'");
	    if ($query->num_rows() > 0) {
	        $row = $query->row();
	        $timezone = $row->str_value;
	    } else {
	        $timezone = "America/Los_Angeles";
	    }
	
	    $checkin_checkout_arr = $this->frontdesk->get_check_in_out_time();
	    
	    $bookings = array();
	    if (isset($postdata["bookings_list"])) {
	        $bookings = $postdata["bookings_list"];
	    }elseif(isset($postdata["booking"])){
	        $bookings[0] = $postdata["booking"];
	    }
	    
	    
	    $result_array = array();
	    $i = 0;
	    foreach ($bookings as $reservation) {
	        $dc_id = $postdata["dc_id"];
	        if (isset($reservation["id"])) {
	            $reservation["dc_uuid"] = $reservation["id"];
	            $dc_room_id = $reservation["room_id"];
	            $dc_rate_id = $reservation["rate_id"];
	
	            $datein = $reservation["date_in"];
	            $dateout = $reservation["date_out"];
	
	            list ($year, $month, $day) = explode("-", $datein);
	            $intdate_start = round(mktime(0, 0, 0, $month, $day, $year) / 86400);
	            list ($year, $month, $day) = explode("-", $dateout);
	            $intdate_end = round(mktime(0, 0, 0, $month, $day, $year) / 86400);
	            $duration = $intdate_end - $intdate_start;
	
	            $guest_count = 1;
	            $result_array[$i]["guests"] = array();
	            if($reservation["guest_count"] > 0){
	                $guest_count = $reservation["guest_count"];
	                $result_array[$i]["guests"] = $reservation['guest_data'];
	            }
	
	            if($reservation["price"] > 0){
	                $amount = $reservation["price"];
	                $per_day_price = $reservation["price"] / $duration;
	            }else{
	                $calc_data = array();
	                $calc_data ["datein"] = $datein;
	                $calc_data ["dateout"] = $dateout;
	                $calc_data ["type_id"] = $dc_room_id;
	                $calc_data ["price_type"] = $dc_rate_id;
	                $calc_data ["adults"] = $reservation["guest_count"];
	                $calc_data ["add_places"] = 0;
	                $calc_data ["baby_places"] = 0;
	                $calc_data ["addbedplace"] = 0;
	                $calc_data ["babyplace2"] = 0;
	                //echo "<pre>";
	                //print_r($calc_data);
	                $temp_amount = $this->frontdesk->getpricecalculation ( $calc_data );
	                $amount = 0;
	                foreach ( $temp_amount as $cell ) {
	                    $amount += $cell ["amount"];
	                }
	
	                $per_day_price = $amount / $duration;
	            }
	
	            $dc_total_price = 0;
	            $k = 0;
	            for ($date_inc = $intdate_start; $date_inc < $intdate_end; $date_inc ++) {
	                $date = date('Y-m-d', $date_inc * 86400);
	
	
	
	                $result_array[$i]["per_day"][$k]["dc_currencycode"] = "";
	                $result_array[$i]["per_day"][$k]["dc_reservation_id"] = $reservation["dc_uuid"];
	                $result_array[$i]["per_day"][$k]["price"] = $per_day_price;
	                $result_array[$i]["per_day"][$k]["dc_rate_id"] = "";
	
	                $result_array[$i]["per_day"][$k]["dc_rate_name"] = "";
	                if(isset($rates_names[$dc_rate_id]["dc_rate_name"])){
	                    $result_array[$i]["per_day"][$k]["dc_rate_name"] = $rates_names[$dc_rate_id]["dc_rate_name"];
	                }
	
	                $result_array[$i]["per_day"][$k]["intdate"] = $date_inc;
	                $result_array[$i]["per_day"][$k]["date_rate"] = $date;
	
	                $dc_total_price += $per_day_price;
	                $k ++;
	            }
	
	            // ========================================
	
	
	            $result_array[$i]["dc_rate_id"] = $dc_rate_id;
	            $result_array[$i]["currencycode"] = "";
	
	            $result_array[$i]["card"]["cc_cvc"] = "";
	
	            $result_array[$i]["card"]["ExpMonth"] = "";
	            $result_array[$i]["card"]["ExpYear"] = "";
	            $result_array[$i]["card"]["CardHolder"] = "";
	            $result_array[$i]["card"]["CardNumber"] = "";
	            $result_array[$i]["card"]["cc_type"] = "";
	
	            $result_array[$i]["guest"]["address"] = "";
	            $result_array[$i]["guest"]["city"] = "";
	            $result_array[$i]["guest"]["email"] = $reservation["email"];
	            $result_array[$i]["guest"]["firstname"] = $reservation["first_name"];
	            $result_array[$i]["guest"]["lastname"] = $reservation["last_name"];
	            $result_array[$i]["guest"]["phone"] = $reservation["phone"];
	            $result_array[$i]["guest"]["country"] = "";
	            $result_array[$i]["guest"]["passportid"] = "";
	
	            $result_array[$i]["status"] = $reservation["status"];
	            // $result_array [$i] ["status"] = "cancelled";
	            $result_array[$i]["dc_reservationid"] = "";
	
	            $created_datetime = explode(" ", $reservation["created"]);
	            $created_date = $created_datetime[0];
	            $created_time = $created_datetime[1];
	
	            $result_array[$i]["reservation"]["dc_id"] = $dc_id;
	
	            $result_array[$i]["reservation"]["commissionamount"] = 0;
	            $result_array[$i]["reservation"]["date"] = $created_date;
	            $result_array[$i]["reservation"]["dc_reservationid"] = "";
	            $result_array[$i]["reservation"]["time"] = $created_time;
	            $result_array[$i]["reservation"]["dc_date"] = $created_date;
	            $result_array[$i]["reservation"]["dc_time"] = $created_time;
	
	            $result_array[$i]["reservation"]["dc_updatetime"] = "";
	
	            $result_array[$i]["reservation"]["isNew"] = 1;
	
	            $result_array[$i]["reservation"]["datein"] = $datein;
	            $result_array[$i]["reservation"]["checkintime"] = "";
	
	            $result_array[$i]["reservation"]["dateout"] = $dateout;
	            $result_array[$i]["reservation"]["checkouttime"] = "";
	
	            $result_array[$i]["reservation"]["dc_roomreservation_id"] = "";
	            // $result_array[$i]["reservation"]["dc_uuid"] = $reservation["booking_id"] . "_" . $dc_room_id . "_" . $j;
	            $result_array[$i]["reservation"]["dc_uuid"] = $reservation["dc_uuid"];
	            $result_array[$i]["reservation"]["category_id"] = $dc_room_id;
	            if (isset($categories_names[$dc_room_id])) {
	                $result_array[$i]["reservation"]["reservation_type_name"] = $categories_names[$dc_room_id];
	            } else {
	                $result_array[$i]["reservation"]["reservation_type_name"] = "";
	            }
	
	            $result_array[$i]["reservation"]["placement_id"] = "";
	            $result_array[$i]["reservation"]["add_places"] = 0;
	            $result_array[$i]["reservation"]["baby_places"] = 0;
	            $result_array[$i]["reservation"]["adults"] = $guest_count;
	            $result_array[$i]["reservation"]["amount"] = $amount;
	
	            $result_array[$i]["reservation"]["price_type"] = $dc_rate_id;
	
	            $result_array[$i]["reservation"]["description"] = "";
	            if (isset($_SESSION["user"]["id"])) {
	                $result_array[$i]["reservation"]["user"] = $_SESSION["user"]["id"];
	            } else {
	                $result_array[$i]["reservation"]["user"] = - 1;
	            }
	            $result_array[$i]["reservation"]["type_id"] = $dc_room_id;
	            $result_array[$i]["reservation"]["dc_type_id"] = $dc_room_id;
	
	            $result_array[$i]["reservation"]["dealer"] = $dealer;
	            $result_array[$i]["reservation"]["dc_guestname"] = $reservation["first_name"] . " " . $reservation["last_name"];
	            $result_array[$i]["reservation"]["dc_numberofguest"] = $guest_count;
	            $result_array[$i]["reservation"]["dc_countrycode"] = "";
	            $result_array[$i]["reservation"]["dc_currencycode"] = "";
	            $result_array[$i]["reservation"]["dc_city"] = "";
	            $result_array[$i]["reservation"]["dc_customerremarks"] = "";
	            $result_array[$i]["reservation"]["dc_roomremarks"] = "";
	            $result_array[$i]["reservation"]["description"] = "";
	
	            $result_array[$i]["reservation"]["dc_totalprice"] = $dc_total_price;
	
	            $result_array[$i]["reservation"]["smoking"] = "";
	
	            $result_array[$i]["roomreservation_id"] = "";
	
	            // =============================================================================
	            $result_array[$i]["reservation"]["early_check_in_close"] = 0;
	            $result_array[$i]["reservation"]["late_check_out_close"] = 0;
	            if(isset($reservation["group_id"])){
	                if(trim($reservation["group_id"]) != ""){
	                   $result_array[$i]["reservation"]["group_name"] = $reservation["group_id"];
	                }
	            }
	        }
	        $i ++;
	    }
	
	    if ($debug) {
	        echo "<pre>";
	        print_r($result_array);
	        // die ();
	    }
	
	    $host = "";
	
	    $reservationpush = array();
	    //if (isset($result_array["reservation"])) {
	    $k = 0;
	    $qty = count($result_array);
	    //$intgroupid = 0;
	    foreach($result_array as $reservation_data) {        
	        $bool_cancel = 0;
	        $guest_array = array();
	        $guest_counter = 1;
	
	        if ($qty > 1) {
	             if(isset($reservation_data["reservation"]["group_name"])){
	                $hms_group_id = 0;
	                
	                $group_name = $reservation_data["reservation"]["group_name"];
	                $sql = "SELECT id as group_id FROM groupreservations WHERE name LIKE '".$group_name."'";
	                $query = $this->db->query( $sql );
	                if ($query->num_rows() > 0) {
	                    $row = $query->row();
	                    $hms_group_id = $row->group_id;
	                }
                    if($hms_group_id == 0){
	                   $hms_group_id = $this->group_res_model->makenewid($group_name);
                    }
                    
                    if($hms_group_id > 0){
                        $reservation_data["reservation"]["intgroupid"] = $hms_group_id;
                    }
	            }
	            
	        }

	        $dc_reservationid = $reservation_data["reservation"]["dc_reservationid"];
	        $dc_status = $reservation_data["status"];
	        $bool_guest = 0;
	
	        $calculate_data = array();
	        $calculate_data["type_id"] = $reservation_data["reservation"]["type_id"];
	        $calculate_data["datein"] = $reservation_data["reservation"]["datein"];
	        $calculate_data["dateout"] = $reservation_data["reservation"]["dateout"];
	        $calculate_data["add_places"] = $reservation_data["reservation"]["add_places"];
	        $calculate_data["baby_places"] = $reservation_data["reservation"]["baby_places"];
	        $calculate_data["addbedplace"] = 0;
	        $calculate_data["babyplace2"] = 0;
	        $calculate_data["price_type"] = $reservation_data["reservation"]["price_type"];
	
	        $temp_amount = $this->frontdesk->getpricecalculation($calculate_data);
	        $otelms_amount = 0;
	        for ($p = 0; $p < count($temp_amount); $p ++) {
	            $otelms_amount += $temp_amount[$p]["amount"];
	        }
	        $booking_amount = $reservation_data["reservation"]["amount"];
	        // $reservations [$i] ["reservation"] ["discount"] = 0;
	        if ($booking_amount != $otelms_amount) {
	            $reservation_data["reservation"]["discount"] = $otelms_amount - $booking_amount;
	        }
	
	        $datein = $reservation_data["reservation"]["datein"];
	        $dateout = $reservation_data["reservation"]["dateout"];
	        $type_id = $reservation_data["reservation"]["type_id"];
	        $sql = "SELECT id, room_id FROM deskofreservation WHERE dc_id = $dc_id AND cancel=0 AND deleted = 0 AND dc_uuid LIKE '" . $reservation_data["reservation"]["dc_uuid"] . "' ORDER BY id DESC ";
	        // echo $sql;
	        $query = $this->db->query($sql);
	        $hms_reservation_id = 0;
	        $otelms_room_id = 0;
	        if ($query->num_rows() > 0) {
	            $row = $query->row();
	            $hms_reservation_id = $row->id;
	            $otelms_room_id = $row->room_id;
	            $reservationpush[$k]["response"] = "fail";
	            $reservationpush[$k]["text"] = "order_exist";
	            $reservationpush[$k]["status"] = $reservation_data["status"];
	            $reservationpush[$k]["hms_reservation_id"] = $row->id;
	            $reservationpush[$k]["dc_book_id"] = $reservation_data["reservation"]["dc_uuid"];
	            $reservation_data["reservation"]["reservation_alert"] = "order_exist";
	            $reservation_data["reservation"]["hms_reservation_id"] = $hms_reservation_id;
	            $reservation_data["reservation"]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $hms_reservation_id;
	            $k ++;
	        } else {
	
	
	            /*
	             * NEW RESERVATION BLOCK
	             */
	
	            $room_id = 0;
	
	            if ($type_id == 0 or $type_id == "") {
	                $query2 = $this->db->query("SELECT value FROM hotelix_config WHERE name LIKE 'overbooking_category_id'");
	                if ($query->num_rows() > 0) {
	                    $row2 = $query2->row();
	                    $type_id = $row2->value;
	                }
	            }
	            
	            if ($type_id == 0 || $type_id == "" || !isset($categories_names[$type_id])) {
	                $reservationpush[$k]["response"] = "fail";
	                $reservationpush[$k]["text"] = "UNKNOWN CATEGORY";
	                $reservationpush[$k]["status"] = "new";
	                $reservationpush[$k]["hms_reservation_id"] = 0;
	                $reservationpush[$k]["dc_book_id"] = $reservation_data["reservation"]["dc_uuid"];
	                $reservation_data["status"] = "new";
	                $reservation_data["reservation"]["reservation_alert"] = $reservationpush[$k]["text"];
	                $reservation_data["reservation"]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
	                $reservation_data["reservation"]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
	                $k ++;
	            } else {
	                $room_id = $this->frontdesk->getfreeroomlist($datein, $dateout, $type_id, 0, 0, $reservation_data["reservation"]["early_check_in_close"], $reservation_data["reservation"]["late_check_out_close"]);
	                if ($room_id == 0) {
	
	                    if (isset($overbooking_category_id)) {
	                        $reservation_data["reservation"]["origin_categoryid"] = $type_id;
	                        $room_id = $this->frontdesk->getfreeroomlist($datein, $dateout, $overbooking_category_id, 0, 0, $reservation_data["reservation"]["early_check_in_close"], $reservation_data["reservation"]["late_check_out_close"]);
	
	                        $insert_over_room_bool = 0;
	                        if ($room_id == 0) {
	                            $room_id = $this->dc_model->dc_make_overbooking_room($overbooking_category_id);
	                            $insert_over_room_bool = 1;
	                        }
	                    } else {
	                        $reservationpush[$k]["response"] = "fail";
	                        $reservationpush[$k]["text"] = "no overbooking_category_id";
	                        $reservationpush[$k]["status"] = "new";
	                        $reservationpush[$k]["hms_reservation_id"] = 0;
	                        $reservationpush[$k]["dc_book_id"] = $reservation_data["reservation"]["dc_uuid"];
	                        $reservation_data["status"] = "new";
	                        $reservation_data["reservation"]["reservation_alert"] = $reservationpush[$k]["text"];
	                        $reservation_data["reservation"]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
	                        $reservation_data["reservation"]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
	                        $k ++;
	                    }
	                }
	                $reservation_data["reservation"]["room_id"] = $room_id;
	
	                if ($bool_guest == 0) {
	                    $guest_id = $this->frontdesk->Guest_insert ( $reservation_data["guest"] );
	                    $add_guests = array ();
	                    $add_g_i = 0;
	                    for($g_i = 0; $g_i < $guest_count; $g_i ++) {
	                        $add_guests [$add_g_i] = $this->frontdesk->Guest_insert ( $reservation_data ["guests"] [$g_i] );
	                        $add_g_i ++;
	                    }
	
	                    //$guest_id = $this->frontdesk->Guest_insert($reservation_data["guest"]);
	                    $bool_guest = 1;
	                }
	                $hms_reservation_id = $this->frontdesk->Reservation_insert($reservation_data["reservation"], $guest_id, 0, 1);
	
	                if (isset($otelms_rooms[$dc_reservationid][$reservation_data["reservation"]["dc_uuid"]])) {
	                    $otelms_rooms[$dc_reservationid][$reservation_data["reservation"]["dc_uuid"]]["status"] = 1;
	                }
	
	                $count_add_guests = count ( $add_guests );
	                for($add_g_i = 0; $add_g_i < $count_add_guests; $add_g_i ++) {
	                    $this->frontdesk->guests_reservation_insert ( $add_guests [$add_g_i], $hms_reservation_id );
	                }
	
	                if (isset($reservation_data["card"])) {
	                    $this->frontdesk->insert_tbl_CreditCards($reservation_data["card"], $guest_id, $hms_reservation_id);
	                }
	
	                if ($hms_reservation_id > 0) {
	                    $reservationpush[$k]["response"] = "ok";
	                    $reservationpush[$k]["text"] = "order_created";
	                    $reservationpush[$k]["status"] = "new";
	                    $reservationpush[$k]["hms_reservation_id"] = $hms_reservation_id;
	                    $reservationpush[$k]["dc_book_id"] = $reservation_data["reservation"]["dc_uuid"];
	                    $reservation_data["status"] = "new";
	                    $reservation_data["reservation"]["reservation_alert"] = $reservationpush[$k]["text"];
	                    $reservation_data["reservation"]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
	                    $reservation_data["reservation"]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
	                    $k ++;
	                } else {
	                    // $confirm_fail = 1;
	                    $reservationpush[$k]["response"] = "fail";
	                    $reservationpush[$k]["text"] = "undferror";
	                    $reservationpush[$k]["status"] = "new";
	                    $reservationpush[$k]["hms_reservation_id"] = 0;
	                    $reservationpush[$k]["dc_book_id"] = $reservation_data["reservation"]["dc_uuid"];
	                    $reservation_data["status"] = "new";
	                    $reservation_data["reservation"]["reservation_alert"] = $reservationpush[$k]["text"];
	                    $reservation_data["reservation"]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
	                    $reservation_data["reservation"]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
	                    $k ++;
	                }
	            }
	        }
	
	        $hotel_name = "";
	        $query = $this->db->query("SELECT * FROM logo");
	        if ($query->num_rows() > 0) {
	            $row = $query->row();
	            $hotel_name = stripslashes($row->logo_title);
	        }
	
	        $counter_r = 0;
	        $new_mass = array();
	
	        if ($reservation_data["status"] == "new") {
	            $new_mass['dcname'] = "Echannel";
	            $new_mass['status'] = $reservation_data["status"];
	            $new_mass['dc_reservationid'] = $reservation_data["reservation"]["hms_reservation_id"];
	            $new_mass['dc_channel_name'] = "Echannel";
	            $new_mass['hotel_name'] = $hotel_name;
	            $new_mass['guest_firstname'] = $reservation_data["guest"]["firstname"];
	            $new_mass['guest_lastname'] = $reservation_data["guest"]["lastname"];
	            $new_mass['guest_phone'] = $reservation_data["guest"]["phone"];
	            $new_mass['guest_email'] = $reservation_data["guest"]["email"];
	
	            $new_mass["room"][$counter_r]["reservation_current"] = 0;
	            $new_mass["room"][$counter_r]["reservation_alert"] = $reservation_data["reservation"]["reservation_alert"];
	            $new_mass["room"][$counter_r]["hms_reservation_id"] = $reservation_data["reservation"]["hms_reservation_id"];
	            $new_mass["room"][$counter_r]["url"] = $reservation_data["reservation"]["url"];
	            $new_mass["room"][$counter_r]["dc_channel_name"] = "Echannel";
	
	            $new_mass["room"][$counter_r]["reservation_dc_reservationid"] = $reservation_data["reservation"]["dc_reservationid"];
	            $new_mass["room"][$counter_r]["reservation_dc_roomreservation_id"] = $reservation_data["reservation"]["dc_roomreservation_id"];
	            $new_mass["room"][$counter_r]["hotel_name"] = "hotel_name";
	            $new_mass["room"][$counter_r]["reservation_date"] = $reservation_data["reservation"]["date"];
	            $new_mass["room"][$counter_r]["status"] = $reservation_data["status"];
	            $new_mass["room"][$counter_r]["reservation_datein"] = $reservation_data["reservation"]["datein"];
	            $new_mass["room"][$counter_r]["reservation_dateout"] = $reservation_data["reservation"]["dateout"];
	            $new_mass["room"][$counter_r]["reservation_type_name"] = $reservation_data["reservation"]["reservation_type_name"];
	            $new_mass["room"][$counter_r]["reservation_category_id"] = $reservation_data["reservation"]["type_id"];
	            $new_mass["room"][$counter_r]["reservation_dc_totalprice"] = $reservation_data["reservation"]["dc_totalprice"];
	            $new_mass["room"][$counter_r]["reservation_dc_customerremarks"] = $reservation_data["reservation"]["dc_customerremarks"];
	
	            $new_mass["room"][$counter_r]["dc_rate_intdate_data"] = $reservation_data["per_day"];
	        }
	
	        if (count($new_mass) > 0) {
	            $this->dc_model->send_notifyarray_new($new_mass, $debug);
	        }
	    }
	
	    if ($debug) {
	        echo "<pre>";
	        echo "\n\n --- XML reservationpush START --- \n\n";
	        print_r($reservationpush);
	        echo "\n\n --- XML reservationpush END --- \n\n";
	    }
	
	    //         if ($reservationpush['status'] == "cancel") {
	    //             $data = array();
	    //             $data["hms_reservation_id"] = $reservationpush["hms_reservation_id"];
	    //             $data['response'] = $reservationpush['response'];
	    //             $data['resid'] = $reservationpush['dc_reservationid'];
	    //             $data['dcname'] = "Echannel";
	    //             $data['status'] = $reservationpush['status'];
	    //             $data['text'] = $reservationpush['text'];
	    //             $this->dc_model->send_notifyarray($data);
	    //         }
	
	    echo json_encode($reservationpush, true);
	}
    
    function set_reservation_OLD($debug = 0)
    {
        $postdata = file_get_contents("php://input");
        $postdata = json_decode($postdata, true);
        $hms_id = $postdata['hms_id'];
    
        $categories_names = array ();
        $query = $this->db->query ( "SELECT id, name FROM categories" );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $categories_names [$row->id] = $row->name;
            }
        }
    
        $rates_names = array ();
        $query = $this->db->query ( "SELECT caption, id FROM  rate" );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $rates_names [$row->id] ["dc_rate_name"] = $row->caption;
            }
        }
    
        $query = $this->db->query("SELECT int_value FROM dc_nash_travel_xml_cfg WHERE name LIKE 'dealer_id'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $dealer = $row->int_value;
        }
    
        $query = $this->db->query("SELECT value FROM hotelix_config WHERE name LIKE 'overbooking_category_id'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $overbooking_category_id = $row->value;
        }
    
    
        $timezone = "";
        $query = $this->db->query("SELECT str_value FROM hotelix_config WHERE name LIKE 'timezone'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $timezone = $row->str_value;
        } else {
            $timezone = "America/Los_Angeles";
        }
    
        $checkin_checkout_arr = $this->frontdesk->get_check_in_out_time();
    
        $result_array = array();
        // print_r($data );
        if (isset($postdata["booking_data"])) {
            $dc_id = $postdata["dc_id"];
            $reservations = array();
            if (isset($postdata["booking_data"][0])) {
                $reservations = $postdata["booking_data"];
            } else {
                $reservations[0] = $postdata["booking_data"];
            }
    
            $counter = 0;
            $otelms_rooms = array();
            foreach ($reservations as $reservation) {
                if (isset($reservation["id"])) {
                    $reservation["dc_uuid"] = $reservation["id"];
                    $sql = "SELECT id, dc_uuid FROM deskofreservation WHERE deleted = 0 AND cancel = 0 AND dc_id = $dc_id AND dc_uuid LIKE '" . $reservation["dc_uuid"]."'";
                    // echo $sql."<pre>";
                    $query = $this->db->query($sql);
    
                    if ($query->num_rows() > 0) {
                        foreach ($query->result() as $row) {
                            $otelms_rooms[2][$row->dc_uuid]["otelms_reservation_id"] = $row->id;
                            $otelms_rooms[2][$row->dc_uuid]["dc_uuid"] = $row->dc_uuid;
                            $otelms_rooms[2][$row->dc_uuid]["status"] = 0;
                        }
                    }
    
                    $rooms_data = array();
                    if (! isset($reservation["rooms"][0])) {
                        $rooms_data[0] = $reservation["rooms"];
                    } else {
                        $rooms_data = $reservation["rooms"];
                    }
    
                    $qty = count($rooms_data);
                    for ($j = 0; $j < $qty; $j ++) {
                        $dc_room_id = $rooms_data[$j]["room_type"];
                        $dc_rate_id = $rooms_data[$j]["rate_type"];
                         
                        $datein = $rooms_data[$j]["datein"];
                        $dateout = $rooms_data[$j]["dateout"];
    
                        list ($year, $month, $day) = explode("-", $datein);
                        $intdate_start = round(mktime(0, 0, 0, $month, $day, $year) / 86400);
                        list ($year, $month, $day) = explode("-", $dateout);
                        $intdate_end = round(mktime(0, 0, 0, $month, $day, $year) / 86400);
                        $duration = $intdate_end - $intdate_start;
    
                        $dc_total_price = 0;
                        $k = 0;
                        for ($date_inc = $intdate_start; $date_inc < $intdate_end; $date_inc ++) {
                            $date = date('Y-m-d', $date_inc * 86400);
    
                            $price = $rooms_data[$j]["price"] / $duration;
    
                            $result_array["reservations"][$counter][$j]["per_day"][$k]["dc_currencycode"] = "";
                            $result_array["reservations"][$counter][$j]["per_day"][$k]["dc_reservation_id"] = $reservation["dc_uuid"];
                            $result_array["reservations"][$counter][$j]["per_day"][$k]["price"] = $price;
                            $result_array["reservations"][$counter][$j]["per_day"][$k]["dc_rate_id"] = "";
    
                            $result_array["reservations"][$counter][$j]["per_day"][$k]["dc_rate_name"] = $rates_names[$dc_rate_id]["dc_rate_name"];
    
                            $result_array["reservations"][$counter][$j]["per_day"][$k]["intdate"] = $date_inc;
                            $result_array["reservations"][$counter][$j]["per_day"][$k]["date_rate"] = $date;
    
                            $dc_total_price += $price;
                            $k ++;
                        }
                         
                        // ========================================
    
                        $result_array["reservations"][$counter][$j]["guests"] = array();
    
                        $result_array["reservations"][$counter][$j]["dc_rate_id"] = $dc_rate_id;
                        $result_array["reservations"][$counter][$j]["currencycode"] = "";
    
                        $result_array["reservations"][$counter][$j]["card"]["cc_cvc"] = "";
    
                        $result_array["reservations"][$counter][$j]["card"]["ExpMonth"] = "";
                        $result_array["reservations"][$counter][$j]["card"]["ExpYear"] = "";
                        $result_array["reservations"][$counter][$j]["card"]["CardHolder"] = "";
                        $result_array["reservations"][$counter][$j]["card"]["CardNumber"] = "";
                        $result_array["reservations"][$counter][$j]["card"]["cc_type"] = "";
    
                        $result_array["reservations"][$counter][$j]["guest"]["address"] = "";
                        $result_array["reservations"][$counter][$j]["guest"]["city"] = "";
                        $result_array["reservations"][$counter][$j]["guest"]["email"] = $reservation["guest_data"]["email"];
                        $result_array["reservations"][$counter][$j]["guest"]["firstname"] = $reservation["guest_data"]["firstname"];
                        $result_array["reservations"][$counter][$j]["guest"]["lastname"] = $reservation["guest_data"]["lastname"];
                        $result_array["reservations"][$counter][$j]["guest"]["phone"] = $reservation["guest_data"]["phone"];
                        $result_array["reservations"][$counter][$j]["guest"]["country"] = "";
                        $result_array["reservations"][$counter][$j]["guest"]["passportid"] = "";
    
                        $result_array["reservations"][$counter][$j]["status"] = $rooms_data[$j]["status"];
                        // $result_array ["reservations"] [$i] ["status"] = "cancelled";
                        $result_array["reservations"][$counter][$j]["dc_reservationid"] = "";
    
                        $created_datetime = explode(" ", $reservation["created"]);
                        $created_date = $created_datetime[0];
                        $created_time = $created_datetime[1];
    
                        $result_array["reservations"][$counter][$j]["reservation"]["dc_id"] = $dc_id;
    
                        $result_array["reservations"][$counter][$j]["reservation"]["commissionamount"] = 0;
                        $result_array["reservations"][$counter][$j]["reservation"]["date"] = $created_date;
                        $result_array["reservations"][$counter][$j]["reservation"]["dc_reservationid"] = "";
                        $result_array["reservations"][$counter][$j]["reservation"]["time"] = $created_time;
                        $result_array["reservations"][$counter][$j]["reservation"]["dc_date"] = $created_date;
                        $result_array["reservations"][$counter][$j]["reservation"]["dc_time"] = $created_time;
    
                        $result_array["reservations"][$counter][$j]["reservation"]["dc_updatetime"] = "";
    
                        $result_array["reservations"][$counter][$j]["reservation"]["isNew"] = 1;
    
                        $result_array["reservations"][$counter][$j]["reservation"]["datein"] = $datein;
                        $result_array["reservations"][$counter][$j]["reservation"]["checkintime"] = "";
    
                        $result_array["reservations"][$counter][$j]["reservation"]["dateout"] = $dateout;
                        $result_array["reservations"][$counter][$j]["reservation"]["checkouttime"] = "";
    
                        $result_array["reservations"][$counter][$j]["reservation"]["dc_roomreservation_id"] = "";
                        //$result_array["reservations"][$counter][$j]["reservation"]["dc_uuid"] = $reservation["booking_id"] . "_" . $dc_room_id . "_" . $j;
                        $result_array["reservations"][$counter][$j]["reservation"]["dc_uuid"] = $reservation["dc_uuid"];
                        $result_array["reservations"][$counter][$j]["reservation"]["category_id"] = $dc_room_id;
                        if (isset($categories_names[$dc_room_id])) {
                            $result_array["reservations"][$counter][$j]["reservation"]["reservation_type_name"] = $categories_names[$dc_room_id];
                        } else {
                            $result_array["reservations"][$counter][$j]["reservation"]["reservation_type_name"] = "";
                        }
    
                        $result_array["reservations"][$counter][$j]["reservation"]["placement_id"] = "";
                        $result_array["reservations"][$counter][$j]["reservation"]["add_places"] = 0;
                        $result_array["reservations"][$counter][$j]["reservation"]["baby_places"] = 0;
                        $result_array["reservations"][$counter][$j]["reservation"]["amount"] = $dc_total_price;
    
                        $result_array["reservations"][$counter][$j]["reservation"]["price_type"] = $dc_rate_id;
    
                        $result_array["reservations"][$counter][$j]["reservation"]["description"] = "";
                        if (isset($_SESSION["user"]["id"])) {
                            $result_array["reservations"][$counter][$j]["reservation"]["user"] = $_SESSION["user"]["id"];
                        } else {
                            $result_array["reservations"][$counter][$j]["reservation"]["user"] = - 1;
                        }
                        $result_array["reservations"][$counter][$j]["reservation"]["type_id"] = $dc_room_id;
                        $result_array["reservations"][$counter][$j]["reservation"]["dc_type_id"] = $dc_room_id;
    
                        $result_array["reservations"][$counter][$j]["reservation"]["dealer"] = $dealer;
                        $result_array["reservations"][$counter][$j]["reservation"]["dc_guestname"] = $reservation["guest_data"]["firstname"]." ".$reservation["guest_data"]["lastname"];
                        $result_array["reservations"][$counter][$j]["reservation"]["dc_numberofguest"] = 1;
                        $result_array["reservations"][$counter][$j]["reservation"]["dc_countrycode"] = "";
                        $result_array["reservations"][$counter][$j]["reservation"]["dc_currencycode"] = "";
                        $result_array["reservations"][$counter][$j]["reservation"]["dc_city"] = "";
                        $result_array["reservations"][$counter][$j]["reservation"]["dc_customerremarks"] = "";
                        $result_array["reservations"][$counter][$j]["reservation"]["dc_roomremarks"] = "";
                        $result_array["reservations"][$counter][$j]["reservation"]["description"] = "";
    
                        $result_array["reservations"][$counter][$j]["reservation"]["dc_totalprice"] = $dc_total_price;
    
                        $result_array["reservations"][$counter][$j]["reservation"]["smoking"] = "";
    
                        $result_array["reservations"][$counter][$j]["roomreservation_id"] = "";
    
                        // =============================================================================
                        $result_array["reservations"][$counter][$j]["reservation"]["early_check_in_close"] = 0;
                        $result_array["reservations"][$counter][$j]["reservation"]["late_check_out_close"] = 0;
    
                        // =============================================================================
    
                        if ($qty > 1) {
                            $result_array["reservations"][$counter][$j]["reservation"]["groupid"] = "";
                        }
                    }
                    $counter ++;
                }
            }
        }
    
        if($debug){
            echo "<pre>";
            print_r ( $result_array );
            //die ();
        }
    
        $host = "";
        //         if ($db_name != "") {
        //             $query = $this->db->query("SELECT host FROM visitka.config WHERE db_name LIKE '" . $db_name . "'");
    
        //             if ($query->num_rows() > 0) {
        //                 $row = $query->row();
        //                 $host = $row->host;
        //             }
        //         } else {
        //             if ($_SERVER["HTTP_HOST"]) {
        //                 $host = $_SERVER["HTTP_HOST"];
        //             }
        //         }
    
        $reservationpush = array();
    
        if (isset($result_array["reservations"])) {
            $k = 0;
    
            $bool_cancel = 0;
            $guest_array = array();
            $guest_counter = 1;
    
            foreach ($result_array["reservations"] as $key => $reservations) {
                $dc_reservationid = $reservations[0]["reservation"]["dc_reservationid"];
                $dc_status = $reservations[0]["status"];
                $res_count = count($reservations);
                $bool_guest = 0;
                // $confirm_fail = 0;
                for ($i = 0; $i < $res_count; $i ++) {
                    $sql = "SELECT id, room_id FROM deskofreservation WHERE dc_updatetime = '" . $reservations[$i]["reservation"]["dc_updatetime"] . "' AND dc_id = $dc_id AND cancel=0 AND deleted = 0 AND dc_uuid LIKE '" . $reservations[$i]["reservation"]["dc_uuid"] . "' ORDER BY id DESC ";
    
                    $query = $this->db->query($sql);
                    $hms_reservation_id = 0;
                    $otelms_room_id = 0;
                    if ($query->num_rows() > 0) {
                        $row = $query->row();
    
                        if (isset($otelms_rooms[$dc_reservationid][$reservations[$i]["reservation"]["dc_uuid"]])) {
                            $otelms_rooms[$dc_reservationid][$reservations[$i]["reservation"]["dc_uuid"]]["status"] = 1;
                        }
                    }
    
                    if ($reservations[$i]["status"] == "new") {
                        $sql = "SELECT id, room_id FROM deskofreservation WHERE dc_date = '" . $reservations[$i]["reservation"]["dc_date"] . "' AND dc_time = '" . $reservations[$i]["reservation"]["dc_time"] . "' AND dc_id = $dc_id AND dc_uuid LIKE '" . $reservations[$i]["reservation"]["dc_uuid"] . "' ORDER BY id DESC ";
    
                        $query = $this->db->query($sql);
                        $hms_reservation_id = 0;
                        $otelms_room_id = 0;
                        if ($query->num_rows() > 0) {
                            $row = $query->row();
    
                            if (isset($otelms_rooms[$dc_reservationid][$reservations[$i]["reservation"]["dc_uuid"]])) {
                                $otelms_rooms[$dc_reservationid][$reservations[$i]["reservation"]["dc_uuid"]]["status"] = 1;
                            }
    
                            $reservationpush[$k]["response"] = "fail";
                            $reservationpush[$k]["status"] = "order_exist";
                            $reservationpush[$k]["hms_reservation_id"] = $row->id;
                            $result_array["reservations"][$key][$i]["status"] = "skip";
                            $k ++;
                            // die();
                            continue;
                        }
                    }
    
                    // =========================================================================
    
                    $calculate_data = array();
                    $calculate_data["type_id"] = $reservations[$i]["reservation"]["type_id"];
                    $calculate_data["datein"] = $reservations[$i]["reservation"]["datein"];
                    $calculate_data["dateout"] = $reservations[$i]["reservation"]["dateout"];
                    $calculate_data["add_places"] = $reservations[$i]["reservation"]["add_places"];
                    $calculate_data["baby_places"] = $reservations[$i]["reservation"]["baby_places"];
                    $calculate_data["addbedplace"] = 0;
                    $calculate_data["babyplace2"] = 0;
                    $calculate_data["price_type"] = $reservations[$i]["reservation"]["price_type"];
    
                    $temp_amount = $this->frontdesk->getpricecalculation($calculate_data);
                    $otelms_amount = 0;
                    for ($p = 0; $p < count($temp_amount); $p ++) {
                        $otelms_amount += $temp_amount[$p]["amount"];
                    }
                    $booking_amount = $reservations[$i]["reservation"]["amount"];
                    // $reservations [$i] ["reservation"] ["discount"] = 0;
                    if ($booking_amount != $otelms_amount) {
                        // if ($otelms_amount != 0) {
                        $reservations[$i]["reservation"]["discount"] = $otelms_amount - $booking_amount;
                        // }
                    }
    
                    // =====================================================
                    // =====================================================
                    // =====================================================
    
                    $datein = $reservations[$i]["reservation"]["datein"];
                    $dateout = $reservations[$i]["reservation"]["dateout"];
                    $type_id = $reservations[$i]["reservation"]["type_id"];
                    $sql = "SELECT id, room_id FROM deskofreservation WHERE dc_id = $dc_id AND cancel=0 AND deleted = 0 AND dc_uuid LIKE '" . $reservations[$i]["reservation"]["dc_uuid"] . "' ORDER BY id DESC ";
                    // echo $sql;
                    $query = $this->db->query($sql);
                    $hms_reservation_id = 0;
                    $otelms_room_id = 0;
                    if ($query->num_rows() > 0) {
                        $row = $query->row();
                        $hms_reservation_id = $row->id;
                        $otelms_room_id = $row->room_id;
                    }
    
                    if (isset($reservations[$i]["per_day"])) {
    
                        $this->dc_rate_intdate_insert($reservations[$i]["per_day"]);
                    }
    
                    if ($reservations[$i]["status"] == "canceled") {
                        if (isset($otelms_rooms[$dc_reservationid][$reservations[$i]["reservation"]["dc_uuid"]])) {
                            $otelms_rooms[$dc_reservationid][$reservations[$i]["reservation"]["dc_uuid"]]["status"] = 1;
                        }
                        $query2 = $this->db->query("SELECT deskofreservation.datein, deskofreservation.dateout, rooms.category_id FROM deskofreservation INNER JOIN rooms ON rooms.id = deskofreservation.room_id WHERE dc_id = $dc_id AND deskofreservation.id = $hms_reservation_id");
    
                        if ($query2->num_rows() > 0) {
                            $row2 = $query2->row();
                            $datein = $row2->datein;
                            $dateout = $row2->dateout;
                            $type_id = $row2->category_id;
                        }
    
                        $time2 = date("Y-m-d H:i:s");
                        $status = 5;
                        $query2 = $this->db->query("SELECT id FROM  services_main WHERE reservation_id = " . $hms_reservation_id . " AND type = 2");
    
                        if ($query2->num_rows() > 0) {
                            $reservationpush[$k]["response"] = "failed";
                            $reservationpush[$k]["text"] = "есть уже отмена";
                            $reservationpush[$k]["status"] = "cancel";
    
                            $reservationpush[$k]["hms_reservation_id"] = $hms_reservation_id;
                            $reservationpush[$k]["dc_reservationid"] = $reservations[$i]["dc_reservationid"];
                            $k ++;
    
                            $dc_log_data = array();
                            $dc_log_data["datein"] = $datein;
                            $dc_log_data["dateout"] = $dateout;
                            $dc_log_data["category_id"] = $type_id;
                            $this->frontdesk->dc_log_update($dc_log_data);
                        } else {
                            $sql = "SELECT id FROM deskofreservation WHERE id = " . $hms_reservation_id;
                            echo $sql;
                            $query2 = $this->db->query($sql);
    
                            if ($query2->num_rows() > 0) {
                                $data_cancel = array();
    
                                $data_cancel["res_id"] = $hms_reservation_id;
                                $data_cancel["charge"] = 0;
                                $data_cancel["status"] = 5;
                                ;
                                $data_cancel["description"] = "cancel from echannel";
                                $data_cancel["guestbe_request"] = 0;
                                $data_cancel["user"] = - 1;
                                // ====================
                                $this->Cancel->Insert($data_cancel);
                                // ====================
                                $query2 = $this->db->query("UPDATE deskofreservation SET dc_updatetime = '" . $reservations[$i]["reservation"]["dc_updatetime"] . "' WHERE id = " . $hms_reservation_id);
                                $reservationpush[$k]["response"] = "ok";
                                $reservationpush[$k]["text"] = "";
                                $reservationpush[$k]["status"] = "cancel";
                                $reservationpush[$k]["hms_reservation_id"] = $hms_reservation_id;
                                $reservationpush[$k]["dc_reservationid"] = $reservations[$i]["dc_reservationid"];
                                $k ++;
                            } else {
                                // $confirm_fail = 0;
                                $reservationpush[$k]["response"] = "failed";
                                $reservationpush[$k]["text"] = "нет брони для отмены";
                                $reservationpush[$k]["status"] = "skip";
    
                                $reservationpush[$k]["hms_reservation_id"] = 0;
                                $reservationpush[$k]["dc_reservationid"] = $reservations[$i]["dc_reservationid"];
                                $k ++;
                            }
                        }
                    } else {
    
                        if ($hms_reservation_id == 0) {
                            /*
                             * NEW RESERVATION BLOCK
                             */
    
                            $room_id = 0;
    
                            if ($type_id == 0 or $type_id == "") {
                                $query2 = $this->db->query("SELECT int_value FROM  dc_nash_travel_xml_cfg WHERE name LIKE 'overbooking_category_id'");
                                if ($query->num_rows() > 0) {
                                    $row2 = $query2->row();
                                    $type_id = $row2->int_value;
                                }
                            }
                            if ($type_id == 0 or $type_id == "") {
                                // $confirm_fail = 1;
                                $reservationpush[$k]["response"] = "error";
                                $reservationpush[$k]["text"] = "UNKNOWN CATEGORY";
                                $reservationpush[$k]["status"] = "new";
                                $reservationpush[$k]["hms_reservation_id"] = $row->id;
                                $reservationpush[$k]["dc_reservationid"] = $reservations[$i]["dc_reservationid"];
                                $result_array["reservations"][$key][$i]["status"] = "new";
                                $result_array["reservations"][$key][$i]["reservation"]["reservation_alert"] = $reservationpush[$k]["text"];
                                $result_array["reservations"][$key][$i]["reservation"]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                $result_array["reservations"][$key][$i]["reservation"]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                $k ++;
                            } else {
                                $room_id = $this->frontdesk->getfreeroomlist($datein, $dateout, $type_id, 0, 0, $reservations[$i]["reservation"]["early_check_in_close"], $reservations[$i]["reservation"]["late_check_out_close"]);
                                if ($room_id == 0) {
    
                                    if (isset($overbooking_category_id)) {
                                        $reservations[$i]["reservation"]["origin_categoryid"] = $type_id;
                                        $room_id = $this->frontdesk->getfreeroomlist($datein, $dateout, $overbooking_category_id, 0, 0, $reservations[$i]["reservation"]["early_check_in_close"], $reservations[$i]["reservation"]["late_check_out_close"]);
    
                                        $insert_over_room_bool = 0;
                                        if ($room_id == 0) {
                                            $room_id = $this->dc_model->dc_make_overbooking_room($overbooking_category_id);
                                            $insert_over_room_bool = 1;
                                        }
                                    } else {
                                        // $confirm_fail = 1;
                                        $reservationpush[$k]["response"] = "failed";
                                        $reservationpush[$k]["text"] = "no overbooking_category_id";
                                        $reservationpush[$k]["status"] = "new";
                                        $reservationpush[$k]["hms_reservation_id"] = 0;
                                        $reservationpush[$k]["dc_reservationid"] = $reservations[$i]["dc_reservationid"];
                                        $reservationpush[$k]["dc_room_id"] = $reservations[$i]["reservation"]["category_id"];
                                        $result_array["reservations"][$key][$i]["status"] = "new";
                                        $result_array["reservations"][$key][$i]["reservation"]["reservation_alert"] = $reservationpush[$k]["text"];
                                        $result_array["reservations"][$key][$i]["reservation"]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                        $result_array["reservations"][$key][$i]["reservation"]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                    }
                                }
                                $reservations[$i]["reservation"]["room_id"] = $room_id;
    
                                if ($bool_guest == 0) {
                                    $guest_id = $this->frontdesk->Guest_insert($reservations[$i]["guest"]);
                                    $bool_guest = 1;
                                }
                                // print_r($reservations [$i] ["reservation"]);
                                // die();
                                $hms_reservation_id = $this->frontdesk->Reservation_insert($reservations[$i]["reservation"], $guest_id, 0, 1);
    
                                if (isset($otelms_rooms[$dc_reservationid][$reservations[$i]["reservation"]["dc_uuid"]])) {
                                    $otelms_rooms[$dc_reservationid][$reservations[$i]["reservation"]["dc_uuid"]]["status"] = 1;
                                }
    
                                if (isset($reservations[$i]["card"])) {
                                    $this->frontdesk->insert_tbl_CreditCards($reservations[$i]["card"], $guest_id, $hms_reservation_id);
                                }
    
                                if ($hms_reservation_id > 0) {
                                    /*
                                     * ==== ADD SERVICES ======
                                     */
                                    // $this->del_addons($reservations [$i] ["reservation"] ["dc_uuid"]);
                                    // $this->add_addons($reservations [$i] ["addons"], $hms_reservation_id, $services_types_dc);
                                    /*
                                     * =========================
                                     */
                                    $reservationpush[$k]["response"] = "ok";
                                    $reservationpush[$k]["text"] = "order_created";
                                    $reservationpush[$k]["status"] = "new";
                                    $reservationpush[$k]["hms_reservation_id"] = $hms_reservation_id;
                                    $reservationpush[$k]["dc_reservationid"] = $reservations[$i]["dc_reservationid"];
                                    $reservationpush[$k]["dc_room_id"] = $reservations[$i]["reservation"]["category_id"];
                                    $result_array["reservations"][$key][$i]["status"] = "new";
                                    $result_array["reservations"][$key][$i]["reservation"]["reservation_alert"] = $reservationpush[$k]["text"];
                                    $result_array["reservations"][$key][$i]["reservation"]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                    $result_array["reservations"][$key][$i]["reservation"]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                    $k ++;
                                } else {
                                    // $confirm_fail = 1;
                                    $reservationpush[$k]["response"] = "failed";
                                    $reservationpush[$k]["text"] = "undferror";
                                    $reservationpush[$k]["status"] = "new";
                                    $reservationpush[$k]["hms_reservation_id"] = 0;
                                    $reservationpush[$k]["dc_reservationid"] = $reservations[$i]["dc_reservationid"];
                                    $reservationpush[$k]["dc_room_id"] = $reservations[$i]["reservation"]["category_id"];
                                    $result_array["reservations"][$key][$i]["status"] = "new";
                                    $result_array["reservations"][$key][$i]["reservation"]["reservation_alert"] = $reservationpush[$k]["text"];
                                    $result_array["reservations"][$key][$i]["reservation"]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                    $result_array["reservations"][$key][$i]["reservation"]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                    $k ++;
                                }
                            }
                        } else {
                            /*
                             * UPDATE RESERVATION BLOCK
                             *
                             */
    
                            $reservation_data = $this->frontdesk->GetReservation($hms_reservation_id);
    
                            // $reservation_data ["user"] = $xml_array ["reservations"] [$dc_reservationid] ["room"] [$cell ["dc_roomreservation_id"]] ["reservation"] ["user"];
                            $reservation_data["firstname"] = $reservations[$i]["guest"]["firstname"];
                            $reservation_data["lastname"] = $reservations[$i]["guest"]["lastname"];
                            $reservation_data["phone"] = $reservations[$i]["guest"]["phone"];
                            $reservation_data["email"] = $reservations[$i]["guest"]["email"];
    
                            $reservation_data["amount"] = $reservations[$i]["reservation"]["amount"];
                            $reservation_data["discount"] = $reservations[$i]["reservation"]["discount"];
                            $reservation_data["date"] = $reservations[$i]["reservation"]["date"];
                            $reservation_data["add_places"] = $reservations[$i]["reservation"]["add_places"];
                            $reservation_data["baby_places"] = $reservations[$i]["reservation"]["baby_places"];
                            $reservation_data["datein"] = $reservations[$i]["reservation"]["datein"];
                            $reservation_data["dateout"] = $reservations[$i]["reservation"]["dateout"];
                            $reservation_data["checkintime"] = $reservations[$i]["reservation"]["checkintime"];
                            $reservation_data["checkouttime"] = $reservations[$i]["reservation"]["checkouttime"];
    
                            // $reservation_data ["type_id"] = $reservations [$i] ["reservation"] ["type_id"];
                            $reservation_data["price_type"] = $reservations[$i]["reservation"]["price_type"];
                            $reservation_data["guest_id_new"] = 0;
                            $reservation_data["free_places"] = 0;
                            $reservation_data["maid_description"] = "";
                            $reservation_data["isread"] = 0;
                            $reservation_data["dc_guestname"] = $reservations[$i]["reservation"]["dc_guestname"];
                            $reservation_data["dc_currencycode"] = $reservations[$i]["reservation"]["dc_currencycode"];
                            $reservation_data["dc_countrycode"] = $reservations[$i]["reservation"]["dc_countrycode"];
                            $reservation_data["dc_city"] = $reservations[$i]["reservation"]["dc_city"];
                            $reservation_data["dc_customerremarks"] = $reservations[$i]["reservation"]["dc_customerremarks"];
                            $reservation_data["dc_roomremarks"] = $reservations[$i]["reservation"]["dc_roomremarks"];
                            $reservation_data["dc_numberofguest"] = $reservations[$i]["reservation"]["dc_numberofguest"];
                            $reservation_data["dc_totalprice"] = $reservations[$i]["reservation"]["dc_totalprice"];
                            $reservation_data["smoking"] = $reservations[$i]["reservation"]["smoking"];
    
                            $reservation_data["description"] = $reservations[$i]["reservation"]["dc_customerremarks"];
    
                            $reservation_data["dc_date"] = $reservations[$i]["reservation"]["dc_date"];
                            $reservation_data["dc_time"] = $reservations[$i]["reservation"]["dc_time"];
                            $reservation_data["dc_updatetime"] = $reservations[$i]["reservation"]["dc_updatetime"];
    
                            $reservation_data["early_check_in_close"] = $reservations[$i]["reservation"]["early_check_in_close"];
                            $reservation_data["late_check_out_close"] = $reservations[$i]["reservation"]["late_check_out_close"];
    
                            // =============================================================================
                            if ($autoclosedaychicho == 1) {
                                $str_checkintime = strtotime($reservations[$i]["reservation"]["checkintime"]);
                                $str_checkouttime = strtotime($reservations[$i]["reservation"]["checkouttime"]);
    
                                $system_checkouttime = strtotime($checkin_checkout_arr["checkouttime"]);
                                $system_checkintime = strtotime($checkin_checkout_arr["checkintime"]);
    
                                if ($str_checkintime < $system_checkouttime) {
                                    $reservation_data["early_check_in_close"] = 1;
                                }
                                if ($str_checkouttime > $system_checkouttime) {
                                    $reservation_data["late_check_out_close"] = 1;
                                }
                            }
                            // =============================================================================
                            // print_r($reservation_data);
    
                            if ($reservation_data["type_id"] == $type_id) {
                                $can_resize = $this->frontdesk->qd_canresize($hms_reservation_id, $datein, $dateout, $reservation_data["early_check_in_close"], $reservation_data["late_check_out_close"]);
                            } else {
                                $can_resize = 0;
                                $reservation_data["type_id"] = $type_id;
                            }
    
                            // $can_resize = $this->frontdesk->qd_canresize($hms_reservation_id, $datein, $dateout );
    
                            if ($can_resize == 1) {
    
                                $this->service_model->DeleteServicesDc($hms_reservation_id);
                                $update_res = $this->frontdesk->UpdateReservation($reservation_data, 0, 1);
    
                                if (isset($otelms_rooms[$dc_reservationid][$reservations[$i]["reservation"]["dc_uuid"]])) {
                                    $otelms_rooms[$dc_reservationid][$reservations[$i]["reservation"]["dc_uuid"]]["status"] = 1;
                                }
                                if ($update_res == "FreeError") {
                                    // $confirm_fail = 1;
                                    $reservationpush[$k]["response"] = "error";
                                    $reservationpush[$k]["text"] = "";
                                    $reservationpush[$k]["status"] = "modified";
                                    $reservationpush[$k]["hms_reservation_id"] = $hms_reservation_id;
                                    $result_array["reservations"][$key][$i]["reservation"]["reservation_alert"] = "";
                                    $result_array["reservations"][$key][$i]["status"] = "modified";
                                    $result_array["reservations"][$key][$i]["reservation"]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                    $result_array["reservations"][$key][$i]["reservation"]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                    $reservationpush[$k]["dc_reservationid"] = $reservations[$i]["reservation"]["dc_reservationid"];
                                    $k ++;
                                } else {
                                    /*
                                     * ==== ADD SERVICES ======
                                     */
                                    // $this->del_addons($dc_roomreservation_id);
                                    // $this->add_addons($reservations [$i] ["addons"], $hms_reservation_id, $services_types_dc);
                                    /*
                                     * =========================
                                     */
                                    $reservationpush[$k]["response"] = "ok";
                                    $reservationpush[$k]["text"] = "";
                                    $reservationpush[$k]["alert"] = "";
                                    $reservationpush[$k]["status"] = "modified";
                                    $reservationpush[$k]["hms_reservation_id"] = $hms_reservation_id;
                                    $result_array["reservations"][$key][$i]["reservation"]["reservation_alert"] = "";
                                    $result_array["reservations"][$key][$i]["status"] = "modified";
                                    $result_array["reservations"][$key][$i]["reservation"]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                    $result_array["reservations"][$key][$i]["reservation"]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                    $reservationpush[$k]["dc_reservationid"] = $reservations[$i]["reservation"]["dc_reservationid"];
                                    $k ++;
                                }
                            } else {
                                if ($type_id == 0 or $type_id == "") {
                                    $query2 = $this->db->query("SELECT int_value FROM  dc_nash_travel_xml_cfg WHERE name LIKE 'overbooking_category_id'");
                                    if ($query->num_rows() > 0) {
                                        $row2 = $query2->row();
                                        $type_id = $row2->int_value;
                                    }
                                }
                                if ($type_id == 0 or $type_id == "") {
                                    // $confirm_fail = 1;
                                    $reservationpush[$k]["response"] = "error";
                                    $reservationpush[$k]["text"] = "UNKNOWN CATEGORY";
                                    $reservationpush[$k]["status"] = "modified";
                                    $reservationpush[$k]["hms_reservation_id"] = $row->id;
                                    $reservationpush[$k]["dc_reservationid"] = $reservations[$i]["dc_reservationid"];
                                    $result_array["reservations"][$key][$i]["status"] = "modified";
                                    $result_array["reservations"][$key][$i]["reservation"]["reservation_alert"] = $reservationpush[$k]["text"];
                                    $result_array["reservations"][$key][$i]["reservation"]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                    $result_array["reservations"][$key][$i]["reservation"]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                    $k ++;
                                } else {
                                    $room_id = $this->frontdesk->getfreeroomlist($datein, $dateout, $type_id, 0, 0, $reservation_data["early_check_in_close"], $reservation_data["late_check_out_close"]);
                                    if ($room_id == 0) {
    
                                        if (isset($overbooking_category_id)) {
                                            $reservations[$i]["reservation"]["origin_categoryid"] = $type_id;
                                            $room_id = $this->frontdesk->getfreeroomlist($datein, $dateout, $overbooking_category_id, 0, 0, $reservation_data["early_check_in_close"], $reservation_data["late_check_out_close"]);
    
                                            $insert_over_room_bool = 0;
                                            if ($room_id == 0) {
                                                $room_id = $this->dc_model->dc_make_overbooking_room($overbooking_category_id);
                                                $insert_over_room_bool = 1;
                                            }
                                        } else {
                                            // $confirm_fail = 1;
                                            $reservationpush[$k]["response"] = "failed";
                                            $reservationpush[$k]["text"] = "no overbooking_category_id";
                                            $reservationpush[$k]["status"] = "new";
                                            $reservationpush[$k]["hms_reservation_id"] = 0;
                                            $reservationpush[$k]["dc_reservationid"] = $reservations[$i]["dc_reservationid"];
                                            $reservationpush[$k]["dc_room_id"] = $reservations[$i]["reservation"]["category_id"];
                                            $result_array["reservations"][$key][$i]["status"] = "new";
                                            $result_array["reservations"][$key][$i]["reservation"]["reservation_alert"] = $reservationpush[$k]["text"];
                                            $result_array["reservations"][$key][$i]["reservation"]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                            $result_array["reservations"][$key][$i]["reservation"]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                        }
                                    }
                                    $reservation_data["room_id"] = $room_id;
    
                                    $this->service_model->DeleteServicesDc($hms_reservation_id);
                                    $update_res = $this->frontdesk->UpdateReservation($reservation_data, 0, 1);
    
                                    if (isset($otelms_rooms[$dc_reservationid][$reservations[$i]["reservation"]["dc_uuid"]])) {
                                        $otelms_rooms[$dc_reservationid][$reservations[$i]["reservation"]["dc_uuid"]]["status"] = 1;
                                    }
    
                                    if ($update_res == "FreeError") {
                                        // $confirm_fail = 1;
                                        $reservationpush[$k]["response"] = "error";
                                        $reservationpush[$k]["text"] = "";
                                        $reservationpush[$k]["status"] = "modified";
                                        $reservationpush[$k]["hms_reservation_id"] = $hms_reservation_id;
                                        $result_array["reservations"][$key][$i]["status"] = "modified";
                                        $result_array["reservations"][$key][$i]["reservation"]["reservation_alert"] = "";
                                        $result_array["reservations"][$key][$i]["reservation"]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                        $result_array["reservations"][$key][$i]["reservation"]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                        $reservationpush[$k]["dc_reservationid"] = $reservations[$i]["reservation"]["dc_reservationid"];
                                        $k ++;
                                    } else {
                                        $reservationpush[$k]["response"] = "ok";
                                        $reservationpush[$k]["text"] = "";
                                        $reservationpush[$k]["alert"] = "";
                                        $reservationpush[$k]["status"] = "modified";
                                        $reservationpush[$k]["hms_reservation_id"] = $hms_reservation_id;
                                        $result_array["reservations"][$key][$i]["status"] = "modified";
                                        $result_array["reservations"][$key][$i]["reservation"]["reservation_alert"] = "";
                                        $result_array["reservations"][$key][$i]["reservation"]["hms_reservation_id"] = $reservationpush[$k]["hms_reservation_id"];
                                        $result_array["reservations"][$key][$i]["reservation"]["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush[$k]["hms_reservation_id"];
                                        $reservationpush[$k]["dc_reservationid"] = $reservations[$i]["reservation"]["dc_reservationid"];
                                        $k ++;
                                    }
                                }
                            }
                        }
                    }
                }
    
                if (isset($otelms_rooms[$dc_reservationid])) {
                    foreach ($otelms_rooms[$dc_reservationid] as $cell) {
                        if ($cell["status"] == 0) {
                            $status = 5;
                            $data_cancel = array();
                            $data_cancel["res_id"] = $cell["otelms_reservation_id"];
                            $data_cancel["charge"] = 0;
                            $data_cancel["status"] = $status;
                            $data_cancel["description"] = "cancel from echannel";
                            $data_cancel["guestbe_request"] = 0;
                            $data_cancel["user"] = - 1;
                            // ====================
                            $this->Cancel->Insert($data_cancel);
                        }
                    }
                }
            }
    
    
            $hotel_name = "";
            $query = $this->db->query("SELECT * FROM logo");
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $hotel_name = stripslashes($row->logo_title);
            }
    
            $counter_r = 0;
            $new_mass = array();
            foreach ($result_array["reservations"] as $cell) {
                $res_count = count($cell);
                for ($i = 0; $i < $res_count; $i ++) {
                    if ($cell[$i]["status"] == "modified" or $cell[$i]["status"] == "new") {
                        $new_mass['dcname'] = "Echannel";
                        $new_mass['status'] = $cell[$i]["status"];
                        $new_mass['dc_reservationid'] = $cell[$i]["reservation"]["dc_reservationid"];
                        $new_mass['dc_channel_name'] = "Echannel";
                        $new_mass['hotel_name'] = $hotel_name;
                        $new_mass['guest_firstname'] = $cell[$i]["guest"]["firstname"];
                        $new_mass['guest_lastname'] = $cell[$i]["guest"]["lastname"];
                        $new_mass['guest_phone'] = $cell[$i]["guest"]["phone"];
                        $new_mass['guest_email'] = $cell[$i]["guest"]["email"];
    
                        $new_mass["room"][$counter_r]["reservation_current"] = $i;
                        $new_mass["room"][$counter_r]["reservation_alert"] = $cell[$i]["reservation"]["reservation_alert"];
                        $new_mass["room"][$counter_r]["hms_reservation_id"] = $cell[$i]["reservation"]["hms_reservation_id"];
                        $new_mass["room"][$counter_r]["url"] = $cell[$i]["reservation"]["url"];
                        $new_mass["room"][$counter_r]["dc_channel_name"] = "Echannel";
    
                        $new_mass["room"][$counter_r]["reservation_dc_reservationid"] = $cell[$i]["reservation"]["dc_reservationid"];
                        $new_mass["room"][$counter_r]["reservation_dc_roomreservation_id"] = $cell[$i]["reservation"]["dc_roomreservation_id"];
                        $new_mass["room"][$counter_r]["hotel_name"] = "hotel_name";
                        $new_mass["room"][$counter_r]["reservation_date"] = $cell[$i]["reservation"]["date"];
                        $new_mass["room"][$counter_r]["status"] = $cell[$i]["status"];
                        $new_mass["room"][$counter_r]["reservation_datein"] = $cell[$i]["reservation"]["datein"];
                        $new_mass["room"][$counter_r]["reservation_dateout"] = $cell[$i]["reservation"]["dateout"];
                        $new_mass["room"][$counter_r]["reservation_type_name"] = $cell[$i]["reservation"]["reservation_type_name"];
                        $new_mass["room"][$counter_r]["reservation_category_id"] = $cell[$i]["reservation"]["type_id"];
                        $new_mass["room"][$counter_r]["reservation_dc_totalprice"] = $cell[$i]["reservation"]["dc_totalprice"];
                        $new_mass["room"][$counter_r]["reservation_dc_customerremarks"] = $cell[$i]["reservation"]["dc_customerremarks"];
    
                        $new_mass["room"][$counter_r]["dc_rate_intdate_data"] = $cell[$i]["per_day"];
                        $max_key = max(array_keys($new_mass["room"][$counter_r]["dc_rate_intdate_data"]));
                        $intdate_temp = $max_key;
    
                        $counter_r ++;
                    }
                }
            }
            if (count($new_mass) > 0) {
                $this->dc_model->send_notifyarray_new($new_mass, $debug);
            }
        }
    
        if($debug){
            echo "<pre>";
            echo "\n\n --- XML reservationpush START --- \n\n";
            print_r($reservationpush);
            echo "\n\n --- XML reservationpush END --- \n\n";
        }
        foreach ($reservationpush as $arg) {
            if ($arg['status'] == "cancel") {
                $data = array();
                $data["hms_reservation_id"] = $arg["hms_reservation_id"];
                $data['response'] = $arg['response'];
                $data['resid'] = $arg['dc_reservationid'];
                $data['dcname'] = "Echannel";
                $data['status'] = $arg['status'];
                $data['text'] = $arg['text'];
                $this->dc_model->send_notifyarray($data);
            }
        }
        echo json_encode($reservationpush, true);
    }
    
    function get_reservation_status()
    {
        $postdata = file_get_contents("php://input");
        $postdata = json_decode($postdata, true);
        $hms_id = $postdata['hms_id'];
        $dc_uuid = $postdata['id'];
        $status = $this->db->select('status')
            ->get_where('deskofreservation', array(
            'dc_uuid' => $dc_uuid
        ))
            ->row()->status;
            
        switch ($status) {
            case 1:
                $status_name = "book";
                break;
            case 2:
                $status_name = "checkin";
                break;
            case 3:
                $status_name = "checkout";
                break;
            case 4:
                $status_name = "Quota";
                break;
            case 5:
                $status_name = "canceled";
                break;
            case 6:
                $status_name = "NotCheckin";
                break;
            case 7:
                $status_name = "repair";
                break;
        }
        echo json_encode(array('status' => $status_name));
    }
    
    
    function get_reservations_test(){
        // 1. Отримати список баз з маскою hotelix_%
        $query = $this->db->query("
    SELECT SCHEMA_NAME
    FROM information_schema.SCHEMATA
    WHERE SCHEMA_NAME LIKE 'hotelix\_%'
");
        
        $dbs = array_column($query->result_array(), 'SCHEMA_NAME');
        
        if (empty($dbs)) {
            die("Не знайдено баз з маскою hotelix_%");
        }
        
        // 2. Випадково вибрати одну базу
        $db_name = $dbs[array_rand($dbs)];
        
        //echo $db_name;
        
        //echo "<pre>";
        
       
        // 3. Побудова конфігурації та підключення
        
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database ( $config, true );
        
        $reservations = $this->db->select('id as hms_booking_id, dc_uuid as id, datein as date_in, dateout as date_out, status as status_id')
        ->get_where('deskofreservation', array(), 1000) 
        ->result_array();
        foreach ($reservations as &$cell) {
            $cell['hms_booking_id'] = (int) $cell['hms_booking_id'];
            switch ($cell['status_id']) {
                case 1:
                    $cell['status'] = "book";
                    break;
                case 2:
                    $cell['status'] = "checkin";
                    break;
                case 3:
                    $cell['status'] = "checkout";
                    break;
                case 4:
                    $cell['status'] = "Quota";
                    break;
                case 5:
                    $cell['status'] = "canceled";
                    break;
                case 6:
                    $cell['status'] = "no_show";
                    break;
                case 7:
                    $cell['status'] = "repair";
                    break;
            }
            unset($cell['status_id']);
        }
        //echo json_encode($reservations);
        
        echo "comardgoba"; 
    }
    
    function get_reservations(){
        
        $postdata = file_get_contents("php://input");
        $postdata = json_decode($postdata, true);
        $hms_id = $postdata['hms_id'];
        $dc_id = $postdata['dc_id'];
        
        $reservations = $this->db->select('id as hms_booking_id, dc_uuid as id, datein as date_in, dateout as date_out, status as status_id')
            ->get_where('deskofreservation', array(
            'dc_id' => $dc_id
        ))
            ->result_array();
        foreach ($reservations as &$cell) {
            $cell['hms_booking_id'] = (int) $cell['hms_booking_id'];
            switch ($cell['status_id']) {
                case 1:
                    $cell['status'] = "book";
                    break;
                case 2:
                    $cell['status'] = "checkin";
                    break;
                case 3:
                    $cell['status'] = "checkout";
                    break;
                case 4:
                    $cell['status'] = "Quota";
                    break;
                case 5:
                    $cell['status'] = "canceled";
                    break;
                case 6:
                    $cell['status'] = "no_show";
                    break;
                case 7:
                    $cell['status'] = "repair";
                    break;
            }
            unset($cell['status_id']);
        }
        echo json_encode($reservations);
    }
    
    function get_reservation_info(){
        $postdata = file_get_contents("php://input");
        $postdata = json_decode($postdata, true);
        $hms_id = $postdata['hms_id'];
        $dc_id = $postdata['dc_id'];
        $dc_uuid = $postdata['id'];
        
        $return_data = array();
        
        $sql = "SELECT deskofreservation.id, deskofreservation.datein, deskofreservation.dateout, 
        deskofreservation.status, deskofreservation.amount, rooms.category_id as category_id, 
		guests.firstname, guests.lastname, guests.middlename, guests.phone, guests.email, 
		rooms.name as room_name, categories.name as category_name, rate.caption as rate_name,
		deskofreservation.date
		FROM deskofreservation
		INNER JOIN guests ON deskofreservation.guest_id = guests.id
		INNER JOIN rooms ON deskofreservation.room_id = rooms.id
		INNER JOIN categories ON categories.id = rooms.category_id
		INNER JOIN rate ON deskofreservation.price_type = rate.id
		WHERE deskofreservation.dc_uuid LIKE '$dc_uuid' AND deskofreservation.dc_id = $dc_id";
        // echo $sql."<br>";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0)
        {
            $row = $query->row();
            switch ($row->status) {
                case 1:
                    $status = "book";
                    break;
                case 2:
                    $status = "checkin";
                    break;
                case 3:
                    $status = "checkout";
                    break;
                case 4:
                    $status = "Quota";
                    break;
                case 5:
                    $status = "canceled";
                    break;
                case 6:
                    $status = "NotCheckin";
                    break;
                case 7:
                    $status = "repair";
                    break;
            }
            $return_data['hms_book_id'] = $row->id;
            $return_data['lastname'] = $row->lastname;
            $return_data['firstname'] = $row->firstname;
            $return_data['phone'] = $row->phone;
            $return_data['email'] = $row->email;
            $return_data['created'] = $row->date;
            $return_data['datein'] = $row->datein;
            $return_data['dateout'] = $row->dateout;
            $return_data['status'] = $status;
            $return_data['room_type'] = $row->category_name;
            $return_data['rate_type'] = $row->rate_name;
            $return_data['price'] = $row->amount;
            
            $return_data['guest_data'] = $this->frontdesk_c2->get_guests($row->id);
            
           
        }
        echo json_encode($return_data);
    }
    
    function reservation_cancel()
    {
        $postdata = file_get_contents("php://input");
        $postdata = json_decode($postdata, true);
        $hms_id = $postdata['hms_id'];
        $dc_id = $postdata['dc_id'];
        $dc_uuid = $postdata['id'];

        $c2 = 3; // skip die
        $sql = "SELECT id FROM deskofreservation
		WHERE dc_id = $dc_id AND dc_uuid LIKE '$dc_uuid'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $cancel_data = array();
                $cancel_data['res_id'] = $row->id;
                $cancel_data['charge'] = 0;
                $cancel_data['status'] = 5;
                $cancel_data['description'] = "";
                $this->cancel->Insert($cancel_data, true, $c2);
            }
            echo json_encode(array('cancel_status' => 1));
        } else {
            echo json_encode(array(
                'cancel_status' => 0,
                'error_message' => "no reservation to cancel"
            ));
        }
    }
	
	function get_rates_info(){
	    $postdata = file_get_contents("php://input");
	    $data = json_decode($postdata, true);
	    $hms_id = $data['hms_id'];
	    $json_data = array();
	    $sql = "SELECT rates_details.dc_rate_id as rate_id, rates_details.name as rate_name
	    FROM global_hotelix_echannel.rates_details 
	    WHERE rates_details.hms_hotel_id = $hms_id";
	    //echo $sql;
	    $query = $this->db->query ( $sql );
	    foreach ( $query->result () as $row ) {
	        $json_data['rates'][$row->rate_id]['rate_id'] = $row->rate_id;
	        $json_data['rates'][$row->rate_id]['rate_name'] = $row->rate_name;
	    }
	    $output = json_encode ( $json_data );
	     
	    echo $output;
	}
	
	function get_properties_data(){
	    $postdata = file_get_contents("php://input");
	    $data = json_decode($postdata, true);
	    $hms_id = $data['hms_id'];
	    
	    $json_data = array();
	    if(isset($data['secret'])){
	        if($data['secret'] == md5("oms_$hms_id")){
	            $json_data['property_data'] = $this->property_model->get_property_data_echannel();
	             
	            foreach($json_data['property_data'] as &$cell){
	                $without_foto_src = 1; // без повернення тега src
	                $property_fotos = $this->property_model->get_property_fotos_echannel($cell['property_id'], $without_foto_src);
	                $cell['property_fotos'] = $property_fotos;
	            }
	        }else{
	           $json_data ['response'] = 'auth_fail';
	        }
	    }else{
	        $json_data ['response'] = 'auth_fail';
	    }

	    $output = json_encode ( $json_data );
	
	    echo $output;
	}
	
	function get_booking_availability() {
		$postdata = file_get_contents("php://input");
		$request = json_decode($postdata, true);
		$hmsid = 92;
		//echo "Start OK!<pre>";
		//print_r($request);
		$party = json_decode($request["party"], true);
		$hotel = json_decode($request["hotel"], true);
		//print_r($party);
		//print_r($hotels);
		//die();
		list ( $year, $month, $day ) = explode ( "-", $request["start_date"] );
		$intdate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		list ( $year, $month, $day ) = explode ( "-", $request["end_date"] );
		$outdate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		$categories = array ();
		$rates = array ();
		$duration = $outdate - $intdate;
		/*
		 * =========== GET CATEGORIES =================
		 * 
		 */
		$sql = "
		SELECT global_hotelix_echannel.rates.category_id, global_hotelix_echannel.rates.rate_id, global_hotelix_echannel.rates.occupancy_id, global_hotelix_echannel.rates.intdate,
		count(global_hotelix_echannel.rates.intdate) as count_intdate, SUM(global_hotelix_echannel.rates.price) as amount
		FROM  global_hotelix_echannel.rates
		WHERE global_hotelix_echannel.rates.occupancy_id = 2 AND global_hotelix_echannel.rates.intdate >= " . $intdate . " AND global_hotelix_echannel.rates.intdate < " . $outdate . " GROUP BY global_hotelix_echannel.rates.category_id, global_hotelix_echannel.rates.rate_id, global_hotelix_echannel.rates.occupancy_id";
		// echo $sql;
		$query = $this->db->query ( $sql );
		foreach ( $query->result () as $row ) {
	
			//if ($duration == $row->count_intdate) {
			$date = gmdate ( "Y-m-d", $row->intdate * 86400 );
			if (! isset ( $categories ["categories"] [$hmsid."-".$row->category_id] ["bar"] )) {
					
				if ($row->amount > 0) {
					$categories ["categories"] [$hmsid."-".$row->category_id] ["bar"] ["rate_id"] = $row->rate_id;
					$categories ["categories"] [$hmsid."-".$row->category_id] ["bar"] ["amount"] = $row->amount;
				}
			}
				
			if ($row->rate_id != 0) {
				$rates [$hmsid."-".$row->rate_id]["name"] = $hmsid."-".$row->rate_id;
				$rates [$hmsid."-".$row->rate_id]["code"] = $hmsid."-".$row->rate_id;
				// $data ["categories"] [$row->category_id] ["rates"] [$row->rate_id] ["baseplace"] = 1;
				$categories ["categories"] [$hmsid."-".$row->category_id] ["rates"] [$row->rate_id] ["amount"] = $row->amount;
				if ($row->amount > 0) {
					if ($categories ["categories"] [$hmsid."-".$row->category_id] ["bar"] ["amount"] > $row->amount) {
						$categories ["categories"] [$hmsid."-".$row->category_id] ["bar"] ["rate_id"] = $row->rate_id;
						$categories ["categories"] [$hmsid."-".$row->category_id] ["bar"] ["amount"] = $row->amount;
					}
				}
			} else {
				$categories ["categories"] [$hmsid."-".$row->category_id] ["count"] = $row->mincount;
				$categories ["categories"] [$hmsid."-".$row->category_id] ["name"] = $row->category_id;
				$categories ["categories"] [$hmsid."-".$row->category_id] ["places"] = 0;
			}
			//}
		}
		//echo "<pre>";
		//print_r($categories);
		//print_r($rates);
	
		$json_data = array();
	
		$json_data["api_version"] = (int)$request["api_version"];
		$json_data["hotel_id"] = (int)$hotel["ta_id"];
		$json_data["start_date"] = $request["start_date"];
		$json_data["end_date"] = $request["end_date"];
		$json_data["party"][0]["adults"] = $party[0]["adults"];
		$json_data["lang"] = $request["lang"];
		$json_data["query_key"] = $request["query_key"];
		$json_data["user_country"] = $request["user_country"];
		$json_data["device_type"] = $request["device_type"];

		/*
		 * ================ hotel_room_types ============================================================
		*
		*/
		
		if (isset ( $categories ["categories"] )) {
			foreach ( $categories ["categories"] as $category_id => $cell ) {
				$json_data ["hotel_room_types"] [$category_id] ["code"] = "";
				$json_data ["hotel_room_types"] [$category_id] ["name"] = "";
				$json_data ["hotel_room_types"] [$category_id] ["description"] = "";
				
				$json_data ["hotel_room_types"] [$category_id] ["photos"] = array();
				$json_data ["hotel_room_types"] [$category_id] ["photos"][0]["url"] = "";
				$json_data ["hotel_room_types"] [$category_id] ["photos"][0]["width"] = "";
				$json_data ["hotel_room_types"] [$category_id] ["photos"][0]["height"] = "";
				$json_data ["hotel_room_types"] [$category_id] ["photos"][0]["caption"] = "";
				
				$json_data ["hotel_room_types"] [$category_id] ["room_amenities"] = array();
				$json_data ["hotel_room_types"] [$category_id] ["room_amenities"]["standard"][0] = 20;
				$json_data ["hotel_room_types"] [$category_id] ["room_amenities"]["standard"][1] = 900118;
				$json_data ["hotel_room_types"] [$category_id] ["room_amenities"]["custom"][0] = "My custom chair";
				$json_data ["hotel_room_types"] [$category_id] ["room_amenities"]["custom"][1] = "Wolf appliances";

				
				$json_data ["hotel_room_types"] [$category_id] ["room_size_value"] = 500;
				$json_data ["hotel_room_types"] [$category_id] ["room_size_units"] = "square_feet";
				
				$json_data ["hotel_room_types"] [$category_id] ["bed_configurations"] = array();
				$json_data ["hotel_room_types"] [$category_id] ["bed_configurations"][0]["type"] = "standard";
				$json_data ["hotel_room_types"] [$category_id] ["bed_configurations"][0]["code"] = 3;
				$json_data ["hotel_room_types"] [$category_id] ["bed_configurations"][0]["count"] = 1;
				
				$json_data ["hotel_room_types"] [$category_id] ["room_view_type"] = array();
				$json_data ["hotel_room_types"] [$category_id] ["room_view_type"]["standard"][0] = 10;
				$json_data ["hotel_room_types"] [$category_id] ["room_view_type"]["custom"][0] = "Northern Lights";
				
				$json_data ["hotel_room_types"] [$category_id] ["accessibility_features"] = array();
				$json_data ["hotel_room_types"] [$category_id] ["accessibility_features"]["standard"][0] = 900501;
				$json_data ["hotel_room_types"] [$category_id] ["accessibility_features"]["standard"][1] = 900505;
				$json_data ["hotel_room_types"] [$category_id] ["accessibility_features"]["custom"][0]  = array();
				
				$json_data ["hotel_room_types"] [$category_id] ["max_occupancy"]["number_of_adults"] = 2;
				$json_data ["hotel_room_types"] [$category_id] ["max_occupancy"]["number_of_children"] = 0;	
			}
		}
	
		/*
		 * ================ hotel_rate_plans ============================================================
		*
		*/
		foreach ( $rates as $rate_id => $cell ) {
			$json_data ["hotel_rate_plans"] [$rate_id] ["name"] = $cell["name"];
			$json_data ["hotel_rate_plans"] [$rate_id] ["code"] = $cell["code"];
			$json_data ["hotel_rate_plans"] [$rate_id] ["description"] = "";
			$json_data ["hotel_rate_plans"] [$rate_id] ["photos"][0]["url"] = "";
			$json_data ["hotel_rate_plans"] [$rate_id] ["photos"][0]["width"] = "";
			$json_data ["hotel_rate_plans"] [$rate_id] ["photos"][0]["height"] = "";
			$json_data ["hotel_rate_plans"] [$rate_id] ["photos"][0]["caption"] = "";
			
			$json_data ["hotel_rate_plans"] [$rate_id] ["rate_amenities"]["standard"] = 75;
			$json_data ["hotel_rate_plans"] [$rate_id] ["rate_amenities"]["custom"][0] = "Complimentary jetskis";
			$json_data ["hotel_rate_plans"] [$rate_id] ["rate_amenities"]["custom"][1] = "Kayak rentals";
			$json_data ["hotel_rate_plans"] [$rate_id] ["refundable"] = "partial";
			$json_data ["hotel_rate_plans"] [$rate_id] ["cancellation_rules"]["deadline"] = "2016-03-17T16:00:00";
			$json_data ["hotel_rate_plans"] [$rate_id] ["cancellation_rules"]["penalty_exists"] = true;
			$json_data ["hotel_rate_plans"] [$rate_id] ["cancellation_rules"]["policy_info"] = "Partially refundable rate";
			
			$json_data ["hotel_rate_plans"] [$rate_id] ["cancellation_rules"]["fees"][0]["currency"] = "USD";
			$json_data ["hotel_rate_plans"] [$rate_id] ["cancellation_rules"]["fees"][0]["amount_type"] = "numNights";
			$json_data ["hotel_rate_plans"] [$rate_id] ["cancellation_rules"]["fees"][0]["amount"] = 2;
			$json_data ["hotel_rate_plans"] [$rate_id] ["cancellation_rules"]["fees"][0]["tax_inclusive"] = true;
			$json_data ["hotel_rate_plans"] [$rate_id] ["cancellation_rules"]["fees"][0]["days_before_arrival"] = 2;
			
			$json_data ["hotel_rate_plans"] [$rate_id] ["cancellation_rules"]["fees"][1]["currency"] = "USD";
			$json_data ["hotel_rate_plans"] [$rate_id] ["cancellation_rules"]["fees"][1]["amount_type"] = "fixed";
			$json_data ["hotel_rate_plans"] [$rate_id] ["cancellation_rules"]["fees"][1]["amount"] = 50;
			$json_data ["hotel_rate_plans"] [$rate_id] ["cancellation_rules"]["fees"][1]["tax_inclusive"] = true;
			$json_data ["hotel_rate_plans"] [$rate_id] ["cancellation_rules"]["fees"][1]["days_before_arrival"] = 4;
			
			$json_data ["hotel_rate_plans"] [$rate_id] ["meal_plan"]["standard"] = 22;
			$json_data ["hotel_rate_plans"] [$rate_id] ["meal_plan"]["custom"][0] = "Brunch on weekend mornings";
			$json_data ["hotel_rate_plans"] [$rate_id] ["discount_type"]["standard"] = 5;
			$json_data ["hotel_rate_plans"] [$rate_id] ["discount_type"]["custom"] = array();
		}
	
		$output = json_encode ( $json_data );
	
		echo $output;
	}
}
?>