<?php
if (! defined('BASEPATH'))
    exit('No direct script access allowed');
    
    class dc_airbnb_gate extends CI_Controller
    {
        
        function __construct()
        {
            parent::__construct();
            $this->load->model('Curl_model');
            $this->load->model('dcm_airbnb');
            $this->load->model('frontdesk');
            $this->load->model('frontdesk_c2');
            $this->load->model('dc_model');
            $this->load->model ( 'Access' );
        }
        
        //     function check_categories() {
        //         $hms_id = $this->config->item('hotel_id');
        
        //         $global_language = $this->hotelix_config->get_record("global_language", "int");
        
        //         $array_info = array();
        //         $sql = "SELECT property_information.id as property_id, categories.id as category_id,
        //         property_information.street, property_information.gps_coordinates, property_information.city,
        //         property_information.additional_information, property_information.post_code,
        //         property_information.state, property_information.country, property_information.property_name,
        //         property_information.reception_phone, property_information.email
        //         FROM property_information
        //         INNER JOIN categories ON property_information.id = categories.property_id
        //         INNER JOIN rooms ON rooms.category_id = categories.id
        //         WHERE categories.is_active = 1 AND property_information.country <> '' AND property_information.city <> ''";
        //         $query = $this->db->query ( $sql );
        //         if ($query->num_rows () > 0) {
        //             foreach ( $query->result () as $row ) {
        //                 $category_name_arr = $this->internationalfields->get_value("category", $row->category_id, "international_name", $global_language);
        
        //                 $category_name = isset($category_name_arr[$global_language]) ? $category_name_arr[$global_language] : "";
        
        //                 array_push($array_info, array(
        //                     "hms_id" => $hms_id,
        //                     "category" => $category_name,
        //                     "property" => $row->property_name,
        //                     "address" => $row->additional_information,
        //                     "state" => $row->state,
        //                     "city" => $row->city,
        //                     "zip" => $row->post_code,
        //                     "country" => $row->country,
        //                     "phone" => $row->reception_phone,
        //                     "email" => $row->email,
        //                     "gps" => $row->gps_coordinates
        //                 ));
        //             }
        //         }
        
        //         echo json_encode($array_info);
        //     }
        
        
        function get_reservation() {
            $postdata = file_get_contents("php://input");
            
            $url = "dc_airbnb_gate/get_reservation/";
            $data = array(
                'request' => $postdata,
                'url' => $url
            );
            
            $this->db->insert('dc_airbnb_log', $data);
            $dc_log_id = $this->db->insert_id();
            
            $reservation_result = $this->dcm_airbnb->get_bookings ($postdata);
            
            $data = array(
                'response' => $reservation_result,
                'responseint' => 0,
                'stime' => 0
            );
            
            $this->db->update('dc_airbnb_log', $data, array(
                'id' => $dc_log_id
            ));
            
            $this->Loger_admin->Save_SyncData("", "", $reservation_result, 22, 10, $dc_log_id);
        }
        
        function get_reservation_2db($db_name = '') {
            $postdata = file_get_contents("php://input");
            
            $config = array ();
            $config ['hostname'] = $this->config->item ( 'visitka_host' );
            $config ['username'] = $this->config->item ( 'visitka_user' );
            $config ['password'] = $this->config->item ( 'visitka_pass' );
            $config ['database'] = $db_name;
            $config ['dbdriver'] = "mysqli";
            $config ['dbprefix'] = "";
            $config ['pconnect'] = FALSE;
            $config ['db_debug'] = TRUE;
            $config ['cache_on'] = FALSE;
            $config ['cachedir'] = "";
            $config ['char_set'] = "utf8";
            $config ['dbcollat'] = "utf8_general_ci";
            
            $this->db = $this->load->database ( $config, true );
            
            $url = "dc_airbnb_gate/get_reservation_2db/".$db_name;
            $data = array(
                'request' => $postdata,
                'url' => $url
            );
            
            $this->db->insert('dc_airbnb_log', $data);
            $dc_log_id = $this->db->insert_id();
            
            $reservation_result = $this->dcm_airbnb->get_bookings ($postdata);
            
            $data = array(
                'response' => $reservation_result,
                'responseint' => 0,
                'stime' => 0
            );
            
            $this->db->update('dc_airbnb_log', $data, array(
                'id' => $dc_log_id
            ));
            
            $this->Loger_admin->Save_SyncData("", "", $reservation_result, 22, 10, $dc_log_id);
        }
        
        public function fail_test( $listing_id = 0, $user_id = 0 )
        {
            
            echo "<pre>";
            if( $user_id == 0 ){
                $user_id = 168475800; // отримаєш з бази локальної, якщо передаєш юзика, то по всім лістингам має проставити он-деманд
            }
            $user_id = $this->dcm_airbnb->getxmlcfgvalue('user_id', 'int');
            
            //з локальної бази ці параметри
            $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
            $refresh_token = $this->dcm_airbnb->getxmlcfgvalue('refresh_token', 'str');
            
            $authparam = $this->dcm_airbnb->authparam();
            $clientid = $authparam['clientid'];
            $clientsecret = $authparam['clientsecret'];
            
            
            //echo $access_token . "\n";
            //echo "step 1\n";
            
            
            if ($refresh_token == "") {
                echo "empty token +\n";
                echo $refresh_token . "+\n";
                
                return;
            }
            
            
            //з конфігу
            
            $auth = $clientid . ':' . $clientsecret;
            
            $headers = array(
                'Content-Type:application/json',
                'Authorization: Basic ' . base64_encode($auth),
            );
            $url = 'https://api.airbnb.com/v2/oauth2/authorizations/' . $access_token . '?_unwrapped=true';
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $buffer = curl_exec($ch);
            curl_close($ch);
            $result = json_decode($buffer, true);
            
            //print_r($result);
            
            if( ! isset( $result['valid'] ) || ! boolval($result['valid']) ){
                
                echo "step get access token\n";
                
                $url = 'https://api.airbnb.com/v2/oauth2/authorizations?_unwrapped=true';
                
                $data = array(
                    'refresh_token' => $refresh_token,
                    'reset_refresh_token' => 0,
                );
                
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
                $buffer = curl_exec($ch);
                curl_close($ch);
                $result = json_decode($buffer, true);
                
                
                //print_r($result);
                //print_r($data);
                
                $access_token = $result['access_token'];
                
                $this->db->query("insert into dc_airbnb_xml_cfg (name, str_value) values ('access_token', '$access_token') on duplicate key update str_value='$access_token'");
                
                echo "step update access token\n";
                echo $access_token . "\n";
            } else {
                echo "valid access token\n";
            }
            
            $headers = array(
                'Content-Type:application/json',
                'X-Airbnb-Oauth-Token:'. $access_token,
                'X-Airbnb-API-Key:' . $clientid
            );
            $url = 'https://api.airbnb.com/v2/listing_imports?user_id=' . $user_id;
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $buffer = curl_exec($ch);
            curl_close($ch);
            
            $imports = json_decode($buffer, true);
            
            echo "import_list 2\n";
            print_r($imports);
            //die();
            
            //return ;
            
            
            
            if( $listing_id != 0 ){
                if( isset( $imports['listing_imports'] ) && count( $imports['listing_imports'] ) ){
                    foreach( $imports['listing_imports'] as $import_data ){
                        if( $import_data['listing_id'] != $listing_id ){
                            continue;
                        } else {
                            
                            $headers = array(
                                'Content-Type:application/json',
                                'X-Airbnb-Oauth-Token:'. $access_token,
                                'X-Airbnb-API-Key:' . $clientid
                            );
                            
                            $url = 'https://api.airbnb.com/v2/listing_imports/' . $import_data['id'];
                            
                            $parametres = array(
                                'synchronization_frequency' => 'on_demand',
                            );
                            
                            $ch = curl_init();
                            curl_setopt($ch, CURLOPT_URL, $url);
                            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
                            curl_setopt($ch, CURLOPT_POST, 1);
                            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($parametres) );
                            $buffer = curl_exec($ch);
                            curl_close($ch);
                            
                            $on_demand = json_decode($buffer, true);
                            
                            echo "- ON_DEMAND\n";
                            print_r($on_demand);
                            
                            break;
                        }
                    }
                }
            } else {
                if( isset( $imports['listing_imports'] ) && count( $imports['listing_imports'] ) ){
                    foreach( $imports['listing_imports'] as $import_data ){
                        
                        $headers = array(
                            'Content-Type:application/json',
                            'X-Airbnb-Oauth-Token:'. $access_token,
                            'X-Airbnb-API-Key:' . $clientid
                        );
                        
                        $url = 'https://api.airbnb.com/v2/listing_imports/' . $import_data['id'];
                        
                        $parametres = array(
                            'synchronization_frequency' => 'on_demand',
                        );
                        
                        $ch = curl_init();
                        curl_setopt($ch, CURLOPT_URL, $url);
                        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
                        curl_setopt($ch, CURLOPT_POST, 1);
                        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($parametres) );
                        $buffer = curl_exec($ch);
                        curl_close($ch);
                        
                        $on_demand = json_decode($buffer, true);
                        echo "- ON_DEMAND_ALL\n";
                        print_r($on_demand);
                        
                        
                    }
                }
            }
            
            if (sizeof($import_data) == 0) {
                echo "suspended ?\n";
                echo $listing_id . "\n";
                $row = $query = $this->db->select('listing_id as import_id')->get_where('dc_airbnb_room2listing', array('listing_id2'=>$listing_id))->row();
                if (!is_null($row->import_id)) {
                    echo $row->import_id . "\n";
                    
                    $headers = array(
                        'Content-Type:application/json',
                        'X-Airbnb-Oauth-Token:'. $access_token,
                        'X-Airbnb-API-Key:' . $clientid
                    );
                    
                    $url = 'https://api.airbnb.com/v2/listing_imports/' . $row->import_id;
                    
                    $parametres = array(
                        'synchronization_frequency' => 'on_demand',
                    );
                    
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $url);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($parametres) );
                    $buffer = curl_exec($ch);
                    curl_close($ch);
                    
                    echo $buffer;
                    
                    $on_demand = json_decode($buffer, true);
                    echo "- ON_DEMAND - " . $row->import_id . "\n";
                    print_r($on_demand);
                }
                
                
            }
            
            
            
            
            $msg_data = array();
            $msg_data['reservation_id'] = 0;
            $msg_data['message'] = "{mlw_caption_contact_to_support}.<br>{mlw_synchronization_error} Airbnb.<br>Listing ID - " . $listing_id. ".";
            $msg_data['type'] = 1;
            $msg_data['state'] = 1;
            //$this->frontdesk_c2->insert_hms_notifications($msg_data);
            
            echo "Notified -\n";
            
        }
        
        public function check_refresh() {
            $refresh_token = $this->dcm_airbnb->getxmlcfgvalue('refresh_token', 'str');
            if ($refresh_token == "") {
                echo "EMPTY";
            } else {
                echo "OK!";
            }
            
            
        }
        
        function check_availability($start_date = "", $nights = 0, $listing_id = 0){
            if(isset($_GET['listing_id'])){
                $listing_id = $_GET['listing_id'];
            }
            if(isset($_GET['start_date'])){
                $start_date = $_GET['start_date'];
            }
            if(isset($_GET['nights'])){
                $nights = $_GET['nights'];
            }
            list ( $year, $month, $day ) = explode ( "-", $start_date );
            $end_date = date('Y-m-d', mktime ( 0, 0, 0, $month, $day + $nights, $year )); // було gmmktime 
            
            list ( $year, $month, $day ) = explode ( "-", $start_date );
            $intdatein = round ( mktime ( 0, 0, 0, $month, $day, $year ) / 86400 ); // було gmmktime 
            list ( $year, $month, $day ) = explode ( "-", $end_date );
            $intdateout = round ( mktime ( 0, 0, 0, $month, $day, $year ) / 86400 ); // було gmmktime 
            $duration = $intdateout - $intdatein;
            $return_array = array();
            $return_array['available'] = false;
            $return_array['failureCode'] = null;
            
            //$category_id = $this->db->select('category_id')->get_where('dc_airbnb_listingtocategory', array('listing_id'=>$listing_id))->row()->category_id;
            
            $category_id = NULL;
            $sql = "SELECT category_id FROM dc_airbnb_listingtocategory WHERE  listing_id = $listing_id";
            $query = $this->db->query ( $sql );
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $category_id = $row->category_id;
            }
            
            if($category_id != NULL){
                $room_id = $this->frontdesk->getfreeroomlist($start_date, $end_date, $category_id);
                if ($room_id > 0) {
                    $max_closed = 0;
                    $max_minstaythrought = 0;
                    $restrict_rate_id = $this->db->select('int_value')->get_where('dc_airbnb_xml_cfg', array('name' => 'restrict_rate_id'))->row()->int_value;
                    $deskofrates = array ();
                    $sql = "SELECT intdate, rate_id, category_id, MAX(closed) as max_closed, MAX(minstaythrought) as max_minstaythrought
                    FROM deskofrate WHERE  rate_id = $restrict_rate_id AND category_id = $category_id AND intdate >= $intdatein AND intdate < $intdateout GROUP by category_id";
                    // 	            echo $sql;
                    // 	            die();
                    $query = $this->db->query ( $sql );
                    if ($query->num_rows() > 0) {
                        $row = $query->row();
                        $max_closed = $row->max_closed;
                        $max_minstaythrought = $row->max_minstaythrought;
                    }
                    
                    if ($max_closed == 0 && $max_minstaythrought <= $duration) {
                        $return_array['available'] = true;
                        unset($return_array['failureCode']);
                    }
                }
            }
            echo json_encode($return_array);
        }
        
        function get_hmsid_by_listing_id(){
            if (! empty($_SERVER['HTTP_CLIENT_IP'])) {
                $ip_real = $_SERVER['HTTP_CLIENT_IP'];
            } elseif (! empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                $ip_real = $_SERVER['HTTP_X_FORWARDED_FOR'];
            } else {
                $ip_real = $_SERVER['REMOTE_ADDR'];
            }
            
            if ($ip_real === "193.151.90.86") {
                
            } else {
                echo json_encode(array('error' => 1, 'ip' => $ip_real));
                return ;
            }
            
            $get = $_GET;
            $listing_id = $get['listing_id'];
        $this->db->select('h2l.hms_id, config.db_name, config.host');
        $this->db->join('visitka.config', 'config.id = h2l.hms_id');
        $where = "h2l.listing_id = $listing_id";
        $this->db->where($where);
        $query = $this->db->get('dc_booking.dc_airbnb_hmsid2listing2imports as h2l');
            
//             $sql = "SELECT h2l.hms_id, config.db_name, config.host
//             FROM dc_booking.dc_airbnb_hmsid2listing2imports as h2l
//             INNER JOIN visitka.config ON config.id = h2l.hms_id
//             WHERE h2l.listing_id = $listing_id";
            //echo $sql;
            //$query = $this->db->query ( $sql );
            if ($query->num_rows() > 0) {
                echo json_encode($query->row_array());
            }else{
                echo json_encode(array('error' => 11));
            }
        }
        
        function airbnb_update_theard(){
            $postdata = file_get_contents("php://input");
            $postdata = str_replace('\\\\', '\\', $postdata);
            
            $response = json_decode($postdata, true);
            
            echo $postdata . "<pre>";
            print_r($response);
            
            if(isset($response['thread']['id'])){
                $thread_id = $response['thread']['id'];
                
                if(isset($response['message']['id'])){
                    $message_id =  $response['message']['id'];
                    
                    $db_message_id = $this->db->select('message_id')
                    ->get_where('dc_mc_messages', array('message_id' => $message_id, 'thread_id' => $thread_id))
                    ->row()
                    ->message_id;
                    
                    if($db_message_id == 0){
                        $hms_notifications_data = array();
                        $hms_notifications_data ['message'] = 'AIRBNB {clt_message} <a href="/messages_c2/view_thread/'.$thread_id.'">'.$thread_id.'</a>';
                        $hms_notifications_data ['state'] = 1;
                        $hms_notifications_data ['type'] = 1;
                        $hms_notifications_data ['create_time'] = date('Y-m-d H:i:s');
                        $this->frontdesk_c2->insert_hms_notifications($hms_notifications_data);
                    }
                }
                
                $this->messages_model->get_airbnb_messages($thread_id);
            }
        }
    }