<?php

require_once APPPATH . 'third_party/vendor/autoload.php';

class Billing_c3 extends CI_Controller
{
    public string $stripe_region_id;
    public string $customer_id;
    
    public function __construct()
    {
        parent::__construct();
        $this->load->model('htmltpl');
        $this->load->model('Authorization');
        $this->load->model('stripe_billing_m3');
        //$this->load->model('frontdesk');
        //$this->load->model('Curl_model');
        //$this->load->model('mlanguages');
        //$this->load->model('Appex');
        //$this->load->model('Stripe');
        $this->Authorization->IsLogined();

        $this->stripe_region_id = $this->stripe_billing_m3->get_property_region_id_for_plans();
        $this->hotelix_config->set_record("stripe_region_id", $this->stripe_region_id,  'int');
        
        $secret_key = $this->stripe_billing_m3->get_keys( $this->stripe_region_id, 'secret' );

        $this->stripe = new \Stripe\StripeClient($secret_key);
        
        // ========== DANGER!!!! ======
        // $this->stripe_billing_m3->clear_billing(); 
        // $this->stripe_billing_m3->sync_plans();

        $this->customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id");
        
        if( ! $this->customer_id ){
            $this->stripe_billing_m3->create_customer();
        }
    }
    
    public function summary(): void
    {
        if (isset ( $_POST ["card_error"] ) && !empty($_POST ["card_error"])) {
            $this->session->set_userdata(array("header_msg_text"=>"{".$_POST ["card_error"]."}"));
        }
        $data = array();
        $this->load->library ( 'parser' );
        $this->load->view ( 'stripe_concept3/summary_view.php', $data );
        return;
    }

    public function plans(): void
    {
        $no_free_countries = ['GEO'];
        $current_level = '';

        $subscription = $this->stripe_billing_m3->get_subscription_data();

        if( $subscription ){
            if( $subscription->object == 'subscription'){
                foreach( $subscription->items->data as $si ){
                    if( ! null == $si->price->metadata->level ){
                        $current_level = $si->price->metadata->level;

                        $current_period = $si->price->recurring->interval == 'month' 
                            ? $si->price->recurring->interval_count
                            : $si->price->recurring->interval_count * 12;
                    }
                }
            } elseif( ! null == $subscription->subscription ) {
                foreach( $subscription->subscription->items->data as $si ){
                    if( ! null == $si->price->metadata->level ){
                        $current_level = $si->price->metadata->level;

                        $current_period = $si->price->recurring->interval == 'month' 
                            ? $si->price->recurring->interval_count
                            : $si->price->recurring->interval_count * 12;
                    }
                }
            }
        }

        //dd( $subscription );

        $currency = strtolower( $this->stripe_billing_m3->get_currency( $this->stripe_region_id )['region_currency'] ?? '');

        if( ! in_array ( $this->frontdesk->get_visitka_id_country_3c(), $no_free_countries ) ){
            $data['plans']['free'] = [
                'price_from' => 0,
                'price' => 0.00,
                'name' => '{clt_free}',
                'type_class' => 'free',
                'is_current' => false,
                'currency' => '',
                'price_month' => 0.00,
                'from' => '&nbsp;',
            ];
        }

        $data['plans']['base'] = [
            'price_from' => 0.00,
            'price' => 0.00,
            'price_month' => 0.00,
            'name' => '{clt_base}',
            'type_class' => 'base',
            'is_current' => false,
            'currency' => $currency,
            'from' => '{clt_from}'
        ];

        $data['plans']['ultra'] = [
            'price_from' => 0.00,
            'price' => 0.00,
            'price_month' => 0.00,
            'name' => '{clt_ultra}',
            'type_class' => 'ultra',
            'is_current' => false,
            'currency' => $currency,
            'from' => '{clt_from}',
        ];

        $plans = $this->stripe_billing_m3->get_plans( true );

        $aparts = $this->hotelix_config->get_record('single_dwelling_count', 'int');
        $hotel_count = $this->hotelix_config->get_record('multi_dwelling_count', 'int');
                
        foreach( $plans as &$plan ){
            if( $plan['level'] == $current_level && $plan['mcount'] == $current_period ){
                $data['plans'][$plan['level']]['is_current'] = true;
                $data['plans'][$plan['level']]['currency'] = $subscription->currency ?? $currency;
                if(  $plan['type_id'] == 2 ){
                    $data['plans'][$plan['level']]['price']
                        += (double)( ( $hotel_count * $plan['amount'] ) );
                } else {
                    $data['plans'][$plan['level']]['price'] 
                        += (double)( $this->stripe_billing_m3->calculate_apart_tiers( $plan['plan_id'], $aparts, $plan['currency'] ) );
                }
            }
            
            if( $plan['mcount'] == 12 ){
                if(  $plan['type_id'] == 2 ){
                    $data['plans'][$plan['level']]['price_from'] 
                        += (double)( ( $hotel_count * $plan['amount'] ) / 12 );
                } else {
                    $data['plans'][$plan['level']]['price_from'] 
                        += (double)( $this->stripe_billing_m3->calculate_apart_tiers( $plan['plan_id'], $aparts, $plan['currency'] ) / 12 );
                }
            }

            if( $plan['mcount'] == 1 ){
                if(  $plan['type_id'] == 2 ){
                    $data['plans'][$plan['level']]['price_month'] 
                        += (double)( ( $hotel_count * $plan['amount'] ) );
                } else {
                    $data['plans'][$plan['level']]['price_month'] 
                        += (double)( $this->stripe_billing_m3->calculate_apart_tiers( $plan['plan_id'], $aparts, $plan['currency'] ) );
                }
            }
        }
        //dd( $data );
        //dd( $plans );
        $this->load->library ( 'parser' );
        $this->load->view ( 'stripe_concept3/plans_view.php', $data );

        return;
    }

    public function ajax_drawer( string $level )
    {
        $billing_count = $this->stripe_billing_m3->get_billing_count();
        $currency = $this->stripe_billing_m3->get_currency( $this->stripe_region_id )['region_currency'] ?? 'USD';
        $dwellings = $this->stripe_billing_m3->get_plans_ranges( $billing_count, $currency );
        
        $data['dwellings'] = $dwellings;
        $data['modules'] = $this->stripe_billing_m3->get_modules('base');

        if( ! in_array( $level, ['free', 'base', 'ultra']) ) return false;

        echo $this->parser->parse('templates/stripe_concept3/drawer_parts/drawer_body_' . $level . '.html', $data, true);
    }

    public function ajax_amount()
    {
        parse_str(file_get_contents("php://input"), $data);
        
        print_r( $data );
    }
    /*
    function redirect_payment()
    {
        
        $hms_id = $this->config->item('hotel_id');
        $postdata = array('hms_id' => $hms_id, 'user' => 'verified_user', 'pass' => 'nihuhrymuhry');
        $postdata = array('postdata' => json_encode($postdata));
        $srt_init = "https://cpcrm-dev.otelms.com/gate/get_bill_info";
        $ch = curl_init($srt_init);
        curl_setopt($ch, CURLOPT_POST,true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $result = curl_exec($ch);
        curl_close($ch);
        $responce = json_decode($result, true);
        //print_r($responce);
        
        if (isset($responce['currency'])) {
            die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/" . $responce['currency'] . "/" . $responce['ratevalue'] . "'>");
        } else {
            echo "Please contact to support team. Undefined currency code! ";
            return;
        }
        
        
        return;
        
        
        // old logic
        $id_country_3c = "???";
        $hms_id = $this->config->item('hotel_id');
        $query = $this->db->query("select id_country_3c from visitka.config where id=" . $hms_id);
        if ($query->num_rows()) {
            $row = $query->row();
            $id_country_3c = $row->id_country_3c;
        } else {
            echo "hms_id error";
            return;
        }
        // if(isset($_SESSION ['user'] ["config_id_country"])){
        $config_id_country = $_SESSION['user']["config_id_country"];
        switch ($id_country_3c) {
            case "UKR":
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/liqpay'>");
                break;
            case "RUS":
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/appex'>");
                // die ( "<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/rub'>" );
                break;
            case "GEO":
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/gel'>");
                break;
            case "POL":
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/pln'>");
                break;
            case "GBR":
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/gbp'>");
                break;
            case "THA": // Тайланд
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "TJK": // Таджикистан
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "ARM": // Armenija
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "KAZ": // Raz
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "SVN": // Таджикистан
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "AZE": // Azer
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "HUN": // HUN
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "BLR": // BLR
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "ESP": // BLR
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/eur'>");
                break;
            case "ALB": // ALB
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/eur'>");
                break;
            case "BGR": // BGR
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/eur'>");
                break;
            case "MDA": // MDA
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/eur'>");
                break;
            case "ROU": // ROU
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/eur'>");
                break;
            case "KGZ": // KGZ
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
                
            case "MYS": // MYS
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "GRC": // GRC
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "NIC": // NIC
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "NPL": // NPL
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "CHL": // CHL
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "LVA": // LVA
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "DEU": // DEU
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/eur'>");
                break;
            case "LTU": // LTU
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/eur'>");
                break;
            default:
                echo "Please contact to support team. Undefined country code! ";
                echo $id_country_3c;
                return;
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe'>");
                break;
        }
        // }
    }
    
   
    function stripe($currency = "", $ratevalue = 1)
    {
        $data = array(
            "currency" => $currency,
            "ratevalue" => $ratevalue
            
        );
        $this->load->library('parser');
        $this->load->view('billing_c2_stripe_view.php', $data);
    }
    
    
    function stripepayment()
    {
        echo "<pre>";
        print_r($_POST);
        // require_once(APPPATH.'libraries/stripe/Stripe.php');
        require_once (APPPATH . 'libraries/stripe/init.php');
        
        $stripe = array(
            'secret_key' => "sk_test_d19ipvh8ROnGPZ4L6q96S4BO",
            'publishable_key' => "pk_test_0toHn3UsTJbzBwO5WIhtQNBK"
        );
        
        \Stripe\Stripe::setApiKey($stripe['secret_key']);
        
        /*
         *
         * $customer = \Stripe\Stripe_Customer::create(array(
         * 'email' => $_POST['stripeEmail'],
         * 'card' => $_POST['stripeToken']
         * ));
         *
         * $charge = \Stripe\Stripe_Charge::create(array(
         * 'customer' => $customer->id,
         * 'amount' => 2000,
         * 'currency' => 'uah'
         * ));
         *
         
        $charge = \Stripe\Charge::create(array(
            'amount' => 2001,
            'currency' => 'uah',
            'source' => $_POST['stripeToken']
        ));
        
        print_r($charge->getLastResponse());
        echo "<br><br><br>============== $ CHARGE =================<br><br><br>";
        print_r($charge);
    }
    
    function stripe_post($stripe_account)
    {
        // echo "<pre>";
        // print_r($_POST);
        // require_once(APPPATH.'libraries/stripe/Stripe.php');
        require_once (APPPATH . 'libraries/stripe/init.php');
        
        switch ($stripe_account) {
            case "us":
                $stripe = $this->Stripe->get_param_hms_billing();
                break;
            case "uk":
                $stripe = $this->Stripe->get_param_hms_billing_uk();
                break;
            default:
                die("Bill error");
                break;
        }
        
        \Stripe\Stripe::setApiKey($stripe['secret_key']);
        
        /*
         *
         * $customer = \Stripe\Stripe_Customer::create(array(
         * 'email' => $_POST['stripeEmail'],
         * 'card' => $_POST['stripeToken']
         * ));
         *
         * $charge = \Stripe\Stripe_Charge::create(array(
         * 'customer' => $customer->id,
         * 'amount' => 2000,
         * 'currency' => 'uah'
         * ));
         *
         
        // $post = $this->input->post($_POST, true);
        $amount = $_POST['amount'];
        $currency = $_POST['currency'];
        
        $hotel_id = $this->config->item('hotel_id');
        $invoice = $hotel_id . "-" . time();
        
        /*
         * ===SAVE TOKEN LOG
         *
         
        
        //         $data = array();
        //         $data['hms_id'] = $hotel_id;
        //         $data['token'] = $_POST['stripeToken'];
        //         $data['amount'] = $amount;
        //         $data['operation_type'] = "charge";
        //         $data['description'] = "hms-" . $invoice;
        
        //         $this->db->insert('global_hotelix.stripe_token_log', $data);
        
        try {
            $charge = \Stripe\Charge::create(array(
                'amount' => $amount * 100,
                'currency' => $currency,
                'description' => "hms-" . $invoice,
                'metadata' => array(
                    'order_id' => $invoice
                ),
                'source' => $_POST['stripeToken']
            ));
        } catch (Exception $e) {
            echo "<pre>";
            echo "error stored";
            $data = array();
            $data['hms_id'] = $hotel_id;
            $data['data'] = json_encode($e);
            
            $this->db->insert('global_hotelix.stripe_log', $data);
            
            $res = json_decode($data['data'], true);
            echo "\n";
            echo $res['jsonBody']['error']['code'];
            echo "\n";
            echo $res['jsonBody']['error']['message'];
            echo "\n";
            
            if ($_SERVER['REMOTE_ADDR'] == "217.65.249.175") {
                echo "<pre>";
                //print_r($e);
                //print_r($stripe);
                //die();
            }
            
        }
        
        
        
        
        $LastResponse = $charge->getLastResponse();
        $response = $LastResponse->json;
        // print_r($response);
        //print_r($response);
        //die();
        if ($response["paid"] == 1) {
            $hotel_id = $this->config->item('hotel_id');
            $db3 = $this->load->database('db3', TRUE);
            $sql = "INSERT INTO test.billingdoc (hmsID, doctype, amount, ref, currency, datetime)
			VALUES('" . $hotel_id . "', '2', '" . $response["amount"] / 100 . "', '" . $response["id"] . "',
			'" . $response["currency"] . "', '" . date("Y-m-d H:i:s") . "')";
            // echo $sql;
            $query = $db3->query($sql);
            $billingdoc_id = $db3->insert_id();
            $sql = "INSERT INTO test.log (`user_id`, `time`, `billingdoc_id`, `operation`) VALUES('0', '" . date("Y-m-d H:i:s") . "', '" . $billingdoc_id . "',
				'new')";
            
            $query = $db3->query($sql);
            
            die("<meta http-equiv='refresh' content='0;url=/billing_c2/blist/1'>");
        } else {
            echo "<pre>";
            print_r($_POST);
            
            echo "Payment error";
            
            print_r($response);
        }
    }
    */
}
?>